# program to scan peer_summary file and produce summary of daily summaries
#
# usage: awk -f psummary.awk peer_summary
#
# format of input records
# peerstats.19960706
#        ident     cnt     mean     rms      max     delay     dist     disp
# ==========================================================================
# 140.173.112.2     85   -0.509    1.345    4.606   80.417   49.260    1.092
# 128.4.1.20      1364    0.058    0.364    4.465    3.712   10.540    1.101
# ...
#
# format of output records (actual data from rackety.udel.edu)
#        host     days     mean       rms       max   >1  >5 >10 >50
# ==================================================================
# 127.127.22.1    1090     0.001     0.401    99.800  19  14  13  10
# 127.0.0.1       1188     0.060     1.622   105.004  78  65  51  32
# 127.127.4.1      586     0.000     0.000     0.000   0   0   0   0
# 140.173.64.1     975    -0.010     2.552   257.595 399 192 114   8
# 128.175.1.3     1121     0.447     8.637   204.123 479 460 397 147
# 140.173.16.1    1106     0.027     1.014   267.857 242  38  31  23
# 128.4.1.4       1119     0.023     1.037   267.748 223  41  34  23
# 128.4.1.2        850     1.202     1.654   267.704 196  53  45  34
# 128.4.1.20      1101     0.088     1.139   268.322 430 111  83  16
# 140.173.32.1     979    -0.949     2.344   257.671 396 217 136   7
# 140.173.112.2   1066     0.040     2.111   152.969 442 315 152  16
# 140.173.80.1    1059     0.019     1.858    87.690 438 348 150   9
# 140.173.96.1    1015     0.110     2.007   266.744 399 314 170  17
# 140.173.128.1   1103    -0.002     2.600   257.672 465 262 132  13
# 140.222.135.1    347    -4.626     8.804   196.394 135 135 134  95
# 140.173.128.2   1081    -0.046     2.967   261.448 463 342 172  17
# 140.222.141.1    354     0.820     8.809   195.333 142 141 139 100
# 140.173.144.2   1058    -0.107     2.805   270.498 448 341 163  17
# 140.222.134.1    354    -0.056     8.479   172.458 142 141 141 100
# 140.222.144.1    415    -1.456     9.964   191.684 161 161 161 123
# 140.222.136.1    234     0.902     7.707   182.431  62  62  62  48
# 128.175.1.1      774     0.890     4.838   266.799 358 291 200  83
# 127.127.10.1    1086    -0.002     1.462   231.128 240 239  60  57
# 140.173.48.2     576     0.016     4.092   350.512 213 126  88  16
# 128.4.1.11         3     0.000     0.000     0.000   0   0   0   0
# 128.4.1.26       386    -1.363    20.251   341.284 164 164 161 132
#
# select table beginning with "ident"
{
	if (NF < 8 || $1 == "ident")
		continue
	i = n
	for (j = 0; j < n; j++) {
		if ($1 == peer_ident[j])
			i = j
	}
	if (i == n) {
		peer_ident[i] = $1
		n++
	}
	peer_count[i]++
	if (($7 - $6 / 2) < 400) {
		peer_count[i]++
		peer_mean[i] += $3
		peer_var[i] += $4 * $4
		if ($5 > peer_max[i])
			peer_max[i] = $5
		if ($5 > 1)
			peer_1[i]++
		if ($5 > 5)
			peer_2[i]++
		if ($5 > 10)
			peer_3[i]++
		if ($5 > 50)
			peer_4[i]++
	}
} END {
	printf "       host     days    mean       rms       max   >1  >5 >10 >50\n"
	printf "==================================================================\n"
	for (i = 0; i < n; i++) {
		if (peer_count[i] <= 0)
			continue
		peer_mean[i] /= peer_count[i]
		peer_var[i] = sqrt(peer_var[i] / peer_count[i])
		printf "%-15s%4d%10.3f%10.3f%10.3f%4d%4d%4d%4d\n", peer_ident[i], peer_count[i], peer_mean[i], peer_var[i], peer_max[i], peer_1[i], peer_2[i], peer_3[i], peer_4[i]
	}
}
