/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef rsa_pss_2048_sha256_32_vectors_h__
#define rsa_pss_2048_sha256_32_vectors_h__

#include "testvectors_base/test-structs.h"

#include "testvectors/rsa_pss_2048_sha256_mgf1_0-vectors.h"

const RsaPssTestVector kRsaPss2048Sha25632WycheproofVectors[] = {

    // Comment:
    // tcID: 1
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     1,
     32,
     {0x4f, 0x01, 0xe0, 0xc1, 0x2b, 0x08, 0x62, 0x5e, 0xca, 0xc8, 0x9a, 0x69,
      0x23, 0x19, 0x06, 0xed, 0xf8, 0x26, 0x38, 0x0f, 0x37, 0xc9, 0x59, 0xa9,
      0x66, 0x90, 0xd0, 0x46, 0x31, 0x6d, 0x68, 0xff, 0xce, 0x9d, 0x5c, 0x47,
      0x16, 0x94, 0xfc, 0xeb, 0xfc, 0x6b, 0x45, 0x53, 0x48, 0x64, 0x68, 0x92,
      0x56, 0xe4, 0xfc, 0x81, 0xc7, 0x8e, 0x58, 0x3f, 0x67, 0x5d, 0x0c, 0x94,
      0xb4, 0x49, 0x64, 0x74, 0x51, 0xe8, 0x1b, 0xef, 0xf0, 0x1a, 0x11, 0xa5,
      0x16, 0xd5, 0xe5, 0xce, 0x3f, 0x1a, 0x91, 0x04, 0x37, 0xcb, 0x8a, 0x3a,
      0x50, 0x96, 0xb1, 0x9f, 0xb1, 0x5f, 0x45, 0x24, 0xa3, 0x5b, 0x23, 0xd8,
      0x9c, 0xdb, 0xa1, 0x2c, 0xf5, 0xb7, 0x1a, 0xac, 0x10, 0x47, 0xb2, 0x8c,
      0x56, 0x2d, 0xf7, 0xc5, 0x54, 0x2c, 0x34, 0xce, 0x23, 0xa1, 0x82, 0xcf,
      0x7e, 0x0e, 0x23, 0x19, 0x34, 0xb1, 0x72, 0x94, 0x79, 0x9d, 0x44, 0x87,
      0x7a, 0x1d, 0x68, 0xef, 0x1b, 0x8f, 0x07, 0x36, 0x19, 0xb7, 0x61, 0x8e,
      0x6b, 0x7c, 0x22, 0xdb, 0x20, 0x03, 0x0d, 0x98, 0xcf, 0x59, 0x1f, 0xfc,
      0x3d, 0x4d, 0xa5, 0xf5, 0x86, 0x13, 0xec, 0xd5, 0xec, 0xfc, 0x3b, 0x40,
      0xa1, 0xd0, 0x2f, 0x40, 0x89, 0x1c, 0xa4, 0x36, 0x95, 0xcd, 0x4c, 0x08,
      0x8b, 0x05, 0xa8, 0x05, 0x4c, 0x89, 0xc5, 0x95, 0xa4, 0x7e, 0x27, 0x48,
      0x16, 0xf3, 0x53, 0x84, 0x22, 0x6f, 0x74, 0x45, 0x9e, 0xe6, 0x3e, 0x25,
      0xa1, 0xbf, 0xc0, 0x3c, 0x36, 0x04, 0x90, 0x55, 0x2e, 0xc3, 0x83, 0x43,
      0xf8, 0xac, 0xe5, 0x02, 0xf0, 0x65, 0x30, 0x3b, 0x00, 0xbc, 0x0e, 0xc3,
      0x20, 0x71, 0x1b, 0x21, 0x1f, 0xde, 0x92, 0xe5, 0x7f, 0xeb, 0x90, 0x13,
      0xc3, 0x60, 0x93, 0x42, 0x49, 0x5e, 0xc0, 0xd7, 0xca, 0xbd, 0xec, 0x21,
      0xe5, 0x4a, 0xcc, 0x38},
     pub_key_1,
     {},
     true},

    // Comment:
    // tcID: 2
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     2,
     32,
     {0x06, 0x58, 0xc6, 0x8f, 0xe0, 0x89, 0x56, 0x46, 0x05, 0x6d, 0x9b, 0xca,
      0x42, 0x2a, 0x64, 0xfe, 0x48, 0x81, 0x3b, 0x4e, 0x14, 0xf0, 0xc8, 0xc4,
      0x12, 0x2e, 0x56, 0xd3, 0x45, 0xb6, 0x81, 0x3d, 0xc6, 0x28, 0x6f, 0xfd,
      0xe0, 0x14, 0x61, 0x7e, 0x35, 0x1c, 0x7a, 0xf0, 0xa0, 0xd2, 0xc0, 0xf2,
      0x85, 0xde, 0xf7, 0x9c, 0xb7, 0x34, 0xe1, 0xe0, 0x55, 0xa2, 0x5f, 0xa6,
      0xfd, 0xdc, 0x1c, 0x07, 0xda, 0x17, 0xb4, 0xb2, 0x35, 0xc6, 0x37, 0x41,
      0x3b, 0x18, 0x49, 0xc2, 0x43, 0x11, 0xfa, 0x72, 0x33, 0x1f, 0x4c, 0x04,
      0x58, 0xc3, 0x64, 0xa4, 0x91, 0x6d, 0xe8, 0x61, 0x9b, 0x88, 0x4d, 0x7e,
      0x37, 0x28, 0x8f, 0xad, 0x12, 0x92, 0x6f, 0xc0, 0x91, 0xf4, 0x85, 0x16,
      0x86, 0xa0, 0x4f, 0xd0, 0xa5, 0x04, 0xdb, 0xce, 0x3d, 0xb3, 0x70, 0x66,
      0x3a, 0x6e, 0xa6, 0x12, 0x8f, 0xea, 0x86, 0xc2, 0xca, 0x94, 0xc6, 0x3e,
      0x0d, 0x34, 0xd7, 0xf2, 0xc8, 0x45, 0xb5, 0xd7, 0x1d, 0x9a, 0x5e, 0x54,
      0x44, 0x51, 0xf5, 0x24, 0xa4, 0x51, 0xac, 0xb8, 0x5c, 0x49, 0xbb, 0xa7,
      0x86, 0x4e, 0x0a, 0x34, 0xa4, 0x86, 0x13, 0xa8, 0x19, 0xca, 0xf3, 0xdf,
      0xd0, 0xd5, 0x10, 0xc9, 0x40, 0xf1, 0xdf, 0x21, 0xc3, 0x37, 0x39, 0x15,
      0xbe, 0x1f, 0x35, 0x09, 0xa5, 0x57, 0xfa, 0x4d, 0x5a, 0x4e, 0x9f, 0x27,
      0x3e, 0x85, 0x46, 0x79, 0x61, 0x13, 0x3e, 0x24, 0x82, 0xc0, 0x90, 0x73,
      0x86, 0x45, 0x42, 0x28, 0xfb, 0x02, 0x46, 0x63, 0x86, 0x16, 0xfc, 0x31,
      0xbb, 0xb6, 0xfa, 0x7c, 0x23, 0x61, 0xb8, 0x03, 0x59, 0x94, 0xee, 0xc6,
      0x9a, 0x92, 0x3f, 0x4c, 0x0b, 0xb0, 0xba, 0x86, 0x96, 0xdf, 0xe8, 0xb1,
      0x40, 0x0c, 0x23, 0x98, 0xd7, 0xb3, 0x43, 0xfd, 0xf4, 0x98, 0xb1, 0x11,
      0x6c, 0x8d, 0xe6, 0x02},
     pub_key_1,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     true},

    // Comment:
    // tcID: 3
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     3,
     32,
     {0x40, 0x1e, 0xb0, 0x3c, 0xdb, 0x47, 0xca, 0x88, 0x03, 0x3e, 0x30, 0x30,
      0xf6, 0xbd, 0xec, 0xba, 0xc8, 0xf5, 0xc8, 0xfc, 0x1d, 0xd6, 0xa1, 0x3d,
      0x23, 0xd3, 0x79, 0xed, 0x9a, 0x2b, 0x30, 0x98, 0x91, 0xd1, 0x3d, 0x74,
      0xfe, 0xa9, 0xd2, 0x1d, 0x15, 0x9b, 0x9e, 0x6d, 0x8f, 0x37, 0xef, 0xa2,
      0x48, 0x99, 0x62, 0xe2, 0x45, 0x55, 0xf5, 0x6d, 0xd4, 0x34, 0xff, 0x1d,
      0x31, 0xce, 0x4f, 0x9f, 0x5a, 0xbd, 0x3f, 0x22, 0xcb, 0xea, 0x8b, 0x69,
      0x1d, 0x6a, 0x11, 0xe4, 0x4e, 0xfb, 0x83, 0xe2, 0xbc, 0xa1, 0x55, 0xe6,
      0xa1, 0x64, 0x32, 0x5e, 0x0f, 0xde, 0x2a, 0x88, 0x65, 0xaf, 0xd5, 0xc9,
      0xf5, 0x11, 0x61, 0xa9, 0xd6, 0x15, 0xf6, 0x2a, 0xf7, 0xec, 0x2e, 0x31,
      0xb3, 0xe5, 0xab, 0x64, 0x9c, 0x16, 0x44, 0x90, 0xd3, 0x1d, 0x88, 0xcf,
      0xae, 0x35, 0xb8, 0x4a, 0xea, 0x79, 0x25, 0x69, 0x0f, 0x92, 0x9a, 0x14,
      0x4b, 0x6d, 0x2f, 0x48, 0xe8, 0xfb, 0x89, 0x4a, 0x52, 0xde, 0xec, 0xd1,
      0xb9, 0xa6, 0x49, 0x69, 0x90, 0xc4, 0xec, 0xf1, 0x58, 0x86, 0x99, 0xa4,
      0x2c, 0xac, 0xd1, 0x0c, 0x53, 0xaf, 0x35, 0x05, 0x14, 0xe4, 0x29, 0x1e,
      0xa9, 0xa0, 0x58, 0xe7, 0x7f, 0x10, 0x1e, 0x32, 0xc1, 0xc0, 0xce, 0xfa,
      0x61, 0xd9, 0x45, 0xf7, 0xbc, 0x93, 0x1f, 0x8b, 0xd1, 0x9e, 0x7b, 0xa3,
      0x16, 0x93, 0x58, 0xa6, 0x0e, 0x5a, 0x8b, 0x01, 0x23, 0xbc, 0x31, 0x99,
      0xb9, 0xfd, 0xca, 0xfe, 0x8e, 0x51, 0x9c, 0x41, 0xba, 0x67, 0x54, 0x91,
      0xa2, 0x7b, 0x85, 0xe4, 0x4e, 0xf2, 0xd7, 0x72, 0x77, 0xc1, 0x0f, 0xe1,
      0x07, 0x29, 0x3c, 0x82, 0x90, 0x18, 0x69, 0x13, 0xbc, 0x9a, 0x99, 0xb6,
      0x40, 0xd8, 0xda, 0x04, 0x1b, 0x64, 0xf3, 0x1e, 0xab, 0x1d, 0x35, 0x92,
      0x09, 0x85, 0xf4, 0xa5},
     pub_key_1,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment:
    // tcID: 4
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     4,
     32,
     {0x68, 0xca, 0xf0, 0x7e, 0x71, 0xee, 0x65, 0x4f, 0xfa, 0xbf, 0x07, 0xd3,
      0x42, 0xfc, 0x40, 0x59, 0xde, 0xb4, 0xf7, 0xe5, 0x97, 0x07, 0x46, 0xc4,
      0x23, 0xb1, 0xe8, 0xf6, 0x68, 0xd5, 0x33, 0x22, 0x75, 0xcc, 0x35, 0xeb,
      0x61, 0x27, 0x0a, 0xeb, 0xd2, 0x78, 0x55, 0xb1, 0xe8, 0x0d, 0x59, 0xde,
      0xf4, 0x7f, 0xe8, 0x88, 0x28, 0x67, 0xfd, 0x33, 0xc2, 0x30, 0x8c, 0x91,
      0x97, 0x6b, 0xaa, 0x0b, 0x1d, 0xf9, 0x52, 0xca, 0xa7, 0x8d, 0xb4, 0x82,
      0x8a, 0xb8, 0x1e, 0x79, 0x94, 0x9b, 0xf1, 0x45, 0xcb, 0xdf, 0xd1, 0xc4,
      0x98, 0x7e, 0xd0, 0x36, 0xf8, 0x1e, 0x84, 0x42, 0x08, 0x10, 0x16, 0xf2,
      0x0f, 0xa4, 0xb5, 0x87, 0x57, 0x48, 0x84, 0xca, 0x6f, 0x60, 0x45, 0x95,
      0x9c, 0xe3, 0x50, 0x1a, 0xe7, 0xc0, 0x2b, 0x19, 0x02, 0xec, 0x1d, 0x24,
      0x1e, 0xf2, 0x8d, 0xee, 0x35, 0x6c, 0x0d, 0x30, 0xd2, 0x8a, 0x95, 0x0f,
      0x1f, 0xbc, 0x68, 0x3e, 0xe7, 0xd9, 0xaa, 0xd2, 0x6b, 0x04, 0x8c, 0x13,
      0x42, 0x6f, 0xe3, 0x97, 0x5d, 0x56, 0x38, 0xaf, 0xeb, 0x5b, 0x9c, 0x1a,
      0x99, 0xd1, 0x62, 0xd3, 0xa5, 0x81, 0x0e, 0x8b, 0x07, 0x4d, 0x7a, 0x2e,
      0xae, 0x2b, 0xe5, 0x2b, 0x57, 0x71, 0x51, 0xf7, 0x6e, 0x1f, 0x73, 0x4b,
      0x0a, 0x95, 0x6e, 0xf4, 0xf2, 0x2b, 0xe6, 0x4d, 0xc2, 0x0a, 0x81, 0xad,
      0x13, 0x16, 0xe4, 0xf7, 0x9d, 0xff, 0x5f, 0xc4, 0x1f, 0xc0, 0x8a, 0x20,
      0xbc, 0x61, 0x22, 0x83, 0xa8, 0x84, 0x15, 0xd4, 0x15, 0x95, 0xbf, 0xea,
      0x66, 0xd5, 0x9d, 0xe7, 0xac, 0x12, 0xe2, 0x30, 0xf7, 0x22, 0x44, 0xad,
      0x99, 0x05, 0xae, 0xf0, 0xea, 0xd3, 0xfa, 0x41, 0xed, 0x70, 0xbf, 0x42,
      0x18, 0x86, 0x3d, 0x5f, 0x04, 0x12, 0x92, 0xf2, 0xd1, 0x4c, 0xe0, 0xa7,
      0x27, 0x1c, 0x6d, 0x36},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment:
    // tcID: 5
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     5,
     32,
     {0x59, 0x97, 0x24, 0xad, 0xc1, 0xba, 0xe3, 0x1e, 0x84, 0xeb, 0x6e, 0x13,
      0x99, 0xcd, 0x90, 0xcd, 0x67, 0xf4, 0x8b, 0x43, 0x2c, 0x63, 0x71, 0x9b,
      0x60, 0x04, 0x02, 0x38, 0x4a, 0xae, 0xa9, 0xb2, 0x1e, 0xe8, 0x64, 0xcd,
      0xcf, 0x25, 0x90, 0x29, 0x18, 0x08, 0x77, 0xc8, 0x47, 0xa2, 0x23, 0x91,
      0x2b, 0x06, 0x47, 0xf0, 0x66, 0xa5, 0x9a, 0x65, 0xdf, 0x6c, 0x2d, 0x3a,
      0x66, 0x75, 0xb1, 0x45, 0x0f, 0x0b, 0x05, 0x18, 0x5c, 0xee, 0x48, 0x6b,
      0xfa, 0xc5, 0x6c, 0xfd, 0xed, 0x18, 0x2b, 0xab, 0xce, 0xfe, 0x60, 0x56,
      0x8a, 0x69, 0x54, 0xf0, 0x26, 0xcb, 0x2f, 0x59, 0x00, 0x2a, 0x2f, 0x75,
      0x5e, 0x9b, 0xce, 0x49, 0x79, 0x3f, 0x28, 0x0d, 0x89, 0x82, 0x2c, 0x9b,
      0xd3, 0xa0, 0x6a, 0x7a, 0xd2, 0x20, 0x9c, 0x3d, 0x6c, 0xab, 0x7c, 0x1f,
      0x74, 0xc8, 0xbb, 0xf4, 0xbf, 0x37, 0x4e, 0x7a, 0xe8, 0xa5, 0x39, 0xfc,
      0xcb, 0x83, 0xa7, 0x8c, 0xff, 0x96, 0xa4, 0xf5, 0x38, 0xad, 0xeb, 0xa0,
      0x86, 0x96, 0x59, 0xd0, 0xe9, 0x64, 0x7d, 0x98, 0xf9, 0x6c, 0xb5, 0x5d,
      0x9c, 0xb7, 0xe5, 0x84, 0x40, 0xc4, 0xc9, 0xd8, 0x5b, 0x8e, 0x9d, 0xc6,
      0x02, 0xe9, 0x09, 0xe2, 0x9e, 0x45, 0xf2, 0xb8, 0x2d, 0xed, 0x44, 0xf4,
      0x0e, 0x9c, 0xeb, 0x12, 0x92, 0xda, 0x20, 0x06, 0x39, 0x67, 0xe3, 0xa1,
      0x16, 0xf4, 0xae, 0xb2, 0x02, 0x86, 0x3c, 0xea, 0x52, 0x3f, 0x21, 0x5b,
      0x8e, 0xc7, 0xfc, 0x4f, 0x6a, 0x22, 0xcd, 0x86, 0x52, 0xed, 0x66, 0x1e,
      0x33, 0x80, 0x3f, 0x3f, 0xa1, 0xbe, 0x96, 0x6f, 0xa8, 0x75, 0x4c, 0xc7,
      0xb0, 0xfa, 0x89, 0x4c, 0xee, 0x0f, 0x04, 0x5e, 0xfb, 0xa1, 0x4c, 0x4f,
      0x4a, 0x1d, 0x7c, 0xb8, 0x37, 0xce, 0xa6, 0x9e, 0x30, 0x52, 0x25, 0x26,
      0xb8, 0xa5, 0x87, 0x8f},
     pub_key_1,
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment:
    // tcID: 6
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     6,
     32,
     {0x4e, 0x68, 0xa8, 0x37, 0x5e, 0x08, 0x69, 0x90, 0xbd, 0xe0, 0x5f, 0xc4,
      0xbb, 0xde, 0x2d, 0x36, 0x8f, 0x8d, 0x96, 0xa5, 0xbb, 0xcf, 0x16, 0xd9,
      0x23, 0x9f, 0xcd, 0xd4, 0x59, 0x42, 0xd7, 0x64, 0xfc, 0x23, 0x17, 0xd9,
      0x0f, 0x4f, 0x62, 0xec, 0x80, 0x05, 0x94, 0x90, 0x24, 0x0b, 0xe8, 0xf3,
      0x2d, 0xfc, 0x32, 0x41, 0x4a, 0x42, 0x7c, 0x7e, 0x34, 0xbe, 0x25, 0xed,
      0x0d, 0xca, 0xee, 0x69, 0x27, 0x88, 0x1e, 0x79, 0x7d, 0xb9, 0x7a, 0x03,
      0x41, 0xfd, 0xde, 0x45, 0x9b, 0x9c, 0xc9, 0x15, 0xd0, 0xa3, 0x48, 0xe1,
      0x5d, 0xcb, 0xfe, 0x1b, 0x07, 0x80, 0x47, 0x2f, 0x52, 0xa8, 0x87, 0xfa,
      0xff, 0xc9, 0x88, 0xa9, 0xce, 0xb6, 0x77, 0xe1, 0xcf, 0x56, 0x38, 0xe4,
      0x4a, 0x9d, 0x6f, 0x25, 0x32, 0x41, 0x7e, 0xd0, 0xbd, 0xe5, 0xd6, 0x7f,
      0x5d, 0xc9, 0x22, 0x9e, 0xf1, 0xf3, 0xcf, 0xd9, 0xcb, 0x46, 0xc6, 0x95,
      0x73, 0x8f, 0xd0, 0x06, 0xcc, 0x62, 0xd0, 0x2f, 0x5d, 0xf7, 0x69, 0x96,
      0x27, 0x02, 0x23, 0x06, 0x0f, 0x72, 0x50, 0x5c, 0xcf, 0xbd, 0xf4, 0xe8,
      0x8d, 0x96, 0x1e, 0x2e, 0x77, 0x63, 0x70, 0x54, 0x80, 0x33, 0x51, 0x48,
      0xec, 0xdd, 0x23, 0xd1, 0x20, 0x2c, 0x26, 0xa9, 0x63, 0x86, 0x0d, 0xc7,
      0x69, 0xa4, 0x3e, 0x44, 0xc7, 0x22, 0x85, 0x09, 0x2b, 0xa7, 0xf2, 0x4d,
      0x81, 0x84, 0x4e, 0x61, 0x2b, 0xf0, 0x3f, 0x9c, 0x2d, 0xdd, 0x4e, 0x59,
      0x60, 0x62, 0x2f, 0x71, 0x67, 0x2f, 0x4e, 0x42, 0xb8, 0xa8, 0xf3, 0x6c,
      0x68, 0x47, 0xa0, 0x5f, 0x70, 0x40, 0x02, 0x07, 0x47, 0x1c, 0x57, 0x5d,
      0x6a, 0x96, 0x0f, 0xac, 0x1d, 0xe8, 0x09, 0x11, 0x8e, 0xfb, 0x52, 0x90,
      0x3c, 0xa3, 0x7f, 0x12, 0xd4, 0x0f, 0x6d, 0xe7, 0x4d, 0xec, 0xb9, 0xa5,
      0xb8, 0xa4, 0x15, 0xd4},
     pub_key_1,
     {0x61},
     true},

    // Comment:
    // tcID: 7
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     7,
     32,
     {0x8b, 0xdd, 0x6d, 0xb9, 0x03, 0x23, 0xf3, 0xbf, 0x26, 0xa3, 0x6a, 0x4a,
      0xb5, 0xb9, 0x21, 0x80, 0xc9, 0x68, 0x81, 0xbd, 0x32, 0xb6, 0x63, 0x17,
      0xc4, 0xb4, 0x8c, 0x2b, 0xa1, 0x42, 0x1f, 0x84, 0x34, 0x00, 0x0c, 0x06,
      0xad, 0xde, 0x42, 0x64, 0xc6, 0xea, 0x2d, 0x53, 0x46, 0x46, 0x8c, 0x6d,
      0x5e, 0x97, 0xcb, 0x13, 0xd3, 0xcb, 0x93, 0x2e, 0x52, 0x3a, 0xc5, 0x7b,
      0x59, 0xc8, 0x14, 0xfa, 0x03, 0x97, 0xca, 0x6d, 0xcc, 0x9b, 0xec, 0x4b,
      0xe1, 0x14, 0x7d, 0x77, 0xab, 0xcd, 0x31, 0x8a, 0x6a, 0xba, 0x1a, 0xf4,
      0x6e, 0xde, 0x2f, 0x56, 0x40, 0xda, 0x06, 0x51, 0x1a, 0x00, 0x6f, 0xd1,
      0xbd, 0x5f, 0xb8, 0xe0, 0x4b, 0xe2, 0x27, 0x89, 0x95, 0x6a, 0xdc, 0x47,
      0xbb, 0xec, 0x79, 0x88, 0xbe, 0x47, 0x71, 0x50, 0xf9, 0xb2, 0x4a, 0x07,
      0xdf, 0xf5, 0x15, 0x30, 0xe8, 0xf0, 0xc1, 0x4c, 0xfe, 0xf7, 0xd2, 0x5c,
      0xa1, 0x41, 0xf5, 0x12, 0x93, 0x99, 0x87, 0xb7, 0xeb, 0x08, 0x25, 0x63,
      0x3d, 0x41, 0xa4, 0x87, 0x42, 0xbd, 0x7f, 0x56, 0xd4, 0xdb, 0x97, 0x33,
      0xd9, 0x2a, 0xc0, 0xf3, 0x6b, 0x40, 0x41, 0xf5, 0x13, 0x32, 0x69, 0x5f,
      0x55, 0x1e, 0xc9, 0x10, 0x76, 0xda, 0x23, 0x01, 0x12, 0x0c, 0x43, 0x8e,
      0xb9, 0xec, 0x19, 0x7c, 0xbe, 0x31, 0x8d, 0x45, 0x71, 0xb6, 0xb7, 0x90,
      0x98, 0xd1, 0x7e, 0xde, 0xd0, 0xca, 0x47, 0x74, 0x7a, 0x14, 0x3e, 0x34,
      0xf8, 0x82, 0xad, 0x6e, 0x3f, 0x49, 0x0f, 0x3a, 0x71, 0x0f, 0xf7, 0xec,
      0x1b, 0xff, 0xce, 0x02, 0x20, 0x27, 0x16, 0x5d, 0x96, 0x28, 0x1e, 0x59,
      0x31, 0x80, 0xc6, 0x7f, 0x44, 0xae, 0xda, 0x9c, 0xe6, 0x60, 0x5e, 0x6b,
      0x8e, 0x5e, 0xac, 0x13, 0x47, 0x69, 0x5d, 0xab, 0x21, 0x1a, 0x96, 0x5b,
      0xb3, 0xd3, 0xf9, 0x28},
     pub_key_1,
     {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
      0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5,
      0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff},
     true},

    // Comment:
    // tcID: 8
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     8,
     32,
     {0x3a, 0x52, 0xbe, 0xc8, 0x4b, 0x5b, 0x41, 0xe0, 0x93, 0x58, 0xa7, 0xfe,
      0x24, 0xbb, 0x7a, 0xe0, 0xcb, 0x39, 0x36, 0x43, 0x74, 0xc9, 0x11, 0xe0,
      0xd3, 0xf0, 0x11, 0xf2, 0xc4, 0xc7, 0x96, 0x67, 0xf4, 0x3e, 0xb7, 0x00,
      0xfc, 0xb3, 0x3e, 0x44, 0x53, 0x36, 0x54, 0xb3, 0xef, 0xdb, 0x37, 0xe6,
      0x27, 0xea, 0xf1, 0x35, 0x2d, 0x21, 0xa1, 0x87, 0xa7, 0x0a, 0x86, 0xb7,
      0x9b, 0x2c, 0x34, 0xae, 0x3e, 0xef, 0x94, 0x4e, 0x3e, 0x61, 0xd3, 0x61,
      0xc3, 0xba, 0xa4, 0x46, 0xdd, 0x46, 0x5f, 0x2d, 0xdc, 0x0b, 0x2a, 0xe7,
      0xbc, 0x8b, 0xee, 0xc1, 0x76, 0x19, 0x22, 0xfb, 0x5d, 0x7a, 0xa6, 0xcc,
      0x4f, 0xab, 0x9d, 0x1a, 0x08, 0x35, 0xf1, 0x5c, 0xd7, 0x1c, 0xcb, 0x3f,
      0xcb, 0x57, 0xc5, 0x78, 0xa4, 0x6a, 0x71, 0x97, 0xda, 0xb4, 0x78, 0xb7,
      0xd1, 0xed, 0x7c, 0x62, 0x35, 0xde, 0xa3, 0xb1, 0x17, 0x47, 0x2c, 0x33,
      0x4c, 0x3a, 0x18, 0xfb, 0x8a, 0x57, 0x49, 0x22, 0xf5, 0x11, 0xd7, 0xeb,
      0xf0, 0x30, 0x20, 0x1d, 0xd7, 0x45, 0x7a, 0x38, 0x60, 0xa6, 0xaf, 0x62,
      0x52, 0xdd, 0xaf, 0x90, 0xd0, 0x7d, 0x90, 0xac, 0xa0, 0x3f, 0x70, 0x37,
      0x22, 0x34, 0x00, 0xc0, 0x66, 0xdb, 0x1d, 0x7f, 0xeb, 0x91, 0xd8, 0x48,
      0x15, 0xaf, 0x24, 0x30, 0x19, 0x0a, 0x21, 0x70, 0xac, 0x7e, 0xef, 0xf8,
      0x98, 0xeb, 0xd5, 0xc4, 0xc7, 0xe9, 0xbe, 0xd1, 0x9a, 0xa8, 0x62, 0x93,
      0xaa, 0x25, 0x7a, 0x9a, 0xd0, 0xa5, 0x14, 0x6b, 0xe8, 0x0e, 0x7c, 0xe6,
      0x08, 0x1c, 0x89, 0x06, 0xd2, 0x69, 0xd0, 0x6b, 0xf0, 0x37, 0xe3, 0x4e,
      0xe1, 0x8a, 0xba, 0x11, 0x3d, 0xcf, 0xc9, 0x8e, 0xca, 0x70, 0xab, 0xed,
      0x72, 0x49, 0xdc, 0x9a, 0x49, 0xf9, 0x71, 0x64, 0x8e, 0x58, 0xd7, 0xdb,
      0x22, 0x82, 0xed, 0x6a},
     pub_key_1,
     {0x34, 0x32, 0x36, 0x34, 0x37, 0x39, 0x37, 0x32, 0x34},
     true},

    // Comment:
    // tcID: 9
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     9,
     32,
     {0x0b, 0x47, 0xd3, 0xbf, 0xed, 0xac, 0x89, 0x32, 0x3c, 0xef, 0x0d, 0x27,
      0x30, 0x35, 0x67, 0x4b, 0x93, 0x7f, 0x41, 0x06, 0x35, 0x5c, 0x0b, 0xaa,
      0xbf, 0x66, 0x64, 0xa5, 0x7b, 0x30, 0x64, 0xa7, 0x89, 0x59, 0x2e, 0xc5,
      0xec, 0x4a, 0x63, 0x99, 0x7b, 0x6f, 0x3d, 0xd8, 0x1b, 0x05, 0x14, 0xa7,
      0x8b, 0x88, 0x24, 0xed, 0xb2, 0xb0, 0xff, 0xaf, 0x45, 0xf8, 0xae, 0x64,
      0x32, 0xce, 0x35, 0x21, 0xbf, 0x77, 0xe0, 0x19, 0x12, 0xdf, 0x0d, 0xa5,
      0xd6, 0xfa, 0xd9, 0xf5, 0x54, 0xa3, 0xd6, 0x9b, 0x40, 0x28, 0x66, 0x52,
      0x6e, 0x69, 0x14, 0xb5, 0xc7, 0x8a, 0xf8, 0x47, 0x23, 0x3d, 0x34, 0x82,
      0x59, 0x81, 0x43, 0xdd, 0x6f, 0xc6, 0x5a, 0x81, 0xdf, 0x92, 0xcf, 0xe1,
      0x19, 0xf3, 0x8b, 0x0d, 0x4f, 0x9d, 0x1a, 0x51, 0xa9, 0x9a, 0xa5, 0x69,
      0xe4, 0x2c, 0xde, 0xc9, 0xb4, 0x2a, 0x05, 0x98, 0xf5, 0xf0, 0xbb, 0xaa,
      0x1b, 0xcd, 0x44, 0xc1, 0x9c, 0x76, 0x14, 0x20, 0x2e, 0x0a, 0xeb, 0xaa,
      0xef, 0xff, 0x7f, 0x3d, 0x19, 0x76, 0x35, 0xe4, 0x90, 0xbb, 0xa8, 0x19,
      0x27, 0xce, 0x49, 0x1a, 0x58, 0x10, 0x95, 0x25, 0x93, 0xf8, 0xfd, 0x57,
      0xa8, 0x0f, 0x60, 0xbc, 0x3c, 0x0b, 0x2a, 0x7b, 0x10, 0xa0, 0xf9, 0xdd,
      0x49, 0x30, 0xdb, 0x81, 0x72, 0xbc, 0xb1, 0x64, 0x2f, 0x6d, 0x03, 0x33,
      0x2a, 0x7d, 0x90, 0xce, 0x1e, 0xdc, 0x1f, 0x80, 0x54, 0xb5, 0xbd, 0x4f,
      0x47, 0x60, 0x99, 0x6b, 0xcd, 0x56, 0x5b, 0xdd, 0xd2, 0xc6, 0xdc, 0x8f,
      0x54, 0xfc, 0x6d, 0xa5, 0xe6, 0xfe, 0x80, 0xa2, 0x24, 0x8f, 0x92, 0x02,
      0x16, 0xb1, 0xbb, 0x83, 0x6d, 0x78, 0x85, 0xa0, 0x23, 0xd9, 0x2e, 0xda,
      0xd5, 0xd2, 0x0b, 0x0e, 0x47, 0xcf, 0x5b, 0xeb, 0x2c, 0xbb, 0x13, 0x93,
      0xc6, 0x24, 0xeb, 0x3a},
     pub_key_1,
     {0x37, 0x31, 0x33, 0x38, 0x36, 0x38, 0x34, 0x38, 0x39, 0x31},
     true},

    // Comment:
    // tcID: 10
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     10,
     32,
     {0x20, 0xc9, 0xd4, 0x47, 0xee, 0x65, 0xa4, 0xcf, 0x78, 0x83, 0xab, 0x72,
      0x4d, 0xf0, 0xc4, 0x54, 0x81, 0x40, 0x29, 0xc8, 0x17, 0x8d, 0xdd, 0x25,
      0xea, 0xaf, 0xab, 0x34, 0x34, 0x4d, 0x6e, 0x06, 0x87, 0x7d, 0x5a, 0x71,
      0x21, 0xaf, 0x22, 0xc7, 0xe5, 0x33, 0x3e, 0x2d, 0x4f, 0x2b, 0xdf, 0x42,
      0x45, 0x0b, 0x7b, 0x73, 0x5c, 0x33, 0x5e, 0xbd, 0xfb, 0x46, 0x1f, 0x7b,
      0x20, 0xdb, 0xb7, 0x7c, 0x68, 0xc4, 0x49, 0xb7, 0x82, 0x6a, 0xd1, 0x46,
      0x68, 0xe2, 0x10, 0x3b, 0x63, 0x6b, 0x30, 0x0a, 0x67, 0x5a, 0x9b, 0x3b,
      0x1a, 0xca, 0x93, 0x64, 0x20, 0xcf, 0x3f, 0xd8, 0xde, 0xb2, 0xac, 0x8a,
      0xec, 0x65, 0x28, 0x40, 0x9f, 0x64, 0x19, 0xd8, 0xd5, 0xac, 0x9e, 0xc2,
      0x75, 0x7a, 0xd4, 0x78, 0x1e, 0x9c, 0xbd, 0xa9, 0x89, 0x12, 0xf4, 0x30,
      0x47, 0x10, 0xd3, 0xa8, 0x90, 0x53, 0xeb, 0xfa, 0x7a, 0x84, 0x35, 0x3c,
      0x86, 0xb0, 0xc4, 0x8e, 0xea, 0x5a, 0x54, 0x1a, 0xf4, 0x64, 0x4f, 0xfa,
      0x21, 0xb7, 0x66, 0xe7, 0x38, 0xf0, 0xd9, 0x4c, 0xc7, 0x96, 0x00, 0x4b,
      0x62, 0x5f, 0x24, 0x4f, 0x63, 0xc4, 0x16, 0x66, 0xb2, 0x21, 0x33, 0x17,
      0xf7, 0x78, 0xf0, 0xd9, 0xd7, 0xd0, 0x9a, 0x10, 0x03, 0xcb, 0xe1, 0xb2,
      0xbf, 0xef, 0x58, 0x5f, 0x15, 0x80, 0xf9, 0x41, 0x39, 0x80, 0x59, 0xa0,
      0x9e, 0xc0, 0x7a, 0xe3, 0x5b, 0xb6, 0x90, 0x72, 0x8c, 0xe8, 0x5c, 0x2e,
      0x19, 0x2d, 0x42, 0x3a, 0x71, 0xb5, 0x13, 0x00, 0x8c, 0x29, 0x58, 0x2b,
      0x37, 0xdf, 0x1f, 0x83, 0xe4, 0x0a, 0x69, 0x9c, 0x88, 0x04, 0x8a, 0xad,
      0xd8, 0x12, 0x11, 0x32, 0x2b, 0x3c, 0x9b, 0xb4, 0x49, 0xad, 0xdb, 0x03,
      0x7c, 0x55, 0x35, 0x51, 0xd7, 0x83, 0x5e, 0x90, 0xd5, 0x3f, 0x1a, 0x18,
      0x83, 0x76, 0x6d, 0x5b},
     pub_key_1,
     {0x31, 0x30, 0x33, 0x35, 0x39, 0x33, 0x33, 0x31, 0x36, 0x36, 0x38},
     true},

    // Comment:
    // tcID: 11
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     11,
     32,
     {0x7c, 0x5e, 0x13, 0x5d, 0x76, 0x70, 0xa5, 0x7d, 0x8f, 0xd7, 0xa1, 0xc9,
      0xc7, 0xb3, 0x3a, 0x6e, 0x07, 0xa5, 0x7d, 0x95, 0x7f, 0x7a, 0x5d, 0x95,
      0x94, 0x20, 0x0e, 0xaa, 0x96, 0x47, 0xa1, 0xd4, 0x60, 0xbb, 0xeb, 0xc4,
      0x0e, 0x00, 0x36, 0xa7, 0xd7, 0x66, 0x5e, 0xba, 0xca, 0x9f, 0xfe, 0x3a,
      0x16, 0x6f, 0xa1, 0x41, 0x1c, 0x70, 0x40, 0x49, 0x97, 0x5a, 0x5e, 0x46,
      0xb4, 0xd4, 0xfa, 0x03, 0xad, 0xbf, 0x69, 0xd1, 0xa1, 0x8a, 0xdf, 0x59,
      0x50, 0x5e, 0x6d, 0x2c, 0xfb, 0xb8, 0x2d, 0x5d, 0x32, 0xb7, 0xe3, 0xdc,
      0xeb, 0x85, 0x42, 0xe9, 0xed, 0x8c, 0x7a, 0xc2, 0x48, 0xf9, 0xf7, 0xa8,
      0x4a, 0xbf, 0x3f, 0x16, 0xe8, 0x62, 0x72, 0x6a, 0x4d, 0xd1, 0x89, 0xc6,
      0x1d, 0x69, 0x79, 0xd8, 0x5b, 0xa9, 0x82, 0xdb, 0x3a, 0x5b, 0x29, 0x03,
      0xf3, 0x8d, 0x25, 0x58, 0xcc, 0x11, 0x5d, 0x64, 0x81, 0x95, 0x25, 0x06,
      0x18, 0x2a, 0x09, 0xe0, 0x4e, 0xc2, 0x57, 0xb1, 0x92, 0x35, 0xf6, 0xc6,
      0xe2, 0xc6, 0x58, 0x7b, 0xed, 0xb9, 0x07, 0x09, 0x29, 0x8c, 0x14, 0x2f,
      0xa3, 0x17, 0x42, 0xf4, 0x01, 0xf2, 0x2e, 0x2b, 0x4b, 0x44, 0x6f, 0x96,
      0x42, 0xb5, 0x98, 0xcf, 0x43, 0xd4, 0xd2, 0x9b, 0xd0, 0x93, 0x4f, 0x48,
      0x53, 0xef, 0x70, 0xec, 0x72, 0xb9, 0x7f, 0x6b, 0xfb, 0x08, 0x4f, 0x45,
      0xea, 0x43, 0x9c, 0x4d, 0xd8, 0x24, 0x2d, 0x05, 0x9b, 0xc3, 0xc1, 0xa8,
      0x51, 0xc6, 0x7d, 0x94, 0x35, 0x7f, 0x93, 0x58, 0x70, 0x14, 0xb2, 0x86,
      0x0d, 0x7f, 0x19, 0x5f, 0x7b, 0x6b, 0xfb, 0x39, 0xaf, 0xa7, 0x12, 0x33,
      0x8c, 0x68, 0x4f, 0x68, 0x50, 0x1c, 0x5f, 0xb9, 0xa6, 0x7d, 0xbb, 0x36,
      0x54, 0x4e, 0x6b, 0xae, 0x5f, 0x72, 0xdc, 0xc8, 0x58, 0x15, 0xc2, 0xd4,
      0xd7, 0x0b, 0x5b, 0xaa},
     pub_key_1,
     {0x33, 0x39, 0x34, 0x39, 0x34, 0x30, 0x31, 0x32, 0x31, 0x35},
     true},

    // Comment:
    // tcID: 12
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     12,
     32,
     {0x80, 0xff, 0x5c, 0x82, 0x58, 0xbc, 0x0c, 0x74, 0x99, 0x3d, 0xbd, 0xc0,
      0xba, 0x64, 0x4e, 0x05, 0x0c, 0xf4, 0x72, 0x13, 0xa6, 0xa1, 0x9b, 0xc8,
      0x3d, 0x5e, 0x4b, 0x20, 0x80, 0xad, 0xcc, 0xa7, 0x63, 0xa5, 0x59, 0x18,
      0xa7, 0xe1, 0x9d, 0x85, 0xa0, 0xda, 0x38, 0xc5, 0xcc, 0x4c, 0x0b, 0x95,
      0x88, 0x84, 0xfc, 0x79, 0x57, 0x8d, 0x4c, 0x91, 0xbc, 0x40, 0x37, 0x56,
      0xc6, 0xdc, 0x35, 0x37, 0x40, 0xdf, 0x2d, 0x03, 0x30, 0xf3, 0x2e, 0x1c,
      0xa9, 0x11, 0x36, 0x93, 0x3f, 0x24, 0x91, 0xc6, 0xe7, 0xe9, 0xa0, 0x1e,
      0xa7, 0xbc, 0xc8, 0x70, 0x88, 0xd7, 0x86, 0x3e, 0x04, 0x8f, 0xe9, 0x79,
      0x6d, 0x95, 0x5e, 0xc7, 0xcf, 0x1d, 0x16, 0x6a, 0xc3, 0x6a, 0x43, 0x1e,
      0x4f, 0x85, 0x8d, 0x93, 0xd8, 0xca, 0xeb, 0xc6, 0xff, 0x60, 0xa6, 0x78,
      0xd3, 0x8f, 0xfc, 0x0c, 0x88, 0xe8, 0xee, 0x0e, 0xa6, 0x55, 0xd4, 0xc1,
      0xa4, 0x63, 0x45, 0x55, 0x6e, 0x46, 0x33, 0xff, 0xdc, 0xe6, 0x89, 0x14,
      0xc7, 0x5a, 0x55, 0xf0, 0x71, 0xd4, 0xe5, 0x9a, 0x2e, 0xb0, 0xd6, 0xfb,
      0x6f, 0xe4, 0xf2, 0x8b, 0x63, 0xad, 0xfc, 0x59, 0x0a, 0x4f, 0x5f, 0xc7,
      0x28, 0x12, 0xda, 0xcc, 0x54, 0x7f, 0xa0, 0xc4, 0x98, 0x56, 0x20, 0xd4,
      0x01, 0x90, 0x83, 0xee, 0xf1, 0x15, 0xdb, 0xdd, 0xd6, 0x73, 0x84, 0x7b,
      0x79, 0x54, 0x0a, 0x4b, 0xee, 0x6d, 0xc4, 0xee, 0x8d, 0xe2, 0x67, 0x05,
      0x7e, 0x32, 0x1c, 0x44, 0xaa, 0xe0, 0x47, 0xd7, 0xbe, 0xf2, 0x30, 0x23,
      0x69, 0xcf, 0xf2, 0x91, 0xf6, 0xef, 0xa9, 0x0d, 0xde, 0x97, 0x67, 0x2e,
      0xc3, 0xcd, 0xf4, 0x95, 0x3f, 0x27, 0xf2, 0x6c, 0xe6, 0x2e, 0x77, 0x25,
      0x1f, 0xbf, 0x50, 0x77, 0xfa, 0x98, 0x6d, 0xab, 0x52, 0x13, 0xf1, 0xf9,
      0x4b, 0x19, 0xe1, 0x27},
     pub_key_1,
     {0x31, 0x33, 0x34, 0x34, 0x32, 0x39, 0x33, 0x30, 0x37, 0x39},
     true},

    // Comment:
    // tcID: 13
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     13,
     32,
     {0x70, 0xed, 0xdb, 0x0b, 0x9c, 0xda, 0xcf, 0x82, 0xad, 0xd0, 0xc5, 0x8a,
      0x15, 0x4f, 0xf2, 0xc0, 0xca, 0x5c, 0xbe, 0x28, 0x77, 0xdb, 0xac, 0x3e,
      0x55, 0x96, 0xde, 0x69, 0xc6, 0x86, 0xac, 0x27, 0x10, 0xa7, 0x8c, 0xaa,
      0xf6, 0x49, 0x2a, 0xf1, 0x8b, 0x42, 0x95, 0x6c, 0x45, 0x0d, 0xc4, 0xeb,
      0x1a, 0x3e, 0x6f, 0xd6, 0x69, 0x10, 0x0d, 0x55, 0xe0, 0x6b, 0x34, 0x28,
      0xc6, 0x28, 0x52, 0x54, 0x29, 0x1f, 0xab, 0x9c, 0x80, 0x63, 0x4c, 0x6f,
      0x9c, 0x87, 0x4d, 0xb7, 0x7c, 0x21, 0x07, 0xdb, 0x37, 0x72, 0x0b, 0x43,
      0x98, 0x2d, 0x97, 0x63, 0xcf, 0x34, 0xf7, 0x92, 0x83, 0x26, 0x5d, 0xd7,
      0x0f, 0x03, 0xe4, 0x44, 0x15, 0x8e, 0x82, 0x70, 0x95, 0x55, 0xdb, 0x72,
      0xfd, 0x7d, 0x13, 0xa0, 0x04, 0x29, 0x01, 0x40, 0xc8, 0x05, 0x11, 0x98,
      0x5f, 0xc5, 0xad, 0x27, 0x5a, 0x72, 0xab, 0xfa, 0x7a, 0xb8, 0x78, 0xcf,
      0x04, 0x3e, 0x66, 0x94, 0x34, 0x0e, 0xc6, 0xb3, 0xcb, 0xef, 0x57, 0x28,
      0xf2, 0xc3, 0xc6, 0x37, 0x47, 0xff, 0x75, 0x90, 0x66, 0x73, 0xbe, 0x53,
      0x80, 0x0a, 0x7e, 0xac, 0x17, 0xa4, 0x7d, 0xeb, 0xac, 0x1c, 0x5a, 0x9d,
      0xd3, 0x6e, 0xeb, 0xba, 0x9c, 0x23, 0x57, 0x5f, 0xfe, 0x1e, 0xd4, 0xcc,
      0xd2, 0xfd, 0x3a, 0x4b, 0x99, 0x02, 0xf5, 0x63, 0xb1, 0x7f, 0x2b, 0xd9,
      0x63, 0x8d, 0x23, 0x48, 0xaf, 0x17, 0x5e, 0x1c, 0xb9, 0x18, 0xa0, 0x68,
      0x16, 0x91, 0xa8, 0x44, 0x44, 0x75, 0x17, 0x50, 0x46, 0x33, 0x25, 0xeb,
      0xef, 0x2c, 0x40, 0x49, 0x3f, 0x04, 0x9c, 0x65, 0x50, 0x77, 0xa7, 0x0b,
      0xf4, 0x20, 0xb5, 0x09, 0x17, 0x90, 0x63, 0x15, 0x65, 0x71, 0x78, 0xe7,
      0xcf, 0xe6, 0x07, 0xe9, 0xc2, 0x2a, 0x23, 0xe6, 0x7f, 0xb8, 0x85, 0x90,
      0xb7, 0x53, 0x41, 0x1c},
     pub_key_1,
     {0x33, 0x37, 0x30, 0x36, 0x32, 0x31, 0x31, 0x37, 0x31, 0x32},
     true},

    // Comment:
    // tcID: 14
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     14,
     32,
     {0x0f, 0xf6, 0xe3, 0x7a, 0x9a, 0xa0, 0x33, 0x91, 0xe6, 0xec, 0x82, 0x70,
      0xb9, 0x26, 0xc1, 0x23, 0xc7, 0xe6, 0x85, 0x3e, 0x01, 0xe4, 0x53, 0x03,
      0x82, 0xae, 0x1e, 0x90, 0x67, 0xc2, 0xc4, 0x47, 0xf2, 0xd2, 0x1e, 0xa4,
      0xf6, 0xb8, 0xcf, 0xfe, 0xa5, 0xcd, 0xea, 0xd0, 0xe7, 0xbb, 0xf4, 0xc2,
      0x6c, 0x07, 0x41, 0x83, 0x97, 0xf7, 0xdd, 0x85, 0xf4, 0xbb, 0xac, 0x03,
      0x76, 0xaa, 0x09, 0x95, 0x74, 0xdb, 0xd3, 0x14, 0x20, 0x81, 0x42, 0x87,
      0x62, 0xe0, 0x09, 0x23, 0x88, 0x14, 0x2b, 0x35, 0x14, 0x83, 0xb6, 0x7f,
      0xd8, 0xab, 0xfb, 0x5b, 0x73, 0xf1, 0x03, 0x83, 0xd3, 0x3f, 0xc2, 0x1a,
      0xee, 0xdc, 0x6a, 0x0e, 0x6f, 0x8a, 0x3d, 0x47, 0xf1, 0x1c, 0x8b, 0x31,
      0x94, 0x25, 0xf9, 0x76, 0x8c, 0xbb, 0xf4, 0x98, 0xad, 0xee, 0x29, 0xe7,
      0xd5, 0x26, 0x11, 0xfe, 0xff, 0x85, 0x96, 0xb1, 0xef, 0x21, 0xeb, 0xd2,
      0x03, 0x39, 0x7d, 0x58, 0x42, 0xca, 0xcf, 0x57, 0x0d, 0x79, 0xcf, 0x0b,
      0x43, 0x08, 0xa3, 0x2d, 0x09, 0x51, 0xa7, 0xfb, 0xf7, 0x94, 0xb8, 0x4e,
      0x54, 0x0c, 0xb5, 0x2b, 0xb0, 0x76, 0x97, 0x2f, 0x00, 0x3a, 0xd5, 0x9a,
      0x35, 0xde, 0xb7, 0xaf, 0x88, 0x7b, 0xed, 0xfd, 0x26, 0xcc, 0x7b, 0x2b,
      0xf3, 0x34, 0xe2, 0x42, 0x51, 0x89, 0x78, 0xff, 0x2e, 0x48, 0x22, 0x4f,
      0x89, 0xc7, 0x89, 0x47, 0x37, 0xbb, 0x83, 0x5b, 0xc3, 0x53, 0xf4, 0xc0,
      0x13, 0x95, 0x53, 0xd3, 0xaa, 0x47, 0x22, 0xd0, 0xcb, 0x15, 0xc5, 0xe0,
      0xac, 0xa5, 0xf5, 0xeb, 0x91, 0xdc, 0x9f, 0x46, 0x39, 0xaa, 0x81, 0x31,
      0x40, 0x38, 0x36, 0x7c, 0x27, 0x79, 0xba, 0x55, 0x21, 0xb2, 0x50, 0xb5,
      0xad, 0xa4, 0x8e, 0xa3, 0xd2, 0xbc, 0x41, 0xa1, 0x68, 0x09, 0x00, 0xbc,
      0xf3, 0xcf, 0x66, 0xbb},
     pub_key_1,
     {0x33, 0x34, 0x33, 0x36, 0x38, 0x38, 0x37, 0x31, 0x32},
     true},

    // Comment:
    // tcID: 15
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     15,
     32,
     {0x22, 0xbe, 0xe4, 0x51, 0x00, 0xf2, 0x6f, 0x64, 0xd7, 0xd9, 0x94, 0x18,
      0x78, 0x41, 0xd9, 0xee, 0xd5, 0xae, 0x1a, 0xf0, 0x60, 0x16, 0x04, 0xb7,
      0x2e, 0xa0, 0x05, 0xfa, 0xe6, 0xe2, 0x8c, 0xf0, 0xac, 0x2d, 0xdd, 0x97,
      0x61, 0x04, 0x6e, 0xda, 0x1e, 0xe5, 0x59, 0x49, 0x82, 0x0c, 0x55, 0x45,
      0xa0, 0xaf, 0x3f, 0xce, 0xd4, 0x02, 0xbd, 0xd4, 0x63, 0xf4, 0x30, 0x70,
      0xda, 0x8a, 0x4d, 0xff, 0x41, 0x53, 0x1a, 0x0c, 0xe0, 0x9b, 0x2e, 0xaa,
      0x14, 0xbb, 0xd3, 0x71, 0x3b, 0x79, 0xbd, 0xf0, 0x0a, 0x14, 0x41, 0x67,
      0xcd, 0x21, 0x42, 0xdf, 0x7a, 0xa8, 0xc5, 0xa2, 0x4b, 0xe6, 0x9c, 0x4c,
      0x1a, 0x72, 0x8c, 0xd0, 0x44, 0x21, 0x18, 0x36, 0x58, 0x72, 0x6c, 0x57,
      0x65, 0xb3, 0x67, 0x01, 0xf0, 0xd6, 0x1d, 0x26, 0xd0, 0x62, 0xba, 0xec,
      0x16, 0xeb, 0x59, 0xb1, 0x59, 0x4a, 0x18, 0x53, 0x63, 0xd8, 0xef, 0xf9,
      0x93, 0xab, 0x9c, 0x6d, 0x5a, 0x58, 0x99, 0x19, 0x91, 0x69, 0xad, 0xa4,
      0x4b, 0x77, 0xeb, 0xa6, 0x24, 0xc5, 0x3b, 0xd7, 0xb7, 0x45, 0xb0, 0x53,
      0xc5, 0x53, 0x55, 0xda, 0x88, 0xe6, 0xb8, 0x3e, 0x74, 0x06, 0x9d, 0x7d,
      0x7e, 0x51, 0x96, 0x4a, 0x0a, 0xd6, 0x66, 0xff, 0x02, 0x7e, 0xc4, 0x79,
      0x2c, 0x6f, 0x13, 0x9f, 0x1b, 0xaa, 0xee, 0x76, 0x9d, 0xeb, 0xc5, 0x5a,
      0xbd, 0xcb, 0xfd, 0x22, 0xfe, 0x84, 0xd6, 0xd6, 0xc7, 0x0a, 0x1c, 0xd1,
      0x45, 0x97, 0xe7, 0xe3, 0xc2, 0x18, 0xb3, 0x6f, 0x35, 0xf5, 0x7d, 0x4b,
      0x4d, 0xae, 0x3f, 0x1c, 0x1d, 0xee, 0x43, 0x32, 0x59, 0xe9, 0x61, 0xcf,
      0x69, 0xc3, 0xe0, 0x19, 0x43, 0x8a, 0xb6, 0x0d, 0xbd, 0xba, 0xe0, 0x50,
      0x51, 0x9f, 0xc3, 0x62, 0x0f, 0xf6, 0x77, 0xd5, 0xce, 0x9e, 0xd6, 0xfc,
      0x43, 0x86, 0x8e, 0x1b},
     pub_key_1,
     {0x31, 0x33, 0x35, 0x31, 0x35, 0x33, 0x30, 0x33, 0x37, 0x30},
     true},

    // Comment:
    // tcID: 16
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     16,
     32,
     {0x1b, 0x41, 0xb1, 0x02, 0x1b, 0x3b, 0xd5, 0xfc, 0x18, 0x6e, 0xed, 0x5c,
      0x1d, 0x2a, 0x69, 0xf7, 0xe6, 0x48, 0xd7, 0x5a, 0x03, 0xb0, 0xfb, 0xd6,
      0x21, 0x04, 0x44, 0x2c, 0x55, 0xa7, 0x07, 0x81, 0x2e, 0xf6, 0x35, 0xc7,
      0x26, 0x9c, 0xfc, 0xb1, 0x24, 0xf4, 0x64, 0xd6, 0x53, 0x2f, 0x28, 0x88,
      0x0b, 0x26, 0xf9, 0x1b, 0x4f, 0x3f, 0x82, 0x62, 0x07, 0xc0, 0xb2, 0x54,
      0x01, 0xba, 0x1e, 0xed, 0x2b, 0x48, 0x95, 0x73, 0x70, 0x80, 0x08, 0x5a,
      0xde, 0x80, 0xf1, 0x36, 0x20, 0xc2, 0x0b, 0xce, 0x00, 0x4a, 0x15, 0x7e,
      0x70, 0x8f, 0x45, 0x0b, 0xc6, 0x15, 0xfd, 0x35, 0xc1, 0xd2, 0x48, 0xed,
      0x0f, 0x9c, 0xbf, 0xdc, 0x77, 0x22, 0x2d, 0x84, 0x7f, 0xa8, 0x14, 0x3e,
      0x85, 0xf3, 0xed, 0xdc, 0xdd, 0xbb, 0x13, 0x7b, 0xc7, 0xbd, 0xb2, 0xce,
      0xab, 0xad, 0xbf, 0xf8, 0xaa, 0xde, 0xe8, 0x6a, 0xaa, 0xa2, 0x17, 0xa3,
      0x53, 0x39, 0x39, 0xfe, 0xf1, 0xd6, 0xf5, 0xf3, 0xb5, 0x27, 0x7d, 0x7f,
      0x8e, 0xf1, 0xca, 0x07, 0x19, 0x47, 0x30, 0xed, 0xee, 0x92, 0xcc, 0x3f,
      0xc9, 0xad, 0xe2, 0xfa, 0xa6, 0x03, 0x11, 0x7e, 0x5a, 0xb8, 0x12, 0xad,
      0x5a, 0x37, 0x54, 0x29, 0xeb, 0xb9, 0x13, 0xfb, 0x37, 0x0e, 0xee, 0xff,
      0x36, 0x27, 0x27, 0xc9, 0xbf, 0x29, 0x01, 0xcd, 0xf3, 0x4c, 0x6d, 0x3f,
      0x03, 0xca, 0x5a, 0xdc, 0x84, 0x97, 0x59, 0xec, 0x2c, 0x8d, 0xd6, 0x4f,
      0xa2, 0x47, 0x16, 0xaf, 0x61, 0x07, 0x49, 0xce, 0x46, 0x2f, 0x18, 0x9a,
      0x5c, 0x3c, 0x94, 0x7e, 0x4c, 0xc6, 0x5d, 0x66, 0x98, 0x3e, 0xa9, 0xef,
      0xa2, 0x92, 0x7d, 0xd4, 0xd9, 0x05, 0x4c, 0x2e, 0x0b, 0x96, 0x94, 0x28,
      0xb1, 0x8a, 0xab, 0x61, 0x6d, 0x3f, 0x95, 0xd2, 0x4d, 0x8a, 0x72, 0x5d,
      0x26, 0x86, 0xd1, 0x0c},
     pub_key_1,
     {0x36, 0x35, 0x35, 0x33, 0x32, 0x30, 0x33, 0x31, 0x32, 0x36},
     true},

    // Comment:
    // tcID: 17
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     17,
     32,
     {0x52, 0x44, 0x9f, 0x16, 0x36, 0x76, 0xb9, 0xa8, 0x24, 0x9b, 0x63, 0xd0,
      0x34, 0x0d, 0x82, 0x30, 0x5c, 0xf3, 0x6a, 0x92, 0x0f, 0x17, 0x33, 0x89,
      0xf3, 0x04, 0x04, 0x45, 0x03, 0xb3, 0xf5, 0xdb, 0xb5, 0x03, 0xb8, 0xc0,
      0x9c, 0xae, 0x20, 0xa2, 0x4c, 0xb6, 0x25, 0x3a, 0x16, 0xd2, 0xe6, 0x35,
      0x59, 0xe0, 0x74, 0x6f, 0x05, 0xc6, 0xdd, 0xd8, 0xfd, 0x65, 0x7c, 0x34,
      0xc2, 0xde, 0x6f, 0xee, 0x62, 0xcf, 0xd2, 0xd4, 0xc6, 0xc4, 0x25, 0x8b,
      0x13, 0x8b, 0x7e, 0x82, 0x73, 0x26, 0x11, 0x08, 0x12, 0xb1, 0xa0, 0x45,
      0x73, 0x98, 0x9b, 0x96, 0x9c, 0x76, 0x9d, 0x29, 0xc8, 0x88, 0xe1, 0xe6,
      0x45, 0x46, 0x41, 0x9d, 0x17, 0xa1, 0x6c, 0xe9, 0xab, 0xeb, 0xc2, 0xbc,
      0x00, 0xf8, 0x82, 0x24, 0x01, 0xee, 0x1e, 0xcf, 0xb9, 0xaa, 0xe3, 0x9f,
      0x35, 0x79, 0x23, 0x38, 0xf6, 0x07, 0x79, 0x1a, 0xcd, 0x3d, 0x7d, 0xfd,
      0x3e, 0x6b, 0x58, 0x4d, 0xc9, 0x38, 0x2f, 0x55, 0x89, 0x90, 0x60, 0x7d,
      0x26, 0xf1, 0xf4, 0x61, 0xc5, 0xb5, 0x78, 0x79, 0xd2, 0xb0, 0xd1, 0xb6,
      0xf5, 0x0d, 0x8b, 0xa2, 0x3b, 0x37, 0x01, 0x5d, 0xa5, 0x59, 0xc4, 0x1f,
      0xad, 0x4b, 0xa3, 0x60, 0x7b, 0x5c, 0xb4, 0x0d, 0x18, 0xc2, 0x13, 0x10,
      0x91, 0x10, 0x2a, 0x42, 0x95, 0x55, 0x5e, 0xa3, 0x7e, 0x9c, 0xe9, 0x2c,
      0xc7, 0xdd, 0x2f, 0x41, 0xbb, 0x5e, 0xb3, 0x0d, 0x02, 0xc3, 0x05, 0x11,
      0x6c, 0x0f, 0x65, 0x46, 0x4e, 0x8e, 0x95, 0x84, 0xd1, 0x75, 0x7f, 0x4b,
      0xe2, 0xaa, 0x28, 0x14, 0xce, 0x6b, 0x38, 0x7c, 0xdd, 0x7a, 0xe7, 0x8a,
      0xa0, 0x03, 0x2a, 0xd5, 0x93, 0x5d, 0x74, 0xd4, 0xd5, 0x66, 0x59, 0xe8,
      0x04, 0x34, 0x2a, 0xea, 0x3a, 0x78, 0x5d, 0x6b, 0xfb, 0x70, 0xc0, 0xcb,
      0x44, 0x89, 0x79, 0x03},
     pub_key_1,
     {0x31, 0x35, 0x36, 0x34, 0x33, 0x34, 0x36, 0x36, 0x30, 0x33},
     true},

    // Comment:
    // tcID: 18
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     18,
     32,
     {0x33, 0xc7, 0x6d, 0xf0, 0x7a, 0x9a, 0xe7, 0x33, 0x5f, 0x5e, 0x31, 0xb3,
      0xd1, 0x4d, 0x74, 0x12, 0xcc, 0x79, 0xc8, 0x76, 0x1f, 0xfc, 0x7f, 0xb5,
      0x52, 0x8a, 0xde, 0x2e, 0x50, 0x88, 0xd3, 0xbe, 0x3e, 0x26, 0x99, 0x62,
      0x08, 0x8f, 0x35, 0x68, 0x30, 0xf6, 0xdb, 0xb4, 0x60, 0xc7, 0x3a, 0x52,
      0x60, 0x57, 0xd5, 0x76, 0x48, 0xcb, 0xc7, 0x09, 0xc1, 0x4c, 0x23, 0xd8,
      0x5f, 0x85, 0xc1, 0x1a, 0xd5, 0xc6, 0xcc, 0x7e, 0x3c, 0xeb, 0x52, 0x38,
      0xbe, 0x9e, 0x83, 0x80, 0xbd, 0x78, 0x91, 0x06, 0xcd, 0x10, 0xe0, 0x34,
      0x03, 0x68, 0x73, 0xba, 0x7b, 0x8a, 0xc9, 0x47, 0x0a, 0x01, 0xcf, 0x40,
      0x48, 0xb4, 0x88, 0x78, 0x25, 0x87, 0xe2, 0xe5, 0xd7, 0xb4, 0xd2, 0x11,
      0x6e, 0x34, 0xb9, 0x4f, 0x9c, 0x3d, 0x22, 0x98, 0x31, 0x15, 0xc0, 0xfe,
      0x96, 0xb4, 0x20, 0x63, 0xb4, 0xf6, 0xfe, 0xf5, 0x94, 0x3f, 0xbc, 0x89,
      0x1a, 0x32, 0x0f, 0x09, 0xe6, 0x2f, 0x36, 0xcb, 0x1a, 0x6d, 0x83, 0x75,
      0x2a, 0x1c, 0x4f, 0xa6, 0xb6, 0x28, 0x99, 0xaf, 0xff, 0x51, 0x18, 0xaf,
      0x71, 0x02, 0xe1, 0x23, 0xfe, 0x9c, 0x7b, 0x2a, 0x51, 0xcf, 0x30, 0x56,
      0x67, 0x08, 0x48, 0x24, 0x0b, 0xe9, 0x3a, 0xaa, 0x03, 0x85, 0xed, 0x09,
      0x3d, 0xa7, 0x63, 0xc9, 0x17, 0x26, 0xde, 0xba, 0xf1, 0xbb, 0x9a, 0x48,
      0xdf, 0x4b, 0xe3, 0x42, 0xa3, 0xcb, 0x9c, 0x33, 0x5d, 0x2b, 0x3e, 0xf9,
      0x99, 0xda, 0x4e, 0xab, 0x94, 0xd1, 0x5b, 0xa3, 0x7b, 0x07, 0xd0, 0x49,
      0xf8, 0x85, 0x57, 0x2f, 0x47, 0xe7, 0xdc, 0x33, 0xb5, 0xd4, 0x81, 0xb5,
      0xce, 0x1a, 0x3f, 0x8b, 0x3a, 0x42, 0x37, 0xbe, 0xfb, 0xf0, 0x4f, 0x01,
      0x5a, 0x97, 0x21, 0x7d, 0xae, 0x6b, 0x16, 0xe7, 0xd8, 0x55, 0xb9, 0x41,
      0x3d, 0x7c, 0x22, 0x71},
     pub_key_1,
     {0x34, 0x34, 0x32, 0x39, 0x35, 0x33, 0x39, 0x31, 0x31, 0x37},
     true},

    // Comment:
    // tcID: 19
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     19,
     32,
     {0x2d, 0xae, 0xba, 0xd5, 0xdc, 0x34, 0xfd, 0x91, 0x91, 0x64, 0xe3, 0xef,
      0x95, 0xbb, 0xad, 0x50, 0xef, 0xca, 0x0e, 0xf2, 0x36, 0x4b, 0x6d, 0xb5,
      0x5d, 0xdd, 0xc8, 0xfd, 0x70, 0x3c, 0xd0, 0x46, 0xe1, 0x2d, 0x2d, 0x21,
      0x81, 0x00, 0x2d, 0x3e, 0x6c, 0x79, 0xa3, 0x67, 0x1e, 0x2c, 0x7c, 0xe1,
      0x80, 0x17, 0x6c, 0x34, 0x82, 0xba, 0xac, 0xc9, 0x00, 0x76, 0xda, 0x77,
      0x27, 0xc9, 0xb0, 0xc9, 0x58, 0xac, 0x40, 0xf5, 0x47, 0x37, 0x6b, 0x44,
      0xe4, 0xf2, 0x66, 0xdf, 0x35, 0x41, 0x97, 0x79, 0xa4, 0xfd, 0x30, 0x60,
      0x3c, 0x00, 0x42, 0xfc, 0x47, 0x3d, 0x4a, 0x37, 0xca, 0x3f, 0x06, 0x9a,
      0x91, 0x5d, 0x2d, 0x0a, 0xb9, 0x5b, 0x81, 0xbe, 0xe5, 0x36, 0x6c, 0x05,
      0x3b, 0x99, 0xd1, 0x56, 0xcc, 0x31, 0xb2, 0xf3, 0xd6, 0x8b, 0x0e, 0xa5,
      0xf9, 0x8d, 0xa4, 0x84, 0x8e, 0xb8, 0xa4, 0xdf, 0xce, 0x8b, 0xa1, 0xe1,
      0x67, 0xcb, 0xa0, 0xae, 0x25, 0x84, 0x75, 0x7e, 0x5c, 0x1e, 0x46, 0x39,
      0x8d, 0x46, 0x95, 0xdd, 0x7a, 0x96, 0x41, 0x2e, 0x2e, 0x1c, 0x7e, 0x62,
      0xb3, 0x47, 0x5a, 0x66, 0x89, 0xc5, 0xa8, 0x0c, 0xc6, 0xb7, 0xc4, 0xbe,
      0x01, 0xa3, 0xcc, 0xe6, 0x04, 0x5a, 0x43, 0xaa, 0xb7, 0x32, 0x53, 0x08,
      0x98, 0xe6, 0x0f, 0x55, 0xaf, 0xf4, 0x27, 0xaf, 0xb2, 0x01, 0xe8, 0x56,
      0x94, 0xb6, 0x1e, 0x81, 0xee, 0x86, 0xe5, 0x89, 0x59, 0xa1, 0x74, 0xea,
      0x87, 0xdd, 0x7f, 0x24, 0x4d, 0x29, 0xc6, 0x16, 0xb8, 0x5c, 0xb4, 0x26,
      0xe7, 0x47, 0x3b, 0xf5, 0x68, 0xa2, 0x64, 0x9f, 0x1e, 0xfc, 0x40, 0x59,
      0x2b, 0x70, 0x04, 0x99, 0x31, 0x4b, 0xc8, 0x09, 0xd4, 0xd9, 0x66, 0x89,
      0x46, 0xd6, 0x0e, 0x27, 0xaf, 0x85, 0x2c, 0x02, 0xf6, 0xc7, 0x21, 0x0d,
      0xbf, 0x96, 0xac, 0x82},
     pub_key_1,
     {0x31, 0x30, 0x39, 0x35, 0x33, 0x32, 0x36, 0x31, 0x33, 0x35, 0x31},
     true},

    // Comment:
    // tcID: 20
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     20,
     32,
     {0x5c, 0x47, 0x99, 0xe8, 0x6c, 0x69, 0x8d, 0x3e, 0x09, 0xd8, 0xc8, 0x06,
      0x10, 0x4c, 0xa3, 0xe7, 0xcb, 0x60, 0x4d, 0x92, 0x2d, 0x43, 0x73, 0xd7,
      0x11, 0x93, 0x24, 0xe9, 0x5b, 0xef, 0xda, 0x06, 0x69, 0x73, 0x22, 0x94,
      0x66, 0x6e, 0x90, 0x09, 0xf9, 0xc7, 0x71, 0x1b, 0x13, 0x0c, 0xe5, 0x31,
      0xb1, 0xcd, 0x16, 0xca, 0x5a, 0x14, 0x74, 0x90, 0xa3, 0x9f, 0x87, 0x26,
      0xb3, 0x48, 0x2c, 0xb3, 0xf2, 0x68, 0x3a, 0x8a, 0x14, 0xd0, 0x4e, 0xd5,
      0x90, 0x12, 0x00, 0x5d, 0xf7, 0x9d, 0x25, 0x00, 0x73, 0x03, 0x60, 0xdf,
      0xd4, 0x0f, 0x6d, 0x7f, 0x90, 0xec, 0x71, 0xc1, 0x01, 0xa6, 0x86, 0xf0,
      0x2c, 0xf3, 0x8c, 0x59, 0x8e, 0xfc, 0x33, 0xa6, 0x0b, 0xd5, 0xd9, 0xc6,
      0xd4, 0xb2, 0xc0, 0x84, 0x25, 0x8f, 0x86, 0x5b, 0x8e, 0x77, 0xe8, 0x02,
      0xdc, 0x85, 0xfa, 0x8c, 0x2f, 0x59, 0xd4, 0x53, 0x0f, 0xbd, 0x1e, 0x2a,
      0xee, 0x00, 0x5c, 0x3d, 0x44, 0x6f, 0xf8, 0xf5, 0x9c, 0x80, 0x7f, 0x06,
      0x64, 0xe5, 0xe6, 0x2f, 0x38, 0xee, 0xe7, 0xbe, 0x9b, 0x2e, 0xea, 0x3f,
      0x8f, 0x98, 0xeb, 0x2b, 0x44, 0xa0, 0x84, 0x8a, 0x70, 0x76, 0x27, 0x1c,
      0xa9, 0x86, 0xde, 0x85, 0x99, 0x83, 0x0a, 0x59, 0xa1, 0x28, 0x97, 0x34,
      0x77, 0x41, 0x18, 0xa9, 0x67, 0xe7, 0x0f, 0x63, 0xdf, 0x1b, 0xb8, 0x23,
      0x74, 0xa1, 0xa0, 0x8f, 0xd9, 0x12, 0x22, 0xec, 0x77, 0x11, 0x7f, 0x2a,
      0xf9, 0x70, 0x6a, 0xbb, 0x91, 0x23, 0x0b, 0x06, 0xd5, 0x02, 0x2e, 0x2a,
      0x87, 0x84, 0x91, 0x93, 0x44, 0x64, 0x7a, 0x3b, 0x26, 0x60, 0xcb, 0x5a,
      0x68, 0x9f, 0x06, 0x2a, 0xc8, 0x4c, 0x36, 0x13, 0x27, 0x80, 0x43, 0xbe,
      0x92, 0x04, 0xa4, 0x23, 0x91, 0x69, 0xfd, 0x14, 0xfa, 0x05, 0xc3, 0x4d,
      0x8a, 0x6a, 0x6e, 0x64},
     pub_key_1,
     {0x35, 0x39, 0x38, 0x37, 0x33, 0x35, 0x30, 0x30, 0x34, 0x31},
     true},

    // Comment:
    // tcID: 21
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     21,
     32,
     {0x32, 0x75, 0x3c, 0x1f, 0x0f, 0xff, 0x11, 0xb1, 0xaa, 0xe6, 0x20, 0xf2,
      0x1f, 0x4b, 0x25, 0xee, 0x32, 0xeb, 0x53, 0x19, 0x41, 0x3c, 0x20, 0x1a,
      0x71, 0xda, 0x05, 0x03, 0xd3, 0x20, 0x77, 0xc9, 0x11, 0xe4, 0x0f, 0xae,
      0x8a, 0x14, 0xd9, 0x44, 0xbc, 0x57, 0xb3, 0x6b, 0x05, 0xd8, 0x5a, 0x9b,
      0x4e, 0x2d, 0x92, 0xf2, 0x60, 0xf6, 0xcd, 0xe6, 0x77, 0x39, 0xb6, 0xd2,
      0x52, 0xe4, 0x80, 0x0c, 0x8e, 0x5c, 0x94, 0x99, 0xf6, 0x03, 0xec, 0xed,
      0x7f, 0x97, 0x65, 0x1e, 0x1e, 0xe8, 0x78, 0x65, 0x4c, 0x0b, 0xb2, 0x05,
      0xba, 0x39, 0xb5, 0x92, 0x85, 0xa6, 0x95, 0x61, 0x99, 0x63, 0xf7, 0xf3,
      0x6d, 0xfd, 0xb7, 0xa2, 0x04, 0x05, 0x52, 0xbb, 0xa7, 0xff, 0x13, 0xd0,
      0x47, 0xd2, 0x73, 0xf0, 0xfc, 0x1c, 0xa3, 0x89, 0x2e, 0x76, 0x92, 0x60,
      0x9d, 0x43, 0xad, 0xc0, 0xde, 0x6e, 0x31, 0x91, 0xf2, 0xee, 0x58, 0xf3,
      0x06, 0x95, 0x31, 0x50, 0x9a, 0x94, 0xde, 0x11, 0x3f, 0xc1, 0x0c, 0x3e,
      0x5d, 0x4c, 0x88, 0x61, 0x08, 0x39, 0x4a, 0x55, 0xdb, 0xc2, 0xfa, 0x4b,
      0xaa, 0xb0, 0x62, 0x3d, 0xb3, 0x47, 0xcd, 0x0f, 0x6e, 0x63, 0x06, 0xaf,
      0x89, 0x73, 0xf0, 0xf1, 0x66, 0x55, 0x8c, 0x31, 0x90, 0x1c, 0x94, 0x58,
      0xef, 0x27, 0x43, 0x32, 0xc1, 0x5e, 0xd9, 0xc4, 0xa6, 0xff, 0x8d, 0xf0,
      0x90, 0xbe, 0xcb, 0x78, 0x41, 0xce, 0x5c, 0xdc, 0x40, 0x70, 0x5b, 0x79,
      0x92, 0x77, 0x82, 0x5f, 0x02, 0x95, 0x82, 0xeb, 0x21, 0x89, 0x0e, 0x23,
      0x71, 0x28, 0x37, 0x08, 0x88, 0x26, 0xc1, 0x08, 0x34, 0x10, 0x28, 0xc9,
      0x6b, 0x4c, 0x6a, 0x0d, 0xd7, 0xb3, 0x7d, 0xef, 0xcd, 0x82, 0x62, 0x2b,
      0xde, 0x64, 0xa2, 0xd5, 0x4e, 0x47, 0x49, 0xb0, 0x65, 0xdb, 0x7d, 0xa5,
      0xa5, 0x15, 0xef, 0xf6},
     pub_key_1,
     {0x33, 0x34, 0x36, 0x33, 0x30, 0x30, 0x36, 0x38, 0x37, 0x38},
     true},

    // Comment:
    // tcID: 22
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     22,
     32,
     {0xa2, 0x22, 0x60, 0x16, 0xf8, 0x48, 0xd9, 0x64, 0x42, 0xf8, 0x2b, 0xbc,
      0x33, 0xbf, 0xbf, 0x09, 0x8c, 0x4c, 0xad, 0x85, 0xb0, 0x79, 0x15, 0xdc,
      0xbc, 0x32, 0x3b, 0xaa, 0xd4, 0x79, 0xbd, 0x97, 0x1f, 0x81, 0xfa, 0xa4,
      0x9b, 0x06, 0x37, 0x76, 0x14, 0x7c, 0x44, 0x82, 0x10, 0xd4, 0xad, 0xef,
      0x7f, 0x06, 0xfe, 0xf4, 0x4b, 0xad, 0xdc, 0x67, 0x25, 0x01, 0xe0, 0x44,
      0x4f, 0xe8, 0xa2, 0x8f, 0x87, 0x1f, 0x49, 0xf6, 0xec, 0x63, 0x4b, 0xf4,
      0xf4, 0x9d, 0x13, 0xe4, 0xf7, 0x3c, 0x83, 0x2c, 0x97, 0x8b, 0xd2, 0x27,
      0xbc, 0x1e, 0x85, 0x80, 0x41, 0x22, 0x15, 0x78, 0x85, 0xc8, 0x74, 0x4d,
      0x31, 0xf7, 0x77, 0x16, 0x8a, 0x8c, 0xdb, 0xe7, 0xa4, 0x74, 0x23, 0x66,
      0xcd, 0xcf, 0x0b, 0xce, 0x50, 0xa0, 0xf5, 0x50, 0xcc, 0x17, 0x29, 0xf2,
      0x08, 0x9c, 0x92, 0x79, 0x90, 0xd9, 0x4f, 0x73, 0xcc, 0x96, 0x2a, 0xf2,
      0x5d, 0x70, 0xa1, 0xfc, 0x4d, 0xa6, 0xdf, 0x84, 0x57, 0xdd, 0xb5, 0xa4,
      0x96, 0x9b, 0xfc, 0xa4, 0xd2, 0xb1, 0x96, 0x4b, 0xae, 0x88, 0x22, 0x6a,
      0xb1, 0x10, 0x47, 0xda, 0x7b, 0x6e, 0x7a, 0xdf, 0x8f, 0x96, 0xdb, 0xd7,
      0x72, 0x74, 0x7f, 0x29, 0xbd, 0x9b, 0x93, 0x61, 0x24, 0x4a, 0x04, 0xb7,
      0x55, 0x8d, 0xf6, 0x2d, 0x84, 0x82, 0x8f, 0x7a, 0xad, 0x2e, 0x56, 0x2f,
      0x23, 0x06, 0xa9, 0x69, 0x73, 0xa0, 0x68, 0xb1, 0x76, 0x00, 0x8b, 0x0c,
      0x75, 0x34, 0xee, 0xbf, 0x0a, 0xe9, 0xf7, 0x97, 0x9a, 0x09, 0x02, 0x21,
      0x2d, 0x4e, 0x20, 0xdc, 0xf1, 0x62, 0xab, 0x51, 0xcd, 0x55, 0x94, 0x4d,
      0x9b, 0xc0, 0x76, 0x92, 0x34, 0x8f, 0x83, 0x06, 0xca, 0x90, 0xa8, 0x03,
      0x06, 0xd4, 0x04, 0xd2, 0x17, 0x24, 0xa2, 0x8e, 0xfb, 0xdd, 0x22, 0x8e,
      0x20, 0x80, 0xdc, 0x89},
     pub_key_1,
     {0x39, 0x38, 0x31, 0x37, 0x33, 0x32, 0x30, 0x32, 0x38, 0x37},
     true},

    // Comment:
    // tcID: 23
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     23,
     32,
     {0x6b, 0x9a, 0x45, 0xec, 0x51, 0x7b, 0xf8, 0x38, 0xa5, 0x35, 0xed, 0x93,
      0xfb, 0x36, 0xbb, 0x02, 0x74, 0x71, 0xb1, 0x1d, 0x20, 0xd0, 0xbf, 0x6b,
      0x1e, 0xda, 0xae, 0xef, 0xa2, 0x5b, 0xcc, 0xdf, 0x58, 0x81, 0xf3, 0x44,
      0x09, 0xa0, 0x42, 0xda, 0xdb, 0xe4, 0xa7, 0xb3, 0xc4, 0x1b, 0xf2, 0x4a,
      0xbe, 0x66, 0xc1, 0xf7, 0xf3, 0x7b, 0x92, 0xb9, 0x65, 0x8f, 0x59, 0xc5,
      0x5f, 0xa8, 0x8a, 0xa1, 0x63, 0x24, 0x65, 0xba, 0x82, 0x45, 0xc5, 0xf0,
      0xc9, 0x8d, 0x08, 0x2f, 0xca, 0xbb, 0x5e, 0x9f, 0xb8, 0x34, 0xd7, 0x27,
      0xa3, 0x54, 0xf8, 0xf8, 0xa7, 0xfc, 0xdb, 0x8d, 0x32, 0x30, 0x72, 0x54,
      0x72, 0xa6, 0xa4, 0xec, 0xb6, 0xf3, 0xd9, 0x75, 0x40, 0x77, 0x3e, 0x53,
      0xeb, 0x45, 0x38, 0x3a, 0xcb, 0xe4, 0xbc, 0x81, 0x16, 0x8e, 0x24, 0x4f,
      0xe7, 0x69, 0xb1, 0xa7, 0xd5, 0x22, 0x0d, 0xbc, 0xaf, 0x83, 0x1e, 0x46,
      0xc9, 0x3f, 0x6e, 0xa7, 0xca, 0x2e, 0xe3, 0x0c, 0xe9, 0x28, 0x1d, 0xd9,
      0x67, 0x4f, 0xcc, 0xdc, 0x79, 0x6f, 0xd6, 0x14, 0x7b, 0xe4, 0xbd, 0x99,
      0xc5, 0x3a, 0x12, 0xea, 0xcf, 0xd4, 0xb9, 0xb0, 0x09, 0x72, 0xb0, 0x53,
      0x9e, 0x3d, 0x94, 0xb8, 0x59, 0x11, 0x69, 0x4e, 0xa9, 0x8f, 0x27, 0x49,
      0x6b, 0x56, 0x7a, 0x29, 0xfd, 0x30, 0x87, 0x84, 0x2b, 0xa0, 0x14, 0x02,
      0x90, 0x1d, 0x1b, 0xb1, 0xba, 0x6b, 0x3c, 0x79, 0x31, 0xf1, 0x32, 0x9f,
      0xf5, 0x64, 0x49, 0x89, 0xbd, 0xc1, 0xf7, 0x02, 0x50, 0x59, 0xd0, 0xd0,
      0x69, 0x51, 0x7f, 0xbb, 0x68, 0x2c, 0x0b, 0xe0, 0x49, 0xec, 0x7e, 0x38,
      0xb6, 0x14, 0xaf, 0x1c, 0xf9, 0xcc, 0x37, 0xea, 0xb7, 0x4e, 0x20, 0xe6,
      0xbc, 0xa4, 0x68, 0xf9, 0x3d, 0x3f, 0x13, 0x74, 0x95, 0x57, 0xb7, 0x01,
      0x29, 0xef, 0x95, 0xe5},
     pub_key_1,
     {0x33, 0x32, 0x32, 0x32, 0x30, 0x34, 0x31, 0x30, 0x34, 0x36},
     true},

    // Comment:
    // tcID: 24
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     24,
     32,
     {0x01, 0x92, 0x6c, 0xbf, 0x92, 0x19, 0x0f, 0xe7, 0xcc, 0xd7, 0xf8, 0x58,
      0xc2, 0x60, 0x03, 0x6a, 0x7a, 0x9d, 0x55, 0x4b, 0xf6, 0x36, 0xa8, 0x2d,
      0x43, 0xed, 0xd3, 0xd2, 0xcf, 0x0f, 0x5f, 0x70, 0x06, 0xc2, 0xe0, 0xd6,
      0xdc, 0x43, 0xc7, 0xc4, 0x27, 0xe4, 0x99, 0x40, 0xcd, 0xc5, 0xc3, 0x97,
      0xdf, 0x66, 0x84, 0x18, 0x97, 0xd3, 0xe1, 0x18, 0xcf, 0xa8, 0x6f, 0x51,
      0x88, 0xc5, 0x44, 0x09, 0xff, 0xc1, 0x69, 0xe8, 0xf1, 0x92, 0xc3, 0xa8,
      0x48, 0x96, 0x93, 0x1d, 0x98, 0xae, 0x8a, 0x9e, 0x83, 0x07, 0x5e, 0x6d,
      0xab, 0xe4, 0xd2, 0x8a, 0x56, 0xf0, 0xa9, 0x28, 0x24, 0x32, 0x51, 0x1a,
      0xb0, 0x9a, 0x1a, 0x0e, 0xd4, 0x20, 0xbe, 0x66, 0x55, 0x21, 0x93, 0x6a,
      0x1c, 0x98, 0x34, 0xa4, 0x56, 0x99, 0x7c, 0x0e, 0x5e, 0x2c, 0x1f, 0xc5,
      0x6a, 0xb4, 0x59, 0x27, 0xb6, 0x04, 0x2d, 0x35, 0x71, 0x16, 0x3b, 0xa5,
      0x9d, 0x99, 0x4b, 0x90, 0x2a, 0xa5, 0xed, 0x41, 0x6c, 0xef, 0xf4, 0x31,
      0x3f, 0xb1, 0xc6, 0x73, 0x34, 0xed, 0x7b, 0xe7, 0x15, 0xd2, 0xe9, 0x6c,
      0x04, 0x5d, 0x6c, 0x0b, 0xfd, 0x20, 0xf2, 0xf5, 0x04, 0x0e, 0x09, 0xfb,
      0xb0, 0x77, 0xa0, 0x1f, 0x98, 0x23, 0x84, 0xcc, 0xd8, 0x83, 0xcf, 0xa2,
      0xfa, 0x25, 0xd3, 0x53, 0x20, 0x74, 0x67, 0x28, 0xae, 0x53, 0x0b, 0xb7,
      0x96, 0xf5, 0xae, 0x6e, 0xc2, 0xc3, 0x6a, 0xad, 0x33, 0x44, 0xce, 0x69,
      0x04, 0x5b, 0x79, 0x30, 0x52, 0xcf, 0x3a, 0x56, 0x92, 0x93, 0xa2, 0xd2,
      0x32, 0xea, 0xb3, 0x78, 0x85, 0x3d, 0xc4, 0x03, 0x0b, 0x91, 0xe1, 0xf0,
      0x8c, 0x31, 0x34, 0x82, 0x24, 0xb7, 0x74, 0xe8, 0xb7, 0x1a, 0x7e, 0x23,
      0xe7, 0x74, 0x03, 0xcb, 0x26, 0xd1, 0xf2, 0xb1, 0xbb, 0x80, 0x0c, 0x77,
      0x28, 0x60, 0x45, 0x1d},
     pub_key_1,
     {0x36, 0x36, 0x36, 0x36, 0x33, 0x30, 0x37, 0x31, 0x30, 0x34},
     true},

    // Comment:
    // tcID: 25
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     25,
     32,
     {0x36, 0x3c, 0xa2, 0x3e, 0xc7, 0xd9, 0x80, 0xa8, 0x3a, 0x5f, 0x36, 0x7c,
      0xba, 0x3e, 0x9a, 0x22, 0x25, 0xb3, 0xa3, 0xec, 0xaf, 0x64, 0x34, 0xb5,
      0xa3, 0x47, 0xe3, 0xba, 0xa5, 0xce, 0x5e, 0xa2, 0x78, 0x24, 0xfe, 0xc7,
      0x27, 0xec, 0x7b, 0x3b, 0xa2, 0xd4, 0x1c, 0xdc, 0x97, 0x23, 0xf5, 0xcf,
      0xf3, 0xe7, 0x5d, 0xc7, 0xf7, 0xb9, 0x20, 0x0b, 0xaa, 0xa2, 0xc0, 0x2b,
      0x4d, 0x83, 0x99, 0xb1, 0x76, 0x0a, 0x10, 0x11, 0x23, 0x1e, 0x2b, 0x26,
      0xba, 0xd9, 0x32, 0x62, 0x04, 0xc5, 0x07, 0x9a, 0xc1, 0xc1, 0x30, 0x3a,
      0xc0, 0x8f, 0xba, 0xe4, 0x2f, 0x6a, 0x40, 0x32, 0x40, 0x7e, 0x87, 0x91,
      0x5f, 0xa3, 0x75, 0x9c, 0x43, 0xb2, 0x9c, 0xa0, 0x7a, 0x1a, 0x32, 0x59,
      0xfb, 0xee, 0x42, 0x74, 0xb6, 0x3a, 0x52, 0x86, 0x0c, 0x63, 0x51, 0x24,
      0x6f, 0x8c, 0x1c, 0x84, 0x53, 0x8e, 0x5e, 0x6f, 0x6a, 0xdd, 0x7f, 0xf6,
      0x15, 0x2a, 0xcc, 0xa4, 0xde, 0xdd, 0xda, 0xb1, 0x46, 0xa2, 0x5b, 0xbd,
      0xf0, 0x07, 0x6e, 0x28, 0x79, 0xec, 0xf9, 0x3b, 0xaf, 0x9d, 0x64, 0x7b,
      0x32, 0xcf, 0x32, 0xa9, 0xe6, 0x27, 0x18, 0xee, 0xc5, 0x99, 0xcd, 0x7b,
      0x51, 0x51, 0x0a, 0x70, 0xfd, 0x98, 0x9a, 0x77, 0x42, 0x60, 0x49, 0x09,
      0x26, 0x21, 0xc2, 0x38, 0x6a, 0x82, 0x77, 0x1b, 0x06, 0xa4, 0xc5, 0xb8,
      0x6b, 0xc2, 0x8f, 0xdd, 0x63, 0x0e, 0x76, 0xfe, 0x43, 0xf2, 0x1c, 0x5d,
      0x22, 0xfa, 0x63, 0x00, 0x1d, 0xa3, 0x00, 0xef, 0x97, 0x77, 0xc9, 0xdc,
      0x41, 0x21, 0x15, 0x88, 0x40, 0xbd, 0x08, 0x43, 0x94, 0xd6, 0x00, 0xa6,
      0xdb, 0x28, 0x4b, 0x1e, 0x77, 0x11, 0x12, 0xb5, 0x6b, 0x63, 0x36, 0x4f,
      0x00, 0x7c, 0xd7, 0x16, 0x66, 0x90, 0x2c, 0xac, 0x56, 0x32, 0x3c, 0x6e,
      0x54, 0x94, 0xd5, 0x0c},
     pub_key_1,
     {0x31, 0x30, 0x33, 0x35, 0x39, 0x35, 0x31, 0x38, 0x39, 0x38},
     true},

    // Comment:
    // tcID: 26
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     26,
     32,
     {0x4a, 0x2d, 0xc2, 0x05, 0xdb, 0x89, 0x9d, 0x51, 0x44, 0x7b, 0x68, 0x9d,
      0x3a, 0xd6, 0x01, 0x00, 0x3e, 0xaf, 0xb7, 0x0a, 0x51, 0x05, 0x1a, 0xe4,
      0xe5, 0x70, 0xc5, 0x12, 0x5a, 0xfa, 0xe6, 0x64, 0x27, 0x05, 0x6f, 0xc2,
      0xc9, 0xf7, 0x1b, 0xc4, 0x26, 0x10, 0xef, 0x85, 0xba, 0x0f, 0x49, 0xa2,
      0x72, 0x12, 0x47, 0xd4, 0xa7, 0x7c, 0x6d, 0xc9, 0xf0, 0x14, 0x29, 0xc2,
      0xd9, 0xb9, 0x09, 0xfc, 0x84, 0xdf, 0xb0, 0x49, 0xbd, 0x35, 0x18, 0x72,
      0x30, 0x1a, 0x77, 0x36, 0x19, 0x55, 0x96, 0xa1, 0xc4, 0x9c, 0xcb, 0x1b,
      0x36, 0x75, 0x44, 0xa1, 0x90, 0xd1, 0x88, 0xe4, 0xe6, 0x67, 0x49, 0x73,
      0x1a, 0x76, 0x0d, 0x76, 0xaa, 0x11, 0x6f, 0xa4, 0xa1, 0x89, 0x66, 0x5a,
      0x98, 0x97, 0x5b, 0x7e, 0xc8, 0x03, 0xe2, 0x69, 0x5f, 0xef, 0x42, 0xea,
      0xe7, 0xc7, 0xf8, 0xe2, 0x74, 0xe4, 0xfb, 0x1c, 0x99, 0xab, 0x0e, 0xeb,
      0xc7, 0x6a, 0xd6, 0xbc, 0x8d, 0x76, 0x8d, 0x2d, 0xfd, 0x59, 0x69, 0x18,
      0x1e, 0x78, 0xb3, 0xee, 0x72, 0xfa, 0x90, 0x0c, 0x31, 0x51, 0x0f, 0x07,
      0x1a, 0x1d, 0xa8, 0xb7, 0x58, 0x9e, 0x49, 0xe2, 0x54, 0xde, 0x88, 0x50,
      0xdb, 0x02, 0xb1, 0xbe, 0x84, 0x1a, 0xf4, 0x78, 0x04, 0x5a, 0x84, 0x7f,
      0x2d, 0xb9, 0x12, 0x6a, 0x42, 0x81, 0x88, 0x7e, 0x02, 0xbe, 0xb5, 0x8f,
      0x1f, 0x0b, 0xbe, 0x67, 0xc9, 0xc7, 0xac, 0xfb, 0x49, 0xb5, 0xe4, 0xec,
      0x4f, 0xc7, 0x6e, 0xf3, 0x06, 0x54, 0xb5, 0xd3, 0xff, 0xcf, 0xcd, 0xf7,
      0xcc, 0x91, 0x2c, 0x5e, 0x1f, 0x2b, 0x20, 0xd9, 0x1b, 0xdd, 0x61, 0x14,
      0xd2, 0x54, 0x05, 0xab, 0x65, 0x21, 0x5c, 0x05, 0xc4, 0xad, 0x2b, 0x6f,
      0xae, 0x66, 0x62, 0xae, 0x51, 0x30, 0xd1, 0x76, 0x52, 0xce, 0x42, 0xc0,
      0xce, 0x86, 0xc1, 0x53},
     pub_key_1,
     {0x31, 0x38, 0x34, 0x36, 0x35, 0x39, 0x37, 0x31, 0x39, 0x35},
     true},

    // Comment:
    // tcID: 27
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     27,
     32,
     {0x45, 0xa2, 0x55, 0x08, 0x93, 0x82, 0x0a, 0xd5, 0x11, 0xea, 0xba, 0xe3,
      0x50, 0x39, 0xa1, 0x34, 0x57, 0x35, 0x0d, 0xf7, 0xec, 0x21, 0xce, 0xdc,
      0x14, 0x84, 0x53, 0x0d, 0xc3, 0x7a, 0xd3, 0x32, 0xa1, 0x70, 0xaf, 0x8b,
      0xb3, 0x05, 0xe4, 0xbd, 0x6d, 0xa7, 0x8c, 0xfa, 0x43, 0x82, 0x04, 0x5d,
      0xdf, 0xbe, 0x24, 0x99, 0xa1, 0x9d, 0x51, 0x83, 0x8b, 0x3a, 0x55, 0x3d,
      0x7a, 0x84, 0x9c, 0x49, 0xe2, 0x84, 0x09, 0x3e, 0x1f, 0x2f, 0xe4, 0xb2,
      0x69, 0x29, 0x5a, 0x75, 0xf1, 0x2d, 0xcd, 0x0e, 0x72, 0x7a, 0x79, 0xc1,
      0xf0, 0xe9, 0xcd, 0x2a, 0x89, 0xe2, 0x95, 0xa3, 0x55, 0xa5, 0x2d, 0xa7,
      0xee, 0x1d, 0xc2, 0x54, 0x7f, 0xa4, 0x3d, 0x96, 0xab, 0xef, 0x1a, 0x3b,
      0x51, 0x21, 0xbc, 0xa6, 0x7c, 0xf4, 0x50, 0xcd, 0x08, 0x7c, 0x9d, 0x90,
      0x4c, 0xf7, 0x97, 0x83, 0x40, 0x57, 0x33, 0x4f, 0x78, 0x8c, 0x96, 0x76,
      0x3a, 0x4f, 0xf0, 0xa8, 0x99, 0x06, 0x83, 0x63, 0x62, 0x1d, 0x90, 0x13,
      0x6e, 0xb5, 0x30, 0xc3, 0x20, 0x41, 0xef, 0x3e, 0xde, 0x97, 0xa4, 0x4b,
      0xe1, 0x37, 0xd0, 0x8c, 0x2a, 0x70, 0x19, 0xf3, 0x1f, 0x8e, 0x27, 0xe1,
      0x56, 0xe5, 0x09, 0x22, 0x78, 0x60, 0xc7, 0x23, 0xe3, 0xae, 0xf1, 0x96,
      0x85, 0xa5, 0xe3, 0xa1, 0x0b, 0x78, 0xdf, 0x66, 0xb3, 0x8f, 0x29, 0x9d,
      0x60, 0xb2, 0x33, 0x8b, 0xc6, 0xa9, 0x43, 0xbc, 0x1b, 0x2f, 0x92, 0x61,
      0x97, 0x7e, 0xf4, 0xe0, 0x8d, 0x1b, 0x6b, 0x42, 0xde, 0x17, 0xc4, 0xc6,
      0x52, 0x09, 0x9d, 0x37, 0x7a, 0x7a, 0xb9, 0x83, 0xff, 0x98, 0x3c, 0x3b,
      0xbb, 0xca, 0x99, 0xf7, 0x9c, 0x81, 0x48, 0xf2, 0xaf, 0xa9, 0xb0, 0xf1,
      0xbe, 0xe5, 0x1e, 0x32, 0x2f, 0xfc, 0x05, 0xb0, 0x51, 0xe1, 0x7d, 0x13,
      0x2a, 0x6e, 0x90, 0xc4},
     pub_key_1,
     {0x33, 0x31, 0x33, 0x36, 0x30, 0x34, 0x36, 0x31, 0x38, 0x39},
     true},

    // Comment:
    // tcID: 28
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     28,
     32,
     {0x25, 0x8d, 0x16, 0x93, 0x22, 0xa9, 0x54, 0x6c, 0xaa, 0x2b, 0x68, 0x08,
      0x9b, 0x48, 0x1b, 0xd3, 0x83, 0x48, 0x15, 0x9f, 0xa9, 0xed, 0x19, 0x2d,
      0x2e, 0xb6, 0x08, 0x39, 0x02, 0x95, 0x52, 0xa4, 0x20, 0xd5, 0xb2, 0x46,
      0x44, 0xc3, 0x38, 0x1a, 0x5f, 0xfb, 0xf2, 0xed, 0x46, 0x07, 0x29, 0x74,
      0x91, 0x8d, 0x77, 0x7f, 0x1c, 0x53, 0xad, 0x51, 0xf9, 0xce, 0x8a, 0x91,
      0xaf, 0xf9, 0x5d, 0xbc, 0xd8, 0x17, 0xf5, 0x0e, 0xf1, 0x3e, 0xbf, 0xc9,
      0xef, 0xb6, 0xc3, 0x69, 0x87, 0xdf, 0xaa, 0xa9, 0x6e, 0x37, 0xaa, 0x89,
      0xdd, 0x7a, 0x32, 0x34, 0x89, 0x06, 0xbc, 0xc2, 0x2f, 0x4d, 0x0b, 0x51,
      0x04, 0xc4, 0x21, 0x81, 0xf7, 0x69, 0x74, 0x65, 0x1e, 0x3c, 0xed, 0x20,
      0xd5, 0x41, 0x2f, 0x70, 0x46, 0x7d, 0x83, 0x4c, 0xb4, 0x9b, 0x1b, 0x7e,
      0x15, 0x32, 0xff, 0x41, 0x7f, 0x91, 0xdc, 0xf6, 0x53, 0xf1, 0x8c, 0x43,
      0xa6, 0xad, 0x9f, 0xf4, 0x46, 0x96, 0x00, 0x89, 0x0f, 0x83, 0x6c, 0x55,
      0x39, 0x63, 0xbc, 0x23, 0x79, 0xd5, 0xbd, 0x79, 0xad, 0x33, 0x80, 0x35,
      0xf7, 0xf4, 0xaa, 0x6a, 0x27, 0xfb, 0xd9, 0x24, 0xb5, 0xbc, 0x8d, 0x8b,
      0x53, 0x73, 0xde, 0x7f, 0x4c, 0xda, 0xc7, 0x5c, 0xbe, 0x0b, 0x8a, 0xbd,
      0x39, 0x61, 0xdb, 0x17, 0xb8, 0x19, 0xd4, 0x6c, 0xcb, 0x4c, 0xce, 0xdd,
      0xcd, 0xb3, 0x63, 0x63, 0x09, 0xd6, 0x75, 0x4c, 0x6d, 0x82, 0xa6, 0x1f,
      0x5d, 0x9b, 0x9b, 0xfa, 0xbd, 0x0c, 0x94, 0x87, 0x77, 0x26, 0x4c, 0x11,
      0x38, 0xc6, 0xfb, 0x60, 0x64, 0xfd, 0xd5, 0xa7, 0x97, 0xe5, 0x51, 0xc1,
      0xd0, 0xe5, 0x45, 0xd1, 0xd3, 0x2d, 0x63, 0xe1, 0xeb, 0xdf, 0xcb, 0x78,
      0x27, 0x56, 0x92, 0xcb, 0x50, 0x71, 0x79, 0x10, 0x31, 0x2d, 0xa9, 0x91,
      0x70, 0x52, 0xcf, 0x53},
     pub_key_1,
     {0x32, 0x36, 0x36, 0x33, 0x37, 0x38, 0x34, 0x32, 0x35, 0x34},
     true},

    // Comment:
    // tcID: 29
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     29,
     32,
     {0x82, 0x4d, 0x03, 0x72, 0xc4, 0x02, 0x97, 0xe3, 0xa0, 0x05, 0x92, 0x36,
      0xa9, 0x3f, 0x60, 0xdb, 0x3d, 0x25, 0x14, 0xde, 0xfe, 0x40, 0x9b, 0xfa,
      0xa2, 0x89, 0x0f, 0x4d, 0x04, 0xcb, 0x21, 0x04, 0x3b, 0xa1, 0x87, 0x1b,
      0x83, 0x74, 0xfa, 0x51, 0xf1, 0xc4, 0xd7, 0x39, 0x2d, 0x0e, 0x24, 0x42,
      0x22, 0xb1, 0xec, 0xcd, 0x11, 0x80, 0x09, 0xe4, 0x6b, 0xbf, 0xd2, 0xa8,
      0x4b, 0xac, 0x9e, 0x84, 0xdd, 0xc5, 0x10, 0x2e, 0xb4, 0x50, 0x8f, 0x5b,
      0x9d, 0x77, 0x45, 0x0f, 0x7a, 0xed, 0x31, 0xcb, 0xf5, 0xb6, 0xa4, 0x03,
      0x2b, 0xb4, 0x4f, 0xd8, 0x08, 0xba, 0xd4, 0x03, 0xe8, 0xb7, 0x8a, 0xf3,
      0x75, 0x6f, 0x47, 0x25, 0x63, 0xe0, 0x50, 0x52, 0x65, 0x27, 0xde, 0xbc,
      0x1e, 0xc4, 0x9e, 0xcf, 0x5d, 0x5c, 0x10, 0xf2, 0x79, 0xd0, 0x6a, 0x5d,
      0xbb, 0x7c, 0xca, 0x18, 0x8b, 0xa2, 0x12, 0xbe, 0x9f, 0xd3, 0x6c, 0x7e,
      0xef, 0x8b, 0x18, 0x74, 0x05, 0xda, 0x50, 0xdf, 0xea, 0x14, 0x0c, 0x4b,
      0x60, 0x4d, 0xc3, 0x13, 0xf2, 0x89, 0x41, 0xf2, 0xc4, 0x44, 0x71, 0x43,
      0xa1, 0x42, 0x0b, 0x31, 0xcd, 0x23, 0x66, 0x32, 0x52, 0xec, 0x04, 0x26,
      0xc8, 0x46, 0x5a, 0xde, 0x55, 0xce, 0xcb, 0xb9, 0xb9, 0xcf, 0x4f, 0x88,
      0xe2, 0xb4, 0xb7, 0xc8, 0x6c, 0xc5, 0xe2, 0xc6, 0xa4, 0xfb, 0x25, 0xc5,
      0x58, 0x35, 0xa2, 0xec, 0xa1, 0x78, 0x0f, 0xbd, 0xbb, 0x8b, 0x35, 0x4b,
      0xa5, 0x12, 0xd4, 0x12, 0xe8, 0x4e, 0x73, 0x76, 0x4e, 0x05, 0x55, 0x14,
      0xe1, 0x0d, 0x7e, 0xa3, 0x2a, 0xd7, 0xe1, 0xa3, 0xc2, 0x0d, 0xfc, 0x53,
      0x73, 0x2d, 0x85, 0xfa, 0xe4, 0x0c, 0xa9, 0x51, 0xb5, 0xfc, 0x18, 0xf9,
      0xab, 0x21, 0xc9, 0x00, 0x1d, 0xae, 0x67, 0xc6, 0x20, 0x0b, 0x9c, 0xfc,
      0x6d, 0x14, 0x25, 0x65},
     pub_key_1,
     {0x31, 0x36, 0x35, 0x32, 0x31, 0x30, 0x30, 0x35, 0x32, 0x34},
     true},

    // Comment:
    // tcID: 30
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     30,
     32,
     {0x83, 0x67, 0x89, 0x3d, 0x5a, 0xd7, 0x7b, 0xe2, 0x4a, 0x73, 0x9c, 0xff,
      0xda, 0xa7, 0xbd, 0x41, 0x4d, 0x66, 0x44, 0x23, 0x57, 0xdb, 0x9b, 0xb3,
      0x39, 0xa7, 0xce, 0x86, 0x2b, 0x40, 0x03, 0x63, 0xd9, 0xe7, 0x01, 0x4a,
      0xa1, 0xce, 0xd3, 0xa8, 0xc3, 0x1d, 0x65, 0xf2, 0x47, 0xe9, 0x6b, 0xa5,
      0x64, 0x9d, 0xf6, 0x36, 0xfb, 0x75, 0x9d, 0xf0, 0x4b, 0x7a, 0x62, 0xda,
      0x27, 0xa6, 0x40, 0x25, 0xbb, 0xb9, 0x71, 0x9c, 0x7a, 0xb1, 0xd7, 0x4d,
      0x63, 0xd2, 0xad, 0x5a, 0x32, 0x4d, 0xb8, 0x71, 0x87, 0x42, 0xe5, 0x43,
      0x8b, 0x78, 0x0a, 0xe6, 0x30, 0x49, 0x9b, 0xea, 0x06, 0x5e, 0x22, 0x15,
      0xdf, 0x93, 0x13, 0xfd, 0x45, 0xa5, 0x79, 0x41, 0xe9, 0x63, 0x2c, 0xe6,
      0x6f, 0xe1, 0x3a, 0x53, 0x59, 0x90, 0x0a, 0x0a, 0xd5, 0xde, 0x92, 0x61,
      0xae, 0xf6, 0xa1, 0x1c, 0x3b, 0x98, 0xbe, 0x76, 0x5c, 0x94, 0xa6, 0xd2,
      0x4f, 0xb7, 0xc8, 0x8f, 0xde, 0xc9, 0xd6, 0xfa, 0x52, 0xff, 0xe9, 0x75,
      0x91, 0x7d, 0x3b, 0x3d, 0x68, 0x79, 0x4c, 0x6f, 0xc8, 0x99, 0xb0, 0xf6,
      0x90, 0x11, 0x73, 0xfa, 0x91, 0x34, 0x5d, 0xf1, 0x5f, 0x1d, 0x08, 0xdb,
      0xaa, 0x0e, 0xd7, 0x7e, 0x69, 0x2f, 0x9d, 0xe8, 0x0d, 0x66, 0x70, 0xa9,
      0x5b, 0xce, 0x1b, 0x01, 0x4b, 0xee, 0xba, 0x77, 0x54, 0x3b, 0xaf, 0x40,
      0x92, 0xf4, 0xb2, 0x15, 0x8a, 0x1f, 0x27, 0xb6, 0x2c, 0xed, 0xb0, 0xbd,
      0x3f, 0x2c, 0xdd, 0x38, 0x1d, 0x9a, 0x46, 0xba, 0xe1, 0xaa, 0x34, 0xc2,
      0xb8, 0xc3, 0x6a, 0x65, 0xd4, 0xe4, 0x4f, 0xa5, 0xaa, 0xb1, 0xcd, 0x18,
      0x8d, 0x42, 0x02, 0x22, 0x7d, 0x6f, 0xd5, 0x37, 0x77, 0x69, 0x80, 0xeb,
      0xe6, 0x36, 0xdd, 0x81, 0xd3, 0xbc, 0x07, 0x75, 0xba, 0xb2, 0x3c, 0xcd,
      0x96, 0x23, 0xd4, 0x23},
     pub_key_1,
     {0x35, 0x37, 0x34, 0x38, 0x30, 0x38, 0x31, 0x36, 0x39, 0x36},
     true},

    // Comment:
    // tcID: 31
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     31,
     32,
     {0x99, 0xf1, 0x49, 0xe9, 0x94, 0x0d, 0x2a, 0x6e, 0xb2, 0xe8, 0x24, 0xb4,
      0x88, 0x38, 0xd5, 0x6f, 0x38, 0x3e, 0x45, 0x03, 0xce, 0xa7, 0x1e, 0x9e,
      0xce, 0xca, 0xf2, 0xa6, 0xe9, 0xd6, 0x16, 0xc1, 0xe9, 0x41, 0xfc, 0x0f,
      0x89, 0x94, 0xa0, 0x37, 0x3c, 0xa6, 0x32, 0x5f, 0x6d, 0xe2, 0xb7, 0x6b,
      0xe0, 0x43, 0xe4, 0x81, 0x2d, 0x36, 0x1d, 0x89, 0xcc, 0xe1, 0x66, 0xe7,
      0xc0, 0xf4, 0xae, 0x8e, 0x0c, 0x2c, 0x8a, 0xa0, 0x53, 0xeb, 0xe4, 0x56,
      0x8e, 0x0c, 0x54, 0x34, 0xac, 0xb6, 0x53, 0x59, 0x02, 0xdd, 0x13, 0x90,
      0x14, 0x46, 0xa3, 0x8d, 0x79, 0x05, 0xee, 0xfa, 0x51, 0xa2, 0x2b, 0xb5,
      0xb2, 0xa0, 0x5b, 0x24, 0x2b, 0x06, 0x16, 0x43, 0xa8, 0xb1, 0x53, 0x8c,
      0x34, 0x22, 0x55, 0x43, 0x8d, 0x46, 0x82, 0x4c, 0x43, 0xc5, 0xdf, 0x1f,
      0xb8, 0x46, 0x31, 0x14, 0x7b, 0x9c, 0xc6, 0x89, 0xd7, 0xb8, 0x28, 0xf2,
      0xbd, 0x5a, 0xbf, 0xb4, 0x8b, 0xd4, 0x0a, 0x1b, 0x0f, 0xf6, 0x86, 0x6e,
      0xad, 0xfd, 0x95, 0x88, 0xa0, 0x36, 0x1d, 0x9b, 0xc6, 0xa0, 0x76, 0xb9,
      0x78, 0xb9, 0xf8, 0x55, 0xa3, 0x67, 0x32, 0x20, 0x78, 0x16, 0xc8, 0xb3,
      0xc4, 0x26, 0x91, 0x4c, 0x73, 0xc9, 0x61, 0x3c, 0xa5, 0x3e, 0xf8, 0x26,
      0x1f, 0xc3, 0x0d, 0xc7, 0xa1, 0x5c, 0xf7, 0xc8, 0x58, 0x60, 0x92, 0x65,
      0x94, 0x66, 0x26, 0x00, 0x0a, 0x14, 0x65, 0xd4, 0x1b, 0x07, 0x6a, 0xc9,
      0xde, 0xd9, 0x3b, 0x86, 0xe9, 0x5d, 0xe5, 0x8c, 0x1a, 0x4d, 0x2b, 0x5c,
      0xfe, 0xd5, 0xd3, 0x11, 0xb6, 0xf2, 0x4c, 0xbf, 0x25, 0x7f, 0xb0, 0x3c,
      0x47, 0xe4, 0x43, 0xca, 0xba, 0xf1, 0xe7, 0x66, 0x16, 0x7f, 0x52, 0x4e,
      0x6f, 0xb6, 0x65, 0xe4, 0x2e, 0xe0, 0x46, 0x14, 0x4f, 0x25, 0x54, 0x4d,
      0x46, 0xd3, 0x4e, 0xfa},
     pub_key_1,
     {0x36, 0x33, 0x34, 0x33, 0x39, 0x31, 0x33, 0x34, 0x36, 0x38},
     true},

    // Comment:
    // tcID: 32
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     32,
     32,
     {0x20, 0xd0, 0x44, 0xf0, 0x45, 0xbd, 0xdd, 0xb0, 0xbf, 0xe9, 0x94, 0xa3,
      0x4b, 0x54, 0x37, 0xe6, 0x14, 0x46, 0xf9, 0x56, 0x8f, 0x3c, 0x7d, 0x09,
      0x13, 0x74, 0x30, 0xcf, 0xa1, 0x7e, 0x39, 0x29, 0xab, 0x8b, 0x84, 0x9e,
      0xc7, 0xcd, 0x63, 0x20, 0x79, 0xa8, 0x8f, 0x99, 0x4c, 0x0f, 0x4a, 0x0c,
      0xe2, 0x3f, 0x29, 0x76, 0x59, 0x5d, 0xf1, 0x98, 0xb4, 0xf1, 0x43, 0x12,
      0x05, 0xc2, 0x9b, 0x3f, 0xa1, 0xd3, 0x79, 0x80, 0x85, 0x54, 0x46, 0xd2,
      0x53, 0x27, 0xee, 0x66, 0x93, 0x24, 0xc3, 0x66, 0x60, 0x22, 0xc0, 0x10,
      0x0c, 0xf1, 0xbf, 0x85, 0x5c, 0x87, 0x74, 0xf3, 0xaa, 0x48, 0x98, 0xda,
      0xce, 0x7a, 0x16, 0x69, 0x3c, 0x61, 0x4e, 0xac, 0x00, 0xcb, 0x33, 0x7f,
      0x05, 0xec, 0x25, 0x88, 0xf6, 0x70, 0x37, 0x0c, 0x3e, 0xe4, 0x0f, 0x29,
      0xe8, 0xe9, 0x00, 0xda, 0x16, 0xd1, 0xdd, 0x28, 0xaa, 0xeb, 0x09, 0x8f,
      0x8f, 0x3b, 0x91, 0x8c, 0x56, 0x2f, 0x8c, 0x25, 0x12, 0xaf, 0x23, 0x8e,
      0xd4, 0xec, 0xb3, 0xbe, 0x4a, 0xe3, 0x93, 0x74, 0xeb, 0x63, 0x8b, 0x02,
      0x14, 0x19, 0xa3, 0xe0, 0x08, 0x90, 0xa4, 0xef, 0xf7, 0x08, 0x76, 0xfa,
      0xbd, 0x74, 0xee, 0xa1, 0xbd, 0x56, 0xde, 0x05, 0xdc, 0xa2, 0x08, 0x92,
      0x8d, 0x43, 0x4e, 0x73, 0x42, 0xe9, 0x17, 0x94, 0x71, 0xe9, 0x58, 0xe2,
      0x35, 0xa2, 0x98, 0xf3, 0x5e, 0xdc, 0xf9, 0xad, 0x77, 0x41, 0x1f, 0x82,
      0x4d, 0x5c, 0x53, 0xb4, 0x30, 0x8c, 0xd0, 0x8b, 0x04, 0x43, 0xb5, 0x8f,
      0xc5, 0xa8, 0x68, 0x39, 0x95, 0x38, 0xe5, 0x29, 0x4d, 0xcb, 0xd2, 0xe9,
      0x4d, 0x02, 0xc7, 0x19, 0xaa, 0x91, 0xac, 0x12, 0xc3, 0x83, 0x9b, 0xea,
      0x47, 0xce, 0xc6, 0x49, 0x62, 0x0b, 0x73, 0x23, 0x5f, 0x36, 0x8f, 0xd5,
      0xd9, 0x77, 0xe0, 0x33},
     pub_key_1,
     {0x31, 0x35, 0x34, 0x31, 0x31, 0x30, 0x33, 0x35, 0x39, 0x38},
     true},

    // Comment:
    // tcID: 33
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     33,
     32,
     {0x4c, 0x8d, 0x64, 0xae, 0xab, 0xd2, 0xe1, 0x2c, 0x8f, 0x2e, 0x3d, 0x31,
      0xac, 0x3f, 0x4b, 0x86, 0x17, 0x23, 0xab, 0x8f, 0x9a, 0x52, 0xcb, 0x89,
      0x10, 0xb2, 0x98, 0xfa, 0x3a, 0x73, 0x5b, 0xf9, 0x12, 0x84, 0xe9, 0xad,
      0x92, 0xbe, 0xf3, 0x99, 0x5a, 0x10, 0x58, 0xfd, 0xb0, 0xf6, 0x96, 0x14,
      0x3d, 0x92, 0xa9, 0x9c, 0x69, 0xc2, 0x33, 0xf6, 0x0f, 0x64, 0x87, 0x38,
      0x82, 0xc1, 0xc9, 0xca, 0x8e, 0x54, 0xcd, 0x03, 0x35, 0x08, 0x04, 0xaa,
      0xc3, 0x19, 0x74, 0x7c, 0x5c, 0xb8, 0xec, 0x6e, 0x42, 0xf6, 0x10, 0x04,
      0x74, 0x15, 0x81, 0x11, 0xb3, 0x05, 0x48, 0x51, 0x9e, 0x02, 0xae, 0x9a,
      0xb3, 0x95, 0x07, 0xef, 0xe5, 0x0b, 0x8b, 0x21, 0x2c, 0xaa, 0x82, 0x30,
      0x5d, 0x9f, 0x2d, 0x2c, 0x43, 0xb2, 0xf7, 0x5c, 0x55, 0x38, 0xb0, 0xff,
      0xe9, 0x42, 0x3e, 0x10, 0x44, 0xb5, 0xfa, 0x05, 0xbd, 0x67, 0x5e, 0x1a,
      0xfb, 0xe6, 0xd2, 0x2e, 0x73, 0xce, 0xd8, 0xdd, 0xdb, 0x3a, 0x00, 0xef,
      0x37, 0x21, 0x11, 0x36, 0x83, 0x8b, 0xfc, 0xd3, 0x76, 0x55, 0x20, 0x3b,
      0xf2, 0xc8, 0x30, 0xa6, 0x2f, 0x2c, 0x70, 0x70, 0x30, 0xe2, 0xb9, 0x64,
      0x44, 0x3d, 0xf1, 0xea, 0x24, 0xab, 0x12, 0x71, 0xfd, 0x06, 0xb3, 0xd6,
      0xc1, 0xab, 0x78, 0xb1, 0x33, 0x74, 0xc0, 0x86, 0xed, 0xab, 0x36, 0x26,
      0x7a, 0xc0, 0x65, 0xbf, 0x5a, 0xd7, 0x99, 0xd2, 0xf2, 0x7a, 0x6f, 0x4b,
      0xae, 0x70, 0x8b, 0xe1, 0x10, 0x38, 0x41, 0xaa, 0xf2, 0x1f, 0xf5, 0x47,
      0x47, 0x46, 0x34, 0xe9, 0x4c, 0x7f, 0xfe, 0xc8, 0xb4, 0xbd, 0xf8, 0x1c,
      0xd0, 0x0c, 0xf0, 0xf0, 0xe6, 0xf2, 0x34, 0xcf, 0x2d, 0x20, 0x8e, 0x2a,
      0xf2, 0xe2, 0xfe, 0xc0, 0x01, 0x94, 0x4e, 0x94, 0x44, 0xb0, 0x05, 0xc8,
      0xed, 0x91, 0x99, 0x03},
     pub_key_1,
     {0x31, 0x30, 0x34, 0x37, 0x38, 0x35, 0x38, 0x30, 0x31, 0x32, 0x38},
     true},

    // Comment:
    // tcID: 34
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     34,
     32,
     {0x0e, 0x97, 0xe2, 0x94, 0x58, 0x3f, 0x52, 0x8a, 0xf6, 0x31, 0xe4, 0x4c,
      0x02, 0x56, 0x33, 0x44, 0x65, 0x7e, 0xd4, 0x77, 0x83, 0xc1, 0x19, 0xa9,
      0xd2, 0x8d, 0x6c, 0x0f, 0x39, 0xb6, 0xeb, 0xea, 0x40, 0xe1, 0x84, 0x7b,
      0x9f, 0x2f, 0xe2, 0x70, 0x8b, 0xed, 0xf4, 0x4d, 0x20, 0x37, 0xef, 0x4b,
      0xa7, 0x46, 0x4c, 0x63, 0x0b, 0x8e, 0xa5, 0xbf, 0xe1, 0xc6, 0x6d, 0x4b,
      0x87, 0x29, 0xb2, 0x0f, 0xfd, 0x22, 0xfb, 0x57, 0x21, 0x19, 0x9e, 0x88,
      0x4b, 0x3b, 0x31, 0x4e, 0xd1, 0xa6, 0xb8, 0xab, 0xf1, 0x1c, 0x72, 0x31,
      0x4d, 0xce, 0x37, 0x5a, 0xca, 0x1d, 0x02, 0xaa, 0xb7, 0x73, 0xd8, 0x88,
      0x30, 0xd1, 0xb5, 0x6e, 0x86, 0xf4, 0x5b, 0x18, 0x62, 0x48, 0x22, 0x42,
      0xd9, 0xff, 0x57, 0xa1, 0x47, 0x38, 0x76, 0xc4, 0x76, 0xc3, 0x3f, 0xb8,
      0x22, 0x84, 0x20, 0xf3, 0xa6, 0xa3, 0x1f, 0x85, 0xb7, 0x7a, 0xec, 0x3a,
      0x8d, 0x60, 0xb3, 0x83, 0xee, 0xd4, 0xf0, 0x7d, 0xba, 0xde, 0x10, 0x20,
      0xf5, 0xaf, 0xcc, 0x08, 0x13, 0x2d, 0x04, 0x23, 0x31, 0x9e, 0x85, 0xf5,
      0x12, 0x35, 0xb4, 0xaa, 0x5e, 0x16, 0xc0, 0xb1, 0x83, 0xe0, 0xfd, 0x65,
      0x3e, 0x59, 0x4c, 0x6b, 0x17, 0xf2, 0x5d, 0x05, 0x5b, 0x41, 0x0b, 0x78,
      0xc8, 0x90, 0xf2, 0x9c, 0x79, 0x66, 0xa8, 0x09, 0x6c, 0xc2, 0x48, 0x90,
      0x60, 0x84, 0x17, 0x6e, 0x09, 0x0a, 0xf5, 0x00, 0xc9, 0xc5, 0xd9, 0x23,
      0x5a, 0x2d, 0x35, 0xf2, 0x31, 0xba, 0xe7, 0x4d, 0xeb, 0x9b, 0x86, 0x0a,
      0x54, 0x1d, 0x2b, 0xb9, 0x33, 0xff, 0x0a, 0x20, 0x0c, 0xcf, 0xf8, 0xea,
      0x36, 0x42, 0xe3, 0x35, 0x05, 0x62, 0xcf, 0x29, 0xdc, 0x2c, 0x11, 0x00,
      0x40, 0x1a, 0x9a, 0xe0, 0xc0, 0xf5, 0xe1, 0xe6, 0x42, 0x0b, 0x21, 0x9e,
      0x34, 0x41, 0x62, 0x54},
     pub_key_1,
     {0x31, 0x30, 0x35, 0x33, 0x36, 0x32, 0x38, 0x35, 0x35, 0x36, 0x38},
     true},

    // Comment:
    // tcID: 35
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     35,
     32,
     {0x80, 0xaa, 0x94, 0xe4, 0x9e, 0xe8, 0x24, 0x19, 0x10, 0x50, 0xc8, 0xbb,
      0xaa, 0x73, 0xb3, 0x52, 0xfe, 0xa2, 0x31, 0x18, 0x93, 0xd8, 0xb8, 0xe0,
      0x0e, 0x61, 0xa2, 0xd1, 0x47, 0x01, 0x78, 0x3d, 0x36, 0x4e, 0x15, 0xfc,
      0x09, 0x03, 0x54, 0x82, 0x74, 0x77, 0x11, 0xfa, 0x1f, 0xa7, 0x26, 0x29,
      0x46, 0x0f, 0xaf, 0xdb, 0x23, 0x47, 0x45, 0x64, 0x52, 0x74, 0x47, 0xe0,
      0xc0, 0x5b, 0xe2, 0xba, 0x89, 0x5e, 0x2d, 0xd1, 0x85, 0x3b, 0x9e, 0x60,
      0x79, 0xaf, 0xc1, 0x46, 0x4f, 0x7c, 0x86, 0x89, 0xb2, 0xad, 0x74, 0xf8,
      0xcd, 0x2b, 0xbb, 0xc7, 0x69, 0x0c, 0x91, 0xbf, 0xe2, 0x67, 0x1b, 0xf3,
      0xfd, 0xb1, 0xa4, 0x39, 0x27, 0xc5, 0xe7, 0x31, 0x23, 0xf4, 0xdc, 0xdd,
      0xb8, 0xdf, 0xf9, 0xf0, 0x6b, 0xf2, 0x54, 0xca, 0x2c, 0xda, 0x0a, 0x03,
      0x99, 0x39, 0xce, 0xaf, 0x2e, 0x19, 0x6f, 0x2c, 0xb2, 0x68, 0xee, 0xa3,
      0x7c, 0x51, 0x5d, 0x00, 0x82, 0xe5, 0xe9, 0xb4, 0xa8, 0x27, 0x19, 0xc6,
      0xf5, 0xdd, 0xd6, 0xe6, 0xa7, 0x79, 0x05, 0x43, 0x25, 0xc1, 0xac, 0x45,
      0xd6, 0xc2, 0x59, 0x9f, 0x2c, 0x83, 0xde, 0xf5, 0x08, 0x81, 0xcd, 0x9d,
      0x3a, 0x85, 0x08, 0x74, 0x96, 0x46, 0xc9, 0x29, 0x6a, 0xe2, 0x42, 0x9a,
      0x96, 0xf5, 0x80, 0xd7, 0xcf, 0xc5, 0x4b, 0x2f, 0x08, 0x72, 0x6e, 0xd3,
      0xca, 0xf7, 0xc3, 0xe5, 0xab, 0x37, 0xd3, 0x2a, 0xff, 0x30, 0x9b, 0x1f,
      0x34, 0xc1, 0xb8, 0xd7, 0x7e, 0x2d, 0xa6, 0x9b, 0x61, 0x9e, 0x38, 0x04,
      0xae, 0x6c, 0xe4, 0x39, 0xe7, 0x96, 0xf8, 0x63, 0x40, 0xdd, 0x0b, 0xbb,
      0xe7, 0xea, 0x82, 0x38, 0x57, 0xd9, 0xe4, 0xeb, 0x1a, 0xeb, 0x76, 0x04,
      0xfa, 0x16, 0xf4, 0xb0, 0x68, 0x3f, 0x78, 0xa8, 0x25, 0x3d, 0x00, 0xfe,
      0xdb, 0x5b, 0x60, 0x24},
     pub_key_1,
     {0x39, 0x35, 0x33, 0x39, 0x30, 0x34, 0x31, 0x30, 0x35},
     true},

    // Comment:
    // tcID: 36
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     36,
     32,
     {0x1e, 0x10, 0xe4, 0x13, 0x57, 0x96, 0x44, 0x3f, 0xf3, 0xa8, 0x15, 0xbe,
      0x4c, 0x87, 0x3f, 0x9f, 0x61, 0x67, 0x5c, 0x85, 0x13, 0x7f, 0xf4, 0x39,
      0x7f, 0x60, 0x0f, 0x4f, 0x5f, 0xf7, 0x96, 0x34, 0xaa, 0x4f, 0xfd, 0xe2,
      0x19, 0x54, 0x19, 0xfc, 0x78, 0xac, 0x82, 0xeb, 0x7b, 0xe2, 0x06, 0xf9,
      0x14, 0x43, 0xb1, 0x2d, 0x74, 0x34, 0x57, 0xcf, 0x7f, 0xdb, 0xfa, 0xc6,
      0xd7, 0xf6, 0x6f, 0xab, 0xe2, 0x6f, 0xba, 0x46, 0x4d, 0x7f, 0x98, 0x4c,
      0x6a, 0x50, 0x2b, 0x19, 0xc8, 0xd4, 0xb6, 0x34, 0xcd, 0xed, 0x91, 0xd4,
      0x28, 0x9b, 0xd8, 0x4e, 0xa7, 0xb2, 0xfd, 0xf2, 0xe6, 0x22, 0x9b, 0xf4,
      0x7b, 0x40, 0xfe, 0xb3, 0x68, 0x69, 0x2f, 0x60, 0x27, 0x7e, 0xef, 0x9c,
      0x02, 0x28, 0xbd, 0x31, 0x5a, 0x32, 0x37, 0x45, 0x81, 0x07, 0xc8, 0xfb,
      0xfd, 0xe8, 0x30, 0xf8, 0xc3, 0x2a, 0xcc, 0x4d, 0x17, 0x2e, 0x8e, 0xec,
      0xcf, 0xac, 0x19, 0xe9, 0x90, 0x21, 0xcf, 0x81, 0x22, 0x48, 0x7f, 0x93,
      0x17, 0x59, 0x81, 0xbf, 0x9b, 0x79, 0x7f, 0xf8, 0x69, 0x15, 0x3b, 0x8a,
      0xdd, 0xaa, 0xed, 0x1f, 0x18, 0x4a, 0x67, 0x7f, 0xd6, 0x94, 0xd8, 0x8e,
      0xe0, 0xed, 0xa3, 0x95, 0x9b, 0xb3, 0xa0, 0xd8, 0xf6, 0x6c, 0x36, 0x16,
      0x58, 0x35, 0x9e, 0xb1, 0x17, 0xea, 0xa9, 0x1f, 0x02, 0xc6, 0xc0, 0x88,
      0x9f, 0x69, 0xf9, 0xa1, 0x4f, 0xad, 0x91, 0xd2, 0xfa, 0x44, 0x3d, 0x2b,
      0xb1, 0x7f, 0x3a, 0xaa, 0x41, 0x92, 0x85, 0x46, 0xe1, 0x63, 0xec, 0x2d,
      0x09, 0xec, 0x5c, 0xc9, 0x75, 0x8c, 0x7c, 0xda, 0x12, 0xfb, 0x29, 0x69,
      0x2f, 0x09, 0xab, 0xb9, 0x87, 0xa1, 0x35, 0x89, 0x2f, 0x17, 0xaf, 0xac,
      0x78, 0x01, 0x46, 0x24, 0x29, 0x8b, 0x1a, 0xf7, 0x9a, 0x52, 0x3f, 0xc0,
      0xcb, 0xde, 0xb1, 0x20},
     pub_key_1,
     {0x39, 0x37, 0x38, 0x38, 0x34, 0x38, 0x30, 0x33, 0x39},
     true},

    // Comment:
    // tcID: 37
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     37,
     32,
     {0x73, 0xe3, 0x94, 0x68, 0xa5, 0x64, 0x07, 0x18, 0xbb, 0x56, 0xf2, 0x69,
      0x39, 0xca, 0x18, 0x40, 0x69, 0x95, 0x01, 0x3c, 0xd1, 0x0a, 0x7a, 0x72,
      0xe6, 0x5d, 0x2e, 0x6b, 0x1d, 0xf2, 0xe8, 0x41, 0xc1, 0xa7, 0x39, 0x41,
      0x35, 0xce, 0x0e, 0x5d, 0xa4, 0xa8, 0x30, 0xbd, 0xfa, 0xac, 0x5b, 0xc5,
      0xb2, 0xd8, 0xdd, 0xbe, 0x6b, 0x50, 0x98, 0xa3, 0xd9, 0xde, 0x96, 0xcc,
      0x63, 0x98, 0x23, 0xf7, 0xa1, 0xb2, 0x3f, 0x76, 0x9b, 0xa1, 0x8d, 0x0d,
      0x47, 0x72, 0xc1, 0xe9, 0x89, 0x89, 0x1a, 0x4d, 0x60, 0xa9, 0x5b, 0xcd,
      0x42, 0x16, 0x0a, 0x78, 0x93, 0x13, 0x61, 0x52, 0x2d, 0xa1, 0xce, 0x1f,
      0x10, 0x20, 0x4f, 0x57, 0xc5, 0x19, 0xa1, 0x0c, 0x2c, 0xc9, 0xee, 0x31,
      0x45, 0xa0, 0xa2, 0xac, 0x31, 0xc3, 0x7b, 0x3b, 0x5e, 0x55, 0x72, 0xaa,
      0xff, 0xda, 0x55, 0x9f, 0x05, 0xa6, 0x84, 0x40, 0x2b, 0xb5, 0xc3, 0xb2,
      0x8c, 0x6a, 0x2a, 0xe2, 0x63, 0x21, 0x40, 0x73, 0x99, 0x95, 0x08, 0xd9,
      0x6a, 0x96, 0xc3, 0x0b, 0xf0, 0x2f, 0xde, 0x3d, 0xe1, 0x62, 0xd9, 0x37,
      0xc4, 0xf2, 0xb3, 0x1f, 0xfd, 0xeb, 0xc4, 0x2f, 0x92, 0x67, 0xe6, 0x21,
      0x85, 0x5f, 0xd1, 0x8e, 0xb9, 0x7c, 0x0c, 0xfa, 0x49, 0x77, 0xc1, 0xa3,
      0x76, 0x5b, 0x4e, 0xbc, 0xe9, 0x55, 0xa9, 0xc8, 0x71, 0x30, 0xba, 0xef,
      0x18, 0x53, 0x49, 0x74, 0x07, 0xb1, 0x92, 0x2b, 0xe2, 0xf4, 0x3b, 0x6d,
      0xea, 0xf7, 0x91, 0x0d, 0x6f, 0x8f, 0xbf, 0xa9, 0x7d, 0x87, 0x0f, 0x16,
      0xe1, 0x7a, 0x3b, 0x9c, 0x13, 0x3b, 0xe1, 0x39, 0x1e, 0x84, 0x7e, 0x10,
      0x30, 0x96, 0xfe, 0xe4, 0x90, 0x5f, 0x24, 0x6f, 0xac, 0xbb, 0xe8, 0xc9,
      0x5f, 0x62, 0xd1, 0x5f, 0x30, 0x2c, 0xb2, 0x7e, 0x8d, 0x4b, 0x69, 0xec,
      0x24, 0x9a, 0xf4, 0xbd},
     pub_key_1,
     {0x33, 0x36, 0x31, 0x30, 0x36, 0x37, 0x32, 0x34, 0x34, 0x32},
     true},

    // Comment:
    // tcID: 38
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     38,
     32,
     {0x40, 0xe3, 0x50, 0x42, 0x84, 0xc5, 0x96, 0x20, 0xca, 0xf1, 0x45, 0xdd,
      0x9f, 0x24, 0x25, 0xc3, 0x9c, 0x66, 0xbb, 0x4e, 0x0d, 0x7a, 0xbd, 0xdd,
      0x69, 0x4b, 0x81, 0x0b, 0xe4, 0xa9, 0xe2, 0xf7, 0x28, 0xd7, 0x06, 0x53,
      0x10, 0x19, 0xe7, 0xe0, 0x72, 0x93, 0x06, 0x6d, 0xe0, 0xdd, 0x6c, 0x7c,
      0x68, 0xcc, 0xf3, 0x2f, 0xf2, 0xd9, 0x1d, 0xea, 0x74, 0xc5, 0x92, 0xc5,
      0x04, 0x91, 0x61, 0x48, 0x55, 0x1c, 0x99, 0xdd, 0xd5, 0xe4, 0xea, 0x0a,
      0x90, 0x65, 0x00, 0x34, 0x1b, 0x1f, 0x7f, 0x6a, 0x03, 0xc4, 0x90, 0x18,
      0x27, 0xfa, 0xbd, 0xdf, 0xfa, 0xf1, 0xf0, 0x28, 0x13, 0x9d, 0xb5, 0x29,
      0x25, 0x54, 0x18, 0x6b, 0x86, 0x7a, 0x01, 0x25, 0x20, 0xd5, 0x54, 0xbb,
      0xc4, 0x2b, 0x1d, 0x73, 0xd5, 0x2b, 0x39, 0x7a, 0x7c, 0x31, 0x0e, 0x7d,
      0x19, 0x50, 0x37, 0xf1, 0x5f, 0xb1, 0xfe, 0x72, 0x9f, 0x57, 0x7d, 0x18,
      0x47, 0x89, 0x44, 0x36, 0xb9, 0x82, 0x8e, 0xca, 0x4f, 0xe8, 0x81, 0x94,
      0x5c, 0x1a, 0x38, 0xa4, 0x08, 0x05, 0x36, 0x5d, 0xdd, 0xf6, 0xcf, 0x77,
      0x08, 0xcb, 0xa2, 0x94, 0x8a, 0x15, 0xb7, 0x56, 0x75, 0x7d, 0x62, 0x46,
      0xda, 0xd9, 0x09, 0x85, 0x22, 0x2e, 0x4b, 0xae, 0xcc, 0x78, 0x23, 0xe4,
      0xe7, 0xe9, 0x9d, 0x56, 0x8a, 0x9d, 0xa1, 0x44, 0xa5, 0xb5, 0x56, 0x22,
      0x0a, 0xae, 0x30, 0xb8, 0xa8, 0xd9, 0x16, 0xa0, 0x50, 0xa8, 0x69, 0xc7,
      0x03, 0x68, 0x60, 0x7d, 0xd0, 0x09, 0x2c, 0xa9, 0xb5, 0xa0, 0x08, 0x65,
      0xd3, 0xbc, 0x1e, 0xe0, 0xec, 0x06, 0xdf, 0x53, 0xf9, 0x82, 0x83, 0x27,
      0x12, 0x7f, 0x33, 0xa9, 0x77, 0x96, 0xf6, 0xb0, 0xb2, 0x55, 0xf1, 0xce,
      0xe3, 0x43, 0x28, 0xcf, 0xd2, 0xca, 0x1e, 0xa3, 0xe6, 0x92, 0xd0, 0xa9,
      0x4e, 0x45, 0x7e, 0xcd},
     pub_key_1,
     {0x31, 0x30, 0x35, 0x34, 0x32, 0x34, 0x30, 0x37, 0x30, 0x35},
     true},

    // Comment:
    // tcID: 39
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     39,
     32,
     {0x72, 0xf7, 0xf4, 0xbf, 0x01, 0xa6, 0x78, 0x4f, 0xac, 0xe7, 0xd3, 0x1b,
      0x19, 0xc1, 0x9b, 0xa1, 0xc7, 0x5b, 0x16, 0xef, 0xf4, 0x19, 0xf8, 0x1b,
      0x39, 0xc1, 0xc1, 0x7c, 0xd4, 0x89, 0xec, 0xaf, 0xff, 0xdb, 0x2d, 0xfe,
      0xb3, 0x30, 0x45, 0xcf, 0x67, 0x9a, 0x45, 0x53, 0x36, 0xbd, 0x68, 0x69,
      0xae, 0x61, 0x10, 0x90, 0x43, 0x68, 0x72, 0x93, 0xbf, 0x98, 0xef, 0x7a,
      0xd0, 0x3a, 0xfe, 0x6e, 0x71, 0xce, 0x4d, 0x43, 0x31, 0x97, 0x43, 0xc0,
      0x7c, 0x31, 0x3b, 0x12, 0xa7, 0x28, 0xc8, 0xa9, 0x82, 0x56, 0xbd, 0x1f,
      0xd7, 0x35, 0x15, 0x2d, 0x1d, 0x2c, 0x83, 0xde, 0x2b, 0x8b, 0x57, 0xcf,
      0x9b, 0xed, 0x46, 0x91, 0xad, 0xe1, 0x5e, 0xab, 0xd2, 0x61, 0x37, 0x7c,
      0x8e, 0x26, 0xba, 0xb0, 0x3d, 0x0d, 0xa0, 0x55, 0x08, 0x6d, 0xc4, 0xca,
      0x58, 0x70, 0xbd, 0xcd, 0x9e, 0xf3, 0xe7, 0xe0, 0x97, 0x3b, 0xe8, 0x71,
      0x73, 0x8a, 0x3e, 0x38, 0x9d, 0x77, 0x4d, 0x5d, 0x04, 0xd7, 0x1a, 0xe0,
      0xa3, 0xbe, 0x03, 0x74, 0x6a, 0xa4, 0xb7, 0xf2, 0x0a, 0xfb, 0xb3, 0xa4,
      0x4d, 0x91, 0x63, 0xcb, 0xf4, 0xe6, 0x75, 0xe3, 0x6d, 0x01, 0xf0, 0x16,
      0x08, 0x7d, 0x4e, 0x7c, 0x68, 0xb2, 0xe3, 0x02, 0x0f, 0x6f, 0xad, 0x36,
      0x39, 0x48, 0x80, 0x4b, 0x04, 0x94, 0xd7, 0xb3, 0x8d, 0x2a, 0xd4, 0xee,
      0x12, 0x88, 0xbf, 0xc5, 0x16, 0x6b, 0x59, 0xae, 0x3d, 0xb2, 0xc2, 0xc0,
      0x39, 0x71, 0xfd, 0x42, 0xd0, 0x4e, 0x6f, 0xec, 0xbd, 0x36, 0xcb, 0xa6,
      0x39, 0x0f, 0xdd, 0x87, 0x8b, 0x67, 0xa2, 0xc6, 0x56, 0x5a, 0x78, 0x26,
      0x67, 0x11, 0x44, 0x71, 0x21, 0x08, 0xe3, 0x7a, 0xdb, 0xe8, 0x19, 0x8a,
      0x2b, 0xb3, 0xa3, 0x71, 0xc9, 0x0d, 0x8c, 0x68, 0x80, 0xdb, 0xcc, 0x94,
      0x8c, 0xb4, 0xf7, 0x75},
     pub_key_1,
     {0x35, 0x31, 0x37, 0x34, 0x34, 0x34, 0x38, 0x31, 0x39, 0x37},
     true},

    // Comment:
    // tcID: 40
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     40,
     32,
     {0x08, 0x4c, 0xf6, 0x62, 0x8f, 0x8f, 0x96, 0xad, 0x84, 0x21, 0x05, 0x19,
      0x8b, 0xc3, 0x0a, 0x72, 0xbc, 0x3e, 0xa4, 0xaa, 0x4b, 0xb0, 0x11, 0x76,
      0x78, 0x0f, 0x38, 0x4f, 0x9f, 0x4e, 0xf2, 0xdc, 0x9b, 0x59, 0x1d, 0x04,
      0x2c, 0x56, 0xc8, 0x98, 0xe4, 0x8d, 0x46, 0x82, 0x26, 0xa9, 0xa3, 0x61,
      0xa9, 0xc8, 0xe0, 0xb2, 0x79, 0x86, 0xfe, 0x64, 0x99, 0x11, 0x2d, 0x9f,
      0x42, 0x5e, 0x08, 0xc7, 0x78, 0xd0, 0x1d, 0x3b, 0x22, 0x1d, 0xc1, 0x10,
      0x41, 0x10, 0x06, 0x37, 0x3f, 0xf9, 0x03, 0xd7, 0x86, 0x78, 0xb5, 0xb0,
      0x43, 0x19, 0xb5, 0xf9, 0x6a, 0xd1, 0x4d, 0x13, 0x95, 0xde, 0xfa, 0x4a,
      0x51, 0x7d, 0x5c, 0xa7, 0x30, 0x79, 0x83, 0xa7, 0x81, 0x91, 0x92, 0xae,
      0x7d, 0x87, 0x82, 0x8e, 0xda, 0x55, 0x39, 0x14, 0x44, 0xcf, 0xb7, 0x37,
      0x88, 0x9f, 0x47, 0x94, 0x37, 0x11, 0x2b, 0x1a, 0x45, 0xc6, 0x87, 0xa5,
      0x63, 0xa0, 0x76, 0x60, 0x22, 0x3d, 0x7f, 0xa1, 0x99, 0xe0, 0x92, 0x4d,
      0x6b, 0x80, 0xea, 0x18, 0xde, 0x20, 0x1a, 0x6d, 0x8e, 0x08, 0xa8, 0x0d,
      0xdd, 0x09, 0x54, 0x03, 0x2c, 0xd3, 0xf9, 0xce, 0x0d, 0x85, 0xd0, 0x18,
      0x0a, 0x08, 0xa8, 0x8d, 0x81, 0x3c, 0x6e, 0xd2, 0x89, 0xde, 0xcf, 0x3f,
      0x1c, 0x15, 0x14, 0xad, 0xef, 0x9a, 0x96, 0x62, 0x33, 0x4d, 0x6e, 0x51,
      0x77, 0xd3, 0xdc, 0xd2, 0x4a, 0x2a, 0x17, 0x0a, 0x65, 0x55, 0xd2, 0x18,
      0xaa, 0x30, 0x63, 0x8a, 0x20, 0x6b, 0x17, 0x83, 0xed, 0xef, 0x43, 0xae,
      0xb6, 0xf6, 0x41, 0x92, 0xf2, 0xfe, 0xc5, 0x2e, 0x2f, 0x82, 0xf4, 0xdf,
      0xe2, 0x37, 0x26, 0x71, 0x9e, 0x16, 0xa3, 0xef, 0x87, 0x3a, 0xe3, 0x74,
      0x88, 0x44, 0x96, 0x34, 0x83, 0x3e, 0xf2, 0xb7, 0x4b, 0x47, 0x66, 0xf4,
      0xcc, 0xff, 0xeb, 0x2a},
     pub_key_1,
     {0x31, 0x39, 0x36, 0x37, 0x35, 0x36, 0x31, 0x32, 0x35, 0x31},
     true},

    // Comment:
    // tcID: 41
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     41,
     32,
     {0x4a, 0x51, 0x0d, 0xd6, 0xed, 0xc7, 0xea, 0xea, 0x7e, 0xe9, 0x30, 0x2b,
      0x00, 0x78, 0x44, 0x43, 0x3b, 0x01, 0x0d, 0xca, 0x7b, 0xe4, 0xad, 0x12,
      0xa8, 0x16, 0x5d, 0xa9, 0x3f, 0xb8, 0xff, 0x74, 0xee, 0x5b, 0x83, 0x67,
      0x69, 0x60, 0x8a, 0x1e, 0x20, 0x7e, 0x20, 0x8a, 0x7d, 0x7f, 0xb2, 0x60,
      0x6c, 0x9f, 0x0b, 0xdc, 0xf7, 0x13, 0x91, 0xed, 0x51, 0x71, 0x10, 0x0a,
      0xb7, 0x38, 0xe5, 0x4d, 0x01, 0x80, 0xa6, 0x29, 0x70, 0x6d, 0xb3, 0x9e,
      0xfb, 0x88, 0xb6, 0x90, 0x78, 0x3c, 0xa9, 0xad, 0x25, 0x23, 0x4b, 0xcd,
      0x6c, 0xe0, 0x92, 0x0a, 0x01, 0xf7, 0x4c, 0x9a, 0xfa, 0xf3, 0x65, 0x00,
      0x43, 0x45, 0x19, 0xaf, 0xb3, 0xe8, 0xed, 0x2b, 0x65, 0xa9, 0x47, 0x29,
      0x81, 0x01, 0xa7, 0x51, 0xba, 0x46, 0xcb, 0x7e, 0xe5, 0x1c, 0x37, 0x90,
      0x3d, 0x60, 0xf6, 0xac, 0x8a, 0x7f, 0x3b, 0xc7, 0x26, 0xf3, 0x94, 0xdf,
      0xd5, 0xb5, 0x3c, 0x12, 0xd5, 0x70, 0x3f, 0xd7, 0x19, 0xaa, 0xc9, 0x58,
      0x90, 0x46, 0xf9, 0xf4, 0x06, 0x48, 0x53, 0xfd, 0xe4, 0xc9, 0x23, 0x74,
      0xc1, 0xda, 0x4f, 0xad, 0x27, 0xa4, 0xf6, 0x03, 0xcf, 0x23, 0xa9, 0xec,
      0x4e, 0xe4, 0x78, 0x67, 0x7f, 0x00, 0x0c, 0xe1, 0x8f, 0xeb, 0x79, 0x1b,
      0x13, 0x0c, 0x03, 0x7d, 0x43, 0x47, 0xab, 0xe3, 0x69, 0x01, 0x58, 0x67,
      0x28, 0xfb, 0x3b, 0x09, 0x26, 0x2c, 0xcd, 0x0f, 0xeb, 0x79, 0xaa, 0x61,
      0xeb, 0x35, 0x03, 0x28, 0x3e, 0xbd, 0xb4, 0x95, 0x31, 0x68, 0x14, 0xa7,
      0x4c, 0x74, 0xf5, 0x81, 0x9b, 0x16, 0x5e, 0x2d, 0x0e, 0xfd, 0x65, 0xd5,
      0x3e, 0x4f, 0x1e, 0x73, 0xd7, 0x6d, 0xa1, 0x84, 0x7f, 0x8f, 0x8b, 0x95,
      0x56, 0x78, 0x43, 0x7b, 0x45, 0x84, 0xbf, 0x6d, 0x8a, 0x8a, 0x29, 0x16,
      0x84, 0xa1, 0xa9, 0x9b},
     pub_key_1,
     {0x33, 0x34, 0x34, 0x37, 0x32, 0x35, 0x33, 0x33, 0x34, 0x33},
     true},

    // Comment:
    // tcID: 42
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     42,
     32,
     {0x12, 0xb0, 0x6d, 0xf2, 0x8d, 0xbd, 0xb8, 0xc6, 0xc3, 0x46, 0x10, 0xeb,
      0xca, 0x8c, 0x6a, 0x73, 0x05, 0x58, 0xf6, 0x66, 0x9b, 0xf1, 0x60, 0xb8,
      0x08, 0x3b, 0x4a, 0x18, 0xa4, 0xd6, 0x41, 0xc3, 0x33, 0xd7, 0x70, 0xd0,
      0x3c, 0x5a, 0x6a, 0x16, 0x5d, 0xb0, 0x73, 0x05, 0xc0, 0xd0, 0xde, 0xb6,
      0x72, 0x13, 0x55, 0xd4, 0xc5, 0x96, 0x3a, 0x0b, 0x61, 0x4b, 0xf0, 0xad,
      0x52, 0x2c, 0xe2, 0xf3, 0x39, 0xfe, 0xc3, 0x01, 0xc6, 0x1b, 0xd3, 0x54,
      0x0d, 0x0a, 0x7b, 0xf2, 0x95, 0xcd, 0x67, 0xa7, 0xab, 0x81, 0x40, 0x1e,
      0x3a, 0xf1, 0xc6, 0x6e, 0x5a, 0xc4, 0xd7, 0x7e, 0x95, 0xc8, 0xb5, 0xd0,
      0x0b, 0xf1, 0x28, 0xdd, 0x1f, 0x47, 0xa8, 0x47, 0xab, 0x78, 0xad, 0xe2,
      0x2f, 0x6d, 0xdb, 0x15, 0x8e, 0x6d, 0xa4, 0x69, 0x50, 0xc1, 0x3e, 0xeb,
      0x10, 0x92, 0x1b, 0xdf, 0x3b, 0x58, 0x18, 0x50, 0x6d, 0x63, 0x50, 0x20,
      0x81, 0x05, 0x35, 0xdb, 0x03, 0xe2, 0x91, 0xc5, 0x03, 0x90, 0x2f, 0x25,
      0xcd, 0x67, 0xe2, 0xd2, 0xf7, 0x31, 0x12, 0x2d, 0x9f, 0x18, 0xc7, 0x11,
      0x8e, 0xce, 0x36, 0x9a, 0xda, 0xac, 0xe1, 0xc7, 0x42, 0x22, 0xb4, 0x70,
      0x46, 0x47, 0x6d, 0x6f, 0x48, 0x91, 0x0a, 0x7d, 0x6b, 0x6d, 0xc4, 0xfa,
      0x52, 0x81, 0x99, 0xd5, 0x4a, 0x47, 0x28, 0x2e, 0x59, 0x94, 0x8e, 0xa6,
      0x6b, 0xdc, 0x52, 0xb9, 0xdf, 0xad, 0x6d, 0x2a, 0xd3, 0x4f, 0x19, 0x01,
      0x7b, 0x2f, 0x92, 0x9c, 0xe5, 0x68, 0x4a, 0xb5, 0x9d, 0x30, 0xe0, 0x25,
      0x2b, 0x96, 0xc7, 0x62, 0x98, 0x7c, 0x35, 0xc7, 0x7e, 0xb9, 0xaf, 0x34,
      0xe5, 0x68, 0xfb, 0x7a, 0x2c, 0x2c, 0x7f, 0x69, 0x8c, 0xd4, 0x87, 0xaf,
      0x18, 0x52, 0xe1, 0x7a, 0xf1, 0xbc, 0x2b, 0x25, 0xfe, 0xff, 0xd3, 0x13,
      0x15, 0xa6, 0xce, 0xad},
     pub_key_1,
     {0x33, 0x36, 0x38, 0x32, 0x36, 0x34, 0x33, 0x31, 0x38},
     true},

    // Comment:
    // tcID: 43
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     43,
     32,
     {0x29, 0xc0, 0x19, 0x87, 0x26, 0x6a, 0xc0, 0x14, 0x48, 0x7e, 0x26, 0x05,
      0x2c, 0x19, 0xcd, 0xd9, 0x65, 0x89, 0x66, 0x44, 0x41, 0x97, 0x02, 0x5b,
      0xda, 0x28, 0xc8, 0xd4, 0x7a, 0x67, 0xf7, 0x01, 0x7d, 0xce, 0x38, 0x9d,
      0xec, 0x61, 0x9d, 0x61, 0xc0, 0x1f, 0x7f, 0x17, 0x58, 0xf8, 0xd5, 0x50,
      0xf9, 0xd4, 0xaa, 0x98, 0xd6, 0xab, 0xfe, 0xa6, 0xae, 0xd8, 0x14, 0x3f,
      0xa4, 0x14, 0x3c, 0x85, 0x3d, 0x4a, 0xf2, 0xba, 0x3c, 0x5c, 0x5d, 0xf1,
      0xf1, 0x81, 0x1d, 0x31, 0x51, 0xd3, 0x5c, 0x6b, 0xab, 0x09, 0xec, 0x94,
      0xab, 0xa0, 0x19, 0x83, 0x83, 0xe3, 0x26, 0x95, 0x5a, 0x1c, 0xe5, 0x4d,
      0x06, 0x4c, 0x6d, 0x73, 0x4f, 0x35, 0xba, 0xb7, 0xb1, 0x8d, 0x3d, 0x36,
      0xd1, 0xff, 0x0a, 0xce, 0x46, 0x70, 0x1c, 0x7d, 0xb0, 0x04, 0xb7, 0x5c,
      0xb4, 0x4b, 0xa1, 0xbc, 0xd2, 0xdc, 0xd2, 0xcc, 0x76, 0xd1, 0xb4, 0x6c,
      0xfd, 0x91, 0xd2, 0xb2, 0xf5, 0xb0, 0x32, 0x96, 0x22, 0x4a, 0x8e, 0x4e,
      0x45, 0x00, 0x31, 0xa3, 0x2a, 0xbe, 0xf8, 0x6c, 0x1f, 0x06, 0xa0, 0x08,
      0xb5, 0x6b, 0x1c, 0x3c, 0x49, 0x9b, 0x8e, 0xb9, 0x51, 0xcc, 0xbc, 0xc9,
      0x40, 0x4d, 0x3c, 0xbc, 0x68, 0xe0, 0xb0, 0x29, 0x2c, 0x4d, 0x14, 0x10,
      0x30, 0xd6, 0xf3, 0xdb, 0x18, 0x80, 0x0c, 0x98, 0x7c, 0x34, 0x73, 0x0e,
      0x68, 0x9a, 0x43, 0xf0, 0x43, 0x6f, 0xf0, 0x02, 0x23, 0x3d, 0xa7, 0xe8,
      0xbe, 0x5b, 0x24, 0x2a, 0xbb, 0x13, 0x23, 0x8d, 0xb2, 0x47, 0xb0, 0xb3,
      0x9a, 0xf3, 0x06, 0x40, 0x66, 0xd3, 0xd6, 0xb4, 0x4d, 0xa0, 0x65, 0xac,
      0x90, 0x05, 0xea, 0x21, 0xa1, 0xac, 0xe2, 0xb8, 0xca, 0x27, 0x29, 0xf5,
      0xde, 0x2f, 0x57, 0x9f, 0x66, 0xf2, 0x01, 0xe9, 0x1b, 0xcc, 0x31, 0xd5,
      0xb4, 0x30, 0xe3, 0x22},
     pub_key_1,
     {0x33, 0x32, 0x36, 0x31, 0x31, 0x39, 0x38, 0x36, 0x30, 0x38},
     true},

    // Comment:
    // tcID: 44
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     44,
     32,
     {0x40, 0x00, 0x26, 0x44, 0x0d, 0xc3, 0x8f, 0x61, 0xc8, 0x73, 0xf0, 0xe4,
      0xec, 0xa1, 0x52, 0xd7, 0x2e, 0x42, 0x37, 0xa6, 0x85, 0xca, 0x69, 0x09,
      0x1b, 0x71, 0x93, 0x8c, 0xad, 0x22, 0x59, 0xfa, 0x04, 0x5a, 0xf8, 0x1d,
      0x9a, 0x8e, 0x56, 0x8f, 0x71, 0xb2, 0xf4, 0x2b, 0x9b, 0x5f, 0xdb, 0xa8,
      0x6b, 0xc3, 0xd5, 0xd5, 0xdd, 0x85, 0xdf, 0xaf, 0x2c, 0x12, 0x82, 0x00,
      0xbf, 0x78, 0x6b, 0xa2, 0x09, 0xc7, 0x83, 0xd9, 0xa9, 0xcc, 0xdc, 0x0c,
      0xdd, 0xfc, 0xfe, 0xf5, 0x79, 0xf6, 0xc9, 0xab, 0xc4, 0xaa, 0x4b, 0x4e,
      0xf4, 0x1f, 0x39, 0x13, 0x6f, 0xe1, 0xd9, 0x60, 0x04, 0x77, 0x78, 0xfe,
      0x29, 0x71, 0x2b, 0xf6, 0xb2, 0x78, 0x17, 0x06, 0x95, 0x54, 0xac, 0x10,
      0xf2, 0x85, 0x3c, 0xbc, 0x82, 0x58, 0x82, 0xbf, 0xad, 0x98, 0x45, 0xef,
      0x30, 0x4c, 0x17, 0xe2, 0x58, 0x7e, 0x12, 0x4c, 0x69, 0x79, 0x42, 0x7a,
      0x3b, 0xe8, 0x09, 0x65, 0xb2, 0x5b, 0x6e, 0xd2, 0x58, 0x78, 0x75, 0x8c,
      0xf3, 0x37, 0x6c, 0x7e, 0xc7, 0xc2, 0xbb, 0x8e, 0xcf, 0x25, 0x29, 0x47,
      0x5e, 0xd2, 0x4a, 0xb2, 0xe3, 0x7b, 0xea, 0xc3, 0x30, 0x7f, 0xbc, 0x2b,
      0xc0, 0xd5, 0x1b, 0x39, 0x00, 0x5d, 0xa9, 0xfe, 0x87, 0xd8, 0x48, 0xcb,
      0xc1, 0xf8, 0x62, 0x5d, 0x47, 0xd7, 0xdd, 0x85, 0x5a, 0xcd, 0x1b, 0x1f,
      0xc7, 0x4e, 0xdf, 0x07, 0x78, 0xfe, 0x64, 0x98, 0x92, 0xf1, 0xe9, 0x75,
      0x01, 0x10, 0xad, 0xde, 0x7e, 0x36, 0x06, 0xf3, 0x25, 0x51, 0x53, 0x38,
      0x45, 0xa5, 0xc4, 0x54, 0x53, 0xe9, 0xc1, 0x7d, 0x4b, 0x81, 0x2d, 0xed,
      0x1c, 0x9c, 0xcb, 0xa7, 0x02, 0xa1, 0xd2, 0x14, 0x8c, 0x64, 0x54, 0x7f,
      0x6b, 0x53, 0xb8, 0xcd, 0xf8, 0x54, 0xb9, 0xfc, 0x9e, 0xc4, 0x93, 0xc5,
      0x28, 0x30, 0xd7, 0x69},
     pub_key_1,
     {0x39, 0x36, 0x37, 0x38, 0x37, 0x38, 0x31, 0x30, 0x39, 0x34},
     true},

    // Comment:
    // tcID: 45
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     45,
     32,
     {0x5e, 0xa7, 0x7a, 0x29, 0x8d, 0x24, 0x68, 0x29, 0x62, 0x74, 0x6d, 0x11,
      0xdc, 0x54, 0xc1, 0x38, 0xa7, 0x9a, 0xda, 0x1c, 0x4e, 0x14, 0x31, 0xbd,
      0x06, 0xba, 0xd9, 0x7a, 0xc4, 0xd0, 0x42, 0x4a, 0x50, 0x0b, 0x75, 0x32,
      0xa3, 0x54, 0x0b, 0x65, 0x7f, 0x93, 0x4a, 0x72, 0x32, 0xf9, 0x88, 0xee,
      0x65, 0x9c, 0x02, 0x43, 0x33, 0x7d, 0x7a, 0xaa, 0xd5, 0x34, 0xbf, 0x15,
      0xea, 0xac, 0x57, 0x35, 0x14, 0x4c, 0xff, 0xda, 0x19, 0xe9, 0x65, 0x99,
      0xf1, 0xd1, 0xe1, 0xe1, 0x87, 0xda, 0x6d, 0xa5, 0xfb, 0xe2, 0xf9, 0xce,
      0x7c, 0x12, 0x40, 0xa3, 0xd2, 0xaa, 0xa3, 0xc6, 0x39, 0xc5, 0xeb, 0x8e,
      0xdb, 0xbe, 0x4e, 0xaf, 0x69, 0xae, 0x8d, 0xf4, 0x52, 0x86, 0xf8, 0x5d,
      0xac, 0x27, 0xee, 0xd1, 0x62, 0xa8, 0x7f, 0x71, 0xdc, 0xd4, 0xe7, 0x0a,
      0x99, 0x60, 0xe7, 0x06, 0xe6, 0xa4, 0xe3, 0xb5, 0xc5, 0xaf, 0xe0, 0x0d,
      0x74, 0x1a, 0x97, 0x41, 0x8e, 0x89, 0xf0, 0xf3, 0xbc, 0x44, 0x13, 0x7f,
      0x06, 0x93, 0x5c, 0x76, 0x7b, 0xb0, 0x43, 0x38, 0xa3, 0xde, 0xc5, 0x91,
      0x73, 0x51, 0xc6, 0x52, 0x51, 0xd7, 0x4a, 0xf5, 0xe5, 0x69, 0x82, 0x48,
      0xeb, 0x49, 0x8d, 0xcf, 0xdf, 0x49, 0x8a, 0xae, 0x03, 0xea, 0x8c, 0xc8,
      0x85, 0x93, 0xb9, 0x8b, 0x34, 0x98, 0x84, 0x17, 0xba, 0x69, 0x7b, 0xdf,
      0xd4, 0x19, 0x00, 0x12, 0x16, 0xe5, 0x7b, 0x18, 0x27, 0x81, 0xd0, 0x7d,
      0x3a, 0xfd, 0x03, 0x71, 0xe1, 0xde, 0x64, 0x00, 0x4f, 0xaf, 0xa5, 0x38,
      0xc0, 0x1e, 0x60, 0x40, 0x92, 0x6b, 0xb1, 0x93, 0xc3, 0x4f, 0x3b, 0xa8,
      0x20, 0x33, 0x1f, 0x8f, 0xce, 0xef, 0xd8, 0x7e, 0x78, 0xfa, 0x09, 0xb0,
      0x7a, 0xfd, 0x0d, 0x11, 0x69, 0x93, 0xec, 0x54, 0x9c, 0xb3, 0xb7, 0xf1,
      0x04, 0x3c, 0xa6, 0x05},
     pub_key_1,
     {0x34, 0x39, 0x35, 0x38, 0x38, 0x32, 0x33, 0x38, 0x32, 0x33},
     true},

    // Comment:
    // tcID: 46
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     46,
     32,
     {0x65, 0x67, 0xfa, 0x3a, 0x97, 0x6c, 0x47, 0x25, 0x55, 0xe4, 0x54, 0x72,
      0xbb, 0x8a, 0x6e, 0xcf, 0xec, 0x7e, 0x0e, 0x80, 0xe8, 0x02, 0xd5, 0x8b,
      0xa5, 0x3a, 0x25, 0x56, 0x69, 0x10, 0x1d, 0x3d, 0x36, 0x2e, 0x64, 0xcc,
      0x34, 0x60, 0x94, 0x2d, 0x61, 0xfb, 0xe6, 0x17, 0x77, 0x2d, 0x38, 0x1d,
      0xd3, 0x45, 0xb7, 0x3f, 0x4b, 0xd3, 0x76, 0x73, 0x37, 0x58, 0x23, 0x80,
      0x1b, 0xfc, 0x6d, 0x1b, 0xea, 0x2e, 0x0e, 0x9c, 0xce, 0x5e, 0x60, 0x7a,
      0xfc, 0x3e, 0x66, 0xc3, 0xda, 0x25, 0xcb, 0x29, 0xe2, 0x33, 0x59, 0xcd,
      0x93, 0x62, 0x6e, 0xfc, 0xff, 0x1e, 0x9e, 0x79, 0xb0, 0xa7, 0xce, 0xdb,
      0x75, 0xba, 0xdb, 0x69, 0xe1, 0x0a, 0x0c, 0xc0, 0x9e, 0x26, 0xb3, 0x68,
      0x4e, 0xa1, 0x1e, 0x3c, 0x43, 0xd3, 0xaf, 0x04, 0x0d, 0xa8, 0x7c, 0xce,
      0x5b, 0x1e, 0x30, 0xbd, 0xbd, 0xcd, 0xc7, 0xbd, 0xfe, 0xbb, 0xe5, 0xbe,
      0x55, 0x42, 0xe1, 0x8b, 0x62, 0x93, 0x5b, 0x0c, 0x2b, 0xf8, 0xb3, 0xcf,
      0x25, 0x07, 0xaa, 0xf2, 0xbe, 0xd2, 0x09, 0xbf, 0x4e, 0x7f, 0xab, 0x1f,
      0xcd, 0xee, 0xd4, 0x7c, 0x9f, 0x7e, 0x2b, 0x0d, 0xd2, 0xe4, 0xb0, 0xb8,
      0xd3, 0xb2, 0xba, 0xd9, 0x36, 0x8f, 0x58, 0xc6, 0xde, 0x0c, 0xe6, 0x1e,
      0xee, 0xfb, 0x9b, 0x3b, 0x98, 0xdc, 0xfe, 0x78, 0x81, 0xe8, 0x1e, 0x67,
      0xe8, 0xe8, 0x90, 0x8a, 0x6c, 0x71, 0x01, 0x1f, 0xf6, 0x9c, 0xe2, 0x1f,
      0xcc, 0x31, 0x39, 0x8a, 0x99, 0x80, 0x4c, 0x9a, 0xb4, 0x8f, 0x50, 0xbc,
      0xbc, 0xa8, 0x01, 0x04, 0xa8, 0xb6, 0x7a, 0x80, 0x03, 0x88, 0x0c, 0xdc,
      0xb1, 0x14, 0xc1, 0x32, 0x55, 0xd7, 0xb1, 0xd1, 0xdc, 0xd7, 0xf0, 0x8a,
      0xee, 0xaa, 0xd0, 0x66, 0x37, 0xaa, 0xa0, 0x51, 0xcb, 0x0e, 0xaf, 0xfa,
      0xd2, 0x42, 0x0d, 0xf4},
     pub_key_1,
     {0x38, 0x32, 0x34, 0x36, 0x33, 0x37, 0x38, 0x33, 0x37},
     true},

    // Comment:
    // tcID: 47
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     47,
     32,
     {0x74, 0x2e, 0x9b, 0xee, 0x46, 0x2e, 0xec, 0xfe, 0xf3, 0xe7, 0xa0, 0x5d,
      0x24, 0xc4, 0x98, 0x25, 0x9e, 0x56, 0xc5, 0xbd, 0xb9, 0xd0, 0xa5, 0x2a,
      0xaa, 0x24, 0xe0, 0x7d, 0x68, 0xc9, 0xef, 0xdc, 0xd6, 0x4d, 0xfa, 0x5d,
      0x3d, 0x44, 0xce, 0x73, 0xc1, 0x97, 0x18, 0x8a, 0x91, 0x68, 0xec, 0x7a,
      0xad, 0xa0, 0x5a, 0x3a, 0xaf, 0xb8, 0xd3, 0xe8, 0xc4, 0x5b, 0x2d, 0x20,
      0x94, 0xf2, 0xb2, 0xf9, 0xdf, 0x61, 0x25, 0xe9, 0xf0, 0xa5, 0xc1, 0x29,
      0xf3, 0x3d, 0xb1, 0x38, 0x7d, 0xfa, 0xf7, 0x72, 0x4c, 0xfd, 0x54, 0x8f,
      0x08, 0xa9, 0x45, 0x93, 0x89, 0x35, 0x58, 0xc3, 0x4d, 0x9e, 0x66, 0xd3,
      0x31, 0xbb, 0x07, 0x19, 0xfc, 0x73, 0x15, 0x22, 0x41, 0xf3, 0xe3, 0x05,
      0xd1, 0xa7, 0x60, 0x43, 0x28, 0xc1, 0x2e, 0x65, 0xbe, 0x34, 0x2c, 0x0f,
      0x49, 0xd0, 0x65, 0x0e, 0x4b, 0x32, 0xbd, 0x8d, 0xb6, 0x5b, 0x86, 0x74,
      0xc3, 0x28, 0x45, 0x49, 0xd4, 0xb6, 0x85, 0x3d, 0xb3, 0x20, 0xca, 0xb0,
      0xd0, 0x19, 0x28, 0x7a, 0x8a, 0xfa, 0xf2, 0x48, 0x6d, 0x74, 0x9b, 0x8b,
      0xbd, 0xd8, 0x03, 0x78, 0x45, 0x51, 0x12, 0xd5, 0xd5, 0x42, 0x65, 0xc5,
      0xe9, 0x4c, 0xc3, 0xde, 0xba, 0xac, 0x80, 0xa6, 0xe3, 0xf0, 0xba, 0x47,
      0xe5, 0x83, 0x11, 0xbd, 0x0f, 0x04, 0x07, 0xac, 0x90, 0xb3, 0x5d, 0x66,
      0xa8, 0xaa, 0x43, 0x2f, 0x7b, 0xc5, 0x9c, 0xf0, 0xf6, 0xff, 0x13, 0x48,
      0x52, 0xa3, 0x3f, 0x99, 0x7a, 0x24, 0xc7, 0x37, 0x81, 0x7c, 0x90, 0xc8,
      0x9b, 0x22, 0xcf, 0x31, 0x3d, 0x30, 0xd9, 0xb9, 0xda, 0xde, 0x41, 0x37,
      0x1f, 0x8d, 0x6a, 0xbe, 0xc6, 0x3a, 0x8e, 0x01, 0x53, 0x2b, 0x4d, 0x4c,
      0x50, 0x4f, 0xc4, 0xe7, 0x8a, 0xba, 0xbd, 0xf3, 0x25, 0x97, 0x0f, 0x4d,
      0xc6, 0x17, 0xe4, 0xd1},
     pub_key_1,
     {0x31, 0x31, 0x30, 0x32, 0x30, 0x38, 0x33, 0x33, 0x37, 0x37, 0x36},
     true},

    // Comment:
    // tcID: 48
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     48,
     32,
     {0x25, 0x07, 0x37, 0x3f, 0x2b, 0x7f, 0x35, 0xf5, 0x8d, 0x9e, 0xa3, 0x1c,
      0xad, 0xe4, 0x82, 0xf1, 0x3a, 0x06, 0x6f, 0x4d, 0xc8, 0x9f, 0x38, 0xa9,
      0x35, 0x9f, 0x5c, 0x6a, 0xdb, 0x8b, 0x41, 0x19, 0xf0, 0xa6, 0x2f, 0xad,
      0x11, 0x44, 0x17, 0x43, 0x1a, 0x64, 0x08, 0x86, 0x9a, 0x23, 0x31, 0x38,
      0x6d, 0xce, 0xde, 0x69, 0x67, 0xfc, 0xe3, 0x0a, 0x06, 0x21, 0x6f, 0x14,
      0x64, 0xb2, 0xa8, 0x6f, 0x13, 0x0b, 0x4e, 0xb6, 0x4e, 0xe6, 0x3e, 0xde,
      0x48, 0x96, 0x87, 0xc8, 0x2d, 0x57, 0x8c, 0x33, 0x04, 0x6f, 0x65, 0x30,
      0xb1, 0xf2, 0x7d, 0x65, 0xd0, 0x26, 0xf9, 0x49, 0x84, 0x09, 0xfc, 0x84,
      0x58, 0xf7, 0xaa, 0x60, 0x32, 0xd6, 0x4f, 0x69, 0x2c, 0x16, 0x3d, 0xae,
      0xae, 0x12, 0x4b, 0x2e, 0xf8, 0x79, 0xc5, 0x36, 0x0d, 0x78, 0x98, 0x53,
      0x27, 0xfb, 0x6f, 0x20, 0xdb, 0x8c, 0xcc, 0xc3, 0x2e, 0xde, 0x88, 0x23,
      0xed, 0x05, 0x31, 0x3e, 0x4a, 0x3c, 0xc7, 0x78, 0x4e, 0xa0, 0x29, 0xa4,
      0x2b, 0x11, 0x0d, 0x07, 0x18, 0x63, 0x38, 0xe9, 0xad, 0xcf, 0xee, 0x27,
      0x82, 0x6d, 0x04, 0x15, 0x0e, 0x5d, 0x81, 0xbb, 0x02, 0xcb, 0x1a, 0x5d,
      0x7a, 0x09, 0x50, 0x68, 0x8f, 0x21, 0x3a, 0x95, 0x5e, 0xf2, 0x70, 0x3a,
      0x3d, 0xd4, 0x70, 0x2a, 0xbc, 0xdb, 0x6a, 0x9e, 0xa8, 0x5a, 0x6c, 0x76,
      0x4b, 0xa6, 0x27, 0xaf, 0xa3, 0x54, 0xdd, 0xd9, 0x8d, 0x21, 0x08, 0xa0,
      0x5b, 0xdc, 0x3f, 0x6d, 0x47, 0x40, 0xab, 0x24, 0xf2, 0xdc, 0x30, 0x6c,
      0x1e, 0xd9, 0xa5, 0x5f, 0xe7, 0x24, 0x50, 0x7a, 0xd5, 0x18, 0x55, 0xfc,
      0x82, 0xb8, 0x6e, 0xe6, 0x00, 0x0e, 0xef, 0x49, 0x91, 0x80, 0x00, 0x38,
      0x1f, 0x71, 0x7e, 0x12, 0xb6, 0xa6, 0x94, 0x2f, 0xeb, 0x13, 0x13, 0xca,
      0xc5, 0x25, 0x71, 0x2e},
     pub_key_1,
     {0x31, 0x33, 0x33, 0x38, 0x37, 0x31, 0x36, 0x34, 0x38},
     true},

    // Comment:
    // tcID: 49
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     49,
     32,
     {0x82, 0xd4, 0xd4, 0xac, 0xff, 0x7b, 0xdb, 0x07, 0x3c, 0x4f, 0x92, 0x30,
      0xb8, 0x1f, 0x91, 0x0f, 0xd9, 0x19, 0xdd, 0x1f, 0x87, 0x95, 0xe7, 0xa6,
      0xe8, 0xbb, 0x3b, 0x96, 0x8b, 0xf9, 0x2f, 0xb2, 0xd6, 0x2b, 0x59, 0x20,
      0x80, 0xc3, 0xbc, 0x6e, 0x3b, 0xcb, 0xc1, 0x43, 0x3a, 0x2f, 0x3b, 0xb4,
      0xf1, 0x54, 0x8e, 0x78, 0xad, 0x86, 0xba, 0x9e, 0x7c, 0xd1, 0xf1, 0x1b,
      0x03, 0x17, 0xef, 0xf4, 0xc3, 0xe7, 0xea, 0xc7, 0x9b, 0xfb, 0xf1, 0x5b,
      0xfd, 0x38, 0x96, 0xb5, 0x37, 0xaf, 0xdd, 0x3f, 0x41, 0x01, 0x1c, 0xeb,
      0x71, 0x6e, 0xdb, 0x7c, 0xf6, 0x3f, 0x5d, 0xb7, 0x74, 0xc3, 0xf5, 0x06,
      0x55, 0xb1, 0x3e, 0x5c, 0x58, 0x76, 0x06, 0xeb, 0xd6, 0x00, 0x4e, 0xdc,
      0x16, 0x9b, 0x68, 0x02, 0x42, 0x5e, 0x20, 0xa3, 0x82, 0xe2, 0x4e, 0x54,
      0xf7, 0x7c, 0xf4, 0xb6, 0xad, 0xf0, 0xe8, 0x56, 0x8c, 0xf2, 0xc8, 0xb5,
      0x88, 0xbe, 0xe5, 0xff, 0xcf, 0xc9, 0x01, 0x7e, 0x67, 0xaa, 0xbe, 0x73,
      0x16, 0x53, 0x04, 0xe8, 0x83, 0x63, 0x51, 0x82, 0xd1, 0x9f, 0x48, 0x95,
      0x96, 0xf7, 0xe9, 0x07, 0x9c, 0x26, 0xfa, 0x97, 0xad, 0x9e, 0x02, 0xee,
      0x41, 0x71, 0x71, 0x79, 0xbc, 0x0c, 0xa3, 0xb3, 0x80, 0xf9, 0xe6, 0x39,
      0x05, 0x2a, 0xc3, 0x60, 0x85, 0x14, 0xa2, 0x35, 0x38, 0x7b, 0x59, 0x3f,
      0xd6, 0x47, 0x0a, 0x3a, 0xee, 0x56, 0xf9, 0xb8, 0xd7, 0x3b, 0x57, 0x07,
      0xce, 0xb6, 0xf6, 0xc9, 0x26, 0xec, 0xc4, 0xb8, 0xed, 0x9c, 0xd7, 0x5b,
      0x8d, 0x9a, 0x89, 0x31, 0xf7, 0x22, 0x51, 0xe3, 0x66, 0x41, 0x53, 0x72,
      0xfa, 0x8f, 0xbc, 0xce, 0x42, 0xd7, 0x7c, 0x35, 0x3c, 0xa9, 0x26, 0xfb,
      0x3f, 0x12, 0xf6, 0x05, 0x43, 0x11, 0x1c, 0xbd, 0xbd, 0xb1, 0x84, 0x23,
      0x82, 0xfa, 0xd2, 0x5a},
     pub_key_1,
     {0x33, 0x32, 0x32, 0x31, 0x34, 0x34, 0x31, 0x36, 0x32},
     true},

    // Comment:
    // tcID: 50
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     50,
     32,
     {0x7b, 0xe5, 0x86, 0x16, 0x00, 0xd3, 0x19, 0x6b, 0xd6, 0x12, 0x41, 0x61,
      0xc3, 0x27, 0x2a, 0xb3, 0x61, 0x67, 0xb4, 0x13, 0x7b, 0x07, 0x05, 0xb6,
      0x48, 0xe9, 0x3c, 0xb9, 0xca, 0xd8, 0xa4, 0xbe, 0x37, 0x10, 0x7b, 0x2a,
      0xb4, 0x49, 0xf4, 0x21, 0xfd, 0x57, 0xa5, 0x5b, 0xc3, 0xfe, 0x9c, 0x6f,
      0xb6, 0xb8, 0x29, 0xdd, 0x6d, 0x6f, 0xcb, 0xe8, 0x8e, 0xec, 0xa9, 0xbb,
      0x93, 0x43, 0x37, 0x64, 0xfd, 0x0a, 0x88, 0x11, 0x31, 0x55, 0xa6, 0x7a,
      0x5f, 0xb5, 0x14, 0xfb, 0x21, 0x01, 0x37, 0x2e, 0x6d, 0xcf, 0xe9, 0x34,
      0x1c, 0x95, 0x38, 0xd8, 0x67, 0x34, 0x72, 0xa0, 0xe7, 0x5c, 0x02, 0x8c,
      0xcd, 0xa4, 0xaa, 0x2e, 0x10, 0xf7, 0x93, 0xcd, 0x0e, 0x10, 0x16, 0x21,
      0x67, 0xa9, 0x8c, 0x9b, 0xf6, 0x88, 0x0a, 0x78, 0x65, 0x1f, 0x77, 0x77,
      0x4e, 0xb2, 0x03, 0x39, 0xf3, 0x96, 0x8e, 0x9c, 0xfa, 0xb7, 0x4d, 0xac,
      0x22, 0x61, 0xde, 0xd1, 0x11, 0xc0, 0x47, 0xcc, 0xb1, 0x87, 0xe1, 0x1d,
      0xdf, 0x25, 0x5d, 0x36, 0x95, 0xe2, 0x51, 0x92, 0x86, 0x3d, 0x63, 0x22,
      0x57, 0x44, 0x4d, 0x5e, 0x46, 0x9f, 0xcf, 0x0e, 0xd8, 0x8f, 0xdc, 0x95,
      0x4e, 0xe9, 0x41, 0x64, 0xd7, 0x02, 0x18, 0xef, 0x03, 0x3c, 0xc5, 0x98,
      0xba, 0x97, 0x4d, 0x8a, 0x53, 0xbc, 0xbd, 0x01, 0xde, 0x33, 0x3d, 0x4e,
      0x18, 0x5f, 0xaf, 0x85, 0xb8, 0x6a, 0xcf, 0xf6, 0x5b, 0x29, 0xf1, 0x5d,
      0x97, 0x32, 0x1d, 0xdc, 0x21, 0xf9, 0xaf, 0xac, 0xca, 0x67, 0x4e, 0xcc,
      0xce, 0x7f, 0xce, 0x12, 0x87, 0xba, 0x50, 0x8c, 0xc2, 0xa5, 0x5c, 0x53,
      0x4a, 0x2c, 0x5d, 0x67, 0x8b, 0x92, 0xb8, 0x6d, 0xd0, 0x2d, 0xe6, 0x41,
      0x68, 0x4c, 0x7c, 0x8b, 0x0f, 0x14, 0x86, 0x3c, 0xfa, 0xec, 0x3d, 0x7e,
      0xb8, 0x43, 0x04, 0x86},
     pub_key_1,
     {0x31, 0x30, 0x36, 0x38, 0x36, 0x36, 0x35, 0x35, 0x35, 0x34, 0x36},
     true},

    // Comment:
    // tcID: 51
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     51,
     32,
     {0x60, 0x24, 0x40, 0xab, 0xa9, 0xa9, 0xad, 0xd4, 0x71, 0x65, 0x55, 0xfd,
      0xa1, 0xdb, 0xc6, 0xa9, 0x34, 0x22, 0x4c, 0x6b, 0x76, 0x24, 0x33, 0x48,
      0x5e, 0x16, 0x06, 0x20, 0xfe, 0xe1, 0x60, 0x7e, 0x90, 0x79, 0xeb, 0x26,
      0x5d, 0xdb, 0xbf, 0xaf, 0x75, 0xfa, 0x26, 0x6b, 0x19, 0xd7, 0x52, 0xb7,
      0x72, 0x1d, 0x4e, 0xa5, 0x20, 0x3e, 0xe2, 0xdc, 0xa8, 0x40, 0xf0, 0x78,
      0xda, 0xd7, 0x51, 0x7e, 0xa2, 0x39, 0x21, 0x42, 0xe4, 0xa9, 0x08, 0x64,
      0x01, 0xbc, 0x3f, 0xf1, 0x9e, 0xd5, 0xb7, 0x62, 0x83, 0x90, 0xb0, 0x17,
      0x5b, 0xc9, 0x82, 0x66, 0x8f, 0xc8, 0x6e, 0x2f, 0xab, 0x33, 0xac, 0xf1,
      0x7f, 0x3a, 0xc2, 0x29, 0xd1, 0x2a, 0xb7, 0xcd, 0xc2, 0x9f, 0xfb, 0x98,
      0x64, 0x96, 0x69, 0xae, 0x3e, 0x64, 0x43, 0xd0, 0x91, 0x6b, 0x61, 0x14,
      0x89, 0xc9, 0x64, 0x2d, 0x35, 0x6c, 0xa1, 0xbf, 0xd3, 0xae, 0xe3, 0x5d,
      0x96, 0xbf, 0x9b, 0xc7, 0xa9, 0xb6, 0x73, 0x4b, 0xe5, 0xf7, 0x7f, 0x96,
      0xdd, 0xf2, 0xb9, 0xcb, 0x36, 0x66, 0x50, 0x61, 0x9c, 0x53, 0xdc, 0x5b,
      0x5b, 0xea, 0xdc, 0x7d, 0x58, 0x15, 0xe7, 0xb3, 0x6b, 0x58, 0xf3, 0xce,
      0xde, 0x2d, 0x47, 0xff, 0x22, 0x8c, 0xac, 0xce, 0x27, 0x89, 0xb8, 0xd8,
      0x75, 0xed, 0xae, 0xf9, 0xb0, 0x91, 0x9b, 0xdc, 0xcb, 0x9c, 0xf9, 0x0a,
      0x7b, 0x5e, 0xb4, 0xe7, 0xb9, 0x96, 0x21, 0x5c, 0x94, 0x3c, 0x01, 0x7e,
      0x24, 0xd1, 0xf2, 0xad, 0x8c, 0x3b, 0xd8, 0x44, 0x66, 0x8d, 0x0d, 0xeb,
      0x56, 0x6d, 0x58, 0x7e, 0x37, 0x8c, 0x38, 0xd5, 0x47, 0xf8, 0xaa, 0x47,
      0x34, 0x65, 0xfa, 0xde, 0xc8, 0x62, 0x4f, 0xdf, 0xf1, 0xf9, 0x80, 0xc9,
      0x50, 0x6c, 0xa1, 0x2e, 0xb9, 0x99, 0xf2, 0xb8, 0xf1, 0x8f, 0x0f, 0x5c,
      0x9b, 0x2b, 0xf4, 0x60},
     pub_key_1,
     {0x36, 0x32, 0x31, 0x35, 0x35, 0x32, 0x34, 0x36},
     true},

    // Comment:
    // tcID: 52
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     52,
     32,
     {0x1b, 0xf6, 0x5b, 0x12, 0x5c, 0xcf, 0x21, 0xec, 0x88, 0x94, 0x57, 0x6b,
      0xb4, 0x66, 0x2a, 0x39, 0xea, 0x4e, 0x34, 0xe3, 0xbd, 0xa2, 0xca, 0x48,
      0x71, 0x8c, 0x56, 0x71, 0x9d, 0x1e, 0xc0, 0xd9, 0xa0, 0x64, 0x5d, 0x06,
      0x44, 0x0c, 0x2d, 0xbe, 0x96, 0xb1, 0xf8, 0x5f, 0xd2, 0x02, 0x06, 0xb0,
      0x01, 0x27, 0x9a, 0xd2, 0x73, 0xe1, 0xa6, 0x56, 0xb5, 0x54, 0xfe, 0xca,
      0xb0, 0x3d, 0x58, 0x8a, 0xaf, 0xa8, 0xcb, 0xe9, 0x57, 0xa5, 0xd5, 0x8c,
      0x97, 0x6f, 0x85, 0xff, 0xfb, 0xe1, 0x55, 0xba, 0xcf, 0x78, 0xf7, 0xa3,
      0x97, 0x88, 0x02, 0x7a, 0x1c, 0xbd, 0xe3, 0xc0, 0x1c, 0x79, 0x57, 0xf6,
      0xbd, 0x2b, 0x97, 0x08, 0xac, 0x5d, 0x66, 0x11, 0xa8, 0x2e, 0x43, 0xf1,
      0x36, 0x3f, 0x72, 0xec, 0xf4, 0x58, 0x3a, 0x32, 0xc9, 0xc8, 0x87, 0xff,
      0x5a, 0xf1, 0xa7, 0x0b, 0x0f, 0x08, 0x15, 0xdb, 0x3d, 0x89, 0xf6, 0xdb,
      0xa2, 0xf0, 0x6c, 0xbc, 0xb1, 0x9c, 0xfc, 0x49, 0x85, 0x1b, 0x02, 0x20,
      0x83, 0x28, 0x09, 0xa1, 0x58, 0xae, 0x9a, 0x8a, 0xa4, 0x50, 0x88, 0x80,
      0xf1, 0x16, 0x9a, 0x30, 0x1e, 0x70, 0x96, 0xab, 0x74, 0xdd, 0x44, 0x77,
      0xb3, 0xf1, 0xb6, 0x24, 0x2f, 0x8b, 0xc6, 0x59, 0x1e, 0x61, 0xbb, 0x46,
      0xd8, 0x71, 0xef, 0xa0, 0xb7, 0x48, 0x36, 0xfc, 0xde, 0xcf, 0x37, 0x1c,
      0x04, 0xcf, 0x78, 0x6c, 0x98, 0x99, 0xd8, 0xc0, 0xcb, 0x47, 0xac, 0xb6,
      0x79, 0x03, 0x27, 0xf6, 0xb4, 0xed, 0xcc, 0xe4, 0xb1, 0xff, 0x65, 0x1f,
      0xba, 0x61, 0xc4, 0x44, 0x2a, 0xe3, 0xe4, 0xd9, 0xa2, 0x36, 0x01, 0xca,
      0x8f, 0x8a, 0xea, 0x8c, 0x60, 0x55, 0xc3, 0xb1, 0xca, 0xe8, 0xfe, 0x4b,
      0x50, 0x67, 0x71, 0xa4, 0xb1, 0x5e, 0xc8, 0xd2, 0xc1, 0xd1, 0x41, 0xdc,
      0xed, 0x2d, 0x90, 0x8a},
     pub_key_1,
     {0x37, 0x30, 0x33, 0x30, 0x38, 0x31, 0x38, 0x37, 0x37, 0x34},
     true},

    // Comment:
    // tcID: 53
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     53,
     32,
     {0x9f, 0xb1, 0x19, 0xff, 0xba, 0xea, 0xb1, 0xf3, 0x38, 0xeb, 0x3c, 0x8d,
      0xb5, 0xaf, 0xf1, 0xe1, 0x33, 0x10, 0x17, 0x2c, 0xfb, 0x7b, 0x97, 0x73,
      0x62, 0x0a, 0x9f, 0xb6, 0xe8, 0x45, 0x4f, 0x02, 0x98, 0x40, 0xc8, 0x8a,
      0xe4, 0xf3, 0x3f, 0x85, 0x55, 0x8a, 0x82, 0xa9, 0xb9, 0xbc, 0x2b, 0x9a,
      0xa4, 0xce, 0x6d, 0x49, 0xf5, 0x34, 0x3f, 0x79, 0x01, 0x1f, 0x67, 0xf2,
      0xc2, 0xf4, 0x6e, 0xc7, 0xb7, 0x87, 0x29, 0x9b, 0x8f, 0xb9, 0xd0, 0xc4,
      0x6a, 0x18, 0xac, 0xce, 0x35, 0x30, 0xc9, 0xb8, 0x81, 0x53, 0x02, 0x29,
      0x64, 0xd8, 0x7d, 0xfd, 0xbf, 0xa7, 0x47, 0x94, 0xf5, 0x06, 0x7a, 0x39,
      0xbf, 0x3e, 0x44, 0x5c, 0xce, 0xd3, 0x58, 0xbf, 0x57, 0xbb, 0xc4, 0x5b,
      0x7a, 0x29, 0xe5, 0x50, 0xb5, 0xfb, 0xdc, 0x0a, 0xa9, 0x1d, 0x1b, 0x4d,
      0xb7, 0x4b, 0x11, 0xd9, 0x9e, 0x99, 0x5b, 0xa2, 0xe1, 0xac, 0x76, 0xc0,
      0xfb, 0xa4, 0x96, 0xfa, 0x95, 0x01, 0x6b, 0x8c, 0x95, 0x44, 0x10, 0x53,
      0x28, 0xb1, 0x4b, 0x3a, 0x3f, 0x1c, 0xd4, 0x53, 0x14, 0xab, 0x67, 0xdd,
      0x87, 0x58, 0xdf, 0x4d, 0x4e, 0x66, 0xa0, 0x1d, 0xc8, 0x9d, 0xc5, 0x41,
      0xe9, 0xd4, 0x6f, 0xee, 0xc6, 0xd1, 0x46, 0x98, 0x46, 0xc7, 0x78, 0xd8,
      0x89, 0x3d, 0x39, 0xa3, 0x37, 0xd3, 0x17, 0xf6, 0x6e, 0xd7, 0x72, 0x51,
      0x96, 0xaf, 0x6e, 0x87, 0x8d, 0x53, 0x66, 0x3e, 0x05, 0xb8, 0xc6, 0xea,
      0x21, 0x52, 0x64, 0xd2, 0xc8, 0x97, 0x42, 0x4a, 0xf9, 0xc3, 0x0a, 0xee,
      0x50, 0x21, 0x08, 0x6b, 0x6c, 0xb6, 0xdb, 0x4b, 0xbe, 0x27, 0xbd, 0xa9,
      0x9e, 0x92, 0x94, 0x69, 0xdf, 0x91, 0x92, 0xbb, 0xdf, 0xdb, 0xa5, 0x72,
      0x86, 0x4b, 0x15, 0xf4, 0x68, 0x91, 0x6f, 0x25, 0xf7, 0xbb, 0x87, 0xd3,
      0xd0, 0x2f, 0x39, 0xc2},
     pub_key_1,
     {0x35, 0x39, 0x32, 0x34, 0x35, 0x32, 0x33, 0x37, 0x34, 0x34},
     true},

    // Comment:
    // tcID: 54
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     54,
     32,
     {0x77, 0x59, 0x0c, 0x14, 0x37, 0xb5, 0x65, 0x7d, 0x4d, 0xf3, 0x85, 0xc0,
      0xc6, 0x39, 0xe0, 0xe4, 0xee, 0xcf, 0x14, 0xdf, 0x26, 0xe8, 0x9d, 0x67,
      0x30, 0x33, 0x94, 0x4c, 0x59, 0x38, 0xbb, 0x6b, 0x17, 0x72, 0xb5, 0xa9,
      0xae, 0xfd, 0xf9, 0x1c, 0x19, 0x64, 0x1c, 0x1f, 0xdc, 0xa9, 0x88, 0x36,
      0xbe, 0xa1, 0xdc, 0x82, 0x19, 0xc0, 0x1e, 0xdc, 0x9e, 0xac, 0x96, 0xaf,
      0xa2, 0xf0, 0x45, 0x87, 0xb7, 0x6e, 0x85, 0x28, 0x7f, 0x78, 0x51, 0x8c,
      0xf3, 0xfb, 0xe1, 0xe8, 0x4a, 0xb5, 0x74, 0xa9, 0x35, 0x8c, 0x1b, 0x0a,
      0xe3, 0xf5, 0xa8, 0x43, 0x38, 0x2f, 0xaa, 0xd1, 0x6d, 0x0a, 0x7f, 0x58,
      0xa7, 0xfd, 0x73, 0x86, 0x8e, 0x4a, 0xc2, 0xdf, 0xa5, 0x7f, 0x8b, 0xa6,
      0x92, 0x73, 0x4a, 0x68, 0x9f, 0xc0, 0xb4, 0xeb, 0x27, 0x0a, 0x42, 0x5a,
      0x69, 0xfd, 0x3d, 0xfc, 0xa7, 0xfa, 0x30, 0xe0, 0x99, 0x96, 0x68, 0x4d,
      0xbe, 0x7f, 0x95, 0x9d, 0xf6, 0x02, 0x56, 0x49, 0xc1, 0xb4, 0x5b, 0x06,
      0x97, 0x31, 0x5b, 0x98, 0xfd, 0x66, 0xe5, 0x87, 0xed, 0x09, 0xab, 0xd4,
      0x3f, 0x0c, 0xcf, 0x4d, 0xff, 0x7a, 0xd8, 0x3a, 0x8a, 0x29, 0xa7, 0x01,
      0xbe, 0x77, 0xff, 0x87, 0x98, 0x2c, 0x3b, 0x82, 0x8b, 0x48, 0x41, 0x0b,
      0x7b, 0xc2, 0x7a, 0xa0, 0x1d, 0x65, 0x9e, 0x88, 0xaa, 0xe6, 0xf0, 0x9d,
      0xdc, 0x3b, 0x22, 0x1f, 0xad, 0x15, 0x23, 0xf7, 0x2e, 0x08, 0x04, 0xf3,
      0x45, 0x18, 0xd2, 0x13, 0xc6, 0x5b, 0x47, 0xf2, 0x35, 0xfd, 0x62, 0x64,
      0x19, 0xed, 0xd0, 0xc9, 0x37, 0x34, 0xea, 0xf1, 0x1a, 0x91, 0xc0, 0xbf,
      0x8c, 0x4c, 0x3e, 0x7a, 0x9c, 0x95, 0xc8, 0xf6, 0x6f, 0x0a, 0x69, 0x0e,
      0x6d, 0x7e, 0xf7, 0x5b, 0x6b, 0xb3, 0x08, 0x0d, 0xb7, 0x5a, 0x8e, 0xcc,
      0x3b, 0xe8, 0x68, 0x53},
     pub_key_1,
     {0x31, 0x34, 0x39, 0x35, 0x35, 0x38, 0x36, 0x36, 0x32, 0x31},
     true},

    // Comment:
    // tcID: 55
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     55,
     32,
     {0x8c, 0xf0, 0x2d, 0x19, 0xd7, 0xdc, 0x5f, 0x00, 0xec, 0x29, 0x38, 0x22,
      0x0b, 0xf4, 0x00, 0xbe, 0xfa, 0x20, 0x44, 0xfd, 0x40, 0x33, 0xe8, 0x74,
      0xdd, 0xee, 0x5b, 0x9b, 0x1f, 0x71, 0x96, 0x1b, 0xb1, 0x51, 0xe6, 0x70,
      0x74, 0x3e, 0x36, 0xf1, 0x67, 0xe0, 0x2a, 0x8c, 0x49, 0xb2, 0x27, 0x93,
      0x0e, 0x23, 0x6e, 0x09, 0xce, 0xc2, 0x3d, 0xb4, 0x17, 0xec, 0xa1, 0x87,
      0x40, 0xf7, 0x8c, 0x75, 0x2e, 0x85, 0x87, 0x9c, 0x32, 0xc1, 0xb3, 0xe2,
      0x11, 0x39, 0xef, 0x92, 0x9e, 0x99, 0x14, 0x9f, 0xcb, 0x0e, 0xcf, 0x0e,
      0x33, 0x4f, 0x24, 0x24, 0x27, 0x80, 0x27, 0x3e, 0x9e, 0xf0, 0x89, 0x3d,
      0xf5, 0x89, 0x96, 0xbc, 0x15, 0x67, 0x79, 0xaf, 0xaa, 0xe7, 0xde, 0xa5,
      0x63, 0x28, 0x87, 0x5c, 0xd8, 0x5b, 0x03, 0x0c, 0x8b, 0x4c, 0xb4, 0xf4,
      0x66, 0xa8, 0x7c, 0x44, 0x99, 0x26, 0xd9, 0x13, 0x3f, 0x45, 0x2f, 0xf7,
      0x51, 0x0f, 0xdc, 0xdf, 0xd6, 0x6f, 0x0f, 0xca, 0x6e, 0x9d, 0x1a, 0x84,
      0xb2, 0xfb, 0x9a, 0x7d, 0x00, 0x18, 0x85, 0xf5, 0x2e, 0xd6, 0x3a, 0xee,
      0x3a, 0x22, 0x05, 0x99, 0x63, 0xdf, 0x11, 0xeb, 0x6a, 0x67, 0xf1, 0x10,
      0x30, 0xd2, 0x84, 0x1c, 0xdb, 0x90, 0xd3, 0xa0, 0x96, 0x73, 0x9f, 0x36,
      0xff, 0xed, 0x1e, 0xb5, 0x38, 0xc1, 0xb0, 0x95, 0xf8, 0x17, 0x2d, 0xfc,
      0xb1, 0xb5, 0xa3, 0x25, 0x46, 0x8f, 0x78, 0xa9, 0xba, 0x11, 0xe0, 0x28,
      0xe1, 0xfc, 0xa6, 0x77, 0x58, 0xee, 0x0f, 0x66, 0xa7, 0xc7, 0x00, 0x2f,
      0x9d, 0x4b, 0x31, 0x78, 0x4b, 0x93, 0xe9, 0x9e, 0x83, 0x8c, 0x44, 0xef,
      0xed, 0x88, 0x17, 0x56, 0xc5, 0x93, 0x47, 0x98, 0xb9, 0xb9, 0x34, 0xb7,
      0x51, 0xd4, 0x34, 0x36, 0x26, 0xff, 0xc6, 0x87, 0x56, 0x76, 0xf4, 0x37,
      0x30, 0x51, 0x35, 0x1d},
     pub_key_1,
     {0x34, 0x30, 0x30, 0x35, 0x33, 0x31, 0x34, 0x34, 0x30, 0x36},
     true},

    // Comment:
    // tcID: 56
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     56,
     32,
     {0x0e, 0x44, 0x38, 0x4d, 0x7e, 0x96, 0x52, 0x13, 0x40, 0xc9, 0xf0, 0x2a,
      0xe7, 0xe3, 0x20, 0x63, 0x6e, 0x68, 0x5e, 0x96, 0x57, 0x80, 0xe1, 0x91,
      0xf9, 0xb6, 0xb8, 0x9d, 0xf8, 0xc1, 0xc8, 0xf6, 0x80, 0x08, 0xc1, 0x69,
      0x1b, 0x3e, 0x70, 0x6e, 0x01, 0x59, 0x11, 0xb5, 0x19, 0xf0, 0x88, 0x13,
      0xbf, 0x8f, 0xa5, 0x37, 0x7e, 0x2e, 0xc2, 0xab, 0x85, 0x82, 0x37, 0xb9,
      0xdb, 0xd4, 0x58, 0xa2, 0x77, 0xe5, 0xe4, 0x2b, 0xae, 0x0e, 0x0d, 0xed,
      0x39, 0xf7, 0xc8, 0xc4, 0xf9, 0x5f, 0xef, 0x46, 0x04, 0x42, 0x17, 0xd2,
      0xe4, 0xa6, 0x46, 0x32, 0x74, 0x1c, 0x7b, 0x84, 0xe0, 0x06, 0x3a, 0x13,
      0xbe, 0x92, 0x38, 0x0a, 0x46, 0xfd, 0x43, 0xf6, 0x76, 0x4c, 0xef, 0xfb,
      0x5d, 0x8a, 0x32, 0xeb, 0x0b, 0xf3, 0xaf, 0x7a, 0xf9, 0xa3, 0xb4, 0xe0,
      0x7c, 0xe5, 0x62, 0x62, 0xa4, 0xea, 0x3e, 0xa2, 0xf3, 0xab, 0xd4, 0xa5,
      0xeb, 0x71, 0x84, 0x98, 0x20, 0x03, 0x1f, 0x61, 0x33, 0x5e, 0x4f, 0xb8,
      0x26, 0x9b, 0x9c, 0x20, 0x1c, 0x8f, 0x6c, 0xa6, 0x62, 0xd2, 0x2a, 0xe1,
      0xbc, 0x9b, 0x58, 0x34, 0xa2, 0x91, 0xca, 0xb8, 0x64, 0xc9, 0xac, 0xa7,
      0xe1, 0x12, 0x0d, 0xdc, 0xc6, 0x59, 0x7e, 0xfe, 0xe5, 0xfe, 0x3f, 0xf2,
      0xbc, 0x8f, 0x70, 0x7b, 0x65, 0x67, 0x60, 0x3b, 0x53, 0x6b, 0x8d, 0x17,
      0xd3, 0xf0, 0xf0, 0xbd, 0x9c, 0xe7, 0x4a, 0x53, 0x5c, 0x20, 0x12, 0xfa,
      0xf0, 0xb6, 0xbb, 0xba, 0x54, 0x4a, 0x37, 0x6a, 0xf3, 0x38, 0xf8, 0x25,
      0x16, 0x5b, 0xa3, 0x1b, 0xbc, 0x5f, 0x88, 0xfa, 0x86, 0xba, 0x8b, 0xac,
      0x02, 0xf4, 0x03, 0x5e, 0xae, 0xd4, 0x70, 0x8c, 0xe7, 0x97, 0x25, 0x63,
      0x27, 0x22, 0x96, 0x09, 0x7a, 0x13, 0x29, 0x68, 0xaa, 0x37, 0x03, 0x0a,
      0xf8, 0xe3, 0xc5, 0xe7},
     pub_key_1,
     {0x33, 0x30, 0x39, 0x36, 0x34, 0x35, 0x37, 0x35, 0x31, 0x32},
     true},

    // Comment:
    // tcID: 57
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     57,
     32,
     {0x90, 0x58, 0x01, 0xfa, 0x11, 0xf3, 0x06, 0x6c, 0x89, 0xd0, 0x97, 0x6a,
      0x30, 0x3f, 0x21, 0xf9, 0x7f, 0x04, 0x2d, 0xab, 0x01, 0x02, 0xa0, 0x66,
      0x76, 0x3d, 0xda, 0x90, 0x7a, 0xc8, 0x22, 0xa2, 0x3f, 0x9b, 0xb9, 0x9a,
      0x93, 0xda, 0xa2, 0xd4, 0x14, 0xdf, 0x4e, 0x71, 0x22, 0xf7, 0x4c, 0xde,
      0xae, 0x59, 0x70, 0xdc, 0x13, 0x2c, 0xd0, 0xff, 0x14, 0x1c, 0x56, 0x98,
      0xee, 0xcf, 0x43, 0xdc, 0x6e, 0xd1, 0xc9, 0x3e, 0xd6, 0xf6, 0xab, 0xf8,
      0xb5, 0xf0, 0x56, 0xf6, 0x74, 0xe9, 0x6d, 0xc9, 0xa6, 0x9e, 0x29, 0x35,
      0x10, 0x01, 0x95, 0x15, 0xde, 0xcf, 0x3c, 0x13, 0x96, 0xcd, 0x84, 0xf5,
      0xa8, 0xea, 0x6e, 0xb6, 0xa8, 0x2a, 0x91, 0x97, 0xdc, 0x8a, 0xf1, 0x8f,
      0xd4, 0x71, 0x5a, 0xe2, 0x4f, 0x06, 0x38, 0xed, 0xfc, 0xd1, 0xc1, 0x2c,
      0x5f, 0xba, 0xf6, 0xc7, 0xc9, 0xb2, 0x70, 0xe9, 0x18, 0x45, 0x7b, 0x3a,
      0xfb, 0x0b, 0x9a, 0x4b, 0xe1, 0xf2, 0x38, 0x41, 0x0e, 0x85, 0xbd, 0xd7,
      0x07, 0x2e, 0xd6, 0x84, 0xb1, 0xdb, 0x2d, 0x96, 0xe0, 0xaf, 0x02, 0xb7,
      0x38, 0x86, 0x24, 0x10, 0x71, 0x32, 0xc7, 0xe1, 0x20, 0x04, 0x1f, 0xdf,
      0x0b, 0xa4, 0x6a, 0x7f, 0x0c, 0x12, 0xe1, 0x8b, 0x8e, 0x72, 0xdc, 0xfa,
      0x1a, 0x29, 0x3c, 0xd3, 0x99, 0x89, 0x3e, 0x05, 0x30, 0x80, 0x77, 0x3a,
      0x5b, 0x9e, 0x70, 0x3e, 0x6d, 0x6b, 0xeb, 0xbf, 0xb8, 0x1f, 0xa2, 0x3d,
      0xa8, 0x14, 0x53, 0x29, 0xfd, 0xee, 0xeb, 0x72, 0xd6, 0x01, 0x30, 0xbf,
      0x05, 0x78, 0x39, 0xce, 0x75, 0x8c, 0xe6, 0x13, 0x6b, 0xc4, 0x67, 0xda,
      0xa8, 0xee, 0x8d, 0xc9, 0xd7, 0xcf, 0xdb, 0x96, 0x6a, 0x96, 0xbb, 0xae,
      0x15, 0xa3, 0x31, 0x67, 0xc1, 0x01, 0xf3, 0xfb, 0xdd, 0xc1, 0x64, 0xcd,
      0xc0, 0xe9, 0x4e, 0x04},
     pub_key_1,
     {0x32, 0x37, 0x38, 0x34, 0x30, 0x32, 0x35, 0x36, 0x32, 0x30},
     true},

    // Comment:
    // tcID: 58
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     58,
     32,
     {0x36, 0x6a, 0xb7, 0xae, 0x0f, 0xc2, 0x87, 0x53, 0xf7, 0xcc, 0x8e, 0x71,
      0x11, 0x39, 0x8b, 0x78, 0xc8, 0x32, 0x3d, 0xe7, 0x17, 0x7e, 0x51, 0xf9,
      0xb6, 0x67, 0x9a, 0x87, 0x88, 0x88, 0x73, 0xf9, 0xe5, 0x50, 0xaa, 0xba,
      0x9f, 0xd7, 0xdd, 0x25, 0xf2, 0xdb, 0x2b, 0x52, 0x24, 0x66, 0x4d, 0x5e,
      0x73, 0x8a, 0xfb, 0x98, 0xcb, 0xf7, 0xb2, 0xe8, 0x6d, 0x2e, 0xc9, 0xa1,
      0x0e, 0x68, 0xcf, 0xc8, 0x22, 0x8a, 0xdf, 0x86, 0x6f, 0x7c, 0xac, 0xe0,
      0xc6, 0xdb, 0xcd, 0x38, 0x1e, 0xa6, 0x2d, 0xcf, 0x4e, 0x23, 0x9a, 0x2b,
      0x7b, 0xbf, 0xf1, 0xb8, 0x3d, 0xb5, 0x79, 0x0d, 0xf0, 0x9f, 0x2b, 0x8b,
      0xda, 0xab, 0xf4, 0x8c, 0x38, 0xbc, 0x5d, 0x00, 0x91, 0x49, 0x61, 0xae,
      0xea, 0x73, 0xc6, 0xe7, 0x03, 0xbd, 0xe7, 0x8b, 0x80, 0x6d, 0xd4, 0x10,
      0x47, 0xd1, 0x79, 0x9b, 0xa8, 0xad, 0xd7, 0x16, 0x0d, 0x6a, 0xbe, 0x46,
      0x8a, 0xed, 0x61, 0xf7, 0x8c, 0xab, 0x2d, 0xc7, 0x39, 0xb9, 0x5f, 0x5f,
      0xf2, 0xb9, 0xda, 0x3a, 0x2c, 0xab, 0xb0, 0x12, 0x9e, 0x1e, 0x06, 0x4a,
      0xf1, 0x7d, 0x37, 0xa1, 0x94, 0x13, 0x3e, 0x04, 0x98, 0xd7, 0xf2, 0xc8,
      0x31, 0x9c, 0x01, 0xef, 0x20, 0xac, 0x6f, 0x4b, 0x81, 0xea, 0xa0, 0x37,
      0xc8, 0x61, 0x04, 0xbc, 0xd0, 0x3d, 0xc3, 0xd8, 0xe5, 0xcd, 0xd6, 0x5a,
      0xf7, 0xce, 0x55, 0xd6, 0xc4, 0x83, 0x52, 0x05, 0x21, 0x39, 0x9a, 0xad,
      0xf7, 0xf2, 0xc4, 0x34, 0x83, 0x80, 0x67, 0xa2, 0x55, 0xe1, 0xee, 0x7e,
      0x35, 0x64, 0x1b, 0x19, 0x97, 0x83, 0x6f, 0x01, 0x09, 0x02, 0xcc, 0xf3,
      0xb2, 0xb1, 0x67, 0x48, 0xec, 0x87, 0xbc, 0x52, 0xdb, 0x2e, 0x65, 0x83,
      0x50, 0xc1, 0x10, 0xaa, 0x50, 0xbd, 0xc7, 0x42, 0x42, 0x22, 0x70, 0xd3,
      0xa2, 0xbd, 0x31, 0x5b},
     pub_key_1,
     {0x32, 0x36, 0x31, 0x38, 0x37, 0x38, 0x37, 0x34, 0x31, 0x38},
     true},

    // Comment:
    // tcID: 59
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     59,
     32,
     {0x92, 0x83, 0x23, 0x28, 0xc1, 0x28, 0x07, 0x51, 0x4d, 0xdc, 0xd9, 0x19,
      0x63, 0x6b, 0x9b, 0xd1, 0x25, 0x19, 0x2c, 0xa9, 0x88, 0x83, 0x06, 0x9b,
      0x2c, 0xa8, 0xed, 0xfb, 0xfb, 0x0d, 0x42, 0x25, 0xdb, 0x3a, 0x62, 0x1b,
      0xd0, 0x3a, 0x71, 0x16, 0xf9, 0xb9, 0x19, 0xb1, 0x6b, 0x25, 0x68, 0xa8,
      0x97, 0xa7, 0x93, 0xd2, 0x0e, 0x9c, 0x43, 0x28, 0xad, 0xd7, 0x1a, 0xb2,
      0xa2, 0x04, 0x5c, 0x78, 0xab, 0x1c, 0x3c, 0xb7, 0x69, 0xab, 0x95, 0x7a,
      0xf2, 0xa3, 0xb5, 0x72, 0xb3, 0xbf, 0x2c, 0x04, 0x53, 0xbe, 0xe1, 0x0b,
      0xbb, 0x9f, 0xa7, 0xef, 0xc6, 0x06, 0x05, 0x21, 0x59, 0x89, 0x97, 0x9d,
      0x7e, 0xe5, 0x72, 0x4f, 0x73, 0xce, 0x85, 0xc7, 0x10, 0xaa, 0x00, 0xf2,
      0x49, 0x61, 0xe5, 0x44, 0x4f, 0x09, 0xa8, 0x3a, 0x82, 0xea, 0xfe, 0x38,
      0x39, 0xf8, 0xdc, 0x3f, 0xa5, 0xe2, 0x7a, 0x6c, 0xb1, 0x22, 0xad, 0x34,
      0xf8, 0x0b, 0x18, 0x11, 0x42, 0xf7, 0x62, 0xa8, 0x7f, 0xdf, 0x8e, 0x8e,
      0x77, 0xb4, 0x2b, 0x34, 0x16, 0x50, 0x21, 0x58, 0xcc, 0x66, 0xdc, 0x2d,
      0xce, 0x34, 0xe2, 0x9f, 0x1c, 0x9e, 0xbd, 0xe9, 0xd6, 0x0c, 0x79, 0x69,
      0xb7, 0x2d, 0x9e, 0x84, 0x11, 0x10, 0xe0, 0x35, 0x80, 0x7e, 0x2a, 0x6f,
      0x85, 0xcd, 0xcd, 0xb8, 0x75, 0xb3, 0xbf, 0x8e, 0x3a, 0xb1, 0xf6, 0xd0,
      0x5f, 0x4a, 0xdb, 0x3d, 0x73, 0x8e, 0x99, 0x65, 0xc5, 0x2d, 0x81, 0x38,
      0x7c, 0xd0, 0xa7, 0x02, 0xab, 0x85, 0x57, 0x6a, 0x50, 0x07, 0x2a, 0x99,
      0x4f, 0x13, 0xc7, 0xe6, 0x91, 0xc3, 0xeb, 0x1f, 0xc4, 0xc4, 0x66, 0x52,
      0xa5, 0xa3, 0xf4, 0x82, 0xff, 0x8f, 0xc2, 0x58, 0x88, 0x15, 0x4c, 0xc8,
      0xa1, 0x34, 0x89, 0x13, 0xd1, 0xcd, 0x0c, 0x19, 0xd7, 0x7c, 0x55, 0xb6,
      0xe4, 0x6e, 0x50, 0xf9},
     pub_key_1,
     {0x31, 0x36, 0x34, 0x32, 0x36, 0x32, 0x35, 0x32, 0x36, 0x32},
     true},

    // Comment:
    // tcID: 60
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     60,
     32,
     {0x3f, 0xc1, 0x7d, 0xe4, 0x11, 0xc9, 0x92, 0x43, 0xa0, 0xe5, 0xd4, 0xaf,
      0xd5, 0x13, 0x1f, 0x17, 0x7b, 0xcb, 0x4e, 0xdc, 0xe0, 0x34, 0xc9, 0x1a,
      0xd9, 0xdf, 0xa8, 0x7e, 0x3c, 0x31, 0xde, 0xde, 0xa6, 0x75, 0x57, 0x4e,
      0x91, 0x79, 0x54, 0x83, 0x26, 0x08, 0xda, 0xbc, 0x72, 0x54, 0x47, 0x29,
      0xfb, 0xcf, 0x91, 0xfd, 0xd1, 0xf1, 0x14, 0xca, 0x43, 0xdf, 0x0a, 0xf7,
      0x3e, 0x22, 0x26, 0xb7, 0x3a, 0x17, 0x97, 0xfd, 0xe7, 0xda, 0xa3, 0xce,
      0xa6, 0xb0, 0x86, 0x21, 0x7d, 0x65, 0x67, 0x98, 0xf9, 0xab, 0xde, 0x4a,
      0x56, 0x3e, 0x5a, 0x8d, 0xe2, 0x03, 0x48, 0x0b, 0x42, 0xaf, 0x12, 0xe6,
      0x36, 0xff, 0xaf, 0x7c, 0x72, 0xd2, 0xdd, 0x79, 0x11, 0x65, 0xce, 0x3c,
      0xe4, 0xb1, 0xe2, 0x1e, 0x8b, 0x74, 0x9c, 0xf8, 0xe9, 0x1b, 0x78, 0xf5,
      0x61, 0x86, 0x7c, 0x89, 0x23, 0x61, 0xc1, 0x52, 0x9c, 0x2c, 0x9e, 0xe7,
      0x80, 0xb6, 0xa7, 0x9b, 0x72, 0xb4, 0x47, 0x63, 0x9c, 0xed, 0x5b, 0x4a,
      0x04, 0xfd, 0x3d, 0x2d, 0x71, 0x69, 0x23, 0xbc, 0xaf, 0xd7, 0x93, 0xcd,
      0x14, 0x54, 0x71, 0x0d, 0xa5, 0xc7, 0x85, 0xec, 0xd2, 0xc4, 0x4c, 0xac,
      0x2f, 0x79, 0x52, 0x0b, 0xcd, 0xed, 0x6d, 0x3d, 0x27, 0xf9, 0xd2, 0xa7,
      0x13, 0x7a, 0x68, 0xe6, 0x9c, 0x34, 0xd1, 0x55, 0x92, 0xe9, 0x63, 0xf9,
      0x15, 0xe8, 0x8b, 0x80, 0x30, 0xcb, 0x7f, 0x27, 0x5a, 0x3b, 0xe4, 0x98,
      0xb2, 0x53, 0x10, 0xab, 0x4c, 0xfb, 0xa7, 0xbd, 0xc0, 0x75, 0x6a, 0xad,
      0xcf, 0xd3, 0x94, 0x4a, 0x60, 0x9c, 0x40, 0xb9, 0x53, 0x1c, 0xfe, 0xd5,
      0x5e, 0x7f, 0x9f, 0x69, 0x14, 0xd5, 0x3c, 0xc1, 0x7d, 0xbf, 0x1d, 0x97,
      0x07, 0xfc, 0x57, 0xde, 0xd6, 0xbc, 0x04, 0xf6, 0x90, 0x51, 0x9c, 0xdb,
      0x2b, 0xdc, 0xea, 0x29},
     pub_key_1,
     {0x36, 0x38, 0x32, 0x34, 0x31, 0x38, 0x39, 0x34, 0x33, 0x36},
     true},

    // Comment:
    // tcID: 61
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     61,
     32,
     {0x46, 0x7d, 0x46, 0x6c, 0xb8, 0xe1, 0x57, 0xb9, 0xcf, 0x3f, 0x51, 0x92,
      0x0b, 0x18, 0xf1, 0xdb, 0x24, 0x01, 0xf4, 0xd2, 0xc3, 0x97, 0xec, 0x58,
      0xbd, 0x3c, 0x6d, 0xdb, 0x1d, 0x5e, 0x9d, 0x94, 0x14, 0x58, 0x35, 0x34,
      0x06, 0x07, 0x73, 0xa1, 0x33, 0x82, 0xf9, 0x3f, 0x0d, 0x88, 0x52, 0xfe,
      0xd2, 0x08, 0xe4, 0xff, 0x56, 0x0e, 0xcc, 0x20, 0x30, 0x77, 0x29, 0x55,
      0x02, 0x2a, 0xa5, 0x94, 0x76, 0x72, 0x62, 0xdd, 0x02, 0xf1, 0xa8, 0x9a,
      0xc4, 0x8b, 0xf4, 0xf7, 0xa2, 0xc3, 0x4e, 0x8c, 0x76, 0x4e, 0x32, 0xb3,
      0x9b, 0x9f, 0x9d, 0x1d, 0x85, 0x71, 0x64, 0xfd, 0xac, 0xea, 0x8a, 0x93,
      0xe3, 0x45, 0x6f, 0x4d, 0xfd, 0x96, 0x58, 0x08, 0x0e, 0x3e, 0x45, 0xc0,
      0xf1, 0x7b, 0xb5, 0x99, 0xc4, 0x56, 0xe2, 0xcf, 0x59, 0x46, 0x14, 0x0d,
      0x46, 0x77, 0x55, 0xee, 0xab, 0xea, 0xfe, 0xef, 0x44, 0x0c, 0x72, 0x27,
      0x2a, 0xf0, 0x8a, 0x4a, 0x4a, 0x13, 0x91, 0xd9, 0x6d, 0x75, 0x02, 0x11,
      0x36, 0x1e, 0x5f, 0xb7, 0x8e, 0x94, 0x39, 0xc3, 0xe3, 0xb3, 0x9e, 0x01,
      0xac, 0x66, 0xe4, 0x0d, 0x84, 0x72, 0x79, 0x08, 0xdb, 0x4d, 0xd7, 0xca,
      0x74, 0x2c, 0x14, 0x54, 0x76, 0x2b, 0x20, 0x22, 0xdc, 0xa5, 0xe1, 0xbb,
      0x1c, 0xa5, 0xd0, 0x51, 0x58, 0x99, 0x88, 0x33, 0x6b, 0xd5, 0x33, 0x4f,
      0x72, 0xd1, 0x2f, 0xe9, 0xee, 0x85, 0xa9, 0xc7, 0x7a, 0xd4, 0xe0, 0x9e,
      0x41, 0x83, 0x92, 0x86, 0x61, 0xe7, 0x2c, 0xff, 0x1c, 0x0b, 0x48, 0x02,
      0x15, 0xb9, 0xaf, 0xae, 0xf2, 0x60, 0x13, 0x99, 0xa4, 0x7f, 0xe6, 0x28,
      0x6a, 0xcc, 0x71, 0x08, 0x50, 0xb7, 0xc2, 0x2d, 0x27, 0x6e, 0x90, 0x12,
      0x19, 0x02, 0x8a, 0x29, 0x6e, 0xdf, 0x83, 0xbf, 0xd5, 0xef, 0x21, 0x59,
      0x8e, 0x5f, 0xb5, 0x5a},
     pub_key_1,
     {0x34, 0x38, 0x34, 0x32, 0x34, 0x35, 0x34, 0x32, 0x35},
     true},

    // Comment: first byte of m_hash modified
    // tcID: 62
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     62,
     32,
     {0x67, 0xd1, 0xd1, 0xc0, 0xa3, 0x98, 0x14, 0x86, 0x25, 0x31, 0x7c, 0x3f,
      0x5e, 0x44, 0xb7, 0x38, 0xbd, 0xf4, 0x61, 0xc2, 0x7a, 0x59, 0x59, 0x4b,
      0x39, 0xeb, 0xb2, 0xae, 0xbe, 0xf2, 0x33, 0xc7, 0x80, 0x93, 0x79, 0xe5,
      0x44, 0x11, 0x41, 0x1b, 0x82, 0xd2, 0xe7, 0xac, 0x88, 0xf9, 0x89, 0xb5,
      0x83, 0x73, 0xd5, 0x32, 0xc7, 0x58, 0xba, 0xea, 0x12, 0x18, 0x78, 0xce,
      0x97, 0x59, 0x44, 0x17, 0x38, 0xd1, 0x21, 0x88, 0x1c, 0x1f, 0xa2, 0xd0,
      0x44, 0x21, 0xf0, 0x2d, 0xd5, 0x65, 0xb1, 0x27, 0x70, 0xd8, 0x44, 0x61,
      0x1e, 0xd1, 0x87, 0x3a, 0x0b, 0x64, 0xd8, 0x22, 0x70, 0x9a, 0x6b, 0x78,
      0xd6, 0xd3, 0x89, 0x2b, 0x29, 0x44, 0x04, 0xbc, 0xe6, 0x71, 0x10, 0x01,
      0xd6, 0xc3, 0xa5, 0x45, 0x46, 0xc7, 0x6a, 0x1d, 0x17, 0x81, 0x96, 0x74,
      0xb0, 0xbe, 0x90, 0x44, 0x97, 0xa2, 0x33, 0xb4, 0x66, 0xfe, 0x4b, 0xec,
      0xc8, 0x32, 0xde, 0xe7, 0x40, 0xf9, 0xab, 0x79, 0xe5, 0xb9, 0xf5, 0xdb,
      0x0b, 0x0f, 0x9a, 0xac, 0x00, 0x84, 0xba, 0x05, 0xce, 0xbf, 0x42, 0x30,
      0x3b, 0x5c, 0xa2, 0xad, 0x95, 0xe3, 0xd6, 0x1b, 0x29, 0xed, 0x64, 0x75,
      0x54, 0x5c, 0x02, 0xe9, 0x3e, 0x7b, 0x0e, 0x11, 0x8a, 0xf9, 0x2f, 0x5c,
      0xdd, 0xb1, 0xfa, 0xeb, 0x2c, 0xbc, 0x23, 0xc9, 0xe6, 0x9c, 0x12, 0x0e,
      0x29, 0xdf, 0x7f, 0xe3, 0x19, 0x91, 0xe8, 0x87, 0xb3, 0xb2, 0x9e, 0x77,
      0x68, 0x8c, 0x60, 0xe8, 0x0b, 0xe6, 0x5c, 0xcc, 0xf3, 0xd7, 0x86, 0x1a,
      0x7a, 0x14, 0xc3, 0x9e, 0x6a, 0x6e, 0x56, 0x45, 0x56, 0x8e, 0x2c, 0xc5,
      0xe4, 0xa1, 0x7b, 0x75, 0xdb, 0x1d, 0xd4, 0x15, 0xaa, 0xdb, 0x45, 0xe1,
      0x12, 0xa9, 0xb5, 0x82, 0xb2, 0xff, 0x6e, 0x82, 0xa4, 0x3d, 0x7a, 0x73,
      0x47, 0xb7, 0xb5, 0x6d},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of m_hash modified
    // tcID: 63
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     63,
     32,
     {0x84, 0x23, 0x48, 0xf2, 0xb2, 0xcd, 0xd4, 0xc7, 0x2c, 0xda, 0x7d, 0xbe,
      0xc0, 0xfb, 0x8b, 0x11, 0x4e, 0x41, 0x9c, 0xbf, 0xc1, 0xee, 0x1b, 0x7c,
      0xe5, 0xd7, 0x0e, 0xc5, 0x6a, 0x83, 0x3c, 0x4e, 0xbc, 0x8c, 0x11, 0x4d,
      0xc3, 0xc9, 0x21, 0x64, 0xb1, 0x3f, 0x46, 0x92, 0xf2, 0x36, 0xd6, 0xb8,
      0x8e, 0x56, 0x18, 0xb2, 0x3a, 0xf9, 0xfa, 0x97, 0x9f, 0xe9, 0xb5, 0xd8,
      0xeb, 0x22, 0x8b, 0x1e, 0xfd, 0x0d, 0xa8, 0xe4, 0x7b, 0x4c, 0x40, 0x42,
      0x96, 0x5c, 0x8b, 0x9f, 0x08, 0xeb, 0x9f, 0x6f, 0xdf, 0x7e, 0x47, 0x2c,
      0x88, 0xf5, 0x32, 0xd4, 0xd8, 0x51, 0x62, 0x3b, 0x4b, 0xf9, 0x9e, 0x02,
      0x1e, 0x82, 0xef, 0x31, 0x3c, 0x7d, 0x93, 0x17, 0x9a, 0xf8, 0x10, 0xb7,
      0x0a, 0xaf, 0x92, 0x9a, 0x39, 0x5e, 0xce, 0x71, 0x3d, 0x5f, 0xec, 0x33,
      0x39, 0xe3, 0x94, 0x21, 0x0b, 0x56, 0xf1, 0xed, 0xf2, 0x6d, 0xed, 0xfb,
      0x04, 0x08, 0x3b, 0xd2, 0x4e, 0xb0, 0xd3, 0xca, 0x11, 0x77, 0x61, 0xf3,
      0x83, 0x19, 0xc3, 0xb9, 0x7a, 0x94, 0x53, 0x99, 0x3d, 0xaf, 0xd3, 0xd2,
      0xdd, 0x8c, 0x01, 0xcd, 0x63, 0x11, 0x7f, 0x8f, 0xda, 0x46, 0xf5, 0x25,
      0x65, 0xe4, 0xd7, 0xde, 0x9f, 0x71, 0x8f, 0x1f, 0x23, 0x25, 0x4c, 0x4f,
      0x9e, 0xe7, 0x7a, 0xd1, 0x41, 0x4a, 0xf4, 0xd4, 0xdc, 0xf9, 0x59, 0xa8,
      0x9b, 0xef, 0x43, 0x83, 0x29, 0x51, 0x6c, 0xc9, 0xb7, 0x91, 0x49, 0xdb,
      0x05, 0x8d, 0x20, 0x6e, 0x6d, 0x7c, 0x01, 0x33, 0xe7, 0xc8, 0x70, 0x33,
      0x5f, 0x04, 0x90, 0xb8, 0xc5, 0x69, 0xd7, 0x87, 0x44, 0x3c, 0x4a, 0x84,
      0xff, 0x66, 0x5d, 0xbc, 0x6f, 0x43, 0x53, 0xde, 0xc6, 0x6f, 0x9c, 0x48,
      0x8a, 0x3f, 0x91, 0x07, 0x1c, 0xe1, 0x95, 0x53, 0xa7, 0xc1, 0x56, 0x02,
      0x5f, 0x1f, 0x81, 0xb2},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of m_hash modified
    // tcID: 64
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     64,
     32,
     {0x77, 0xc9, 0xdd, 0x77, 0x86, 0xf0, 0xb5, 0xcb, 0xe7, 0x6f, 0x20, 0xab,
      0xf2, 0x43, 0x61, 0xf8, 0x97, 0x9d, 0x3a, 0x6c, 0x6c, 0x12, 0x2e, 0x79,
      0x8e, 0xda, 0x90, 0x6b, 0x0b, 0x97, 0x00, 0xcd, 0x2d, 0xd2, 0x6e, 0x52,
      0x86, 0xdd, 0xd3, 0x9d, 0x07, 0xb7, 0xc2, 0x43, 0x79, 0xcb, 0x40, 0xf8,
      0x35, 0x03, 0x54, 0xa3, 0x6b, 0x07, 0x59, 0xbf, 0xad, 0xe6, 0x1d, 0x3d,
      0x77, 0x07, 0x02, 0xb5, 0x82, 0x18, 0xc5, 0xdc, 0x64, 0xdd, 0xd0, 0xd5,
      0xfc, 0xe4, 0x05, 0xa1, 0x6f, 0xbc, 0x4d, 0xe3, 0xa5, 0xfb, 0xe7, 0x73,
      0x70, 0x32, 0x60, 0x5c, 0x06, 0xac, 0x82, 0xe1, 0x74, 0x61, 0x9c, 0x30,
      0x04, 0xd2, 0x4b, 0xbf, 0x22, 0xbd, 0x1a, 0xb3, 0xe4, 0xd4, 0x32, 0xb4,
      0xae, 0x36, 0xc2, 0x35, 0x73, 0xcb, 0xad, 0x84, 0x5c, 0x16, 0xa1, 0x84,
      0x2e, 0x5d, 0xe1, 0xa3, 0xbf, 0xa2, 0xf1, 0x2d, 0x34, 0x96, 0xa3, 0x11,
      0x4f, 0xda, 0x83, 0x0d, 0xd6, 0x06, 0x1c, 0xf5, 0x38, 0xa4, 0x57, 0x1f,
      0xe0, 0x88, 0xcc, 0x03, 0xdd, 0x7e, 0x87, 0x62, 0xfb, 0x08, 0xb8, 0x45,
      0x01, 0x84, 0x3f, 0x5f, 0x03, 0x62, 0xa4, 0xfb, 0x09, 0x7d, 0x6f, 0xe9,
      0xb9, 0x69, 0x70, 0xc0, 0xc5, 0x05, 0xd2, 0xf6, 0xa5, 0x97, 0x54, 0xc4,
      0x26, 0x84, 0x90, 0x86, 0x27, 0xfa, 0x8c, 0x73, 0x4e, 0xcd, 0x58, 0x7c,
      0x16, 0x1d, 0xe7, 0xb7, 0xbd, 0xd6, 0x99, 0x24, 0xc0, 0xb4, 0xd0, 0x6c,
      0xb7, 0xdb, 0x2a, 0x70, 0xdd, 0x92, 0x57, 0x87, 0x6d, 0x1d, 0xa1, 0xed,
      0x8c, 0xc0, 0x0f, 0xa6, 0x82, 0x79, 0x52, 0x5c, 0x34, 0x6b, 0x72, 0x56,
      0xc9, 0x16, 0xcc, 0xf1, 0xdf, 0x93, 0x86, 0xff, 0x9d, 0x1e, 0xb2, 0x7f,
      0x0a, 0x5d, 0x83, 0xa0, 0x0a, 0x27, 0x38, 0xfa, 0x2d, 0xbf, 0xaa, 0x50,
      0x0b, 0xae, 0xa7, 0x89},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of m_hash modified
    // tcID: 65
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     65,
     32,
     {0x45, 0x52, 0x21, 0xc3, 0x85, 0xf7, 0x69, 0xfe, 0xdd, 0x12, 0x3a, 0xfa,
      0x37, 0xa4, 0x2b, 0x74, 0x77, 0xd6, 0xc3, 0xed, 0x96, 0x8c, 0xe4, 0x4d,
      0x49, 0x82, 0xc4, 0x1a, 0xd2, 0x9a, 0x3f, 0x59, 0xba, 0xeb, 0x2b, 0x56,
      0x6d, 0xba, 0xcc, 0x91, 0xb4, 0x23, 0xfb, 0xae, 0xc3, 0x71, 0xf3, 0x80,
      0x9c, 0x20, 0xca, 0xd6, 0xaf, 0xcc, 0x2b, 0x8d, 0xf7, 0x82, 0xe4, 0x72,
      0xc9, 0x54, 0xcd, 0xef, 0xfc, 0xa4, 0x95, 0x53, 0xf6, 0xec, 0xa5, 0x87,
      0x81, 0x89, 0x4c, 0x67, 0xfe, 0xd1, 0xd9, 0x32, 0x6a, 0x53, 0x42, 0x2f,
      0x96, 0x42, 0x03, 0x1b, 0x69, 0xff, 0x45, 0xe6, 0xa8, 0x26, 0xd1, 0x8e,
      0x42, 0x41, 0xb5, 0x21, 0x42, 0x31, 0xf7, 0xd2, 0x52, 0xd4, 0xc6, 0x40,
      0x38, 0x6a, 0x17, 0xc2, 0xa1, 0x83, 0x9b, 0xa9, 0xc5, 0xa3, 0x4e, 0x94,
      0xb2, 0xb8, 0xf3, 0x0f, 0xb2, 0x59, 0xfa, 0x75, 0x23, 0x39, 0xf1, 0x34,
      0xe5, 0x43, 0x75, 0xa9, 0xa4, 0xf3, 0xa5, 0xdb, 0xd5, 0xf3, 0xfb, 0x93,
      0xc3, 0x8b, 0x59, 0xfc, 0x33, 0xa7, 0x7d, 0xbd, 0xea, 0x9b, 0x8f, 0xab,
      0x7c, 0x20, 0x9e, 0x6f, 0x40, 0x3d, 0x18, 0x89, 0x58, 0xb5, 0xfa, 0x54,
      0x81, 0xbd, 0x22, 0x5b, 0x26, 0x6b, 0xee, 0x67, 0x61, 0x13, 0x21, 0x04,
      0x89, 0x0c, 0x8c, 0x25, 0xf0, 0x45, 0x83, 0x08, 0x4e, 0xb0, 0x1c, 0x26,
      0x6c, 0xcb, 0xca, 0x40, 0x16, 0x17, 0x12, 0x0c, 0x61, 0xa3, 0x88, 0xcc,
      0x68, 0x3f, 0xdd, 0x5d, 0x19, 0x5c, 0x8d, 0xcd, 0x48, 0xf4, 0xd1, 0xa9,
      0xbe, 0x80, 0xc0, 0x77, 0x27, 0xf7, 0x8a, 0x10, 0xcd, 0x26, 0x35, 0x9c,
      0x8d, 0xd1, 0xd8, 0x76, 0x14, 0xf8, 0xac, 0xac, 0x15, 0x06, 0xc5, 0xbb,
      0xa7, 0x9b, 0x30, 0xc0, 0xaf, 0x74, 0x5c, 0x87, 0x24, 0x33, 0xf1, 0x7e,
      0x8a, 0x52, 0xa9, 0x4e},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bits in m_hash flipped
    // tcID: 66
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     66,
     32,
     {0x5d, 0x1f, 0x5b, 0x3a, 0xda, 0x8d, 0x45, 0x07, 0xa7, 0x44, 0x78, 0x29,
      0xf2, 0x67, 0x64, 0xb9, 0xf7, 0x94, 0xcc, 0xb4, 0xc2, 0x87, 0x87, 0x0b,
      0x5c, 0x5a, 0xac, 0x64, 0x9f, 0x92, 0x72, 0xfb, 0xbe, 0x22, 0xf0, 0x64,
      0xcb, 0x75, 0xe5, 0xb3, 0x81, 0x3b, 0xf8, 0x74, 0xc6, 0x97, 0x7d, 0xc2,
      0x86, 0xef, 0x1d, 0xed, 0xde, 0xee, 0x1a, 0x84, 0xa9, 0x30, 0x2f, 0xbb,
      0xc9, 0xc8, 0xf8, 0x6e, 0xc4, 0x5e, 0xed, 0x54, 0x69, 0xbb, 0x85, 0xee,
      0xd8, 0x61, 0x8e, 0xfd, 0xaf, 0x29, 0xea, 0x4b, 0xc0, 0xa9, 0xcd, 0x0c,
      0x0b, 0xe7, 0x1e, 0x82, 0xbd, 0xab, 0x6f, 0x15, 0xa9, 0xf7, 0xa6, 0x37,
      0xf2, 0x97, 0xe0, 0xb5, 0xad, 0x4c, 0x78, 0x85, 0xbd, 0x27, 0xb8, 0x9f,
      0x4a, 0x52, 0x45, 0x2f, 0x01, 0x76, 0xdf, 0x3d, 0x26, 0x6f, 0x9c, 0x13,
      0xfc, 0x44, 0xd3, 0xfc, 0xc3, 0xe7, 0x1e, 0x3c, 0xc5, 0xed, 0xe3, 0xfe,
      0x25, 0x55, 0xff, 0x2b, 0xf2, 0xb7, 0x2a, 0x21, 0x98, 0xaf, 0x70, 0x9e,
      0x29, 0xc2, 0xf6, 0xf5, 0xce, 0x44, 0x99, 0x7c, 0x02, 0xea, 0x7a, 0xeb,
      0xc9, 0xa3, 0x3d, 0x0c, 0x60, 0x9f, 0xf0, 0xf5, 0x86, 0xe7, 0x53, 0xe5,
      0x85, 0xee, 0x50, 0x52, 0xa0, 0xbf, 0x2f, 0x71, 0x24, 0x7c, 0xf4, 0x3a,
      0xc2, 0x44, 0x81, 0x8c, 0x84, 0x34, 0x76, 0x62, 0x33, 0x83, 0x84, 0xd6,
      0xc1, 0xa4, 0xc9, 0xb9, 0xeb, 0xc1, 0x4f, 0x91, 0x2d, 0xb6, 0x88, 0xe6,
      0x58, 0xd4, 0x53, 0xbb, 0x20, 0x82, 0xc8, 0xde, 0xf4, 0xc4, 0x40, 0xa6,
      0xb2, 0x5e, 0x03, 0xea, 0x44, 0x59, 0xc1, 0xc9, 0xbd, 0x54, 0x95, 0xe2,
      0xce, 0x93, 0x43, 0x43, 0x9c, 0xbb, 0xf0, 0x3a, 0xff, 0xca, 0x63, 0x85,
      0x6c, 0xc5, 0x09, 0x36, 0xd4, 0x9c, 0xf2, 0xdc, 0xfc, 0x73, 0x67, 0x9c,
      0x9a, 0xa3, 0x2e, 0x56},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: s_len changed to 0
    // tcID: 67
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     67,
     32,
     {0x5e, 0x91, 0xb5, 0xdc, 0xbf, 0x02, 0xd6, 0xf1, 0x96, 0x21, 0xd4, 0x1a,
      0x83, 0xdc, 0x8f, 0x15, 0xea, 0x83, 0xc0, 0xed, 0xb8, 0x37, 0x65, 0xef,
      0x02, 0x9b, 0x0a, 0xca, 0xc2, 0xe1, 0xec, 0x89, 0x18, 0xb1, 0xd2, 0xaf,
      0xe1, 0xfa, 0xdf, 0x11, 0xc4, 0x8d, 0x27, 0x59, 0x4c, 0xb9, 0xc0, 0x1f,
      0xed, 0x79, 0xd9, 0x0e, 0x5d, 0x5a, 0x80, 0x85, 0xc4, 0x38, 0x45, 0x01,
      0x11, 0xaa, 0x7d, 0x9f, 0xa3, 0x9c, 0x23, 0x45, 0xb1, 0x4f, 0xc3, 0xc2,
      0xcb, 0x34, 0x12, 0x8f, 0x86, 0xdb, 0x5e, 0xb0, 0x0b, 0xdf, 0x8d, 0xfe,
      0x38, 0xd6, 0x1f, 0x29, 0xa4, 0x1f, 0xe3, 0x13, 0x42, 0xe7, 0xaa, 0xef,
      0xcb, 0x4b, 0x12, 0x2e, 0xb5, 0xd6, 0x3c, 0x2f, 0x5c, 0x26, 0x3c, 0x8d,
      0xf8, 0x45, 0x0e, 0x94, 0x28, 0xff, 0xef, 0x97, 0x4d, 0x53, 0x58, 0x18,
      0xd5, 0x1d, 0xc0, 0x3a, 0x7d, 0x60, 0xc8, 0xb2, 0xd1, 0x6c, 0x99, 0x9a,
      0xe4, 0x6d, 0x73, 0xab, 0x40, 0x51, 0x5f, 0xe6, 0x01, 0xd9, 0xb8, 0x9b,
      0x1d, 0x09, 0xc6, 0xd6, 0x0c, 0xd5, 0x16, 0x39, 0xa9, 0x7c, 0x1d, 0x21,
      0x1e, 0x09, 0x76, 0x09, 0xba, 0x5e, 0x8c, 0x31, 0x9c, 0x6f, 0xbd, 0x21,
      0xb3, 0x4a, 0x63, 0x4e, 0xc8, 0xfb, 0x89, 0x71, 0xc5, 0xaa, 0xe2, 0x1c,
      0x70, 0xb8, 0x47, 0xa4, 0x53, 0x9c, 0xc1, 0x0d, 0xc3, 0x14, 0xdd, 0xd8,
      0xa9, 0x62, 0x9e, 0x8a, 0x0e, 0x51, 0xc6, 0x6c, 0x0c, 0xb6, 0x1f, 0xd1,
      0xf7, 0x22, 0x8c, 0x01, 0xc6, 0x76, 0x91, 0x90, 0xab, 0xe9, 0xba, 0xc9,
      0xa3, 0x89, 0x78, 0x00, 0x05, 0x00, 0x14, 0x35, 0x85, 0x94, 0xe0, 0xfb,
      0x20, 0xdb, 0xb4, 0x58, 0xb1, 0x2a, 0xa1, 0x34, 0x68, 0x26, 0xcc, 0x9f,
      0x7e, 0x9c, 0x53, 0x52, 0xb0, 0x73, 0xd6, 0x28, 0x53, 0xda, 0xfe, 0x77,
      0xc8, 0x48, 0xcb, 0x1f},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: s_len changed to 20
    // tcID: 68
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     68,
     32,
     {0x57, 0xe8, 0xcc, 0x1d, 0xc0, 0x0c, 0x07, 0x38, 0x3d, 0x89, 0xa7, 0x9b,
      0x5c, 0x8e, 0x4f, 0x5b, 0xde, 0x2a, 0x2b, 0xa5, 0x5a, 0x3c, 0x72, 0x01,
      0xb3, 0x29, 0x1c, 0x4d, 0x80, 0x5b, 0x1b, 0x2e, 0xb3, 0x6f, 0x8f, 0x32,
      0x6b, 0x54, 0x23, 0x42, 0xda, 0x18, 0x0a, 0xbe, 0x50, 0x86, 0x69, 0xbb,
      0x6c, 0xc2, 0xdd, 0x54, 0xe3, 0x27, 0xbc, 0x70, 0xc1, 0xe3, 0x17, 0xba,
      0x93, 0xa0, 0xfd, 0x21, 0xe7, 0xfc, 0xe2, 0x2a, 0x0c, 0x59, 0x7c, 0x74,
      0x20, 0xd1, 0xd5, 0x60, 0x2a, 0xc4, 0x3d, 0x93, 0x48, 0xba, 0x3e, 0xba,
      0x56, 0x1f, 0x25, 0x0e, 0x30, 0x1a, 0xb9, 0x55, 0xb0, 0xdc, 0x33, 0xe4,
      0xab, 0xde, 0x32, 0x94, 0x6b, 0x9b, 0x3e, 0x86, 0xc8, 0xbf, 0x07, 0xa4,
      0x46, 0x46, 0xca, 0x59, 0x59, 0x60, 0xbb, 0x98, 0x8f, 0xef, 0x04, 0xb2,
      0x82, 0x49, 0x67, 0xe9, 0xda, 0x8b, 0x02, 0x64, 0xf1, 0xda, 0x06, 0x59,
      0x37, 0x39, 0x35, 0x31, 0x3a, 0x57, 0x4b, 0x53, 0x80, 0xf0, 0xb5, 0x4c,
      0xe1, 0xbc, 0x0d, 0xde, 0x42, 0x3b, 0xd3, 0xa5, 0x4f, 0x6a, 0xe5, 0xfa,
      0xfa, 0x77, 0x2a, 0x55, 0xc1, 0xc4, 0x4e, 0xb6, 0xed, 0xff, 0xec, 0xf1,
      0x3e, 0x6e, 0x5e, 0x1e, 0xda, 0xf8, 0x7a, 0x79, 0xe3, 0x38, 0x57, 0x73,
      0x04, 0x14, 0x1f, 0xbc, 0x44, 0xf0, 0xe9, 0xee, 0xb2, 0x86, 0xf5, 0x53,
      0xf8, 0x79, 0xad, 0xdd, 0x6e, 0x12, 0xe4, 0x36, 0xfa, 0x3a, 0xf5, 0x1a,
      0xd5, 0x3a, 0x72, 0xf2, 0x67, 0x9f, 0x0e, 0xd1, 0x02, 0xd5, 0x04, 0xee,
      0x08, 0x70, 0x6f, 0xe1, 0x11, 0xea, 0xee, 0x49, 0xd8, 0x80, 0xd1, 0xa0,
      0xb9, 0x19, 0x24, 0xb3, 0xb7, 0x99, 0x68, 0xed, 0x0f, 0x9b, 0xff, 0x44,
      0x6d, 0xac, 0x19, 0x9e, 0xe8, 0x9b, 0x15, 0x8c, 0x07, 0x49, 0x27, 0xd2,
      0x7b, 0x86, 0x44, 0x98},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: salt is all 0
    // tcID: 69
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     69,
     32,
     {0x15, 0x91, 0xae, 0x74, 0x3c, 0x58, 0xce, 0xb7, 0x23, 0xa7, 0x6f, 0x50,
      0x2e, 0x21, 0xff, 0x6a, 0x65, 0xc2, 0x4c, 0xab, 0xf5, 0xf5, 0x27, 0xba,
      0xb5, 0xa6, 0xf2, 0xa6, 0x9f, 0x20, 0xc7, 0x76, 0xfd, 0x22, 0x51, 0xe4,
      0x3a, 0xd2, 0x2e, 0x09, 0xb1, 0x48, 0x6c, 0xeb, 0x19, 0x35, 0xb2, 0xdc,
      0x2a, 0xde, 0x95, 0xe2, 0x33, 0xf2, 0x96, 0xcc, 0x0e, 0x5a, 0x8a, 0xf8,
      0x10, 0x96, 0x59, 0xbe, 0x76, 0xb6, 0xbf, 0xdf, 0x37, 0xe1, 0x48, 0x37,
      0xfd, 0x6c, 0x34, 0xbf, 0xed, 0x1f, 0x19, 0xec, 0x9d, 0x21, 0xf9, 0x74,
      0xb9, 0x84, 0xfe, 0x4d, 0x47, 0x73, 0x89, 0x6e, 0xbc, 0xc7, 0xfb, 0x86,
      0x2f, 0xd6, 0x41, 0xcd, 0x0d, 0x77, 0x17, 0x84, 0x85, 0xc7, 0x0c, 0x2d,
      0x68, 0xb4, 0xd9, 0xbe, 0x1d, 0x86, 0x3f, 0x6f, 0x25, 0x4b, 0x77, 0x99,
      0x1f, 0xc9, 0x05, 0x3f, 0x5d, 0x54, 0x15, 0xd1, 0xaa, 0x74, 0xba, 0x90,
      0x67, 0xe2, 0xe6, 0x60, 0x7f, 0xb6, 0x51, 0x63, 0x8c, 0x9c, 0xc0, 0x43,
      0x0a, 0x40, 0xc9, 0xb6, 0x91, 0x97, 0x7b, 0x55, 0x7a, 0x31, 0xd9, 0x5a,
      0x29, 0x0a, 0x95, 0xb5, 0x6e, 0xf2, 0xec, 0x8e, 0x43, 0x13, 0x68, 0x6a,
      0x9c, 0x5e, 0xf4, 0x82, 0x35, 0x91, 0x2b, 0x21, 0x0f, 0xdd, 0x2c, 0x50,
      0xaa, 0xfa, 0xc2, 0x81, 0x31, 0x10, 0x4c, 0x79, 0x5c, 0x42, 0xae, 0x75,
      0x81, 0x0b, 0x02, 0x84, 0xb2, 0xd2, 0x57, 0xe8, 0x1e, 0xca, 0xc4, 0x24,
      0x06, 0x22, 0xeb, 0xc2, 0x61, 0xab, 0x8b, 0xce, 0xee, 0xeb, 0xe8, 0x0f,
      0x1c, 0xfa, 0x70, 0xf1, 0x8d, 0x78, 0x2a, 0xeb, 0xb9, 0x7d, 0x80, 0x3e,
      0xa3, 0xa8, 0x95, 0xbe, 0x54, 0x1b, 0xe6, 0x94, 0x1d, 0xf1, 0x03, 0xea,
      0xaa, 0xbd, 0x87, 0x08, 0x48, 0xbf, 0xaf, 0x58, 0xcd, 0xaf, 0x6c, 0xec,
      0xdd, 0x5a, 0x10, 0xbf},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: salt is all 1
    // tcID: 70
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     70,
     32,
     {0x6f, 0x2f, 0x65, 0x0a, 0xc1, 0x0d, 0x5a, 0xa2, 0xc1, 0x67, 0x03, 0xf6,
      0x57, 0x23, 0x3d, 0xa8, 0xc0, 0x35, 0xda, 0x67, 0xa6, 0xe9, 0xe9, 0x50,
      0xdf, 0xd0, 0x39, 0x13, 0x99, 0xda, 0x3a, 0x86, 0xca, 0x78, 0x37, 0xdd,
      0x7c, 0xf2, 0x3e, 0x86, 0x4d, 0x9c, 0xfc, 0xa1, 0xfe, 0x77, 0xda, 0xe4,
      0x5a, 0x01, 0xba, 0x21, 0xd2, 0x3d, 0xd9, 0x18, 0xca, 0x7b, 0xba, 0x09,
      0x4a, 0xae, 0x37, 0x61, 0x00, 0x19, 0x8f, 0x59, 0x83, 0x43, 0x96, 0xec,
      0x94, 0x2f, 0xcf, 0xfd, 0xd7, 0xd6, 0xa4, 0x49, 0x53, 0xf6, 0x9b, 0xc6,
      0x02, 0x91, 0xb1, 0xee, 0xd5, 0x92, 0x1a, 0x04, 0x34, 0xd8, 0xb8, 0x95,
      0x3b, 0xeb, 0x9d, 0x1e, 0x1b, 0x15, 0xfd, 0xca, 0x70, 0x90, 0xfa, 0x5c,
      0x64, 0x68, 0x47, 0xc0, 0xb7, 0x59, 0xe9, 0x4f, 0x05, 0x69, 0x11, 0xad,
      0x18, 0x8d, 0x4b, 0x0c, 0xc3, 0x99, 0xc8, 0xc3, 0x45, 0x75, 0x7d, 0x50,
      0x22, 0xf1, 0xa3, 0x89, 0x26, 0xde, 0x0c, 0xbd, 0xa8, 0x64, 0x8a, 0x7a,
      0xff, 0xd9, 0xf0, 0x31, 0x26, 0x2b, 0x10, 0x79, 0xa3, 0x68, 0x1d, 0x58,
      0x24, 0x91, 0x86, 0xfe, 0xc4, 0xf6, 0xe9, 0x8b, 0xf1, 0x51, 0xc9, 0xb6,
      0x80, 0xa4, 0x6b, 0x88, 0xda, 0xda, 0x9b, 0x42, 0xcc, 0xa3, 0x65, 0xcf,
      0x90, 0x8e, 0xd0, 0x50, 0x1c, 0xd2, 0x1e, 0x02, 0xa5, 0xbc, 0x4c, 0x06,
      0x75, 0xf2, 0x3e, 0xce, 0x50, 0x98, 0x7b, 0x70, 0x34, 0x99, 0xee, 0xb9,
      0x4b, 0x6c, 0x40, 0xb5, 0xcd, 0xf2, 0x22, 0x99, 0x77, 0x6f, 0xe3, 0x08,
      0x00, 0xf8, 0x87, 0xa1, 0xdf, 0xff, 0x18, 0xcd, 0x8a, 0x7d, 0xa8, 0xc2,
      0x38, 0x80, 0x60, 0xdc, 0xb7, 0x8c, 0x92, 0x5c, 0x54, 0xb4, 0xe6, 0x20,
      0xcd, 0x3f, 0xe7, 0x54, 0x6a, 0xcc, 0xfb, 0x3b, 0xba, 0xe9, 0xde, 0x08,
      0xba, 0x88, 0x60, 0x09},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: byte 0 in zero padding modified
    // tcID: 71
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     71,
     32,
     {0x37, 0x48, 0x7b, 0x94, 0x8d, 0xac, 0x95, 0xa1, 0xe5, 0x7b, 0xf1, 0xac,
      0x40, 0x88, 0x8b, 0x8e, 0x07, 0x4c, 0xf9, 0xdb, 0x9c, 0x98, 0x25, 0xe7,
      0xb7, 0x26, 0x7d, 0x3b, 0x10, 0x5a, 0x8c, 0x67, 0xcb, 0x9b, 0x33, 0xc0,
      0xe5, 0xfd, 0x64, 0x18, 0x36, 0x79, 0x8f, 0x41, 0xb8, 0xb1, 0xf0, 0x24,
      0xb1, 0x32, 0x43, 0xda, 0x4f, 0xa5, 0xe5, 0x27, 0x09, 0x83, 0x37, 0xe5,
      0xca, 0xc4, 0x1e, 0x05, 0x23, 0xa2, 0x8f, 0xb1, 0x35, 0xae, 0x06, 0x0e,
      0x7c, 0x1e, 0x4e, 0xb9, 0x55, 0x62, 0x22, 0xbc, 0x43, 0xbf, 0x16, 0x59,
      0xf6, 0x5a, 0x2a, 0x2d, 0xb1, 0x08, 0xac, 0x9b, 0x7c, 0x99, 0x42, 0xa5,
      0x65, 0x8f, 0xcb, 0xca, 0x56, 0x22, 0xc1, 0x15, 0xe3, 0x4e, 0xad, 0x88,
      0x3e, 0xa4, 0xef, 0x03, 0xf7, 0xf6, 0x29, 0x90, 0xf2, 0x82, 0xfa, 0x79,
      0x1b, 0x04, 0x48, 0x90, 0x53, 0x77, 0x13, 0x29, 0xa4, 0x82, 0x46, 0x7c,
      0xba, 0x8a, 0x13, 0xad, 0x98, 0xf2, 0x7f, 0xf7, 0xb6, 0x1c, 0x24, 0xa4,
      0x52, 0xe0, 0x85, 0xd4, 0x32, 0x13, 0x0b, 0x72, 0x59, 0xe5, 0x9b, 0x28,
      0x66, 0xe5, 0x53, 0x20, 0x11, 0x9b, 0x21, 0xe3, 0xc7, 0x06, 0xf3, 0x59,
      0x6e, 0xc1, 0x74, 0x51, 0x7c, 0x43, 0xcd, 0xbe, 0x95, 0x7e, 0x01, 0x2b,
      0x57, 0x39, 0x61, 0xb1, 0xfa, 0x92, 0x53, 0x73, 0x94, 0x5a, 0xb3, 0x20,
      0x9a, 0x10, 0x07, 0xd1, 0x97, 0xe1, 0xe9, 0x30, 0x1d, 0xd0, 0xaf, 0xa4,
      0x85, 0xac, 0xf6, 0x64, 0x3b, 0xa0, 0x58, 0x7a, 0x69, 0xf7, 0xc4, 0x4b,
      0xdf, 0x1e, 0x53, 0xc3, 0x2f, 0x05, 0xa3, 0xb9, 0x6d, 0xb0, 0xc4, 0x62,
      0x50, 0x9c, 0x29, 0x2d, 0x7d, 0xe0, 0x9a, 0x6c, 0x78, 0xeb, 0xf1, 0x13,
      0x14, 0x53, 0xd3, 0x7a, 0xb0, 0x37, 0x17, 0x60, 0x11, 0x29, 0x67, 0x30,
      0xf5, 0x7c, 0xda, 0x97},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: byte 7 in zero padding modified
    // tcID: 72
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     72,
     32,
     {0x24, 0x1a, 0x3a, 0x75, 0x69, 0x21, 0x0a, 0x47, 0xb8, 0x31, 0x25, 0xfb,
      0x67, 0x03, 0x9a, 0x68, 0xd9, 0x85, 0x9b, 0x97, 0x1a, 0x49, 0xaf, 0x62,
      0xbf, 0xd4, 0xbd, 0xe0, 0x1e, 0x3b, 0x95, 0x5a, 0xb1, 0x66, 0xbb, 0xa5,
      0x16, 0x56, 0x57, 0xfb, 0xfa, 0x51, 0x95, 0x73, 0x02, 0x7e, 0xf1, 0xa0,
      0xf4, 0x0c, 0xf7, 0x53, 0x3f, 0x94, 0x1d, 0x64, 0xe0, 0x9f, 0xcf, 0xcc,
      0x35, 0xcd, 0xd5, 0x64, 0xc1, 0xee, 0x08, 0x23, 0x16, 0x6d, 0xfc, 0x05,
      0x4e, 0xd9, 0x3e, 0x01, 0xc5, 0x83, 0x1c, 0x03, 0x69, 0x20, 0x33, 0x5d,
      0x8b, 0x8d, 0xaa, 0x32, 0x22, 0x0d, 0xd5, 0xc0, 0xb6, 0xa0, 0x71, 0xf0,
      0x8d, 0x19, 0x41, 0x1c, 0x64, 0x18, 0xaa, 0xa9, 0x88, 0x33, 0x75, 0x58,
      0x7b, 0x19, 0xf0, 0x72, 0x0e, 0x79, 0xf1, 0x84, 0x53, 0x5d, 0x7e, 0xd8,
      0xc5, 0x36, 0x0e, 0x66, 0x7a, 0xde, 0x54, 0x1c, 0x1d, 0xdb, 0xf9, 0xc0,
      0x62, 0x92, 0x55, 0xd8, 0xd2, 0x86, 0xea, 0xe8, 0xde, 0xfd, 0x34, 0xf0,
      0x00, 0xa3, 0xbe, 0x1f, 0xa7, 0xfe, 0xa6, 0x5a, 0x4c, 0xd4, 0xf6, 0x4b,
      0x11, 0xc6, 0x41, 0x80, 0x6f, 0xa5, 0x7d, 0x67, 0xb4, 0xc6, 0xb7, 0xb4,
      0x98, 0x92, 0xf3, 0x8d, 0xc5, 0xd1, 0x3a, 0xbd, 0xab, 0xfa, 0xa6, 0xcb,
      0x91, 0xed, 0x60, 0x22, 0xd4, 0xfb, 0x46, 0x7c, 0xdb, 0x60, 0x46, 0xb1,
      0x3f, 0xcc, 0x81, 0x42, 0xa9, 0x7b, 0xc3, 0x4e, 0xdd, 0xd0, 0x45, 0x79,
      0x6f, 0x4e, 0x19, 0xb1, 0x88, 0x5d, 0x04, 0xc5, 0x1f, 0x53, 0xe5, 0xbc,
      0x0c, 0x27, 0x26, 0x78, 0x99, 0x0a, 0xea, 0x50, 0xa1, 0x24, 0x27, 0x4c,
      0xdf, 0x04, 0x8e, 0xcd, 0xb7, 0x07, 0x4c, 0xa8, 0x6f, 0x36, 0x84, 0x1a,
      0x7a, 0xde, 0x80, 0xa8, 0xae, 0xc6, 0xa6, 0x53, 0xa0, 0x29, 0x2c, 0x82,
      0xa1, 0xb5, 0xc6, 0x78},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes in zero padding modified
    // tcID: 73
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     73,
     32,
     {0x48, 0x4d, 0x71, 0xbe, 0x45, 0x1d, 0x1f, 0x36, 0x67, 0xe0, 0x1f, 0x3e,
      0x7f, 0x1a, 0x80, 0xdb, 0x97, 0x64, 0xf7, 0x51, 0xca, 0x87, 0xff, 0xc6,
      0x35, 0x29, 0x53, 0xa7, 0x73, 0xf6, 0x51, 0x9e, 0x8a, 0x0f, 0x21, 0x0d,
      0x6d, 0x43, 0xb4, 0x17, 0x67, 0x0d, 0x9c, 0x0c, 0xe3, 0xc1, 0x1a, 0x66,
      0x8c, 0xc8, 0x33, 0x94, 0xa5, 0xe2, 0xd7, 0xbc, 0xd4, 0xae, 0x98, 0xe5,
      0x0e, 0xd2, 0x6c, 0x0a, 0xb6, 0x6b, 0x41, 0xad, 0x2e, 0x28, 0xfa, 0x70,
      0x3f, 0x2d, 0xa0, 0x4d, 0xb0, 0x96, 0x38, 0x75, 0x84, 0x2d, 0x90, 0xa7,
      0x78, 0x99, 0x64, 0x2d, 0xc2, 0x97, 0xcf, 0x37, 0xa7, 0x6f, 0xdb, 0x00,
      0x7a, 0x99, 0x0c, 0x5b, 0x7a, 0xf8, 0x3e, 0x26, 0x4b, 0xe9, 0x32, 0x31,
      0x49, 0xfb, 0x68, 0x0a, 0xcb, 0x69, 0xa1, 0x9e, 0x0c, 0x5a, 0xa9, 0x49,
      0xc2, 0x09, 0x4e, 0x0a, 0x18, 0xab, 0xfa, 0x1b, 0x19, 0x9b, 0x73, 0x36,
      0x36, 0x54, 0x63, 0x8d, 0x86, 0xf9, 0xab, 0xe7, 0x3a, 0x67, 0x8f, 0xf0,
      0xa4, 0x1f, 0x6b, 0x70, 0x2b, 0x70, 0xea, 0x1a, 0xed, 0xb2, 0x87, 0xad,
      0xd7, 0x9b, 0x9a, 0x7f, 0x4a, 0x97, 0x53, 0x5d, 0x0d, 0xb4, 0x6c, 0x05,
      0x98, 0x30, 0x72, 0x48, 0x1d, 0xbe, 0x43, 0xfe, 0x6d, 0xfe, 0x33, 0x22,
      0x9c, 0xa1, 0xae, 0xc4, 0x2e, 0x19, 0xaf, 0xeb, 0x5b, 0xd3, 0x5f, 0x1e,
      0x44, 0x26, 0x4c, 0x1f, 0xc6, 0xc1, 0x8f, 0xdd, 0xc9, 0x5f, 0xad, 0xf1,
      0xb1, 0x67, 0x6f, 0x18, 0x5e, 0x5b, 0x55, 0xf9, 0xa2, 0xbf, 0xe6, 0xb6,
      0xd4, 0x02, 0x89, 0xf2, 0x40, 0x63, 0x35, 0x13, 0x82, 0x8a, 0x7b, 0x96,
      0x77, 0x48, 0xbb, 0xf0, 0xcc, 0xd1, 0xd3, 0xfb, 0x9f, 0x62, 0x40, 0xf3,
      0x17, 0x90, 0xa7, 0x89, 0xd8, 0xc7, 0x09, 0xc2, 0x78, 0xdd, 0xbb, 0x0f,
      0x70, 0x67, 0x78, 0xb5},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of hash h modified
    // tcID: 74
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     74,
     32,
     {0x3f, 0x27, 0xe0, 0xfa, 0xfc, 0x57, 0x62, 0x9c, 0xcc, 0x04, 0x32, 0x82,
      0x71, 0x87, 0x76, 0x6a, 0x30, 0x53, 0x7e, 0x82, 0x1a, 0x2f, 0xcd, 0x5f,
      0x10, 0x88, 0x10, 0x0d, 0x4d, 0x8b, 0x6a, 0x6a, 0x9c, 0xe9, 0x50, 0xf5,
      0x11, 0x02, 0xe3, 0xb5, 0x51, 0x67, 0xd4, 0xb4, 0x9e, 0x0b, 0x6a, 0x30,
      0x6e, 0x0f, 0xdf, 0x90, 0x83, 0x7d, 0x06, 0x30, 0x85, 0x90, 0x93, 0xe9,
      0x0a, 0x94, 0xfa, 0x56, 0x4b, 0x7a, 0x4a, 0x82, 0xf4, 0xcc, 0xb7, 0x72,
      0x37, 0x7e, 0x07, 0xa2, 0xb5, 0xa6, 0x87, 0x3d, 0x98, 0xbf, 0x66, 0x5c,
      0x92, 0xdf, 0x1c, 0xe7, 0xcb, 0xdb, 0x58, 0x3c, 0xda, 0x83, 0x94, 0x7b,
      0x3c, 0x9c, 0x3d, 0xf5, 0xb3, 0x80, 0x7b, 0x47, 0x0f, 0x23, 0xf8, 0xd0,
      0x8d, 0xf9, 0xfb, 0xa7, 0x8e, 0x13, 0xd6, 0xb6, 0x35, 0xf9, 0xf5, 0x9d,
      0x2d, 0x4b, 0xaa, 0x34, 0x83, 0x1d, 0xc6, 0xc3, 0xe5, 0xa2, 0x96, 0x95,
      0x64, 0x5b, 0x1e, 0xd5, 0x0f, 0x3a, 0x33, 0x89, 0xe9, 0xe1, 0x19, 0xde,
      0x76, 0x5e, 0x6d, 0x7d, 0xaa, 0xff, 0x0b, 0x45, 0x4e, 0xad, 0xd1, 0x0f,
      0x44, 0x5e, 0x40, 0x2b, 0xf3, 0xcf, 0x4d, 0x14, 0xf4, 0xd1, 0x6c, 0x2d,
      0x9e, 0x4f, 0xb5, 0x57, 0x1c, 0xea, 0x79, 0x29, 0xd5, 0x30, 0x19, 0xd4,
      0x14, 0xd1, 0x18, 0xe8, 0x2d, 0x49, 0x1b, 0xf3, 0xfb, 0x3b, 0xd7, 0x42,
      0x7a, 0xbd, 0x6e, 0xb4, 0x8a, 0x0e, 0xd2, 0x77, 0x22, 0x1c, 0x42, 0x84,
      0x0e, 0xaa, 0x1f, 0xd5, 0xe7, 0xce, 0x65, 0x8f, 0x77, 0x63, 0x09, 0x9c,
      0x1d, 0x59, 0x43, 0x1e, 0x49, 0x8c, 0xb5, 0x83, 0x57, 0xa6, 0x59, 0xae,
      0xa8, 0xe1, 0x81, 0xec, 0x0f, 0xb5, 0xad, 0x8a, 0x55, 0xd1, 0xc0, 0xf1,
      0x29, 0x50, 0x0a, 0x25, 0xb8, 0x5c, 0xbc, 0xc8, 0x73, 0x3f, 0xa3, 0xdf,
      0xa9, 0xea, 0x30, 0xa4},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of hash h modified
    // tcID: 75
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     75,
     32,
     {0x00, 0x6e, 0x3f, 0x34, 0x3b, 0x22, 0xfb, 0xf5, 0xcc, 0xe8, 0x16, 0xef,
      0xbf, 0xe0, 0x66, 0x36, 0xc1, 0x61, 0x96, 0x32, 0x66, 0x55, 0x91, 0xf9,
      0xb1, 0xfd, 0x2b, 0xd0, 0xaa, 0xac, 0x9a, 0x0f, 0x77, 0x6c, 0x50, 0x1d,
      0x7a, 0x23, 0x2f, 0xd2, 0xed, 0xcc, 0x12, 0xac, 0x63, 0xb3, 0xb5, 0x6a,
      0xa1, 0x2a, 0xe8, 0x79, 0x82, 0xc1, 0x99, 0x7e, 0x5a, 0xc5, 0xfd, 0x50,
      0xf6, 0xa5, 0xc3, 0x50, 0xe6, 0xe8, 0x4f, 0xc1, 0x7d, 0x21, 0x49, 0x54,
      0x7b, 0xab, 0xc4, 0x83, 0x0f, 0x8c, 0x2e, 0xef, 0x18, 0x85, 0xe4, 0xbf,
      0xb1, 0x5c, 0x9b, 0x73, 0x32, 0x2b, 0x69, 0x3e, 0xa7, 0x4e, 0xab, 0xf4,
      0x3e, 0x50, 0x50, 0xc4, 0x77, 0xc0, 0xe7, 0x5e, 0xcf, 0x75, 0xcf, 0xe4,
      0x87, 0xf4, 0x1f, 0x4a, 0x2d, 0xf4, 0x97, 0x2a, 0x16, 0xe0, 0x58, 0x0d,
      0x57, 0x94, 0x6d, 0x50, 0x4f, 0xb0, 0x73, 0xf2, 0x3e, 0xa6, 0x91, 0x08,
      0x6e, 0x5b, 0xc4, 0x0e, 0x2b, 0x2e, 0x1d, 0xd6, 0x53, 0xf2, 0xab, 0x20,
      0x1a, 0xd6, 0x09, 0xfd, 0x06, 0x98, 0x3a, 0x5c, 0xeb, 0xb9, 0x86, 0x78,
      0xc0, 0x39, 0x15, 0x05, 0x63, 0xf6, 0xc9, 0x44, 0xbd, 0x65, 0x58, 0xb4,
      0x22, 0xde, 0x25, 0xb9, 0x72, 0x08, 0x87, 0xd9, 0x7e, 0xf6, 0x3b, 0x34,
      0xcd, 0xee, 0x01, 0x39, 0x39, 0x1c, 0x48, 0x55, 0x89, 0x41, 0xba, 0x94,
      0xbd, 0xc0, 0xc2, 0x2e, 0x60, 0x5d, 0xd9, 0xca, 0xe6, 0x69, 0x40, 0x6c,
      0x3d, 0xdb, 0x36, 0x17, 0x87, 0xec, 0x64, 0x37, 0xc8, 0x7a, 0x68, 0x8b,
      0x0c, 0x64, 0xf0, 0x29, 0x0b, 0x1b, 0xc0, 0xce, 0x17, 0x46, 0x65, 0x92,
      0xa4, 0x8b, 0x83, 0xb2, 0x7f, 0x04, 0x42, 0xbd, 0xb1, 0x5e, 0xf7, 0x53,
      0xad, 0x56, 0xea, 0xab, 0xeb, 0x08, 0xbb, 0x3b, 0x7a, 0xce, 0x7f, 0x96,
      0x20, 0xfe, 0xa1, 0x13},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of hash h modified
    // tcID: 76
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     76,
     32,
     {0x83, 0x8d, 0x0a, 0xd3, 0x4f, 0x23, 0x93, 0xae, 0xc5, 0x36, 0x82, 0xed,
      0x48, 0xf9, 0x37, 0xa4, 0x58, 0xa3, 0x22, 0x16, 0xa7, 0x4d, 0xcc, 0x4a,
      0x1e, 0x59, 0x1a, 0x53, 0x81, 0x19, 0xc3, 0xb5, 0x6c, 0xad, 0x78, 0xb1,
      0xc4, 0xb7, 0x22, 0x94, 0x83, 0x73, 0xc5, 0x1c, 0x04, 0xa5, 0x0e, 0x46,
      0xfb, 0x5f, 0x30, 0x34, 0xf4, 0x3c, 0x5d, 0x26, 0x03, 0x64, 0x61, 0x7e,
      0x6f, 0x03, 0xaf, 0x7d, 0x75, 0xd6, 0x6b, 0xaf, 0x3d, 0xfa, 0x1c, 0xa9,
      0x4e, 0x75, 0xe7, 0x7d, 0x30, 0x4c, 0x63, 0xea, 0x50, 0x15, 0xcd, 0xd7,
      0xfb, 0x1e, 0x1c, 0xdf, 0xbd, 0x6b, 0x5e, 0xbe, 0xf2, 0xb2, 0xad, 0xdf,
      0x69, 0x7f, 0x14, 0xc9, 0x7c, 0xf9, 0xb5, 0xcb, 0xb1, 0xba, 0xb7, 0xf6,
      0x12, 0xb3, 0xa4, 0x28, 0xd3, 0x2c, 0xef, 0xbb, 0x78, 0x8b, 0xdb, 0x70,
      0x72, 0x9e, 0x53, 0xd5, 0xb8, 0xcd, 0x14, 0xf5, 0x86, 0xaa, 0x2b, 0x94,
      0x10, 0xbb, 0xae, 0x2d, 0x09, 0x3b, 0xd1, 0x1f, 0x49, 0x14, 0x69, 0x47,
      0x9e, 0xb6, 0x40, 0x84, 0x75, 0x14, 0xd7, 0x22, 0x69, 0xcd, 0xda, 0xb4,
      0x84, 0xd8, 0x82, 0xaa, 0xa9, 0x76, 0x18, 0x39, 0xac, 0xa9, 0x85, 0x1b,
      0x3d, 0x40, 0x92, 0x11, 0xde, 0x83, 0xdf, 0x74, 0x26, 0x74, 0xd6, 0x30,
      0x5c, 0xc3, 0xa7, 0x11, 0x43, 0xfa, 0x50, 0x77, 0xbc, 0xe9, 0xd3, 0xc8,
      0xda, 0x1f, 0x6d, 0xa0, 0xdf, 0x5c, 0x27, 0x1f, 0x04, 0x8b, 0xa5, 0x89,
      0xe5, 0xc3, 0x4a, 0x23, 0xef, 0x12, 0x74, 0x72, 0x99, 0xd9, 0xdc, 0x42,
      0x99, 0x58, 0x93, 0x64, 0xf2, 0x13, 0x7a, 0xce, 0x59, 0x78, 0x1e, 0x3f,
      0x01, 0x01, 0x1a, 0xe1, 0x45, 0xa5, 0xe1, 0xaf, 0x20, 0xc7, 0x45, 0x16,
      0xe0, 0xb5, 0x6d, 0x72, 0x9e, 0x49, 0xb3, 0xde, 0x31, 0x0c, 0x19, 0x7e,
      0x7a, 0x76, 0x0e, 0xfa},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of hash h modified
    // tcID: 77
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     77,
     32,
     {0x6b, 0x19, 0xa0, 0x3c, 0x77, 0x4e, 0x1c, 0x3c, 0x24, 0xea, 0x88, 0x9b,
      0x55, 0x2e, 0x99, 0xfe, 0x00, 0x68, 0xa6, 0xcd, 0xa0, 0x22, 0xd5, 0xcc,
      0xb6, 0xd7, 0x5a, 0x44, 0x7c, 0xfa, 0x0b, 0x16, 0xb5, 0xb1, 0x44, 0x20,
      0x8d, 0xd4, 0x07, 0xe4, 0x40, 0x23, 0x0f, 0xfa, 0xad, 0x4f, 0x12, 0xa0,
      0x74, 0x6d, 0xa1, 0x08, 0xda, 0xb5, 0xd4, 0xf1, 0x62, 0xbd, 0xc9, 0xb2,
      0x4d, 0xc6, 0x8a, 0x2e, 0x9e, 0x07, 0x7e, 0xf5, 0x70, 0x24, 0x72, 0xc4,
      0xce, 0xaa, 0x89, 0xc2, 0x9c, 0xac, 0x41, 0xb4, 0x78, 0x2b, 0x92, 0xf6,
      0xc8, 0x7e, 0x01, 0x4d, 0xf2, 0x48, 0x35, 0x80, 0xca, 0xdf, 0x2b, 0x45,
      0x5f, 0x82, 0x3f, 0xe1, 0x2c, 0x9c, 0x79, 0xa1, 0x55, 0xea, 0x32, 0xa9,
      0xf1, 0xed, 0x12, 0x0f, 0xe0, 0xf1, 0x3b, 0x10, 0xab, 0x47, 0x92, 0xfd,
      0x94, 0xb9, 0x9e, 0x0a, 0xa6, 0xff, 0xd2, 0x7c, 0x04, 0xef, 0x70, 0x88,
      0xe3, 0xcb, 0x93, 0x54, 0x36, 0x52, 0x96, 0x50, 0x89, 0x4f, 0xee, 0x6b,
      0x5b, 0x78, 0xe0, 0xbb, 0x5a, 0xa5, 0x9e, 0xe7, 0xbb, 0xb2, 0xfb, 0x46,
      0xaf, 0x78, 0x4e, 0x2c, 0x33, 0xeb, 0x76, 0xa1, 0x2c, 0xdd, 0x7d, 0x00,
      0x87, 0xa0, 0x81, 0xd8, 0x2d, 0x3e, 0x46, 0x6a, 0x38, 0x1d, 0xd3, 0x7d,
      0x25, 0xd3, 0xb4, 0xa9, 0x27, 0x56, 0x72, 0x3c, 0xb1, 0xf1, 0xf4, 0x9d,
      0x04, 0x81, 0xd1, 0x2b, 0xaa, 0x21, 0xff, 0x77, 0xc0, 0x29, 0x1f, 0x90,
      0x26, 0x82, 0x22, 0x6d, 0x99, 0xd7, 0x7d, 0x36, 0xbf, 0xe5, 0x8d, 0x18,
      0x25, 0x98, 0x8c, 0x97, 0xd9, 0xd0, 0x0e, 0x15, 0xab, 0x48, 0xc9, 0x91,
      0x95, 0x83, 0xfd, 0x60, 0x59, 0x3f, 0xa9, 0x3a, 0xb1, 0xca, 0x8e, 0x7d,
      0xab, 0xaa, 0x91, 0x2f, 0x65, 0x35, 0xbb, 0xb0, 0x5e, 0x82, 0xbb, 0xfa,
      0xa8, 0x53, 0x7b, 0x0e},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes of h replaced by 0
    // tcID: 78
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     78,
     32,
     {0x68, 0x26, 0x73, 0xd7, 0xc9, 0x8a, 0xe7, 0x00, 0x39, 0xe9, 0xf2, 0x59,
      0x27, 0x5c, 0x88, 0x4d, 0xa7, 0xc7, 0x71, 0x36, 0xe0, 0x6d, 0x47, 0xe8,
      0xaf, 0x72, 0xf8, 0x2a, 0x09, 0x61, 0x4a, 0x08, 0xed, 0x12, 0x5c, 0x6d,
      0x3a, 0x80, 0xf7, 0x01, 0xa6, 0x1d, 0xc2, 0xad, 0x96, 0x7e, 0x96, 0x37,
      0x66, 0x2b, 0xf4, 0x0b, 0x48, 0x54, 0x3e, 0x5b, 0x62, 0x0d, 0xaf, 0x37,
      0xe3, 0x08, 0x8d, 0x2a, 0x54, 0xa8, 0xc5, 0x14, 0x7e, 0xf9, 0x92, 0x27,
      0xcd, 0x5c, 0xfd, 0x0a, 0x47, 0x8d, 0x1f, 0xd1, 0xec, 0x62, 0xc4, 0x95,
      0xcb, 0x89, 0x04, 0x6d, 0xf7, 0x56, 0x90, 0x86, 0x21, 0x09, 0x99, 0x13,
      0xaa, 0x41, 0x42, 0xc3, 0xdb, 0xa2, 0xa6, 0x2d, 0xe6, 0xa8, 0x89, 0x9f,
      0x0a, 0xcc, 0x79, 0x32, 0xe3, 0x35, 0x81, 0xd4, 0x10, 0x20, 0x20, 0x42,
      0x3a, 0x99, 0x87, 0x67, 0x77, 0xc5, 0x92, 0x92, 0xd5, 0x97, 0x42, 0x8f,
      0x50, 0xb8, 0x46, 0xa3, 0x9d, 0x70, 0x9d, 0x38, 0xc3, 0xa8, 0x42, 0xf9,
      0xa9, 0x53, 0x1f, 0x26, 0xdc, 0x2a, 0x11, 0xf5, 0x18, 0x95, 0x0e, 0xee,
      0x92, 0x56, 0x0f, 0xb6, 0xb6, 0x66, 0x7a, 0x11, 0x32, 0x37, 0xa3, 0xe6,
      0xd7, 0xbd, 0xae, 0x48, 0xba, 0xfc, 0x90, 0xa7, 0x6a, 0x68, 0x39, 0xb9,
      0x7e, 0x63, 0x01, 0xe5, 0x46, 0xf5, 0xb1, 0x36, 0xff, 0x23, 0xd6, 0x62,
      0x59, 0x3f, 0x74, 0x92, 0x0d, 0xcc, 0xb5, 0x6d, 0x47, 0xfe, 0xa5, 0x57,
      0xad, 0xca, 0x4b, 0x36, 0x82, 0x04, 0x69, 0x42, 0x5c, 0xdd, 0x40, 0x71,
      0xad, 0xe7, 0xc5, 0xc1, 0x4f, 0x36, 0x5b, 0xa4, 0xe0, 0xda, 0x97, 0xcd,
      0xd6, 0x2c, 0xec, 0x66, 0xfd, 0xc7, 0x24, 0xd3, 0xf3, 0x09, 0xb6, 0x29,
      0x7c, 0x1c, 0x84, 0x09, 0x1a, 0x74, 0xd6, 0x56, 0xb4, 0xb0, 0x30, 0x78,
      0x7d, 0xf5, 0x93, 0xb0},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bits of h replaced by 1s
    // tcID: 79
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     79,
     32,
     {0x14, 0x52, 0xce, 0xf4, 0xf4, 0xe0, 0xd4, 0x6c, 0xa8, 0xca, 0xf3, 0xa6,
      0x28, 0x07, 0x4f, 0x7e, 0xd0, 0xac, 0xaf, 0xd0, 0xa1, 0x6c, 0x4c, 0x4c,
      0x42, 0x3c, 0xd3, 0x61, 0xcd, 0x61, 0x31, 0x9d, 0x5e, 0x91, 0x2b, 0x16,
      0x2b, 0xb2, 0xb7, 0x32, 0x6e, 0x56, 0xe2, 0x0d, 0x5f, 0x98, 0x14, 0xd6,
      0x33, 0x9e, 0x0c, 0xc4, 0x4d, 0xa9, 0xba, 0x1b, 0xe2, 0x8e, 0x47, 0x38,
      0x80, 0xb6, 0x27, 0x6a, 0x86, 0xb8, 0xcd, 0xfd, 0x91, 0xd2, 0xf5, 0xfa,
      0x83, 0x00, 0x24, 0xb8, 0x42, 0x83, 0x4b, 0xcf, 0x2d, 0x42, 0x5c, 0x48,
      0xb5, 0xa5, 0x84, 0x64, 0xb7, 0xa3, 0x11, 0x1f, 0x55, 0xad, 0xe2, 0xd3,
      0xb9, 0xcd, 0xb9, 0x58, 0x39, 0x2e, 0xfd, 0x55, 0x9f, 0x6b, 0x61, 0x36,
      0xcd, 0x15, 0x8e, 0x15, 0x7f, 0xaa, 0x4b, 0x7e, 0xe8, 0x6a, 0x34, 0x57,
      0xdc, 0xdb, 0xd8, 0x77, 0xb8, 0x2d, 0x53, 0xc2, 0x3d, 0x6e, 0x71, 0x48,
      0x8e, 0x55, 0x45, 0x74, 0xb7, 0x8f, 0x0b, 0xe7, 0x2d, 0xa8, 0xd4, 0x16,
      0x0a, 0xee, 0x68, 0x0c, 0xe4, 0x85, 0xf9, 0xfa, 0x54, 0x45, 0x62, 0xa1,
      0x2a, 0x89, 0x32, 0x85, 0x60, 0xa7, 0x73, 0xff, 0x25, 0x13, 0x8d, 0xec,
      0xf4, 0x20, 0x0e, 0x25, 0x58, 0xe3, 0xb5, 0xa3, 0x64, 0xa4, 0x37, 0x2c,
      0xd1, 0xf6, 0x4f, 0xb2, 0x58, 0x87, 0xb8, 0xc2, 0xb3, 0x93, 0x8a, 0xca,
      0x10, 0xd8, 0x72, 0x75, 0x35, 0xd0, 0xeb, 0x0b, 0x73, 0xaf, 0x2b, 0x7a,
      0xd7, 0x06, 0x56, 0xf9, 0x7c, 0x5c, 0x1a, 0x97, 0xd3, 0xe2, 0xc2, 0xd1,
      0xcd, 0x27, 0x32, 0xc5, 0xfe, 0x8f, 0xdc, 0x5b, 0xa6, 0xf5, 0x54, 0xbd,
      0x51, 0x90, 0xa5, 0x47, 0x42, 0x31, 0x3a, 0x61, 0x75, 0xdb, 0x2a, 0x77,
      0xd3, 0x6d, 0x24, 0x93, 0x4d, 0xc0, 0x56, 0xd6, 0x6c, 0xc6, 0xbd, 0x83,
      0xab, 0xac, 0x61, 0xe0},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bits in hash h flipped
    // tcID: 80
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     80,
     32,
     {0x2f, 0x5a, 0xb0, 0x41, 0xe8, 0x7b, 0x74, 0xc0, 0xff, 0xa6, 0xf5, 0xb0,
      0xa4, 0xc5, 0xec, 0x8d, 0x0e, 0xe3, 0xd2, 0x35, 0x7a, 0x0f, 0xd2, 0xfa,
      0xce, 0x27, 0x5d, 0xbc, 0x6b, 0x50, 0xa2, 0x30, 0xf2, 0x10, 0x8b, 0x4b,
      0x37, 0xfa, 0x45, 0xd5, 0xbb, 0x12, 0x11, 0xfb, 0x26, 0xb9, 0x6d, 0x31,
      0x5c, 0xec, 0x93, 0x91, 0xd1, 0x98, 0xad, 0x77, 0x13, 0xfa, 0xf3, 0xc4,
      0xfb, 0x60, 0x80, 0x6c, 0xbe, 0x63, 0x78, 0xc7, 0xa0, 0x8c, 0x2e, 0x75,
      0xa6, 0x78, 0x48, 0xca, 0x98, 0xc8, 0x0a, 0x02, 0x68, 0x06, 0x50, 0xed,
      0xa9, 0x8f, 0xf0, 0xc8, 0x18, 0xf1, 0xe7, 0xaf, 0x9f, 0xf3, 0xa3, 0x23,
      0x61, 0x50, 0x69, 0x9a, 0x4c, 0x90, 0x0c, 0x39, 0x4c, 0x2a, 0x00, 0xea,
      0x65, 0xb3, 0x9f, 0xea, 0x87, 0x35, 0x04, 0x89, 0x8c, 0x6f, 0xce, 0xd5,
      0xe4, 0x52, 0x0b, 0xf3, 0xd6, 0x9a, 0x11, 0xde, 0xbd, 0x3e, 0x66, 0xad,
      0x68, 0x1b, 0x7d, 0x03, 0xbb, 0xca, 0x94, 0x0f, 0xbc, 0x80, 0x9f, 0x03,
      0xf9, 0x90, 0x79, 0xd0, 0xf2, 0x4f, 0x31, 0xcd, 0xc7, 0x6a, 0xfa, 0xb7,
      0x3e, 0xc0, 0xb4, 0xf5, 0xba, 0xff, 0x44, 0x37, 0xb0, 0xa3, 0x04, 0xa8,
      0x89, 0x3c, 0xf5, 0x93, 0xbc, 0xf4, 0x7b, 0x2f, 0x63, 0xa4, 0x01, 0xf1,
      0xb4, 0x56, 0xf1, 0x74, 0x1b, 0x3b, 0x36, 0x41, 0xe3, 0x15, 0x4e, 0x6f,
      0x4b, 0xc0, 0x35, 0x72, 0x3f, 0xc3, 0x53, 0x2e, 0xe2, 0x2d, 0x4f, 0x65,
      0xa3, 0x96, 0x3c, 0x1b, 0x27, 0x8c, 0x1a, 0x9a, 0x8c, 0xe7, 0xe0, 0x48,
      0x76, 0xe8, 0xc3, 0x27, 0xa7, 0x04, 0x63, 0xe3, 0x78, 0x5b, 0x9a, 0x5a,
      0xa5, 0xb4, 0xa5, 0x0c, 0xb4, 0xe3, 0x5d, 0x92, 0x08, 0x51, 0x72, 0xa6,
      0x1c, 0xc5, 0x40, 0x7a, 0xf2, 0x75, 0x2a, 0x59, 0xd0, 0x6b, 0x58, 0xa2,
      0x42, 0x92, 0x63, 0x28},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: hash of salt missing
    // tcID: 81
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     81,
     32,
     {0x83, 0xd3, 0xf4, 0xb1, 0x8d, 0x26, 0x53, 0x18, 0x95, 0x72, 0xe7, 0x5e,
      0x9b, 0x44, 0x64, 0x29, 0x2c, 0xa6, 0x49, 0x59, 0x1a, 0x82, 0xb1, 0x56,
      0x9c, 0xe1, 0x38, 0x38, 0xc2, 0x45, 0xda, 0x67, 0x37, 0x1b, 0x1e, 0xa7,
      0x8e, 0x42, 0x15, 0xeb, 0xa8, 0xde, 0x71, 0x34, 0x11, 0xff, 0x06, 0x0a,
      0x98, 0x04, 0x05, 0xf0, 0xba, 0xd9, 0x95, 0x46, 0x98, 0x91, 0x53, 0x01,
      0x7a, 0x38, 0x0f, 0x9c, 0x7b, 0x56, 0x65, 0x00, 0xfd, 0xd5, 0xa1, 0x58,
      0x30, 0xeb, 0x0c, 0x5f, 0x47, 0x23, 0xe3, 0x41, 0x39, 0x12, 0x68, 0x93,
      0x3a, 0x41, 0x31, 0x1e, 0x98, 0x32, 0xb3, 0x40, 0xef, 0xbc, 0x2c, 0xff,
      0xb4, 0xba, 0xa9, 0xc5, 0xdd, 0x47, 0x78, 0x3e, 0xac, 0x81, 0xa4, 0x1e,
      0x3d, 0x63, 0x36, 0x57, 0x2d, 0x38, 0xb0, 0x34, 0xdf, 0xe5, 0xef, 0x4b,
      0x94, 0xe5, 0xc3, 0xf9, 0x03, 0xcf, 0x3e, 0x8e, 0x0a, 0x3c, 0x2c, 0x59,
      0xcf, 0xd1, 0x3f, 0x99, 0xf6, 0x96, 0xb0, 0xfb, 0xfe, 0x71, 0x36, 0x8c,
      0xda, 0x5a, 0x1d, 0x28, 0xba, 0xd1, 0xaf, 0x3c, 0x89, 0x76, 0xe3, 0xf6,
      0xc1, 0xba, 0xc0, 0x87, 0x07, 0xd2, 0x68, 0x4f, 0x6d, 0x55, 0xc2, 0xed,
      0x4b, 0x43, 0x3c, 0x9e, 0xfd, 0xe9, 0x1b, 0x20, 0x6e, 0x08, 0x42, 0xe5,
      0x34, 0xbe, 0x7e, 0x88, 0xfa, 0x21, 0x97, 0x63, 0xb9, 0x60, 0xd9, 0xd5,
      0xa4, 0x3a, 0x47, 0x99, 0x90, 0xaa, 0x97, 0x32, 0x66, 0x16, 0x93, 0xb9,
      0xe4, 0xda, 0x89, 0xa7, 0xbb, 0x5d, 0xda, 0x87, 0x8a, 0xe4, 0x3f, 0x5e,
      0x1a, 0x11, 0x94, 0x4f, 0x7a, 0x5c, 0x6e, 0xfa, 0xd6, 0x00, 0xdd, 0xd1,
      0x3a, 0x14, 0x8c, 0x1f, 0xc8, 0xfd, 0x25, 0x74, 0xb9, 0x66, 0x73, 0x42,
      0xc7, 0x3f, 0x2a, 0x8b, 0x96, 0x51, 0x1a, 0x5f, 0x75, 0xcb, 0x1c, 0xe4,
      0x86, 0xb9, 0xdf, 0x81},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of ps modified
    // tcID: 82
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     82,
     32,
     {0x31, 0xce, 0x7c, 0xa5, 0x97, 0xf7, 0x6a, 0xb9, 0x5d, 0x47, 0x56, 0x3f,
      0x72, 0x8f, 0xf9, 0x3b, 0xf4, 0x3d, 0x98, 0x64, 0xe5, 0xbd, 0x12, 0x29,
      0xb8, 0x24, 0xae, 0x26, 0xb5, 0xa1, 0x3c, 0x79, 0xf6, 0xf7, 0x95, 0x72,
      0x17, 0xb3, 0x7e, 0x1a, 0xf0, 0x53, 0x7f, 0xea, 0x81, 0x61, 0x61, 0x87,
      0xff, 0x08, 0xa0, 0xd5, 0xc9, 0x8a, 0x92, 0xda, 0x8d, 0xba, 0x61, 0xbc,
      0x5c, 0x14, 0xda, 0x33, 0x21, 0xfd, 0x11, 0x46, 0xd8, 0x3c, 0x2c, 0xbd,
      0x0e, 0xc0, 0x68, 0x7d, 0x81, 0xf6, 0xd7, 0x34, 0x9f, 0x5a, 0x0c, 0xab,
      0x08, 0x40, 0xe2, 0x2c, 0xbf, 0xa8, 0x3f, 0x02, 0xa7, 0x9d, 0x32, 0x1f,
      0xf8, 0x88, 0x30, 0xd4, 0x7d, 0x48, 0x42, 0xc0, 0xb0, 0x32, 0xc2, 0x7a,
      0x18, 0x1a, 0xc0, 0x6a, 0x42, 0xcd, 0x0b, 0xfe, 0xda, 0xf7, 0x5f, 0x2d,
      0xaa, 0x53, 0xf6, 0x4e, 0xac, 0xb5, 0x98, 0x65, 0x45, 0xbc, 0xf1, 0x50,
      0xb8, 0xd4, 0x33, 0xe6, 0x6b, 0x69, 0x8f, 0x25, 0x53, 0xf9, 0xda, 0x25,
      0x9b, 0xec, 0x31, 0x9d, 0x8c, 0x0c, 0xec, 0x05, 0xd9, 0xc3, 0x20, 0xe7,
      0x30, 0x04, 0x63, 0xd4, 0x1e, 0xb0, 0x77, 0x02, 0x8c, 0x1e, 0x0a, 0x7d,
      0x6d, 0x87, 0xd4, 0xdd, 0xdf, 0x54, 0xc5, 0xb7, 0x8d, 0x6a, 0x15, 0xe4,
      0x52, 0x7e, 0x37, 0x11, 0x0b, 0x9b, 0x9a, 0xd2, 0xf3, 0xb2, 0xdd, 0x0d,
      0xb5, 0x91, 0x22, 0x7d, 0x41, 0xcc, 0x9f, 0x26, 0xf2, 0x34, 0x95, 0x81,
      0xdd, 0x89, 0xe0, 0xba, 0x63, 0x9d, 0x0c, 0xf9, 0xf8, 0xc8, 0x6f, 0xe8,
      0x19, 0xdb, 0xad, 0xc6, 0x88, 0x52, 0x2b, 0x58, 0xd7, 0x28, 0x4c, 0xaa,
      0xbf, 0x84, 0x3e, 0x71, 0x43, 0x39, 0x52, 0x55, 0xe9, 0xa0, 0xd7, 0x10,
      0xff, 0xbe, 0xf6, 0xad, 0x13, 0xf6, 0xa9, 0x36, 0x1e, 0x20, 0xd2, 0xf6,
      0xf5, 0xa4, 0x14, 0xf5},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of ps modified
    // tcID: 83
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     83,
     32,
     {0x57, 0x98, 0x78, 0x51, 0x87, 0x91, 0x07, 0x03, 0x68, 0x0c, 0xb2, 0x10,
      0x9f, 0x49, 0x2c, 0x3f, 0x0a, 0x91, 0xb4, 0xa8, 0xf1, 0x1d, 0x3d, 0xa7,
      0x75, 0xab, 0xa8, 0x91, 0xee, 0xde, 0xc3, 0xd7, 0x6f, 0xd3, 0x0a, 0x93,
      0x9f, 0x5d, 0x7a, 0x2b, 0xaf, 0x72, 0x90, 0xc5, 0x73, 0xe8, 0x86, 0xce,
      0xc8, 0xec, 0xec, 0x0b, 0x15, 0x98, 0xf2, 0xcd, 0x16, 0x9d, 0x53, 0xb4,
      0xab, 0xf8, 0xac, 0xcc, 0x09, 0x70, 0x91, 0x87, 0xf3, 0x2a, 0x12, 0xc8,
      0x0f, 0xdb, 0x42, 0xed, 0x98, 0xd9, 0xe9, 0x8b, 0x09, 0x23, 0x82, 0x8f,
      0x0e, 0x38, 0xac, 0xc3, 0x38, 0x23, 0x4f, 0x7b, 0x7a, 0x0e, 0xe3, 0x77,
      0x64, 0x4a, 0x65, 0x5f, 0x48, 0x81, 0x6e, 0xa4, 0xa5, 0xbf, 0xf0, 0xf6,
      0xd6, 0x3c, 0x39, 0x45, 0xdc, 0x3a, 0xaf, 0x92, 0x1e, 0x94, 0x04, 0x86,
      0x45, 0x94, 0xbc, 0x32, 0x3c, 0x1f, 0x3e, 0xf4, 0x2f, 0x93, 0x61, 0xed,
      0x6c, 0xb8, 0xfc, 0xff, 0x29, 0x94, 0x29, 0x3e, 0x17, 0x86, 0x5e, 0x2f,
      0xad, 0x2d, 0x88, 0x52, 0x77, 0x25, 0x1f, 0xa2, 0x4d, 0x7e, 0x7a, 0xac,
      0xeb, 0xc4, 0x8d, 0x61, 0xc3, 0xb4, 0x80, 0x47, 0xdd, 0x7c, 0x99, 0x82,
      0x6b, 0x31, 0x05, 0xd2, 0xf8, 0x20, 0xcd, 0x62, 0x40, 0x4c, 0xad, 0x5d,
      0x75, 0x8d, 0xa4, 0x61, 0xaf, 0x67, 0x67, 0x7e, 0x39, 0xe5, 0x50, 0x86,
      0xd8, 0xfa, 0x52, 0xea, 0x03, 0x34, 0xbc, 0x3b, 0x77, 0xf9, 0x51, 0x91,
      0xff, 0xac, 0xd2, 0x8e, 0xad, 0x07, 0xa3, 0x4e, 0x46, 0x72, 0x57, 0x7c,
      0x4c, 0x65, 0xb5, 0xbb, 0x9d, 0x5f, 0x9c, 0xab, 0x6e, 0x1f, 0x12, 0x42,
      0x21, 0x62, 0x91, 0xb6, 0x9a, 0x0c, 0x98, 0x71, 0x44, 0x52, 0xf0, 0x1f,
      0x37, 0x72, 0x2f, 0xf2, 0x65, 0x89, 0x73, 0x4c, 0xf6, 0x02, 0x0c, 0x5a,
      0xc9, 0x19, 0x63, 0x74},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes of ps changed to 0xff
    // tcID: 84
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     84,
     32,
     {0x37, 0x47, 0xc7, 0xc1, 0x16, 0xcf, 0x30, 0x56, 0x7e, 0x24, 0xfd, 0x42,
      0x13, 0xc1, 0x26, 0xec, 0x84, 0x36, 0x6a, 0x26, 0xeb, 0x30, 0x4a, 0x65,
      0xd1, 0x44, 0xdd, 0x9b, 0x45, 0x30, 0x54, 0xdf, 0x4e, 0x50, 0x36, 0xc8,
      0x61, 0xb5, 0x80, 0x71, 0x37, 0x93, 0x4b, 0x1c, 0xef, 0x35, 0x14, 0x11,
      0xe4, 0x06, 0x54, 0xba, 0xe5, 0xdf, 0x6f, 0xbe, 0x3c, 0x42, 0xd7, 0x63,
      0x40, 0x7f, 0x27, 0x3d, 0x3d, 0xbe, 0x05, 0x9f, 0xc6, 0x41, 0x2a, 0x36,
      0x67, 0x75, 0x60, 0x3e, 0x06, 0x4b, 0x15, 0x61, 0xa5, 0x8e, 0x70, 0x86,
      0x0e, 0xdf, 0x95, 0x4d, 0xbe, 0x66, 0x6f, 0x8f, 0xe4, 0x4f, 0x44, 0xf8,
      0x7d, 0xf3, 0xb0, 0xe3, 0xf3, 0xe1, 0x9c, 0x90, 0x49, 0x66, 0xad, 0xa5,
      0x2f, 0x00, 0x80, 0x6f, 0x97, 0x5f, 0x25, 0x6d, 0x4a, 0x85, 0x5c, 0xee,
      0x97, 0x3e, 0x20, 0xf3, 0x3c, 0x31, 0xf9, 0xf2, 0xb3, 0x79, 0x2f, 0xcf,
      0x32, 0x6f, 0x07, 0x5f, 0x86, 0xf2, 0x75, 0xd8, 0xef, 0x8d, 0xf2, 0xdd,
      0x0a, 0xba, 0xc8, 0x3d, 0x49, 0x1d, 0x48, 0x5f, 0xc1, 0x67, 0xcd, 0x40,
      0xf3, 0x80, 0x2f, 0x66, 0x03, 0x6d, 0xf4, 0xfd, 0x64, 0xfc, 0x44, 0x1a,
      0xc8, 0xa2, 0x5b, 0x40, 0x5d, 0x5e, 0xf9, 0x60, 0x12, 0x76, 0x23, 0xc2,
      0x69, 0xca, 0x83, 0x66, 0x71, 0xa6, 0x6a, 0x6b, 0xf2, 0xf3, 0x9c, 0x07,
      0x92, 0xda, 0xde, 0x17, 0x56, 0x4d, 0x31, 0x86, 0x3c, 0x7e, 0x01, 0x61,
      0xee, 0x0b, 0xb8, 0x85, 0x22, 0xac, 0x0c, 0x90, 0x54, 0xbe, 0xbc, 0xed,
      0xb6, 0x03, 0xa2, 0xd1, 0x8d, 0xdb, 0x0f, 0x64, 0xa9, 0x1c, 0xa5, 0xa2,
      0xf0, 0x08, 0x6a, 0xfd, 0x0d, 0x8c, 0x07, 0xcb, 0x0c, 0x1e, 0x7f, 0x24,
      0xd1, 0x2f, 0x86, 0x6c, 0xdc, 0xde, 0x46, 0xd6, 0x63, 0xc1, 0xd4, 0xdc,
      0x7f, 0x7c, 0x6f, 0x62},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes of ps changed to 0x80
    // tcID: 85
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     85,
     32,
     {0x13, 0x77, 0xd4, 0x99, 0x7c, 0x03, 0xd8, 0x85, 0xe4, 0xb9, 0x5f, 0x03,
      0x50, 0xb1, 0xc8, 0x09, 0x1a, 0x4d, 0x9b, 0xee, 0xf9, 0x53, 0x3d, 0xc6,
      0xab, 0xd1, 0x94, 0xa1, 0x43, 0x9c, 0x38, 0x36, 0x22, 0xb9, 0xdc, 0xa5,
      0xa4, 0x9d, 0xa2, 0x47, 0xcd, 0x55, 0xc0, 0x21, 0x86, 0x82, 0x9f, 0x69,
      0x5e, 0xbb, 0x00, 0x7e, 0xf0, 0x53, 0x5c, 0x47, 0x57, 0xba, 0xad, 0x05,
      0x7d, 0x7b, 0xf7, 0x6d, 0xcf, 0xe3, 0x7c, 0xb9, 0x18, 0x1b, 0x0c, 0x29,
      0x0d, 0xb1, 0x6d, 0x0a, 0xbc, 0x51, 0xff, 0x32, 0xd0, 0x3b, 0x6a, 0x8e,
      0x56, 0xec, 0xd2, 0x70, 0xda, 0xc2, 0x31, 0xc8, 0x1e, 0x50, 0xc7, 0xe0,
      0x20, 0x3d, 0x22, 0xb9, 0x91, 0x29, 0x1f, 0xec, 0x65, 0x0b, 0x99, 0x04,
      0xb2, 0x53, 0x9a, 0x8a, 0x33, 0x01, 0x72, 0x84, 0x3b, 0xcf, 0xf0, 0xcf,
      0x46, 0xf0, 0x6e, 0x32, 0xf5, 0x5b, 0xec, 0x1f, 0x5a, 0x73, 0x4e, 0x70,
      0xec, 0x8e, 0x4e, 0x88, 0x83, 0xe3, 0xc2, 0x2e, 0xab, 0x75, 0x61, 0xd9,
      0xc7, 0x67, 0x37, 0x02, 0x53, 0x52, 0xb5, 0xc9, 0xfa, 0x9c, 0x76, 0xea,
      0xac, 0xb9, 0x09, 0xd2, 0x3d, 0x0d, 0x7d, 0x7b, 0x6f, 0x10, 0x94, 0xcc,
      0xec, 0x8b, 0xa9, 0x4f, 0x14, 0x9f, 0x81, 0x94, 0x6f, 0xae, 0xdb, 0x39,
      0xac, 0x55, 0x7c, 0xc2, 0x88, 0x17, 0xc9, 0x11, 0x4a, 0x89, 0xa6, 0xf7,
      0x20, 0xd8, 0x49, 0xf9, 0x0c, 0xb2, 0x3a, 0xd2, 0x02, 0xed, 0x46, 0x82,
      0x03, 0x6b, 0x3c, 0xb7, 0x0b, 0x6f, 0xd5, 0xdf, 0x02, 0x25, 0x90, 0x0e,
      0xae, 0xc7, 0xa2, 0x1e, 0x39, 0xfd, 0x43, 0x3d, 0x32, 0x00, 0xae, 0xd4,
      0xbb, 0x4a, 0xbc, 0x3b, 0x53, 0x13, 0x93, 0xfa, 0x46, 0x2f, 0xbc, 0x92,
      0x0c, 0x91, 0x8f, 0x19, 0x38, 0xd3, 0x3c, 0xa8, 0x6e, 0x7c, 0xa3, 0xbb,
      0xf1, 0xd3, 0x4d, 0x74},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: ps followed by 0
    // tcID: 86
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     86,
     32,
     {0x7d, 0x0f, 0x3c, 0xeb, 0xb4, 0x37, 0x25, 0x69, 0xe8, 0xf0, 0x2d, 0xf9,
      0xf4, 0x22, 0x22, 0x15, 0x1c, 0xc3, 0x16, 0x59, 0xdf, 0x8d, 0x50, 0x78,
      0xe9, 0xee, 0x8e, 0x91, 0x03, 0x07, 0x35, 0xd2, 0x7e, 0x66, 0xda, 0x8c,
      0x87, 0x03, 0x9a, 0x27, 0xac, 0x28, 0x58, 0x8e, 0x84, 0x31, 0xd7, 0xad,
      0x15, 0x83, 0x53, 0x4e, 0x85, 0x70, 0x31, 0x8c, 0xbb, 0x25, 0x54, 0xc0,
      0x70, 0x16, 0xbf, 0xb0, 0x2f, 0xe5, 0x9a, 0xf0, 0x05, 0x76, 0xb7, 0x90,
      0x82, 0x86, 0xf4, 0xb2, 0x7e, 0x36, 0xf7, 0x68, 0xa1, 0x18, 0xc3, 0xf3,
      0xa1, 0xce, 0xae, 0xff, 0xee, 0x03, 0xa1, 0xb6, 0x72, 0x70, 0xc3, 0xe4,
      0x89, 0xcc, 0xe5, 0xc5, 0xf1, 0x17, 0x1e, 0x0a, 0x87, 0x34, 0x55, 0x34,
      0x03, 0x04, 0x7f, 0xaf, 0xf6, 0x80, 0xdb, 0xcd, 0x70, 0xbf, 0x0f, 0xc1,
      0xf0, 0xf4, 0x46, 0x1b, 0xd4, 0xe6, 0x8c, 0x6c, 0x09, 0x78, 0xda, 0x34,
      0x90, 0xa1, 0x37, 0xdd, 0xd8, 0xf6, 0x2b, 0xd7, 0x9c, 0x6a, 0x1d, 0xaf,
      0x70, 0xf7, 0xa9, 0xa3, 0xe9, 0x00, 0x56, 0xcc, 0xd4, 0x1c, 0x62, 0xf0,
      0x49, 0x15, 0xbf, 0x12, 0x8f, 0x74, 0xda, 0xbc, 0xc4, 0x7c, 0xba, 0x85,
      0xb0, 0xfa, 0xe4, 0x7a, 0x04, 0xda, 0x32, 0xe1, 0x77, 0x99, 0xca, 0x15,
      0x08, 0x14, 0xd2, 0x77, 0x93, 0x81, 0x6e, 0x6a, 0x19, 0x83, 0x90, 0xc3,
      0x5d, 0x1f, 0x35, 0xab, 0xf6, 0x81, 0x67, 0x61, 0xa5, 0xff, 0x0c, 0x28,
      0xb1, 0xe6, 0x0e, 0xee, 0xd2, 0x44, 0xb1, 0xf2, 0x49, 0x34, 0x17, 0x4a,
      0x1d, 0x2c, 0x46, 0x94, 0x75, 0xf3, 0xeb, 0x88, 0x42, 0xeb, 0x9f, 0x5c,
      0x62, 0x24, 0x38, 0x69, 0x94, 0xaf, 0xf9, 0x57, 0x9f, 0x26, 0xea, 0x7d,
      0x73, 0xc6, 0x68, 0xa1, 0x13, 0xef, 0x7d, 0xee, 0x8b, 0x2b, 0xda, 0x57,
      0x61, 0x35, 0xd4, 0x52},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: ps followed by 0xff
    // tcID: 87
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     87,
     32,
     {0x53, 0xf2, 0xdb, 0x26, 0x23, 0x58, 0xc2, 0x17, 0x92, 0xec, 0xa6, 0x35,
      0x80, 0x6e, 0xa1, 0xc1, 0xad, 0x04, 0x1d, 0x93, 0x34, 0xe9, 0x77, 0xa2,
      0x5c, 0x1d, 0xe0, 0xfc, 0x82, 0x33, 0xec, 0x6f, 0x01, 0x73, 0x7a, 0xdc,
      0xf1, 0xfb, 0x4d, 0xbe, 0xdb, 0xd0, 0x07, 0x84, 0x06, 0xec, 0xad, 0x92,
      0x1e, 0x37, 0xc7, 0x7d, 0x45, 0x85, 0xb5, 0xeb, 0x5e, 0xcc, 0x74, 0xc0,
      0x7a, 0xda, 0x18, 0x64, 0xa3, 0xc1, 0x3a, 0xca, 0xba, 0x93, 0x72, 0xf8,
      0x52, 0xae, 0xf5, 0x5f, 0xf2, 0xdc, 0x42, 0xc0, 0xaa, 0xef, 0x74, 0xbb,
      0x65, 0x6b, 0x8e, 0x0b, 0xec, 0xcb, 0x7b, 0x9e, 0xae, 0x58, 0x7f, 0xdf,
      0x3b, 0x52, 0xeb, 0x67, 0x8a, 0xf1, 0x03, 0x2e, 0x60, 0xad, 0x12, 0x32,
      0x1c, 0x9c, 0x10, 0xc4, 0x45, 0x44, 0x8d, 0xf5, 0x23, 0x85, 0x6a, 0xd2,
      0x62, 0x20, 0x8a, 0x06, 0xb8, 0x81, 0x7e, 0xe2, 0x29, 0xdf, 0x82, 0x5f,
      0x08, 0x0a, 0x72, 0xd5, 0xe1, 0xa4, 0x3f, 0x22, 0x22, 0x15, 0x82, 0x4a,
      0x8e, 0xa6, 0xd4, 0x55, 0xc8, 0x0b, 0x25, 0x63, 0xc6, 0x5b, 0xe1, 0xea,
      0xa0, 0x45, 0x57, 0x14, 0xae, 0x57, 0x6a, 0xe6, 0x7e, 0x46, 0xd0, 0x06,
      0x93, 0x4c, 0xf0, 0xc1, 0x37, 0xb8, 0xc9, 0x90, 0x0a, 0xf9, 0xed, 0x71,
      0x63, 0x91, 0xce, 0x96, 0xec, 0x43, 0x29, 0x6e, 0x83, 0xa5, 0xa1, 0x03,
      0x90, 0xed, 0x91, 0xf2, 0xe6, 0x75, 0x3e, 0xd0, 0x25, 0x4f, 0x02, 0x90,
      0xad, 0x89, 0x94, 0x62, 0xb3, 0xb7, 0xaf, 0x42, 0xc3, 0xc5, 0xf0, 0x89,
      0x38, 0x63, 0xa3, 0xb5, 0xe6, 0x05, 0x2d, 0x3a, 0x6d, 0xee, 0x55, 0x47,
      0x46, 0x96, 0x0a, 0x07, 0xfb, 0x6e, 0xcd, 0xf7, 0x81, 0xe4, 0x7b, 0x96,
      0x02, 0x3b, 0xa0, 0x1c, 0xfd, 0xe4, 0xc7, 0x21, 0x46, 0x11, 0xa1, 0xbe,
      0x57, 0x35, 0xe2, 0xfd},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: shifted salt
    // tcID: 88
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     88,
     32,
     {0x11, 0xe8, 0x93, 0x82, 0x38, 0xa2, 0x0f, 0x0e, 0x69, 0x47, 0x01, 0x59,
      0x87, 0x38, 0x0d, 0xfd, 0x88, 0xa1, 0x66, 0x16, 0x06, 0xbd, 0x05, 0xbb,
      0xe4, 0x29, 0x8f, 0x47, 0x46, 0xe8, 0x1e, 0x3b, 0xbf, 0x34, 0xae, 0xce,
      0xba, 0x53, 0x60, 0xf1, 0x83, 0x9e, 0xe0, 0xd7, 0xd7, 0xfe, 0x3e, 0x57,
      0x8c, 0xac, 0xc2, 0xd2, 0x4b, 0x15, 0xee, 0xfe, 0x20, 0x64, 0xed, 0xb1,
      0xfd, 0x04, 0xff, 0x9a, 0x44, 0xc0, 0xa6, 0x00, 0xeb, 0xf0, 0x0f, 0x64,
      0xfb, 0xb1, 0xea, 0xd4, 0x24, 0x6e, 0x5f, 0xfb, 0xad, 0x0c, 0x22, 0x44,
      0x1e, 0xd0, 0x73, 0x46, 0x2f, 0x26, 0xe3, 0x0b, 0x61, 0xa0, 0xa9, 0x14,
      0x2b, 0x4f, 0x99, 0x3d, 0x1b, 0x26, 0xfa, 0x32, 0xe1, 0x13, 0x82, 0xda,
      0x33, 0xb9, 0xeb, 0x58, 0x55, 0xce, 0xf6, 0x73, 0x6b, 0xec, 0x2f, 0x4f,
      0x5b, 0xc6, 0xbf, 0x82, 0xfd, 0xf7, 0xda, 0x62, 0x34, 0x6a, 0x4d, 0x96,
      0x96, 0xc5, 0x3e, 0x1c, 0xfa, 0x78, 0x96, 0x67, 0xb7, 0x21, 0xf3, 0x2f,
      0x77, 0x79, 0xda, 0xf7, 0xdf, 0x85, 0x47, 0x40, 0x96, 0xa9, 0xe9, 0xa7,
      0x29, 0x1a, 0xfc, 0x76, 0xdf, 0x3a, 0x66, 0xc7, 0xa0, 0xb9, 0x97, 0xb4,
      0x1b, 0xfb, 0x71, 0xfe, 0xdb, 0xdb, 0x4e, 0x65, 0x09, 0x5e, 0xfe, 0x1a,
      0x81, 0xd3, 0x5b, 0x66, 0xbe, 0x55, 0x43, 0x2e, 0x0a, 0x6e, 0x33, 0x90,
      0x54, 0x75, 0xb4, 0x6a, 0x94, 0xe0, 0x5b, 0xce, 0x7f, 0xee, 0x84, 0x64,
      0x5f, 0x50, 0x0d, 0x8e, 0xbd, 0x7c, 0x02, 0x82, 0xc3, 0x5f, 0x22, 0x77,
      0x4e, 0x70, 0x89, 0x26, 0x22, 0x10, 0xf8, 0x3e, 0xd4, 0x85, 0xcd, 0x2b,
      0x04, 0x5a, 0xcd, 0x5d, 0x62, 0xb4, 0xbb, 0x53, 0xdc, 0xbe, 0xb2, 0x58,
      0x8d, 0xc6, 0x53, 0x55, 0x18, 0x18, 0x9c, 0xb0, 0x22, 0x0a, 0x7c, 0x94,
      0x06, 0xe4, 0x54, 0xd6},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 89
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     89,
     32,
     {0x39, 0xa8, 0xe9, 0x47, 0xc9, 0x19, 0xec, 0xfa, 0xd7, 0xee, 0x28, 0xbb,
      0x70, 0x8c, 0x1f, 0x9e, 0x82, 0x50, 0x36, 0x37, 0x4e, 0xa0, 0xf6, 0x10,
      0xbf, 0x55, 0x31, 0xd8, 0x9b, 0x81, 0x3d, 0x50, 0x6f, 0xd0, 0x0b, 0xdc,
      0x15, 0x85, 0x0b, 0x25, 0x0a, 0xc5, 0x0f, 0xc5, 0x56, 0xa6, 0x76, 0xc8,
      0x94, 0xfb, 0x64, 0x1d, 0xc6, 0x50, 0x99, 0x9e, 0xb6, 0x23, 0x9b, 0x91,
      0xe2, 0xc7, 0x55, 0x12, 0x6b, 0xbb, 0x9f, 0xef, 0x57, 0x83, 0xa5, 0xab,
      0x83, 0x4e, 0x0a, 0xd9, 0x1c, 0x60, 0xe7, 0x20, 0xe8, 0x0e, 0x09, 0x6c,
      0x09, 0x11, 0x67, 0xa2, 0xa1, 0xda, 0xe8, 0x38, 0xa1, 0x6f, 0xe0, 0xeb,
      0xaa, 0x8e, 0xfb, 0x35, 0x73, 0xc8, 0x9a, 0xc5, 0xd8, 0xe0, 0x58, 0x4b,
      0x5e, 0xc4, 0xe2, 0x16, 0x8e, 0xf0, 0x97, 0xf9, 0x37, 0xef, 0x0f, 0x0d,
      0x2a, 0x2f, 0x96, 0x4a, 0x8e, 0x6a, 0x81, 0x0d, 0xd1, 0x5b, 0x9c, 0x27,
      0xb2, 0x34, 0xd7, 0x88, 0xaf, 0x3c, 0x4f, 0x54, 0xdc, 0x97, 0x03, 0x56,
      0x57, 0xff, 0x19, 0xf2, 0x83, 0x55, 0x55, 0xdb, 0xaf, 0xd0, 0x2c, 0x4e,
      0xd3, 0xc7, 0x66, 0x54, 0xfa, 0x86, 0x8b, 0xab, 0xb7, 0x15, 0x34, 0xbf,
      0xe8, 0x46, 0x74, 0xee, 0xdd, 0xbf, 0xc2, 0xb2, 0x7a, 0x51, 0x7f, 0x66,
      0x6b, 0xd0, 0x3a, 0x27, 0xd8, 0x17, 0x3b, 0xb9, 0x28, 0x26, 0xa2, 0x31,
      0xcd, 0x9a, 0x24, 0x1c, 0x17, 0x14, 0x45, 0xb4, 0x16, 0x93, 0x4e, 0xbe,
      0xc5, 0xf7, 0xee, 0xa4, 0xfb, 0x41, 0xa6, 0x19, 0x37, 0xd9, 0xa9, 0x8f,
      0x61, 0xb2, 0xfd, 0x1c, 0xa8, 0xe2, 0xbe, 0x12, 0x5e, 0x85, 0xcc, 0x8d,
      0x16, 0xd5, 0x53, 0xb1, 0x14, 0xab, 0x72, 0x39, 0x5e, 0x86, 0xfe, 0xa5,
      0x2f, 0x54, 0xed, 0xd8, 0x53, 0xe9, 0xc5, 0x15, 0x65, 0x57, 0xe3, 0x8f,
      0x62, 0x1b, 0x97, 0x5a},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: bit 7 of masked_db not cleared
    // tcID: 90
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     90,
     32,
     {0x9c, 0x13, 0xd8, 0x77, 0xac, 0x2b, 0xd8, 0xc0, 0x2c, 0x11, 0xe2, 0x9f,
      0xfc, 0xc0, 0xc1, 0x04, 0x6d, 0xbc, 0x98, 0x70, 0x17, 0x7e, 0x84, 0x3c,
      0x30, 0xb4, 0x99, 0xc2, 0xbf, 0x7f, 0xd0, 0x9d, 0xaa, 0x43, 0x46, 0x9c,
      0xaf, 0x2b, 0x8c, 0x3e, 0x95, 0x5d, 0xed, 0x95, 0xe4, 0xd6, 0x22, 0x09,
      0xf7, 0x57, 0x1b, 0xb4, 0x55, 0x93, 0xf4, 0xcd, 0x8b, 0x0c, 0x7b, 0xc9,
      0x47, 0x0a, 0x8a, 0x69, 0x38, 0x37, 0x24, 0x8b, 0x5a, 0x78, 0x54, 0xdc,
      0x8e, 0x37, 0xe7, 0x52, 0xd9, 0x49, 0x47, 0x92, 0x72, 0x64, 0x29, 0x94,
      0x18, 0x20, 0x61, 0xd7, 0xaf, 0x80, 0xb0, 0xac, 0x6f, 0x6e, 0x98, 0x48,
      0x74, 0xc8, 0xcd, 0xc6, 0xa5, 0xd7, 0xd1, 0x7d, 0xc9, 0xe9, 0xde, 0x5a,
      0xd1, 0x21, 0x20, 0xcd, 0xb9, 0xf6, 0xc0, 0xd0, 0x9c, 0x0e, 0x11, 0xb8,
      0x7b, 0x34, 0x23, 0xe3, 0x7b, 0xa9, 0x43, 0x7a, 0x4f, 0x76, 0xcc, 0x1e,
      0x61, 0x24, 0x57, 0x9e, 0x5f, 0x79, 0x83, 0x2b, 0x89, 0x71, 0x0d, 0xe1,
      0x96, 0x8c, 0xe4, 0x6e, 0x3e, 0x69, 0xfa, 0x18, 0x5c, 0x0a, 0x92, 0x4e,
      0x8c, 0xb5, 0xf9, 0x96, 0xee, 0x59, 0x63, 0xf6, 0x82, 0x6d, 0xd3, 0x77,
      0x14, 0xde, 0x26, 0x4d, 0x75, 0x54, 0x5e, 0x85, 0x09, 0xca, 0xf8, 0x73,
      0x53, 0x30, 0xcd, 0xe7, 0xed, 0x42, 0x28, 0xe5, 0x77, 0x94, 0x71, 0x82,
      0x7b, 0x83, 0x75, 0x7c, 0x46, 0x60, 0x22, 0x11, 0x7c, 0x45, 0xd5, 0x98,
      0xf5, 0xa4, 0xa7, 0xfe, 0xd7, 0xbe, 0x4e, 0x1b, 0x4d, 0x32, 0x0f, 0x89,
      0x48, 0x79, 0x06, 0x1a, 0x75, 0xd1, 0xa4, 0x1e, 0xfd, 0x8d, 0xca, 0xf3,
      0xc6, 0x17, 0x33, 0xed, 0x8c, 0xa2, 0xcc, 0x2f, 0x83, 0x71, 0x4f, 0x8f,
      0xdb, 0xc7, 0xa9, 0x7c, 0xd6, 0xd6, 0xb9, 0x7e, 0xa3, 0xd3, 0x6e, 0xbd,
      0x69, 0x89, 0x06, 0x33},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of masked_db changed to 0
    // tcID: 91
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     91,
     32,
     {0x00, 0x56, 0x6c, 0x95, 0x52, 0x4a, 0xd0, 0x99, 0x5e, 0xda, 0x7d, 0x66,
      0x8f, 0xa0, 0x8e, 0x8f, 0x75, 0xbe, 0xa8, 0x68, 0xb6, 0x09, 0x72, 0xd6,
      0x48, 0x8c, 0xbe, 0x89, 0x39, 0xbb, 0xde, 0x68, 0xfa, 0x52, 0x06, 0xe6,
      0x71, 0xf3, 0x55, 0x55, 0xf6, 0x28, 0xfa, 0x70, 0x7c, 0xe7, 0xba, 0x0f,
      0x46, 0x8c, 0xfa, 0x8b, 0x97, 0x37, 0xe0, 0xef, 0x64, 0xe0, 0xe2, 0x3c,
      0x90, 0x1e, 0x49, 0x65, 0xcc, 0xaa, 0xee, 0xfa, 0x9b, 0x84, 0x36, 0x3a,
      0x30, 0x37, 0xcf, 0x5f, 0x9e, 0x04, 0x4e, 0x29, 0x5f, 0xe5, 0x7f, 0x32,
      0xc1, 0x12, 0x5c, 0xa7, 0x0c, 0x63, 0x9b, 0x22, 0x73, 0x2a, 0xa4, 0xc4,
      0xb3, 0xe5, 0x56, 0x26, 0x90, 0xbc, 0x1d, 0x7e, 0x7e, 0x74, 0xdd, 0x01,
      0xc6, 0x74, 0x21, 0x2d, 0xcb, 0x63, 0xc5, 0x8f, 0xa2, 0x33, 0x33, 0xd4,
      0x5e, 0x1e, 0x4c, 0xcf, 0xfa, 0x5d, 0x18, 0x64, 0x43, 0xcc, 0x78, 0x5c,
      0x5e, 0xce, 0x3f, 0x2d, 0x7a, 0x89, 0x95, 0xe2, 0x5d, 0xe6, 0xa1, 0x71,
      0xcb, 0xc9, 0x60, 0xc2, 0x72, 0xc2, 0x89, 0x9f, 0x6f, 0x87, 0xce, 0xad,
      0xb7, 0x2e, 0xea, 0x1b, 0xe0, 0x85, 0x24, 0x56, 0x69, 0xac, 0x08, 0x99,
      0x35, 0x91, 0xe7, 0x2b, 0xb9, 0xaf, 0xf8, 0xbc, 0x29, 0x38, 0x8b, 0x35,
      0xc9, 0x9f, 0x1b, 0xa7, 0x47, 0x7a, 0xf9, 0xd1, 0x67, 0x54, 0x89, 0x4a,
      0x50, 0xd4, 0xca, 0xea, 0x4b, 0xc8, 0x0e, 0x2a, 0xef, 0x2c, 0xed, 0x27,
      0xf4, 0xa1, 0xc8, 0x8b, 0xe2, 0x84, 0xbb, 0xb4, 0x0c, 0xb8, 0xae, 0x27,
      0x9b, 0x4e, 0x38, 0xa4, 0xcd, 0x8a, 0x51, 0xa9, 0x2a, 0x27, 0x9a, 0x79,
      0x9b, 0x33, 0x16, 0xc2, 0x93, 0x8e, 0x13, 0x86, 0x04, 0x3a, 0xe7, 0xab,
      0x1d, 0x86, 0x05, 0xcd, 0x31, 0x0d, 0x72, 0x39, 0xc8, 0x05, 0xa0, 0x7a,
      0x19, 0xc7, 0xb1, 0x7d},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte in em modified
    // tcID: 92
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     92,
     32,
     {0x2b, 0x46, 0xa0, 0xaa, 0xb5, 0xf5, 0x73, 0xe3, 0x2f, 0xfb, 0xcb, 0x41,
      0x1c, 0xd9, 0x9d, 0x2f, 0x90, 0xaa, 0x9b, 0x1a, 0xbb, 0xc6, 0x00, 0xb0,
      0xcd, 0xa0, 0xd8, 0x24, 0xf7, 0x90, 0x20, 0xaa, 0xb4, 0x7a, 0x24, 0x94,
      0xca, 0xea, 0x20, 0xfc, 0x93, 0x01, 0x7e, 0x77, 0xb9, 0x9e, 0xb7, 0x3a,
      0x1f, 0x8a, 0x55, 0x0b, 0x61, 0x1e, 0x27, 0x47, 0xad, 0x29, 0x20, 0x77,
      0x72, 0x62, 0x9c, 0x2e, 0xc4, 0x09, 0x18, 0xc0, 0x7a, 0xde, 0xf1, 0xc9,
      0x0c, 0x99, 0xa1, 0x5c, 0xdd, 0xb9, 0xea, 0xc8, 0x89, 0x55, 0xb4, 0x09,
      0x3a, 0x9e, 0x74, 0x3d, 0x24, 0x20, 0xb4, 0x64, 0x7e, 0x16, 0x7b, 0xff,
      0x8d, 0xdb, 0x07, 0xce, 0x19, 0x7d, 0xb8, 0x9d, 0x8a, 0x7d, 0x3f, 0x32,
      0x70, 0x58, 0xa4, 0x1c, 0xc4, 0x59, 0xed, 0x4f, 0x6d, 0x5d, 0x23, 0xdf,
      0xc0, 0x15, 0x47, 0x9d, 0x95, 0xe1, 0x95, 0xda, 0x37, 0xf5, 0xb1, 0xfc,
      0x31, 0x8a, 0x3f, 0x74, 0xa0, 0xac, 0x5f, 0xe2, 0xb9, 0x56, 0x9c, 0x7f,
      0xd9, 0x9b, 0x8e, 0xb3, 0xed, 0x39, 0x67, 0xa5, 0xed, 0xa1, 0xd2, 0x46,
      0xa3, 0xb2, 0x25, 0x54, 0x8f, 0x67, 0xff, 0x86, 0x02, 0x02, 0x03, 0x3e,
      0x71, 0x64, 0xd4, 0xb9, 0x9d, 0xcf, 0x95, 0xf4, 0x23, 0x2d, 0x18, 0xa7,
      0x91, 0x3f, 0x72, 0x58, 0xa3, 0x31, 0x79, 0x13, 0x3a, 0x6f, 0xb4, 0xab,
      0x5a, 0x49, 0x37, 0xb6, 0x42, 0xea, 0xcb, 0x92, 0x90, 0x8c, 0xf7, 0x94,
      0x95, 0x74, 0x5a, 0xbc, 0x58, 0x35, 0x24, 0xcb, 0x02, 0x36, 0xfb, 0xfa,
      0xdd, 0x2c, 0x7e, 0x8b, 0x0a, 0x65, 0x97, 0x01, 0x79, 0x12, 0xb4, 0x73,
      0x7f, 0xc0, 0x14, 0x32, 0x62, 0x5a, 0x50, 0x83, 0x55, 0x86, 0x96, 0x70,
      0xbe, 0xf2, 0x5d, 0x32, 0xaf, 0xe6, 0x75, 0x3c, 0x38, 0xcf, 0xd9, 0x6e,
      0xc3, 0x89, 0x53, 0xfb},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte in em modified
    // tcID: 93
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     93,
     32,
     {0x3b, 0x65, 0x97, 0x53, 0x57, 0xab, 0x2a, 0x41, 0x0c, 0x2f, 0xae, 0x7f,
      0x2f, 0x03, 0x81, 0xe6, 0xc4, 0x09, 0x51, 0x26, 0x04, 0x51, 0xf2, 0xef,
      0xf0, 0x5f, 0x0d, 0xc7, 0x07, 0xab, 0xd0, 0x13, 0xa9, 0x96, 0xfc, 0x10,
      0x65, 0x8a, 0x69, 0x63, 0xf4, 0x62, 0x87, 0x7a, 0x80, 0x8f, 0x61, 0xad,
      0x03, 0x62, 0xb9, 0xf6, 0x40, 0x75, 0x0b, 0x19, 0xde, 0xbf, 0x3d, 0x59,
      0x69, 0x21, 0x34, 0xe3, 0x57, 0xa4, 0x9e, 0xd3, 0x69, 0x3f, 0x50, 0x92,
      0x4b, 0x7c, 0x8a, 0x18, 0x24, 0xcc, 0xaf, 0xcb, 0x4b, 0x93, 0xf7, 0x67,
      0x9d, 0xd8, 0x92, 0x82, 0x3c, 0xd4, 0x79, 0x89, 0x5d, 0x41, 0xfd, 0x1c,
      0x40, 0xfb, 0x89, 0xfb, 0x1d, 0xa1, 0x9b, 0xc1, 0xfd, 0xc7, 0x2e, 0xb0,
      0x38, 0x78, 0x2f, 0x24, 0xba, 0x33, 0x26, 0x42, 0x8c, 0xfb, 0x16, 0x6a,
      0x47, 0x5a, 0x9f, 0xd2, 0x7f, 0x94, 0xd1, 0xa0, 0xca, 0x6f, 0xa0, 0xe6,
      0xa0, 0xd2, 0xc2, 0x88, 0x3d, 0xb3, 0xee, 0xb2, 0xc0, 0xa5, 0x94, 0x74,
      0xda, 0x36, 0x21, 0x16, 0x95, 0xfb, 0x81, 0x1b, 0x9e, 0x8b, 0xc7, 0xf0,
      0x5c, 0xcb, 0x1f, 0x50, 0xd2, 0x6d, 0x71, 0xa2, 0xdd, 0x20, 0x9b, 0x0d,
      0x26, 0x9a, 0x73, 0x66, 0x10, 0xc7, 0xdc, 0x1f, 0x73, 0x43, 0xa4, 0x73,
      0x6f, 0xa2, 0xb8, 0xc2, 0x78, 0x27, 0xdf, 0xca, 0xd4, 0x9b, 0xc4, 0xa8,
      0x68, 0x22, 0xcd, 0xe1, 0x57, 0x9d, 0xfb, 0xd6, 0x46, 0x47, 0x4f, 0x11,
      0xe1, 0xa6, 0x0f, 0x5e, 0x4a, 0xc2, 0xf2, 0xa3, 0xa5, 0x42, 0x1a, 0x7b,
      0xaa, 0x9d, 0xea, 0x5d, 0x24, 0xbe, 0x03, 0xcb, 0x6f, 0xee, 0x77, 0x1d,
      0xd8, 0x08, 0xb6, 0x7f, 0x88, 0x6b, 0x37, 0xbe, 0x5a, 0x30, 0x0f, 0x65,
      0x51, 0xd7, 0xe7, 0x63, 0x6e, 0x99, 0x97, 0xb3, 0x25, 0x5c, 0xee, 0xd5,
      0x18, 0x7e, 0xbc, 0xc0},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte in em modified
    // tcID: 94
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     94,
     32,
     {0x45, 0x16, 0xc8, 0xa3, 0x9b, 0x85, 0x44, 0xd1, 0xc6, 0x5d, 0x96, 0x47,
      0x2f, 0xea, 0x0b, 0x27, 0x53, 0x06, 0x03, 0x30, 0xe7, 0x6e, 0x6f, 0x90,
      0xf4, 0x1a, 0xb3, 0x49, 0x95, 0x3d, 0x26, 0xab, 0x1b, 0x95, 0xfd, 0x87,
      0x48, 0x45, 0x35, 0xb6, 0x8c, 0x0a, 0xfc, 0xf1, 0x54, 0x2a, 0x9b, 0x96,
      0x6a, 0x9b, 0xf9, 0x8b, 0x89, 0xa5, 0x3b, 0xb2, 0x88, 0x77, 0xb3, 0x4d,
      0x16, 0x8a, 0x4b, 0xa8, 0x20, 0x12, 0x15, 0xc5, 0x5f, 0x9e, 0x86, 0xd3,
      0x0b, 0x71, 0x59, 0x09, 0x35, 0x17, 0x68, 0x2e, 0x6e, 0x95, 0x60, 0x78,
      0x94, 0x7e, 0x54, 0xe3, 0xf3, 0xa7, 0x79, 0xda, 0x03, 0x2a, 0xf7, 0xdc,
      0x6b, 0xca, 0xb1, 0xc0, 0xb2, 0xa6, 0x69, 0x3f, 0xe0, 0xee, 0xb9, 0xde,
      0x0d, 0x15, 0x8b, 0xcc, 0x12, 0x52, 0x93, 0xa6, 0xf1, 0x0c, 0xca, 0xf1,
      0x49, 0x9b, 0x6a, 0xd9, 0x12, 0xed, 0x59, 0x12, 0x53, 0x7e, 0x3c, 0x3c,
      0x5f, 0x18, 0xeb, 0x0a, 0xb8, 0xe7, 0x01, 0x05, 0x6d, 0x7b, 0x97, 0x3b,
      0x8b, 0x61, 0xaf, 0x91, 0x88, 0x58, 0xb8, 0x71, 0x52, 0xb6, 0xc4, 0x06,
      0x71, 0xbf, 0x96, 0x73, 0x5a, 0xb1, 0xa1, 0x12, 0x97, 0x23, 0x46, 0xe7,
      0x71, 0xe7, 0xcd, 0x94, 0x82, 0xf6, 0xf5, 0x9d, 0x32, 0x0b, 0x87, 0x98,
      0xa2, 0x71, 0xcf, 0x21, 0x77, 0x97, 0x47, 0xf9, 0x64, 0x28, 0x1a, 0xfa,
      0x13, 0x03, 0x14, 0x2e, 0xb3, 0xe1, 0x84, 0x17, 0x72, 0xde, 0x82, 0x5b,
      0x4b, 0x5e, 0x68, 0x02, 0x4d, 0xea, 0x01, 0x41, 0x93, 0xc4, 0xe1, 0xc2,
      0x06, 0xbd, 0xc6, 0x12, 0x1a, 0x8f, 0x2d, 0x41, 0x83, 0x7b, 0xe3, 0xd1,
      0x38, 0x33, 0xed, 0x61, 0x5d, 0x5b, 0x9d, 0xf4, 0xac, 0x4c, 0x86, 0xcd,
      0x25, 0x34, 0x4f, 0xe1, 0x02, 0x2d, 0xf0, 0xad, 0xab, 0xfe, 0x2d, 0x46,
      0xf7, 0xd9, 0xf0, 0xd0},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is 0
    // tcID: 95
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     95,
     32,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is 1
    // tcID: 96
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     96,
     32,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is n-1
    // tcID: 97
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     97,
     32,
     {0xa2, 0xb4, 0x51, 0xa0, 0x7d, 0x0a, 0xa5, 0xf9, 0x6e, 0x45, 0x56, 0x71,
      0x51, 0x35, 0x50, 0x51, 0x4a, 0x8a, 0x5b, 0x46, 0x2e, 0xbe, 0xf7, 0x17,
      0x09, 0x4f, 0xa1, 0xfe, 0xe8, 0x22, 0x24, 0xe6, 0x37, 0xf9, 0x74, 0x6d,
      0x3f, 0x7c, 0xaf, 0xd3, 0x18, 0x78, 0xd8, 0x03, 0x25, 0xb6, 0xef, 0x5a,
      0x17, 0x00, 0xf6, 0x59, 0x03, 0xb4, 0x69, 0x42, 0x9e, 0x89, 0xd6, 0xea,
      0xc8, 0x84, 0x50, 0x97, 0xb5, 0xab, 0x39, 0x31, 0x89, 0xdb, 0x92, 0x51,
      0x2e, 0xd8, 0xa7, 0x71, 0x1a, 0x12, 0x53, 0xfa, 0xcd, 0x20, 0xf7, 0x9c,
      0x15, 0xe8, 0x24, 0x7f, 0x3d, 0x3e, 0x42, 0xe4, 0x6e, 0x48, 0xc9, 0x8e,
      0x25, 0x4a, 0x2f, 0xe9, 0x76, 0x53, 0x13, 0xa0, 0x3e, 0xff, 0x8f, 0x17,
      0xe1, 0xa0, 0x29, 0x39, 0x7a, 0x1f, 0xa2, 0x6a, 0x8d, 0xce, 0x26, 0xf4,
      0x90, 0xed, 0x81, 0x29, 0x96, 0x15, 0xd9, 0x81, 0x4c, 0x22, 0xda, 0x61,
      0x04, 0x28, 0xe0, 0x9c, 0x7d, 0x96, 0x58, 0x59, 0x42, 0x66, 0xf5, 0xc0,
      0x21, 0xd0, 0xfc, 0xec, 0xa0, 0x8d, 0x94, 0x5a, 0x12, 0xbe, 0x82, 0xde,
      0x4d, 0x1e, 0xce, 0x6b, 0x4c, 0x03, 0x14, 0x5b, 0x5d, 0x34, 0x95, 0xd4,
      0xed, 0x54, 0x11, 0xeb, 0x87, 0x8d, 0xaf, 0x05, 0xfd, 0x7a, 0xfc, 0x3e,
      0x09, 0xad, 0xa0, 0xf1, 0x12, 0x64, 0x22, 0xf5, 0x90, 0x97, 0x5a, 0x19,
      0x69, 0x81, 0x6f, 0x48, 0x69, 0x8b, 0xcb, 0xba, 0x1b, 0x4d, 0x9c, 0xae,
      0x79, 0xd4, 0x60, 0xd8, 0xf9, 0xf8, 0x5e, 0x79, 0x75, 0x00, 0x5d, 0x9b,
      0xc2, 0x2c, 0x4e, 0x5a, 0xc0, 0xf7, 0xc1, 0xa4, 0x5d, 0x12, 0x56, 0x9a,
      0x62, 0x80, 0x7d, 0x3b, 0x9a, 0x02, 0xe5, 0xa5, 0x30, 0xe7, 0x73, 0x06,
      0x6f, 0x45, 0x3d, 0x1f, 0x5b, 0x4c, 0x2e, 0x9c, 0xf7, 0x82, 0x02, 0x83,
      0xf7, 0x42, 0xb9, 0xd4},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is n
    // tcID: 98
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     98,
     32,
     {0xa2, 0xb4, 0x51, 0xa0, 0x7d, 0x0a, 0xa5, 0xf9, 0x6e, 0x45, 0x56, 0x71,
      0x51, 0x35, 0x50, 0x51, 0x4a, 0x8a, 0x5b, 0x46, 0x2e, 0xbe, 0xf7, 0x17,
      0x09, 0x4f, 0xa1, 0xfe, 0xe8, 0x22, 0x24, 0xe6, 0x37, 0xf9, 0x74, 0x6d,
      0x3f, 0x7c, 0xaf, 0xd3, 0x18, 0x78, 0xd8, 0x03, 0x25, 0xb6, 0xef, 0x5a,
      0x17, 0x00, 0xf6, 0x59, 0x03, 0xb4, 0x69, 0x42, 0x9e, 0x89, 0xd6, 0xea,
      0xc8, 0x84, 0x50, 0x97, 0xb5, 0xab, 0x39, 0x31, 0x89, 0xdb, 0x92, 0x51,
      0x2e, 0xd8, 0xa7, 0x71, 0x1a, 0x12, 0x53, 0xfa, 0xcd, 0x20, 0xf7, 0x9c,
      0x15, 0xe8, 0x24, 0x7f, 0x3d, 0x3e, 0x42, 0xe4, 0x6e, 0x48, 0xc9, 0x8e,
      0x25, 0x4a, 0x2f, 0xe9, 0x76, 0x53, 0x13, 0xa0, 0x3e, 0xff, 0x8f, 0x17,
      0xe1, 0xa0, 0x29, 0x39, 0x7a, 0x1f, 0xa2, 0x6a, 0x8d, 0xce, 0x26, 0xf4,
      0x90, 0xed, 0x81, 0x29, 0x96, 0x15, 0xd9, 0x81, 0x4c, 0x22, 0xda, 0x61,
      0x04, 0x28, 0xe0, 0x9c, 0x7d, 0x96, 0x58, 0x59, 0x42, 0x66, 0xf5, 0xc0,
      0x21, 0xd0, 0xfc, 0xec, 0xa0, 0x8d, 0x94, 0x5a, 0x12, 0xbe, 0x82, 0xde,
      0x4d, 0x1e, 0xce, 0x6b, 0x4c, 0x03, 0x14, 0x5b, 0x5d, 0x34, 0x95, 0xd4,
      0xed, 0x54, 0x11, 0xeb, 0x87, 0x8d, 0xaf, 0x05, 0xfd, 0x7a, 0xfc, 0x3e,
      0x09, 0xad, 0xa0, 0xf1, 0x12, 0x64, 0x22, 0xf5, 0x90, 0x97, 0x5a, 0x19,
      0x69, 0x81, 0x6f, 0x48, 0x69, 0x8b, 0xcb, 0xba, 0x1b, 0x4d, 0x9c, 0xae,
      0x79, 0xd4, 0x60, 0xd8, 0xf9, 0xf8, 0x5e, 0x79, 0x75, 0x00, 0x5d, 0x9b,
      0xc2, 0x2c, 0x4e, 0x5a, 0xc0, 0xf7, 0xc1, 0xa4, 0x5d, 0x12, 0x56, 0x9a,
      0x62, 0x80, 0x7d, 0x3b, 0x9a, 0x02, 0xe5, 0xa5, 0x30, 0xe7, 0x73, 0x06,
      0x6f, 0x45, 0x3d, 0x1f, 0x5b, 0x4c, 0x2e, 0x9c, 0xf7, 0x82, 0x02, 0x83,
      0xf7, 0x42, 0xb9, 0xd5},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to signature
    // tcID: 99
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     99,
     32,
     {0x00, 0x00, 0x68, 0xca, 0xf0, 0x7e, 0x71, 0xee, 0x65, 0x4f, 0xfa, 0xbf,
      0x07, 0xd3, 0x42, 0xfc, 0x40, 0x59, 0xde, 0xb4, 0xf7, 0xe5, 0x97, 0x07,
      0x46, 0xc4, 0x23, 0xb1, 0xe8, 0xf6, 0x68, 0xd5, 0x33, 0x22, 0x75, 0xcc,
      0x35, 0xeb, 0x61, 0x27, 0x0a, 0xeb, 0xd2, 0x78, 0x55, 0xb1, 0xe8, 0x0d,
      0x59, 0xde, 0xf4, 0x7f, 0xe8, 0x88, 0x28, 0x67, 0xfd, 0x33, 0xc2, 0x30,
      0x8c, 0x91, 0x97, 0x6b, 0xaa, 0x0b, 0x1d, 0xf9, 0x52, 0xca, 0xa7, 0x8d,
      0xb4, 0x82, 0x8a, 0xb8, 0x1e, 0x79, 0x94, 0x9b, 0xf1, 0x45, 0xcb, 0xdf,
      0xd1, 0xc4, 0x98, 0x7e, 0xd0, 0x36, 0xf8, 0x1e, 0x84, 0x42, 0x08, 0x10,
      0x16, 0xf2, 0x0f, 0xa4, 0xb5, 0x87, 0x57, 0x48, 0x84, 0xca, 0x6f, 0x60,
      0x45, 0x95, 0x9c, 0xe3, 0x50, 0x1a, 0xe7, 0xc0, 0x2b, 0x19, 0x02, 0xec,
      0x1d, 0x24, 0x1e, 0xf2, 0x8d, 0xee, 0x35, 0x6c, 0x0d, 0x30, 0xd2, 0x8a,
      0x95, 0x0f, 0x1f, 0xbc, 0x68, 0x3e, 0xe7, 0xd9, 0xaa, 0xd2, 0x6b, 0x04,
      0x8c, 0x13, 0x42, 0x6f, 0xe3, 0x97, 0x5d, 0x56, 0x38, 0xaf, 0xeb, 0x5b,
      0x9c, 0x1a, 0x99, 0xd1, 0x62, 0xd3, 0xa5, 0x81, 0x0e, 0x8b, 0x07, 0x4d,
      0x7a, 0x2e, 0xae, 0x2b, 0xe5, 0x2b, 0x57, 0x71, 0x51, 0xf7, 0x6e, 0x1f,
      0x73, 0x4b, 0x0a, 0x95, 0x6e, 0xf4, 0xf2, 0x2b, 0xe6, 0x4d, 0xc2, 0x0a,
      0x81, 0xad, 0x13, 0x16, 0xe4, 0xf7, 0x9d, 0xff, 0x5f, 0xc4, 0x1f, 0xc0,
      0x8a, 0x20, 0xbc, 0x61, 0x22, 0x83, 0xa8, 0x84, 0x15, 0xd4, 0x15, 0x95,
      0xbf, 0xea, 0x66, 0xd5, 0x9d, 0xe7, 0xac, 0x12, 0xe2, 0x30, 0xf7, 0x22,
      0x44, 0xad, 0x99, 0x05, 0xae, 0xf0, 0xea, 0xd3, 0xfa, 0x41, 0xed, 0x70,
      0xbf, 0x42, 0x18, 0x86, 0x3d, 0x5f, 0x04, 0x12, 0x92, 0xf2, 0xd1, 0x4c,
      0xe0, 0xa7, 0x27, 0x1c, 0x6d, 0x36},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to signature
    // tcID: 100
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     100,
     32,
     {0x68, 0xca, 0xf0, 0x7e, 0x71, 0xee, 0x65, 0x4f, 0xfa, 0xbf, 0x07, 0xd3,
      0x42, 0xfc, 0x40, 0x59, 0xde, 0xb4, 0xf7, 0xe5, 0x97, 0x07, 0x46, 0xc4,
      0x23, 0xb1, 0xe8, 0xf6, 0x68, 0xd5, 0x33, 0x22, 0x75, 0xcc, 0x35, 0xeb,
      0x61, 0x27, 0x0a, 0xeb, 0xd2, 0x78, 0x55, 0xb1, 0xe8, 0x0d, 0x59, 0xde,
      0xf4, 0x7f, 0xe8, 0x88, 0x28, 0x67, 0xfd, 0x33, 0xc2, 0x30, 0x8c, 0x91,
      0x97, 0x6b, 0xaa, 0x0b, 0x1d, 0xf9, 0x52, 0xca, 0xa7, 0x8d, 0xb4, 0x82,
      0x8a, 0xb8, 0x1e, 0x79, 0x94, 0x9b, 0xf1, 0x45, 0xcb, 0xdf, 0xd1, 0xc4,
      0x98, 0x7e, 0xd0, 0x36, 0xf8, 0x1e, 0x84, 0x42, 0x08, 0x10, 0x16, 0xf2,
      0x0f, 0xa4, 0xb5, 0x87, 0x57, 0x48, 0x84, 0xca, 0x6f, 0x60, 0x45, 0x95,
      0x9c, 0xe3, 0x50, 0x1a, 0xe7, 0xc0, 0x2b, 0x19, 0x02, 0xec, 0x1d, 0x24,
      0x1e, 0xf2, 0x8d, 0xee, 0x35, 0x6c, 0x0d, 0x30, 0xd2, 0x8a, 0x95, 0x0f,
      0x1f, 0xbc, 0x68, 0x3e, 0xe7, 0xd9, 0xaa, 0xd2, 0x6b, 0x04, 0x8c, 0x13,
      0x42, 0x6f, 0xe3, 0x97, 0x5d, 0x56, 0x38, 0xaf, 0xeb, 0x5b, 0x9c, 0x1a,
      0x99, 0xd1, 0x62, 0xd3, 0xa5, 0x81, 0x0e, 0x8b, 0x07, 0x4d, 0x7a, 0x2e,
      0xae, 0x2b, 0xe5, 0x2b, 0x57, 0x71, 0x51, 0xf7, 0x6e, 0x1f, 0x73, 0x4b,
      0x0a, 0x95, 0x6e, 0xf4, 0xf2, 0x2b, 0xe6, 0x4d, 0xc2, 0x0a, 0x81, 0xad,
      0x13, 0x16, 0xe4, 0xf7, 0x9d, 0xff, 0x5f, 0xc4, 0x1f, 0xc0, 0x8a, 0x20,
      0xbc, 0x61, 0x22, 0x83, 0xa8, 0x84, 0x15, 0xd4, 0x15, 0x95, 0xbf, 0xea,
      0x66, 0xd5, 0x9d, 0xe7, 0xac, 0x12, 0xe2, 0x30, 0xf7, 0x22, 0x44, 0xad,
      0x99, 0x05, 0xae, 0xf0, 0xea, 0xd3, 0xfa, 0x41, 0xed, 0x70, 0xbf, 0x42,
      0x18, 0x86, 0x3d, 0x5f, 0x04, 0x12, 0x92, 0xf2, 0xd1, 0x4c, 0xe0, 0xa7,
      0x27, 0x1c, 0x6d, 0x36, 0x00, 0x00},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated signature
    // tcID: 101
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     101,
     32,
     {0x68, 0xca, 0xf0, 0x7e, 0x71, 0xee, 0x65, 0x4f, 0xfa, 0xbf, 0x07, 0xd3,
      0x42, 0xfc, 0x40, 0x59, 0xde, 0xb4, 0xf7, 0xe5, 0x97, 0x07, 0x46, 0xc4,
      0x23, 0xb1, 0xe8, 0xf6, 0x68, 0xd5, 0x33, 0x22, 0x75, 0xcc, 0x35, 0xeb,
      0x61, 0x27, 0x0a, 0xeb, 0xd2, 0x78, 0x55, 0xb1, 0xe8, 0x0d, 0x59, 0xde,
      0xf4, 0x7f, 0xe8, 0x88, 0x28, 0x67, 0xfd, 0x33, 0xc2, 0x30, 0x8c, 0x91,
      0x97, 0x6b, 0xaa, 0x0b, 0x1d, 0xf9, 0x52, 0xca, 0xa7, 0x8d, 0xb4, 0x82,
      0x8a, 0xb8, 0x1e, 0x79, 0x94, 0x9b, 0xf1, 0x45, 0xcb, 0xdf, 0xd1, 0xc4,
      0x98, 0x7e, 0xd0, 0x36, 0xf8, 0x1e, 0x84, 0x42, 0x08, 0x10, 0x16, 0xf2,
      0x0f, 0xa4, 0xb5, 0x87, 0x57, 0x48, 0x84, 0xca, 0x6f, 0x60, 0x45, 0x95,
      0x9c, 0xe3, 0x50, 0x1a, 0xe7, 0xc0, 0x2b, 0x19, 0x02, 0xec, 0x1d, 0x24,
      0x1e, 0xf2, 0x8d, 0xee, 0x35, 0x6c, 0x0d, 0x30, 0xd2, 0x8a, 0x95, 0x0f,
      0x1f, 0xbc, 0x68, 0x3e, 0xe7, 0xd9, 0xaa, 0xd2, 0x6b, 0x04, 0x8c, 0x13,
      0x42, 0x6f, 0xe3, 0x97, 0x5d, 0x56, 0x38, 0xaf, 0xeb, 0x5b, 0x9c, 0x1a,
      0x99, 0xd1, 0x62, 0xd3, 0xa5, 0x81, 0x0e, 0x8b, 0x07, 0x4d, 0x7a, 0x2e,
      0xae, 0x2b, 0xe5, 0x2b, 0x57, 0x71, 0x51, 0xf7, 0x6e, 0x1f, 0x73, 0x4b,
      0x0a, 0x95, 0x6e, 0xf4, 0xf2, 0x2b, 0xe6, 0x4d, 0xc2, 0x0a, 0x81, 0xad,
      0x13, 0x16, 0xe4, 0xf7, 0x9d, 0xff, 0x5f, 0xc4, 0x1f, 0xc0, 0x8a, 0x20,
      0xbc, 0x61, 0x22, 0x83, 0xa8, 0x84, 0x15, 0xd4, 0x15, 0x95, 0xbf, 0xea,
      0x66, 0xd5, 0x9d, 0xe7, 0xac, 0x12, 0xe2, 0x30, 0xf7, 0x22, 0x44, 0xad,
      0x99, 0x05, 0xae, 0xf0, 0xea, 0xd3, 0xfa, 0x41, 0xed, 0x70, 0xbf, 0x42,
      0x18, 0x86, 0x3d, 0x5f, 0x04, 0x12, 0x92, 0xf2, 0xd1, 0x4c, 0xe0, 0xa7,
      0x27, 0x1c},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: empty signature
    // tcID: 102
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     102,
     32,
     {},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: PKCS #1 v1.5 signature
    // tcID: 103
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     103,
     32,
     {0x17, 0x58, 0xeb, 0x94, 0x58, 0x8e, 0x6f, 0xc4, 0xf5, 0x0c, 0x1b, 0xe1,
      0xaf, 0xca, 0xa4, 0x10, 0x27, 0x86, 0x9f, 0x30, 0x4c, 0xad, 0x51, 0x3b,
      0x1f, 0xb1, 0x2c, 0x2f, 0x44, 0x6d, 0x63, 0xcd, 0xc0, 0x5c, 0x48, 0x30,
      0xa7, 0xe3, 0xe6, 0x30, 0xda, 0x7b, 0x2d, 0xa4, 0xf7, 0x86, 0x7c, 0xc1,
      0x73, 0xbf, 0x64, 0x20, 0xf9, 0x73, 0x22, 0x77, 0x28, 0x25, 0x96, 0xde,
      0x41, 0xde, 0xd3, 0x2e, 0x21, 0xd0, 0xcc, 0x31, 0x44, 0x11, 0x74, 0xda,
      0x87, 0x65, 0xf5, 0x74, 0x19, 0xc7, 0x76, 0x4e, 0xa7, 0x58, 0xf5, 0x5b,
      0xc1, 0x76, 0x46, 0xeb, 0x10, 0x0c, 0x43, 0x5d, 0x1a, 0xc0, 0xee, 0xd6,
      0xfc, 0x7b, 0xa6, 0xde, 0x5f, 0x83, 0x20, 0x94, 0xee, 0x2f, 0x47, 0x99,
      0x79, 0x76, 0x5e, 0x05, 0xac, 0x99, 0x76, 0x78, 0x8d, 0xb3, 0xc2, 0x41,
      0xa9, 0xe3, 0x2a, 0x0d, 0xa8, 0x64, 0xf0, 0x01, 0x9a, 0x87, 0x64, 0x6b,
      0xa6, 0x23, 0xd6, 0x3f, 0x44, 0x11, 0xaf, 0x5d, 0xee, 0x1b, 0xe9, 0xec,
      0x48, 0x8c, 0x7e, 0x3e, 0x1b, 0x23, 0x14, 0x79, 0xde, 0x70, 0xb9, 0xac,
      0x5f, 0x78, 0xa1, 0x7b, 0x1f, 0x41, 0x20, 0xae, 0xce, 0x45, 0xf2, 0x6c,
      0x07, 0xe7, 0xbb, 0x34, 0x5f, 0xdf, 0xeb, 0x05, 0xe1, 0x4b, 0xca, 0xac,
      0xc6, 0x14, 0x67, 0x2a, 0x46, 0x5f, 0xc5, 0x23, 0x62, 0x4c, 0xb1, 0x9f,
      0x66, 0xf9, 0xc6, 0xc3, 0xf6, 0x42, 0xb8, 0x32, 0xca, 0x44, 0xcb, 0x25,
      0x17, 0x6d, 0x67, 0x9f, 0x0e, 0x05, 0x60, 0x6c, 0x3f, 0xed, 0x02, 0x2c,
      0xac, 0x24, 0xc2, 0xbf, 0x96, 0x0a, 0x40, 0x6d, 0x48, 0x81, 0x8e, 0x3e,
      0xb7, 0xed, 0x53, 0xb0, 0x44, 0x60, 0x32, 0x46, 0x90, 0x47, 0xdf, 0xed,
      0x95, 0xfc, 0x18, 0x08, 0x8c, 0x92, 0xd9, 0x1d, 0x93, 0x72, 0x2c, 0x47,
      0xf8, 0x81, 0x63, 0xa8},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false}};

#endif  // rsa_pss_2048_sha256_32_vectors_h__
