/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef rsa_pss_2048_sha1_20_vectors_h__
#define rsa_pss_2048_sha1_20_vectors_h__

#include "testvectors_base/test-structs.h"

static const std::vector<uint8_t> pub_key_0{
    0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
    0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 0x00,
    0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xbd, 0x31, 0xc7,
    0xa0, 0x26, 0x91, 0xd2, 0xd9, 0x58, 0x7e, 0xf6, 0xa9, 0x46, 0xff, 0x78,
    0x85, 0x44, 0xcc, 0xad, 0xd4, 0xb2, 0x98, 0x8a, 0xd6, 0x20, 0x86, 0x79,
    0x2a, 0x6b, 0xf9, 0x6c, 0x86, 0x16, 0xb4, 0xad, 0x13, 0x31, 0x7d, 0x22,
    0x70, 0xb9, 0x01, 0xd0, 0xfc, 0xd1, 0xd8, 0x80, 0xcb, 0x8f, 0x52, 0xfb,
    0x87, 0x30, 0x4a, 0x52, 0x58, 0xc1, 0x1b, 0x38, 0xdf, 0xea, 0xe8, 0xdf,
    0x67, 0x0a, 0xee, 0xe7, 0xea, 0x1d, 0x0d, 0x9d, 0xf8, 0xe0, 0x0e, 0x80,
    0x84, 0x7e, 0x41, 0xe5, 0x98, 0x9e, 0xd4, 0x02, 0xd4, 0x4e, 0x78, 0xb3,
    0x0f, 0xef, 0x17, 0xb5, 0x67, 0x1d, 0x3a, 0xdb, 0xf8, 0x68, 0x5e, 0x4d,
    0xc2, 0x04, 0x49, 0x9e, 0xcd, 0x18, 0x63, 0xe1, 0xd5, 0xaf, 0xf2, 0x8a,
    0x7c, 0xf6, 0x6e, 0xad, 0xf3, 0x1f, 0xec, 0x92, 0x36, 0xc1, 0x20, 0xad,
    0xd1, 0x34, 0x51, 0x52, 0x2c, 0x64, 0x7c, 0x98, 0x32, 0xa6, 0x72, 0xcd,
    0x64, 0xd3, 0x28, 0xc1, 0xc3, 0x22, 0x18, 0x3f, 0x46, 0x61, 0xd0, 0x9b,
    0xda, 0x60, 0xb8, 0xdd, 0x5f, 0x03, 0x28, 0xda, 0x54, 0x20, 0x82, 0x14,
    0x24, 0xaf, 0xda, 0xbb, 0x1a, 0x80, 0xc5, 0xd1, 0x27, 0x63, 0xa1, 0xb0,
    0x23, 0x8c, 0xd8, 0x9d, 0x07, 0x42, 0xbf, 0xc5, 0x0b, 0x6a, 0x2f, 0xcb,
    0x70, 0x1d, 0x82, 0x42, 0x18, 0xf9, 0x82, 0x6f, 0x4f, 0x78, 0xa2, 0x3a,
    0x2b, 0x5a, 0xa4, 0x2a, 0xce, 0x7f, 0x17, 0x53, 0x76, 0xfb, 0x6c, 0xbd,
    0xb2, 0xba, 0xd2, 0x93, 0xba, 0x58, 0x3d, 0x4d, 0x31, 0xc6, 0xb8, 0xf9,
    0x02, 0x9e, 0x46, 0xb1, 0x36, 0x89, 0x24, 0x98, 0x55, 0xf5, 0x05, 0x75,
    0x6e, 0x00, 0xe2, 0x25, 0xa6, 0xa4, 0x5a, 0x18, 0x76, 0x9b, 0xd8, 0xd2,
    0xb3, 0xa4, 0xac, 0xb9, 0xf1, 0xc2, 0x3d, 0x3e, 0x51, 0x88, 0x25, 0x61,
    0xe5, 0x02, 0x03, 0x01, 0x00, 0x01};

const RsaPssTestVector kRsaPss2048Sha120WycheproofVectors[] = {

    // Comment:
    // tcID: 1
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     1,
     20,
     {0x1d, 0x5a, 0x9b, 0xb4, 0x9c, 0xb1, 0xf5, 0xc2, 0x86, 0x2f, 0x36, 0xe4,
      0x51, 0xdc, 0xe7, 0xfc, 0x60, 0x7f, 0x3d, 0x30, 0x2e, 0xb9, 0xa9, 0xfb,
      0xea, 0x5b, 0x67, 0x3a, 0x29, 0xfa, 0x90, 0x23, 0x30, 0x83, 0x81, 0x26,
      0x2c, 0x53, 0x8c, 0xb5, 0x39, 0x10, 0xb5, 0x77, 0x3a, 0x7a, 0x44, 0xff,
      0x46, 0x58, 0x28, 0xbd, 0xfc, 0xcf, 0x8a, 0x7a, 0x4e, 0xf9, 0x02, 0xe9,
      0x45, 0xdd, 0x5f, 0x62, 0x26, 0xff, 0xb7, 0xd5, 0xb0, 0x5f, 0x23, 0x35,
      0xe5, 0x76, 0x2c, 0x5a, 0xce, 0xff, 0x71, 0xc8, 0x40, 0x81, 0x50, 0x95,
      0x9c, 0x17, 0x80, 0xcc, 0x9c, 0x22, 0xfc, 0xce, 0xbd, 0x34, 0x05, 0xe8,
      0x1f, 0x1b, 0xc1, 0x6d, 0x27, 0x6c, 0x07, 0xe4, 0xa5, 0x45, 0xdd, 0xb1,
      0xaa, 0xde, 0xb7, 0x51, 0xb5, 0x71, 0xd2, 0x2f, 0x3e, 0x4b, 0xc4, 0xe0,
      0x20, 0x20, 0xee, 0xc5, 0x90, 0x1a, 0x1e, 0xbc, 0x04, 0x41, 0x5e, 0x9d,
      0xdf, 0xe9, 0x67, 0xfb, 0xe4, 0xec, 0x71, 0x66, 0x92, 0x3a, 0xa0, 0x95,
      0xb9, 0xfc, 0x7a, 0x81, 0xfc, 0x21, 0xba, 0x37, 0xb5, 0x22, 0x0a, 0x97,
      0x3f, 0xc5, 0xf3, 0x2f, 0xdb, 0x8e, 0x08, 0x41, 0xed, 0x32, 0x14, 0x50,
      0x24, 0x84, 0x02, 0xa1, 0x59, 0xd2, 0xc0, 0x8e, 0x4a, 0x72, 0xb7, 0x80,
      0x31, 0x0d, 0x42, 0x0a, 0x6e, 0x49, 0x9c, 0x2b, 0x34, 0xb0, 0xbd, 0x6f,
      0xe0, 0xd1, 0xd0, 0xe1, 0xa7, 0x81, 0x05, 0x63, 0x32, 0x4a, 0xd8, 0xe7,
      0x78, 0x72, 0x07, 0x55, 0xeb, 0x00, 0xac, 0x6e, 0x28, 0xb2, 0x04, 0xff,
      0x5f, 0xbb, 0x01, 0xfc, 0xfc, 0x91, 0xe8, 0xf1, 0xd2, 0xf1, 0x13, 0xa5,
      0xf3, 0x28, 0x43, 0x11, 0x9f, 0x5e, 0x06, 0xbe, 0xec, 0x0f, 0xe9, 0x4e,
      0x5b, 0xfd, 0x0c, 0xcd, 0xd7, 0xf3, 0x22, 0xbd, 0xab, 0x7b, 0x05, 0xc4,
      0xf8, 0x3c, 0x05, 0x04},
     pub_key_0,
     {},
     true},

    // Comment:
    // tcID: 2
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     2,
     20,
     {0x01, 0xe9, 0xb1, 0xd4, 0xf3, 0x6d, 0x04, 0x0a, 0x55, 0x3e, 0xe1, 0x2a,
      0xfb, 0x76, 0xa3, 0x6d, 0x04, 0xc6, 0xc5, 0xa0, 0xf3, 0xdf, 0x84, 0xae,
      0x22, 0x42, 0x2e, 0x81, 0x57, 0xe5, 0x7b, 0x1c, 0x43, 0xa7, 0xbd, 0xaa,
      0xde, 0x30, 0xae, 0x73, 0x07, 0x36, 0x32, 0xa4, 0x67, 0x99, 0x73, 0xec,
      0x10, 0xbc, 0xbb, 0x30, 0x16, 0xf6, 0xe2, 0x0c, 0x9c, 0xad, 0x29, 0xa1,
      0x4f, 0x96, 0x05, 0x25, 0x07, 0x81, 0x9e, 0x90, 0xcf, 0x56, 0xba, 0x50,
      0xc9, 0x7d, 0xf5, 0xe5, 0x00, 0x1c, 0x7f, 0x94, 0x81, 0x7e, 0xd2, 0x9f,
      0x75, 0x00, 0xf8, 0x39, 0xeb, 0x41, 0x5e, 0xf3, 0x18, 0x2a, 0xed, 0xb2,
      0x48, 0x4b, 0xac, 0xe4, 0x3c, 0xd2, 0xfc, 0xaa, 0xa6, 0xf5, 0xdb, 0xc4,
      0xb6, 0x49, 0x17, 0x91, 0x59, 0x2f, 0x08, 0x4b, 0x2a, 0x14, 0xab, 0x30,
      0x3e, 0x89, 0xde, 0xb2, 0x8a, 0x68, 0xc7, 0x2b, 0x0b, 0x63, 0x0a, 0xe8,
      0x5b, 0xec, 0xb6, 0x7f, 0x2b, 0x72, 0x2f, 0x23, 0xa0, 0xf3, 0x21, 0xf3,
      0xa7, 0x49, 0x6b, 0x25, 0x18, 0x95, 0x11, 0x16, 0x40, 0x45, 0x29, 0x32,
      0x57, 0x9a, 0xa5, 0x3f, 0xfb, 0x8f, 0x8f, 0xb4, 0xff, 0xd3, 0x31, 0xfa,
      0x48, 0xc6, 0xf1, 0xe8, 0xe1, 0x52, 0xce, 0x7e, 0x04, 0xcf, 0xec, 0x94,
      0x1c, 0xd9, 0x6d, 0xcf, 0x7a, 0x88, 0x5a, 0x30, 0x22, 0xe4, 0x26, 0xd8,
      0x7e, 0x81, 0x11, 0x33, 0x6f, 0x11, 0x66, 0x87, 0x8d, 0xcf, 0x8d, 0x19,
      0x0f, 0xfb, 0x16, 0xa5, 0x74, 0xfe, 0xa9, 0xeb, 0x6d, 0x7e, 0x27, 0x0e,
      0x02, 0x5c, 0x6d, 0x98, 0x81, 0x7e, 0x75, 0xc9, 0x68, 0xf7, 0x8c, 0x47,
      0x50, 0xbe, 0x01, 0x8f, 0x74, 0x96, 0x8d, 0x7f, 0x3e, 0x5c, 0xb9, 0xd6,
      0xf4, 0x7d, 0x5a, 0xaf, 0xc9, 0x9c, 0x85, 0xc8, 0x3a, 0xf7, 0x17, 0x5c,
      0x73, 0x09, 0x1a, 0xe8},
     pub_key_0,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     true},

    // Comment:
    // tcID: 3
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     3,
     20,
     {0xac, 0x3c, 0x33, 0x2b, 0x52, 0xf0, 0x6b, 0xa2, 0x19, 0x0c, 0x6e, 0xe3,
      0x12, 0xc3, 0x23, 0x21, 0xac, 0x37, 0x70, 0x19, 0xc3, 0x54, 0x53, 0x53,
      0x7a, 0x39, 0x3b, 0xcf, 0x0c, 0x1e, 0x6f, 0x36, 0x97, 0xf7, 0x70, 0xcc,
      0xec, 0x09, 0x27, 0x40, 0x10, 0x0a, 0x70, 0x09, 0xcb, 0xa2, 0x0f, 0x86,
      0x30, 0x41, 0x08, 0x16, 0x5d, 0x5d, 0xe5, 0x72, 0xdf, 0x89, 0xc4, 0x24,
      0x23, 0xea, 0xba, 0xf9, 0x10, 0x61, 0x9d, 0x55, 0x5f, 0x7b, 0x27, 0xf7,
      0xac, 0xa3, 0x18, 0x61, 0xdb, 0x0b, 0xca, 0x83, 0x57, 0x95, 0x64, 0x66,
      0xd3, 0x79, 0x2f, 0xb6, 0x66, 0x9c, 0x77, 0xb9, 0x8b, 0xed, 0x3c, 0x72,
      0x1f, 0x71, 0x32, 0x15, 0x48, 0xf8, 0xb4, 0x31, 0x3e, 0x53, 0x5e, 0xab,
      0x56, 0x38, 0xb9, 0xe3, 0x41, 0xf4, 0xba, 0xc6, 0xc9, 0xca, 0x02, 0xbd,
      0x07, 0x11, 0x1d, 0xa4, 0xe3, 0x9f, 0x2c, 0xb8, 0xed, 0x8e, 0xa5, 0xda,
      0xce, 0xd3, 0xad, 0xa8, 0x37, 0x6e, 0xc8, 0xdb, 0x27, 0xf6, 0xd6, 0x19,
      0xad, 0x92, 0xe0, 0x1f, 0xb4, 0x9b, 0xb3, 0xe5, 0x3e, 0xc3, 0xb8, 0x4c,
      0xa6, 0x7b, 0x18, 0xc2, 0x68, 0xdb, 0x08, 0xec, 0x28, 0x75, 0x2b, 0x0c,
      0x13, 0xf2, 0x69, 0xa3, 0x9f, 0xa7, 0x00, 0xda, 0xc1, 0x63, 0xb5, 0xb9,
      0x43, 0x9c, 0xd7, 0xa9, 0x88, 0x36, 0x73, 0x33, 0x5f, 0x2b, 0x7e, 0xcc,
      0x07, 0x28, 0xab, 0x38, 0xdf, 0x17, 0x8c, 0xe1, 0x44, 0x79, 0xbf, 0x6a,
      0x8a, 0xa1, 0xe2, 0x4a, 0x43, 0x3e, 0x41, 0xf9, 0xf2, 0x17, 0xbe, 0x5c,
      0x01, 0x81, 0x24, 0x51, 0x35, 0xd1, 0xe2, 0x65, 0xe1, 0xca, 0x1a, 0xa0,
      0x6d, 0xd6, 0xe8, 0x53, 0xf5, 0xd1, 0xf1, 0x44, 0x87, 0x8e, 0x2f, 0x64,
      0x46, 0x15, 0x99, 0xcf, 0x88, 0x49, 0x02, 0x85, 0xb5, 0x2a, 0x79, 0xb7,
      0x44, 0xf2, 0x5e, 0xc5},
     pub_key_0,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment:
    // tcID: 4
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     4,
     20,
     {0x0b, 0xb9, 0x47, 0x3d, 0x3a, 0x8c, 0xc4, 0xab, 0xd6, 0x3c, 0x6f, 0x2a,
      0xc1, 0x3e, 0x27, 0x8a, 0x9c, 0xd1, 0xdd, 0xa8, 0x44, 0xfd, 0xbd, 0x13,
      0xe9, 0xb7, 0x7c, 0xdd, 0x52, 0xc1, 0xb0, 0x5a, 0xc5, 0x91, 0x26, 0xe4,
      0x5d, 0x27, 0x67, 0x77, 0xe8, 0xb1, 0xbc, 0x42, 0x3c, 0xb2, 0x61, 0xd2,
      0x96, 0x75, 0x98, 0x89, 0x54, 0xc9, 0xdd, 0xc3, 0x8b, 0xb9, 0xa6, 0x7b,
      0xec, 0x5e, 0x03, 0xe1, 0xe7, 0x80, 0x91, 0x53, 0x33, 0xdf, 0xe4, 0x94,
      0xdd, 0x8a, 0x4f, 0x0b, 0xfa, 0x0d, 0x74, 0x88, 0x05, 0x88, 0x5c, 0x38,
      0x9d, 0x6f, 0x7f, 0xb6, 0xf7, 0x86, 0xc5, 0x8d, 0x21, 0xa4, 0x68, 0xb3,
      0x58, 0x93, 0x46, 0xd7, 0x0e, 0x11, 0x53, 0xe2, 0x9d, 0xcd, 0xb9, 0x1d,
      0xec, 0x8a, 0xc1, 0x85, 0x50, 0x1e, 0xfe, 0xa2, 0x47, 0xba, 0xc7, 0xc6,
      0x3e, 0x3c, 0x54, 0x6e, 0xd6, 0x35, 0xe6, 0x47, 0x09, 0x7b, 0xae, 0x3b,
      0x8c, 0xcb, 0x99, 0x27, 0x01, 0xa7, 0x5d, 0x20, 0x9c, 0x43, 0x9c, 0x5d,
      0xbe, 0x81, 0x22, 0xda, 0x61, 0x6a, 0x4e, 0x23, 0x0b, 0xce, 0x08, 0xf5,
      0x41, 0xab, 0xff, 0x85, 0x4f, 0xb9, 0x3c, 0x87, 0xfd, 0xde, 0x0f, 0xb4,
      0x57, 0xc4, 0x4b, 0x27, 0x83, 0x56, 0x8b, 0xcb, 0xbf, 0xbb, 0xa6, 0x11,
      0xd8, 0xe9, 0x84, 0x41, 0x0d, 0x36, 0x0c, 0x4e, 0xc3, 0x73, 0x2c, 0xb6,
      0x94, 0x26, 0xa9, 0x41, 0x91, 0xd5, 0xa0, 0xcb, 0x33, 0x14, 0x9b, 0x51,
      0x8d, 0xed, 0x86, 0x86, 0x47, 0x06, 0xc7, 0x23, 0xb2, 0x72, 0x28, 0xd7,
      0x48, 0x36, 0x51, 0x31, 0x91, 0xce, 0xbc, 0x79, 0x07, 0x93, 0xe5, 0x80,
      0x92, 0x87, 0xb0, 0x27, 0x9e, 0x7b, 0xc8, 0x2f, 0x26, 0x6d, 0x43, 0x7d,
      0x19, 0x2e, 0x98, 0x97, 0x59, 0x60, 0xd0, 0x01, 0x4d, 0xd0, 0x2e, 0x17,
      0x2b, 0x7f, 0xe2, 0x51},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment:
    // tcID: 5
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     5,
     20,
     {0x1b, 0x92, 0x01, 0x5b, 0xd3, 0x4f, 0xcc, 0xe8, 0x19, 0xbc, 0xf7, 0x5a,
      0x6c, 0x38, 0xa0, 0x5a, 0xe2, 0xb4, 0x25, 0xf4, 0xb2, 0x18, 0x02, 0x30,
      0x6c, 0x1a, 0xf6, 0x45, 0xd1, 0x19, 0x7d, 0x2c, 0x84, 0xb8, 0x4b, 0x24,
      0xd4, 0x53, 0xec, 0xcc, 0x44, 0xf5, 0x78, 0x46, 0x5b, 0x81, 0x00, 0xad,
      0x9d, 0x60, 0xac, 0x49, 0x12, 0xc7, 0xaa, 0x4d, 0x57, 0x45, 0xa1, 0xac,
      0xea, 0xd1, 0x76, 0xd8, 0x75, 0x8f, 0x6a, 0xbb, 0x53, 0x2d, 0x87, 0x4b,
      0xa5, 0x40, 0x7d, 0x9e, 0x3e, 0x39, 0x9f, 0x2c, 0xd6, 0x16, 0x6b, 0x9d,
      0x3a, 0xd1, 0x74, 0x5c, 0xd2, 0x0d, 0xdb, 0xb5, 0x84, 0x89, 0x18, 0x79,
      0xeb, 0xe7, 0x1b, 0xfd, 0x42, 0x75, 0xd4, 0xc1, 0x76, 0xc9, 0xda, 0x1e,
      0x13, 0x90, 0x3e, 0x42, 0xbe, 0x68, 0xff, 0x2a, 0x78, 0xd2, 0xda, 0x93,
      0x24, 0xa8, 0xcf, 0xc7, 0xa8, 0xe2, 0xfd, 0x08, 0x30, 0x7c, 0x0e, 0xe1,
      0x42, 0x88, 0x08, 0x71, 0x96, 0xc8, 0x40, 0xa0, 0xe2, 0xb3, 0x81, 0x1d,
      0x9e, 0x9b, 0xda, 0x6e, 0xc2, 0x4b, 0xc8, 0x6e, 0x7c, 0xa5, 0xe3, 0x4b,
      0x57, 0x96, 0x9e, 0x3a, 0xac, 0x31, 0x38, 0x8f, 0xd2, 0xe6, 0x96, 0x52,
      0x8f, 0x7d, 0x51, 0x36, 0xbd, 0x44, 0xc1, 0x22, 0x15, 0x6a, 0x51, 0x47,
      0xf0, 0x5b, 0xc9, 0xb1, 0x18, 0xd3, 0xa3, 0x3e, 0xe6, 0xd7, 0xfa, 0xec,
      0xbb, 0x04, 0x82, 0x90, 0xbb, 0x0d, 0x47, 0x19, 0xc2, 0x5b, 0xa7, 0x17,
      0x41, 0xd7, 0x43, 0x4d, 0x66, 0xfc, 0x4b, 0xab, 0xa9, 0xb9, 0x95, 0xdf,
      0xbc, 0x56, 0xe3, 0x50, 0x7c, 0xfc, 0x97, 0xaa, 0x2d, 0x67, 0xac, 0xfa,
      0x10, 0x83, 0xe0, 0xef, 0x58, 0xe6, 0xdb, 0x69, 0x75, 0xb3, 0xbd, 0x6b,
      0x10, 0xdd, 0xf1, 0xc1, 0x30, 0x87, 0xd2, 0xbf, 0x54, 0x6a, 0x93, 0x1f,
      0x0b, 0xaa, 0x0c, 0xc6},
     pub_key_0,
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment:
    // tcID: 6
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     6,
     20,
     {0xab, 0x8c, 0x1e, 0x95, 0xac, 0xc3, 0x6a, 0xd6, 0x21, 0x8e, 0x48, 0xf0,
      0x33, 0x83, 0x5d, 0x15, 0xec, 0x6b, 0xc7, 0x18, 0x15, 0x52, 0xfe, 0xb6,
      0xdd, 0x6e, 0x12, 0x85, 0x46, 0x91, 0x7b, 0xac, 0x89, 0x2f, 0x5b, 0x34,
      0x9a, 0x23, 0x4d, 0x05, 0x1a, 0x83, 0xea, 0x64, 0x69, 0xe2, 0x71, 0x89,
      0xf2, 0x99, 0x53, 0x02, 0x38, 0x83, 0x37, 0xc2, 0xff, 0xb3, 0xa7, 0x46,
      0xdb, 0x17, 0xb1, 0x57, 0x92, 0x3b, 0xcf, 0x6e, 0x98, 0x5e, 0xbd, 0x20,
      0x3a, 0x4e, 0x9a, 0x23, 0x69, 0x7c, 0xf2, 0x92, 0x59, 0x12, 0xec, 0xad,
      0xc3, 0xd3, 0xf6, 0x82, 0x52, 0xe5, 0xe0, 0x1e, 0x11, 0x2d, 0xb1, 0x82,
      0x96, 0x58, 0xb1, 0x6f, 0xfe, 0x71, 0x88, 0x22, 0x89, 0x21, 0x82, 0x9e,
      0xe5, 0x9d, 0x57, 0x5c, 0x6a, 0xd8, 0x29, 0x9d, 0x76, 0xc7, 0xf5, 0xd6,
      0xcb, 0x20, 0x4b, 0x76, 0x98, 0x54, 0xde, 0x02, 0x04, 0x08, 0x75, 0x60,
      0x46, 0x59, 0x04, 0xc7, 0x3e, 0xc3, 0xbb, 0xc1, 0xb4, 0x7b, 0xbc, 0x98,
      0x58, 0x6f, 0x0b, 0xa1, 0x7b, 0x99, 0xc4, 0x32, 0x34, 0xd2, 0x62, 0xb7,
      0xf1, 0xe1, 0x9f, 0xb2, 0xcd, 0xd2, 0x0b, 0x92, 0xc3, 0x22, 0xd6, 0xe4,
      0x98, 0x83, 0x5b, 0x3c, 0xe8, 0x48, 0x0e, 0xda, 0x17, 0x29, 0x21, 0xb5,
      0xa4, 0x70, 0x7d, 0x5c, 0xcb, 0x66, 0x2e, 0x1e, 0xe4, 0xb3, 0xb4, 0xc3,
      0x6b, 0x5b, 0x48, 0x5a, 0x10, 0xae, 0xcf, 0x1b, 0x12, 0x44, 0x97, 0x32,
      0x01, 0x8e, 0x59, 0x4a, 0x73, 0x4b, 0x68, 0xc8, 0xfa, 0xd4, 0xa7, 0x30,
      0xb4, 0x69, 0xd0, 0x97, 0xc8, 0x9c, 0x41, 0x21, 0xd4, 0xf6, 0xdc, 0xe3,
      0x4b, 0xe7, 0x8f, 0x65, 0x59, 0x1b, 0x67, 0x3b, 0x1d, 0x0e, 0xe1, 0x70,
      0xcb, 0x3c, 0x18, 0x52, 0xca, 0x22, 0xbd, 0x53, 0xb9, 0xb2, 0x6b, 0x2f,
      0xa1, 0x9f, 0xf2, 0x75},
     pub_key_0,
     {0x61},
     true},

    // Comment:
    // tcID: 7
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     7,
     20,
     {0x26, 0x4d, 0xc9, 0x79, 0xcd, 0xb2, 0x93, 0xd1, 0x80, 0xf1, 0x5e, 0xf3,
      0x18, 0x33, 0x34, 0xd4, 0x94, 0x04, 0x10, 0xc9, 0x63, 0x97, 0x12, 0x91,
      0x00, 0x06, 0xc6, 0x8e, 0x37, 0x66, 0xc3, 0xab, 0xa1, 0xdd, 0x95, 0x51,
      0x0d, 0x71, 0xe7, 0xd9, 0x1d, 0x93, 0xe6, 0x11, 0x28, 0xda, 0x45, 0x6c,
      0xb0, 0xd8, 0x4c, 0x44, 0x55, 0x2f, 0x33, 0x50, 0x4b, 0xd2, 0xda, 0xe3,
      0x06, 0x99, 0xd3, 0x72, 0xe3, 0x94, 0x91, 0x2a, 0x66, 0xc3, 0x34, 0xe8,
      0x88, 0x87, 0x3a, 0x94, 0x9d, 0x58, 0xa3, 0xb7, 0xd7, 0xd4, 0x3e, 0x76,
      0x39, 0x1a, 0xb0, 0xcc, 0x49, 0x0e, 0x7c, 0x3a, 0xfe, 0xe6, 0xa5, 0xf3,
      0x26, 0x2b, 0x7d, 0x29, 0x89, 0x19, 0xd6, 0x4c, 0x5e, 0x7b, 0xb8, 0x1c,
      0xd7, 0xbf, 0x8e, 0x61, 0x2b, 0x9f, 0x6e, 0x26, 0x6e, 0xb2, 0x83, 0x16,
      0xa7, 0xfd, 0x01, 0xe4, 0x4b, 0x62, 0x10, 0x0f, 0x4b, 0x46, 0x2b, 0xa5,
      0xb2, 0x38, 0x11, 0x50, 0x81, 0x53, 0x6a, 0xd1, 0xf6, 0xa0, 0x68, 0xd6,
      0x56, 0xd0, 0x00, 0x00, 0x43, 0x1a, 0xfd, 0x1b, 0x6a, 0x5b, 0x57, 0xf4,
      0x3f, 0x27, 0xca, 0x77, 0x8c, 0x08, 0xa4, 0xf8, 0x6f, 0x62, 0xef, 0x84,
      0xc7, 0x3a, 0xa7, 0x2b, 0x0c, 0x36, 0x1c, 0x68, 0x34, 0x5c, 0x10, 0x59,
      0x9e, 0xd7, 0x31, 0xd6, 0x42, 0x3c, 0x75, 0x04, 0x62, 0xac, 0xfb, 0x46,
      0x99, 0x10, 0xa5, 0x0a, 0xa2, 0xfc, 0xad, 0x3e, 0xf8, 0xc9, 0x08, 0x63,
      0x3b, 0xd3, 0xfb, 0x0b, 0x2e, 0x7e, 0x89, 0x88, 0xf9, 0xbe, 0x2e, 0xbd,
      0x71, 0x53, 0x33, 0x38, 0x1c, 0x65, 0x06, 0xe0, 0xcd, 0xab, 0xa7, 0x69,
      0x11, 0x09, 0xcc, 0xeb, 0x8a, 0xd5, 0x36, 0x4f, 0xbc, 0x03, 0x5c, 0x30,
      0x9a, 0x50, 0x91, 0x2d, 0xbb, 0x67, 0x0a, 0x8c, 0x25, 0x5c, 0x28, 0x7a,
      0x9b, 0xa9, 0x92, 0xf0},
     pub_key_0,
     {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
      0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5,
      0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff},
     true},

    // Comment:
    // tcID: 8
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     8,
     20,
     {0x91, 0xd5, 0xf6, 0x7d, 0xd4, 0xf9, 0x3a, 0x60, 0x93, 0xad, 0xb8, 0xa7,
      0x68, 0x6b, 0xe7, 0xe4, 0x58, 0xf6, 0x6c, 0x23, 0xe3, 0x24, 0x64, 0x94,
      0x2f, 0x46, 0x19, 0x30, 0x55, 0xc6, 0x1c, 0x29, 0xdb, 0x94, 0xeb, 0x12,
      0xf9, 0x6c, 0x91, 0x8e, 0x1c, 0xbf, 0xcb, 0xcd, 0x2e, 0xd6, 0xf4, 0xef,
      0x6d, 0x27, 0x1c, 0xb6, 0xde, 0xf9, 0x03, 0x75, 0xb1, 0xc0, 0x7b, 0xb2,
      0xd5, 0xe7, 0xc1, 0xc9, 0x24, 0x25, 0xb1, 0x6b, 0x2d, 0x8a, 0xcf, 0xb8,
      0x7b, 0x8a, 0xec, 0xec, 0xb8, 0x74, 0xb7, 0xbc, 0x2e, 0xc9, 0xb2, 0x86,
      0x5f, 0x88, 0x82, 0xe0, 0x80, 0x7d, 0xb9, 0xed, 0x48, 0x1e, 0xd5, 0xfe,
      0xd0, 0xf3, 0xdc, 0xa5, 0xb6, 0x43, 0x68, 0x6e, 0x70, 0xb4, 0x94, 0x0a,
      0xf6, 0xd0, 0x86, 0xed, 0x7f, 0xb9, 0x1f, 0xc3, 0x0b, 0x32, 0x2c, 0xe9,
      0xfd, 0xa1, 0x3a, 0xb7, 0x0a, 0x72, 0x06, 0xfe, 0xab, 0x15, 0x29, 0x91,
      0x41, 0x5d, 0x50, 0xae, 0x58, 0x6e, 0x8a, 0x92, 0x29, 0xa5, 0xd2, 0xeb,
      0xdd, 0x1c, 0xfe, 0x56, 0xc1, 0x31, 0xfb, 0x83, 0x2f, 0x1d, 0xc3, 0x9b,
      0xd9, 0xfc, 0xe7, 0xb7, 0x3b, 0x19, 0x08, 0x32, 0xb4, 0x05, 0x2f, 0x5d,
      0xd3, 0x4c, 0xff, 0xcb, 0x39, 0xf5, 0xb0, 0xd5, 0x27, 0xdb, 0x23, 0x22,
      0xd2, 0x92, 0x42, 0x7b, 0xba, 0x61, 0x1c, 0xca, 0xf8, 0xaf, 0xd7, 0xce,
      0xf8, 0x87, 0x83, 0x37, 0xf1, 0xa8, 0xb2, 0xbc, 0x0f, 0x5a, 0xc0, 0x84,
      0x97, 0xee, 0xcc, 0x95, 0xb2, 0x3b, 0xa1, 0x71, 0x70, 0x77, 0x95, 0xfd,
      0xf5, 0x39, 0x7f, 0x94, 0xea, 0xd6, 0xb8, 0x56, 0x9b, 0x48, 0x71, 0xae,
      0xef, 0x10, 0x52, 0xfb, 0x4e, 0x89, 0x5b, 0xad, 0x9f, 0x17, 0x46, 0x2c,
      0x1d, 0xfd, 0x71, 0x29, 0x50, 0x63, 0x1f, 0x62, 0x55, 0x03, 0xd1, 0x33,
      0x6e, 0x85, 0x0e, 0x6f},
     pub_key_0,
     {0x38, 0x36, 0x33, 0x32, 0x37, 0x32, 0x37, 0x38, 0x30},
     true},

    // Comment:
    // tcID: 9
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     9,
     20,
     {0x50, 0x0b, 0xa4, 0x95, 0x29, 0x45, 0xdf, 0x53, 0x2e, 0x56, 0x5c, 0x98,
      0x03, 0xee, 0x08, 0xea, 0xe2, 0xb7, 0xb6, 0x9e, 0x02, 0x19, 0x9c, 0xdc,
      0x51, 0x01, 0x84, 0xfa, 0xb3, 0xf2, 0x26, 0x13, 0xf4, 0xa0, 0x05, 0xfb,
      0x42, 0x5b, 0xcf, 0xf9, 0x6e, 0x25, 0xba, 0x4f, 0x66, 0xa8, 0x49, 0xab,
      0xbd, 0x29, 0x9f, 0x2e, 0xa7, 0xd5, 0x30, 0xb2, 0x63, 0xba, 0xb4, 0x89,
      0x9e, 0xe3, 0xb6, 0x12, 0x1b, 0x88, 0xb1, 0xf2, 0xba, 0x01, 0x86, 0x86,
      0x7f, 0xca, 0xcf, 0x68, 0x6a, 0x71, 0xfd, 0xba, 0x46, 0xc2, 0xe5, 0x37,
      0x91, 0x67, 0x60, 0x3b, 0xd8, 0x8a, 0x9e, 0x1a, 0x20, 0xf5, 0x21, 0x14,
      0x20, 0xa1, 0x73, 0x7a, 0x77, 0xc4, 0x0f, 0xce, 0x3a, 0x77, 0x22, 0x11,
      0x56, 0x82, 0x88, 0x2b, 0xa0, 0x4f, 0xb5, 0x21, 0x08, 0x87, 0x50, 0x17,
      0x8f, 0x3b, 0x66, 0x59, 0x21, 0x01, 0x12, 0x09, 0xf4, 0x04, 0x6b, 0x99,
      0x81, 0xb7, 0x96, 0x96, 0xcb, 0x41, 0x93, 0xfe, 0x56, 0x78, 0x3e, 0xa9,
      0x6f, 0xfe, 0xa6, 0x2f, 0xd3, 0xf5, 0x94, 0x5e, 0x47, 0x90, 0xed, 0x1a,
      0x10, 0x59, 0xb5, 0xf8, 0x11, 0x24, 0xe5, 0x2d, 0xfd, 0xae, 0x58, 0xe6,
      0x81, 0x4a, 0x1e, 0xa9, 0x18, 0x51, 0xc0, 0x45, 0xd7, 0x19, 0x60, 0x60,
      0x0a, 0x2a, 0x94, 0xdb, 0x05, 0xf4, 0x0f, 0xdc, 0xc6, 0x1b, 0x90, 0xe8,
      0x46, 0xe5, 0x63, 0x12, 0x2e, 0x6f, 0xff, 0x4a, 0xd1, 0xba, 0x74, 0x39,
      0x4a, 0xf7, 0xfc, 0x13, 0xec, 0x46, 0xfd, 0x7b, 0xef, 0xe8, 0x82, 0x5a,
      0xbb, 0x40, 0xb3, 0x65, 0xe8, 0xec, 0xec, 0x71, 0x31, 0x76, 0x9a, 0xe3,
      0x87, 0x1e, 0x80, 0x6e, 0xff, 0x4f, 0x60, 0x92, 0x80, 0x2a, 0x8e, 0xda,
      0xa8, 0xcc, 0x47, 0xac, 0x80, 0x53, 0xc8, 0xfe, 0xfc, 0xa2, 0x16, 0x48,
      0xab, 0xca, 0xb6, 0x0f},
     pub_key_0,
     {0x36, 0x31, 0x36, 0x39, 0x33, 0x39, 0x35, 0x31, 0x33, 0x37},
     true},

    // Comment:
    // tcID: 10
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     10,
     20,
     {0x32, 0x96, 0xd2, 0xcb, 0xab, 0xc9, 0x25, 0x7d, 0x91, 0xb7, 0x5b, 0x51,
      0xb9, 0x94, 0xdf, 0xb8, 0xf7, 0x77, 0xfd, 0x26, 0x30, 0x80, 0x14, 0x14,
      0xc3, 0x3d, 0x40, 0x58, 0x60, 0xe3, 0xf7, 0x5b, 0x8b, 0x08, 0x54, 0x09,
      0x52, 0xe4, 0xde, 0xfb, 0xa2, 0x50, 0xd3, 0x94, 0x65, 0x37, 0x77, 0x4f,
      0x93, 0xa8, 0xc8, 0x86, 0x07, 0xc8, 0xd6, 0x73, 0xa0, 0xa1, 0xc7, 0x16,
      0x1e, 0xa1, 0x4c, 0x56, 0xb8, 0xd3, 0xe2, 0xd1, 0x78, 0x62, 0xe9, 0x32,
      0x14, 0x6f, 0x29, 0x93, 0x7b, 0x00, 0x84, 0x29, 0x5f, 0x16, 0xbd, 0xa9,
      0xf6, 0xc5, 0x55, 0xaf, 0x0e, 0x26, 0xf7, 0xdd, 0xd2, 0x23, 0xaf, 0x61,
      0x18, 0xc7, 0x95, 0x46, 0x3a, 0xc9, 0xb5, 0xbe, 0x70, 0xbd, 0x41, 0x3b,
      0xbe, 0xda, 0x91, 0x53, 0x9f, 0x05, 0xda, 0x15, 0x72, 0x75, 0xc2, 0x42,
      0x69, 0xf0, 0x39, 0xbe, 0x88, 0xb3, 0xc3, 0x58, 0x9e, 0x4c, 0xbc, 0x99,
      0x74, 0x6f, 0x3a, 0xcf, 0x18, 0x6b, 0x79, 0xbf, 0x27, 0x88, 0x2e, 0xf2,
      0xef, 0x3e, 0xdc, 0x0d, 0xc7, 0x17, 0xed, 0x2b, 0x94, 0xed, 0x55, 0x17,
      0x7f, 0x99, 0x53, 0x7a, 0x32, 0x61, 0xcf, 0x50, 0x98, 0x52, 0x11, 0x56,
      0x52, 0x37, 0x62, 0x61, 0xb0, 0x90, 0xef, 0x76, 0x6c, 0xc6, 0x8a, 0x99,
      0xec, 0x4e, 0xc7, 0xaa, 0x8e, 0xc6, 0xca, 0xb7, 0x24, 0xb4, 0xec, 0xca,
      0xe9, 0x80, 0x5f, 0x30, 0x0c, 0x48, 0xa0, 0x76, 0xf0, 0xdd, 0x34, 0x5b,
      0x60, 0x18, 0x94, 0x1b, 0xbe, 0x4f, 0xdb, 0xf9, 0x4e, 0x54, 0x8b, 0xdd,
      0x6b, 0xdb, 0x6c, 0x62, 0xa3, 0x58, 0x40, 0x7e, 0xd3, 0xc8, 0x4f, 0xf5,
      0x87, 0xeb, 0xb3, 0x6c, 0xa8, 0x28, 0x18, 0xfd, 0x82, 0x61, 0x8c, 0x94,
      0xbd, 0x35, 0x59, 0x44, 0x54, 0x7b, 0x09, 0xaf, 0x94, 0xa0, 0x3e, 0x68,
      0xa3, 0xf0, 0x7f, 0x94},
     pub_key_0,
     {0x33, 0x30, 0x36, 0x35, 0x33, 0x31, 0x30, 0x36, 0x31},
     true},

    // Comment:
    // tcID: 11
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     11,
     20,
     {0x97, 0xe5, 0x85, 0x9c, 0x08, 0x0f, 0x77, 0x6f, 0xaa, 0x13, 0x03, 0x9d,
      0xb1, 0x9d, 0x49, 0xea, 0xf2, 0xa1, 0x6b, 0x04, 0x82, 0x46, 0xc9, 0x39,
      0xef, 0x87, 0x5f, 0xdb, 0x4e, 0x28, 0xeb, 0x2b, 0xf4, 0xee, 0x3c, 0x11,
      0x4b, 0x2d, 0x99, 0xb2, 0x07, 0x53, 0xd1, 0x08, 0x20, 0x61, 0xfc, 0x49,
      0x35, 0x42, 0x9a, 0x92, 0xaa, 0xd3, 0xd4, 0x86, 0x71, 0x86, 0x57, 0xa8,
      0xca, 0x21, 0x41, 0x87, 0x3e, 0x69, 0x66, 0x8e, 0xdd, 0x74, 0x9f, 0x99,
      0xf1, 0xcd, 0x75, 0x7d, 0xfe, 0x7c, 0xc2, 0xdb, 0x29, 0x7c, 0xf1, 0xbc,
      0xaa, 0x1f, 0x82, 0xc3, 0xcd, 0x92, 0x48, 0x2f, 0x4d, 0xca, 0x6c, 0xa6,
      0x6b, 0x0c, 0x28, 0x27, 0x6c, 0x32, 0xc4, 0xc2, 0x86, 0x4c, 0x8e, 0x87,
      0xe8, 0xc4, 0x2b, 0x40, 0x08, 0xa8, 0x7a, 0x41, 0x00, 0x52, 0x31, 0x30,
      0xc8, 0xe4, 0xbb, 0x35, 0xb7, 0xfa, 0x7d, 0x1a, 0xf7, 0xea, 0x60, 0x97,
      0xda, 0x7f, 0x7a, 0xe8, 0x37, 0x2d, 0x5a, 0xed, 0xa2, 0x0b, 0x4a, 0x4b,
      0xa3, 0xa6, 0xc9, 0x3e, 0x1b, 0x77, 0xb1, 0x7a, 0x08, 0x32, 0x8a, 0x27,
      0xd9, 0x75, 0xcc, 0xfa, 0x6d, 0x1b, 0x90, 0x10, 0xb3, 0x4c, 0xcc, 0x12,
      0xeb, 0xc0, 0xc3, 0xd4, 0xe6, 0xbb, 0x14, 0xc1, 0xb6, 0x55, 0xa1, 0x5b,
      0x7f, 0x68, 0x60, 0x40, 0x68, 0xc9, 0xc4, 0x93, 0xf5, 0x61, 0x01, 0x7a,
      0x1a, 0xae, 0xc7, 0xc8, 0x4d, 0x1a, 0x24, 0xd9, 0xef, 0x97, 0xaa, 0x68,
      0x3a, 0x24, 0x0a, 0xbd, 0x14, 0x1a, 0x55, 0xda, 0xa3, 0xc2, 0x10, 0x17,
      0x4e, 0x73, 0x1d, 0xaf, 0xf6, 0x3e, 0xb3, 0x9a, 0xc3, 0xaa, 0xb1, 0xa7,
      0x9b, 0x9a, 0x0f, 0x91, 0x78, 0xa7, 0xc3, 0x74, 0xf0, 0xbd, 0x01, 0x48,
      0xe4, 0xff, 0xd8, 0xc9, 0xe1, 0x7f, 0x2d, 0xc7, 0xef, 0x8f, 0xb2, 0x0e,
      0x3f, 0x5f, 0x10, 0x43},
     pub_key_0,
     {0x38, 0x35, 0x39, 0x39, 0x36, 0x37, 0x34, 0x35, 0x36, 0x39},
     true},

    // Comment:
    // tcID: 12
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     12,
     20,
     {0x83, 0x57, 0xbf, 0x73, 0x0c, 0x66, 0x8c, 0xf6, 0x32, 0xcf, 0x2b, 0x1b,
      0x5f, 0x9f, 0x9f, 0x38, 0x37, 0x06, 0x1a, 0x1d, 0xe0, 0xb8, 0x69, 0x06,
      0xde, 0xbe, 0xcd, 0x43, 0x07, 0x7b, 0xd1, 0x32, 0xb6, 0xc6, 0xa0, 0x78,
      0xb3, 0x5b, 0x68, 0x78, 0xa0, 0x7a, 0x8d, 0x0a, 0x84, 0xce, 0xb4, 0x5c,
      0x93, 0xcf, 0x8e, 0x56, 0xe2, 0x1e, 0x7c, 0xfc, 0x09, 0x51, 0x07, 0x41,
      0x26, 0x72, 0xb5, 0x8f, 0xae, 0xea, 0x7c, 0xdb, 0xa7, 0x17, 0x65, 0x10,
      0x18, 0x90, 0xb1, 0x2a, 0x92, 0xaf, 0x31, 0xd1, 0x2f, 0x63, 0x70, 0x52,
      0x92, 0x15, 0xc2, 0x99, 0x46, 0x9e, 0xbf, 0xdc, 0xaa, 0x20, 0x55, 0xd2,
      0xc2, 0x26, 0x1b, 0xfc, 0xe7, 0x32, 0x99, 0x77, 0xf1, 0x3f, 0xce, 0xb5,
      0x1d, 0x44, 0x5b, 0x56, 0xa5, 0x7a, 0x4e, 0x34, 0xe7, 0xc6, 0xab, 0xcb,
      0xd7, 0xec, 0xd1, 0x3a, 0xf0, 0xd9, 0x2a, 0x63, 0x00, 0xcc, 0xaf, 0x70,
      0xe3, 0xae, 0x8a, 0x82, 0x73, 0x80, 0xc5, 0x8b, 0xfe, 0x4f, 0x38, 0x1a,
      0xb0, 0x85, 0x78, 0x45, 0x45, 0xd6, 0xb2, 0x3e, 0xbf, 0x89, 0x6e, 0xa8,
      0xc4, 0x53, 0xaf, 0x1b, 0x49, 0x87, 0x84, 0x02, 0x5c, 0x9e, 0x9e, 0xb0,
      0x1e, 0x10, 0xe9, 0xd1, 0xe2, 0x2e, 0xaf, 0x2c, 0x77, 0x90, 0x2b, 0x64,
      0x43, 0x5b, 0xe4, 0xc5, 0x4b, 0x9f, 0x3d, 0x74, 0xb6, 0x34, 0x82, 0xe6,
      0x9c, 0xf7, 0x51, 0xf5, 0x22, 0xf5, 0xa3, 0xff, 0x59, 0xa3, 0x5c, 0xce,
      0xc8, 0xe6, 0x12, 0x32, 0x14, 0x95, 0xa7, 0x27, 0xfd, 0xab, 0xe0, 0x89,
      0x12, 0x65, 0xcb, 0x45, 0xa1, 0x8c, 0x99, 0x84, 0x6a, 0xec, 0x27, 0xbc,
      0xeb, 0xdd, 0x79, 0x19, 0x5f, 0x65, 0xe0, 0x5a, 0x4d, 0x57, 0x99, 0xa3,
      0x33, 0x21, 0x95, 0x89, 0xc6, 0x1e, 0x1a, 0xaa, 0x93, 0x54, 0x79, 0x74,
      0x13, 0x87, 0x46, 0xfa},
     pub_key_0,
     {0x31, 0x35, 0x39, 0x36, 0x37, 0x38, 0x30, 0x36, 0x35, 0x34, 0x31},
     true},

    // Comment:
    // tcID: 13
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     13,
     20,
     {0x46, 0xf2, 0x50, 0x7d, 0x08, 0x17, 0xc1, 0x47, 0x53, 0xed, 0x5d, 0x4a,
      0x9f, 0xa6, 0xc9, 0x8c, 0xbc, 0xf7, 0x48, 0x3f, 0x23, 0x7e, 0xcf, 0x5d,
      0x26, 0xd7, 0x6e, 0x65, 0x22, 0xe9, 0x40, 0x21, 0x58, 0x41, 0xda, 0x07,
      0xf3, 0xf2, 0x0d, 0x4a, 0xf6, 0xd8, 0xa3, 0x5e, 0x18, 0x26, 0x17, 0x15,
      0x01, 0x15, 0x06, 0x3c, 0x1e, 0x1d, 0xc8, 0x97, 0xb6, 0x7a, 0xde, 0x6b,
      0x62, 0x63, 0x70, 0x0f, 0x54, 0x20, 0xa7, 0xf6, 0x59, 0x5c, 0xe6, 0x20,
      0xf9, 0x0c, 0xe6, 0xb8, 0x39, 0x3f, 0xf0, 0x06, 0xfe, 0x4f, 0x08, 0x25,
      0xde, 0xe8, 0x2d, 0xdc, 0xa8, 0x45, 0x7e, 0xf7, 0x4d, 0x78, 0xe3, 0x35,
      0x2f, 0x05, 0xec, 0xce, 0x19, 0x6a, 0x1b, 0xf4, 0xd4, 0x5f, 0x01, 0x83,
      0x17, 0xa6, 0xa4, 0x2c, 0x59, 0xa2, 0xf2, 0x87, 0x6f, 0x95, 0xe4, 0x05,
      0xd6, 0x5c, 0x4b, 0xc5, 0xf0, 0x38, 0x0d, 0x0e, 0x09, 0x56, 0x76, 0x6f,
      0x89, 0xb1, 0x58, 0x50, 0xfb, 0xf7, 0x36, 0xcb, 0x04, 0x29, 0x21, 0xe4,
      0x58, 0x97, 0x21, 0xb5, 0xad, 0x9a, 0xbb, 0x62, 0x13, 0xbf, 0xec, 0xf8,
      0xea, 0xb2, 0xed, 0x07, 0x7c, 0x6c, 0xf3, 0x3b, 0xe2, 0x6e, 0x8b, 0x9f,
      0xc5, 0xf9, 0x5a, 0xdc, 0x04, 0x5e, 0xff, 0xf8, 0x65, 0x82, 0x31, 0xe2,
      0x8f, 0xd5, 0x95, 0x70, 0x15, 0x31, 0xe8, 0xbc, 0x3c, 0x74, 0xb4, 0x2f,
      0x12, 0x27, 0x1f, 0x07, 0x7e, 0x08, 0xcf, 0x93, 0x86, 0xd5, 0xb6, 0x11,
      0xbd, 0x88, 0x21, 0x8e, 0x42, 0xae, 0x75, 0x7e, 0xab, 0x5c, 0x0c, 0x9b,
      0x97, 0x4c, 0x2b, 0xc1, 0x7d, 0xa1, 0x2c, 0x8b, 0xab, 0xad, 0x3e, 0xef,
      0xda, 0x8a, 0x16, 0xa5, 0x6c, 0xe3, 0x43, 0x1d, 0xa3, 0x54, 0x60, 0xb1,
      0xad, 0x1d, 0xf2, 0xb2, 0xe1, 0x72, 0xcd, 0xfc, 0x00, 0x65, 0x12, 0xe1,
      0xa4, 0xac, 0x86, 0x6f},
     pub_key_0,
     {0x33, 0x32, 0x37, 0x30, 0x38, 0x33, 0x38, 0x39, 0x39},
     true},

    // Comment:
    // tcID: 14
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     14,
     20,
     {0x0c, 0x3b, 0x3f, 0x51, 0x20, 0xfb, 0x9c, 0x7d, 0xc3, 0xa7, 0x15, 0x49,
      0x87, 0x86, 0xaa, 0xe8, 0xe2, 0xdf, 0xe5, 0xd6, 0x3f, 0x54, 0xcf, 0x80,
      0x5d, 0x02, 0xba, 0xfd, 0x36, 0xc8, 0x06, 0xc8, 0x3d, 0x0a, 0x93, 0xaf,
      0x5d, 0x1e, 0xda, 0x29, 0x3f, 0x4f, 0xfe, 0x6d, 0x0a, 0xb2, 0x18, 0x64,
      0x8a, 0x82, 0xad, 0x12, 0xdd, 0x32, 0x8a, 0x60, 0xf6, 0xc6, 0x32, 0xdb,
      0xf9, 0xf6, 0xe5, 0xe5, 0x04, 0xfd, 0x08, 0xb8, 0xb8, 0x4d, 0x8d, 0x58,
      0x00, 0x0a, 0x2d, 0x2a, 0x9f, 0x9a, 0x96, 0x6e, 0xe8, 0x98, 0xd9, 0xcb,
      0x75, 0xa6, 0x9c, 0x93, 0x0b, 0x26, 0x0f, 0x6d, 0xba, 0x3a, 0x03, 0x01,
      0xae, 0x87, 0x6e, 0x21, 0x2d, 0x4f, 0xb9, 0x71, 0xd8, 0x19, 0xc2, 0x0c,
      0xb0, 0x7a, 0xaf, 0x0f, 0xcd, 0xbc, 0x15, 0x27, 0x65, 0x39, 0x81, 0x73,
      0xdc, 0x0d, 0x72, 0x29, 0xeb, 0xcd, 0x8a, 0x9a, 0xad, 0xdf, 0xf4, 0x5d,
      0x11, 0x8b, 0xf6, 0x3a, 0xb3, 0x97, 0xad, 0xb3, 0x9a, 0xf9, 0x12, 0x03,
      0xe8, 0xfa, 0x5a, 0x7d, 0x28, 0xf2, 0x93, 0x7f, 0xf7, 0xcf, 0x31, 0xae,
      0x90, 0xdd, 0x9e, 0xfc, 0x9f, 0x25, 0x49, 0xbf, 0x6c, 0xbc, 0xc3, 0xc6,
      0x5a, 0xaf, 0x78, 0xa9, 0x3c, 0x76, 0x00, 0x7b, 0xee, 0x27, 0x20, 0x93,
      0x0e, 0x2a, 0x53, 0x31, 0x33, 0x59, 0x83, 0x94, 0x3a, 0x6d, 0x93, 0x57,
      0x0b, 0x11, 0x61, 0x51, 0x65, 0x19, 0x6f, 0x9d, 0x7d, 0xda, 0xdf, 0x80,
      0x5d, 0x44, 0x30, 0x21, 0x58, 0x05, 0x14, 0xd9, 0x21, 0xf4, 0x39, 0x89,
      0x14, 0x46, 0xc1, 0xfb, 0x1d, 0xd7, 0x40, 0x79, 0x4b, 0xbd, 0x6d, 0xec,
      0xb0, 0x17, 0xac, 0xc2, 0x38, 0xa8, 0x1c, 0xea, 0xb3, 0x60, 0x71, 0xbe,
      0x58, 0x55, 0x15, 0x57, 0xb0, 0x96, 0x43, 0xcd, 0x2b, 0xd7, 0xbe, 0x6e,
      0x69, 0xb7, 0x7a, 0xa8},
     pub_key_0,
     {0x34, 0x36, 0x30, 0x35, 0x38, 0x34, 0x35, 0x36, 0x30, 0x34},
     true},

    // Comment:
    // tcID: 15
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     15,
     20,
     {0x94, 0xb7, 0x77, 0x21, 0x5d, 0x1a, 0xe1, 0x9f, 0x95, 0x9d, 0x04, 0x6f,
      0xc0, 0x2f, 0xde, 0x3e, 0x11, 0x3e, 0x15, 0xbd, 0xad, 0xb1, 0xd7, 0x92,
      0xc7, 0x44, 0xf2, 0x17, 0x20, 0x0e, 0x27, 0x5d, 0x39, 0x54, 0xb7, 0x98,
      0xb4, 0x3e, 0x5e, 0xe3, 0x82, 0x87, 0x74, 0x20, 0x14, 0x40, 0x87, 0xbe,
      0x34, 0x0e, 0x11, 0xd2, 0x87, 0x9c, 0x10, 0xaf, 0x63, 0x76, 0x43, 0x7b,
      0x5a, 0x8f, 0x62, 0x63, 0x4f, 0xa1, 0x9b, 0x93, 0x38, 0x36, 0x0a, 0x31,
      0x8c, 0x95, 0xc9, 0x42, 0x1d, 0x90, 0xf6, 0x03, 0x37, 0x63, 0x4f, 0x3a,
      0x03, 0xa2, 0x26, 0x07, 0x96, 0xd8, 0x92, 0x8e, 0x05, 0x6a, 0xa7, 0x75,
      0x9c, 0xb1, 0x3f, 0x3b, 0xbc, 0x72, 0x95, 0x4f, 0x9c, 0x9d, 0xa7, 0xea,
      0xb1, 0xd3, 0x56, 0x40, 0x50, 0xe4, 0x26, 0x7c, 0xed, 0x55, 0x7e, 0x36,
      0x84, 0xe5, 0x09, 0x0c, 0xef, 0x96, 0xf5, 0x85, 0x15, 0x3d, 0xb8, 0xc7,
      0x32, 0xb7, 0x8b, 0x4f, 0x7d, 0xf5, 0x9d, 0xb2, 0x19, 0xd7, 0xae, 0xac,
      0x42, 0xd4, 0xf2, 0x0b, 0x1d, 0xc9, 0x82, 0x51, 0x71, 0xbb, 0xeb, 0xc2,
      0x71, 0x2e, 0x72, 0x2e, 0xd6, 0xfe, 0xd1, 0x2d, 0xfc, 0x72, 0xdc, 0xcb,
      0x1e, 0x9a, 0x2c, 0x6d, 0x93, 0xe4, 0xc8, 0x66, 0x41, 0xe1, 0xdf, 0xe1,
      0x6d, 0x6d, 0x43, 0x62, 0x9d, 0xee, 0x7d, 0x80, 0xeb, 0xa8, 0xe9, 0x63,
      0x9e, 0xa5, 0x94, 0xff, 0xa2, 0x06, 0xcf, 0x3f, 0x0e, 0x56, 0x1b, 0x29,
      0x53, 0xa2, 0x90, 0xd8, 0xcd, 0x70, 0xbd, 0x0c, 0xcb, 0xef, 0x64, 0xb3,
      0x2b, 0xd6, 0x6b, 0x29, 0x4f, 0x1f, 0xb1, 0xec, 0x97, 0xba, 0xd0, 0xe0,
      0x96, 0xe5, 0xe2, 0x00, 0xe5, 0x81, 0x2f, 0xe0, 0x25, 0x33, 0x3c, 0xed,
      0xd7, 0xd1, 0xec, 0x8c, 0x11, 0x1b, 0x28, 0xbe, 0xb4, 0xa4, 0x02, 0xf5,
      0xca, 0xbf, 0x2f, 0x99},
     pub_key_0,
     {0x31, 0x31, 0x31, 0x37, 0x38, 0x36, 0x36, 0x34, 0x32, 0x30, 0x32},
     true},

    // Comment:
    // tcID: 16
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     16,
     20,
     {0x81, 0x9f, 0x62, 0x4b, 0x0d, 0xfe, 0x68, 0x22, 0xd3, 0x92, 0x3a, 0xc1,
      0xe5, 0xc7, 0x5f, 0x79, 0xe1, 0xda, 0x3d, 0xfb, 0xc1, 0x3b, 0x33, 0x28,
      0x74, 0xd4, 0x05, 0x2e, 0xeb, 0xb3, 0x0f, 0x9b, 0x2a, 0x09, 0xec, 0xf7,
      0x5f, 0x11, 0x22, 0x99, 0x0c, 0x37, 0x36, 0x7d, 0x75, 0xe4, 0xec, 0x51,
      0x0f, 0x46, 0x45, 0xb9, 0xf4, 0x1f, 0xe4, 0xf2, 0xf9, 0x80, 0x5a, 0x98,
      0x1e, 0xa8, 0x1c, 0xe9, 0x32, 0x12, 0x76, 0x13, 0x12, 0x6c, 0xaf, 0x8e,
      0x04, 0xb9, 0xd1, 0x94, 0xa9, 0x27, 0xb7, 0x20, 0xb2, 0x4c, 0xd9, 0xf1,
      0x72, 0x1e, 0x33, 0xd1, 0x21, 0xc5, 0x99, 0x30, 0xec, 0x48, 0xa5, 0xf5,
      0x57, 0x4f, 0x9a, 0xa8, 0xc6, 0xba, 0xfb, 0x5c, 0x8c, 0xcf, 0x9d, 0xdd,
      0xb2, 0xdb, 0xb4, 0x18, 0xd9, 0x88, 0x4e, 0xcb, 0x4a, 0x93, 0x1a, 0x92,
      0x65, 0x36, 0x0d, 0xac, 0x74, 0x75, 0xde, 0x7e, 0x4c, 0xc7, 0x95, 0xce,
      0x7a, 0x58, 0x6c, 0x7d, 0x47, 0x6b, 0xa4, 0x70, 0xdd, 0xa7, 0xc0, 0x3b,
      0x3f, 0x1a, 0xb6, 0x9d, 0x93, 0x72, 0xd7, 0xcf, 0xf3, 0x42, 0x23, 0x06,
      0xed, 0xd8, 0xfe, 0x8f, 0x6d, 0xd7, 0x45, 0x59, 0x6f, 0x1f, 0xca, 0xcf,
      0xb9, 0x99, 0x14, 0x47, 0x0c, 0x13, 0xe7, 0x52, 0xbf, 0xaa, 0xdc, 0xe6,
      0x32, 0xfe, 0x41, 0x24, 0xd6, 0xcc, 0xd8, 0x0e, 0xeb, 0xf8, 0x7a, 0x69,
      0x82, 0xa9, 0x98, 0xaa, 0x4a, 0x08, 0x92, 0xc2, 0x70, 0xae, 0x6d, 0xe0,
      0xb9, 0xbc, 0xbf, 0xbc, 0x9c, 0xbd, 0x96, 0xdf, 0xf2, 0xe2, 0xf9, 0x3f,
      0x80, 0xd9, 0x37, 0x0f, 0xa2, 0xa0, 0x15, 0xe1, 0x3d, 0x03, 0x76, 0xb4,
      0xd9, 0xdc, 0xbd, 0xed, 0xea, 0x29, 0xba, 0x9b, 0x61, 0x6a, 0x83, 0x26,
      0x1c, 0xcf, 0x6e, 0xc5, 0x60, 0x79, 0xff, 0x2e, 0xc9, 0x3d, 0x72, 0x98,
      0x9c, 0xf9, 0x34, 0x54},
     pub_key_0,
     {0x38, 0x30, 0x35, 0x34, 0x35, 0x35, 0x34, 0x36, 0x34},
     true},

    // Comment:
    // tcID: 17
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     17,
     20,
     {0x11, 0x8d, 0x4d, 0xcf, 0xeb, 0xd8, 0x2e, 0xa7, 0x4b, 0x28, 0x04, 0x1b,
      0xd8, 0xbf, 0x5f, 0x96, 0x9d, 0x04, 0xe1, 0x60, 0xe2, 0xb8, 0xab, 0x2f,
      0xbb, 0xe1, 0xc2, 0xa1, 0x67, 0x3c, 0xdd, 0x4f, 0xa7, 0xd8, 0x01, 0xaa,
      0x4b, 0xc2, 0x3f, 0x98, 0x98, 0xbc, 0x0d, 0xcb, 0x24, 0x0e, 0x8a, 0x3e,
      0xde, 0x07, 0x6f, 0x91, 0x1f, 0xfe, 0xb2, 0x74, 0x9c, 0x03, 0xd2, 0x19,
      0x23, 0x05, 0x5f, 0x88, 0x78, 0xae, 0xed, 0x88, 0x56, 0x3d, 0xbb, 0xc4,
      0x54, 0x22, 0xb6, 0x58, 0xf8, 0x64, 0x7d, 0xc8, 0x68, 0x88, 0x5c, 0x92,
      0x01, 0x5d, 0xf4, 0xd5, 0x92, 0x5f, 0x3e, 0x6d, 0x75, 0xe8, 0x57, 0x54,
      0xb7, 0xf0, 0x02, 0x37, 0x4d, 0x45, 0x83, 0xed, 0x31, 0x0b, 0xc9, 0x91,
      0xca, 0xd2, 0x81, 0x2f, 0xd2, 0x9d, 0x09, 0x06, 0xc4, 0xde, 0xa5, 0xc5,
      0x29, 0x21, 0xfe, 0x21, 0x84, 0x88, 0x0c, 0x5e, 0x8c, 0xa5, 0x1b, 0x06,
      0xbc, 0x56, 0x54, 0xed, 0xd5, 0xe0, 0xe7, 0x2e, 0x20, 0x92, 0x2a, 0x9c,
      0x9b, 0x2f, 0xcd, 0x06, 0x8c, 0x70, 0x0e, 0xc8, 0x28, 0x78, 0xb6, 0xac,
      0x04, 0xa5, 0x6b, 0xec, 0xd7, 0x6f, 0xbb, 0xe9, 0xfd, 0x4a, 0xbf, 0xa9,
      0x34, 0x87, 0x56, 0xf9, 0x83, 0xbf, 0xa9, 0x25, 0x39, 0x42, 0x4d, 0x97,
      0x2d, 0x76, 0x4e, 0x78, 0x13, 0xbb, 0xbd, 0x34, 0xbb, 0x36, 0x9e, 0xc1,
      0x47, 0xfc, 0xb1, 0xa9, 0x4e, 0x86, 0x02, 0xe3, 0x59, 0xf1, 0xef, 0x31,
      0x27, 0x25, 0xf2, 0xbb, 0x81, 0xc0, 0x49, 0x32, 0xc1, 0xc4, 0xeb, 0xeb,
      0xfa, 0x09, 0xe3, 0x16, 0x5d, 0x02, 0x87, 0xa8, 0x5a, 0x22, 0xf0, 0x89,
      0x8d, 0x63, 0x85, 0x53, 0x80, 0x66, 0x24, 0x6a, 0xde, 0x07, 0xcb, 0x51,
      0x58, 0x0d, 0xb1, 0xfc, 0xca, 0x86, 0xaf, 0xad, 0x06, 0xfe, 0x2f, 0x96,
      0x95, 0xc2, 0xf8, 0xfd},
     pub_key_0,
     {0x32, 0x37, 0x33, 0x35, 0x32, 0x33, 0x30, 0x35, 0x35, 0x31},
     true},

    // Comment:
    // tcID: 18
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     18,
     20,
     {0x53, 0x71, 0x13, 0x44, 0x08, 0x85, 0x47, 0xe4, 0x05, 0xb1, 0xe3, 0xf7,
      0x60, 0x5e, 0x44, 0xf9, 0xb7, 0xb6, 0x73, 0x5d, 0x5d, 0x3c, 0x32, 0xee,
      0x0e, 0x40, 0x8f, 0xe7, 0xec, 0x9c, 0xcf, 0x58, 0x99, 0x84, 0x87, 0x44,
      0x3f, 0x66, 0xd4, 0xed, 0xc0, 0x02, 0x0d, 0xba, 0x88, 0xef, 0xde, 0xf9,
      0xea, 0xd4, 0x03, 0xa2, 0x87, 0x4b, 0x28, 0x92, 0x05, 0x4e, 0x39, 0x1f,
      0x61, 0xc1, 0xb3, 0x6e, 0x49, 0x0a, 0x86, 0x23, 0x86, 0x8e, 0xa3, 0xe3,
      0xee, 0xb0, 0x7e, 0xb6, 0xa2, 0xde, 0x96, 0x50, 0x3b, 0x93, 0xf4, 0xfb,
      0x53, 0x42, 0x25, 0x07, 0x2c, 0x6b, 0xf9, 0x08, 0x37, 0xc0, 0x29, 0xa1,
      0xf5, 0xc2, 0xa5, 0xd8, 0x19, 0x4d, 0xf2, 0xe2, 0x03, 0xfb, 0x0c, 0x2a,
      0xae, 0xea, 0x50, 0x67, 0x67, 0x95, 0x28, 0x97, 0xd9, 0x00, 0xd9, 0xfb,
      0x20, 0xc8, 0xcf, 0x4f, 0x7b, 0x68, 0xa9, 0x7a, 0x52, 0x78, 0xd7, 0xaa,
      0xa6, 0xe3, 0x83, 0xf0, 0xcc, 0x8d, 0x2b, 0x53, 0xbb, 0x74, 0x8a, 0xb6,
      0xb0, 0xdc, 0x5f, 0xb1, 0xce, 0x82, 0xb0, 0x8a, 0xa9, 0x86, 0x44, 0x9b,
      0x3c, 0x31, 0x37, 0xa5, 0x96, 0x59, 0x85, 0xd0, 0xcd, 0x62, 0xb7, 0xa1,
      0xa1, 0x1b, 0x31, 0xa4, 0x98, 0x66, 0x9a, 0x0b, 0x30, 0x72, 0x69, 0x2e,
      0xed, 0x9a, 0x13, 0x93, 0xe4, 0x2d, 0x7e, 0x61, 0xb9, 0x02, 0x26, 0xac,
      0xc6, 0x2b, 0x28, 0x4e, 0xc5, 0x50, 0xc0, 0x81, 0x3c, 0x4a, 0xfa, 0x25,
      0xa1, 0xb6, 0xfc, 0x10, 0x3c, 0xb8, 0x0c, 0xf4, 0x29, 0x94, 0x4b, 0x55,
      0x7e, 0x13, 0x34, 0xe8, 0x1c, 0x11, 0x73, 0xdf, 0x4a, 0x86, 0xab, 0x10,
      0x7c, 0xd8, 0xec, 0x6c, 0x75, 0x39, 0x2c, 0xc7, 0xcb, 0x11, 0xc9, 0x21,
      0x2f, 0x15, 0xee, 0x7e, 0x18, 0xaa, 0x0d, 0x27, 0x00, 0x6a, 0xf5, 0xc5,
      0xed, 0xe7, 0xb0, 0xe6},
     pub_key_0,
     {0x31, 0x32, 0x32, 0x38, 0x34, 0x34, 0x30, 0x38, 0x30, 0x37},
     true},

    // Comment:
    // tcID: 19
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     19,
     20,
     {0x97, 0x2a, 0xb5, 0xdf, 0xd3, 0xaa, 0x92, 0xef, 0x9f, 0xf4, 0x00, 0x26,
      0x76, 0x47, 0x16, 0x78, 0x4c, 0x87, 0x15, 0x4f, 0x12, 0x96, 0x7e, 0xd3,
      0xf0, 0x2a, 0xde, 0xe5, 0xf7, 0x3f, 0xe9, 0xa0, 0x59, 0x4b, 0x22, 0x59,
      0x9e, 0x82, 0x9b, 0xcd, 0xae, 0xb0, 0x02, 0x17, 0xa1, 0x22, 0x18, 0xda,
      0xdf, 0x06, 0xc9, 0x94, 0x0a, 0xaf, 0x9c, 0x02, 0xc7, 0x5c, 0xb1, 0x49,
      0xa8, 0x9e, 0x25, 0x8a, 0x54, 0x88, 0x94, 0xbf, 0x47, 0x62, 0x10, 0x0b,
      0xa1, 0x7b, 0xc8, 0xbc, 0x60, 0xa7, 0xa0, 0xd0, 0x53, 0x07, 0xb7, 0x13,
      0x36, 0x78, 0xdb, 0xa4, 0xba, 0xbf, 0x66, 0x0d, 0x12, 0x41, 0x86, 0x59,
      0xce, 0xa2, 0x5c, 0x9f, 0x98, 0x2b, 0xdb, 0x9b, 0x1d, 0x23, 0x00, 0xfd,
      0xd9, 0xd1, 0x44, 0xa2, 0x5d, 0x4f, 0x15, 0x0e, 0x54, 0xca, 0x7c, 0xa3,
      0x44, 0xdd, 0xe9, 0xe9, 0xe1, 0xba, 0x57, 0x83, 0xc2, 0xcb, 0x60, 0x6b,
      0xbc, 0x86, 0x34, 0x1a, 0xb9, 0x34, 0x4a, 0x08, 0x40, 0xdc, 0x51, 0x5d,
      0xd1, 0xd5, 0x89, 0xbe, 0xde, 0x2e, 0x3f, 0x48, 0x3b, 0x20, 0x18, 0x0f,
      0x08, 0x69, 0x5c, 0xca, 0x0e, 0x9e, 0x1c, 0xef, 0xc6, 0x8b, 0x6b, 0xfc,
      0x35, 0x27, 0xe4, 0x8f, 0xf0, 0x26, 0x0a, 0x3f, 0x69, 0x6c, 0x06, 0x80,
      0x36, 0x4b, 0xd4, 0xb6, 0x83, 0x0d, 0x67, 0x5e, 0xc4, 0x98, 0x66, 0x38,
      0xe9, 0x76, 0xb8, 0x3c, 0xb1, 0xf5, 0x6a, 0xd5, 0xfe, 0x70, 0x5d, 0x5d,
      0xee, 0x0c, 0x0c, 0x5e, 0xb2, 0x9b, 0xd1, 0x5a, 0x24, 0xf2, 0x65, 0x96,
      0x50, 0x00, 0xeb, 0xce, 0xe5, 0xa8, 0x55, 0x1a, 0xd8, 0xef, 0x74, 0xb4,
      0x05, 0x92, 0x47, 0x72, 0x55, 0x16, 0x9b, 0xda, 0x56, 0xdc, 0x8f, 0x35,
      0xfa, 0xfa, 0xf7, 0x96, 0xfb, 0xfa, 0x44, 0xd3, 0x66, 0x03, 0x3e, 0x15,
      0xac, 0xfe, 0x04, 0x8b},
     pub_key_0,
     {0x35, 0x31, 0x31, 0x36, 0x35, 0x38, 0x39, 0x38, 0x37},
     true},

    // Comment:
    // tcID: 20
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     20,
     20,
     {0x7a, 0x7c, 0xde, 0xad, 0x06, 0xba, 0x21, 0x2e, 0x8d, 0xd6, 0xb4, 0x46,
      0xf9, 0x11, 0xcf, 0x37, 0xb4, 0x0c, 0x5a, 0xc7, 0xf9, 0xc8, 0x17, 0x12,
      0x5c, 0x0d, 0x5e, 0xe3, 0xcd, 0xe4, 0x9e, 0xf3, 0x36, 0xb8, 0x7e, 0xb9,
      0x4f, 0x7d, 0x8a, 0x93, 0xe1, 0xd9, 0xfd, 0x0e, 0xfe, 0xb7, 0x7e, 0x72,
      0x47, 0x69, 0xb2, 0x7d, 0x6f, 0x63, 0xba, 0x91, 0xf7, 0x21, 0x9f, 0x23,
      0xe0, 0x85, 0xa3, 0x43, 0x3e, 0x4d, 0x69, 0xca, 0x8f, 0x8e, 0x42, 0x05,
      0x34, 0xf5, 0x54, 0xc6, 0x9a, 0x72, 0x21, 0xd7, 0x0e, 0x57, 0xf8, 0xa8,
      0x24, 0x6b, 0x24, 0xb5, 0x98, 0x67, 0x16, 0xc5, 0x0d, 0xa4, 0x94, 0x2a,
      0x17, 0x20, 0xe5, 0x1b, 0x3a, 0xb8, 0x7e, 0xfd, 0xad, 0x42, 0xe0, 0x2c,
      0xac, 0x25, 0x4b, 0xe2, 0x67, 0x3d, 0x5b, 0xfa, 0x46, 0x69, 0xe7, 0x64,
      0xde, 0xfb, 0x40, 0x11, 0x21, 0xa2, 0x50, 0x55, 0x99, 0x3d, 0xc5, 0xeb,
      0xba, 0x22, 0x17, 0x68, 0x34, 0xb4, 0xa2, 0xf9, 0xa8, 0xa3, 0xa3, 0x4d,
      0x35, 0xae, 0x2c, 0x34, 0x4e, 0x9a, 0x84, 0x67, 0x5d, 0x94, 0xef, 0x8f,
      0x56, 0xb1, 0x6d, 0x84, 0x8d, 0x15, 0x85, 0x1c, 0x05, 0x8a, 0xe6, 0x4d,
      0xf8, 0xa4, 0x04, 0xee, 0xe0, 0x9b, 0x63, 0xbb, 0x64, 0xfe, 0x01, 0x7c,
      0x20, 0x6a, 0x94, 0xdb, 0xd7, 0xb2, 0x74, 0x44, 0x0f, 0x04, 0xfe, 0x07,
      0xd2, 0x2d, 0x07, 0x9c, 0x2d, 0x2a, 0x86, 0x86, 0xf2, 0x47, 0xeb, 0x98,
      0x3a, 0x0e, 0xe6, 0x25, 0xb2, 0xd4, 0xb9, 0xfd, 0xd4, 0xd9, 0xad, 0xe5,
      0x37, 0x12, 0xf0, 0xd1, 0x3c, 0xf1, 0xff, 0x1a, 0xac, 0x03, 0xd0, 0x9f,
      0x80, 0x33, 0x5b, 0xf9, 0x36, 0x43, 0x27, 0xa8, 0x91, 0x71, 0xa8, 0xa5,
      0x1f, 0x42, 0x19, 0xf8, 0x66, 0x46, 0xbe, 0x96, 0xf0, 0xd9, 0x6c, 0x6c,
      0xb2, 0x7f, 0x43, 0xd3},
     pub_key_0,
     {0x36, 0x38, 0x34, 0x35, 0x38, 0x35, 0x36, 0x37, 0x32, 0x34},
     true},

    // Comment:
    // tcID: 21
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     21,
     20,
     {0xbb, 0x15, 0x91, 0x55, 0x02, 0xad, 0x77, 0xb3, 0xa0, 0x80, 0xee, 0xd7,
      0x0b, 0x44, 0x4b, 0x75, 0x34, 0x96, 0x45, 0x0a, 0x41, 0x14, 0xd4, 0x35,
      0xd2, 0xae, 0xe9, 0xfb, 0xf1, 0xb3, 0x45, 0x07, 0x4f, 0xe8, 0x5c, 0x23,
      0xad, 0x4e, 0xf5, 0x26, 0x03, 0xb3, 0xa8, 0xa0, 0x77, 0xd5, 0x02, 0x4e,
      0x3d, 0x56, 0xdd, 0x62, 0x01, 0x69, 0xb6, 0xdc, 0x0f, 0xf7, 0x43, 0x7f,
      0xe1, 0xa5, 0x20, 0xc2, 0x93, 0xd7, 0x8f, 0xaa, 0x77, 0x25, 0x8e, 0x8c,
      0x86, 0x32, 0x10, 0x0e, 0x06, 0x44, 0xf4, 0x69, 0xf0, 0xa3, 0x25, 0x0a,
      0x53, 0x48, 0x3e, 0x9a, 0x2f, 0x8d, 0xab, 0x0b, 0xda, 0xea, 0xd5, 0xdf,
      0x41, 0xdd, 0x1b, 0xba, 0x91, 0xdd, 0x01, 0xd7, 0x9e, 0xda, 0x1d, 0xf8,
      0x38, 0xdd, 0x45, 0x67, 0xd0, 0x45, 0x26, 0xb0, 0xe1, 0xfc, 0xb5, 0xd0,
      0x7c, 0xc6, 0x28, 0xf4, 0xff, 0x62, 0xfe, 0xcb, 0x65, 0xd2, 0x38, 0x6a,
      0xf6, 0x38, 0xba, 0x6d, 0x0e, 0x59, 0x45, 0x18, 0x69, 0x9c, 0x56, 0x85,
      0x03, 0x36, 0x35, 0xaf, 0x6c, 0xb3, 0x02, 0xd0, 0x7b, 0xf3, 0x9a, 0x1d,
      0xc5, 0xb5, 0x0e, 0xde, 0x06, 0xba, 0xac, 0xaf, 0xad, 0x9a, 0x2e, 0xe9,
      0xac, 0x48, 0xbf, 0x88, 0xc1, 0x13, 0x29, 0xd2, 0xbe, 0x62, 0xd5, 0x65,
      0xb0, 0x31, 0x28, 0x13, 0xfc, 0x81, 0xc9, 0xe3, 0xcd, 0x24, 0x3a, 0xac,
      0xaa, 0x6c, 0x11, 0xdc, 0xcb, 0xb6, 0x94, 0x1e, 0x2a, 0xba, 0x6f, 0x93,
      0x52, 0x4b, 0x01, 0x40, 0xf3, 0x09, 0x87, 0x16, 0x80, 0x36, 0xb1, 0x38,
      0x10, 0xc1, 0x0f, 0x65, 0xf0, 0xac, 0xc4, 0x43, 0xf7, 0xdf, 0x70, 0x09,
      0xc2, 0x38, 0xa8, 0xd5, 0xbf, 0xab, 0x00, 0x11, 0x6f, 0x1a, 0xdc, 0xb4,
      0xcb, 0xf5, 0x5c, 0x48, 0x42, 0x39, 0x68, 0x94, 0x04, 0x78, 0x8b, 0xd2,
      0x9e, 0xb7, 0x87, 0xf8},
     pub_key_0,
     {0x32, 0x37, 0x37, 0x36, 0x32, 0x39, 0x39, 0x31, 0x34, 0x35},
     true},

    // Comment:
    // tcID: 22
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     22,
     20,
     {0x4f, 0xe9, 0x65, 0xe8, 0xb6, 0x85, 0xd1, 0xef, 0xf3, 0x8f, 0x26, 0x26,
      0x1f, 0x5c, 0x16, 0x8b, 0x77, 0x56, 0x0d, 0xe5, 0xf2, 0xd7, 0x24, 0x3a,
      0x33, 0xc3, 0xc1, 0xc7, 0xf2, 0x67, 0xd7, 0xb6, 0x0e, 0x9a, 0x61, 0x44,
      0x4b, 0x6c, 0xf0, 0xa7, 0x1c, 0xaa, 0x18, 0xca, 0x81, 0xf3, 0x89, 0x60,
      0xf4, 0x5e, 0xf2, 0x95, 0x86, 0x91, 0x0c, 0x24, 0x0c, 0x93, 0x82, 0x05,
      0x51, 0xf3, 0xda, 0x5e, 0x15, 0x18, 0x06, 0x84, 0x80, 0x7f, 0xaa, 0x5d,
      0x9f, 0xd3, 0x61, 0x32, 0x5b, 0x9d, 0x39, 0xc7, 0xb8, 0xe8, 0x05, 0xab,
      0xd7, 0x5b, 0x69, 0xaf, 0x4d, 0x02, 0x03, 0x45, 0xbc, 0xda, 0x26, 0x6a,
      0x15, 0x54, 0x0b, 0x32, 0xcc, 0xd2, 0x8e, 0x57, 0xf7, 0x06, 0x3e, 0xdc,
      0x22, 0x8f, 0xbc, 0x81, 0x5f, 0x1a, 0xb9, 0x65, 0xfa, 0x54, 0x2e, 0xd6,
      0x79, 0xc4, 0x3f, 0x7b, 0x49, 0x49, 0xf7, 0x44, 0x8e, 0x68, 0x82, 0xbc,
      0x36, 0xa8, 0xf1, 0x04, 0x12, 0xdc, 0x0e, 0x82, 0x8b, 0x33, 0xad, 0x4e,
      0x09, 0xa5, 0xc7, 0x2d, 0x37, 0x30, 0x14, 0x35, 0x20, 0xe4, 0xeb, 0x62,
      0x53, 0x56, 0x61, 0x5b, 0xf4, 0x9e, 0x51, 0xcc, 0xeb, 0xe9, 0x04, 0xaf,
      0x7c, 0x63, 0x97, 0x78, 0x5d, 0xe0, 0xf2, 0x03, 0x71, 0x68, 0x9f, 0x29,
      0x75, 0x66, 0x65, 0x24, 0x10, 0x3b, 0xdb, 0xb4, 0xbf, 0x27, 0xf1, 0xe2,
      0x02, 0x01, 0x8a, 0xca, 0x80, 0x03, 0xde, 0x61, 0x5f, 0x07, 0x37, 0x73,
      0xcc, 0xa7, 0xe6, 0x47, 0xe7, 0x1e, 0xe5, 0x1d, 0x97, 0xcc, 0x30, 0x35,
      0x6a, 0x17, 0xb5, 0x0a, 0xa3, 0xc4, 0x7a, 0x74, 0xe1, 0x33, 0xaa, 0xbb,
      0xa4, 0xae, 0x41, 0x75, 0x07, 0x86, 0xa9, 0xb1, 0xe5, 0x84, 0xe3, 0x19,
      0x83, 0x6c, 0x3c, 0x7e, 0x7c, 0x8c, 0x2e, 0xb2, 0xce, 0x66, 0x04, 0x32,
      0x38, 0x56, 0xb3, 0x99},
     pub_key_0,
     {0x32, 0x38, 0x37, 0x39, 0x32, 0x38, 0x32, 0x38, 0x33, 0x34},
     true},

    // Comment:
    // tcID: 23
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     23,
     20,
     {0x9e, 0x12, 0xdc, 0x1e, 0xc8, 0x81, 0x82, 0xf9, 0x46, 0x2a, 0x79, 0x5d,
      0x71, 0x0d, 0xd0, 0x74, 0x47, 0xe7, 0x9a, 0x4e, 0x03, 0x5b, 0x97, 0xc1,
      0x6e, 0x35, 0x1c, 0x4b, 0x5d, 0x4e, 0x98, 0x45, 0x9b, 0x8e, 0x5a, 0x52,
      0xe2, 0xf5, 0x1d, 0xcc, 0x1e, 0xdc, 0x4c, 0x89, 0x43, 0x86, 0x3f, 0xa9,
      0xab, 0xc8, 0xfb, 0xd7, 0x5e, 0xe2, 0xf4, 0x76, 0x91, 0xa5, 0x84, 0x28,
      0x03, 0x40, 0x21, 0xc6, 0xd3, 0x32, 0x31, 0x91, 0xa5, 0xa5, 0xfd, 0xb2,
      0xda, 0x2a, 0xc1, 0xb2, 0xa1, 0x49, 0xb8, 0xd1, 0x02, 0x55, 0x76, 0x30,
      0x9e, 0x21, 0x41, 0x0c, 0x94, 0x00, 0xcb, 0xd3, 0xb6, 0x7d, 0x2a, 0xc4,
      0xd4, 0xaf, 0x6f, 0x57, 0xc6, 0x38, 0x0f, 0xda, 0x28, 0x17, 0xc2, 0x63,
      0x98, 0x47, 0x95, 0x93, 0x4b, 0x48, 0x84, 0x4f, 0x5e, 0xa4, 0x76, 0x14,
      0x02, 0x35, 0x41, 0x12, 0xa2, 0xa8, 0xe2, 0xc0, 0x6d, 0xcc, 0xea, 0x0e,
      0x53, 0x5a, 0x06, 0xb6, 0xb1, 0x27, 0x4a, 0x42, 0xf2, 0x18, 0xb1, 0xd4,
      0x42, 0xc2, 0xc8, 0x34, 0x7e, 0x7f, 0xd1, 0x68, 0x10, 0x0e, 0xf6, 0x58,
      0xc6, 0x3c, 0x79, 0x0e, 0x6b, 0xdf, 0xad, 0x3f, 0x4e, 0x57, 0xa5, 0x36,
      0xe2, 0xce, 0x18, 0x1a, 0x97, 0x6d, 0xee, 0x1d, 0x60, 0x5c, 0xee, 0x94,
      0x7b, 0xf5, 0xb2, 0x28, 0xf7, 0xc5, 0x40, 0xc2, 0xc9, 0xc9, 0xf2, 0xca,
      0xa0, 0x46, 0x1b, 0xf7, 0x37, 0xe3, 0x2f, 0x54, 0x54, 0xf5, 0x2c, 0xf5,
      0x30, 0x0b, 0x23, 0xe8, 0xa9, 0x92, 0x1d, 0x5e, 0x4a, 0x38, 0x0e, 0xb8,
      0x36, 0xb6, 0x45, 0x51, 0x5c, 0x0c, 0x71, 0xea, 0x80, 0x3b, 0x73, 0x0d,
      0x06, 0x67, 0xdb, 0xa4, 0x9b, 0xe3, 0x82, 0x5c, 0x7a, 0x5f, 0x49, 0xaf,
      0xb7, 0xe9, 0x89, 0xc8, 0x52, 0x46, 0xce, 0xec, 0x23, 0x6c, 0x3a, 0x0e,
      0xb4, 0x3e, 0xd8, 0xbe},
     pub_key_0,
     {0x36, 0x36, 0x35, 0x37, 0x36, 0x37, 0x39, 0x37, 0x33},
     true},

    // Comment:
    // tcID: 24
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     24,
     20,
     {0x3f, 0x55, 0x47, 0x0e, 0x61, 0x2c, 0x83, 0x2e, 0xea, 0x00, 0xcd, 0x73,
      0x8b, 0x61, 0x52, 0xbd, 0x03, 0xd8, 0x8c, 0x3a, 0xbd, 0xa9, 0x5c, 0xcc,
      0x2e, 0xd6, 0xeb, 0x6a, 0xa5, 0xc0, 0xe4, 0xd8, 0x58, 0x98, 0x2a, 0x54,
      0x8d, 0x25, 0x91, 0x4e, 0xac, 0x76, 0x49, 0xc5, 0x3d, 0x21, 0x69, 0xda,
      0x5a, 0xd4, 0xf0, 0x9b, 0xb6, 0x4d, 0x62, 0x90, 0xc9, 0x13, 0xd3, 0x46,
      0x42, 0x4d, 0x18, 0x9b, 0xc2, 0x41, 0x4e, 0xd5, 0x0d, 0xd2, 0xbd, 0xcf,
      0xe3, 0xe9, 0xe8, 0x0a, 0x99, 0x2c, 0x66, 0x11, 0xec, 0x86, 0xb5, 0x37,
      0xa8, 0xb5, 0xcd, 0x92, 0x98, 0x5c, 0xb6, 0x22, 0x6a, 0x03, 0x67, 0xc2,
      0xff, 0x20, 0xd2, 0x85, 0x9c, 0x21, 0x88, 0x2f, 0xaf, 0xb2, 0xb9, 0xc4,
      0x7f, 0x48, 0xfd, 0x19, 0xcf, 0xa1, 0x4f, 0x79, 0x3e, 0x0f, 0xff, 0x45,
      0xd0, 0x6a, 0x2e, 0x88, 0x62, 0x53, 0xa2, 0x09, 0xed, 0x95, 0x03, 0x0d,
      0xa0, 0x5a, 0x1c, 0x6e, 0xa3, 0x5d, 0x29, 0x93, 0xc6, 0x00, 0x49, 0x1b,
      0x49, 0x3d, 0xed, 0x76, 0xe9, 0x52, 0xac, 0xb0, 0x44, 0x2c, 0x52, 0x76,
      0x0f, 0xbb, 0x1f, 0x73, 0x59, 0x57, 0xa1, 0xab, 0x30, 0xfe, 0xfe, 0xa6,
      0xe7, 0xb5, 0x96, 0xa7, 0xaa, 0x4e, 0xa4, 0x79, 0xba, 0x6a, 0x6a, 0xeb,
      0x86, 0x6c, 0xe6, 0xca, 0xf3, 0x8c, 0xb7, 0xc6, 0x33, 0x8b, 0x29, 0x93,
      0x21, 0x3c, 0x39, 0xc9, 0x8b, 0x0c, 0xdd, 0x6e, 0x46, 0xc9, 0x70, 0x20,
      0x69, 0xb8, 0x5a, 0x8c, 0x7e, 0x05, 0x0c, 0x10, 0x79, 0xb1, 0x1f, 0xd2,
      0x09, 0xfd, 0xe0, 0xcc, 0x58, 0xd3, 0x7b, 0xee, 0xc4, 0x6d, 0xb4, 0xc8,
      0xc9, 0x5b, 0x40, 0x2c, 0x45, 0xb2, 0xf5, 0xb7, 0x90, 0x6f, 0x1e, 0xf1,
      0x9f, 0x2a, 0x84, 0xdb, 0xb8, 0xe5, 0x4b, 0xd5, 0xd5, 0xdd, 0x39, 0xa5,
      0x32, 0xed, 0x6e, 0x37},
     pub_key_0,
     {0x37, 0x34, 0x36, 0x35, 0x35, 0x35, 0x37, 0x30, 0x37},
     true},

    // Comment:
    // tcID: 25
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     25,
     20,
     {0x08, 0x82, 0x3a, 0x3e, 0xef, 0xc4, 0xd1, 0x3f, 0x80, 0x14, 0x19, 0xb3,
      0x74, 0xa5, 0xd8, 0xcd, 0x51, 0xf9, 0x28, 0x1e, 0x12, 0x4d, 0xeb, 0x04,
      0x15, 0x25, 0x0e, 0x9e, 0x35, 0x3e, 0x3a, 0x2f, 0x97, 0x4a, 0x83, 0x34,
      0x7c, 0xa0, 0x9d, 0x3b, 0x5e, 0xc2, 0x4e, 0xc9, 0x40, 0x48, 0xb0, 0x96,
      0xa4, 0xb1, 0x1d, 0xfa, 0xc5, 0x2f, 0x24, 0x80, 0xb5, 0x22, 0xf7, 0x0e,
      0xb4, 0xee, 0xee, 0xd6, 0xf8, 0x49, 0x41, 0xbc, 0x37, 0xd1, 0xdd, 0x1d,
      0x82, 0xd7, 0xb9, 0x88, 0x3b, 0xee, 0xf1, 0xa6, 0xcd, 0xcd, 0xc5, 0xb3,
      0xf6, 0x02, 0x4d, 0x92, 0x99, 0xb1, 0x0d, 0x76, 0x97, 0xc0, 0x32, 0x5e,
      0x2c, 0x75, 0x76, 0x4f, 0x22, 0x5c, 0xdf, 0x5f, 0xed, 0x48, 0x3a, 0xc3,
      0x00, 0xa4, 0x89, 0xb6, 0x95, 0x36, 0xac, 0xc9, 0xfc, 0x90, 0xd5, 0x81,
      0xdf, 0xa1, 0x0d, 0x67, 0x05, 0x6b, 0x3e, 0xf9, 0xb0, 0x5e, 0x09, 0xaa,
      0x8d, 0xfd, 0x3d, 0x68, 0x8e, 0xc4, 0xd6, 0x3f, 0x48, 0x3c, 0x30, 0x1a,
      0x44, 0x93, 0x4b, 0xba, 0x18, 0x41, 0x86, 0x09, 0x48, 0xc1, 0x30, 0xd6,
      0x35, 0x3e, 0x7d, 0x74, 0xc9, 0xca, 0x9e, 0x76, 0x4c, 0x44, 0xe3, 0xb6,
      0xfb, 0x16, 0x65, 0xaf, 0xd3, 0x8b, 0x6a, 0x7d, 0xf8, 0x89, 0x2d, 0x90,
      0xa0, 0xd5, 0x48, 0x3d, 0xfa, 0xec, 0x62, 0x70, 0x08, 0x4a, 0xd7, 0x6a,
      0xa5, 0x0f, 0x38, 0xe3, 0x43, 0x89, 0xf8, 0x91, 0xfa, 0x64, 0x55, 0xed,
      0x9f, 0x3c, 0xba, 0xcc, 0x42, 0x22, 0x66, 0xf6, 0xca, 0x2b, 0x10, 0xae,
      0xa5, 0xc3, 0xca, 0xf8, 0x30, 0x35, 0xc0, 0x68, 0x33, 0xcd, 0x7b, 0xbb,
      0xba, 0x83, 0xda, 0xdf, 0xb2, 0x88, 0x07, 0xf7, 0xb3, 0xd7, 0xf4, 0xac,
      0x6e, 0x90, 0x25, 0xa4, 0x72, 0x17, 0xc3, 0xdd, 0x1d, 0xfe, 0x94, 0x26,
      0xaa, 0xe6, 0x17, 0x5f},
     pub_key_0,
     {0x39, 0x38, 0x37, 0x34, 0x31, 0x32, 0x31, 0x35, 0x38, 0x38},
     true},

    // Comment:
    // tcID: 26
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     26,
     20,
     {0xbb, 0x6c, 0x05, 0x5b, 0x3f, 0x55, 0x67, 0x1f, 0x0c, 0xe8, 0x5c, 0x56,
      0x41, 0xb9, 0x70, 0xb5, 0xca, 0x0d, 0xd1, 0xf1, 0xb8, 0x97, 0x8b, 0x91,
      0x5c, 0x8e, 0x36, 0x39, 0x07, 0x00, 0xf6, 0xbf, 0xc7, 0x65, 0xdc, 0x6b,
      0x16, 0x94, 0x62, 0x56, 0x72, 0xf7, 0x0c, 0x0b, 0xdc, 0x97, 0x51, 0x7d,
      0x81, 0xcc, 0xa9, 0x19, 0x0a, 0xc4, 0xbc, 0x9e, 0xb5, 0x10, 0x5d, 0xf3,
      0x45, 0x7f, 0x48, 0x14, 0x4a, 0xb9, 0xdc, 0xc0, 0x49, 0xae, 0x54, 0xf2,
      0x81, 0x23, 0xaf, 0x02, 0x04, 0x17, 0x66, 0x85, 0xef, 0x6c, 0x2d, 0x71,
      0xb0, 0xe6, 0x18, 0x38, 0x94, 0x00, 0xe1, 0x8e, 0x90, 0xfd, 0x1d, 0xfe,
      0x65, 0xcd, 0xe8, 0x8b, 0x62, 0x8f, 0xdc, 0x41, 0x06, 0x31, 0xec, 0xae,
      0x8d, 0x64, 0xb8, 0x6d, 0xa3, 0x29, 0x22, 0x8c, 0xe4, 0xc9, 0x9f, 0xcf,
      0x57, 0x2e, 0x77, 0xe3, 0xea, 0x36, 0x6c, 0xe6, 0xd3, 0x3d, 0x14, 0x01,
      0xe2, 0x50, 0xc7, 0x5a, 0x32, 0x9c, 0x71, 0xc7, 0xf5, 0x36, 0x3a, 0x95,
      0xcf, 0xde, 0x27, 0xbc, 0x8c, 0xf0, 0x10, 0xbe, 0xf5, 0x7a, 0xac, 0xbd,
      0x44, 0xc6, 0x0a, 0x4d, 0x5b, 0x7a, 0xea, 0x41, 0xdf, 0x9b, 0x9d, 0x59,
      0xef, 0xa0, 0xcb, 0x6c, 0xd3, 0x43, 0xb3, 0xc9, 0x5c, 0x7a, 0xcb, 0xd8,
      0x4d, 0x77, 0x87, 0x3a, 0x57, 0x75, 0xc8, 0x75, 0x7c, 0x58, 0x5d, 0x66,
      0x5c, 0xfa, 0xe9, 0xbf, 0x10, 0x09, 0x5f, 0xe4, 0xf9, 0x79, 0xb5, 0x86,
      0x6b, 0x6f, 0xb3, 0x93, 0xb0, 0x98, 0x90, 0xe1, 0x18, 0xa3, 0x5a, 0xe8,
      0xa1, 0x7f, 0x7e, 0xb8, 0xf6, 0x0d, 0xd6, 0xe4, 0x95, 0x40, 0x10, 0xba,
      0x90, 0x3e, 0x69, 0xf4, 0xcd, 0xc6, 0x38, 0x80, 0xbb, 0x24, 0xc3, 0x01,
      0x9a, 0xcc, 0x59, 0x6e, 0x60, 0x28, 0xb5, 0xf1, 0xaa, 0x86, 0xcc, 0x16,
      0xd6, 0xf9, 0x72, 0x0b},
     pub_key_0,
     {0x32, 0x36, 0x30, 0x32, 0x33, 0x30, 0x32, 0x33, 0x37, 0x30},
     true},

    // Comment:
    // tcID: 27
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     27,
     20,
     {0x80, 0xac, 0x09, 0x7d, 0x00, 0x55, 0x5c, 0x8f, 0x6a, 0xc3, 0x4f, 0x3e,
      0xa9, 0x65, 0x70, 0x43, 0x22, 0x83, 0xb3, 0x73, 0xbf, 0xbf, 0xc3, 0x27,
      0xe5, 0xe1, 0xf8, 0x8b, 0x9b, 0x25, 0xd8, 0xdc, 0xcd, 0x61, 0xd1, 0x06,
      0x4a, 0x94, 0x4a, 0x10, 0x41, 0x8f, 0xfb, 0x86, 0x3c, 0xa2, 0xee, 0xe2,
      0x81, 0x82, 0xd0, 0x46, 0xea, 0x81, 0x9b, 0x77, 0x6e, 0x00, 0xa6, 0xfd,
      0x62, 0x83, 0x6a, 0xa3, 0xf3, 0x34, 0xaa, 0xf7, 0xd1, 0x48, 0x97, 0x97,
      0x17, 0x82, 0xa8, 0xe5, 0x57, 0xc5, 0x33, 0x14, 0xa3, 0xda, 0x16, 0xf3,
      0xbf, 0x09, 0x95, 0x9c, 0x13, 0x9a, 0xbf, 0x42, 0xc9, 0x5a, 0x94, 0x3e,
      0x8f, 0x73, 0x6f, 0xe6, 0xac, 0x47, 0xaa, 0xc2, 0xc4, 0x45, 0x3d, 0x2a,
      0x70, 0x91, 0x21, 0x4e, 0x9d, 0x6c, 0x81, 0x09, 0x8f, 0x39, 0x90, 0x7d,
      0x00, 0x1b, 0x4c, 0xda, 0xef, 0x6a, 0x66, 0xb4, 0x26, 0xb5, 0x71, 0x10,
      0x5a, 0x94, 0x33, 0x13, 0x49, 0xd0, 0xc4, 0xd4, 0x56, 0x26, 0x3e, 0x09,
      0x0c, 0x0e, 0xd0, 0x1a, 0xd2, 0x19, 0x5c, 0xa0, 0xe7, 0xaf, 0xfd, 0x36,
      0xd0, 0xf5, 0x59, 0xcd, 0xf1, 0x2c, 0x8c, 0x81, 0x28, 0xc7, 0xcf, 0x1a,
      0x8a, 0xeb, 0xae, 0xf6, 0x15, 0x4b, 0x4b, 0xf8, 0xe3, 0xbd, 0x8d, 0xb7,
      0x89, 0xea, 0xb0, 0x80, 0xb1, 0x4b, 0x45, 0xb1, 0x05, 0x27, 0xe8, 0x00,
      0x45, 0x2f, 0xbe, 0x2f, 0x20, 0x34, 0x5c, 0xb4, 0x1a, 0xfa, 0xe4, 0xf3,
      0x55, 0x30, 0x93, 0x6c, 0x1b, 0x99, 0x13, 0x7a, 0x33, 0x70, 0xf4, 0xf1,
      0xc9, 0xec, 0xcf, 0xa8, 0x1b, 0xfa, 0x37, 0x49, 0xfe, 0xc4, 0xb1, 0xb0,
      0x67, 0x2b, 0x50, 0xe9, 0x70, 0xc6, 0x21, 0xba, 0x0a, 0x66, 0xd1, 0xe7,
      0x75, 0xbb, 0x4d, 0xf0, 0x67, 0x4f, 0x58, 0x7c, 0x93, 0x8a, 0x29, 0x17,
      0x6c, 0x60, 0x33, 0x18},
     pub_key_0,
     {0x33, 0x37, 0x32, 0x36, 0x36, 0x31, 0x31, 0x36, 0x30, 0x38},
     true},

    // Comment:
    // tcID: 28
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     28,
     20,
     {0x66, 0x9f, 0x32, 0x56, 0x20, 0x3b, 0x4f, 0xfe, 0x73, 0xec, 0x01, 0xc2,
      0xd7, 0xd1, 0x20, 0xab, 0x9c, 0x02, 0xba, 0xb8, 0x2a, 0xc7, 0x54, 0x95,
      0xdc, 0xfa, 0x24, 0xdb, 0x2f, 0x8e, 0x79, 0x97, 0x06, 0x73, 0xd4, 0x79,
      0x0d, 0xa7, 0x72, 0xf4, 0xb1, 0x6b, 0x14, 0xf8, 0x10, 0x47, 0x08, 0x60,
      0x34, 0xb3, 0xad, 0x92, 0x71, 0x96, 0xa4, 0x83, 0x90, 0x77, 0x4a, 0xef,
      0xe0, 0xd2, 0x77, 0xff, 0x46, 0x67, 0x98, 0xd3, 0x49, 0x7c, 0x0e, 0x10,
      0x8d, 0x51, 0x47, 0x69, 0x45, 0xe4, 0xc3, 0x24, 0xd3, 0x21, 0x45, 0xaf,
      0x5d, 0x8c, 0xaf, 0xe8, 0x8b, 0xfd, 0x6a, 0x4b, 0x52, 0xc8, 0xe0, 0x33,
      0xab, 0x4b, 0x95, 0xbc, 0x5b, 0x5c, 0x34, 0x51, 0x80, 0x8f, 0x01, 0x9b,
      0x39, 0x28, 0x5e, 0xfd, 0x4f, 0xeb, 0x6c, 0x21, 0x70, 0x8b, 0x00, 0xaa,
      0x5b, 0xc7, 0x81, 0xaf, 0xa8, 0x7f, 0xd7, 0x47, 0x5c, 0xad, 0x67, 0x38,
      0x33, 0x61, 0x71, 0x59, 0xe7, 0x50, 0x51, 0x64, 0x60, 0x64, 0xd8, 0x1e,
      0xd4, 0x20, 0x44, 0x79, 0x1c, 0x27, 0xe3, 0x7e, 0xec, 0x42, 0x18, 0x93,
      0xfd, 0x37, 0x1d, 0x7c, 0xd9, 0x6b, 0x46, 0x2c, 0x15, 0x85, 0x60, 0x54,
      0x5d, 0xf3, 0xf5, 0x86, 0x2f, 0xe9, 0x79, 0x58, 0xc9, 0x97, 0x4c, 0x93,
      0x32, 0xb4, 0x6d, 0x89, 0x44, 0x86, 0xe9, 0x7c, 0x84, 0x52, 0x8a, 0x1f,
      0x55, 0xa3, 0xd9, 0xad, 0xd4, 0x29, 0xcd, 0x7c, 0x1a, 0x05, 0xfb, 0x58,
      0x2a, 0xff, 0xc1, 0x2f, 0xa3, 0xae, 0xee, 0x98, 0x0a, 0x93, 0xb8, 0x16,
      0x8f, 0x28, 0x4d, 0x7f, 0x95, 0xfa, 0xa2, 0xdd, 0xf1, 0x37, 0xe4, 0x45,
      0xd2, 0xc5, 0x65, 0x8b, 0x89, 0xa2, 0xa2, 0x30, 0xa9, 0xa6, 0x40, 0xbb,
      0xee, 0x40, 0x66, 0x5c, 0x2b, 0xed, 0xe3, 0xf1, 0x6b, 0x98, 0x6c, 0x72,
      0xad, 0x15, 0xb4, 0xf2},
     pub_key_0,
     {0x37, 0x33, 0x34, 0x34, 0x36, 0x33, 0x34, 0x34, 0x32, 0x35},
     true},

    // Comment:
    // tcID: 29
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     29,
     20,
     {0x50, 0x19, 0x1c, 0xd6, 0x48, 0x15, 0x55, 0x05, 0x42, 0x31, 0xeb, 0x25,
      0xb7, 0xd4, 0x4f, 0x37, 0x40, 0x52, 0xa2, 0x28, 0x03, 0x6f, 0x1e, 0x79,
      0x6c, 0x2d, 0x92, 0x3c, 0x9d, 0xf9, 0xbf, 0xd2, 0xf8, 0x81, 0x62, 0x08,
      0x70, 0xee, 0x4d, 0x7d, 0xff, 0xa4, 0x63, 0x7e, 0x57, 0x0d, 0x60, 0x55,
      0x34, 0x5c, 0x87, 0xb6, 0x1a, 0x2c, 0x8f, 0x4f, 0x3b, 0x53, 0x6d, 0x89,
      0xcb, 0x03, 0x79, 0x88, 0x3c, 0x99, 0xfa, 0x24, 0x6e, 0x3a, 0xe9, 0xc6,
      0xa1, 0x57, 0x77, 0x07, 0x67, 0xbb, 0x01, 0x8d, 0x70, 0x23, 0x82, 0x84,
      0x0e, 0x51, 0x25, 0xea, 0x59, 0xbb, 0x63, 0x67, 0xf9, 0x8c, 0x07, 0x03,
      0x27, 0xd3, 0x0b, 0xc4, 0xe1, 0x7c, 0x40, 0xb4, 0x65, 0xfb, 0x53, 0x14,
      0xe5, 0x96, 0x92, 0x52, 0x7d, 0x79, 0x2c, 0x91, 0x55, 0xf5, 0xf1, 0xc2,
      0xd9, 0xf4, 0x06, 0x1a, 0x3b, 0x78, 0x47, 0x41, 0x78, 0x8d, 0x92, 0xd7,
      0x61, 0xe1, 0xa3, 0xc5, 0x53, 0x32, 0x0b, 0x41, 0x65, 0xc8, 0x64, 0xe8,
      0x74, 0xf2, 0x46, 0x64, 0xde, 0x3d, 0xc6, 0xb5, 0x72, 0xdb, 0xbd, 0x4f,
      0xdc, 0x49, 0x54, 0x31, 0xde, 0x28, 0x83, 0x89, 0xc2, 0x69, 0x0b, 0xcf,
      0x56, 0x48, 0x26, 0x32, 0xee, 0x34, 0xb6, 0x38, 0xaa, 0x90, 0x2f, 0x5e,
      0xa8, 0x08, 0x93, 0x3a, 0xea, 0xce, 0x4e, 0xef, 0xbd, 0x2b, 0x6e, 0xf5,
      0x4b, 0x47, 0xcf, 0x2a, 0xfe, 0x58, 0x6c, 0x20, 0xbf, 0x01, 0x5e, 0x78,
      0x2d, 0x5a, 0xb9, 0x52, 0xbf, 0x76, 0x96, 0x26, 0x84, 0x67, 0xa6, 0xbe,
      0xb2, 0xf2, 0x50, 0x6c, 0xbc, 0xbe, 0xc9, 0x19, 0x67, 0x4f, 0xc7, 0x85,
      0x47, 0x4e, 0xe0, 0x60, 0x8c, 0x43, 0x98, 0x0f, 0x64, 0x98, 0x7e, 0xc0,
      0xb7, 0x5e, 0x80, 0x41, 0x87, 0x1e, 0xd9, 0xa2, 0xf9, 0x9b, 0xf4, 0x62,
      0x35, 0x04, 0xa9, 0xd5},
     pub_key_0,
     {0x39, 0x31, 0x30, 0x32, 0x34, 0x30, 0x39, 0x31, 0x33, 0x37},
     true},

    // Comment:
    // tcID: 30
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     30,
     20,
     {0x55, 0xa3, 0xbe, 0x3e, 0x5c, 0x6c, 0x1b, 0xb4, 0x72, 0xfe, 0xb5, 0x4e,
      0x21, 0x54, 0xae, 0xf1, 0x0c, 0x88, 0x80, 0x19, 0x51, 0x83, 0x86, 0x0a,
      0x3c, 0x19, 0xdc, 0x2f, 0x0d, 0x9f, 0x2e, 0x74, 0x73, 0xb9, 0x0b, 0xb2,
      0xa9, 0xec, 0xdb, 0x1a, 0x8b, 0x14, 0x4e, 0xe2, 0x7c, 0x60, 0xed, 0x7e,
      0xa2, 0x58, 0x38, 0xbf, 0x6e, 0xcd, 0x60, 0xc2, 0xc5, 0xda, 0xe9, 0x21,
      0x34, 0x39, 0xa9, 0xee, 0x8a, 0x7a, 0x49, 0xe9, 0x70, 0xee, 0xf3, 0xcd,
      0xbd, 0x86, 0xf0, 0xb2, 0x59, 0xd7, 0xad, 0x59, 0x82, 0x30, 0xf4, 0x3e,
      0x2a, 0x5a, 0xc0, 0xa0, 0xf6, 0x8f, 0x94, 0x7c, 0xbd, 0xed, 0x0d, 0x20,
      0xe7, 0xa7, 0x68, 0xfc, 0xa5, 0x30, 0xf3, 0xda, 0xc4, 0x15, 0x15, 0xec,
      0x9c, 0xa7, 0x91, 0x67, 0xde, 0x3d, 0x80, 0x0c, 0x8b, 0xf5, 0x47, 0x16,
      0x3b, 0x03, 0x5a, 0x0f, 0x3f, 0x45, 0xc3, 0x71, 0xd5, 0x39, 0x69, 0xeb,
      0xb6, 0xd1, 0x4e, 0x58, 0x50, 0xba, 0xb3, 0x03, 0xdb, 0xfc, 0xf8, 0x60,
      0x92, 0xb4, 0x7d, 0x41, 0x58, 0x2e, 0xde, 0x46, 0x0b, 0xf9, 0x92, 0x0c,
      0x8e, 0xee, 0x79, 0x21, 0x87, 0xd1, 0xda, 0x13, 0x49, 0x45, 0x04, 0x6d,
      0x28, 0xaf, 0x67, 0xc4, 0x33, 0xfb, 0x80, 0x2f, 0x09, 0xa6, 0xbf, 0xa9,
      0x46, 0xa8, 0xaa, 0xdb, 0xa2, 0xae, 0x9f, 0x89, 0xaf, 0xb5, 0x30, 0x54,
      0x0c, 0xbd, 0x22, 0x96, 0x01, 0x26, 0xe6, 0xe8, 0x58, 0xbe, 0x58, 0xe6,
      0x37, 0x29, 0x03, 0x69, 0x8c, 0x64, 0x42, 0x53, 0xcb, 0x5f, 0xf7, 0x2c,
      0x49, 0x3b, 0x35, 0xca, 0xa4, 0x40, 0x7d, 0x38, 0x1f, 0x96, 0xb3, 0x04,
      0xb0, 0x99, 0x3c, 0xe0, 0x8b, 0x7b, 0x0c, 0x69, 0x2c, 0x0b, 0xb7, 0x93,
      0x6f, 0x74, 0x36, 0x66, 0xdb, 0x5a, 0xeb, 0xe2, 0xaf, 0xc2, 0xc6, 0x7e,
      0x3b, 0x25, 0x6f, 0xec},
     pub_key_0,
     {0x33, 0x38, 0x32, 0x39, 0x38, 0x31, 0x38, 0x36, 0x38, 0x35},
     true},

    // Comment:
    // tcID: 31
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     31,
     20,
     {0xb6, 0xfd, 0x6d, 0x2d, 0x4e, 0xbe, 0x58, 0x60, 0x47, 0x0a, 0xec, 0x5e,
      0x25, 0xbb, 0xbb, 0x02, 0xd6, 0x7d, 0x46, 0xd9, 0x60, 0x00, 0x83, 0x11,
      0xd1, 0xdb, 0xff, 0xf3, 0xb8, 0x50, 0x48, 0xce, 0xf4, 0x06, 0x42, 0x36,
      0x21, 0x04, 0xe8, 0xe5, 0x44, 0xb9, 0x14, 0xb9, 0x97, 0x4e, 0xb5, 0x3f,
      0xf1, 0xcc, 0x12, 0xcb, 0x8b, 0x0f, 0xd5, 0xb8, 0xa9, 0x24, 0xe9, 0x6a,
      0xd9, 0x82, 0xcc, 0xaf, 0xc1, 0xa8, 0x00, 0x92, 0x58, 0x6a, 0xdb, 0xd2,
      0x90, 0x52, 0x50, 0x45, 0x2e, 0x38, 0xb3, 0x42, 0xf7, 0x92, 0x1c, 0xfc,
      0x82, 0x62, 0x3e, 0xd4, 0x99, 0x74, 0x2b, 0x2f, 0xb0, 0xb9, 0x0d, 0x1b,
      0x52, 0x85, 0xba, 0xd2, 0xfa, 0x03, 0xab, 0x82, 0x46, 0x84, 0x88, 0x35,
      0x66, 0x05, 0xb5, 0xb7, 0x69, 0x33, 0x35, 0xe8, 0xdc, 0xf9, 0x83, 0xf6,
      0x39, 0xd8, 0x2c, 0x31, 0x68, 0x02, 0x0e, 0x27, 0xa7, 0xe0, 0xd0, 0x6b,
      0x2a, 0xf1, 0x84, 0xeb, 0x96, 0x61, 0x8c, 0xe9, 0x42, 0xc9, 0x9b, 0x49,
      0xbf, 0xcc, 0x27, 0xa4, 0xb6, 0xb4, 0x7c, 0x5c, 0x07, 0x86, 0x5c, 0x5b,
      0x2e, 0xaf, 0xe3, 0x0c, 0x6b, 0xba, 0x2d, 0x9a, 0x97, 0x81, 0x8a, 0xa0,
      0xeb, 0x5d, 0x22, 0x88, 0x01, 0x81, 0x03, 0x66, 0x8f, 0x89, 0x2e, 0x8b,
      0xf5, 0xef, 0x18, 0x37, 0x52, 0x1c, 0xd2, 0xbd, 0x41, 0xb5, 0xb8, 0xf6,
      0xa9, 0x54, 0xf5, 0xc4, 0xa5, 0x0d, 0xe8, 0x74, 0xb8, 0xe0, 0x07, 0x84,
      0xa5, 0x54, 0x6c, 0xc9, 0xb7, 0xce, 0x8d, 0xe2, 0xff, 0x77, 0x67, 0x49,
      0xb0, 0x02, 0x7b, 0x37, 0x15, 0x8c, 0xd5, 0xb1, 0x1b, 0x44, 0x0a, 0x52,
      0xa1, 0x82, 0x0b, 0x79, 0x50, 0xfa, 0x68, 0x5b, 0xb4, 0x35, 0x05, 0xe1,
      0xd3, 0x53, 0x12, 0xa6, 0xfd, 0xcb, 0xec, 0xdb, 0xe9, 0x47, 0x67, 0x2d,
      0xc2, 0xbe, 0x74, 0xa1},
     pub_key_0,
     {0x31, 0x33, 0x33, 0x32, 0x31, 0x34, 0x33, 0x38, 0x30, 0x39},
     true},

    // Comment:
    // tcID: 32
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     32,
     20,
     {0x7f, 0xc5, 0x4d, 0x81, 0x08, 0x36, 0x8e, 0xef, 0x19, 0xf5, 0x87, 0x72,
      0x75, 0xd0, 0x7e, 0x87, 0x1a, 0x32, 0x51, 0xcc, 0xa7, 0x1c, 0x63, 0xca,
      0xfb, 0x46, 0x80, 0x87, 0x48, 0xcc, 0xe2, 0x40, 0xb8, 0xeb, 0x95, 0xa1,
      0xf2, 0x18, 0xb7, 0x79, 0x54, 0xed, 0xd2, 0xab, 0x87, 0x68, 0xe3, 0xfc,
      0xaa, 0x8c, 0x8d, 0x3e, 0x9b, 0x7d, 0x67, 0x8c, 0x0d, 0x44, 0xf9, 0x73,
      0x1d, 0x5a, 0x58, 0xf6, 0xac, 0x5f, 0x36, 0x43, 0x18, 0x7b, 0xf8, 0x8b,
      0xa6, 0x02, 0x33, 0x01, 0x20, 0x09, 0x36, 0xd9, 0x41, 0x45, 0x17, 0xf1,
      0xb1, 0x3a, 0xc2, 0xaf, 0xc0, 0x1d, 0x8c, 0xb8, 0xe0, 0x11, 0x63, 0x11,
      0x09, 0xf2, 0xe8, 0xeb, 0x66, 0xb6, 0x1b, 0x71, 0x10, 0xc2, 0x73, 0xe2,
      0x6c, 0x20, 0x66, 0xe9, 0x38, 0x47, 0x32, 0xb5, 0xd9, 0x78, 0xc0, 0xb2,
      0xd6, 0xa9, 0xf0, 0x22, 0x75, 0x33, 0xe0, 0x92, 0x37, 0x3f, 0xe9, 0xd8,
      0xc2, 0xdc, 0x33, 0xf8, 0x25, 0x3c, 0x13, 0xaa, 0x57, 0x30, 0xb3, 0xf7,
      0x92, 0xdd, 0x66, 0xc6, 0xb6, 0xb2, 0xbe, 0x2d, 0xc5, 0x72, 0x3a, 0x47,
      0x0d, 0x8d, 0xa1, 0x5c, 0x79, 0x28, 0x6d, 0x18, 0x42, 0xc5, 0xce, 0xa6,
      0x7e, 0xaa, 0x47, 0xb9, 0x06, 0xc4, 0xf0, 0x34, 0xd1, 0x58, 0x76, 0x10,
      0xd9, 0xfa, 0x02, 0xcb, 0x72, 0x41, 0x36, 0x4f, 0x88, 0x62, 0x45, 0x8f,
      0xeb, 0x6d, 0x8f, 0xff, 0x98, 0x25, 0x5b, 0x4c, 0x81, 0xb6, 0x9c, 0x24,
      0x8d, 0x5f, 0x5d, 0xd7, 0x21, 0xee, 0x47, 0x7b, 0x1f, 0x73, 0x41, 0xc7,
      0x38, 0x08, 0xb8, 0x80, 0xa8, 0x8f, 0x84, 0x25, 0xdf, 0xf9, 0xc2, 0x7c,
      0x2b, 0xd0, 0x14, 0x0a, 0x61, 0xb8, 0xc6, 0x4d, 0x8d, 0xae, 0x15, 0xc4,
      0x35, 0x9a, 0x91, 0x8d, 0xe4, 0x2c, 0x8a, 0x77, 0x8b, 0x8b, 0x8e, 0x35,
      0x2b, 0x62, 0x42, 0x91},
     pub_key_0,
     {0x34, 0x34, 0x34, 0x35, 0x38, 0x30, 0x35, 0x31, 0x35, 0x39},
     true},

    // Comment:
    // tcID: 33
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     33,
     20,
     {0x03, 0x9c, 0xa7, 0x9f, 0x8b, 0xcf, 0x17, 0x37, 0x4b, 0xde, 0x9d, 0xca,
      0x5b, 0x76, 0x15, 0xb8, 0x09, 0xac, 0x8d, 0x49, 0x24, 0x1a, 0x48, 0xb1,
      0x18, 0xc1, 0x8c, 0xbd, 0xd4, 0xe3, 0xfc, 0x43, 0xc2, 0xe3, 0x79, 0x2b,
      0x73, 0xd4, 0x03, 0x06, 0x2c, 0xe8, 0x00, 0xf2, 0x69, 0x55, 0x12, 0x5b,
      0x7b, 0x15, 0xbe, 0xb6, 0x0a, 0x64, 0x47, 0x71, 0x00, 0x82, 0xc6, 0xc6,
      0xbf, 0x80, 0xd2, 0x4d, 0xbb, 0x41, 0x7a, 0x58, 0xab, 0x93, 0x41, 0x60,
      0xb1, 0x88, 0x83, 0xba, 0x64, 0xf2, 0x9b, 0x46, 0x1f, 0x6f, 0x76, 0xf8,
      0x33, 0xeb, 0xd1, 0x6c, 0x38, 0xf7, 0x66, 0x49, 0x76, 0xaa, 0xec, 0x15,
      0x21, 0xab, 0x6a, 0x56, 0x7b, 0x34, 0x28, 0x3a, 0x98, 0xb8, 0x55, 0x6b,
      0x4f, 0xd3, 0x46, 0xb0, 0x50, 0xed, 0x4b, 0x17, 0x56, 0xc1, 0x22, 0x8f,
      0x89, 0x11, 0x72, 0xa6, 0x34, 0x44, 0x47, 0x79, 0xe2, 0x67, 0x98, 0x47,
      0x6d, 0x48, 0x1e, 0x41, 0x6e, 0x11, 0x80, 0xaa, 0x17, 0x09, 0xf8, 0x85,
      0xfe, 0x5c, 0x6f, 0x09, 0x14, 0x66, 0xab, 0xa6, 0x28, 0x7f, 0x72, 0x7f,
      0x26, 0xd0, 0x86, 0x61, 0x8e, 0xbb, 0xcc, 0x2c, 0x02, 0x0a, 0x00, 0x1a,
      0xd8, 0xb2, 0x4d, 0x2a, 0xd0, 0xda, 0xc7, 0x84, 0x45, 0x6e, 0x16, 0x2d,
      0x06, 0x03, 0x05, 0x67, 0x18, 0x7c, 0x25, 0xf2, 0xe2, 0xa0, 0x23, 0xe3,
      0x0d, 0xec, 0xc0, 0x76, 0xea, 0xca, 0x92, 0xd2, 0xc8, 0x20, 0x42, 0xdd,
      0x07, 0x7a, 0xbf, 0xb7, 0x88, 0xfa, 0x03, 0xa0, 0xda, 0xab, 0x97, 0x14,
      0xdb, 0x41, 0x58, 0x22, 0x50, 0x1d, 0x99, 0xf8, 0x96, 0x00, 0xf8, 0xd6,
      0x77, 0xfa, 0xa7, 0x26, 0xaa, 0x43, 0xd2, 0x31, 0x46, 0x45, 0xb2, 0x32,
      0x05, 0x88, 0xb4, 0xca, 0xd7, 0x20, 0x8b, 0x2f, 0xd1, 0x2d, 0x7f, 0x99,
      0xfc, 0x37, 0xd8, 0x09},
     pub_key_0,
     {0x39, 0x37, 0x36, 0x37, 0x30, 0x32, 0x32, 0x32, 0x32, 0x39},
     true},

    // Comment:
    // tcID: 34
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     34,
     20,
     {0x90, 0x7f, 0x82, 0x6f, 0x39, 0x41, 0x2c, 0x22, 0x97, 0x44, 0x69, 0xbb,
      0xb2, 0x8f, 0x04, 0x9d, 0x84, 0x04, 0xb9, 0x39, 0x7b, 0xbb, 0x86, 0x32,
      0x2c, 0x74, 0x28, 0x72, 0xd8, 0xdc, 0x00, 0x8b, 0xd1, 0x99, 0xec, 0x7e,
      0x89, 0x1c, 0x1a, 0x79, 0x9d, 0xa6, 0x0e, 0xf2, 0x0c, 0x9d, 0xd7, 0x57,
      0x3b, 0xa9, 0x69, 0x76, 0x1f, 0x5d, 0x81, 0x2f, 0x72, 0xe8, 0x89, 0xaf,
      0x85, 0x5b, 0x83, 0x3b, 0x5a, 0xa1, 0xca, 0xc3, 0x38, 0xcf, 0x2a, 0x42,
      0xd4, 0xe0, 0xa9, 0xd1, 0x4c, 0xbc, 0x6f, 0xb0, 0x04, 0x86, 0x6a, 0xba,
      0x01, 0x34, 0x1e, 0x9d, 0xee, 0x8e, 0x28, 0x96, 0xdf, 0x16, 0x39, 0x96,
      0xd7, 0x8c, 0x4d, 0x30, 0xd8, 0xc6, 0x87, 0x70, 0xe7, 0xc7, 0x2e, 0xaf,
      0x68, 0x9c, 0xc4, 0x97, 0x13, 0xc3, 0xeb, 0x47, 0x9b, 0xe8, 0x45, 0x2c,
      0x93, 0x5a, 0xa4, 0x4c, 0x48, 0xae, 0xcb, 0xb0, 0xd3, 0xf0, 0x64, 0x66,
      0x14, 0xd3, 0x67, 0x50, 0xef, 0x12, 0x60, 0x36, 0x82, 0x8b, 0xe7, 0x6b,
      0xe5, 0x80, 0x87, 0x99, 0x61, 0x93, 0x2a, 0x74, 0xf3, 0x4b, 0xac, 0x99,
      0x83, 0xfb, 0xa0, 0xb9, 0x70, 0xac, 0x74, 0x0f, 0x58, 0x41, 0x52, 0xc5,
      0xcb, 0xb4, 0xd6, 0xe3, 0x81, 0x5e, 0x87, 0x70, 0x1a, 0xda, 0x8d, 0x30,
      0xa5, 0x01, 0xab, 0xdb, 0x62, 0xab, 0x17, 0x3a, 0xa1, 0xa7, 0xa3, 0x19,
      0x9c, 0xa2, 0x7c, 0xfb, 0x17, 0x98, 0x95, 0x13, 0x20, 0x89, 0xc0, 0x38,
      0xe4, 0x0a, 0x27, 0x3b, 0xe4, 0x5b, 0x47, 0x1a, 0x1a, 0x1f, 0x70, 0xe7,
      0xd1, 0x76, 0xb7, 0x42, 0x4e, 0x85, 0x2b, 0x3f, 0x8c, 0x60, 0x81, 0x93,
      0xa7, 0x12, 0x65, 0x88, 0xc5, 0x06, 0x5c, 0xfc, 0x5a, 0x71, 0x17, 0xbe,
      0xb7, 0x2f, 0x73, 0xea, 0x8a, 0x83, 0x6c, 0x8a, 0x15, 0xf1, 0x2e, 0xca,
      0x67, 0xf8, 0x40, 0x51},
     pub_key_0,
     {0x31, 0x30, 0x37, 0x38, 0x38, 0x39, 0x30, 0x31, 0x37, 0x32, 0x35},
     true},

    // Comment:
    // tcID: 35
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     35,
     20,
     {0x7b, 0x78, 0x6c, 0x0a, 0x1b, 0xaa, 0xf5, 0x2f, 0xb8, 0x44, 0x59, 0xe9,
      0x2a, 0xfa, 0xf0, 0x38, 0xbf, 0xe9, 0x97, 0xc9, 0xa4, 0xd9, 0x10, 0x30,
      0x36, 0x33, 0xfe, 0x27, 0x50, 0xb9, 0x74, 0x48, 0xa1, 0x5b, 0xb0, 0x57,
      0xb5, 0x05, 0x68, 0x3b, 0xc5, 0x3c, 0xa4, 0xb1, 0x8f, 0xff, 0x1d, 0xd9,
      0x0d, 0x14, 0x16, 0xbb, 0x8c, 0x0f, 0xb2, 0xc2, 0x95, 0x50, 0xd7, 0xdd,
      0xa9, 0xc9, 0xa7, 0xf0, 0x87, 0x38, 0x67, 0x76, 0xfe, 0x65, 0xb1, 0x28,
      0x8c, 0x1f, 0x55, 0x08, 0xba, 0x94, 0x68, 0xed, 0x93, 0x28, 0xc9, 0xd6,
      0x62, 0x0e, 0x68, 0x82, 0xfc, 0x81, 0x8c, 0x4e, 0xbe, 0x83, 0x2d, 0xf3,
      0x6d, 0xcb, 0x5d, 0x92, 0x83, 0x7a, 0x71, 0x1e, 0xa6, 0xf0, 0xd2, 0x0b,
      0x78, 0x42, 0x35, 0x93, 0x3d, 0x0c, 0x57, 0x1e, 0x2d, 0x60, 0x61, 0x44,
      0x5e, 0xf5, 0xd1, 0xbc, 0x22, 0xd4, 0x33, 0x78, 0xd2, 0x59, 0x3b, 0x2a,
      0x76, 0x21, 0x14, 0xf6, 0x87, 0xbc, 0xf5, 0x9c, 0xad, 0xb4, 0xec, 0xab,
      0xf2, 0x58, 0xd3, 0xe1, 0x4a, 0x4b, 0xde, 0xa0, 0xb2, 0x15, 0x82, 0x8b,
      0x2e, 0x74, 0x62, 0x43, 0x9f, 0xcd, 0x4c, 0xb9, 0x95, 0x18, 0xbb, 0x5d,
      0x5d, 0xd9, 0x26, 0x6d, 0x6d, 0xcd, 0x45, 0x9b, 0xf3, 0x6c, 0xf3, 0x2c,
      0xb8, 0x68, 0x30, 0x67, 0x91, 0x8a, 0x22, 0x5c, 0x16, 0x85, 0xdb, 0x5e,
      0x52, 0xf9, 0xa5, 0x30, 0x5c, 0xbe, 0x60, 0xa3, 0x8d, 0xf2, 0xba, 0xbe,
      0x90, 0x13, 0x67, 0xec, 0xa5, 0x7f, 0x9c, 0xfe, 0xee, 0x29, 0x55, 0x54,
      0x9a, 0xd9, 0xb9, 0x93, 0x18, 0xb0, 0x15, 0xae, 0x19, 0x40, 0x2a, 0x4d,
      0xad, 0x77, 0x52, 0xe1, 0x5b, 0x94, 0xb2, 0x5b, 0x34, 0x14, 0xcc, 0x9b,
      0xe0, 0xc1, 0x34, 0x21, 0xf3, 0x1a, 0x41, 0xd0, 0xb1, 0xa3, 0xe4, 0x3c,
      0xe2, 0xc1, 0xd3, 0x09},
     pub_key_0,
     {0x38, 0x32, 0x31, 0x37, 0x33, 0x33, 0x38, 0x36, 0x33, 0x31},
     true},

    // Comment:
    // tcID: 36
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     36,
     20,
     {0x64, 0x2e, 0x3b, 0x94, 0xf8, 0xc5, 0xa0, 0x89, 0x7b, 0x57, 0x87, 0x80,
      0x5c, 0x99, 0xb0, 0x4a, 0xf6, 0xc7, 0xa2, 0xef, 0x47, 0xea, 0xe1, 0x0d,
      0xdc, 0xbf, 0x58, 0xe0, 0xf9, 0x41, 0x13, 0x73, 0x92, 0x0d, 0x1e, 0x4d,
      0x76, 0x96, 0x19, 0xf9, 0x71, 0x82, 0xdb, 0x36, 0xa9, 0xc3, 0x8b, 0x6c,
      0xd6, 0x95, 0xa1, 0xd9, 0x6d, 0xaa, 0xa9, 0xc9, 0x28, 0x8d, 0xdd, 0x47,
      0x74, 0xf9, 0xe0, 0x85, 0xdc, 0xb4, 0x82, 0x9f, 0x1c, 0xd8, 0x52, 0x23,
      0x90, 0x16, 0xdd, 0x23, 0xce, 0xb1, 0xa4, 0x93, 0xa1, 0x29, 0x4e, 0x3d,
      0x35, 0x10, 0x4f, 0x48, 0x38, 0x4a, 0xce, 0xbf, 0xa0, 0xcb, 0xec, 0xdc,
      0x11, 0x4f, 0x44, 0x5c, 0x63, 0xd8, 0xa1, 0x52, 0x4e, 0x60, 0x8d, 0x3f,
      0x75, 0x17, 0x27, 0x82, 0xb1, 0xc3, 0x16, 0x9d, 0x53, 0x17, 0x90, 0x2a,
      0x67, 0x96, 0x68, 0x8d, 0xd6, 0xb0, 0x11, 0x2d, 0x08, 0x22, 0xa5, 0xc6,
      0x5a, 0x9a, 0xb3, 0x1b, 0xe8, 0x4c, 0x93, 0x9c, 0xec, 0xc4, 0x19, 0x0d,
      0xfc, 0x76, 0x6c, 0xfd, 0x29, 0xb9, 0x65, 0xca, 0x02, 0xba, 0xcc, 0xf2,
      0xe3, 0xa6, 0x8f, 0x13, 0xfa, 0x30, 0x4b, 0x46, 0x9c, 0x60, 0xd7, 0xeb,
      0x49, 0x04, 0x9d, 0x78, 0xdc, 0x1e, 0x0e, 0xd9, 0x4d, 0xaa, 0x27, 0x3d,
      0xfb, 0xde, 0x71, 0x40, 0x24, 0xe6, 0x2b, 0xa9, 0x7c, 0xfc, 0x7b, 0x3d,
      0x32, 0xff, 0xf0, 0x34, 0x98, 0x65, 0x18, 0xe0, 0x48, 0x61, 0x24, 0xa6,
      0xd6, 0xd3, 0x3f, 0x40, 0x47, 0x41, 0x82, 0xb2, 0xc2, 0x35, 0x30, 0x6c,
      0x7d, 0x0d, 0x50, 0x88, 0xe7, 0xe7, 0x33, 0xb0, 0xa8, 0x95, 0x74, 0x5a,
      0x4b, 0xf4, 0xc1, 0x87, 0xd2, 0xcd, 0xc9, 0xd6, 0xa8, 0xdf, 0x71, 0x53,
      0xb4, 0x1f, 0x16, 0x30, 0x5a, 0x15, 0xda, 0x78, 0x07, 0xc6, 0xbc, 0x69,
      0xc3, 0x13, 0xb4, 0xca},
     pub_key_0,
     {0x31, 0x31, 0x34, 0x38, 0x36, 0x30, 0x37, 0x32, 0x31, 0x35},
     true},

    // Comment:
    // tcID: 37
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     37,
     20,
     {0x5a, 0xce, 0x1b, 0x9c, 0xe1, 0xf5, 0x79, 0x01, 0xe8, 0xb8, 0xa9, 0x0f,
      0x03, 0x37, 0x50, 0xf8, 0x07, 0xe5, 0x23, 0x61, 0x77, 0x9b, 0xfd, 0x97,
      0xc6, 0x0f, 0x02, 0x9c, 0xff, 0x8a, 0x70, 0x77, 0x4c, 0x06, 0x78, 0x1a,
      0x2e, 0xc5, 0xd1, 0x61, 0x16, 0xe0, 0xea, 0x51, 0x70, 0xb9, 0x9d, 0x04,
      0x86, 0xee, 0xfa, 0xfc, 0xff, 0x11, 0xf2, 0x78, 0x0d, 0x7d, 0x04, 0x13,
      0x9e, 0x28, 0xe4, 0x08, 0xa3, 0x58, 0xb4, 0x8a, 0xd5, 0x5c, 0x0d, 0x62,
      0xa3, 0x57, 0x32, 0x3d, 0x3e, 0xc7, 0x59, 0x20, 0x5d, 0xf7, 0x7c, 0x73,
      0xf8, 0x9e, 0x99, 0x1f, 0x84, 0x91, 0x14, 0xd8, 0xbf, 0xcf, 0xe4, 0xb6,
      0xa4, 0xea, 0xfd, 0x86, 0xa9, 0xcf, 0x43, 0x50, 0x07, 0x75, 0xb1, 0xcf,
      0x4b, 0x49, 0x80, 0xc4, 0xf6, 0xee, 0xe1, 0x7a, 0xef, 0x78, 0x2e, 0xb7,
      0xf9, 0x41, 0x44, 0xab, 0x1e, 0x7a, 0x0a, 0xb9, 0xc8, 0x3e, 0xf2, 0x86,
      0x0c, 0x14, 0x29, 0xd4, 0xac, 0x91, 0x74, 0x29, 0x5f, 0x5a, 0xee, 0xb6,
      0xa3, 0xd5, 0xfd, 0x43, 0x08, 0x07, 0xb9, 0xc2, 0xec, 0x20, 0xe0, 0xe2,
      0xcd, 0x12, 0x42, 0xe4, 0x96, 0xe5, 0x47, 0x0b, 0x73, 0x3d, 0xb5, 0x2c,
      0x85, 0x7b, 0xe5, 0xa6, 0x5c, 0x60, 0x47, 0x79, 0xd9, 0xe1, 0xbf, 0xa5,
      0xa7, 0xba, 0xcb, 0xf2, 0x97, 0x9f, 0x1e, 0x53, 0x32, 0x78, 0x07, 0x6f,
      0x10, 0x2b, 0x14, 0xef, 0xc3, 0x21, 0xe9, 0x05, 0xae, 0x52, 0x85, 0xe5,
      0x0e, 0x3c, 0x99, 0x98, 0x03, 0x67, 0x18, 0xb3, 0x4c, 0xff, 0x35, 0xea,
      0x0c, 0x08, 0x27, 0x35, 0xea, 0x57, 0x6a, 0xcc, 0x2f, 0x18, 0x06, 0x5c,
      0x7e, 0x05, 0xdf, 0x03, 0xd3, 0xfe, 0xe2, 0x09, 0xf1, 0xa8, 0xdf, 0x7d,
      0xa5, 0xa0, 0x7a, 0xf3, 0xa4, 0xab, 0x86, 0xe5, 0x4e, 0xdf, 0x85, 0xfe,
      0x61, 0x34, 0x3f, 0xef},
     pub_key_0,
     {0x38, 0x30, 0x34, 0x33, 0x33, 0x35, 0x30, 0x30, 0x36, 0x35},
     true},

    // Comment:
    // tcID: 38
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     38,
     20,
     {0x30, 0xa1, 0xa5, 0x57, 0xfc, 0x96, 0x51, 0xe0, 0x8c, 0x00, 0x4b, 0x23,
      0xa5, 0xfc, 0x25, 0x6b, 0x13, 0xf9, 0xf9, 0x22, 0x10, 0x82, 0xf8, 0x67,
      0x64, 0x3d, 0xd7, 0x07, 0xfd, 0x55, 0x13, 0xde, 0x72, 0xb5, 0x2d, 0x13,
      0xbd, 0x1b, 0x1b, 0x6f, 0xd0, 0x90, 0xfd, 0x81, 0x6b, 0xeb, 0x48, 0x68,
      0x13, 0x41, 0x9b, 0xd9, 0xf4, 0x26, 0xf9, 0xd4, 0xe8, 0xec, 0x7e, 0x5c,
      0x86, 0xd4, 0x22, 0x8e, 0x3b, 0xfb, 0x89, 0x92, 0x87, 0xb2, 0x35, 0x4d,
      0x5b, 0x72, 0x0d, 0xb6, 0x0b, 0x68, 0x98, 0x2e, 0x76, 0xba, 0x2b, 0x14,
      0xed, 0x22, 0xb8, 0xbf, 0x84, 0x92, 0x44, 0xc9, 0xae, 0x6b, 0x55, 0x07,
      0x1b, 0xce, 0xfd, 0x4f, 0x70, 0x63, 0xd1, 0x5b, 0xa4, 0x3e, 0x0a, 0x5f,
      0x74, 0x7b, 0xef, 0x73, 0x73, 0xcb, 0x2d, 0xcb, 0xff, 0x6d, 0x51, 0x1b,
      0x03, 0x0d, 0x3e, 0x13, 0xf6, 0x28, 0x89, 0x64, 0x06, 0x95, 0x5a, 0x77,
      0x57, 0x35, 0x70, 0x30, 0x50, 0x73, 0xd9, 0x2c, 0x5c, 0xfb, 0x2a, 0x9c,
      0x4d, 0x92, 0xf8, 0x67, 0xc1, 0x80, 0x1e, 0x63, 0xc8, 0xad, 0xdb, 0xa4,
      0x3c, 0xe3, 0xd7, 0xfa, 0xf9, 0x1a, 0xf4, 0x64, 0xf9, 0x41, 0xfa, 0xa4,
      0x8f, 0x28, 0xf5, 0x49, 0xd8, 0x97, 0xf9, 0x3c, 0x07, 0x43, 0x94, 0x13,
      0x72, 0x03, 0xa1, 0x91, 0x76, 0xcb, 0xdb, 0x41, 0xbc, 0xff, 0x26, 0x0b,
      0x7b, 0x00, 0x53, 0x50, 0x89, 0x56, 0x97, 0x0e, 0x31, 0xf6, 0x58, 0x07,
      0xb4, 0x0c, 0x3b, 0x79, 0x05, 0xda, 0x15, 0x1b, 0x55, 0x20, 0x93, 0x1e,
      0xc5, 0xc4, 0x70, 0xf0, 0x20, 0xac, 0xb3, 0x06, 0xfc, 0x6e, 0x96, 0x9a,
      0x89, 0x96, 0x6f, 0xef, 0x4a, 0xb1, 0xc2, 0xa1, 0x7f, 0xd5, 0xa1, 0x12,
      0xe0, 0xa8, 0x41, 0xb8, 0x53, 0xdd, 0x14, 0x49, 0xbe, 0x32, 0xa3, 0xb5,
      0x2d, 0x2f, 0x6e, 0x89},
     pub_key_0,
     {0x36, 0x36, 0x39, 0x39, 0x34, 0x34, 0x37, 0x30, 0x33, 0x35},
     true},

    // Comment:
    // tcID: 39
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     39,
     20,
     {0x19, 0x60, 0xaa, 0x85, 0xaf, 0xb7, 0x5f, 0x52, 0xa0, 0xbe, 0xe9, 0x17,
      0xbd, 0x0a, 0xfd, 0x51, 0xde, 0x8a, 0xbb, 0xe1, 0xbe, 0x7a, 0xbf, 0xa7,
      0xc8, 0x32, 0x1f, 0x74, 0xe1, 0x89, 0x21, 0xdb, 0x7d, 0x53, 0xde, 0x05,
      0x25, 0x35, 0xc2, 0xb1, 0x0c, 0x71, 0xc3, 0x2a, 0xd8, 0x40, 0x16, 0xa9,
      0x98, 0x98, 0x0a, 0x89, 0xca, 0xcf, 0xbb, 0xda, 0x35, 0x43, 0xc3, 0x99,
      0x31, 0x95, 0x38, 0xf3, 0xa2, 0x16, 0x98, 0x1b, 0xa9, 0x38, 0xa5, 0x3f,
      0x52, 0xb0, 0xd5, 0xb0, 0x78, 0xa6, 0xce, 0xf7, 0x04, 0x7b, 0xeb, 0xce,
      0x6c, 0x50, 0x23, 0xdb, 0x08, 0x01, 0x72, 0xd9, 0x0b, 0x86, 0x86, 0x98,
      0xa2, 0x90, 0x9b, 0x2f, 0xde, 0x70, 0x13, 0x28, 0x37, 0x07, 0xf9, 0xb7,
      0x4f, 0x3d, 0x80, 0x0c, 0x39, 0xb0, 0xf5, 0xdc, 0xfe, 0xd8, 0x45, 0x79,
      0x16, 0x78, 0xc7, 0x69, 0x63, 0x24, 0xab, 0xc9, 0x73, 0x31, 0x70, 0x2f,
      0x22, 0x36, 0x62, 0x01, 0x82, 0xfb, 0x52, 0x8e, 0x2b, 0xe5, 0x95, 0xad,
      0x10, 0x16, 0x1b, 0xd8, 0x89, 0xff, 0x68, 0x8b, 0xde, 0x34, 0x95, 0x0f,
      0x2b, 0x2f, 0xbb, 0xb3, 0x98, 0x3f, 0x76, 0xca, 0x92, 0x24, 0xdf, 0x04,
      0xe2, 0xde, 0xf7, 0xad, 0xa7, 0xda, 0xc4, 0xba, 0x70, 0xd7, 0x63, 0xe2,
      0xbd, 0x7b, 0xf0, 0xb5, 0xa9, 0xd0, 0x5e, 0x80, 0x8f, 0x9e, 0x44, 0x26,
      0xf0, 0x4c, 0xc9, 0x4e, 0x28, 0x51, 0x0f, 0xd8, 0xb9, 0x1a, 0x83, 0x8f,
      0x86, 0xc8, 0x08, 0x85, 0x1e, 0xd8, 0x8f, 0xb0, 0xe4, 0x75, 0x5a, 0xfc,
      0x73, 0xe5, 0x71, 0x6e, 0x9e, 0x42, 0xd7, 0x94, 0xe3, 0x51, 0xa4, 0xf3,
      0x10, 0x00, 0x42, 0x73, 0x36, 0xe7, 0x05, 0x28, 0x49, 0xcc, 0x67, 0x3b,
      0x7e, 0x54, 0x54, 0x71, 0x27, 0xe7, 0xe6, 0xf6, 0x62, 0xca, 0xf6, 0xbc,
      0x51, 0x2d, 0x52, 0x5e},
     pub_key_0,
     {0x39, 0x39, 0x33, 0x35, 0x32, 0x39, 0x32, 0x34, 0x31},
     true},

    // Comment:
    // tcID: 40
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     40,
     20,
     {0x59, 0x6a, 0x2b, 0x36, 0x37, 0x0d, 0xd1, 0x15, 0xba, 0x49, 0x61, 0x09,
      0xe5, 0xa9, 0x85, 0x1b, 0x2f, 0xf5, 0x8c, 0x2f, 0x9a, 0x5b, 0xfd, 0x1b,
      0x26, 0xcd, 0xf3, 0xea, 0xbb, 0x84, 0x0c, 0x49, 0xb4, 0x6b, 0x6a, 0x68,
      0x87, 0xe4, 0xc1, 0x3c, 0x4b, 0x93, 0x0b, 0x73, 0x76, 0x49, 0xbd, 0xc5,
      0x6f, 0xb8, 0x91, 0x68, 0xe4, 0x6d, 0x91, 0xa1, 0xf1, 0x18, 0x6a, 0xde,
      0xcd, 0x0f, 0xe8, 0x67, 0xce, 0xc0, 0x67, 0xc9, 0xa9, 0x0e, 0x8e, 0x1a,
      0x66, 0x38, 0x80, 0xec, 0x44, 0x00, 0x67, 0x22, 0xd4, 0xa6, 0x88, 0x8b,
      0x83, 0xb7, 0x64, 0xa8, 0x64, 0x92, 0x5d, 0xe7, 0x00, 0xb3, 0x0a, 0x6b,
      0x07, 0x52, 0x04, 0xa8, 0x97, 0x88, 0x00, 0x29, 0x6d, 0x5e, 0xb0, 0xef,
      0x1f, 0x0d, 0xc9, 0xac, 0x87, 0xc5, 0xfb, 0x7a, 0x4b, 0x2a, 0x7c, 0xd1,
      0x48, 0x56, 0x6e, 0xd6, 0xea, 0xcd, 0xaf, 0xfe, 0x22, 0xd9, 0x14, 0xda,
      0x5f, 0x2d, 0x6c, 0xed, 0xf7, 0xad, 0xa2, 0x85, 0x93, 0xb5, 0x48, 0x77,
      0x5d, 0x74, 0x8a, 0x61, 0xb6, 0xed, 0x22, 0xab, 0x59, 0x34, 0xbd, 0xa0,
      0xc5, 0x77, 0x82, 0xca, 0xf1, 0xf4, 0x8a, 0x30, 0x9c, 0x80, 0xbe, 0xd4,
      0xfc, 0xaa, 0xcf, 0xae, 0x1d, 0xc0, 0x43, 0x28, 0x47, 0x58, 0x3a, 0xee,
      0x83, 0x32, 0xee, 0xc9, 0x43, 0x5e, 0x40, 0x9f, 0xce, 0x2e, 0x0d, 0x3e,
      0x14, 0xf6, 0xc4, 0xcc, 0xf1, 0x21, 0xb8, 0xee, 0xa6, 0xf5, 0xb4, 0x15,
      0x89, 0x4e, 0xba, 0x24, 0xef, 0x06, 0x6a, 0x08, 0xd5, 0xfa, 0xa9, 0x23,
      0x1f, 0xe3, 0xe7, 0x76, 0x7c, 0xd1, 0xfb, 0xde, 0xa7, 0x85, 0x0d, 0xb1,
      0xae, 0xae, 0xda, 0x75, 0x5d, 0xcb, 0xd8, 0xae, 0xc3, 0x3a, 0x7d, 0xab,
      0xf4, 0x30, 0xbb, 0x70, 0x02, 0x75, 0x4e, 0x38, 0xa7, 0x01, 0x17, 0xb4,
      0x7d, 0x3f, 0x67, 0x7e},
     pub_key_0,
     {0x34, 0x32, 0x36, 0x31, 0x37, 0x34, 0x30, 0x35, 0x35, 0x30},
     true},

    // Comment: first byte of m_hash modified
    // tcID: 41
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     41,
     20,
     {0xb8, 0xed, 0xfc, 0xc9, 0xff, 0x64, 0x51, 0xff, 0x58, 0x38, 0xc4, 0x70,
      0x23, 0x2c, 0x4d, 0x0f, 0x35, 0x8a, 0x88, 0xff, 0x63, 0x44, 0xe6, 0x2c,
      0xf4, 0xcf, 0x91, 0x70, 0x57, 0x6e, 0x65, 0x95, 0xfb, 0x22, 0xf6, 0xb2,
      0xf3, 0xb2, 0x19, 0x0a, 0x6f, 0x28, 0x67, 0x45, 0xe3, 0x9a, 0x30, 0x0c,
      0xfd, 0x36, 0x8f, 0x82, 0xf8, 0x6f, 0x12, 0xf8, 0x1a, 0xd4, 0xf8, 0x54,
      0x6c, 0xaf, 0xed, 0xb0, 0x0a, 0x38, 0xbc, 0x85, 0xf8, 0xe2, 0x40, 0x12,
      0x7f, 0xc2, 0x32, 0xef, 0x82, 0x87, 0xc7, 0xbb, 0xd3, 0x5f, 0xda, 0xf5,
      0x5c, 0xa8, 0x49, 0xc9, 0x74, 0x5e, 0xf2, 0xed, 0x13, 0x71, 0xa8, 0x4e,
      0x77, 0xcd, 0xb0, 0x75, 0x13, 0xa5, 0xe8, 0xdc, 0x48, 0x98, 0xe7, 0xa9,
      0xc8, 0xc5, 0x2a, 0x3e, 0x35, 0xb3, 0x68, 0x2a, 0xbb, 0xa3, 0xb5, 0x83,
      0x12, 0x30, 0x26, 0xb9, 0x84, 0x0a, 0xe2, 0x86, 0x14, 0x84, 0x26, 0xc5,
      0x9b, 0x4c, 0x00, 0x56, 0x6a, 0x14, 0x7c, 0x6d, 0x89, 0xe0, 0x39, 0xb2,
      0x80, 0x52, 0xa8, 0x97, 0x4f, 0x96, 0x6c, 0x2d, 0x77, 0xcb, 0xd2, 0x6a,
      0xd9, 0x4f, 0x54, 0xce, 0x98, 0x77, 0x48, 0x37, 0x4e, 0x88, 0xb7, 0xbc,
      0xc4, 0xaf, 0xd2, 0x45, 0x82, 0xd4, 0x08, 0xdb, 0x9c, 0xf9, 0x49, 0x06,
      0xae, 0x9d, 0x00, 0x39, 0xe1, 0xbd, 0x22, 0xad, 0x8a, 0x23, 0xa8, 0xc3,
      0x79, 0x77, 0x7e, 0xca, 0xc9, 0x54, 0x54, 0x0f, 0x1b, 0x13, 0x18, 0x63,
      0x69, 0xfe, 0x34, 0x80, 0x95, 0x5c, 0xbe, 0xf6, 0x09, 0x07, 0x54, 0xb2,
      0x86, 0xc8, 0xe9, 0xad, 0xaa, 0x28, 0x8b, 0x10, 0x24, 0xd9, 0x4b, 0xe0,
      0x29, 0x1d, 0x20, 0xe2, 0x0a, 0x9e, 0xeb, 0x52, 0x5d, 0x5e, 0x9a, 0x2e,
      0x0e, 0x0b, 0x5c, 0xb4, 0x41, 0x98, 0x02, 0xb3, 0x08, 0xe2, 0x75, 0x54,
      0xca, 0x34, 0x10, 0xa0},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of m_hash modified
    // tcID: 42
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     42,
     20,
     {0x48, 0xc5, 0x90, 0x34, 0x7b, 0x59, 0x3c, 0xab, 0x64, 0x2b, 0x07, 0xd4,
      0x9b, 0xc2, 0x22, 0x95, 0x03, 0xad, 0x80, 0x79, 0xdf, 0xa8, 0x2e, 0x3c,
      0xe1, 0xf0, 0x14, 0xd1, 0xf0, 0x04, 0x6c, 0x58, 0x62, 0xea, 0x5d, 0x3d,
      0x3c, 0x3f, 0x44, 0x70, 0x53, 0x70, 0xb1, 0x50, 0x79, 0xe1, 0xdd, 0xa2,
      0x62, 0x7e, 0x3a, 0xe8, 0x61, 0xfd, 0xff, 0x25, 0xee, 0xfb, 0xbb, 0x43,
      0x64, 0x00, 0x70, 0x28, 0x16, 0xff, 0x8c, 0x60, 0xae, 0xc8, 0xe2, 0xca,
      0xe0, 0xe0, 0xfd, 0x2e, 0xa8, 0x7a, 0x3c, 0x9e, 0xa0, 0x37, 0x31, 0xfa,
      0x2c, 0x5f, 0xc7, 0x82, 0x99, 0xae, 0xa7, 0x62, 0x99, 0x51, 0xcb, 0x71,
      0xad, 0xf1, 0x60, 0x8e, 0x58, 0x43, 0xb3, 0xf9, 0xc9, 0x9f, 0x0c, 0x3a,
      0xd3, 0x7b, 0x6c, 0x85, 0xe0, 0xa2, 0x71, 0xa1, 0xf5, 0xa0, 0x73, 0x22,
      0x43, 0x3c, 0x59, 0x45, 0xf9, 0xa4, 0x71, 0xe6, 0x95, 0xc0, 0xee, 0x81,
      0x56, 0x4a, 0x9b, 0xc6, 0x13, 0xb7, 0x3e, 0x07, 0x00, 0xa8, 0x04, 0xd7,
      0xc8, 0x19, 0x6f, 0x16, 0x07, 0x29, 0xb8, 0xf9, 0x01, 0x67, 0xa6, 0x70,
      0x47, 0x61, 0x93, 0x0b, 0xcc, 0x5a, 0xab, 0x75, 0xf2, 0xd5, 0xe7, 0x10,
      0x67, 0xe7, 0x99, 0x83, 0x3a, 0x8f, 0x4d, 0x8e, 0xd4, 0x9e, 0xa1, 0x7e,
      0xc7, 0x1a, 0x29, 0xbb, 0x9d, 0x20, 0xc9, 0x65, 0x01, 0x24, 0x1d, 0x97,
      0x93, 0x1e, 0x90, 0xb0, 0xf5, 0x0d, 0xb3, 0x9a, 0x57, 0x82, 0x9c, 0x61,
      0x5c, 0xa2, 0x62, 0xd7, 0x56, 0x74, 0x4b, 0xa3, 0x42, 0x2c, 0x35, 0x05,
      0x48, 0x4c, 0x79, 0xe9, 0x64, 0xd8, 0x40, 0x92, 0x73, 0x31, 0xa1, 0x49,
      0x08, 0x89, 0xee, 0x67, 0xed, 0x1a, 0xf6, 0x81, 0xd3, 0x50, 0xe0, 0xa1,
      0xfc, 0x95, 0xb4, 0x46, 0xc9, 0x5e, 0x38, 0xa3, 0xc1, 0x4a, 0xf3, 0x23,
      0x6c, 0xfd, 0xff, 0x4d},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of m_hash modified
    // tcID: 43
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     43,
     20,
     {0x53, 0xdb, 0xcd, 0xc6, 0x1a, 0xca, 0xb0, 0xd9, 0x66, 0x64, 0x4f, 0x60,
      0xbb, 0xa8, 0xb9, 0xc7, 0x82, 0x61, 0xf0, 0x1a, 0xfc, 0xbe, 0xe9, 0x5e,
      0x20, 0x6f, 0xae, 0x66, 0x5c, 0x07, 0xfc, 0x69, 0xc1, 0x30, 0x15, 0x94,
      0x1a, 0xf7, 0xb6, 0x84, 0x74, 0x51, 0x91, 0xfb, 0x78, 0x38, 0x76, 0x80,
      0xa2, 0x74, 0x83, 0x8d, 0x1d, 0x9a, 0x3b, 0xd4, 0xb5, 0xf5, 0x56, 0x40,
      0x6e, 0xd1, 0x1e, 0x18, 0x79, 0xde, 0xf7, 0xc2, 0xf0, 0x18, 0xf5, 0x7b,
      0x31, 0x73, 0x20, 0x01, 0x3e, 0x9d, 0x49, 0x95, 0xf1, 0x61, 0x0c, 0xb3,
      0xca, 0xbb, 0x8f, 0x8c, 0xdb, 0xf7, 0x18, 0xd5, 0xc3, 0x04, 0x43, 0x17,
      0xb0, 0x00, 0x57, 0x42, 0x44, 0xd5, 0xfb, 0x9f, 0xe6, 0x64, 0xbb, 0xd4,
      0x0a, 0xeb, 0x0b, 0xd0, 0x66, 0xd4, 0xcc, 0xfa, 0x22, 0x4a, 0x49, 0xc3,
      0xe9, 0xe3, 0xa3, 0xae, 0x32, 0x36, 0x90, 0xe5, 0xfe, 0x77, 0xa3, 0xc7,
      0x2d, 0x5d, 0xc7, 0x52, 0xbe, 0x7d, 0x68, 0xec, 0xc3, 0x89, 0x58, 0xa2,
      0xbf, 0xa8, 0xe0, 0xc9, 0x36, 0x5b, 0x5e, 0x54, 0x6c, 0xa1, 0x5f, 0xb9,
      0x5e, 0x20, 0x5a, 0x30, 0x81, 0x8b, 0x01, 0xb6, 0x1f, 0xbf, 0x7a, 0x67,
      0x09, 0x28, 0x1b, 0x9c, 0xcc, 0xc9, 0xa0, 0xc1, 0x11, 0x9c, 0xb8, 0xc1,
      0x1c, 0x4f, 0xa2, 0xe5, 0xfe, 0xa4, 0xaf, 0xfc, 0x47, 0x7b, 0x19, 0x35,
      0xb8, 0xba, 0x73, 0x8c, 0x39, 0x08, 0x9f, 0x15, 0xc6, 0xfe, 0x0f, 0xec,
      0x0c, 0x78, 0xb9, 0x74, 0x64, 0x6e, 0xa0, 0xeb, 0xb8, 0x0c, 0xa5, 0xe8,
      0x38, 0x6d, 0x98, 0x03, 0x76, 0x47, 0x04, 0xe7, 0xf1, 0x61, 0x88, 0xa8,
      0x11, 0xde, 0x89, 0x37, 0x9f, 0xab, 0x80, 0x47, 0x17, 0x36, 0x4c, 0xf9,
      0xec, 0x39, 0x37, 0x1e, 0xaa, 0x41, 0x6c, 0x62, 0x8a, 0x55, 0xd2, 0xdc,
      0x1a, 0x5b, 0x5e, 0xd9},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of m_hash modified
    // tcID: 44
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     44,
     20,
     {0x17, 0xb5, 0x50, 0xac, 0x16, 0x8e, 0x25, 0xeb, 0xf6, 0xd1, 0xbd, 0x66,
      0xac, 0x30, 0x81, 0x5c, 0xfd, 0xb6, 0x80, 0x27, 0x87, 0x93, 0xfe, 0xc7,
      0x8b, 0x36, 0xe2, 0xf2, 0x8d, 0x10, 0xc3, 0x28, 0x92, 0xdd, 0x0a, 0xf9,
      0x95, 0x0f, 0x84, 0x02, 0xad, 0x8b, 0x54, 0x59, 0x74, 0x72, 0x24, 0x9a,
      0xeb, 0x95, 0x63, 0x21, 0x5e, 0x17, 0xa1, 0x7a, 0xd8, 0xff, 0xad, 0x7c,
      0x4a, 0x1c, 0x14, 0xc4, 0xb9, 0x2c, 0xd8, 0xdf, 0xc0, 0x35, 0xcf, 0xaa,
      0xc6, 0xd6, 0x62, 0xe2, 0x7c, 0x0d, 0xf6, 0xb1, 0xd7, 0x87, 0xb7, 0x13,
      0x6a, 0x4a, 0xbd, 0x5e, 0xf2, 0xab, 0xf8, 0x05, 0xcf, 0xa6, 0x8a, 0xc8,
      0xee, 0xe0, 0xa6, 0xb5, 0x00, 0x1b, 0x9f, 0xe8, 0x85, 0x5a, 0x08, 0x52,
      0x6d, 0xa1, 0x97, 0x1d, 0x32, 0xd0, 0xa3, 0x92, 0x42, 0x4b, 0xbd, 0x37,
      0xbd, 0x43, 0xf6, 0x8b, 0x81, 0x19, 0xaa, 0x5c, 0x6e, 0xa3, 0x3d, 0xa8,
      0x17, 0x66, 0x0e, 0xbc, 0x35, 0xd8, 0x0c, 0x4d, 0x47, 0x7a, 0xf3, 0x36,
      0x3b, 0xdc, 0xa4, 0xc9, 0x76, 0xec, 0x84, 0xf2, 0xaa, 0xe2, 0xcf, 0xfd,
      0xf9, 0xce, 0x51, 0x7b, 0x50, 0x99, 0x4e, 0x6a, 0x06, 0x2f, 0x19, 0x9d,
      0x71, 0x32, 0x3c, 0x53, 0x2d, 0x57, 0xe7, 0x6f, 0x8d, 0x89, 0x67, 0x4c,
      0x36, 0x1e, 0x22, 0x75, 0x32, 0x65, 0x89, 0xb1, 0x42, 0xb4, 0xdb, 0x82,
      0x68, 0xa1, 0xb3, 0x64, 0x25, 0xa7, 0xd7, 0x0c, 0x57, 0x11, 0x5d, 0xf2,
      0xbc, 0x96, 0x95, 0xd6, 0xdc, 0x2a, 0xd6, 0xf3, 0x85, 0x0d, 0x0c, 0xfd,
      0xa5, 0x45, 0xa8, 0xe8, 0x7a, 0x75, 0xa4, 0x9a, 0xd2, 0x83, 0x8c, 0xd2,
      0x40, 0xf3, 0x46, 0x1a, 0x28, 0x52, 0x01, 0xa8, 0x3d, 0xbb, 0x67, 0x08,
      0x51, 0xa9, 0xab, 0xcd, 0xb1, 0x1f, 0x2b, 0x26, 0xd8, 0xc8, 0x9f, 0x1e,
      0xe4, 0xd4, 0x4e, 0xe9},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bits in m_hash flipped
    // tcID: 45
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     45,
     20,
     {0x11, 0xcb, 0x2f, 0x04, 0x4d, 0x4b, 0xae, 0x43, 0xfa, 0x2c, 0x7b, 0xb9,
      0x67, 0xf8, 0xf3, 0xae, 0xf3, 0x37, 0x16, 0xe0, 0xe5, 0x19, 0xad, 0x0c,
      0x49, 0x57, 0x0b, 0xd7, 0x28, 0x88, 0x32, 0x23, 0x9f, 0x71, 0xbe, 0x6a,
      0xb8, 0x2b, 0x9b, 0xb9, 0x65, 0x20, 0x97, 0x2d, 0xf4, 0xb4, 0x5c, 0x8b,
      0x85, 0xf0, 0xdc, 0xbd, 0x8a, 0xa6, 0x83, 0x95, 0x06, 0xc8, 0xb4, 0x4a,
      0x99, 0x0b, 0x20, 0xe0, 0xc2, 0xb5, 0x8c, 0x31, 0x35, 0x59, 0xf8, 0x6a,
      0xed, 0x3b, 0xd6, 0x48, 0xd8, 0xa7, 0xba, 0x5e, 0xf2, 0xaf, 0x00, 0xb9,
      0x58, 0xeb, 0x89, 0xfd, 0x69, 0xa3, 0x10, 0x7b, 0xdc, 0x51, 0x9c, 0x60,
      0xdf, 0xfb, 0x21, 0xa2, 0x0d, 0x4a, 0x37, 0xdf, 0x75, 0x72, 0xb3, 0xe4,
      0x96, 0xdb, 0x68, 0xca, 0x86, 0xf9, 0xe8, 0x5f, 0xf1, 0x32, 0x01, 0x63,
      0x99, 0xbb, 0x0c, 0xde, 0x7a, 0x71, 0x9b, 0xc1, 0x72, 0x9d, 0xf1, 0xb1,
      0xb3, 0xe6, 0xe4, 0xdc, 0x1a, 0xc0, 0x22, 0x46, 0xbd, 0xa3, 0xde, 0x9e,
      0xcd, 0x89, 0xac, 0x14, 0xf4, 0x94, 0x8d, 0xa2, 0x98, 0xda, 0x77, 0xe1,
      0x42, 0x58, 0x6a, 0xc0, 0xd4, 0x88, 0x54, 0xb4, 0xd1, 0xec, 0xa3, 0x6a,
      0x18, 0xaf, 0x52, 0x21, 0xce, 0x51, 0x78, 0x9a, 0xcb, 0xf7, 0x72, 0xc0,
      0x6e, 0x43, 0x60, 0x09, 0xa3, 0xb8, 0x85, 0x40, 0xe5, 0x93, 0xd4, 0x27,
      0x1b, 0xab, 0xce, 0x1e, 0xcf, 0xd1, 0x49, 0xfa, 0x53, 0x67, 0x33, 0x8e,
      0x82, 0xff, 0x3b, 0x89, 0x83, 0xc8, 0xaf, 0x02, 0xdf, 0x99, 0xe3, 0x70,
      0x39, 0xa7, 0xd0, 0x3f, 0x11, 0x3d, 0xff, 0x04, 0x3f, 0x59, 0x8e, 0x3d,
      0x68, 0xf3, 0x08, 0x3e, 0xc3, 0xcd, 0x54, 0x5a, 0x52, 0xa0, 0x76, 0x48,
      0x7f, 0x7f, 0xf9, 0x3c, 0x01, 0x65, 0x38, 0xdd, 0x6f, 0xb9, 0xf9, 0x47,
      0xe8, 0x7d, 0xa7, 0x16},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: s_len changed to 0
    // tcID: 46
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     46,
     20,
     {0x0d, 0xd1, 0x6c, 0x3c, 0xcc, 0x10, 0xb2, 0x80, 0xbc, 0x36, 0xc0, 0x10,
      0x4e, 0x7c, 0x5f, 0xe4, 0x71, 0x07, 0xc1, 0xba, 0x51, 0x1d, 0x19, 0x73,
      0x57, 0xaa, 0x7a, 0x53, 0x7e, 0x90, 0xf0, 0x79, 0xa0, 0x03, 0x85, 0x74,
      0x4a, 0x85, 0xa0, 0x70, 0x80, 0x4e, 0x91, 0x34, 0xa7, 0x5f, 0xa7, 0x3b,
      0xf1, 0xc0, 0x53, 0x16, 0x2e, 0xd2, 0xe6, 0x22, 0xef, 0x1d, 0x3a, 0x1b,
      0x9f, 0x11, 0x7c, 0x47, 0xa7, 0xb6, 0x8f, 0x9e, 0x10, 0x00, 0xbf, 0x85,
      0x15, 0x70, 0x98, 0x7f, 0xbb, 0x9f, 0x8b, 0x5f, 0xd2, 0xbf, 0xc0, 0x58,
      0xf9, 0x5f, 0x2b, 0xd1, 0x2c, 0xa9, 0x77, 0xe4, 0x4f, 0x59, 0x6d, 0xf0,
      0xa1, 0xc4, 0x8d, 0xe9, 0xd0, 0xc8, 0x40, 0x73, 0x2d, 0x94, 0xac, 0x2f,
      0x11, 0x15, 0x6c, 0x9e, 0x73, 0x9d, 0xe8, 0xdf, 0x89, 0x31, 0xef, 0xae,
      0x8a, 0xa4, 0x2c, 0xd6, 0x25, 0x4b, 0x3f, 0xbe, 0x14, 0x05, 0x31, 0x3e,
      0x8b, 0x19, 0xca, 0x86, 0x04, 0x5e, 0xdf, 0x87, 0x63, 0x1b, 0xd2, 0x19,
      0xf6, 0x92, 0x3b, 0x8d, 0xfd, 0x78, 0x3a, 0xc9, 0xe7, 0xc9, 0x13, 0xcf,
      0x73, 0x48, 0xc7, 0xb5, 0x02, 0x8b, 0x47, 0x88, 0x98, 0xa3, 0x66, 0xb8,
      0x93, 0x93, 0x8a, 0x94, 0xd2, 0xfe, 0xa9, 0x2e, 0x78, 0x00, 0x1a, 0xe2,
      0xba, 0xaf, 0x5d, 0xc0, 0xc3, 0x1e, 0x9b, 0x0d, 0x46, 0x19, 0xe0, 0xfd,
      0xe4, 0x54, 0x14, 0xb0, 0xc5, 0x86, 0x3c, 0x88, 0x26, 0x40, 0x6d, 0x87,
      0xb4, 0x8f, 0xbe, 0x0c, 0x52, 0x16, 0x4d, 0x0a, 0x8d, 0x1f, 0xd0, 0x0b,
      0x88, 0x3d, 0xda, 0xe8, 0xe1, 0x23, 0x5c, 0x84, 0x6d, 0x51, 0xe5, 0xcb,
      0x20, 0xd7, 0x24, 0x57, 0x6d, 0xfd, 0xfa, 0x01, 0xd1, 0x5f, 0x47, 0xcb,
      0xac, 0x56, 0xb1, 0x75, 0x43, 0xfc, 0xdf, 0xe8, 0x1d, 0xd7, 0x0d, 0xca,
      0x54, 0x5f, 0xfd, 0xd0},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: s_len changed to 32
    // tcID: 47
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     47,
     20,
     {0x18, 0xbd, 0x76, 0x41, 0x74, 0x87, 0x32, 0x63, 0x34, 0x17, 0x71, 0xa7,
      0x83, 0x53, 0x49, 0x21, 0xcc, 0xc5, 0xf3, 0x39, 0x5c, 0xa9, 0x6a, 0x3a,
      0x57, 0x70, 0x6b, 0xab, 0x1f, 0x78, 0x90, 0x5c, 0x00, 0x2f, 0x3c, 0xd6,
      0xe1, 0x79, 0x1e, 0x23, 0x8a, 0x8b, 0xa6, 0xb9, 0xfd, 0xdd, 0x74, 0xd4,
      0xe7, 0x58, 0x52, 0x7b, 0xc3, 0xce, 0x76, 0xa2, 0xd9, 0xb3, 0x7e, 0x13,
      0x0b, 0xcc, 0xb8, 0xe2, 0x35, 0xf8, 0x38, 0x8e, 0x54, 0x15, 0x2f, 0x44,
      0x73, 0x46, 0xa5, 0x80, 0xf4, 0x80, 0x8b, 0xcc, 0x17, 0xdf, 0xa5, 0x1c,
      0x69, 0xc2, 0x62, 0x5e, 0xfe, 0xe5, 0x75, 0x31, 0x4b, 0x60, 0x9b, 0x8e,
      0x30, 0xf1, 0xca, 0xf8, 0x22, 0x41, 0x1b, 0xa1, 0xce, 0xcb, 0xb2, 0xc2,
      0x95, 0xc7, 0x66, 0x20, 0xea, 0x1b, 0x64, 0xfa, 0xdb, 0xd4, 0xa8, 0xb5,
      0x2e, 0xa3, 0x98, 0xf6, 0x05, 0x38, 0xf3, 0xa1, 0x9f, 0xc9, 0xc7, 0xc5,
      0xf7, 0xb7, 0xde, 0x80, 0x2e, 0x16, 0xc2, 0x90, 0xd6, 0x35, 0x27, 0x85,
      0x90, 0xbc, 0x36, 0x7b, 0x93, 0x5e, 0xb7, 0x20, 0x95, 0x47, 0xaa, 0x1c,
      0xb3, 0x78, 0xe5, 0x4e, 0x2e, 0x38, 0x3d, 0x8a, 0x2c, 0x67, 0xa6, 0x9e,
      0x79, 0x0f, 0xca, 0xb5, 0x40, 0xa5, 0x1c, 0xf7, 0x56, 0xc8, 0x6a, 0x5f,
      0xd0, 0xf3, 0x37, 0xb1, 0x42, 0x46, 0xed, 0xa6, 0x5e, 0x9b, 0x8b, 0x85,
      0xe6, 0xeb, 0xe6, 0x2e, 0x89, 0x15, 0x6a, 0x38, 0x7e, 0x9d, 0x1b, 0x72,
      0x06, 0xda, 0x72, 0xc0, 0x82, 0x2d, 0x20, 0xa2, 0x06, 0x37, 0x39, 0x19,
      0x56, 0xd4, 0x73, 0xfe, 0xa4, 0x26, 0x50, 0x5e, 0x6a, 0x54, 0x12, 0x60,
      0xb9, 0x2c, 0xb4, 0xb6, 0x69, 0x80, 0x59, 0x2d, 0xcf, 0x92, 0xbf, 0xa7,
      0x1d, 0x26, 0x4c, 0x57, 0x54, 0x96, 0xdc, 0xc0, 0x98, 0xba, 0xc8, 0x2e,
      0xdd, 0x5c, 0x6d, 0xc1},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: salt is all 0
    // tcID: 48
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     48,
     20,
     {0x60, 0x83, 0xe2, 0x4a, 0xcb, 0xd4, 0x97, 0x3b, 0x8e, 0x28, 0xbd, 0x22,
      0xe9, 0x96, 0x92, 0x42, 0x52, 0xe3, 0x06, 0x02, 0x9c, 0x3d, 0xb5, 0xc5,
      0x35, 0x3f, 0x3e, 0x4c, 0x50, 0x5d, 0x36, 0xf1, 0xfb, 0x7e, 0x58, 0x08,
      0x23, 0xe2, 0x19, 0x64, 0xf9, 0x20, 0x6f, 0xbb, 0x15, 0x84, 0x65, 0xf6,
      0x4b, 0x26, 0x08, 0x9e, 0x1f, 0xd4, 0xb8, 0xbc, 0xb2, 0xab, 0xcc, 0x03,
      0x84, 0x78, 0x1b, 0xb0, 0x05, 0xdb, 0x9c, 0xa7, 0x14, 0x67, 0x66, 0x1c,
      0xc7, 0xe8, 0xe6, 0xa1, 0xc6, 0xb5, 0xdc, 0x8a, 0xe6, 0x46, 0xf0, 0xe6,
      0x80, 0x59, 0x20, 0x01, 0x62, 0x28, 0xf4, 0x00, 0x78, 0x49, 0x06, 0xa2,
      0x33, 0x9f, 0x5e, 0x23, 0x85, 0xcf, 0x29, 0x55, 0x06, 0xc2, 0x23, 0x3b,
      0x66, 0x2a, 0x0e, 0x01, 0x60, 0x91, 0x83, 0x26, 0x11, 0x22, 0xb3, 0x09,
      0xa1, 0x87, 0x4b, 0x34, 0xcc, 0x74, 0x24, 0x2f, 0x36, 0x20, 0xe3, 0xdb,
      0xc6, 0x39, 0xa2, 0x5a, 0x9e, 0x28, 0xc5, 0x4e, 0x4d, 0x3d, 0xb0, 0x8d,
      0x6a, 0x79, 0x3e, 0xc4, 0x68, 0x90, 0x2c, 0xf0, 0xdf, 0xfd, 0xc3, 0xeb,
      0xcb, 0x09, 0x82, 0xae, 0x7a, 0x96, 0x95, 0x1e, 0xbf, 0x5e, 0x76, 0x40,
      0x45, 0x2b, 0xa0, 0xf5, 0x33, 0x22, 0x73, 0xfd, 0x9b, 0xbe, 0x4d, 0xba,
      0x26, 0xe7, 0xeb, 0x10, 0x6c, 0x7e, 0xd1, 0x6c, 0x8b, 0xaa, 0x1f, 0x1d,
      0x7e, 0x5d, 0x16, 0x04, 0x82, 0x74, 0x1e, 0x95, 0x12, 0xb7, 0x8a, 0xa6,
      0x2a, 0x94, 0x2c, 0xab, 0xbb, 0x38, 0x78, 0x9e, 0x7b, 0xb3, 0x80, 0x15,
      0x7b, 0xb4, 0x2e, 0x6a, 0x71, 0xc5, 0x80, 0xdb, 0xa2, 0x54, 0xcb, 0x8f,
      0x59, 0x62, 0x0f, 0x30, 0xac, 0x80, 0x9d, 0x3e, 0xd8, 0x14, 0xc5, 0xee,
      0x0f, 0x31, 0x06, 0xb0, 0x38, 0x06, 0x99, 0x3d, 0x79, 0xde, 0xd9, 0x4a,
      0xb4, 0xc3, 0xb4, 0xd0},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: salt is all 1
    // tcID: 49
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     49,
     20,
     {0x46, 0xdf, 0x0c, 0xd4, 0x9c, 0xa2, 0x1a, 0x0e, 0xe8, 0x4d, 0x8d, 0x8a,
      0x2a, 0x63, 0x2c, 0x3c, 0x3d, 0x41, 0x88, 0x00, 0x87, 0x73, 0xc0, 0x5b,
      0x6e, 0x14, 0x8f, 0x62, 0x9c, 0x62, 0xb9, 0xdb, 0xf3, 0xd8, 0xb1, 0xdf,
      0x5b, 0xfe, 0xbc, 0x16, 0xef, 0xb1, 0x4e, 0x5e, 0xd1, 0x0b, 0xb9, 0xcd,
      0x53, 0xf8, 0x15, 0xec, 0x39, 0x06, 0xa2, 0xb6, 0xe9, 0xcc, 0xcd, 0xe6,
      0x4f, 0x52, 0xc2, 0x3c, 0xdf, 0xd5, 0x60, 0x5f, 0x8c, 0x8c, 0x2f, 0x62,
      0xea, 0xdb, 0x0b, 0x24, 0x45, 0xfa, 0x79, 0xa4, 0xe6, 0x67, 0xcb, 0x63,
      0xb1, 0x0b, 0xb9, 0x18, 0x1e, 0x8e, 0xc1, 0x19, 0x46, 0x05, 0x4d, 0xbd,
      0x13, 0xe9, 0xca, 0x54, 0x5c, 0xd9, 0xda, 0x94, 0x5b, 0xd0, 0x3a, 0xe1,
      0xc4, 0xf8, 0xed, 0x48, 0x55, 0x5d, 0x2e, 0x71, 0xe1, 0xba, 0x8d, 0x41,
      0x0a, 0x72, 0x5f, 0xaf, 0xbe, 0xee, 0x8e, 0xf6, 0x79, 0x8f, 0xef, 0x9d,
      0x3a, 0x9c, 0x6d, 0x48, 0x82, 0x5c, 0x99, 0x6d, 0xa1, 0xf2, 0x21, 0x50,
      0x48, 0x91, 0x6b, 0xdf, 0x96, 0xd2, 0x94, 0xc9, 0x87, 0xca, 0x67, 0x8d,
      0x6b, 0x16, 0x06, 0xae, 0xfa, 0xb2, 0x99, 0x5b, 0x11, 0xee, 0x07, 0x16,
      0x33, 0xeb, 0x1c, 0x48, 0x73, 0xc1, 0x25, 0x2a, 0x38, 0xf3, 0x45, 0x34,
      0x82, 0xcc, 0x72, 0xdd, 0xc9, 0x2f, 0x9f, 0x47, 0x64, 0xad, 0xf4, 0x32,
      0x72, 0x74, 0x11, 0x8d, 0x9a, 0xdb, 0xef, 0x6e, 0x8d, 0xdb, 0xde, 0x84,
      0xad, 0x7c, 0x69, 0x91, 0xf7, 0x15, 0x5a, 0x1f, 0x77, 0xaa, 0xb1, 0xd0,
      0x1f, 0x95, 0x93, 0x1c, 0xf7, 0x3d, 0x61, 0x92, 0x5c, 0x19, 0xd6, 0x60,
      0x40, 0xe0, 0xf7, 0xd8, 0xbf, 0xc6, 0x89, 0x77, 0xdb, 0x94, 0x81, 0x25,
      0xdd, 0x81, 0xa0, 0x28, 0x2b, 0x30, 0xb1, 0x94, 0x2e, 0x05, 0x97, 0xb4,
      0x89, 0xc6, 0xc2, 0xe4},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: byte 0 in zero padding modified
    // tcID: 50
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     50,
     20,
     {0x21, 0xcd, 0x7d, 0x32, 0xc9, 0x13, 0x62, 0xb7, 0x09, 0xbc, 0x62, 0x9d,
      0x9e, 0x04, 0xb2, 0x42, 0x60, 0x4c, 0x32, 0x5c, 0x95, 0x86, 0xdf, 0xf3,
      0xdc, 0x15, 0x2e, 0xfe, 0x3a, 0x05, 0xb1, 0xe2, 0xf1, 0xce, 0x85, 0x26,
      0x5c, 0x94, 0xac, 0xe1, 0xf0, 0xad, 0x3c, 0x50, 0xd3, 0x27, 0xca, 0x58,
      0x2e, 0x4b, 0x99, 0x36, 0x3c, 0x5f, 0xc2, 0xca, 0x40, 0x60, 0x36, 0x76,
      0xc7, 0x74, 0xb3, 0xd7, 0x06, 0xf7, 0xe0, 0xdf, 0xc3, 0x1e, 0x03, 0x06,
      0xf8, 0x83, 0x52, 0x73, 0xfa, 0xcb, 0x8a, 0xa9, 0xc6, 0x50, 0x3b, 0xcf,
      0xf6, 0xaf, 0x47, 0x18, 0x75, 0xf8, 0xa4, 0xbc, 0xb5, 0xb5, 0xb6, 0x40,
      0x5e, 0xc2, 0x2e, 0x7b, 0xca, 0xc9, 0xfb, 0x7f, 0xa2, 0xca, 0x84, 0xcf,
      0xac, 0x60, 0xf1, 0x19, 0x0f, 0x3d, 0xab, 0x9b, 0xa3, 0x4a, 0xb1, 0x30,
      0x4e, 0x07, 0xe2, 0xfa, 0x9a, 0x25, 0xce, 0xa4, 0xc4, 0x59, 0xe7, 0x8e,
      0x05, 0x29, 0x9d, 0xb7, 0x49, 0x7d, 0x43, 0x01, 0xe0, 0x5e, 0xba, 0x53,
      0x8f, 0x78, 0x45, 0xbe, 0xf4, 0x72, 0x0f, 0xed, 0xe2, 0xb5, 0x41, 0x50,
      0x1a, 0x6e, 0xbc, 0xab, 0x62, 0xa0, 0x4a, 0x1f, 0xfd, 0xdd, 0xdd, 0xff,
      0x81, 0x46, 0x51, 0x38, 0x02, 0xfa, 0x49, 0x52, 0x77, 0xce, 0x5f, 0x02,
      0x44, 0x21, 0x37, 0x86, 0xde, 0xa4, 0xd5, 0xa6, 0xd0, 0x2f, 0xcd, 0x93,
      0xcd, 0x41, 0x49, 0x07, 0xc5, 0x57, 0x10, 0x7c, 0xc5, 0x3f, 0xa5, 0xc5,
      0x40, 0x9f, 0x2f, 0xa0, 0xd5, 0x92, 0xcb, 0xa7, 0x92, 0x73, 0xc9, 0xb9,
      0xd4, 0xde, 0xb8, 0xd2, 0x31, 0x98, 0x90, 0x9b, 0x71, 0x21, 0x98, 0xbe,
      0x83, 0xc9, 0x55, 0xa9, 0x15, 0xe5, 0x52, 0x9c, 0x63, 0x4d, 0x83, 0x75,
      0xdc, 0x05, 0x59, 0xd7, 0x2e, 0x30, 0xea, 0x9f, 0x47, 0x54, 0x7f, 0x6d,
      0x2d, 0x52, 0x52, 0x9b},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: byte 7 in zero padding modified
    // tcID: 51
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     51,
     20,
     {0x27, 0x46, 0xd7, 0xd4, 0x8f, 0xf2, 0xf1, 0x73, 0x64, 0xc4, 0x0a, 0x0d,
      0xf2, 0x77, 0x24, 0x26, 0x56, 0xaf, 0x6c, 0xcf, 0xa8, 0x98, 0x02, 0xd6,
      0xc3, 0x1e, 0xc3, 0x23, 0x88, 0x56, 0x1f, 0xbd, 0x26, 0x1c, 0x85, 0xcc,
      0x03, 0xe2, 0x59, 0x9b, 0x84, 0x5e, 0x23, 0xec, 0x90, 0x49, 0x3f, 0x63,
      0x7a, 0x3c, 0x1d, 0x09, 0x0b, 0x26, 0x04, 0xcf, 0x5c, 0x3e, 0xcb, 0xa9,
      0xb0, 0x90, 0x78, 0x56, 0x0e, 0x75, 0x52, 0x35, 0x95, 0x92, 0x39, 0x10,
      0xf6, 0x88, 0xe9, 0x13, 0x37, 0x18, 0x5c, 0x4d, 0x09, 0x78, 0x62, 0x3b,
      0xae, 0x7c, 0x33, 0xd1, 0xc3, 0xb5, 0x0d, 0x83, 0x79, 0x4c, 0x0a, 0x5a,
      0x44, 0xa5, 0x30, 0x9b, 0xa1, 0xd3, 0x9f, 0x3c, 0x5d, 0xc3, 0xb3, 0x16,
      0x61, 0xc8, 0x95, 0xab, 0xa0, 0x48, 0x9c, 0xd3, 0x92, 0x29, 0x01, 0x35,
      0x10, 0x8c, 0xce, 0x56, 0x79, 0x4c, 0xce, 0xa4, 0x91, 0xab, 0x42, 0x4b,
      0xac, 0x44, 0x05, 0xcb, 0x90, 0xa7, 0x2a, 0xb5, 0x30, 0x42, 0xb3, 0xfa,
      0x86, 0x32, 0x22, 0xc4, 0x1d, 0x15, 0x6c, 0xa0, 0xe7, 0x52, 0xf7, 0x33,
      0xeb, 0x58, 0x8b, 0xd9, 0x53, 0x2a, 0xc4, 0x22, 0xbe, 0xef, 0xfa, 0xc4,
      0xc0, 0x1c, 0x37, 0x26, 0x2f, 0x49, 0xfe, 0x7e, 0x3f, 0x9d, 0xff, 0x3f,
      0x99, 0x3e, 0xac, 0x7b, 0x1a, 0xda, 0xf1, 0x53, 0x80, 0x5e, 0x1b, 0x44,
      0xf7, 0x53, 0x9e, 0x04, 0xa3, 0x8c, 0x19, 0x57, 0x97, 0x64, 0xa6, 0xd8,
      0xc0, 0x63, 0x4f, 0xca, 0xb0, 0xcc, 0x22, 0xce, 0x41, 0x05, 0x19, 0x68,
      0xee, 0xeb, 0x44, 0xf1, 0x7f, 0xed, 0x7a, 0xe9, 0x59, 0xd5, 0x19, 0x9e,
      0xe5, 0xe0, 0x89, 0x6a, 0x96, 0x4e, 0xef, 0xce, 0x58, 0x3b, 0x8e, 0x09,
      0x84, 0xf4, 0x1a, 0x26, 0xd0, 0xbd, 0xc3, 0x06, 0xb4, 0x6d, 0x97, 0xb2,
      0x9d, 0x58, 0x7f, 0x88},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes in zero padding modified
    // tcID: 52
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     52,
     20,
     {0x39, 0x61, 0x0e, 0xbb, 0x75, 0x05, 0xfe, 0x88, 0x53, 0xdd, 0x2d, 0x4b,
      0xb0, 0xc3, 0xa3, 0x49, 0x0b, 0x66, 0x94, 0x65, 0xc4, 0xc8, 0x30, 0x80,
      0xd6, 0x43, 0x33, 0x72, 0x09, 0x80, 0x2c, 0x9b, 0x6a, 0x11, 0xe6, 0xc7,
      0x94, 0x81, 0xcb, 0x54, 0x06, 0x16, 0xc7, 0xf8, 0x77, 0xac, 0x58, 0xbb,
      0xa0, 0x8c, 0xf3, 0xf9, 0x3c, 0xcd, 0x6d, 0xea, 0xc0, 0xe8, 0x22, 0x75,
      0x81, 0xaa, 0x73, 0x46, 0x1f, 0xdc, 0xc8, 0x90, 0x82, 0x42, 0x46, 0x8a,
      0x4c, 0x57, 0x11, 0x1c, 0x63, 0x77, 0x12, 0xa1, 0xce, 0x5e, 0xae, 0x6b,
      0xdb, 0xbb, 0xde, 0xb0, 0x85, 0xae, 0xcc, 0xb2, 0xcc, 0x24, 0x79, 0xd5,
      0x02, 0x26, 0x0c, 0x1d, 0x1f, 0xf6, 0x37, 0x59, 0xd2, 0x7f, 0x58, 0xec,
      0xdf, 0x87, 0xfe, 0xcf, 0x5d, 0x23, 0x07, 0x2f, 0x70, 0x9b, 0x5a, 0xa8,
      0x11, 0xdb, 0xdb, 0x06, 0x7a, 0xa3, 0x94, 0xc2, 0x72, 0xc2, 0x70, 0xbd,
      0x8e, 0xd1, 0xc9, 0xd0, 0x49, 0x1f, 0xcc, 0xad, 0x73, 0xb7, 0x4a, 0x4b,
      0x46, 0xe2, 0xf8, 0xfe, 0xc3, 0xe2, 0x42, 0x76, 0x61, 0x36, 0x0c, 0x41,
      0xbe, 0x30, 0x60, 0x15, 0xe4, 0x33, 0x64, 0xbb, 0x45, 0x9a, 0x8c, 0x3c,
      0xd1, 0x79, 0x7f, 0xc4, 0xa8, 0x9b, 0xe3, 0xa5, 0x20, 0x39, 0x63, 0x20,
      0x42, 0x7f, 0x12, 0xde, 0x28, 0xd3, 0x00, 0x1a, 0xe2, 0x57, 0xfd, 0x98,
      0xa4, 0xf0, 0xf9, 0x06, 0x78, 0x1a, 0x2f, 0xf6, 0x96, 0xbf, 0x51, 0x34,
      0x6c, 0x92, 0x54, 0x5b, 0xd1, 0x8c, 0x37, 0x16, 0x8d, 0x94, 0x34, 0x80,
      0xad, 0x1e, 0xa9, 0xdc, 0xb4, 0x7a, 0x2c, 0xc6, 0x85, 0x4b, 0xbf, 0x74,
      0x56, 0xf2, 0x05, 0x12, 0x1f, 0x1f, 0x4f, 0x5b, 0xeb, 0x65, 0x19, 0x52,
      0x1a, 0x91, 0x71, 0x1a, 0xa1, 0x57, 0xd2, 0x44, 0x1b, 0x9b, 0xea, 0x9a,
      0x29, 0xcc, 0xba, 0x7c},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of hash h modified
    // tcID: 53
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     53,
     20,
     {0x68, 0x1d, 0x7a, 0xfa, 0xca, 0xdf, 0x19, 0xda, 0xb9, 0x25, 0x2f, 0xbc,
      0x35, 0xba, 0x86, 0xa8, 0xd3, 0x4f, 0x47, 0x86, 0x75, 0x92, 0x51, 0xa9,
      0x1d, 0xba, 0x18, 0x87, 0x2a, 0x07, 0x0a, 0xf3, 0x9e, 0x5b, 0x3e, 0x9a,
      0x12, 0x88, 0x6b, 0x63, 0x88, 0xcc, 0x59, 0xd2, 0xf8, 0x3b, 0xf1, 0x9a,
      0x09, 0xd1, 0xcf, 0x6c, 0xdf, 0x32, 0xf0, 0xf5, 0x7c, 0xb7, 0x0a, 0xe8,
      0xdf, 0x8d, 0x62, 0x3b, 0xc7, 0xc2, 0xa4, 0x5a, 0x34, 0x4b, 0x02, 0x48,
      0x2c, 0xdd, 0x02, 0x6b, 0x42, 0x07, 0x73, 0x5b, 0xae, 0x60, 0x89, 0x83,
      0x1c, 0x8e, 0xf3, 0xd9, 0x74, 0x28, 0x28, 0x8e, 0x36, 0x3b, 0xdf, 0xcf,
      0x6d, 0x31, 0x3f, 0xed, 0xe6, 0x72, 0x82, 0x40, 0xaf, 0x8f, 0x06, 0x9f,
      0x9b, 0x6d, 0x7b, 0x57, 0xe0, 0x29, 0xaa, 0xb5, 0xb9, 0x2e, 0x3d, 0xd3,
      0x62, 0x7f, 0x1d, 0x1a, 0x9a, 0x24, 0x2d, 0xe3, 0xe1, 0x4a, 0x4c, 0xf5,
      0x02, 0x5f, 0x9a, 0x3b, 0xa2, 0xdd, 0xda, 0x23, 0x08, 0x0f, 0x3d, 0x25,
      0x0d, 0xb3, 0x20, 0xc3, 0x54, 0x15, 0x8c, 0x2a, 0x7e, 0x53, 0x0e, 0xa7,
      0x7e, 0xf3, 0x85, 0x83, 0xba, 0x1d, 0x3b, 0xb2, 0x14, 0x1b, 0x05, 0x3c,
      0x94, 0x66, 0xc0, 0x43, 0xe4, 0xcc, 0x26, 0x12, 0x56, 0xba, 0xdd, 0xf5,
      0x7b, 0xed, 0x45, 0xc9, 0xa4, 0x91, 0xb4, 0x9f, 0x56, 0xd3, 0x58, 0x4a,
      0x3d, 0x6b, 0x0d, 0xf5, 0x84, 0x34, 0x08, 0xb0, 0x28, 0x7b, 0x85, 0x0e,
      0x88, 0xc4, 0x31, 0x40, 0xfa, 0x32, 0xcf, 0xe5, 0xda, 0x29, 0xd0, 0x6e,
      0xe0, 0x51, 0xbb, 0x0b, 0x00, 0x13, 0xfa, 0x6c, 0x5b, 0x6e, 0xf6, 0xea,
      0x02, 0x5d, 0x10, 0x6f, 0x8b, 0xe8, 0x16, 0x6a, 0x92, 0x14, 0xe1, 0xf7,
      0x7c, 0xb1, 0x9e, 0x98, 0x52, 0x98, 0xe6, 0xd7, 0x1d, 0x8c, 0x00, 0xb9,
      0x20, 0xae, 0x29, 0x8c},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of hash h modified
    // tcID: 54
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     54,
     20,
     {0x02, 0xea, 0xe2, 0x70, 0x38, 0x79, 0x52, 0x2f, 0x66, 0x60, 0x22, 0x1d,
      0xc9, 0x8a, 0x84, 0xa1, 0xa5, 0xbf, 0x69, 0xd2, 0x19, 0x88, 0x64, 0xda,
      0x83, 0xa6, 0x33, 0xd0, 0xee, 0xf5, 0x6d, 0x83, 0x95, 0x06, 0x45, 0xff,
      0x98, 0x78, 0xbf, 0x12, 0x61, 0x8e, 0xc8, 0xcf, 0xf8, 0x26, 0xc6, 0xe3,
      0xd9, 0x55, 0xd8, 0x2b, 0xc7, 0xf6, 0xd1, 0x0a, 0xc2, 0x07, 0x46, 0x7c,
      0x37, 0x3d, 0x7c, 0x7c, 0xe8, 0xd6, 0xdb, 0x7e, 0xb9, 0xe9, 0x66, 0xde,
      0xd3, 0xc7, 0x8a, 0x89, 0xab, 0xae, 0x18, 0x0e, 0xb1, 0x26, 0x2b, 0x80,
      0xa9, 0x76, 0xb3, 0x2d, 0x77, 0x64, 0x2f, 0x39, 0xeb, 0xc4, 0x38, 0x8d,
      0x28, 0x44, 0xad, 0x24, 0x14, 0xba, 0x6a, 0x0a, 0xf1, 0xb2, 0x63, 0xbf,
      0xb4, 0x4f, 0x16, 0xf6, 0xd3, 0xbd, 0xf4, 0x44, 0x17, 0xac, 0x31, 0x18,
      0x2a, 0x84, 0x0c, 0x83, 0x84, 0x8f, 0x1e, 0x60, 0xb3, 0x65, 0x25, 0xb0,
      0x13, 0x5b, 0xca, 0x97, 0x18, 0xb9, 0xc6, 0xe8, 0xc0, 0x6a, 0xd3, 0xc6,
      0x2e, 0xb0, 0x7e, 0xb0, 0xf7, 0xc5, 0x27, 0x93, 0xa3, 0x88, 0xed, 0xab,
      0x9b, 0x3e, 0x37, 0xea, 0xd9, 0x29, 0xba, 0xbb, 0x8a, 0x86, 0x66, 0x45,
      0x75, 0x1d, 0xed, 0x5d, 0x33, 0x1e, 0xfd, 0xe2, 0xd8, 0x36, 0x31, 0x79,
      0x18, 0x8b, 0xd1, 0x4a, 0xd3, 0x23, 0xdc, 0x0f, 0x9d, 0x34, 0x3c, 0x4c,
      0x3d, 0x07, 0xc2, 0x0a, 0x5e, 0xd6, 0xad, 0x02, 0x10, 0x2d, 0x3c, 0x80,
      0x4f, 0xce, 0xfb, 0xd4, 0x3e, 0x84, 0x8d, 0x2a, 0xca, 0xa6, 0x32, 0xec,
      0xa2, 0xe7, 0x2d, 0xcb, 0xd2, 0x20, 0x0b, 0x5b, 0x59, 0x58, 0x68, 0xef,
      0x1a, 0x11, 0x53, 0x36, 0xf7, 0x54, 0xa1, 0x64, 0x29, 0x2c, 0x7b, 0x46,
      0x5e, 0x9d, 0x07, 0xed, 0x64, 0xf0, 0x39, 0x7c, 0xf3, 0x66, 0x4f, 0xd6,
      0xf8, 0x7e, 0x0c, 0x1e},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of hash h modified
    // tcID: 55
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     55,
     20,
     {0x6b, 0x8d, 0xc3, 0x66, 0xea, 0xe1, 0x34, 0x8b, 0x77, 0x00, 0x19, 0xd1,
      0xa2, 0xd2, 0xa3, 0xa0, 0x75, 0xed, 0xa3, 0x6f, 0x99, 0xc1, 0x20, 0x29,
      0x02, 0xbf, 0x44, 0xc5, 0x0b, 0x3e, 0xc8, 0xe7, 0x5c, 0x04, 0x15, 0xee,
      0xbd, 0xc6, 0x1d, 0x70, 0xf3, 0x7c, 0x82, 0x80, 0xb5, 0xae, 0x6b, 0x2e,
      0x03, 0xdd, 0xd0, 0xb1, 0xf1, 0x5c, 0x69, 0x44, 0xcd, 0xe9, 0x43, 0x3b,
      0x08, 0x37, 0x26, 0x5b, 0x8c, 0xd6, 0x58, 0xf2, 0x10, 0x29, 0xb0, 0x91,
      0x83, 0x2e, 0xe2, 0x8c, 0x50, 0x47, 0xdb, 0x21, 0xde, 0x40, 0x29, 0xb0,
      0xee, 0x17, 0x36, 0x9f, 0x99, 0xdb, 0xfc, 0xc2, 0xa4, 0xad, 0x42, 0xdc,
      0xc5, 0x8e, 0x21, 0x06, 0x73, 0x15, 0x4b, 0x4f, 0xa1, 0x47, 0x4d, 0xbd,
      0x68, 0x4f, 0x9c, 0x76, 0x39, 0xc0, 0x85, 0x6d, 0x93, 0x6c, 0x8b, 0x7f,
      0xdc, 0x43, 0x7b, 0xec, 0x8d, 0x6f, 0x87, 0x54, 0xcd, 0x95, 0x77, 0x63,
      0x9b, 0x14, 0x41, 0x3a, 0xb7, 0xb3, 0x0e, 0xd2, 0x36, 0x44, 0x05, 0x16,
      0x83, 0x7f, 0x82, 0x0a, 0x0b, 0x0e, 0x14, 0x6c, 0x48, 0x70, 0x6d, 0x53,
      0x4b, 0xf0, 0x38, 0x41, 0xf3, 0xc0, 0x17, 0x2b, 0xd6, 0x98, 0xeb, 0x83,
      0x56, 0x33, 0x2d, 0x25, 0x65, 0xdb, 0xeb, 0x51, 0x43, 0xa8, 0x22, 0xa0,
      0xa4, 0xb9, 0x78, 0x18, 0x26, 0x18, 0x91, 0x3e, 0x64, 0xfa, 0xa7, 0x1a,
      0x15, 0xd4, 0x54, 0xbc, 0x05, 0xac, 0xcb, 0x74, 0xd1, 0x33, 0x8a, 0x4e,
      0x66, 0xea, 0x77, 0xe6, 0x90, 0xa6, 0x23, 0x8c, 0x90, 0xb8, 0x4a, 0x52,
      0x61, 0xb1, 0x7c, 0x6d, 0x2f, 0xe9, 0x47, 0xc3, 0x7b, 0xbb, 0xae, 0x99,
      0xae, 0xa0, 0x74, 0x2f, 0x65, 0x59, 0xd6, 0x17, 0x7a, 0x27, 0x2d, 0xb4,
      0xd5, 0x10, 0x47, 0xa2, 0x06, 0xb8, 0x04, 0xa5, 0x90, 0xed, 0xad, 0x0f,
      0x7a, 0xf7, 0xc0, 0x78},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of hash h modified
    // tcID: 56
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     56,
     20,
     {0x96, 0xa0, 0x51, 0x98, 0x0a, 0x5d, 0xb7, 0x7b, 0x94, 0xa7, 0xad, 0xc3,
      0x2f, 0x73, 0x97, 0x3d, 0xcf, 0xcd, 0x62, 0xe9, 0x5b, 0x0e, 0x0d, 0x2e,
      0x08, 0x44, 0x10, 0xc3, 0x7f, 0x65, 0xb5, 0x0d, 0x01, 0x8e, 0x99, 0x46,
      0x33, 0x4f, 0xa5, 0xd2, 0x68, 0xa6, 0x84, 0x8d, 0xc1, 0x64, 0xdb, 0x1d,
      0x01, 0x2c, 0x5d, 0x42, 0xda, 0x61, 0x3d, 0x9d, 0x16, 0x7d, 0xc1, 0x37,
      0x23, 0xb3, 0x34, 0xac, 0xfb, 0xb4, 0x72, 0xd3, 0x20, 0x27, 0xee, 0x6b,
      0x52, 0x90, 0x3f, 0xb8, 0xfc, 0x07, 0xc1, 0xa8, 0xca, 0x31, 0x15, 0x6f,
      0xd7, 0x35, 0x68, 0xd3, 0xa1, 0xd9, 0x33, 0xd1, 0x44, 0xd0, 0xf2, 0x63,
      0xa2, 0xad, 0xae, 0x75, 0x1e, 0x8d, 0x4f, 0xb5, 0xb9, 0x49, 0xad, 0xb3,
      0x40, 0x75, 0xa6, 0xfa, 0x59, 0xdd, 0xfc, 0xc4, 0x93, 0x99, 0xf9, 0xd0,
      0x1d, 0xc8, 0xd8, 0x73, 0x3b, 0xe4, 0x7f, 0x2e, 0xcf, 0xb3, 0x96, 0xa3,
      0xcf, 0xe4, 0x0d, 0x61, 0x9b, 0xe4, 0x43, 0x67, 0x67, 0xf7, 0x6d, 0x00,
      0x89, 0xb8, 0x45, 0xf4, 0xa2, 0x65, 0xa5, 0xff, 0xba, 0xcb, 0x69, 0xdf,
      0xca, 0xa6, 0x8d, 0xe6, 0xb3, 0x4b, 0x6c, 0x5b, 0x14, 0x33, 0xe1, 0x49,
      0xb3, 0xbd, 0xca, 0x5b, 0xc7, 0x2b, 0x98, 0x61, 0x77, 0x57, 0xa1, 0x24,
      0x2b, 0x46, 0xf1, 0xfd, 0x0d, 0x7d, 0x0a, 0x7a, 0xf7, 0x5a, 0xdb, 0x95,
      0x04, 0x33, 0xe1, 0xb7, 0x58, 0x4f, 0xa2, 0xde, 0x51, 0xb9, 0x32, 0x31,
      0xdd, 0x73, 0x51, 0x2c, 0xee, 0x72, 0x8a, 0x3e, 0x6f, 0x7c, 0xb9, 0x51,
      0x77, 0x07, 0x2d, 0xcf, 0xd2, 0x53, 0x62, 0xda, 0x53, 0x7f, 0xd4, 0x13,
      0x48, 0x87, 0xab, 0x1b, 0x53, 0x69, 0x79, 0xf3, 0x96, 0x9a, 0x02, 0xcd,
      0xc2, 0xf3, 0x69, 0x9e, 0x39, 0x4b, 0x00, 0x1a, 0xb2, 0x27, 0xdf, 0x7d,
      0xaa, 0x17, 0x5b, 0x75},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes of h replaced by 0
    // tcID: 57
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     57,
     20,
     {0x5b, 0xac, 0x31, 0x03, 0x06, 0x2a, 0x57, 0x26, 0xa5, 0x78, 0x76, 0xfa,
      0xbc, 0xe9, 0xd1, 0x13, 0xf9, 0x81, 0x6f, 0x30, 0xf0, 0x33, 0x0a, 0xc8,
      0xbf, 0x07, 0x97, 0xeb, 0xd4, 0x1c, 0x53, 0x26, 0xea, 0x69, 0x3e, 0xd7,
      0xa3, 0xdb, 0x0a, 0xf2, 0x51, 0xef, 0x26, 0x8f, 0xa9, 0x5e, 0xe1, 0x16,
      0x5e, 0xe3, 0xd5, 0xfb, 0xa2, 0x63, 0x0f, 0xa7, 0x5c, 0x34, 0x6a, 0xe4,
      0x22, 0xc3, 0xd1, 0x4d, 0x25, 0xe1, 0x6e, 0xb1, 0xc3, 0xb7, 0x62, 0xd9,
      0xac, 0xe3, 0x79, 0xad, 0x50, 0x06, 0xe8, 0x56, 0x8b, 0x2b, 0x49, 0x4c,
      0x7c, 0xbb, 0x90, 0xfb, 0x75, 0x89, 0xb6, 0x07, 0xda, 0x24, 0xcb, 0x8c,
      0xd6, 0xa4, 0xd8, 0x51, 0xca, 0x4b, 0xc6, 0x74, 0x18, 0x19, 0xdd, 0xf9,
      0xac, 0xb7, 0xb3, 0xcb, 0x50, 0xcd, 0x43, 0x56, 0xb6, 0x34, 0xad, 0x27,
      0x78, 0x44, 0x61, 0x46, 0xb4, 0x91, 0x2b, 0x9d, 0xa4, 0x30, 0x92, 0x1b,
      0xff, 0x3a, 0x8c, 0xc7, 0xe3, 0x30, 0xe8, 0x2a, 0x38, 0xbd, 0x9f, 0x69,
      0xea, 0xf4, 0x78, 0x59, 0xb5, 0x19, 0x9c, 0xce, 0xea, 0x0b, 0x9d, 0x11,
      0x1d, 0xbd, 0xe5, 0xe2, 0x0a, 0x84, 0x51, 0xfd, 0x98, 0x96, 0x85, 0x98,
      0x61, 0x72, 0xe4, 0xf6, 0x9b, 0xa2, 0x98, 0x3c, 0x30, 0x1c, 0x51, 0xe5,
      0x7d, 0xdc, 0x45, 0x7a, 0xf8, 0xfe, 0xac, 0x97, 0x09, 0xd8, 0x4d, 0x9b,
      0x3c, 0x70, 0xfb, 0xba, 0x42, 0x3a, 0xbb, 0xa4, 0xcc, 0xa6, 0xea, 0xb1,
      0xff, 0xf4, 0x2a, 0xcd, 0xee, 0xc5, 0xec, 0x89, 0x93, 0x6c, 0x4e, 0xa8,
      0xf8, 0x37, 0xb0, 0x1e, 0xff, 0x95, 0x4d, 0x13, 0xfb, 0xcf, 0xe8, 0x73,
      0x1a, 0x6c, 0x7c, 0xc9, 0x27, 0x1a, 0x80, 0x5a, 0x98, 0xb8, 0x87, 0x7f,
      0x36, 0x43, 0x35, 0xea, 0x23, 0x90, 0x03, 0xcc, 0x62, 0x59, 0xae, 0xbb,
      0x92, 0x2d, 0x2f, 0x97},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bits of h replaced by 1s
    // tcID: 58
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     58,
     20,
     {0x1e, 0x10, 0x8d, 0xdf, 0x1d, 0x6d, 0x93, 0x1d, 0xd5, 0x68, 0xfc, 0xde,
      0x1e, 0x11, 0x97, 0x1d, 0xcd, 0x86, 0xb4, 0x09, 0x69, 0x99, 0x09, 0xd4,
      0xc2, 0x68, 0x9a, 0xc1, 0x7f, 0xcf, 0x0c, 0xde, 0x9b, 0xc2, 0x7d, 0x10,
      0xf9, 0xf2, 0x87, 0x01, 0x13, 0xcc, 0x61, 0xf9, 0x98, 0x3d, 0x1e, 0xc5,
      0xe4, 0xb1, 0xb5, 0xf8, 0xad, 0x0e, 0x48, 0x8a, 0x99, 0x1f, 0x14, 0x55,
      0xc5, 0xad, 0x4f, 0x72, 0x10, 0x56, 0xe5, 0x4d, 0x11, 0xb7, 0x7d, 0xc7,
      0xba, 0x73, 0xbd, 0x3c, 0xaa, 0xeb, 0x89, 0xc2, 0x11, 0x41, 0xf0, 0x01,
      0x05, 0x01, 0xc9, 0xf7, 0x2a, 0x3f, 0xcd, 0x4d, 0x7e, 0x7e, 0x59, 0xf7,
      0x01, 0xdf, 0x03, 0x2f, 0xa3, 0x92, 0xbf, 0x82, 0xa1, 0xde, 0x9f, 0xf9,
      0xf6, 0xc1, 0x5e, 0xf2, 0xb0, 0xa5, 0x42, 0x01, 0xf7, 0x87, 0xbd, 0x87,
      0xba, 0x4f, 0xc9, 0x69, 0x60, 0x65, 0xe5, 0xdb, 0x96, 0xca, 0xe4, 0xb6,
      0x1f, 0x66, 0x29, 0x43, 0x96, 0xee, 0xea, 0x94, 0xc1, 0xc0, 0xac, 0x10,
      0xdd, 0x8f, 0x1c, 0xae, 0x92, 0x8c, 0x7b, 0x7f, 0xfa, 0x84, 0xa8, 0x66,
      0xd6, 0x9d, 0x45, 0x0f, 0x07, 0x2f, 0x74, 0x6a, 0x4a, 0xf2, 0x0d, 0x4b,
      0x39, 0xd2, 0x6c, 0xbe, 0xe4, 0x3b, 0x22, 0x7e, 0x96, 0xc4, 0xef, 0x5e,
      0xde, 0x5a, 0xa0, 0x43, 0xd5, 0x1c, 0x6a, 0x5e, 0x94, 0xc8, 0xa5, 0x97,
      0x58, 0xf9, 0xb4, 0x21, 0x33, 0xcf, 0xf0, 0xb0, 0x1c, 0x36, 0x5f, 0xed,
      0x57, 0xd1, 0x89, 0x10, 0x6c, 0x4e, 0x38, 0xcc, 0x73, 0xef, 0xe7, 0x16,
      0x5a, 0xaa, 0x76, 0xb2, 0xa2, 0xfb, 0x0a, 0x2c, 0x41, 0x53, 0x66, 0x73,
      0x23, 0x4c, 0x41, 0x16, 0xa7, 0x44, 0x5d, 0xd9, 0xfc, 0x93, 0xe0, 0xf2,
      0x7e, 0xab, 0x8e, 0x5d, 0x4c, 0x19, 0xa7, 0x12, 0xe0, 0x98, 0x40, 0x15,
      0x1e, 0x44, 0x05, 0x3f},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bits in hash h flipped
    // tcID: 59
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     59,
     20,
     {0x48, 0x77, 0x08, 0x5b, 0xc4, 0x5b, 0x4e, 0x53, 0x8a, 0x2f, 0x25, 0x75,
      0x5c, 0xa4, 0x10, 0x03, 0x2a, 0x01, 0xaf, 0x46, 0x05, 0x23, 0xbe, 0xa0,
      0xee, 0x1d, 0xa7, 0x67, 0xd7, 0x36, 0x88, 0xad, 0xf0, 0x9d, 0x8b, 0x30,
      0x0c, 0x50, 0x00, 0xd7, 0x44, 0x56, 0xa5, 0x58, 0x06, 0xdc, 0xfa, 0x1e,
      0x1b, 0x1c, 0x78, 0x7a, 0x69, 0xff, 0xf2, 0x95, 0x21, 0x57, 0x72, 0x17,
      0x36, 0x49, 0xfb, 0xf9, 0x6c, 0x17, 0xc8, 0x58, 0xd4, 0xbe, 0x9a, 0x7a,
      0xb9, 0xb7, 0xb3, 0x18, 0x92, 0x43, 0xed, 0xb9, 0x97, 0xaf, 0x6a, 0x01,
      0x00, 0xf5, 0x54, 0xe3, 0x68, 0x16, 0x9b, 0x11, 0x5c, 0xf4, 0x4d, 0xd1,
      0xb4, 0x86, 0x65, 0x40, 0x7d, 0xfc, 0xcb, 0x41, 0xed, 0xef, 0xa3, 0x56,
      0xc2, 0x97, 0x31, 0x5f, 0xe5, 0xd3, 0x2a, 0xe9, 0x1e, 0x21, 0x70, 0x5d,
      0x60, 0x02, 0xc4, 0xc6, 0x24, 0xc4, 0xb8, 0x96, 0xdd, 0x60, 0x24, 0x83,
      0x9b, 0x01, 0x13, 0xfc, 0x71, 0x12, 0x90, 0x52, 0x33, 0x0a, 0x30, 0x98,
      0x92, 0xc1, 0x3c, 0xf5, 0xc6, 0x8e, 0xf7, 0x22, 0xd6, 0x37, 0xe9, 0x76,
      0x61, 0x36, 0x6d, 0x40, 0xf8, 0x07, 0x9c, 0x5c, 0x78, 0x98, 0x57, 0x47,
      0x1d, 0x73, 0xfb, 0xa4, 0xf4, 0x68, 0xa6, 0xc2, 0x6c, 0x21, 0xe6, 0x56,
      0x59, 0xb5, 0xfe, 0x28, 0xfe, 0xa0, 0xe3, 0x4f, 0xd4, 0x77, 0x65, 0x11,
      0x9e, 0x41, 0xd3, 0xa1, 0x2a, 0x14, 0x81, 0x81, 0xa7, 0x8f, 0x85, 0xc8,
      0x04, 0x46, 0xe2, 0xde, 0x5b, 0x42, 0xc4, 0x2b, 0x35, 0x4d, 0x71, 0x0a,
      0x4f, 0x62, 0x37, 0xa8, 0x30, 0xa5, 0x9e, 0x79, 0x52, 0x56, 0x0a, 0x8f,
      0xfc, 0xe4, 0x02, 0x84, 0x5c, 0x38, 0xe9, 0xd4, 0xa0, 0x20, 0x2e, 0x3d,
      0x4d, 0x8a, 0x03, 0x52, 0x98, 0xe4, 0xb4, 0x80, 0x25, 0xe0, 0x3e, 0x62,
      0xbc, 0x6c, 0x1f, 0xf0},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: hash of salt missing
    // tcID: 60
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     60,
     20,
     {0x49, 0x62, 0x6b, 0xd9, 0x83, 0x77, 0xf1, 0xd2, 0xe5, 0x71, 0xa9, 0xd9,
      0x19, 0x3b, 0xcd, 0xe1, 0xc2, 0x9a, 0xff, 0xe1, 0x78, 0x06, 0x55, 0x49,
      0x91, 0x68, 0x0b, 0xea, 0xbe, 0xf4, 0x01, 0x2c, 0x73, 0xfd, 0xcc, 0xd5,
      0x85, 0x4b, 0x7d, 0xd6, 0x5a, 0x3a, 0xff, 0x86, 0x86, 0x88, 0xb6, 0xd4,
      0x55, 0x3f, 0x79, 0xea, 0x5f, 0xe9, 0xf0, 0x4d, 0x3f, 0x6a, 0xfa, 0xef,
      0x95, 0x66, 0x55, 0x02, 0x25, 0x4b, 0x15, 0x28, 0xdd, 0x35, 0xe1, 0x4a,
      0x0d, 0x33, 0xe7, 0x10, 0x42, 0x10, 0xca, 0x91, 0x39, 0x7a, 0xc7, 0x66,
      0xbc, 0x7f, 0xde, 0x1a, 0x03, 0x0b, 0x6e, 0x2d, 0x38, 0xad, 0x4d, 0x69,
      0xd0, 0x55, 0x57, 0x46, 0x46, 0x02, 0xc0, 0x40, 0x88, 0x8f, 0xb6, 0xf1,
      0x5f, 0x46, 0x5a, 0x61, 0x27, 0x6e, 0x67, 0x30, 0xbb, 0x31, 0x06, 0x90,
      0x8f, 0x60, 0xe4, 0x31, 0xaf, 0xa8, 0xc1, 0x12, 0x7c, 0x82, 0xb0, 0xf2,
      0x3d, 0xde, 0xe4, 0x10, 0xe3, 0xc5, 0xe7, 0x36, 0x91, 0xfb, 0x6d, 0x76,
      0xf2, 0xb6, 0x40, 0x53, 0x48, 0x72, 0x8d, 0x78, 0xa5, 0x20, 0x56, 0x1f,
      0xbb, 0x31, 0x99, 0x29, 0x6d, 0xc8, 0xb7, 0xd4, 0x3e, 0x01, 0x90, 0x16,
      0x1a, 0x28, 0x99, 0x23, 0xa1, 0x17, 0x84, 0x09, 0xb4, 0x38, 0x10, 0xe5,
      0xb7, 0x10, 0xdd, 0x74, 0xba, 0x5d, 0xfa, 0xd6, 0xa9, 0xa3, 0x56, 0x75,
      0xfe, 0xd1, 0x58, 0x47, 0x28, 0xf9, 0xd2, 0x22, 0xe9, 0xb1, 0x15, 0xf8,
      0x39, 0x00, 0xb6, 0xea, 0x83, 0x3e, 0xb2, 0x8b, 0xc8, 0x56, 0xd5, 0xb7,
      0x06, 0xbc, 0xa4, 0x7f, 0xf2, 0xca, 0x21, 0x13, 0xe1, 0xa7, 0xba, 0x96,
      0x9a, 0x0d, 0xe3, 0x31, 0x9d, 0x9f, 0x81, 0x56, 0x70, 0x57, 0x5b, 0x85,
      0xe2, 0x16, 0xdf, 0xf8, 0x88, 0x4c, 0xec, 0x20, 0xb5, 0x6a, 0x3b, 0xf5,
      0x18, 0x36, 0xf2, 0x06},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of ps modified
    // tcID: 61
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     61,
     20,
     {0x7d, 0xf9, 0xad, 0xda, 0x89, 0xf8, 0x3a, 0xbb, 0xdf, 0x0e, 0x34, 0x93,
      0x57, 0x84, 0x61, 0xfb, 0x8e, 0x01, 0xf5, 0x9d, 0xc1, 0x04, 0x6f, 0xd0,
      0x1a, 0xcb, 0x4f, 0x9c, 0x79, 0xa9, 0xa5, 0xf9, 0x5f, 0x7d, 0x73, 0xdc,
      0x0a, 0x9d, 0xff, 0x9a, 0xc4, 0xb0, 0x3b, 0x68, 0x53, 0xa5, 0xe7, 0x88,
      0xda, 0x82, 0x0a, 0x54, 0xe0, 0xdc, 0x71, 0xcd, 0x5f, 0x4c, 0x6e, 0x7e,
      0x19, 0x1e, 0xf9, 0x85, 0xac, 0x99, 0xfe, 0x3b, 0x79, 0xe5, 0x78, 0xdf,
      0x13, 0xdb, 0xa5, 0x21, 0xda, 0x80, 0x82, 0xf7, 0xad, 0xdf, 0x6a, 0xf7,
      0xef, 0x4d, 0xf6, 0x49, 0xfb, 0xae, 0x8c, 0x9d, 0x58, 0xb7, 0x41, 0x9f,
      0x55, 0x1a, 0xd6, 0x7f, 0x06, 0x1e, 0x16, 0x53, 0xd2, 0x6e, 0xcc, 0x41,
      0xf9, 0xdf, 0xf8, 0xde, 0xa2, 0x36, 0x46, 0x2f, 0x0d, 0xa7, 0xbb, 0x34,
      0xbe, 0xa8, 0x90, 0xe2, 0x18, 0x82, 0x43, 0x7d, 0x9f, 0xa8, 0xf6, 0x75,
      0x95, 0x4e, 0x1c, 0x72, 0xa8, 0xae, 0x23, 0x5b, 0xbc, 0xfe, 0xa0, 0xb7,
      0x2a, 0x96, 0x34, 0x35, 0xe7, 0xc6, 0x9d, 0x7c, 0x5b, 0xe8, 0x6f, 0xcd,
      0x79, 0xa5, 0x0e, 0xcb, 0xd5, 0x3e, 0x33, 0xf7, 0xd3, 0xef, 0xf2, 0x68,
      0xee, 0x87, 0xb0, 0xcf, 0x63, 0x4a, 0x7a, 0x9a, 0xb2, 0xfa, 0x35, 0x03,
      0xe8, 0xdf, 0x25, 0x4b, 0xb2, 0xf2, 0x23, 0xc1, 0xd2, 0xa9, 0xda, 0x9c,
      0xab, 0xba, 0xb9, 0x48, 0xab, 0x3b, 0x29, 0xf5, 0x3e, 0x70, 0xcc, 0x7e,
      0xd8, 0x59, 0xe5, 0xc3, 0xc1, 0xc6, 0x6e, 0xe0, 0x2b, 0x24, 0x75, 0xc8,
      0x6c, 0x30, 0xb1, 0x48, 0xc6, 0x40, 0xd6, 0x7d, 0x7d, 0xf0, 0x87, 0x9f,
      0xd1, 0x4b, 0x4a, 0xf9, 0xfa, 0x19, 0xa6, 0x8d, 0x6b, 0xd3, 0xcb, 0x86,
      0x6c, 0x94, 0xdb, 0x16, 0x6e, 0xf1, 0x28, 0x27, 0xb6, 0x74, 0x48, 0xd7,
      0xc3, 0x16, 0xb3, 0x88},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of ps modified
    // tcID: 62
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     62,
     20,
     {0x87, 0xec, 0x6a, 0x8c, 0x3c, 0x3f, 0x5d, 0xb0, 0xd8, 0x56, 0x30, 0xbd,
      0x76, 0xff, 0x0a, 0x99, 0x00, 0x7e, 0xeb, 0x86, 0x75, 0xae, 0x68, 0xf1,
      0x39, 0x4c, 0x25, 0xe1, 0xaf, 0x4f, 0x34, 0x00, 0x51, 0x62, 0x6d, 0x2d,
      0xa4, 0x0d, 0xf6, 0x53, 0xdc, 0xb7, 0x18, 0x94, 0xb4, 0xf2, 0x92, 0xa6,
      0xc0, 0xdc, 0x32, 0x9c, 0x9a, 0xa8, 0xf5, 0x99, 0x41, 0x88, 0x39, 0x89,
      0x00, 0x89, 0x08, 0x1c, 0xa3, 0x91, 0x0f, 0x86, 0x0e, 0x1c, 0xdf, 0xeb,
      0x9a, 0xb1, 0x25, 0x6a, 0x0f, 0x45, 0xff, 0xee, 0xea, 0xc8, 0x61, 0xdc,
      0x64, 0x71, 0xa9, 0x02, 0x37, 0x5d, 0xe4, 0x28, 0x7b, 0x05, 0xcc, 0x59,
      0xd8, 0xcd, 0x5b, 0x84, 0xff, 0x90, 0xe9, 0x51, 0xd0, 0xb0, 0xc5, 0x74,
      0xf3, 0xf3, 0xd6, 0x3a, 0x61, 0x7b, 0xa1, 0xe3, 0xea, 0xe4, 0x1c, 0x93,
      0x1a, 0x27, 0x6a, 0xf8, 0x77, 0x2f, 0xd0, 0xd2, 0x09, 0x7d, 0x4a, 0xcd,
      0x1c, 0xce, 0x8f, 0xd6, 0x2e, 0xa2, 0x95, 0x8d, 0x24, 0x8e, 0xfa, 0x8b,
      0x96, 0xf3, 0xaa, 0x5a, 0xfb, 0xa3, 0x96, 0xb1, 0x7e, 0x29, 0x0e, 0x6a,
      0x99, 0x2e, 0xe4, 0xcd, 0x01, 0x24, 0x81, 0x02, 0x55, 0xd4, 0x44, 0x1e,
      0xb6, 0x79, 0xa4, 0x7c, 0x72, 0x6e, 0xb7, 0x84, 0x20, 0x13, 0x95, 0x40,
      0x2b, 0x4f, 0x14, 0x4f, 0x48, 0xc6, 0xfb, 0x63, 0xac, 0xcd, 0x25, 0xef,
      0xab, 0x39, 0xb6, 0xf5, 0x73, 0x73, 0x28, 0x9b, 0x33, 0x77, 0x4c, 0xc8,
      0xaf, 0x37, 0xcb, 0x2a, 0x4b, 0x43, 0xce, 0xb7, 0x2a, 0x04, 0xfc, 0x80,
      0xf2, 0x75, 0x70, 0x81, 0xea, 0x8f, 0x27, 0xca, 0xea, 0x18, 0x61, 0x29,
      0x68, 0x81, 0xbd, 0x94, 0x8b, 0xd2, 0x44, 0x58, 0x89, 0x2f, 0x5c, 0xdd,
      0x1b, 0xaf, 0xb7, 0x0a, 0xe4, 0x86, 0x98, 0x4a, 0xf8, 0x3c, 0xbe, 0xf4,
      0xfd, 0xfc, 0x0c, 0xc4},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes of ps changed to 0xff
    // tcID: 63
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     63,
     20,
     {0xa8, 0x95, 0x75, 0x5f, 0x24, 0x94, 0xf5, 0xc3, 0x5e, 0x72, 0x03, 0xda,
      0x9d, 0xdc, 0x02, 0x18, 0x0c, 0x77, 0xcb, 0x1b, 0x99, 0x4f, 0x59, 0x02,
      0x0e, 0xc7, 0x2f, 0x51, 0x74, 0xff, 0xa5, 0x9a, 0x71, 0x7a, 0x7e, 0x7d,
      0x0e, 0xd3, 0x8f, 0x86, 0x36, 0x90, 0x7c, 0x9e, 0xb3, 0x48, 0x07, 0xda,
      0x4c, 0x43, 0x36, 0x2f, 0x34, 0x2d, 0x5a, 0xb0, 0x17, 0x9f, 0xdd, 0x26,
      0x88, 0x54, 0x56, 0xcc, 0x69, 0xa4, 0xa5, 0xcf, 0x9e, 0x95, 0xa0, 0xb2,
      0x3c, 0x80, 0x08, 0x29, 0xed, 0xa1, 0x5f, 0xce, 0xee, 0xb3, 0xb4, 0x54,
      0xd5, 0xab, 0x92, 0x0d, 0x00, 0x44, 0xa3, 0xcf, 0xde, 0xcf, 0x4c, 0x43,
      0x4f, 0x28, 0x48, 0x4d, 0x3a, 0xfa, 0x70, 0xa4, 0x88, 0x83, 0x9f, 0xbc,
      0x63, 0xdf, 0x9a, 0x19, 0x1c, 0x3e, 0xe3, 0xb5, 0xdf, 0x05, 0x98, 0xeb,
      0xa1, 0x55, 0xbc, 0x96, 0x23, 0x12, 0x63, 0x3b, 0xab, 0x04, 0xb4, 0x8d,
      0x47, 0x11, 0x0f, 0x19, 0xc9, 0x7f, 0xac, 0xb6, 0xea, 0x3d, 0x38, 0x38,
      0xe1, 0xf4, 0x41, 0x85, 0x1b, 0xcb, 0x06, 0xed, 0x39, 0x5a, 0x1f, 0xc6,
      0xf6, 0x37, 0x0e, 0x06, 0x50, 0x94, 0x93, 0x9d, 0xbd, 0xec, 0x28, 0xfb,
      0x63, 0x96, 0xcb, 0x06, 0x2e, 0xee, 0x52, 0x48, 0x53, 0xf1, 0x51, 0xa1,
      0xd2, 0x20, 0x1e, 0x51, 0xd2, 0xda, 0xa6, 0x68, 0x04, 0x65, 0xed, 0x2c,
      0xef, 0x8d, 0x6c, 0xd3, 0x6a, 0xa4, 0x3f, 0x77, 0x34, 0x75, 0x4b, 0x9f,
      0x49, 0x96, 0x20, 0xd9, 0x56, 0xc2, 0xcd, 0x6f, 0xd0, 0xc2, 0xca, 0x31,
      0x73, 0xfd, 0xad, 0x36, 0x84, 0x36, 0xd8, 0x31, 0x3e, 0x14, 0x80, 0x85,
      0xd2, 0x2c, 0x79, 0x31, 0xfe, 0xe7, 0xff, 0x58, 0xd4, 0xd0, 0x93, 0x34,
      0x81, 0x6c, 0x21, 0x1c, 0x15, 0x32, 0xf1, 0x08, 0x6d, 0xd1, 0x97, 0xbf,
      0xa4, 0xb2, 0xf6, 0x28},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes of ps changed to 0x80
    // tcID: 64
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     64,
     20,
     {0x0a, 0xe8, 0x89, 0x87, 0xb0, 0x01, 0xf5, 0xa5, 0xd5, 0xd7, 0xb2, 0x57,
      0xa5, 0x7f, 0xc2, 0xc3, 0x7f, 0x64, 0x2f, 0x13, 0x67, 0x17, 0x17, 0x1f,
      0xce, 0x28, 0x43, 0x04, 0x95, 0xde, 0xef, 0xb9, 0x40, 0x79, 0x97, 0xb9,
      0xe6, 0x48, 0xb0, 0xaa, 0xef, 0xf5, 0x68, 0xac, 0xb3, 0xe5, 0xb5, 0x3e,
      0x65, 0x7b, 0x41, 0x7e, 0x9c, 0xd8, 0xda, 0x52, 0x79, 0xa5, 0x2c, 0x03,
      0x8d, 0x96, 0x57, 0x43, 0x09, 0x6c, 0x2d, 0x53, 0x3c, 0x25, 0xea, 0x98,
      0xcd, 0x74, 0x7c, 0xa5, 0xd7, 0x19, 0xf4, 0x3c, 0xc2, 0xda, 0xca, 0x42,
      0x6c, 0xf7, 0xbe, 0xe2, 0x05, 0xbf, 0x89, 0xc2, 0x25, 0xa0, 0x81, 0x7d,
      0x59, 0x07, 0x9b, 0x81, 0x62, 0xc6, 0x02, 0x2a, 0xd0, 0x29, 0xd0, 0x94,
      0x6e, 0xb9, 0x9e, 0x8e, 0x44, 0xec, 0x08, 0x98, 0xc9, 0x89, 0x26, 0x14,
      0xc0, 0xc4, 0x89, 0x06, 0xdf, 0x99, 0x21, 0x92, 0x75, 0xa0, 0x4f, 0xc1,
      0xef, 0xe9, 0x2d, 0x5d, 0x6b, 0xf9, 0x8c, 0x90, 0xa5, 0xac, 0x46, 0x9a,
      0x36, 0xf4, 0x7a, 0x0f, 0x23, 0x88, 0x9f, 0xd1, 0x8d, 0xa1, 0xb3, 0x8e,
      0xf1, 0x12, 0xda, 0xfb, 0x69, 0x6f, 0x53, 0x6b, 0xbd, 0x04, 0xe6, 0xc9,
      0x66, 0xa9, 0xba, 0x32, 0x6b, 0xbd, 0x63, 0x8d, 0x82, 0xb6, 0xd7, 0x66,
      0x19, 0x16, 0xb7, 0xbd, 0x7d, 0x3d, 0x4a, 0xc4, 0x26, 0xe9, 0xf0, 0xfd,
      0x52, 0x79, 0x18, 0x50, 0x5a, 0x60, 0x27, 0xb8, 0xdd, 0x71, 0x6a, 0x39,
      0x66, 0xfb, 0x43, 0x9c, 0xc4, 0xa1, 0x30, 0xa1, 0x30, 0x14, 0x23, 0x8c,
      0x5f, 0x10, 0x4d, 0x75, 0x4f, 0xbf, 0xec, 0x2f, 0x1c, 0x78, 0x0b, 0x49,
      0xaa, 0xf8, 0x03, 0x61, 0x8c, 0x2a, 0x8b, 0x69, 0xec, 0x7d, 0x0f, 0x09,
      0x85, 0x5c, 0xb1, 0x01, 0x98, 0x78, 0xf5, 0x2d, 0xf1, 0x3c, 0x44, 0x92,
      0xa4, 0x80, 0xdc, 0xe7},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: ps followed by 0
    // tcID: 65
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     65,
     20,
     {0x3a, 0xb3, 0xc8, 0xcf, 0x8b, 0x99, 0xa2, 0xbf, 0x88, 0x21, 0x53, 0xef,
      0x1a, 0xd6, 0xdb, 0x44, 0x9e, 0x1e, 0xdf, 0x67, 0x3a, 0x01, 0xe0, 0x14,
      0xb4, 0x0d, 0x1a, 0x23, 0xfc, 0xb3, 0x8f, 0xba, 0x21, 0xbd, 0x63, 0xcc,
      0xd9, 0xdf, 0x9a, 0x08, 0x49, 0xd5, 0x9c, 0x41, 0x52, 0x09, 0x46, 0xd4,
      0x6f, 0xd2, 0x6f, 0xed, 0x9e, 0xd4, 0xbd, 0x65, 0xba, 0x0e, 0x00, 0x70,
      0x5c, 0x11, 0x9e, 0xbf, 0xcd, 0xf3, 0x1c, 0xed, 0x34, 0x43, 0x3e, 0xcd,
      0xf9, 0xb4, 0x17, 0x0f, 0x99, 0x90, 0xc2, 0xa2, 0x6c, 0x4a, 0xfd, 0xdd,
      0x28, 0x4b, 0x7e, 0x13, 0x4b, 0x9b, 0xa8, 0xb6, 0xd0, 0xd4, 0x16, 0x24,
      0xa1, 0x69, 0xb8, 0xf4, 0xeb, 0xec, 0x7a, 0x87, 0xd0, 0xde, 0x0e, 0xe7,
      0x87, 0x0c, 0x99, 0xd4, 0xd0, 0x51, 0x46, 0xa7, 0xb7, 0x1c, 0x94, 0x60,
      0x6f, 0xd1, 0x78, 0xaa, 0x65, 0x5c, 0x3e, 0xdb, 0xa0, 0xf7, 0x64, 0xf3,
      0x29, 0x2d, 0x76, 0x21, 0x7d, 0x43, 0x49, 0xf9, 0x0d, 0x09, 0x19, 0xc4,
      0x2c, 0x35, 0xbe, 0x21, 0x61, 0x3f, 0xca, 0xf8, 0x24, 0xe1, 0x6a, 0xb3,
      0xf4, 0x5e, 0xf1, 0x7c, 0x14, 0x25, 0x59, 0x75, 0xcb, 0x85, 0xf7, 0xe1,
      0xf5, 0xdd, 0xbc, 0x01, 0x51, 0xac, 0x49, 0x61, 0xf6, 0x8a, 0x33, 0x1b,
      0x97, 0x73, 0x7b, 0x17, 0x1e, 0x93, 0xc0, 0x1a, 0x0f, 0x46, 0x05, 0xc7,
      0x25, 0x6d, 0xe9, 0x3c, 0xe1, 0xe1, 0xcc, 0x8f, 0x51, 0x75, 0x83, 0x89,
      0x99, 0xc7, 0x34, 0x80, 0x9b, 0xda, 0xf8, 0xb9, 0x5e, 0xdf, 0xac, 0x0d,
      0x5f, 0x98, 0xc3, 0xde, 0x33, 0xad, 0x63, 0x99, 0xe8, 0x20, 0x7a, 0x80,
      0x15, 0x37, 0x3e, 0x1f, 0x5e, 0xd7, 0x6e, 0x30, 0x4b, 0x5e, 0x2a, 0xc2,
      0x60, 0xbb, 0xed, 0x23, 0xc6, 0x62, 0xc3, 0x8b, 0x6f, 0x29, 0xdc, 0xb0,
      0x1f, 0xaa, 0x48, 0x94},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: ps followed by 0xff
    // tcID: 66
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     66,
     20,
     {0x5a, 0x7e, 0x54, 0x9f, 0x99, 0xc1, 0x38, 0xd3, 0xfa, 0x7e, 0xde, 0x3a,
      0xd6, 0x55, 0x47, 0x3f, 0x78, 0xc3, 0xa8, 0xde, 0x65, 0x0b, 0xf8, 0xdb,
      0x6a, 0x51, 0x16, 0xf0, 0x80, 0x7e, 0x5d, 0xf8, 0x44, 0x45, 0xed, 0x72,
      0xea, 0x6a, 0x82, 0xa8, 0x15, 0x0d, 0xb3, 0x52, 0xb8, 0x52, 0x10, 0xe1,
      0x20, 0x81, 0x8d, 0xa1, 0x3d, 0x98, 0x00, 0xd1, 0x58, 0x23, 0xf5, 0x78,
      0x0b, 0x60, 0x51, 0xe5, 0x1b, 0xf4, 0x48, 0x86, 0x54, 0xe6, 0xa9, 0x3c,
      0x95, 0xd1, 0x9b, 0x45, 0x37, 0x87, 0x44, 0x48, 0x3b, 0x43, 0xb3, 0x72,
      0x00, 0xd9, 0x33, 0x77, 0x5d, 0x2f, 0x84, 0xa7, 0x71, 0x9c, 0xdf, 0xf6,
      0xda, 0xe2, 0xe1, 0x57, 0x16, 0xc8, 0x6a, 0x9c, 0x5a, 0x00, 0x42, 0xa5,
      0x26, 0x8c, 0xdc, 0x7b, 0x5e, 0x18, 0x60, 0xc1, 0x50, 0xd8, 0x52, 0x53,
      0x57, 0x37, 0x87, 0xb2, 0x83, 0x9f, 0xed, 0xf6, 0x4d, 0xf3, 0xd5, 0x4c,
      0x97, 0x7f, 0x63, 0xe7, 0xbf, 0xaf, 0x31, 0x68, 0xf0, 0x15, 0x3e, 0x2e,
      0xf0, 0x19, 0x24, 0x4e, 0x5c, 0xdd, 0x9b, 0xe6, 0x9b, 0x42, 0x16, 0x07,
      0xfe, 0xf7, 0x27, 0xbd, 0x54, 0x42, 0xad, 0xa4, 0xba, 0xb8, 0x02, 0xac,
      0x9f, 0xc0, 0xc0, 0x04, 0x4e, 0xb5, 0xb4, 0x35, 0xa9, 0xca, 0xf2, 0x17,
      0x73, 0x2b, 0x67, 0x40, 0x57, 0x1b, 0xf9, 0xf7, 0xb1, 0xb3, 0xfd, 0x83,
      0xda, 0x8d, 0x4c, 0x80, 0x6a, 0x7e, 0x22, 0x41, 0xe3, 0x7c, 0xd0, 0xd0,
      0x6a, 0xba, 0xe2, 0x8a, 0xc5, 0xa8, 0x3a, 0xe3, 0xb2, 0xf8, 0x1f, 0x33,
      0x74, 0xdb, 0xea, 0x97, 0xe4, 0x6c, 0x66, 0xe8, 0x21, 0x22, 0x6f, 0xc7,
      0xcf, 0x0b, 0x0a, 0xf2, 0xdc, 0xbd, 0xb7, 0xc5, 0xcf, 0xf6, 0x41, 0x77,
      0x5c, 0x81, 0xfe, 0xa4, 0xc8, 0xcb, 0x93, 0x09, 0xe9, 0x89, 0xbc, 0xa0,
      0x4a, 0x4a, 0x5d, 0x3d},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: shifted salt
    // tcID: 67
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     67,
     20,
     {0x49, 0x75, 0xc3, 0xfd, 0x63, 0x58, 0x98, 0x99, 0x38, 0x63, 0x3d, 0x07,
      0xcf, 0x7b, 0xf0, 0x12, 0x1c, 0x8a, 0x8c, 0x98, 0x7f, 0xde, 0x1c, 0xac,
      0x40, 0x59, 0x24, 0xab, 0x88, 0xc5, 0xa3, 0x17, 0x5d, 0x27, 0x20, 0x7e,
      0xbb, 0xfe, 0x42, 0xb2, 0x44, 0x04, 0x22, 0x7e, 0x38, 0x8b, 0x11, 0xd9,
      0x2b, 0xbb, 0xac, 0xbb, 0xcf, 0x15, 0x2d, 0x3f, 0xac, 0x01, 0x66, 0xac,
      0xb8, 0x68, 0xf9, 0x08, 0x51, 0x59, 0x03, 0xe3, 0x7d, 0xa9, 0x8e, 0x96,
      0xae, 0xa3, 0x67, 0xc1, 0x79, 0x53, 0x0a, 0x43, 0xf7, 0x8d, 0x87, 0x7c,
      0xf0, 0x83, 0x83, 0x33, 0xfc, 0xea, 0x30, 0x3c, 0xf6, 0x71, 0x0f, 0x04,
      0x65, 0x13, 0xf0, 0x1d, 0x58, 0x6b, 0xc5, 0x4b, 0x42, 0xbf, 0xcf, 0x5d,
      0xd4, 0x7b, 0x1a, 0x01, 0xea, 0x8b, 0x95, 0xaa, 0xfb, 0x4b, 0x94, 0x06,
      0x88, 0x8b, 0x32, 0x66, 0x44, 0x5f, 0x74, 0x9b, 0x1c, 0x56, 0x45, 0x9c,
      0xe4, 0xe1, 0x0a, 0x57, 0xed, 0xc5, 0x9f, 0x61, 0x0b, 0x8b, 0x74, 0xed,
      0xf9, 0x98, 0x7c, 0x98, 0x88, 0x46, 0x01, 0x08, 0xa1, 0x15, 0x25, 0xd0,
      0xe7, 0x22, 0x8b, 0xa5, 0xeb, 0x94, 0x72, 0xa0, 0xfa, 0xda, 0x1d, 0x05,
      0x6c, 0x8b, 0x0d, 0x08, 0xef, 0xee, 0x27, 0x61, 0x10, 0x75, 0x95, 0xc6,
      0xb2, 0x21, 0x71, 0x6b, 0x67, 0x82, 0xc2, 0x7b, 0xd7, 0x75, 0x5f, 0x1a,
      0x23, 0xae, 0xf6, 0xcb, 0x96, 0x6a, 0x31, 0x47, 0x19, 0x21, 0x59, 0x4a,
      0x1d, 0xe1, 0x7e, 0xbc, 0x7e, 0x5b, 0x52, 0xb9, 0x33, 0xae, 0x52, 0xa0,
      0x79, 0x4b, 0xf4, 0xbc, 0xd1, 0xa7, 0x92, 0xe7, 0x8a, 0x47, 0xf0, 0x19,
      0x69, 0x8a, 0x37, 0xd0, 0xd3, 0x89, 0xca, 0x20, 0x40, 0xc0, 0xd3, 0x75,
      0x8e, 0xed, 0xf0, 0xfa, 0x81, 0x00, 0x41, 0x57, 0x4b, 0x32, 0x93, 0x8d,
      0x29, 0x0c, 0xfb, 0x45},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 68
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     68,
     20,
     {0x88, 0x1d, 0xc4, 0xbf, 0x8b, 0x2c, 0x6c, 0x17, 0xe1, 0x0b, 0xef, 0x3d,
      0xab, 0x32, 0x7b, 0x4c, 0xbb, 0x76, 0x41, 0x3a, 0x7e, 0x5a, 0xfb, 0xd2,
      0x4f, 0x19, 0x8f, 0xa4, 0x61, 0xbc, 0xe9, 0x39, 0x2d, 0x31, 0xf0, 0xa1,
      0x1d, 0x69, 0xbd, 0x67, 0xb7, 0x5f, 0xa3, 0x0f, 0xf2, 0x10, 0x0d, 0xcd,
      0x52, 0xb8, 0xe0, 0xc2, 0x4c, 0x91, 0xb0, 0x19, 0x6d, 0x17, 0x2a, 0xe3,
      0xfc, 0x1d, 0x40, 0xfb, 0x16, 0x7b, 0x2a, 0xbd, 0xce, 0x4b, 0x83, 0xfe,
      0xd3, 0x65, 0xb9, 0xd5, 0x94, 0x6a, 0x33, 0x3d, 0x0f, 0x66, 0x9d, 0x99,
      0xed, 0xf7, 0xb8, 0xa3, 0xa1, 0xc8, 0xdd, 0xf2, 0x39, 0x7c, 0xb7, 0x7b,
      0xcb, 0x62, 0xae, 0xcf, 0x81, 0x88, 0x07, 0xd6, 0x96, 0xaf, 0x4f, 0x18,
      0x6b, 0xf2, 0xe0, 0x62, 0x8d, 0xdb, 0x1b, 0x9d, 0x45, 0xdc, 0xd6, 0xeb,
      0x96, 0x5d, 0xd1, 0xb5, 0xeb, 0x2b, 0xad, 0xe6, 0x0f, 0xbf, 0x5b, 0x2a,
      0xe8, 0x16, 0xf4, 0x5f, 0x9e, 0x0a, 0xd0, 0x24, 0x03, 0x9b, 0xf6, 0x4c,
      0x08, 0x1e, 0x37, 0x63, 0x0d, 0x6d, 0xb5, 0x1a, 0x36, 0x8e, 0x92, 0x25,
      0x62, 0x68, 0x17, 0x8a, 0xeb, 0xd3, 0x29, 0x63, 0xa0, 0x76, 0x93, 0xf8,
      0x28, 0xd0, 0x1e, 0xeb, 0xaa, 0xd0, 0xfa, 0x04, 0xe0, 0xff, 0x29, 0xd8,
      0xc7, 0xae, 0x68, 0x1b, 0xe4, 0xec, 0x16, 0xd2, 0xa6, 0xba, 0xfc, 0x15,
      0x73, 0xe3, 0x8f, 0x58, 0xc6, 0xc2, 0xc3, 0x6a, 0x5d, 0x5a, 0x2a, 0xe7,
      0x71, 0x8a, 0xdb, 0x13, 0x90, 0x77, 0x0d, 0x9a, 0x38, 0x82, 0xf8, 0x95,
      0xb3, 0xf0, 0xfe, 0xe1, 0x6a, 0x2b, 0xdc, 0x74, 0x3b, 0x09, 0x06, 0x56,
      0x7b, 0x69, 0x38, 0xd7, 0x3a, 0x66, 0x6c, 0xc3, 0x3d, 0x85, 0x14, 0x23,
      0x59, 0xd4, 0x0e, 0xab, 0xbc, 0x1d, 0xa6, 0x5a, 0xe6, 0x16, 0xc7, 0x81,
      0x8f, 0x86, 0xfe, 0x1a},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: bit 7 of masked_db not cleared
    // tcID: 69
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     69,
     20,
     {0x15, 0x87, 0x22, 0x63, 0xf8, 0x27, 0x0e, 0x7a, 0xe9, 0xd3, 0x12, 0x7a,
      0x9b, 0x67, 0x78, 0x28, 0xca, 0xe2, 0x07, 0x7e, 0x53, 0x4e, 0xa3, 0x49,
      0x07, 0x02, 0x89, 0x39, 0x4d, 0x13, 0x59, 0x93, 0x92, 0xb5, 0xf8, 0x03,
      0xf8, 0xdb, 0xfe, 0x40, 0xa5, 0x48, 0x72, 0x23, 0xdd, 0xa2, 0xa3, 0xc6,
      0xf3, 0x0d, 0xdc, 0x92, 0xc4, 0xe6, 0xd9, 0xd2, 0x2e, 0x7d, 0x0d, 0x2b,
      0x60, 0x19, 0x7e, 0x03, 0x2f, 0x18, 0x8d, 0xa3, 0x54, 0x57, 0x27, 0x3c,
      0xe5, 0x51, 0x8b, 0x42, 0x61, 0x96, 0xc9, 0x52, 0xd0, 0x21, 0x9f, 0xf6,
      0x19, 0x0f, 0xce, 0x90, 0x5d, 0x85, 0x6d, 0x49, 0x1b, 0x00, 0x99, 0x98,
      0x21, 0xce, 0x8d, 0x1e, 0xa4, 0xb1, 0x8f, 0x34, 0x23, 0xeb, 0xad, 0x24,
      0x2b, 0xc8, 0x46, 0xe0, 0xaf, 0x40, 0x8f, 0x21, 0xcd, 0xdb, 0xf4, 0x4e,
      0x9e, 0x5f, 0x5d, 0x30, 0x0d, 0x71, 0xa3, 0xb1, 0x04, 0xea, 0xa2, 0x23,
      0x0e, 0xe6, 0x33, 0xd2, 0xea, 0x44, 0x01, 0x6a, 0xf7, 0x35, 0xcd, 0x5e,
      0xd9, 0xc7, 0xb4, 0x21, 0xf3, 0x22, 0x78, 0x15, 0x47, 0xbc, 0xbb, 0x0c,
      0xd9, 0x5e, 0x47, 0x80, 0x41, 0x2f, 0x73, 0x4b, 0xf6, 0x81, 0xbb, 0x47,
      0xab, 0xd4, 0x6b, 0x15, 0x8d, 0x25, 0x1e, 0xc9, 0x20, 0x56, 0x55, 0x3a,
      0xc0, 0x6a, 0x59, 0xc4, 0xba, 0x7f, 0xd2, 0x0b, 0xfe, 0x50, 0xcc, 0x58,
      0x38, 0x68, 0x32, 0xb5, 0x2e, 0x54, 0x8d, 0xf3, 0x45, 0xb0, 0x86, 0xb5,
      0x75, 0x7c, 0x4c, 0x9f, 0x2e, 0x13, 0x31, 0x31, 0xbe, 0xcc, 0x90, 0xa7,
      0x2e, 0xc6, 0xc3, 0x13, 0xe7, 0x66, 0x4d, 0xbc, 0x92, 0x2c, 0x87, 0xa9,
      0x03, 0x64, 0xbf, 0xc7, 0x46, 0xa4, 0x25, 0xdf, 0x77, 0xc9, 0xb9, 0x7d,
      0xc2, 0xaf, 0xec, 0xb2, 0xcc, 0x36, 0xfe, 0xc4, 0x15, 0xa4, 0xe1, 0xc6,
      0xa9, 0x57, 0xb4, 0xb3},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of masked_db changed to 0
    // tcID: 70
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     70,
     20,
     {0x6d, 0xe5, 0x0a, 0x99, 0x11, 0x89, 0x35, 0x47, 0xab, 0x56, 0x06, 0x5d,
      0x29, 0x53, 0x03, 0x87, 0x68, 0xcd, 0x06, 0x89, 0xa6, 0x3b, 0x07, 0x03,
      0xc0, 0xdc, 0x99, 0xe7, 0xcd, 0xa4, 0x12, 0xff, 0x49, 0xec, 0xa5, 0x03,
      0x67, 0x1f, 0x06, 0x86, 0x35, 0xf6, 0x9b, 0x38, 0xc0, 0x62, 0x74, 0x27,
      0xf0, 0x27, 0x85, 0xb3, 0x87, 0x0c, 0x67, 0x91, 0xad, 0xd3, 0x7d, 0x43,
      0x6a, 0x81, 0x53, 0x8e, 0x6f, 0xe3, 0xdd, 0x0e, 0xaf, 0xdb, 0x50, 0xa1,
      0x8d, 0x2f, 0x2d, 0x97, 0xe3, 0xcb, 0xa0, 0x62, 0xfc, 0x83, 0x43, 0xa6,
      0xdf, 0xd4, 0x48, 0xc1, 0x19, 0x97, 0xd1, 0xc5, 0xbf, 0x6e, 0x18, 0x95,
      0xe0, 0x9a, 0xb4, 0x35, 0xeb, 0xb1, 0x60, 0x52, 0xc2, 0x03, 0x47, 0xf4,
      0xd0, 0x77, 0xc6, 0xc7, 0x77, 0x92, 0x97, 0xa2, 0x9e, 0x76, 0xe4, 0x9c,
      0xdf, 0x0d, 0x10, 0x71, 0x3f, 0xce, 0x20, 0xab, 0x51, 0xd2, 0x73, 0xfe,
      0xba, 0xff, 0xd0, 0x67, 0x9a, 0x1e, 0xd5, 0x6d, 0xa5, 0xc0, 0x43, 0x0a,
      0x90, 0xa5, 0xfc, 0xa1, 0xec, 0x20, 0x10, 0x29, 0x3b, 0x2e, 0xb8, 0xfe,
      0x34, 0xa7, 0x32, 0xef, 0x46, 0x79, 0x31, 0x8f, 0xc5, 0x68, 0x2c, 0xd8,
      0x79, 0x6d, 0x57, 0xbe, 0x09, 0x90, 0x40, 0x43, 0x96, 0x1d, 0x51, 0x71,
      0xfa, 0x32, 0x30, 0x67, 0x45, 0x01, 0x54, 0x4e, 0x3d, 0x54, 0x82, 0xf5,
      0x10, 0xaf, 0xeb, 0x0e, 0xe4, 0xba, 0x9f, 0xd1, 0xcf, 0xe5, 0xba, 0x55,
      0x27, 0xc9, 0xc3, 0x2f, 0xf0, 0x9d, 0xf5, 0x79, 0x88, 0x4d, 0x4a, 0x5b,
      0x03, 0x51, 0xce, 0xfa, 0x07, 0xba, 0xf4, 0x09, 0x61, 0x41, 0x23, 0x48,
      0xb6, 0x84, 0x6f, 0xce, 0x5b, 0xd6, 0xd6, 0x5a, 0x54, 0x38, 0x82, 0x12,
      0x18, 0xd6, 0x77, 0xe7, 0x74, 0x82, 0x81, 0x08, 0xad, 0x80, 0x5f, 0x57,
      0x4c, 0xe7, 0xb5, 0x97},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte in em modified
    // tcID: 71
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     71,
     20,
     {0x1f, 0x47, 0xac, 0x7f, 0xd4, 0x58, 0x5e, 0xa4, 0x2a, 0xb0, 0x8e, 0x10,
      0x02, 0xf5, 0x47, 0xdc, 0x78, 0xdb, 0xac, 0xda, 0x00, 0xeb, 0x2b, 0x3e,
      0x74, 0xd0, 0xe4, 0x6d, 0x45, 0xff, 0xa8, 0xfa, 0x7b, 0x35, 0xd7, 0xaf,
      0xdf, 0x60, 0x5b, 0x2d, 0xa7, 0x72, 0xbf, 0x54, 0x84, 0x3f, 0x15, 0x29,
      0x7b, 0xcc, 0x6f, 0x52, 0xee, 0xec, 0xae, 0xfe, 0x1c, 0x26, 0x10, 0x8c,
      0x35, 0xf9, 0x05, 0x9c, 0x82, 0x23, 0x76, 0x7c, 0x19, 0x59, 0x7f, 0x44,
      0x70, 0xde, 0x50, 0x28, 0xb6, 0xc5, 0x22, 0xae, 0xfc, 0x5b, 0x61, 0xd5,
      0x45, 0xeb, 0xd6, 0xd3, 0x31, 0x2c, 0xc0, 0x92, 0xd1, 0xfc, 0x2a, 0x70,
      0xc5, 0x24, 0xfe, 0x02, 0x56, 0x02, 0x9d, 0x3d, 0x35, 0x79, 0x75, 0x21,
      0x5b, 0x2b, 0xb6, 0x23, 0x36, 0xc4, 0xf4, 0x92, 0x3e, 0xaa, 0x0c, 0xc4,
      0x22, 0xa3, 0xa0, 0x88, 0xb8, 0x6f, 0x4e, 0x0d, 0x81, 0xb6, 0xb4, 0xe0,
      0x4c, 0x21, 0x80, 0x8a, 0x19, 0xac, 0x22, 0x9f, 0x26, 0x57, 0xed, 0xd4,
      0x2a, 0x6c, 0x41, 0xe8, 0x83, 0xe6, 0x9a, 0x91, 0x67, 0x17, 0xb5, 0x9f,
      0xc6, 0x98, 0x0d, 0x79, 0x88, 0x4e, 0xae, 0x5e, 0xa9, 0x18, 0x02, 0x2d,
      0xa2, 0x8c, 0xe2, 0xf8, 0xe5, 0x2a, 0x2e, 0x5d, 0xd5, 0x0d, 0x2d, 0x29,
      0x69, 0x74, 0x8c, 0x2d, 0x97, 0x52, 0x5e, 0x67, 0x2c, 0x12, 0x11, 0x3f,
      0x60, 0x5b, 0x8c, 0x4b, 0xfc, 0xbf, 0xdc, 0xa0, 0x5b, 0xd8, 0x52, 0x85,
      0xd8, 0xfe, 0x6d, 0x22, 0xb7, 0x3d, 0x3b, 0x04, 0xfa, 0xfd, 0x45, 0x3c,
      0xfa, 0x72, 0x67, 0xce, 0xfd, 0xb5, 0x28, 0x19, 0x00, 0x38, 0x9f, 0xf5,
      0x3b, 0xb4, 0xdc, 0x3b, 0xf0, 0xdc, 0x36, 0x6d, 0x86, 0x91, 0x2d, 0x82,
      0x24, 0x10, 0xe8, 0xf7, 0x7f, 0x33, 0x39, 0x2c, 0x0c, 0x27, 0xfe, 0xd3,
      0x65, 0x9d, 0xa4, 0x63},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte in em modified
    // tcID: 72
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     72,
     20,
     {0x79, 0x22, 0xbf, 0xdd, 0x4d, 0xa2, 0x22, 0x91, 0x8c, 0x57, 0x31, 0x84,
      0xb1, 0xd8, 0x1a, 0x14, 0xfe, 0x87, 0xec, 0xa0, 0xa3, 0x0c, 0x55, 0xf9,
      0x16, 0x7a, 0xd8, 0x14, 0x4e, 0xa0, 0x6a, 0x9d, 0x22, 0xb1, 0x08, 0xa4,
      0x14, 0x37, 0xb4, 0x2a, 0xa0, 0x8a, 0xfa, 0xc4, 0x4e, 0x76, 0x61, 0xf7,
      0xb4, 0xc6, 0x29, 0x38, 0x97, 0x42, 0x6c, 0xb2, 0xe9, 0x60, 0xaf, 0xf1,
      0x63, 0x61, 0x33, 0x49, 0xb3, 0x58, 0x1c, 0xbd, 0x3a, 0x88, 0x4f, 0xf9,
      0x89, 0x8c, 0x45, 0xc5, 0xc2, 0x13, 0xd9, 0x96, 0xcd, 0xc1, 0xcc, 0x11,
      0x9d, 0xbc, 0xd7, 0xe0, 0xe9, 0x9e, 0xd0, 0x8f, 0x99, 0xf8, 0xb6, 0x9f,
      0x8a, 0xa0, 0x79, 0xcc, 0x6d, 0x15, 0x00, 0x66, 0x97, 0xd4, 0xa7, 0xfc,
      0x5b, 0xcf, 0xd3, 0x49, 0xfc, 0xf2, 0x6f, 0x43, 0xb6, 0xf5, 0x07, 0x4d,
      0xb8, 0xe4, 0x48, 0xbc, 0x92, 0xab, 0x84, 0x42, 0xb2, 0x7e, 0x82, 0x64,
      0x3a, 0x11, 0x84, 0x2a, 0x0d, 0xc7, 0x0b, 0x82, 0x2c, 0xf7, 0xae, 0x26,
      0xe9, 0x07, 0x91, 0xf6, 0x7d, 0x25, 0xa3, 0x21, 0xae, 0xc2, 0x4c, 0xcd,
      0x75, 0x53, 0xe6, 0x31, 0xbc, 0xe7, 0x48, 0x88, 0xc4, 0x3d, 0x9e, 0xcd,
      0x18, 0xe7, 0x7f, 0xc2, 0x46, 0x15, 0xec, 0x44, 0x5b, 0x7d, 0x7e, 0xe8,
      0x3a, 0xaf, 0x63, 0xc0, 0x73, 0x3d, 0xa2, 0x5e, 0xcd, 0x51, 0x2f, 0x7d,
      0xc7, 0xee, 0xc6, 0xe3, 0xfb, 0x49, 0x9d, 0x7e, 0xee, 0x61, 0x65, 0xc7,
      0x8a, 0x42, 0x75, 0xa9, 0xe6, 0xfd, 0xcb, 0x1b, 0x96, 0x2f, 0x38, 0xc8,
      0x13, 0x9d, 0xa5, 0x08, 0x95, 0x65, 0xb3, 0x9c, 0x6d, 0x73, 0x73, 0x9f,
      0x84, 0xc7, 0x0e, 0xd6, 0x0e, 0x2c, 0x83, 0xbb, 0x4f, 0x35, 0x1d, 0x4c,
      0x87, 0xcb, 0xa2, 0xcf, 0x6c, 0x68, 0xb9, 0x87, 0x9e, 0x28, 0x3b, 0x9c,
      0x5e, 0x3d, 0xe1, 0xc8},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte in em modified
    // tcID: 73
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     73,
     20,
     {0x8a, 0x7e, 0x60, 0x0a, 0x66, 0x75, 0xa0, 0x6e, 0x67, 0x7f, 0xf1, 0x34,
      0x4f, 0xd5, 0x3a, 0x8d, 0xd2, 0xb9, 0x9f, 0xcc, 0xa4, 0x0c, 0x2a, 0xb7,
      0x99, 0x63, 0x66, 0x63, 0x59, 0x4a, 0xc3, 0xfe, 0x2a, 0x51, 0x0b, 0xf1,
      0xe3, 0xec, 0x4c, 0xa9, 0xdd, 0x28, 0xcc, 0xed, 0x48, 0xb4, 0xe8, 0x45,
      0x7e, 0xd7, 0x4f, 0x4e, 0xc2, 0xad, 0xf3, 0x1b, 0x77, 0xff, 0x1b, 0xfa,
      0xbd, 0x0f, 0x80, 0xc9, 0xab, 0x46, 0x88, 0xf1, 0x56, 0x30, 0x40, 0x6d,
      0x8c, 0xa3, 0x1e, 0xda, 0xa3, 0xa3, 0xcc, 0x79, 0x80, 0xba, 0x1b, 0x76,
      0x0c, 0xfb, 0xd3, 0xff, 0x90, 0x16, 0xe1, 0xf3, 0xfa, 0x0c, 0x34, 0xcb,
      0x59, 0x37, 0x8b, 0x0f, 0x37, 0x45, 0xb4, 0x51, 0xfd, 0x3e, 0x05, 0x3c,
      0x87, 0x11, 0xec, 0xc4, 0x1f, 0xea, 0xaf, 0x35, 0x09, 0x80, 0x53, 0x2a,
      0x7d, 0xb6, 0x7a, 0xfc, 0x35, 0xf0, 0x0d, 0xa1, 0xf1, 0x91, 0xff, 0x4f,
      0x66, 0xb8, 0xe7, 0xe2, 0x73, 0x68, 0xbc, 0x26, 0x16, 0x0f, 0x54, 0x0a,
      0xf7, 0x84, 0xe8, 0xec, 0xb3, 0x8e, 0x2d, 0xad, 0xf4, 0xbe, 0x82, 0xe4,
      0xb7, 0x61, 0x62, 0x6c, 0x5c, 0x06, 0xef, 0xe0, 0xda, 0xda, 0x64, 0x2e,
      0xb2, 0x6f, 0x12, 0xd1, 0xee, 0x96, 0x68, 0x4a, 0x5e, 0xf8, 0xe5, 0xfe,
      0xee, 0xb0, 0xda, 0x9e, 0xf4, 0x32, 0x64, 0x73, 0x36, 0xe4, 0xec, 0x71,
      0x5c, 0xfa, 0x26, 0x0a, 0x87, 0x27, 0xae, 0xc4, 0xa0, 0x80, 0x73, 0x80,
      0x86, 0xad, 0x26, 0xb5, 0x13, 0x55, 0xb8, 0xbf, 0xaf, 0x1b, 0x13, 0x5e,
      0x97, 0xd1, 0x08, 0xb3, 0x6c, 0x73, 0xb4, 0x36, 0xcc, 0x5c, 0xb5, 0x95,
      0x93, 0xa7, 0xce, 0x0f, 0x0e, 0x74, 0x83, 0x15, 0x23, 0x19, 0xfc, 0xeb,
      0x37, 0x47, 0x94, 0x51, 0xee, 0xea, 0x09, 0x8a, 0x8e, 0xeb, 0x0d, 0xee,
      0x19, 0x75, 0x6e, 0x03},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is 0
    // tcID: 74
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     74,
     20,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is 1
    // tcID: 75
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     75,
     20,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is n-1
    // tcID: 76
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     76,
     20,
     {0xbd, 0x31, 0xc7, 0xa0, 0x26, 0x91, 0xd2, 0xd9, 0x58, 0x7e, 0xf6, 0xa9,
      0x46, 0xff, 0x78, 0x85, 0x44, 0xcc, 0xad, 0xd4, 0xb2, 0x98, 0x8a, 0xd6,
      0x20, 0x86, 0x79, 0x2a, 0x6b, 0xf9, 0x6c, 0x86, 0x16, 0xb4, 0xad, 0x13,
      0x31, 0x7d, 0x22, 0x70, 0xb9, 0x01, 0xd0, 0xfc, 0xd1, 0xd8, 0x80, 0xcb,
      0x8f, 0x52, 0xfb, 0x87, 0x30, 0x4a, 0x52, 0x58, 0xc1, 0x1b, 0x38, 0xdf,
      0xea, 0xe8, 0xdf, 0x67, 0x0a, 0xee, 0xe7, 0xea, 0x1d, 0x0d, 0x9d, 0xf8,
      0xe0, 0x0e, 0x80, 0x84, 0x7e, 0x41, 0xe5, 0x98, 0x9e, 0xd4, 0x02, 0xd4,
      0x4e, 0x78, 0xb3, 0x0f, 0xef, 0x17, 0xb5, 0x67, 0x1d, 0x3a, 0xdb, 0xf8,
      0x68, 0x5e, 0x4d, 0xc2, 0x04, 0x49, 0x9e, 0xcd, 0x18, 0x63, 0xe1, 0xd5,
      0xaf, 0xf2, 0x8a, 0x7c, 0xf6, 0x6e, 0xad, 0xf3, 0x1f, 0xec, 0x92, 0x36,
      0xc1, 0x20, 0xad, 0xd1, 0x34, 0x51, 0x52, 0x2c, 0x64, 0x7c, 0x98, 0x32,
      0xa6, 0x72, 0xcd, 0x64, 0xd3, 0x28, 0xc1, 0xc3, 0x22, 0x18, 0x3f, 0x46,
      0x61, 0xd0, 0x9b, 0xda, 0x60, 0xb8, 0xdd, 0x5f, 0x03, 0x28, 0xda, 0x54,
      0x20, 0x82, 0x14, 0x24, 0xaf, 0xda, 0xbb, 0x1a, 0x80, 0xc5, 0xd1, 0x27,
      0x63, 0xa1, 0xb0, 0x23, 0x8c, 0xd8, 0x9d, 0x07, 0x42, 0xbf, 0xc5, 0x0b,
      0x6a, 0x2f, 0xcb, 0x70, 0x1d, 0x82, 0x42, 0x18, 0xf9, 0x82, 0x6f, 0x4f,
      0x78, 0xa2, 0x3a, 0x2b, 0x5a, 0xa4, 0x2a, 0xce, 0x7f, 0x17, 0x53, 0x76,
      0xfb, 0x6c, 0xbd, 0xb2, 0xba, 0xd2, 0x93, 0xba, 0x58, 0x3d, 0x4d, 0x31,
      0xc6, 0xb8, 0xf9, 0x02, 0x9e, 0x46, 0xb1, 0x36, 0x89, 0x24, 0x98, 0x55,
      0xf5, 0x05, 0x75, 0x6e, 0x00, 0xe2, 0x25, 0xa6, 0xa4, 0x5a, 0x18, 0x76,
      0x9b, 0xd8, 0xd2, 0xb3, 0xa4, 0xac, 0xb9, 0xf1, 0xc2, 0x3d, 0x3e, 0x51,
      0x88, 0x25, 0x61, 0xe4},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is n
    // tcID: 77
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     77,
     20,
     {0xbd, 0x31, 0xc7, 0xa0, 0x26, 0x91, 0xd2, 0xd9, 0x58, 0x7e, 0xf6, 0xa9,
      0x46, 0xff, 0x78, 0x85, 0x44, 0xcc, 0xad, 0xd4, 0xb2, 0x98, 0x8a, 0xd6,
      0x20, 0x86, 0x79, 0x2a, 0x6b, 0xf9, 0x6c, 0x86, 0x16, 0xb4, 0xad, 0x13,
      0x31, 0x7d, 0x22, 0x70, 0xb9, 0x01, 0xd0, 0xfc, 0xd1, 0xd8, 0x80, 0xcb,
      0x8f, 0x52, 0xfb, 0x87, 0x30, 0x4a, 0x52, 0x58, 0xc1, 0x1b, 0x38, 0xdf,
      0xea, 0xe8, 0xdf, 0x67, 0x0a, 0xee, 0xe7, 0xea, 0x1d, 0x0d, 0x9d, 0xf8,
      0xe0, 0x0e, 0x80, 0x84, 0x7e, 0x41, 0xe5, 0x98, 0x9e, 0xd4, 0x02, 0xd4,
      0x4e, 0x78, 0xb3, 0x0f, 0xef, 0x17, 0xb5, 0x67, 0x1d, 0x3a, 0xdb, 0xf8,
      0x68, 0x5e, 0x4d, 0xc2, 0x04, 0x49, 0x9e, 0xcd, 0x18, 0x63, 0xe1, 0xd5,
      0xaf, 0xf2, 0x8a, 0x7c, 0xf6, 0x6e, 0xad, 0xf3, 0x1f, 0xec, 0x92, 0x36,
      0xc1, 0x20, 0xad, 0xd1, 0x34, 0x51, 0x52, 0x2c, 0x64, 0x7c, 0x98, 0x32,
      0xa6, 0x72, 0xcd, 0x64, 0xd3, 0x28, 0xc1, 0xc3, 0x22, 0x18, 0x3f, 0x46,
      0x61, 0xd0, 0x9b, 0xda, 0x60, 0xb8, 0xdd, 0x5f, 0x03, 0x28, 0xda, 0x54,
      0x20, 0x82, 0x14, 0x24, 0xaf, 0xda, 0xbb, 0x1a, 0x80, 0xc5, 0xd1, 0x27,
      0x63, 0xa1, 0xb0, 0x23, 0x8c, 0xd8, 0x9d, 0x07, 0x42, 0xbf, 0xc5, 0x0b,
      0x6a, 0x2f, 0xcb, 0x70, 0x1d, 0x82, 0x42, 0x18, 0xf9, 0x82, 0x6f, 0x4f,
      0x78, 0xa2, 0x3a, 0x2b, 0x5a, 0xa4, 0x2a, 0xce, 0x7f, 0x17, 0x53, 0x76,
      0xfb, 0x6c, 0xbd, 0xb2, 0xba, 0xd2, 0x93, 0xba, 0x58, 0x3d, 0x4d, 0x31,
      0xc6, 0xb8, 0xf9, 0x02, 0x9e, 0x46, 0xb1, 0x36, 0x89, 0x24, 0x98, 0x55,
      0xf5, 0x05, 0x75, 0x6e, 0x00, 0xe2, 0x25, 0xa6, 0xa4, 0x5a, 0x18, 0x76,
      0x9b, 0xd8, 0xd2, 0xb3, 0xa4, 0xac, 0xb9, 0xf1, 0xc2, 0x3d, 0x3e, 0x51,
      0x88, 0x25, 0x61, 0xe5},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to signature
    // tcID: 78
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     78,
     20,
     {0x00, 0x00, 0x0b, 0xb9, 0x47, 0x3d, 0x3a, 0x8c, 0xc4, 0xab, 0xd6, 0x3c,
      0x6f, 0x2a, 0xc1, 0x3e, 0x27, 0x8a, 0x9c, 0xd1, 0xdd, 0xa8, 0x44, 0xfd,
      0xbd, 0x13, 0xe9, 0xb7, 0x7c, 0xdd, 0x52, 0xc1, 0xb0, 0x5a, 0xc5, 0x91,
      0x26, 0xe4, 0x5d, 0x27, 0x67, 0x77, 0xe8, 0xb1, 0xbc, 0x42, 0x3c, 0xb2,
      0x61, 0xd2, 0x96, 0x75, 0x98, 0x89, 0x54, 0xc9, 0xdd, 0xc3, 0x8b, 0xb9,
      0xa6, 0x7b, 0xec, 0x5e, 0x03, 0xe1, 0xe7, 0x80, 0x91, 0x53, 0x33, 0xdf,
      0xe4, 0x94, 0xdd, 0x8a, 0x4f, 0x0b, 0xfa, 0x0d, 0x74, 0x88, 0x05, 0x88,
      0x5c, 0x38, 0x9d, 0x6f, 0x7f, 0xb6, 0xf7, 0x86, 0xc5, 0x8d, 0x21, 0xa4,
      0x68, 0xb3, 0x58, 0x93, 0x46, 0xd7, 0x0e, 0x11, 0x53, 0xe2, 0x9d, 0xcd,
      0xb9, 0x1d, 0xec, 0x8a, 0xc1, 0x85, 0x50, 0x1e, 0xfe, 0xa2, 0x47, 0xba,
      0xc7, 0xc6, 0x3e, 0x3c, 0x54, 0x6e, 0xd6, 0x35, 0xe6, 0x47, 0x09, 0x7b,
      0xae, 0x3b, 0x8c, 0xcb, 0x99, 0x27, 0x01, 0xa7, 0x5d, 0x20, 0x9c, 0x43,
      0x9c, 0x5d, 0xbe, 0x81, 0x22, 0xda, 0x61, 0x6a, 0x4e, 0x23, 0x0b, 0xce,
      0x08, 0xf5, 0x41, 0xab, 0xff, 0x85, 0x4f, 0xb9, 0x3c, 0x87, 0xfd, 0xde,
      0x0f, 0xb4, 0x57, 0xc4, 0x4b, 0x27, 0x83, 0x56, 0x8b, 0xcb, 0xbf, 0xbb,
      0xa6, 0x11, 0xd8, 0xe9, 0x84, 0x41, 0x0d, 0x36, 0x0c, 0x4e, 0xc3, 0x73,
      0x2c, 0xb6, 0x94, 0x26, 0xa9, 0x41, 0x91, 0xd5, 0xa0, 0xcb, 0x33, 0x14,
      0x9b, 0x51, 0x8d, 0xed, 0x86, 0x86, 0x47, 0x06, 0xc7, 0x23, 0xb2, 0x72,
      0x28, 0xd7, 0x48, 0x36, 0x51, 0x31, 0x91, 0xce, 0xbc, 0x79, 0x07, 0x93,
      0xe5, 0x80, 0x92, 0x87, 0xb0, 0x27, 0x9e, 0x7b, 0xc8, 0x2f, 0x26, 0x6d,
      0x43, 0x7d, 0x19, 0x2e, 0x98, 0x97, 0x59, 0x60, 0xd0, 0x01, 0x4d, 0xd0,
      0x2e, 0x17, 0x2b, 0x7f, 0xe2, 0x51},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to signature
    // tcID: 79
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     79,
     20,
     {0x0b, 0xb9, 0x47, 0x3d, 0x3a, 0x8c, 0xc4, 0xab, 0xd6, 0x3c, 0x6f, 0x2a,
      0xc1, 0x3e, 0x27, 0x8a, 0x9c, 0xd1, 0xdd, 0xa8, 0x44, 0xfd, 0xbd, 0x13,
      0xe9, 0xb7, 0x7c, 0xdd, 0x52, 0xc1, 0xb0, 0x5a, 0xc5, 0x91, 0x26, 0xe4,
      0x5d, 0x27, 0x67, 0x77, 0xe8, 0xb1, 0xbc, 0x42, 0x3c, 0xb2, 0x61, 0xd2,
      0x96, 0x75, 0x98, 0x89, 0x54, 0xc9, 0xdd, 0xc3, 0x8b, 0xb9, 0xa6, 0x7b,
      0xec, 0x5e, 0x03, 0xe1, 0xe7, 0x80, 0x91, 0x53, 0x33, 0xdf, 0xe4, 0x94,
      0xdd, 0x8a, 0x4f, 0x0b, 0xfa, 0x0d, 0x74, 0x88, 0x05, 0x88, 0x5c, 0x38,
      0x9d, 0x6f, 0x7f, 0xb6, 0xf7, 0x86, 0xc5, 0x8d, 0x21, 0xa4, 0x68, 0xb3,
      0x58, 0x93, 0x46, 0xd7, 0x0e, 0x11, 0x53, 0xe2, 0x9d, 0xcd, 0xb9, 0x1d,
      0xec, 0x8a, 0xc1, 0x85, 0x50, 0x1e, 0xfe, 0xa2, 0x47, 0xba, 0xc7, 0xc6,
      0x3e, 0x3c, 0x54, 0x6e, 0xd6, 0x35, 0xe6, 0x47, 0x09, 0x7b, 0xae, 0x3b,
      0x8c, 0xcb, 0x99, 0x27, 0x01, 0xa7, 0x5d, 0x20, 0x9c, 0x43, 0x9c, 0x5d,
      0xbe, 0x81, 0x22, 0xda, 0x61, 0x6a, 0x4e, 0x23, 0x0b, 0xce, 0x08, 0xf5,
      0x41, 0xab, 0xff, 0x85, 0x4f, 0xb9, 0x3c, 0x87, 0xfd, 0xde, 0x0f, 0xb4,
      0x57, 0xc4, 0x4b, 0x27, 0x83, 0x56, 0x8b, 0xcb, 0xbf, 0xbb, 0xa6, 0x11,
      0xd8, 0xe9, 0x84, 0x41, 0x0d, 0x36, 0x0c, 0x4e, 0xc3, 0x73, 0x2c, 0xb6,
      0x94, 0x26, 0xa9, 0x41, 0x91, 0xd5, 0xa0, 0xcb, 0x33, 0x14, 0x9b, 0x51,
      0x8d, 0xed, 0x86, 0x86, 0x47, 0x06, 0xc7, 0x23, 0xb2, 0x72, 0x28, 0xd7,
      0x48, 0x36, 0x51, 0x31, 0x91, 0xce, 0xbc, 0x79, 0x07, 0x93, 0xe5, 0x80,
      0x92, 0x87, 0xb0, 0x27, 0x9e, 0x7b, 0xc8, 0x2f, 0x26, 0x6d, 0x43, 0x7d,
      0x19, 0x2e, 0x98, 0x97, 0x59, 0x60, 0xd0, 0x01, 0x4d, 0xd0, 0x2e, 0x17,
      0x2b, 0x7f, 0xe2, 0x51, 0x00, 0x00},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated signature
    // tcID: 80
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     80,
     20,
     {0x0b, 0xb9, 0x47, 0x3d, 0x3a, 0x8c, 0xc4, 0xab, 0xd6, 0x3c, 0x6f, 0x2a,
      0xc1, 0x3e, 0x27, 0x8a, 0x9c, 0xd1, 0xdd, 0xa8, 0x44, 0xfd, 0xbd, 0x13,
      0xe9, 0xb7, 0x7c, 0xdd, 0x52, 0xc1, 0xb0, 0x5a, 0xc5, 0x91, 0x26, 0xe4,
      0x5d, 0x27, 0x67, 0x77, 0xe8, 0xb1, 0xbc, 0x42, 0x3c, 0xb2, 0x61, 0xd2,
      0x96, 0x75, 0x98, 0x89, 0x54, 0xc9, 0xdd, 0xc3, 0x8b, 0xb9, 0xa6, 0x7b,
      0xec, 0x5e, 0x03, 0xe1, 0xe7, 0x80, 0x91, 0x53, 0x33, 0xdf, 0xe4, 0x94,
      0xdd, 0x8a, 0x4f, 0x0b, 0xfa, 0x0d, 0x74, 0x88, 0x05, 0x88, 0x5c, 0x38,
      0x9d, 0x6f, 0x7f, 0xb6, 0xf7, 0x86, 0xc5, 0x8d, 0x21, 0xa4, 0x68, 0xb3,
      0x58, 0x93, 0x46, 0xd7, 0x0e, 0x11, 0x53, 0xe2, 0x9d, 0xcd, 0xb9, 0x1d,
      0xec, 0x8a, 0xc1, 0x85, 0x50, 0x1e, 0xfe, 0xa2, 0x47, 0xba, 0xc7, 0xc6,
      0x3e, 0x3c, 0x54, 0x6e, 0xd6, 0x35, 0xe6, 0x47, 0x09, 0x7b, 0xae, 0x3b,
      0x8c, 0xcb, 0x99, 0x27, 0x01, 0xa7, 0x5d, 0x20, 0x9c, 0x43, 0x9c, 0x5d,
      0xbe, 0x81, 0x22, 0xda, 0x61, 0x6a, 0x4e, 0x23, 0x0b, 0xce, 0x08, 0xf5,
      0x41, 0xab, 0xff, 0x85, 0x4f, 0xb9, 0x3c, 0x87, 0xfd, 0xde, 0x0f, 0xb4,
      0x57, 0xc4, 0x4b, 0x27, 0x83, 0x56, 0x8b, 0xcb, 0xbf, 0xbb, 0xa6, 0x11,
      0xd8, 0xe9, 0x84, 0x41, 0x0d, 0x36, 0x0c, 0x4e, 0xc3, 0x73, 0x2c, 0xb6,
      0x94, 0x26, 0xa9, 0x41, 0x91, 0xd5, 0xa0, 0xcb, 0x33, 0x14, 0x9b, 0x51,
      0x8d, 0xed, 0x86, 0x86, 0x47, 0x06, 0xc7, 0x23, 0xb2, 0x72, 0x28, 0xd7,
      0x48, 0x36, 0x51, 0x31, 0x91, 0xce, 0xbc, 0x79, 0x07, 0x93, 0xe5, 0x80,
      0x92, 0x87, 0xb0, 0x27, 0x9e, 0x7b, 0xc8, 0x2f, 0x26, 0x6d, 0x43, 0x7d,
      0x19, 0x2e, 0x98, 0x97, 0x59, 0x60, 0xd0, 0x01, 0x4d, 0xd0, 0x2e, 0x17,
      0x2b, 0x7f},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: empty signature
    // tcID: 81
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     81,
     20,
     {},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: PKCS #1 v1.5 signature
    // tcID: 82
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     82,
     20,
     {0x35, 0x98, 0xf8, 0x79, 0x16, 0xb4, 0x5e, 0x65, 0x7d, 0xf6, 0x3a, 0x83,
      0x9c, 0x7e, 0x54, 0x49, 0x53, 0xc0, 0x03, 0x94, 0x77, 0xb3, 0x96, 0xa2,
      0x76, 0xd8, 0xdf, 0x75, 0x2b, 0x0a, 0x98, 0x19, 0x2a, 0x10, 0xfd, 0xf4,
      0x31, 0x03, 0x33, 0x53, 0xf8, 0x56, 0x5c, 0x6d, 0xe1, 0xb2, 0x68, 0xf4,
      0xcc, 0xb4, 0x4c, 0x00, 0xce, 0x76, 0x0c, 0x67, 0xe9, 0x74, 0x09, 0x27,
      0x1c, 0x55, 0x05, 0x5b, 0x3e, 0xa8, 0x85, 0xd7, 0x42, 0xde, 0xf2, 0xc6,
      0xcd, 0x32, 0xf5, 0xfe, 0xd0, 0x77, 0x19, 0x3d, 0x12, 0xbd, 0x48, 0xd7,
      0x81, 0x30, 0x35, 0x3a, 0xd4, 0xac, 0xa3, 0x4d, 0x91, 0x48, 0xbf, 0xe8,
      0x0d, 0x8e, 0xa4, 0x55, 0xc3, 0xce, 0x4b, 0x24, 0xf7, 0x01, 0x31, 0x90,
      0x8e, 0x19, 0x47, 0xfe, 0xae, 0x31, 0x1e, 0x29, 0xe0, 0xae, 0x9d, 0x10,
      0x74, 0xba, 0x73, 0x12, 0x45, 0x68, 0x46, 0x8e, 0x34, 0xc8, 0xb0, 0x73,
      0x28, 0x3d, 0x16, 0x35, 0x9c, 0x53, 0x0e, 0xa6, 0x13, 0xad, 0xb4, 0xde,
      0x2b, 0xa9, 0x4e, 0xbc, 0x47, 0x0a, 0x57, 0x05, 0x55, 0x71, 0xef, 0x9f,
      0x57, 0x5c, 0x06, 0x8e, 0x00, 0xde, 0x09, 0xb6, 0xd1, 0xaf, 0x20, 0x51,
      0xb9, 0x30, 0x79, 0xdd, 0xc6, 0x83, 0x09, 0x0d, 0x44, 0x27, 0x84, 0x7b,
      0x4b, 0x9e, 0xd6, 0x3a, 0x34, 0xa0, 0x1d, 0x9a, 0xee, 0xef, 0x00, 0x52,
      0x42, 0x78, 0xff, 0x54, 0xb7, 0xd2, 0x95, 0x5c, 0xca, 0xe5, 0xca, 0x10,
      0x01, 0xee, 0x75, 0x88, 0xf5, 0xa2, 0x11, 0x66, 0xdd, 0xe7, 0xb2, 0x94,
      0x1a, 0x61, 0x36, 0xb3, 0x8d, 0x37, 0x4a, 0xac, 0x73, 0x75, 0x2b, 0xcf,
      0xd3, 0xe7, 0x00, 0x06, 0x6b, 0x29, 0x72, 0xc6, 0x6c, 0xef, 0x76, 0xa4,
      0x8d, 0x81, 0x81, 0x1e, 0x26, 0xfc, 0x76, 0x46, 0x97, 0x4a, 0x14, 0x97,
      0x08, 0xae, 0x2d, 0x21},
     pub_key_0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false}};

#endif  // rsa_pss_2048_sha1_20_vectors_h__
