/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef rsa_pss_3072_sha256_32_vectors_h__
#define rsa_pss_3072_sha256_32_vectors_h__

#include "testvectors_base/test-structs.h"

static const std::vector<uint8_t> pub_key_2{
    0x30, 0x82, 0x01, 0xa2, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
    0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x8f, 0x00,
    0x30, 0x82, 0x01, 0x8a, 0x02, 0x82, 0x01, 0x81, 0x00, 0xc6, 0xfe, 0x23,
    0x79, 0x25, 0x66, 0x02, 0x3c, 0x26, 0x52, 0x87, 0xc5, 0xac, 0x6f, 0x71,
    0x54, 0x1c, 0x09, 0x94, 0xd1, 0x1d, 0x05, 0x9e, 0xe6, 0x40, 0x39, 0x86,
    0xef, 0xa2, 0x1c, 0x24, 0xb5, 0x1b, 0xd9, 0x1d, 0x88, 0x62, 0xf9, 0xdf,
    0x79, 0xa4, 0xe3, 0x28, 0xe3, 0xe2, 0x7c, 0x83, 0xdf, 0x26, 0x0b, 0x25,
    0xa9, 0xb4, 0x34, 0x20, 0xaf, 0xfc, 0x44, 0xb5, 0x1e, 0x8d, 0x75, 0x25,
    0xb6, 0xf2, 0x9c, 0x37, 0x2a, 0x40, 0x51, 0x04, 0x73, 0x20, 0x07, 0x52,
    0x7a, 0x62, 0xed, 0x82, 0xfa, 0xc7, 0x3f, 0x48, 0x92, 0xa8, 0x0e, 0x09,
    0x68, 0x2a, 0x41, 0xa5, 0x8c, 0xd3, 0x47, 0x01, 0x7f, 0x3b, 0xe7, 0xd8,
    0x01, 0x33, 0x4f, 0x92, 0xd9, 0x32, 0x1a, 0xaf, 0xd5, 0x3b, 0x51, 0xbf,
    0xfa, 0xbf, 0xc7, 0x52, 0xcf, 0xcc, 0xae, 0x0b, 0x1e, 0xe0, 0x3b, 0xda,
    0xff, 0x9e, 0x42, 0x8c, 0xc1, 0xc1, 0x17, 0xf1, 0xac, 0x96, 0xb4, 0xfe,
    0x23, 0xf8, 0xc2, 0x3e, 0x63, 0x81, 0x18, 0x6a, 0x66, 0xfd, 0x59, 0x28,
    0x93, 0x39, 0xae, 0x55, 0xc4, 0xbc, 0xda, 0xdb, 0xff, 0x84, 0xab, 0xda,
    0xa5, 0x32, 0x24, 0x0d, 0x4e, 0x1d, 0x28, 0xb2, 0xd0, 0x48, 0x1d, 0xad,
    0xd3, 0xb2, 0x46, 0x55, 0x7c, 0xa8, 0xfe, 0x18, 0x09, 0x28, 0x17, 0x73,
    0x0b, 0x39, 0xe6, 0xee, 0x37, 0x8f, 0xfc, 0xc8, 0x5b, 0x19, 0xff, 0xdc,
    0x91, 0x6a, 0x9b, 0x99, 0x1a, 0x6b, 0x66, 0xd4, 0xa9, 0xc7, 0xba, 0xb5,
    0xf5, 0xe7, 0xa3, 0x72, 0x21, 0x01, 0x14, 0x2e, 0x7a, 0x41, 0x08, 0xc1,
    0x5d, 0x57, 0x3b, 0x15, 0x28, 0x9e, 0x07, 0xe4, 0x6e, 0xae, 0xa0, 0x7b,
    0x42, 0xc2, 0xab, 0xcb, 0xa3, 0x30, 0xe9, 0x95, 0x54, 0xb4, 0x65, 0x61,
    0x65, 0xbb, 0x4c, 0x0d, 0xb2, 0xb6, 0x39, 0x3a, 0x07, 0xec, 0xa5, 0x75,
    0xc5, 0x1a, 0x93, 0xc4, 0xe1, 0x5b, 0xdb, 0x0f, 0x74, 0x79, 0x09, 0x44,
    0x7e, 0x3e, 0xfe, 0x34, 0xc6, 0x7c, 0xa8, 0x95, 0x4b, 0x53, 0x0e, 0x56,
    0xa2, 0x0a, 0x1b, 0x6d, 0x84, 0xd4, 0x5e, 0xd1, 0xbc, 0xd3, 0xaa, 0x58,
    0xec, 0x06, 0xf1, 0x84, 0xee, 0x58, 0x57, 0xaa, 0xa8, 0x19, 0xe1, 0xcc,
    0xa9, 0xa2, 0x6f, 0x4e, 0x28, 0xd6, 0xb9, 0x77, 0xd3, 0x39, 0x16, 0xdb,
    0x98, 0x96, 0xd2, 0x52, 0xd1, 0xaf, 0xa7, 0x62, 0xe2, 0x87, 0xcb, 0x0d,
    0x38, 0x4c, 0xc7, 0x5b, 0xfe, 0x53, 0xf4, 0xe9, 0x22, 0xd0, 0x2d, 0xd0,
    0xa4, 0x81, 0xc0, 0x42, 0xe2, 0xd3, 0x06, 0xb4, 0xb3, 0xc1, 0x89, 0x37,
    0x1e, 0x57, 0x5b, 0x25, 0xe0, 0x00, 0x5a, 0x16, 0x4c, 0xf6, 0x9d, 0xd0,
    0x97, 0x6e, 0x4d, 0x5b, 0xe4, 0x76, 0x80, 0x6e, 0xa6, 0xbe, 0x60, 0x84,
    0xe7, 0x1a, 0xb4, 0xf5, 0xac, 0x5c, 0x1b, 0x12, 0x03, 0x02, 0x03, 0x01,
    0x00, 0x01};

const RsaPssTestVector kRsaPss3072Sha25632WycheproofVectors[] = {

    // Comment:
    // tcID: 1
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     1,
     32,
     {0xb5, 0x20, 0x06, 0x56, 0x82, 0x63, 0x3b, 0xa5, 0x4c, 0x9b, 0x71, 0x3b,
      0x2e, 0xf1, 0x9c, 0xdc, 0x1f, 0xcf, 0x27, 0x5b, 0xa1, 0x74, 0x4c, 0x23,
      0x50, 0xda, 0x73, 0x07, 0xa2, 0x09, 0x71, 0xcc, 0x30, 0xee, 0xfa, 0x37,
      0xd1, 0x66, 0x7d, 0x23, 0xd2, 0x00, 0x01, 0xa6, 0x74, 0xf0, 0xe0, 0x0d,
      0xf4, 0xf9, 0xb9, 0xe1, 0xd5, 0xfe, 0x7e, 0xb8, 0x5c, 0xc4, 0x5c, 0xab,
      0x5d, 0xd6, 0x25, 0x75, 0x9d, 0xe8, 0x30, 0x17, 0x99, 0x5c, 0x93, 0xd4,
      0x8b, 0x12, 0x6d, 0xf0, 0x3a, 0xa7, 0x4e, 0xf8, 0x7d, 0xae, 0xa0, 0xc1,
      0x65, 0x2d, 0xd3, 0x70, 0xad, 0x5d, 0x66, 0x35, 0x98, 0xa3, 0x83, 0xca,
      0xc2, 0x17, 0xa2, 0x08, 0xb2, 0x2c, 0x7c, 0xf0, 0xe4, 0x48, 0xcc, 0x7a,
      0xe0, 0x55, 0x5f, 0x89, 0x2c, 0xcb, 0x8d, 0xed, 0x68, 0x94, 0xcf, 0xb0,
      0xc3, 0x28, 0xcb, 0x54, 0x2b, 0xe0, 0x48, 0x5d, 0x86, 0x0c, 0xa7, 0x72,
      0x03, 0x08, 0x1f, 0x3b, 0x04, 0xc6, 0xf5, 0x5c, 0x56, 0x89, 0xb1, 0xa6,
      0x6b, 0x1c, 0x24, 0x81, 0x9a, 0x4a, 0x7e, 0xa5, 0x5f, 0x32, 0xe0, 0x0f,
      0x61, 0xac, 0xcf, 0x4b, 0x41, 0x1b, 0xb3, 0x20, 0xa9, 0x6c, 0x99, 0x01,
      0x73, 0xb6, 0x3c, 0xcd, 0x74, 0xe7, 0xda, 0x7d, 0xf5, 0xce, 0xaf, 0x33,
      0xa3, 0x9a, 0x8a, 0xcb, 0x89, 0xa8, 0x45, 0xa5, 0x94, 0xb1, 0x64, 0xec,
      0x6e, 0x22, 0xcc, 0xe9, 0x40, 0xeb, 0x06, 0xf2, 0xd4, 0x87, 0xa8, 0xbc,
      0x45, 0x74, 0x45, 0x18, 0x78, 0xc2, 0xbb, 0xf5, 0x7d, 0x24, 0x1f, 0x76,
      0x58, 0x6e, 0x07, 0x03, 0xbf, 0x5f, 0x86, 0xbe, 0xe8, 0x32, 0xd0, 0x5b,
      0x75, 0xfa, 0xba, 0xed, 0x6a, 0xcc, 0xad, 0xfc, 0x1e, 0xc2, 0xcd, 0x6e,
      0x61, 0x9d, 0xbb, 0x29, 0xb6, 0x5d, 0x6e, 0x6f, 0x5e, 0x11, 0x8a, 0xd5,
      0x2d, 0x82, 0xa9, 0x55, 0xd2, 0x10, 0x05, 0xec, 0xd6, 0x3f, 0xb3, 0x82,
      0xf3, 0x2b, 0xb8, 0xe2, 0xe1, 0xe5, 0x72, 0x20, 0xb3, 0x45, 0xcd, 0x64,
      0x22, 0xbd, 0xd8, 0x4a, 0x91, 0x49, 0x5d, 0x0a, 0xb5, 0x77, 0x5b, 0x08,
      0x13, 0x9e, 0xde, 0xe9, 0x60, 0xda, 0xb1, 0xb4, 0xff, 0xd9, 0xea, 0x5b,
      0x27, 0x39, 0x8b, 0x58, 0xe6, 0xe3, 0x52, 0x11, 0xc3, 0x58, 0x15, 0x01,
      0xe9, 0x9b, 0xf5, 0xe3, 0xf1, 0x7f, 0xd7, 0x93, 0x81, 0x52, 0x8d, 0x28,
      0xa4, 0x92, 0x7e, 0x28, 0x08, 0x2f, 0x45, 0xbf, 0xa9, 0x51, 0x9f, 0x98,
      0xea, 0x66, 0x3d, 0xc8, 0x4c, 0x50, 0x31, 0x7a, 0xdf, 0x0b, 0xd5, 0xda,
      0x98, 0xb0, 0x14, 0x59, 0x01, 0x1c, 0xec, 0x61, 0x80, 0x05, 0x34, 0xdd,
      0x5a, 0xfc, 0x5a, 0x56, 0x7c, 0x19, 0xe4, 0xa4, 0x00, 0xf0, 0x6d, 0xee,
      0x74, 0x11, 0x20, 0x83, 0xb5, 0x32, 0x26, 0x15, 0xc1, 0x44, 0xce, 0x3b},
     pub_key_2,
     {},
     true},

    // Comment:
    // tcID: 2
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     2,
     32,
     {0x8e, 0x10, 0xf2, 0x3f, 0x49, 0x01, 0x1d, 0x76, 0x19, 0x46, 0xb2, 0x83,
      0xd7, 0x15, 0x2e, 0x85, 0x1e, 0xe7, 0x6e, 0x5c, 0xaa, 0x17, 0x41, 0xb0,
      0x90, 0x1e, 0xea, 0x31, 0x7d, 0x89, 0x45, 0xf2, 0xa0, 0x36, 0x85, 0x51,
      0xb3, 0xf2, 0xb3, 0xa6, 0xa0, 0xd6, 0xa9, 0x39, 0xae, 0xbd, 0xed, 0x8f,
      0xea, 0x0a, 0x96, 0xdd, 0x1d, 0x03, 0x7b, 0xe3, 0x3b, 0x1c, 0x35, 0xce,
      0x78, 0xdc, 0x89, 0x69, 0x39, 0x18, 0xa9, 0x9d, 0x54, 0x7a, 0x1d, 0x89,
      0x2f, 0x40, 0x47, 0xc0, 0x9f, 0xff, 0x7a, 0x65, 0x23, 0xac, 0xb0, 0xcb,
      0x0c, 0xdd, 0xeb, 0xcd, 0x4a, 0x6f, 0xdc, 0xc3, 0x09, 0xa4, 0x66, 0xca,
      0x95, 0x80, 0xfe, 0xdf, 0x03, 0x2b, 0xf5, 0x61, 0x54, 0xf8, 0xd7, 0x9d,
      0x5c, 0x46, 0x86, 0xab, 0xfd, 0x2c, 0x7a, 0xbd, 0x34, 0x2b, 0x37, 0xe5,
      0x37, 0x3b, 0x59, 0xa0, 0x7f, 0xa8, 0x65, 0xb1, 0x18, 0xc4, 0x4f, 0x2c,
      0x44, 0xb8, 0x51, 0x30, 0x6d, 0xc9, 0x7e, 0xae, 0xeb, 0x63, 0x8f, 0x14,
      0xba, 0xfb, 0xb0, 0x9c, 0x81, 0x99, 0x6b, 0xea, 0xba, 0xae, 0xc2, 0x8c,
      0x19, 0xf0, 0x6f, 0xfd, 0x59, 0xdb, 0xe3, 0x08, 0x0e, 0x01, 0x24, 0xe2,
      0x38, 0x64, 0x18, 0x05, 0x27, 0x35, 0xf5, 0x41, 0xd4, 0x96, 0x32, 0x2c,
      0x03, 0xeb, 0xee, 0x6e, 0x4d, 0xca, 0xba, 0x24, 0xdd, 0xe9, 0x77, 0x2a,
      0x9f, 0x07, 0x99, 0x73, 0xdf, 0x26, 0xe8, 0x54, 0xc2, 0x55, 0xeb, 0x48,
      0xdf, 0x50, 0xc0, 0x1d, 0x49, 0x83, 0x1e, 0x54, 0xb6, 0x4d, 0x0f, 0xf8,
      0x62, 0xd0, 0x3f, 0xb4, 0xd8, 0x2f, 0xf2, 0x04, 0xd3, 0x03, 0xb5, 0x37,
      0x17, 0x6c, 0x50, 0xea, 0x56, 0x76, 0x1a, 0x83, 0xd0, 0xae, 0xd8, 0xed,
      0x2d, 0xee, 0xcb, 0xbb, 0xa9, 0x81, 0xc8, 0xaa, 0xcd, 0x13, 0x00, 0x05,
      0x1a, 0x86, 0x4d, 0x1e, 0xfd, 0xc8, 0x97, 0xf3, 0x13, 0x83, 0xcc, 0xd6,
      0xf1, 0x81, 0xbf, 0x97, 0x6a, 0x75, 0xe7, 0xa7, 0x61, 0x3b, 0x60, 0xb3,
      0xcb, 0x2a, 0x6f, 0x7a, 0xb8, 0x63, 0x6f, 0x67, 0x29, 0x90, 0xc1, 0x30,
      0x17, 0xf2, 0x98, 0x1c, 0x11, 0xba, 0x36, 0x09, 0x6c, 0xbe, 0xa8, 0x98,
      0xf0, 0x16, 0xc5, 0x81, 0xee, 0x85, 0x9e, 0x95, 0x0b, 0xec, 0x19, 0x5c,
      0xc4, 0xe3, 0x76, 0xe1, 0x34, 0x34, 0x1b, 0x2f, 0xd3, 0xe3, 0xd6, 0x18,
      0x1b, 0xa4, 0xd3, 0x77, 0xb2, 0xaa, 0xb6, 0xa1, 0x48, 0xc6, 0xea, 0x8c,
      0xca, 0x9e, 0xe3, 0x47, 0x82, 0x97, 0xe9, 0x01, 0x85, 0x6a, 0xb1, 0x8f,
      0x61, 0xc0, 0x23, 0x3c, 0x89, 0x98, 0x41, 0xe5, 0xda, 0x12, 0x55, 0x16,
      0xcf, 0x52, 0x74, 0xdc, 0x1b, 0x22, 0xe2, 0xa5, 0x1c, 0x92, 0x2d, 0xae,
      0xec, 0xcf, 0xad, 0x0f, 0x2a, 0x8b, 0xf8, 0x4e, 0x53, 0x1b, 0xc4, 0xf8},
     pub_key_2,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     true},

    // Comment:
    // tcID: 3
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     3,
     32,
     {0x22, 0x91, 0x5c, 0xfa, 0x1d, 0x7d, 0xd3, 0x0f, 0x50, 0xb4, 0xc0, 0xe4,
      0xce, 0xe4, 0x2c, 0x5f, 0x0a, 0xa1, 0xb7, 0xa6, 0x64, 0x4f, 0x8a, 0x11,
      0xe6, 0x11, 0xb2, 0xdb, 0x04, 0x2b, 0x12, 0x2a, 0xf8, 0x21, 0x1f, 0xfc,
      0x1d, 0xc2, 0x20, 0xb4, 0x35, 0xd8, 0x91, 0x9c, 0xf6, 0x4d, 0x71, 0x5b,
      0x54, 0xff, 0x8a, 0x76, 0x2f, 0x70, 0x2b, 0x36, 0x5c, 0xbd, 0xab, 0x45,
      0x55, 0x09, 0xb9, 0x7d, 0x9b, 0x31, 0x00, 0x11, 0x46, 0x7d, 0x41, 0x86,
      0x64, 0x7b, 0x95, 0x7e, 0x2e, 0xfa, 0x40, 0x4a, 0xed, 0x3b, 0x84, 0x84,
      0x05, 0x29, 0xbd, 0xef, 0x77, 0x46, 0x34, 0x83, 0x85, 0xa1, 0xc6, 0xa2,
      0xec, 0xdb, 0x88, 0xd1, 0xcc, 0x2b, 0x40, 0xb3, 0x6c, 0x34, 0x63, 0x86,
      0x73, 0x9c, 0x39, 0xd2, 0x81, 0x59, 0x38, 0xe4, 0x63, 0xa3, 0x53, 0x48,
      0x42, 0x6f, 0x17, 0xd3, 0x2d, 0x63, 0x3b, 0x87, 0x3d, 0x61, 0x24, 0xd8,
      0xb4, 0x9a, 0x72, 0x67, 0x43, 0xaf, 0x7c, 0x0e, 0x56, 0xd6, 0x33, 0x94,
      0x15, 0x5b, 0x63, 0x08, 0x9c, 0x63, 0xed, 0x88, 0x97, 0xf8, 0xaf, 0x2a,
      0x22, 0x60, 0xd3, 0x34, 0x99, 0xaf, 0xab, 0x11, 0xc9, 0x11, 0xfa, 0xa7,
      0x54, 0xce, 0xd5, 0xac, 0xda, 0xc2, 0xde, 0x57, 0x1f, 0x39, 0xc2, 0x76,
      0x87, 0x16, 0xe4, 0x30, 0x82, 0x44, 0xa9, 0x9d, 0x1e, 0x65, 0xda, 0x70,
      0x61, 0xd2, 0xfe, 0xb8, 0xec, 0x8b, 0x4e, 0x51, 0x7b, 0xd5, 0xe1, 0x9c,
      0xac, 0x62, 0x66, 0x98, 0x47, 0x9a, 0xb2, 0x01, 0x92, 0x57, 0xcf, 0x83,
      0xad, 0x7b, 0x64, 0x1d, 0xb2, 0x34, 0x5b, 0x38, 0x00, 0x6d, 0x63, 0xf8,
      0x4b, 0x41, 0x77, 0x2b, 0x90, 0x03, 0x77, 0x78, 0x38, 0x9c, 0xc3, 0x0e,
      0xd6, 0xab, 0xa6, 0xaf, 0x21, 0x2d, 0x93, 0x26, 0x79, 0x2a, 0xf7, 0x46,
      0xd7, 0xbc, 0xa9, 0x21, 0x1f, 0xa3, 0x44, 0xfd, 0xc2, 0x79, 0x8a, 0x49,
      0x0a, 0xed, 0x3a, 0x28, 0x40, 0x62, 0x0c, 0x2a, 0x85, 0xe3, 0xd9, 0xb9,
      0xc3, 0x8f, 0x23, 0x30, 0x07, 0x26, 0x63, 0xe1, 0x6d, 0xd2, 0x6b, 0xc4,
      0x14, 0xc7, 0xd6, 0x8f, 0x6b, 0x11, 0xd2, 0xcd, 0x3e, 0x03, 0x87, 0xc1,
      0x83, 0x4c, 0x5e, 0x22, 0x62, 0xa9, 0xe2, 0xdc, 0x1b, 0xf7, 0xc0, 0x10,
      0x8b, 0x4e, 0x20, 0x52, 0x56, 0x6c, 0x7a, 0x94, 0x1e, 0xf6, 0xb3, 0x8c,
      0x86, 0x87, 0xfd, 0x7a, 0xbe, 0x6a, 0xdd, 0x2b, 0x74, 0x5c, 0x2c, 0x2d,
      0x68, 0x0a, 0xe3, 0xe5, 0x64, 0x6c, 0xe2, 0xe7, 0x17, 0xef, 0x98, 0x99,
      0xc7, 0xf3, 0xfb, 0x1e, 0x30, 0x88, 0xe8, 0xc0, 0x58, 0x7d, 0x86, 0x54,
      0x6f, 0x75, 0x27, 0x71, 0x81, 0x95, 0x95, 0xa7, 0xa3, 0xd4, 0x22, 0x82,
      0x0c, 0xea, 0xa1, 0x2e, 0x3e, 0xe6, 0x71, 0xa4, 0x56, 0xda, 0xc6, 0x73},
     pub_key_2,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment:
    // tcID: 4
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     4,
     32,
     {0x8f, 0x9a, 0xc1, 0x35, 0x4a, 0xf4, 0x16, 0x1d, 0x0e, 0x55, 0xb5, 0x67,
      0x48, 0x21, 0xd0, 0x28, 0x23, 0xb3, 0xa6, 0xb3, 0xf7, 0x9c, 0xef, 0xb9,
      0x8c, 0xbc, 0x77, 0xf9, 0xac, 0x2d, 0x91, 0xcc, 0x63, 0x45, 0xf9, 0x89,
      0xa7, 0x82, 0x81, 0x32, 0xf7, 0x3f, 0x36, 0x30, 0xa2, 0x47, 0xa9, 0x36,
      0xb6, 0xa0, 0x57, 0xb3, 0xe5, 0xa2, 0xfd, 0xa0, 0xc5, 0x99, 0x9e, 0xa7,
      0x72, 0x1e, 0xe8, 0x88, 0x09, 0x60, 0xc2, 0x4c, 0xd2, 0x37, 0x7e, 0x86,
      0x9c, 0xca, 0x17, 0x99, 0x74, 0x71, 0x42, 0xd5, 0x7a, 0xd6, 0xa8, 0xd8,
      0x3e, 0xc9, 0x25, 0x4d, 0x89, 0xf5, 0x91, 0xad, 0xd1, 0x1a, 0x75, 0x8e,
      0x1e, 0xa1, 0xe2, 0x9b, 0xd0, 0x8f, 0x62, 0x4d, 0x0e, 0x28, 0xce, 0xa5,
      0x2e, 0xd5, 0xee, 0xd7, 0xc0, 0xf5, 0xf4, 0x9d, 0x35, 0x33, 0xeb, 0x1c,
      0xdb, 0xb2, 0xaf, 0x83, 0x7d, 0xc4, 0x29, 0x42, 0xf9, 0xa8, 0x6b, 0x5f,
      0x4e, 0x2d, 0x5c, 0xe5, 0x06, 0x69, 0x7e, 0xf0, 0x67, 0xa3, 0x44, 0x94,
      0x9b, 0xdd, 0x89, 0xaf, 0xcc, 0x25, 0x97, 0x8a, 0xf4, 0xd5, 0x0c, 0x30,
      0x0b, 0xcd, 0x0f, 0xfc, 0x9d, 0x93, 0xcc, 0x55, 0x9e, 0x3a, 0xe1, 0xa1,
      0x32, 0x15, 0xa1, 0xd3, 0xf6, 0x03, 0x08, 0x27, 0x34, 0x0c, 0x65, 0x91,
      0x06, 0x1a, 0x5a, 0xb7, 0xe6, 0x51, 0x53, 0xb1, 0xdf, 0x8b, 0x25, 0xe1,
      0x42, 0x1f, 0x92, 0x4d, 0x39, 0xc7, 0xe6, 0xf7, 0x62, 0x43, 0xc1, 0xbb,
      0x9a, 0xe4, 0x06, 0x3d, 0x9a, 0x47, 0x5c, 0xd2, 0xec, 0xe4, 0x5f, 0x4e,
      0x28, 0x8f, 0xe0, 0x72, 0x00, 0x74, 0xe8, 0x78, 0x68, 0xd7, 0x0a, 0x55,
      0x84, 0xa9, 0xac, 0x2b, 0x47, 0xa5, 0x64, 0x17, 0xcc, 0x76, 0xf1, 0x51,
      0x54, 0x31, 0x55, 0x45, 0xa3, 0xed, 0x67, 0x04, 0xb3, 0x65, 0xf1, 0x5d,
      0x34, 0x32, 0x08, 0x04, 0x46, 0x9c, 0x3b, 0x09, 0xed, 0x21, 0x1c, 0xbc,
      0x9e, 0x9e, 0x76, 0x7b, 0x6f, 0x21, 0xfa, 0x16, 0xf8, 0x64, 0x1d, 0x8b,
      0x78, 0xb8, 0xdf, 0xf8, 0x06, 0x2a, 0x25, 0xb5, 0xbd, 0x3b, 0x6a, 0x38,
      0xcb, 0x47, 0x06, 0xc4, 0x2c, 0x1f, 0xbb, 0xe6, 0x6d, 0xb1, 0xc0, 0x5c,
      0xb5, 0x75, 0x31, 0x13, 0x2e, 0xb9, 0x4f, 0xe1, 0x56, 0x97, 0x35, 0xc3,
      0x3e, 0xc4, 0x91, 0xc3, 0x18, 0xa6, 0x86, 0xc8, 0x37, 0xac, 0x81, 0x0b,
      0xe4, 0xaf, 0xff, 0x60, 0x5f, 0x92, 0xbb, 0x39, 0x0e, 0x7a, 0xb3, 0xcd,
      0x24, 0xc0, 0xcd, 0x99, 0x7c, 0xf1, 0x3f, 0x11, 0x2e, 0x5a, 0xa0, 0x17,
      0x46, 0xf4, 0x39, 0x02, 0x43, 0x26, 0x39, 0xe1, 0xee, 0xfc, 0xbd, 0x37,
      0xb4, 0x13, 0xc5, 0x86, 0xf0, 0x57, 0xbc, 0xba, 0x40, 0xa8, 0xf1, 0x25,
      0x12, 0x51, 0xe8, 0x4c, 0xb7, 0xc8, 0x7c, 0x53, 0xc1, 0xd1, 0xd5, 0x58},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment:
    // tcID: 5
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     5,
     32,
     {0x6e, 0x47, 0x1c, 0x93, 0x42, 0xaa, 0xa2, 0x7b, 0xdd, 0xf6, 0x4b, 0x02,
      0xe8, 0x80, 0x56, 0x11, 0xa1, 0x37, 0x70, 0xb2, 0x2c, 0xc3, 0xd2, 0x4c,
      0xdf, 0xa9, 0xa2, 0xfc, 0x14, 0x86, 0x5f, 0x59, 0x34, 0x4c, 0x28, 0x8c,
      0xf1, 0x5d, 0x4c, 0x87, 0x85, 0x08, 0x99, 0x68, 0xa1, 0x2e, 0x9d, 0x3e,
      0x63, 0xb8, 0x17, 0x94, 0x89, 0x56, 0x87, 0x43, 0x44, 0x8f, 0x69, 0x8f,
      0x31, 0x66, 0x40, 0x14, 0x63, 0x22, 0xef, 0x3b, 0x61, 0x1f, 0xc9, 0x83,
      0x96, 0xcf, 0x4a, 0x47, 0x57, 0xe4, 0x8c, 0xe6, 0x70, 0x1f, 0x12, 0x3f,
      0xc0, 0xbb, 0x8d, 0xf8, 0x0b, 0x63, 0xcd, 0x23, 0x71, 0x52, 0x2f, 0x8e,
      0xd9, 0x29, 0xf7, 0xbd, 0xb7, 0x09, 0xd4, 0x24, 0xaf, 0x6e, 0xab, 0x2e,
      0xab, 0x21, 0x2b, 0x43, 0xaf, 0xe5, 0x37, 0xfe, 0xc7, 0xbb, 0xb9, 0xdd,
      0x02, 0xe6, 0x4f, 0x11, 0x6e, 0x02, 0xad, 0x12, 0x14, 0xae, 0x93, 0x1a,
      0x6f, 0xe2, 0x8a, 0x59, 0x82, 0x02, 0x90, 0x88, 0xa2, 0x7b, 0xb9, 0x5e,
      0xf2, 0xee, 0x46, 0xad, 0x21, 0x20, 0x83, 0x71, 0x93, 0x27, 0xac, 0xab,
      0x5e, 0xe5, 0x1c, 0x82, 0xd9, 0x4d, 0x5b, 0x14, 0xf6, 0xdf, 0xfd, 0x22,
      0x42, 0xdd, 0xf9, 0xfb, 0xbb, 0x2d, 0x03, 0xf9, 0x45, 0x79, 0x6a, 0x3e,
      0x35, 0x34, 0x6f, 0x23, 0x34, 0xca, 0x6b, 0x4e, 0xc5, 0xd9, 0xed, 0x6f,
      0x15, 0x84, 0x68, 0x8e, 0x66, 0x19, 0x51, 0xe9, 0x48, 0xcb, 0x95, 0xfc,
      0x5c, 0xc0, 0x4e, 0x90, 0xca, 0xd9, 0x8c, 0x86, 0x1d, 0xdf, 0xf5, 0x14,
      0xc6, 0x02, 0x75, 0x65, 0x0a, 0xe3, 0x00, 0x31, 0x85, 0xef, 0xe0, 0xc0,
      0x43, 0x56, 0xb0, 0x7f, 0x36, 0x1f, 0x7d, 0xc7, 0xe1, 0x7c, 0x5d, 0xe4,
      0x79, 0xcb, 0xf1, 0x19, 0xc2, 0x91, 0x0a, 0xaf, 0xfa, 0x03, 0x2a, 0xaa,
      0x81, 0xec, 0x9e, 0xb9, 0xf7, 0xe1, 0xad, 0x21, 0xa4, 0x10, 0xff, 0xce,
      0x25, 0x02, 0xe4, 0x82, 0x94, 0x04, 0xd0, 0x1a, 0xe0, 0x90, 0xef, 0x28,
      0x9b, 0xc2, 0x8c, 0x9c, 0x3f, 0x37, 0xd3, 0xfc, 0xae, 0x33, 0xe1, 0x52,
      0x3b, 0x3c, 0x9b, 0x81, 0xe3, 0x01, 0xf5, 0x1d, 0x04, 0x61, 0x96, 0xfc,
      0x15, 0xc9, 0x0d, 0x58, 0xbd, 0x35, 0xa1, 0xfb, 0x11, 0xfa, 0x04, 0x62,
      0x1b, 0x32, 0xcb, 0x61, 0xe7, 0x18, 0xa4, 0x34, 0xa0, 0xaa, 0xef, 0xcb,
      0x67, 0x6c, 0xbc, 0xa8, 0x88, 0x55, 0x4d, 0x1e, 0x84, 0xd4, 0x3b, 0x10,
      0x8f, 0xc1, 0xcb, 0x12, 0x3c, 0xd2, 0xd3, 0x00, 0xda, 0x63, 0x0f, 0xb7,
      0x7a, 0x3c, 0xe2, 0x9a, 0x0f, 0x53, 0xaf, 0x32, 0xa5, 0xce, 0x81, 0xc5,
      0xad, 0x77, 0x2a, 0x19, 0x9d, 0x11, 0x80, 0xa9, 0xe2, 0xf0, 0x90, 0x84,
      0x7c, 0xd8, 0x7d, 0xdf, 0x7b, 0x39, 0xae, 0xec, 0x89, 0xa6, 0xb4, 0x92},
     pub_key_2,
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment:
    // tcID: 6
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     6,
     32,
     {0x39, 0xf7, 0xdc, 0x90, 0x10, 0xbf, 0x3c, 0x20, 0x0d, 0xf5, 0x51, 0x49,
      0x94, 0x04, 0xca, 0x40, 0x34, 0x6e, 0x58, 0xce, 0x0c, 0x56, 0x27, 0x1e,
      0x2e, 0xb7, 0x83, 0x51, 0x87, 0xae, 0x57, 0xa7, 0xb9, 0xa0, 0x68, 0x8c,
      0x9b, 0x08, 0x8a, 0xd8, 0x5e, 0x12, 0x8f, 0x56, 0xc0, 0x29, 0x9c, 0x43,
      0x7a, 0x1a, 0x9a, 0x91, 0x04, 0xf3, 0xf5, 0x1a, 0xab, 0x70, 0x43, 0xd5,
      0x71, 0x49, 0x63, 0xe4, 0x6a, 0xce, 0x5d, 0x8e, 0x43, 0x5f, 0xd3, 0xe4,
      0x16, 0xdd, 0x61, 0x47, 0x4e, 0x9d, 0xca, 0xc3, 0xff, 0xa6, 0xc3, 0xf0,
      0xeb, 0xc4, 0xad, 0xa9, 0x87, 0xc4, 0x31, 0x3e, 0xc3, 0x6f, 0x2c, 0x43,
      0xd2, 0xdc, 0x74, 0x9e, 0x49, 0x6f, 0xbf, 0xad, 0x63, 0x9d, 0xc8, 0x11,
      0x30, 0x43, 0x88, 0x99, 0x0b, 0x98, 0xcf, 0x10, 0xff, 0x61, 0x6a, 0x86,
      0x6b, 0xf5, 0xd9, 0x8c, 0xd5, 0x19, 0x9b, 0xb7, 0x47, 0x04, 0xae, 0x4e,
      0xf3, 0x65, 0x42, 0x41, 0x30, 0x73, 0x8b, 0x9d, 0x81, 0xf8, 0x93, 0xa5,
      0xe2, 0x31, 0x6e, 0xe6, 0xda, 0xea, 0x18, 0x5c, 0x17, 0x0f, 0x69, 0xeb,
      0xd2, 0xad, 0x45, 0x5b, 0x56, 0x67, 0x6e, 0xbd, 0xa9, 0xd0, 0xbb, 0x0b,
      0xf4, 0xd3, 0x35, 0x74, 0x75, 0xed, 0x81, 0x66, 0xa3, 0xd2, 0xdf, 0xe6,
      0xe0, 0x93, 0xc3, 0xa4, 0xbc, 0x5b, 0xc2, 0xfc, 0x22, 0x75, 0xe6, 0x77,
      0x9d, 0x80, 0x91, 0x07, 0xb6, 0x21, 0x13, 0x8f, 0xc6, 0x29, 0xa6, 0x76,
      0x7d, 0x58, 0x09, 0xc8, 0x5b, 0xf8, 0x8b, 0x46, 0xb1, 0x4a, 0x8e, 0x4e,
      0xe9, 0xe3, 0x10, 0xdb, 0x74, 0x6f, 0x4c, 0x0a, 0x79, 0xa3, 0xd3, 0x6f,
      0x6e, 0x30, 0x51, 0x25, 0x64, 0x2d, 0xbf, 0x82, 0x34, 0x74, 0xfb, 0x91,
      0x3a, 0x99, 0x67, 0xa6, 0xd1, 0x20, 0xe8, 0x2a, 0x79, 0xac, 0xe4, 0x8c,
      0x50, 0x1f, 0xed, 0x8d, 0xd6, 0xed, 0xb9, 0x63, 0x4d, 0xf9, 0x09, 0xfe,
      0x67, 0x75, 0xf8, 0xf6, 0xfc, 0x5b, 0x79, 0xf5, 0x88, 0x1e, 0x1f, 0x13,
      0xb7, 0xcd, 0xe3, 0x7c, 0x7c, 0x3f, 0x97, 0x31, 0x9c, 0xd6, 0x12, 0xf8,
      0xad, 0x2b, 0x1a, 0xc9, 0x21, 0x07, 0x9f, 0x18, 0x21, 0x3e, 0x5f, 0xac,
      0xba, 0x0b, 0x83, 0xc1, 0x78, 0x87, 0xe6, 0x95, 0x01, 0xa6, 0xd2, 0xeb,
      0x37, 0x66, 0x1f, 0x03, 0x59, 0x0a, 0xf1, 0xa1, 0x56, 0x46, 0x16, 0x5e,
      0xb7, 0x85, 0xf4, 0x67, 0xca, 0xd0, 0xc6, 0x25, 0x94, 0x7e, 0x8a, 0x8a,
      0x4a, 0x68, 0xf8, 0x93, 0x80, 0x77, 0xd5, 0xef, 0x7f, 0x1b, 0x8b, 0x4d,
      0xa0, 0xd0, 0x9a, 0xd5, 0x87, 0x4b, 0xcb, 0x22, 0xcc, 0xc4, 0xee, 0x36,
      0xb9, 0x34, 0x1b, 0x97, 0x4a, 0x51, 0xa1, 0xd6, 0xca, 0x00, 0x9d, 0xed,
      0x4a, 0xce, 0x9f, 0xaa, 0x99, 0xd9, 0x24, 0xa2, 0x34, 0x21, 0xaa, 0xbb},
     pub_key_2,
     {0x61},
     true},

    // Comment:
    // tcID: 7
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     7,
     32,
     {0xae, 0x84, 0x72, 0xe9, 0x87, 0x80, 0x6e, 0x51, 0x10, 0xbe, 0xae, 0x33,
      0x00, 0x56, 0xff, 0x97, 0x4a, 0xbf, 0xce, 0x7e, 0xa9, 0x92, 0x79, 0x79,
      0xcd, 0xd1, 0x43, 0x46, 0x74, 0x74, 0x14, 0xcd, 0xce, 0x06, 0xa9, 0xc7,
      0x8e, 0xb1, 0x84, 0x6c, 0x75, 0xdc, 0x28, 0x8d, 0x7d, 0xa5, 0x31, 0x53,
      0x1d, 0xa4, 0x9b, 0xa7, 0x65, 0x1d, 0x3a, 0x1f, 0x79, 0xe3, 0x29, 0x7f,
      0xe3, 0x7a, 0xa7, 0x3e, 0x07, 0x5c, 0xfe, 0x5a, 0xc0, 0x04, 0xb1, 0x66,
      0x52, 0x6c, 0xba, 0x55, 0xf9, 0x14, 0xe0, 0xd2, 0xfb, 0x1f, 0x12, 0xa6,
      0x0a, 0x32, 0x22, 0xda, 0xc4, 0x34, 0xfa, 0x37, 0x8c, 0x2e, 0x7b, 0x0e,
      0xa9, 0xc2, 0xcb, 0x5e, 0x22, 0xcc, 0x34, 0x3e, 0xa6, 0x24, 0xad, 0x6c,
      0xf5, 0x54, 0x5a, 0x61, 0x36, 0x4c, 0xd6, 0x7d, 0x6d, 0xc2, 0x3d, 0x22,
      0xe4, 0x88, 0x8a, 0x25, 0x3e, 0x94, 0x0f, 0xf0, 0xe0, 0xce, 0x02, 0x07,
      0xc1, 0xfe, 0xed, 0xcc, 0xdf, 0xa1, 0x0f, 0x50, 0xd2, 0x36, 0x3b, 0xdb,
      0xdf, 0x10, 0x89, 0x3e, 0x39, 0x67, 0xd7, 0x55, 0x5f, 0xba, 0x15, 0x7f,
      0x9a, 0x45, 0x0d, 0x6b, 0xbe, 0x63, 0xff, 0x31, 0x77, 0x7b, 0xdf, 0xd4,
      0x02, 0xaf, 0xa7, 0x2c, 0x3a, 0x21, 0x81, 0xe5, 0xcc, 0x02, 0x54, 0x43,
      0xce, 0xc3, 0x0d, 0x25, 0x36, 0x53, 0xdb, 0x7e, 0x82, 0xeb, 0x7d, 0xd4,
      0x88, 0xe6, 0x49, 0x1f, 0xd2, 0x50, 0x01, 0x72, 0x3e, 0xae, 0x2e, 0x31,
      0x06, 0xc7, 0xb5, 0x0c, 0x2b, 0x73, 0xc1, 0x42, 0xa4, 0xa3, 0x1e, 0xc4,
      0x3e, 0xdc, 0x9e, 0xc9, 0x01, 0x13, 0x83, 0xc9, 0x9a, 0x09, 0x5b, 0x36,
      0x25, 0x8a, 0x0a, 0x77, 0xaa, 0xc2, 0xaf, 0x19, 0xb2, 0x6a, 0xf8, 0xa1,
      0x66, 0xb1, 0x30, 0xf7, 0xf5, 0x7f, 0x03, 0xa0, 0xe8, 0x00, 0x7d, 0x5a,
      0xc0, 0xee, 0xa9, 0xec, 0xbe, 0x14, 0xfb, 0x78, 0x85, 0x53, 0x8a, 0x22,
      0xc1, 0x3d, 0xe5, 0x77, 0x1b, 0xfd, 0xf5, 0x23, 0xfe, 0xf9, 0xc9, 0xb5,
      0xf5, 0x2e, 0xbc, 0x2a, 0xf7, 0x90, 0x2a, 0x0b, 0xaf, 0x2a, 0x33, 0x92,
      0x3b, 0x0d, 0x06, 0x22, 0xb8, 0xfd, 0x5c, 0x93, 0x82, 0x14, 0xae, 0xa4,
      0xb9, 0xe7, 0xf0, 0xa6, 0x47, 0xc5, 0x52, 0x0c, 0x3a, 0x94, 0xa2, 0x97,
      0x37, 0xb9, 0x5c, 0xc6, 0x23, 0xf2, 0x0b, 0xba, 0x8e, 0xaa, 0x3e, 0x9d,
      0xb6, 0x01, 0x16, 0xfe, 0x17, 0x60, 0xd9, 0xb7, 0xac, 0x18, 0x41, 0xe7,
      0x58, 0x6a, 0xec, 0x97, 0x08, 0x21, 0x2a, 0x5b, 0xef, 0x2f, 0xf6, 0x7c,
      0x74, 0x46, 0x28, 0x83, 0x06, 0x2e, 0x05, 0x2a, 0xb9, 0xfd, 0x90, 0xff,
      0xca, 0x0f, 0x0a, 0x61, 0x66, 0xb7, 0x1a, 0x93, 0xbd, 0x28, 0x9a, 0x1d,
      0x4a, 0xcd, 0x2d, 0x6c, 0xe7, 0x2a, 0xe0, 0xb9, 0x1c, 0xdd, 0xe7, 0x2e},
     pub_key_2,
     {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
      0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5,
      0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff},
     true},

    // Comment:
    // tcID: 8
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     8,
     32,
     {0x5c, 0xe9, 0x90, 0x63, 0xbb, 0x6c, 0x6b, 0xf8, 0xe4, 0x67, 0x72, 0xe8,
      0x70, 0x1b, 0x63, 0xab, 0xb2, 0xfe, 0xb5, 0xf8, 0x8c, 0x5b, 0x76, 0xb7,
      0x6c, 0x00, 0xc7, 0x19, 0x40, 0x2c, 0xcb, 0x39, 0x9d, 0x6c, 0x6d, 0x8c,
      0x67, 0xed, 0x5b, 0x6f, 0xb0, 0xf1, 0xdf, 0xeb, 0x8f, 0x8d, 0xcc, 0x5b,
      0xae, 0x03, 0xad, 0x57, 0xc1, 0xb0, 0xf5, 0x30, 0x33, 0xdd, 0x25, 0x03,
      0xb9, 0x60, 0x4f, 0xdc, 0x40, 0xeb, 0xa5, 0x1e, 0x4b, 0x03, 0xc9, 0x1a,
      0x8d, 0x12, 0xb1, 0xa3, 0xb9, 0x29, 0xb1, 0xff, 0x1e, 0x8e, 0x79, 0xcb,
      0x58, 0xd7, 0x88, 0x11, 0x4d, 0x53, 0xf7, 0xe0, 0x7d, 0x87, 0xa8, 0x85,
      0xf6, 0xdd, 0x4d, 0x26, 0x56, 0x05, 0x83, 0x98, 0x6f, 0x7a, 0x84, 0xdc,
      0x46, 0x6b, 0xa9, 0x81, 0xdb, 0x06, 0xbe, 0xdd, 0xb1, 0xfa, 0x80, 0xb0,
      0xa4, 0x44, 0xb9, 0xa5, 0x6c, 0x82, 0xf9, 0x8a, 0x92, 0x79, 0x77, 0xda,
      0x9f, 0xa1, 0xca, 0x83, 0xae, 0xba, 0xf2, 0xc4, 0x36, 0x92, 0xce, 0xf6,
      0x1b, 0x12, 0x99, 0x5d, 0x8d, 0xd0, 0xf3, 0xbd, 0x6b, 0xf0, 0x61, 0x02,
      0x5d, 0xdd, 0x34, 0xaf, 0x3e, 0x02, 0x57, 0x20, 0x33, 0x90, 0xa8, 0x07,
      0x65, 0xef, 0x70, 0x6a, 0xcf, 0x7d, 0xf6, 0xf4, 0x32, 0x10, 0xa7, 0x92,
      0x86, 0x73, 0xd2, 0x60, 0xf2, 0xf3, 0xc3, 0x0a, 0x9b, 0xba, 0x9b, 0x08,
      0x73, 0x5d, 0xd9, 0xaa, 0x3f, 0xf2, 0xfc, 0x27, 0xa2, 0xee, 0x9e, 0x13,
      0x0c, 0x88, 0xba, 0x36, 0x7c, 0x3d, 0x14, 0x28, 0xf1, 0x73, 0xea, 0x08,
      0xe2, 0x73, 0x88, 0x6b, 0xc1, 0x53, 0xc1, 0x1e, 0x24, 0xb0, 0x5c, 0xdb,
      0xf9, 0xb0, 0x05, 0x73, 0xb0, 0x13, 0x17, 0x04, 0x17, 0xfd, 0x96, 0xb0,
      0x10, 0x6f, 0x72, 0xc0, 0x73, 0xf1, 0x21, 0x6b, 0xa8, 0x72, 0xec, 0xcc,
      0x9f, 0x56, 0xff, 0x9e, 0x3e, 0x08, 0xbf, 0xde, 0x64, 0x04, 0x1d, 0x99,
      0x6b, 0x11, 0x7a, 0x11, 0x4b, 0x72, 0x3c, 0xd9, 0x7f, 0x70, 0xe0, 0x70,
      0x68, 0xec, 0xe6, 0x43, 0xf5, 0x8d, 0x5e, 0xe5, 0xca, 0xdc, 0xa7, 0xe2,
      0x4a, 0x18, 0xb0, 0xa6, 0x6a, 0xb7, 0x24, 0xfb, 0x65, 0x3a, 0x01, 0xc5,
      0x74, 0x9d, 0x51, 0xd4, 0xbf, 0x54, 0x08, 0xd2, 0xd2, 0x00, 0x8b, 0x30,
      0xeb, 0x3d, 0xc2, 0x0b, 0x0e, 0x14, 0x51, 0x0c, 0x06, 0x40, 0x2f, 0x78,
      0x92, 0x76, 0xb6, 0x23, 0x78, 0x02, 0xd6, 0x08, 0xab, 0x49, 0x37, 0x80,
      0x01, 0xed, 0x6f, 0x36, 0x04, 0xab, 0xca, 0x03, 0x8e, 0x3c, 0x7e, 0x05,
      0x7d, 0x95, 0xe8, 0x5c, 0x9e, 0x66, 0x8f, 0x39, 0x7b, 0xcc, 0xe1, 0x87,
      0x65, 0x13, 0x21, 0x42, 0xd6, 0xb0, 0xf1, 0x18, 0xc5, 0x11, 0xe5, 0x7d,
      0xef, 0xcb, 0x31, 0x6f, 0xe4, 0x1d, 0xec, 0x06, 0xb9, 0x88, 0xd9, 0x11},
     pub_key_2,
     {0x34, 0x32, 0x36, 0x34, 0x37, 0x39, 0x37, 0x32, 0x34},
     true},

    // Comment:
    // tcID: 9
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     9,
     32,
     {0xa7, 0xe0, 0xad, 0x7e, 0xc6, 0x4a, 0x60, 0x0e, 0x37, 0xb7, 0x0d, 0xca,
      0xba, 0x90, 0x36, 0xbb, 0x3e, 0xa9, 0x55, 0x08, 0xc9, 0x61, 0x66, 0x8c,
      0x4e, 0x05, 0x1c, 0x8f, 0x3f, 0xaa, 0x45, 0x44, 0x96, 0xce, 0x6c, 0x00,
      0x9a, 0xe9, 0xcf, 0xea, 0xa2, 0xc1, 0x94, 0xc5, 0xc9, 0x27, 0x8e, 0x46,
      0xb7, 0x5b, 0xab, 0x40, 0xc5, 0x2f, 0x07, 0x7a, 0x4f, 0xea, 0x17, 0x5b,
      0x26, 0x79, 0x12, 0x1d, 0x30, 0xb7, 0x06, 0x13, 0x9c, 0xde, 0x7a, 0xb5,
      0x71, 0xc8, 0x9f, 0x4d, 0x19, 0xab, 0xe0, 0x7c, 0x67, 0xc7, 0x0a, 0xfd,
      0x3e, 0x4c, 0x2c, 0x05, 0xd6, 0x0c, 0x92, 0xbb, 0x2a, 0x63, 0x9b, 0xa3,
      0x89, 0x82, 0x60, 0x88, 0x89, 0x96, 0x05, 0xf1, 0x70, 0x7e, 0xca, 0xcd,
      0x88, 0xe4, 0x24, 0x91, 0xde, 0xbc, 0x78, 0x29, 0x5b, 0x44, 0xf4, 0xe0,
      0x97, 0x91, 0xf9, 0xd5, 0x41, 0x82, 0x3a, 0xd5, 0xc4, 0x89, 0x52, 0xbd,
      0x31, 0x51, 0xef, 0x98, 0xac, 0xe7, 0xe2, 0x51, 0xd1, 0x2e, 0xbc, 0xc9,
      0x37, 0x0b, 0xc2, 0x05, 0xa1, 0x68, 0x8c, 0x9a, 0x5e, 0x91, 0x90, 0xcd,
      0x08, 0x2d, 0xa1, 0xae, 0x94, 0xf2, 0x2e, 0xb2, 0xb0, 0xb4, 0x6b, 0x2a,
      0x5e, 0xb2, 0x27, 0x3b, 0x0b, 0x32, 0x42, 0x15, 0xde, 0x18, 0x7d, 0x68,
      0x54, 0x71, 0xa0, 0x7f, 0x67, 0x3d, 0x43, 0xe5, 0x8f, 0x36, 0xc1, 0xe0,
      0xf0, 0x74, 0x76, 0x5d, 0xc5, 0x9c, 0x1e, 0xbc, 0xe4, 0x49, 0x22, 0x93,
      0x61, 0xd0, 0x75, 0x22, 0xc7, 0xf0, 0x3f, 0x27, 0xed, 0xa5, 0x7a, 0xb8,
      0xbc, 0x89, 0xac, 0x68, 0x3d, 0x27, 0xff, 0x4f, 0x95, 0xa3, 0x28, 0x89,
      0x25, 0x07, 0x95, 0x2f, 0x14, 0xd9, 0xe3, 0xd8, 0x64, 0x3d, 0x80, 0x5c,
      0x32, 0x7e, 0xef, 0x8b, 0xdf, 0x13, 0xab, 0x7e, 0x66, 0x34, 0xa1, 0x03,
      0xfe, 0x92, 0xcb, 0xe9, 0xe7, 0xb0, 0x0f, 0x9b, 0xdf, 0x8e, 0xfa, 0x74,
      0x08, 0x66, 0xc0, 0x44, 0x73, 0x57, 0x99, 0xd5, 0x92, 0x45, 0xaa, 0xfb,
      0x8d, 0x04, 0xe8, 0xbd, 0x55, 0xb6, 0x6f, 0xea, 0x31, 0xc9, 0xfc, 0xe4,
      0xce, 0xdd, 0x4a, 0xbe, 0x68, 0x44, 0x4f, 0xc8, 0xa6, 0xdd, 0x55, 0x0c,
      0x3c, 0x8f, 0x1d, 0x65, 0x97, 0xbd, 0xe0, 0x01, 0xfb, 0x97, 0x7b, 0x78,
      0x02, 0xe0, 0x26, 0x3b, 0x73, 0x19, 0xad, 0x7a, 0x6c, 0x1c, 0x4a, 0x6c,
      0x55, 0x87, 0x74, 0x64, 0x1b, 0x20, 0x4b, 0x6d, 0x3e, 0xb2, 0xa2, 0xae,
      0xed, 0xbf, 0x4a, 0x38, 0xde, 0x65, 0x84, 0x03, 0x11, 0x02, 0xa1, 0x95,
      0x8f, 0xab, 0x6f, 0xbe, 0xa9, 0x97, 0x67, 0x93, 0xbd, 0x1e, 0xa6, 0xc9,
      0xae, 0xaa, 0xfe, 0x81, 0x51, 0x5b, 0x95, 0x4c, 0x76, 0x15, 0xf8, 0xc4,
      0x55, 0x38, 0xf4, 0x0a, 0x22, 0xad, 0xf0, 0xce, 0x6f, 0x2c, 0x97, 0x7d},
     pub_key_2,
     {0x37, 0x31, 0x33, 0x38, 0x36, 0x38, 0x34, 0x38, 0x39, 0x31},
     true},

    // Comment:
    // tcID: 10
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     10,
     32,
     {0x6c, 0x60, 0x10, 0x7d, 0xd1, 0x82, 0xd5, 0xcb, 0xf4, 0x55, 0x0e, 0x7a,
      0x6e, 0x3a, 0x65, 0x2f, 0x73, 0x15, 0x03, 0xd8, 0xfa, 0xfb, 0xa3, 0xa7,
      0xaa, 0x52, 0xe7, 0xac, 0x93, 0xd4, 0xde, 0x4e, 0x03, 0xd9, 0x11, 0xe0,
      0x58, 0xad, 0xe4, 0x48, 0x28, 0x5b, 0xb9, 0xc3, 0x45, 0x2b, 0x60, 0x89,
      0x7c, 0x09, 0x9f, 0xd4, 0xba, 0x22, 0xff, 0x41, 0x94, 0xee, 0xf1, 0xa3,
      0xfc, 0xc3, 0x25, 0x0c, 0xb9, 0xae, 0x27, 0x0c, 0x33, 0xee, 0x76, 0x7b,
      0x2b, 0x4f, 0x18, 0x85, 0x26, 0x12, 0xe2, 0x7c, 0x4a, 0xb3, 0x1d, 0x8e,
      0xa6, 0xcc, 0xbf, 0x12, 0x2a, 0x35, 0x7a, 0x6d, 0x6e, 0x52, 0x71, 0x91,
      0xa3, 0x6e, 0x0a, 0xa2, 0xaa, 0x92, 0x5f, 0x68, 0xe1, 0x58, 0xc8, 0xd5,
      0xde, 0xcf, 0xbf, 0x84, 0x84, 0xd1, 0x6c, 0x2c, 0xe9, 0x06, 0x82, 0x6d,
      0xc4, 0x77, 0x3d, 0x59, 0xfd, 0x1a, 0x40, 0x32, 0xc2, 0xf5, 0x76, 0xa1,
      0xae, 0x83, 0x74, 0xa1, 0x3c, 0xc2, 0x4a, 0xbe, 0x15, 0xac, 0x14, 0x03,
      0x45, 0x2a, 0xc7, 0xcd, 0x8a, 0x64, 0x3d, 0xfe, 0x18, 0xc9, 0x11, 0xae,
      0x34, 0xf7, 0x73, 0x52, 0x0f, 0xa9, 0x44, 0x72, 0xc5, 0x96, 0xdb, 0xd6,
      0xf5, 0xb9, 0x32, 0x27, 0x95, 0x1e, 0xbb, 0xcb, 0xac, 0xf6, 0x0b, 0x18,
      0xe5, 0xa6, 0x03, 0x30, 0xeb, 0xa9, 0xbc, 0xe0, 0xd8, 0xa7, 0x32, 0xcf,
      0xc2, 0x7c, 0x7c, 0x0b, 0x9e, 0x22, 0x07, 0x06, 0x70, 0xa1, 0x65, 0x84,
      0x6d, 0x9d, 0x7e, 0x9b, 0x24, 0xdc, 0x6e, 0xe9, 0x75, 0x93, 0x47, 0xf5,
      0xc6, 0x32, 0x0b, 0x63, 0x78, 0x9d, 0x5c, 0xcb, 0xe9, 0x56, 0x6d, 0x9f,
      0x3c, 0x53, 0x4e, 0x15, 0x2f, 0x26, 0x86, 0x63, 0x1a, 0x41, 0xaa, 0x85,
      0x80, 0x1a, 0x31, 0xa7, 0xf3, 0x1c, 0xab, 0xf9, 0x59, 0xcd, 0xc9, 0x37,
      0x55, 0xa3, 0xac, 0xdf, 0xcf, 0x0d, 0xdb, 0xbc, 0x52, 0x98, 0xe9, 0x1f,
      0xbb, 0xb2, 0x67, 0x55, 0x65, 0x91, 0x2e, 0x5f, 0xd9, 0x5c, 0xd5, 0x9b,
      0x57, 0x44, 0x83, 0x32, 0x22, 0x24, 0x7a, 0xaa, 0xa5, 0xa5, 0x86, 0x8d,
      0xa4, 0xd1, 0xd1, 0xaf, 0x59, 0x0b, 0x86, 0x33, 0xdf, 0xe6, 0x10, 0x5e,
      0x0a, 0x6a, 0xbd, 0xed, 0x24, 0x97, 0xac, 0x7e, 0x46, 0x65, 0x04, 0x32,
      0xcb, 0xf0, 0xb7, 0x84, 0xb9, 0x44, 0x77, 0x70, 0xb2, 0x0f, 0x75, 0xb2,
      0x61, 0x8f, 0xb7, 0xe6, 0xcc, 0x6f, 0xc5, 0xca, 0xdb, 0x02, 0x29, 0x80,
      0xf7, 0x89, 0x43, 0xfa, 0x9f, 0x78, 0x4e, 0x5f, 0x0c, 0x8f, 0xb5, 0x19,
      0x22, 0x39, 0xdb, 0xd3, 0x29, 0x3a, 0x38, 0xe6, 0xda, 0xde, 0x27, 0xa0,
      0x7e, 0x08, 0xb5, 0x45, 0x97, 0x02, 0x9f, 0x92, 0xa8, 0xb2, 0x9b, 0x70,
      0x0f, 0x84, 0x2f, 0xda, 0x55, 0xae, 0xb3, 0xe0, 0xdd, 0xa7, 0x94, 0x05},
     pub_key_2,
     {0x31, 0x30, 0x33, 0x35, 0x39, 0x33, 0x33, 0x31, 0x36, 0x36, 0x38},
     true},

    // Comment:
    // tcID: 11
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     11,
     32,
     {0x22, 0x64, 0xd2, 0x76, 0xcc, 0xe2, 0x2a, 0xec, 0x8d, 0x10, 0x9c, 0xed,
      0x7a, 0x04, 0x8e, 0xa4, 0x4d, 0x62, 0x7a, 0xee, 0x57, 0x7f, 0x11, 0x17,
      0x99, 0x83, 0x16, 0xaf, 0x91, 0x1e, 0x98, 0x13, 0x90, 0x85, 0xbc, 0x92,
      0xf1, 0x20, 0x82, 0x7b, 0x30, 0x4c, 0x4c, 0xa5, 0x19, 0x74, 0x3a, 0x33,
      0xf7, 0xbe, 0x05, 0xd8, 0xa4, 0x9a, 0x28, 0xcd, 0x71, 0x6c, 0xa6, 0x5f,
      0x6b, 0x97, 0x65, 0x13, 0xb3, 0x3a, 0x44, 0x0b, 0x6e, 0x8e, 0xc5, 0xda,
      0xeb, 0x85, 0xd6, 0xa5, 0x92, 0x6d, 0xc5, 0x01, 0x5a, 0x2d, 0x24, 0xd9,
      0x4f, 0xf1, 0xf8, 0x7a, 0x07, 0x38, 0x67, 0xbe, 0xa1, 0x37, 0xa7, 0x21,
      0x72, 0x54, 0xb9, 0xbd, 0x04, 0x02, 0x73, 0x66, 0x4c, 0x58, 0xd6, 0x1e,
      0x61, 0x8a, 0xce, 0x6b, 0xc9, 0x42, 0xc4, 0x46, 0x40, 0x1c, 0x72, 0x15,
      0x65, 0xf7, 0x4f, 0xad, 0x5b, 0xf3, 0x14, 0x75, 0x09, 0x37, 0x52, 0xe3,
      0xa6, 0x7f, 0xb3, 0x22, 0x31, 0xec, 0x8d, 0x26, 0x64, 0x95, 0x94, 0xf3,
      0x2c, 0x5d, 0x45, 0x3f, 0x0b, 0xaa, 0xe5, 0x1b, 0x20, 0xdc, 0xc2, 0x4f,
      0x0e, 0x5e, 0x82, 0xee, 0xe7, 0x1d, 0x85, 0xaa, 0x77, 0xf3, 0x3a, 0xb0,
      0x1c, 0xb5, 0x88, 0x42, 0x0c, 0xf6, 0x72, 0x46, 0x1c, 0x49, 0x0d, 0xb5,
      0x2d, 0xc2, 0xfd, 0xcc, 0x7a, 0x22, 0xcc, 0xb2, 0xb9, 0x2f, 0xe8, 0xde,
      0x0e, 0x3f, 0x81, 0x10, 0xc9, 0x3e, 0x58, 0x90, 0x07, 0x6d, 0xb8, 0x29,
      0x2b, 0x76, 0xf6, 0xfe, 0x80, 0xec, 0xf3, 0x12, 0x0b, 0x4f, 0x38, 0x24,
      0xf7, 0x7e, 0x53, 0x85, 0x51, 0xec, 0xd4, 0x35, 0x92, 0x2c, 0x7d, 0x43,
      0x3f, 0x04, 0x67, 0xb4, 0x45, 0x02, 0x6d, 0x03, 0x71, 0xa4, 0x9a, 0x73,
      0xfb, 0x2e, 0xe9, 0x00, 0xc0, 0x94, 0xfc, 0xb8, 0xec, 0xc4, 0xc0, 0x1b,
      0x33, 0x0d, 0xde, 0x05, 0x61, 0xfc, 0xde, 0x6b, 0xf2, 0xdf, 0xb6, 0xd2,
      0x6f, 0x3c, 0x3d, 0x9b, 0x89, 0x73, 0x42, 0xd8, 0x07, 0x9e, 0x29, 0x22,
      0x68, 0x28, 0xa3, 0x9d, 0x8f, 0xec, 0x96, 0xb5, 0x3e, 0x06, 0x0a, 0x77,
      0x1f, 0xee, 0x75, 0xb4, 0x82, 0xb2, 0xe0, 0xe2, 0x62, 0x06, 0x93, 0x16,
      0xbd, 0x50, 0xe8, 0xe2, 0x10, 0x07, 0x8c, 0xe5, 0x64, 0x76, 0xf7, 0x0f,
      0x14, 0x9b, 0xfb, 0x35, 0x6f, 0xe1, 0xe4, 0x90, 0xea, 0x64, 0x2c, 0xe8,
      0x5a, 0x86, 0x64, 0xe5, 0x0d, 0x0b, 0x3f, 0x35, 0x08, 0x06, 0xd9, 0xde,
      0x39, 0x26, 0xc8, 0xb2, 0xd4, 0x17, 0xfa, 0xcd, 0x92, 0x67, 0x41, 0x02,
      0x2f, 0xaf, 0xa2, 0xf7, 0xb1, 0x07, 0x81, 0x39, 0x7c, 0xf0, 0x12, 0x69,
      0x74, 0x42, 0xea, 0x74, 0x2c, 0x11, 0xf2, 0x3a, 0x5b, 0x5e, 0xf5, 0xfd,
      0x10, 0x36, 0x92, 0x07, 0xcc, 0xa6, 0x93, 0xfc, 0x8a, 0xf5, 0x7d, 0x22},
     pub_key_2,
     {0x33, 0x39, 0x34, 0x39, 0x34, 0x30, 0x31, 0x32, 0x31, 0x35},
     true},

    // Comment:
    // tcID: 12
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     12,
     32,
     {0x67, 0x7d, 0xd6, 0x91, 0x8b, 0xf4, 0xc9, 0x69, 0x34, 0xe3, 0x29, 0xa1,
      0x14, 0x00, 0x24, 0x60, 0xd6, 0x7d, 0x1e, 0x8f, 0x72, 0x9e, 0xea, 0x9d,
      0x2e, 0x8b, 0xae, 0x78, 0xf4, 0x44, 0x2f, 0x1a, 0x48, 0x0f, 0xf1, 0xe5,
      0xd2, 0x0c, 0x1b, 0xd8, 0x1e, 0x61, 0xe5, 0xf9, 0x2e, 0x5e, 0x42, 0x88,
      0x1c, 0xb1, 0xfc, 0x22, 0xbb, 0x7d, 0xa3, 0xa4, 0xd2, 0x10, 0x60, 0xbb,
      0x23, 0xbb, 0x17, 0xc2, 0x34, 0xa8, 0x5c, 0x76, 0xf7, 0x59, 0x1f, 0xb5,
      0x4c, 0xe0, 0xef, 0x70, 0xee, 0x75, 0x56, 0x90, 0x5e, 0xb6, 0x70, 0x83,
      0x0b, 0x9d, 0x10, 0x90, 0x5d, 0x10, 0x0f, 0x0c, 0x25, 0x5b, 0x94, 0x46,
      0x89, 0xf2, 0x3e, 0x13, 0x13, 0xb0, 0x44, 0x87, 0x77, 0xc5, 0x2b, 0xa8,
      0x0b, 0x76, 0x7e, 0x07, 0x10, 0x88, 0x18, 0xaa, 0x51, 0x31, 0xf8, 0xb7,
      0x5c, 0x84, 0xfd, 0x2d, 0x7b, 0x40, 0x35, 0xe0, 0xdf, 0x9a, 0x21, 0x3a,
      0xfa, 0x8c, 0xb9, 0x13, 0x48, 0x2a, 0xe0, 0xaf, 0x76, 0xa9, 0x97, 0xaa,
      0xa0, 0xc8, 0xcb, 0x63, 0x97, 0x5b, 0xf9, 0xc0, 0x06, 0xd8, 0x9f, 0xe4,
      0xea, 0x6e, 0xf0, 0x35, 0xcd, 0xb4, 0x13, 0x71, 0x03, 0x58, 0x5b, 0x9d,
      0x05, 0x15, 0x0b, 0x08, 0x6d, 0x7f, 0x32, 0x9b, 0x70, 0xef, 0xcb, 0x42,
      0x8d, 0xdf, 0x76, 0xca, 0x36, 0xd4, 0x4a, 0xf7, 0x42, 0x32, 0x6a, 0xa0,
      0x50, 0x39, 0x38, 0x2a, 0xf6, 0x72, 0x16, 0xc1, 0x2f, 0x7e, 0xb2, 0xdc,
      0xf0, 0x15, 0x95, 0xf3, 0xb7, 0x82, 0x35, 0x34, 0x1b, 0xe0, 0xbf, 0x7e,
      0xa3, 0x0f, 0x62, 0x94, 0x23, 0x9c, 0x7a, 0x4b, 0x1e, 0xad, 0x8f, 0x98,
      0xba, 0xc8, 0x05, 0xe8, 0x8c, 0xae, 0xb4, 0x82, 0xb1, 0x3c, 0x5b, 0xc5,
      0x52, 0x32, 0x9a, 0x47, 0xf1, 0xe2, 0x62, 0x33, 0xcd, 0x24, 0xa3, 0xb4,
      0xbf, 0xb6, 0xbe, 0x6d, 0x9e, 0x3a, 0xe8, 0xe5, 0x8f, 0x06, 0xc9, 0x5b,
      0x51, 0x3c, 0xcd, 0x5c, 0x61, 0x68, 0x5a, 0xd0, 0xae, 0xf6, 0x27, 0xbe,
      0xba, 0xb0, 0xb7, 0x2b, 0xca, 0x3b, 0xc3, 0x74, 0xf4, 0x96, 0x45, 0xe4,
      0x03, 0xbb, 0xea, 0xa2, 0x55, 0xb5, 0x01, 0xdc, 0xe3, 0xf1, 0xf4, 0x6f,
      0x9d, 0x74, 0xd1, 0xaa, 0xc2, 0xf6, 0xec, 0x5e, 0xed, 0xc5, 0x44, 0x0e,
      0x3d, 0xd9, 0xf2, 0x64, 0xbc, 0xb1, 0xd9, 0x8b, 0x85, 0x5d, 0x1c, 0xc7,
      0x88, 0xd7, 0x96, 0x91, 0x9d, 0x01, 0x4a, 0xe2, 0x15, 0xdf, 0xe2, 0x36,
      0x1a, 0x1d, 0x13, 0xaa, 0x55, 0xa7, 0x16, 0x3f, 0x41, 0x64, 0xcf, 0xf3,
      0x8c, 0x5f, 0x62, 0xc0, 0x0f, 0x59, 0xeb, 0x20, 0xef, 0xec, 0x26, 0xe0,
      0xfc, 0xf6, 0x6d, 0x37, 0xf1, 0x2c, 0x7a, 0x9d, 0x23, 0xdd, 0xe6, 0x8f,
      0x25, 0x62, 0x0d, 0xf1, 0xa4, 0xd5, 0xe5, 0xe5, 0x5c, 0xa9, 0x46, 0x34},
     pub_key_2,
     {0x31, 0x33, 0x34, 0x34, 0x32, 0x39, 0x33, 0x30, 0x37, 0x39},
     true},

    // Comment:
    // tcID: 13
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     13,
     32,
     {0xad, 0x82, 0x5d, 0xf9, 0x62, 0x15, 0xeb, 0xac, 0x22, 0xf3, 0x7e, 0x59,
      0x48, 0xfd, 0xb2, 0x28, 0x1b, 0xb7, 0xca, 0x69, 0xfb, 0xd9, 0xed, 0x6d,
      0x3f, 0x4d, 0x2f, 0xb2, 0x1c, 0xc6, 0xf9, 0xd0, 0x7c, 0xf7, 0x77, 0x9a,
      0x26, 0x4d, 0xd4, 0x27, 0xa8, 0x63, 0xf0, 0xcc, 0x36, 0xa8, 0x12, 0xf1,
      0x25, 0xd6, 0xed, 0x9b, 0xcc, 0xf6, 0xc2, 0x33, 0xae, 0x89, 0x58, 0x29,
      0x9c, 0xfe, 0x64, 0x5b, 0x17, 0x33, 0x11, 0x31, 0xc3, 0x24, 0x59, 0x37,
      0x75, 0x24, 0x32, 0x6f, 0x2e, 0x9e, 0xb4, 0x31, 0x24, 0xe2, 0xe2, 0xfb,
      0x7a, 0x02, 0x5e, 0x0e, 0xc3, 0xde, 0x65, 0x51, 0xb7, 0xec, 0x0a, 0xff,
      0x5d, 0x1b, 0x4c, 0x4c, 0x03, 0xe4, 0x54, 0xef, 0xcd, 0x25, 0x0a, 0x7c,
      0x97, 0x11, 0xf2, 0x1e, 0x71, 0xf6, 0xe3, 0x47, 0xb5, 0xe7, 0x40, 0x0c,
      0xef, 0x50, 0xee, 0xd9, 0x34, 0x26, 0xb4, 0x3c, 0xd1, 0x1c, 0xf5, 0x5c,
      0x34, 0xa9, 0xd6, 0xd1, 0xd5, 0x43, 0x14, 0xb1, 0xf0, 0x86, 0x9f, 0xeb,
      0xf3, 0xb9, 0x2b, 0x8d, 0xb4, 0x21, 0xc4, 0xfa, 0x00, 0x0e, 0x98, 0xab,
      0x0f, 0x89, 0x11, 0x20, 0xd7, 0xc0, 0xa9, 0x1b, 0xf5, 0x0e, 0x30, 0x7f,
      0xb2, 0xca, 0xfa, 0x59, 0x6c, 0x80, 0x0a, 0x05, 0xe6, 0xf4, 0x2c, 0x57,
      0x7a, 0x02, 0xaa, 0x21, 0x69, 0xcd, 0xbe, 0xbc, 0xa1, 0x4c, 0x41, 0xd1,
      0x0e, 0xe1, 0xbd, 0x41, 0x57, 0x85, 0xd7, 0x59, 0x43, 0x47, 0xf4, 0x6e,
      0x70, 0x0f, 0x62, 0xbc, 0xaa, 0x5c, 0xd7, 0x28, 0x02, 0x52, 0x47, 0xf3,
      0x9c, 0x40, 0xed, 0xc0, 0x97, 0x70, 0x15, 0x60, 0x4e, 0x19, 0x6f, 0xa3,
      0x0b, 0x1a, 0x49, 0xd8, 0x41, 0x32, 0x46, 0x9d, 0x1a, 0x87, 0x0a, 0x57,
      0xd2, 0x72, 0xc9, 0x8e, 0xd9, 0x3d, 0x86, 0x45, 0xa7, 0xbb, 0x92, 0xa4,
      0x47, 0x60, 0x57, 0xbf, 0x2b, 0x13, 0x4c, 0xa2, 0x0e, 0x45, 0xda, 0x22,
      0xcc, 0xa2, 0x96, 0x1f, 0xd5, 0x2d, 0x65, 0xf8, 0x40, 0xb0, 0x7a, 0x87,
      0xaa, 0x4a, 0xd1, 0x04, 0xaf, 0x67, 0xd7, 0xbb, 0xc5, 0x3e, 0xa9, 0x50,
      0x16, 0x88, 0x3e, 0x3e, 0xe0, 0x87, 0xf3, 0x95, 0x82, 0xb1, 0x3e, 0x27,
      0x4d, 0xf3, 0x2a, 0xa4, 0x19, 0xea, 0xbe, 0x12, 0xa9, 0xee, 0xb0, 0x88,
      0x68, 0x42, 0x5c, 0x0a, 0x1a, 0xd0, 0x67, 0x98, 0xd0, 0xf7, 0xda, 0x98,
      0x73, 0x40, 0x31, 0x3c, 0xd4, 0x25, 0x4a, 0x41, 0x40, 0xa6, 0x2f, 0x3b,
      0xb1, 0xb7, 0x6b, 0xf5, 0x7a, 0x2c, 0x07, 0x12, 0xef, 0x21, 0x05, 0xf4,
      0xde, 0x08, 0x19, 0xf6, 0xc7, 0x24, 0xe0, 0xa2, 0xd9, 0x2f, 0x87, 0x68,
      0x3a, 0x27, 0x34, 0xbe, 0xdb, 0x4f, 0xce, 0xcc, 0x75, 0xff, 0x26, 0x29,
      0x1a, 0xd8, 0x62, 0xfc, 0x33, 0x97, 0xa9, 0xf0, 0x2e, 0x6e, 0xdd, 0xf4},
     pub_key_2,
     {0x33, 0x37, 0x30, 0x36, 0x32, 0x31, 0x31, 0x37, 0x31, 0x32},
     true},

    // Comment:
    // tcID: 14
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     14,
     32,
     {0xb3, 0xc3, 0x01, 0x91, 0x8f, 0x5d, 0x1b, 0xec, 0xd6, 0xc8, 0x8e, 0xf0,
      0x4f, 0x90, 0x85, 0x09, 0xe9, 0xb6, 0x2a, 0xcd, 0x20, 0x7c, 0xb0, 0xc0,
      0x3e, 0x96, 0x8b, 0x56, 0xd4, 0x23, 0x7b, 0x4a, 0x23, 0xce, 0xad, 0x6f,
      0xa5, 0xa7, 0x2e, 0xa6, 0x47, 0x2a, 0xf4, 0x7e, 0xf3, 0x85, 0x47, 0x66,
      0x37, 0x6b, 0xed, 0xaf, 0x67, 0xc1, 0x4a, 0x79, 0x13, 0xd4, 0x8a, 0x74,
      0xaa, 0x65, 0x21, 0xf8, 0xac, 0x81, 0x4f, 0x01, 0xe3, 0xbc, 0xb0, 0x73,
      0xe3, 0xb8, 0x5f, 0x31, 0x5b, 0xf5, 0x14, 0x68, 0xc2, 0x84, 0x44, 0x23,
      0x14, 0x02, 0xa7, 0x7c, 0xbe, 0xbd, 0x0c, 0xbf, 0xc9, 0x8b, 0x06, 0xfe,
      0x92, 0x5f, 0x5d, 0x59, 0xb4, 0x35, 0x3c, 0x21, 0xab, 0xb3, 0x24, 0x69,
      0x6b, 0xd5, 0xd4, 0x02, 0xe7, 0xcc, 0x54, 0x35, 0xbc, 0xcd, 0x8e, 0xec,
      0x3e, 0xeb, 0x8e, 0x7e, 0x4b, 0x5d, 0x4f, 0x8f, 0x71, 0x9a, 0xdc, 0x00,
      0xea, 0xe9, 0x18, 0x0c, 0xb3, 0xcc, 0xe9, 0xdd, 0x89, 0x23, 0x1b, 0x63,
      0x76, 0x51, 0xa7, 0x6d, 0x87, 0xc0, 0x31, 0x1d, 0x0f, 0x9d, 0xe0, 0xf7,
      0xc9, 0xbd, 0x7f, 0x64, 0x85, 0xd7, 0xd6, 0x00, 0xbb, 0xf1, 0x05, 0xe1,
      0xfc, 0x6d, 0x37, 0x44, 0xe8, 0x35, 0x28, 0xfe, 0x76, 0x1c, 0x2a, 0xb0,
      0xfa, 0x0c, 0xd5, 0xc3, 0x86, 0xd2, 0xee, 0x44, 0xb0, 0x96, 0x7c, 0xe2,
      0xda, 0xc3, 0xab, 0xf1, 0xc7, 0x23, 0x86, 0x85, 0x69, 0xf4, 0x3a, 0xe0,
      0x9f, 0x1a, 0x5e, 0xe3, 0x22, 0x45, 0xb1, 0x15, 0x69, 0xfb, 0x2d, 0xff,
      0xf0, 0x8f, 0x6f, 0x40, 0xc0, 0xcf, 0x45, 0xd2, 0xbc, 0x7f, 0xc5, 0x24,
      0xa8, 0x27, 0x79, 0x32, 0x8f, 0x85, 0x0f, 0xfa, 0xed, 0xcd, 0x9d, 0xe2,
      0x7d, 0xb5, 0xe1, 0xbd, 0x37, 0x2a, 0x76, 0xfb, 0x60, 0xfb, 0xbc, 0xf8,
      0x8a, 0x14, 0xa2, 0xd8, 0x20, 0x64, 0x7f, 0x66, 0x0a, 0x89, 0x4f, 0x54,
      0x20, 0xc7, 0x24, 0x6d, 0x9d, 0x94, 0x01, 0xad, 0x56, 0xd5, 0x77, 0xb5,
      0x69, 0x07, 0xd9, 0xfd, 0x3b, 0x69, 0xe3, 0x5f, 0xaa, 0x40, 0x00, 0x02,
      0x07, 0xd7, 0x04, 0x08, 0x7e, 0x3a, 0x70, 0x11, 0xcc, 0x34, 0x3c, 0xc9,
      0x4f, 0x99, 0xba, 0x65, 0x3d, 0xa6, 0x45, 0x14, 0x85, 0xa9, 0xfc, 0x17,
      0xbb, 0xad, 0x26, 0x88, 0xb5, 0x11, 0xee, 0x68, 0xcd, 0x90, 0x28, 0x8e,
      0x4f, 0x5e, 0x83, 0xab, 0x74, 0x2a, 0x54, 0xbe, 0x00, 0x6b, 0x51, 0xfd,
      0x75, 0xe9, 0xea, 0x3a, 0xd0, 0x9e, 0xf7, 0x11, 0x2f, 0x79, 0x3b, 0x61,
      0xd5, 0x47, 0x0a, 0xa1, 0x62, 0x55, 0xdb, 0x34, 0xa8, 0xab, 0xd5, 0x96,
      0x3b, 0x53, 0xa9, 0x40, 0xc8, 0x90, 0xce, 0x89, 0xf2, 0x7b, 0x8f, 0x7e,
      0x53, 0x54, 0x89, 0xe9, 0x65, 0xf3, 0x3a, 0x4b, 0x97, 0x98, 0xc3, 0x01},
     pub_key_2,
     {0x33, 0x34, 0x33, 0x36, 0x38, 0x38, 0x37, 0x31, 0x32},
     true},

    // Comment:
    // tcID: 15
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     15,
     32,
     {0x60, 0x28, 0x83, 0xfa, 0x2f, 0x9a, 0x6c, 0xa3, 0x54, 0x37, 0xd3, 0x77,
      0xff, 0xfa, 0x5c, 0xf5, 0xa5, 0x64, 0x38, 0x98, 0x76, 0x39, 0x60, 0xc7,
      0x72, 0x2d, 0x5a, 0x5b, 0x80, 0x8f, 0xdf, 0xb4, 0xa0, 0x9a, 0x0c, 0xd3,
      0xbb, 0xc8, 0xc5, 0xd2, 0xfc, 0x8a, 0x60, 0x32, 0x29, 0xa5, 0xde, 0x18,
      0x86, 0x6a, 0xa0, 0xc5, 0xd8, 0x8c, 0x22, 0x72, 0x78, 0x47, 0x84, 0xc8,
      0x83, 0x91, 0x8f, 0xcb, 0xf4, 0x7a, 0xc6, 0x2f, 0x5e, 0x75, 0x23, 0xd6,
      0x5d, 0x6a, 0xb4, 0x86, 0xc6, 0x8c, 0xa2, 0x45, 0x19, 0x9e, 0x1a, 0xca,
      0xd7, 0xf0, 0x87, 0xb4, 0xe8, 0x22, 0x66, 0x91, 0x05, 0xf4, 0xf4, 0x5a,
      0x50, 0xc1, 0xa4, 0x37, 0x22, 0xfb, 0xac, 0x7a, 0x9b, 0x88, 0xef, 0x7b,
      0xcb, 0xe5, 0x79, 0x6a, 0xc9, 0x60, 0x1a, 0x09, 0xd3, 0xfd, 0x62, 0x01,
      0xc7, 0x7e, 0xe0, 0x9f, 0x59, 0x1a, 0x9d, 0x37, 0xf4, 0x8b, 0x3e, 0x93,
      0xfb, 0x6e, 0xe5, 0xd9, 0x68, 0x3d, 0x3e, 0xf4, 0xd5, 0x81, 0xfb, 0x2a,
      0xd9, 0xe5, 0xcb, 0x28, 0x96, 0xba, 0xcb, 0xd0, 0x78, 0x95, 0x2f, 0x9d,
      0xd0, 0x45, 0x40, 0xfb, 0xee, 0xec, 0xf6, 0xd8, 0xd9, 0xfa, 0x45, 0xe7,
      0x91, 0xcc, 0xf3, 0x02, 0x71, 0x30, 0xd1, 0xf1, 0xec, 0x55, 0x1f, 0xb3,
      0x5e, 0xbb, 0xa6, 0xff, 0x32, 0x9c, 0x7d, 0x31, 0xc5, 0xbe, 0xdd, 0x65,
      0x30, 0x3d, 0x56, 0xb5, 0x8f, 0x82, 0x6f, 0x38, 0x91, 0x7b, 0x3f, 0x79,
      0xd8, 0x2b, 0x44, 0x2f, 0x46, 0x68, 0xad, 0x47, 0x9b, 0x7e, 0x10, 0x8e,
      0x2e, 0x59, 0xd8, 0x86, 0x40, 0xc1, 0xda, 0x8e, 0xcd, 0xf7, 0x19, 0x15,
      0x6d, 0xdc, 0xad, 0x93, 0xd5, 0x68, 0xd9, 0x59, 0x3d, 0xfc, 0x7b, 0xf0,
      0xbd, 0xa2, 0x51, 0x94, 0x54, 0xcd, 0x2b, 0x1d, 0xaf, 0xef, 0xd5, 0x56,
      0x09, 0x1a, 0x2a, 0x13, 0xff, 0x80, 0xc7, 0x5b, 0xbe, 0x9d, 0xdb, 0x04,
      0xb1, 0xe5, 0x5f, 0x7e, 0xdc, 0xcb, 0x8a, 0x08, 0x32, 0xef, 0x03, 0x07,
      0x95, 0x64, 0xcc, 0x36, 0x7c, 0xf5, 0xb6, 0x96, 0xbe, 0x4e, 0x19, 0x30,
      0x01, 0xd8, 0xc3, 0xbc, 0x51, 0x24, 0x22, 0x73, 0x59, 0xc7, 0x61, 0x63,
      0x81, 0xa4, 0x73, 0xb0, 0x7f, 0x31, 0xd6, 0x49, 0x4c, 0x06, 0x2b, 0x2a,
      0x91, 0x51, 0x42, 0x0b, 0x82, 0x8b, 0x83, 0x0f, 0x25, 0x0e, 0x66, 0xec,
      0x57, 0x0e, 0x38, 0xbc, 0x44, 0xe2, 0x6b, 0xb8, 0x3d, 0x45, 0xc7, 0xf7,
      0x94, 0xa9, 0x46, 0x0b, 0x4b, 0x6d, 0x74, 0x6c, 0x88, 0x8d, 0x08, 0x4a,
      0x75, 0x4a, 0xc7, 0xd7, 0x5a, 0xb1, 0xbf, 0xf2, 0x32, 0xbe, 0x49, 0xdd,
      0x1f, 0xb7, 0x3e, 0xfd, 0x76, 0xfb, 0xda, 0x26, 0xe6, 0x41, 0x1b, 0x3b,
      0x1d, 0xe8, 0x67, 0x15, 0x18, 0xf9, 0x37, 0xb8, 0xce, 0x3b, 0xa8, 0xc0},
     pub_key_2,
     {0x31, 0x33, 0x35, 0x31, 0x35, 0x33, 0x30, 0x33, 0x37, 0x30},
     true},

    // Comment:
    // tcID: 16
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     16,
     32,
     {0xb2, 0x59, 0x67, 0x6e, 0x6b, 0x9b, 0x49, 0xed, 0xc0, 0x4c, 0xf3, 0xf6,
      0xb0, 0x62, 0x67, 0xa6, 0xaf, 0x92, 0x4d, 0x27, 0x8c, 0x21, 0xf5, 0x99,
      0x4c, 0x21, 0x90, 0xd0, 0xcb, 0x66, 0x7d, 0x64, 0x12, 0x91, 0x36, 0x1a,
      0x8b, 0xfa, 0xee, 0x82, 0x36, 0x36, 0x0a, 0x4d, 0xff, 0xbd, 0x5e, 0xc4,
      0xf1, 0xf8, 0xd9, 0xf8, 0x5b, 0x54, 0xc1, 0xbb, 0xe3, 0xc9, 0xdc, 0x35,
      0x33, 0x24, 0x43, 0xc2, 0x50, 0x9f, 0x0a, 0xd7, 0xd5, 0xec, 0x42, 0x57,
      0x1d, 0x75, 0x5a, 0xf8, 0x14, 0xcc, 0x0e, 0xf4, 0x8e, 0x51, 0x4d, 0xc5,
      0x34, 0x2c, 0xa7, 0x65, 0x3d, 0x53, 0x57, 0x89, 0xc8, 0xc2, 0x1f, 0xee,
      0x5e, 0x54, 0x7a, 0xc3, 0xc2, 0x47, 0xc9, 0xbe, 0x6b, 0x79, 0x21, 0x99,
      0xdb, 0x48, 0xa1, 0x72, 0x99, 0xb5, 0xf9, 0xd3, 0xbb, 0x98, 0x81, 0xca,
      0x95, 0x75, 0x11, 0x32, 0xfa, 0xc7, 0x6d, 0x77, 0x6a, 0xd0, 0x28, 0x72,
      0x27, 0x9b, 0xd7, 0x7d, 0xcb, 0x43, 0xb0, 0xca, 0xe7, 0x67, 0x3e, 0x40,
      0x90, 0x7c, 0x1b, 0xc3, 0x21, 0xe1, 0x46, 0x37, 0xf2, 0x24, 0x48, 0x1f,
      0x58, 0xb9, 0x0f, 0x87, 0x5c, 0xdc, 0x08, 0xc4, 0x95, 0x15, 0xb4, 0xbe,
      0x48, 0x21, 0x47, 0xfc, 0xf2, 0xe6, 0x21, 0x26, 0xfe, 0x4c, 0x03, 0x10,
      0xc0, 0x67, 0x7e, 0xb7, 0xec, 0xcd, 0x93, 0x52, 0xa9, 0xcc, 0x09, 0x02,
      0xb5, 0x4e, 0x4b, 0x34, 0x54, 0xf3, 0xff, 0xd6, 0x96, 0x66, 0xd1, 0x64,
      0x69, 0xbe, 0x95, 0x8a, 0x54, 0xaa, 0xd1, 0xd2, 0xa5, 0x8e, 0xb5, 0x61,
      0xb4, 0xb2, 0x22, 0xa4, 0xca, 0x5e, 0xdc, 0xb5, 0x61, 0x2d, 0x03, 0xb8,
      0xbd, 0x2f, 0x7f, 0x26, 0x30, 0x2b, 0x51, 0x56, 0x7b, 0x83, 0xfe, 0x1d,
      0x59, 0xee, 0xed, 0x36, 0xbd, 0x2e, 0xf1, 0x28, 0xcf, 0x47, 0x6c, 0xcb,
      0xab, 0xe4, 0xeb, 0x55, 0xd8, 0xc4, 0xec, 0x91, 0xa0, 0xbd, 0xa8, 0x44,
      0x59, 0x72, 0xfb, 0x3d, 0x74, 0xa4, 0xbc, 0xee, 0x2e, 0xcf, 0x5e, 0x90,
      0xf5, 0xbc, 0x19, 0xd4, 0xe9, 0x90, 0x8e, 0x7a, 0xa2, 0x84, 0xcd, 0xbc,
      0x37, 0xd2, 0x2f, 0xf4, 0xea, 0x70, 0x47, 0x9e, 0x8e, 0x2a, 0x9d, 0x2b,
      0xf0, 0xa6, 0xf0, 0x2b, 0x3a, 0x2d, 0x26, 0x43, 0xa3, 0x4d, 0x7d, 0x4f,
      0x93, 0x78, 0x2d, 0xf0, 0x60, 0x7c, 0x80, 0x61, 0x77, 0xf6, 0x19, 0x63,
      0xb6, 0x0c, 0x08, 0xe4, 0x15, 0x4a, 0x07, 0x4e, 0x92, 0xb2, 0x6c, 0x4f,
      0x2c, 0x67, 0x8c, 0x9d, 0xa7, 0xcd, 0x9d, 0x16, 0x30, 0x7c, 0x73, 0x09,
      0x55, 0x9a, 0x39, 0x35, 0xa8, 0xef, 0xf9, 0x59, 0x3b, 0x54, 0x54, 0xa1,
      0xcd, 0x60, 0xc3, 0x88, 0xc9, 0x95, 0xdf, 0x97, 0x10, 0x75, 0xc5, 0x39,
      0x7f, 0xeb, 0x77, 0xf3, 0x6e, 0xd8, 0xb9, 0x98, 0x7b, 0x8e, 0xf3, 0xdb},
     pub_key_2,
     {0x36, 0x35, 0x35, 0x33, 0x32, 0x30, 0x33, 0x31, 0x32, 0x36},
     true},

    // Comment:
    // tcID: 17
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     17,
     32,
     {0x57, 0x76, 0x5f, 0xb3, 0x0e, 0x12, 0xf0, 0x81, 0x43, 0xd7, 0x2d, 0x7a,
      0x42, 0x32, 0xc9, 0x15, 0x83, 0xd6, 0x0a, 0xfb, 0xd8, 0xdf, 0xe0, 0x1c,
      0x3b, 0x50, 0xd8, 0x61, 0x14, 0x0d, 0x3c, 0x5b, 0xd0, 0xa1, 0x7c, 0x3a,
      0x51, 0xdf, 0xad, 0x96, 0xd8, 0xce, 0x07, 0x16, 0x34, 0x8d, 0xc6, 0xf6,
      0x2c, 0x12, 0xc1, 0x6b, 0xab, 0x54, 0x01, 0xa1, 0xfa, 0x90, 0x95, 0x0e,
      0x96, 0x80, 0x10, 0x64, 0xda, 0xb2, 0x53, 0x7a, 0x4c, 0xd0, 0xb5, 0x22,
      0x77, 0x08, 0x61, 0x8e, 0xd2, 0xe3, 0x4e, 0x2e, 0xab, 0x8a, 0x55, 0x7a,
      0x31, 0x6a, 0x5a, 0x7c, 0x42, 0xb6, 0xb2, 0x97, 0xcf, 0xa6, 0x46, 0xcf,
      0x8a, 0x90, 0xaf, 0x59, 0x73, 0x0f, 0xe5, 0xd3, 0x4d, 0xf9, 0xa2, 0xd4,
      0xa9, 0xbb, 0x0d, 0x8b, 0xb1, 0xd8, 0xe5, 0xde, 0xcf, 0xfd, 0xda, 0x6f,
      0x50, 0x86, 0x3b, 0xde, 0x34, 0x7c, 0x17, 0xed, 0x88, 0xe2, 0x32, 0xc4,
      0xd3, 0x23, 0x5b, 0x00, 0xce, 0x5d, 0xb0, 0x88, 0xe5, 0x14, 0xf3, 0x49,
      0x0f, 0x8d, 0x45, 0x9e, 0xba, 0x99, 0x3d, 0x31, 0xf9, 0x9b, 0xb2, 0x4a,
      0x09, 0x7c, 0x0e, 0x32, 0x24, 0x54, 0xe6, 0xc6, 0x8e, 0x6c, 0x9c, 0xb0,
      0x04, 0x2a, 0x8f, 0xe1, 0xa5, 0x89, 0x74, 0x58, 0xd0, 0x97, 0xee, 0x68,
      0xe5, 0xc7, 0x91, 0x63, 0xf0, 0x5e, 0xe0, 0x81, 0x74, 0x99, 0xa9, 0x8f,
      0x2a, 0xf0, 0x38, 0xaa, 0xf0, 0x2c, 0x48, 0x8f, 0xad, 0x86, 0xee, 0x0c,
      0x15, 0x7f, 0xbd, 0x1c, 0xfb, 0x91, 0xa1, 0x7b, 0xc0, 0x09, 0x71, 0x32,
      0x6d, 0x15, 0xe1, 0xc0, 0x2a, 0xb4, 0x40, 0xc4, 0x6b, 0x07, 0xc8, 0x07,
      0xda, 0xd0, 0x82, 0x2e, 0x2d, 0xce, 0x95, 0x05, 0xea, 0x75, 0xdc, 0xea,
      0x6b, 0xa1, 0x34, 0xb5, 0x8e, 0xe9, 0xeb, 0x79, 0xbb, 0x70, 0xc2, 0x04,
      0x5c, 0x1a, 0x4e, 0x62, 0x06, 0xee, 0x9e, 0x12, 0x90, 0x9b, 0x1c, 0x3a,
      0x7a, 0x38, 0x6c, 0xde, 0x5f, 0xb1, 0x96, 0x51, 0x01, 0x15, 0x9d, 0xd3,
      0x4c, 0x58, 0x61, 0x70, 0x49, 0x1b, 0x3b, 0x8c, 0xca, 0x3a, 0x9b, 0x4f,
      0x1d, 0x0b, 0x74, 0x38, 0xae, 0xde, 0x0e, 0xfb, 0x1c, 0xdc, 0x9e, 0x77,
      0x12, 0xab, 0xe0, 0x67, 0x5e, 0xa9, 0xee, 0x87, 0xe2, 0xcd, 0x82, 0x00,
      0xcb, 0x08, 0xbb, 0xb8, 0x5a, 0x3f, 0x87, 0x69, 0x5c, 0x31, 0x47, 0x09,
      0x2e, 0x15, 0x3c, 0x29, 0x2e, 0x5a, 0x32, 0x47, 0x5b, 0xc4, 0x80, 0x0f,
      0xa2, 0xe3, 0xd0, 0x37, 0x07, 0x0b, 0xc6, 0xf1, 0x30, 0xe5, 0x23, 0x4f,
      0x5c, 0xd7, 0x4c, 0x91, 0x09, 0xd2, 0xcc, 0xa1, 0x4e, 0xb8, 0x3b, 0xf6,
      0x17, 0x47, 0x71, 0x2b, 0x4b, 0x9c, 0x90, 0x93, 0x3d, 0x2c, 0x25, 0xd8,
      0x76, 0xba, 0x1b, 0xf7, 0xa8, 0xe6, 0x01, 0xb4, 0x72, 0xc1, 0x54, 0xc5},
     pub_key_2,
     {0x31, 0x35, 0x36, 0x34, 0x33, 0x34, 0x36, 0x36, 0x30, 0x33},
     true},

    // Comment:
    // tcID: 18
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     18,
     32,
     {0x27, 0xc6, 0x77, 0xb2, 0xb0, 0xb5, 0x46, 0xf2, 0x3d, 0x5c, 0x3c, 0xea,
      0xed, 0x40, 0x07, 0xcf, 0xff, 0x9f, 0xc1, 0xe0, 0x84, 0x3d, 0xe4, 0x3e,
      0x7d, 0xde, 0xe8, 0xba, 0x32, 0x27, 0x49, 0x54, 0xd7, 0x9d, 0x9f, 0xad,
      0x43, 0xc1, 0x0e, 0x89, 0x02, 0x66, 0x12, 0x3f, 0x24, 0x7a, 0xbd, 0x2c,
      0xa3, 0x51, 0xa1, 0x5b, 0x19, 0x6a, 0x34, 0x0b, 0x77, 0x53, 0xd4, 0xcd,
      0x37, 0x56, 0xa0, 0x91, 0x27, 0x1a, 0x25, 0xfb, 0xf7, 0x83, 0x4b, 0x05,
      0xee, 0x9c, 0x5d, 0xb4, 0xa8, 0xa3, 0x55, 0xd5, 0x74, 0x6f, 0xf9, 0xb0,
      0xff, 0x61, 0x06, 0x1a, 0xc4, 0x67, 0x0b, 0xfc, 0x94, 0x68, 0xa4, 0x10,
      0x19, 0x17, 0xca, 0x61, 0xbf, 0x6d, 0xa1, 0xb0, 0x29, 0x87, 0x2b, 0xc3,
      0xfe, 0x14, 0xa3, 0x06, 0xd4, 0xd4, 0x37, 0x94, 0xde, 0xb2, 0xa1, 0xae,
      0x0a, 0x4a, 0xa5, 0xf4, 0x32, 0xe9, 0xf3, 0x3e, 0x53, 0x6f, 0x39, 0xc2,
      0x49, 0xfc, 0x3f, 0xfc, 0x29, 0x4a, 0x46, 0x6e, 0x7b, 0xd7, 0xb3, 0xd3,
      0x5e, 0x7c, 0xe5, 0xf1, 0x5a, 0x35, 0x64, 0xdf, 0x93, 0x51, 0x77, 0x0f,
      0xe6, 0x6b, 0x13, 0x12, 0xe6, 0x94, 0x37, 0xa0, 0x28, 0xd0, 0x7f, 0xe3,
      0x1a, 0xb3, 0x64, 0x4f, 0xa6, 0xd1, 0x6d, 0x9e, 0x37, 0x7f, 0xc3, 0xb8,
      0x82, 0x0f, 0x79, 0xd2, 0x20, 0xb0, 0x30, 0x12, 0xad, 0xd3, 0x69, 0xc6,
      0x30, 0xc7, 0xc0, 0x1c, 0x12, 0x3d, 0xfe, 0x1b, 0xe9, 0x7d, 0x8d, 0x71,
      0xd4, 0x91, 0xdc, 0x38, 0xe7, 0x78, 0x16, 0x35, 0x13, 0x96, 0x36, 0x21,
      0x3e, 0xda, 0x76, 0x55, 0xeb, 0x2a, 0xb9, 0xbf, 0x8c, 0x44, 0xaf, 0x43,
      0xd3, 0xc0, 0x98, 0x66, 0x7c, 0x68, 0x87, 0xbe, 0x8e, 0x7f, 0x29, 0xcc,
      0x72, 0xdb, 0xbb, 0xfd, 0x5c, 0x43, 0xec, 0xe1, 0xa0, 0xbd, 0xfb, 0xd0,
      0x1a, 0xaa, 0xad, 0x10, 0x77, 0x00, 0xed, 0x7d, 0x94, 0x68, 0x13, 0x86,
      0x38, 0xaf, 0xe7, 0xc7, 0xec, 0x64, 0xe6, 0x67, 0x38, 0xe1, 0x88, 0x40,
      0x0e, 0x8a, 0x71, 0xf8, 0x95, 0x26, 0xf8, 0x17, 0x0f, 0xb5, 0x6a, 0x20,
      0x0f, 0x69, 0xdc, 0x9e, 0x46, 0x64, 0xfc, 0x24, 0xf4, 0x0c, 0x80, 0xe1,
      0x17, 0xf3, 0x66, 0x6f, 0x91, 0xcc, 0xba, 0xf8, 0xdf, 0xae, 0x5f, 0xa1,
      0x45, 0xc9, 0xa9, 0x4a, 0xd6, 0x42, 0x19, 0x64, 0x3a, 0x66, 0xc9, 0x3a,
      0x68, 0x2a, 0x36, 0x5b, 0xf0, 0x82, 0x66, 0x1a, 0x00, 0xbc, 0x8b, 0x0a,
      0x66, 0x3a, 0x6f, 0x2e, 0xfb, 0xda, 0xe2, 0x97, 0x44, 0xc7, 0x35, 0x93,
      0x7c, 0x0f, 0x0d, 0x7f, 0x6f, 0xaf, 0x7e, 0xac, 0xd0, 0x68, 0xcd, 0x02,
      0xc0, 0x16, 0xcd, 0x16, 0x74, 0x1d, 0x49, 0x17, 0x0b, 0xc4, 0x0e, 0x2f,
      0xe3, 0x56, 0x5c, 0xf3, 0x86, 0x6d, 0xb6, 0xfc, 0x1d, 0x52, 0x89, 0x59},
     pub_key_2,
     {0x34, 0x34, 0x32, 0x39, 0x35, 0x33, 0x39, 0x31, 0x31, 0x37},
     true},

    // Comment:
    // tcID: 19
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     19,
     32,
     {0x98, 0x49, 0xc3, 0x25, 0x0c, 0x03, 0x09, 0x5e, 0xcc, 0x9a, 0xd4, 0x04,
      0xf9, 0xee, 0x41, 0x2c, 0x4e, 0xe7, 0x97, 0xef, 0x0a, 0x0f, 0x0e, 0x80,
      0x62, 0x47, 0x22, 0x5f, 0xe0, 0x3b, 0x3c, 0xa5, 0x38, 0x11, 0x57, 0x47,
      0x6b, 0x44, 0xbb, 0x89, 0x09, 0xd1, 0xcf, 0xb2, 0x45, 0x04, 0x01, 0x08,
      0x73, 0x33, 0x3d, 0xc9, 0x69, 0xf0, 0x35, 0xe0, 0x8d, 0x55, 0x2c, 0x2b,
      0x9e, 0x2d, 0xa8, 0x21, 0x59, 0x61, 0x9a, 0x75, 0xaa, 0xee, 0x04, 0xf2,
      0x0c, 0x53, 0x59, 0x45, 0x0b, 0x6d, 0x85, 0xdb, 0xdc, 0x98, 0xe3, 0x17,
      0x40, 0x10, 0x39, 0x5b, 0xba, 0x07, 0xcf, 0x3e, 0x64, 0xcd, 0x1e, 0xe4,
      0x4f, 0x81, 0x75, 0x4a, 0x64, 0xca, 0xb4, 0xef, 0xe7, 0xc0, 0x19, 0xe0,
      0x5b, 0xa8, 0xb3, 0x57, 0x73, 0x33, 0xfa, 0x69, 0x28, 0x58, 0xc3, 0xda,
      0xdc, 0xb0, 0xf7, 0x04, 0x7c, 0xdb, 0x1d, 0x2b, 0xf7, 0x5b, 0x34, 0x49,
      0x39, 0x88, 0xad, 0x84, 0x79, 0x45, 0x17, 0xf1, 0x8c, 0x93, 0x4d, 0x95,
      0xa7, 0xed, 0x5f, 0xfe, 0x75, 0xaa, 0x5b, 0x3b, 0x56, 0x08, 0x46, 0x2f,
      0x18, 0xbf, 0x5c, 0x65, 0x6e, 0x6f, 0x1e, 0x62, 0x6d, 0x0e, 0x2a, 0xe4,
      0xab, 0x7c, 0x69, 0xda, 0x07, 0xa2, 0x61, 0x6c, 0x51, 0x5b, 0x88, 0xfe,
      0x33, 0xfe, 0xba, 0x7c, 0xab, 0x21, 0xeb, 0x98, 0x69, 0xff, 0xa0, 0x1c,
      0xde, 0x1c, 0xf3, 0xb3, 0x18, 0xe4, 0xb7, 0xc7, 0x08, 0x9e, 0xc2, 0xd3,
      0x74, 0x8f, 0x93, 0xce, 0x3e, 0xbc, 0xad, 0x0d, 0x75, 0xbc, 0x2e, 0x5f,
      0x9b, 0xd2, 0x0f, 0x10, 0xd6, 0xd9, 0x46, 0xee, 0x11, 0x2b, 0xe2, 0x5d,
      0xd9, 0x77, 0x93, 0xf7, 0x29, 0x5c, 0xf6, 0x86, 0x2e, 0xc1, 0x16, 0xf3,
      0x06, 0xd5, 0x32, 0x87, 0x59, 0xc3, 0x04, 0x32, 0x91, 0x78, 0xa5, 0x0a,
      0x01, 0xee, 0x76, 0xb5, 0xc5, 0x35, 0x2a, 0xe1, 0x60, 0xe0, 0xe7, 0x11,
      0x6f, 0x6e, 0x96, 0x40, 0xd7, 0xbe, 0x77, 0x28, 0x7c, 0x39, 0x10, 0xc9,
      0x29, 0xbc, 0x3a, 0x2a, 0x5c, 0xe1, 0xcb, 0xe0, 0x8e, 0x48, 0xd5, 0xa2,
      0x7a, 0x11, 0x06, 0x2d, 0x74, 0x44, 0x2c, 0x5e, 0xc8, 0xa9, 0x2b, 0xe9,
      0xbd, 0x8a, 0xa8, 0x2d, 0xb1, 0x7b, 0xec, 0x86, 0xb2, 0xe1, 0x41, 0x50,
      0x0f, 0xc5, 0xed, 0xaa, 0xd5, 0x89, 0xbc, 0xc0, 0xa0, 0xbc, 0x15, 0x2a,
      0x69, 0x85, 0x74, 0x20, 0xbd, 0x5f, 0x64, 0x83, 0xaa, 0x3d, 0xb9, 0xd1,
      0xfa, 0x4c, 0xe7, 0xf6, 0xa1, 0xe2, 0x09, 0x64, 0xb1, 0x62, 0x0e, 0x8a,
      0x3a, 0x13, 0x83, 0x93, 0x11, 0xa6, 0x10, 0x31, 0xe3, 0x1b, 0xdb, 0xbd,
      0x3e, 0x13, 0x50, 0xd1, 0x77, 0x3e, 0xd1, 0x32, 0x35, 0x5e, 0xaa, 0x3a,
      0xdc, 0x8a, 0x29, 0x24, 0x37, 0x29, 0x3c, 0x26, 0xfc, 0x42, 0x88, 0x44},
     pub_key_2,
     {0x31, 0x30, 0x39, 0x35, 0x33, 0x32, 0x36, 0x31, 0x33, 0x35, 0x31},
     true},

    // Comment:
    // tcID: 20
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     20,
     32,
     {0x9d, 0x81, 0xba, 0x9f, 0xff, 0x8a, 0x9e, 0x27, 0xc1, 0xaf, 0x56, 0xef,
      0xb4, 0xb4, 0x80, 0x88, 0x78, 0x5b, 0x96, 0x77, 0x39, 0x78, 0x43, 0xf3,
      0x35, 0xf0, 0x38, 0xb4, 0x6e, 0x86, 0x30, 0x45, 0xc5, 0xc4, 0x8f, 0xc6,
      0x89, 0xec, 0x04, 0x6f, 0x87, 0xd7, 0xc2, 0xa1, 0xe2, 0x23, 0x08, 0x55,
      0x81, 0x81, 0xa1, 0xdd, 0x95, 0x71, 0x10, 0x88, 0xba, 0x84, 0xdb, 0x74,
      0xeb, 0xe3, 0x33, 0x98, 0xf7, 0x7b, 0x76, 0x0c, 0x69, 0x33, 0x71, 0xa4,
      0x03, 0xd8, 0x98, 0x8e, 0x3e, 0x90, 0xd0, 0x25, 0xae, 0xde, 0x1e, 0x7b,
      0x9d, 0x42, 0x8e, 0xe4, 0xce, 0x45, 0x02, 0xa3, 0x07, 0xbd, 0x15, 0x1c,
      0xde, 0xc1, 0xae, 0x14, 0x8c, 0x6e, 0x0d, 0x36, 0xd5, 0x0d, 0x3c, 0x19,
      0xeb, 0x12, 0x66, 0x71, 0x4b, 0x01, 0x11, 0xac, 0xe6, 0x12, 0xdd, 0x8a,
      0xbd, 0xae, 0xf9, 0x69, 0xc3, 0x2c, 0xf3, 0xba, 0xe1, 0xbd, 0xd4, 0xb1,
      0x4c, 0xd5, 0x3b, 0x3f, 0xfb, 0xe5, 0x9c, 0xa7, 0x5d, 0x27, 0x9b, 0xe3,
      0xa9, 0x33, 0xeb, 0x34, 0x96, 0xe0, 0xcc, 0x5d, 0x9b, 0x63, 0x9a, 0x58,
      0x99, 0xac, 0xcc, 0x4c, 0x91, 0xf8, 0x20, 0xcf, 0xcc, 0x46, 0x09, 0x63,
      0x0c, 0xd4, 0x7f, 0x0f, 0x32, 0x1a, 0x34, 0x9f, 0x04, 0x9c, 0xfe, 0xb5,
      0xa7, 0x4d, 0xd1, 0xdc, 0xa0, 0xf8, 0x98, 0xa3, 0x64, 0x91, 0xcc, 0x37,
      0x52, 0xc2, 0xa8, 0xc3, 0x0d, 0x39, 0xc2, 0x4f, 0x9c, 0xbf, 0xa2, 0x1c,
      0xfc, 0xa1, 0x56, 0x00, 0xe4, 0xae, 0x16, 0x1a, 0x98, 0x34, 0xf8, 0x39,
      0x87, 0x8b, 0xbe, 0x66, 0xe2, 0x01, 0xb8, 0xc8, 0xaa, 0x8a, 0x43, 0x09,
      0x13, 0xe1, 0x57, 0xc3, 0xc7, 0xd7, 0x4b, 0xcd, 0x90, 0x1d, 0xe4, 0x31,
      0x08, 0xd6, 0x04, 0x98, 0x05, 0xbc, 0x85, 0xac, 0x0b, 0x29, 0x86, 0x91,
      0x84, 0xfd, 0x58, 0x7f, 0xe4, 0x6d, 0x47, 0xeb, 0x74, 0x0a, 0x86, 0x00,
      0x99, 0x40, 0x24, 0x04, 0x80, 0xd3, 0xba, 0x70, 0x0a, 0x71, 0x30, 0x20,
      0x76, 0x37, 0xa4, 0x38, 0x74, 0x60, 0x84, 0x01, 0x1f, 0x90, 0x39, 0xe5,
      0x2c, 0x1f, 0x6a, 0xa5, 0xc9, 0x9d, 0x70, 0x93, 0xd1, 0x4e, 0x3b, 0x4d,
      0xa4, 0x14, 0x8f, 0x82, 0x5a, 0x22, 0x2f, 0xb8, 0xb1, 0xc3, 0x5e, 0x59,
      0x46, 0xd0, 0x2c, 0xed, 0x55, 0x44, 0x3c, 0xf0, 0x73, 0x6f, 0x72, 0x01,
      0x1b, 0x12, 0x9a, 0x40, 0x63, 0x2c, 0xaa, 0xef, 0xb7, 0x8c, 0x44, 0xfc,
      0xfc, 0x31, 0xfb, 0x24, 0x49, 0xf2, 0xd4, 0x6c, 0x7a, 0xa5, 0x39, 0x66,
      0xb7, 0x96, 0x6e, 0xba, 0x8d, 0x14, 0x3b, 0x32, 0x20, 0x04, 0x59, 0x91,
      0xf6, 0x6b, 0x1e, 0xfe, 0x10, 0xf6, 0x96, 0xd5, 0xd5, 0x68, 0xea, 0x87,
      0x59, 0x8a, 0xb5, 0xfd, 0x66, 0x55, 0xdb, 0x50, 0x6b, 0xee, 0x18, 0xbe},
     pub_key_2,
     {0x35, 0x39, 0x38, 0x37, 0x33, 0x35, 0x30, 0x30, 0x34, 0x31},
     true},

    // Comment:
    // tcID: 21
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     21,
     32,
     {0x8f, 0x0c, 0x40, 0x86, 0xce, 0x83, 0x92, 0x42, 0xb6, 0x69, 0x6e, 0x7e,
      0x0f, 0xe6, 0x3b, 0xe0, 0x7b, 0x1d, 0xa1, 0xb7, 0x74, 0x47, 0x52, 0x01,
      0x72, 0xfc, 0xcc, 0xb4, 0x1f, 0x34, 0x1b, 0xa9, 0x44, 0x92, 0x7a, 0xcc,
      0x17, 0xcf, 0x1c, 0xa0, 0x68, 0x66, 0x92, 0x13, 0x0b, 0xe5, 0xbf, 0xde,
      0x23, 0x63, 0x85, 0x62, 0x8b, 0x0e, 0x99, 0xbd, 0x0b, 0x3a, 0xc5, 0xfc,
      0xf2, 0xb6, 0x4b, 0xb6, 0xfd, 0x0c, 0x8c, 0xa7, 0x34, 0xfe, 0xbb, 0xd0,
      0x0d, 0xcc, 0x9b, 0x99, 0x88, 0x7d, 0xbd, 0x4a, 0x8c, 0x5f, 0x7b, 0xc9,
      0x70, 0x31, 0xa7, 0xe1, 0x8f, 0x61, 0x43, 0xd5, 0x61, 0xb2, 0x9e, 0xf3,
      0xe2, 0x54, 0x49, 0x55, 0x9c, 0x55, 0x63, 0xa9, 0x16, 0x95, 0x92, 0xef,
      0xa5, 0x34, 0xfb, 0x9b, 0x75, 0xca, 0xcb, 0x7c, 0xa6, 0x7b, 0x3a, 0x8f,
      0xf7, 0x6f, 0x56, 0x42, 0xdf, 0xbf, 0xfa, 0x93, 0xe4, 0xba, 0x7e, 0x51,
      0xe8, 0xa5, 0x91, 0x9a, 0xfd, 0xbb, 0x1c, 0x3e, 0xc9, 0x1c, 0x9c, 0xba,
      0x07, 0x69, 0x02, 0x38, 0x36, 0x14, 0xb2, 0xb1, 0x90, 0x6e, 0x61, 0x92,
      0xb4, 0x51, 0x23, 0x98, 0x70, 0xaf, 0xb8, 0x63, 0xe1, 0x58, 0xf8, 0xec,
      0x61, 0x12, 0x7f, 0x8a, 0x7a, 0x94, 0x42, 0x61, 0x0c, 0x1c, 0xa4, 0x7e,
      0x5a, 0x9c, 0x8a, 0x0f, 0x46, 0x05, 0x48, 0x32, 0x07, 0x27, 0xef, 0x16,
      0x33, 0xcf, 0x90, 0x92, 0xce, 0xe6, 0x5e, 0x37, 0x3e, 0xf1, 0x63, 0x22,
      0xfa, 0xdd, 0xcd, 0xb4, 0xf6, 0x71, 0xd9, 0x13, 0x05, 0xae, 0x8b, 0x3e,
      0x4d, 0xc9, 0xec, 0x65, 0xf5, 0x06, 0x96, 0x67, 0xd4, 0x62, 0xf4, 0x29,
      0xb0, 0x25, 0xee, 0x6f, 0x05, 0xcc, 0x38, 0xf8, 0xea, 0x53, 0xf4, 0xcf,
      0x0d, 0x81, 0xb4, 0xea, 0x90, 0xf7, 0xe0, 0x78, 0xe3, 0xb8, 0xc8, 0x04,
      0xad, 0x2c, 0xc7, 0x52, 0x52, 0x53, 0xfa, 0x81, 0xeb, 0xf5, 0x0e, 0x8e,
      0x62, 0xbd, 0x68, 0x41, 0xf2, 0x87, 0x27, 0x21, 0x4d, 0x18, 0x36, 0x65,
      0xa1, 0x08, 0xbc, 0xf8, 0xe6, 0xf9, 0x9b, 0x28, 0x4a, 0x86, 0xb3, 0xf6,
      0xad, 0xb5, 0xf5, 0xdf, 0x71, 0xac, 0xda, 0x60, 0xcb, 0x68, 0x64, 0x97,
      0x0c, 0xc2, 0x27, 0x69, 0xc1, 0xb1, 0xec, 0x94, 0xab, 0xd1, 0xfb, 0xdd,
      0x1c, 0x21, 0xed, 0xf2, 0xc3, 0x75, 0xbb, 0x16, 0x7e, 0xf6, 0x65, 0x38,
      0xde, 0xdd, 0xe6, 0xb6, 0xb3, 0xc7, 0xf8, 0x63, 0x44, 0x43, 0xff, 0x16,
      0x34, 0x82, 0x25, 0x0f, 0x1c, 0x8e, 0x97, 0x74, 0x8c, 0xbe, 0x8b, 0xa0,
      0x37, 0x06, 0x62, 0xb1, 0xa1, 0x0f, 0xb5, 0x8b, 0x1a, 0xb5, 0x95, 0xe2,
      0x28, 0xaf, 0x81, 0x3d, 0x3f, 0xbb, 0x85, 0x2e, 0x9b, 0x80, 0x14, 0xa9,
      0x8a, 0xfd, 0x6d, 0x96, 0xb2, 0xe2, 0x7c, 0x0e, 0xb7, 0x68, 0x85, 0x95},
     pub_key_2,
     {0x33, 0x34, 0x36, 0x33, 0x30, 0x30, 0x36, 0x38, 0x37, 0x38},
     true},

    // Comment:
    // tcID: 22
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     22,
     32,
     {0x2b, 0x1f, 0x09, 0x3b, 0x09, 0xdd, 0xb2, 0x7d, 0x5c, 0x25, 0x51, 0x87,
      0x81, 0x40, 0x9d, 0xb4, 0x71, 0xc8, 0x3e, 0x84, 0xe5, 0x03, 0x32, 0xc4,
      0x7a, 0x18, 0x3a, 0x65, 0x7c, 0xe6, 0x0f, 0xd4, 0x4a, 0xd9, 0xa7, 0x86,
      0xb4, 0xd6, 0xae, 0x95, 0x06, 0xe5, 0x91, 0xa4, 0x49, 0xdc, 0x0c, 0x46,
      0xf6, 0x5d, 0x9d, 0xe5, 0x16, 0x50, 0x79, 0xbf, 0x5b, 0xb7, 0x76, 0xb7,
      0x0e, 0xeb, 0x82, 0x6e, 0x3c, 0x58, 0xdd, 0x7a, 0x91, 0x6e, 0x37, 0xd8,
      0x3b, 0x7e, 0xa6, 0xae, 0xf7, 0xa1, 0x2f, 0x1a, 0xae, 0x14, 0x62, 0x84,
      0x4b, 0x0b, 0xab, 0x4a, 0xcd, 0x4a, 0x5c, 0x9c, 0xff, 0xee, 0xc5, 0xc5,
      0x2b, 0x0a, 0x6d, 0x36, 0xeb, 0xb3, 0x4f, 0xac, 0xde, 0xf9, 0xc3, 0xdf,
      0xc4, 0x6d, 0x8a, 0x11, 0x5d, 0x38, 0x35, 0xce, 0xa3, 0x27, 0x75, 0x43,
      0x4e, 0x78, 0xdc, 0xdb, 0xc3, 0xe5, 0x44, 0x4c, 0x82, 0xc0, 0xfa, 0x23,
      0xf5, 0x2f, 0xca, 0xab, 0x3b, 0x8d, 0xec, 0x37, 0x2e, 0xf7, 0xb1, 0x9a,
      0x0b, 0x39, 0x1f, 0xfa, 0x81, 0x10, 0xe7, 0x7f, 0xbf, 0xb6, 0xfe, 0xa8,
      0xa8, 0xde, 0xf4, 0x6a, 0x5f, 0x6c, 0xe2, 0x05, 0x66, 0xaf, 0x9e, 0x09,
      0x18, 0x40, 0x4d, 0xf4, 0x44, 0x6d, 0x6a, 0x69, 0x30, 0x0e, 0xea, 0xda,
      0xc1, 0xb0, 0xf5, 0xb8, 0x16, 0x25, 0xf4, 0x4c, 0xb9, 0xab, 0xb1, 0x87,
      0x65, 0x72, 0x81, 0x5c, 0x23, 0x63, 0xe5, 0xd3, 0x66, 0x91, 0xe0, 0x70,
      0xc1, 0x9b, 0xaf, 0x8c, 0x65, 0x4e, 0x64, 0x40, 0x57, 0x27, 0x39, 0xc4,
      0x68, 0xab, 0x75, 0x89, 0xd2, 0x62, 0xd3, 0x99, 0x2f, 0xcd, 0xb2, 0x94,
      0x7d, 0x6f, 0x18, 0xe4, 0xbe, 0x55, 0x57, 0x24, 0x37, 0xe9, 0x55, 0xd7,
      0xf8, 0xb6, 0x0f, 0xf4, 0xb1, 0xf1, 0xdc, 0x9d, 0x0c, 0x5e, 0x6b, 0xde,
      0xdf, 0x91, 0x32, 0x25, 0xfc, 0x65, 0xb0, 0xac, 0xbe, 0x8b, 0x6b, 0xae,
      0xde, 0x36, 0x2c, 0xb6, 0x15, 0xe8, 0x6f, 0xa2, 0x33, 0x5e, 0xb8, 0x18,
      0x87, 0x8d, 0x3d, 0xd7, 0xbf, 0x68, 0x9d, 0xd4, 0x48, 0x20, 0x5c, 0xdf,
      0x14, 0xf6, 0x9c, 0xa5, 0x92, 0x5d, 0xf6, 0x6c, 0xf4, 0x21, 0xda, 0x22,
      0x00, 0x35, 0xbe, 0xbe, 0x9a, 0x78, 0xec, 0x5f, 0xda, 0x4c, 0x0e, 0x4f,
      0x49, 0xa4, 0x56, 0xf9, 0xfe, 0xfc, 0x79, 0x1f, 0xa9, 0x10, 0x9e, 0xaa,
      0xcb, 0x52, 0x1e, 0x27, 0xae, 0xe9, 0x5c, 0x12, 0x0f, 0x4f, 0x9c, 0xde,
      0x09, 0x3b, 0x7a, 0x80, 0x2d, 0xac, 0x80, 0x81, 0x0b, 0x9d, 0x4d, 0x57,
      0x93, 0x41, 0x66, 0x72, 0xb5, 0x8c, 0xa1, 0x92, 0x73, 0x28, 0x4a, 0x58,
      0x1a, 0xde, 0x84, 0xfd, 0x6d, 0x9b, 0xfa, 0x31, 0xa3, 0xb5, 0x25, 0x4b,
      0xec, 0xe8, 0x75, 0xa5, 0x6f, 0xb3, 0xad, 0x64, 0x51, 0xb1, 0xa6, 0x61},
     pub_key_2,
     {0x39, 0x38, 0x31, 0x37, 0x33, 0x32, 0x30, 0x32, 0x38, 0x37},
     true},

    // Comment:
    // tcID: 23
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     23,
     32,
     {0x2b, 0x04, 0xd2, 0x24, 0x78, 0x8e, 0x2e, 0x94, 0x20, 0x44, 0x86, 0xc1,
      0x11, 0xc0, 0xb0, 0x75, 0x40, 0xb8, 0xe7, 0x32, 0x4a, 0x8d, 0x57, 0x25,
      0x78, 0x41, 0xec, 0xdb, 0x77, 0xd6, 0xac, 0x90, 0x6a, 0xc7, 0x95, 0xdd,
      0xa7, 0x2d, 0x51, 0xb0, 0x54, 0xb5, 0xce, 0x6c, 0x52, 0x32, 0xe0, 0x61,
      0xa1, 0x8d, 0x67, 0xd6, 0x4c, 0x7c, 0x1b, 0x1e, 0xf1, 0xb6, 0x01, 0xcc,
      0xe2, 0x8b, 0x84, 0xed, 0x36, 0x45, 0xaf, 0xc6, 0x16, 0xee, 0xd7, 0xd1,
      0xed, 0x7c, 0x21, 0xfa, 0x34, 0x8a, 0x41, 0x8f, 0xc7, 0x41, 0x74, 0x49,
      0xbd, 0x99, 0x73, 0x40, 0xe9, 0x9c, 0x67, 0x2a, 0x5b, 0x83, 0xdc, 0x43,
      0x00, 0x3f, 0xff, 0x82, 0x77, 0x1a, 0x30, 0xb7, 0xb6, 0x66, 0xfe, 0xe4,
      0x0e, 0x07, 0x8d, 0xfb, 0xc7, 0xaf, 0x96, 0x9d, 0x1a, 0xad, 0xec, 0x23,
      0x7c, 0xcd, 0xe3, 0x89, 0x59, 0xa0, 0xb5, 0x85, 0x2b, 0xa0, 0xae, 0xb1,
      0x5d, 0x88, 0x64, 0xac, 0x41, 0xda, 0xca, 0xd4, 0x60, 0xe9, 0xe6, 0x9c,
      0xea, 0x03, 0x74, 0xcb, 0x90, 0xfe, 0x2d, 0xf0, 0x46, 0x80, 0x11, 0x40,
      0x9c, 0xbb, 0xec, 0x50, 0x85, 0xf3, 0x16, 0x84, 0x14, 0x21, 0x00, 0xc1,
      0x35, 0x21, 0x74, 0x2a, 0x47, 0xaf, 0x69, 0x62, 0xe7, 0xa3, 0x8d, 0x68,
      0x2f, 0x59, 0x1c, 0x8b, 0x63, 0xfe, 0x3f, 0x62, 0x96, 0x18, 0xaf, 0xa3,
      0x90, 0x25, 0x90, 0x90, 0x4f, 0x3c, 0x99, 0xbb, 0xd3, 0xf2, 0x68, 0x1f,
      0x42, 0x19, 0x67, 0x14, 0xcb, 0x6e, 0x59, 0xa6, 0x42, 0x22, 0x62, 0xb5,
      0xd6, 0xc8, 0x22, 0x0f, 0x65, 0x64, 0xcf, 0x35, 0xb3, 0x87, 0x3e, 0x35,
      0x60, 0x15, 0xae, 0x3d, 0xc6, 0xfb, 0xd2, 0x43, 0xc2, 0x9a, 0x8b, 0x40,
      0x43, 0xa3, 0x67, 0xa4, 0x9a, 0x0d, 0xd4, 0x4b, 0x92, 0x1d, 0x98, 0x00,
      0x5a, 0x7b, 0xb0, 0x47, 0x83, 0x71, 0x71, 0x0c, 0x4a, 0x86, 0x7a, 0x00,
      0x22, 0x74, 0x24, 0x49, 0xd5, 0x94, 0xa3, 0x21, 0x72, 0x77, 0x76, 0xd9,
      0x06, 0xe6, 0x36, 0xc4, 0xf1, 0xc7, 0x98, 0xa6, 0x5d, 0xf8, 0x18, 0x4d,
      0x7c, 0x82, 0x61, 0x41, 0x3b, 0x16, 0xa4, 0x54, 0x4c, 0x37, 0xa8, 0xbf,
      0xd4, 0xa3, 0xfc, 0xc4, 0xdd, 0x0c, 0xca, 0x3c, 0x30, 0x49, 0xc0, 0x44,
      0x6d, 0xc0, 0xe2, 0x7e, 0x33, 0x4c, 0x70, 0xf6, 0x67, 0x87, 0xd8, 0xbf,
      0xce, 0x5b, 0xd9, 0xdc, 0x2c, 0xc5, 0x81, 0x1a, 0xd9, 0x25, 0x18, 0xe6,
      0x79, 0xe8, 0xd2, 0x19, 0x92, 0x63, 0x21, 0xb0, 0xe7, 0xc7, 0x7d, 0x47,
      0x43, 0xdb, 0x31, 0x8a, 0xc1, 0xe4, 0x7f, 0x6a, 0x5d, 0xbf, 0x3f, 0x6c,
      0x53, 0x83, 0x1a, 0x2e, 0xc8, 0x82, 0x9a, 0x07, 0x12, 0x5f, 0x5a, 0xfc,
      0xa4, 0xf9, 0xf2, 0x7a, 0x96, 0x8f, 0xe5, 0xd2, 0x69, 0xd5, 0xd4, 0x27},
     pub_key_2,
     {0x33, 0x32, 0x32, 0x32, 0x30, 0x34, 0x31, 0x30, 0x34, 0x36},
     true},

    // Comment:
    // tcID: 24
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     24,
     32,
     {0x3e, 0xd7, 0x9e, 0x78, 0x05, 0xfd, 0x64, 0xff, 0xfe, 0x18, 0x63, 0xe6,
      0xe9, 0x23, 0x3a, 0x50, 0x2b, 0xdf, 0x1e, 0x35, 0x62, 0x27, 0x99, 0xa3,
      0xfd, 0x4d, 0xa7, 0x6a, 0x23, 0xa8, 0x0e, 0x3e, 0x6f, 0xca, 0xb6, 0x1e,
      0x5c, 0x3f, 0x62, 0x14, 0x74, 0xe9, 0x1b, 0x90, 0xa4, 0x3b, 0x36, 0xed,
      0xe2, 0x7a, 0x86, 0x27, 0x46, 0x0d, 0x04, 0xa7, 0x46, 0x77, 0xae, 0x09,
      0x94, 0xe9, 0x49, 0xb7, 0xb9, 0x3e, 0x01, 0x86, 0x8c, 0x54, 0x13, 0xaf,
      0x61, 0xdc, 0xb5, 0xa9, 0x29, 0x0f, 0x92, 0x1f, 0xdc, 0x24, 0x07, 0x3e,
      0x5c, 0x7a, 0x85, 0xce, 0x91, 0x00, 0x16, 0xc2, 0x87, 0x2e, 0xa4, 0x10,
      0xc2, 0x39, 0xaf, 0x0a, 0x33, 0x73, 0x0e, 0xd8, 0x95, 0x79, 0xf8, 0xd1,
      0xf0, 0x74, 0x3e, 0xbe, 0xc1, 0xe5, 0x56, 0x00, 0xfe, 0xa2, 0xa3, 0xa9,
      0x8e, 0x49, 0xac, 0x1c, 0x5a, 0xe1, 0x2e, 0x3c, 0x27, 0xc3, 0x2d, 0xf9,
      0xea, 0x5f, 0xef, 0xeb, 0x5c, 0x4d, 0x00, 0x4c, 0xed, 0xbc, 0xdd, 0x30,
      0xcb, 0xfc, 0x00, 0xfc, 0x21, 0xb4, 0xaa, 0x5b, 0x17, 0x2e, 0x87, 0xd3,
      0x49, 0x20, 0xc6, 0xdd, 0x31, 0xd9, 0xc8, 0x0d, 0xb4, 0x0c, 0xad, 0xca,
      0xc6, 0x34, 0x16, 0x34, 0xec, 0xf8, 0xc2, 0x8f, 0xdb, 0x3c, 0xba, 0xe6,
      0xc2, 0x36, 0xa7, 0x13, 0x22, 0xb8, 0x1a, 0xbb, 0x91, 0x37, 0xba, 0xaa,
      0x83, 0xf6, 0x58, 0x26, 0xf1, 0xd6, 0x6e, 0x51, 0x1f, 0x72, 0x79, 0x35,
      0xe0, 0x1f, 0x16, 0xcc, 0x70, 0xc5, 0xab, 0x78, 0x45, 0x1f, 0x2f, 0xc1,
      0x99, 0xc0, 0x20, 0x51, 0x78, 0x9c, 0x36, 0x83, 0xbc, 0x57, 0x31, 0x90,
      0xad, 0xec, 0xfc, 0x04, 0x14, 0x05, 0xc9, 0xa3, 0xaa, 0x8a, 0x6e, 0x36,
      0xb5, 0xb4, 0xf0, 0x16, 0x58, 0x9d, 0x21, 0x4d, 0xa8, 0xbb, 0xb2, 0xe7,
      0x45, 0x6b, 0x50, 0x59, 0x9e, 0xce, 0x0d, 0x8b, 0x61, 0xf1, 0x06, 0x95,
      0x5c, 0xdd, 0x38, 0xeb, 0x73, 0x7d, 0xb4, 0xfd, 0x52, 0x78, 0x3d, 0x60,
      0x67, 0x6a, 0xf3, 0x0c, 0x0d, 0x58, 0xbc, 0xb4, 0x46, 0x55, 0x21, 0x0d,
      0x2d, 0x53, 0xf1, 0xd7, 0x00, 0x1c, 0x92, 0x5f, 0x74, 0x75, 0x40, 0x41,
      0xe9, 0x4b, 0x92, 0x51, 0xd9, 0x50, 0x78, 0x4b, 0xbd, 0xe1, 0x35, 0xef,
      0x91, 0x08, 0xff, 0xaf, 0x59, 0x17, 0x0f, 0xe7, 0x6d, 0x07, 0x20, 0x11,
      0xad, 0x7f, 0xd1, 0xcf, 0x1a, 0xe2, 0x76, 0x31, 0x40, 0x37, 0x6b, 0xe7,
      0x01, 0xa5, 0x21, 0x0b, 0x29, 0xfa, 0xef, 0x9e, 0x25, 0x01, 0xcb, 0x3e,
      0x27, 0x69, 0x95, 0x52, 0x30, 0xbc, 0xef, 0xf7, 0xca, 0x53, 0xaf, 0xce,
      0x81, 0x09, 0xb7, 0xcd, 0xd3, 0x81, 0x2f, 0x41, 0x24, 0x82, 0xf8, 0x15,
      0x7d, 0x55, 0xac, 0xde, 0xad, 0xea, 0x7d, 0x9a, 0x3b, 0x31, 0x43, 0x65},
     pub_key_2,
     {0x36, 0x36, 0x36, 0x36, 0x33, 0x30, 0x37, 0x31, 0x30, 0x34},
     true},

    // Comment:
    // tcID: 25
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     25,
     32,
     {0x07, 0x23, 0x89, 0x93, 0x59, 0x94, 0x03, 0x3e, 0xb7, 0xa1, 0xbd, 0x07,
      0xc3, 0xdd, 0xeb, 0x07, 0xf6, 0x45, 0x89, 0x18, 0x0b, 0xb5, 0xa0, 0x44,
      0x5f, 0x7c, 0x36, 0x41, 0x2d, 0xe2, 0x02, 0x1c, 0xf7, 0x71, 0x52, 0x54,
      0x52, 0x8c, 0x7b, 0xa9, 0x56, 0x05, 0x04, 0x5d, 0x21, 0x95, 0x49, 0x9e,
      0x09, 0x5b, 0xee, 0xa8, 0x26, 0xd0, 0xf8, 0x6d, 0xa9, 0x38, 0x60, 0x78,
      0xb8, 0x3a, 0x64, 0xc4, 0xe3, 0xda, 0xbd, 0x43, 0x41, 0x5f, 0x68, 0xa1,
      0xb4, 0xf0, 0x83, 0x81, 0xed, 0x29, 0x01, 0x82, 0x72, 0x71, 0x02, 0xe8,
      0x75, 0xbd, 0xc2, 0x85, 0x4a, 0x28, 0xa7, 0x25, 0xa8, 0xb9, 0x93, 0x4d,
      0xea, 0x06, 0xa8, 0x79, 0x9c, 0x46, 0x46, 0x3a, 0x21, 0xa9, 0x94, 0x9f,
      0x8b, 0xc1, 0x9f, 0x87, 0xb5, 0xc0, 0xea, 0xbe, 0xbd, 0x25, 0x20, 0x0c,
      0x1a, 0xea, 0x8e, 0xb8, 0xae, 0x35, 0xbe, 0x9b, 0x15, 0x3a, 0xe5, 0x4e,
      0x11, 0xf3, 0x48, 0xbe, 0x42, 0x11, 0x27, 0xb4, 0xbf, 0xa8, 0x98, 0x2c,
      0xb7, 0xdb, 0x0a, 0x12, 0x2a, 0x7b, 0x68, 0xc0, 0xf4, 0x49, 0x67, 0x66,
      0xc9, 0x25, 0x02, 0x52, 0xc7, 0x5f, 0xfc, 0x31, 0x7e, 0x6c, 0x2a, 0x81,
      0x9e, 0xdf, 0x70, 0x60, 0x9a, 0x8a, 0x59, 0x35, 0xfc, 0x8e, 0x06, 0x55,
      0x4b, 0x84, 0xf3, 0x1a, 0x5a, 0x2e, 0x1c, 0xa8, 0x55, 0xf9, 0x6c, 0x86,
      0xac, 0xc1, 0x24, 0x59, 0xcf, 0xe9, 0x2b, 0x61, 0x35, 0x73, 0xaf, 0x36,
      0x55, 0x02, 0x36, 0x5a, 0x3a, 0x3f, 0x7c, 0xd0, 0x47, 0xff, 0x3a, 0x22,
      0x7f, 0xc0, 0x9c, 0x54, 0x94, 0x03, 0x6d, 0x39, 0xc7, 0x88, 0x7b, 0xf1,
      0xf1, 0x1d, 0xae, 0x79, 0xf8, 0x3c, 0x0d, 0x4f, 0xe7, 0xcf, 0xa0, 0x2c,
      0x8e, 0x11, 0x56, 0x1f, 0x35, 0x1f, 0x86, 0xb6, 0x91, 0xa1, 0x4a, 0xf9,
      0x45, 0x35, 0x32, 0x84, 0xf9, 0xc7, 0xc0, 0xea, 0x73, 0xd5, 0x38, 0x90,
      0x49, 0xca, 0x01, 0x95, 0xcb, 0x10, 0x3f, 0xa8, 0x1f, 0x45, 0xca, 0x01,
      0xa1, 0x7c, 0x7a, 0x85, 0x7a, 0x14, 0x22, 0x23, 0xf6, 0x7c, 0x85, 0x51,
      0x30, 0x34, 0x78, 0xcf, 0x79, 0x1f, 0x0f, 0x63, 0x8e, 0x02, 0xe6, 0x0c,
      0x7f, 0x94, 0x52, 0xf8, 0x48, 0xeb, 0xf0, 0xb6, 0xd6, 0xd8, 0xd0, 0x05,
      0x9b, 0xf8, 0xa2, 0xd5, 0x13, 0x22, 0x1c, 0x38, 0x5c, 0xe0, 0x75, 0xe8,
      0xab, 0xe3, 0xae, 0x0a, 0x7d, 0xf9, 0xe6, 0x50, 0x90, 0xca, 0x27, 0x85,
      0x28, 0x6b, 0x24, 0x5c, 0xf5, 0xce, 0x73, 0x4e, 0x4d, 0xd2, 0xa2, 0x57,
      0x74, 0x58, 0x3a, 0x4a, 0xec, 0x4f, 0xc1, 0xce, 0xd4, 0x02, 0xf2, 0x5c,
      0x23, 0x53, 0xbd, 0xe8, 0x0c, 0x2e, 0xf3, 0xee, 0xdc, 0xb5, 0xb7, 0x61,
      0xa7, 0xf2, 0xb8, 0x7c, 0x20, 0x1f, 0x3d, 0x5f, 0x9c, 0x08, 0xd3, 0xa5},
     pub_key_2,
     {0x31, 0x30, 0x33, 0x35, 0x39, 0x35, 0x31, 0x38, 0x39, 0x38},
     true},

    // Comment:
    // tcID: 26
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     26,
     32,
     {0x9c, 0x43, 0x68, 0x8f, 0x7c, 0xcc, 0x42, 0x86, 0xe1, 0x04, 0xc6, 0x53,
      0xc8, 0x79, 0x79, 0xab, 0xfb, 0x36, 0x86, 0x9a, 0x82, 0xff, 0x4b, 0xc2,
      0xc6, 0xcb, 0xeb, 0x4d, 0xdc, 0xd4, 0xc5, 0x1b, 0x83, 0x33, 0x67, 0xac,
      0x00, 0x09, 0x8a, 0x84, 0xce, 0xef, 0x06, 0x2a, 0xf0, 0xa0, 0xc0, 0xde,
      0xc4, 0x6b, 0x54, 0xd7, 0x26, 0xf3, 0x7d, 0xf1, 0x17, 0x76, 0x2f, 0x83,
      0x87, 0x26, 0x11, 0xaa, 0x49, 0x5a, 0x88, 0xe6, 0x9f, 0xe0, 0xe3, 0x1e,
      0x58, 0xce, 0xe9, 0x1e, 0x3b, 0x70, 0x98, 0x7f, 0xf1, 0x7f, 0x70, 0x3a,
      0x39, 0xa7, 0xaf, 0x95, 0xee, 0x41, 0x21, 0xb5, 0xbc, 0x09, 0x2b, 0xb4,
      0xa1, 0x30, 0x64, 0x35, 0xd0, 0x94, 0xa9, 0x31, 0x53, 0xee, 0x22, 0xdc,
      0x50, 0xd4, 0xd4, 0x84, 0x5c, 0x60, 0xaa, 0x06, 0x5a, 0xa0, 0x3c, 0xa6,
      0xf3, 0x27, 0xdd, 0xb3, 0xc8, 0x70, 0xac, 0x69, 0x3b, 0x56, 0x79, 0xab,
      0x33, 0x90, 0xe6, 0x78, 0x2d, 0xac, 0x49, 0xb7, 0x6f, 0x71, 0xa0, 0xdd,
      0x63, 0x54, 0x24, 0x01, 0x84, 0xf8, 0xdd, 0x94, 0x00, 0xdd, 0x84, 0xbc,
      0x29, 0x59, 0x23, 0x4a, 0x3c, 0x9a, 0xea, 0x08, 0xb4, 0xce, 0x78, 0x1d,
      0x38, 0x40, 0x5e, 0xea, 0xd7, 0x54, 0xb8, 0xf3, 0xcf, 0x4c, 0x5b, 0xdd,
      0x0c, 0xbf, 0x3a, 0x15, 0x01, 0x7e, 0xf4, 0xbb, 0x58, 0x13, 0xbc, 0x9b,
      0xd5, 0x57, 0xfe, 0x28, 0x8c, 0xbe, 0x32, 0xe6, 0xf6, 0x65, 0x9d, 0xdc,
      0xb0, 0x1e, 0xe1, 0x0a, 0x48, 0xa9, 0xf9, 0xd3, 0x3c, 0xb5, 0xe5, 0x71,
      0x64, 0xfa, 0x77, 0x78, 0x4c, 0x89, 0xb6, 0xe9, 0xa5, 0x5b, 0xa6, 0x59,
      0x99, 0xf7, 0xcd, 0x61, 0x17, 0x0d, 0x82, 0x6f, 0x89, 0xe3, 0xcb, 0xae,
      0x12, 0x3d, 0xde, 0xbe, 0x1d, 0x2b, 0xcf, 0x2d, 0xac, 0x72, 0xa7, 0x98,
      0xee, 0x9d, 0x2a, 0x47, 0xe8, 0x0f, 0x1e, 0x73, 0xad, 0x28, 0xc6, 0x51,
      0x6b, 0x27, 0x10, 0x12, 0x73, 0x3e, 0x3d, 0x8c, 0x3d, 0xb6, 0x95, 0x42,
      0x9d, 0x0d, 0x67, 0x30, 0x2e, 0x53, 0x33, 0xf1, 0xaf, 0xab, 0xe6, 0xc3,
      0x6c, 0xab, 0xac, 0x97, 0xc4, 0xf3, 0x02, 0xe2, 0x8b, 0x3a, 0x08, 0x21,
      0xdb, 0x91, 0x5b, 0x10, 0xc1, 0xe5, 0xbe, 0xdb, 0x64, 0xbc, 0x5b, 0x88,
      0xd9, 0x9b, 0x7f, 0xbd, 0x32, 0xd3, 0xaf, 0x00, 0xb0, 0x62, 0x01, 0xc6,
      0x4f, 0xa6, 0x6f, 0x38, 0xfc, 0xf4, 0x19, 0x03, 0xa7, 0xef, 0x1d, 0xf4,
      0x26, 0x5c, 0x0e, 0x12, 0x0d, 0x1a, 0xcc, 0xb6, 0x31, 0xc4, 0x3b, 0x7b,
      0x8f, 0xd4, 0x9f, 0x8f, 0x77, 0xe2, 0x28, 0xb5, 0x50, 0x65, 0x6f, 0xf7,
      0xca, 0xeb, 0x79, 0x37, 0x8d, 0xc3, 0xb8, 0x68, 0xba, 0x63, 0xd8, 0xe9,
      0x7b, 0x83, 0x2b, 0xa1, 0x82, 0x24, 0xd0, 0x8c, 0xc8, 0x7e, 0x67, 0xcf},
     pub_key_2,
     {0x31, 0x38, 0x34, 0x36, 0x35, 0x39, 0x37, 0x31, 0x39, 0x35},
     true},

    // Comment:
    // tcID: 27
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     27,
     32,
     {0x80, 0x7f, 0x9a, 0x9f, 0x0f, 0xe0, 0xf0, 0x4c, 0x59, 0xcd, 0xb1, 0xf8,
      0x7b, 0xe6, 0x0f, 0x51, 0x0d, 0xfe, 0xf3, 0xaf, 0xbf, 0x5f, 0xc8, 0xd1,
      0x3a, 0xa7, 0x35, 0x77, 0x8a, 0x4c, 0x88, 0x23, 0xe8, 0x28, 0x04, 0x65,
      0x0a, 0x83, 0x7a, 0xfa, 0xc8, 0x49, 0xe7, 0x8c, 0x8d, 0x1f, 0xd8, 0x1b,
      0x36, 0x4e, 0x98, 0x58, 0x9d, 0xa3, 0xf2, 0x09, 0x2b, 0xae, 0x5f, 0x7c,
      0x04, 0x1e, 0xc0, 0xc3, 0x99, 0xb9, 0x94, 0xcf, 0xa8, 0x9b, 0xc3, 0xc3,
      0x01, 0xec, 0x39, 0x80, 0xf7, 0xbf, 0xc7, 0x89, 0xa7, 0x83, 0x8d, 0x21,
      0x28, 0x66, 0xa5, 0x00, 0x76, 0x3b, 0x5d, 0x29, 0x09, 0x4f, 0x11, 0x2a,
      0xd5, 0x72, 0xb2, 0xa8, 0x25, 0xf1, 0x95, 0x10, 0x86, 0x9c, 0x5c, 0x6e,
      0x67, 0x52, 0x09, 0xc7, 0x22, 0xbe, 0x18, 0xcb, 0x9d, 0xe4, 0xa9, 0x5b,
      0x90, 0x2d, 0x46, 0x72, 0x4d, 0x64, 0x13, 0x58, 0x1c, 0xce, 0x11, 0x3a,
      0x53, 0x99, 0x1d, 0x74, 0x8a, 0xd8, 0xfd, 0x13, 0x26, 0x43, 0xbc, 0xa1,
      0xe5, 0xfd, 0x30, 0x52, 0x47, 0x04, 0x4e, 0xfe, 0xa0, 0x7f, 0x5b, 0x17,
      0x14, 0x5e, 0xf2, 0xf0, 0x3f, 0xaa, 0x8b, 0x13, 0xbe, 0x02, 0xd4, 0x94,
      0x45, 0xf8, 0x86, 0x4e, 0x1e, 0x0b, 0x00, 0x51, 0xf5, 0xb5, 0x94, 0xd1,
      0xf0, 0xb9, 0x12, 0x14, 0x8d, 0xb8, 0x2a, 0x68, 0x83, 0x30, 0x1d, 0x53,
      0x28, 0x39, 0xf6, 0x25, 0x0f, 0x0c, 0x34, 0xa1, 0xc1, 0x7a, 0x7e, 0x08,
      0x87, 0xf4, 0x2e, 0x65, 0x0e, 0x26, 0xea, 0xc3, 0xf9, 0xcc, 0x45, 0x3b,
      0x69, 0xc1, 0x2b, 0xc6, 0x54, 0x8e, 0x06, 0xa3, 0x7d, 0xc9, 0x05, 0xde,
      0xd4, 0x80, 0x26, 0xd0, 0x8f, 0x32, 0xa1, 0x7c, 0x7a, 0x76, 0xd5, 0x46,
      0x29, 0x65, 0x40, 0x19, 0x4e, 0x95, 0xab, 0x33, 0x10, 0xa7, 0xbb, 0xaf,
      0x0c, 0x6a, 0x2e, 0x97, 0x34, 0xd8, 0x52, 0x2a, 0xb4, 0x6f, 0xf4, 0x57,
      0xf5, 0xa5, 0x02, 0x38, 0xee, 0xaa, 0x40, 0x27, 0x32, 0x5d, 0x2a, 0x48,
      0xe2, 0xeb, 0x0c, 0x0a, 0xe7, 0x93, 0x12, 0x96, 0xd1, 0x6a, 0xf2, 0x5a,
      0xbd, 0x5e, 0x6c, 0x2a, 0xb0, 0x0f, 0x7b, 0x07, 0xf5, 0xf2, 0x1e, 0xdb,
      0x70, 0x34, 0x18, 0x0c, 0xfa, 0x0b, 0x3f, 0xd3, 0xcf, 0xd3, 0x4b, 0x80,
      0x4d, 0x3d, 0x12, 0x52, 0x91, 0x27, 0x44, 0x75, 0xe2, 0xd3, 0xac, 0x97,
      0xbd, 0xc2, 0xba, 0xa2, 0x08, 0x89, 0x2f, 0xb0, 0x41, 0x75, 0x65, 0xfe,
      0x9f, 0x7e, 0x98, 0x7e, 0x1c, 0x2a, 0x1e, 0xa0, 0x4c, 0x51, 0x34, 0x72,
      0x78, 0xac, 0x2e, 0x3f, 0x85, 0x0d, 0x35, 0x5e, 0x3a, 0xc6, 0xad, 0xff,
      0x00, 0x7d, 0x15, 0x86, 0x97, 0x37, 0x2f, 0x42, 0xf3, 0x0b, 0xef, 0x18,
      0x5c, 0xb1, 0xb9, 0xba, 0x2f, 0x04, 0x58, 0x48, 0x0f, 0x0f, 0xf6, 0xe1},
     pub_key_2,
     {0x33, 0x31, 0x33, 0x36, 0x30, 0x34, 0x36, 0x31, 0x38, 0x39},
     true},

    // Comment:
    // tcID: 28
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     28,
     32,
     {0x30, 0x91, 0x94, 0x7d, 0x5f, 0xa8, 0xbd, 0xeb, 0x46, 0x3a, 0x0a, 0x5c,
      0x32, 0x80, 0x4f, 0xd2, 0x44, 0x20, 0x3f, 0xde, 0x74, 0x75, 0x9a, 0x31,
      0x01, 0xa4, 0x75, 0x18, 0xb6, 0x8e, 0xb9, 0x99, 0x48, 0xd6, 0x25, 0xb4,
      0xf9, 0xbb, 0xc3, 0x84, 0x86, 0x2e, 0x6b, 0x33, 0xc5, 0xb4, 0xc4, 0xfa,
      0xe2, 0x40, 0xb7, 0x82, 0xb0, 0xbc, 0xb2, 0x98, 0xe5, 0xea, 0x09, 0x05,
      0x42, 0xf9, 0xf0, 0xc1, 0xa0, 0xcf, 0x21, 0xa4, 0x2a, 0xb1, 0x11, 0xcb,
      0x1c, 0x80, 0x72, 0xe6, 0x25, 0xf6, 0x01, 0x89, 0x09, 0x2a, 0x71, 0x64,
      0x33, 0x9e, 0x5d, 0x1e, 0xb7, 0x7a, 0xa0, 0x7b, 0x4d, 0x8b, 0x9c, 0xbf,
      0x85, 0x0e, 0xf0, 0x90, 0x7f, 0x28, 0x9e, 0x2b, 0x8b, 0x2c, 0xd6, 0x1f,
      0xd1, 0x84, 0xaf, 0x76, 0x48, 0x40, 0x4a, 0x9b, 0x15, 0xe5, 0x96, 0xdd,
      0xb5, 0x87, 0x98, 0xed, 0x43, 0x8a, 0xe4, 0xa6, 0x32, 0x5a, 0xdf, 0x39,
      0xc4, 0x74, 0x53, 0x60, 0x95, 0x5e, 0x6a, 0x6c, 0x06, 0x0e, 0xda, 0xcc,
      0xd3, 0x81, 0x42, 0x10, 0x20, 0x38, 0xbd, 0x8f, 0x1d, 0x9d, 0x5a, 0x33,
      0xf3, 0x9f, 0xb1, 0x2f, 0x0c, 0x93, 0x5e, 0xc9, 0x8a, 0x0c, 0x00, 0xef,
      0xd9, 0x3b, 0xee, 0xdd, 0x16, 0xf3, 0x40, 0x12, 0x99, 0x77, 0xcc, 0xa9,
      0x09, 0x99, 0xe7, 0x73, 0xb0, 0xca, 0x93, 0x09, 0xb8, 0xda, 0x7c, 0x33,
      0xa4, 0xf7, 0xdb, 0x34, 0x66, 0x31, 0xbc, 0xdf, 0xb3, 0xb1, 0x2c, 0x81,
      0x83, 0xa4, 0xa3, 0x62, 0x8d, 0x71, 0x3a, 0x96, 0x67, 0xed, 0x70, 0xc9,
      0xf8, 0x3a, 0xcc, 0x27, 0x97, 0x08, 0x6f, 0x5f, 0xd5, 0x68, 0x5d, 0xad,
      0x61, 0x27, 0xed, 0xe0, 0x4e, 0x60, 0x36, 0x75, 0x8d, 0xdf, 0xeb, 0xa4,
      0xda, 0x38, 0x5f, 0xe7, 0x22, 0xe2, 0x49, 0xf8, 0x83, 0x66, 0xfb, 0xab,
      0x3f, 0x8f, 0x65, 0xa0, 0x25, 0x12, 0xf2, 0x86, 0xce, 0x0f, 0xe2, 0x1f,
      0x77, 0xb2, 0x62, 0xd5, 0xdb, 0x77, 0x87, 0xad, 0x02, 0x18, 0xb3, 0xb3,
      0x0f, 0x76, 0xc3, 0x3f, 0x75, 0x60, 0x66, 0x83, 0x64, 0x22, 0x3b, 0x65,
      0xa9, 0x6a, 0x27, 0x2e, 0x23, 0xda, 0x28, 0x53, 0x46, 0xe0, 0x87, 0xf6,
      0x7a, 0xf3, 0x31, 0xfd, 0xa3, 0x1c, 0x50, 0x7c, 0x36, 0x48, 0x02, 0x93,
      0x54, 0x07, 0xb4, 0x55, 0xb6, 0x7c, 0xd0, 0x5c, 0xbb, 0x15, 0xae, 0xbf,
      0xa3, 0xb7, 0xfe, 0x2e, 0x03, 0x1d, 0x75, 0x47, 0xdf, 0xa8, 0xaa, 0x36,
      0x08, 0xbd, 0xd4, 0xee, 0x2f, 0x72, 0x2b, 0x1b, 0x4a, 0xb8, 0x51, 0x37,
      0x7b, 0xf1, 0x0d, 0x42, 0xa1, 0xb2, 0xb3, 0x33, 0x41, 0xa5, 0x3a, 0x7c,
      0xe1, 0x09, 0x4a, 0xe3, 0x34, 0x18, 0xf2, 0x2c, 0x7b, 0xbe, 0x84, 0xab,
      0x8b, 0x8b, 0xbf, 0x72, 0x26, 0x58, 0x4b, 0xb6, 0x90, 0x59, 0x25, 0x92},
     pub_key_2,
     {0x32, 0x36, 0x36, 0x33, 0x37, 0x38, 0x34, 0x32, 0x35, 0x34},
     true},

    // Comment:
    // tcID: 29
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     29,
     32,
     {0x7a, 0xac, 0x4a, 0xe7, 0x76, 0x95, 0x4d, 0xf9, 0xe6, 0xc8, 0x82, 0x89,
      0xa0, 0x8c, 0x15, 0x81, 0x05, 0x2f, 0x81, 0x85, 0x3c, 0xca, 0xca, 0x02,
      0x9e, 0x6b, 0xdb, 0x56, 0x4f, 0x91, 0xe5, 0x29, 0xd8, 0x22, 0x3c, 0x76,
      0x85, 0x53, 0x71, 0x81, 0xd1, 0xa7, 0x5a, 0xdb, 0xf7, 0xbc, 0xba, 0xe0,
      0x89, 0xa7, 0xd1, 0x77, 0xba, 0x6c, 0x83, 0xbb, 0x70, 0x4d, 0xd4, 0x27,
      0xfc, 0x42, 0x09, 0x3a, 0x1b, 0xf1, 0xea, 0x66, 0x88, 0x6d, 0x79, 0x46,
      0xea, 0xc4, 0xb8, 0x11, 0xa1, 0x11, 0xb6, 0x3b, 0x46, 0x4d, 0xa8, 0xff,
      0x91, 0x00, 0x42, 0xa3, 0x5f, 0xac, 0x71, 0x4e, 0x8a, 0xdf, 0x5d, 0xca,
      0x82, 0x7b, 0xb3, 0x84, 0xcb, 0x3f, 0xb0, 0x40, 0x31, 0x2c, 0x04, 0xfe,
      0x8d, 0x52, 0x63, 0xfb, 0x02, 0xa9, 0xd0, 0x82, 0x76, 0xd5, 0x3e, 0xe9,
      0x66, 0xb6, 0x90, 0xab, 0x28, 0x72, 0xd6, 0xc1, 0x02, 0xa7, 0xf4, 0x15,
      0xfb, 0xb1, 0x94, 0x20, 0xbf, 0xa5, 0x86, 0x15, 0x67, 0xee, 0x50, 0x15,
      0x8a, 0x4e, 0xe1, 0x41, 0xdb, 0xab, 0x2e, 0xb6, 0x40, 0xd7, 0xad, 0x76,
      0x8f, 0xcb, 0x68, 0xd9, 0xa4, 0xb1, 0x99, 0x32, 0x9d, 0x13, 0x07, 0x60,
      0x90, 0xe9, 0x65, 0x5c, 0x33, 0xbb, 0x79, 0x1e, 0xa8, 0x30, 0x40, 0x1e,
      0x2d, 0xa5, 0x7e, 0x11, 0x0e, 0xf0, 0x68, 0xa9, 0x9d, 0x26, 0x0a, 0x1f,
      0xd4, 0x8f, 0x10, 0x4f, 0x55, 0x58, 0x26, 0x45, 0x42, 0xe6, 0xfe, 0xe2,
      0x6e, 0xff, 0x4e, 0xcb, 0xa4, 0xf9, 0xdf, 0x16, 0x33, 0x0e, 0x2b, 0x00,
      0x0e, 0xd9, 0xd3, 0x78, 0x55, 0xb0, 0xa1, 0x4f, 0x1b, 0x72, 0x65, 0xfa,
      0x0d, 0xb6, 0x35, 0x6b, 0xf2, 0x60, 0x30, 0x84, 0x10, 0xc8, 0x99, 0xfd,
      0x00, 0xd7, 0x95, 0xbe, 0xdc, 0x5e, 0x1d, 0xaa, 0x2b, 0x3b, 0x8e, 0x58,
      0x78, 0x4a, 0x2e, 0x0d, 0xe1, 0x6a, 0x3b, 0xb0, 0xf6, 0x4b, 0xf7, 0x3a,
      0x50, 0xbd, 0x3c, 0x2e, 0xbb, 0x46, 0x2a, 0x25, 0x80, 0xca, 0xdb, 0xb6,
      0xa1, 0xe6, 0x11, 0x83, 0x6a, 0x60, 0xb7, 0xc8, 0xb6, 0xc1, 0x08, 0x3c,
      0x9d, 0x29, 0xea, 0xd4, 0xbd, 0x0b, 0x62, 0x7e, 0x53, 0x8b, 0x8e, 0xaa,
      0xc3, 0x98, 0xdd, 0x72, 0x18, 0xda, 0xcf, 0xb2, 0x90, 0x51, 0x33, 0xfe,
      0x7c, 0x31, 0xbe, 0xf2, 0x9b, 0xb1, 0x34, 0x6d, 0x4e, 0x61, 0x63, 0x64,
      0x98, 0x54, 0xa6, 0xc7, 0xb3, 0x25, 0xf2, 0x14, 0x9a, 0xd9, 0x1b, 0x8d,
      0x8b, 0x82, 0x7d, 0xe2, 0x78, 0xdb, 0x00, 0xdd, 0x0d, 0xd9, 0x82, 0x7a,
      0xf6, 0x2f, 0xa2, 0x29, 0xbd, 0xfb, 0xec, 0x0c, 0x71, 0xcb, 0xe9, 0x61,
      0xbf, 0xa7, 0xed, 0x25, 0x96, 0x69, 0x20, 0x75, 0x3d, 0xeb, 0xdb, 0x70,
      0xe3, 0xd6, 0x1c, 0xa7, 0x47, 0xec, 0x55, 0xc4, 0xbb, 0x05, 0xba, 0xe2},
     pub_key_2,
     {0x31, 0x36, 0x35, 0x32, 0x31, 0x30, 0x30, 0x35, 0x32, 0x34},
     true},

    // Comment:
    // tcID: 30
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     30,
     32,
     {0xaa, 0x16, 0x54, 0x29, 0xaf, 0x52, 0x69, 0xd3, 0x5d, 0x74, 0xe8, 0xb0,
      0x33, 0xff, 0x4d, 0xb8, 0x82, 0x28, 0x2d, 0x22, 0xb6, 0x0a, 0x24, 0x1e,
      0x6d, 0x0a, 0x54, 0x6d, 0xc1, 0x91, 0xd0, 0x3c, 0x0f, 0x75, 0x24, 0x8d,
      0xb4, 0xdc, 0x83, 0x3c, 0x58, 0x7d, 0xb4, 0x1b, 0x9c, 0x43, 0x8f, 0x48,
      0x5a, 0x21, 0x52, 0xf8, 0xf8, 0x16, 0x17, 0x75, 0x65, 0x33, 0xcb, 0x15,
      0xdb, 0xd0, 0xc7, 0x56, 0x5a, 0x64, 0x03, 0x27, 0xdc, 0x64, 0xda, 0x2b,
      0xad, 0xc2, 0x30, 0x52, 0xde, 0x4b, 0x8d, 0xbe, 0xb9, 0x47, 0x70, 0x56,
      0xba, 0xce, 0xe1, 0xeb, 0x95, 0xe9, 0x3a, 0xf4, 0x6d, 0x6d, 0x68, 0xcc,
      0x79, 0x57, 0x78, 0xb3, 0x50, 0x6b, 0x14, 0xde, 0x84, 0x28, 0xfb, 0xe8,
      0x78, 0x26, 0x00, 0xe1, 0x0d, 0xf7, 0xcc, 0xe9, 0x86, 0x70, 0x49, 0x4e,
      0xfb, 0xda, 0x15, 0x89, 0x0f, 0x72, 0xcf, 0x08, 0x93, 0x57, 0xd7, 0x43,
      0xe9, 0xed, 0x68, 0x1a, 0x14, 0xb8, 0x4c, 0x15, 0x9b, 0x92, 0xcd, 0x5c,
      0x25, 0x9e, 0x6d, 0xa4, 0x5e, 0xdc, 0x34, 0x84, 0xa8, 0x53, 0xad, 0x74,
      0xdf, 0xe9, 0x9f, 0x1b, 0x39, 0xdf, 0x3d, 0x3b, 0x20, 0x81, 0x1c, 0x89,
      0xc5, 0x04, 0x70, 0x47, 0xa8, 0x3b, 0x67, 0xaf, 0xc9, 0x44, 0x40, 0x1a,
      0x6e, 0x99, 0xd9, 0xdc, 0xbe, 0x55, 0x75, 0x6f, 0xaa, 0x16, 0xdd, 0x21,
      0x7e, 0xe3, 0x81, 0x2d, 0x7b, 0x2d, 0xb0, 0x54, 0x04, 0x8d, 0x5a, 0xdd,
      0x49, 0x6c, 0xc4, 0x9f, 0x41, 0x7d, 0x1b, 0x60, 0x8f, 0x55, 0xff, 0xca,
      0xc5, 0x74, 0x20, 0x7c, 0x10, 0x66, 0x7d, 0xab, 0x31, 0xec, 0x80, 0xb1,
      0x3d, 0x30, 0x1f, 0xd2, 0x57, 0xb2, 0x5c, 0xd8, 0xe3, 0x5c, 0xd2, 0x01,
      0xf6, 0x29, 0x62, 0x7a, 0x5f, 0x23, 0xf2, 0x5b, 0x16, 0x67, 0xbd, 0x05,
      0xbf, 0x01, 0x95, 0xea, 0xd6, 0x89, 0x81, 0x3a, 0xcd, 0xed, 0x91, 0x4a,
      0x8e, 0x80, 0x0f, 0x72, 0xe3, 0x32, 0x60, 0x5a, 0x50, 0xbc, 0x2f, 0xc5,
      0x6f, 0x2b, 0xc5, 0xd2, 0x6f, 0xf8, 0xe8, 0xd7, 0xbf, 0xb2, 0x90, 0xbd,
      0x85, 0xad, 0x3f, 0xce, 0x2e, 0x2f, 0x38, 0x7c, 0x9b, 0xcf, 0x99, 0xdf,
      0xce, 0xaa, 0x9b, 0x3f, 0xd0, 0xb7, 0xbf, 0x9a, 0xa7, 0x51, 0xde, 0xf1,
      0xba, 0x58, 0x04, 0x15, 0x79, 0x16, 0xdd, 0x77, 0x15, 0x18, 0x81, 0x1e,
      0xa9, 0x2d, 0xa7, 0x2d, 0xd5, 0x6b, 0xaa, 0xd4, 0x86, 0xbf, 0x5e, 0xe7,
      0x4b, 0xe5, 0x15, 0x44, 0x48, 0xfc, 0xe4, 0xf4, 0xcd, 0x99, 0xa5, 0x39,
      0x21, 0xc3, 0xd1, 0x9c, 0xf2, 0x10, 0x11, 0x5d, 0x90, 0x72, 0x33, 0x5b,
      0xb8, 0x2f, 0x5b, 0xe4, 0x8d, 0x0a, 0xe2, 0x66, 0xc2, 0x25, 0x4e, 0xfb,
      0x16, 0x41, 0xc2, 0xb0, 0x62, 0xc6, 0x75, 0x88, 0xcd, 0x62, 0x13, 0x34},
     pub_key_2,
     {0x35, 0x37, 0x34, 0x38, 0x30, 0x38, 0x31, 0x36, 0x39, 0x36},
     true},

    // Comment:
    // tcID: 31
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     31,
     32,
     {0x27, 0xd8, 0x88, 0xfc, 0x7c, 0x46, 0xd5, 0x57, 0xa8, 0x3e, 0x3c, 0x9c,
      0xd5, 0x07, 0x56, 0x9e, 0x29, 0x74, 0xad, 0xe0, 0xb8, 0x7c, 0xee, 0x08,
      0x0e, 0x75, 0xdf, 0xf7, 0x34, 0x04, 0x7e, 0xbc, 0xd9, 0xd7, 0xd4, 0xfc,
      0x58, 0x9c, 0x32, 0xc7, 0x14, 0xb8, 0x10, 0xd6, 0x5a, 0x39, 0x46, 0x0f,
      0xbb, 0x85, 0xed, 0x5e, 0x57, 0xc7, 0x49, 0xc1, 0x8d, 0x41, 0xa8, 0xe5,
      0xef, 0xd9, 0xcf, 0x8f, 0xb7, 0xba, 0x68, 0x02, 0xce, 0x95, 0x04, 0xa7,
      0xcd, 0x38, 0xd4, 0x54, 0x78, 0xdc, 0x1e, 0xca, 0xc6, 0xe7, 0x1a, 0x74,
      0x75, 0xf8, 0xf2, 0x04, 0x6a, 0xb4, 0x21, 0xbd, 0x92, 0xc0, 0xf0, 0x25,
      0x45, 0xe5, 0x19, 0x76, 0x94, 0x7e, 0x09, 0x78, 0x7d, 0x96, 0x9e, 0xfc,
      0xe3, 0xe3, 0x9e, 0x66, 0xeb, 0x56, 0x45, 0xf1, 0xb1, 0x5d, 0x85, 0x0d,
      0x58, 0x0f, 0xa1, 0xaf, 0xb5, 0xaf, 0x6b, 0xee, 0xbd, 0x41, 0x14, 0xe4,
      0xe6, 0x2d, 0x8e, 0x94, 0x00, 0x1c, 0x82, 0xf2, 0xb6, 0xce, 0xe0, 0x35,
      0x91, 0xde, 0x92, 0x4c, 0x7f, 0xaf, 0x75, 0xf1, 0xee, 0xf6, 0x04, 0x7d,
      0x36, 0x70, 0xc2, 0x79, 0x7b, 0x21, 0x0d, 0x4f, 0xfb, 0x88, 0xf4, 0x24,
      0xbf, 0x8c, 0x84, 0xe6, 0x15, 0x32, 0x72, 0x77, 0x00, 0x0b, 0x91, 0xaf,
      0x82, 0xfb, 0xbf, 0xa5, 0xcc, 0x46, 0x12, 0x64, 0x4f, 0x7c, 0xfb, 0x71,
      0x85, 0x71, 0x3e, 0x0a, 0x64, 0x08, 0x57, 0x6b, 0xb6, 0x71, 0x04, 0x04,
      0x96, 0xbd, 0x3f, 0x8d, 0x78, 0x75, 0xf7, 0x5a, 0x6e, 0xb0, 0x8e, 0x44,
      0xe2, 0xa9, 0xe3, 0xb3, 0x12, 0x74, 0x78, 0x7b, 0xe8, 0xae, 0x66, 0x53,
      0x32, 0x86, 0x4e, 0x2f, 0xde, 0x4b, 0x94, 0x4d, 0x64, 0x43, 0xb9, 0x9b,
      0x3c, 0x6c, 0x3a, 0x71, 0x2f, 0xc2, 0x71, 0x47, 0xf9, 0x87, 0x99, 0x35,
      0x1a, 0x5c, 0x84, 0xe3, 0xb9, 0xce, 0x89, 0x8a, 0x43, 0xfd, 0x85, 0xf8,
      0xc2, 0x96, 0xa2, 0xd8, 0x2f, 0x81, 0x3a, 0xd4, 0xf7, 0xa2, 0xad, 0xb1,
      0x57, 0xe9, 0xac, 0x74, 0x38, 0x46, 0xee, 0x59, 0x6c, 0x78, 0x2b, 0x21,
      0x38, 0xe6, 0xc1, 0x24, 0x8c, 0x37, 0x28, 0xf5, 0xd1, 0xa4, 0x6c, 0x9a,
      0x75, 0xce, 0x7b, 0xba, 0xeb, 0xe8, 0xb3, 0x3d, 0x44, 0xa7, 0x0b, 0xf8,
      0xe3, 0x5b, 0x00, 0x0b, 0xda, 0xdb, 0xf3, 0x79, 0x6a, 0x38, 0xec, 0x4c,
      0x27, 0xf6, 0xa2, 0x16, 0x16, 0x6d, 0xfc, 0x16, 0x21, 0xf8, 0x50, 0x9f,
      0x73, 0xcd, 0x25, 0x3a, 0xcf, 0x1a, 0xba, 0x9b, 0x68, 0x72, 0x12, 0x91,
      0x7a, 0xa8, 0x40, 0xfd, 0x53, 0x99, 0xac, 0xac, 0xfe, 0xbe, 0xb2, 0xce,
      0xff, 0x5b, 0x22, 0x28, 0x7b, 0xf5, 0x40, 0x2f, 0x9c, 0x56, 0xb0, 0x25,
      0xbc, 0x33, 0x7f, 0x22, 0xae, 0x1c, 0x6a, 0xce, 0x24, 0xd0, 0x16, 0xfe},
     pub_key_2,
     {0x36, 0x33, 0x34, 0x33, 0x39, 0x31, 0x33, 0x34, 0x36, 0x38},
     true},

    // Comment:
    // tcID: 32
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     32,
     32,
     {0x52, 0x7d, 0xca, 0x15, 0x94, 0x92, 0x9a, 0xc8, 0xf5, 0xb1, 0x3a, 0x38,
      0xb7, 0x30, 0x0b, 0x0d, 0x69, 0x24, 0x94, 0x52, 0x61, 0x51, 0xb9, 0x0d,
      0x30, 0x33, 0x4c, 0x06, 0xda, 0xf2, 0xea, 0xd8, 0x7a, 0x84, 0x88, 0xb2,
      0x54, 0x7f, 0xbd, 0x3d, 0x93, 0x31, 0x56, 0x23, 0x21, 0xda, 0x29, 0x07,
      0x7f, 0xa9, 0x80, 0x10, 0x97, 0xec, 0x16, 0x91, 0xae, 0x0e, 0xaa, 0x68,
      0x79, 0x30, 0x0d, 0x44, 0x11, 0x87, 0x4c, 0xdc, 0xf3, 0xaa, 0xb8, 0x48,
      0x23, 0x5d, 0x69, 0xcc, 0x76, 0x96, 0xaf, 0x87, 0xf8, 0x61, 0xa2, 0x02,
      0x9d, 0xb0, 0xe8, 0x3f, 0x5f, 0xc7, 0x97, 0x20, 0xb8, 0x24, 0xb3, 0x69,
      0x2f, 0x5b, 0x5b, 0xa0, 0xe8, 0x20, 0x7e, 0xfd, 0x2c, 0x3e, 0x66, 0xbd,
      0x0e, 0x3b, 0xa7, 0x99, 0x89, 0xd1, 0xd6, 0xf2, 0x78, 0x4f, 0x69, 0xbb,
      0x43, 0xa6, 0xbf, 0x5f, 0xa4, 0x8d, 0xd9, 0x57, 0x8b, 0x31, 0xbb, 0x7a,
      0xb9, 0x3b, 0x17, 0x97, 0x8b, 0x0d, 0x17, 0x37, 0x86, 0x39, 0xcb, 0x61,
      0x0b, 0x49, 0x8d, 0x98, 0x97, 0xee, 0xda, 0x4e, 0x30, 0x25, 0x12, 0xe7,
      0xaa, 0xe0, 0x47, 0x0c, 0xc4, 0x3a, 0xc4, 0xb7, 0x07, 0x72, 0x8a, 0xe3,
      0x28, 0x34, 0x4e, 0x90, 0x8c, 0x0a, 0xd0, 0x51, 0xc4, 0x77, 0x51, 0x53,
      0x2b, 0xce, 0x56, 0xdf, 0xfd, 0x05, 0xe8, 0x51, 0x5d, 0x29, 0x77, 0x98,
      0xc5, 0x8b, 0x87, 0x63, 0x84, 0x3a, 0xf7, 0xdf, 0xe4, 0x81, 0xf4, 0x0b,
      0x2b, 0x7d, 0x7c, 0xbe, 0xe8, 0x68, 0xa5, 0x06, 0x57, 0x2d, 0x6a, 0x54,
      0xcf, 0x00, 0x8c, 0xe8, 0x5e, 0xc0, 0x06, 0x0b, 0xf8, 0x23, 0x01, 0x95,
      0x3b, 0x23, 0xbd, 0xd5, 0xe4, 0x77, 0x47, 0xa5, 0x35, 0xd3, 0xef, 0x8f,
      0xdf, 0x5d, 0xb0, 0xc6, 0x5d, 0x70, 0x1b, 0x16, 0x7a, 0x53, 0x1f, 0xcf,
      0x36, 0xa4, 0x8e, 0x63, 0xd8, 0xcc, 0x44, 0x96, 0xcd, 0x74, 0xcc, 0x5d,
      0x11, 0xab, 0x04, 0xb3, 0x2b, 0x7e, 0x9c, 0x24, 0x84, 0x0e, 0xdd, 0xa7,
      0x71, 0xfb, 0x0a, 0xd3, 0xc1, 0x3f, 0x2a, 0xa3, 0x80, 0x3a, 0x10, 0x4e,
      0x09, 0xcd, 0x32, 0x38, 0xde, 0x3f, 0x3c, 0x06, 0xc4, 0x22, 0x24, 0xa9,
      0xe6, 0x62, 0x87, 0xaa, 0x53, 0xdb, 0x9e, 0xd0, 0x88, 0xb7, 0xd6, 0x96,
      0x4f, 0xb5, 0x82, 0x3e, 0x03, 0x96, 0x81, 0x35, 0x07, 0x28, 0x1b, 0x6c,
      0x4c, 0xe1, 0xd5, 0xba, 0x08, 0x75, 0xc6, 0xeb, 0x3a, 0x24, 0x88, 0xaf,
      0x15, 0x35, 0x52, 0xe3, 0x02, 0xe4, 0xda, 0x44, 0x07, 0x53, 0xe2, 0x1f,
      0xe0, 0x85, 0xe7, 0x70, 0xfa, 0x3c, 0x23, 0xa4, 0xbc, 0x0f, 0x05, 0x6c,
      0x46, 0x4c, 0x52, 0xf3, 0xbb, 0xb1, 0x28, 0x78, 0xdd, 0xbf, 0xa8, 0x87,
      0x61, 0x46, 0x6e, 0x83, 0x72, 0x8d, 0xda, 0xe9, 0xb6, 0x04, 0x5b, 0x45},
     pub_key_2,
     {0x31, 0x35, 0x34, 0x31, 0x31, 0x30, 0x33, 0x35, 0x39, 0x38},
     true},

    // Comment:
    // tcID: 33
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     33,
     32,
     {0xc6, 0xfa, 0x78, 0xfe, 0x10, 0x91, 0xdf, 0x4c, 0xb9, 0xd5, 0xf9, 0x02,
      0x13, 0xf5, 0x2d, 0x43, 0xe8, 0xe2, 0x36, 0x2a, 0x0e, 0xc8, 0x15, 0x87,
      0x83, 0xd5, 0x90, 0xb8, 0xbf, 0xf6, 0x63, 0x66, 0xfa, 0x01, 0xc9, 0x72,
      0x38, 0x61, 0xc4, 0xf8, 0xfe, 0x32, 0x22, 0x6e, 0xfb, 0x1c, 0x88, 0x62,
      0x1d, 0x12, 0xa3, 0xce, 0x93, 0x97, 0xb0, 0xe8, 0xf7, 0x28, 0xf0, 0x87,
      0x92, 0x38, 0x66, 0x03, 0xaa, 0x68, 0xe2, 0x2a, 0x29, 0x1f, 0xcf, 0x57,
      0xab, 0x7b, 0xcd, 0xa3, 0x21, 0x0c, 0x09, 0xfb, 0x7a, 0x48, 0xea, 0x19,
      0x67, 0xf6, 0xd0, 0xa2, 0x29, 0x71, 0xe5, 0xd4, 0x8f, 0xc4, 0x39, 0xc3,
      0xb1, 0xed, 0x39, 0x12, 0x93, 0xdd, 0x4f, 0x70, 0x52, 0x89, 0xba, 0x25,
      0xb0, 0xd4, 0xf5, 0x42, 0x81, 0x6e, 0x59, 0x2f, 0x91, 0x04, 0x61, 0xb1,
      0xf4, 0xc0, 0x4e, 0xf9, 0xe7, 0x3e, 0x55, 0x46, 0xdc, 0x83, 0x21, 0xf5,
      0x1d, 0x89, 0x24, 0x5c, 0x9b, 0x5f, 0x68, 0xec, 0x0e, 0xae, 0x43, 0xbf,
      0x82, 0xc2, 0xa3, 0x69, 0x49, 0xa9, 0x45, 0x88, 0x27, 0x7f, 0x82, 0x9a,
      0x01, 0x7d, 0x60, 0x25, 0x4b, 0x2c, 0x31, 0x85, 0x35, 0x1a, 0x3a, 0x85,
      0x6f, 0x7a, 0xac, 0x7a, 0x23, 0xb8, 0xe3, 0xf8, 0x7f, 0xf1, 0xf0, 0x71,
      0x6a, 0x4d, 0x1b, 0x90, 0x7b, 0xec, 0xbe, 0xf5, 0x24, 0x5f, 0xf0, 0xfe,
      0xaf, 0xd1, 0x76, 0x14, 0x29, 0xe7, 0x04, 0x90, 0x55, 0xd2, 0x0d, 0x96,
      0x7c, 0xc0, 0x2f, 0xd4, 0x0a, 0x1a, 0x25, 0xc3, 0x66, 0x1e, 0xfc, 0xf9,
      0x7b, 0x2d, 0xc6, 0x11, 0xdb, 0xfb, 0x2c, 0xaa, 0x0d, 0xb2, 0xf0, 0x08,
      0x29, 0xe5, 0x79, 0x04, 0x0a, 0x33, 0xf7, 0xec, 0x9f, 0x2b, 0xbc, 0x3d,
      0x99, 0x70, 0x49, 0xa7, 0xb1, 0x2d, 0xd4, 0x0a, 0x68, 0xf8, 0xd9, 0xb5,
      0x26, 0x4e, 0xd5, 0x10, 0xcf, 0xad, 0x1b, 0x64, 0x4c, 0x24, 0xf0, 0xe8,
      0xc3, 0x35, 0x4f, 0xe4, 0x88, 0x5b, 0xf3, 0x85, 0xf3, 0xbc, 0xfe, 0xa7,
      0x3a, 0x13, 0xa0, 0xee, 0xf5, 0x55, 0xa7, 0x06, 0xf5, 0x24, 0x4f, 0xd9,
      0x02, 0xb2, 0x06, 0x2e, 0x94, 0xc1, 0xbf, 0xe8, 0x84, 0x66, 0xee, 0x9c,
      0x63, 0x27, 0x61, 0x60, 0x5f, 0xa7, 0x9b, 0x6d, 0x79, 0x9d, 0x9e, 0x79,
      0x89, 0x7b, 0xf0, 0xe5, 0x6e, 0xfa, 0x34, 0xf0, 0x55, 0x57, 0x16, 0x04,
      0xa4, 0x09, 0xd5, 0xd8, 0x99, 0xa8, 0x55, 0x0f, 0xfd, 0x6f, 0x00, 0x2c,
      0xdf, 0xf6, 0xdd, 0xa4, 0xa5, 0x20, 0x1b, 0x2f, 0x95, 0xa7, 0x60, 0x1c,
      0x84, 0x6c, 0xf1, 0xd0, 0x03, 0xc5, 0xb3, 0xfe, 0x93, 0xa9, 0xba, 0x80,
      0x8b, 0x20, 0x86, 0x16, 0x9e, 0x5b, 0xb2, 0xb8, 0x95, 0xfb, 0x29, 0x10,
      0x0f, 0x14, 0x1e, 0xbb, 0x35, 0x67, 0xbe, 0xde, 0xae, 0xcd, 0xf0, 0x01},
     pub_key_2,
     {0x31, 0x30, 0x34, 0x37, 0x38, 0x35, 0x38, 0x30, 0x31, 0x32, 0x38},
     true},

    // Comment:
    // tcID: 34
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     34,
     32,
     {0xc5, 0x82, 0x18, 0x7c, 0x93, 0x24, 0x3b, 0x6e, 0x33, 0xd1, 0x53, 0x66,
      0x12, 0xde, 0x1c, 0xd3, 0x50, 0xce, 0x22, 0xa3, 0x52, 0x0f, 0x3f, 0x9e,
      0xbd, 0x59, 0x04, 0x6a, 0x9f, 0x7d, 0x52, 0x20, 0x0f, 0xde, 0xd0, 0xaa,
      0x32, 0xbf, 0x9e, 0x82, 0x49, 0xc1, 0x89, 0xa5, 0x92, 0x73, 0xf2, 0xcf,
      0xf5, 0xbb, 0x7d, 0xa3, 0x2b, 0xcd, 0x53, 0xc7, 0x2b, 0x0a, 0xa7, 0x30,
      0xf8, 0x2d, 0x9e, 0x51, 0x62, 0x93, 0x2a, 0x7f, 0x42, 0xb6, 0x5f, 0xb9,
      0xe7, 0xa9, 0xab, 0x25, 0x45, 0x8c, 0xab, 0xa2, 0xb6, 0x05, 0x89, 0x22,
      0xc2, 0x10, 0x78, 0xaa, 0x7e, 0x31, 0xdb, 0xf2, 0x4c, 0xee, 0x8d, 0xfe,
      0x93, 0x67, 0x10, 0x2d, 0xfa, 0x41, 0xcb, 0x73, 0x32, 0x3f, 0xa0, 0xfd,
      0x58, 0xd9, 0xf1, 0x9a, 0x16, 0x75, 0x87, 0xe1, 0x9b, 0x5a, 0xbe, 0xb0,
      0x75, 0xe8, 0xac, 0xdb, 0xe8, 0x9c, 0xc5, 0xda, 0x76, 0x6b, 0x9f, 0x87,
      0x17, 0x5c, 0x7b, 0xc7, 0xb7, 0xfc, 0xb7, 0xa6, 0x8b, 0x44, 0xdd, 0x88,
      0x24, 0xcd, 0x4a, 0x56, 0x16, 0x5d, 0x5f, 0xa2, 0x90, 0xbc, 0x33, 0x26,
      0x64, 0xba, 0x88, 0x50, 0x55, 0xbb, 0x7e, 0x34, 0x37, 0xd3, 0x35, 0x01,
      0x23, 0x7f, 0xb6, 0xba, 0xb3, 0xbe, 0x51, 0x4b, 0x8f, 0xf4, 0xc2, 0xf1,
      0x5e, 0x84, 0x9e, 0xb2, 0xd8, 0xbb, 0xe1, 0x9b, 0xce, 0x13, 0x17, 0x98,
      0x23, 0x06, 0xfc, 0x29, 0xff, 0xb9, 0x21, 0xa7, 0x6b, 0x68, 0x8c, 0x75,
      0xda, 0xbe, 0x44, 0x03, 0x5b, 0x59, 0x83, 0x05, 0x90, 0xb6, 0x4c, 0x14,
      0x3d, 0x72, 0x3e, 0x61, 0x14, 0x42, 0x61, 0x86, 0xeb, 0x0d, 0x12, 0xa5,
      0xee, 0x5b, 0xbd, 0x5e, 0x73, 0xf5, 0x38, 0xa8, 0x34, 0x0a, 0xaa, 0x80,
      0xe0, 0xc0, 0x36, 0xef, 0x0d, 0xaa, 0x3e, 0x98, 0x0f, 0xa6, 0x9c, 0xa7,
      0x3f, 0x7e, 0x04, 0xd2, 0xef, 0x8c, 0x95, 0x65, 0xc8, 0xc0, 0xc0, 0x15,
      0x4a, 0xf2, 0xee, 0x9e, 0x3c, 0x90, 0xd9, 0x66, 0x0d, 0x92, 0x67, 0xe1,
      0x84, 0x7f, 0xc2, 0x51, 0xd4, 0x09, 0xdf, 0x72, 0xe4, 0x66, 0xfd, 0x64,
      0x15, 0x76, 0x13, 0x90, 0x34, 0x71, 0x42, 0xcc, 0x8b, 0x63, 0x94, 0xa6,
      0x3e, 0x17, 0x9a, 0xd4, 0x01, 0xf4, 0xef, 0x51, 0xfc, 0xa0, 0x28, 0x8c,
      0x78, 0xa9, 0x59, 0x58, 0x31, 0x2f, 0xeb, 0xd8, 0x94, 0xd1, 0xa3, 0x6f,
      0xf9, 0xa8, 0x2e, 0x4a, 0xbc, 0xd8, 0xa2, 0x7d, 0x08, 0x5c, 0xbc, 0xdc,
      0x54, 0x91, 0x0d, 0x4d, 0xf2, 0x94, 0x7a, 0xc2, 0x2f, 0xb7, 0x27, 0x4f,
      0xa2, 0x28, 0x2e, 0x39, 0xb2, 0x46, 0xc5, 0x8c, 0xfe, 0xef, 0x59, 0x62,
      0xe3, 0x5b, 0x77, 0x2d, 0x25, 0x73, 0xb8, 0x65, 0x07, 0x78, 0xb3, 0x17,
      0xde, 0x8e, 0x17, 0xbe, 0x4c, 0xe0, 0x56, 0x53, 0x7d, 0x79, 0x72, 0x09},
     pub_key_2,
     {0x31, 0x30, 0x35, 0x33, 0x36, 0x32, 0x38, 0x35, 0x35, 0x36, 0x38},
     true},

    // Comment:
    // tcID: 35
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     35,
     32,
     {0x5e, 0x43, 0xe4, 0xfa, 0x01, 0xf4, 0x7b, 0x68, 0xcc, 0x79, 0x16, 0xaf,
      0xef, 0xa3, 0x0e, 0x10, 0x67, 0xd5, 0xc9, 0x72, 0x31, 0xdd, 0xde, 0xf9,
      0x25, 0x42, 0x4b, 0x7c, 0xa4, 0x5a, 0x8f, 0x37, 0x36, 0x2b, 0x11, 0x70,
      0xd0, 0x15, 0x94, 0xfa, 0xc6, 0x51, 0x89, 0x19, 0x95, 0x50, 0x7d, 0xa1,
      0x4c, 0xbe, 0x02, 0xf5, 0x06, 0x30, 0x46, 0x52, 0x5b, 0x0d, 0xd1, 0x85,
      0xd6, 0xb4, 0x96, 0x2d, 0x28, 0xf7, 0x3e, 0x35, 0x4b, 0xd9, 0xb7, 0x8c,
      0x9a, 0xb0, 0xfc, 0x35, 0x56, 0x55, 0x71, 0x16, 0x7a, 0xf0, 0xd1, 0x1c,
      0xe0, 0xcf, 0xf9, 0x84, 0x7c, 0xd0, 0x67, 0x79, 0xce, 0x92, 0xc1, 0xbd,
      0x24, 0x32, 0x11, 0x6b, 0x21, 0x6d, 0xd5, 0x2f, 0x47, 0xc0, 0xf7, 0x27,
      0x48, 0x13, 0xe8, 0x05, 0xe6, 0xc4, 0xf6, 0xcf, 0x03, 0x7c, 0x0f, 0x34,
      0x64, 0x48, 0x55, 0x8a, 0xf3, 0x81, 0xe7, 0x6b, 0x7e, 0x16, 0x12, 0x91,
      0xfa, 0xb0, 0x55, 0xfa, 0xb8, 0xda, 0xaf, 0x7a, 0x5f, 0xd9, 0xae, 0x3e,
      0xf4, 0x3f, 0xac, 0xde, 0x73, 0xd4, 0x83, 0x71, 0x1c, 0xff, 0x04, 0xac,
      0xad, 0x39, 0xac, 0x74, 0xfb, 0xa5, 0xd8, 0xcd, 0xcb, 0x22, 0xc9, 0x98,
      0x1c, 0x48, 0xbe, 0x6c, 0x31, 0x3a, 0x94, 0x4f, 0x25, 0xfa, 0xc0, 0x03,
      0x7f, 0x6f, 0x68, 0x1c, 0x44, 0xdd, 0x90, 0xf5, 0x6d, 0x76, 0x3e, 0x30,
      0x8b, 0x99, 0x8f, 0xef, 0xf1, 0x15, 0xfe, 0xd1, 0x6e, 0x19, 0xb8, 0x3b,
      0xa8, 0x52, 0x1d, 0x0a, 0x46, 0x59, 0x05, 0xb0, 0x4c, 0x77, 0xcb, 0xa3,
      0x4f, 0xc6, 0xdb, 0x05, 0x5c, 0xe7, 0xae, 0xae, 0x95, 0x19, 0x7d, 0xc4,
      0xe1, 0x54, 0xf6, 0x87, 0x58, 0x78, 0xa1, 0xa0, 0x7b, 0x14, 0xbb, 0xc0,
      0xe7, 0x87, 0x06, 0x68, 0x34, 0x6b, 0x92, 0xb3, 0x22, 0xfa, 0x91, 0xbc,
      0x11, 0xac, 0x38, 0x06, 0xfc, 0x3d, 0xd3, 0x9f, 0xab, 0xb0, 0xcf, 0x02,
      0x76, 0x2e, 0x00, 0x40, 0x03, 0x80, 0x5d, 0xe8, 0xa4, 0x81, 0x92, 0x97,
      0x0d, 0x85, 0x9c, 0x9b, 0x54, 0x32, 0x94, 0xd1, 0x1f, 0xe9, 0xeb, 0xe5,
      0x24, 0xae, 0x7c, 0x36, 0x68, 0x2c, 0x78, 0x6d, 0x99, 0xcc, 0x14, 0xbd,
      0xcc, 0xdb, 0xd6, 0x48, 0xb0, 0x70, 0x31, 0x22, 0xd9, 0xbf, 0x26, 0x67,
      0xa2, 0x51, 0x68, 0x65, 0xe7, 0x09, 0x39, 0x7d, 0x10, 0x50, 0xed, 0x4a,
      0x7e, 0x65, 0x50, 0x09, 0x54, 0xec, 0x04, 0x25, 0xd7, 0xa8, 0xd4, 0xc0,
      0xc4, 0xae, 0x45, 0x54, 0xce, 0xbf, 0xa7, 0x65, 0x0a, 0x24, 0x2a, 0xa8,
      0x91, 0xec, 0x7d, 0xa7, 0x03, 0x3f, 0x38, 0x4c, 0xaf, 0xcf, 0xa2, 0xeb,
      0x3a, 0xad, 0x09, 0x01, 0x20, 0xfe, 0x63, 0xfa, 0x07, 0x76, 0x50, 0x88,
      0x82, 0xbd, 0x4f, 0xff, 0x34, 0x0f, 0x8d, 0xb1, 0xeb, 0xf7, 0x0a, 0x1a},
     pub_key_2,
     {0x39, 0x35, 0x33, 0x39, 0x30, 0x34, 0x31, 0x30, 0x35},
     true},

    // Comment:
    // tcID: 36
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     36,
     32,
     {0x25, 0xd0, 0xcd, 0xc3, 0xc0, 0x6b, 0x10, 0x67, 0x2d, 0x73, 0x35, 0xb0,
      0xbe, 0x5f, 0xcf, 0x40, 0x2b, 0x3a, 0xd0, 0x7b, 0x4b, 0xc3, 0xa9, 0x7f,
      0x04, 0xec, 0x4b, 0x37, 0x54, 0x75, 0x17, 0x2d, 0xb4, 0x81, 0xe2, 0x3b,
      0xe1, 0x99, 0xea, 0xbc, 0x2e, 0x56, 0x93, 0x6b, 0x8f, 0x3e, 0x53, 0x7f,
      0x9a, 0x76, 0xfb, 0xe6, 0x0f, 0x5d, 0x03, 0x65, 0x40, 0x0f, 0x36, 0x40,
      0xff, 0xee, 0xd1, 0xd1, 0x9f, 0x8e, 0x98, 0xf7, 0x95, 0x7f, 0x53, 0x36,
      0x21, 0x36, 0x21, 0x20, 0xdf, 0x4d, 0x6f, 0x0c, 0x69, 0x02, 0x76, 0x0f,
      0x10, 0x74, 0xa1, 0x22, 0x22, 0x3d, 0x1b, 0x64, 0x3b, 0xac, 0xb9, 0x4c,
      0x8e, 0xa3, 0x3f, 0x7c, 0xa2, 0xc8, 0xcc, 0x6c, 0x1f, 0x12, 0xc3, 0xef,
      0x49, 0x16, 0xe4, 0xb8, 0x73, 0xfb, 0xfe, 0x96, 0x32, 0xf2, 0xbc, 0x95,
      0xdc, 0x8c, 0x64, 0xec, 0x63, 0x91, 0x87, 0xb0, 0x78, 0xb9, 0xc4, 0xeb,
      0x5d, 0x51, 0x64, 0xd3, 0x77, 0xb2, 0x67, 0xc4, 0xe2, 0xa6, 0x18, 0x39,
      0x89, 0x8f, 0x2a, 0x42, 0x3a, 0x26, 0x32, 0xed, 0x19, 0x97, 0x11, 0x32,
      0x36, 0x6a, 0xba, 0xf8, 0x71, 0xa8, 0x9b, 0xf2, 0x8e, 0x76, 0x58, 0x96,
      0x07, 0x2a, 0x77, 0x03, 0x2d, 0x28, 0xd5, 0xba, 0x55, 0xbc, 0xbd, 0x72,
      0x53, 0x0c, 0xef, 0xdc, 0x29, 0x13, 0x1a, 0x21, 0x74, 0x18, 0xff, 0x9a,
      0xc8, 0x14, 0x36, 0x8a, 0xa6, 0x6f, 0x6d, 0xb1, 0x98, 0xe3, 0x3c, 0x38,
      0x17, 0xa8, 0x05, 0x4b, 0x56, 0x04, 0xe7, 0x96, 0xe0, 0xfd, 0x27, 0xd7,
      0x2f, 0xdc, 0x2d, 0xf7, 0x80, 0xd3, 0x73, 0x69, 0x48, 0x0a, 0x87, 0xe7,
      0xb6, 0x9a, 0xef, 0x0a, 0x57, 0x17, 0x13, 0x9b, 0xb9, 0xae, 0xb1, 0x68,
      0x30, 0x08, 0x01, 0x54, 0x9a, 0xf1, 0x95, 0xa7, 0xb3, 0xb1, 0x7f, 0xa7,
      0x5f, 0x7d, 0x6f, 0xc9, 0x2e, 0x38, 0xd2, 0xaf, 0xd7, 0x0a, 0x74, 0xdd,
      0xde, 0x53, 0x16, 0xe7, 0xe7, 0xee, 0xf2, 0x9a, 0xbd, 0x1e, 0x9e, 0xb9,
      0xd6, 0xdc, 0x1c, 0x38, 0xb8, 0x76, 0xa2, 0xd5, 0x14, 0x2a, 0x23, 0x77,
      0xab, 0x22, 0xb4, 0x63, 0xc1, 0x30, 0x84, 0xf4, 0xff, 0x7d, 0x44, 0xb6,
      0xe2, 0x91, 0x6f, 0xcb, 0xce, 0xff, 0x37, 0x8a, 0x65, 0xa1, 0x0a, 0x0c,
      0x5d, 0xa9, 0x4a, 0x74, 0x96, 0xa1, 0xa9, 0x98, 0x5c, 0xa5, 0x19, 0x0c,
      0xc2, 0x07, 0xb6, 0x0d, 0x69, 0xb2, 0x8c, 0x48, 0x0b, 0x7d, 0x26, 0xcb,
      0x5b, 0x74, 0x02, 0x31, 0xd9, 0x0d, 0x9d, 0xe1, 0xc5, 0x5d, 0x64, 0x7f,
      0xde, 0x75, 0x63, 0x1b, 0x2b, 0x6d, 0x36, 0x3a, 0x52, 0xf2, 0x49, 0xcf,
      0x6b, 0x64, 0x38, 0x03, 0xc5, 0x73, 0xe7, 0x3b, 0xe9, 0x28, 0x6c, 0xcd,
      0x17, 0xcf, 0xe2, 0x0d, 0x3d, 0xaf, 0x63, 0xae, 0x5a, 0x18, 0xa4, 0x97},
     pub_key_2,
     {0x39, 0x37, 0x38, 0x38, 0x34, 0x38, 0x30, 0x33, 0x39},
     true},

    // Comment:
    // tcID: 37
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     37,
     32,
     {0x81, 0x01, 0xf3, 0x56, 0xf3, 0xc6, 0xe0, 0xb2, 0x1a, 0x1c, 0x07, 0x5f,
      0x7a, 0x3e, 0xfa, 0xa5, 0xcd, 0xcb, 0xd9, 0x37, 0x4a, 0x9d, 0xf4, 0x47,
      0xf5, 0xbe, 0x5b, 0x3b, 0x28, 0xa4, 0x64, 0x98, 0x4e, 0x6c, 0x6b, 0x81,
      0x9d, 0x61, 0xf1, 0xc7, 0xf0, 0x76, 0x57, 0xe9, 0x5c, 0xe6, 0x3a, 0x4d,
      0xad, 0x76, 0x8b, 0x72, 0x3f, 0x1e, 0x30, 0x51, 0x70, 0xbc, 0x4d, 0x10,
      0x16, 0xce, 0xf6, 0x95, 0xd9, 0x1a, 0x65, 0x86, 0x4b, 0xd1, 0xab, 0x23,
      0x65, 0xb2, 0xbc, 0x59, 0x6d, 0x25, 0x2e, 0xe2, 0x06, 0xf7, 0x1c, 0xd4,
      0x42, 0x28, 0xfe, 0x12, 0x7e, 0x73, 0x73, 0xef, 0xa6, 0xbd, 0x2e, 0x84,
      0x51, 0x29, 0x21, 0x8b, 0x99, 0x09, 0x7a, 0x07, 0x4f, 0x7c, 0xc0, 0x3e,
      0xf9, 0xde, 0xd0, 0x93, 0xf4, 0xbe, 0x64, 0x30, 0x42, 0xbe, 0xf2, 0x9f,
      0xcf, 0x88, 0x19, 0x96, 0x7a, 0x34, 0xa8, 0xdb, 0x6a, 0x06, 0x6b, 0x73,
      0xc3, 0x11, 0xdd, 0x29, 0x31, 0xc3, 0x9b, 0x1a, 0xea, 0xf5, 0x5f, 0xcd,
      0xc0, 0x35, 0xdf, 0x8b, 0xab, 0x81, 0x05, 0xcf, 0x0f, 0x07, 0xf5, 0xcb,
      0xb3, 0x00, 0x29, 0xda, 0x31, 0x49, 0x93, 0x92, 0x6c, 0x2e, 0x92, 0xb5,
      0x09, 0x85, 0x68, 0xab, 0x1c, 0x53, 0x3b, 0x17, 0x9b, 0x8c, 0x2f, 0x8f,
      0xaf, 0x71, 0x69, 0x9f, 0x7e, 0x6e, 0xff, 0x87, 0xda, 0xa4, 0xa5, 0xc7,
      0x15, 0xc7, 0xac, 0x0e, 0x18, 0x1b, 0x87, 0xb2, 0xd8, 0xd7, 0x91, 0xb6,
      0x11, 0x30, 0x04, 0x5f, 0xd3, 0x5c, 0x34, 0xea, 0x29, 0x71, 0x0d, 0xeb,
      0x0c, 0x33, 0xc3, 0x39, 0xcd, 0xa0, 0x11, 0x95, 0xd1, 0x2a, 0x5e, 0x23,
      0xed, 0x54, 0x59, 0x58, 0xf7, 0x48, 0xe2, 0x3d, 0x6b, 0x86, 0xe0, 0x34,
      0x18, 0x6d, 0x9d, 0xc2, 0xe5, 0xb5, 0x27, 0xa7, 0x37, 0x59, 0x84, 0xce,
      0x50, 0x5b, 0xba, 0x46, 0xb5, 0x4b, 0x58, 0x34, 0xe1, 0xc9, 0x52, 0xa7,
      0xaf, 0x46, 0x8d, 0x9b, 0x9d, 0xc2, 0x9f, 0x38, 0x45, 0x8f, 0x74, 0xd3,
      0x77, 0x3f, 0xc5, 0xc3, 0x5a, 0x80, 0x44, 0xa2, 0xfa, 0xaa, 0xb8, 0x57,
      0x59, 0x66, 0x92, 0x25, 0xb0, 0xa9, 0x81, 0xd8, 0x80, 0x3d, 0xec, 0x5a,
      0x56, 0x55, 0x51, 0x11, 0x99, 0xab, 0x43, 0xab, 0xb2, 0x13, 0xc4, 0xa6,
      0x1b, 0x1c, 0x1b, 0x39, 0x31, 0xe2, 0x9c, 0x25, 0xf9, 0x48, 0xfc, 0xec,
      0x49, 0xfc, 0xd9, 0x9d, 0xf1, 0x42, 0x0e, 0x2d, 0x89, 0x4f, 0x2c, 0x33,
      0xa3, 0x35, 0x08, 0x2c, 0xba, 0x06, 0x44, 0xe5, 0xd1, 0xf1, 0x4d, 0x49,
      0x96, 0x5d, 0xb1, 0xc4, 0x9b, 0x7d, 0x33, 0xc2, 0xda, 0xe8, 0xec, 0x6b,
      0x19, 0x41, 0xe8, 0x64, 0x71, 0x28, 0xee, 0x2b, 0x29, 0x5e, 0xc5, 0xb7,
      0x4d, 0x27, 0xd6, 0xbb, 0x6c, 0xe0, 0xf1, 0xeb, 0x19, 0xa8, 0x3b, 0xc2},
     pub_key_2,
     {0x33, 0x36, 0x31, 0x30, 0x36, 0x37, 0x32, 0x34, 0x34, 0x32},
     true},

    // Comment:
    // tcID: 38
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     38,
     32,
     {0x13, 0x0b, 0x9b, 0xeb, 0x5f, 0xa3, 0x71, 0x18, 0xed, 0x59, 0xec, 0xa2,
      0xfa, 0x8d, 0x7c, 0x92, 0x1d, 0xe1, 0x6a, 0x68, 0x33, 0xb9, 0x3d, 0x98,
      0xa3, 0x70, 0x72, 0x28, 0xca, 0x50, 0xb8, 0xed, 0x6e, 0xfc, 0x25, 0x47,
      0x84, 0x43, 0x05, 0x12, 0xc4, 0xed, 0x00, 0x57, 0x69, 0xc8, 0x43, 0x4c,
      0x9e, 0x75, 0x2e, 0xe4, 0x70, 0x69, 0xc9, 0x5c, 0xc1, 0xf4, 0x76, 0x86,
      0x6d, 0xcd, 0xd6, 0x2f, 0x20, 0x62, 0xde, 0x83, 0x92, 0xe5, 0xfb, 0xd8,
      0xc1, 0x9b, 0xa2, 0xa0, 0x8c, 0x80, 0xff, 0x6b, 0x66, 0xaf, 0xf8, 0x41,
      0x1a, 0xe4, 0x9e, 0xba, 0xb9, 0x3c, 0xba, 0xec, 0x14, 0x1e, 0x8d, 0x9d,
      0x07, 0x9b, 0xa5, 0xa2, 0xa5, 0x52, 0xb1, 0x84, 0x5f, 0xc5, 0x7e, 0xe7,
      0x18, 0xa4, 0x5e, 0x94, 0x1e, 0x92, 0x5a, 0x5d, 0xf2, 0xbb, 0x9f, 0xe1,
      0x1b, 0x46, 0x02, 0xa6, 0x39, 0x98, 0x62, 0xc3, 0x18, 0x50, 0x86, 0x62,
      0x78, 0x36, 0x04, 0x3e, 0xa1, 0x5e, 0x5a, 0x90, 0xa2, 0xa1, 0xed, 0x07,
      0x4d, 0x7f, 0x75, 0x09, 0x0f, 0xb7, 0x26, 0x65, 0x35, 0x6a, 0x68, 0xbb,
      0xa2, 0xf3, 0x86, 0x10, 0x92, 0x5f, 0x69, 0x32, 0x6b, 0xb2, 0x4d, 0x02,
      0xc3, 0x7a, 0xf0, 0x9c, 0xd0, 0x5c, 0xdb, 0x4c, 0x1d, 0x10, 0x50, 0x5d,
      0x1c, 0x50, 0x6b, 0x71, 0x93, 0x06, 0xe4, 0x57, 0x0b, 0x75, 0x2f, 0xb2,
      0x8b, 0xe3, 0x45, 0x30, 0x46, 0xfa, 0x61, 0xe5, 0x50, 0x9e, 0x4c, 0xda,
      0xb1, 0x6c, 0x4a, 0xdf, 0x44, 0xfd, 0x30, 0x21, 0x20, 0x25, 0x26, 0x47,
      0x9c, 0xcd, 0xe6, 0xff, 0x14, 0x19, 0x01, 0x00, 0xd5, 0x26, 0x6f, 0x6c,
      0xae, 0x54, 0x3e, 0x65, 0xe3, 0x4f, 0xc9, 0x72, 0x6d, 0x9b, 0xc4, 0x97,
      0x51, 0x46, 0x6a, 0xa6, 0x7d, 0x54, 0xa7, 0xef, 0xe7, 0x97, 0x7e, 0x8e,
      0x64, 0xdd, 0x4c, 0xb3, 0xba, 0x04, 0x51, 0xdf, 0x8d, 0xb5, 0x24, 0xfd,
      0x09, 0xb1, 0xe1, 0x96, 0xe2, 0xd2, 0x6c, 0x46, 0xe2, 0x29, 0x29, 0x1f,
      0x4d, 0xf7, 0xac, 0x83, 0x87, 0x55, 0x54, 0xd0, 0xca, 0x1f, 0x55, 0x78,
      0x6d, 0xbe, 0xfb, 0x03, 0xd8, 0xfd, 0x9a, 0x01, 0x84, 0x01, 0x53, 0x7d,
      0xab, 0xde, 0x19, 0x34, 0x94, 0x39, 0x98, 0x23, 0xe3, 0x41, 0x86, 0x0e,
      0x4f, 0x1c, 0x24, 0xa4, 0xde, 0x0c, 0x86, 0xf4, 0x99, 0x7e, 0xed, 0x03,
      0x08, 0xb6, 0xce, 0x27, 0xb3, 0xb9, 0x26, 0xca, 0x80, 0x28, 0x4d, 0xdf,
      0xbe, 0x74, 0xa6, 0x2e, 0x97, 0x01, 0x6e, 0x9a, 0xef, 0x9c, 0xa7, 0x18,
      0x2c, 0xfb, 0x3f, 0x1a, 0x16, 0xe1, 0xe5, 0xb5, 0xe3, 0xa2, 0xb1, 0xdd,
      0xe1, 0x12, 0x63, 0x92, 0x18, 0x05, 0x4f, 0x0e, 0x9d, 0x47, 0x72, 0x91,
      0xf0, 0xd5, 0x80, 0xc1, 0xab, 0x7e, 0x84, 0x0e, 0x37, 0xa5, 0x0f, 0xcf},
     pub_key_2,
     {0x31, 0x30, 0x35, 0x34, 0x32, 0x34, 0x30, 0x37, 0x30, 0x35},
     true},

    // Comment:
    // tcID: 39
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     39,
     32,
     {0xbc, 0x3d, 0xef, 0x5a, 0x81, 0x6a, 0x23, 0xd2, 0x3f, 0xc8, 0xa7, 0xb8,
      0xc4, 0xcc, 0x87, 0x89, 0xe4, 0x04, 0x4a, 0x8c, 0x96, 0x3c, 0xbe, 0x7f,
      0xf9, 0xcb, 0xcb, 0x9e, 0x50, 0xbe, 0x23, 0xac, 0x92, 0x52, 0x4c, 0x5a,
      0x53, 0x38, 0xab, 0x8b, 0x42, 0xe7, 0xdb, 0x1a, 0xa8, 0x31, 0x80, 0xce,
      0x33, 0x54, 0xaa, 0xd4, 0x30, 0xff, 0xd2, 0xae, 0x43, 0xeb, 0xaa, 0xfa,
      0x88, 0x99, 0x0d, 0x10, 0x0e, 0x27, 0xd7, 0x88, 0xc7, 0x79, 0xae, 0xe2,
      0x38, 0x46, 0xe4, 0x67, 0x4a, 0xf2, 0x1b, 0x81, 0xcc, 0xed, 0xb8, 0xcd,
      0xc6, 0x5d, 0x63, 0x80, 0x56, 0x6f, 0x64, 0x9e, 0xd1, 0x4c, 0x3e, 0x43,
      0xde, 0xc9, 0x4b, 0x3a, 0x52, 0x7c, 0xa6, 0xcb, 0x53, 0x00, 0x1b, 0x6d,
      0x8f, 0x92, 0x10, 0xed, 0xe0, 0x57, 0xfc, 0xe8, 0x3f, 0x0b, 0xd7, 0xda,
      0x60, 0x03, 0x3b, 0x96, 0xaf, 0xc4, 0x8a, 0x44, 0xcb, 0x43, 0x41, 0x38,
      0x2f, 0x13, 0x43, 0x31, 0xa8, 0xe2, 0x6f, 0x2e, 0xf0, 0x95, 0x67, 0x01,
      0xaa, 0x12, 0x15, 0x13, 0x13, 0x75, 0x43, 0x81, 0xae, 0x2d, 0x5a, 0x99,
      0x16, 0x72, 0x22, 0xbc, 0x91, 0x56, 0x5e, 0x83, 0xae, 0xa3, 0xf0, 0x57,
      0xb2, 0x86, 0x79, 0x4d, 0xd9, 0x80, 0x5b, 0x6b, 0x53, 0x38, 0x31, 0xc2,
      0x39, 0x84, 0x49, 0x8a, 0x55, 0x98, 0x5c, 0xc8, 0x46, 0x5c, 0x3f, 0x35,
      0x76, 0x4d, 0x28, 0x71, 0x56, 0x92, 0xe9, 0xa9, 0x24, 0x90, 0xf2, 0xec,
      0x82, 0x12, 0x27, 0x99, 0x57, 0x6b, 0x80, 0x8b, 0xc9, 0xd0, 0xfd, 0xaf,
      0x87, 0xbb, 0x4d, 0x39, 0x1f, 0x5b, 0xb2, 0x5c, 0x50, 0x6a, 0x6f, 0xb9,
      0x2e, 0x6f, 0xe7, 0x46, 0xde, 0x50, 0x6e, 0xb3, 0x74, 0x8a, 0x6d, 0x03,
      0x6e, 0xf5, 0xd8, 0x80, 0x40, 0x00, 0xdd, 0x0e, 0xcf, 0x73, 0x87, 0x09,
      0xae, 0x6d, 0xda, 0xef, 0xf4, 0x47, 0x34, 0x51, 0x33, 0x74, 0xa0, 0x22,
      0xc2, 0x1a, 0xd5, 0x28, 0xa4, 0x2f, 0x6f, 0x0a, 0x15, 0xf0, 0xb5, 0xc4,
      0x7d, 0x3a, 0x64, 0x37, 0x91, 0x91, 0xf1, 0x61, 0xd5, 0xf9, 0x6b, 0xe3,
      0x3e, 0x7d, 0x61, 0xdf, 0xcc, 0xe2, 0xa3, 0x0e, 0xcb, 0x73, 0xe3, 0x4b,
      0x99, 0xd8, 0x61, 0x62, 0xb6, 0x65, 0x50, 0x84, 0x1d, 0xd7, 0x00, 0xa3,
      0x8d, 0xc1, 0x05, 0x78, 0x38, 0x39, 0x75, 0x13, 0xae, 0xba, 0xa4, 0x11,
      0xe3, 0x47, 0xc2, 0x9f, 0xa9, 0xa2, 0xd1, 0x78, 0x93, 0x78, 0xf0, 0x44,
      0xcd, 0xcb, 0x94, 0x17, 0xf8, 0xec, 0x37, 0x03, 0xbe, 0x8c, 0xe9, 0x11,
      0xba, 0xe9, 0x6d, 0x44, 0xc5, 0xc3, 0x66, 0x4c, 0x62, 0xdf, 0x09, 0xf5,
      0x8a, 0x27, 0x09, 0xeb, 0x37, 0x9c, 0x39, 0x21, 0xca, 0x5b, 0x1a, 0x27,
      0x7b, 0xc7, 0xfd, 0xb7, 0xbc, 0x57, 0x73, 0x75, 0x42, 0x31, 0x6e, 0xd1},
     pub_key_2,
     {0x35, 0x31, 0x37, 0x34, 0x34, 0x34, 0x38, 0x31, 0x39, 0x37},
     true},

    // Comment:
    // tcID: 40
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     40,
     32,
     {0x07, 0x48, 0x44, 0x1e, 0xdc, 0x13, 0x3a, 0xe2, 0x6f, 0xa1, 0x30, 0x03,
      0x37, 0x71, 0x6e, 0x02, 0x49, 0xd9, 0xc9, 0x09, 0x6e, 0x9e, 0xeb, 0x77,
      0x34, 0x99, 0xb4, 0x42, 0xdb, 0xd1, 0x64, 0x1f, 0x3a, 0xee, 0xbb, 0x86,
      0xad, 0xe9, 0x83, 0x20, 0x63, 0x01, 0xad, 0xe3, 0x97, 0xb1, 0x08, 0x9f,
      0x43, 0xde, 0xc0, 0x80, 0x2d, 0x87, 0xd2, 0x32, 0x87, 0xf8, 0x9f, 0x71,
      0x80, 0xb2, 0xd9, 0x2c, 0xe2, 0xf7, 0x70, 0x41, 0x03, 0x80, 0x05, 0xd1,
      0xcf, 0xc2, 0x7f, 0xbc, 0xab, 0x2b, 0xaf, 0xd4, 0x77, 0xa5, 0x1c, 0xd4,
      0xf7, 0x54, 0xfb, 0x58, 0x31, 0x1b, 0x80, 0xc7, 0xf4, 0x81, 0x20, 0x5b,
      0x02, 0xc1, 0x10, 0x25, 0x36, 0xe4, 0xed, 0x18, 0xf9, 0xc2, 0x6b, 0x1b,
      0xde, 0xe6, 0x7b, 0x72, 0xba, 0xcf, 0xa4, 0xd6, 0x9b, 0xbe, 0x8e, 0xea,
      0x7c, 0x67, 0x96, 0x3c, 0x64, 0x4c, 0x26, 0x93, 0x3d, 0x27, 0xeb, 0xf9,
      0x84, 0xdf, 0xee, 0xda, 0x41, 0x6d, 0x45, 0xbf, 0xa1, 0x83, 0xad, 0xfc,
      0x10, 0xd8, 0xee, 0xf0, 0x3e, 0x7b, 0x15, 0x94, 0x62, 0x10, 0x2e, 0x54,
      0x6f, 0x40, 0xbc, 0xf2, 0x7e, 0x72, 0x3c, 0xa2, 0xae, 0x51, 0x6e, 0x76,
      0x84, 0x88, 0xb2, 0xce, 0x19, 0x30, 0x3f, 0x4c, 0xfe, 0x54, 0xf2, 0x7b,
      0xe9, 0xf6, 0x7b, 0x23, 0x9a, 0xa6, 0xb3, 0x79, 0x48, 0x79, 0x95, 0x67,
      0x11, 0x05, 0xa2, 0x19, 0x23, 0xbf, 0xcd, 0x14, 0xd5, 0x1b, 0x4b, 0x5d,
      0x72, 0x2c, 0xc7, 0xcd, 0x0a, 0x6f, 0x4b, 0x45, 0xa9, 0x5b, 0xdf, 0xb2,
      0x68, 0xfc, 0x6d, 0xfd, 0x38, 0xcf, 0x73, 0x80, 0x4c, 0x20, 0x29, 0xec,
      0x83, 0xd0, 0x55, 0xd4, 0x99, 0x95, 0xc4, 0xe1, 0x89, 0x6b, 0xab, 0x3b,
      0x7a, 0xb0, 0x83, 0x5b, 0xd8, 0xff, 0x1a, 0x2c, 0xf4, 0xca, 0x18, 0x5c,
      0xb8, 0xb5, 0x20, 0xc8, 0xd7, 0x07, 0xd7, 0x04, 0x29, 0xe6, 0x67, 0xa5,
      0xe2, 0xf4, 0x00, 0x60, 0x49, 0x4a, 0x02, 0x2c, 0x17, 0xda, 0x52, 0xcc,
      0x81, 0x11, 0xc4, 0x03, 0x85, 0x16, 0x4a, 0x34, 0xee, 0x45, 0xdf, 0xb5,
      0x2b, 0xb3, 0x45, 0x45, 0xde, 0xe9, 0x70, 0x8f, 0xdf, 0x2e, 0xe2, 0x21,
      0xf7, 0x43, 0x4d, 0x0a, 0x0f, 0x80, 0xb7, 0xba, 0xe2, 0xa7, 0xe9, 0xc0,
      0x1e, 0x2d, 0x74, 0xa8, 0x89, 0xa2, 0x5a, 0x43, 0xf3, 0x9b, 0x3e, 0x75,
      0xce, 0x3c, 0x09, 0x32, 0x0c, 0xad, 0x05, 0x4d, 0x14, 0x52, 0x47, 0xc7,
      0xc9, 0x9d, 0x5b, 0x31, 0xa5, 0x3f, 0x9c, 0xd0, 0x52, 0x7c, 0xee, 0x1c,
      0x44, 0xed, 0x85, 0x45, 0x75, 0x0b, 0x63, 0x39, 0x16, 0xbc, 0x01, 0x64,
      0x54, 0xa0, 0xe1, 0xd4, 0xc0, 0x46, 0xe6, 0x00, 0xa4, 0x30, 0x29, 0xaf,
      0xa4, 0x33, 0x5d, 0x74, 0x79, 0x5c, 0xa5, 0x12, 0x16, 0xbb, 0x20, 0x41},
     pub_key_2,
     {0x31, 0x39, 0x36, 0x37, 0x35, 0x36, 0x31, 0x32, 0x35, 0x31},
     true},

    // Comment:
    // tcID: 41
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     41,
     32,
     {0x03, 0x23, 0x9c, 0xd5, 0xb4, 0x51, 0x55, 0xf6, 0xc4, 0x8a, 0xb1, 0xca,
      0x33, 0x47, 0xf7, 0x84, 0x64, 0x2e, 0x7a, 0xa7, 0x0b, 0xb7, 0xda, 0xd5,
      0xdd, 0x98, 0xd6, 0x54, 0x2f, 0xc4, 0xff, 0xa1, 0xfb, 0x4c, 0x1a, 0x4d,
      0xa2, 0x92, 0x7e, 0x3c, 0x39, 0x53, 0x86, 0xf2, 0xa6, 0x02, 0x49, 0x63,
      0xcd, 0x4f, 0x3e, 0xf4, 0x86, 0x25, 0xb9, 0xe8, 0x9e, 0x92, 0xed, 0x53,
      0xea, 0x68, 0xb1, 0xec, 0xf9, 0x62, 0xef, 0xf8, 0xe6, 0x11, 0x5f, 0x2e,
      0xef, 0x77, 0x65, 0x2c, 0x1b, 0x99, 0xd4, 0xd6, 0x12, 0x83, 0x67, 0x97,
      0x12, 0x03, 0xcd, 0x84, 0xd1, 0x34, 0xe1, 0xd3, 0xa2, 0xbb, 0xe0, 0xc9,
      0xd1, 0x58, 0x79, 0x51, 0x81, 0x65, 0xed, 0x03, 0xd4, 0x18, 0x1e, 0x29,
      0x5d, 0x6e, 0x66, 0xc4, 0x61, 0x9e, 0x61, 0xad, 0xca, 0x73, 0xa0, 0xdc,
      0x27, 0x27, 0x5e, 0xc3, 0x5d, 0x42, 0x6f, 0x6a, 0xdd, 0x92, 0xbb, 0x79,
      0x8d, 0xf2, 0x6b, 0x61, 0xbd, 0x34, 0x92, 0xb1, 0xd8, 0xfc, 0x6c, 0xa9,
      0xed, 0x67, 0x59, 0xc7, 0xc8, 0xff, 0x6e, 0xa3, 0x27, 0x53, 0xe1, 0x1b,
      0x4c, 0xa5, 0xcb, 0xae, 0x38, 0xf9, 0x8a, 0xc7, 0x77, 0x7a, 0xa5, 0x2a,
      0x5b, 0x75, 0x90, 0xf5, 0xd5, 0xd7, 0x61, 0x35, 0x39, 0x3f, 0xfe, 0x9a,
      0x3f, 0x15, 0x37, 0x9a, 0x4a, 0x26, 0x27, 0x96, 0xaa, 0x9b, 0x5a, 0xe0,
      0x86, 0x72, 0xf2, 0xa3, 0x56, 0x45, 0x34, 0xe2, 0xdc, 0x3f, 0x95, 0x7a,
      0x87, 0x16, 0xfe, 0x78, 0x6b, 0x00, 0x21, 0xb6, 0xe1, 0x93, 0x53, 0x55,
      0xab, 0xf9, 0xb0, 0xb7, 0x5a, 0xd3, 0xb8, 0x0a, 0xec, 0x1c, 0x15, 0x25,
      0x42, 0xb8, 0x13, 0xb8, 0x5f, 0x58, 0x20, 0xa7, 0x9d, 0x5f, 0x53, 0xe3,
      0xa3, 0x37, 0xb3, 0x6d, 0x4d, 0x3a, 0x64, 0x1c, 0x45, 0x0f, 0x88, 0x52,
      0x82, 0x37, 0xb6, 0x10, 0xf4, 0x89, 0x88, 0x60, 0x78, 0xa6, 0xa3, 0x7a,
      0x3a, 0x2d, 0x6d, 0x0b, 0xc4, 0x9a, 0xed, 0x98, 0xf9, 0x30, 0x6d, 0xbc,
      0xfb, 0xa3, 0x30, 0xd0, 0x0a, 0x0c, 0x45, 0xbe, 0x89, 0xc8, 0x57, 0x47,
      0x31, 0x0a, 0xe1, 0xbf, 0x8c, 0x92, 0xca, 0x96, 0x0a, 0x24, 0xbe, 0xb7,
      0x6a, 0x40, 0x20, 0xfe, 0x04, 0x37, 0xfb, 0xb9, 0x1e, 0xd5, 0xa5, 0x62,
      0x03, 0x18, 0x5e, 0xe5, 0x03, 0x5e, 0x1e, 0xb4, 0xc9, 0xa0, 0xcd, 0xb0,
      0xcf, 0x6e, 0xd8, 0xfc, 0xab, 0x39, 0x56, 0xb5, 0x43, 0xdf, 0xeb, 0xc8,
      0xea, 0x1f, 0x27, 0x5f, 0xa5, 0x29, 0xbf, 0x33, 0x56, 0x8a, 0x05, 0x3d,
      0x20, 0x41, 0xe3, 0x40, 0xdf, 0xf7, 0x24, 0xed, 0xf6, 0xeb, 0x6d, 0x2d,
      0xac, 0x13, 0x5a, 0xca, 0x21, 0x73, 0xba, 0xee, 0x10, 0x44, 0x42, 0x23,
      0x9c, 0x22, 0x66, 0xa7, 0xcc, 0x03, 0xcd, 0xef, 0xe5, 0xb9, 0x28, 0xc8},
     pub_key_2,
     {0x33, 0x34, 0x34, 0x37, 0x32, 0x35, 0x33, 0x33, 0x34, 0x33},
     true},

    // Comment:
    // tcID: 42
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     42,
     32,
     {0x64, 0xed, 0x1b, 0xc0, 0x54, 0x0b, 0x10, 0x94, 0x47, 0x05, 0x8f, 0xac,
      0x11, 0xad, 0x2a, 0x45, 0xda, 0xca, 0xe2, 0xb1, 0x74, 0xab, 0xb4, 0xc1,
      0x11, 0xe8, 0x68, 0xab, 0x5d, 0x9a, 0x62, 0x21, 0x45, 0xe5, 0x9f, 0x59,
      0x8e, 0x73, 0x68, 0x6b, 0x51, 0x70, 0x71, 0xb3, 0xf7, 0xbe, 0xe3, 0x4d,
      0x55, 0x14, 0x22, 0x7b, 0x93, 0x48, 0xfe, 0x0b, 0x2a, 0x5b, 0x77, 0x2b,
      0x7a, 0xd4, 0xd9, 0x58, 0x2a, 0xb2, 0x89, 0x8e, 0x18, 0x83, 0x74, 0x9e,
      0x75, 0x94, 0x7c, 0x64, 0x7a, 0x4c, 0xaa, 0x9d, 0x77, 0xd0, 0x93, 0x86,
      0xd9, 0xb4, 0xec, 0xaf, 0xc7, 0x41, 0xec, 0x27, 0x45, 0x54, 0x29, 0x9b,
      0xa2, 0x5f, 0x05, 0x15, 0xb7, 0xa1, 0xe5, 0x85, 0x44, 0xfb, 0x5d, 0xcd,
      0x8f, 0x99, 0x59, 0x5c, 0x05, 0x9f, 0x6b, 0x14, 0xaa, 0xbf, 0x62, 0xc2,
      0x63, 0xba, 0xc6, 0xb2, 0x95, 0x87, 0x5c, 0x86, 0x3e, 0x21, 0x0b, 0xfa,
      0xd7, 0x97, 0x72, 0xc6, 0x4b, 0xa0, 0xa3, 0x46, 0x11, 0x6c, 0xe7, 0x95,
      0x13, 0xfb, 0x17, 0x6f, 0x0e, 0x1f, 0x21, 0x29, 0xec, 0x2d, 0xb1, 0x12,
      0x84, 0x8d, 0xaf, 0xfd, 0x20, 0xda, 0x01, 0xf8, 0x20, 0x8b, 0x29, 0xf1,
      0x02, 0xcd, 0x81, 0x36, 0x91, 0xad, 0xac, 0xcf, 0x98, 0x06, 0x8c, 0x08,
      0x11, 0x68, 0xf2, 0xc1, 0x93, 0x20, 0x55, 0x07, 0x9f, 0x46, 0xe3, 0xeb,
      0xf3, 0x6e, 0x05, 0xbd, 0x45, 0x54, 0xab, 0x2d, 0x1a, 0x75, 0xa3, 0xbc,
      0xe9, 0xdb, 0x7c, 0x4d, 0x84, 0xa8, 0x98, 0x73, 0xf5, 0xb6, 0xbc, 0x87,
      0x47, 0x16, 0x6c, 0xfa, 0x86, 0x10, 0x92, 0x66, 0x4d, 0x1c, 0xe9, 0x5e,
      0x28, 0x01, 0x1e, 0xe9, 0x66, 0x1f, 0x14, 0x12, 0xc8, 0xec, 0x3e, 0xa1,
      0x96, 0xf9, 0x96, 0xe3, 0xe9, 0xe9, 0x3b, 0x5d, 0xd5, 0xf8, 0x9d, 0x31,
      0xd9, 0xf5, 0x67, 0x08, 0xbe, 0xb9, 0xb0, 0x6b, 0x92, 0xf7, 0xc1, 0xe5,
      0x8d, 0xf5, 0xef, 0xd5, 0xc6, 0x31, 0x15, 0xa7, 0x92, 0xba, 0x4d, 0x7f,
      0x69, 0xdd, 0xc7, 0x82, 0xae, 0x36, 0x45, 0x89, 0x4d, 0xac, 0x86, 0xd4,
      0x7e, 0x26, 0x71, 0xb8, 0xf0, 0xe6, 0x3e, 0xc7, 0x55, 0x9f, 0xb9, 0x97,
      0xb2, 0x5d, 0xae, 0xfd, 0x15, 0x89, 0xa8, 0x0f, 0x16, 0x3f, 0x93, 0xce,
      0xaa, 0x39, 0x72, 0x92, 0xad, 0xa9, 0x73, 0x29, 0x6c, 0x6b, 0x0f, 0x26,
      0x60, 0xc6, 0xbf, 0x7b, 0x66, 0xb6, 0x28, 0xb6, 0x96, 0xa6, 0x10, 0x9c,
      0x9e, 0x51, 0x6f, 0xad, 0xb2, 0x5a, 0x3f, 0x47, 0x5e, 0xe1, 0xf2, 0x73,
      0xa4, 0x90, 0xa0, 0x28, 0x39, 0x6b, 0xab, 0x59, 0xff, 0xb8, 0xe9, 0x1a,
      0xbc, 0xe0, 0xa2, 0x46, 0x63, 0x1c, 0x2c, 0x76, 0xee, 0x08, 0xf8, 0x70,
      0x17, 0x04, 0xf0, 0xc4, 0x34, 0x7e, 0xdf, 0x03, 0xe3, 0xf2, 0xe5, 0x21},
     pub_key_2,
     {0x33, 0x36, 0x38, 0x32, 0x36, 0x34, 0x33, 0x31, 0x38},
     true},

    // Comment:
    // tcID: 43
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     43,
     32,
     {0x65, 0x49, 0x2f, 0xcd, 0xdd, 0x65, 0x29, 0xa4, 0xe1, 0xc1, 0x9f, 0x79,
      0x50, 0xc4, 0x92, 0x02, 0x1d, 0xb0, 0x3f, 0x4d, 0x74, 0x05, 0x13, 0x96,
      0xa9, 0x4a, 0xbb, 0xfc, 0x6c, 0x70, 0xec, 0x10, 0xad, 0xc1, 0xc4, 0x4c,
      0xf7, 0x75, 0x35, 0xe9, 0x8d, 0xa1, 0xa0, 0x96, 0xef, 0x5e, 0x93, 0xbc,
      0x55, 0xf9, 0xa9, 0xde, 0xd5, 0xd5, 0x9e, 0xb1, 0x5e, 0xbe, 0xc1, 0x7d,
      0xd5, 0x1c, 0xbf, 0x7e, 0x26, 0xcf, 0x9a, 0x82, 0x91, 0xd7, 0xab, 0xd8,
      0x29, 0x43, 0x98, 0x19, 0x3e, 0x98, 0x1a, 0xb8, 0x4f, 0x53, 0x85, 0x96,
      0x2e, 0x7c, 0xb7, 0xb2, 0x6f, 0x43, 0x87, 0x5b, 0x8a, 0x2a, 0x2e, 0x89,
      0xea, 0xb0, 0x11, 0xcd, 0x8a, 0x9d, 0x3d, 0x68, 0x34, 0x07, 0xee, 0xfb,
      0xc7, 0xef, 0xdd, 0x2a, 0x81, 0x61, 0x8b, 0x5a, 0x7c, 0x0f, 0x6f, 0x07,
      0xcf, 0x31, 0x1f, 0xa4, 0x26, 0xc8, 0x69, 0x74, 0xa9, 0xda, 0x06, 0xc9,
      0xa8, 0x98, 0x1a, 0x04, 0x8f, 0x8c, 0x7b, 0x32, 0x55, 0xea, 0xeb, 0x3e,
      0x10, 0xd3, 0xd8, 0xc0, 0x18, 0x7d, 0xc5, 0xb3, 0x62, 0x9b, 0xf5, 0x34,
      0x99, 0x96, 0x65, 0x5b, 0xf5, 0xf3, 0x72, 0xb5, 0x0d, 0x82, 0x38, 0x1c,
      0xac, 0xb3, 0xd9, 0x24, 0x8b, 0x31, 0x3f, 0xc3, 0x53, 0x64, 0x51, 0x99,
      0x82, 0x45, 0x34, 0xcd, 0x49, 0x53, 0xb2, 0xaa, 0xcb, 0x20, 0x11, 0x0a,
      0xe4, 0x26, 0xae, 0x59, 0xf8, 0x46, 0x50, 0xbb, 0x3b, 0x85, 0xf5, 0x80,
      0x94, 0x05, 0x65, 0x11, 0x36, 0x2f, 0x9f, 0xe6, 0x26, 0x01, 0xfc, 0x05,
      0xee, 0x75, 0xf5, 0x93, 0x5b, 0x85, 0x26, 0xba, 0xb6, 0x96, 0x8b, 0x96,
      0xc0, 0xc6, 0x5d, 0x40, 0xfe, 0xce, 0x4b, 0x70, 0x03, 0x7f, 0xc3, 0x19,
      0xdd, 0xb9, 0xf9, 0xd8, 0x6a, 0x45, 0x3d, 0x32, 0xde, 0x28, 0x18, 0xef,
      0x5e, 0x26, 0x93, 0xa6, 0xbe, 0xec, 0x62, 0x7d, 0x88, 0x1a, 0x00, 0x80,
      0x5e, 0x55, 0x3e, 0x15, 0x17, 0x6e, 0x9f, 0xaa, 0x6c, 0x91, 0x02, 0x9e,
      0x3b, 0x80, 0x1b, 0xea, 0x69, 0xf4, 0x27, 0xc2, 0xdc, 0x05, 0xf9, 0xdb,
      0x8c, 0xe7, 0xd5, 0xa3, 0x1a, 0x6d, 0xa5, 0xeb, 0x8f, 0x11, 0x25, 0xd3,
      0xba, 0x72, 0x49, 0x97, 0xdf, 0x48, 0xaf, 0x34, 0xe4, 0x0a, 0x63, 0x07,
      0xc7, 0xef, 0x1d, 0x20, 0x53, 0x61, 0xbd, 0xc8, 0x98, 0x17, 0xc4, 0xd1,
      0xa2, 0x02, 0x38, 0x74, 0xcb, 0x2a, 0x8d, 0xc9, 0x03, 0xab, 0x17, 0x1f,
      0xd1, 0x4d, 0xf0, 0x74, 0x5d, 0x65, 0xf3, 0x20, 0x4d, 0x99, 0xe0, 0xd9,
      0x20, 0xbc, 0x36, 0xf3, 0x82, 0xda, 0xd0, 0x9a, 0x4b, 0x17, 0x4a, 0xdb,
      0xd8, 0xbc, 0x72, 0x02, 0x7b, 0xfa, 0x11, 0x85, 0x83, 0x8e, 0x2b, 0x20,
      0xca, 0x7a, 0x6e, 0xd2, 0x26, 0xeb, 0x8b, 0x85, 0xdf, 0x5f, 0xe2, 0x6a},
     pub_key_2,
     {0x33, 0x32, 0x36, 0x31, 0x31, 0x39, 0x38, 0x36, 0x30, 0x38},
     true},

    // Comment:
    // tcID: 44
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     44,
     32,
     {0x37, 0xec, 0x05, 0x63, 0x88, 0x18, 0x1d, 0x85, 0x38, 0xbc, 0x2e, 0xfe,
      0xcd, 0x67, 0x99, 0x86, 0xd8, 0xa0, 0xef, 0x2a, 0xe3, 0x1d, 0xdc, 0x67,
      0xfc, 0x54, 0xaa, 0x91, 0x5a, 0xb6, 0x03, 0xa6, 0xa3, 0x4d, 0x62, 0xfa,
      0xe5, 0x86, 0xe4, 0x50, 0x1b, 0xbc, 0x61, 0x08, 0x5f, 0xd7, 0x98, 0xb3,
      0xef, 0x75, 0x3c, 0xfa, 0x2c, 0x06, 0x48, 0xb3, 0xce, 0xae, 0xcd, 0xd3,
      0x93, 0xee, 0x60, 0x1a, 0x89, 0xd5, 0x02, 0xff, 0x9a, 0xc1, 0x47, 0x11,
      0xba, 0x6a, 0x8d, 0x37, 0x7a, 0xfa, 0xfd, 0xbf, 0x40, 0x17, 0xf6, 0xcb,
      0x09, 0x5b, 0x7b, 0xea, 0x1d, 0x99, 0x26, 0x0e, 0x51, 0xaf, 0x92, 0xbb,
      0xe9, 0x34, 0x90, 0xaa, 0x48, 0x4f, 0xb3, 0x8a, 0x91, 0xf8, 0xe4, 0xbb,
      0x94, 0xaf, 0x87, 0x2b, 0xda, 0x58, 0x7f, 0x2f, 0x7c, 0x52, 0x69, 0xba,
      0x71, 0x10, 0xc5, 0xf2, 0x18, 0x2c, 0x81, 0x0f, 0xf0, 0xee, 0x35, 0x6d,
      0xfe, 0x7b, 0x08, 0x4b, 0x3d, 0xe5, 0xe1, 0x5a, 0x11, 0x96, 0xba, 0xef,
      0x0b, 0xc8, 0x64, 0x09, 0xef, 0x18, 0x72, 0x97, 0xe0, 0x17, 0x19, 0xca,
      0x19, 0x14, 0xbe, 0xae, 0x4e, 0x52, 0xb7, 0xa4, 0x94, 0xe0, 0xfe, 0x25,
      0x78, 0xc4, 0x05, 0x1b, 0x5b, 0xe6, 0x11, 0x35, 0xdd, 0x03, 0x45, 0xdd,
      0x96, 0xea, 0x78, 0x0e, 0x7e, 0xfb, 0xfa, 0x63, 0x42, 0x42, 0x3f, 0xe4,
      0xf6, 0x7b, 0xb5, 0xc7, 0x9d, 0xc5, 0x58, 0x52, 0xb3, 0xbe, 0x79, 0xfe,
      0xdd, 0x98, 0x08, 0x97, 0xd6, 0x8d, 0x61, 0xea, 0x3e, 0x4d, 0x53, 0x36,
      0xd8, 0x23, 0x70, 0xf9, 0x24, 0xac, 0xc1, 0x39, 0xb6, 0xac, 0x71, 0x1c,
      0xea, 0xe9, 0xcc, 0x60, 0xb9, 0xbe, 0xa1, 0x3c, 0x32, 0x07, 0x4a, 0x47,
      0x5c, 0x62, 0x22, 0x9d, 0x96, 0x3a, 0x15, 0x27, 0x01, 0x21, 0x46, 0xc5,
      0x3f, 0x97, 0x09, 0x3f, 0x5b, 0x2e, 0x20, 0x39, 0xa4, 0xd5, 0x2f, 0x45,
      0x66, 0xbf, 0x3b, 0x8b, 0xf5, 0x5d, 0x8d, 0x2e, 0xfd, 0xca, 0x72, 0x95,
      0x05, 0xbf, 0x0d, 0x1b, 0x0b, 0x12, 0x0a, 0xa8, 0x35, 0xef, 0x2c, 0xb7,
      0xc3, 0xba, 0x06, 0x5f, 0x81, 0x38, 0x6c, 0xad, 0xbc, 0x00, 0xc0, 0x60,
      0xc1, 0x8f, 0x4a, 0xc9, 0x89, 0xc7, 0x57, 0xa6, 0x31, 0x08, 0xbe, 0x4e,
      0xcf, 0x6d, 0xa3, 0x18, 0x38, 0xb1, 0x7e, 0xe1, 0xc3, 0x7b, 0x66, 0xa8,
      0x87, 0xf7, 0x41, 0xf8, 0xbd, 0xeb, 0xc3, 0xc0, 0xb9, 0x59, 0x94, 0x04,
      0x61, 0xe2, 0x08, 0xae, 0xe5, 0x39, 0xcb, 0xd1, 0x09, 0x94, 0xbc, 0xc6,
      0xc0, 0xd2, 0xf5, 0x5c, 0x41, 0xa1, 0x7f, 0x8f, 0xde, 0x8a, 0xa5, 0xc0,
      0xd3, 0xc4, 0xfb, 0xb3, 0x5d, 0xd4, 0x8b, 0x6e, 0xbd, 0x9f, 0x71, 0x8d,
      0x92, 0x4b, 0xf1, 0x6a, 0xa4, 0xd1, 0x07, 0x47, 0x1a, 0x9a, 0x3e, 0x71},
     pub_key_2,
     {0x39, 0x36, 0x37, 0x38, 0x37, 0x38, 0x31, 0x30, 0x39, 0x34},
     true},

    // Comment:
    // tcID: 45
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     45,
     32,
     {0x0b, 0x31, 0x0c, 0xe9, 0x60, 0xef, 0xe7, 0xd0, 0x7c, 0x04, 0xce, 0x0e,
      0x3d, 0x36, 0x5f, 0x15, 0x7a, 0x48, 0xb1, 0x71, 0xbc, 0xf2, 0xdd, 0xc7,
      0x5e, 0xf0, 0x2e, 0x09, 0x77, 0x11, 0xec, 0xd1, 0x94, 0x2a, 0xce, 0x2c,
      0x41, 0x46, 0x82, 0xdc, 0x2c, 0x4b, 0x2c, 0xa8, 0x84, 0xb9, 0xfd, 0x7a,
      0x49, 0x52, 0x73, 0x19, 0xc9, 0xf4, 0x44, 0xcb, 0x3e, 0x39, 0xa9, 0x2d,
      0x1d, 0x7c, 0x82, 0x36, 0x01, 0x04, 0x32, 0xe7, 0x31, 0x18, 0x15, 0x14,
      0xd0, 0x84, 0x2e, 0xed, 0x1a, 0x35, 0x80, 0xca, 0x55, 0x1f, 0x81, 0xcf,
      0x8a, 0x43, 0x01, 0x4a, 0xd4, 0xd5, 0x7f, 0x48, 0xa9, 0x12, 0x07, 0xca,
      0xc1, 0x55, 0xdc, 0x40, 0x72, 0x40, 0x78, 0xa4, 0xd2, 0x20, 0xf3, 0x90,
      0x6b, 0x9c, 0x22, 0x89, 0xaf, 0x6e, 0xa3, 0x90, 0x22, 0x2e, 0x3f, 0x6c,
      0x17, 0xa6, 0x29, 0x16, 0x96, 0x54, 0x59, 0x38, 0x7d, 0x4e, 0xf6, 0x0c,
      0x39, 0xeb, 0x90, 0x9f, 0x6c, 0x2f, 0xbf, 0x5d, 0x5e, 0x67, 0xc6, 0x5e,
      0xc1, 0x32, 0xf7, 0x63, 0xcb, 0x43, 0x12, 0x72, 0x81, 0xcb, 0x01, 0x48,
      0xa0, 0x65, 0x71, 0xf7, 0xff, 0x84, 0xb1, 0x1a, 0x55, 0x1e, 0x4a, 0x2b,
      0x7c, 0xe4, 0x27, 0x92, 0x83, 0x0a, 0x13, 0xca, 0x5c, 0x1a, 0x63, 0xaa,
      0x50, 0x44, 0xf1, 0xfa, 0x96, 0x08, 0x5d, 0xcd, 0xf0, 0xd2, 0xc4, 0xd7,
      0xf8, 0xac, 0x3a, 0x95, 0x7b, 0xbc, 0xd6, 0xf1, 0x40, 0x9c, 0xdc, 0xc2,
      0xad, 0x59, 0xf8, 0xf6, 0x2b, 0x72, 0x86, 0x30, 0x9c, 0x8b, 0x77, 0xf8,
      0x56, 0x79, 0xbe, 0xe9, 0x2d, 0xf4, 0xab, 0xdd, 0xa6, 0x72, 0x87, 0xd1,
      0x5e, 0x61, 0x45, 0xeb, 0xf4, 0xf7, 0xff, 0xbb, 0x11, 0x13, 0x9f, 0x17,
      0x25, 0x2c, 0x80, 0xec, 0x7e, 0xf1, 0xa7, 0xf5, 0x89, 0xae, 0x44, 0xb2,
      0x6b, 0x00, 0xd1, 0x1e, 0x22, 0x8b, 0xb1, 0xa7, 0x53, 0x39, 0xb4, 0x7c,
      0xa9, 0x4e, 0x84, 0xff, 0x79, 0x7b, 0x85, 0x51, 0xa6, 0x34, 0x4b, 0x72,
      0xcb, 0x83, 0x73, 0xc2, 0x6e, 0x36, 0x0c, 0xef, 0xf4, 0xb4, 0x35, 0x11,
      0xa4, 0x7f, 0x7e, 0x6e, 0x99, 0xfe, 0xc8, 0x28, 0xdd, 0x1e, 0x9b, 0xfe,
      0x90, 0x1f, 0xca, 0x7b, 0x95, 0xe8, 0x8f, 0x74, 0x19, 0xa7, 0xe3, 0xfb,
      0xeb, 0x14, 0xb1, 0x16, 0x3e, 0x03, 0x2d, 0x73, 0x18, 0x76, 0xa7, 0x70,
      0x44, 0x18, 0xa2, 0x75, 0x31, 0xd4, 0xf6, 0xa3, 0x36, 0x52, 0xe5, 0xa4,
      0x19, 0xd2, 0x1a, 0xee, 0xd1, 0x48, 0x6b, 0xe6, 0x26, 0xd6, 0xa0, 0x9b,
      0xc3, 0xd3, 0x58, 0x1e, 0xab, 0xf5, 0x55, 0x54, 0x5c, 0xc9, 0xd5, 0x80,
      0x05, 0xf7, 0x4c, 0x94, 0xf7, 0x07, 0x77, 0x45, 0x05, 0x01, 0xdf, 0x2a,
      0x8d, 0x16, 0x9a, 0x57, 0xd8, 0xc2, 0xec, 0x70, 0xdd, 0x15, 0x9f, 0xbf},
     pub_key_2,
     {0x34, 0x39, 0x35, 0x38, 0x38, 0x32, 0x33, 0x38, 0x32, 0x33},
     true},

    // Comment:
    // tcID: 46
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     46,
     32,
     {0x0d, 0x5c, 0x19, 0x37, 0x6a, 0x13, 0x37, 0x66, 0x55, 0xc0, 0x52, 0x70,
      0x30, 0x17, 0x74, 0xc7, 0xd0, 0x88, 0x79, 0xd4, 0xfd, 0xc3, 0x41, 0xe6,
      0x44, 0x11, 0xdf, 0xbe, 0xa6, 0xc1, 0x35, 0xc6, 0x3a, 0xb5, 0x0c, 0x20,
      0xba, 0xc3, 0x75, 0xda, 0x36, 0x81, 0x1c, 0xb6, 0xcb, 0xc9, 0xca, 0x6a,
      0xce, 0x90, 0x6c, 0x6a, 0xcd, 0x56, 0x81, 0xec, 0x4a, 0x6b, 0x54, 0x5a,
      0x54, 0x31, 0x6e, 0xd1, 0x52, 0x6a, 0x69, 0xfa, 0x65, 0x25, 0xb1, 0x1c,
      0x9b, 0x98, 0xf8, 0xf2, 0x9a, 0x98, 0x49, 0x50, 0xf7, 0x74, 0x86, 0xb0,
      0xa1, 0x5c, 0xe8, 0x55, 0x82, 0x61, 0x02, 0xbd, 0x3b, 0xa3, 0xb1, 0x65,
      0x1c, 0x8d, 0xca, 0xf4, 0x03, 0x1c, 0xe2, 0x8f, 0x51, 0xaf, 0x0a, 0x36,
      0x1a, 0x23, 0xe2, 0x93, 0xaa, 0xdb, 0x72, 0x7b, 0x18, 0x1e, 0xeb, 0x50,
      0xf4, 0xfc, 0xed, 0xfd, 0x58, 0x47, 0xf1, 0xd0, 0x14, 0x21, 0xf1, 0x2f,
      0x3c, 0xd1, 0x1b, 0x1a, 0x2b, 0x3b, 0x3f, 0xf2, 0xe6, 0xfb, 0x31, 0xf2,
      0xc1, 0x38, 0xa2, 0xf4, 0xf7, 0x7d, 0x00, 0x8a, 0x46, 0x39, 0xfc, 0x81,
      0x4a, 0xa6, 0xfb, 0xf8, 0xa4, 0x70, 0x04, 0xc7, 0xbb, 0x72, 0xde, 0x41,
      0xd0, 0x32, 0x95, 0x80, 0xf9, 0xdd, 0xbd, 0x2d, 0x19, 0xe0, 0x77, 0xfd,
      0x90, 0x87, 0x14, 0x49, 0x31, 0x89, 0x5b, 0xea, 0x8b, 0x61, 0x63, 0x54,
      0xf7, 0xda, 0x1a, 0xcf, 0x07, 0x7d, 0x8c, 0xd3, 0x40, 0x21, 0xa8, 0x8f,
      0xbb, 0x73, 0xcc, 0xb7, 0x35, 0xc1, 0xba, 0xe6, 0x12, 0x7c, 0x48, 0xd1,
      0x51, 0xdb, 0x02, 0xd7, 0x67, 0x17, 0x60, 0xb2, 0x5d, 0x24, 0x00, 0x71,
      0x11, 0x52, 0xd5, 0xc2, 0x7a, 0x31, 0x8d, 0xdd, 0x47, 0x4f, 0x84, 0x88,
      0x5c, 0x12, 0xe8, 0xfb, 0xfa, 0x55, 0x33, 0x22, 0x48, 0x24, 0x39, 0xf5,
      0xc9, 0xd2, 0x83, 0x2a, 0xce, 0x15, 0xaa, 0x33, 0x6c, 0xc0, 0x92, 0xa1,
      0x30, 0x24, 0x47, 0x6b, 0x95, 0xcc, 0xfe, 0xf9, 0x02, 0x2a, 0x4e, 0x0f,
      0x0b, 0xfb, 0xc5, 0x5c, 0x40, 0x94, 0x7d, 0x45, 0x57, 0x0e, 0xa8, 0xf0,
      0x98, 0x00, 0xf8, 0x5e, 0x0c, 0xfd, 0xa4, 0xeb, 0x99, 0x99, 0xd8, 0x59,
      0xb9, 0xb3, 0xa1, 0xe9, 0xe9, 0xee, 0x08, 0x07, 0xab, 0x32, 0xe9, 0x3f,
      0x1e, 0x16, 0xee, 0x36, 0xe4, 0xf4, 0xb6, 0x56, 0xeb, 0x3c, 0x61, 0x6a,
      0xd7, 0x97, 0xe1, 0x7d, 0xfb, 0x53, 0x00, 0xc6, 0x55, 0x3e, 0xec, 0xe8,
      0x76, 0xdc, 0xe9, 0x78, 0xb8, 0xcb, 0x08, 0x2a, 0x0e, 0x9b, 0xcc, 0xcf,
      0x47, 0x08, 0xa4, 0xf8, 0x21, 0x18, 0x93, 0x54, 0xf9, 0xe7, 0x31, 0x0c,
      0x35, 0x8e, 0x86, 0x45, 0x38, 0xac, 0x37, 0x42, 0x17, 0xe8, 0x37, 0x9a,
      0xa9, 0xf0, 0xe0, 0xe7, 0xda, 0xca, 0x3a, 0xb8, 0xd4, 0x6a, 0x6a, 0xe6},
     pub_key_2,
     {0x38, 0x32, 0x34, 0x36, 0x33, 0x37, 0x38, 0x33, 0x37},
     true},

    // Comment:
    // tcID: 47
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     47,
     32,
     {0x45, 0x67, 0xe5, 0x47, 0x63, 0x46, 0xc0, 0x6b, 0x1b, 0xa2, 0x64, 0xf6,
      0x6c, 0xfd, 0x9e, 0x18, 0x10, 0x59, 0xd4, 0x4b, 0x0c, 0x37, 0xc4, 0x28,
      0x0a, 0x41, 0xe4, 0x1d, 0x11, 0x3c, 0x89, 0x83, 0x4c, 0x0a, 0xa6, 0x8d,
      0x25, 0xe1, 0xab, 0x87, 0x17, 0xcd, 0x85, 0xc8, 0xb4, 0xbd, 0xee, 0x48,
      0x2c, 0x3e, 0xed, 0x7d, 0x2e, 0xee, 0x16, 0x94, 0x7b, 0xd6, 0x8c, 0xa7,
      0xe6, 0x38, 0x11, 0x87, 0xb9, 0xf0, 0x9a, 0x34, 0x68, 0xe2, 0xf6, 0x7b,
      0x0c, 0xbf, 0x40, 0x4f, 0x0f, 0x56, 0x34, 0xf0, 0xce, 0x62, 0xad, 0x7e,
      0xed, 0x6f, 0x55, 0x7d, 0x78, 0x74, 0x29, 0x0b, 0x8b, 0x3a, 0x93, 0x47,
      0xe4, 0xf2, 0x03, 0xe7, 0xd2, 0x46, 0x09, 0x6f, 0x45, 0x75, 0x12, 0x7e,
      0x86, 0x0b, 0x13, 0x69, 0x7b, 0x27, 0xfb, 0xdf, 0x4f, 0xe4, 0x65, 0x41,
      0xc4, 0x81, 0x61, 0x67, 0x6b, 0xf1, 0x39, 0xcb, 0x8b, 0x75, 0xce, 0x52,
      0x80, 0x79, 0xbd, 0x6f, 0x01, 0xe6, 0x86, 0x63, 0xa7, 0xa7, 0xa3, 0xca,
      0x94, 0x4e, 0xea, 0x31, 0x25, 0x39, 0xd3, 0x2e, 0xd1, 0x1e, 0x0f, 0x3b,
      0x10, 0x62, 0xea, 0x9c, 0x25, 0x16, 0x97, 0x46, 0x8c, 0xb7, 0xca, 0xdd,
      0x18, 0x2f, 0x4e, 0x47, 0x60, 0x2c, 0x14, 0x55, 0x33, 0x95, 0xc6, 0x91,
      0xa4, 0x27, 0x1f, 0x11, 0x7a, 0x9d, 0xb6, 0x13, 0xe2, 0xe8, 0x2a, 0x9a,
      0x57, 0x05, 0xab, 0x4f, 0xfc, 0x7d, 0xc7, 0xc0, 0xab, 0xd0, 0x37, 0x1c,
      0x5c, 0xa1, 0x08, 0x80, 0x27, 0x7f, 0xf8, 0x3f, 0x86, 0xb4, 0x20, 0x4f,
      0x72, 0x00, 0x5b, 0x6b, 0xd4, 0x2a, 0xb0, 0x3d, 0xb0, 0xab, 0x7e, 0xf8,
      0x2d, 0xbd, 0x48, 0xc7, 0xaa, 0x8e, 0x8f, 0x44, 0x8b, 0xce, 0x64, 0x08,
      0x2f, 0xd9, 0x35, 0x42, 0x0b, 0x88, 0xfa, 0xc0, 0x10, 0x80, 0xcf, 0x54,
      0x4b, 0x18, 0x74, 0x63, 0x46, 0xc0, 0xb1, 0xe8, 0x0d, 0x82, 0xc4, 0x74,
      0x5a, 0xde, 0x0b, 0x0a, 0x53, 0xf2, 0x26, 0x59, 0x4c, 0x7e, 0x55, 0x0d,
      0xf3, 0x7f, 0x58, 0x56, 0x39, 0x0f, 0xde, 0x9d, 0xe9, 0xfe, 0x73, 0xb7,
      0x8e, 0xfb, 0x48, 0x40, 0xb9, 0xe3, 0x30, 0x80, 0x3b, 0x92, 0xb1, 0xa1,
      0x92, 0x26, 0x9e, 0x85, 0x37, 0x73, 0x0f, 0xfb, 0x82, 0x07, 0x94, 0x77,
      0x24, 0xdd, 0x6d, 0x73, 0xc2, 0xf9, 0x7b, 0x7c, 0x46, 0x5d, 0xd4, 0x7c,
      0x0d, 0xec, 0x5d, 0x6b, 0x27, 0x37, 0x8e, 0x53, 0xdf, 0xe9, 0x1a, 0xb7,
      0xc8, 0xfc, 0xf2, 0x7e, 0xfd, 0xb0, 0x8f, 0xce, 0xc4, 0x50, 0x3d, 0x02,
      0xf2, 0x31, 0xa5, 0x23, 0x67, 0xec, 0x85, 0x37, 0x0e, 0xb1, 0xd9, 0x59,
      0x83, 0x9a, 0x77, 0x63, 0x47, 0x81, 0x58, 0x7f, 0xdc, 0x98, 0x15, 0x60,
      0x3b, 0x83, 0x65, 0xd8, 0xda, 0x7f, 0x55, 0xf9, 0xa1, 0x43, 0x9b, 0xfe},
     pub_key_2,
     {0x31, 0x31, 0x30, 0x32, 0x30, 0x38, 0x33, 0x33, 0x37, 0x37, 0x36},
     true},

    // Comment:
    // tcID: 48
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     48,
     32,
     {0x61, 0x7d, 0xb8, 0xfc, 0x96, 0xc1, 0x22, 0xd6, 0x56, 0x6a, 0x59, 0xa0,
      0x3f, 0x25, 0x73, 0x36, 0xc7, 0x56, 0x51, 0x17, 0x65, 0x17, 0x51, 0xb4,
      0xb7, 0x60, 0x45, 0xe6, 0xa0, 0x75, 0xaa, 0x3f, 0xd4, 0x81, 0xb4, 0x83,
      0xd0, 0x6f, 0x96, 0x6c, 0x06, 0x85, 0x2e, 0x0f, 0xab, 0xf2, 0xa9, 0x97,
      0xee, 0xde, 0x48, 0x1e, 0xa7, 0x07, 0x27, 0x82, 0x83, 0xf8, 0x0f, 0x8f,
      0xd3, 0xd9, 0xd7, 0x6b, 0x96, 0x80, 0x63, 0xeb, 0x16, 0x0a, 0x4f, 0x22,
      0xb2, 0xd5, 0xc4, 0x57, 0x15, 0xb0, 0x46, 0xab, 0xb0, 0x0a, 0x99, 0x96,
      0xd9, 0xa4, 0xc3, 0x18, 0x60, 0x8b, 0x6d, 0xe1, 0x7f, 0x82, 0x87, 0xf7,
      0x69, 0xd8, 0x01, 0xc7, 0xec, 0xd1, 0xe6, 0x56, 0x56, 0xde, 0x68, 0x55,
      0xf7, 0x7f, 0x30, 0x24, 0xfb, 0x57, 0xb3, 0xf5, 0xba, 0x53, 0x0f, 0xdb,
      0xb5, 0xf3, 0x4a, 0x1d, 0x5d, 0x34, 0x35, 0x7b, 0xef, 0x98, 0x4c, 0x29,
      0xe3, 0x63, 0x28, 0xc7, 0xb6, 0x1a, 0x82, 0xd8, 0x4a, 0x24, 0xbd, 0x81,
      0x1a, 0x94, 0x5d, 0xb0, 0x51, 0xd3, 0x01, 0x1f, 0x70, 0x38, 0x65, 0xcf,
      0x45, 0xcc, 0xc5, 0x9a, 0x72, 0x2e, 0x88, 0x02, 0xe7, 0xb7, 0x44, 0xa1,
      0xc1, 0xd5, 0xe1, 0x9b, 0xae, 0x1c, 0xa9, 0x83, 0x0c, 0x2a, 0xe2, 0x22,
      0x39, 0xa1, 0x15, 0xc2, 0xe6, 0xbb, 0x5e, 0x05, 0x18, 0x08, 0x26, 0xeb,
      0x5a, 0x98, 0x48, 0xa5, 0x23, 0x7e, 0x1c, 0x7b, 0x2f, 0x38, 0x69, 0x0f,
      0x43, 0xe9, 0x12, 0x90, 0x1f, 0x45, 0xa6, 0x9c, 0xbb, 0xcf, 0xac, 0xd0,
      0xf6, 0xe6, 0x28, 0x7d, 0x63, 0xb2, 0x31, 0x42, 0x56, 0x26, 0xe8, 0x76,
      0xa8, 0x83, 0x7a, 0x6e, 0xef, 0x68, 0x6f, 0x9a, 0x27, 0xee, 0x04, 0xdd,
      0xa2, 0x58, 0x43, 0xca, 0x1c, 0x71, 0x3a, 0xcd, 0x64, 0xdd, 0x26, 0x38,
      0x2f, 0x3f, 0x41, 0x59, 0x0c, 0x66, 0xac, 0xba, 0x0e, 0x8f, 0xe5, 0xb6,
      0x10, 0xf3, 0xfd, 0xa9, 0x6c, 0xc5, 0x0a, 0x2b, 0x12, 0xb4, 0xfe, 0xfc,
      0x59, 0x38, 0x80, 0x20, 0xc0, 0x78, 0x37, 0x5e, 0xb5, 0x42, 0x2b, 0x38,
      0x64, 0x1d, 0x6b, 0x7c, 0x52, 0x98, 0xc0, 0x47, 0xab, 0x7f, 0x48, 0xc9,
      0x9c, 0xfc, 0x35, 0x58, 0xfa, 0xd3, 0xac, 0xc9, 0x22, 0x66, 0x53, 0xa5,
      0x0b, 0x21, 0x0b, 0x7e, 0x82, 0xb1, 0xb7, 0x57, 0xc2, 0x24, 0x62, 0xb0,
      0x66, 0xd8, 0x1c, 0x80, 0xca, 0xa5, 0x1d, 0xad, 0xd9, 0x92, 0x28, 0xa7,
      0xf2, 0x1a, 0xc4, 0x53, 0x8a, 0xa4, 0x4e, 0xa0, 0x34, 0x53, 0x4f, 0x2b,
      0xaf, 0xb9, 0xd1, 0xa3, 0x5f, 0x88, 0xea, 0x87, 0x0c, 0x97, 0x5b, 0xcf,
      0x1e, 0x2f, 0x20, 0x0a, 0xe1, 0x75, 0x71, 0x2f, 0x01, 0x25, 0x80, 0x73,
      0xb1, 0xfd, 0xb8, 0x0c, 0xc0, 0xb8, 0xd5, 0x57, 0xe6, 0xe2, 0x65, 0xff},
     pub_key_2,
     {0x31, 0x33, 0x33, 0x38, 0x37, 0x31, 0x36, 0x34, 0x38},
     true},

    // Comment:
    // tcID: 49
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     49,
     32,
     {0x5f, 0xd3, 0xfa, 0xbd, 0xd5, 0x7d, 0x92, 0xca, 0x50, 0x67, 0x81, 0xf7,
      0x01, 0x0a, 0x67, 0x5e, 0x30, 0x3c, 0x2e, 0x79, 0x4c, 0x14, 0x66, 0xf0,
      0x2b, 0x21, 0x05, 0x09, 0xa8, 0xea, 0xc6, 0x48, 0x7c, 0xe3, 0x23, 0xe7,
      0x57, 0xd2, 0x5c, 0xc8, 0xf7, 0xf3, 0x7b, 0x04, 0x1a, 0x6b, 0x91, 0x0b,
      0xef, 0x34, 0xc0, 0x48, 0x0b, 0x6e, 0xc7, 0xa0, 0xb7, 0xe9, 0x7a, 0x48,
      0x16, 0x7f, 0xa2, 0xeb, 0x19, 0xca, 0x90, 0xe6, 0x2b, 0xde, 0x2a, 0x8e,
      0xab, 0x7c, 0x29, 0x1b, 0xe6, 0x2a, 0xf4, 0xcb, 0x45, 0x8d, 0xe6, 0xae,
      0x14, 0x3a, 0x4a, 0x0d, 0xc7, 0x16, 0x30, 0x72, 0x8c, 0x08, 0x69, 0xde,
      0x47, 0xb1, 0xd3, 0x1e, 0x24, 0xbc, 0xe2, 0x6f, 0x39, 0x5f, 0x49, 0xa1,
      0xe3, 0x29, 0xb5, 0x23, 0x14, 0x91, 0xe4, 0x02, 0x06, 0xa3, 0x32, 0x32,
      0xd6, 0x7e, 0xb6, 0xa9, 0x44, 0xc4, 0x9b, 0x0c, 0x3c, 0x84, 0x43, 0x9a,
      0xff, 0x43, 0x2f, 0xff, 0x3c, 0x97, 0xc6, 0xe3, 0xef, 0x38, 0x0e, 0x16,
      0x38, 0x32, 0x83, 0x9a, 0x6f, 0xe7, 0xdc, 0xec, 0xc2, 0x66, 0x59, 0x64,
      0x1b, 0x20, 0xe9, 0x1f, 0x84, 0xb0, 0x78, 0xc5, 0xe5, 0xee, 0x5b, 0xa5,
      0x67, 0xc9, 0xbc, 0xcf, 0xde, 0xb4, 0x5f, 0x29, 0x8a, 0x8d, 0xd7, 0x28,
      0x81, 0xa5, 0x87, 0xfc, 0x9e, 0x0c, 0x4f, 0x6d, 0xa8, 0xd4, 0x9d, 0xce,
      0x0f, 0xbe, 0x01, 0xad, 0xec, 0x3c, 0xd8, 0x7d, 0x4e, 0x58, 0x10, 0x9e,
      0xad, 0x90, 0xfd, 0x57, 0x2f, 0x69, 0x8c, 0x7d, 0x49, 0x45, 0xb7, 0x5f,
      0x5e, 0x1f, 0x1d, 0xff, 0x29, 0x6f, 0x68, 0xf5, 0xd5, 0xad, 0x80, 0x68,
      0xfd, 0x59, 0xea, 0xfe, 0xee, 0x4e, 0xe2, 0x9a, 0x2a, 0x9a, 0x9c, 0x06,
      0xa3, 0xc5, 0x01, 0xf0, 0xab, 0x92, 0xfa, 0x99, 0xee, 0x06, 0x34, 0x2a,
      0x8b, 0x17, 0x8b, 0xd0, 0x01, 0x93, 0x53, 0xb2, 0x4f, 0xe1, 0x18, 0xe8,
      0xe1, 0x2e, 0x92, 0xca, 0xba, 0x88, 0xb5, 0x93, 0xdd, 0x6e, 0xe4, 0x61,
      0x9b, 0xe0, 0x13, 0xc3, 0xb5, 0x95, 0x54, 0xc9, 0xa4, 0x71, 0xda, 0x32,
      0x15, 0x5f, 0xd3, 0x99, 0x2c, 0x5a, 0x81, 0xa6, 0xb1, 0xc5, 0x7c, 0xc5,
      0x10, 0x21, 0x6e, 0xf8, 0xde, 0x06, 0x67, 0x9f, 0x08, 0xdd, 0x5c, 0xdb,
      0x24, 0x16, 0x85, 0x46, 0xf9, 0xd6, 0xf1, 0x6f, 0x23, 0x52, 0xcf, 0x18,
      0x3b, 0x50, 0x47, 0x7b, 0x0e, 0x89, 0x37, 0xa1, 0xee, 0xc2, 0x7a, 0x02,
      0x28, 0x22, 0xbe, 0x4b, 0xad, 0x08, 0x6b, 0x97, 0x17, 0xd6, 0xee, 0xff,
      0x40, 0xd7, 0x43, 0xed, 0x6a, 0xe1, 0x4b, 0x56, 0xfb, 0x14, 0x0d, 0x08,
      0x06, 0xf0, 0x4e, 0x55, 0xc6, 0x0f, 0xdc, 0x49, 0x87, 0x16, 0xec, 0x55,
      0x4d, 0x6b, 0x53, 0x16, 0x1f, 0x26, 0x0c, 0xfc, 0xe2, 0xea, 0x3e, 0xbb},
     pub_key_2,
     {0x33, 0x32, 0x32, 0x31, 0x34, 0x34, 0x31, 0x36, 0x32},
     true},

    // Comment:
    // tcID: 50
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     50,
     32,
     {0x47, 0x31, 0x82, 0x1b, 0x07, 0x1f, 0x69, 0xfe, 0x50, 0x79, 0xe2, 0xc6,
      0x55, 0xd9, 0x64, 0x38, 0xd9, 0xb2, 0x05, 0xf2, 0x33, 0x4e, 0x49, 0x57,
      0x31, 0xb0, 0xf4, 0xf4, 0x43, 0xfb, 0xd6, 0x30, 0x25, 0x03, 0x1e, 0xe5,
      0x93, 0x3d, 0x10, 0xcf, 0x02, 0xe6, 0xef, 0xc8, 0x89, 0xc4, 0xed, 0x6f,
      0xe6, 0x09, 0x97, 0x7b, 0x95, 0x04, 0x6e, 0x46, 0x8f, 0x0e, 0x00, 0x60,
      0x54, 0xc5, 0x6a, 0x5b, 0x3b, 0x4b, 0xcf, 0x39, 0xf1, 0x26, 0xef, 0xf5,
      0xcd, 0x75, 0x42, 0xf7, 0xe9, 0xac, 0x18, 0x97, 0xfd, 0x29, 0x5a, 0x00,
      0xb5, 0xf1, 0x03, 0x10, 0x76, 0x13, 0x84, 0xf1, 0x10, 0xcd, 0x92, 0x96,
      0xe1, 0x48, 0x42, 0x75, 0xd4, 0xd6, 0x55, 0x3f, 0x3f, 0x70, 0x5b, 0x62,
      0xf7, 0x06, 0x92, 0x70, 0x01, 0x85, 0xbc, 0x9b, 0xe3, 0xa0, 0xd3, 0x78,
      0x21, 0xe1, 0x53, 0x73, 0x79, 0xd3, 0x1a, 0x1e, 0xd0, 0x6b, 0xda, 0x54,
      0xb0, 0xa4, 0xe4, 0xa8, 0x5c, 0xb2, 0x93, 0xaa, 0x3c, 0xd2, 0xe3, 0xe7,
      0x28, 0xe0, 0x96, 0xb6, 0x3b, 0x00, 0x81, 0xad, 0xa8, 0xef, 0x3d, 0xb8,
      0xd9, 0xeb, 0x06, 0x9d, 0x26, 0x8f, 0xfe, 0x14, 0x29, 0xc9, 0x12, 0x66,
      0xda, 0x75, 0x0e, 0x7a, 0x7d, 0x3c, 0x5e, 0xaf, 0x43, 0x77, 0x27, 0x63,
      0xe4, 0x46, 0x4a, 0x45, 0x92, 0x48, 0xb3, 0x1b, 0x5c, 0x08, 0x32, 0x56,
      0x17, 0xa0, 0xd9, 0x35, 0x0d, 0x22, 0x96, 0xe3, 0xa3, 0x80, 0xd2, 0x04,
      0x8b, 0xe1, 0x29, 0x90, 0x5b, 0x6f, 0x66, 0x87, 0x02, 0x2f, 0x9e, 0x5c,
      0x1a, 0x2b, 0x70, 0xa5, 0x63, 0x4a, 0x26, 0xf3, 0x5b, 0x56, 0x18, 0x50,
      0x4c, 0xa4, 0x15, 0x87, 0xce, 0xb5, 0x4c, 0xc9, 0x9c, 0x9b, 0x11, 0xf4,
      0x15, 0xc7, 0xac, 0x6a, 0xeb, 0x61, 0x58, 0xb9, 0xf1, 0x7e, 0x44, 0xb4,
      0xcc, 0x6a, 0x72, 0xe6, 0xe0, 0x5d, 0xf2, 0x96, 0xfa, 0xf0, 0x6e, 0x70,
      0xde, 0xd3, 0x85, 0x2a, 0x82, 0x55, 0x4b, 0x74, 0x10, 0x11, 0xf8, 0x03,
      0x5b, 0xc1, 0x18, 0x39, 0xb3, 0xfd, 0xff, 0xec, 0x38, 0xee, 0x87, 0xb8,
      0xd2, 0xa1, 0x91, 0x03, 0x5d, 0x73, 0xd4, 0x5a, 0x6e, 0x04, 0xcd, 0x37,
      0xbf, 0xc2, 0xfe, 0x2f, 0x1f, 0x75, 0x9d, 0x64, 0xbd, 0x4b, 0x60, 0xfe,
      0xe5, 0x4e, 0x71, 0xd0, 0xcc, 0x57, 0x16, 0xc6, 0xea, 0x9b, 0x21, 0x18,
      0x89, 0x4b, 0xc4, 0x20, 0x57, 0xef, 0x60, 0x27, 0xe9, 0xe8, 0x2d, 0x43,
      0x61, 0x12, 0xa0, 0xb6, 0xd6, 0xab, 0xf7, 0xb2, 0x81, 0xb1, 0x3d, 0x59,
      0xc7, 0x2d, 0x05, 0x37, 0xc6, 0xf9, 0x41, 0x6e, 0x99, 0x32, 0x82, 0x4b,
      0x6f, 0x6f, 0x03, 0x52, 0x56, 0x4c, 0x44, 0xeb, 0x9f, 0xd7, 0xc9, 0xec,
      0xa9, 0x9f, 0x1f, 0x61, 0xbd, 0xe4, 0xbe, 0x6b, 0x68, 0x90, 0xe6, 0xee},
     pub_key_2,
     {0x31, 0x30, 0x36, 0x38, 0x36, 0x36, 0x35, 0x35, 0x35, 0x34, 0x36},
     true},

    // Comment:
    // tcID: 51
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     51,
     32,
     {0x2a, 0xc1, 0x25, 0xba, 0x10, 0x20, 0xac, 0xe4, 0xa4, 0x69, 0x4a, 0x63,
      0xd7, 0xf6, 0x1b, 0x01, 0x67, 0x43, 0xd8, 0xfe, 0xcc, 0x59, 0x4e, 0xdc,
      0x98, 0xd6, 0xac, 0x28, 0xdf, 0xb8, 0xf4, 0x1d, 0x91, 0x86, 0x44, 0x85,
      0xb3, 0xfa, 0xec, 0x75, 0xa8, 0x9c, 0x1a, 0xb4, 0x3a, 0xb1, 0x01, 0x38,
      0x82, 0x09, 0x73, 0x4f, 0xfb, 0x6d, 0x29, 0x88, 0x6e, 0xa1, 0xb2, 0x81,
      0x4b, 0xd6, 0xed, 0xad, 0x0d, 0x27, 0x8d, 0xa8, 0x62, 0xf2, 0xb1, 0x2e,
      0xc1, 0x8d, 0x60, 0xcf, 0xcf, 0x5a, 0x71, 0x6d, 0x6a, 0x37, 0xe8, 0x98,
      0xa5, 0xb2, 0x92, 0x35, 0xc6, 0xfc, 0x8b, 0xfc, 0xcb, 0x95, 0xa5, 0x62,
      0xf2, 0xf2, 0x0e, 0x5f, 0x7b, 0xf3, 0x1a, 0xbf, 0x28, 0xb8, 0x2b, 0xbe,
      0x5d, 0x31, 0x69, 0x0b, 0x3e, 0xb3, 0xb1, 0xaa, 0x36, 0xa8, 0x9a, 0xf2,
      0x1c, 0xe2, 0x47, 0xf8, 0xe0, 0x79, 0x08, 0x7f, 0xd3, 0x71, 0xf0, 0xe1,
      0x76, 0xf7, 0x2e, 0xf0, 0x46, 0x86, 0xe7, 0x56, 0x59, 0x1e, 0x38, 0xef,
      0x77, 0xcd, 0x73, 0xaf, 0x07, 0x87, 0xb0, 0x1e, 0x02, 0xfd, 0xf1, 0x6c,
      0xc7, 0xeb, 0x94, 0xf6, 0x77, 0x3d, 0xbd, 0x5a, 0x7f, 0x81, 0x88, 0x19,
      0xaa, 0xbe, 0xfe, 0x0c, 0x9b, 0xd4, 0x7d, 0x79, 0x63, 0x3b, 0x84, 0xcc,
      0x9f, 0xcf, 0x7b, 0x33, 0x5e, 0x3e, 0x6c, 0x7b, 0x48, 0xe8, 0xe5, 0xb8,
      0x6e, 0x3e, 0x85, 0xaf, 0x24, 0x9c, 0x36, 0x1c, 0x43, 0xae, 0xf3, 0x6c,
      0x16, 0xf4, 0x01, 0xda, 0x46, 0x3a, 0x23, 0x19, 0x4b, 0x0e, 0x6b, 0x1d,
      0xfc, 0x66, 0x9e, 0xf1, 0xef, 0x4e, 0xb6, 0x26, 0xe8, 0x8c, 0x8e, 0x63,
      0xed, 0xc8, 0x23, 0x54, 0x4e, 0x28, 0xdd, 0x70, 0x10, 0x40, 0x97, 0x6d,
      0x08, 0x2f, 0x38, 0xdf, 0x50, 0xde, 0x1a, 0xe7, 0xbe, 0x4f, 0x23, 0x85,
      0x94, 0xf8, 0xbc, 0xac, 0x3b, 0x51, 0xb2, 0xa7, 0x9c, 0x5b, 0x70, 0x40,
      0x3a, 0x49, 0xa1, 0xb8, 0x6c, 0xe3, 0x2e, 0xbf, 0x3b, 0x70, 0x33, 0x1a,
      0x75, 0xfd, 0x25, 0xa5, 0x48, 0x60, 0x84, 0x27, 0x99, 0xe6, 0xb8, 0x49,
      0xf8, 0x16, 0x48, 0xb5, 0xb2, 0x88, 0x28, 0x3a, 0x6c, 0xca, 0x85, 0x73,
      0xe9, 0x6b, 0xb5, 0xc0, 0x90, 0xf3, 0x23, 0x00, 0x4a, 0x35, 0xc9, 0xb2,
      0x01, 0x62, 0x1c, 0xf1, 0x8e, 0xd1, 0x18, 0x7d, 0xb8, 0xec, 0x02, 0xce,
      0x20, 0x5e, 0xd2, 0xef, 0x0d, 0x9a, 0x8c, 0xc7, 0x2d, 0xec, 0xb8, 0x11,
      0x62, 0x9c, 0xbd, 0x86, 0x4e, 0xde, 0x9f, 0x3d, 0x95, 0xe5, 0x60, 0x9a,
      0x3c, 0xb4, 0x97, 0xf5, 0x81, 0xc5, 0x37, 0x40, 0xbf, 0x93, 0xb6, 0x58,
      0xd6, 0xd6, 0xdf, 0x30, 0x77, 0xc4, 0x85, 0xd5, 0x14, 0x58, 0xb0, 0x58,
      0x03, 0xc4, 0x91, 0x96, 0x16, 0xf4, 0xb0, 0x12, 0xcf, 0xd9, 0x66, 0xb5},
     pub_key_2,
     {0x36, 0x32, 0x31, 0x35, 0x35, 0x32, 0x34, 0x36},
     true},

    // Comment:
    // tcID: 52
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     52,
     32,
     {0xb8, 0x3b, 0x74, 0x42, 0x5a, 0x7d, 0x0b, 0x75, 0x19, 0x20, 0x94, 0xa3,
      0x2f, 0x8d, 0xce, 0x49, 0xf9, 0xc2, 0x80, 0xe4, 0x1d, 0xa0, 0xa8, 0xc3,
      0xc7, 0x55, 0xb7, 0xf1, 0x73, 0x11, 0x09, 0x23, 0xe3, 0x60, 0x52, 0x8b,
      0x2c, 0x7d, 0xc5, 0x24, 0x57, 0xb3, 0xfc, 0xc3, 0x53, 0xaf, 0xba, 0xa0,
      0xc5, 0x46, 0x00, 0x29, 0x55, 0x65, 0x8d, 0x90, 0x4b, 0xd3, 0x58, 0x35,
      0xc6, 0xbc, 0x72, 0xfb, 0xf4, 0x48, 0x40, 0xae, 0x15, 0x58, 0x02, 0xc5,
      0x73, 0x48, 0x9d, 0x6c, 0x7d, 0x51, 0xba, 0x6f, 0x4b, 0x27, 0x16, 0x8c,
      0x05, 0x88, 0x26, 0xff, 0x94, 0xdb, 0x0c, 0x45, 0x64, 0xc1, 0x78, 0xe4,
      0x75, 0xde, 0xde, 0x97, 0x8a, 0x70, 0x8a, 0x94, 0xea, 0x7e, 0xb8, 0xa6,
      0xba, 0x43, 0xe4, 0x7f, 0x8a, 0x72, 0xe0, 0x53, 0x51, 0xb4, 0x2f, 0xed,
      0x7e, 0xea, 0x51, 0xb7, 0xfa, 0x3b, 0x63, 0xe1, 0x46, 0x43, 0x79, 0x7f,
      0x58, 0xb7, 0x71, 0x7e, 0x97, 0x92, 0xf8, 0xf5, 0xa4, 0x33, 0xd6, 0xfb,
      0xce, 0xec, 0x38, 0x99, 0xa5, 0x97, 0xd6, 0x5a, 0x33, 0xfa, 0xfb, 0xad,
      0x96, 0x0b, 0x67, 0xd0, 0x53, 0x9b, 0x82, 0xe8, 0x8f, 0x74, 0x92, 0x92,
      0x32, 0xca, 0x00, 0x7d, 0x93, 0x80, 0x4b, 0x26, 0x9e, 0x55, 0x45, 0x29,
      0xe7, 0x31, 0x03, 0x40, 0xd8, 0xa9, 0xd4, 0xa6, 0x21, 0x65, 0xe2, 0x7c,
      0x3b, 0x5c, 0x21, 0x58, 0x37, 0x44, 0xfa, 0x84, 0x9d, 0xf3, 0xa1, 0x8f,
      0xb3, 0x02, 0x5e, 0x0f, 0x47, 0xbe, 0x2b, 0xbb, 0x41, 0x57, 0x4c, 0x56,
      0x46, 0xf9, 0x16, 0xf3, 0x64, 0xd5, 0x65, 0xb9, 0xfb, 0x04, 0x41, 0x50,
      0xb9, 0xe9, 0x09, 0x5f, 0xee, 0x41, 0x96, 0x20, 0xdd, 0x20, 0x55, 0x4f,
      0xfb, 0x9e, 0xdf, 0xe1, 0xe7, 0x2f, 0x49, 0xcf, 0xa4, 0x83, 0x45, 0x85,
      0xd2, 0x5f, 0x69, 0x31, 0x08, 0x55, 0x72, 0x66, 0x52, 0x9c, 0xa3, 0xa5,
      0x6f, 0x56, 0xf0, 0x5c, 0xfe, 0x44, 0xb5, 0x47, 0xed, 0x35, 0x9a, 0x56,
      0x2b, 0x94, 0x39, 0x1d, 0xc3, 0xe9, 0xaf, 0xe4, 0x41, 0x48, 0x39, 0x52,
      0x2a, 0x6d, 0x34, 0xa9, 0x07, 0xa9, 0xb3, 0xbb, 0xfc, 0x61, 0xf1, 0x08,
      0x15, 0xf2, 0x75, 0xa6, 0x23, 0x43, 0xd8, 0x69, 0xe6, 0x31, 0xfa, 0x77,
      0x6c, 0xfb, 0x08, 0xc9, 0xeb, 0x6f, 0x76, 0xfb, 0x24, 0x9c, 0x63, 0x93,
      0x61, 0xe4, 0x0b, 0x02, 0x54, 0x39, 0xe4, 0x71, 0x15, 0x53, 0x83, 0x5b,
      0x26, 0xb2, 0x24, 0x23, 0xde, 0x4a, 0x64, 0x06, 0x7f, 0x6d, 0xf2, 0x8c,
      0x93, 0x68, 0xc4, 0x6d, 0x93, 0x39, 0x14, 0xef, 0x65, 0x9d, 0x58, 0x4b,
      0x70, 0x3b, 0xeb, 0x86, 0x75, 0xd6, 0xe4, 0xbe, 0x7e, 0x2e, 0xd5, 0x0e,
      0xe6, 0xc3, 0x01, 0x2d, 0x0b, 0xd3, 0x8e, 0xfd, 0x07, 0x84, 0xf6, 0xc5},
     pub_key_2,
     {0x37, 0x30, 0x33, 0x30, 0x38, 0x31, 0x38, 0x37, 0x37, 0x34},
     true},

    // Comment:
    // tcID: 53
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     53,
     32,
     {0x2a, 0xd2, 0x43, 0xfb, 0xa3, 0x59, 0xfd, 0x75, 0x82, 0xb7, 0x75, 0xef,
      0x93, 0xb1, 0xb3, 0x3a, 0x1b, 0x7d, 0xdb, 0xaa, 0x13, 0xa6, 0x7c, 0xb1,
      0x02, 0x08, 0xa1, 0x32, 0x45, 0x26, 0xad, 0x5a, 0xa7, 0xb7, 0x2c, 0x98,
      0x98, 0x0a, 0x29, 0xc0, 0x16, 0x11, 0xc0, 0x0b, 0xa9, 0x6d, 0xb2, 0x03,
      0xa3, 0x6a, 0x7a, 0x15, 0xd4, 0xca, 0x00, 0xf3, 0x0d, 0x3a, 0x76, 0x0d,
      0xcd, 0x9e, 0x59, 0x6e, 0x2c, 0xcf, 0x99, 0x2c, 0x11, 0xa0, 0x61, 0x93,
      0x5e, 0x69, 0x90, 0x03, 0x8e, 0x28, 0x15, 0x18, 0x12, 0x00, 0xd9, 0xf1,
      0xc2, 0x2a, 0xfc, 0xc9, 0x89, 0xbe, 0x0b, 0x94, 0x51, 0x93, 0x6d, 0xdf,
      0x1f, 0x72, 0x6c, 0xa3, 0x7b, 0x00, 0xdf, 0xd6, 0x7f, 0xbb, 0x05, 0x4e,
      0x8c, 0xfa, 0x8f, 0xa3, 0xca, 0x3f, 0xec, 0xcd, 0xc0, 0x33, 0xf2, 0x6d,
      0x45, 0x79, 0xe8, 0xbf, 0x4a, 0x7c, 0x2e, 0x8e, 0x4b, 0xd4, 0x2c, 0x32,
      0xa0, 0x15, 0xe3, 0xc9, 0x1d, 0x03, 0x2e, 0x46, 0x71, 0x7e, 0xc9, 0xeb,
      0x1d, 0xf8, 0x17, 0xba, 0x54, 0x93, 0x6a, 0xea, 0x3e, 0x42, 0x64, 0x56,
      0x15, 0x62, 0x69, 0x91, 0xbf, 0xe6, 0x0e, 0x86, 0xe9, 0x26, 0x2a, 0x61,
      0xf9, 0x56, 0xe1, 0x05, 0x00, 0x69, 0x12, 0x33, 0xc0, 0xed, 0x4e, 0x53,
      0x4d, 0x05, 0x49, 0x2d, 0x73, 0x72, 0x0d, 0x33, 0xc0, 0xe6, 0x62, 0x2c,
      0x7c, 0x94, 0x60, 0x74, 0xb8, 0x59, 0xfe, 0x09, 0x57, 0x09, 0x1a, 0x8a,
      0x00, 0xef, 0x55, 0xb8, 0x72, 0x13, 0x5f, 0xf4, 0x32, 0xe2, 0x55, 0xd8,
      0xe6, 0xef, 0xe1, 0xa1, 0xeb, 0x3f, 0xcc, 0xba, 0x43, 0x77, 0x39, 0xaf,
      0x0b, 0x53, 0x0b, 0x7c, 0xac, 0x72, 0x3b, 0x3e, 0x61, 0x18, 0x5c, 0xf0,
      0x6a, 0x68, 0x18, 0x72, 0x5c, 0x88, 0x33, 0x4d, 0x2a, 0xef, 0x25, 0xdf,
      0x07, 0xcc, 0xf4, 0xfb, 0x01, 0x8a, 0xa2, 0xdd, 0x13, 0xd6, 0xbe, 0x2a,
      0x7a, 0xd8, 0x81, 0x4f, 0x53, 0x83, 0x4a, 0x72, 0xaa, 0xcf, 0x68, 0xff,
      0x81, 0x94, 0x89, 0xb2, 0xe5, 0xed, 0xdb, 0x0c, 0x9b, 0xf4, 0xcf, 0x35,
      0x0e, 0xba, 0x63, 0xf8, 0x3e, 0xcb, 0x02, 0x71, 0x36, 0x35, 0xa2, 0x05,
      0xef, 0xf1, 0xe9, 0x7d, 0xac, 0x41, 0x47, 0x76, 0x37, 0xff, 0x8f, 0x25,
      0xf0, 0xe4, 0x51, 0xd0, 0xbb, 0x23, 0xa3, 0x61, 0x5e, 0x0d, 0x13, 0x8a,
      0xb6, 0x32, 0xae, 0xa6, 0x0a, 0x05, 0xae, 0x6f, 0xd1, 0xb9, 0x77, 0x53,
      0xeb, 0xf8, 0x77, 0xcc, 0xf1, 0x98, 0x30, 0x64, 0xa3, 0x71, 0x0b, 0x3c,
      0x12, 0x28, 0x9d, 0x1b, 0x33, 0x50, 0xb3, 0x82, 0xe8, 0xf3, 0x7e, 0xff,
      0xcd, 0x53, 0x2f, 0xa1, 0x34, 0x34, 0xbf, 0xa9, 0xaf, 0x1b, 0xee, 0x8e,
      0xef, 0x60, 0xbc, 0x2a, 0xc6, 0x3d, 0x8c, 0x14, 0x02, 0xdc, 0x65, 0x51},
     pub_key_2,
     {0x35, 0x39, 0x32, 0x34, 0x35, 0x32, 0x33, 0x37, 0x34, 0x34},
     true},

    // Comment:
    // tcID: 54
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     54,
     32,
     {0x09, 0x35, 0xbd, 0x01, 0x91, 0xfa, 0x4d, 0xbe, 0xb1, 0xda, 0x86, 0xc8,
      0x36, 0xf2, 0x00, 0x99, 0x0d, 0x4a, 0x22, 0x05, 0xd2, 0x36, 0xce, 0xbb,
      0x0c, 0x74, 0x87, 0xb7, 0x54, 0xb8, 0xef, 0x20, 0x6e, 0x7f, 0x70, 0x72,
      0xdb, 0x5f, 0x1e, 0x31, 0x21, 0xe3, 0x60, 0x0c, 0xe4, 0x25, 0x97, 0xa9,
      0x61, 0x86, 0xdb, 0x67, 0x21, 0x11, 0xf0, 0xba, 0x87, 0x28, 0xea, 0xa9,
      0x6e, 0x36, 0x1b, 0x7a, 0xc5, 0xfe, 0x43, 0x01, 0x3f, 0x58, 0xca, 0x17,
      0xd1, 0x06, 0x33, 0xf0, 0xf1, 0xfb, 0x3f, 0x16, 0x4e, 0x15, 0x1e, 0x10,
      0x77, 0x5c, 0x70, 0x4d, 0x5c, 0xc5, 0x37, 0xf7, 0x1a, 0xc8, 0xa6, 0x1d,
      0xde, 0xf7, 0xd5, 0x89, 0xce, 0xdf, 0xf8, 0x95, 0x4d, 0x1a, 0x48, 0x39,
      0x37, 0x04, 0x4d, 0x14, 0x74, 0x13, 0x9a, 0xfa, 0x0c, 0xc7, 0x3f, 0xbd,
      0xad, 0x9e, 0x12, 0xfc, 0x12, 0x97, 0x6f, 0x55, 0xec, 0x81, 0x77, 0x7f,
      0x42, 0x8e, 0x0d, 0xc1, 0x86, 0xe3, 0xf3, 0xbf, 0x93, 0xb3, 0x58, 0xbf,
      0x9e, 0x16, 0x27, 0xfd, 0xfe, 0x51, 0x87, 0x6d, 0x5f, 0x34, 0x95, 0x9e,
      0xdc, 0x40, 0xef, 0xf1, 0x0b, 0xa7, 0x1c, 0x56, 0xae, 0x8e, 0xc8, 0xf0,
      0x7f, 0xca, 0x2e, 0x1f, 0xc5, 0x26, 0x3c, 0x2c, 0x22, 0xf1, 0xc8, 0x13,
      0x84, 0x99, 0xf8, 0x24, 0x92, 0x0a, 0x9a, 0x83, 0x96, 0xb3, 0x1a, 0xe4,
      0x17, 0xc2, 0x5a, 0x8f, 0x92, 0x8f, 0xaa, 0x66, 0x5a, 0x9c, 0xb6, 0xb5,
      0x47, 0x52, 0xf9, 0x8f, 0x17, 0x27, 0x90, 0x98, 0xa5, 0x4b, 0x68, 0xc5,
      0x8f, 0xc5, 0x87, 0x99, 0x98, 0xe7, 0xf6, 0x51, 0x30, 0xed, 0x96, 0x15,
      0x5e, 0xc6, 0xae, 0x0d, 0x92, 0xb3, 0x5b, 0xad, 0xff, 0xd0, 0x5b, 0x19,
      0x58, 0x0b, 0xe8, 0x38, 0x6b, 0x7e, 0x8d, 0x2f, 0xdf, 0xe3, 0x38, 0xf9,
      0x71, 0x78, 0x01, 0x08, 0xf8, 0x86, 0xa3, 0x09, 0x19, 0x6b, 0x65, 0x42,
      0xdc, 0x40, 0x38, 0xa1, 0xba, 0x45, 0x6f, 0xac, 0x18, 0xe1, 0x6c, 0x99,
      0x75, 0xc9, 0xc6, 0x0c, 0x47, 0xfa, 0x14, 0xab, 0x95, 0x3a, 0xf3, 0x72,
      0xeb, 0xe4, 0x67, 0x8d, 0xae, 0x70, 0x08, 0x4e, 0xaf, 0xc4, 0x32, 0x45,
      0xcf, 0x51, 0x31, 0x42, 0xea, 0xbd, 0xf1, 0x03, 0x19, 0xf4, 0x33, 0xd7,
      0x53, 0x1f, 0x0d, 0x8b, 0x84, 0xb1, 0xb6, 0xdc, 0xaf, 0x86, 0x45, 0x64,
      0x4f, 0x0d, 0x52, 0xda, 0x66, 0x18, 0x23, 0xb3, 0xde, 0x25, 0x9c, 0xe2,
      0x87, 0x8e, 0xb2, 0x0b, 0x5c, 0x2f, 0x76, 0xc3, 0x48, 0xd9, 0xc0, 0x6a,
      0x2f, 0xea, 0xa2, 0x16, 0xef, 0xfd, 0x2e, 0x45, 0x45, 0x30, 0xa0, 0x37,
      0xd8, 0xa4, 0x3c, 0xd9, 0x64, 0x1b, 0x55, 0xbf, 0x6e, 0x2d, 0x30, 0x77,
      0x7f, 0x29, 0x13, 0x99, 0x41, 0xd8, 0x1c, 0xba, 0x66, 0x64, 0x30, 0x6a},
     pub_key_2,
     {0x31, 0x34, 0x39, 0x35, 0x35, 0x38, 0x36, 0x36, 0x32, 0x31},
     true},

    // Comment:
    // tcID: 55
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     55,
     32,
     {0x81, 0x22, 0x58, 0x7a, 0xc5, 0x47, 0xb1, 0x7e, 0xeb, 0x67, 0x04, 0x34,
      0xc9, 0xa4, 0x71, 0xb2, 0x7c, 0xcf, 0x84, 0x20, 0x7b, 0x20, 0x18, 0x77,
      0x63, 0xdc, 0x7e, 0xb1, 0x9c, 0xbd, 0xa4, 0xf5, 0xab, 0x19, 0x79, 0x72,
      0xee, 0x7d, 0x69, 0x30, 0xbd, 0x39, 0x9e, 0x09, 0xe0, 0xcc, 0xa2, 0x7d,
      0x0d, 0x5c, 0xc8, 0x32, 0x22, 0xd6, 0xab, 0x2a, 0x7c, 0x0e, 0x34, 0xec,
      0x7d, 0x4b, 0x95, 0xfd, 0x84, 0xb1, 0xf5, 0x7a, 0x53, 0x44, 0x72, 0x8e,
      0x96, 0xed, 0x08, 0x45, 0x3e, 0xd3, 0x1b, 0xa9, 0xc2, 0xfa, 0xc3, 0xed,
      0xb7, 0x3f, 0xf9, 0xe9, 0x37, 0xc1, 0xb1, 0xba, 0x1a, 0x7d, 0xd0, 0xc9,
      0x27, 0x20, 0x33, 0x33, 0xf7, 0xcb, 0x18, 0xc5, 0x43, 0xd4, 0x3b, 0xfa,
      0x4c, 0x90, 0x5a, 0xbb, 0xb2, 0xd1, 0x38, 0x5a, 0x76, 0x4e, 0xf1, 0x02,
      0x3b, 0x3b, 0x82, 0x24, 0x03, 0xb8, 0x86, 0xb4, 0x5c, 0x2b, 0x0c, 0xa2,
      0x3a, 0xd5, 0xc5, 0x00, 0x09, 0xda, 0xf3, 0x66, 0xc1, 0x5b, 0x4a, 0x5b,
      0xed, 0x78, 0xa3, 0xbd, 0xdc, 0xd0, 0xc5, 0xab, 0xde, 0x07, 0x44, 0xa9,
      0xfd, 0xfc, 0xde, 0x2d, 0xfb, 0xaa, 0x9c, 0x35, 0xd7, 0x5f, 0x15, 0xf4,
      0xb5, 0x52, 0xd6, 0xe1, 0xfd, 0x46, 0x14, 0x48, 0x1a, 0xb0, 0xa8, 0xb6,
      0x09, 0xfb, 0xa2, 0xce, 0xb2, 0x07, 0xe3, 0x22, 0x41, 0xa7, 0xa3, 0xca,
      0x8d, 0xe0, 0x2d, 0x36, 0xae, 0xa4, 0xd0, 0x81, 0x51, 0x45, 0x32, 0xe9,
      0x63, 0x45, 0x41, 0x2f, 0xe7, 0x8e, 0xd4, 0x5a, 0x50, 0x07, 0xdc, 0xe6,
      0x7f, 0xa1, 0xa8, 0x8c, 0x29, 0xcd, 0x4c, 0x54, 0x2b, 0x9d, 0x3a, 0xd4,
      0x4f, 0x84, 0xd2, 0x1c, 0x0b, 0xc3, 0x08, 0x1c, 0x54, 0xf7, 0xb9, 0x49,
      0x9e, 0x4c, 0x28, 0xe6, 0x48, 0xf1, 0xdb, 0x97, 0x32, 0xb7, 0x74, 0x01,
      0x00, 0x18, 0x6b, 0x1f, 0x7f, 0xb1, 0x11, 0xb5, 0xc1, 0x79, 0xcb, 0x6e,
      0x61, 0x0d, 0xca, 0x78, 0x10, 0x54, 0x7b, 0x18, 0x1e, 0xaf, 0x41, 0x88,
      0x34, 0x85, 0x36, 0x06, 0x94, 0x66, 0xc1, 0x29, 0x80, 0xa9, 0x2c, 0xb9,
      0xf7, 0x47, 0x11, 0x68, 0xf0, 0xa0, 0xc4, 0x7e, 0x74, 0xd5, 0x2f, 0xea,
      0x5a, 0x22, 0xf7, 0x0c, 0xb4, 0x8d, 0xe3, 0x81, 0xe0, 0x41, 0x9a, 0x62,
      0x53, 0x39, 0xca, 0xc9, 0x9f, 0x44, 0x01, 0x39, 0x9e, 0x28, 0xa1, 0xf1,
      0x0a, 0x2e, 0x02, 0x03, 0x5e, 0x47, 0x3c, 0x0d, 0x03, 0x17, 0x85, 0x9f,
      0x10, 0x10, 0xcd, 0x25, 0x4a, 0x99, 0xae, 0xb5, 0xa5, 0xd1, 0xb2, 0x4c,
      0x9a, 0xf1, 0xda, 0x9c, 0xd5, 0x07, 0x62, 0x08, 0x08, 0x97, 0x62, 0xae,
      0xf4, 0x52, 0xc3, 0x98, 0x12, 0x59, 0xd5, 0x19, 0x6a, 0xe7, 0xca, 0xca,
      0xed, 0x7f, 0xf8, 0x7c, 0xdc, 0x69, 0xa8, 0x90, 0xa1, 0xb1, 0x61, 0x4e},
     pub_key_2,
     {0x34, 0x30, 0x30, 0x35, 0x33, 0x31, 0x34, 0x34, 0x30, 0x36},
     true},

    // Comment:
    // tcID: 56
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     56,
     32,
     {0x72, 0x66, 0xf3, 0x39, 0x0c, 0x4e, 0x83, 0x54, 0x4d, 0xe1, 0x22, 0xf2,
      0x4f, 0x5c, 0x5d, 0xf6, 0xe8, 0xe5, 0xd0, 0x8d, 0x2c, 0xaa, 0x08, 0xcd,
      0xab, 0x67, 0x2d, 0xc1, 0xd4, 0x3d, 0xd0, 0x51, 0x08, 0x55, 0xb1, 0x5b,
      0x1c, 0xbb, 0x90, 0xdc, 0x31, 0x8d, 0xfd, 0x19, 0x7e, 0x45, 0xb1, 0x26,
      0x26, 0x11, 0xeb, 0xe2, 0x20, 0x4a, 0x75, 0x77, 0xde, 0xb5, 0xfb, 0xe9,
      0x3d, 0x36, 0xb5, 0x87, 0xdc, 0xf7, 0x9f, 0x99, 0x57, 0xb0, 0x2d, 0xaa,
      0x33, 0xe2, 0x7b, 0x19, 0xb6, 0x23, 0xf5, 0x5f, 0xeb, 0x79, 0xfc, 0x5a,
      0xeb, 0xb2, 0x1a, 0x55, 0xd6, 0x1a, 0x2e, 0x39, 0x7e, 0x52, 0x8b, 0x5f,
      0x68, 0xbd, 0xce, 0x0e, 0x87, 0x49, 0xf5, 0x5f, 0x08, 0xdc, 0x41, 0x15,
      0x35, 0x4e, 0x5e, 0xb1, 0x1a, 0xdd, 0x44, 0xd9, 0xe3, 0xdc, 0x4e, 0x43,
      0xb8, 0x9a, 0x0d, 0xfa, 0x8e, 0x0c, 0xa0, 0xa8, 0x3a, 0xee, 0xe2, 0x98,
      0xc7, 0xba, 0xa0, 0xfd, 0x0a, 0x5f, 0x8a, 0xfa, 0x48, 0x80, 0xc6, 0xfc,
      0x16, 0xc1, 0xf5, 0x43, 0x45, 0x1d, 0xfd, 0xac, 0xfa, 0xea, 0x6e, 0x75,
      0x87, 0x37, 0x07, 0x93, 0xb6, 0xda, 0x0d, 0x6e, 0x96, 0x42, 0x15, 0x6a,
      0xd4, 0xce, 0x85, 0xff, 0x9e, 0x8f, 0xcb, 0x3e, 0x78, 0x6b, 0x3f, 0x86,
      0x3a, 0x77, 0xb9, 0xe2, 0xe3, 0xfd, 0xa7, 0xe9, 0x10, 0x6a, 0x96, 0x00,
      0x35, 0x88, 0xac, 0x08, 0x54, 0x09, 0x4d, 0x4e, 0x2a, 0x61, 0x35, 0x34,
      0x25, 0x50, 0xc0, 0xcb, 0x13, 0x4b, 0x1e, 0x84, 0x38, 0xad, 0x95, 0xb8,
      0x0b, 0xae, 0x70, 0x2b, 0xd6, 0x2d, 0x7d, 0x07, 0x30, 0x80, 0x92, 0x38,
      0x16, 0x50, 0xf0, 0x0e, 0x71, 0x2c, 0x96, 0xea, 0x1e, 0x44, 0xee, 0xcf,
      0xc2, 0x7f, 0x9f, 0x0e, 0x79, 0xd0, 0x38, 0xe9, 0x05, 0xdb, 0xf4, 0xc2,
      0x1a, 0x5a, 0x53, 0x6f, 0xc7, 0xdc, 0x8a, 0xe5, 0xbf, 0x21, 0x9b, 0x71,
      0x56, 0xf7, 0xab, 0x68, 0x5d, 0x95, 0x98, 0xfd, 0x16, 0x5f, 0x97, 0x94,
      0xb2, 0xc6, 0xd6, 0x6e, 0xcc, 0xe2, 0xa5, 0x45, 0x13, 0x45, 0xf5, 0xb0,
      0x5d, 0xbe, 0xa4, 0xb0, 0x08, 0x7f, 0x38, 0x44, 0x48, 0x95, 0x5c, 0x53,
      0x07, 0x31, 0xe7, 0x9c, 0xb9, 0x87, 0xc1, 0xdc, 0x19, 0xe6, 0xef, 0x0f,
      0x64, 0xb7, 0x28, 0xeb, 0xec, 0xcc, 0x8c, 0x77, 0xb8, 0x17, 0xd7, 0xa8,
      0xd2, 0x90, 0x96, 0x01, 0xed, 0x4f, 0xb1, 0xfc, 0x60, 0x42, 0x84, 0x0c,
      0x56, 0x75, 0x8f, 0x11, 0xc9, 0x91, 0xbe, 0x89, 0x98, 0x8b, 0xd4, 0xf0,
      0x73, 0x92, 0x51, 0x0d, 0x80, 0x4e, 0xb5, 0xcc, 0xa1, 0xe3, 0x8c, 0xa4,
      0x04, 0x82, 0x14, 0x0e, 0x85, 0x34, 0xd9, 0x7c, 0x26, 0x24, 0x0b, 0x29,
      0x11, 0x96, 0xef, 0xb3, 0x6e, 0x37, 0x03, 0x5a, 0xcf, 0x6b, 0x7b, 0x3b},
     pub_key_2,
     {0x33, 0x30, 0x39, 0x36, 0x34, 0x35, 0x37, 0x35, 0x31, 0x32},
     true},

    // Comment:
    // tcID: 57
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     57,
     32,
     {0x63, 0xe5, 0x41, 0x27, 0xba, 0x82, 0x52, 0x24, 0x3a, 0xaf, 0x8d, 0x07,
      0xea, 0xf7, 0x6a, 0x53, 0xb5, 0x2b, 0x89, 0x70, 0x07, 0x20, 0x98, 0xdb,
      0x52, 0x95, 0xcd, 0xa1, 0x73, 0x16, 0x4f, 0x6f, 0xbe, 0x81, 0x14, 0xb3,
      0xd8, 0x0f, 0xf9, 0xba, 0xb4, 0xee, 0x9f, 0x9b, 0xc9, 0x1d, 0xda, 0xa5,
      0x72, 0xaa, 0x3c, 0x5b, 0x18, 0x6f, 0xbb, 0xf5, 0xb0, 0xb4, 0xc5, 0xef,
      0xd0, 0x39, 0x61, 0x95, 0xf9, 0xb6, 0xd1, 0x4a, 0x84, 0x00, 0x16, 0xbb,
      0x24, 0xd0, 0xea, 0xb6, 0xdf, 0xa4, 0x87, 0x84, 0xf5, 0x49, 0x05, 0x57,
      0x80, 0xf2, 0x64, 0x56, 0x73, 0xb6, 0x0c, 0x35, 0x9a, 0x2a, 0x2c, 0x9a,
      0xdf, 0xca, 0x78, 0x38, 0x33, 0x66, 0xa4, 0x09, 0x09, 0xb8, 0xfc, 0x33,
      0x49, 0xf7, 0xe4, 0x25, 0xbb, 0xfc, 0x78, 0x59, 0x83, 0x69, 0x95, 0x59,
      0x45, 0x59, 0x1d, 0xc4, 0xc3, 0x32, 0xfa, 0x81, 0x87, 0xce, 0xba, 0x20,
      0xc2, 0x5c, 0xc1, 0xba, 0xed, 0xdd, 0xcf, 0xc0, 0x3d, 0x31, 0xcf, 0xf2,
      0xac, 0x92, 0xe5, 0xaa, 0x72, 0x27, 0xcd, 0x5e, 0xe1, 0x76, 0x69, 0xfb,
      0xe6, 0x84, 0x3b, 0x75, 0x00, 0x58, 0x69, 0x5b, 0xdb, 0x32, 0xd1, 0x5f,
      0x1c, 0x2c, 0x65, 0x41, 0x31, 0x8a, 0x6a, 0x73, 0xbb, 0x8b, 0xa2, 0xc1,
      0xd0, 0x45, 0x9c, 0x8b, 0x0d, 0xf0, 0x49, 0x52, 0xe6, 0xe2, 0x59, 0x28,
      0x51, 0xf2, 0x62, 0x90, 0x10, 0x1f, 0x30, 0xaf, 0xab, 0x2e, 0x31, 0x0d,
      0x14, 0x17, 0x95, 0x5b, 0x9f, 0x74, 0x2c, 0xc8, 0x99, 0x9a, 0x14, 0x19,
      0xa0, 0x53, 0x06, 0x1e, 0xbe, 0xcf, 0x89, 0x64, 0x00, 0x55, 0x5b, 0x99,
      0x93, 0x2c, 0x89, 0x2f, 0x74, 0x27, 0xb5, 0x36, 0xd4, 0xec, 0x2e, 0x12,
      0xdd, 0x15, 0x87, 0x66, 0xc9, 0xa8, 0x94, 0xb9, 0x4a, 0x07, 0x67, 0x74,
      0x5a, 0xbc, 0xdf, 0x3c, 0xdf, 0x31, 0xd3, 0x43, 0x91, 0xe2, 0xb6, 0xd7,
      0x93, 0x46, 0x01, 0x74, 0x1a, 0xf8, 0x81, 0xbc, 0x22, 0x41, 0xbe, 0xbb,
      0xb0, 0xbb, 0x0e, 0x7e, 0xa1, 0xfe, 0x31, 0x7c, 0x6a, 0x49, 0xbe, 0xd7,
      0x6f, 0xbb, 0xd5, 0xb1, 0x13, 0x72, 0xa7, 0x20, 0x2c, 0x84, 0xde, 0x24,
      0xd9, 0x21, 0x80, 0x20, 0x9a, 0x8a, 0xcf, 0x98, 0x63, 0xfe, 0x8c, 0x5c,
      0x32, 0xc6, 0xbf, 0x9c, 0x2e, 0x18, 0xcc, 0x04, 0xc0, 0x78, 0xb0, 0xb1,
      0x52, 0x1b, 0x99, 0x92, 0x75, 0x7f, 0x8c, 0x1e, 0xf9, 0x05, 0x1d, 0x25,
      0xda, 0x1e, 0x99, 0xaa, 0x88, 0x4e, 0xe7, 0x97, 0xa5, 0x07, 0x79, 0x90,
      0xdd, 0x93, 0x7c, 0xe3, 0xda, 0x61, 0x83, 0xdc, 0xe3, 0x45, 0xcb, 0x6c,
      0xad, 0x05, 0x11, 0xa0, 0xb5, 0xb5, 0xe4, 0x43, 0xd6, 0x14, 0x63, 0x7a,
      0x65, 0xc7, 0xe6, 0xb4, 0x6a, 0xd3, 0x1f, 0xac, 0x8d, 0xcf, 0xcb, 0x0c},
     pub_key_2,
     {0x32, 0x37, 0x38, 0x34, 0x30, 0x32, 0x35, 0x36, 0x32, 0x30},
     true},

    // Comment:
    // tcID: 58
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     58,
     32,
     {0xa9, 0xf6, 0xdb, 0xcb, 0x6e, 0x1b, 0x58, 0xbe, 0xd2, 0x75, 0x76, 0xc8,
      0x9f, 0xd8, 0xc1, 0xb6, 0x67, 0x94, 0x52, 0x5e, 0x9a, 0xec, 0x25, 0x11,
      0xf1, 0x51, 0xcf, 0x78, 0xc5, 0x91, 0x5b, 0x38, 0x73, 0x9a, 0xa8, 0x30,
      0x0d, 0x6e, 0x9d, 0xba, 0x0d, 0x01, 0x63, 0x10, 0xb6, 0xf3, 0x5b, 0xe6,
      0x2a, 0x44, 0xae, 0xdd, 0x88, 0x23, 0xd7, 0x71, 0xdd, 0xcd, 0xfe, 0xc3,
      0xb8, 0xbc, 0x4d, 0x9f, 0x63, 0xc0, 0xba, 0xd9, 0x75, 0x44, 0x1b, 0x33,
      0x41, 0xfa, 0xa7, 0xa6, 0xc8, 0x8b, 0x39, 0xa9, 0x14, 0x8d, 0xdf, 0xf3,
      0xee, 0xc7, 0x1c, 0x2f, 0x51, 0x1c, 0x42, 0x28, 0x8e, 0xe5, 0xe4, 0x25,
      0xf7, 0x79, 0xcd, 0xcd, 0xac, 0xfe, 0x47, 0x74, 0x8c, 0xbf, 0xe0, 0x43,
      0xf8, 0x89, 0xb0, 0xce, 0x03, 0xec, 0x56, 0x06, 0x2a, 0xba, 0xdb, 0x2f,
      0x69, 0x2d, 0xcc, 0xf9, 0xbb, 0xa3, 0xb3, 0x69, 0xbc, 0xca, 0x67, 0x8d,
      0xf7, 0x2e, 0xb5, 0xee, 0xd4, 0xeb, 0x83, 0x0a, 0x7d, 0x61, 0xc0, 0x04,
      0x11, 0x35, 0xcd, 0xb0, 0x96, 0x57, 0x8b, 0xbc, 0xb1, 0xb8, 0x42, 0xd4,
      0x30, 0x9b, 0xe9, 0x95, 0xf6, 0x94, 0x78, 0x43, 0xb4, 0xf1, 0xc7, 0x91,
      0x90, 0x00, 0xd6, 0x96, 0xbb, 0xcd, 0xb5, 0x16, 0x68, 0x8f, 0x69, 0xc0,
      0x97, 0x22, 0x40, 0x4a, 0x67, 0x66, 0xf2, 0x21, 0x70, 0xf0, 0xf0, 0x7b,
      0x95, 0x8f, 0x91, 0x59, 0xfd, 0x2b, 0x8b, 0xcd, 0xa1, 0x15, 0xe7, 0xb7,
      0x94, 0x09, 0xe3, 0xfc, 0xac, 0xa7, 0x1a, 0xf9, 0xb7, 0x5e, 0x05, 0xcd,
      0xf6, 0x2c, 0x8b, 0x9b, 0x90, 0x42, 0x83, 0x13, 0x4b, 0xe5, 0x6b, 0x58,
      0xc5, 0x4c, 0x30, 0x7c, 0xf0, 0xe5, 0x90, 0xe6, 0x9f, 0x5f, 0x18, 0x03,
      0x29, 0x37, 0x5e, 0xea, 0x2c, 0x2b, 0x04, 0x56, 0x7c, 0x6a, 0xc9, 0x9d,
      0xf6, 0x56, 0x0f, 0xb0, 0xfc, 0x5d, 0x93, 0x30, 0x4e, 0x96, 0x40, 0xcf,
      0xd8, 0xee, 0xe0, 0xb2, 0xd5, 0xa5, 0xbb, 0x05, 0xd2, 0xac, 0x7b, 0x1d,
      0xf1, 0xb0, 0xe4, 0xc6, 0x4a, 0x27, 0x8a, 0x0c, 0x6c, 0x69, 0x4c, 0xc1,
      0xb3, 0x55, 0x53, 0x96, 0xa6, 0xba, 0xd3, 0x32, 0x61, 0xc8, 0x20, 0xb2,
      0x42, 0xa3, 0xa6, 0x40, 0xaa, 0x7d, 0x17, 0xf2, 0x71, 0x0e, 0xe1, 0x27,
      0xee, 0xf8, 0x04, 0x69, 0x9d, 0x7b, 0x1d, 0xf6, 0xa3, 0x17, 0x42, 0xe9,
      0xd5, 0x8c, 0xad, 0xfe, 0x42, 0xae, 0x7e, 0x1b, 0x9f, 0x93, 0xbb, 0x83,
      0xbc, 0xe3, 0x87, 0xb5, 0x6d, 0x7e, 0x92, 0xcd, 0xbb, 0xd7, 0xda, 0x8d,
      0xa5, 0x83, 0x34, 0x25, 0x7e, 0xd8, 0x37, 0xd1, 0x15, 0xeb, 0x95, 0xfc,
      0xd1, 0x97, 0xcf, 0xa9, 0xda, 0xee, 0xaf, 0x91, 0x41, 0xdd, 0xa6, 0x89,
      0xc0, 0x11, 0x34, 0x44, 0x89, 0xa9, 0x5c, 0xca, 0xbb, 0x01, 0x4e, 0xce},
     pub_key_2,
     {0x32, 0x36, 0x31, 0x38, 0x37, 0x38, 0x37, 0x34, 0x31, 0x38},
     true},

    // Comment:
    // tcID: 59
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     59,
     32,
     {0x5a, 0x16, 0xc6, 0xeb, 0x90, 0xbd, 0x39, 0xe9, 0x32, 0x22, 0x4b, 0xa1,
      0xab, 0x24, 0xe3, 0x28, 0x3d, 0x8d, 0x0b, 0xa5, 0x5e, 0xd6, 0xb2, 0x4b,
      0x99, 0x3b, 0xf0, 0x85, 0xeb, 0xb1, 0xa2, 0x8c, 0xcb, 0xab, 0x38, 0x5b,
      0x1e, 0x1b, 0x64, 0x4a, 0x89, 0x18, 0x94, 0x32, 0x0d, 0xd0, 0x67, 0xe2,
      0xe8, 0x38, 0x58, 0x02, 0x43, 0xda, 0xdb, 0x38, 0x3c, 0xa7, 0x96, 0xec,
      0xf1, 0x24, 0x2a, 0xd1, 0xa9, 0xcf, 0xda, 0xef, 0x6e, 0x22, 0x6b, 0xf3,
      0x03, 0xd9, 0x48, 0x2d, 0xc2, 0xaf, 0x1b, 0x3e, 0x5d, 0x8c, 0xbc, 0xc4,
      0x0a, 0xeb, 0x52, 0xde, 0xb6, 0x0c, 0x0b, 0x09, 0x2d, 0x0b, 0xee, 0xa7,
      0x90, 0x4c, 0x3f, 0xa0, 0xc3, 0xb4, 0x0e, 0x48, 0x7d, 0x6d, 0x3e, 0xd8,
      0x0f, 0x10, 0xe1, 0xaa, 0x6a, 0x17, 0x72, 0x8f, 0xf9, 0xc3, 0xbb, 0xc5,
      0x51, 0x82, 0x96, 0x49, 0x9d, 0x30, 0x58, 0x31, 0x89, 0x87, 0x78, 0x51,
      0xa9, 0x1f, 0xf6, 0xb4, 0xcc, 0x7e, 0xc2, 0xe7, 0xb3, 0x39, 0x98, 0x96,
      0x13, 0x43, 0x70, 0x04, 0xab, 0x69, 0x99, 0xdb, 0x14, 0xff, 0x55, 0xc0,
      0xba, 0xac, 0xdb, 0xbd, 0x85, 0x98, 0x24, 0xb9, 0x00, 0xb2, 0x4c, 0x57,
      0x1d, 0x27, 0x10, 0xec, 0x22, 0xf5, 0xe4, 0x50, 0x52, 0x30, 0x7c, 0x17,
      0x65, 0xd9, 0x5f, 0x94, 0xb9, 0x9c, 0xf5, 0x7a, 0x90, 0x79, 0x25, 0x58,
      0x80, 0x58, 0xc8, 0xf7, 0xf7, 0xfa, 0x86, 0xdd, 0x87, 0xe8, 0x7e, 0x01,
      0x3c, 0x88, 0x4d, 0x09, 0x9f, 0x9e, 0xce, 0x5d, 0x3b, 0xce, 0xb1, 0x6e,
      0x42, 0x78, 0x93, 0x57, 0xe6, 0x5e, 0x9b, 0x75, 0xb8, 0x1a, 0x89, 0xe3,
      0x0a, 0xd8, 0xf2, 0xa9, 0x7c, 0x74, 0xa3, 0x5b, 0x09, 0x5e, 0x7c, 0x70,
      0x83, 0x5a, 0x01, 0x92, 0xb2, 0x85, 0x01, 0xc8, 0xe8, 0x82, 0x65, 0xcb,
      0xff, 0xd6, 0xe4, 0xc5, 0xc5, 0x78, 0xad, 0x57, 0xd1, 0xf8, 0x81, 0x11,
      0x51, 0x65, 0x19, 0x15, 0x70, 0xa1, 0x9d, 0xf3, 0x3a, 0x53, 0x6b, 0x90,
      0x9d, 0x05, 0x1e, 0xd9, 0x8e, 0x2d, 0x9d, 0x98, 0x51, 0xe3, 0x29, 0x89,
      0xe6, 0x23, 0x57, 0xf2, 0x73, 0xae, 0xa3, 0x8d, 0xa0, 0x84, 0x26, 0x19,
      0x3b, 0x7c, 0x10, 0x39, 0xfd, 0x52, 0x20, 0xb0, 0x71, 0xcf, 0xfc, 0xe9,
      0x69, 0x0f, 0xe8, 0x6c, 0x76, 0x48, 0xc3, 0x31, 0x8f, 0xd4, 0x98, 0x4b,
      0x25, 0xf5, 0x09, 0xdc, 0xb7, 0x98, 0xcd, 0x14, 0x10, 0x22, 0x5a, 0x40,
      0x19, 0x32, 0x59, 0x02, 0x5c, 0x34, 0xba, 0x22, 0x95, 0x5e, 0x65, 0x65,
      0x10, 0x3a, 0x4d, 0x01, 0xc7, 0x8d, 0xe6, 0x04, 0xdd, 0xe9, 0xe3, 0x4b,
      0x83, 0x8b, 0x49, 0x6b, 0xd1, 0x73, 0x32, 0x07, 0x13, 0x70, 0x00, 0xd7,
      0x67, 0xf6, 0xe3, 0xce, 0x63, 0x9c, 0xe5, 0xf1, 0x97, 0x07, 0xa9, 0xad},
     pub_key_2,
     {0x31, 0x36, 0x34, 0x32, 0x36, 0x32, 0x35, 0x32, 0x36, 0x32},
     true},

    // Comment:
    // tcID: 60
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     60,
     32,
     {0x4b, 0x48, 0xed, 0xb4, 0x60, 0x41, 0x6b, 0x6e, 0x1d, 0xbe, 0xb8, 0x7f,
      0xd5, 0x11, 0xaa, 0x57, 0x9c, 0xaa, 0xec, 0xef, 0x2b, 0xb7, 0xc7, 0x81,
      0x8e, 0x4d, 0x57, 0xed, 0x2f, 0x1b, 0x1f, 0x65, 0x63, 0x65, 0xd7, 0x95,
      0x45, 0xc7, 0xe3, 0x92, 0x82, 0x42, 0x12, 0xdc, 0x16, 0x5d, 0x56, 0x1a,
      0xf6, 0x99, 0x37, 0x60, 0x87, 0xa6, 0x21, 0xc5, 0xb8, 0x80, 0xfe, 0x3b,
      0xd5, 0x08, 0x4c, 0xd5, 0x7b, 0xa6, 0xea, 0x2c, 0xdf, 0x1f, 0x48, 0x21,
      0xe2, 0xbf, 0x05, 0x45, 0x11, 0xc9, 0xed, 0xbb, 0xcf, 0x2f, 0x46, 0x14,
      0x7a, 0xaf, 0x69, 0xb7, 0xd9, 0xd4, 0xc1, 0x4b, 0xbc, 0xf5, 0x14, 0x23,
      0xe6, 0x10, 0x76, 0x13, 0x06, 0xc1, 0xca, 0xf1, 0xd4, 0x67, 0x96, 0x16,
      0x5b, 0x22, 0xef, 0x8d, 0xff, 0x23, 0x37, 0x31, 0x43, 0x44, 0xfb, 0x5d,
      0x80, 0xb3, 0x8f, 0x1b, 0x38, 0x27, 0x9a, 0xd6, 0x59, 0x11, 0xcf, 0x5e,
      0x19, 0xc1, 0x31, 0x39, 0xf1, 0xf9, 0xc3, 0xe0, 0x73, 0xe1, 0xa6, 0x6f,
      0x66, 0x56, 0xc2, 0x9f, 0xa6, 0xec, 0x91, 0xf8, 0x49, 0x63, 0xcd, 0xf4,
      0x71, 0x8e, 0x1c, 0xfe, 0xb1, 0xa5, 0xd1, 0x71, 0xa0, 0xce, 0xe5, 0xd9,
      0x04, 0x77, 0xdf, 0x64, 0x8c, 0x56, 0x18, 0xe3, 0x75, 0x92, 0x01, 0x66,
      0x6c, 0x97, 0x4f, 0x36, 0x63, 0x98, 0x04, 0xc6, 0x4c, 0x39, 0x40, 0x2c,
      0x24, 0x10, 0xf1, 0xe8, 0x45, 0xcf, 0xde, 0xdb, 0x80, 0x4b, 0x59, 0xa0,
      0x59, 0xac, 0x1c, 0x29, 0x41, 0x5e, 0xb1, 0x4d, 0xc5, 0x70, 0x7d, 0xa5,
      0xc2, 0xd1, 0x90, 0xbe, 0xa8, 0x37, 0xcc, 0xdd, 0xfb, 0xf9, 0x98, 0xed,
      0xa7, 0xde, 0xed, 0x2e, 0xad, 0xf3, 0xfe, 0x2c, 0xf3, 0x93, 0x49, 0xcb,
      0xab, 0x80, 0x46, 0x1e, 0x0d, 0xc4, 0x54, 0x86, 0x39, 0x68, 0x6a, 0x4c,
      0x47, 0x5a, 0x3a, 0x43, 0x2c, 0xd6, 0x21, 0x6d, 0x43, 0xd8, 0x3e, 0x62,
      0xa2, 0xc7, 0xb4, 0x44, 0x29, 0xee, 0x42, 0xaf, 0xe5, 0x73, 0xd4, 0x5f,
      0x34, 0x03, 0x04, 0x03, 0x18, 0x37, 0xb9, 0x8d, 0xd7, 0xbe, 0x03, 0x26,
      0x70, 0x5d, 0xd7, 0x88, 0x6d, 0x7e, 0xb2, 0x6c, 0x57, 0x28, 0xc1, 0xe3,
      0x43, 0x3c, 0xe6, 0xbf, 0x2f, 0xd3, 0x87, 0x7a, 0x48, 0xc0, 0x6e, 0x34,
      0xab, 0xec, 0xf9, 0xca, 0xb7, 0x18, 0x13, 0xbb, 0x18, 0xa6, 0xc7, 0xfe,
      0x6f, 0x4f, 0x49, 0x90, 0xda, 0x06, 0x5e, 0xd1, 0x0c, 0xfb, 0x05, 0xe9,
      0xae, 0xf4, 0x78, 0x48, 0x03, 0x9b, 0x85, 0x5a, 0xb0, 0xcd, 0x07, 0xc6,
      0x0c, 0x5f, 0xc5, 0x6a, 0x6e, 0x1e, 0x55, 0x22, 0xa4, 0x60, 0xaf, 0xa9,
      0x46, 0x64, 0x94, 0x74, 0xc9, 0xe6, 0x64, 0x80, 0xd2, 0xa2, 0x65, 0xac,
      0x1a, 0x29, 0x70, 0x55, 0x71, 0xdc, 0x03, 0x31, 0x0d, 0x50, 0xc1, 0x1c},
     pub_key_2,
     {0x36, 0x38, 0x32, 0x34, 0x31, 0x38, 0x39, 0x34, 0x33, 0x36},
     true},

    // Comment:
    // tcID: 61
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     61,
     32,
     {0x8b, 0xd9, 0x72, 0xbf, 0x9f, 0xa5, 0x2f, 0x2d, 0x1f, 0x2d, 0x56, 0x4e,
      0xdb, 0x34, 0x31, 0x08, 0x51, 0xc8, 0xc4, 0xb9, 0xf9, 0x13, 0x6d, 0x8f,
      0xe4, 0x94, 0xcc, 0x79, 0x83, 0x2e, 0xc4, 0x97, 0x94, 0x0b, 0x64, 0x2e,
      0x32, 0x46, 0x65, 0x27, 0xcb, 0xd4, 0x0a, 0xf8, 0x17, 0xe3, 0xec, 0xb8,
      0x44, 0xbd, 0x62, 0xa4, 0x9a, 0x53, 0x87, 0x1a, 0xcb, 0xac, 0xeb, 0x15,
      0xc7, 0x2a, 0x2d, 0xef, 0xf8, 0xf7, 0xcb, 0xb8, 0x19, 0x19, 0x85, 0xfb,
      0xfd, 0x78, 0x0a, 0xdc, 0xb8, 0x6a, 0x99, 0xc3, 0x4c, 0x53, 0x7f, 0x84,
      0x8b, 0x58, 0x6b, 0x12, 0x9e, 0x0a, 0x5e, 0x96, 0x0f, 0x81, 0x0b, 0x81,
      0x2c, 0x99, 0xd1, 0x5b, 0x38, 0xe3, 0x65, 0x7b, 0xc0, 0x9f, 0x8e, 0xd4,
      0x34, 0x6a, 0x3d, 0xbc, 0xc1, 0x64, 0x02, 0xe3, 0x31, 0xa1, 0x38, 0x39,
      0xb7, 0xb2, 0x35, 0x18, 0x78, 0x6a, 0x67, 0xe2, 0xac, 0x96, 0xa6, 0xef,
      0x7d, 0x9e, 0x93, 0x1a, 0xbc, 0x8f, 0xe1, 0x88, 0xe3, 0xc3, 0x49, 0xa2,
      0x76, 0x21, 0xb2, 0xda, 0x88, 0xc6, 0xfa, 0x45, 0xdd, 0xef, 0x43, 0x6b,
      0x42, 0x08, 0x86, 0xcd, 0xb1, 0x9f, 0xc0, 0x31, 0xee, 0x58, 0x20, 0x18,
      0x24, 0xac, 0x06, 0xb5, 0x12, 0x9c, 0x51, 0x37, 0xe1, 0x0b, 0x6a, 0x70,
      0x1a, 0xd7, 0xb3, 0x1d, 0x20, 0x4e, 0x32, 0xc4, 0xa8, 0x4e, 0x1b, 0x37,
      0x66, 0x28, 0x79, 0x85, 0xe7, 0x21, 0xbd, 0xd8, 0x91, 0x73, 0x62, 0x6a,
      0xe8, 0xc6, 0xb3, 0x28, 0xdd, 0x26, 0x49, 0x6b, 0x27, 0x26, 0xd5, 0x87,
      0x8b, 0x47, 0x59, 0x0b, 0x38, 0xd0, 0xcd, 0xd7, 0xf3, 0x10, 0x57, 0xdc,
      0x06, 0x64, 0x55, 0xd4, 0xea, 0x87, 0x38, 0xc5, 0xdd, 0x25, 0x1e, 0xa5,
      0x08, 0x15, 0xe9, 0x6b, 0xd5, 0xa4, 0x5e, 0xb6, 0xdb, 0xa8, 0x0d, 0xde,
      0x52, 0xb6, 0x30, 0x68, 0x19, 0x6b, 0x08, 0x01, 0xb3, 0x9f, 0x57, 0xb2,
      0xd6, 0xc8, 0x2e, 0x52, 0xe6, 0xbb, 0x66, 0x22, 0x40, 0x46, 0xd1, 0xa2,
      0x25, 0x0f, 0xbe, 0x1d, 0xba, 0xd2, 0x5e, 0x97, 0x0b, 0xb0, 0xf4, 0x3a,
      0x32, 0x5f, 0x23, 0xa4, 0x0d, 0x9e, 0xe8, 0x79, 0x90, 0x9c, 0x30, 0x0a,
      0xdd, 0xf6, 0x92, 0x95, 0x32, 0x9c, 0x5c, 0xf1, 0x15, 0x3c, 0xf4, 0x06,
      0x49, 0x17, 0xa7, 0x34, 0xa2, 0xfe, 0x98, 0xf5, 0xb1, 0x3a, 0x96, 0xd7,
      0xc2, 0x4e, 0x94, 0x69, 0xe7, 0x63, 0xf8, 0x4e, 0xd1, 0x3d, 0xec, 0x5e,
      0x5a, 0xab, 0x26, 0x06, 0x63, 0xa1, 0x78, 0x2c, 0x12, 0xa0, 0xb8, 0x28,
      0x6d, 0x96, 0xb2, 0xb0, 0xbb, 0x1a, 0x48, 0xdf, 0x46, 0x17, 0x26, 0x85,
      0x3c, 0xe6, 0x0b, 0xf6, 0xef, 0x8c, 0xa3, 0x82, 0x0b, 0xfa, 0x5a, 0xfb,
      0x4e, 0xde, 0x20, 0x7a, 0x8b, 0xa7, 0x82, 0x5b, 0x7c, 0xff, 0x4c, 0xd8},
     pub_key_2,
     {0x34, 0x38, 0x34, 0x32, 0x34, 0x35, 0x34, 0x32, 0x35},
     true},

    // Comment: first byte of m_hash modified
    // tcID: 62
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     62,
     32,
     {0x73, 0x0a, 0x26, 0xb2, 0xc3, 0xfc, 0x2d, 0xf4, 0x74, 0x21, 0x2c, 0x04,
      0xfc, 0xb3, 0x46, 0xb3, 0xb7, 0x8a, 0x58, 0xc6, 0x11, 0x35, 0x18, 0x71,
      0xac, 0x1c, 0x52, 0x62, 0x86, 0x7c, 0xe1, 0x9a, 0x6f, 0x55, 0x38, 0x80,
      0xd6, 0x8b, 0xa4, 0xc3, 0x58, 0x27, 0x61, 0x0b, 0x72, 0xbb, 0x04, 0x41,
      0x62, 0xb0, 0x83, 0xfe, 0x9f, 0xfa, 0x7a, 0x82, 0xe2, 0x36, 0x60, 0x90,
      0x46, 0x48, 0x21, 0x94, 0x6f, 0x2c, 0xe1, 0xa8, 0xea, 0x19, 0xb1, 0x2c,
      0x10, 0xc0, 0xe4, 0x2a, 0x52, 0xff, 0x80, 0x58, 0x51, 0xc2, 0x26, 0x74,
      0x8a, 0x9d, 0x65, 0xd7, 0xcb, 0x20, 0x57, 0xc9, 0xee, 0x0b, 0xed, 0xdd,
      0x8c, 0xa0, 0x2a, 0xe1, 0xbc, 0x36, 0xce, 0xd3, 0x99, 0x25, 0xd2, 0x42,
      0x9d, 0x53, 0x1c, 0x2e, 0x60, 0x7b, 0xfb, 0xf0, 0x64, 0x87, 0x08, 0xef,
      0x4f, 0x7d, 0x81, 0x6c, 0x88, 0x39, 0xcc, 0x8c, 0x62, 0x03, 0x6a, 0xc3,
      0x7e, 0x81, 0x1f, 0x94, 0xa9, 0x43, 0x19, 0x8a, 0xcf, 0x6e, 0x19, 0xc6,
      0x6c, 0xd8, 0x29, 0xbd, 0xe9, 0xde, 0xc9, 0x96, 0x9e, 0xb4, 0x72, 0x4e,
      0x2d, 0x4d, 0xdc, 0x4f, 0x8c, 0x2b, 0xb2, 0x52, 0x70, 0x07, 0xdd, 0xba,
      0xf2, 0x97, 0x59, 0x37, 0xec, 0xe7, 0xf1, 0x77, 0x9d, 0xb2, 0x8c, 0x61,
      0x05, 0x03, 0xe7, 0xeb, 0xbf, 0x0b, 0x03, 0x45, 0x9a, 0x1f, 0x47, 0x94,
      0x13, 0x68, 0x42, 0xb5, 0x7d, 0x04, 0xf1, 0x4e, 0x22, 0xb9, 0x8e, 0xf3,
      0x79, 0x39, 0xc6, 0x4d, 0x08, 0xfb, 0x24, 0x2c, 0xca, 0x54, 0x8b, 0x7b,
      0xb2, 0xc2, 0xd8, 0xb1, 0xdf, 0x6b, 0xb8, 0xb0, 0xb7, 0xf6, 0xf3, 0x8e,
      0x47, 0x22, 0x6e, 0x9f, 0xc0, 0xa4, 0x72, 0x3c, 0x2a, 0x51, 0x8e, 0xbd,
      0xc5, 0xc4, 0xc8, 0xf1, 0x5d, 0xb7, 0x4f, 0xe9, 0x58, 0xbb, 0x56, 0x7e,
      0x55, 0xf0, 0x92, 0xd3, 0xdc, 0x8a, 0xf0, 0x12, 0x8b, 0x35, 0x3e, 0x2d,
      0x27, 0x3d, 0x57, 0x44, 0x33, 0xc2, 0x2c, 0xca, 0x57, 0x9c, 0x47, 0x90,
      0x05, 0xb5, 0x2c, 0x71, 0x5e, 0xff, 0x1e, 0xf4, 0xec, 0xa8, 0xd8, 0x2d,
      0x2f, 0x6d, 0x7c, 0xc9, 0x72, 0xfe, 0x0e, 0x75, 0xf1, 0x9e, 0xee, 0xa3,
      0xb7, 0x7e, 0xa7, 0xfe, 0x26, 0xb1, 0xd2, 0x9c, 0xed, 0xbf, 0xa7, 0xef,
      0x07, 0x37, 0xe4, 0xaa, 0x50, 0xa5, 0x67, 0xb5, 0xfb, 0x41, 0x7e, 0x35,
      0x6f, 0xa8, 0x03, 0x4a, 0x72, 0xa5, 0x3c, 0x5d, 0x1c, 0x0c, 0xd4, 0x67,
      0x80, 0x8d, 0xf6, 0xfa, 0xeb, 0xa8, 0x9d, 0xdd, 0xea, 0xeb, 0x09, 0xc3,
      0xce, 0x79, 0x37, 0x45, 0x0b, 0x41, 0xe7, 0xc1, 0xd4, 0x40, 0x3b, 0x30,
      0x33, 0xd3, 0x53, 0x1a, 0xdc, 0x24, 0xe9, 0xf5, 0xfe, 0x35, 0xd8, 0x77,
      0xa3, 0xe3, 0x6f, 0xd3, 0x70, 0x22, 0x89, 0xe6, 0x9b, 0x46, 0x0b, 0x97},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of m_hash modified
    // tcID: 63
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     63,
     32,
     {0x39, 0xe9, 0x5e, 0x2d, 0xbb, 0xcf, 0x18, 0x17, 0x40, 0x71, 0x46, 0xb1,
      0x91, 0x48, 0xae, 0xcc, 0xdc, 0x6b, 0x53, 0x87, 0x29, 0xae, 0x4f, 0x3b,
      0xc2, 0x40, 0xf4, 0xed, 0x8c, 0xb9, 0xdc, 0x6a, 0x0e, 0x9c, 0xdf, 0x43,
      0x6b, 0xf5, 0x23, 0x7e, 0x79, 0xe2, 0x39, 0xa4, 0x32, 0xa9, 0x53, 0xce,
      0x38, 0x04, 0xa7, 0xa5, 0x5b, 0xcc, 0x3f, 0x7a, 0x0d, 0x37, 0xd0, 0x12,
      0x3b, 0x1f, 0x04, 0x6e, 0xcb, 0xf0, 0xeb, 0x33, 0xf5, 0x26, 0x31, 0xe0,
      0x49, 0xb0, 0x69, 0x2b, 0xa2, 0xe5, 0x5d, 0xb1, 0x34, 0xf6, 0x0e, 0x08,
      0x5c, 0x07, 0x8b, 0x0c, 0xbb, 0xd6, 0x6a, 0x74, 0xbd, 0x09, 0xc8, 0x52,
      0xfa, 0x9f, 0x02, 0x9f, 0xdc, 0xc2, 0x56, 0x79, 0x99, 0x0d, 0xc4, 0x82,
      0x28, 0x4d, 0xe9, 0xfc, 0x74, 0xdf, 0x34, 0x3a, 0xa7, 0x19, 0x7d, 0x84,
      0x68, 0x90, 0x11, 0xf6, 0x1e, 0xc0, 0xd1, 0xd0, 0xfd, 0x3b, 0x81, 0x1a,
      0x91, 0x8e, 0x80, 0xb9, 0xed, 0xe6, 0xc7, 0x8c, 0x03, 0xf0, 0xff, 0x6e,
      0xc7, 0xe7, 0xec, 0xba, 0x9c, 0xbd, 0x8a, 0x41, 0x24, 0x12, 0x80, 0x34,
      0xe4, 0x25, 0xaa, 0xcb, 0x00, 0x4c, 0x04, 0x2b, 0xe8, 0x05, 0x71, 0x0e,
      0x94, 0xca, 0x4d, 0x36, 0xcc, 0x2f, 0x5d, 0x89, 0x30, 0x36, 0x09, 0x19,
      0x50, 0xbb, 0x16, 0x63, 0xd3, 0x49, 0x9f, 0x8e, 0xbe, 0x09, 0xea, 0x27,
      0x60, 0xe3, 0x93, 0x9b, 0x83, 0x5e, 0xfa, 0x58, 0x58, 0x34, 0x11, 0x2a,
      0x55, 0x15, 0xc8, 0x90, 0x0d, 0xb9, 0x8a, 0x44, 0x91, 0x4a, 0x6c, 0x3e,
      0x5c, 0xae, 0xad, 0x29, 0xb1, 0x82, 0xe5, 0x85, 0x09, 0x2e, 0xe5, 0x91,
      0x26, 0xc9, 0xe6, 0xa7, 0x73, 0x7d, 0x3b, 0x34, 0xb2, 0xfd, 0xae, 0xb7,
      0x4d, 0xdb, 0x29, 0x9c, 0xc3, 0x72, 0x56, 0x87, 0x16, 0x7d, 0x5c, 0x1f,
      0x92, 0xd9, 0x18, 0x6f, 0x3a, 0xef, 0xca, 0x61, 0xad, 0x6c, 0x27, 0x28,
      0x3d, 0xbc, 0x82, 0x1f, 0x6b, 0x5a, 0xac, 0xb2, 0x38, 0x50, 0x0a, 0x51,
      0xf7, 0x43, 0x9a, 0x8b, 0xf5, 0x55, 0xee, 0x26, 0xfb, 0xa4, 0xc8, 0x61,
      0x3f, 0xc4, 0x3f, 0xfc, 0xd2, 0x54, 0x97, 0x7f, 0x5f, 0x67, 0x09, 0x5e,
      0xf2, 0x3e, 0x95, 0x67, 0x21, 0xd5, 0xd7, 0x1a, 0x8a, 0x73, 0x50, 0x31,
      0x06, 0xb2, 0x55, 0x5c, 0x74, 0x33, 0xca, 0xbb, 0x30, 0x4f, 0x30, 0x49,
      0x2c, 0x90, 0xb3, 0x57, 0x12, 0x7b, 0x09, 0xd4, 0x5f, 0x17, 0x1d, 0x7f,
      0x4d, 0x49, 0x39, 0xc8, 0x45, 0x16, 0xf9, 0x6e, 0xb8, 0xf0, 0x69, 0x33,
      0x85, 0xe5, 0x3a, 0x3c, 0xf8, 0xa6, 0xb4, 0xd0, 0x63, 0x8b, 0x12, 0x1e,
      0x2e, 0x70, 0xb5, 0x45, 0x18, 0x83, 0xef, 0x36, 0x80, 0x97, 0xc7, 0xa2,
      0x01, 0x0d, 0xfd, 0x88, 0x90, 0x15, 0xee, 0xf0, 0x08, 0x15, 0x13, 0xd7},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of m_hash modified
    // tcID: 64
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     64,
     32,
     {0x84, 0xf1, 0xe3, 0x7e, 0x7d, 0x52, 0x95, 0x5a, 0x8d, 0x07, 0x6e, 0x83,
      0xfa, 0xbc, 0xe6, 0xa7, 0x15, 0x3d, 0x49, 0xe7, 0x71, 0x14, 0x6a, 0xd6,
      0x65, 0xac, 0x95, 0xb6, 0x7e, 0xea, 0x85, 0xec, 0xf8, 0xc1, 0x26, 0x88,
      0x7c, 0x0b, 0x0e, 0x4f, 0xf2, 0xf4, 0xf3, 0xca, 0x11, 0xcc, 0xc5, 0x10,
      0xfc, 0x4a, 0x06, 0x2b, 0x31, 0x57, 0xed, 0xf2, 0x0f, 0xf2, 0x76, 0x3e,
      0xd0, 0xc4, 0x4c, 0xa8, 0xd4, 0x8c, 0x57, 0x11, 0x19, 0xbf, 0x5a, 0x4a,
      0xda, 0x5d, 0x87, 0xea, 0xf5, 0xc3, 0x89, 0xcd, 0x8c, 0xe3, 0xa9, 0xce,
      0x70, 0xbf, 0xa9, 0x8d, 0x55, 0x36, 0xfc, 0x73, 0x1a, 0x26, 0x07, 0x06,
      0x6b, 0xb2, 0xcd, 0x09, 0x15, 0x51, 0x14, 0x04, 0xe6, 0x9a, 0xe5, 0xba,
      0x69, 0xbc, 0x19, 0x7e, 0xd9, 0x95, 0xf5, 0x1d, 0x83, 0x5b, 0xde, 0x74,
      0xc5, 0xdd, 0x1d, 0x4e, 0x69, 0xa5, 0x44, 0x45, 0xf3, 0x72, 0x36, 0x92,
      0xc3, 0xb2, 0x01, 0xc2, 0x83, 0x70, 0xe4, 0x89, 0x2e, 0xa5, 0x6c, 0x3d,
      0x2b, 0x83, 0x54, 0x48, 0x9a, 0x72, 0x84, 0x95, 0xe7, 0xd7, 0xd6, 0x11,
      0xe8, 0x2c, 0x73, 0x9d, 0x53, 0xde, 0xd8, 0x2f, 0x1e, 0x72, 0xc4, 0xe7,
      0x27, 0x3e, 0xc6, 0x3c, 0x8f, 0xc4, 0xcd, 0x13, 0x24, 0x12, 0x19, 0x65,
      0x9d, 0x9c, 0x6c, 0x86, 0x20, 0xa4, 0x55, 0x47, 0x75, 0x87, 0x73, 0x7a,
      0xb9, 0x79, 0x59, 0xa9, 0x1e, 0xfa, 0xbc, 0x1e, 0x1d, 0xe8, 0x21, 0x8b,
      0xb6, 0x74, 0x66, 0xb8, 0xe8, 0x90, 0xf4, 0x7b, 0x5a, 0xe4, 0x62, 0x66,
      0xac, 0x06, 0xe0, 0x62, 0x47, 0xf3, 0xa1, 0x69, 0xa3, 0x1f, 0x9f, 0xaf,
      0xa2, 0x68, 0xbd, 0x45, 0x3c, 0x67, 0xb7, 0x7f, 0x7c, 0xa9, 0xa5, 0x3a,
      0xde, 0xe4, 0x2b, 0x3a, 0x9a, 0xcd, 0x4a, 0xf4, 0x67, 0xf7, 0xde, 0xfb,
      0xcf, 0xb9, 0x6f, 0x08, 0x77, 0x17, 0x13, 0x7b, 0xcc, 0x0b, 0xfb, 0x41,
      0xf5, 0xad, 0xd9, 0x4a, 0xf4, 0x98, 0x1c, 0x00, 0xd9, 0x5f, 0x99, 0x29,
      0x95, 0xaa, 0x3a, 0xe4, 0x06, 0xdd, 0x6d, 0xf5, 0x6a, 0x70, 0x70, 0x83,
      0x4d, 0x20, 0x1e, 0xb1, 0xcd, 0x12, 0xc7, 0xca, 0x87, 0x77, 0x9d, 0xe0,
      0xeb, 0x38, 0xdb, 0xb9, 0x2f, 0x4e, 0x7f, 0x6f, 0x78, 0xdd, 0x22, 0x4d,
      0x0d, 0xee, 0x4b, 0x12, 0xb2, 0x08, 0x36, 0x15, 0x55, 0x53, 0xb0, 0xa7,
      0x6e, 0x2c, 0xc0, 0x71, 0xab, 0xb5, 0x9a, 0x70, 0xab, 0x39, 0x36, 0x79,
      0xca, 0x45, 0x8d, 0x18, 0xf9, 0xa5, 0xec, 0x69, 0xd1, 0xd7, 0x0b, 0x07,
      0x4d, 0x6c, 0xc8, 0xf9, 0xc3, 0xd5, 0x14, 0x3d, 0xe1, 0xc5, 0x3d, 0xac,
      0x15, 0x6d, 0x36, 0xd2, 0x86, 0x60, 0x95, 0x3a, 0xc6, 0x86, 0x70, 0xe3,
      0x43, 0x17, 0xa8, 0x86, 0x4c, 0xf7, 0xc7, 0x21, 0x4e, 0x5c, 0x9c, 0x33},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of m_hash modified
    // tcID: 65
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     65,
     32,
     {0x87, 0x5c, 0x6f, 0x8f, 0x33, 0x95, 0xf7, 0x50, 0x24, 0xb7, 0xad, 0xe4,
      0xf6, 0xb3, 0x00, 0x4c, 0x46, 0x07, 0xaa, 0x6c, 0xc9, 0x91, 0x68, 0xd0,
      0x1c, 0xcd, 0x6c, 0xb4, 0x81, 0xb5, 0x1f, 0xb8, 0xa2, 0xbb, 0x44, 0xbd,
      0x10, 0xa0, 0xe7, 0x76, 0x8f, 0x28, 0x26, 0x53, 0xab, 0x6c, 0xa3, 0x40,
      0xb0, 0x44, 0xad, 0x03, 0xe0, 0x9a, 0xbd, 0x01, 0xbd, 0x09, 0x62, 0xa5,
      0xe3, 0x72, 0x4f, 0xf7, 0xa4, 0x9f, 0xfe, 0xe7, 0x81, 0x8d, 0xd5, 0xac,
      0xd0, 0xa6, 0x96, 0x8c, 0x5c, 0x45, 0x8c, 0x20, 0x7d, 0x0f, 0x77, 0xef,
      0xf3, 0xf8, 0xa2, 0xbe, 0x4b, 0x55, 0x93, 0x14, 0xb0, 0x2e, 0x41, 0x38,
      0x65, 0xec, 0xbf, 0xc0, 0xbf, 0x7e, 0xd7, 0xe6, 0x6a, 0xe1, 0x0b, 0x86,
      0xef, 0xa9, 0x87, 0x3e, 0xff, 0x30, 0xa1, 0x7a, 0xed, 0xbf, 0x81, 0xcd,
      0x98, 0x81, 0x1b, 0xa2, 0x28, 0x54, 0x3e, 0xce, 0x8b, 0x14, 0xf6, 0x4c,
      0xa9, 0x8d, 0xd2, 0x6a, 0xa5, 0xee, 0x83, 0xa1, 0x84, 0x7d, 0x6f, 0xda,
      0xbb, 0x81, 0x40, 0xe4, 0xdf, 0xe4, 0x8d, 0xb3, 0x9f, 0x6a, 0x48, 0xa8,
      0x25, 0xb7, 0xaf, 0x48, 0xc1, 0xe1, 0xbd, 0x12, 0x4a, 0x2f, 0x6b, 0x76,
      0xd0, 0xe3, 0x7f, 0x76, 0xf4, 0xba, 0x98, 0x6a, 0xb3, 0xaf, 0xeb, 0x55,
      0xc7, 0xcf, 0x2f, 0x45, 0x02, 0x1d, 0xc3, 0x25, 0x32, 0x2a, 0xe6, 0x1b,
      0x53, 0x1f, 0x43, 0x24, 0x2c, 0x65, 0xba, 0x8b, 0x4a, 0x55, 0x08, 0x01,
      0xe9, 0x66, 0x60, 0x27, 0x30, 0xcc, 0x18, 0x6b, 0xf4, 0x67, 0x8d, 0x30,
      0x0d, 0x57, 0x83, 0xda, 0x4b, 0xb9, 0xd9, 0xad, 0x54, 0xac, 0xeb, 0x65,
      0x6e, 0xc7, 0xe4, 0x59, 0x8e, 0x3c, 0x20, 0x9a, 0xc4, 0x8e, 0x1b, 0x77,
      0x5b, 0x68, 0x89, 0x6f, 0xe2, 0x82, 0xbc, 0x2e, 0x3b, 0xf9, 0xca, 0xc9,
      0x9c, 0x60, 0x1d, 0x64, 0xde, 0x18, 0xd3, 0x1d, 0x18, 0x92, 0xb3, 0x09,
      0x8f, 0xae, 0x29, 0x33, 0x85, 0x4f, 0x82, 0x2c, 0x49, 0xfa, 0xa0, 0x9e,
      0x07, 0x9c, 0x4f, 0xfa, 0x9d, 0xd2, 0xc0, 0x06, 0x47, 0x12, 0x63, 0xf0,
      0x2e, 0x7e, 0x8e, 0xaf, 0x03, 0x45, 0x13, 0x94, 0x82, 0xcd, 0x82, 0xed,
      0x8e, 0x6d, 0x3e, 0x08, 0x08, 0x87, 0xed, 0x13, 0xf2, 0xe6, 0x58, 0x19,
      0xa1, 0xdc, 0xdb, 0x6d, 0x3f, 0x56, 0x92, 0xf5, 0xec, 0x7f, 0x3a, 0x06,
      0x09, 0xf2, 0xf7, 0x1c, 0xa4, 0x56, 0x4d, 0x58, 0xf6, 0x0a, 0x03, 0x11,
      0xbe, 0x5b, 0x59, 0x7d, 0xdd, 0xa9, 0xb0, 0x7b, 0x52, 0x54, 0x1e, 0xa9,
      0x24, 0xcc, 0x05, 0x14, 0x62, 0x43, 0xd8, 0xb3, 0x89, 0x9d, 0x3a, 0xb0,
      0x01, 0x18, 0x47, 0x67, 0xf8, 0x96, 0xf0, 0xe0, 0x44, 0x22, 0x4d, 0x96,
      0xc9, 0x75, 0x12, 0x7c, 0x1c, 0x98, 0x7a, 0x84, 0xd1, 0x5c, 0xfa, 0x12},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bits in m_hash flipped
    // tcID: 66
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     66,
     32,
     {0xbe, 0xd5, 0xc4, 0x4c, 0x1e, 0x2a, 0x04, 0x1c, 0x21, 0x30, 0xca, 0xf3,
      0x4c, 0xe4, 0x3e, 0x4e, 0xfd, 0xde, 0x6f, 0x78, 0x46, 0xc3, 0x0d, 0x5a,
      0x1b, 0xbd, 0xd8, 0x8c, 0x26, 0x64, 0x85, 0x32, 0x2b, 0x1f, 0xd6, 0xd6,
      0x35, 0x3e, 0x85, 0xca, 0x45, 0x38, 0xd8, 0x62, 0x39, 0x4f, 0xd3, 0x21,
      0x80, 0xb3, 0x6c, 0x10, 0xb3, 0x14, 0xa8, 0x82, 0x3a, 0x6c, 0x4a, 0x78,
      0xcb, 0x62, 0xb5, 0xb9, 0x88, 0x4a, 0x6c, 0xa4, 0x80, 0xad, 0x29, 0x93,
      0xd4, 0xf2, 0x09, 0xd1, 0x89, 0x5f, 0x9a, 0x41, 0x82, 0xa1, 0x4d, 0x47,
      0xf0, 0x9a, 0x13, 0xc9, 0xc9, 0xbb, 0xaf, 0x21, 0x1d, 0x07, 0x65, 0x3f,
      0x8c, 0x61, 0x0c, 0x16, 0xd1, 0x56, 0xc9, 0x31, 0xdf, 0x94, 0x36, 0xbc,
      0x7b, 0x9e, 0xf9, 0x29, 0xde, 0xde, 0x2c, 0x1d, 0x59, 0xa2, 0xb0, 0x44,
      0x12, 0x90, 0xf5, 0x18, 0x25, 0xef, 0x44, 0x96, 0x45, 0x64, 0xe3, 0x42,
      0x0d, 0xcf, 0x3c, 0x16, 0x22, 0xa8, 0x22, 0x7a, 0x82, 0xb8, 0xd3, 0x80,
      0x6e, 0xb5, 0xd2, 0x46, 0xa3, 0xb0, 0x52, 0x7c, 0xde, 0x1b, 0xe3, 0xf2,
      0x19, 0xa9, 0x01, 0x56, 0x53, 0xf3, 0xf8, 0xa3, 0x95, 0x6d, 0x05, 0x5e,
      0xff, 0x6a, 0x90, 0xf4, 0x2b, 0x48, 0xf3, 0xfa, 0xe5, 0xdc, 0x57, 0xd6,
      0xbe, 0x11, 0x19, 0x56, 0xe6, 0xa9, 0xb6, 0xef, 0x52, 0xdc, 0x35, 0xef,
      0x5a, 0xc3, 0x63, 0xf1, 0xce, 0x80, 0x2c, 0x4c, 0x09, 0x55, 0x5d, 0xd3,
      0x43, 0xad, 0x0d, 0xda, 0x96, 0xb4, 0x67, 0x16, 0x6a, 0xc5, 0x15, 0x83,
      0x0e, 0x9e, 0x2e, 0xe4, 0x0d, 0x56, 0xe6, 0x85, 0x58, 0x40, 0x8b, 0x1f,
      0xb7, 0x1c, 0xbc, 0x4a, 0x96, 0x4e, 0xbd, 0x83, 0x2e, 0x31, 0x5d, 0x8b,
      0xee, 0x13, 0x52, 0x93, 0x14, 0xa8, 0xae, 0x34, 0x6f, 0x4d, 0x12, 0xf5,
      0xef, 0x00, 0x68, 0x6f, 0x4e, 0xc2, 0x6f, 0x94, 0x79, 0xf5, 0x7e, 0x69,
      0x24, 0x42, 0x64, 0xd8, 0x1a, 0x0f, 0xa3, 0x9b, 0xa7, 0x67, 0x0c, 0xdf,
      0x2d, 0xb9, 0x68, 0x4e, 0x0b, 0x70, 0xd2, 0x86, 0x4c, 0x4f, 0x25, 0x14,
      0xe4, 0x98, 0xe8, 0x7d, 0x47, 0x4e, 0x65, 0xcb, 0x18, 0x88, 0x35, 0xd5,
      0xfd, 0x8c, 0x34, 0xe5, 0x43, 0x29, 0x44, 0xcc, 0x08, 0x74, 0xea, 0xdc,
      0xd0, 0xa3, 0xe6, 0x2d, 0x9f, 0x53, 0x35, 0x83, 0xd3, 0x3f, 0x5a, 0x99,
      0xaf, 0x63, 0xd6, 0xcf, 0x42, 0x93, 0x63, 0xf5, 0x8f, 0x69, 0x1d, 0xeb,
      0x4a, 0x95, 0xff, 0x40, 0x9e, 0x32, 0xc3, 0x93, 0xf3, 0x44, 0xc5, 0xe0,
      0x34, 0x7b, 0x2f, 0x12, 0x12, 0x5f, 0x6e, 0x39, 0x44, 0xf5, 0x63, 0xd5,
      0x9c, 0x65, 0x39, 0xc6, 0x61, 0x12, 0x9f, 0x30, 0x02, 0x67, 0xdd, 0xe2,
      0x99, 0x97, 0x2f, 0x02, 0xdc, 0xc2, 0x40, 0xbb, 0x85, 0x41, 0xac, 0xf2},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: s_len changed to 0
    // tcID: 67
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     67,
     32,
     {0x4e, 0x28, 0xf5, 0x46, 0x28, 0x3f, 0x9a, 0xc7, 0x4c, 0xc9, 0x9c, 0x6b,
      0xca, 0x79, 0xbc, 0x20, 0x8e, 0x47, 0x22, 0x0c, 0xfb, 0x07, 0x17, 0xaa,
      0xbc, 0x52, 0x1a, 0xc5, 0x51, 0x19, 0xec, 0x6b, 0xbc, 0xac, 0x88, 0x0b,
      0xed, 0x00, 0x07, 0xc0, 0x4e, 0xef, 0x92, 0xa2, 0x4b, 0x09, 0x1d, 0x9a,
      0x09, 0xee, 0x5d, 0x3b, 0x5b, 0xe7, 0x90, 0xab, 0xdb, 0x2c, 0x98, 0xa0,
      0x73, 0x13, 0xd5, 0x05, 0xfc, 0x87, 0x6a, 0xdc, 0xbb, 0x10, 0x89, 0x02,
      0x69, 0x40, 0xe0, 0x3d, 0xfc, 0x10, 0xfb, 0x46, 0xa0, 0xc2, 0xa7, 0x64,
      0xeb, 0xe8, 0x6e, 0x51, 0xec, 0xc2, 0xab, 0x48, 0x9f, 0x56, 0xda, 0xf3,
      0x87, 0x64, 0xfc, 0x0a, 0x36, 0xa9, 0xcb, 0x45, 0x29, 0x36, 0x7c, 0x98,
      0x80, 0xbf, 0xd7, 0x63, 0x1c, 0x34, 0x0f, 0xb7, 0xfb, 0xac, 0x0e, 0xdd,
      0x2e, 0x1d, 0xef, 0x00, 0xd6, 0x5b, 0xd5, 0x2e, 0x59, 0x7e, 0x2e, 0xba,
      0x1b, 0xe1, 0xe4, 0x1b, 0xd8, 0x9a, 0x00, 0xf5, 0xc6, 0x6f, 0xbc, 0x18,
      0xb9, 0x3e, 0x9c, 0xc1, 0xb5, 0xbe, 0x96, 0x27, 0x80, 0xf6, 0xd7, 0xa9,
      0xc6, 0xd3, 0x75, 0xa2, 0x85, 0x56, 0x11, 0x4f, 0x37, 0xa8, 0xa3, 0x60,
      0x6d, 0xcd, 0x68, 0xc8, 0x12, 0x8b, 0xf7, 0xa7, 0xe5, 0xf1, 0x20, 0x57,
      0x78, 0xbc, 0xf3, 0x04, 0x8b, 0xd4, 0xf7, 0xc1, 0x0c, 0xbd, 0xb4, 0xae,
      0x75, 0x99, 0x54, 0xc4, 0xe4, 0xdb, 0x0a, 0x9f, 0xe4, 0xdf, 0x27, 0x0c,
      0x41, 0xbb, 0x86, 0x88, 0x5d, 0xbd, 0xd8, 0xcb, 0x7e, 0x72, 0xa3, 0x33,
      0x22, 0x23, 0x8a, 0x2d, 0x29, 0x61, 0x5a, 0x2f, 0x01, 0xe9, 0xfc, 0x59,
      0xc2, 0x30, 0xc2, 0xcc, 0xe5, 0x8a, 0xd0, 0x96, 0xc2, 0xde, 0x50, 0x71,
      0xe0, 0x20, 0xf7, 0x6c, 0x8c, 0x39, 0x87, 0x4f, 0x1d, 0xe6, 0x77, 0xdd,
      0x5d, 0x2f, 0x96, 0xab, 0x4d, 0xc1, 0x45, 0x09, 0x8d, 0x25, 0xb7, 0x40,
      0xb5, 0x27, 0x9f, 0x05, 0x71, 0x3d, 0xaf, 0xf5, 0x4b, 0xa6, 0x95, 0xf9,
      0x50, 0x03, 0x98, 0x82, 0x05, 0x9c, 0xfc, 0x2f, 0x86, 0xc3, 0x5a, 0x05,
      0x01, 0xb8, 0xd0, 0x91, 0x4a, 0xa5, 0x9a, 0x80, 0x6e, 0x8d, 0x14, 0x03,
      0xfb, 0x2e, 0xef, 0x16, 0x3b, 0xa1, 0xd6, 0xe3, 0xd1, 0xe1, 0x8d, 0xc9,
      0x9c, 0x62, 0x2f, 0x8c, 0x2d, 0x36, 0x0b, 0xfa, 0xb2, 0xc9, 0xe8, 0xfd,
      0x9d, 0x74, 0xa0, 0x27, 0xe4, 0x66, 0xfb, 0xcf, 0x4f, 0xa5, 0x67, 0x77,
      0xee, 0x0f, 0xea, 0x7e, 0x04, 0xae, 0x19, 0x01, 0xe6, 0x5b, 0x53, 0x61,
      0xf9, 0x71, 0x46, 0xd7, 0xf4, 0xa5, 0x50, 0xad, 0xf7, 0x75, 0x39, 0xfa,
      0xbb, 0x71, 0x35, 0x96, 0x7d, 0xc1, 0x6f, 0x8c, 0xa9, 0x9e, 0x82, 0x83,
      0xdd, 0x69, 0x62, 0x7c, 0xf2, 0x7c, 0xb9, 0xd2, 0xdf, 0x20, 0xbb, 0xbb},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: s_len changed to 20
    // tcID: 68
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     68,
     32,
     {0x78, 0xd3, 0x50, 0x92, 0x84, 0xdc, 0x06, 0xb5, 0x45, 0x83, 0xe1, 0x1d,
      0xdf, 0x25, 0x07, 0xd9, 0xe5, 0x0b, 0xdb, 0xf0, 0x79, 0xfc, 0x31, 0x9d,
      0x10, 0x7b, 0xc2, 0x52, 0x7c, 0x1b, 0x74, 0x2f, 0x4c, 0x75, 0x93, 0x20,
      0xfa, 0x22, 0x43, 0x5d, 0x74, 0xe9, 0x42, 0x53, 0xfe, 0xb4, 0xa3, 0x79,
      0x12, 0x8e, 0x7f, 0x33, 0xc5, 0xf3, 0x46, 0x2f, 0xbf, 0xb9, 0x2f, 0xf4,
      0x0c, 0x10, 0xb2, 0x3f, 0x8b, 0xdc, 0x58, 0x90, 0x11, 0x47, 0x57, 0x36,
      0x42, 0x07, 0x76, 0x80, 0x14, 0x38, 0x0f, 0xc1, 0x6e, 0xbe, 0xaf, 0x22,
      0xa7, 0xb1, 0xa9, 0x36, 0x6f, 0x3f, 0xbb, 0xbb, 0x91, 0x23, 0x47, 0xf1,
      0xef, 0x59, 0x5d, 0x74, 0x2a, 0x97, 0x6b, 0x69, 0x37, 0x75, 0x33, 0xe7,
      0xb6, 0x1d, 0x32, 0x37, 0xc3, 0x69, 0x3c, 0xf4, 0x3b, 0x34, 0xf9, 0x27,
      0x73, 0x49, 0x7b, 0x8d, 0xf7, 0xac, 0x06, 0x60, 0xf6, 0x74, 0x39, 0xaa,
      0xa6, 0x6f, 0xe1, 0x79, 0xb3, 0x4d, 0x9d, 0xd4, 0xd0, 0x13, 0xe8, 0xfa,
      0xb9, 0x58, 0xfb, 0xe2, 0xa2, 0x7c, 0xe8, 0x4b, 0x6d, 0x1c, 0x3c, 0x29,
      0x98, 0xa5, 0x0d, 0x41, 0xb6, 0xb3, 0x80, 0x00, 0x19, 0x16, 0x73, 0xc2,
      0x37, 0x92, 0xdb, 0x2f, 0xe4, 0x7e, 0x4d, 0xdd, 0x3b, 0x53, 0x96, 0xc6,
      0x5d, 0xc4, 0x48, 0x12, 0xe5, 0x52, 0x98, 0xb8, 0xb5, 0x0b, 0x5a, 0x2a,
      0x01, 0xd5, 0x08, 0xb9, 0xd2, 0x15, 0x98, 0x61, 0x13, 0xb0, 0x99, 0x71,
      0x7c, 0x3a, 0x4e, 0xe9, 0x30, 0xf4, 0x79, 0x30, 0x8c, 0x20, 0xc2, 0x66,
      0x30, 0xaa, 0x54, 0x19, 0xc2, 0x58, 0x9c, 0x8c, 0xbb, 0xaf, 0xa7, 0xea,
      0xeb, 0xd7, 0x1f, 0xca, 0x9e, 0x75, 0x17, 0x93, 0x62, 0x9d, 0x76, 0x7b,
      0xe8, 0x70, 0x9f, 0xef, 0x91, 0x77, 0xd6, 0x63, 0x1a, 0x48, 0x73, 0x1f,
      0x5e, 0x59, 0xfc, 0x7e, 0x98, 0xcd, 0x46, 0x63, 0x75, 0xe8, 0x77, 0x5b,
      0xa9, 0x35, 0xf1, 0x2b, 0x45, 0x57, 0x58, 0x19, 0xec, 0xef, 0x4d, 0x78,
      0xd8, 0x5b, 0x6e, 0x98, 0x4d, 0x90, 0xd4, 0x1c, 0x93, 0xbb, 0x03, 0xc8,
      0x32, 0xfe, 0x41, 0x5f, 0xb5, 0x67, 0xa1, 0xd9, 0x51, 0xf7, 0xdb, 0xdf,
      0x40, 0x7b, 0xee, 0xf8, 0xca, 0xa3, 0xa7, 0x41, 0xca, 0x7c, 0x77, 0x29,
      0xc8, 0xd8, 0xba, 0x98, 0x89, 0x6d, 0xbe, 0x52, 0xd9, 0x78, 0x5f, 0xeb,
      0x49, 0x33, 0x2e, 0x64, 0x67, 0x71, 0xe7, 0xd8, 0x4b, 0x75, 0x47, 0x6a,
      0xaf, 0xa0, 0xa5, 0x45, 0x12, 0x80, 0x63, 0x39, 0xcb, 0x54, 0xec, 0x1c,
      0x70, 0x94, 0x3b, 0xeb, 0x50, 0x89, 0x66, 0x74, 0x1e, 0xba, 0x4d, 0x39,
      0xc2, 0xfe, 0x53, 0x5a, 0xa8, 0x2a, 0x9c, 0xb9, 0x2e, 0xec, 0x99, 0xd3,
      0x85, 0x40, 0xef, 0xa3, 0xe3, 0x9f, 0xbc, 0x02, 0xd7, 0x57, 0xad, 0x74},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: salt is all 0
    // tcID: 69
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     69,
     32,
     {0x04, 0x2b, 0xea, 0x79, 0xb2, 0x24, 0x18, 0x31, 0x1d, 0x75, 0xe8, 0x6d,
      0x0c, 0x05, 0xa9, 0xab, 0x49, 0x05, 0xe5, 0x9b, 0x3e, 0x0b, 0x12, 0xfa,
      0x0b, 0x1e, 0x37, 0x2b, 0xbf, 0x66, 0x69, 0x0e, 0x1c, 0x23, 0x14, 0x5b,
      0x23, 0xb9, 0x27, 0x35, 0xf2, 0x21, 0x4a, 0xc1, 0xea, 0xc2, 0xcc, 0x40,
      0x45, 0xe2, 0x99, 0xf4, 0x0f, 0x7e, 0x41, 0x8c, 0x91, 0xff, 0x32, 0x8e,
      0x68, 0xbf, 0x17, 0x46, 0x6e, 0xb3, 0xe2, 0x8d, 0xe3, 0x13, 0x9e, 0xc2,
      0x3b, 0x57, 0xce, 0x5a, 0xaf, 0xbc, 0x1e, 0x0e, 0x15, 0x21, 0xa2, 0x92,
      0x93, 0x5a, 0x35, 0xc6, 0xd6, 0x18, 0x9a, 0x42, 0xa8, 0x1c, 0x57, 0x3f,
      0x8b, 0xe9, 0xa0, 0xcf, 0x80, 0xb3, 0x44, 0x57, 0x39, 0x2f, 0xaf, 0x03,
      0x1b, 0x63, 0x25, 0x44, 0xfd, 0xd5, 0x02, 0x85, 0xa7, 0xfa, 0x82, 0xa4,
      0xae, 0x61, 0x50, 0xb6, 0x0d, 0xd9, 0xa3, 0x2c, 0xfd, 0x13, 0x1b, 0x24,
      0x6d, 0x6c, 0x89, 0xfc, 0x92, 0xe9, 0xa1, 0xdf, 0x96, 0x85, 0x7a, 0x6b,
      0x56, 0xfd, 0x9c, 0x89, 0x7a, 0xa4, 0xc8, 0xb4, 0xee, 0x8e, 0x10, 0xdc,
      0xd0, 0xee, 0x80, 0x33, 0x4d, 0x22, 0x61, 0xf0, 0x29, 0x30, 0xa3, 0xa5,
      0x4a, 0x34, 0x77, 0xc8, 0xe1, 0x55, 0x73, 0x18, 0x78, 0x63, 0x72, 0x56,
      0xf7, 0x08, 0x53, 0x48, 0x49, 0x30, 0xd1, 0x80, 0xa3, 0x7c, 0x0b, 0x60,
      0x4a, 0xaa, 0xf6, 0x49, 0xce, 0x93, 0xf8, 0x86, 0xa5, 0xf9, 0xaa, 0xf8,
      0x6e, 0x52, 0x92, 0x86, 0xbf, 0x1a, 0xb5, 0xc8, 0xe1, 0x89, 0xd4, 0x4a,
      0x28, 0x81, 0x4d, 0x5e, 0x1c, 0x7e, 0x5c, 0x37, 0x6d, 0x8e, 0x80, 0xec,
      0xe5, 0x68, 0x6d, 0x6e, 0xba, 0xb9, 0x0a, 0x51, 0x77, 0x3b, 0xe4, 0xa9,
      0x19, 0xb2, 0x2b, 0xde, 0x12, 0x3c, 0xee, 0xd0, 0x6c, 0x76, 0xd2, 0xc1,
      0xaf, 0x87, 0x85, 0x40, 0xb5, 0xec, 0x81, 0xce, 0x06, 0x79, 0x59, 0xea,
      0x83, 0x33, 0xe2, 0x34, 0x0a, 0x9f, 0x9d, 0x7f, 0x2b, 0x22, 0xe1, 0x05,
      0x2e, 0x74, 0x78, 0x38, 0x2c, 0xa9, 0x37, 0xcb, 0xda, 0xd6, 0x2a, 0x6d,
      0x8f, 0xa4, 0x09, 0x17, 0x0e, 0xf2, 0xa0, 0x32, 0x99, 0x12, 0x69, 0x65,
      0xd5, 0x58, 0x97, 0x8c, 0xad, 0x7d, 0x39, 0x9a, 0x68, 0x3d, 0x19, 0xb7,
      0x6b, 0xc5, 0x98, 0xb9, 0x4f, 0x6c, 0x94, 0xc3, 0x3c, 0x6b, 0xb1, 0x65,
      0x2d, 0x44, 0x50, 0x8c, 0x77, 0x7d, 0xe0, 0xda, 0x7b, 0x65, 0x1e, 0x7c,
      0x93, 0x8e, 0x80, 0x2b, 0xac, 0x83, 0x55, 0xd3, 0x50, 0x30, 0x29, 0xcd,
      0x17, 0x25, 0xe2, 0xdd, 0x70, 0xa9, 0x06, 0x27, 0xdf, 0x66, 0xc0, 0x49,
      0x89, 0xe5, 0x41, 0xa5, 0x6d, 0xc7, 0xdf, 0x6a, 0x6a, 0x24, 0x17, 0x5d,
      0x92, 0x1e, 0xcd, 0xcf, 0xdc, 0xd0, 0xe8, 0xb4, 0x54, 0xde, 0x4a, 0x6e},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: salt is all 1
    // tcID: 70
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     70,
     32,
     {0x1d, 0x8b, 0xfd, 0xc0, 0xdd, 0xfb, 0x31, 0x2f, 0x4b, 0x90, 0x2b, 0xd2,
      0x41, 0xcb, 0x57, 0x50, 0xf8, 0x03, 0x12, 0x68, 0x8d, 0xaf, 0x5e, 0x29,
      0xec, 0x6f, 0xb8, 0xcb, 0x08, 0x5f, 0xc2, 0x97, 0x8b, 0x25, 0xf1, 0x01,
      0x48, 0x3e, 0x99, 0xd6, 0xc3, 0xa0, 0x4e, 0x7a, 0x66, 0xe8, 0x00, 0x25,
      0x7e, 0xcd, 0xe1, 0xef, 0x18, 0xc7, 0xba, 0x17, 0xee, 0xec, 0xd9, 0x4d,
      0x89, 0x24, 0x5d, 0x15, 0xa6, 0x69, 0x0b, 0xe9, 0xd6, 0x1f, 0xaa, 0x9c,
      0x94, 0xce, 0xfd, 0x06, 0xa2, 0x4a, 0xd2, 0x29, 0xf5, 0x21, 0x68, 0x8a,
      0xf4, 0x4a, 0x2b, 0x26, 0xf7, 0x26, 0x26, 0x86, 0x07, 0xa3, 0xe4, 0xc6,
      0x32, 0x28, 0x26, 0x1a, 0xc1, 0xbd, 0xfe, 0x71, 0x4f, 0xf0, 0x41, 0x4d,
      0x60, 0x29, 0x77, 0x2e, 0x53, 0x24, 0x37, 0x70, 0xd7, 0x35, 0xdb, 0xe2,
      0x11, 0xdf, 0x1c, 0xe9, 0x60, 0x56, 0x43, 0x14, 0x05, 0xc2, 0xc6, 0x12,
      0xce, 0x30, 0x79, 0x57, 0xc5, 0xe7, 0xa7, 0x61, 0x6b, 0xfe, 0x87, 0x71,
      0x48, 0x65, 0x0d, 0xe4, 0xef, 0x0b, 0x4c, 0xb3, 0x42, 0xaa, 0xbc, 0x93,
      0x15, 0xbe, 0xab, 0x5e, 0x33, 0xf5, 0x39, 0x86, 0xef, 0xa2, 0xb4, 0x9d,
      0xe1, 0x2b, 0x7d, 0xd1, 0xae, 0x36, 0x76, 0xba, 0x09, 0xa2, 0xae, 0xec,
      0x8c, 0x39, 0xc6, 0x5d, 0xd4, 0x4c, 0xe4, 0x08, 0xa8, 0xc8, 0x7d, 0x91,
      0xe2, 0x22, 0x5e, 0xe7, 0x76, 0xcc, 0x1d, 0x92, 0x4f, 0x35, 0x4b, 0xa2,
      0xe9, 0x1c, 0x0d, 0x52, 0xb5, 0x5f, 0xff, 0x4c, 0xcc, 0xa2, 0xcf, 0x6e,
      0xe7, 0x6e, 0xe6, 0xb9, 0x58, 0x8b, 0xa8, 0xf2, 0xd1, 0x61, 0x0a, 0x7c,
      0x7e, 0xc5, 0x20, 0x60, 0x2b, 0x37, 0xe2, 0x06, 0x09, 0x5e, 0x65, 0x8f,
      0xa1, 0x44, 0x39, 0x3d, 0xe3, 0xfa, 0x47, 0xd0, 0x48, 0xa0, 0x17, 0xed,
      0x93, 0xab, 0x89, 0xf8, 0x35, 0xb6, 0x3f, 0x82, 0x32, 0xc3, 0xf3, 0x1e,
      0xae, 0xab, 0xe7, 0x6a, 0x05, 0x6c, 0x53, 0xd8, 0x7f, 0x23, 0x49, 0x19,
      0x8c, 0x73, 0xcd, 0xbe, 0x9b, 0xc8, 0x90, 0x85, 0xf6, 0x10, 0xcb, 0xbe,
      0x5f, 0x5b, 0xa6, 0x5a, 0x01, 0x90, 0xd7, 0x33, 0x9f, 0x2c, 0x26, 0xa7,
      0xe3, 0x91, 0x3a, 0xa9, 0x8a, 0xca, 0x13, 0x8b, 0xd8, 0x7e, 0x61, 0x78,
      0xc1, 0x69, 0xd8, 0xa1, 0x20, 0xeb, 0x5e, 0x74, 0xc5, 0x1b, 0xf5, 0x04,
      0x02, 0x14, 0xef, 0xdc, 0xcf, 0x7f, 0x9f, 0xc6, 0x16, 0x24, 0x07, 0x90,
      0x81, 0xf9, 0xfa, 0xf9, 0xc7, 0x0b, 0x29, 0x4b, 0xce, 0x55, 0x89, 0x5e,
      0xef, 0x36, 0x27, 0xcf, 0xec, 0x1c, 0xbd, 0x48, 0x89, 0x40, 0xf7, 0xdc,
      0x5f, 0x34, 0xb3, 0x86, 0xfa, 0xc8, 0x6a, 0x56, 0x97, 0x60, 0xbd, 0x49,
      0x0e, 0x85, 0x6d, 0x36, 0x49, 0x12, 0xea, 0x35, 0x4d, 0x4a, 0xbd, 0x97},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: byte 0 in zero padding modified
    // tcID: 71
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     71,
     32,
     {0xb0, 0x1d, 0x88, 0xbd, 0xc0, 0xb6, 0x08, 0x6a, 0x22, 0xc3, 0xdd, 0xd9,
      0xb0, 0x4a, 0x4e, 0x4a, 0x95, 0xc3, 0xb2, 0x55, 0x0d, 0xc7, 0xe6, 0xc0,
      0x6e, 0x7a, 0x36, 0xab, 0x17, 0xec, 0xab, 0xfc, 0x56, 0x06, 0xa0, 0x6f,
      0x7a, 0xe7, 0xa0, 0xfe, 0x47, 0x23, 0x74, 0x3e, 0x40, 0x31, 0x12, 0xc7,
      0xfc, 0x08, 0x80, 0x0e, 0xcb, 0x68, 0x7a, 0x64, 0xde, 0x4b, 0xe5, 0xea,
      0x24, 0x82, 0x60, 0x0f, 0xbe, 0xb0, 0x1b, 0x46, 0xfc, 0x79, 0x9b, 0x42,
      0x06, 0xba, 0xcf, 0xfa, 0x8c, 0x38, 0xd2, 0x7c, 0x99, 0xca, 0xda, 0xa0,
      0xaf, 0x33, 0x3a, 0x80, 0x02, 0x82, 0x93, 0x98, 0xd1, 0x99, 0x6d, 0x1e,
      0x8f, 0x64, 0x68, 0x86, 0x70, 0xe3, 0x0f, 0x14, 0xe9, 0x6d, 0x99, 0x77,
      0x05, 0x6f, 0x31, 0x0f, 0xfa, 0xa9, 0xd1, 0x0b, 0x83, 0xd1, 0xc0, 0xee,
      0xc4, 0xd3, 0xd7, 0x3f, 0x64, 0xad, 0xaa, 0x34, 0x3f, 0xb8, 0xb2, 0x06,
      0xae, 0xeb, 0x29, 0x90, 0x34, 0x20, 0x13, 0xff, 0x42, 0xc7, 0x24, 0x2d,
      0xcf, 0x30, 0xf1, 0x65, 0x34, 0x88, 0xb4, 0x97, 0x6d, 0xff, 0x36, 0xa7,
      0x98, 0x53, 0xcb, 0xa1, 0xdd, 0x28, 0xc6, 0x44, 0x7e, 0x62, 0x6e, 0x14,
      0xa9, 0x24, 0x59, 0x36, 0x62, 0x08, 0xb7, 0xca, 0xdc, 0x54, 0x42, 0xc1,
      0xa0, 0xbf, 0x0d, 0x4d, 0x8b, 0xe6, 0xe3, 0x2d, 0x53, 0x06, 0x17, 0x31,
      0x12, 0x74, 0x2a, 0x87, 0x3e, 0x8c, 0x4d, 0xb7, 0x81, 0xcd, 0x36, 0x2b,
      0x4e, 0xf1, 0x98, 0xf3, 0x2c, 0x75, 0x0b, 0x44, 0xef, 0xfe, 0x3b, 0xcb,
      0x04, 0x48, 0x42, 0x6f, 0x09, 0x09, 0x41, 0xed, 0x4c, 0x15, 0x1c, 0x9b,
      0x75, 0x58, 0x8a, 0xc0, 0x86, 0x7a, 0x2f, 0x46, 0x8d, 0xc2, 0xfa, 0x46,
      0xf0, 0xbe, 0x77, 0x8a, 0x8d, 0x6f, 0x2b, 0xa0, 0x1f, 0xf4, 0x75, 0x34,
      0xc6, 0xd7, 0x1d, 0x62, 0x10, 0x9d, 0xea, 0x67, 0x41, 0xc6, 0x01, 0x42,
      0x58, 0x0a, 0x1f, 0x4e, 0x22, 0xb1, 0x76, 0x12, 0x00, 0xf4, 0xf1, 0x59,
      0x99, 0x70, 0xe1, 0xc4, 0x56, 0x49, 0x6f, 0xf8, 0x25, 0x25, 0x08, 0x5c,
      0x0a, 0x12, 0xee, 0xa8, 0xc4, 0x12, 0xb9, 0x29, 0xbb, 0x18, 0x73, 0xcd,
      0x7d, 0xbb, 0x2a, 0xb3, 0x5b, 0x9e, 0xef, 0x30, 0x9d, 0x9f, 0x06, 0x17,
      0xfd, 0x37, 0xfb, 0x3c, 0x56, 0xa5, 0xbc, 0x84, 0xd9, 0x65, 0x09, 0x8d,
      0xd6, 0xb0, 0xc0, 0x58, 0x90, 0x8f, 0x9c, 0xbd, 0xe6, 0x85, 0x8f, 0x0d,
      0x07, 0x34, 0x72, 0x6c, 0x59, 0x3f, 0x2b, 0xce, 0xc3, 0x22, 0x36, 0x74,
      0x1e, 0x11, 0x0a, 0xcb, 0x9d, 0x53, 0x6a, 0x79, 0x42, 0xf6, 0x7f, 0x4c,
      0x8a, 0x4b, 0x06, 0x47, 0x82, 0x29, 0xba, 0xb0, 0x9e, 0x8a, 0x3e, 0xc7,
      0x39, 0x30, 0xb7, 0x5e, 0x82, 0xfd, 0x4a, 0xc8, 0xe4, 0x66, 0xfa, 0x5b},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: byte 7 in zero padding modified
    // tcID: 72
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     72,
     32,
     {0x52, 0xc6, 0x36, 0xd9, 0x1f, 0x3a, 0x8c, 0x26, 0x9e, 0xa2, 0xbe, 0x76,
      0x72, 0x93, 0xa3, 0x25, 0xa7, 0xad, 0xdd, 0x7b, 0x10, 0x26, 0x25, 0x1d,
      0x45, 0xc1, 0xe9, 0x9d, 0x81, 0x8f, 0x6f, 0x8b, 0x1d, 0x52, 0x30, 0x67,
      0x68, 0xd1, 0x63, 0xb9, 0xd0, 0xde, 0x36, 0x00, 0xe1, 0x8b, 0x8e, 0x6f,
      0xc3, 0xd9, 0xe8, 0x74, 0xcc, 0xfc, 0xef, 0x45, 0xe4, 0x01, 0x1e, 0xba,
      0xcf, 0x35, 0x00, 0xe7, 0x12, 0xf3, 0x68, 0x63, 0xe5, 0x3c, 0xb0, 0x1d,
      0xb1, 0x74, 0x97, 0x98, 0x94, 0x1d, 0x55, 0x74, 0x28, 0xac, 0x01, 0x7d,
      0x22, 0xbe, 0x75, 0x3e, 0xb4, 0x01, 0xdf, 0x9a, 0x96, 0x26, 0x11, 0x26,
      0xb0, 0x17, 0xbc, 0xea, 0xdb, 0x8a, 0x58, 0xe2, 0xd8, 0x5b, 0xd5, 0x17,
      0x97, 0xe5, 0x9c, 0xf9, 0xb3, 0x4b, 0x9a, 0x42, 0xad, 0x90, 0xea, 0x44,
      0x1d, 0xa5, 0x8f, 0xd9, 0x86, 0xe0, 0x23, 0xd5, 0xf6, 0x17, 0x49, 0x8b,
      0xe1, 0x30, 0x45, 0x52, 0xcb, 0x6f, 0x3b, 0x27, 0xa4, 0x4a, 0x6d, 0xc9,
      0x28, 0x9a, 0x29, 0xf1, 0x0b, 0xa8, 0x79, 0xc8, 0x2c, 0xcf, 0xba, 0xf7,
      0x46, 0x8f, 0x65, 0xff, 0xd1, 0xd9, 0xb1, 0xf4, 0x4f, 0x60, 0x48, 0x0a,
      0x87, 0x43, 0xe4, 0x11, 0x0a, 0x45, 0x4d, 0x6b, 0x88, 0xf8, 0xf6, 0x87,
      0x0a, 0x32, 0x33, 0x65, 0x10, 0xa0, 0xe9, 0x67, 0xb3, 0x52, 0xb5, 0xf7,
      0x3b, 0xd6, 0xa8, 0xf3, 0x9c, 0xa6, 0xf4, 0x0b, 0x65, 0xc0, 0x16, 0x14,
      0x9a, 0xb7, 0x44, 0x94, 0x52, 0xa5, 0x9e, 0xc8, 0x7d, 0xfa, 0xae, 0xf3,
      0x3f, 0xed, 0x36, 0xf1, 0x75, 0x9d, 0xc4, 0x48, 0x5b, 0x63, 0xee, 0x30,
      0x2d, 0x30, 0x24, 0x41, 0x50, 0x2c, 0x61, 0xb1, 0xd8, 0x42, 0x78, 0x43,
      0x08, 0x0d, 0x96, 0x83, 0x41, 0x87, 0x3b, 0x27, 0x29, 0x91, 0xa0, 0xec,
      0xf9, 0xc1, 0x9d, 0x6f, 0x37, 0x17, 0x0c, 0xa7, 0xcd, 0xb8, 0xa3, 0x06,
      0x8a, 0xcc, 0x8d, 0x6a, 0x7a, 0xa4, 0xe8, 0xa3, 0x3e, 0xf4, 0x63, 0x09,
      0x7a, 0x79, 0x78, 0xdf, 0xee, 0xa1, 0x40, 0x18, 0x73, 0x26, 0x72, 0xdf,
      0x9a, 0x12, 0x4f, 0x7b, 0x31, 0x64, 0xf3, 0xcc, 0xc5, 0x27, 0xa8, 0xc0,
      0xd7, 0xa2, 0xd7, 0x5a, 0xbc, 0x03, 0xef, 0xce, 0x9a, 0xdb, 0xa2, 0x96,
      0x55, 0x8f, 0xbb, 0x11, 0x10, 0xb4, 0xc6, 0xe7, 0xc8, 0xf7, 0x95, 0x2f,
      0x67, 0xbc, 0x55, 0x82, 0x19, 0xd2, 0xa8, 0x36, 0xc6, 0x73, 0x46, 0x7a,
      0x49, 0x95, 0x14, 0x0d, 0x9d, 0x7c, 0xc3, 0x77, 0xad, 0xca, 0x98, 0x98,
      0xf8, 0xac, 0xe6, 0x44, 0x6f, 0xeb, 0x50, 0xe5, 0xb7, 0x44, 0xf7, 0x6a,
      0x7f, 0x75, 0xf1, 0x03, 0xb6, 0x54, 0x09, 0x6f, 0xd2, 0x90, 0x2f, 0xd8,
      0x63, 0x45, 0x2a, 0xb4, 0xbc, 0x0f, 0x89, 0xc4, 0x57, 0xbf, 0x1a, 0xba},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes in zero padding modified
    // tcID: 73
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     73,
     32,
     {0xbc, 0xf0, 0xf1, 0x16, 0x94, 0xa2, 0xa7, 0x07, 0x89, 0x84, 0x54, 0xa8,
      0x16, 0x25, 0xb8, 0x3e, 0x3f, 0xe9, 0xa9, 0x61, 0x55, 0xef, 0xad, 0x7c,
      0xac, 0xd0, 0x49, 0xc3, 0x48, 0xc2, 0x3e, 0xb7, 0x28, 0xfc, 0xb3, 0xea,
      0xf3, 0x95, 0x01, 0x56, 0x57, 0x05, 0x91, 0x29, 0x32, 0x8f, 0x19, 0xf6,
      0xe4, 0x4f, 0x05, 0x0d, 0x10, 0x78, 0x3a, 0xdf, 0xa3, 0x84, 0xf2, 0x0c,
      0x25, 0xac, 0x54, 0x5c, 0x38, 0x77, 0x1a, 0x0c, 0x46, 0xc9, 0x72, 0x4a,
      0x00, 0x08, 0x68, 0x04, 0x3d, 0x60, 0xcb, 0x9c, 0x68, 0x85, 0x95, 0xc1,
      0x34, 0x02, 0x2a, 0x0b, 0x6e, 0x99, 0xd5, 0x94, 0x58, 0x1f, 0x94, 0x63,
      0x8d, 0x24, 0xcf, 0xf6, 0x74, 0xa1, 0xf2, 0xeb, 0xc7, 0x7c, 0x0d, 0x13,
      0xa8, 0xdb, 0xd6, 0x18, 0x48, 0xbb, 0x05, 0x95, 0xc6, 0xe2, 0x01, 0x60,
      0x8f, 0x00, 0xc7, 0x5c, 0x5c, 0xec, 0x3d, 0x30, 0x91, 0xbd, 0xaa, 0xf5,
      0xd9, 0xc7, 0xcc, 0x60, 0x33, 0x75, 0x91, 0xed, 0xf4, 0x85, 0x0e, 0x7b,
      0x78, 0x2d, 0x45, 0x29, 0x2b, 0xaa, 0x16, 0x5d, 0x99, 0xa8, 0x11, 0xd7,
      0x9f, 0xbd, 0xd7, 0x5d, 0x83, 0x89, 0xa2, 0x70, 0x50, 0x7d, 0x3e, 0xb2,
      0x6d, 0x5c, 0x24, 0x0e, 0xf0, 0x08, 0x69, 0xd9, 0x10, 0x88, 0x3c, 0xcb,
      0x54, 0x36, 0xb3, 0x69, 0x07, 0xa8, 0x2e, 0x40, 0x58, 0xb5, 0xa2, 0xc6,
      0xa2, 0x7e, 0x09, 0x2e, 0xf4, 0xcd, 0xcd, 0x5c, 0x98, 0xbb, 0x41, 0x0b,
      0xf2, 0x29, 0xd8, 0xfe, 0x95, 0x20, 0x55, 0x9e, 0x81, 0x67, 0xc0, 0xb1,
      0xfd, 0x3b, 0x94, 0x63, 0x22, 0x09, 0xbf, 0xe0, 0x33, 0x28, 0x92, 0xf8,
      0x79, 0xf2, 0x5a, 0xfb, 0xba, 0x6f, 0xb6, 0x7c, 0xb1, 0xdf, 0xc2, 0x25,
      0x74, 0x6d, 0xf6, 0x18, 0xad, 0xa7, 0x4a, 0x2c, 0x08, 0x5b, 0xdb, 0xae,
      0xc3, 0xb4, 0xf6, 0xd6, 0x75, 0x50, 0x4a, 0xf6, 0x22, 0x1d, 0xdd, 0x35,
      0xdb, 0x01, 0x82, 0x9d, 0xf1, 0xfd, 0x38, 0x62, 0x36, 0xdf, 0x6e, 0xe4,
      0x76, 0xa3, 0x66, 0x01, 0x78, 0xa7, 0x40, 0x8d, 0xff, 0x69, 0xa8, 0x6f,
      0xeb, 0x52, 0x2c, 0xbe, 0xdf, 0x7f, 0xf8, 0x66, 0xd5, 0x87, 0x8b, 0xca,
      0xf1, 0x9e, 0x82, 0xf0, 0x9b, 0xfe, 0x2e, 0x6d, 0x33, 0xb4, 0xfb, 0x70,
      0xe1, 0x46, 0x7c, 0xac, 0xee, 0xea, 0xe4, 0xe5, 0xe0, 0xd8, 0xc8, 0x1b,
      0x0a, 0x7d, 0x3e, 0x17, 0xec, 0x59, 0x4c, 0x9b, 0xe9, 0xc9, 0xec, 0x51,
      0xc2, 0x3a, 0xae, 0x99, 0xc8, 0x1f, 0xe9, 0x19, 0xd9, 0x42, 0xde, 0x16,
      0x7e, 0xee, 0x37, 0x0c, 0x60, 0x55, 0x64, 0xb8, 0xdb, 0xf1, 0xfe, 0xe8,
      0x60, 0xc6, 0xe0, 0x52, 0xa2, 0x80, 0xc7, 0x19, 0x0f, 0xda, 0x3c, 0x2f,
      0x8c, 0x1f, 0x40, 0x1e, 0x82, 0xc4, 0xdc, 0x1d, 0x67, 0xc7, 0x3e, 0x78},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of hash h modified
    // tcID: 74
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     74,
     32,
     {0x58, 0x38, 0x4f, 0xb4, 0x3a, 0xfc, 0xcf, 0x19, 0xcd, 0xd0, 0x0c, 0x20,
      0x06, 0xd5, 0xa6, 0xbd, 0xd1, 0x2a, 0x5a, 0xc1, 0x49, 0xba, 0x6b, 0x21,
      0xd5, 0xdb, 0xfc, 0xa1, 0xb3, 0x94, 0x62, 0x40, 0x07, 0xfa, 0x5a, 0x72,
      0x9a, 0x8d, 0x4e, 0x30, 0x8d, 0xaa, 0xce, 0xce, 0x63, 0x65, 0x46, 0x06,
      0xe9, 0xbe, 0x32, 0xae, 0x81, 0x84, 0xce, 0x9a, 0xa2, 0x37, 0xcd, 0xeb,
      0x44, 0xce, 0x1c, 0x96, 0x1a, 0x45, 0x98, 0x19, 0x2a, 0x60, 0x9d, 0x1e,
      0xdc, 0xe2, 0xb9, 0xa9, 0xb8, 0x94, 0x4c, 0xff, 0x2c, 0x9b, 0xfe, 0xec,
      0x9e, 0x2f, 0xe6, 0xc7, 0x88, 0x7f, 0x04, 0xe1, 0x91, 0x1d, 0x7f, 0xdc,
      0x99, 0x4c, 0xdc, 0xc5, 0xc1, 0x28, 0x2b, 0xbb, 0x2a, 0x51, 0x9d, 0x4e,
      0x64, 0x33, 0xbf, 0x08, 0x77, 0x90, 0xc8, 0x83, 0x3f, 0xc6, 0x3e, 0x92,
      0x36, 0x46, 0x31, 0x21, 0xad, 0xe0, 0x94, 0xe0, 0x82, 0xd7, 0x2a, 0x45,
      0x6e, 0xf9, 0xea, 0xf9, 0x28, 0xb2, 0xd3, 0x8a, 0x72, 0x74, 0xb2, 0x3a,
      0x51, 0x36, 0x11, 0x8e, 0x82, 0xb8, 0x97, 0x41, 0x4b, 0xb6, 0xcd, 0x01,
      0x77, 0x29, 0x8a, 0xac, 0x69, 0x70, 0xf1, 0x79, 0x40, 0x3d, 0x15, 0x25,
      0x53, 0xfc, 0x2d, 0x7e, 0x13, 0xe4, 0x0c, 0x3b, 0x48, 0x75, 0xe6, 0xbc,
      0x3f, 0xda, 0x90, 0x45, 0x82, 0xee, 0x49, 0x81, 0x7f, 0x39, 0xe3, 0xc7,
      0x9b, 0x8e, 0xf7, 0x01, 0x05, 0xde, 0x88, 0x38, 0x74, 0x84, 0x59, 0x50,
      0x59, 0x45, 0x3f, 0x9f, 0x57, 0xb5, 0x2f, 0x1e, 0x79, 0xf5, 0x22, 0x6e,
      0xa2, 0xf8, 0x16, 0x8e, 0x2e, 0x48, 0xde, 0x1d, 0x0d, 0x54, 0x4d, 0xaa,
      0xd2, 0x05, 0xf6, 0xc3, 0x2a, 0x68, 0x65, 0xf6, 0x6a, 0xcd, 0x4b, 0x31,
      0x88, 0x34, 0x74, 0x15, 0x53, 0xcb, 0x1b, 0xce, 0x7a, 0x7c, 0x06, 0xe4,
      0xc3, 0x3c, 0xf5, 0x1e, 0xab, 0xcb, 0xbe, 0x44, 0x62, 0x6f, 0x53, 0xf7,
      0xa2, 0x72, 0x9c, 0xef, 0xda, 0x59, 0xec, 0xba, 0x55, 0xff, 0xb4, 0xbc,
      0xcb, 0x74, 0x6d, 0xbd, 0x76, 0x89, 0xe7, 0xf3, 0xc1, 0xf2, 0x9a, 0x6f,
      0x26, 0x18, 0x0f, 0xdf, 0xb1, 0x43, 0xb1, 0x6d, 0x10, 0xe5, 0x8c, 0x72,
      0xd4, 0xf8, 0xab, 0xb3, 0xdc, 0x3d, 0x35, 0xca, 0xbe, 0xbe, 0x79, 0x28,
      0xb5, 0xd6, 0x1d, 0x5c, 0x1c, 0x9b, 0xed, 0x92, 0x2b, 0xd4, 0x4b, 0xad,
      0xf9, 0xdb, 0x2f, 0x0e, 0x29, 0xf5, 0x4d, 0x95, 0x0a, 0x99, 0x78, 0xb1,
      0x40, 0x8a, 0x29, 0x35, 0xc6, 0xab, 0x9e, 0x24, 0x91, 0xbb, 0x06, 0x24,
      0xa8, 0x88, 0xd3, 0x06, 0x69, 0x2f, 0xcf, 0x71, 0xe4, 0xc9, 0x3b, 0xfd,
      0x38, 0xce, 0x65, 0x90, 0xe0, 0x22, 0xc8, 0xe5, 0xbe, 0xf0, 0xa9, 0xb5,
      0xa3, 0x15, 0x2e, 0xdc, 0xc6, 0x1c, 0x7a, 0xb8, 0xbd, 0xee, 0xf2, 0x19},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of hash h modified
    // tcID: 75
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     75,
     32,
     {0x4e, 0x71, 0xb9, 0x2c, 0x27, 0xa2, 0x2e, 0x50, 0x03, 0xc8, 0xff, 0x63,
      0x97, 0x20, 0xb5, 0xb8, 0x09, 0xb3, 0x4f, 0x1f, 0x27, 0x97, 0x13, 0x5b,
      0xb4, 0xce, 0x06, 0xa7, 0xd1, 0xf6, 0x56, 0x9c, 0x5c, 0xc4, 0x91, 0x0d,
      0x7c, 0xd0, 0xbb, 0xb1, 0x5e, 0xc6, 0xd0, 0xcb, 0xeb, 0x56, 0x12, 0xeb,
      0x96, 0x45, 0xea, 0xb2, 0x05, 0x13, 0x0e, 0x3c, 0xf0, 0x4a, 0x00, 0x11,
      0xf5, 0x67, 0x28, 0xeb, 0x44, 0x7d, 0x26, 0xdc, 0x77, 0xa4, 0xec, 0xab,
      0xa3, 0x96, 0xae, 0x84, 0xff, 0x14, 0x81, 0x42, 0x2d, 0x83, 0xe4, 0x41,
      0x8f, 0x48, 0x58, 0xcf, 0x66, 0x39, 0xb8, 0x31, 0x10, 0x5d, 0x0f, 0x8c,
      0x42, 0x8f, 0xa9, 0xdc, 0x69, 0xe3, 0x80, 0xdc, 0xd7, 0x7d, 0x8d, 0x30,
      0xc3, 0x62, 0xb1, 0xca, 0x06, 0x7b, 0xba, 0xf1, 0x24, 0xaa, 0xaa, 0x0b,
      0x0c, 0xe4, 0xbb, 0xe9, 0xaf, 0xa7, 0xf2, 0x78, 0x7b, 0x6b, 0x8c, 0x47,
      0x6b, 0x61, 0x39, 0x96, 0x0e, 0x1b, 0x43, 0x6f, 0x8b, 0x13, 0xa1, 0xb8,
      0x5f, 0xfa, 0xd3, 0x82, 0xe3, 0x16, 0x22, 0x32, 0x61, 0xd7, 0xe7, 0xa5,
      0xf2, 0x30, 0x0c, 0xfc, 0x04, 0xe5, 0x19, 0x57, 0xea, 0x4a, 0x0a, 0x65,
      0xd1, 0x95, 0x96, 0xc3, 0x03, 0x42, 0x39, 0xb8, 0xbf, 0x8f, 0x0b, 0xea,
      0x6f, 0x0d, 0x6d, 0x74, 0x9e, 0x2d, 0x3d, 0xf8, 0x24, 0x1e, 0x46, 0x22,
      0x20, 0x4c, 0x33, 0x4c, 0xd7, 0x48, 0xc4, 0xd0, 0x25, 0x4f, 0xac, 0x93,
      0xdb, 0x64, 0xfb, 0xba, 0xf7, 0x9e, 0xca, 0xd1, 0x2a, 0xd1, 0x9c, 0x74,
      0xd9, 0x44, 0x97, 0x07, 0x79, 0xa6, 0x40, 0x11, 0x35, 0xa5, 0xa8, 0xcb,
      0xb3, 0x2b, 0x63, 0x34, 0x98, 0x8d, 0xf3, 0x42, 0x4c, 0x39, 0x93, 0xc1,
      0x57, 0x62, 0x09, 0x88, 0xae, 0xe3, 0xbf, 0x27, 0x6e, 0xca, 0x44, 0xda,
      0xaa, 0x53, 0x70, 0x26, 0x5a, 0x6d, 0xdb, 0xce, 0xe5, 0xd2, 0x07, 0x67,
      0x0c, 0x0d, 0x46, 0xd5, 0x55, 0x02, 0x7c, 0x18, 0x54, 0xba, 0x92, 0x21,
      0xbb, 0x86, 0xdc, 0xc4, 0xdf, 0x2f, 0xa8, 0xe9, 0x98, 0x33, 0xe3, 0x62,
      0x14, 0x7c, 0x8d, 0x2c, 0x45, 0x98, 0xf4, 0x67, 0xd0, 0xff, 0xb8, 0xce,
      0xb1, 0x8c, 0x91, 0x87, 0x51, 0x1b, 0x41, 0x35, 0xea, 0x06, 0x8d, 0x99,
      0x61, 0xbd, 0x07, 0xee, 0x0f, 0xe5, 0x6b, 0x7d, 0xab, 0xb2, 0x22, 0xac,
      0x54, 0x27, 0x46, 0xda, 0xa4, 0xa4, 0x5c, 0xfd, 0x77, 0xf0, 0x21, 0x3f,
      0x7e, 0x5b, 0xcd, 0xbf, 0xeb, 0xb5, 0xa4, 0xad, 0x18, 0xd7, 0x9a, 0x59,
      0x9d, 0x07, 0x55, 0xdb, 0xaa, 0xa1, 0x9f, 0xd0, 0x3f, 0x4b, 0xd8, 0xcf,
      0x9c, 0x7c, 0x84, 0x16, 0xc1, 0x4d, 0x23, 0xb0, 0xca, 0x54, 0xde, 0x5f,
      0x04, 0x92, 0xd2, 0xd9, 0xce, 0xd1, 0xc8, 0xb5, 0xcb, 0x79, 0xcc, 0xb5},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of hash h modified
    // tcID: 76
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     76,
     32,
     {0x1a, 0x9f, 0x21, 0xdb, 0x6f, 0x3f, 0xe4, 0x15, 0xa3, 0x44, 0xb6, 0x1d,
      0xb7, 0x6e, 0xbf, 0x60, 0xa8, 0x4f, 0xf0, 0xdf, 0x70, 0xec, 0xb5, 0xcd,
      0x14, 0xa1, 0x6a, 0xaf, 0xdb, 0xfb, 0xf8, 0x95, 0x30, 0x3d, 0x9e, 0xb8,
      0x31, 0xd7, 0xa9, 0xbe, 0xd8, 0x9e, 0xe3, 0xca, 0x73, 0x7f, 0x49, 0x64,
      0x3b, 0x07, 0x7a, 0x82, 0x4d, 0xc3, 0xf4, 0x33, 0xc0, 0x0e, 0xf1, 0xb6,
      0x93, 0xf8, 0x2d, 0x30, 0x44, 0x9f, 0xcd, 0x32, 0x3a, 0x48, 0xc8, 0x4c,
      0xc5, 0xaf, 0x37, 0x5d, 0x7b, 0xfa, 0x2d, 0x3a, 0xd8, 0x82, 0x48, 0x02,
      0x25, 0xfe, 0x4a, 0x6a, 0xdf, 0x05, 0xc0, 0x34, 0x1a, 0x79, 0x13, 0xab,
      0x93, 0x1b, 0xd0, 0x85, 0x13, 0x4f, 0xe4, 0x70, 0x00, 0x3d, 0x3a, 0x61,
      0x2d, 0x88, 0xff, 0x0d, 0xa5, 0x4a, 0xf1, 0xbe, 0xde, 0x6b, 0xfd, 0x58,
      0xf1, 0x99, 0x01, 0xde, 0x43, 0xba, 0x61, 0xc7, 0x2d, 0x5f, 0x96, 0x30,
      0x2b, 0x64, 0x28, 0xbf, 0x03, 0x84, 0x7d, 0x54, 0xec, 0x1d, 0x74, 0x92,
      0x17, 0x87, 0xba, 0x1f, 0xed, 0xc4, 0x80, 0x60, 0x5f, 0xcb, 0x45, 0xb7,
      0x4d, 0x37, 0xdd, 0x0a, 0xbb, 0x40, 0x67, 0xf9, 0x7e, 0x28, 0xcc, 0xbb,
      0x86, 0xbc, 0x0a, 0x1c, 0x05, 0xee, 0xb6, 0x58, 0x29, 0x84, 0x60, 0x6b,
      0xe2, 0x15, 0x74, 0xbb, 0xb7, 0xbc, 0x04, 0xed, 0xef, 0x52, 0x8a, 0x85,
      0x81, 0xeb, 0x13, 0x5e, 0x97, 0x1c, 0x6d, 0xbb, 0xa2, 0x1b, 0x11, 0x55,
      0xe7, 0x77, 0xda, 0x9f, 0x6c, 0x6a, 0xc1, 0x82, 0xb4, 0xde, 0x0c, 0x9e,
      0xbf, 0xbc, 0x59, 0xc7, 0x1e, 0xe6, 0x68, 0x8d, 0x9b, 0x05, 0x4c, 0xf7,
      0x77, 0x2f, 0x59, 0x6f, 0xc9, 0xf6, 0xe8, 0x7b, 0xca, 0x4e, 0xe8, 0xdf,
      0x7d, 0x62, 0x67, 0xe2, 0x98, 0x24, 0xb1, 0xa7, 0x08, 0x40, 0xc6, 0x9e,
      0x1d, 0x16, 0x28, 0x58, 0xec, 0xe7, 0xde, 0x3b, 0xf0, 0x80, 0x72, 0xf5,
      0xca, 0xaa, 0xdd, 0x1b, 0x8c, 0x66, 0x17, 0xfa, 0x78, 0x88, 0xbd, 0x5e,
      0x9d, 0x53, 0x67, 0xbe, 0x06, 0x4c, 0xc8, 0x2a, 0xc4, 0xb5, 0x9b, 0x24,
      0x0e, 0x0e, 0x73, 0x97, 0x06, 0x04, 0x17, 0xe6, 0x38, 0x6a, 0x62, 0x3c,
      0x96, 0xbc, 0x7f, 0x9b, 0xc1, 0xda, 0x43, 0x65, 0xe0, 0x8c, 0x22, 0xcb,
      0xdd, 0x2e, 0xf1, 0xa4, 0xa7, 0x7d, 0xfe, 0xf4, 0xbb, 0xb3, 0xe4, 0xcb,
      0xee, 0xe7, 0x01, 0x2c, 0x25, 0xce, 0x52, 0xce, 0xef, 0xa1, 0x8b, 0xf5,
      0x05, 0x65, 0x83, 0x10, 0x90, 0x30, 0xf9, 0x1d, 0x92, 0xde, 0x82, 0x00,
      0xf3, 0xb2, 0x02, 0xef, 0xb9, 0xcf, 0x58, 0xd3, 0x75, 0xdf, 0x1d, 0xfe,
      0xe6, 0x99, 0x58, 0x62, 0x98, 0xb9, 0xee, 0xf0, 0xd1, 0xe9, 0x94, 0x66,
      0xbd, 0x47, 0xa0, 0xd1, 0x28, 0xfb, 0x90, 0x89, 0xec, 0x6c, 0x87, 0xe9},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of hash h modified
    // tcID: 77
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     77,
     32,
     {0x70, 0xda, 0xb9, 0xab, 0xa4, 0x5e, 0x87, 0x81, 0x1d, 0x66, 0x7c, 0x5e,
      0x83, 0x24, 0xd1, 0xf0, 0xcc, 0x50, 0x07, 0x1c, 0x30, 0x6e, 0x68, 0x77,
      0xac, 0xfb, 0x9a, 0x58, 0xe4, 0xb7, 0x47, 0x98, 0xb1, 0x93, 0x15, 0x90,
      0x21, 0x87, 0x5e, 0x18, 0xdd, 0xe2, 0x42, 0xa5, 0x1c, 0x38, 0x85, 0xcc,
      0x51, 0x57, 0x3a, 0x95, 0xee, 0xe4, 0x02, 0x9f, 0x66, 0x32, 0x22, 0xe0,
      0xfe, 0xfd, 0x68, 0xcd, 0x4f, 0xa7, 0x1c, 0x6f, 0xca, 0x4e, 0xe8, 0xe2,
      0x87, 0x6e, 0x62, 0xbf, 0x82, 0x11, 0xe0, 0x98, 0x6b, 0x4e, 0x1e, 0x7a,
      0xfb, 0x2c, 0x19, 0xdd, 0xd5, 0xe4, 0xe1, 0x84, 0xa7, 0x7c, 0xb1, 0x1a,
      0x04, 0x5f, 0x77, 0xbd, 0x26, 0x22, 0x66, 0x57, 0x32, 0xd1, 0x67, 0x41,
      0x11, 0x16, 0x69, 0x24, 0xfa, 0xf5, 0xb9, 0x35, 0xeb, 0x2b, 0xf4, 0xac,
      0x8c, 0xd4, 0x7b, 0x63, 0xac, 0x00, 0x78, 0xc5, 0xec, 0x05, 0xd4, 0xde,
      0xdc, 0x91, 0x59, 0x5c, 0x2b, 0x3f, 0x5c, 0x8d, 0xc3, 0x99, 0x05, 0x1e,
      0xd0, 0x65, 0x44, 0x01, 0xca, 0xe2, 0x01, 0x28, 0xc3, 0xda, 0xb2, 0x8e,
      0x76, 0x68, 0xb0, 0x5b, 0x4d, 0xa6, 0x24, 0xfb, 0xfa, 0xb8, 0x3e, 0x42,
      0x50, 0x31, 0xc8, 0xb8, 0xf4, 0xbb, 0x76, 0xb7, 0x8e, 0x2e, 0x66, 0x6e,
      0xb8, 0x54, 0xb0, 0xaf, 0x34, 0x20, 0x11, 0xa5, 0xe1, 0x9b, 0xb2, 0x52,
      0xf9, 0x0a, 0x94, 0xef, 0x9c, 0x91, 0x6a, 0x94, 0x5e, 0x3e, 0x1f, 0xa9,
      0x26, 0x63, 0x94, 0x25, 0xc2, 0xe2, 0x95, 0x45, 0x33, 0xfd, 0xab, 0x1f,
      0x6b, 0x94, 0x46, 0x50, 0x24, 0x94, 0x78, 0x79, 0x23, 0x39, 0xd9, 0xb2,
      0xf7, 0x7b, 0x46, 0xb0, 0x94, 0xc9, 0x86, 0x72, 0x00, 0x29, 0xe0, 0x40,
      0xc5, 0xc6, 0xb7, 0xc1, 0x4b, 0x77, 0x7f, 0xc9, 0xa1, 0x64, 0x00, 0x4a,
      0x5b, 0x01, 0x1b, 0x15, 0xce, 0x6c, 0xab, 0x8d, 0x08, 0x0f, 0x9a, 0x00,
      0x65, 0x46, 0xbe, 0x01, 0x05, 0x91, 0xc6, 0x38, 0xd6, 0x01, 0xd7, 0x75,
      0x63, 0x7f, 0x2e, 0xd7, 0xab, 0x94, 0xcc, 0x78, 0x6b, 0x05, 0xe0, 0xea,
      0x7b, 0x0b, 0x0b, 0x4c, 0x7d, 0x1c, 0x73, 0x0d, 0xe9, 0x3f, 0xec, 0x53,
      0x80, 0xc1, 0xfa, 0x76, 0x50, 0x1f, 0x7e, 0x3a, 0x8e, 0xeb, 0x26, 0x28,
      0x7b, 0x27, 0xfc, 0xa1, 0x7c, 0x30, 0x95, 0x28, 0x93, 0x13, 0x6a, 0x5c,
      0x12, 0xc4, 0x81, 0x63, 0xc9, 0xe7, 0x79, 0x61, 0x54, 0xb0, 0xb2, 0xd6,
      0xcc, 0x7a, 0x5d, 0x94, 0x91, 0xa9, 0xc7, 0x77, 0xe6, 0xd3, 0x8c, 0x60,
      0x41, 0x3c, 0x5d, 0xfe, 0x92, 0x19, 0x62, 0xeb, 0xad, 0x11, 0xfc, 0x67,
      0x71, 0xee, 0x4f, 0x3c, 0xef, 0x2a, 0x27, 0x17, 0xa7, 0x8b, 0xb6, 0xae,
      0x08, 0x95, 0x16, 0x08, 0x18, 0x88, 0x17, 0x98, 0xb5, 0x8d, 0x05, 0x95},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes of h replaced by 0
    // tcID: 78
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     78,
     32,
     {0x9f, 0x8d, 0x0b, 0x7f, 0xc6, 0x93, 0x4a, 0x3e, 0xb7, 0xec, 0x6f, 0xeb,
      0x90, 0xbc, 0x8e, 0xd2, 0xc4, 0x57, 0xee, 0xac, 0x96, 0x4f, 0x0f, 0xa9,
      0xce, 0x89, 0x24, 0x21, 0x8c, 0x5d, 0xd3, 0x8c, 0xe8, 0x50, 0x83, 0xe6,
      0x57, 0xbb, 0xd1, 0x9c, 0xe6, 0xd6, 0xdd, 0xb5, 0x42, 0x23, 0x15, 0xc0,
      0x67, 0xea, 0x83, 0x07, 0x38, 0x1c, 0x72, 0x75, 0xe9, 0x75, 0x7f, 0x11,
      0xf9, 0x47, 0x23, 0xbe, 0xd3, 0xa1, 0x74, 0x72, 0x85, 0x55, 0xde, 0xa4,
      0x5c, 0x8d, 0xeb, 0x32, 0x65, 0x87, 0x9d, 0x95, 0xf0, 0x05, 0xd6, 0xbb,
      0xfb, 0x4c, 0x75, 0xec, 0xc7, 0x45, 0x2a, 0x20, 0xb9, 0x23, 0xf7, 0x8d,
      0x68, 0x1a, 0x01, 0x0a, 0x2c, 0x5d, 0x15, 0x19, 0x84, 0x13, 0x83, 0xcf,
      0xa8, 0xb2, 0x99, 0xab, 0x60, 0xdb, 0x09, 0x90, 0x5a, 0xe9, 0x91, 0x4c,
      0x7c, 0xcf, 0x1d, 0x1b, 0xcb, 0x57, 0x8e, 0xed, 0xe6, 0x3d, 0xa1, 0x2a,
      0xb0, 0xb1, 0x62, 0x31, 0xdd, 0x40, 0xf3, 0xe7, 0x56, 0xa3, 0xee, 0x84,
      0x71, 0x6c, 0x64, 0xdb, 0x34, 0x8b, 0x1b, 0xc3, 0xfd, 0x49, 0xdc, 0xe7,
      0xbe, 0xe9, 0x8a, 0x16, 0xa1, 0xf6, 0xd9, 0x19, 0x0d, 0x57, 0xb9, 0x40,
      0xa2, 0x65, 0xa3, 0x1f, 0x82, 0x98, 0xbe, 0xb1, 0xa1, 0xf7, 0x59, 0xbe,
      0x17, 0x72, 0x4c, 0x5f, 0x91, 0x1c, 0xa1, 0xd8, 0xbc, 0x9f, 0x22, 0x33,
      0xed, 0xdb, 0x09, 0xfe, 0x51, 0xd2, 0xd3, 0x6e, 0xd1, 0x97, 0x6f, 0x04,
      0x31, 0xf0, 0x6b, 0x8f, 0xfa, 0x84, 0x81, 0x05, 0xbf, 0x01, 0x9d, 0x30,
      0xd7, 0xd8, 0xd0, 0x53, 0x03, 0xda, 0xeb, 0xb5, 0x69, 0x80, 0xd1, 0xa6,
      0x96, 0xf1, 0xdc, 0x92, 0x24, 0x16, 0x49, 0x32, 0xdf, 0xd1, 0x19, 0xe8,
      0xdb, 0x7b, 0x87, 0xe4, 0x4e, 0x0d, 0xcf, 0xa1, 0xb7, 0x6a, 0xa2, 0xdf,
      0xba, 0x2b, 0xeb, 0xa0, 0x2f, 0x14, 0xd1, 0x41, 0x0d, 0xfd, 0xed, 0xd2,
      0x78, 0x32, 0xc0, 0x38, 0x40, 0xff, 0x86, 0x84, 0x4b, 0x41, 0xb7, 0x37,
      0x81, 0x19, 0x5c, 0x82, 0x0a, 0xae, 0x42, 0xf7, 0x56, 0x95, 0x97, 0x75,
      0xf6, 0x03, 0x8f, 0x96, 0x15, 0xbd, 0x31, 0x9f, 0x27, 0x88, 0x75, 0x6a,
      0xfd, 0x3f, 0x37, 0xd3, 0x84, 0xa7, 0x75, 0xc4, 0xd6, 0x48, 0x4a, 0xd3,
      0xdd, 0xdd, 0x7c, 0xb9, 0xa4, 0x5e, 0x2b, 0x75, 0x0d, 0x73, 0xf4, 0xf8,
      0x02, 0xe6, 0x0e, 0xfe, 0xbc, 0xc2, 0x35, 0x63, 0x0a, 0xce, 0x45, 0xf2,
      0xc5, 0x0a, 0x2d, 0x6f, 0xbf, 0xc1, 0x0b, 0x95, 0x1e, 0x36, 0xc3, 0x63,
      0x64, 0x0e, 0xa7, 0x62, 0xce, 0x6e, 0xd5, 0x76, 0x49, 0xbe, 0x8b, 0x49,
      0xa4, 0x5c, 0x98, 0x7a, 0x66, 0xb8, 0x6c, 0x2d, 0x59, 0x00, 0x56, 0xf7,
      0xd4, 0xa1, 0x78, 0xe1, 0x56, 0x3b, 0xb0, 0x7e, 0xd8, 0xcb, 0xb8, 0xb0},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bits of h replaced by 1s
    // tcID: 79
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     79,
     32,
     {0x31, 0x2f, 0xe5, 0x04, 0x66, 0x19, 0x32, 0x4e, 0x6b, 0x32, 0xa3, 0x85,
      0xbc, 0xca, 0xbb, 0x71, 0x3d, 0x78, 0x7f, 0xf7, 0xa7, 0xfc, 0x95, 0x27,
      0xbf, 0x1b, 0x57, 0x62, 0x79, 0x40, 0x36, 0x5f, 0xc8, 0x4c, 0xb8, 0x58,
      0x43, 0x5f, 0x07, 0x83, 0x22, 0x93, 0x5d, 0x03, 0x84, 0x72, 0x8d, 0xc7,
      0x7a, 0x56, 0xe6, 0x42, 0x9a, 0xdb, 0x6a, 0xb9, 0xc9, 0xe3, 0xb6, 0xa2,
      0x50, 0x36, 0x3d, 0x3a, 0x52, 0x9c, 0x7b, 0xea, 0xd3, 0x1f, 0xcc, 0x57,
      0x59, 0x0f, 0xae, 0xc3, 0x72, 0xf8, 0x16, 0x14, 0x8f, 0xc7, 0x3c, 0x8e,
      0x0e, 0xed, 0x5b, 0x6d, 0xc5, 0x91, 0xa1, 0x0c, 0xa6, 0x71, 0x1e, 0xb1,
      0x21, 0xee, 0xa9, 0x91, 0xaf, 0xd5, 0xb8, 0xa8, 0x20, 0xca, 0xa3, 0x77,
      0x07, 0x1a, 0x04, 0xa1, 0x1f, 0x3e, 0xa5, 0x26, 0xd1, 0x50, 0xce, 0x9e,
      0x6f, 0x7e, 0x51, 0x52, 0x2f, 0xa7, 0xb8, 0x6e, 0xa5, 0xe0, 0x3a, 0x4a,
      0x37, 0xc4, 0x4c, 0xf7, 0x7c, 0x35, 0xb4, 0x90, 0x7f, 0xeb, 0xb1, 0xfb,
      0xd6, 0xd6, 0xd9, 0xc9, 0xf1, 0x17, 0xdc, 0x0c, 0x41, 0xb4, 0x65, 0xdc,
      0x2a, 0xfb, 0xdd, 0x09, 0xb9, 0x32, 0x37, 0x56, 0x4a, 0x48, 0x14, 0xcb,
      0x28, 0x31, 0xa0, 0x95, 0xfe, 0x98, 0x62, 0xd1, 0xf6, 0x07, 0xa3, 0x19,
      0x05, 0xd4, 0x5d, 0x69, 0x46, 0xa3, 0xd5, 0xb6, 0x37, 0x7d, 0x85, 0xb4,
      0x24, 0xb9, 0x9f, 0xe3, 0x6e, 0x1d, 0x0f, 0xc5, 0xc7, 0xe7, 0x4b, 0xdc,
      0x65, 0x88, 0xbb, 0xa4, 0xaf, 0x33, 0xb9, 0x74, 0x2e, 0x57, 0x27, 0xb3,
      0x2c, 0x24, 0xb2, 0x93, 0x7a, 0x3f, 0xae, 0x82, 0xdf, 0x37, 0x34, 0xe8,
      0x6b, 0x79, 0xfe, 0x21, 0xd9, 0x81, 0x0f, 0xef, 0x8d, 0x6b, 0xe7, 0x53,
      0xfd, 0xfc, 0xcb, 0xdf, 0x78, 0xd7, 0x35, 0xc4, 0x22, 0x3c, 0xc8, 0xe7,
      0x78, 0x1f, 0x11, 0x1d, 0xa2, 0xd8, 0x3a, 0x63, 0x28, 0x89, 0x95, 0xd9,
      0xba, 0xf1, 0x86, 0x81, 0x58, 0xec, 0x31, 0x17, 0x04, 0x2a, 0x4b, 0xc4,
      0x12, 0x5f, 0x7d, 0xb1, 0xa2, 0xe9, 0x58, 0x77, 0xfe, 0x14, 0x37, 0x70,
      0x1f, 0x31, 0x95, 0x5a, 0x20, 0xfa, 0x05, 0xe6, 0x87, 0xca, 0x84, 0xb6,
      0xa8, 0xa4, 0xdc, 0xbf, 0x34, 0xef, 0x62, 0x75, 0x28, 0xbd, 0xd2, 0x2a,
      0x3d, 0xae, 0xb6, 0x97, 0x61, 0xc4, 0x7b, 0x87, 0x99, 0xd1, 0xe2, 0x4e,
      0xcc, 0xba, 0xa0, 0xcf, 0xd3, 0xf5, 0x68, 0x4d, 0x98, 0xc5, 0xc6, 0x9a,
      0x79, 0x94, 0x28, 0x46, 0xc7, 0x45, 0xbf, 0xab, 0x42, 0x8e, 0xea, 0xdd,
      0x4d, 0xc5, 0x2c, 0xf3, 0x82, 0x7c, 0x08, 0x54, 0x7c, 0x7e, 0x8a, 0x8f,
      0xb0, 0xdc, 0x14, 0x9e, 0x8b, 0x04, 0x3a, 0x49, 0xeb, 0xd2, 0x16, 0x0e,
      0x03, 0x72, 0x73, 0x3d, 0x38, 0x00, 0x05, 0x81, 0xe7, 0x75, 0xd0, 0xc7},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bits in hash h flipped
    // tcID: 80
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     80,
     32,
     {0x69, 0xd4, 0x19, 0x0a, 0xb2, 0xeb, 0x0b, 0x4a, 0x59, 0xfe, 0x36, 0x92,
      0xc6, 0xb9, 0x9d, 0xd3, 0xec, 0x7a, 0x84, 0x98, 0xf3, 0xb8, 0x1d, 0xbb,
      0xc4, 0x70, 0x9b, 0x77, 0xad, 0x49, 0xae, 0x34, 0x4a, 0x68, 0xac, 0xc3,
      0x3e, 0xc0, 0x51, 0x76, 0xa5, 0xc1, 0xf5, 0x72, 0xdc, 0xa5, 0xca, 0x96,
      0x2d, 0x51, 0xba, 0xb6, 0x38, 0x1d, 0x0d, 0xd0, 0x50, 0xf5, 0x39, 0xfb,
      0x5f, 0x65, 0x32, 0xa3, 0xc8, 0x11, 0xd2, 0xcb, 0xde, 0x95, 0xb0, 0x43,
      0xd8, 0x54, 0xc5, 0x0f, 0x47, 0x9c, 0xca, 0xfa, 0x3c, 0xd7, 0xdd, 0xce,
      0x18, 0x25, 0x58, 0x69, 0x3c, 0x70, 0x1d, 0xf6, 0x67, 0x47, 0xe5, 0x37,
      0xe2, 0x9a, 0xdb, 0x9c, 0x7e, 0x2e, 0xc3, 0xf3, 0x45, 0xfa, 0x50, 0x10,
      0xff, 0x3f, 0x8c, 0xa5, 0xcf, 0x4d, 0xe3, 0x11, 0x39, 0xdc, 0x3f, 0x9e,
      0xd9, 0x3b, 0x4f, 0x7e, 0xe7, 0x7b, 0xf9, 0xbd, 0x29, 0x75, 0x7f, 0x33,
      0x0e, 0x25, 0x9e, 0x6d, 0xdd, 0x5e, 0x40, 0xf8, 0x61, 0x52, 0xf2, 0x6c,
      0x76, 0xcf, 0x7a, 0x77, 0x8b, 0x75, 0x65, 0x28, 0x74, 0x06, 0xe4, 0x31,
      0xc4, 0x40, 0x81, 0x24, 0x20, 0xbb, 0x1c, 0x9e, 0x36, 0x61, 0x4b, 0x51,
      0x74, 0x5c, 0xd3, 0x5a, 0xd1, 0x8a, 0x01, 0x8a, 0xca, 0xf3, 0xa8, 0x87,
      0x1e, 0x90, 0x49, 0x88, 0xb6, 0x6e, 0x2a, 0x09, 0x66, 0x2f, 0x88, 0x81,
      0x0b, 0xf5, 0xbf, 0xc1, 0x7d, 0xd7, 0x46, 0x5a, 0xbb, 0x77, 0xd2, 0xf6,
      0x25, 0xca, 0x83, 0xcc, 0xf2, 0xe2, 0xf1, 0x87, 0xb2, 0x17, 0xc2, 0x8c,
      0xc0, 0x81, 0x8f, 0x04, 0xe2, 0x59, 0xec, 0xd5, 0x9c, 0x0c, 0xe0, 0x7f,
      0x67, 0x32, 0xeb, 0x18, 0xc7, 0x2f, 0xbd, 0x00, 0x7a, 0x1f, 0x07, 0x0c,
      0x55, 0x44, 0x24, 0x18, 0x5b, 0xa4, 0x5e, 0x9e, 0xb1, 0xb1, 0x0b, 0x05,
      0x55, 0xf8, 0xd4, 0x67, 0x8f, 0xd7, 0xf7, 0xe9, 0x1c, 0x92, 0xde, 0x9f,
      0x2a, 0x11, 0xc4, 0x5b, 0xe7, 0xdc, 0x13, 0x66, 0xff, 0xc3, 0xab, 0x71,
      0xf2, 0x63, 0xeb, 0x89, 0x2e, 0xce, 0xf2, 0x53, 0x53, 0xbe, 0xc9, 0xca,
      0x6a, 0xb7, 0x86, 0x68, 0xcb, 0x9b, 0x66, 0xa9, 0xd0, 0xcd, 0x68, 0xb4,
      0xdf, 0x0b, 0x2e, 0xe1, 0x79, 0x40, 0xfc, 0x1c, 0x66, 0x91, 0x5c, 0xf3,
      0x0b, 0xe0, 0x60, 0x95, 0x2c, 0xba, 0x3b, 0x42, 0x37, 0xbe, 0xbf, 0x7c,
      0xa4, 0xb5, 0x90, 0x23, 0xa9, 0x29, 0x3c, 0x66, 0x34, 0x91, 0x2a, 0x90,
      0x29, 0x15, 0x28, 0xe4, 0x8b, 0x96, 0x54, 0x2a, 0x05, 0x60, 0xda, 0x0c,
      0x45, 0x74, 0x07, 0xbf, 0x45, 0x4a, 0x9c, 0xe5, 0x91, 0x9c, 0x70, 0xe6,
      0x25, 0x36, 0xb8, 0xe5, 0xe2, 0x6f, 0x95, 0x94, 0x0a, 0x2a, 0x64, 0x46,
      0xa0, 0x0e, 0x9c, 0xa6, 0x4e, 0x71, 0x00, 0x12, 0xd0, 0x7c, 0x99, 0x04},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: hash of salt missing
    // tcID: 81
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     81,
     32,
     {0x39, 0xd6, 0x28, 0xb8, 0x28, 0xf4, 0x4d, 0xad, 0x50, 0x1d, 0xb9, 0x9f,
      0x8d, 0xeb, 0x5c, 0x33, 0x36, 0x3c, 0x04, 0x3b, 0x4b, 0xa0, 0x41, 0xc7,
      0x62, 0xa0, 0xab, 0x6c, 0x7e, 0xdc, 0x99, 0x3a, 0x6c, 0xa1, 0x65, 0xe1,
      0x59, 0x81, 0xf8, 0x2e, 0xf3, 0x0c, 0xf9, 0x1e, 0x67, 0x9a, 0xd3, 0x35,
      0x75, 0x14, 0xa6, 0xa8, 0x8f, 0x45, 0x10, 0x7f, 0xf7, 0x67, 0x55, 0x87,
      0xd2, 0xa7, 0x8f, 0xf6, 0x67, 0xd2, 0xcf, 0x66, 0x94, 0x6a, 0x8b, 0xe5,
      0xb7, 0xdb, 0xd5, 0x35, 0xc5, 0x30, 0xa9, 0xaf, 0x96, 0xd2, 0xab, 0x04,
      0x90, 0x2b, 0x9e, 0xa2, 0xf7, 0x90, 0xe1, 0x0c, 0x10, 0x99, 0x50, 0x18,
      0x0e, 0x61, 0x75, 0x9d, 0xe7, 0x08, 0xae, 0x81, 0x67, 0xe1, 0xb8, 0xba,
      0x43, 0xef, 0x31, 0x7d, 0x8a, 0x14, 0x1e, 0x70, 0x61, 0x81, 0x84, 0xdf,
      0x8f, 0xb0, 0x54, 0xb8, 0x91, 0xd6, 0x91, 0x36, 0x49, 0xdf, 0x60, 0x3e,
      0x39, 0x18, 0xb0, 0xb2, 0x2a, 0x85, 0xc0, 0xe1, 0x95, 0x51, 0xa6, 0xd5,
      0x6b, 0xad, 0x91, 0xca, 0xe1, 0xfd, 0x99, 0xdf, 0xc3, 0xab, 0xeb, 0xb3,
      0xfa, 0x5e, 0xba, 0x6b, 0xe1, 0xc2, 0x6b, 0x10, 0x3d, 0xbf, 0xa3, 0x6a,
      0x89, 0xcd, 0x59, 0x5e, 0x4e, 0xd8, 0x81, 0x39, 0x3b, 0x72, 0x96, 0xa5,
      0x0a, 0x23, 0x7e, 0xdc, 0x33, 0x1e, 0x18, 0xb7, 0xd2, 0x19, 0x83, 0xb6,
      0x6f, 0xf9, 0xec, 0x5c, 0x32, 0x19, 0x55, 0xde, 0xd1, 0x4e, 0x17, 0x97,
      0x52, 0xb3, 0x21, 0x17, 0xa5, 0x52, 0xb5, 0x13, 0xa1, 0xb8, 0xa9, 0x48,
      0x52, 0xc0, 0x2e, 0xad, 0x94, 0x57, 0xd6, 0xc8, 0x2c, 0x33, 0xec, 0x95,
      0xbe, 0x7c, 0xf8, 0xef, 0xf6, 0x06, 0x89, 0x2d, 0x1a, 0xa3, 0x45, 0xe0,
      0xe3, 0xfe, 0x9b, 0x6c, 0xeb, 0x55, 0x89, 0x76, 0x00, 0x2c, 0x8b, 0xaf,
      0x26, 0xa4, 0x94, 0xad, 0xf5, 0xa7, 0x96, 0x28, 0xed, 0xe5, 0xc9, 0x9c,
      0x9a, 0xfd, 0x70, 0x6f, 0x26, 0x2f, 0xd4, 0x22, 0x72, 0xe2, 0xaa, 0xd7,
      0x90, 0xb0, 0xd8, 0xd0, 0x34, 0xe6, 0xfe, 0x05, 0x68, 0x32, 0x98, 0x6b,
      0x07, 0x57, 0x05, 0x3d, 0x25, 0x89, 0x9b, 0xd7, 0x8a, 0x5d, 0x77, 0x37,
      0x14, 0xd1, 0xe5, 0x2d, 0x71, 0x21, 0x51, 0x8e, 0x39, 0x31, 0xac, 0x75,
      0x12, 0x50, 0xb6, 0xf8, 0x68, 0x97, 0x16, 0x48, 0xe2, 0xa1, 0xa1, 0xb4,
      0x24, 0xb8, 0x0e, 0xc0, 0x9c, 0x1f, 0xe1, 0x53, 0xe6, 0xed, 0xc5, 0x32,
      0xd7, 0x37, 0xef, 0xce, 0x26, 0xc0, 0x25, 0xff, 0xe0, 0x71, 0x33, 0x27,
      0xe5, 0xff, 0x37, 0xf6, 0x92, 0x79, 0x29, 0x74, 0xa6, 0x87, 0x3a, 0x29,
      0x05, 0x89, 0xa9, 0xb8, 0x88, 0xd6, 0xd8, 0x2e, 0xa8, 0x56, 0xa5, 0x23,
      0xc9, 0xf3, 0xa6, 0xb2, 0xed, 0xaa, 0xf3, 0xd7, 0x6d, 0xa4, 0x1f, 0xe0},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of ps modified
    // tcID: 82
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     82,
     32,
     {0x54, 0xa5, 0xa3, 0x18, 0x6b, 0xbd, 0xf9, 0xa0, 0x8d, 0xf3, 0xb3, 0xbb,
      0x34, 0x39, 0x79, 0xc4, 0xe7, 0x4e, 0x3e, 0x6d, 0x50, 0x7b, 0x6b, 0x81,
      0xe1, 0xaa, 0x34, 0x42, 0x1f, 0xee, 0x0f, 0xc5, 0x3f, 0x9d, 0xc5, 0xb0,
      0xf8, 0x0a, 0xd5, 0x35, 0xe2, 0x5c, 0xaf, 0x47, 0xff, 0x3e, 0x3a, 0xbb,
      0x72, 0x9e, 0x27, 0x1e, 0x2e, 0x3d, 0x94, 0x5b, 0x61, 0xe5, 0x6f, 0xb2,
      0x9e, 0x32, 0xe7, 0xd9, 0x3e, 0x74, 0x84, 0x74, 0x27, 0x62, 0x52, 0xe3,
      0xb3, 0xf0, 0x5b, 0xa7, 0x09, 0xa1, 0x90, 0x9b, 0x95, 0x41, 0x4d, 0xa0,
      0xad, 0xa0, 0xef, 0xfd, 0x5e, 0xa3, 0x57, 0x25, 0x60, 0xfd, 0x24, 0xd3,
      0xbf, 0xe2, 0x79, 0x80, 0x06, 0xc3, 0x22, 0xac, 0xdf, 0xb7, 0xca, 0xea,
      0xb1, 0x2b, 0x82, 0x16, 0x9b, 0x72, 0x77, 0x1b, 0x07, 0x03, 0x03, 0x70,
      0xf3, 0x01, 0xa3, 0x1f, 0x0b, 0x91, 0x97, 0x24, 0xa5, 0x59, 0x4d, 0x9b,
      0x48, 0xbb, 0x5c, 0x89, 0x45, 0xce, 0xba, 0xe0, 0x16, 0x53, 0x76, 0x6b,
      0x71, 0x00, 0x10, 0x3a, 0xaa, 0x38, 0xd4, 0xc0, 0x08, 0x06, 0x41, 0xfb,
      0x7d, 0x94, 0x6c, 0x2b, 0xa6, 0x6b, 0xeb, 0xc4, 0xe6, 0xdf, 0x76, 0xc1,
      0x27, 0xee, 0xdd, 0x9b, 0x83, 0xdd, 0x23, 0x93, 0x57, 0xec, 0xd3, 0xc7,
      0xa4, 0xe0, 0x37, 0x0b, 0x01, 0x6d, 0x54, 0x22, 0x03, 0x96, 0x3e, 0x96,
      0x2a, 0xba, 0x5a, 0xd8, 0x30, 0x5d, 0x29, 0x80, 0xb3, 0x5b, 0x8e, 0x4f,
      0x65, 0xe2, 0x38, 0x7a, 0xfa, 0x91, 0x2c, 0x13, 0xac, 0x7f, 0x72, 0x5b,
      0x91, 0xba, 0xde, 0xdb, 0x13, 0x32, 0xb2, 0x1e, 0x15, 0x69, 0x27, 0x52,
      0xd4, 0x74, 0xfc, 0xfe, 0x1b, 0x40, 0x8d, 0x5c, 0x2b, 0xc2, 0xe2, 0x9f,
      0x67, 0xb9, 0xab, 0x76, 0xcd, 0xfd, 0x64, 0xbb, 0xeb, 0x80, 0x9c, 0xe9,
      0xe8, 0x9c, 0xa2, 0x17, 0x22, 0xb4, 0xe0, 0x4f, 0x03, 0xbb, 0xcf, 0x07,
      0x0d, 0xf8, 0x38, 0x74, 0x85, 0xd7, 0xa2, 0xc3, 0xfa, 0x0b, 0x0b, 0x3c,
      0xd7, 0xe1, 0x75, 0x62, 0x51, 0x0d, 0xad, 0x0f, 0xfb, 0x1c, 0x16, 0xd8,
      0x38, 0xb0, 0x42, 0xab, 0x85, 0xd5, 0x8f, 0xbf, 0x44, 0x29, 0xeb, 0x91,
      0xdc, 0x9f, 0xb4, 0x99, 0xd5, 0x4c, 0xb9, 0x23, 0x00, 0xd3, 0x31, 0xdc,
      0x56, 0x09, 0xb2, 0x70, 0xdb, 0xe6, 0x39, 0x52, 0x2d, 0x84, 0x37, 0x8b,
      0x52, 0x9d, 0xd7, 0xb5, 0x92, 0xc5, 0xea, 0xeb, 0xef, 0xd4, 0xe0, 0x32,
      0x40, 0x1b, 0x07, 0x35, 0x01, 0xa4, 0xfe, 0x15, 0x30, 0x85, 0x1c, 0x2d,
      0x84, 0x52, 0x63, 0xb0, 0xc9, 0x88, 0xd6, 0xf4, 0x9e, 0x7d, 0xea, 0x2c,
      0xb4, 0x92, 0x5f, 0x9e, 0xca, 0xf7, 0x73, 0x65, 0xbf, 0x01, 0x89, 0x42,
      0x02, 0x78, 0x3c, 0xb4, 0xc7, 0x9f, 0x33, 0x70, 0xb7, 0x4e, 0xa7, 0x89},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of ps modified
    // tcID: 83
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     83,
     32,
     {0x4e, 0xd9, 0x72, 0x4e, 0xd7, 0x88, 0x2a, 0x0e, 0xa9, 0xd6, 0x1c, 0xf2,
      0xd1, 0xbf, 0xb1, 0xc0, 0x42, 0xd9, 0x4b, 0x24, 0x27, 0xd7, 0x10, 0x79,
      0x62, 0x5d, 0x8d, 0x59, 0xf7, 0xe5, 0x63, 0x2a, 0x57, 0x85, 0x21, 0x97,
      0x3b, 0xd4, 0x96, 0xcd, 0xab, 0xf1, 0xe9, 0xdd, 0x45, 0xba, 0xc4, 0x56,
      0x44, 0x09, 0x30, 0xd2, 0x21, 0xb9, 0x5c, 0xc4, 0xd2, 0x08, 0x0e, 0x96,
      0xc9, 0x63, 0x68, 0x5b, 0x90, 0x90, 0x00, 0xc4, 0x5d, 0x62, 0x83, 0x5b,
      0x9e, 0x68, 0xdd, 0xc7, 0x28, 0xe9, 0xc0, 0x3a, 0x48, 0x31, 0xa9, 0x04,
      0x35, 0xab, 0xab, 0x57, 0xa9, 0x9a, 0xff, 0xcc, 0x72, 0x70, 0xb4, 0x90,
      0xb8, 0x50, 0x72, 0x16, 0x09, 0xf5, 0x68, 0xfa, 0x4a, 0x40, 0x4f, 0xf8,
      0xb0, 0x54, 0x34, 0x5e, 0x1d, 0x8e, 0x4e, 0xdb, 0x92, 0x34, 0x33, 0x0f,
      0x9d, 0xbe, 0x60, 0xe4, 0xee, 0x20, 0x42, 0xa5, 0xbf, 0xb2, 0x8d, 0x3a,
      0x11, 0xa9, 0xfd, 0x03, 0x65, 0x56, 0x87, 0x56, 0x19, 0x38, 0xc4, 0x5b,
      0xaf, 0xc6, 0x4f, 0x59, 0xd0, 0xd5, 0xd7, 0x2f, 0xd2, 0x3b, 0xc4, 0x0a,
      0x52, 0x1d, 0xda, 0x3e, 0x2b, 0x4a, 0x7b, 0x69, 0xb6, 0x04, 0x71, 0x93,
      0xcf, 0x8d, 0xc3, 0xfe, 0xe3, 0xfd, 0x29, 0x9f, 0xe8, 0x8b, 0x58, 0xfa,
      0x05, 0x2b, 0xce, 0x5c, 0x4a, 0xf6, 0x2b, 0xaf, 0x54, 0x8b, 0xd5, 0xfa,
      0x8c, 0x08, 0xbf, 0x6a, 0xa1, 0x7e, 0xdd, 0xb8, 0xfd, 0x17, 0x5c, 0x40,
      0x12, 0x8d, 0x1e, 0xfc, 0x64, 0xe4, 0x0e, 0x08, 0x07, 0x6f, 0x73, 0x8a,
      0x5d, 0xa4, 0x95, 0xb1, 0xe9, 0xe0, 0xa2, 0xf5, 0x2f, 0x1a, 0xcc, 0x19,
      0x36, 0xc9, 0x05, 0xfb, 0x69, 0x87, 0x1d, 0xe2, 0x15, 0x9a, 0xa5, 0xb4,
      0xac, 0xcf, 0xec, 0xa0, 0x07, 0x64, 0xec, 0xbd, 0x03, 0xf0, 0xc9, 0xa2,
      0xd8, 0x23, 0x1f, 0x26, 0xce, 0x5e, 0x7a, 0xef, 0x43, 0xf2, 0x71, 0xd3,
      0x62, 0x34, 0x59, 0x93, 0x0a, 0x0d, 0x99, 0xa5, 0xa4, 0x1c, 0x72, 0x60,
      0x85, 0x11, 0x35, 0x09, 0xc1, 0x5a, 0xba, 0xec, 0xd8, 0xe7, 0x8f, 0x25,
      0xfb, 0x2e, 0x5c, 0x39, 0x83, 0xaf, 0xda, 0x6e, 0xad, 0xd0, 0xe6, 0x8d,
      0x74, 0x26, 0x13, 0xd0, 0x85, 0xea, 0x1d, 0xb5, 0x24, 0xf8, 0xd9, 0x7e,
      0x18, 0x91, 0x36, 0xb6, 0x48, 0x1e, 0x3e, 0x61, 0xb7, 0xf5, 0x29, 0x0f,
      0x2d, 0x10, 0xb1, 0x5a, 0x9b, 0x93, 0xa5, 0xfb, 0x4a, 0x68, 0x91, 0xf5,
      0xe4, 0xa3, 0x41, 0x79, 0x7e, 0x5f, 0xe2, 0x7e, 0x3c, 0x20, 0x2d, 0x26,
      0x7d, 0x76, 0xbe, 0x40, 0x9a, 0x3b, 0x72, 0xb1, 0x5e, 0x40, 0x67, 0x29,
      0xa2, 0xe5, 0x6c, 0x9b, 0x9d, 0x7c, 0xda, 0x30, 0x28, 0x3d, 0x7d, 0xd3,
      0x52, 0xc8, 0x8e, 0xa8, 0x23, 0x50, 0xe4, 0xa1, 0x2f, 0xa1, 0x7b, 0x97},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes of ps changed to 0xff
    // tcID: 84
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     84,
     32,
     {0xa8, 0x55, 0xda, 0x78, 0xc4, 0x4b, 0xe7, 0x4d, 0xdd, 0xee, 0x63, 0x41,
      0x57, 0xb6, 0x85, 0xa2, 0x27, 0x71, 0x4c, 0xbb, 0x6a, 0x21, 0x28, 0x8c,
      0xdb, 0xf3, 0xa8, 0x7a, 0xa4, 0x8b, 0x1d, 0xa9, 0x8c, 0xd5, 0x90, 0xa0,
      0x49, 0xd2, 0xab, 0x71, 0x51, 0x36, 0xd1, 0x47, 0x14, 0x2e, 0x55, 0x26,
      0xbe, 0xc5, 0xd1, 0xd0, 0x8a, 0x24, 0xd9, 0x9e, 0x99, 0x65, 0x24, 0x2f,
      0xed, 0x7c, 0x0e, 0x9e, 0x3a, 0x94, 0xc6, 0xcd, 0x76, 0x51, 0x10, 0x83,
      0xb7, 0xfc, 0x24, 0x4d, 0xb4, 0xb8, 0xef, 0xa0, 0x94, 0x62, 0x45, 0x64,
      0xfe, 0xb6, 0x19, 0x92, 0xb0, 0x2b, 0x3f, 0x77, 0x24, 0xfb, 0xe6, 0xf5,
      0x3f, 0x4f, 0x12, 0x20, 0xfe, 0x03, 0xf2, 0x8a, 0x6d, 0xef, 0xec, 0x46,
      0x32, 0xcd, 0x07, 0x46, 0x36, 0xfc, 0x12, 0x9d, 0x75, 0xf7, 0xc1, 0x2f,
      0x2d, 0xa8, 0x39, 0x03, 0xb1, 0xb4, 0x0e, 0x24, 0x15, 0x09, 0x6f, 0x3b,
      0xf3, 0x95, 0x5d, 0x1b, 0xc2, 0x31, 0xf6, 0x43, 0xcd, 0x96, 0x44, 0x63,
      0x19, 0x9d, 0xa0, 0x0d, 0xf1, 0x64, 0xf7, 0xeb, 0xdd, 0x96, 0x7b, 0x24,
      0x15, 0xed, 0x46, 0x0f, 0x9d, 0x26, 0xbd, 0xf6, 0x54, 0x2a, 0xd3, 0x55,
      0xdc, 0x05, 0x47, 0xdd, 0xfc, 0x93, 0xc2, 0x72, 0x90, 0x2e, 0xb0, 0x69,
      0x8a, 0x53, 0xb0, 0xd0, 0x6e, 0xac, 0x9a, 0xcb, 0x9d, 0x54, 0xd3, 0x35,
      0xc4, 0xa4, 0x60, 0xc9, 0x7f, 0xd7, 0x78, 0xdd, 0xa4, 0x08, 0x54, 0xab,
      0xb7, 0x08, 0x6b, 0xef, 0xf7, 0x89, 0x28, 0xb6, 0x16, 0x04, 0xdd, 0x94,
      0xf8, 0xe0, 0xbf, 0x8e, 0xd5, 0x41, 0x85, 0xc3, 0xbf, 0x14, 0xcb, 0x8b,
      0xbb, 0xd7, 0x9c, 0x6f, 0x9d, 0xa3, 0x88, 0x8e, 0xee, 0x31, 0x69, 0x2b,
      0x30, 0xf3, 0x70, 0xf8, 0xd6, 0xe2, 0x71, 0x6d, 0xaf, 0x73, 0xeb, 0x5f,
      0x31, 0x8e, 0xd4, 0xf9, 0x97, 0x05, 0xf0, 0x19, 0xee, 0xd2, 0x9b, 0x2b,
      0xa5, 0xfa, 0x61, 0x93, 0xeb, 0x00, 0x49, 0xfd, 0xde, 0xcf, 0xf0, 0x2e,
      0xd1, 0x93, 0x00, 0x10, 0x2e, 0x27, 0xbe, 0x3c, 0x85, 0xd2, 0x31, 0xbc,
      0xa8, 0xcd, 0x1c, 0x24, 0xe1, 0x75, 0xe9, 0x5f, 0xbc, 0x2a, 0x3b, 0xf8,
      0xe2, 0x3e, 0x2b, 0x8a, 0x62, 0x2f, 0x48, 0xcd, 0x10, 0x06, 0x72, 0xe0,
      0x58, 0xc2, 0xca, 0x2f, 0x3b, 0x18, 0x55, 0xed, 0xdb, 0x06, 0xb6, 0xe7,
      0x07, 0xe1, 0xf0, 0x59, 0x56, 0xa4, 0x68, 0x39, 0x76, 0x74, 0x91, 0x93,
      0xfa, 0xec, 0xcb, 0x5e, 0x25, 0xaf, 0x7a, 0x99, 0x52, 0x8d, 0xa6, 0x1c,
      0x68, 0x62, 0x69, 0xb4, 0x9e, 0xa5, 0xb7, 0x68, 0x76, 0x8d, 0x7f, 0x62,
      0x4a, 0x16, 0x00, 0xe4, 0x03, 0xdb, 0x22, 0x9a, 0x85, 0xe8, 0x64, 0x4f,
      0x4d, 0xd7, 0x14, 0x73, 0x15, 0xce, 0xdb, 0xdc, 0x85, 0x70, 0x3c, 0x89},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes of ps changed to 0x80
    // tcID: 85
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     85,
     32,
     {0x5b, 0x7d, 0x07, 0x9d, 0x66, 0x7b, 0x60, 0xb3, 0x50, 0x80, 0x89, 0x03,
      0x1b, 0x60, 0x43, 0x27, 0xbb, 0xcd, 0xae, 0xdc, 0x88, 0x7c, 0x95, 0x30,
      0xba, 0x15, 0x54, 0x69, 0x4d, 0xfa, 0xf0, 0x81, 0xac, 0x91, 0xfd, 0x33,
      0x93, 0x23, 0x79, 0x3d, 0x86, 0x27, 0x86, 0xc9, 0x26, 0x96, 0xf1, 0xd9,
      0x52, 0x3c, 0xc8, 0xaa, 0xc1, 0x4d, 0xba, 0x90, 0xa6, 0x36, 0x3b, 0xee,
      0x9a, 0x93, 0xfc, 0xd7, 0x75, 0x19, 0x73, 0xec, 0xb7, 0x0c, 0xd8, 0x12,
      0x72, 0x5f, 0x11, 0x90, 0xd6, 0x2f, 0x9d, 0x95, 0x0a, 0x55, 0x23, 0x36,
      0xee, 0xec, 0x2f, 0x27, 0x59, 0xc4, 0xd3, 0x47, 0xd4, 0xb7, 0x57, 0x17,
      0xc4, 0x63, 0x65, 0xc6, 0x84, 0xac, 0xfa, 0xac, 0x48, 0xff, 0xa5, 0xa3,
      0xa7, 0x47, 0x48, 0xbd, 0x13, 0xd4, 0xce, 0x46, 0x1d, 0xf0, 0x09, 0x5b,
      0xc2, 0xfe, 0x74, 0xb5, 0x65, 0xf6, 0x29, 0xbe, 0x54, 0x07, 0x98, 0x5c,
      0xa7, 0xce, 0xaa, 0xc4, 0x38, 0x10, 0xe4, 0x29, 0x51, 0xe7, 0xa7, 0xab,
      0xd8, 0xc2, 0xf5, 0x48, 0xde, 0xca, 0x74, 0xf3, 0x4a, 0xfa, 0x47, 0xc2,
      0xd7, 0x2b, 0x85, 0xee, 0xa9, 0xcd, 0x24, 0x34, 0xd4, 0xb5, 0xba, 0x81,
      0xf9, 0xee, 0xc8, 0x65, 0xa2, 0xc4, 0xae, 0x17, 0xd4, 0xfe, 0x00, 0xac,
      0xed, 0x59, 0xbc, 0x20, 0xf0, 0xe8, 0xa4, 0xe9, 0xb5, 0xfe, 0x98, 0xda,
      0x5b, 0x78, 0x59, 0x71, 0x9f, 0xea, 0x29, 0xb6, 0x43, 0x32, 0x3f, 0x2f,
      0xb0, 0x5f, 0x4b, 0xba, 0x83, 0x80, 0x4b, 0xa1, 0xae, 0x30, 0x40, 0xe6,
      0x23, 0x31, 0xd4, 0xee, 0x15, 0xad, 0x82, 0x22, 0x1f, 0x14, 0xab, 0xe7,
      0xa9, 0xdc, 0x44, 0x08, 0x51, 0xfb, 0x97, 0x70, 0x8b, 0x12, 0x0e, 0x4d,
      0x32, 0xe3, 0x73, 0x27, 0xd1, 0x03, 0xb6, 0x26, 0xa6, 0x48, 0x45, 0xa7,
      0x6d, 0x24, 0x76, 0x2d, 0x12, 0xe4, 0x21, 0x0e, 0x16, 0x6a, 0x87, 0xfa,
      0x77, 0xf8, 0xe2, 0xf2, 0xc9, 0xfe, 0xda, 0x8d, 0xfa, 0xae, 0xfa, 0x10,
      0x77, 0x44, 0x80, 0xb8, 0xe6, 0xf6, 0xbd, 0x91, 0x2c, 0x40, 0x48, 0xb7,
      0x7a, 0xb3, 0xcd, 0x76, 0x84, 0xc3, 0x48, 0xc3, 0xca, 0x39, 0x8c, 0xa0,
      0xc0, 0x63, 0x93, 0xe8, 0x3d, 0xef, 0xa0, 0xee, 0xa7, 0x03, 0x4c, 0x97,
      0x69, 0x5e, 0x75, 0x56, 0xfa, 0xce, 0xf2, 0x3c, 0xc8, 0xa0, 0xe9, 0xd3,
      0x95, 0x08, 0x0f, 0xbd, 0x94, 0xb0, 0x85, 0x38, 0x05, 0x50, 0xde, 0xca,
      0x1a, 0x29, 0x52, 0x55, 0x48, 0x73, 0xbe, 0x09, 0x36, 0x71, 0x4c, 0x5d,
      0x78, 0xca, 0x53, 0xd3, 0x67, 0x28, 0x91, 0x9a, 0x7c, 0x4e, 0x70, 0x69,
      0xce, 0x97, 0xbf, 0x21, 0x5d, 0xa1, 0xd0, 0x2c, 0xf1, 0x40, 0x68, 0xc1,
      0x61, 0x00, 0xf8, 0xf7, 0x8b, 0xab, 0xa2, 0xd1, 0x9a, 0xbd, 0x30, 0x6e},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: ps followed by 0
    // tcID: 86
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     86,
     32,
     {0x85, 0x74, 0xa8, 0x0f, 0x36, 0x97, 0x3b, 0xf6, 0xb9, 0x86, 0xc7, 0xb8,
      0x1b, 0xc6, 0xd2, 0x89, 0xb1, 0x18, 0xca, 0xaf, 0xff, 0xc3, 0x1d, 0x2c,
      0x99, 0xd2, 0xdc, 0xcc, 0x1e, 0x66, 0x11, 0xd5, 0x98, 0xdd, 0xa3, 0xfd,
      0x7c, 0x22, 0xcf, 0x10, 0xc7, 0x72, 0x9f, 0xa8, 0x4a, 0x87, 0xe3, 0xf1,
      0x9f, 0xf4, 0xbf, 0x11, 0xa9, 0x60, 0x18, 0x69, 0x4b, 0x7d, 0x82, 0x9b,
      0xc0, 0x03, 0x00, 0x9e, 0xb1, 0x04, 0xe8, 0x95, 0x5e, 0x8a, 0x87, 0x17,
      0xf2, 0xfa, 0x89, 0x22, 0x02, 0x81, 0xfe, 0xd0, 0x87, 0x8b, 0x9f, 0xeb,
      0xf7, 0x7e, 0x5b, 0x81, 0xe9, 0x35, 0x15, 0xa8, 0x54, 0x1d, 0x7a, 0x4b,
      0x8a, 0x4c, 0x00, 0x8a, 0x29, 0x8d, 0x31, 0x7e, 0x7b, 0x82, 0xc8, 0x26,
      0xb5, 0xd6, 0x7b, 0xf0, 0x4d, 0x45, 0x9a, 0x5d, 0x5f, 0xd7, 0xf6, 0x93,
      0x89, 0xdf, 0xbb, 0x25, 0x14, 0x6c, 0x48, 0x05, 0xca, 0xb1, 0xaa, 0xdd,
      0x00, 0x9d, 0x7b, 0x00, 0x95, 0x6b, 0xa9, 0x3f, 0x6d, 0x02, 0xf5, 0x26,
      0x6d, 0x8b, 0x06, 0xe2, 0x8b, 0x34, 0x6b, 0x06, 0xf1, 0xc3, 0x50, 0x1c,
      0xef, 0x04, 0xa1, 0xc6, 0x07, 0xd7, 0xf8, 0x5e, 0xe0, 0x37, 0x17, 0x8e,
      0x6f, 0x2b, 0x0d, 0xde, 0x30, 0x7e, 0xb6, 0xf5, 0xf8, 0x82, 0x29, 0x54,
      0x1c, 0xb3, 0xd3, 0x7e, 0x49, 0x5c, 0xb5, 0x99, 0x72, 0x64, 0xa0, 0xc1,
      0x34, 0x27, 0x13, 0xe8, 0x54, 0x8e, 0x31, 0x86, 0x81, 0xa7, 0x83, 0x38,
      0x1d, 0xec, 0x9d, 0x65, 0x24, 0xf5, 0xc8, 0x0c, 0x43, 0x7b, 0x99, 0x7f,
      0x2f, 0xb9, 0x5c, 0x80, 0xca, 0x71, 0x58, 0xd0, 0xeb, 0xd5, 0x31, 0xb4,
      0xc9, 0xba, 0xfb, 0x19, 0xad, 0x9e, 0xa0, 0x54, 0x22, 0x17, 0xc1, 0xad,
      0x96, 0x5e, 0xe6, 0xf1, 0xaf, 0xa5, 0xa4, 0x8b, 0xec, 0xbf, 0x65, 0xb3,
      0x80, 0xf1, 0x94, 0x6d, 0xcc, 0x85, 0xfb, 0xcd, 0x82, 0xfb, 0x90, 0x01,
      0x1e, 0x65, 0x0d, 0xd1, 0xe5, 0x07, 0xdd, 0x19, 0x03, 0x7e, 0xc1, 0xf2,
      0xac, 0x98, 0xa8, 0x7c, 0x25, 0xa6, 0xf5, 0x88, 0xaa, 0x6b, 0x6f, 0x93,
      0xd3, 0x5b, 0x83, 0xc1, 0xe8, 0xe0, 0x91, 0x52, 0x47, 0x0d, 0xae, 0x2a,
      0xf8, 0xaf, 0xc1, 0xfb, 0x21, 0x46, 0xcd, 0x42, 0x6f, 0xe8, 0xd3, 0xca,
      0xe5, 0xa8, 0x0c, 0x1a, 0x63, 0xc7, 0xfc, 0x42, 0x82, 0x52, 0x26, 0xbe,
      0xc2, 0x6d, 0x57, 0xfb, 0x62, 0xbd, 0x04, 0x8f, 0xcd, 0x92, 0x1b, 0x8b,
      0xe7, 0xaa, 0x8d, 0x02, 0x49, 0x26, 0xfe, 0x3c, 0xf5, 0xc5, 0xe3, 0xe7,
      0xf5, 0xb2, 0xf5, 0x0b, 0x33, 0xde, 0xa5, 0x47, 0x38, 0x9e, 0x40, 0xfd,
      0x67, 0xa8, 0x52, 0x3c, 0xd5, 0xfa, 0xcb, 0x29, 0xe9, 0x75, 0x83, 0xf2,
      0x6a, 0x34, 0xf1, 0xed, 0x88, 0x08, 0x69, 0x80, 0x0a, 0x4b, 0x35, 0xd6},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: ps followed by 0xff
    // tcID: 87
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     87,
     32,
     {0x78, 0x57, 0xb1, 0xfe, 0x06, 0xfc, 0xc4, 0x17, 0xc0, 0x77, 0x66, 0xa9,
      0x89, 0x2a, 0xe3, 0x0e, 0xac, 0xa6, 0x5d, 0xf7, 0x47, 0x45, 0x75, 0xa7,
      0x0d, 0x8e, 0x28, 0x6f, 0xc2, 0x2e, 0x30, 0x92, 0xdc, 0xd2, 0x34, 0x46,
      0xb1, 0x01, 0xcf, 0x27, 0x95, 0x1e, 0xeb, 0x2c, 0xf8, 0x79, 0xd3, 0x20,
      0xb2, 0xbd, 0x12, 0xf4, 0x5b, 0x79, 0xc1, 0x00, 0x18, 0x17, 0x85, 0x32,
      0xd8, 0xfc, 0x4d, 0x70, 0x85, 0x83, 0xad, 0xb4, 0xd7, 0xd7, 0x46, 0x9c,
      0xd5, 0x36, 0x2c, 0x07, 0x4c, 0x51, 0x91, 0x06, 0xc7, 0x61, 0x22, 0x85,
      0x57, 0xd4, 0x28, 0x0d, 0xad, 0xd9, 0x07, 0xb2, 0x76, 0x75, 0xe3, 0x18,
      0x03, 0x3a, 0xd3, 0x2e, 0xa7, 0x1e, 0x00, 0x1c, 0x3e, 0x7f, 0x68, 0xf6,
      0xdc, 0x07, 0x50, 0x93, 0x96, 0xa6, 0x1d, 0xb2, 0x9a, 0x9a, 0xd3, 0x76,
      0xf4, 0x06, 0xff, 0x35, 0xae, 0xae, 0xbf, 0x8c, 0x6f, 0xd0, 0xbf, 0x7d,
      0xf4, 0xbb, 0x72, 0x1c, 0x91, 0xdf, 0xdf, 0xfa, 0x93, 0x3f, 0x37, 0xdb,
      0x0b, 0xee, 0x5d, 0x4f, 0x7d, 0x34, 0xf3, 0xdf, 0x2a, 0x3a, 0x0f, 0x38,
      0x3e, 0x44, 0x36, 0x47, 0x83, 0x8d, 0x7c, 0x02, 0xca, 0x87, 0xd9, 0xd7,
      0x98, 0x14, 0xee, 0x9d, 0x5b, 0x28, 0x60, 0xfd, 0xfe, 0xa5, 0x57, 0x77,
      0x02, 0xdb, 0xc8, 0x29, 0x61, 0x0e, 0xe1, 0xeb, 0x13, 0xf6, 0xe6, 0xf0,
      0x63, 0x6f, 0x39, 0xc5, 0xec, 0x53, 0x7c, 0x06, 0x95, 0xbc, 0xa4, 0x97,
      0x1d, 0xca, 0xb6, 0x90, 0x7e, 0x90, 0x76, 0x50, 0xb9, 0x2b, 0x96, 0xd5,
      0xd6, 0x4c, 0x6d, 0xe5, 0x2c, 0x4d, 0x98, 0x6d, 0x45, 0x8f, 0x01, 0x95,
      0x34, 0x5b, 0x1e, 0x84, 0xfb, 0xea, 0xa4, 0x83, 0xe3, 0xc9, 0x26, 0x16,
      0x7a, 0x0d, 0x1a, 0x97, 0x70, 0x24, 0xae, 0xf2, 0x47, 0x4c, 0x31, 0x75,
      0x25, 0x15, 0xb5, 0x50, 0x21, 0x04, 0x8d, 0x2f, 0xc2, 0x3e, 0xcc, 0x5e,
      0xc5, 0x12, 0x6c, 0x57, 0xb1, 0x8a, 0x16, 0x56, 0xed, 0x49, 0xaa, 0x90,
      0xe0, 0xcb, 0x51, 0xe7, 0x7e, 0x56, 0x50, 0x7d, 0x7f, 0xc6, 0x0b, 0x1f,
      0x76, 0x13, 0x54, 0x42, 0x3b, 0x11, 0x0d, 0x44, 0xc6, 0x76, 0x64, 0x78,
      0x1e, 0x5c, 0xae, 0xcb, 0x5d, 0xa5, 0x47, 0x5b, 0x01, 0xab, 0x23, 0x56,
      0x99, 0x33, 0x78, 0x49, 0x1c, 0x2c, 0xe4, 0xfb, 0xc4, 0x1b, 0xad, 0xf1,
      0x10, 0xc3, 0x3b, 0xd0, 0xb7, 0x8c, 0xd1, 0x95, 0x40, 0xd8, 0xaa, 0xf2,
      0x7b, 0xc9, 0xf3, 0x45, 0x0c, 0xe7, 0x57, 0x9c, 0x87, 0xee, 0x40, 0xa4,
      0x54, 0x13, 0x30, 0x93, 0xad, 0x89, 0xb2, 0x9b, 0x99, 0xb4, 0xb1, 0x5c,
      0x21, 0xf0, 0x72, 0xbd, 0x2f, 0x5c, 0x99, 0x1e, 0x6a, 0x98, 0xa2, 0x3f,
      0xef, 0xc0, 0x61, 0x21, 0xba, 0x81, 0x54, 0x0c, 0xad, 0x7e, 0x2a, 0x34},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: shifted salt
    // tcID: 88
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     88,
     32,
     {0x93, 0x93, 0xa9, 0x98, 0x9b, 0xa8, 0x65, 0xa8, 0xbe, 0x0f, 0xee, 0x26,
      0x5e, 0xe6, 0xb5, 0xb3, 0xcb, 0x93, 0x80, 0x01, 0x9e, 0x3c, 0x43, 0x77,
      0x52, 0x1a, 0x72, 0x9a, 0x96, 0x8d, 0xee, 0x03, 0x74, 0xb5, 0x47, 0xe9,
      0x4e, 0x6b, 0x12, 0xd8, 0x60, 0xbd, 0xfd, 0x51, 0x97, 0x78, 0x7d, 0x35,
      0x20, 0x8a, 0xe3, 0xe8, 0xd6, 0xa6, 0x89, 0xd0, 0x31, 0x07, 0x2f, 0x6b,
      0x99, 0x3b, 0x7a, 0x89, 0x00, 0xa2, 0x78, 0xfb, 0xf1, 0xc0, 0x7d, 0xad,
      0xcb, 0xa6, 0xb4, 0x07, 0x43, 0x75, 0xc6, 0x66, 0xe0, 0x35, 0xc2, 0xf1,
      0x2d, 0x15, 0x8f, 0x62, 0x62, 0x77, 0xd7, 0xd4, 0xb7, 0x81, 0xc8, 0xb6,
      0xbd, 0x71, 0xa9, 0x7f, 0x57, 0x5f, 0x08, 0xc4, 0x52, 0x0b, 0x2d, 0x66,
      0x58, 0x87, 0x56, 0xb9, 0xfc, 0x86, 0x03, 0xa3, 0x46, 0xce, 0xc7, 0x3e,
      0xba, 0x4e, 0x83, 0x50, 0xd7, 0x57, 0x0e, 0x92, 0x3c, 0xf8, 0x4c, 0x1b,
      0x33, 0xad, 0x7b, 0xdd, 0x50, 0x7d, 0x87, 0xc3, 0xdd, 0xf0, 0x10, 0x84,
      0x70, 0x3f, 0x47, 0xd4, 0x23, 0xa5, 0xab, 0xac, 0xb7, 0xa6, 0xca, 0xf5,
      0xbf, 0x7a, 0xc4, 0xc6, 0x1c, 0xfc, 0x91, 0xba, 0x94, 0x83, 0xe7, 0xb3,
      0xcb, 0xf9, 0xa0, 0x94, 0xaa, 0xe2, 0x5b, 0x17, 0x46, 0x8f, 0xb3, 0xa3,
      0xb6, 0xa4, 0x2d, 0x23, 0x22, 0x5b, 0xd4, 0x85, 0x9d, 0x22, 0x79, 0x03,
      0x7d, 0xe2, 0xff, 0x44, 0x6e, 0xb4, 0x41, 0xde, 0x70, 0x60, 0xa6, 0x75,
      0xb6, 0x1b, 0x3e, 0x59, 0x1a, 0x4f, 0x85, 0x42, 0x65, 0xff, 0xe9, 0x37,
      0xbc, 0xf5, 0x75, 0xea, 0x85, 0xb8, 0x40, 0x46, 0xaf, 0x56, 0x8a, 0x29,
      0x89, 0x02, 0x77, 0x4a, 0xd9, 0xa8, 0x88, 0x84, 0x7f, 0x3d, 0x20, 0x49,
      0x6d, 0x8c, 0x57, 0x0d, 0xa9, 0x07, 0x68, 0x6e, 0x34, 0x41, 0x99, 0x88,
      0x57, 0xe3, 0x92, 0x7f, 0xee, 0xbb, 0xf5, 0x54, 0x0d, 0x73, 0x4f, 0xc7,
      0x09, 0x32, 0x63, 0xb0, 0xef, 0xdc, 0x33, 0xf3, 0x2f, 0x93, 0xb9, 0x36,
      0xd8, 0xf8, 0x1b, 0x92, 0x07, 0x45, 0xc2, 0xc8, 0x54, 0x26, 0x60, 0x59,
      0xc9, 0x21, 0x20, 0x43, 0x5b, 0x3f, 0x41, 0xd7, 0xa3, 0xa5, 0xa7, 0xd2,
      0xc3, 0x57, 0x1a, 0x15, 0xdb, 0x21, 0x36, 0x36, 0x2f, 0x73, 0x6e, 0x09,
      0x9e, 0x89, 0x37, 0x85, 0x87, 0x6f, 0x0f, 0xf0, 0xb5, 0x1d, 0x30, 0x06,
      0x41, 0x72, 0x35, 0x12, 0x9b, 0xa4, 0x48, 0x0c, 0x41, 0x64, 0x32, 0x9f,
      0x1f, 0x9c, 0x6a, 0xaf, 0x48, 0xc9, 0x34, 0x11, 0xe3, 0x88, 0xf0, 0x0c,
      0xd8, 0xb6, 0xb1, 0x25, 0xf4, 0xf1, 0xd3, 0xfb, 0xf2, 0x1e, 0xe7, 0xad,
      0x43, 0x55, 0xa4, 0x16, 0x10, 0x1c, 0xd8, 0x57, 0xf6, 0xae, 0x91, 0x95,
      0x8a, 0xa8, 0x8b, 0x31, 0x13, 0x4a, 0x7b, 0x69, 0x06, 0xaa, 0x18, 0x4d},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 89
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     89,
     32,
     {0xb7, 0x7b, 0x9c, 0x58, 0x62, 0xc9, 0xfd, 0x0f, 0x4e, 0x4d, 0x72, 0xfb,
      0x7b, 0xcb, 0x23, 0xb2, 0xa5, 0xd2, 0x12, 0x4f, 0x13, 0xaa, 0x70, 0x01,
      0x27, 0x54, 0x51, 0xa1, 0x01, 0x48, 0x99, 0x3a, 0x3e, 0x84, 0x6e, 0x0b,
      0x29, 0x15, 0x7a, 0xa3, 0xa1, 0xa8, 0xae, 0x64, 0x3e, 0x2e, 0xe8, 0x4a,
      0x45, 0x9b, 0x03, 0x32, 0x01, 0x69, 0x26, 0x97, 0xef, 0xf5, 0x3b, 0x36,
      0x06, 0xe8, 0x5c, 0x66, 0x49, 0xd7, 0x6c, 0x82, 0x88, 0x89, 0x94, 0x99,
      0xf2, 0x75, 0x19, 0x18, 0x87, 0x9a, 0x03, 0x4d, 0x61, 0x65, 0x43, 0xc0,
      0xb7, 0xcf, 0xb2, 0x15, 0x74, 0x4b, 0x8d, 0xd0, 0x3e, 0x50, 0xce, 0x4e,
      0xed, 0xa2, 0x89, 0x1d, 0xdb, 0x8c, 0xa9, 0xc5, 0x68, 0xcc, 0xf9, 0x8b,
      0x31, 0x28, 0xbe, 0x25, 0xe1, 0x91, 0xa4, 0x46, 0x2f, 0x64, 0x58, 0xc7,
      0x18, 0xb3, 0x3e, 0x5f, 0x51, 0x9e, 0x3d, 0xe1, 0x52, 0xb0, 0xec, 0x69,
      0x1f, 0x2f, 0x5b, 0x8f, 0x3c, 0xc1, 0x50, 0xce, 0x37, 0x81, 0x40, 0x95,
      0x00, 0x1c, 0xd6, 0x0b, 0x3d, 0xc6, 0xe6, 0x94, 0xa3, 0xdf, 0x5a, 0xab,
      0x7a, 0x0c, 0x1b, 0x2d, 0xc1, 0x52, 0xc2, 0x69, 0x01, 0x29, 0x4b, 0x01,
      0xcb, 0xa4, 0x3b, 0x74, 0xe4, 0xe2, 0x8d, 0x14, 0xa9, 0xa6, 0x14, 0xd0,
      0x19, 0x8c, 0x30, 0xfe, 0x57, 0x88, 0x31, 0xc8, 0xd1, 0xb5, 0x1b, 0x1d,
      0xb0, 0xdc, 0x34, 0xf6, 0xc4, 0x7d, 0xe0, 0xd3, 0x8d, 0x20, 0xef, 0xd1,
      0xaf, 0xc8, 0xd3, 0x85, 0xe6, 0xbf, 0xfe, 0xae, 0x43, 0x28, 0x0f, 0x62,
      0xa5, 0xf2, 0x71, 0x5a, 0xf7, 0x9a, 0xf6, 0x4f, 0x04, 0xd1, 0x26, 0xe1,
      0xdd, 0x36, 0x06, 0x7b, 0xb4, 0x4d, 0x01, 0xeb, 0xc7, 0x87, 0x69, 0x76,
      0x6b, 0xd4, 0x33, 0x2a, 0x43, 0xdb, 0xa1, 0xb1, 0x24, 0xa4, 0xcb, 0xed,
      0x38, 0x1c, 0xcb, 0x43, 0x95, 0x2e, 0xe4, 0xcc, 0x19, 0x20, 0x1f, 0x05,
      0x55, 0x8c, 0x11, 0xf5, 0x1a, 0xb5, 0xe7, 0x6b, 0x76, 0xb0, 0x1f, 0xcd,
      0x03, 0x6a, 0x94, 0x9e, 0xc9, 0xe4, 0xd7, 0x15, 0x3f, 0xb2, 0x5a, 0x1a,
      0xaf, 0xdc, 0x8e, 0x0f, 0x17, 0x54, 0xbb, 0x59, 0xff, 0xec, 0xb9, 0xa6,
      0xfd, 0x9c, 0xb0, 0x5d, 0x52, 0x76, 0x61, 0xbc, 0x01, 0x3c, 0xb7, 0x3c,
      0xec, 0x4a, 0xd1, 0xab, 0x04, 0x6e, 0x1e, 0x94, 0xb6, 0xd5, 0x18, 0x60,
      0x4c, 0x7c, 0xe7, 0xba, 0xe1, 0xdd, 0x13, 0x19, 0xb6, 0x12, 0xcd, 0xe5,
      0x29, 0xa6, 0xae, 0x58, 0x8c, 0x4c, 0x6a, 0x6a, 0x76, 0x69, 0xe8, 0x2e,
      0x14, 0x1b, 0xa6, 0x35, 0x2e, 0x45, 0x52, 0xfd, 0xf0, 0x5d, 0x9d, 0x1e,
      0x3f, 0xa2, 0x17, 0xac, 0x5b, 0x38, 0x62, 0x9d, 0x81, 0xed, 0x74, 0x96,
      0x29, 0xec, 0x53, 0xf3, 0xb3, 0x0f, 0x29, 0xdf, 0x88, 0x3f, 0xa6, 0x8e},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: bit 7 of masked_db not cleared
    // tcID: 90
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     90,
     32,
     {0x6a, 0xe7, 0x42, 0x56, 0x10, 0xf6, 0xd9, 0xb6, 0xcf, 0x5a, 0x35, 0x8b,
      0xdf, 0xf3, 0xbd, 0xd0, 0x08, 0x02, 0xd5, 0x5c, 0xda, 0xba, 0x22, 0x01,
      0x79, 0x47, 0x38, 0xb9, 0x00, 0x48, 0x9d, 0xfe, 0xb1, 0x1d, 0x92, 0x1d,
      0x87, 0x44, 0x9e, 0xf9, 0xd1, 0xe5, 0xb0, 0xde, 0xae, 0x4b, 0xdb, 0x26,
      0xcc, 0x13, 0xc9, 0x91, 0x6a, 0x76, 0x7c, 0xde, 0x8e, 0x0e, 0xf6, 0x7d,
      0xe6, 0xf8, 0x04, 0x2e, 0x1d, 0x5f, 0x60, 0x0b, 0xf7, 0x07, 0xf6, 0x53,
      0x80, 0xf9, 0x71, 0x22, 0x2d, 0x37, 0x08, 0x8e, 0xda, 0xaf, 0xa4, 0x90,
      0x9e, 0xd5, 0x66, 0x69, 0x46, 0x01, 0xe2, 0x5b, 0xec, 0x8c, 0x31, 0x28,
      0xdd, 0x61, 0xe6, 0x64, 0x68, 0x8b, 0x5c, 0xe2, 0xed, 0x2f, 0x62, 0x6a,
      0x5b, 0x61, 0x8b, 0xb1, 0x0d, 0x12, 0xcc, 0x78, 0xeb, 0xbb, 0x0f, 0x3c,
      0xd6, 0x88, 0x3b, 0x64, 0x76, 0xfe, 0x4f, 0x89, 0x00, 0x8d, 0x9e, 0x8f,
      0xeb, 0x7e, 0x83, 0x5f, 0xa8, 0x73, 0xf2, 0xd6, 0xd9, 0x97, 0x34, 0x12,
      0xab, 0xcf, 0x12, 0xd2, 0x64, 0x67, 0x23, 0xb1, 0xa5, 0xab, 0x4e, 0x3b,
      0x20, 0x6d, 0x49, 0xab, 0x6f, 0x47, 0x78, 0x90, 0x10, 0xcf, 0x90, 0x2a,
      0xdf, 0x72, 0x0a, 0x02, 0xc7, 0x67, 0x78, 0x47, 0x92, 0x54, 0x87, 0x63,
      0x4f, 0x81, 0xe1, 0x63, 0x81, 0x9f, 0x28, 0x6d, 0xa4, 0xd4, 0x24, 0x37,
      0xe6, 0x6e, 0xad, 0x92, 0x78, 0xa0, 0x88, 0xd9, 0xa2, 0x62, 0x8a, 0xec,
      0x13, 0x7b, 0xe6, 0x0e, 0xac, 0x2e, 0xb3, 0x03, 0x06, 0xe5, 0x98, 0xb9,
      0x45, 0x9f, 0x0e, 0xe1, 0xc7, 0x9d, 0xc1, 0x32, 0x24, 0x8f, 0x01, 0x3f,
      0x15, 0xfb, 0x80, 0xba, 0x71, 0x37, 0x03, 0xb6, 0x68, 0x48, 0x61, 0x2d,
      0x8f, 0x4e, 0x5d, 0x6b, 0xc4, 0x44, 0xe1, 0x66, 0x99, 0x8f, 0x31, 0x07,
      0xb4, 0x59, 0xef, 0xc7, 0x3e, 0xbe, 0x1b, 0xdc, 0x0b, 0x98, 0xe4, 0xd5,
      0x7b, 0xb9, 0x60, 0xd6, 0xdb, 0x05, 0x40, 0xf6, 0x8b, 0x96, 0x21, 0x2d,
      0xa6, 0xff, 0xb0, 0x5b, 0xac, 0x7a, 0xce, 0x76, 0xdb, 0x7b, 0x3b, 0xb6,
      0x91, 0x88, 0x71, 0x5c, 0x09, 0x1f, 0x14, 0x35, 0x4f, 0xbb, 0x8a, 0x02,
      0xcf, 0x2b, 0x2d, 0x77, 0xe7, 0xf2, 0xe8, 0xdb, 0x50, 0x5e, 0x93, 0x60,
      0x3b, 0xbf, 0xff, 0x2f, 0x33, 0xba, 0x54, 0xbe, 0x38, 0x63, 0x0d, 0xba,
      0x29, 0x1b, 0xef, 0xec, 0xa4, 0x5c, 0x76, 0xc6, 0x7f, 0x34, 0x4b, 0x9d,
      0xaf, 0x7a, 0x7b, 0x07, 0x12, 0xb5, 0xa4, 0x9e, 0x7b, 0x6a, 0xf2, 0x97,
      0x34, 0x51, 0x65, 0x70, 0xca, 0xc3, 0x2d, 0x02, 0x07, 0x4a, 0x74, 0xcc,
      0x0e, 0x49, 0x79, 0x75, 0x08, 0xe1, 0xaf, 0xf2, 0xaf, 0x9f, 0x20, 0xa7,
      0x16, 0x34, 0x40, 0xfd, 0x96, 0x2b, 0xbc, 0xc5, 0x26, 0x9d, 0x8f, 0x13},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of masked_db changed to 0
    // tcID: 91
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     91,
     32,
     {0xb9, 0xbd, 0xe8, 0xfc, 0x00, 0x5a, 0xb0, 0xb6, 0xb0, 0x31, 0x7a, 0xad,
      0xbe, 0xf7, 0xd6, 0xe8, 0xab, 0xb6, 0x93, 0x91, 0xbd, 0x7e, 0xa4, 0x3f,
      0xba, 0x5a, 0x49, 0xff, 0xec, 0x02, 0x97, 0x9f, 0x89, 0xd0, 0xa9, 0xef,
      0xea, 0xcf, 0xcc, 0xab, 0xae, 0x27, 0x1c, 0x99, 0x8a, 0xd7, 0xfb, 0xff,
      0x44, 0x42, 0x36, 0x7c, 0x07, 0xe4, 0x9a, 0x89, 0x2b, 0x96, 0x32, 0xbf,
      0x4f, 0x30, 0xde, 0x3e, 0x95, 0x58, 0x38, 0x75, 0xf3, 0x06, 0x9f, 0xd3,
      0x29, 0x9a, 0x30, 0xbc, 0x21, 0xe7, 0x45, 0x26, 0xcc, 0x51, 0xcb, 0x10,
      0xda, 0xfe, 0x22, 0xb0, 0x6d, 0x3a, 0x41, 0x2a, 0x65, 0x09, 0xda, 0xa8,
      0x3d, 0x33, 0x7e, 0x18, 0xc5, 0xde, 0xe6, 0x59, 0x1a, 0x11, 0x26, 0x2e,
      0x00, 0x8c, 0x3b, 0x56, 0x2a, 0x18, 0xa9, 0xad, 0xa3, 0x16, 0x92, 0x67,
      0xea, 0xa8, 0x49, 0xb1, 0x6a, 0x37, 0x7b, 0x19, 0x5c, 0xa6, 0xf8, 0x3d,
      0xf0, 0xd2, 0xc2, 0x94, 0x5a, 0x3d, 0x3f, 0xc2, 0xb8, 0x72, 0xbc, 0x2b,
      0xa9, 0x65, 0xef, 0x41, 0x86, 0xad, 0x1e, 0x7e, 0xa5, 0xb5, 0x6f, 0xb6,
      0x89, 0xfa, 0xda, 0x3f, 0x37, 0x7e, 0x08, 0x97, 0xe5, 0xcf, 0x86, 0x90,
      0x6d, 0xd2, 0xd8, 0x94, 0x84, 0x8a, 0x6f, 0x3d, 0x64, 0xd9, 0x6a, 0x55,
      0x23, 0xfd, 0x74, 0xd2, 0xe8, 0x41, 0x88, 0x09, 0xfc, 0xef, 0xe5, 0xb9,
      0xbf, 0x12, 0xf5, 0xae, 0x71, 0x89, 0xe2, 0xaa, 0xd2, 0x68, 0xe8, 0x35,
      0xb5, 0xa7, 0x01, 0x07, 0x3e, 0x26, 0xbe, 0x13, 0x1c, 0x9d, 0xac, 0x06,
      0x20, 0x31, 0x42, 0xd9, 0x3c, 0x95, 0xaf, 0x3d, 0x00, 0xac, 0xec, 0x60,
      0x3a, 0xae, 0x2a, 0x24, 0xbf, 0xf3, 0xd5, 0x48, 0x1c, 0x7e, 0x71, 0xbe,
      0x5f, 0x63, 0xa1, 0xc4, 0x7e, 0xef, 0x68, 0x0a, 0x00, 0x99, 0x10, 0x08,
      0xca, 0x00, 0x47, 0xc7, 0xbe, 0xf7, 0x81, 0x2c, 0x9b, 0x82, 0x3a, 0x64,
      0xe6, 0xcb, 0x40, 0xd0, 0xfb, 0x44, 0x72, 0xb7, 0x02, 0xbf, 0x4f, 0x1c,
      0x94, 0x83, 0xf8, 0x35, 0x81, 0x2e, 0xb3, 0xf7, 0x08, 0x08, 0xe3, 0xde,
      0xc7, 0xab, 0x2c, 0xe2, 0xd8, 0xcf, 0x1c, 0x0d, 0xed, 0xe8, 0x52, 0x17,
      0x80, 0x51, 0x31, 0x40, 0xf1, 0x0d, 0x84, 0x72, 0x7d, 0x4f, 0x14, 0xae,
      0x06, 0xf6, 0x52, 0x76, 0xfe, 0xba, 0x18, 0x57, 0xa7, 0xe8, 0x79, 0xe9,
      0xc4, 0xf5, 0x9c, 0x80, 0x76, 0x0b, 0x11, 0x7e, 0x1c, 0x40, 0x83, 0xe3,
      0x42, 0x01, 0x8d, 0xa1, 0xc4, 0x2a, 0xdc, 0x6c, 0x52, 0x55, 0x40, 0x4a,
      0xda, 0xf8, 0x46, 0x0d, 0x12, 0x2d, 0x3c, 0x67, 0x0a, 0xa2, 0x9b, 0x58,
      0xc0, 0x87, 0xd1, 0x18, 0x64, 0x3e, 0xac, 0xe8, 0x66, 0x67, 0xe6, 0xba,
      0xd6, 0xc0, 0x7f, 0x07, 0x8f, 0x9c, 0xdb, 0x86, 0x18, 0xb4, 0x8e, 0x92},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte in em modified
    // tcID: 92
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     92,
     32,
     {0x87, 0x2f, 0x41, 0x08, 0x15, 0x92, 0x64, 0x94, 0x66, 0x9f, 0xf8, 0x1d,
      0xc7, 0x11, 0x4e, 0x09, 0x6f, 0x00, 0x77, 0x90, 0xf6, 0xa4, 0xae, 0x3a,
      0x94, 0x6b, 0x64, 0x98, 0x4e, 0xb2, 0x8b, 0xf2, 0x83, 0x51, 0x61, 0x6c,
      0xc8, 0x2e, 0xd3, 0x41, 0x72, 0xf1, 0xd1, 0xd0, 0xa8, 0x91, 0x8f, 0x87,
      0xd6, 0x42, 0x58, 0x32, 0x8d, 0xb6, 0x3b, 0x72, 0x12, 0x7f, 0xbd, 0x26,
      0x32, 0x0a, 0x21, 0xc1, 0x14, 0xa7, 0xf0, 0xb6, 0xc8, 0x8e, 0xf7, 0x17,
      0xd9, 0x49, 0xf5, 0x7a, 0x28, 0xe6, 0x62, 0x44, 0xb1, 0xfb, 0xaa, 0xa9,
      0x42, 0xd3, 0xab, 0x22, 0x45, 0xac, 0x76, 0xf0, 0xcc, 0x4b, 0xaf, 0xcc,
      0x11, 0x9a, 0x64, 0xf7, 0xd1, 0x67, 0xe3, 0xe2, 0xa6, 0x4d, 0xc9, 0xa0,
      0x04, 0x46, 0x4b, 0x28, 0xbf, 0xdc, 0xac, 0x00, 0xa2, 0x4e, 0xd7, 0xe3,
      0x68, 0x9c, 0xa1, 0xed, 0x23, 0x48, 0x0c, 0x1a, 0x06, 0x25, 0x60, 0x1c,
      0x4e, 0x7f, 0x1e, 0x37, 0x4b, 0x54, 0xc1, 0xc1, 0xfb, 0xed, 0x91, 0xe0,
      0x96, 0x7b, 0x40, 0xa3, 0x92, 0x02, 0x10, 0xb8, 0x46, 0x19, 0xc2, 0x32,
      0x17, 0xc2, 0xa6, 0xa3, 0x97, 0x34, 0x32, 0x06, 0x07, 0xab, 0xee, 0x43,
      0x2c, 0x7a, 0xd2, 0xbb, 0x0a, 0x8b, 0x73, 0x54, 0x00, 0xbf, 0x77, 0x52,
      0x56, 0xa6, 0x13, 0x24, 0xd4, 0xc4, 0xee, 0x74, 0x3f, 0xfe, 0x99, 0xa7,
      0xbc, 0xd1, 0x3a, 0x27, 0xb0, 0xfa, 0x33, 0xc0, 0xdf, 0xbe, 0x0c, 0xf9,
      0x66, 0x31, 0x16, 0x99, 0x75, 0x73, 0xa5, 0x92, 0x04, 0xc6, 0x2a, 0xa4,
      0x97, 0xe9, 0x8a, 0x69, 0x8b, 0x5d, 0xd1, 0x93, 0x14, 0xde, 0x9e, 0xf9,
      0x5c, 0xb8, 0xbd, 0xad, 0x0e, 0x07, 0xb7, 0x22, 0xeb, 0x67, 0x95, 0xf6,
      0xea, 0x80, 0x98, 0xb7, 0xb0, 0x92, 0xf7, 0xbd, 0xf7, 0x3a, 0xa4, 0x59,
      0xdd, 0x85, 0x84, 0x3b, 0x31, 0x0d, 0x71, 0xe0, 0x40, 0x04, 0x70, 0xac,
      0x14, 0xdb, 0x38, 0x39, 0x40, 0x51, 0x9c, 0x06, 0x0d, 0x11, 0x1f, 0x0b,
      0x80, 0x89, 0x60, 0x83, 0xb6, 0xfb, 0x30, 0x5e, 0xe6, 0xd9, 0xd7, 0x87,
      0x9d, 0x17, 0x7f, 0x7c, 0xfd, 0x85, 0xc9, 0x13, 0xd2, 0x26, 0xfd, 0x6c,
      0x75, 0xf3, 0x85, 0x19, 0xd7, 0xe8, 0xf6, 0xd3, 0x2b, 0xce, 0x50, 0xe8,
      0x59, 0x01, 0xfe, 0x6b, 0xdf, 0xc7, 0x49, 0x97, 0x86, 0x2a, 0x3b, 0x80,
      0x9e, 0x5e, 0xd5, 0x79, 0x30, 0x13, 0xcd, 0x19, 0xaf, 0x9e, 0xfc, 0xa6,
      0x16, 0xa9, 0xac, 0x3e, 0x34, 0x61, 0x36, 0x14, 0x23, 0x74, 0xf5, 0x8c,
      0xa8, 0x23, 0xb6, 0xa6, 0xb2, 0x87, 0x0b, 0xfe, 0xc4, 0x12, 0x07, 0xb0,
      0xa8, 0xf5, 0x8d, 0x72, 0xc1, 0x19, 0xe3, 0x19, 0xa3, 0x93, 0x4c, 0xbd,
      0x40, 0x45, 0x1f, 0x0a, 0x1e, 0x26, 0xb4, 0x47, 0xa5, 0x68, 0x7b, 0x9a},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte in em modified
    // tcID: 93
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     93,
     32,
     {0x5e, 0x0a, 0x2f, 0x62, 0x7d, 0x11, 0xc2, 0xf5, 0xc2, 0xa6, 0x1c, 0xec,
      0x6b, 0x9a, 0xb6, 0xea, 0x6f, 0x26, 0x20, 0x08, 0x5e, 0x52, 0xab, 0x1d,
      0x16, 0x23, 0x65, 0xa2, 0xc7, 0x04, 0x01, 0x78, 0xb3, 0xe6, 0x22, 0x25,
      0x03, 0xef, 0xdb, 0xc6, 0x6e, 0xff, 0x0c, 0xb8, 0x92, 0xbe, 0x95, 0xab,
      0xee, 0x6a, 0xe0, 0x2a, 0xf0, 0xa2, 0x94, 0x36, 0xde, 0x4e, 0xcd, 0x2f,
      0xf6, 0x3e, 0xb7, 0xe0, 0x82, 0xd5, 0x1a, 0xb3, 0x1d, 0x35, 0x83, 0x09,
      0x74, 0x7c, 0xe6, 0x1e, 0x30, 0xdf, 0x4a, 0xb3, 0x38, 0x23, 0x41, 0xb8,
      0x8e, 0xb2, 0xda, 0x84, 0x40, 0x6a, 0xe2, 0x0f, 0xb3, 0xbf, 0x9a, 0x96,
      0x8c, 0xf5, 0xcc, 0xc8, 0x71, 0xbe, 0x02, 0xf6, 0xcd, 0x9f, 0x2a, 0x89,
      0xff, 0xc6, 0xf3, 0xa6, 0x9a, 0x58, 0x95, 0x26, 0xe8, 0xa4, 0xf1, 0xa8,
      0xc0, 0x49, 0x28, 0x6f, 0xfc, 0xa8, 0x35, 0x9e, 0x81, 0xcb, 0x31, 0x73,
      0xa2, 0xd2, 0xe2, 0xcc, 0x76, 0xa4, 0x82, 0x9e, 0xde, 0xbd, 0xd3, 0xdb,
      0xda, 0x32, 0x7a, 0x92, 0xdd, 0x35, 0x20, 0x2b, 0x59, 0x7b, 0xdf, 0x07,
      0x7d, 0x7a, 0xc2, 0x92, 0x4f, 0x8c, 0xfb, 0x29, 0xa8, 0x5d, 0xc2, 0x5d,
      0xfd, 0x2a, 0xb6, 0xe7, 0x70, 0xcc, 0x80, 0x12, 0x0a, 0x7b, 0xd5, 0x94,
      0xe0, 0x20, 0x39, 0x2e, 0x58, 0xac, 0xca, 0x9d, 0x73, 0x56, 0x77, 0x3e,
      0x58, 0xaa, 0xcf, 0xab, 0xd6, 0x6c, 0x2d, 0x9a, 0x88, 0x83, 0x79, 0xb7,
      0x38, 0x68, 0xd0, 0x7e, 0x3d, 0x14, 0xaf, 0x1d, 0xad, 0xc1, 0x84, 0x3f,
      0x2a, 0x6c, 0x8e, 0x14, 0xc9, 0x3b, 0x3b, 0x29, 0x13, 0x41, 0x69, 0xc5,
      0xae, 0x3b, 0x29, 0x3e, 0xe6, 0xf6, 0xa4, 0x75, 0xf2, 0x0c, 0x7c, 0x15,
      0x92, 0x58, 0xa8, 0xcf, 0x1a, 0x1c, 0xed, 0xe6, 0x02, 0xaf, 0xa9, 0xfe,
      0x7c, 0x61, 0xa3, 0x21, 0x8c, 0x34, 0x02, 0x4a, 0x87, 0xbd, 0xf4, 0xa6,
      0x4e, 0xf1, 0x2c, 0x78, 0xa1, 0x1a, 0x50, 0xbc, 0x15, 0x21, 0x83, 0x6b,
      0xc4, 0xd8, 0x4e, 0xba, 0x90, 0xab, 0x1d, 0xb1, 0xb1, 0x7e, 0xf0, 0xe6,
      0xe9, 0x5d, 0x7c, 0x9d, 0xe5, 0xd6, 0xb8, 0x4e, 0x11, 0xdd, 0x54, 0x22,
      0xa8, 0x69, 0xec, 0xc7, 0xf9, 0x0f, 0x95, 0x27, 0x94, 0xf6, 0x09, 0x3d,
      0xf8, 0x9f, 0xb6, 0x64, 0xaa, 0xe8, 0x66, 0x69, 0xc6, 0x3b, 0xd4, 0x6d,
      0xe5, 0x97, 0x23, 0x88, 0xd8, 0x19, 0x08, 0xfe, 0x56, 0xc6, 0xbd, 0x02,
      0x9e, 0x39, 0x30, 0x47, 0xc5, 0x29, 0x24, 0xa9, 0x7a, 0xa5, 0x5c, 0x07,
      0xd4, 0x82, 0xf9, 0x8b, 0x78, 0x4e, 0x6d, 0x39, 0xcb, 0xc2, 0x80, 0x33,
      0x0a, 0x34, 0xac, 0x4a, 0x8a, 0x72, 0x73, 0x32, 0x35, 0xe6, 0x62, 0x34,
      0x90, 0x3a, 0x45, 0x05, 0x22, 0x8a, 0x3f, 0xc8, 0xe1, 0x14, 0x60, 0x34},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte in em modified
    // tcID: 94
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     94,
     32,
     {0x07, 0xf0, 0x77, 0x24, 0x11, 0xcd, 0xb1, 0xe0, 0x28, 0x02, 0xf8, 0xca,
      0x69, 0x9b, 0xf5, 0x5b, 0xeb, 0xad, 0xd2, 0x54, 0xc9, 0xaa, 0xdc, 0x16,
      0xe1, 0xd6, 0xd4, 0xaf, 0x3e, 0x12, 0x67, 0x0b, 0xfd, 0x2a, 0xdc, 0x2d,
      0xbe, 0x80, 0x19, 0x5f, 0x06, 0x5d, 0x75, 0xfa, 0x4a, 0x25, 0xef, 0x75,
      0x77, 0x66, 0xff, 0xfa, 0x4d, 0x90, 0x2b, 0x38, 0x6a, 0x9c, 0x7f, 0x24,
      0x72, 0x06, 0xf6, 0x0c, 0x74, 0x49, 0x38, 0xf5, 0x0d, 0x6f, 0x84, 0x01,
      0x70, 0xae, 0x94, 0xc6, 0x79, 0x22, 0x99, 0xc3, 0x86, 0xa1, 0xd6, 0xd7,
      0xae, 0xb7, 0x3f, 0xec, 0xd5, 0xb7, 0x2a, 0x28, 0x24, 0x9a, 0x2a, 0xd7,
      0x71, 0xa5, 0x51, 0x8f, 0xb6, 0x94, 0xf5, 0x49, 0x24, 0xe1, 0x5c, 0xec,
      0xb2, 0xd7, 0x55, 0xda, 0x44, 0xb5, 0x45, 0x35, 0xdc, 0x6f, 0x8f, 0xce,
      0x0e, 0x91, 0xea, 0x16, 0x0e, 0xa9, 0x42, 0xc9, 0xe3, 0x4e, 0xef, 0x5d,
      0x73, 0x67, 0xc9, 0x06, 0x5f, 0x5a, 0xc2, 0x70, 0xef, 0x11, 0xa3, 0x5b,
      0xce, 0xdf, 0x66, 0x31, 0x83, 0xf7, 0x4c, 0xd2, 0xd5, 0x04, 0x41, 0x0b,
      0x97, 0xb4, 0x03, 0x4a, 0x59, 0xd2, 0x01, 0x33, 0x3f, 0x23, 0x5f, 0x59,
      0x92, 0x4a, 0xad, 0x30, 0xfa, 0x87, 0x7a, 0x31, 0xe0, 0xc1, 0x57, 0x3f,
      0x62, 0xe7, 0xbe, 0x41, 0xf9, 0x61, 0xe9, 0xc3, 0x1e, 0xc3, 0x34, 0x15,
      0x3d, 0x83, 0xad, 0xb0, 0xef, 0x38, 0x96, 0x3f, 0x0f, 0x5e, 0x20, 0xc9,
      0x0b, 0x67, 0xae, 0x5c, 0x5e, 0x2e, 0xf8, 0x52, 0x05, 0x87, 0x58, 0x7c,
      0x22, 0xe8, 0x69, 0x88, 0x1a, 0xbc, 0x6b, 0xfc, 0xec, 0xd6, 0x2a, 0x1f,
      0x87, 0x81, 0x15, 0xe6, 0xcb, 0xca, 0x72, 0x59, 0xe8, 0xb9, 0xe1, 0x16,
      0xfd, 0xee, 0xd8, 0x41, 0xf1, 0xd6, 0x98, 0xe8, 0x5f, 0x65, 0xc7, 0xae,
      0x07, 0x42, 0x1c, 0xf3, 0x09, 0x6f, 0x6b, 0x31, 0xa0, 0x7e, 0x25, 0x19,
      0x44, 0xbd, 0x7e, 0x2c, 0xf5, 0x0c, 0xcf, 0x69, 0xa1, 0x8d, 0xe7, 0xc1,
      0x77, 0x00, 0xb2, 0x57, 0x86, 0xd2, 0x9e, 0xd7, 0x4f, 0xe8, 0xd5, 0x75,
      0x7d, 0x4d, 0xab, 0xe2, 0xd6, 0xfb, 0xff, 0xc2, 0x22, 0x74, 0x48, 0xee,
      0x8d, 0x55, 0x59, 0xf9, 0x92, 0xa3, 0xb6, 0x35, 0xcd, 0x74, 0xa6, 0x8c,
      0x32, 0x9f, 0x17, 0x85, 0xe7, 0x43, 0xce, 0x9d, 0x3b, 0xee, 0x57, 0xb9,
      0x97, 0xf9, 0xae, 0x2d, 0xeb, 0x53, 0x1f, 0x89, 0x94, 0xad, 0xa9, 0x8d,
      0x9a, 0x35, 0x36, 0xb0, 0x74, 0x81, 0x4c, 0x2d, 0x50, 0x03, 0xd6, 0xa3,
      0xd5, 0x0a, 0x9e, 0x56, 0x28, 0x7f, 0x3a, 0xee, 0x8e, 0xd8, 0x71, 0x04,
      0xc1, 0x96, 0x56, 0xa6, 0x05, 0x75, 0x15, 0xfe, 0x17, 0xbb, 0x2a, 0x72,
      0xa5, 0x3a, 0x7c, 0x19, 0xb7, 0xa8, 0x14, 0x25, 0x2c, 0x8b, 0xee, 0x61},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is 0
    // tcID: 95
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     95,
     32,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is 1
    // tcID: 96
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     96,
     32,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is n-1
    // tcID: 97
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     97,
     32,
     {0xc6, 0xfe, 0x23, 0x79, 0x25, 0x66, 0x02, 0x3c, 0x26, 0x52, 0x87, 0xc5,
      0xac, 0x6f, 0x71, 0x54, 0x1c, 0x09, 0x94, 0xd1, 0x1d, 0x05, 0x9e, 0xe6,
      0x40, 0x39, 0x86, 0xef, 0xa2, 0x1c, 0x24, 0xb5, 0x1b, 0xd9, 0x1d, 0x88,
      0x62, 0xf9, 0xdf, 0x79, 0xa4, 0xe3, 0x28, 0xe3, 0xe2, 0x7c, 0x83, 0xdf,
      0x26, 0x0b, 0x25, 0xa9, 0xb4, 0x34, 0x20, 0xaf, 0xfc, 0x44, 0xb5, 0x1e,
      0x8d, 0x75, 0x25, 0xb6, 0xf2, 0x9c, 0x37, 0x2a, 0x40, 0x51, 0x04, 0x73,
      0x20, 0x07, 0x52, 0x7a, 0x62, 0xed, 0x82, 0xfa, 0xc7, 0x3f, 0x48, 0x92,
      0xa8, 0x0e, 0x09, 0x68, 0x2a, 0x41, 0xa5, 0x8c, 0xd3, 0x47, 0x01, 0x7f,
      0x3b, 0xe7, 0xd8, 0x01, 0x33, 0x4f, 0x92, 0xd9, 0x32, 0x1a, 0xaf, 0xd5,
      0x3b, 0x51, 0xbf, 0xfa, 0xbf, 0xc7, 0x52, 0xcf, 0xcc, 0xae, 0x0b, 0x1e,
      0xe0, 0x3b, 0xda, 0xff, 0x9e, 0x42, 0x8c, 0xc1, 0xc1, 0x17, 0xf1, 0xac,
      0x96, 0xb4, 0xfe, 0x23, 0xf8, 0xc2, 0x3e, 0x63, 0x81, 0x18, 0x6a, 0x66,
      0xfd, 0x59, 0x28, 0x93, 0x39, 0xae, 0x55, 0xc4, 0xbc, 0xda, 0xdb, 0xff,
      0x84, 0xab, 0xda, 0xa5, 0x32, 0x24, 0x0d, 0x4e, 0x1d, 0x28, 0xb2, 0xd0,
      0x48, 0x1d, 0xad, 0xd3, 0xb2, 0x46, 0x55, 0x7c, 0xa8, 0xfe, 0x18, 0x09,
      0x28, 0x17, 0x73, 0x0b, 0x39, 0xe6, 0xee, 0x37, 0x8f, 0xfc, 0xc8, 0x5b,
      0x19, 0xff, 0xdc, 0x91, 0x6a, 0x9b, 0x99, 0x1a, 0x6b, 0x66, 0xd4, 0xa9,
      0xc7, 0xba, 0xb5, 0xf5, 0xe7, 0xa3, 0x72, 0x21, 0x01, 0x14, 0x2e, 0x7a,
      0x41, 0x08, 0xc1, 0x5d, 0x57, 0x3b, 0x15, 0x28, 0x9e, 0x07, 0xe4, 0x6e,
      0xae, 0xa0, 0x7b, 0x42, 0xc2, 0xab, 0xcb, 0xa3, 0x30, 0xe9, 0x95, 0x54,
      0xb4, 0x65, 0x61, 0x65, 0xbb, 0x4c, 0x0d, 0xb2, 0xb6, 0x39, 0x3a, 0x07,
      0xec, 0xa5, 0x75, 0xc5, 0x1a, 0x93, 0xc4, 0xe1, 0x5b, 0xdb, 0x0f, 0x74,
      0x79, 0x09, 0x44, 0x7e, 0x3e, 0xfe, 0x34, 0xc6, 0x7c, 0xa8, 0x95, 0x4b,
      0x53, 0x0e, 0x56, 0xa2, 0x0a, 0x1b, 0x6d, 0x84, 0xd4, 0x5e, 0xd1, 0xbc,
      0xd3, 0xaa, 0x58, 0xec, 0x06, 0xf1, 0x84, 0xee, 0x58, 0x57, 0xaa, 0xa8,
      0x19, 0xe1, 0xcc, 0xa9, 0xa2, 0x6f, 0x4e, 0x28, 0xd6, 0xb9, 0x77, 0xd3,
      0x39, 0x16, 0xdb, 0x98, 0x96, 0xd2, 0x52, 0xd1, 0xaf, 0xa7, 0x62, 0xe2,
      0x87, 0xcb, 0x0d, 0x38, 0x4c, 0xc7, 0x5b, 0xfe, 0x53, 0xf4, 0xe9, 0x22,
      0xd0, 0x2d, 0xd0, 0xa4, 0x81, 0xc0, 0x42, 0xe2, 0xd3, 0x06, 0xb4, 0xb3,
      0xc1, 0x89, 0x37, 0x1e, 0x57, 0x5b, 0x25, 0xe0, 0x00, 0x5a, 0x16, 0x4c,
      0xf6, 0x9d, 0xd0, 0x97, 0x6e, 0x4d, 0x5b, 0xe4, 0x76, 0x80, 0x6e, 0xa6,
      0xbe, 0x60, 0x84, 0xe7, 0x1a, 0xb4, 0xf5, 0xac, 0x5c, 0x1b, 0x12, 0x02},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is n
    // tcID: 98
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     98,
     32,
     {0xc6, 0xfe, 0x23, 0x79, 0x25, 0x66, 0x02, 0x3c, 0x26, 0x52, 0x87, 0xc5,
      0xac, 0x6f, 0x71, 0x54, 0x1c, 0x09, 0x94, 0xd1, 0x1d, 0x05, 0x9e, 0xe6,
      0x40, 0x39, 0x86, 0xef, 0xa2, 0x1c, 0x24, 0xb5, 0x1b, 0xd9, 0x1d, 0x88,
      0x62, 0xf9, 0xdf, 0x79, 0xa4, 0xe3, 0x28, 0xe3, 0xe2, 0x7c, 0x83, 0xdf,
      0x26, 0x0b, 0x25, 0xa9, 0xb4, 0x34, 0x20, 0xaf, 0xfc, 0x44, 0xb5, 0x1e,
      0x8d, 0x75, 0x25, 0xb6, 0xf2, 0x9c, 0x37, 0x2a, 0x40, 0x51, 0x04, 0x73,
      0x20, 0x07, 0x52, 0x7a, 0x62, 0xed, 0x82, 0xfa, 0xc7, 0x3f, 0x48, 0x92,
      0xa8, 0x0e, 0x09, 0x68, 0x2a, 0x41, 0xa5, 0x8c, 0xd3, 0x47, 0x01, 0x7f,
      0x3b, 0xe7, 0xd8, 0x01, 0x33, 0x4f, 0x92, 0xd9, 0x32, 0x1a, 0xaf, 0xd5,
      0x3b, 0x51, 0xbf, 0xfa, 0xbf, 0xc7, 0x52, 0xcf, 0xcc, 0xae, 0x0b, 0x1e,
      0xe0, 0x3b, 0xda, 0xff, 0x9e, 0x42, 0x8c, 0xc1, 0xc1, 0x17, 0xf1, 0xac,
      0x96, 0xb4, 0xfe, 0x23, 0xf8, 0xc2, 0x3e, 0x63, 0x81, 0x18, 0x6a, 0x66,
      0xfd, 0x59, 0x28, 0x93, 0x39, 0xae, 0x55, 0xc4, 0xbc, 0xda, 0xdb, 0xff,
      0x84, 0xab, 0xda, 0xa5, 0x32, 0x24, 0x0d, 0x4e, 0x1d, 0x28, 0xb2, 0xd0,
      0x48, 0x1d, 0xad, 0xd3, 0xb2, 0x46, 0x55, 0x7c, 0xa8, 0xfe, 0x18, 0x09,
      0x28, 0x17, 0x73, 0x0b, 0x39, 0xe6, 0xee, 0x37, 0x8f, 0xfc, 0xc8, 0x5b,
      0x19, 0xff, 0xdc, 0x91, 0x6a, 0x9b, 0x99, 0x1a, 0x6b, 0x66, 0xd4, 0xa9,
      0xc7, 0xba, 0xb5, 0xf5, 0xe7, 0xa3, 0x72, 0x21, 0x01, 0x14, 0x2e, 0x7a,
      0x41, 0x08, 0xc1, 0x5d, 0x57, 0x3b, 0x15, 0x28, 0x9e, 0x07, 0xe4, 0x6e,
      0xae, 0xa0, 0x7b, 0x42, 0xc2, 0xab, 0xcb, 0xa3, 0x30, 0xe9, 0x95, 0x54,
      0xb4, 0x65, 0x61, 0x65, 0xbb, 0x4c, 0x0d, 0xb2, 0xb6, 0x39, 0x3a, 0x07,
      0xec, 0xa5, 0x75, 0xc5, 0x1a, 0x93, 0xc4, 0xe1, 0x5b, 0xdb, 0x0f, 0x74,
      0x79, 0x09, 0x44, 0x7e, 0x3e, 0xfe, 0x34, 0xc6, 0x7c, 0xa8, 0x95, 0x4b,
      0x53, 0x0e, 0x56, 0xa2, 0x0a, 0x1b, 0x6d, 0x84, 0xd4, 0x5e, 0xd1, 0xbc,
      0xd3, 0xaa, 0x58, 0xec, 0x06, 0xf1, 0x84, 0xee, 0x58, 0x57, 0xaa, 0xa8,
      0x19, 0xe1, 0xcc, 0xa9, 0xa2, 0x6f, 0x4e, 0x28, 0xd6, 0xb9, 0x77, 0xd3,
      0x39, 0x16, 0xdb, 0x98, 0x96, 0xd2, 0x52, 0xd1, 0xaf, 0xa7, 0x62, 0xe2,
      0x87, 0xcb, 0x0d, 0x38, 0x4c, 0xc7, 0x5b, 0xfe, 0x53, 0xf4, 0xe9, 0x22,
      0xd0, 0x2d, 0xd0, 0xa4, 0x81, 0xc0, 0x42, 0xe2, 0xd3, 0x06, 0xb4, 0xb3,
      0xc1, 0x89, 0x37, 0x1e, 0x57, 0x5b, 0x25, 0xe0, 0x00, 0x5a, 0x16, 0x4c,
      0xf6, 0x9d, 0xd0, 0x97, 0x6e, 0x4d, 0x5b, 0xe4, 0x76, 0x80, 0x6e, 0xa6,
      0xbe, 0x60, 0x84, 0xe7, 0x1a, 0xb4, 0xf5, 0xac, 0x5c, 0x1b, 0x12, 0x03},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to signature
    // tcID: 99
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     99,
     32,
     {0x00, 0x00, 0x8f, 0x9a, 0xc1, 0x35, 0x4a, 0xf4, 0x16, 0x1d, 0x0e, 0x55,
      0xb5, 0x67, 0x48, 0x21, 0xd0, 0x28, 0x23, 0xb3, 0xa6, 0xb3, 0xf7, 0x9c,
      0xef, 0xb9, 0x8c, 0xbc, 0x77, 0xf9, 0xac, 0x2d, 0x91, 0xcc, 0x63, 0x45,
      0xf9, 0x89, 0xa7, 0x82, 0x81, 0x32, 0xf7, 0x3f, 0x36, 0x30, 0xa2, 0x47,
      0xa9, 0x36, 0xb6, 0xa0, 0x57, 0xb3, 0xe5, 0xa2, 0xfd, 0xa0, 0xc5, 0x99,
      0x9e, 0xa7, 0x72, 0x1e, 0xe8, 0x88, 0x09, 0x60, 0xc2, 0x4c, 0xd2, 0x37,
      0x7e, 0x86, 0x9c, 0xca, 0x17, 0x99, 0x74, 0x71, 0x42, 0xd5, 0x7a, 0xd6,
      0xa8, 0xd8, 0x3e, 0xc9, 0x25, 0x4d, 0x89, 0xf5, 0x91, 0xad, 0xd1, 0x1a,
      0x75, 0x8e, 0x1e, 0xa1, 0xe2, 0x9b, 0xd0, 0x8f, 0x62, 0x4d, 0x0e, 0x28,
      0xce, 0xa5, 0x2e, 0xd5, 0xee, 0xd7, 0xc0, 0xf5, 0xf4, 0x9d, 0x35, 0x33,
      0xeb, 0x1c, 0xdb, 0xb2, 0xaf, 0x83, 0x7d, 0xc4, 0x29, 0x42, 0xf9, 0xa8,
      0x6b, 0x5f, 0x4e, 0x2d, 0x5c, 0xe5, 0x06, 0x69, 0x7e, 0xf0, 0x67, 0xa3,
      0x44, 0x94, 0x9b, 0xdd, 0x89, 0xaf, 0xcc, 0x25, 0x97, 0x8a, 0xf4, 0xd5,
      0x0c, 0x30, 0x0b, 0xcd, 0x0f, 0xfc, 0x9d, 0x93, 0xcc, 0x55, 0x9e, 0x3a,
      0xe1, 0xa1, 0x32, 0x15, 0xa1, 0xd3, 0xf6, 0x03, 0x08, 0x27, 0x34, 0x0c,
      0x65, 0x91, 0x06, 0x1a, 0x5a, 0xb7, 0xe6, 0x51, 0x53, 0xb1, 0xdf, 0x8b,
      0x25, 0xe1, 0x42, 0x1f, 0x92, 0x4d, 0x39, 0xc7, 0xe6, 0xf7, 0x62, 0x43,
      0xc1, 0xbb, 0x9a, 0xe4, 0x06, 0x3d, 0x9a, 0x47, 0x5c, 0xd2, 0xec, 0xe4,
      0x5f, 0x4e, 0x28, 0x8f, 0xe0, 0x72, 0x00, 0x74, 0xe8, 0x78, 0x68, 0xd7,
      0x0a, 0x55, 0x84, 0xa9, 0xac, 0x2b, 0x47, 0xa5, 0x64, 0x17, 0xcc, 0x76,
      0xf1, 0x51, 0x54, 0x31, 0x55, 0x45, 0xa3, 0xed, 0x67, 0x04, 0xb3, 0x65,
      0xf1, 0x5d, 0x34, 0x32, 0x08, 0x04, 0x46, 0x9c, 0x3b, 0x09, 0xed, 0x21,
      0x1c, 0xbc, 0x9e, 0x9e, 0x76, 0x7b, 0x6f, 0x21, 0xfa, 0x16, 0xf8, 0x64,
      0x1d, 0x8b, 0x78, 0xb8, 0xdf, 0xf8, 0x06, 0x2a, 0x25, 0xb5, 0xbd, 0x3b,
      0x6a, 0x38, 0xcb, 0x47, 0x06, 0xc4, 0x2c, 0x1f, 0xbb, 0xe6, 0x6d, 0xb1,
      0xc0, 0x5c, 0xb5, 0x75, 0x31, 0x13, 0x2e, 0xb9, 0x4f, 0xe1, 0x56, 0x97,
      0x35, 0xc3, 0x3e, 0xc4, 0x91, 0xc3, 0x18, 0xa6, 0x86, 0xc8, 0x37, 0xac,
      0x81, 0x0b, 0xe4, 0xaf, 0xff, 0x60, 0x5f, 0x92, 0xbb, 0x39, 0x0e, 0x7a,
      0xb3, 0xcd, 0x24, 0xc0, 0xcd, 0x99, 0x7c, 0xf1, 0x3f, 0x11, 0x2e, 0x5a,
      0xa0, 0x17, 0x46, 0xf4, 0x39, 0x02, 0x43, 0x26, 0x39, 0xe1, 0xee, 0xfc,
      0xbd, 0x37, 0xb4, 0x13, 0xc5, 0x86, 0xf0, 0x57, 0xbc, 0xba, 0x40, 0xa8,
      0xf1, 0x25, 0x12, 0x51, 0xe8, 0x4c, 0xb7, 0xc8, 0x7c, 0x53, 0xc1, 0xd1,
      0xd5, 0x58},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to signature
    // tcID: 100
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     100,
     32,
     {0x8f, 0x9a, 0xc1, 0x35, 0x4a, 0xf4, 0x16, 0x1d, 0x0e, 0x55, 0xb5, 0x67,
      0x48, 0x21, 0xd0, 0x28, 0x23, 0xb3, 0xa6, 0xb3, 0xf7, 0x9c, 0xef, 0xb9,
      0x8c, 0xbc, 0x77, 0xf9, 0xac, 0x2d, 0x91, 0xcc, 0x63, 0x45, 0xf9, 0x89,
      0xa7, 0x82, 0x81, 0x32, 0xf7, 0x3f, 0x36, 0x30, 0xa2, 0x47, 0xa9, 0x36,
      0xb6, 0xa0, 0x57, 0xb3, 0xe5, 0xa2, 0xfd, 0xa0, 0xc5, 0x99, 0x9e, 0xa7,
      0x72, 0x1e, 0xe8, 0x88, 0x09, 0x60, 0xc2, 0x4c, 0xd2, 0x37, 0x7e, 0x86,
      0x9c, 0xca, 0x17, 0x99, 0x74, 0x71, 0x42, 0xd5, 0x7a, 0xd6, 0xa8, 0xd8,
      0x3e, 0xc9, 0x25, 0x4d, 0x89, 0xf5, 0x91, 0xad, 0xd1, 0x1a, 0x75, 0x8e,
      0x1e, 0xa1, 0xe2, 0x9b, 0xd0, 0x8f, 0x62, 0x4d, 0x0e, 0x28, 0xce, 0xa5,
      0x2e, 0xd5, 0xee, 0xd7, 0xc0, 0xf5, 0xf4, 0x9d, 0x35, 0x33, 0xeb, 0x1c,
      0xdb, 0xb2, 0xaf, 0x83, 0x7d, 0xc4, 0x29, 0x42, 0xf9, 0xa8, 0x6b, 0x5f,
      0x4e, 0x2d, 0x5c, 0xe5, 0x06, 0x69, 0x7e, 0xf0, 0x67, 0xa3, 0x44, 0x94,
      0x9b, 0xdd, 0x89, 0xaf, 0xcc, 0x25, 0x97, 0x8a, 0xf4, 0xd5, 0x0c, 0x30,
      0x0b, 0xcd, 0x0f, 0xfc, 0x9d, 0x93, 0xcc, 0x55, 0x9e, 0x3a, 0xe1, 0xa1,
      0x32, 0x15, 0xa1, 0xd3, 0xf6, 0x03, 0x08, 0x27, 0x34, 0x0c, 0x65, 0x91,
      0x06, 0x1a, 0x5a, 0xb7, 0xe6, 0x51, 0x53, 0xb1, 0xdf, 0x8b, 0x25, 0xe1,
      0x42, 0x1f, 0x92, 0x4d, 0x39, 0xc7, 0xe6, 0xf7, 0x62, 0x43, 0xc1, 0xbb,
      0x9a, 0xe4, 0x06, 0x3d, 0x9a, 0x47, 0x5c, 0xd2, 0xec, 0xe4, 0x5f, 0x4e,
      0x28, 0x8f, 0xe0, 0x72, 0x00, 0x74, 0xe8, 0x78, 0x68, 0xd7, 0x0a, 0x55,
      0x84, 0xa9, 0xac, 0x2b, 0x47, 0xa5, 0x64, 0x17, 0xcc, 0x76, 0xf1, 0x51,
      0x54, 0x31, 0x55, 0x45, 0xa3, 0xed, 0x67, 0x04, 0xb3, 0x65, 0xf1, 0x5d,
      0x34, 0x32, 0x08, 0x04, 0x46, 0x9c, 0x3b, 0x09, 0xed, 0x21, 0x1c, 0xbc,
      0x9e, 0x9e, 0x76, 0x7b, 0x6f, 0x21, 0xfa, 0x16, 0xf8, 0x64, 0x1d, 0x8b,
      0x78, 0xb8, 0xdf, 0xf8, 0x06, 0x2a, 0x25, 0xb5, 0xbd, 0x3b, 0x6a, 0x38,
      0xcb, 0x47, 0x06, 0xc4, 0x2c, 0x1f, 0xbb, 0xe6, 0x6d, 0xb1, 0xc0, 0x5c,
      0xb5, 0x75, 0x31, 0x13, 0x2e, 0xb9, 0x4f, 0xe1, 0x56, 0x97, 0x35, 0xc3,
      0x3e, 0xc4, 0x91, 0xc3, 0x18, 0xa6, 0x86, 0xc8, 0x37, 0xac, 0x81, 0x0b,
      0xe4, 0xaf, 0xff, 0x60, 0x5f, 0x92, 0xbb, 0x39, 0x0e, 0x7a, 0xb3, 0xcd,
      0x24, 0xc0, 0xcd, 0x99, 0x7c, 0xf1, 0x3f, 0x11, 0x2e, 0x5a, 0xa0, 0x17,
      0x46, 0xf4, 0x39, 0x02, 0x43, 0x26, 0x39, 0xe1, 0xee, 0xfc, 0xbd, 0x37,
      0xb4, 0x13, 0xc5, 0x86, 0xf0, 0x57, 0xbc, 0xba, 0x40, 0xa8, 0xf1, 0x25,
      0x12, 0x51, 0xe8, 0x4c, 0xb7, 0xc8, 0x7c, 0x53, 0xc1, 0xd1, 0xd5, 0x58,
      0x00, 0x00},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated signature
    // tcID: 101
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     101,
     32,
     {0x8f, 0x9a, 0xc1, 0x35, 0x4a, 0xf4, 0x16, 0x1d, 0x0e, 0x55, 0xb5, 0x67,
      0x48, 0x21, 0xd0, 0x28, 0x23, 0xb3, 0xa6, 0xb3, 0xf7, 0x9c, 0xef, 0xb9,
      0x8c, 0xbc, 0x77, 0xf9, 0xac, 0x2d, 0x91, 0xcc, 0x63, 0x45, 0xf9, 0x89,
      0xa7, 0x82, 0x81, 0x32, 0xf7, 0x3f, 0x36, 0x30, 0xa2, 0x47, 0xa9, 0x36,
      0xb6, 0xa0, 0x57, 0xb3, 0xe5, 0xa2, 0xfd, 0xa0, 0xc5, 0x99, 0x9e, 0xa7,
      0x72, 0x1e, 0xe8, 0x88, 0x09, 0x60, 0xc2, 0x4c, 0xd2, 0x37, 0x7e, 0x86,
      0x9c, 0xca, 0x17, 0x99, 0x74, 0x71, 0x42, 0xd5, 0x7a, 0xd6, 0xa8, 0xd8,
      0x3e, 0xc9, 0x25, 0x4d, 0x89, 0xf5, 0x91, 0xad, 0xd1, 0x1a, 0x75, 0x8e,
      0x1e, 0xa1, 0xe2, 0x9b, 0xd0, 0x8f, 0x62, 0x4d, 0x0e, 0x28, 0xce, 0xa5,
      0x2e, 0xd5, 0xee, 0xd7, 0xc0, 0xf5, 0xf4, 0x9d, 0x35, 0x33, 0xeb, 0x1c,
      0xdb, 0xb2, 0xaf, 0x83, 0x7d, 0xc4, 0x29, 0x42, 0xf9, 0xa8, 0x6b, 0x5f,
      0x4e, 0x2d, 0x5c, 0xe5, 0x06, 0x69, 0x7e, 0xf0, 0x67, 0xa3, 0x44, 0x94,
      0x9b, 0xdd, 0x89, 0xaf, 0xcc, 0x25, 0x97, 0x8a, 0xf4, 0xd5, 0x0c, 0x30,
      0x0b, 0xcd, 0x0f, 0xfc, 0x9d, 0x93, 0xcc, 0x55, 0x9e, 0x3a, 0xe1, 0xa1,
      0x32, 0x15, 0xa1, 0xd3, 0xf6, 0x03, 0x08, 0x27, 0x34, 0x0c, 0x65, 0x91,
      0x06, 0x1a, 0x5a, 0xb7, 0xe6, 0x51, 0x53, 0xb1, 0xdf, 0x8b, 0x25, 0xe1,
      0x42, 0x1f, 0x92, 0x4d, 0x39, 0xc7, 0xe6, 0xf7, 0x62, 0x43, 0xc1, 0xbb,
      0x9a, 0xe4, 0x06, 0x3d, 0x9a, 0x47, 0x5c, 0xd2, 0xec, 0xe4, 0x5f, 0x4e,
      0x28, 0x8f, 0xe0, 0x72, 0x00, 0x74, 0xe8, 0x78, 0x68, 0xd7, 0x0a, 0x55,
      0x84, 0xa9, 0xac, 0x2b, 0x47, 0xa5, 0x64, 0x17, 0xcc, 0x76, 0xf1, 0x51,
      0x54, 0x31, 0x55, 0x45, 0xa3, 0xed, 0x67, 0x04, 0xb3, 0x65, 0xf1, 0x5d,
      0x34, 0x32, 0x08, 0x04, 0x46, 0x9c, 0x3b, 0x09, 0xed, 0x21, 0x1c, 0xbc,
      0x9e, 0x9e, 0x76, 0x7b, 0x6f, 0x21, 0xfa, 0x16, 0xf8, 0x64, 0x1d, 0x8b,
      0x78, 0xb8, 0xdf, 0xf8, 0x06, 0x2a, 0x25, 0xb5, 0xbd, 0x3b, 0x6a, 0x38,
      0xcb, 0x47, 0x06, 0xc4, 0x2c, 0x1f, 0xbb, 0xe6, 0x6d, 0xb1, 0xc0, 0x5c,
      0xb5, 0x75, 0x31, 0x13, 0x2e, 0xb9, 0x4f, 0xe1, 0x56, 0x97, 0x35, 0xc3,
      0x3e, 0xc4, 0x91, 0xc3, 0x18, 0xa6, 0x86, 0xc8, 0x37, 0xac, 0x81, 0x0b,
      0xe4, 0xaf, 0xff, 0x60, 0x5f, 0x92, 0xbb, 0x39, 0x0e, 0x7a, 0xb3, 0xcd,
      0x24, 0xc0, 0xcd, 0x99, 0x7c, 0xf1, 0x3f, 0x11, 0x2e, 0x5a, 0xa0, 0x17,
      0x46, 0xf4, 0x39, 0x02, 0x43, 0x26, 0x39, 0xe1, 0xee, 0xfc, 0xbd, 0x37,
      0xb4, 0x13, 0xc5, 0x86, 0xf0, 0x57, 0xbc, 0xba, 0x40, 0xa8, 0xf1, 0x25,
      0x12, 0x51, 0xe8, 0x4c, 0xb7, 0xc8, 0x7c, 0x53, 0xc1, 0xd1},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: empty signature
    // tcID: 102
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     102,
     32,
     {},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: PKCS #1 v1.5 signature
    // tcID: 103
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     103,
     32,
     {0x63, 0x6d, 0x31, 0xd8, 0xd5, 0xdf, 0xe0, 0xfc, 0x6a, 0xb0, 0x1e, 0xf2,
      0xcc, 0xd4, 0x60, 0x2d, 0xfe, 0xa6, 0x2d, 0x38, 0x6b, 0x00, 0x2c, 0x42,
      0x9e, 0x7e, 0x84, 0x6e, 0x7a, 0x98, 0xd0, 0xcb, 0x1d, 0x44, 0x8d, 0x25,
      0xbe, 0x03, 0x9d, 0x51, 0x58, 0x88, 0x7a, 0xb4, 0x6a, 0x9d, 0xd4, 0x9c,
      0x41, 0x53, 0x7a, 0x89, 0x03, 0x6a, 0x06, 0x5f, 0xc1, 0x03, 0x29, 0xdf,
      0x05, 0x1e, 0x5f, 0x2e, 0x5c, 0x1d, 0x44, 0x36, 0xe8, 0x47, 0x90, 0xff,
      0x6d, 0xb4, 0xd3, 0xf3, 0x15, 0x75, 0xe5, 0xf0, 0xfb, 0xdf, 0xca, 0xee,
      0x62, 0x57, 0x22, 0xc5, 0x49, 0x2f, 0xce, 0xaa, 0x3f, 0xb2, 0x9d, 0x0a,
      0x86, 0x52, 0x00, 0xde, 0xc0, 0x6e, 0x11, 0x7b, 0x04, 0x75, 0x3c, 0xa9,
      0x45, 0x0a, 0x7c, 0xa7, 0xf7, 0xd1, 0xa1, 0x17, 0x6c, 0xc3, 0x8e, 0xca,
      0xb7, 0x21, 0x86, 0x44, 0x13, 0xa0, 0xd7, 0xa2, 0x2d, 0x8f, 0xc1, 0x59,
      0x5b, 0x6c, 0xd0, 0x03, 0x2f, 0xbf, 0x15, 0x4f, 0xbb, 0xb3, 0x1b, 0x56,
      0xd3, 0xbf, 0x96, 0x37, 0x61, 0xce, 0x8e, 0xc9, 0xfb, 0x38, 0xbb, 0xa3,
      0x41, 0x97, 0x16, 0xd0, 0xd3, 0x9e, 0x97, 0x68, 0x57, 0xe7, 0x9b, 0x1f,
      0xae, 0xfd, 0x5f, 0x5a, 0x2c, 0xe0, 0xeb, 0xd9, 0x49, 0x68, 0xda, 0x1e,
      0xc3, 0xa3, 0x87, 0x80, 0x46, 0x94, 0xd9, 0x0f, 0x37, 0xb3, 0x40, 0x33,
      0xc7, 0xf7, 0x0c, 0xcf, 0xb2, 0x6b, 0xef, 0xfa, 0xaf, 0xb7, 0xbf, 0x56,
      0xc1, 0xb8, 0x38, 0x5d, 0x48, 0x92, 0x17, 0x45, 0x8e, 0x0a, 0x68, 0xb5,
      0xd6, 0x80, 0xf9, 0xfa, 0x45, 0x38, 0x2f, 0xd1, 0xc2, 0x27, 0xff, 0x3c,
      0x11, 0xe3, 0xec, 0x82, 0x42, 0x6e, 0xc6, 0x48, 0xa5, 0x64, 0xf0, 0xe8,
      0x86, 0xe5, 0xb1, 0x2e, 0x69, 0x5d, 0xd2, 0xfc, 0x84, 0x65, 0xbd, 0x9d,
      0x08, 0x73, 0x1f, 0xb1, 0x40, 0x08, 0x4c, 0x79, 0xbe, 0x64, 0xd9, 0x15,
      0xbc, 0xb4, 0xba, 0x10, 0xf1, 0xed, 0xb4, 0xc3, 0x7e, 0x35, 0x23, 0x17,
      0x53, 0xbe, 0x2d, 0x9f, 0x33, 0x9d, 0x37, 0xd7, 0xb5, 0xf2, 0x2c, 0x91,
      0x58, 0x4a, 0x68, 0xa9, 0x73, 0xf9, 0xcc, 0x46, 0x9a, 0x23, 0xd3, 0xb5,
      0x80, 0x01, 0x57, 0xdb, 0xd7, 0x2a, 0x84, 0x05, 0xfe, 0xf4, 0xe4, 0x44,
      0xff, 0x01, 0xf7, 0xfd, 0x23, 0xef, 0xa1, 0x43, 0xc1, 0x88, 0x75, 0x04,
      0xe8, 0x17, 0x73, 0x74, 0x38, 0x43, 0xd8, 0xa7, 0x32, 0x09, 0xa1, 0xde,
      0xb6, 0x6c, 0x5f, 0x30, 0x5d, 0xf5, 0x39, 0xbc, 0x30, 0xe8, 0x71, 0x33,
      0x2e, 0x82, 0x33, 0x0e, 0x5b, 0x66, 0xfa, 0x6e, 0xa2, 0x53, 0xb2, 0xb6,
      0x4b, 0x4c, 0x97, 0x81, 0x01, 0x1d, 0x20, 0xe8, 0x0d, 0xdd, 0x8c, 0xb8,
      0x39, 0x16, 0x83, 0x4e, 0xb8, 0xfa, 0x69, 0x6b, 0x0a, 0x4b, 0x6b, 0xcd},
     pub_key_2,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false}};

#endif  // rsa_pss_3072_sha256_32_vectors_h__
