/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef rsa_oaep_2048_sha384_mgf1sha384_vectors_h__
#define rsa_oaep_2048_sha384_mgf1sha384_vectors_h__

#include "testvectors_base/test-structs.h"

const RsaOaepTestVector kRsaOaep2048Sha384Mgf1Sha384WycheproofVectors[] = {

    // Comment:
    // tcID: 1
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     1,
     {},
     {0xbf, 0x20, 0xe0, 0xe0, 0x4d, 0xdb, 0xf1, 0x03, 0xa5, 0x13, 0x32, 0x27,
      0xfb, 0xc2, 0x69, 0x6a, 0x0a, 0xcc, 0x72, 0xf7, 0x6f, 0x86, 0x92, 0x40,
      0xb0, 0x6a, 0xee, 0x89, 0xc2, 0x51, 0x28, 0x38, 0x6d, 0x0e, 0x0c, 0x16,
      0x92, 0x7f, 0x98, 0xc1, 0xff, 0x3b, 0x22, 0xb4, 0xfb, 0x61, 0xb5, 0x08,
      0xf3, 0x83, 0xf7, 0xea, 0x76, 0x43, 0x96, 0xb2, 0x20, 0x1e, 0x80, 0x0c,
      0x79, 0x3c, 0x81, 0xa4, 0xd3, 0x8e, 0x20, 0xb0, 0x3e, 0xad, 0x70, 0x3f,
      0x0b, 0x16, 0x4d, 0x7e, 0x7b, 0xf4, 0x70, 0x8c, 0xe9, 0x70, 0xc5, 0x90,
      0x7b, 0x13, 0x9b, 0xda, 0xb8, 0xe2, 0xa1, 0x92, 0x29, 0x89, 0xf9, 0x7c,
      0xc2, 0xcc, 0xe6, 0x56, 0xfe, 0x37, 0x63, 0x09, 0x19, 0x62, 0x6d, 0x96,
      0x62, 0x22, 0xc4, 0x62, 0xaf, 0x0e, 0x72, 0xea, 0x36, 0xf3, 0xd8, 0x16,
      0x78, 0xbf, 0xd1, 0x92, 0x8c, 0xaf, 0x91, 0x11, 0x07, 0x9e, 0xdf, 0x93,
      0x79, 0x6d, 0x27, 0x13, 0xde, 0xee, 0x2b, 0x85, 0xcb, 0x04, 0xfa, 0x63,
      0xd9, 0xfa, 0x41, 0xd2, 0x12, 0x34, 0x55, 0x07, 0xc9, 0x0d, 0x04, 0xf4,
      0xc6, 0xc8, 0x0a, 0x11, 0x4b, 0x36, 0x41, 0x6c, 0xc5, 0x5d, 0x78, 0xeb,
      0x96, 0x9d, 0x90, 0x42, 0x69, 0xa6, 0x9b, 0xf2, 0xe8, 0x39, 0x07, 0x55,
      0x43, 0x95, 0x56, 0x16, 0x07, 0x1a, 0x45, 0xbc, 0x16, 0x78, 0xc6, 0x43,
      0x04, 0xff, 0x5f, 0x4c, 0x22, 0xb2, 0x07, 0xc2, 0x77, 0x03, 0xf7, 0x00,
      0x61, 0xd1, 0x47, 0x1b, 0x47, 0x04, 0x35, 0x7c, 0x13, 0xdc, 0x44, 0xe1,
      0xb3, 0xee, 0xd0, 0x84, 0x2f, 0x57, 0x8e, 0x3e, 0x84, 0xe2, 0x81, 0x84,
      0xf8, 0x4e, 0xf6, 0xf8, 0x0a, 0xc8, 0x06, 0xc3, 0xcc, 0xc0, 0xaf, 0xde,
      0xb1, 0x7a, 0x74, 0xb4, 0x26, 0x93, 0xf6, 0xe4, 0xb2, 0xa6, 0xc7, 0x61,
      0x61, 0x36, 0x3f, 0x3d},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 2
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     2,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x00, 0x51, 0x19, 0x0f, 0x85, 0xcf, 0x3b, 0xd0, 0xe9, 0xbd, 0xf5, 0xc9,
      0x37, 0x59, 0x3d, 0x22, 0x19, 0xdb, 0x50, 0xba, 0x7d, 0x05, 0x12, 0xd3,
      0x88, 0x07, 0xb3, 0x1e, 0xaa, 0x93, 0x10, 0xf0, 0x12, 0x03, 0x20, 0xf7,
      0xfa, 0xd7, 0xc6, 0xb1, 0x35, 0xf2, 0x9c, 0xb1, 0x7f, 0xfa, 0x5b, 0x13,
      0x5c, 0x0e, 0xbb, 0x1c, 0x4c, 0x81, 0x12, 0xa6, 0x69, 0x12, 0xaa, 0x92,
      0xbb, 0xb3, 0x19, 0x1d, 0x5a, 0x28, 0x48, 0x84, 0xf1, 0x94, 0x60, 0xdf,
      0xb9, 0xbf, 0x23, 0x2f, 0x0d, 0xb6, 0xc2, 0x07, 0xff, 0x21, 0xd5, 0x37,
      0x12, 0xe1, 0xc8, 0xd9, 0x0b, 0xec, 0x03, 0x64, 0x26, 0xce, 0xf5, 0x6a,
      0x01, 0x7e, 0x61, 0x75, 0xbf, 0x8b, 0xf2, 0x38, 0xc3, 0x20, 0x50, 0x18,
      0x88, 0x69, 0x30, 0x1e, 0xf7, 0x8d, 0x39, 0x84, 0x76, 0x20, 0x38, 0xbb,
      0x72, 0xa9, 0x82, 0xd5, 0xc9, 0xc9, 0x50, 0x18, 0x20, 0x19, 0x6d, 0x68,
      0xc7, 0x98, 0xea, 0x29, 0xd0, 0xd6, 0x0f, 0x76, 0x28, 0x62, 0x5f, 0xfe,
      0x97, 0x5e, 0xe0, 0x75, 0x7c, 0x6b, 0x70, 0xbf, 0x87, 0xb8, 0x21, 0x9d,
      0xdf, 0x9e, 0x6a, 0xd3, 0x24, 0xec, 0x97, 0x51, 0xfd, 0x36, 0x64, 0x88,
      0x73, 0x36, 0xbc, 0xaa, 0x7a, 0xf7, 0x1c, 0x93, 0x08, 0x3d, 0xd9, 0x67,
      0x02, 0xe6, 0x08, 0x9e, 0x2b, 0x67, 0xab, 0xb7, 0x63, 0x19, 0x3f, 0x95,
      0xd4, 0x22, 0x2b, 0x91, 0x77, 0xc1, 0x7b, 0x47, 0x26, 0x99, 0x82, 0x40,
      0xce, 0x74, 0x20, 0x5f, 0x18, 0xcb, 0x4b, 0x17, 0xbb, 0xfc, 0x73, 0x18,
      0x51, 0x76, 0xad, 0x76, 0x1c, 0x1d, 0x48, 0xe6, 0x33, 0xa4, 0xac, 0x7a,
      0xdc, 0x2f, 0x61, 0xdc, 0x95, 0x79, 0x8e, 0x53, 0x0d, 0x20, 0x81, 0x7b,
      0x72, 0x13, 0x11, 0xbe, 0x82, 0x4d, 0xfc, 0xf7, 0x62, 0x9f, 0xbc, 0x53,
      0x35, 0x43, 0x28, 0x0c},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 3
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     3,
     {0x54, 0x65, 0x73, 0x74},
     {0x0a, 0x50, 0x67, 0xa9, 0x7a, 0x17, 0x11, 0x4b, 0xe5, 0xa7, 0x16, 0x97,
      0xf1, 0x56, 0x94, 0xd9, 0x8c, 0xdd, 0x6e, 0x79, 0xdc, 0xba, 0x17, 0x26,
      0xa3, 0x8c, 0xa6, 0x60, 0xae, 0x4f, 0xd9, 0xa1, 0x33, 0x6d, 0xf2, 0xde,
      0x79, 0x71, 0x8c, 0xea, 0x17, 0x6a, 0x36, 0x5c, 0x46, 0xa2, 0x4d, 0x04,
      0x68, 0xc2, 0xa7, 0x19, 0xcc, 0x18, 0x35, 0xe5, 0xb6, 0x0a, 0xa6, 0x44,
      0x24, 0xa8, 0xde, 0xa0, 0x92, 0x1f, 0xb6, 0x41, 0x45, 0x8c, 0x27, 0x9c,
      0x74, 0xa7, 0xac, 0x74, 0x47, 0x41, 0x26, 0xbe, 0xcc, 0x25, 0xc8, 0x4c,
      0xb8, 0xe4, 0x11, 0xcc, 0x7a, 0x11, 0x9c, 0x78, 0x29, 0x8a, 0x2f, 0x45,
      0x65, 0x8c, 0x75, 0x90, 0xc3, 0xb4, 0x0d, 0xbc, 0xeb, 0x7c, 0x41, 0xc6,
      0x7e, 0x73, 0xd4, 0x1b, 0x46, 0xac, 0x55, 0xcb, 0xea, 0x54, 0x1c, 0x64,
      0xa9, 0x1c, 0x52, 0x1e, 0x37, 0x78, 0x90, 0xcc, 0x03, 0x1a, 0x49, 0x33,
      0xa2, 0x37, 0x60, 0x9d, 0xce, 0x1d, 0x9f, 0x76, 0x68, 0x46, 0x41, 0x41,
      0x7a, 0x44, 0x75, 0x96, 0x62, 0xe1, 0x66, 0xd8, 0x37, 0xe7, 0x7e, 0x9b,
      0x8b, 0x3f, 0xd3, 0x34, 0x3c, 0xad, 0x26, 0xde, 0x86, 0xdb, 0x4f, 0x91,
      0x4a, 0xe8, 0x38, 0x93, 0xfe, 0x96, 0x58, 0x65, 0x4d, 0x09, 0x32, 0xb6,
      0xa9, 0x8c, 0xa5, 0x73, 0x56, 0x69, 0xd6, 0x67, 0x18, 0x6d, 0x89, 0x4b,
      0x5d, 0x47, 0x2a, 0x1e, 0xfe, 0xf4, 0xb2, 0xe0, 0x60, 0x35, 0x18, 0x9f,
      0xea, 0xf9, 0x60, 0xca, 0x12, 0x42, 0xb6, 0x20, 0x26, 0x4e, 0x71, 0xc4,
      0x73, 0x07, 0xa8, 0xa3, 0x8b, 0xba, 0xe9, 0xbc, 0x3d, 0x1b, 0xd5, 0x50,
      0x8a, 0xc3, 0x7f, 0x1b, 0xa7, 0x70, 0xbf, 0xc3, 0x6a, 0x50, 0xa5, 0x43,
      0xee, 0x20, 0x4e, 0x5e, 0xff, 0x53, 0x10, 0xfe, 0x3b, 0xf4, 0x30, 0xdc,
      0x69, 0x08, 0xeb, 0x9e},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 4
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     4,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x76, 0x7b, 0xcf, 0x45, 0x0f, 0x41, 0x6e, 0x42, 0x89, 0x80, 0xa4, 0x88,
      0xbc, 0x83, 0x07, 0x67, 0x49, 0x76, 0x25, 0x30, 0x08, 0xd8, 0x13, 0x40,
      0xa2, 0xf5, 0x19, 0xa1, 0xf4, 0xb9, 0x36, 0xab, 0xf0, 0x20, 0x28, 0xc2,
      0xe7, 0x61, 0x4f, 0x4a, 0xa3, 0x1a, 0x8b, 0x3e, 0x17, 0xc9, 0x6b, 0x49,
      0x22, 0x34, 0x0a, 0x6a, 0x96, 0x96, 0xfd, 0x4f, 0xf3, 0x58, 0xc1, 0xa8,
      0x4c, 0x34, 0x7b, 0x40, 0x50, 0x33, 0x45, 0x9f, 0x91, 0x92, 0xe9, 0xf7,
      0xd6, 0x11, 0xca, 0x2d, 0xa6, 0xa6, 0x69, 0xa8, 0x95, 0xd4, 0x91, 0xa3,
      0xc1, 0x90, 0x8c, 0xb5, 0x98, 0x73, 0x0b, 0x59, 0x6d, 0x66, 0xb1, 0xd4,
      0xb7, 0x61, 0x7f, 0x33, 0x76, 0x6a, 0xf3, 0x85, 0xc3, 0x33, 0xf0, 0x37,
      0xe7, 0x34, 0x1c, 0x96, 0x80, 0xf9, 0x85, 0x4f, 0x6a, 0xb4, 0xf2, 0xc9,
      0x86, 0x46, 0x2d, 0x87, 0x4f, 0x4d, 0xc6, 0x6c, 0x6f, 0xa4, 0xf4, 0x9f,
      0xd3, 0xef, 0x33, 0xd7, 0xc8, 0xcd, 0x81, 0xd7, 0x60, 0x84, 0x11, 0xaa,
      0x61, 0x0e, 0x5e, 0x91, 0x01, 0xdb, 0xdb, 0xa5, 0x22, 0xf7, 0x5c, 0xd1,
      0x2c, 0x57, 0x5b, 0x42, 0xd0, 0x82, 0x81, 0x12, 0x27, 0xba, 0x10, 0x31,
      0x9f, 0x6e, 0xa0, 0xc9, 0xa2, 0xeb, 0x6a, 0x3e, 0x63, 0xcf, 0xe0, 0xc1,
      0xba, 0xb1, 0x8f, 0x29, 0x09, 0x1f, 0xc5, 0xd6, 0x37, 0x27, 0x85, 0x20,
      0x8a, 0x83, 0x0f, 0x73, 0x2f, 0x8a, 0x06, 0x35, 0xf5, 0xee, 0x7b, 0x0b,
      0x9d, 0x2d, 0x62, 0xff, 0x9f, 0x1a, 0x6c, 0xb8, 0x8d, 0xa2, 0x53, 0xad,
      0x5f, 0x0d, 0x56, 0xe5, 0x72, 0x54, 0x8a, 0x35, 0x0a, 0x7e, 0x12, 0xff,
      0x84, 0x6d, 0x09, 0xad, 0x53, 0x52, 0xfa, 0x45, 0xde, 0x48, 0x43, 0x86,
      0xb5, 0x29, 0xe6, 0xf1, 0x4a, 0x1e, 0x80, 0x55, 0x14, 0x53, 0x94, 0xf8,
      0xd4, 0xf9, 0x1b, 0x80},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 5
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     5,
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     {0xc2, 0xa9, 0xb9, 0x6b, 0x17, 0x31, 0x4b, 0xfc, 0xc8, 0x2d, 0x06, 0x53,
      0xe1, 0x4a, 0xaa, 0x70, 0x24, 0xb3, 0x14, 0x51, 0xa8, 0x42, 0xf7, 0x17,
      0x4a, 0x8a, 0x70, 0x8d, 0xd8, 0x0c, 0x94, 0x21, 0x2a, 0xf6, 0x70, 0x80,
      0x6f, 0x96, 0xe7, 0xc0, 0x8e, 0x24, 0x13, 0x19, 0x8b, 0xc3, 0x2d, 0x99,
      0xa2, 0xe6, 0x7d, 0x32, 0xc6, 0xfe, 0x77, 0x27, 0x35, 0xce, 0xd1, 0x6a,
      0xe8, 0xb9, 0x03, 0xd3, 0x40, 0xb6, 0x15, 0x85, 0xeb, 0x4b, 0x2a, 0xe7,
      0xe0, 0xf5, 0x1c, 0xaa, 0xfe, 0xa6, 0x91, 0xda, 0xbe, 0x31, 0xdd, 0xff,
      0x90, 0xb1, 0x14, 0xa1, 0x3f, 0x05, 0x07, 0x2f, 0xd8, 0xa8, 0xa9, 0xbc,
      0x16, 0xfd, 0xcf, 0x32, 0xd1, 0x99, 0xda, 0xa0, 0xde, 0x8e, 0xf3, 0x4f,
      0xd7, 0x90, 0xf1, 0x13, 0x50, 0x5e, 0xab, 0x2b, 0x04, 0x9c, 0x51, 0x5a,
      0x13, 0xa7, 0xd5, 0x6f, 0x45, 0x2f, 0x74, 0x8a, 0xb7, 0x6a, 0x07, 0x47,
      0x6d, 0x60, 0x9f, 0x9e, 0x8d, 0xb4, 0x8d, 0x97, 0xf7, 0x4f, 0x8e, 0x8b,
      0xcd, 0xea, 0x62, 0xf4, 0x95, 0xf5, 0x73, 0xbf, 0xd2, 0xa1, 0x71, 0x22,
      0x4b, 0xce, 0x7e, 0x23, 0x89, 0x81, 0x1c, 0x01, 0xee, 0xc7, 0x0d, 0xdf,
      0xfe, 0xdd, 0x6b, 0xd2, 0xb7, 0xa3, 0x89, 0x6a, 0x81, 0xa3, 0x83, 0xe6,
      0x86, 0xdd, 0x80, 0x86, 0x3f, 0x86, 0xa2, 0x29, 0x0d, 0xb0, 0x96, 0x1a,
      0xd1, 0xb2, 0xc6, 0x39, 0x9a, 0x12, 0xfc, 0x72, 0x5a, 0x33, 0xa1, 0x82,
      0xdf, 0xff, 0xd5, 0xeb, 0xc0, 0x99, 0x61, 0x2b, 0x9c, 0xd9, 0x96, 0xa1,
      0xc4, 0x40, 0x37, 0xd2, 0x39, 0x6f, 0xf6, 0x57, 0xd2, 0x2a, 0x50, 0xd9,
      0x42, 0x04, 0xe4, 0x42, 0x8f, 0xe3, 0xd6, 0x2b, 0x62, 0x9c, 0x83, 0x19,
      0x67, 0x76, 0x54, 0xef, 0xb1, 0xbb, 0x0f, 0xce, 0xac, 0x9a, 0xe8, 0xd1,
      0xeb, 0x3d, 0x2f, 0x07},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 6
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     6,
     {0x61},
     {0xc6, 0x7d, 0x74, 0xac, 0xd6, 0x80, 0x29, 0xef, 0x17, 0x83, 0xf6, 0x41,
      0x2a, 0x2f, 0xf0, 0x97, 0xbc, 0x4c, 0x58, 0x8f, 0x41, 0x25, 0xdc, 0x9a,
      0xf8, 0x71, 0xff, 0x6c, 0xbc, 0x18, 0xca, 0xf2, 0xfd, 0xbd, 0x5f, 0x92,
      0x23, 0x52, 0x11, 0xbb, 0x46, 0x0d, 0x7c, 0x32, 0xba, 0xd3, 0xd7, 0x68,
      0xa7, 0x89, 0x3a, 0xd5, 0xb1, 0xe9, 0x20, 0xec, 0x9b, 0xde, 0x3c, 0xf9,
      0x57, 0x7f, 0x66, 0xa1, 0x6d, 0x5a, 0x3e, 0x5a, 0x4f, 0xeb, 0x40, 0xf0,
      0x41, 0x3a, 0xd4, 0x76, 0x13, 0x92, 0x9b, 0x44, 0xd4, 0x01, 0x85, 0xcd,
      0x45, 0x07, 0x51, 0x5e, 0x73, 0xe9, 0x14, 0x4a, 0x62, 0x6c, 0x6e, 0x24,
      0x61, 0x87, 0x67, 0x89, 0xc8, 0x12, 0x8e, 0xb6, 0x43, 0x88, 0x79, 0xcc,
      0x6b, 0x2a, 0x97, 0x1d, 0xbc, 0xaf, 0xa9, 0xe9, 0xf4, 0x0b, 0x01, 0x20,
      0xfa, 0x38, 0xf4, 0x80, 0x23, 0x80, 0x50, 0x11, 0xd8, 0x9d, 0x48, 0xcb,
      0x09, 0x3b, 0xba, 0xfd, 0x22, 0x1a, 0xca, 0x8b, 0x62, 0x31, 0x1a, 0x6a,
      0x2a, 0x29, 0xa9, 0x2e, 0x13, 0x30, 0x2c, 0x6d, 0xa0, 0xf9, 0x19, 0x0a,
      0xce, 0xb9, 0xc3, 0x6c, 0x97, 0x0d, 0x73, 0x14, 0x25, 0xec, 0x07, 0x9b,
      0xbc, 0x62, 0x95, 0xaa, 0xc0, 0x1d, 0x9c, 0xce, 0x13, 0x6f, 0x9e, 0x2d,
      0x55, 0xe8, 0x51, 0x6d, 0x00, 0x74, 0x13, 0xf1, 0xd4, 0x4b, 0xfa, 0xf6,
      0x3e, 0x25, 0x77, 0x67, 0xdc, 0x06, 0x20, 0xa8, 0x90, 0x2f, 0xb4, 0x49,
      0xf9, 0xd6, 0x2a, 0x25, 0x63, 0x00, 0x87, 0xb6, 0x13, 0x78, 0x4a, 0xf8,
      0x1f, 0x1a, 0x58, 0x8d, 0xa7, 0xb0, 0xfc, 0x2e, 0xd2, 0x13, 0x8e, 0x58,
      0xea, 0xcc, 0x74, 0x6c, 0xc2, 0x41, 0x7b, 0x00, 0x88, 0xa1, 0xbc, 0x94,
      0x55, 0x52, 0xaf, 0xb7, 0x53, 0x68, 0x47, 0xba, 0xed, 0x72, 0xc1, 0x64,
      0x84, 0xee, 0x7d, 0xdb},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 7
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     7,
     {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
      0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5,
      0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff},
     {0xc1, 0xfb, 0x08, 0x43, 0xb4, 0xe3, 0xc7, 0x7e, 0x62, 0x2d, 0x11, 0x97,
      0xee, 0x89, 0x7b, 0x82, 0x51, 0x97, 0x11, 0x72, 0xdd, 0xd2, 0xa1, 0xbb,
      0x94, 0x14, 0x21, 0x73, 0x45, 0x1d, 0x17, 0x48, 0xb4, 0x68, 0xa4, 0x50,
      0xb1, 0x5b, 0xc0, 0x62, 0xad, 0xc9, 0x43, 0x11, 0xfb, 0xd4, 0x3a, 0x80,
      0x73, 0x91, 0x72, 0x1b, 0xc0, 0x5a, 0x49, 0x49, 0xb3, 0x9a, 0xf2, 0xce,
      0xaf, 0xb1, 0xbb, 0xbe, 0x6e, 0x15, 0x72, 0x37, 0xc6, 0xa7, 0xcb, 0x33,
      0xfb, 0x97, 0x1c, 0xef, 0x3c, 0x7b, 0xb1, 0x72, 0xca, 0x76, 0xf2, 0x7e,
      0x5a, 0x70, 0xb4, 0xab, 0x50, 0x1b, 0x8c, 0x4f, 0x69, 0x51, 0x45, 0xda,
      0x34, 0xf0, 0x0a, 0x54, 0xde, 0xb4, 0x7b, 0xaf, 0x1f, 0x47, 0x22, 0xc3,
      0x13, 0xa1, 0x82, 0x2b, 0x87, 0x46, 0x10, 0x9c, 0x47, 0x1f, 0x4f, 0xd8,
      0xe6, 0x94, 0x1c, 0xef, 0xe5, 0x45, 0x80, 0x4f, 0xad, 0x30, 0xe7, 0x89,
      0xe4, 0x19, 0xaa, 0x32, 0xf1, 0x69, 0x58, 0xfa, 0x66, 0x7e, 0xd4, 0x29,
      0x12, 0xd6, 0xdf, 0xb5, 0xcc, 0x6d, 0x76, 0x35, 0xe2, 0x86, 0x72, 0x53,
      0xbf, 0xeb, 0x5a, 0xe9, 0x46, 0x28, 0x3f, 0x4f, 0xbc, 0x00, 0x1f, 0xe8,
      0xf5, 0x78, 0xca, 0x00, 0xc7, 0x35, 0xf6, 0xcb, 0x02, 0xf6, 0x5e, 0xfa,
      0xff, 0x24, 0x01, 0xf9, 0xda, 0x63, 0x0a, 0xc2, 0xed, 0x9c, 0xa7, 0xd4,
      0x4e, 0x4d, 0xe8, 0xae, 0x1f, 0xf6, 0x42, 0x55, 0x60, 0xd5, 0x4d, 0x75,
      0xa9, 0x34, 0x93, 0x70, 0x21, 0x58, 0x94, 0x18, 0xb9, 0x15, 0x73, 0xb4,
      0xee, 0xb4, 0xf6, 0x98, 0x38, 0x30, 0x09, 0xc3, 0x07, 0x49, 0x39, 0xd8,
      0x3c, 0x90, 0xd4, 0x63, 0xa2, 0xc7, 0x99, 0xc1, 0x6e, 0x06, 0xc6, 0x46,
      0x76, 0x41, 0xd3, 0x35, 0xb0, 0x01, 0xef, 0x89, 0xc9, 0x41, 0x2f, 0x74,
      0x78, 0xd5, 0xaf, 0xb9},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 8
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     8,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa5, 0x9e, 0xd1, 0x88, 0x17, 0x82, 0xb3, 0xa1, 0x51, 0x25, 0x4f, 0xd0,
      0x10, 0x2d, 0x0c, 0x78, 0x26, 0x9c, 0xe0, 0x15, 0xa5, 0x42, 0x76, 0x77,
      0x63, 0xd7, 0x86, 0xbb, 0xb8, 0x8d, 0x7c, 0x76, 0x4e, 0x6a, 0x24, 0x49,
      0xf4, 0x9b, 0xb8, 0x31, 0x34, 0x30, 0xed, 0x48, 0x0c, 0xe6, 0xd6, 0x55,
      0x83, 0x50, 0x2f, 0x64, 0x7f, 0x43, 0x9f, 0xfb, 0x57, 0x8c, 0xba, 0x62,
      0x67, 0xdd, 0xb4, 0x92, 0xdc, 0x74, 0xff, 0xab, 0x44, 0xce, 0xbb, 0xc1,
      0x1d, 0xf4, 0x4f, 0xa6, 0xe8, 0x38, 0x99, 0x71, 0x9c, 0x74, 0x32, 0xe5,
      0x09, 0xae, 0x3a, 0x58, 0x71, 0x7f, 0x45, 0x2b, 0xdb, 0x53, 0x1f, 0x01,
      0xb7, 0x0f, 0x95, 0x41, 0xca, 0xdb, 0x50, 0x4b, 0x94, 0x2f, 0x82, 0xb1,
      0x03, 0x2a, 0x5d, 0xaa, 0x27, 0x17, 0x9d, 0x83, 0xdc, 0x63, 0xe0, 0xf3,
      0x42, 0xd5, 0xf7, 0x69, 0xfa, 0xfc, 0x07, 0x50, 0x68, 0x74, 0x70, 0x4f,
      0xab, 0x17, 0xd6, 0x1c, 0xbd, 0xa6, 0x98, 0xa2, 0x01, 0xfa, 0x42, 0x73,
      0x8f, 0xb2, 0x1e, 0x9e, 0xf8, 0x82, 0x8c, 0xfa, 0x0e, 0x0b, 0x4a, 0x5e,
      0xe8, 0x6e, 0x63, 0x9d, 0x69, 0x64, 0x27, 0x48, 0xcc, 0x76, 0x4a, 0x4f,
      0xa2, 0x7f, 0xdb, 0x18, 0xc4, 0x22, 0xf1, 0x25, 0x7b, 0x9a, 0x7c, 0xaa,
      0xf2, 0x43, 0x0e, 0x6a, 0x34, 0x7b, 0xba, 0xa1, 0x70, 0xb7, 0x7f, 0xc7,
      0xf2, 0xaa, 0xb7, 0xad, 0x26, 0x73, 0x32, 0x4c, 0x17, 0xac, 0xff, 0x7f,
      0x67, 0xcc, 0x00, 0x52, 0x54, 0x83, 0xc5, 0xa3, 0x90, 0xc0, 0x84, 0xec,
      0xeb, 0x0d, 0xde, 0xa6, 0x37, 0xf0, 0x9c, 0xc1, 0x15, 0x86, 0x38, 0xee,
      0xde, 0xad, 0x7b, 0x38, 0xa1, 0x4e, 0x99, 0x39, 0xc5, 0x55, 0xcf, 0xb1,
      0x88, 0x1d, 0xae, 0x08, 0x47, 0x9d, 0x83, 0x8c, 0x1d, 0xc1, 0xaf, 0x3b,
      0x81, 0x34, 0x83, 0x05},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     priv_key_2,
     true},

    // Comment:
    // tcID: 9
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     9,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x54, 0x90, 0xda, 0x68, 0x47, 0x78, 0xd7, 0x36, 0x66, 0xab, 0x3c, 0xdd,
      0xb1, 0x45, 0xbf, 0x50, 0xc9, 0x14, 0xed, 0x7f, 0xc5, 0xcc, 0xca, 0x7f,
      0xa5, 0xae, 0xc0, 0x7e, 0x45, 0xd9, 0x25, 0xfd, 0x40, 0x4e, 0x34, 0xc8,
      0x99, 0xb3, 0x62, 0x0e, 0xe0, 0x10, 0xcb, 0xdf, 0x02, 0xf1, 0x90, 0xbf,
      0x23, 0xf4, 0x7c, 0x07, 0xf9, 0x95, 0x14, 0x2b, 0xfa, 0x0b, 0x1b, 0xdd,
      0x98, 0x88, 0x72, 0x67, 0x1a, 0xa4, 0xcc, 0xab, 0xa8, 0xfc, 0xc6, 0x68,
      0xcf, 0x41, 0x3a, 0x62, 0x7b, 0xdf, 0x27, 0xf8, 0xb6, 0x80, 0xf1, 0xb9,
      0xd6, 0x33, 0xcf, 0x3e, 0x2a, 0x3c, 0x0b, 0x83, 0xa9, 0xeb, 0xec, 0x59,
      0x1c, 0x9f, 0xd9, 0xf1, 0xa4, 0xbc, 0x99, 0x7a, 0xd8, 0x36, 0xbf, 0x5d,
      0xb9, 0xa8, 0x01, 0x5c, 0x34, 0xbe, 0xf1, 0x13, 0x92, 0xef, 0x8b, 0xfa,
      0x4b, 0x27, 0x8b, 0x9b, 0xa8, 0xf3, 0x15, 0xe2, 0x56, 0x90, 0x82, 0x99,
      0x81, 0x22, 0x45, 0xdc, 0x53, 0x4d, 0xea, 0xcb, 0x9b, 0x97, 0xb7, 0x64,
      0x51, 0x62, 0xab, 0x66, 0x97, 0x21, 0x26, 0x81, 0x77, 0x40, 0x47, 0x99,
      0x17, 0x3f, 0x4f, 0x9a, 0x1e, 0x90, 0xab, 0xaf, 0x04, 0xcf, 0x78, 0xa1,
      0xea, 0x8a, 0x95, 0xe8, 0x6c, 0x34, 0x35, 0x53, 0x15, 0x35, 0x62, 0xe3,
      0x17, 0x5e, 0xa1, 0x35, 0x99, 0x8e, 0x20, 0xcb, 0x51, 0x38, 0x6e, 0x93,
      0x4e, 0xe2, 0x86, 0x76, 0xe1, 0x0a, 0x5a, 0x73, 0xb5, 0x9f, 0xa1, 0xca,
      0x3b, 0x5c, 0x96, 0xae, 0x43, 0x32, 0x38, 0x83, 0xab, 0x5a, 0x9a, 0x92,
      0x14, 0xba, 0xa4, 0x61, 0x04, 0x6e, 0x3f, 0x60, 0x0e, 0xac, 0xed, 0x75,
      0xcc, 0xfb, 0x88, 0x7f, 0xdb, 0x11, 0xd5, 0xd2, 0x02, 0x34, 0x79, 0x18,
      0xcb, 0x42, 0x27, 0x63, 0x70, 0xef, 0x6f, 0xb4, 0x23, 0x30, 0xd3, 0x92,
      0x27, 0x71, 0xe7, 0xb5},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
      0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13},
     priv_key_2,
     true},

    // Comment:
    // tcID: 10
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     10,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xaa, 0xec, 0x36, 0x6e, 0x45, 0xe9, 0xcb, 0xee, 0x80, 0x4f, 0x4b, 0xea,
      0xb0, 0xc7, 0xd4, 0xa8, 0x02, 0x73, 0x1a, 0xe1, 0xe2, 0x2d, 0x93, 0xe3,
      0xdc, 0x0f, 0xa4, 0x86, 0x8d, 0xd8, 0x49, 0xc0, 0xcd, 0xfc, 0x52, 0x06,
      0x60, 0x51, 0xcf, 0x12, 0x88, 0x7c, 0xcc, 0x09, 0x25, 0x73, 0x01, 0x02,
      0x6b, 0xe0, 0xe4, 0xeb, 0xe2, 0xd6, 0x0d, 0xbe, 0xc6, 0xde, 0x54, 0x7d,
      0x1d, 0xd4, 0xf7, 0x78, 0x68, 0x2f, 0xa9, 0xd8, 0x8d, 0xcc, 0xb0, 0xea,
      0xb5, 0xe6, 0xcb, 0x07, 0xfe, 0x7c, 0x3a, 0x36, 0x64, 0xb5, 0xf3, 0x1b,
      0xd6, 0x8c, 0xdb, 0xe9, 0xb8, 0x8f, 0xec, 0x68, 0x4b, 0x9e, 0x4a, 0x02,
      0x3f, 0x0e, 0x78, 0x2e, 0x5e, 0x9a, 0x32, 0x86, 0x28, 0xdb, 0x6c, 0x3d,
      0x94, 0xa1, 0x08, 0x2b, 0xd0, 0xd3, 0xe4, 0x53, 0xce, 0x26, 0x28, 0xc1,
      0xf1, 0x7a, 0x76, 0x7c, 0x01, 0x7d, 0x72, 0x50, 0x84, 0xdd, 0x0b, 0x7d,
      0x71, 0x52, 0x41, 0xb8, 0x08, 0xb2, 0x53, 0x74, 0x64, 0xdc, 0xc6, 0xee,
      0xb5, 0xaf, 0x4c, 0x4c, 0x18, 0x70, 0x2b, 0xcd, 0xc7, 0x33, 0xc5, 0x3f,
      0x35, 0xd8, 0x05, 0xf8, 0x13, 0xe7, 0x72, 0xac, 0x32, 0xbc, 0xaf, 0xfe,
      0x02, 0x5e, 0xf0, 0xfa, 0x89, 0x31, 0x84, 0x9f, 0xeb, 0xf9, 0x9c, 0x9e,
      0x73, 0xcf, 0x5e, 0x47, 0x30, 0xa1, 0x49, 0x24, 0xd9, 0xf0, 0x74, 0x06,
      0x3b, 0x4d, 0x80, 0xfa, 0xf3, 0xe8, 0xbc, 0xe1, 0x93, 0x0d, 0xaa, 0x24,
      0x1e, 0xce, 0xe3, 0xb6, 0x84, 0xd6, 0x67, 0x4d, 0xc4, 0x1b, 0x8c, 0xe5,
      0x3a, 0xa8, 0xc0, 0x00, 0x2b, 0x02, 0x00, 0xfa, 0x39, 0x37, 0x20, 0xed,
      0x96, 0x78, 0x22, 0xeb, 0x2e, 0xdd, 0x74, 0xa1, 0x95, 0x42, 0x3e, 0xba,
      0x5d, 0xd6, 0xfe, 0x39, 0x15, 0x0d, 0xcb, 0x69, 0x7c, 0xc1, 0xf3, 0x55,
      0x3f, 0x84, 0xb9, 0xfe},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
      0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
      0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f},
     priv_key_2,
     true},

    // Comment: Longest valid message size
    // tcID: 11
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     11,
     {0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78},
     {0x34, 0x8f, 0x66, 0x80, 0xd2, 0x5d, 0x93, 0xe7, 0xf8, 0xf1, 0x7f, 0x24,
      0x10, 0xdd, 0x4b, 0xdc, 0x8a, 0x2b, 0xa5, 0xc9, 0xd2, 0x9b, 0x17, 0xf3,
      0xdc, 0x1e, 0x30, 0x8d, 0x86, 0x8e, 0xf3, 0xe1, 0x12, 0x19, 0x82, 0x63,
      0x5c, 0x60, 0xfd, 0x38, 0x6f, 0x77, 0x56, 0x63, 0x70, 0xf5, 0xbc, 0x0d,
      0x34, 0xe9, 0x59, 0x66, 0x37, 0xc5, 0x9b, 0x00, 0xa6, 0xeb, 0x66, 0x5b,
      0xf5, 0x70, 0x71, 0x26, 0x04, 0x83, 0xf7, 0x2a, 0x5c, 0xf0, 0xbd, 0x6a,
      0xd8, 0x06, 0xa0, 0x49, 0xaa, 0x67, 0x0f, 0xfa, 0xc2, 0x06, 0x67, 0x2f,
      0xad, 0x6e, 0x20, 0x6d, 0x9e, 0x13, 0xf8, 0x2d, 0x89, 0xcd, 0x36, 0x75,
      0xa8, 0x88, 0x87, 0x3c, 0xfd, 0xd1, 0xea, 0x20, 0xfe, 0xec, 0x04, 0xac,
      0x9e, 0x1d, 0x4d, 0xae, 0xbc, 0x58, 0xae, 0x9e, 0xbb, 0x84, 0x45, 0x9a,
      0x34, 0x81, 0xd2, 0x68, 0x46, 0x8f, 0x6e, 0x97, 0xbb, 0xad, 0x00, 0x11,
      0x24, 0x75, 0x76, 0xcd, 0xce, 0xa3, 0x19, 0xb6, 0x8b, 0x19, 0xce, 0x7f,
      0x25, 0x73, 0xcb, 0x3d, 0x71, 0x1e, 0x07, 0x8b, 0x9e, 0x20, 0x6f, 0xea,
      0x72, 0x9e, 0x5b, 0x61, 0xd6, 0x7f, 0x40, 0x0a, 0x33, 0x5a, 0xed, 0xb4,
      0x8f, 0x67, 0x3a, 0xf1, 0xa8, 0x1c, 0x29, 0x98, 0xd8, 0x0b, 0xa3, 0x4a,
      0xc1, 0x85, 0x30, 0xcc, 0xef, 0x71, 0x83, 0x86, 0x58, 0xe8, 0x93, 0x7c,
      0x12, 0x7f, 0x5d, 0x5c, 0xe9, 0x3a, 0x52, 0x5a, 0x2e, 0xc6, 0x0c, 0x98,
      0x56, 0x9d, 0x78, 0x55, 0x92, 0x49, 0x0f, 0xcf, 0x3c, 0x72, 0xd5, 0x37,
      0x91, 0xf8, 0xe8, 0x12, 0x44, 0x29, 0x2f, 0x18, 0x24, 0x26, 0x45, 0x18,
      0xbb, 0x82, 0x7a, 0xdf, 0x12, 0x05, 0xe6, 0xa2, 0xe1, 0xca, 0x7d, 0x01,
      0x19, 0x5d, 0xd4, 0xc3, 0x61, 0x6a, 0xcb, 0x75, 0x80, 0xc0, 0xc9, 0xc5,
      0x72, 0x02, 0x4a, 0x4f},
     {},
     priv_key_2,
     true},

    // Comment: first byte of l_hash modified
    // tcID: 12
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     12,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa6, 0x42, 0xbe, 0xde, 0x4d, 0x11, 0x9d, 0x37, 0xba, 0x3c, 0x6f, 0x72,
      0x9a, 0xb8, 0xef, 0x09, 0x05, 0x5a, 0x41, 0xc5, 0xcc, 0x65, 0x0a, 0x95,
      0x4b, 0xd0, 0xa2, 0xaa, 0x24, 0x81, 0x72, 0xf3, 0xe3, 0x32, 0xd3, 0xca,
      0xf2, 0x7f, 0x66, 0x52, 0x20, 0x22, 0x87, 0x70, 0x5d, 0x58, 0xb3, 0xec,
      0x31, 0xa5, 0x92, 0x50, 0x83, 0x48, 0x6c, 0x50, 0xc3, 0x1e, 0xa5, 0xb2,
      0x7a, 0x69, 0x3b, 0x2b, 0x93, 0xc6, 0xa4, 0xbe, 0x3c, 0x59, 0x38, 0xa4,
      0x78, 0x14, 0x8e, 0xd6, 0x60, 0x00, 0x42, 0x97, 0x0d, 0x71, 0xe2, 0xae,
      0x81, 0xe2, 0x1a, 0x2f, 0x60, 0xea, 0x68, 0x3c, 0x4a, 0x11, 0xbe, 0x85,
      0xd2, 0xa0, 0x0c, 0xd3, 0x9e, 0xdb, 0x6f, 0x05, 0xf8, 0xe9, 0x3c, 0x2d,
      0x76, 0x0e, 0x68, 0xba, 0x74, 0xa4, 0x2d, 0xce, 0xcb, 0x6a, 0x89, 0x05,
      0x36, 0xc7, 0xbb, 0x09, 0x31, 0x46, 0xa8, 0x16, 0x1e, 0x88, 0x47, 0xb1,
      0x8d, 0xdf, 0x18, 0xe1, 0x3e, 0xb0, 0x4f, 0xcd, 0x84, 0x12, 0x60, 0x01,
      0x60, 0x84, 0xb2, 0x3e, 0xfa, 0xd5, 0xf3, 0x6c, 0x3c, 0x53, 0x74, 0xa8,
      0x50, 0xb2, 0x6f, 0x97, 0xe8, 0x07, 0x6f, 0x9e, 0x28, 0x8c, 0x9e, 0x90,
      0x48, 0x45, 0xc4, 0x6d, 0xf4, 0xfd, 0x8a, 0xf4, 0x10, 0x31, 0xdc, 0x6a,
      0x9d, 0xc4, 0x1c, 0x35, 0xc1, 0xac, 0x73, 0xfb, 0x95, 0x86, 0xe3, 0x08,
      0xec, 0xb8, 0x26, 0x0d, 0x85, 0xd7, 0x30, 0xff, 0xe7, 0x8b, 0xcc, 0x04,
      0x39, 0xe4, 0x84, 0x5b, 0xc9, 0xf6, 0x19, 0x79, 0x56, 0xb2, 0xe4, 0xdf,
      0xa4, 0xc5, 0xe6, 0x36, 0x7b, 0x20, 0x3c, 0x1a, 0x45, 0x0a, 0x08, 0x1e,
      0x3e, 0xdf, 0x6b, 0x50, 0xaa, 0x85, 0x30, 0x3b, 0xbb, 0x54, 0x7e, 0xfb,
      0xab, 0x50, 0x09, 0xfa, 0x80, 0x83, 0x9d, 0x78, 0xa7, 0xd3, 0xc8, 0x51,
      0x48, 0x15, 0xa9, 0x93},
     {},
     priv_key_2,
     false},

    // Comment: last byte of l_hash modified
    // tcID: 13
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     13,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x4d, 0x80, 0x5a, 0x7c, 0xe6, 0x50, 0x73, 0x9a, 0x4e, 0x4f, 0x33, 0x4d,
      0xe9, 0xe5, 0x7f, 0xc1, 0x34, 0x60, 0x4c, 0x9e, 0x51, 0x98, 0xaa, 0xb2,
      0xbd, 0x20, 0x44, 0xb1, 0x1a, 0xfb, 0xc4, 0x57, 0x41, 0x81, 0x4b, 0x2c,
      0x6b, 0x79, 0x64, 0x11, 0x71, 0x04, 0x45, 0xad, 0x3f, 0x73, 0xb5, 0xa1,
      0x1d, 0x20, 0x66, 0xab, 0x73, 0xd4, 0xed, 0x63, 0x69, 0x97, 0xc6, 0x54,
      0x2e, 0xc1, 0x8e, 0x8a, 0xf4, 0xf1, 0xca, 0x00, 0x19, 0x86, 0x51, 0x56,
      0xcf, 0x9e, 0xe8, 0x63, 0x15, 0xad, 0xb7, 0x5d, 0xb3, 0x64, 0x09, 0x53,
      0xd1, 0xf1, 0x26, 0x85, 0x37, 0xd3, 0x08, 0x25, 0x6f, 0x71, 0x2d, 0x0a,
      0x3b, 0x3a, 0x4b, 0x2b, 0x88, 0x32, 0x20, 0x56, 0xae, 0x9c, 0x06, 0x45,
      0x8f, 0xc3, 0x6e, 0xee, 0xd6, 0x03, 0x59, 0xd0, 0x91, 0x09, 0x0a, 0x9a,
      0x3d, 0x6c, 0x36, 0x46, 0xfc, 0xf5, 0x4e, 0x0f, 0x98, 0x00, 0x8a, 0x64,
      0x40, 0xf5, 0x07, 0x7e, 0xce, 0x46, 0x7e, 0x10, 0xb9, 0xee, 0xff, 0xc6,
      0x71, 0x30, 0x93, 0x06, 0xee, 0xa6, 0x0b, 0x91, 0x2d, 0xcb, 0x87, 0x2b,
      0x48, 0x42, 0x84, 0x50, 0x04, 0x1f, 0x55, 0x34, 0x12, 0xb0, 0xf7, 0xa3,
      0x70, 0xfc, 0x1f, 0x2e, 0xcf, 0xbe, 0x17, 0x11, 0x65, 0x8d, 0xe4, 0x99,
      0x1f, 0xed, 0xc3, 0x34, 0x13, 0xf8, 0xfa, 0xf6, 0x9c, 0x3f, 0x8c, 0xf9,
      0x7e, 0x90, 0x03, 0xb2, 0xb0, 0x39, 0xbf, 0xf2, 0x37, 0x68, 0x13, 0x39,
      0x87, 0x5a, 0x85, 0xd2, 0x13, 0x2b, 0xda, 0x1a, 0x02, 0x9a, 0x2e, 0x79,
      0xf0, 0xe3, 0x7f, 0x90, 0xf5, 0x03, 0x58, 0x21, 0x63, 0x99, 0xb5, 0x99,
      0xd1, 0x7e, 0x77, 0x60, 0x33, 0x6f, 0xa4, 0x47, 0xe6, 0x59, 0x9c, 0xee,
      0x60, 0xca, 0x38, 0x4f, 0x82, 0x9d, 0xf0, 0xfe, 0x49, 0xe6, 0xfd, 0xdf,
      0xce, 0x91, 0xa7, 0x4f},
     {},
     priv_key_2,
     false},

    // Comment: l_hash changed to all 0
    // tcID: 14
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     14,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x55, 0x2e, 0xda, 0xec, 0x51, 0x57, 0x7d, 0xaf, 0x5a, 0x3a, 0x41, 0xf5,
      0x12, 0x2d, 0x8e, 0x14, 0xa0, 0xf2, 0x10, 0xf4, 0xa6, 0x91, 0xc2, 0x2b,
      0x62, 0x45, 0x50, 0xd9, 0x53, 0xc2, 0xe0, 0xc9, 0x3f, 0xef, 0x2f, 0xb8,
      0x83, 0xd7, 0x66, 0xa4, 0x99, 0x64, 0x24, 0x37, 0x7c, 0x38, 0x4f, 0x41,
      0x62, 0x4c, 0x3d, 0x65, 0x72, 0x8a, 0xa1, 0xa9, 0x53, 0xe3, 0x28, 0x3b,
      0xba, 0x9f, 0xf5, 0xd0, 0x20, 0xac, 0xc1, 0xf8, 0x70, 0xe4, 0x95, 0xc5,
      0x39, 0xf9, 0x85, 0x7d, 0x32, 0xb4, 0x2e, 0x9a, 0x7f, 0x82, 0x1e, 0x21,
      0x87, 0xe9, 0x97, 0xc4, 0x09, 0xef, 0x85, 0xf0, 0x01, 0x3c, 0x43, 0x49,
      0x18, 0xd7, 0xe0, 0x85, 0x56, 0x66, 0x07, 0xc2, 0xcf, 0x27, 0x9d, 0x6d,
      0x7a, 0x1f, 0x51, 0xba, 0x51, 0x67, 0x2d, 0x74, 0x49, 0x1d, 0x1a, 0xd7,
      0x97, 0x46, 0x1b, 0x55, 0x51, 0x99, 0xff, 0x3b, 0xcb, 0xd2, 0x6f, 0x3d,
      0x87, 0x78, 0x1f, 0x09, 0xde, 0xe6, 0xce, 0xf4, 0x46, 0x05, 0x36, 0x85,
      0xee, 0xb6, 0x0f, 0x0a, 0x81, 0xd5, 0x7c, 0xf7, 0x3b, 0x3d, 0x67, 0x4c,
      0xff, 0xf6, 0x06, 0x0f, 0x53, 0xb0, 0xfa, 0x8f, 0x22, 0x4e, 0x43, 0xab,
      0x4a, 0x88, 0xf0, 0xce, 0x37, 0xd2, 0xab, 0x9b, 0x4c, 0x25, 0x7d, 0xf7,
      0x7e, 0x75, 0x19, 0xf2, 0x11, 0xdb, 0xaf, 0x6b, 0x98, 0x37, 0x99, 0x2d,
      0x9f, 0x6c, 0xd4, 0xe5, 0xfa, 0xbb, 0xa4, 0xab, 0x0b, 0x40, 0x5b, 0x49,
      0xc8, 0xef, 0x0c, 0xc1, 0x72, 0xbc, 0x58, 0x89, 0xac, 0x9b, 0xee, 0xce,
      0xf9, 0xab, 0xd4, 0x8b, 0x46, 0xb1, 0x34, 0xc3, 0xf0, 0xa8, 0x52, 0x2c,
      0xdf, 0xa0, 0xa0, 0x7f, 0xd1, 0xc9, 0x17, 0x88, 0xac, 0x81, 0xc0, 0x6b,
      0x2c, 0xab, 0xd1, 0x61, 0x17, 0xfe, 0x55, 0xd7, 0x89, 0x2e, 0x4d, 0xba,
      0x41, 0x18, 0x8d, 0xc9},
     {},
     priv_key_2,
     false},

    // Comment: l_hash changed to all 1
    // tcID: 15
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     15,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x5d, 0xe9, 0xc4, 0xff, 0xfa, 0xad, 0x10, 0x23, 0xd5, 0x78, 0x67, 0x3b,
      0xda, 0x5f, 0x05, 0xd6, 0x2d, 0xc7, 0x3b, 0x59, 0x72, 0xb5, 0xad, 0xdd,
      0x16, 0xc4, 0x53, 0xcb, 0x0d, 0x5a, 0xa9, 0xbe, 0xb4, 0xcd, 0x7b, 0x51,
      0xef, 0x91, 0xa4, 0x9f, 0x58, 0xc4, 0xea, 0xcb, 0xa8, 0x17, 0xb2, 0x98,
      0xb3, 0xf0, 0xd5, 0x05, 0x3c, 0x37, 0xcf, 0xcc, 0x03, 0x77, 0x0c, 0x0f,
      0x84, 0xe7, 0x76, 0x88, 0xbf, 0x35, 0x90, 0x40, 0x33, 0xa4, 0xb0, 0x02,
      0xfa, 0xb9, 0x06, 0x58, 0x05, 0xe6, 0x98, 0xf6, 0xf3, 0x08, 0x2c, 0x4a,
      0xfd, 0x05, 0xd1, 0x8e, 0x7b, 0x06, 0x6a, 0x45, 0xa8, 0xc4, 0x00, 0xa2,
      0x5d, 0x93, 0x54, 0x55, 0xd3, 0xb5, 0x75, 0xee, 0x28, 0xda, 0x69, 0xe8,
      0x33, 0x16, 0x3f, 0x80, 0x14, 0xf5, 0x0c, 0xc3, 0xab, 0xda, 0x56, 0x7b,
      0x07, 0xf5, 0xb5, 0xfc, 0xe3, 0x45, 0x22, 0xf6, 0x82, 0x5c, 0xfb, 0x64,
      0x32, 0xee, 0x17, 0xfb, 0x9e, 0xd6, 0xde, 0x30, 0xb7, 0xcd, 0x61, 0x09,
      0x60, 0xcf, 0x39, 0xf1, 0x98, 0x44, 0xb0, 0x9a, 0x61, 0xb0, 0x0a, 0x95,
      0x77, 0x06, 0x22, 0x7b, 0x2f, 0xa4, 0xe8, 0x80, 0x81, 0xca, 0x03, 0x0a,
      0x26, 0x4d, 0xc1, 0x31, 0x4b, 0xeb, 0xc9, 0xa7, 0x60, 0xdf, 0xf7, 0x2d,
      0xed, 0x1f, 0x8d, 0x51, 0x70, 0x63, 0x49, 0xdb, 0x4c, 0xc9, 0x5f, 0x0d,
      0x7e, 0x6f, 0x33, 0x15, 0x35, 0x07, 0x5b, 0xe4, 0xe9, 0x5c, 0x12, 0x38,
      0x97, 0x59, 0xc2, 0x67, 0x17, 0xcd, 0xd9, 0x33, 0x15, 0x71, 0x17, 0xa3,
      0xb0, 0x3f, 0x1c, 0x6f, 0x73, 0x82, 0x6a, 0xb8, 0x37, 0xa5, 0x74, 0x05,
      0xb0, 0xcd, 0xab, 0xb2, 0x2e, 0x7f, 0x6e, 0xe4, 0x68, 0xf4, 0x6d, 0x93,
      0x54, 0x90, 0x67, 0xda, 0xaa, 0x6e, 0x73, 0x5e, 0xf4, 0x78, 0xfb, 0x2f,
      0x68, 0x09, 0xb1, 0x16},
     {},
     priv_key_2,
     false},

    // Comment: first byte of ps modified
    // tcID: 16
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     16,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xae, 0xa2, 0x35, 0x31, 0x3f, 0xd3, 0xbc, 0x3b, 0xe9, 0x5b, 0x1d, 0xb3,
      0x9e, 0x4b, 0xf2, 0xae, 0x67, 0xb8, 0xe7, 0x05, 0x55, 0xd6, 0xdb, 0xb3,
      0xde, 0x2c, 0x07, 0x9c, 0x19, 0xfb, 0xb1, 0xdc, 0x4a, 0x9a, 0x6b, 0x4e,
      0x8c, 0xe3, 0xd8, 0xdf, 0xc6, 0xd0, 0x85, 0xb7, 0x6a, 0x05, 0x59, 0x24,
      0x0b, 0xb9, 0x0d, 0xab, 0x22, 0x3d, 0xdd, 0xf6, 0x50, 0xda, 0x78, 0x30,
      0x1c, 0x25, 0x50, 0x85, 0x98, 0x2a, 0x7b, 0x8e, 0xcf, 0x11, 0xbc, 0x82,
      0x45, 0x86, 0xde, 0x05, 0x24, 0xcb, 0xcf, 0xea, 0x2a, 0x83, 0xba, 0x11,
      0xf6, 0x19, 0xc8, 0xc8, 0x7a, 0xe9, 0x1d, 0x64, 0xaa, 0xe9, 0x27, 0x43,
      0xb6, 0xe2, 0x71, 0x9c, 0xc3, 0xd7, 0xa6, 0x70, 0xa7, 0x76, 0x14, 0xe0,
      0x86, 0xe4, 0xe3, 0x13, 0x7c, 0xb1, 0xca, 0x0c, 0x48, 0x67, 0x68, 0x9b,
      0x3c, 0x3a, 0xec, 0xcc, 0x5f, 0x31, 0x52, 0x88, 0x01, 0xd1, 0xe2, 0x2e,
      0x86, 0x4c, 0x03, 0x1f, 0x58, 0xce, 0xd9, 0xd7, 0x3f, 0x61, 0x9b, 0xd5,
      0xef, 0xa8, 0xf2, 0x8f, 0x22, 0x45, 0x87, 0x76, 0x8c, 0x30, 0x9e, 0x50,
      0x86, 0x70, 0x3a, 0xb9, 0xd6, 0xac, 0xac, 0xaa, 0xa1, 0xee, 0x26, 0x81,
      0x41, 0x7b, 0x64, 0x7c, 0x92, 0xdb, 0x06, 0x40, 0x44, 0x68, 0x40, 0x86,
      0x6b, 0x50, 0xde, 0x5d, 0x35, 0x7d, 0xa3, 0xca, 0x25, 0x9b, 0xd9, 0xe0,
      0xb0, 0x72, 0xbb, 0xc3, 0xdd, 0xba, 0x81, 0x9a, 0x90, 0xde, 0xd0, 0xb4,
      0xdf, 0x60, 0x45, 0xee, 0x3a, 0xf3, 0xa0, 0xf0, 0x13, 0x22, 0x8f, 0xc4,
      0x54, 0x26, 0x3f, 0x92, 0xa2, 0x49, 0xed, 0xed, 0x9c, 0x73, 0xf7, 0x61,
      0x2f, 0x2f, 0x33, 0x03, 0xcc, 0x2b, 0x34, 0x63, 0xdd, 0x9c, 0x7a, 0x0f,
      0xc2, 0xe4, 0x74, 0xf8, 0x99, 0xe9, 0xa2, 0x7f, 0x83, 0xea, 0x7f, 0xa5,
      0xf1, 0x1e, 0x09, 0x95},
     {},
     priv_key_2,
     false},

    // Comment: ps terminated by 0xff
    // tcID: 17
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     17,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xac, 0xb7, 0xbc, 0xcf, 0x7e, 0x2c, 0xad, 0x69, 0x57, 0x2f, 0x61, 0xc9,
      0x85, 0x65, 0x95, 0x7f, 0x0e, 0x30, 0x93, 0x1c, 0xc5, 0x98, 0x0c, 0x4e,
      0xe4, 0x54, 0x08, 0x44, 0xe0, 0x8d, 0x37, 0x06, 0x62, 0x80, 0xb3, 0xd8,
      0xd0, 0xf1, 0x50, 0x90, 0xfa, 0xec, 0xa1, 0x2a, 0xb2, 0x2b, 0x0a, 0x3f,
      0x70, 0xb2, 0xd3, 0xb6, 0x8e, 0xbc, 0x6d, 0x4b, 0x3f, 0x19, 0x98, 0x27,
      0x7d, 0x93, 0x25, 0x68, 0x36, 0xa1, 0xf6, 0x58, 0x79, 0xc8, 0xf4, 0x8e,
      0xa2, 0x2b, 0x13, 0xb8, 0x0f, 0xb0, 0x73, 0x8c, 0xd4, 0x4f, 0xb5, 0x40,
      0x50, 0x7f, 0xb9, 0xf4, 0x45, 0x77, 0x62, 0x3a, 0x1a, 0xf1, 0x53, 0x84,
      0x19, 0x6a, 0xfc, 0x9d, 0x5a, 0x68, 0x82, 0xc2, 0x45, 0x93, 0x8f, 0xc1,
      0xb5, 0x3c, 0x60, 0x0f, 0xd0, 0xdd, 0x9f, 0x07, 0xa5, 0x74, 0xe1, 0x67,
      0x04, 0x1b, 0x53, 0xf4, 0x14, 0xc7, 0xdb, 0x6c, 0x25, 0x2e, 0x87, 0x54,
      0x43, 0xb0, 0x00, 0x63, 0x58, 0x38, 0x2f, 0x5c, 0x83, 0x73, 0x5e, 0x97,
      0x13, 0x37, 0x07, 0x72, 0x49, 0xf7, 0xe9, 0x38, 0x6e, 0xd0, 0xe9, 0x15,
      0xce, 0xab, 0x28, 0x3c, 0x04, 0x74, 0x30, 0x8b, 0xba, 0x05, 0xe7, 0x41,
      0x0c, 0x91, 0x95, 0x96, 0x48, 0xd1, 0x76, 0x8d, 0x2e, 0x51, 0xe5, 0x99,
      0xd4, 0x79, 0xa5, 0x57, 0x8c, 0x6e, 0x7a, 0x0f, 0xc6, 0x1f, 0xc8, 0xe1,
      0x8c, 0x01, 0x7f, 0x4e, 0x25, 0x76, 0x08, 0x7b, 0xe8, 0xa8, 0xfd, 0xc7,
      0xad, 0xa5, 0xb7, 0x08, 0xbb, 0x07, 0xd6, 0xb0, 0x57, 0x9c, 0x9b, 0xae,
      0xca, 0xb7, 0xe3, 0x87, 0x94, 0x69, 0x8c, 0x6d, 0x91, 0x39, 0x0f, 0xef,
      0x55, 0x4c, 0x53, 0xb9, 0x75, 0x61, 0x03, 0x4d, 0xb1, 0x4b, 0x16, 0xdd,
      0xe6, 0x48, 0xc9, 0xd5, 0xff, 0xe6, 0x1e, 0xf8, 0xde, 0xba, 0xb9, 0x5c,
      0x57, 0xb2, 0x25, 0x65},
     {},
     priv_key_2,
     false},

    // Comment: ps is all zero
    // tcID: 18
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     18,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xaa, 0x5b, 0x36, 0xde, 0x5f, 0x95, 0xc3, 0xc3, 0xb3, 0x55, 0xa7, 0x96,
      0x8d, 0x39, 0xde, 0x17, 0x29, 0x9b, 0xdb, 0x01, 0x87, 0x0f, 0x07, 0xb3,
      0x60, 0x07, 0x14, 0xd5, 0x99, 0x9d, 0xce, 0xee, 0x36, 0x45, 0x10, 0x47,
      0xe7, 0xeb, 0x19, 0x42, 0xbf, 0x25, 0x82, 0x8a, 0x73, 0x68, 0xd2, 0x19,
      0x71, 0x0e, 0xe2, 0x7c, 0xbb, 0x8f, 0x58, 0xd9, 0xf6, 0x4d, 0x9c, 0xc1,
      0x65, 0x86, 0x5f, 0xba, 0xbd, 0xc5, 0x25, 0x94, 0xa9, 0x50, 0x49, 0xf2,
      0x1b, 0x65, 0xfb, 0xee, 0x38, 0x11, 0x6a, 0x80, 0x32, 0xd3, 0x7e, 0xb5,
      0x3d, 0xbe, 0x05, 0xb7, 0xce, 0x54, 0x76, 0xe6, 0x94, 0xcc, 0x0e, 0xa4,
      0xff, 0x98, 0x1f, 0xb2, 0x69, 0xd9, 0x3c, 0xb6, 0x34, 0x06, 0x1c, 0x83,
      0x55, 0xef, 0x8e, 0x29, 0xd3, 0x5a, 0xe3, 0xc2, 0x51, 0xd2, 0x4d, 0x89,
      0x4f, 0xbd, 0xbc, 0xd1, 0x51, 0xda, 0x91, 0x4a, 0x2a, 0x1c, 0x05, 0x7a,
      0x22, 0xaf, 0xe8, 0xe1, 0x3a, 0x59, 0x68, 0x29, 0xcf, 0xf3, 0x2d, 0xa6,
      0xa8, 0xf7, 0x20, 0x0c, 0xec, 0x82, 0x68, 0x33, 0xbc, 0xcb, 0x20, 0xbc,
      0xe2, 0x0f, 0x96, 0xdd, 0x04, 0x06, 0x6e, 0xa0, 0x72, 0x81, 0x49, 0xdf,
      0xd4, 0x69, 0xad, 0x20, 0x57, 0xab, 0x3d, 0x65, 0x17, 0xc8, 0x5d, 0x88,
      0x17, 0x36, 0x52, 0x58, 0xbe, 0xc1, 0x8a, 0x3f, 0xc6, 0x7f, 0x31, 0x44,
      0x70, 0xb7, 0x5f, 0x00, 0xc5, 0x7c, 0xbb, 0xd0, 0x4c, 0x51, 0xbd, 0x04,
      0x97, 0x16, 0x03, 0xac, 0xdb, 0xbd, 0xcd, 0xb3, 0x6f, 0xf8, 0xb3, 0x15,
      0xba, 0xf4, 0x93, 0x9d, 0x0b, 0x9a, 0xd5, 0xfa, 0x52, 0x09, 0x3c, 0x8d,
      0xcd, 0x70, 0x1f, 0xe2, 0x0f, 0xd6, 0x7d, 0x8c, 0x3a, 0x12, 0x38, 0xf6,
      0x01, 0x41, 0xcb, 0x45, 0xe6, 0xb4, 0xce, 0x0d, 0x50, 0x4f, 0x03, 0x02,
      0x80, 0x91, 0x44, 0x7c},
     {},
     priv_key_2,
     false},

    // Comment: ps replaced by 0xff's
    // tcID: 19
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     19,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa7, 0x9a, 0xac, 0xcb, 0x72, 0x90, 0x7b, 0x41, 0x12, 0x3e, 0x3e, 0xfd,
      0xb5, 0x7b, 0xe0, 0xc5, 0xab, 0x48, 0xdc, 0x09, 0xac, 0x22, 0xfd, 0xdc,
      0xda, 0x6b, 0xc4, 0x97, 0xcb, 0xaa, 0x95, 0xb5, 0x88, 0xed, 0x3c, 0x70,
      0xdc, 0x3e, 0x39, 0x4e, 0x96, 0xe8, 0xc8, 0xcc, 0x07, 0xd1, 0xb4, 0x9a,
      0x6a, 0xd9, 0x58, 0xa9, 0xcf, 0xf9, 0x42, 0x2b, 0xe7, 0x8a, 0xa2, 0xbe,
      0x64, 0x1f, 0x38, 0xdc, 0x16, 0x09, 0xe0, 0x76, 0xc4, 0x1b, 0x79, 0xd8,
      0x74, 0xb8, 0xdf, 0xc0, 0xd6, 0x01, 0xfc, 0xd0, 0x65, 0xc4, 0xa2, 0x4b,
      0x97, 0x62, 0x17, 0x0f, 0xdd, 0x20, 0x98, 0x5a, 0x28, 0x3f, 0x49, 0x3d,
      0x67, 0x72, 0xac, 0x5b, 0x87, 0xf2, 0x8d, 0xdc, 0x3f, 0xb6, 0x7a, 0x94,
      0x1b, 0x7d, 0xe4, 0x8c, 0x6a, 0x8a, 0x87, 0x69, 0xb3, 0x0d, 0x8e, 0x1c,
      0xf0, 0x20, 0xe6, 0x49, 0xd1, 0x19, 0x22, 0xd4, 0x69, 0x33, 0xff, 0xe8,
      0x09, 0xa6, 0x85, 0x97, 0x74, 0x4d, 0x9f, 0xc5, 0x4e, 0xe4, 0x7e, 0xdc,
      0xca, 0x19, 0x0a, 0xb7, 0xd9, 0x5f, 0x66, 0x06, 0x76, 0x57, 0x70, 0x3a,
      0x61, 0xd5, 0x3a, 0x0a, 0x6f, 0xa2, 0x81, 0x13, 0xe1, 0xd4, 0x91, 0x2f,
      0x3e, 0xf0, 0xa8, 0xd2, 0xb5, 0xd0, 0xaa, 0xdc, 0xf6, 0x07, 0xf2, 0xf4,
      0x2a, 0x4f, 0xf5, 0x2e, 0x2a, 0x99, 0x62, 0xd1, 0x19, 0xfc, 0xf8, 0xd6,
      0x5c, 0x64, 0x74, 0xa9, 0x1d, 0x62, 0xfc, 0x3e, 0x7f, 0xba, 0x86, 0x7d,
      0x06, 0xa0, 0x7a, 0x03, 0xd2, 0xfa, 0x49, 0x69, 0x19, 0x58, 0x79, 0xa6,
      0x92, 0x38, 0x91, 0x34, 0xa5, 0xf4, 0x14, 0x63, 0x2d, 0xe3, 0xdc, 0x69,
      0x28, 0x74, 0x49, 0x09, 0x45, 0x2f, 0x7c, 0x63, 0x18, 0xff, 0xd0, 0xdf,
      0x0c, 0xe3, 0xd9, 0xe1, 0x0a, 0x8c, 0xae, 0x53, 0xd8, 0x06, 0xb5, 0x55,
      0xa4, 0x62, 0x17, 0x8e},
     {},
     priv_key_2,
     false},

    // Comment: seed is all 0
    // tcID: 20
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     20,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x07, 0xbd, 0x2f, 0xbe, 0x88, 0x0a, 0x85, 0xda, 0x97, 0x96, 0x2b, 0x4e,
      0x80, 0x6e, 0x3f, 0x38, 0x0b, 0xba, 0x3d, 0xc8, 0x0f, 0x63, 0x1d, 0x9b,
      0x4a, 0x9a, 0x64, 0xab, 0x51, 0x17, 0x9c, 0x5e, 0xa7, 0xf5, 0x87, 0x89,
      0xd8, 0xe5, 0x89, 0x4b, 0x1f, 0xc7, 0xdf, 0x15, 0xb3, 0x4d, 0x09, 0xf5,
      0x59, 0x2f, 0xc6, 0x00, 0xbf, 0x1e, 0xdd, 0x11, 0x85, 0x38, 0xa6, 0x14,
      0xce, 0x31, 0x44, 0x16, 0x5b, 0xf0, 0x57, 0x86, 0x52, 0x68, 0x6c, 0xe7,
      0xdf, 0x72, 0x0c, 0x26, 0x60, 0x54, 0x3d, 0x83, 0x67, 0x46, 0x67, 0x5a,
      0x41, 0xcc, 0x92, 0x9b, 0x19, 0x86, 0x47, 0xc5, 0x2f, 0xfb, 0x8b, 0x4a,
      0xfc, 0x74, 0xcb, 0xa7, 0xde, 0x45, 0x6d, 0x22, 0x98, 0xa1, 0xaa, 0x40,
      0xc2, 0x52, 0x47, 0xb4, 0xc1, 0x30, 0x4f, 0x41, 0xbf, 0x4e, 0x13, 0x7b,
      0x98, 0x24, 0x5a, 0xb8, 0xed, 0xea, 0x6f, 0x62, 0x07, 0x7a, 0x8e, 0xad,
      0xc6, 0xbc, 0x90, 0x37, 0x22, 0xd0, 0xc7, 0x25, 0x3b, 0x3d, 0x2b, 0x0a,
      0xcd, 0xc1, 0xf9, 0x61, 0x15, 0x7f, 0x14, 0x40, 0x4d, 0xbd, 0xf5, 0x0f,
      0x29, 0x4f, 0xd7, 0xfe, 0xd6, 0x4f, 0xab, 0x3a, 0x0c, 0x3c, 0xf4, 0x6e,
      0x68, 0x3f, 0x41, 0xb8, 0x9c, 0x0d, 0xb6, 0x11, 0x23, 0x95, 0xff, 0x8a,
      0xf6, 0x34, 0x89, 0x24, 0x82, 0x3a, 0x43, 0x85, 0x5a, 0x0c, 0xce, 0xb4,
      0xbb, 0x00, 0xbb, 0x25, 0x64, 0xe4, 0x0d, 0xe0, 0xdb, 0x8c, 0xcd, 0x80,
      0x3a, 0xf1, 0xc4, 0xce, 0x78, 0x73, 0xaa, 0x2f, 0xa1, 0x56, 0xd0, 0x9a,
      0x42, 0x74, 0xb4, 0x7c, 0x58, 0x88, 0x55, 0x3c, 0xd0, 0x9c, 0x32, 0x45,
      0x6d, 0xa4, 0x94, 0x11, 0x06, 0x1e, 0x90, 0x01, 0x88, 0x22, 0x5e, 0xb1,
      0x81, 0xcf, 0x57, 0xcd, 0x8b, 0xba, 0xdf, 0x05, 0x5f, 0x9f, 0x4d, 0xf6,
      0xf6, 0x38, 0x9a, 0xcd},
     {},
     priv_key_2,
     true},

    // Comment: seed is all 1
    // tcID: 21
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     21,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x79, 0xcb, 0x79, 0x28, 0xbc, 0xca, 0x16, 0xd8, 0xb7, 0x4a, 0x09, 0x00,
      0xd8, 0xde, 0x2b, 0x4e, 0x7f, 0x96, 0x2e, 0x60, 0x73, 0xd7, 0x4f, 0x3d,
      0xff, 0x11, 0xc5, 0xa7, 0xd3, 0xe4, 0x07, 0xca, 0x96, 0x2f, 0xd7, 0xea,
      0xe0, 0xd3, 0xdc, 0x1e, 0xde, 0x81, 0xea, 0x7c, 0xd4, 0x05, 0x9f, 0xd1,
      0xe3, 0x04, 0xbf, 0x29, 0x7c, 0xf3, 0x02, 0x07, 0xb0, 0xab, 0xc8, 0xaa,
      0x31, 0x18, 0x94, 0x03, 0xd5, 0x2a, 0x38, 0x81, 0x1b, 0x6f, 0x11, 0xbf,
      0xb9, 0x30, 0xc1, 0x5e, 0xc7, 0xb0, 0xe2, 0xe9, 0x03, 0x62, 0x3a, 0xe1,
      0xd8, 0x10, 0x83, 0xa5, 0xe0, 0xa7, 0x33, 0x1c, 0x62, 0x0d, 0x3d, 0x5b,
      0x28, 0x9a, 0xdc, 0xbb, 0x74, 0x24, 0x6d, 0x9c, 0x59, 0x33, 0x6d, 0x16,
      0x5c, 0x01, 0x76, 0xe3, 0xc1, 0xb9, 0x22, 0xd3, 0x81, 0xae, 0x8d, 0xa7,
      0x31, 0xa9, 0x33, 0x27, 0x9f, 0xef, 0x6d, 0x18, 0x5a, 0x68, 0x9e, 0x03,
      0x99, 0x70, 0x13, 0x5a, 0xc3, 0xc4, 0xd1, 0xd8, 0x7d, 0x85, 0x8e, 0x65,
      0xf4, 0x09, 0x34, 0x1c, 0x59, 0x3d, 0xd1, 0x99, 0xe2, 0xdc, 0x60, 0xc1,
      0x60, 0x33, 0x02, 0x3a, 0xd2, 0x66, 0x56, 0x15, 0x87, 0x7b, 0x41, 0x34,
      0x87, 0x21, 0xfd, 0xf3, 0x56, 0x9b, 0xd0, 0x3a, 0xff, 0x20, 0x6a, 0x00,
      0xa9, 0x70, 0x5c, 0x25, 0xb3, 0xe3, 0x3f, 0xf3, 0xb7, 0x00, 0xce, 0xd0,
      0x5a, 0x6e, 0x72, 0xf3, 0xc5, 0x58, 0x1e, 0xb3, 0x09, 0x0c, 0x1c, 0x23,
      0x8f, 0xf5, 0xfc, 0xb2, 0x6a, 0x28, 0x6b, 0xd4, 0xc2, 0x31, 0xf4, 0xeb,
      0xa8, 0x1c, 0x5d, 0xae, 0xe3, 0xc3, 0xc2, 0xdc, 0x9a, 0xc3, 0xcf, 0x2e,
      0x73, 0xbc, 0xc1, 0x5e, 0xef, 0x09, 0x1c, 0xef, 0x33, 0x5b, 0x8b, 0x89,
      0x96, 0x3a, 0x0d, 0x59, 0x83, 0xe1, 0x75, 0x4e, 0x42, 0x3d, 0x3b, 0x70,
      0xc0, 0x39, 0xb2, 0xc7},
     {},
     priv_key_2,
     true},

    // Comment: First byte is 1
    // tcID: 22
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     22,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xc2, 0x95, 0xf5, 0x7d, 0xe5, 0x1d, 0x49, 0x1e, 0xff, 0x36, 0x2a, 0xe8,
      0x45, 0x9c, 0x8b, 0xe0, 0x22, 0x4f, 0x27, 0x39, 0x3a, 0x6d, 0x13, 0x5b,
      0xc8, 0x65, 0x6b, 0x4f, 0x4a, 0x80, 0x1f, 0x50, 0xe1, 0xc4, 0xc4, 0x8b,
      0x9e, 0xb5, 0x2d, 0xda, 0x12, 0xc3, 0x97, 0x41, 0x6a, 0x89, 0xf7, 0x09,
      0x81, 0x3f, 0xc5, 0x00, 0x80, 0x4e, 0x0c, 0xb4, 0x58, 0xce, 0x64, 0xd7,
      0xc2, 0xc9, 0x6f, 0x3f, 0x1f, 0x89, 0xce, 0x70, 0xeb, 0x79, 0xb1, 0xf3,
      0xc2, 0xef, 0xbd, 0xc4, 0x6e, 0x1b, 0xf5, 0xdc, 0x8d, 0xee, 0xec, 0x5a,
      0x34, 0xab, 0x25, 0x25, 0x68, 0xaa, 0xf8, 0xb6, 0xd8, 0x32, 0xf6, 0x77,
      0xc0, 0x4a, 0xac, 0x91, 0x39, 0x01, 0xcd, 0x37, 0xc6, 0x91, 0x4f, 0xc3,
      0x51, 0x7e, 0x53, 0xde, 0x1d, 0x75, 0x06, 0x0c, 0x6c, 0x2d, 0x76, 0x66,
      0x25, 0xb5, 0xb8, 0x16, 0x3b, 0xa5, 0x56, 0x41, 0x4c, 0xd1, 0x14, 0xf4,
      0x54, 0x03, 0xf7, 0x3d, 0x26, 0x76, 0xb7, 0xfc, 0xf9, 0x20, 0x8d, 0x4f,
      0x29, 0x9d, 0x49, 0x2f, 0x14, 0x6f, 0x3e, 0x3d, 0xa3, 0x2e, 0xbf, 0xbd,
      0xe7, 0x7a, 0x4f, 0x91, 0x57, 0x4a, 0xbe, 0x21, 0x95, 0xaf, 0x5b, 0xa3,
      0xb9, 0x1b, 0xc4, 0xfe, 0x44, 0x1e, 0x15, 0xe0, 0x1d, 0xa0, 0xfc, 0xd6,
      0xd9, 0xe3, 0x74, 0xaa, 0xc3, 0x8e, 0x62, 0x26, 0x97, 0xb9, 0x38, 0x5e,
      0xdb, 0x49, 0x3b, 0xba, 0x4a, 0x48, 0x6d, 0x35, 0xe8, 0x70, 0x0c, 0x50,
      0x09, 0xec, 0x9c, 0xb8, 0x2c, 0xac, 0x71, 0xa8, 0x8c, 0x85, 0x4e, 0xdc,
      0x6f, 0x1c, 0xee, 0xf9, 0x6e, 0x75, 0x9c, 0x64, 0xb0, 0x83, 0x50, 0xf8,
      0x07, 0x3f, 0xff, 0x92, 0x94, 0x68, 0xef, 0x5a, 0xa8, 0x3a, 0x86, 0xbf,
      0xfd, 0x97, 0x50, 0xdc, 0x43, 0xea, 0x99, 0x92, 0x7e, 0x93, 0xb4, 0xb3,
      0xf8, 0x48, 0x19, 0xc8},
     {},
     priv_key_2,
     false},

    // Comment: m is 0
    // tcID: 23
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     23,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00},
     {},
     priv_key_2,
     false},

    // Comment: m is 1
    // tcID: 24
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     24,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01},
     {},
     priv_key_2,
     false},

    // Comment: m is n-1
    // tcID: 25
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     25,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xcd, 0xa6, 0xfa, 0x5c, 0xa7, 0x6b, 0xfe, 0x04, 0x92, 0xec, 0x57, 0xe0,
      0xa3, 0xbf, 0xff, 0x72, 0x72, 0xdc, 0x8d, 0x1e, 0x25, 0xad, 0x1f, 0xb3,
      0x38, 0xaa, 0x05, 0x0f, 0x02, 0xc1, 0x04, 0xe6, 0x31, 0x33, 0xd6, 0xb5,
      0xb7, 0xc4, 0x98, 0x5e, 0xbb, 0xae, 0x9a, 0xc0, 0x36, 0xa5, 0xb9, 0xc0,
      0x30, 0x74, 0xd6, 0x0a, 0xec, 0x8e, 0x25, 0xba, 0xf3, 0x92, 0xa0, 0xc4,
      0x30, 0xff, 0x05, 0xb8, 0x8e, 0x94, 0x88, 0x05, 0xd3, 0xdd, 0x74, 0x51,
      0x1d, 0x88, 0x85, 0x25, 0x0a, 0x7b, 0x57, 0x42, 0x15, 0xad, 0xa0, 0x15,
      0xc5, 0x59, 0x07, 0x66, 0x86, 0xe2, 0x53, 0xcc, 0xc9, 0x6c, 0x08, 0x15,
      0xb1, 0x29, 0x1e, 0xe7, 0x87, 0xcc, 0x33, 0x63, 0xb4, 0xf7, 0x7d, 0x93,
      0x0e, 0xb9, 0x98, 0xd7, 0xc5, 0x82, 0xb2, 0x4c, 0xea, 0x9c, 0xe2, 0x1d,
      0xe9, 0x72, 0x27, 0x91, 0x98, 0x98, 0x63, 0xa2, 0x7e, 0xbc, 0x80, 0xa0,
      0x0d, 0xe5, 0xbd, 0x2f, 0x92, 0x28, 0x77, 0x5e, 0x5a, 0x4c, 0xeb, 0x05,
      0x4d, 0x58, 0xc9, 0xbe, 0x36, 0xa0, 0x54, 0x33, 0x69, 0x71, 0xa1, 0x36,
      0x42, 0xdd, 0x95, 0x10, 0xdd, 0x69, 0x6a, 0xa2, 0x68, 0xdb, 0x3a, 0xab,
      0x22, 0x99, 0xd5, 0xd8, 0x8f, 0x8e, 0x56, 0x24, 0x34, 0xd1, 0x42, 0x70,
      0x94, 0xd3, 0xdf, 0x8e, 0x72, 0xd1, 0xef, 0x69, 0xb4, 0xed, 0x34, 0xd1,
      0x2b, 0xac, 0x37, 0x52, 0x23, 0xb2, 0xa2, 0x5c, 0xf2, 0x27, 0xf7, 0x35,
      0xf8, 0x16, 0xe8, 0x5e, 0x17, 0x23, 0x93, 0x04, 0x76, 0x9a, 0x60, 0x82,
      0x15, 0x4c, 0xd1, 0x58, 0x99, 0xfc, 0x1e, 0xae, 0xfb, 0x69, 0xb7, 0x48,
      0xa3, 0xe5, 0xed, 0x24, 0xd3, 0x83, 0x72, 0x59, 0x7d, 0xe3, 0xe4, 0xe2,
      0xa2, 0x7b, 0x95, 0x1d, 0x6a, 0xc7, 0xdb, 0x18, 0x2d, 0x68, 0x09, 0xd8,
      0xff, 0x51, 0x1b, 0x7e},
     {},
     priv_key_2,
     false},

    // Comment: ciphertext is empty
    // tcID: 26
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     26,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {},
     {},
     priv_key_2,
     false},

    // Comment: prepended bytes to ciphertext
    // tcID: 27
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     27,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x76, 0x7b, 0xcf, 0x45, 0x0f, 0x41, 0x6e, 0x42, 0x89, 0x80,
      0xa4, 0x88, 0xbc, 0x83, 0x07, 0x67, 0x49, 0x76, 0x25, 0x30, 0x08, 0xd8,
      0x13, 0x40, 0xa2, 0xf5, 0x19, 0xa1, 0xf4, 0xb9, 0x36, 0xab, 0xf0, 0x20,
      0x28, 0xc2, 0xe7, 0x61, 0x4f, 0x4a, 0xa3, 0x1a, 0x8b, 0x3e, 0x17, 0xc9,
      0x6b, 0x49, 0x22, 0x34, 0x0a, 0x6a, 0x96, 0x96, 0xfd, 0x4f, 0xf3, 0x58,
      0xc1, 0xa8, 0x4c, 0x34, 0x7b, 0x40, 0x50, 0x33, 0x45, 0x9f, 0x91, 0x92,
      0xe9, 0xf7, 0xd6, 0x11, 0xca, 0x2d, 0xa6, 0xa6, 0x69, 0xa8, 0x95, 0xd4,
      0x91, 0xa3, 0xc1, 0x90, 0x8c, 0xb5, 0x98, 0x73, 0x0b, 0x59, 0x6d, 0x66,
      0xb1, 0xd4, 0xb7, 0x61, 0x7f, 0x33, 0x76, 0x6a, 0xf3, 0x85, 0xc3, 0x33,
      0xf0, 0x37, 0xe7, 0x34, 0x1c, 0x96, 0x80, 0xf9, 0x85, 0x4f, 0x6a, 0xb4,
      0xf2, 0xc9, 0x86, 0x46, 0x2d, 0x87, 0x4f, 0x4d, 0xc6, 0x6c, 0x6f, 0xa4,
      0xf4, 0x9f, 0xd3, 0xef, 0x33, 0xd7, 0xc8, 0xcd, 0x81, 0xd7, 0x60, 0x84,
      0x11, 0xaa, 0x61, 0x0e, 0x5e, 0x91, 0x01, 0xdb, 0xdb, 0xa5, 0x22, 0xf7,
      0x5c, 0xd1, 0x2c, 0x57, 0x5b, 0x42, 0xd0, 0x82, 0x81, 0x12, 0x27, 0xba,
      0x10, 0x31, 0x9f, 0x6e, 0xa0, 0xc9, 0xa2, 0xeb, 0x6a, 0x3e, 0x63, 0xcf,
      0xe0, 0xc1, 0xba, 0xb1, 0x8f, 0x29, 0x09, 0x1f, 0xc5, 0xd6, 0x37, 0x27,
      0x85, 0x20, 0x8a, 0x83, 0x0f, 0x73, 0x2f, 0x8a, 0x06, 0x35, 0xf5, 0xee,
      0x7b, 0x0b, 0x9d, 0x2d, 0x62, 0xff, 0x9f, 0x1a, 0x6c, 0xb8, 0x8d, 0xa2,
      0x53, 0xad, 0x5f, 0x0d, 0x56, 0xe5, 0x72, 0x54, 0x8a, 0x35, 0x0a, 0x7e,
      0x12, 0xff, 0x84, 0x6d, 0x09, 0xad, 0x53, 0x52, 0xfa, 0x45, 0xde, 0x48,
      0x43, 0x86, 0xb5, 0x29, 0xe6, 0xf1, 0x4a, 0x1e, 0x80, 0x55, 0x14, 0x53,
      0x94, 0xf8, 0xd4, 0xf9, 0x1b, 0x80},
     {},
     priv_key_2,
     false},

    // Comment: appended bytes to ciphertext
    // tcID: 28
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     28,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x76, 0x7b, 0xcf, 0x45, 0x0f, 0x41, 0x6e, 0x42, 0x89, 0x80, 0xa4, 0x88,
      0xbc, 0x83, 0x07, 0x67, 0x49, 0x76, 0x25, 0x30, 0x08, 0xd8, 0x13, 0x40,
      0xa2, 0xf5, 0x19, 0xa1, 0xf4, 0xb9, 0x36, 0xab, 0xf0, 0x20, 0x28, 0xc2,
      0xe7, 0x61, 0x4f, 0x4a, 0xa3, 0x1a, 0x8b, 0x3e, 0x17, 0xc9, 0x6b, 0x49,
      0x22, 0x34, 0x0a, 0x6a, 0x96, 0x96, 0xfd, 0x4f, 0xf3, 0x58, 0xc1, 0xa8,
      0x4c, 0x34, 0x7b, 0x40, 0x50, 0x33, 0x45, 0x9f, 0x91, 0x92, 0xe9, 0xf7,
      0xd6, 0x11, 0xca, 0x2d, 0xa6, 0xa6, 0x69, 0xa8, 0x95, 0xd4, 0x91, 0xa3,
      0xc1, 0x90, 0x8c, 0xb5, 0x98, 0x73, 0x0b, 0x59, 0x6d, 0x66, 0xb1, 0xd4,
      0xb7, 0x61, 0x7f, 0x33, 0x76, 0x6a, 0xf3, 0x85, 0xc3, 0x33, 0xf0, 0x37,
      0xe7, 0x34, 0x1c, 0x96, 0x80, 0xf9, 0x85, 0x4f, 0x6a, 0xb4, 0xf2, 0xc9,
      0x86, 0x46, 0x2d, 0x87, 0x4f, 0x4d, 0xc6, 0x6c, 0x6f, 0xa4, 0xf4, 0x9f,
      0xd3, 0xef, 0x33, 0xd7, 0xc8, 0xcd, 0x81, 0xd7, 0x60, 0x84, 0x11, 0xaa,
      0x61, 0x0e, 0x5e, 0x91, 0x01, 0xdb, 0xdb, 0xa5, 0x22, 0xf7, 0x5c, 0xd1,
      0x2c, 0x57, 0x5b, 0x42, 0xd0, 0x82, 0x81, 0x12, 0x27, 0xba, 0x10, 0x31,
      0x9f, 0x6e, 0xa0, 0xc9, 0xa2, 0xeb, 0x6a, 0x3e, 0x63, 0xcf, 0xe0, 0xc1,
      0xba, 0xb1, 0x8f, 0x29, 0x09, 0x1f, 0xc5, 0xd6, 0x37, 0x27, 0x85, 0x20,
      0x8a, 0x83, 0x0f, 0x73, 0x2f, 0x8a, 0x06, 0x35, 0xf5, 0xee, 0x7b, 0x0b,
      0x9d, 0x2d, 0x62, 0xff, 0x9f, 0x1a, 0x6c, 0xb8, 0x8d, 0xa2, 0x53, 0xad,
      0x5f, 0x0d, 0x56, 0xe5, 0x72, 0x54, 0x8a, 0x35, 0x0a, 0x7e, 0x12, 0xff,
      0x84, 0x6d, 0x09, 0xad, 0x53, 0x52, 0xfa, 0x45, 0xde, 0x48, 0x43, 0x86,
      0xb5, 0x29, 0xe6, 0xf1, 0x4a, 0x1e, 0x80, 0x55, 0x14, 0x53, 0x94, 0xf8,
      0xd4, 0xf9, 0x1b, 0x80, 0x00, 0x00},
     {},
     priv_key_2,
     false},

    // Comment: truncated ciphertext
    // tcID: 29
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     29,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x7b, 0xcf, 0x45, 0x0f, 0x41, 0x6e, 0x42, 0x89, 0x80, 0xa4, 0x88, 0xbc,
      0x83, 0x07, 0x67, 0x49, 0x76, 0x25, 0x30, 0x08, 0xd8, 0x13, 0x40, 0xa2,
      0xf5, 0x19, 0xa1, 0xf4, 0xb9, 0x36, 0xab, 0xf0, 0x20, 0x28, 0xc2, 0xe7,
      0x61, 0x4f, 0x4a, 0xa3, 0x1a, 0x8b, 0x3e, 0x17, 0xc9, 0x6b, 0x49, 0x22,
      0x34, 0x0a, 0x6a, 0x96, 0x96, 0xfd, 0x4f, 0xf3, 0x58, 0xc1, 0xa8, 0x4c,
      0x34, 0x7b, 0x40, 0x50, 0x33, 0x45, 0x9f, 0x91, 0x92, 0xe9, 0xf7, 0xd6,
      0x11, 0xca, 0x2d, 0xa6, 0xa6, 0x69, 0xa8, 0x95, 0xd4, 0x91, 0xa3, 0xc1,
      0x90, 0x8c, 0xb5, 0x98, 0x73, 0x0b, 0x59, 0x6d, 0x66, 0xb1, 0xd4, 0xb7,
      0x61, 0x7f, 0x33, 0x76, 0x6a, 0xf3, 0x85, 0xc3, 0x33, 0xf0, 0x37, 0xe7,
      0x34, 0x1c, 0x96, 0x80, 0xf9, 0x85, 0x4f, 0x6a, 0xb4, 0xf2, 0xc9, 0x86,
      0x46, 0x2d, 0x87, 0x4f, 0x4d, 0xc6, 0x6c, 0x6f, 0xa4, 0xf4, 0x9f, 0xd3,
      0xef, 0x33, 0xd7, 0xc8, 0xcd, 0x81, 0xd7, 0x60, 0x84, 0x11, 0xaa, 0x61,
      0x0e, 0x5e, 0x91, 0x01, 0xdb, 0xdb, 0xa5, 0x22, 0xf7, 0x5c, 0xd1, 0x2c,
      0x57, 0x5b, 0x42, 0xd0, 0x82, 0x81, 0x12, 0x27, 0xba, 0x10, 0x31, 0x9f,
      0x6e, 0xa0, 0xc9, 0xa2, 0xeb, 0x6a, 0x3e, 0x63, 0xcf, 0xe0, 0xc1, 0xba,
      0xb1, 0x8f, 0x29, 0x09, 0x1f, 0xc5, 0xd6, 0x37, 0x27, 0x85, 0x20, 0x8a,
      0x83, 0x0f, 0x73, 0x2f, 0x8a, 0x06, 0x35, 0xf5, 0xee, 0x7b, 0x0b, 0x9d,
      0x2d, 0x62, 0xff, 0x9f, 0x1a, 0x6c, 0xb8, 0x8d, 0xa2, 0x53, 0xad, 0x5f,
      0x0d, 0x56, 0xe5, 0x72, 0x54, 0x8a, 0x35, 0x0a, 0x7e, 0x12, 0xff, 0x84,
      0x6d, 0x09, 0xad, 0x53, 0x52, 0xfa, 0x45, 0xde, 0x48, 0x43, 0x86, 0xb5,
      0x29, 0xe6, 0xf1, 0x4a, 0x1e, 0x80, 0x55, 0x14, 0x53, 0x94, 0xf8, 0xd4,
      0xf9, 0x1b, 0x80},
     {},
     priv_key_2,
     false},

    // Comment: em has low hamming weight
    // tcID: 30
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     30,
     {0xc8, 0x55, 0x6d, 0xdd, 0xe4, 0x08, 0x6f, 0x39, 0xf8, 0x81, 0xc4, 0x59,
      0xe7, 0x90, 0xab, 0x6d, 0x3e, 0x6a, 0xc8, 0x62, 0xbe, 0x3b, 0x0f, 0x7c,
      0xcd, 0xb6, 0xb1, 0x85, 0x9e, 0xb1, 0x60, 0x79, 0x3c, 0xc1, 0x65, 0x38,
      0x74, 0x4d, 0xd2, 0xd7, 0xb8, 0xf5, 0xd0, 0xa4, 0x31, 0xb2, 0xe7, 0xfb,
      0x21, 0xdc, 0x47, 0x97, 0x7b, 0x40, 0xcd, 0x13, 0x81, 0xfc, 0xc5, 0xf3,
      0xe8, 0x57, 0x73, 0x31, 0xc1, 0x45, 0x84, 0xab, 0x3e, 0x5e, 0xd9, 0x2a,
      0x97, 0x9a, 0x5b, 0xeb, 0xe4, 0xb4, 0x8c, 0x21, 0xa8, 0xb4, 0xf7, 0x1d,
      0x6a, 0x49, 0x6d, 0x52, 0x69, 0x07, 0xf7, 0xb6, 0xe5, 0x79, 0x13, 0x28,
      0xae, 0xfb, 0x25, 0x91, 0xe7, 0x99, 0x45, 0x64, 0xc9, 0x96, 0x82, 0x67,
      0x98, 0xbf, 0x62, 0xfa, 0x86, 0xd4, 0xb1, 0xe2, 0xf5, 0x7e, 0x5d, 0xf1,
      0xfa, 0xb3, 0x16, 0xa9, 0x28, 0xa0, 0x07, 0x17, 0x46, 0x98, 0xd3, 0x2d,
      0x15, 0xcc, 0x5a, 0x7e, 0x15, 0xac, 0xf5, 0x3c, 0x31, 0xb3, 0x0d, 0xfc,
      0x18, 0xaa, 0xb2, 0xaa, 0x9d, 0xdb, 0x0e, 0xda, 0xbe, 0x65, 0xe1, 0x53,
      0xed, 0xb6},
     {0xcd, 0x72, 0xb9, 0xc7, 0x69, 0x7a, 0x39, 0x93, 0x23, 0xbb, 0x3d, 0xf6,
      0x92, 0x56, 0xef, 0x3d, 0x78, 0x96, 0xc4, 0xb7, 0xc3, 0x5a, 0x49, 0x32,
      0xd5, 0x63, 0x21, 0xe2, 0xbc, 0xe7, 0xd5, 0x90, 0x39, 0x90, 0x41, 0x67,
      0x2d, 0x8a, 0x76, 0x94, 0xba, 0x94, 0x5d, 0x06, 0x54, 0x69, 0xd9, 0xf5,
      0x27, 0x41, 0x6c, 0xc7, 0x71, 0xd6, 0xbe, 0xc6, 0x9d, 0xb4, 0xd3, 0x65,
      0x3a, 0xb8, 0x4e, 0xf6, 0xa1, 0xe1, 0xab, 0x13, 0xcf, 0xcd, 0x5a, 0x23,
      0xb4, 0x9f, 0xe9, 0x70, 0xf2, 0x18, 0x01, 0x6b, 0xcc, 0x67, 0x4a, 0x65,
      0x5a, 0x10, 0x42, 0x6c, 0xac, 0x75, 0x58, 0x00, 0x65, 0xdf, 0x46, 0x7e,
      0x2b, 0x3c, 0xa9, 0x5e, 0x4a, 0x92, 0xf0, 0xc5, 0x8b, 0x5f, 0xd9, 0xe6,
      0x60, 0x6c, 0xc4, 0x44, 0x96, 0xa4, 0x22, 0x07, 0xda, 0x4b, 0x5b, 0xc4,
      0x6e, 0xa6, 0xd3, 0x89, 0xc3, 0x5b, 0x30, 0x95, 0xdb, 0x2c, 0x7e, 0xd7,
      0x56, 0x18, 0x24, 0x08, 0xac, 0x5c, 0x99, 0xae, 0xea, 0xa7, 0x09, 0x8b,
      0x1f, 0x4a, 0x91, 0xc5, 0xb6, 0xad, 0xe5, 0x87, 0x63, 0x3d, 0x66, 0xc9,
      0xbc, 0x33, 0x57, 0xb1, 0x1f, 0x3e, 0xcf, 0x01, 0x9b, 0x1c, 0x53, 0x85,
      0x8d, 0x45, 0x1d, 0x9f, 0x00, 0xa2, 0x33, 0x18, 0x33, 0x82, 0x55, 0xd4,
      0x89, 0x21, 0x97, 0x1e, 0x86, 0xad, 0xb8, 0x9a, 0x5c, 0x57, 0x42, 0xc6,
      0xd7, 0xda, 0x82, 0xc7, 0xb9, 0xeb, 0x71, 0x67, 0x9d, 0x2d, 0xc5, 0x49,
      0x11, 0xd9, 0xa4, 0x27, 0x24, 0x6b, 0xe0, 0x58, 0xf5, 0x4f, 0xf2, 0x69,
      0x10, 0x8c, 0x47, 0xa4, 0xbd, 0x56, 0x8c, 0x39, 0x53, 0xa9, 0x36, 0x5f,
      0x64, 0x15, 0x88, 0xf9, 0x5c, 0x3c, 0x51, 0x31, 0x1b, 0x3f, 0xe2, 0xf7,
      0xc4, 0xe9, 0xb9, 0x4f, 0x8d, 0xb3, 0x41, 0x0e, 0x73, 0x81, 0x57, 0xd5,
      0x7e, 0x55, 0x98, 0x98},
     {0x02, 0x7f, 0x3e, 0xb1, 0x4d, 0x2f, 0x37, 0x0b, 0x11, 0x8a, 0x0b,
      0x95, 0xac, 0xb6, 0xce, 0x98, 0x49, 0xb6, 0x39, 0x4d, 0xe0, 0x52,
      0x69, 0xf3, 0x39, 0xcb, 0xc5, 0x05, 0xfc, 0x1b, 0x45, 0xf3, 0xf6,
      0xa2, 0x5b, 0x82, 0x4c, 0xf9, 0x97, 0xa6, 0x40, 0x6a, 0xb2, 0xf4,
      0x96, 0xe1, 0x45, 0xbf, 0x00, 0x00, 0x00, 0x00},
     priv_key_2,
     true},

    // Comment: em has low hamming weight
    // tcID: 31
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     31,
     {0x5a, 0x1e, 0xba, 0x08, 0x3b, 0x90, 0x3a, 0xe2, 0xef, 0x8b, 0xcc, 0x91,
      0xee, 0x0c, 0xe4, 0x42, 0x49, 0x90, 0x3d, 0x72, 0xe0, 0xdf, 0xec, 0xdb,
      0x2e, 0x44, 0xe1, 0x96, 0xf7, 0xb1, 0xfe, 0xbe, 0x50, 0x90, 0xb5, 0x8e,
      0x40, 0xb6, 0xe7, 0x00, 0x04, 0xcf, 0x16, 0x3b, 0x9a, 0x59, 0xbc, 0x02,
      0x90, 0x8a, 0xaa, 0x3e, 0xb5, 0x20, 0x63, 0xd0, 0xb9, 0xae, 0x68, 0x17,
      0xa7, 0xea, 0xe8, 0x53, 0x3a, 0x13, 0x43, 0x7c, 0x0e, 0xaf, 0xe1, 0xb5,
      0xc3, 0x59, 0xb5, 0xdf, 0xbc, 0x88, 0x21, 0xe2, 0x13, 0xc4, 0x1b, 0xef,
      0xd4, 0xb4, 0x54, 0x8d, 0xd3, 0xe3, 0x7f, 0x01, 0xd6, 0xb4, 0x61, 0xd1,
      0x2c, 0xc4, 0x03, 0x1d, 0x50, 0xc9, 0x33, 0x51, 0x4f, 0x00, 0x4d, 0xce,
      0x0e, 0x62, 0xa4, 0xe9, 0x70, 0xb6, 0xa7, 0xb3, 0xbf, 0x06, 0x81, 0x9d,
      0xcb, 0x2a, 0x33, 0x35, 0x1d, 0x7e, 0x8c, 0x0d, 0x13, 0x0b, 0x0b, 0xbf,
      0x3a, 0x67, 0xe2, 0xb7, 0x5f, 0xb0, 0x05, 0x9f, 0xb6, 0xea, 0x83, 0x64,
      0x67, 0x8e, 0x90, 0xf8, 0x6f, 0x9e, 0xbf, 0x2e, 0x9e, 0x4c, 0x52, 0x99,
      0xd3, 0x89},
     {0x41, 0x12, 0xdc, 0x2f, 0x41, 0x5f, 0x5c, 0xa0, 0x5e, 0x1a, 0x93, 0x72,
      0x66, 0x00, 0x96, 0x83, 0x6f, 0x4e, 0x47, 0x64, 0x9e, 0xf2, 0x2f, 0x31,
      0xf3, 0xd2, 0xb2, 0x76, 0x5c, 0xcc, 0xed, 0xf9, 0x22, 0xbb, 0xd9, 0x41,
      0x7f, 0x38, 0x63, 0xee, 0x6b, 0xe8, 0xf9, 0x9a, 0x74, 0x8f, 0x6b, 0x2d,
      0x8b, 0xc0, 0xb2, 0x86, 0xab, 0xd2, 0x08, 0x49, 0x54, 0x8b, 0x01, 0x73,
      0xe3, 0x85, 0xfa, 0x90, 0x6d, 0x2e, 0x6d, 0x50, 0xac, 0x3c, 0x8b, 0xee,
      0xcb, 0xea, 0x78, 0xd9, 0x0a, 0xa7, 0xc6, 0x30, 0xf4, 0xcd, 0x12, 0x6b,
      0x84, 0xe3, 0x4b, 0x6a, 0xcb, 0xa9, 0xdd, 0x54, 0x5a, 0x86, 0x73, 0xc4,
      0xe0, 0x0d, 0xe4, 0xf6, 0xbc, 0xa4, 0x36, 0xf6, 0x26, 0xbd, 0x7b, 0x8c,
      0x1f, 0xf3, 0xc7, 0xcb, 0x3d, 0xa7, 0x17, 0x6e, 0xc1, 0x1a, 0x0f, 0xd5,
      0x96, 0x07, 0x89, 0x05, 0xa5, 0x7e, 0x91, 0x38, 0x7c, 0xe4, 0x70, 0xf7,
      0x3c, 0x23, 0x92, 0x27, 0xb6, 0xa9, 0x90, 0x6c, 0x3a, 0xa8, 0xcc, 0xc2,
      0x14, 0xf3, 0x23, 0xca, 0x46, 0x7a, 0x35, 0x9f, 0xd0, 0xd1, 0xae, 0x6c,
      0x3a, 0x56, 0x0d, 0x0f, 0x12, 0x85, 0x58, 0x9b, 0x3e, 0x8b, 0x2e, 0x2a,
      0xcb, 0xc3, 0xca, 0x60, 0x6f, 0xe2, 0x32, 0x98, 0x73, 0x9c, 0xc1, 0x94,
      0xd9, 0x74, 0x48, 0xa5, 0x72, 0x06, 0x59, 0x51, 0x89, 0xbb, 0xc9, 0xac,
      0x03, 0x9a, 0xec, 0xbb, 0x77, 0xa3, 0x87, 0x4a, 0xee, 0xd6, 0x1d, 0xdf,
      0x8f, 0xe7, 0x18, 0xa8, 0x73, 0x56, 0x0c, 0x52, 0xf7, 0xcf, 0xa2, 0x2d,
      0x05, 0x4d, 0x37, 0x0a, 0xff, 0x20, 0xa4, 0x8f, 0xc3, 0x18, 0x50, 0xa1,
      0x9d, 0x7c, 0x41, 0x73, 0xd1, 0x20, 0xa4, 0xfb, 0x10, 0x80, 0x51, 0xbc,
      0x68, 0xb8, 0xeb, 0xd4, 0x0d, 0xa3, 0x35, 0xf6, 0x20, 0xcc, 0xe5, 0x3c,
      0xd0, 0x7e, 0xa9, 0xdc},
     {0xd1, 0x4b, 0xd6, 0x1a, 0x24, 0x6e, 0x92, 0xee, 0x2b, 0xe3, 0x9c,
      0x60, 0x66, 0xd2, 0x5d, 0x2b, 0x2b, 0xb3, 0xbc, 0x95, 0xcf, 0xb1,
      0x6c, 0xa3, 0x47, 0x00, 0x04, 0x8e, 0xcd, 0xcf, 0xe8, 0x56, 0x85,
      0xd5, 0xaa, 0xb6, 0xbf, 0x71, 0xd5, 0xd8, 0x3b, 0xd6, 0xfa, 0xcc,
      0xb8, 0x1d, 0x1c, 0x0b, 0x00, 0x00, 0x00, 0x00},
     priv_key_2,
     true},

    // Comment: em has a large hamming weight
    // tcID: 32
    {SEC_OID_SHA384,
     CKG_MGF1_SHA384,
     32,
     {0x06, 0x8a, 0x7d, 0x66, 0x62, 0xc9, 0xe1, 0xf9, 0x6c, 0xb4, 0xc3, 0x2c,
      0xde, 0x0b, 0xa6, 0xda, 0x2a, 0xaf, 0x25, 0x50, 0x1d, 0xc5, 0xf3, 0xb0,
      0xcf, 0xf0, 0xc7, 0x4b, 0x6a, 0xdc, 0x1c, 0xac, 0xf8, 0x1c, 0x5b, 0x54,
      0x65, 0x05, 0xf3, 0x60, 0xa4, 0xed, 0xc9, 0x1f, 0x7f, 0x54, 0xcd, 0xac,
      0x99, 0x45, 0x8b, 0xdb, 0x01, 0xa5, 0xee, 0xe0, 0x49, 0x47, 0xe2, 0xc7,
      0x25, 0x04, 0x4d, 0xa5, 0x07, 0xc5, 0x60, 0xa8, 0xb9, 0x85, 0x6a, 0x53,
      0x74, 0xfd, 0x75, 0xc0, 0x2e, 0x6b, 0x8d, 0x1f, 0x91, 0x5e, 0x29, 0x1c,
      0x6d, 0x83, 0x52, 0xeb, 0x89, 0xce, 0xf2, 0xf9, 0x29, 0x7c, 0xc4, 0xd9,
      0xb8, 0xca, 0x11, 0x8d, 0x1e, 0xbf, 0xac, 0x47, 0xaa, 0x64, 0x99, 0x2a,
      0x7e, 0x07, 0x7e, 0x4b, 0xa3, 0x5c, 0xa1, 0x81, 0xeb, 0x3f, 0x0b, 0xda,
      0x03, 0x30, 0x72, 0x0f, 0x3f, 0x70, 0x2a, 0x33, 0x87, 0x8d, 0x30, 0x35,
      0xe1, 0x5e, 0x63, 0x76, 0xd5, 0x28, 0xfa, 0xde, 0xaf, 0x29, 0xdb, 0x79,
      0xf4, 0xb6, 0x94, 0x34, 0x17, 0xbc, 0x74, 0x1c, 0x2a, 0x2f, 0x1d, 0x1e,
      0xb5, 0x98},
     {0x20, 0x4f, 0x1d, 0xfe, 0x1c, 0xaf, 0x79, 0x52, 0xaf, 0x8d, 0x47, 0x45,
      0x07, 0x1f, 0x41, 0x76, 0xed, 0xab, 0x7c, 0x46, 0x70, 0xdb, 0x83, 0x50,
      0x2a, 0x45, 0x0f, 0x6b, 0x52, 0xa6, 0xd9, 0x0a, 0xef, 0x17, 0x9e, 0xb4,
      0x86, 0x9b, 0x37, 0x1d, 0x6a, 0x3e, 0xe2, 0xf0, 0x22, 0x54, 0x94, 0xbd,
      0xad, 0xe6, 0xbd, 0x38, 0xb0, 0x4a, 0x8c, 0xcb, 0xb0, 0x04, 0x93, 0xe7,
      0xc4, 0xb6, 0x0c, 0x0c, 0x5b, 0xe6, 0x71, 0x80, 0x8c, 0xa9, 0x1f, 0x93,
      0xae, 0xa1, 0x74, 0x96, 0xb4, 0x7c, 0xf9, 0xc6, 0xca, 0x83, 0xe5, 0xf6,
      0xcb, 0xdc, 0x41, 0x86, 0x0b, 0x84, 0x0f, 0x2c, 0x7b, 0xd1, 0x9c, 0x22,
      0x36, 0xaa, 0x1c, 0xaf, 0x92, 0xf7, 0xb7, 0xf1, 0x51, 0x30, 0x5a, 0xbb,
      0x17, 0x3d, 0x1c, 0xcb, 0xc9, 0x7a, 0x3d, 0xab, 0xf5, 0x0c, 0x24, 0xae,
      0x5d, 0x5b, 0xb7, 0x19, 0x59, 0x5c, 0xc2, 0xd1, 0xbe, 0xa2, 0x91, 0x85,
      0xc5, 0x5d, 0x7e, 0x1e, 0x87, 0x3f, 0xf5, 0x04, 0xb8, 0xe3, 0x00, 0x8e,
      0xc3, 0xbd, 0x8c, 0x70, 0x2e, 0x79, 0x2b, 0x6f, 0x6b, 0x7b, 0x24, 0xda,
      0xf7, 0x1b, 0x12, 0x16, 0x8f, 0xb5, 0xcd, 0x58, 0x6a, 0xc9, 0x31, 0x3b,
      0xce, 0x2f, 0xda, 0x37, 0xcf, 0xd0, 0xd6, 0x8e, 0x40, 0x14, 0x44, 0x92,
      0x0e, 0xa1, 0x25, 0xfd, 0x9e, 0x7c, 0x8f, 0x42, 0x4f, 0x4c, 0x5e, 0x0a,
      0x06, 0x8e, 0x7b, 0x95, 0x94, 0x82, 0x89, 0xd7, 0x14, 0x72, 0xb7, 0x5d,
      0x42, 0x90, 0x21, 0xac, 0xf7, 0x32, 0x49, 0x65, 0x1d, 0xeb, 0x09, 0xce,
      0xe0, 0x62, 0xde, 0x57, 0x4e, 0x5e, 0xc1, 0x81, 0x02, 0x85, 0x2d, 0x19,
      0x46, 0x05, 0x0c, 0x84, 0xb3, 0xda, 0x9e, 0x63, 0x75, 0x6f, 0x96, 0x4c,
      0xba, 0x0e, 0x4c, 0x68, 0xe8, 0xc8, 0xef, 0x2c, 0xbb, 0xf6, 0xcd, 0x32,
      0x5a, 0x11, 0x85, 0x3b},
     {0xd1, 0x35, 0x95, 0xcf, 0x0b, 0x41, 0x93, 0xb8, 0x0f, 0x34, 0xd3,
      0xed, 0x3f, 0x8a, 0x4c, 0xc3, 0xa3, 0xff, 0x5d, 0x42, 0xf6, 0xa2,
      0x1d, 0x7f, 0x14, 0x93, 0xe7, 0x44, 0xc3, 0xbb, 0x58, 0x19, 0xc5,
      0x3a, 0x9f, 0x16, 0xc9, 0xec, 0x3b, 0x62, 0xde, 0xce, 0x16, 0x7b,
      0xd6, 0x74, 0xa2, 0xf8, 0x00, 0x00, 0x00, 0x00},
     priv_key_2,
     true}};

#endif  // rsa_oaep_2048_sha384_mgf1sha384_vectors_h__
