# is-absolute [![NPM version](https://badge.fury.io/js/is-absolute.svg)](http://badge.fury.io/js/is-absolute)  [![Build Status](https://travis-ci.org/jonschlinkert/is-absolute.svg)](https://travis-ci.org/jonschlinkert/is-absolute)

> Return true if a file path is absolute.

Based on the `isAbsolute` utility method in [express](https://github.com/visionmedia/express).

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i is-absolute --save
```

## Usage

```js
var isAbsolute = require('is-absolute');

isAbsolute('a/b/c.js');
//=> 'false'
isAbsolute('/a/b/c.js');
//=> 'true'
```

**Explicitly test windows paths**

```js
isAbsolute.posix('/foo/bar');
isAbsolute.posix('/user/docs/Letter.txt');
//=> true

isAbsolute.posix('foo/bar');
//=> false
```

**Explicitly test windows paths**

```js
var isAbsolute = require('is-absolute');

isAbsolute.win32('c:\\');
isAbsolute.win32('//C://user\\docs\\Letter.txt');
isAbsolute.win32('\\\\unc\\share');
isAbsolute.win32('\\\\unc\\share\\foo');
isAbsolute.win32('\\\\unc\\share\\foo\\');
isAbsolute.win32('\\\\unc\\share\\foo\\bar');
isAbsolute.win32('\\\\unc\\share\\foo\\bar\\');
isAbsolute.win32('\\\\unc\\share\\foo\\bar\\baz');
//=> true

isAbsolute.win32('a:foo/a/b/c/d');
isAbsolute.win32(':\\');
isAbsolute.win32('foo\\bar\\baz');
isAbsolute.win32('foo\\bar\\baz\\');
//=> false
```

## Other projects

* [is-relative](https://github.com/jonschlinkert/is-relative): Returns `true` if the path appears to be relative.
* [is-dotfile](https://github.com/jonschlinkert/is-dotfile): Return true if a file path is (or has) a dotfile.
* [is-glob](https://github.com/jonschlinkert/is-glob): Returns `true` if the given string looks like a glob pattern.
* [is-unc-path](https://github.com/jonschlinkert/is-unc-path): Returns true if a filepath is a windows UNC file path.
* [is-valid-glob](https://github.com/jonschlinkert/is-valid-glob): Return true if a value is a valid glob pattern or patterns.

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/is-absolute/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2014-2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on July 11, 2015._