#===============================================================================
# Copyright 2014 NetApp, Inc. All Rights Reserved,
# contribution by Jorge Mora <mora@netapp.com>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#===============================================================================
# Generated by process_xdr.py from portmap2.x on Thu Sep 08 09:14:34 2016
"""
PORTMAPv2 constants module
"""
import nfstest_config as c

# Module constants
__author__    = "Jorge Mora (%s)" % c.NFSTEST_AUTHOR_EMAIL
__copyright__ = "Copyright (C) 2014 NetApp, Inc."
__license__   = "GPL v2"
__version__   = "2.0"

# Enum proto2
TCP = 6   # protocol number for TCP/IP
UDP = 17  # protocol number for UDP/IP

proto2 = {
     6 : "TCP",
    17 : "UDP",
}

# Enum portmap_proc2
PMAPPROC_NULL    = 0
PMAPPROC_SET     = 1
PMAPPROC_UNSET   = 2
PMAPPROC_GETPORT = 3
PMAPPROC_DUMP    = 4
PMAPPROC_CALLIT  = 5

portmap_proc2 = {
    0 : "PMAPPROC_NULL",
    1 : "PMAPPROC_SET",
    2 : "PMAPPROC_UNSET",
    3 : "PMAPPROC_GETPORT",
    4 : "PMAPPROC_DUMP",
    5 : "PMAPPROC_CALLIT",
}

# Enum portmap_prog2
PORTMAP   = 100000
RSTAT     = 100001
RUSERS    = 100002
NFS       = 100003
YPSERV    = 100004
MOUNT     = 100005
RDBX      = 100006
YPBIND    = 100007
WALL      = 100008
YPPASSWDD = 100009
ETHERSTAT = 100010
RQUOTA    = 100011
REXEC     = 100017
NLOCKMGR  = 100021
STATMON1  = 100023
STATMON2  = 100024
YPUPDATE  = 100028
NFS_ACL   = 100227

portmap_prog2 = {
    100000 : "PORTMAP",
    100001 : "RSTAT",
    100002 : "RUSERS",
    100003 : "NFS",
    100004 : "YPSERV",
    100005 : "MOUNT",
    100006 : "RDBX",
    100007 : "YPBIND",
    100008 : "WALL",
    100009 : "YPPASSWDD",
    100010 : "ETHERSTAT",
    100011 : "RQUOTA",
    100017 : "REXEC",
    100021 : "NLOCKMGR",
    100023 : "STATMON1",
    100024 : "STATMON2",
    100028 : "YPUPDATE",
    100227 : "NFS_ACL",
}
