// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
//! Structures used to hold wlan information.
use shared::basetsd::UINT8;
use shared::minwindef::{UCHAR, ULONG, USHORT};
ENUM!{enum DOT11_BSS_TYPE {
    dot11_BSS_type_infrastructure = 1,
    dot11_BSS_type_independent = 2,
    dot11_BSS_type_any = 3,
}}
pub type PDOT11_BSS_TYPE = *mut DOT11_BSS_TYPE;
pub const DOT11_SSID_MAX_LENGTH: usize = 32;
STRUCT!{struct DOT11_SSID {
    uSSIDLength: ULONG,
    ucSSID: [UCHAR; DOT11_SSID_MAX_LENGTH],
}}
pub type PDOT11_SSID = *mut DOT11_SSID;
ENUM!{enum DOT11_AUTH_ALGORITHM {
    DOT11_AUTH_ALGO_80211_OPEN = 1,
    DOT11_AUTH_ALGO_80211_SHARED_KEY = 2,
    DOT11_AUTH_ALGO_WPA = 3,
    DOT11_AUTH_ALGO_WPA_PSK = 4,
    DOT11_AUTH_ALGO_WPA_NONE = 5,
    DOT11_AUTH_ALGO_RSNA = 6,
    DOT11_AUTH_ALGO_RSNA_PSK = 7,
    DOT11_AUTH_ALGO_IHV_START = 0x80000000,
    DOT11_AUTH_ALGO_IHV_END = 0xffffffff,
}}
pub type PDOT11_AUTH_ALGORITHM = *mut DOT11_AUTH_ALGORITHM;
pub const DOT11_AUTH_ALGORITHM_OPEN_SYSTEM: DOT11_AUTH_ALGORITHM = DOT11_AUTH_ALGO_80211_OPEN;
pub const DOT11_AUTH_ALGORITHM_SHARED_KEY: DOT11_AUTH_ALGORITHM = DOT11_AUTH_ALGO_80211_SHARED_KEY;
pub const DOT11_AUTH_ALGORITHM_WPA: DOT11_AUTH_ALGORITHM = DOT11_AUTH_ALGO_WPA;
pub const DOT11_AUTH_ALGORITHM_WPA_PSK: DOT11_AUTH_ALGORITHM = DOT11_AUTH_ALGO_WPA_PSK;
pub const DOT11_AUTH_ALGORITHM_WPA_NONE: DOT11_AUTH_ALGORITHM = DOT11_AUTH_ALGO_WPA_NONE;
pub const DOT11_AUTH_ALGORITHM_RSNA: DOT11_AUTH_ALGORITHM = DOT11_AUTH_ALGO_RSNA;
pub const DOT11_AUTH_ALGORITHM_RSNA_PSK: DOT11_AUTH_ALGORITHM = DOT11_AUTH_ALGO_RSNA_PSK;
ENUM!{enum DOT11_CIPHER_ALGORITHM {
    DOT11_CIPHER_ALGO_NONE = 0x00,
    DOT11_CIPHER_ALGO_WEP40 = 0x01,
    DOT11_CIPHER_ALGO_TKIP = 0x02,
    DOT11_CIPHER_ALGO_CCMP = 0x04,
    DOT11_CIPHER_ALGO_WEP104 = 0x05,
    DOT11_CIPHER_ALGO_BIP = 0x06,
    DOT11_CIPHER_ALGO_GCMP = 0x08,
    DOT11_CIPHER_ALGO_WPA_USE_GROUP = 0x100,
    DOT11_CIPHER_ALGO_WEP = 0x101,
    DOT11_CIPHER_ALGO_IHV_START = 0x80000000,
    DOT11_CIPHER_ALGO_IHV_END = 0xffffffff,
}}
pub type PDOT11_CIPHER_ALGORITHM = *mut DOT11_CIPHER_ALGORITHM;
STRUCT!{struct DOT11_AUTH_CIPHER_PAIR {
    AuthAlgoId: DOT11_AUTH_ALGORITHM,
    CipherAlgoId: DOT11_CIPHER_ALGORITHM,
}}
pub type PDOT11_AUTH_CIPHER_PAIR = *mut DOT11_AUTH_CIPHER_PAIR;
pub const DOT11_OI_MAX_LENGTH: usize = 5;
pub const DOT11_OI_MIN_LENGTH: usize = 3;
STRUCT!{struct DOT11_OI {
    OILength: USHORT,
    OI: [UCHAR; DOT11_OI_MAX_LENGTH],
}}
pub type PDOT11_OI = *mut DOT11_OI;
STRUCT!{struct DOT11_ACCESSNETWORKOPTIONS {
    AccessNetworkType: UINT8,
    Internet: UINT8,
    ASRA: UINT8,
    ESR: UINT8,
    UESA: UINT8,
}}
pub type PDOT11_ACCESSNETWORKOPTIONS = *mut DOT11_ACCESSNETWORKOPTIONS;
STRUCT!{struct DOT11_VENUEINFO {
    VenueGroup: UINT8,
    VenueType: UINT8,
}}
pub type PDOT11_VENUEINFO = *mut DOT11_VENUEINFO;
