/*
 * Note: this file originally auto-generated by mib2c 
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-features.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#include <net-snmp/agent/table.h>
#include <net-snmp/agent/table_iterator.h>
#include "nsTransactionTable.h"

netsnmp_feature_require(table_dataset)

/** Initialize the nsTransactionTable table by defining it's contents
   and how it's structured */
void
initialize_table_nsTransactionTable(void)
{
    const oid nsTransactionTable_oid[] = { 1, 3, 6, 1, 4, 1, 8072, 1, 8, 1 };
    netsnmp_table_registration_info *table_info;
    netsnmp_handler_registration *my_handler;
    netsnmp_iterator_info *iinfo;

    /*
     * create the table structure itself 
     */
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    iinfo = SNMP_MALLOC_TYPEDEF(netsnmp_iterator_info);

    /*
     * if your table is read only, it's easiest to change the
     * HANDLER_CAN_RWRITE definition below to HANDLER_CAN_RONLY 
     */
    my_handler = netsnmp_create_handler_registration(
        "nsTransactionTable", nsTransactionTable_handler,
        nsTransactionTable_oid, OID_LENGTH(nsTransactionTable_oid),
        HANDLER_CAN_RONLY);

    if (!my_handler || !table_info || !iinfo) {
        if (my_handler)
            netsnmp_handler_registration_free(my_handler);
        SNMP_FREE(table_info);
        SNMP_FREE(iinfo);
        return;                 /* mallocs failed */
    }

    /***************************************************
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_index(table_info, ASN_INTEGER);    /* index:
                                                                 * * nsTransactionID 
                                                                 */

    table_info->min_column = 2;
    table_info->max_column = 2;
    iinfo->get_first_data_point = nsTransactionTable_get_first_data_point;
    iinfo->get_next_data_point = nsTransactionTable_get_next_data_point;
    iinfo->table_reginfo = table_info;

    /***************************************************
     * registering the table with the master agent
     */
    DEBUGMSGTL(("initialize_table_nsTransactionTable",
                "Registering table nsTransactionTable as a table iterator\n"));
    netsnmp_register_table_iterator2(my_handler, iinfo);
}

/** Initializes the nsTransactionTable module */
void
init_nsTransactionTable(void)
{

    /*
     * here we initialize all the tables we're planning on supporting 
     */
    initialize_table_nsTransactionTable();
}

/** returns the first data point within the nsTransactionTable table data.

    Set the my_loop_context variable to the first data point structure
    of your choice (from which you can find the next one).  This could
    be anything from the first node in a linked list, to an integer
    pointer containing the beginning of an array variable.

    Set the my_data_context variable to something to be returned to
    you later that will provide you with the data to return in a given
    row.  This could be the same pointer as what my_loop_context is
    set to, or something different.

    The put_index_data variable contains a list of snmp variable
    bindings, one for each index in your table.  Set the values of
    each appropriately according to the data matching the first row
    and return the put_index_data variable at the end of the function.
*/
extern netsnmp_agent_session *agent_delegated_list;

netsnmp_variable_list *
nsTransactionTable_get_first_data_point(void **my_loop_context,
                                        void **my_data_context,
                                        netsnmp_variable_list
                                        * put_index_data,
                                        netsnmp_iterator_info *iinfo)
{

    netsnmp_variable_list *vptr;

    if (!agent_delegated_list)
        return NULL;

    *my_loop_context = (void *) agent_delegated_list;
    *my_data_context = (void *) agent_delegated_list;

    vptr = put_index_data;

    snmp_set_var_value(vptr,
                       (u_char *) & agent_delegated_list->pdu->transid,
                       sizeof(agent_delegated_list->pdu->transid));

    return put_index_data;
}

/** functionally the same as nsTransactionTable_get_first_data_point, but
   my_loop_context has already been set to a previous value and should
   be updated to the next in the list.  For example, if it was a
   linked list, you might want to cast it and the return
   my_loop_context->next.  The my_data_context pointer should be set
   to something you need later and the indexes in put_index_data
   updated again. */

netsnmp_variable_list *
nsTransactionTable_get_next_data_point(void **my_loop_context,
                                       void **my_data_context,
                                       netsnmp_variable_list
                                       * put_index_data,
                                       netsnmp_iterator_info *iinfo)
{

    netsnmp_variable_list *vptr;
    netsnmp_agent_session *alist = (netsnmp_agent_session *)
        *my_loop_context;

    if (!alist->next)
        return NULL;

    alist = alist->next;

    *my_loop_context = (void *) alist;
    *my_data_context = (void *) alist;

    vptr = put_index_data;

    snmp_set_var_value(vptr, (u_char *) & alist->pdu->transid,
                       sizeof(alist->pdu->transid));
    return put_index_data;
}

/** handles requests for the nsTransactionTable table, if anything
   else needs to be done */
int
nsTransactionTable_handler(netsnmp_mib_handler *handler,
                           netsnmp_handler_registration *reginfo,
                           netsnmp_agent_request_info *reqinfo,
                           netsnmp_request_info *requests)
{

    netsnmp_table_request_info *table_info;
    netsnmp_variable_list *var;
    netsnmp_agent_session *asp;

    for (; requests; requests = requests->next) {
        var = requests->requestvb;
        if (requests->processed != 0)
            continue;

        /*
         * perform anything here that you need to do.  The requests have
         * already been processed by the master table_dataset handler, but
         * this gives you chance to act on the request in some other way if 
         * need be. 
         */

        /*
         * the following extracts the my_data_context pointer set in the
         * loop functions above.  You can then use the results to help
         * return data for the columns of the nsTransactionTable table in
         * question 
         */
        asp =
            (netsnmp_agent_session *)
            netsnmp_extract_iterator_context(requests);
        if (asp == NULL) {
            netsnmp_set_request_error(reqinfo, requests,
                                      SNMP_NOSUCHINSTANCE);
        }

        /*
         * extracts the information about the table from the request 
         */
        table_info = netsnmp_extract_table_info(requests);

        /*
         * table_info->colnum contains the column number requested 
         */
        /*
         * table_info->indexes contains a linked list of snmp variable
         * bindings for the indexes of the table.  Values in the list have 
         * been set corresponding to the indexes of the request 
         */
        if (table_info == NULL) {
            continue;
        }

        switch (reqinfo->mode) {
            /*
             * the table_iterator helper should change all GETNEXTs into
             * GETs for you automatically, so you don't have to worry
             * about the GETNEXT case.  Only GETs and SETs need to be
             * dealt with here 
             */
        case MODE_GET:
            switch (table_info->colnum) {

            case COLUMN_NSTRANSACTIONMODE:
                snmp_set_var_typed_value(var, ASN_INTEGER,
                                         (u_char *) & asp->mode,
                                         sizeof(asp->mode));
                break;

            default:
                /*
                 * We shouldn't get here 
                 */
                snmp_log(LOG_ERR,
                         "problem encountered in nsTransactionTable_handler: unknown column\n");
            }
            break;

        default:
            snmp_log(LOG_ERR,
                     "problem encountered in nsTransactionTable_handler: unsupported mode\n");
        }
    }
    return SNMP_ERR_NOERROR;
}
