/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.parsers.SecuritySupport;

class FactoryFinder {
    private static boolean debug;
    static /* synthetic */ Class class$javax$xml$parsers$FactoryFinder;

    FactoryFinder() {
    }

    static Object find(String string, String string2) throws ConfigurationError {
        Object object;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader = securitySupport.getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$javax$xml$parsers$FactoryFinder == null ? (class$javax$xml$parsers$FactoryFinder = FactoryFinder.class$("javax.xml.parsers.FactoryFinder")) : class$javax$xml$parsers$FactoryFinder).getClassLoader();
        }
        FactoryFinder.dPrint("find factoryId=" + string);
        try {
            object = securitySupport.getSystemProperty(string);
            if (object != null) {
                FactoryFinder.dPrint("found system property, value=" + (String)object);
                return FactoryFinder.newInstance((String)object, classLoader, true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            object = securitySupport.getSystemProperty("java.home");
            String string3 = (String)object + File.separator + "lib" + File.separator + "jaxp.properties";
            FileInputStream fileInputStream = securitySupport.getFileInputStream(new File(string3));
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string4 = properties.getProperty(string);
            if (string4 != null) {
                FactoryFinder.dPrint("found in jaxp.properties, value=" + string4);
                return FactoryFinder.newInstance(string4, classLoader, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = FactoryFinder.findJarServiceProvider(string);
        if (object != null) {
            return object;
        }
        if (string2 == null) {
            throw new ConfigurationError("Provider for " + string + " cannot be found", null);
        }
        FactoryFinder.dPrint("using fallback, value=" + string2);
        return FactoryFinder.newInstance(string2, classLoader, true);
    }

    private static void dPrint(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    private static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class<?> clazz;
            if (classLoader == null) {
                clazz = Class.forName(string);
            } else {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (bl) {
                        classLoader = (class$javax$xml$parsers$FactoryFinder == null ? (class$javax$xml$parsers$FactoryFinder = FactoryFinder.class$("javax.xml.parsers.FactoryFinder")) : class$javax$xml$parsers$FactoryFinder).getClassLoader();
                        clazz = classLoader.loadClass(string);
                    }
                    throw classNotFoundException;
                }
            }
            Object obj = clazz.newInstance();
            FactoryFinder.dPrint("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            return obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    private static Object findJarServiceProvider(String string) throws ConfigurationError {
        BufferedReader bufferedReader;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        String string2 = "META-INF/services/" + string;
        InputStream inputStream = null;
        ClassLoader classLoader = securitySupport.getContextClassLoader();
        if (classLoader != null) {
            inputStream = securitySupport.getResourceAsStream(classLoader, string2);
            if (inputStream == null) {
                classLoader = (class$javax$xml$parsers$FactoryFinder == null ? (class$javax$xml$parsers$FactoryFinder = FactoryFinder.class$("javax.xml.parsers.FactoryFinder")) : class$javax$xml$parsers$FactoryFinder).getClassLoader();
                inputStream = securitySupport.getResourceAsStream(classLoader, string2);
            }
        } else {
            classLoader = (class$javax$xml$parsers$FactoryFinder == null ? (class$javax$xml$parsers$FactoryFinder = FactoryFinder.class$("javax.xml.parsers.FactoryFinder")) : class$javax$xml$parsers$FactoryFinder).getClassLoader();
            inputStream = securitySupport.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        FactoryFinder.dPrint("found jar resource=" + string2 + " using ClassLoader: " + classLoader);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        if (string3 != null && !"".equals(string3)) {
            FactoryFinder.dPrint("found in resource, value=" + string3);
            return FactoryFinder.newInstance(string3, classLoader, false);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string = SecuritySupport.getInstance().getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

