/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected boolean fDOML1 = false;
    protected int fNamespaceCounter = 1;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;
    private boolean fPreserveSpace;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
    }

    public XMLSerializer(OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
    }

    public XMLSerializer(Writer writer, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(outputStream);
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        super.setOutputFormat(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
        this.fNSBinder = new NamespaceSupport();
        this.fLocalNSBinder = new NamespaceSupport();
        this.fSymbolTable = new SymbolTable();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = false;
        try {
            String string4;
            String string5;
            Object object;
            if (this._printer == null) {
                String string6 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(string6);
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string2 == null || string2.length() == 0 ? string3 : string2);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl2 = elementState.preserveSpace;
            attributes = this.extractNamespaces(attributes);
            if (string3 == null || string3.length() == 0) {
                if (string2 == null) {
                    String string7 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoName", null);
                    throw new SAXException(string7);
                }
                string3 = string != null && !string.equals("") ? ((object = this.getPrefix(string)) != null && ((String)object).length() > 0 ? (String)object + ":" + string2 : string2) : string2;
                bl = true;
            }
            this._printer.printText('<');
            this._printer.printText(string3);
            this._printer.indent();
            if (attributes != null) {
                int n = 0;
                while (n < attributes.getLength()) {
                    this._printer.printSpace();
                    string5 = attributes.getQName(n);
                    if (string5 != null && string5.length() == 0) {
                        string5 = attributes.getLocalName(n);
                        String string8 = attributes.getURI(n);
                        if (!(string8 == null || string8.length() == 0 || string != null && string.length() != 0 && string8.equals(string) || (object = this.getPrefix(string8)) == null || ((String)object).length() <= 0)) {
                            string5 = (String)object + ":" + string5;
                        }
                    }
                    if ((string4 = attributes.getValue(n)) == null) {
                        string4 = "";
                    }
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                    if (string5.equals("xml:space")) {
                        bl2 = string4.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            if (this._prefixes != null) {
                object = this._prefixes.keys();
                while (object.hasMoreElements()) {
                    this._printer.printSpace();
                    string4 = (String)object.nextElement();
                    string5 = (String)this._prefixes.get(string4);
                    if (string5.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(string4);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                }
            }
            elementState = this.enterElementState(string, string2, string3, bl2);
            string5 = string2 == null || string2.length() == 0 ? string3 : string + "^" + string2;
            elementState.doCData = this._format.isCDataElement(string5);
            elementState.unescaped = this._format.isNonEscapingElement(string5);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.endElementIO(string, string2, string3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElementIO(String string, String string2, String string3) throws IOException {
        this._printer.unindent();
        ElementState elementState = this.getElementState();
        if (elementState.empty) {
            this._printer.printText("/>");
        } else {
            if (elementState.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(elementState.rawName);
            this._printer.printText('>');
        }
        elementState = this.leaveElementState();
        elementState.afterElement = true;
        elementState.afterComment = false;
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        try {
            if (this._printer == null) {
                String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(string2);
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl = elementState.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(string);
            this._printer.indent();
            if (attributeList != null) {
                int n = 0;
                while (n < attributeList.getLength()) {
                    this._printer.printSpace();
                    String string3 = attributeList.getName(n);
                    String string4 = attributeList.getValue(n);
                    if (string4 != null) {
                        this._printer.printText(string3);
                        this._printer.printText("=\"");
                        this.printEscaped(string4);
                        this._printer.printText('\"');
                    }
                    if (string3.equals("xml:space")) {
                        bl = string4.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            elementState = this.enterElementState(null, null, string, bl);
            elementState.doCData = this._format.isCDataElement(string);
            elementState.unescaped = this._format.isNonEscapingElement(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    protected void startDocument(String string) throws IOException {
        String string2 = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer stringBuffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    stringBuffer.append(this._format.getVersion());
                } else {
                    stringBuffer.append("1.0");
                }
                stringBuffer.append('\"');
                String string3 = this._format.getEncoding();
                if (string3 != null) {
                    stringBuffer.append(" encoding=\"");
                    stringBuffer.append(string3);
                    stringBuffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    stringBuffer.append(" standalone=\"yes\"");
                }
                stringBuffer.append("?>");
                this._printer.printText(stringBuffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            int n = 0;
                            while (n < 18 + string.length()) {
                                this._printer.printText(" ");
                                ++n;
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (string2 != null && string2.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(string2, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (string2 != null && string2.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string);
                    this._printer.printText(" [");
                    this.printText(string2, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    protected void serializeElement(Element element) throws IOException {
        String string;
        String string2;
        Attr attr;
        int n;
        if (this.fNamespaces) {
            this.fLocalNSBinder.reset();
            this.fLocalNSBinder.pushContext();
            this.fNSBinder.pushContext();
        }
        String string3 = element.getTagName();
        ElementState elementState = this.getElementState();
        if (this.isDocumentState()) {
            boolean bl = this.fDOML1 = element.getLocalName() == null;
            if (!this._started) {
                this.startDocument(string3);
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (elementState.inCData) {
                this._printer.printText("]]>");
                elementState.inCData = false;
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
        }
        this.fPreserveSpace = elementState.preserveSpace;
        int n2 = 0;
        NamedNodeMap namedNodeMap = null;
        if (element.hasAttributes()) {
            namedNodeMap = element.getAttributes();
            n2 = namedNodeMap.getLength();
        }
        if (!this.fNamespaces) {
            this._printer.printText('<');
            this._printer.printText(string3);
            this._printer.indent();
            n = 0;
            while (n < n2) {
                attr = (Attr)namedNodeMap.item(n);
                string2 = attr.getName();
                string = attr.getValue();
                if (string == null) {
                    string = "";
                }
                if (attr.getSpecified()) {
                    this._printer.printSpace();
                    this._printer.printText(string2);
                    this._printer.printText("=\"");
                    this.printEscaped(string);
                    this._printer.printText('\"');
                }
                if (string2.equals("xml:space")) {
                    this.fPreserveSpace = string.equals("preserve") ? true : this._format.getPreserveSpace();
                }
                ++n;
            }
        } else {
            String string4;
            String string5;
            int n3;
            String string6;
            n = 0;
            while (n < n2) {
                attr = (Attr)namedNodeMap.item(n);
                string6 = attr.getNamespaceURI();
                if (string6 != null && string6.equals(NamespaceContext.XMLNS_URI)) {
                    string = attr.getNodeValue();
                    if (string == null) {
                        string = XMLSymbols.EMPTY_STRING;
                    }
                    if (string.equals(NamespaceContext.XMLNS_URI)) {
                        if (this.fDOMErrorHandler != null) {
                            this.modifyDOMError("No prefix other than 'xmlns' can be bound to 'http://www.w3.org/2000/xmlns/' namespace name", (short)1, attr);
                            n3 = this.fDOMErrorHandler.handleError(this.fDOMError) ? 1 : 0;
                            if (n3 == 0) {
                                throw new RuntimeException("Stopped at user request");
                            }
                        }
                    } else {
                        string5 = attr.getPrefix();
                        string5 = string5 == null || string5.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string5);
                        String string7 = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (string5 == XMLSymbols.PREFIX_XMLNS) {
                            if ((string = this.fSymbolTable.addSymbol(string)).length() != 0) {
                                this.fNSBinder.declarePrefix(string7, string);
                            }
                        } else {
                            string = this.fSymbolTable.addSymbol(string);
                            this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, string);
                        }
                    }
                }
                ++n;
            }
            string6 = element.getNamespaceURI();
            string5 = element.getPrefix();
            if (string6 != null && string5 != null && string6.length() == 0 && string5.length() != 0) {
                string5 = null;
                this._printer.printText('<');
                this._printer.printText(element.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(string3);
                this._printer.indent();
            }
            if (string6 != null) {
                string6 = this.fSymbolTable.addSymbol(string6);
                String string8 = string5 = string5 == null || string5.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string5);
                if (this.fNSBinder.getURI(string5) != string6) {
                    this.printNamespaceAttr(string5, string6);
                    this.fLocalNSBinder.declarePrefix(string5, string6);
                }
            } else {
                n3 = string3.indexOf(58);
                if (n3 > -1) {
                    if (this.fDOMErrorHandler != null) {
                        string4 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ElementQName", new Object[]{string3});
                        this.modifyDOMError(string4, (short)1, element);
                        boolean bl = this.fDOMErrorHandler.handleError(this.fDOMError);
                        if (!bl) {
                            throw new RuntimeException("Process stoped at user request");
                        }
                    }
                } else {
                    string6 = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                    if (string6 != null && string6.length() > 0) {
                        this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                        this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    }
                }
            }
            n = 0;
            while (n < n2) {
                attr = (Attr)namedNodeMap.item(n);
                string = attr.getValue();
                string2 = attr.getNodeName();
                string6 = attr.getNamespaceURI();
                if (string6 != null && string6.length() == 0) {
                    string6 = null;
                    string2 = attr.getLocalName();
                }
                if (string == null) {
                    string = XMLSymbols.EMPTY_STRING;
                }
                if (string6 != null) {
                    string5 = attr.getPrefix();
                    string5 = string5 == null ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string5);
                    String string9 = this.fSymbolTable.addSymbol(attr.getLocalName());
                    if (string6 != null && string6.equals(NamespaceContext.XMLNS_URI)) {
                        String string10;
                        string5 = attr.getPrefix();
                        string5 = string5 == null || string5.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string5);
                        string9 = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (string5 == XMLSymbols.PREFIX_XMLNS) {
                            string10 = this.fLocalNSBinder.getURI(string9);
                            if ((string = this.fSymbolTable.addSymbol(string)).length() != 0) {
                                if (string10 != null) {
                                    this.fNSBinder.declarePrefix(string9, string10);
                                } else {
                                    this.printNamespaceAttr(string9, string);
                                }
                            }
                        } else {
                            string6 = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                            string10 = this.fLocalNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                            string = this.fSymbolTable.addSymbol(string);
                            if (string10 != null) {
                                this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, string);
                            } else {
                                this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, string);
                            }
                        }
                    } else {
                        string6 = this.fSymbolTable.addSymbol(string6);
                        string4 = this.fNSBinder.getURI(string5);
                        if (string5 == XMLSymbols.EMPTY_STRING || string4 != string6) {
                            string2 = attr.getNodeName();
                            String string11 = this.fLocalNSBinder.getPrefix(string6);
                            if (string11 == null) {
                                string11 = this.fNSBinder.getPrefix(string6);
                            }
                            if (string11 != null && string11 != XMLSymbols.EMPTY_STRING) {
                                string5 = string11;
                                string2 = string5 + ":" + string9;
                            } else {
                                if (string5 == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(string5) != null) {
                                    string5 = this.fSymbolTable.addSymbol(PREFIX + this.fNamespaceCounter++);
                                    while (this.fLocalNSBinder.getURI(string5) != null) {
                                        string5 = this.fSymbolTable.addSymbol(PREFIX + this.fNamespaceCounter++);
                                    }
                                    string2 = string5 + ":" + string9;
                                }
                                this.printNamespaceAttr(string5, string6);
                                string = this.fSymbolTable.addSymbol(string);
                                this.fLocalNSBinder.declarePrefix(string5, string);
                                this.fNSBinder.declarePrefix(string5, string6);
                            }
                        }
                        this.printAttribute(string2, string == null ? XMLSymbols.EMPTY_STRING : string, attr.getSpecified());
                    }
                } else {
                    int n4 = string2.indexOf(58);
                    if (n4 > -1) {
                        if (this.fDOMErrorHandler != null) {
                            this.modifyDOMError("DOM Level 1 Node: " + string2, (short)1, attr);
                            boolean bl = this.fDOMErrorHandler.handleError(this.fDOMError);
                            if (!bl) {
                                throw new RuntimeException("Stopped at user request");
                            }
                        }
                        this.printAttribute(string2, string, attr.getSpecified());
                    } else {
                        this.printAttribute(string2, string, attr.getSpecified());
                    }
                }
                ++n;
            }
        }
        if (element.hasChildNodes()) {
            elementState = this.enterElementState(null, null, string3, this.fPreserveSpace);
            elementState.doCData = this._format.isCDataElement(string3);
            elementState.unescaped = this._format.isNonEscapingElement(string3);
            Node node = element.getFirstChild();
            while (node != null) {
                this.serializeNode(node);
                node = node.getNextSibling();
            }
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this.endElementIO(null, null, string3);
        } else {
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this._printer.unindent();
            this._printer.printText("/>");
            elementState.afterElement = true;
            elementState.afterComment = false;
            elementState.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void printNamespaceAttr(String string, String string2) throws IOException {
        this._printer.printSpace();
        if (string == XMLSymbols.EMPTY_STRING) {
            this._printer.printText(XMLSymbols.PREFIX_XMLNS);
        } else {
            this._printer.printText("xmlns:" + string);
        }
        this._printer.printText("=\"");
        this.printEscaped(string2);
        this._printer.printText('\"');
    }

    private void printAttribute(String string, String string2, boolean bl) throws IOException {
        if (bl || this.fFeatures != null && !((Boolean)this.fFeatures.get("discard-default-content")).booleanValue()) {
            this._printer.printSpace();
            this._printer.printText(string);
            this._printer.printText("=\"");
            this.printEscaped(string2);
            this._printer.printText('\"');
        }
        if (string.equals("xml:space")) {
            this.fPreserveSpace = string2.equals("preserve") ? true : this._format.getPreserveSpace();
        }
    }

    protected String getEntityRef(int n) {
        switch (n) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attributes) throws SAXException {
        if (attributes == null) {
            return null;
        }
        int n = attributes.getLength();
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n2 = n - 1;
        while (n2 >= 0) {
            String string = attributesImpl.getQName(n2);
            if (string.startsWith("xmlns")) {
                if (string.length() == 5) {
                    this.startPrefixMapping("", attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                } else if (string.charAt(5) == ':') {
                    this.startPrefixMapping(string.substring(6), attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                }
            }
            --n2;
        }
        return attributesImpl;
    }

    protected void printEscaped(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!XMLChar.isValid(c)) {
                if (++n2 < n) {
                    this.surrogates(c, string.charAt(n2));
                } else {
                    this.fatalError("The character '" + (char)c + "' is an invalid XML character");
                }
            } else {
                this.printXMLChar(c);
            }
            ++n2;
        }
    }

    protected final void printXMLChar(int n) throws IOException {
        if (n == 60) {
            this._printer.printText("&lt;");
        } else if (n == 38) {
            this._printer.printText("&amp;");
        } else if (n == 34) {
            this._printer.printText("&quot;");
        } else if (n >= 32 && this._encodingInfo.isPrintable(n) || n == 10 || n == 13 || n == 9) {
            this._printer.printText((char)n);
        } else {
            this._printer.printText("&#x");
            this._printer.printText(Integer.toHexString(n));
            this._printer.printText(';');
        }
    }

    protected void printText(String string, boolean bl, boolean bl2) throws IOException {
        int n = string.length();
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (!XMLChar.isValid(c)) {
                    if (++n2 < n) {
                        this.surrogates(c, string.charAt(n2));
                    } else {
                        this.fatalError("The character '" + c + "' is an invalid XML character");
                    }
                } else if (bl2) {
                    this._printer.printText(c);
                } else {
                    this.printXMLChar(c);
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                char c = string.charAt(n3);
                if (!XMLChar.isValid(c)) {
                    if (++n3 < n) {
                        this.surrogates(c, string.charAt(n3));
                    } else {
                        this.fatalError("The character '" + c + "' is an invalid XML character");
                    }
                } else if (XMLChar.isSpace(c)) {
                    this._printer.printSpace();
                } else if (bl2) {
                    this._printer.printText(c);
                } else {
                    this.printXMLChar(c);
                }
                ++n3;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void printText(char[] var1_1, int var2_2, int var3_3, boolean var4_4, boolean var5_5) throws IOException {
        block9: {
            if (!var4_4) ** GOTO lbl32
            while (var3_3-- > 0) {
                var7_6 = var1_1[var2_2];
                ++var2_2;
                if (!XMLChar.isValid(var7_6)) {
                    if (++var2_2 < var3_3) {
                        this.surrogates(var7_6, var1_1[var2_2]);
                        continue;
                    }
                    this.fatalError("The character '" + var7_6 + "' is an invalid XML character");
                    continue;
                }
                if (var5_5) {
                    this._printer.printText(var7_6);
                    continue;
                }
                this.printXMLChar(var7_6);
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                var7_7 = var1_1[var2_2];
                ++var2_2;
                if (!XMLChar.isValid(var7_7)) {
                    if (++var2_2 < var3_3) {
                        this.surrogates(var7_7, var1_1[var2_2]);
                        continue;
                    }
                    this.fatalError("The character '" + var7_7 + "' is an invalid XML character");
                    continue;
                }
                if (XMLChar.isSpace(var7_7)) {
                    this._printer.printSpace();
                    continue;
                }
                if (var5_5) {
                    this._printer.printText(var7_7);
                    continue;
                }
                this.printXMLChar(var7_7);
lbl32:
                // 6 sources

                ** while (var3_3-- > 0)
            }
        }
    }

    public boolean reset() {
        super.reset();
        return true;
    }
}

