/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMInputSourceImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.parsers.DOMBuilderImpl;
import org.apache.xml.serialize.DOMWriterImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMBuilder;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.DOMInputSource;
import org.w3c.dom.ls.DOMWriter;

public class CoreDOMImplementationImpl
implements DOMImplementation,
DOMImplementationLS {
    RevalidationHandler fDOMRevalidator = null;
    boolean free = true;
    static CoreDOMImplementationImpl singleton = new CoreDOMImplementationImpl();

    public static DOMImplementation getDOMImplementation() {
        return singleton;
    }

    public boolean hasFeature(String string, String string2) {
        boolean bl = string2 == null || string2.length() == 0;
        return string.equalsIgnoreCase("Core") && (bl || string2.equals("1.0") || string2.equals("2.0")) || string.equalsIgnoreCase("XML") && (bl || string2.equals("1.0") || string2.equals("2.0")) || string.equalsIgnoreCase("LS-Load") && (bl || string2.equals("3.0"));
    }

    public DocumentType createDocumentType(String string, String string2, String string3) {
        if (!CoreDocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        int n = string.indexOf(58);
        int n2 = string.lastIndexOf(58);
        if (n == 0 || n == string.length() - 1 || n2 != n) {
            throw new DOMException(14, "DOM003 Namespace error");
        }
        return new DocumentTypeImpl(null, string, string2, string3);
    }

    public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
        if (documentType != null && documentType.getOwnerDocument() != null) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        CoreDocumentImpl coreDocumentImpl = new CoreDocumentImpl(documentType);
        Element element = coreDocumentImpl.createElementNS(string, string2);
        coreDocumentImpl.appendChild(element);
        return coreDocumentImpl;
    }

    public DOMImplementation getInterface(String string) {
        throw new DOMException(9, "getInterface() is not implemented");
    }

    public DOMBuilder createDOMBuilder(short s, String string) throws DOMException {
        if (s == 2) {
            throw new DOMException(9, "Asynchronous mode is not supported");
        }
        if (string != null && string.equals("http://www.w3.org/TR/REC-xml")) {
            return new DOMBuilderImpl("org.apache.xerces.parsers.DTDConfiguration", string);
        }
        return new DOMBuilderImpl("org.apache.xerces.parsers.StandardParserConfiguration", string);
    }

    public DOMWriter createDOMWriter() {
        return new DOMWriterImpl(true);
    }

    public DOMInputSource createDOMInputSource() {
        return new DOMInputSourceImpl();
    }

    synchronized RevalidationHandler getValidator(String string) {
        if (this.fDOMRevalidator == null) {
            try {
                this.fDOMRevalidator = (RevalidationHandler)Class.forName("org.apache.xerces.impl.xs.XMLSchemaValidator").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {}
        }
        while (!this.isFree()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                try {
                    return (RevalidationHandler)Class.forName("org.apache.xerces.impl.xs.XMLSchemaValidator").newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        this.free = false;
        return this.fDOMRevalidator;
    }

    synchronized void releaseValidator(String string) {
        this.notifyAll();
        this.free = true;
    }

    final synchronized boolean isFree() {
        return this.free;
    }
}

