/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.impl.XMLEntityHandler;
import org.apache.xerces.impl.XMLEntityScanner;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.io.ASCIIReader;
import org.apache.xerces.impl.io.UCSReader;
import org.apache.xerces.impl.io.UTF8Reader;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.util.EncodingMap;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.URI;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLEntityManager
implements XMLComponent,
XMLEntityResolver {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final int DEFAULT_XMLDECL_BUFFER_SIZE = 64;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String WARN_ON_DUPLICATE_ENTITYDEF = "http://apache.org/xml/features/warn-on-duplicate-entitydef";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/warn-on-duplicate-entitydef"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/validation-manager"};
    private static final boolean DEBUG_BUFFER = false;
    private static final boolean DEBUG_ENTITIES = false;
    private static final boolean DEBUG_ENCODINGS = false;
    private static final boolean DEBUG_RESOLVER = false;
    protected boolean fValidation;
    protected boolean fExternalGeneralEntities;
    protected boolean fExternalParameterEntities;
    protected boolean fAllowJavaEncodings;
    protected boolean fWarnDuplicateEntityDef;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected ValidationManager fValidationManager;
    protected int fBufferSize = 2048;
    protected boolean fStandalone;
    protected XMLEntityHandler fEntityHandler;
    protected XMLEntityScanner fEntityScanner;
    protected Hashtable fEntities = new Hashtable();
    protected Stack fEntityStack = new Stack();
    protected ScannedEntity fCurrentEntity;
    protected Hashtable fDeclaredEntities;
    private final XMLResourceIdentifierImpl fResourceIdentifier = new XMLResourceIdentifierImpl();
    protected Vector fOwnReaders = new Vector();

    public XMLEntityManager() {
        this(null);
    }

    public XMLEntityManager(XMLEntityManager xMLEntityManager) {
        this.fEntityScanner = new EntityScanner();
        this.fDeclaredEntities = xMLEntityManager != null ? xMLEntityManager.getDeclaredEntities() : null;
    }

    public void setStandalone(boolean bl) {
        this.fStandalone = bl;
    }

    public boolean isStandalone() {
        return this.fStandalone;
    }

    public void setEntityHandler(XMLEntityHandler xMLEntityHandler) {
        this.fEntityHandler = xMLEntityHandler;
    }

    public void addInternalEntity(String string, String string2) {
        if (!this.fEntities.containsKey(string)) {
            InternalEntity internalEntity = new InternalEntity(string, string2);
            this.fEntities.put(string, internalEntity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{string}, (short)0);
        }
    }

    public void addExternalEntity(String string, String string2, String string3, String string4) {
        if (!this.fEntities.containsKey(string)) {
            if (string4 == null) {
                int n = this.fEntityStack.size();
                if (n == 0 && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null) {
                    string4 = this.fCurrentEntity.entityLocation.getExpandedSystemId();
                }
                int n2 = n - 1;
                while (n2 >= 0) {
                    ScannedEntity scannedEntity = (ScannedEntity)this.fEntityStack.elementAt(n2);
                    if (scannedEntity.entityLocation != null && scannedEntity.entityLocation.getExpandedSystemId() != null) {
                        string4 = scannedEntity.entityLocation.getExpandedSystemId();
                        break;
                    }
                    --n2;
                }
            }
            ExternalEntity externalEntity = new ExternalEntity(string, new XMLResourceIdentifierImpl(string2, string3, string4, XMLEntityManager.expandSystemId(string3, string4)), null);
            this.fEntities.put(string, externalEntity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{string}, (short)0);
        }
    }

    public boolean isExternalEntity(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            return false;
        }
        return entity.isExternal();
    }

    public void addUnparsedEntity(String string, String string2, String string3, String string4, String string5) {
        if (!this.fEntities.containsKey(string)) {
            ExternalEntity externalEntity = new ExternalEntity(string, new XMLResourceIdentifierImpl(string2, string3, string4, null), string5);
            this.fEntities.put(string, externalEntity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{string}, (short)0);
        }
    }

    public boolean isUnparsedEntity(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            return false;
        }
        return entity.isUnparsed();
    }

    public boolean isDeclaredEntity(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        return entity != null;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws IOException, XNIException {
        boolean bl;
        if (xMLResourceIdentifier == null) {
            return null;
        }
        String string = xMLResourceIdentifier.getPublicId();
        String string2 = xMLResourceIdentifier.getLiteralSystemId();
        String string3 = xMLResourceIdentifier.getBaseSystemId();
        String string4 = xMLResourceIdentifier.getExpandedSystemId();
        boolean bl2 = bl = string4 == null;
        if (string3 == null && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null && (string3 = this.fCurrentEntity.entityLocation.getExpandedSystemId()) != null) {
            bl = true;
        }
        if (bl) {
            string4 = XMLEntityManager.expandSystemId(string2, string3);
        }
        XMLInputSource xMLInputSource = null;
        if (this.fEntityResolver != null) {
            XMLResourceIdentifierImpl xMLResourceIdentifierImpl = null;
            if (xMLResourceIdentifier instanceof XMLResourceIdentifierImpl) {
                xMLResourceIdentifierImpl = (XMLResourceIdentifierImpl)xMLResourceIdentifier;
            } else {
                this.fResourceIdentifier.clear();
                xMLResourceIdentifierImpl = this.fResourceIdentifier;
            }
            xMLResourceIdentifierImpl.setValues(string, string2, string3, string4);
            xMLInputSource = this.fEntityResolver.resolveEntity(xMLResourceIdentifierImpl);
        }
        if (xMLInputSource == null) {
            xMLInputSource = new XMLInputSource(string, string2, string3);
        }
        return xMLInputSource;
    }

    public void startEntity(String string, boolean bl) throws IOException, XNIException {
        int n;
        int n2;
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            if (this.fEntityHandler != null) {
                String string2 = null;
                this.fResourceIdentifier.clear();
                this.fEntityHandler.startEntity(string, this.fResourceIdentifier, string2);
                this.fEntityHandler.endEntity(string);
            }
            return;
        }
        boolean bl2 = entity.isExternal();
        if (bl2 && (this.fValidationManager == null || !this.fValidationManager.isCachedDTD())) {
            boolean bl3;
            n2 = entity.isUnparsed() ? 1 : 0;
            n = string.startsWith("%") ? 1 : 0;
            boolean bl4 = bl3 = n == 0;
            if (n2 != 0 || bl3 && !this.fExternalGeneralEntities || n != 0 && !this.fExternalParameterEntities) {
                if (this.fEntityHandler != null) {
                    this.fResourceIdentifier.clear();
                    String string3 = null;
                    ExternalEntity externalEntity = (ExternalEntity)entity;
                    String string4 = externalEntity.entityLocation != null ? externalEntity.entityLocation.getLiteralSystemId() : null;
                    String string5 = externalEntity.entityLocation != null ? externalEntity.entityLocation.getBaseSystemId() : null;
                    String string6 = XMLEntityManager.expandSystemId(string4, string5);
                    this.fResourceIdentifier.setValues(externalEntity.entityLocation != null ? externalEntity.entityLocation.getPublicId() : null, string4, string5, string6);
                    this.fEntityHandler.startEntity(string, this.fResourceIdentifier, string3);
                    this.fEntityHandler.endEntity(string);
                }
                return;
            }
        }
        n = n2 = this.fEntityStack.size();
        while (n >= 0) {
            Entity entity2;
            Entity entity3 = entity2 = n == n2 ? this.fCurrentEntity : (Entity)this.fEntityStack.elementAt(n);
            if (entity2.name == string) {
                String string7 = string;
                int n3 = n + 1;
                while (n3 < n2) {
                    entity2 = (Entity)this.fEntityStack.elementAt(n3);
                    string7 = string7 + " -> " + entity2.name;
                    ++n3;
                }
                string7 = string7 + " -> " + this.fCurrentEntity.name;
                string7 = string7 + " -> " + string;
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "RecursiveReference", new Object[]{string, string7}, (short)2);
                if (this.fEntityHandler != null) {
                    this.fResourceIdentifier.clear();
                    String string8 = null;
                    if (bl2) {
                        ExternalEntity externalEntity = (ExternalEntity)entity;
                        String string9 = externalEntity.entityLocation != null ? externalEntity.entityLocation.getLiteralSystemId() : null;
                        String string10 = externalEntity.entityLocation != null ? externalEntity.entityLocation.getBaseSystemId() : null;
                        String string11 = XMLEntityManager.expandSystemId(string9, string10);
                        this.fResourceIdentifier.setValues(externalEntity.entityLocation != null ? externalEntity.entityLocation.getPublicId() : null, string9, string10, string11);
                    }
                    this.fEntityHandler.startEntity(string, this.fResourceIdentifier, string8);
                    this.fEntityHandler.endEntity(string);
                }
                return;
            }
            --n;
        }
        XMLInputSource xMLInputSource = null;
        if (bl2) {
            ExternalEntity externalEntity = (ExternalEntity)entity;
            xMLInputSource = this.resolveEntity(externalEntity.entityLocation);
        } else {
            InternalEntity internalEntity = (InternalEntity)entity;
            StringReader stringReader = new StringReader(internalEntity.text);
            xMLInputSource = new XMLInputSource(null, null, null, stringReader, null);
        }
        this.startEntity(string, xMLInputSource, bl, bl2);
    }

    public void startDocumentEntity(XMLInputSource xMLInputSource) throws IOException, XNIException {
        String string = this.fSymbolTable.addSymbol("[xml]");
        this.startEntity(string, xMLInputSource, false, true);
    }

    public void startDTDEntity(XMLInputSource xMLInputSource) throws IOException, XNIException {
        String string = this.fSymbolTable.addSymbol("[dtd]");
        this.startEntity(string, xMLInputSource, false, true);
    }

    public void startEntity(String string, XMLInputSource xMLInputSource, boolean bl, boolean bl2) throws IOException, XNIException {
        String string2 = xMLInputSource.getPublicId();
        String string3 = xMLInputSource.getSystemId();
        String string4 = xMLInputSource.getBaseSystemId();
        String string5 = xMLInputSource.getEncoding();
        Boolean bl3 = null;
        InputStream inputStream = null;
        Reader reader = xMLInputSource.getCharacterStream();
        String string6 = XMLEntityManager.expandSystemId(string3, string4);
        if (string4 == null) {
            string4 = string6;
        }
        if (reader == null) {
            inputStream = xMLInputSource.getByteStream();
            if (inputStream == null) {
                inputStream = new URL(string6).openStream();
            }
            inputStream = new RewindableInputStream(inputStream);
            if (string5 == null) {
                byte[] byArray = new byte[4];
                int n = 0;
                while (n < 4) {
                    byArray[n] = (byte)inputStream.read();
                    ++n;
                }
                if (n == 4) {
                    Object[] objectArray = this.getEncodingName(byArray, n);
                    string5 = (String)objectArray[0];
                    bl3 = (Boolean)objectArray[1];
                    inputStream.reset();
                    boolean bl4 = false;
                    if (n > 2 && string5.equals("UTF-8")) {
                        int n2 = byArray[0] & 0xFF;
                        int n3 = byArray[1] & 0xFF;
                        int n4 = byArray[2] & 0xFF;
                        if (n2 == 239 && n3 == 187 && n4 == 191) {
                            inputStream.skip(3L);
                        }
                    }
                    reader = this.createReader(inputStream, string5, bl3);
                } else {
                    reader = this.createReader(inputStream, string5, bl3);
                }
            } else {
                reader = this.createReader(inputStream, string5, bl3);
            }
        }
        this.fOwnReaders.addElement(reader);
        if (this.fCurrentEntity != null) {
            this.fEntityStack.push(this.fCurrentEntity);
        }
        this.fCurrentEntity = new ScannedEntity(string, new XMLResourceIdentifierImpl(string2, string3, string4, string6), inputStream, reader, string5, bl, false, bl2);
        if (this.fEntityHandler != null) {
            this.fResourceIdentifier.setValues(string2, string3, string4, string6);
            this.fEntityHandler.startEntity(string, this.fResourceIdentifier, string5);
        }
    }

    public XMLEntityScanner getEntityScanner() {
        return this.fEntityScanner;
    }

    public void closeReaders() {
        int n = this.fOwnReaders.size() - 1;
        while (n >= 0) {
            try {
                ((Reader)this.fOwnReaders.elementAt(n)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            --n;
        }
        this.fOwnReaders.removeAllElements();
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        try {
            this.fValidation = xMLComponentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fExternalGeneralEntities = xMLComponentManager.getFeature(EXTERNAL_GENERAL_ENTITIES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fExternalGeneralEntities = true;
        }
        try {
            this.fExternalParameterEntities = xMLComponentManager.getFeature(EXTERNAL_PARAMETER_ENTITIES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fExternalParameterEntities = true;
        }
        try {
            this.fAllowJavaEncodings = xMLComponentManager.getFeature(ALLOW_JAVA_ENCODINGS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fAllowJavaEncodings = false;
        }
        try {
            this.fWarnDuplicateEntityDef = xMLComponentManager.getFeature(WARN_ON_DUPLICATE_ENTITYDEF);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fWarnDuplicateEntityDef = false;
        }
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        try {
            this.fEntityResolver = (XMLEntityResolver)xMLComponentManager.getProperty(ENTITY_RESOLVER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fEntityResolver = null;
        }
        try {
            this.fValidationManager = (ValidationManager)xMLComponentManager.getProperty(VALIDATION_MANAGER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidationManager = null;
        }
        this.fStandalone = false;
        this.fEntities.clear();
        this.fEntityStack.removeAllElements();
        this.fCurrentEntity = null;
        if (this.fDeclaredEntities != null) {
            Enumeration enumeration = this.fDeclaredEntities.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = this.fDeclaredEntities.get(k);
                this.fEntities.put(k, v);
            }
        }
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        String string2;
        if (string.startsWith("http://apache.org/xml/features/") && (string2 = string.substring("http://apache.org/xml/features/".length())).equals("allow-java-encodings")) {
            this.fAllowJavaEncodings = bl;
        }
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            String string2 = string.substring("http://apache.org/xml/properties/".length());
            if (string2.equals("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)object;
                return;
            }
            if (string2.equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)object;
                return;
            }
            if (string2.equals("internal/entity-resolver")) {
                this.fEntityResolver = (XMLEntityResolver)object;
                return;
            }
        }
    }

    public static String expandSystemId(String string) {
        return XMLEntityManager.expandSystemId(string, null);
    }

    public static String expandSystemId(String string, String string2) {
        Object object;
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            object = new URI(string);
            if (object != null) {
                return string;
            }
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        object = XMLEntityManager.fixURI(string);
        URI uRI = null;
        URI uRI2 = null;
        try {
            if (string2 == null || string2.length() == 0 || string2.equals(string)) {
                String string3;
                try {
                    string3 = XMLEntityManager.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException securityException) {
                    string3 = "";
                }
                if (!string3.endsWith("/")) {
                    string3 = string3 + "/";
                }
                uRI = new URI("file", "", string3, null, null);
            } else {
                try {
                    uRI = new URI(XMLEntityManager.fixURI(string2));
                }
                catch (URI.MalformedURIException malformedURIException) {
                    String string4;
                    try {
                        string4 = XMLEntityManager.fixURI(System.getProperty("user.dir"));
                    }
                    catch (SecurityException securityException) {
                        string4 = "";
                    }
                    if (string2.indexOf(58) != -1) {
                        uRI = new URI("file", "", XMLEntityManager.fixURI(string2), null, null);
                    }
                    if (!string4.endsWith("/")) {
                        string4 = string4 + "/";
                    }
                    string4 = string4 + XMLEntityManager.fixURI(string2);
                    uRI = new URI("file", "", string4, null, null);
                }
            }
            uRI2 = new URI(uRI, (String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRI2 == null) {
            return string;
        }
        return uRI2.toString();
    }

    protected void endEntity() throws XNIException {
        if (this.fEntityHandler != null) {
            this.fEntityHandler.endEntity(this.fCurrentEntity.name);
        }
        this.fCurrentEntity = this.fEntityStack.size() > 0 ? (ScannedEntity)this.fEntityStack.pop() : null;
    }

    protected Object[] getEncodingName(byte[] byArray, int n) {
        if (n < 2) {
            return new Object[]{"UTF-8", null};
        }
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        if (n2 == 254 && n3 == 255) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n2 == 255 && n3 == 254) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n < 3) {
            return new Object[]{"UTF-8", null};
        }
        int n4 = byArray[2] & 0xFF;
        if (n2 == 239 && n3 == 187 && n4 == 191) {
            return new Object[]{"UTF-8", null};
        }
        if (n < 4) {
            return new Object[]{"UTF-8", null};
        }
        int n5 = byArray[3] & 0xFF;
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(false)};
        }
        if (n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null};
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null};
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
            return new Object[]{"CP037", null};
        }
        return new Object[]{"UTF-8", null};
    }

    protected Reader createReader(InputStream inputStream, String string, Boolean bl) throws IOException {
        String string2;
        String string3;
        if (string == null) {
            string = "UTF-8";
        }
        if ((string3 = string.toUpperCase()).equals("UTF-8")) {
            return new UTF8Reader(inputStream, this.fBufferSize);
        }
        if (string3.equals("US-ASCII")) {
            return new ASCIIReader(inputStream, this.fBufferSize);
        }
        if (string3.equals("ISO-10646-UCS-4")) {
            if (bl != null) {
                boolean bl2 = bl;
                if (bl2) {
                    return new UCSReader(inputStream, UCSReader.UCS4BE);
                }
                return new UCSReader(inputStream, UCSReader.UCS4LE);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{string}, (short)2);
        }
        if (string3.equals("ISO-10646-UCS-2")) {
            if (bl != null) {
                boolean bl3 = bl;
                if (bl3) {
                    return new UCSReader(inputStream, UCSReader.UCS2BE);
                }
                return new UCSReader(inputStream, UCSReader.UCS2LE);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{string}, (short)2);
        }
        boolean bl4 = XMLChar.isValidIANAEncoding(string);
        boolean bl5 = XMLChar.isValidJavaEncoding(string);
        if (!bl4 || this.fAllowJavaEncodings && !bl5) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{string}, (short)2);
            string = "ISO-8859-1";
        }
        if ((string2 = EncodingMap.getIANA2JavaMapping(string3)) == null) {
            if (this.fAllowJavaEncodings) {
                string2 = string;
            } else {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{string}, (short)2);
                string2 = "ISO8859_1";
            }
        }
        return new InputStreamReader(inputStream, string2);
    }

    protected static String fixURI(String string) {
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2) {
            char c = string.charAt(1);
            if (c == ':') {
                char c2 = Character.toUpperCase(string.charAt(0));
                if (c2 >= 'A' && c2 <= 'Z') {
                    string = "/" + string;
                }
            } else if (c == '/' && string.charAt(0) == '/') {
                string = "file:" + string;
            }
        }
        return string;
    }

    Hashtable getDeclaredEntities() {
        return this.fEntities;
    }

    final void print() {
    }

    protected final class RewindableInputStream
    extends InputStream {
        private InputStream fInputStream;
        private byte[] fData = new byte[2048];
        private int fStartOffset;
        private int fEndOffset;
        private int fOffset;
        private int fLength;
        private int fMark;

        public RewindableInputStream(InputStream inputStream) {
            this.fInputStream = inputStream;
            this.fStartOffset = 0;
            this.fEndOffset = -1;
            this.fOffset = 0;
            this.fLength = 0;
            this.fMark = 0;
        }

        public void setStartOffset(int n) {
            this.fStartOffset = n;
        }

        public void rewind() {
            this.fOffset = this.fStartOffset;
        }

        public int read() throws IOException {
            int n = 0;
            if (this.fOffset < this.fLength) {
                return this.fData[this.fOffset++] & 0xFF;
            }
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            if (this.fOffset == this.fData.length) {
                byte[] byArray = new byte[this.fOffset << 1];
                System.arraycopy(this.fData, 0, byArray, 0, this.fOffset);
                this.fData = byArray;
            }
            if ((n = this.fInputStream.read()) == -1) {
                this.fEndOffset = this.fOffset;
                return -1;
            }
            this.fData[this.fLength++] = (byte)n;
            ++this.fOffset;
            return n & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.fLength - this.fOffset;
            if (n3 == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                if (XMLEntityManager.this.fCurrentEntity.mayReadChunks) {
                    return this.fInputStream.read(byArray, n, n2);
                }
                int n4 = this.read();
                if (n4 == -1) {
                    this.fEndOffset = this.fOffset;
                    return -1;
                }
                byArray[n] = (byte)n4;
                return 1;
            }
            if (n2 < n3) {
                if (n2 <= 0) {
                    return 0;
                }
            } else {
                n2 = n3;
            }
            if (byArray != null) {
                System.arraycopy(this.fData, this.fOffset, byArray, n, n2);
            }
            this.fOffset += n2;
            return n2;
        }

        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            int n = this.fLength - this.fOffset;
            if (n == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return 0L;
                }
                return this.fInputStream.skip(l);
            }
            if (l <= (long)n) {
                this.fOffset = (int)((long)this.fOffset + l);
                return l;
            }
            this.fOffset += n;
            if (this.fOffset == this.fEndOffset) {
                return n;
            }
            return this.fInputStream.skip(l -= (long)n) + (long)n;
        }

        public int available() throws IOException {
            int n = this.fLength - this.fOffset;
            if (n == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return XMLEntityManager.this.fCurrentEntity.mayReadChunks ? this.fInputStream.available() : 0;
            }
            return n;
        }

        public void mark(int n) {
            this.fMark = this.fOffset;
        }

        public void reset() {
            this.fOffset = this.fMark;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() throws IOException {
            if (this.fInputStream != null) {
                this.fInputStream.close();
                this.fInputStream = null;
            }
        }
    }

    protected class EntityScanner
    extends XMLEntityScanner {
        public String getBaseSystemId() {
            return XMLEntityManager.this.fCurrentEntity != null && XMLEntityManager.this.fCurrentEntity.entityLocation != null ? XMLEntityManager.this.fCurrentEntity.entityLocation.getExpandedSystemId() : null;
        }

        public void setEncoding(String string) throws IOException {
            if (!(XMLEntityManager.this.fCurrentEntity.stream == null || XMLEntityManager.this.fCurrentEntity.encoding != null && XMLEntityManager.this.fCurrentEntity.encoding.equals(string))) {
                if (XMLEntityManager.this.fCurrentEntity.encoding != null && XMLEntityManager.this.fCurrentEntity.encoding.startsWith("UTF-16")) {
                    String string2 = string.toUpperCase();
                    if (string2.equals("UTF-16")) {
                        return;
                    }
                    if (string2.equals("ISO-10646-UCS-4")) {
                        XMLEntityManager.this.fCurrentEntity.reader = XMLEntityManager.this.fCurrentEntity.encoding.equals("UTF-16BE") ? new UCSReader(XMLEntityManager.this.fCurrentEntity.stream, UCSReader.UCS4BE) : new UCSReader(XMLEntityManager.this.fCurrentEntity.stream, UCSReader.UCS4LE);
                        return;
                    }
                    if (string2.equals("ISO-10646-UCS-2")) {
                        XMLEntityManager.this.fCurrentEntity.reader = XMLEntityManager.this.fCurrentEntity.encoding.equals("UTF-16BE") ? new UCSReader(XMLEntityManager.this.fCurrentEntity.stream, UCSReader.UCS2BE) : new UCSReader(XMLEntityManager.this.fCurrentEntity.stream, UCSReader.UCS2LE);
                        return;
                    }
                }
                XMLEntityManager.this.fCurrentEntity.reader = XMLEntityManager.this.createReader(XMLEntityManager.this.fCurrentEntity.stream, string, null);
            }
        }

        public boolean isExternal() {
            return XMLEntityManager.this.fCurrentEntity.isExternal();
        }

        public int peekChar() throws IOException {
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            int n = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position];
            if (XMLEntityManager.this.fCurrentEntity.isExternal()) {
                return n != 13 ? n : 10;
            }
            return n;
        }

        public int scanChar() throws IOException {
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            int n = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++];
            boolean bl = false;
            if (n == 10 || n == 13 && (bl = XMLEntityManager.this.fCurrentEntity.isExternal())) {
                ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                    XMLEntityManager.this.fCurrentEntity.ch[0] = (char)n;
                    this.load(1, false);
                }
                if (n == 13 && bl) {
                    if (XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++] != '\n') {
                        --XMLEntityManager.this.fCurrentEntity.position;
                    }
                    n = 10;
                }
            }
            ++XMLEntityManager.this.fCurrentEntity.columnNumber;
            return n;
        }

        public String scanNmtoken() throws IOException {
            Object object;
            int n;
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            int n2 = XMLEntityManager.this.fCurrentEntity.position;
            while (XMLChar.isName(XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position])) {
                if (++XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                n = XMLEntityManager.this.fCurrentEntity.position - n2;
                if (n == XMLEntityManager.this.fBufferSize) {
                    object = new char[XMLEntityManager.this.fBufferSize * 2];
                    System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, n2, object, 0, n);
                    XMLEntityManager.this.fCurrentEntity.ch = (char[])object;
                    XMLEntityManager.this.fBufferSize *= 2;
                } else {
                    System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, n2, XMLEntityManager.this.fCurrentEntity.ch, 0, n);
                }
                n2 = 0;
                if (this.load(n, false)) break;
            }
            n = XMLEntityManager.this.fCurrentEntity.position - n2;
            XMLEntityManager.this.fCurrentEntity.columnNumber += n;
            object = null;
            if (n > 0) {
                object = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, n2, n);
            }
            return object;
        }

        /*
         * Unable to fully structure code
         */
        public String scanName() throws IOException {
            block5: {
                if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                    this.load(0, true);
                }
                if (!XMLChar.isNameStart(XMLEntityManager.this.fCurrentEntity.ch[var1_1 = XMLEntityManager.this.fCurrentEntity.position++])) break block5;
                if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) ** GOTO lbl23
                XMLEntityManager.this.fCurrentEntity.ch[0] = XMLEntityManager.this.fCurrentEntity.ch[var1_1];
                var1_1 = 0;
                if (!this.load(1, false)) ** GOTO lbl23
                ++XMLEntityManager.this.fCurrentEntity.columnNumber;
                var2_2 = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, 0, 1);
                return var2_2;
lbl-1000:
                // 1 sources

                {
                    if (++XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                    var2_3 = XMLEntityManager.this.fCurrentEntity.position - var1_1;
                    if (var2_3 == XMLEntityManager.this.fBufferSize) {
                        var3_4 = new char[XMLEntityManager.this.fBufferSize * 2];
                        System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, var1_1, var3_4, 0, var2_3);
                        XMLEntityManager.this.fCurrentEntity.ch = (char[])var3_4;
                        XMLEntityManager.this.fBufferSize *= 2;
                    } else {
                        System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, var1_1, XMLEntityManager.this.fCurrentEntity.ch, 0, var2_3);
                    }
                    var1_1 = 0;
                    if (this.load(var2_3, false)) break;
lbl23:
                    // 4 sources

                    ** while (XMLChar.isName((int)XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position]))
                }
            }
            var2_3 = XMLEntityManager.this.fCurrentEntity.position - var1_1;
            XMLEntityManager.this.fCurrentEntity.columnNumber += var2_3;
            var3_4 = null;
            if (var2_3 > 0) {
                var3_4 = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, var1_1, var2_3);
            }
            return var3_4;
        }

        public boolean scanQName(QName qName) throws IOException {
            int n;
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            if (XMLChar.isNameStart(XMLEntityManager.this.fCurrentEntity.ch[n = XMLEntityManager.this.fCurrentEntity.position++])) {
                Object object;
                int n2;
                if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                    XMLEntityManager.this.fCurrentEntity.ch[0] = XMLEntityManager.this.fCurrentEntity.ch[n];
                    n = 0;
                    if (this.load(1, false)) {
                        ++XMLEntityManager.this.fCurrentEntity.columnNumber;
                        String string = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, 0, 1);
                        qName.setValues(null, string, string, null);
                        return true;
                    }
                }
                int n3 = -1;
                while (XMLChar.isName(XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position])) {
                    n2 = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position];
                    if (n2 == 58) {
                        if (n3 != -1) break;
                        n3 = XMLEntityManager.this.fCurrentEntity.position;
                    }
                    if (++XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                    int n4 = XMLEntityManager.this.fCurrentEntity.position - n;
                    if (n4 == XMLEntityManager.this.fBufferSize) {
                        object = new char[XMLEntityManager.this.fBufferSize * 2];
                        System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, n, object, 0, n4);
                        XMLEntityManager.this.fCurrentEntity.ch = (char[])object;
                        XMLEntityManager.this.fBufferSize *= 2;
                    } else {
                        System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, n, XMLEntityManager.this.fCurrentEntity.ch, 0, n4);
                    }
                    if (n3 != -1) {
                        n3 -= n;
                    }
                    n = 0;
                    if (this.load(n4, false)) break;
                }
                n2 = XMLEntityManager.this.fCurrentEntity.position - n;
                XMLEntityManager.this.fCurrentEntity.columnNumber += n2;
                if (n2 > 0) {
                    String string = null;
                    object = null;
                    String string2 = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, n, n2);
                    if (n3 != -1) {
                        int n5 = n3 - n;
                        string = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, n, n5);
                        int n6 = n2 - n5 - 1;
                        object = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, n3 + 1, n6);
                    } else {
                        object = string2;
                    }
                    qName.setValues(string, (String)object, string2, null);
                    return true;
                }
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        public int scanContent(XMLString var1_1) throws IOException {
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            } else if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count - 1) {
                XMLEntityManager.this.fCurrentEntity.ch[0] = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.count - 1];
                this.load(1, false);
                XMLEntityManager.this.fCurrentEntity.position = 0;
            }
            var2_2 = XMLEntityManager.this.fCurrentEntity.position;
            var3_3 = XMLEntityManager.this.fCurrentEntity.ch[var2_2];
            var4_4 = 0;
            var5_5 = XMLEntityManager.this.fCurrentEntity.isExternal();
            if (var3_3 != 10 && (var3_3 != 13 || !var5_5)) ** GOTO lbl54
            do {
                if ((var3_3 = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++]) == 13 && var5_5) {
                    ++var4_4;
                    ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                    XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                    if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                        var2_2 = 0;
                        XMLEntityManager.this.fCurrentEntity.position = var4_4;
                        if (this.load(var4_4, false)) break;
                    }
                    if (XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position] == '\n') {
                        ++XMLEntityManager.this.fCurrentEntity.position;
                        ++var2_2;
                        continue;
                    }
                    ++var4_4;
                    continue;
                }
                if (var3_3 == 10) {
                    ++var4_4;
                    ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                    XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                    if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                    var2_2 = 0;
                    XMLEntityManager.this.fCurrentEntity.position = var4_4;
                    if (!this.load(var4_4, false)) continue;
                    break;
                }
                --XMLEntityManager.this.fCurrentEntity.position;
                break;
            } while (XMLEntityManager.this.fCurrentEntity.position < XMLEntityManager.this.fCurrentEntity.count - 1);
            var6_6 = var2_2;
            while (var6_6 < XMLEntityManager.this.fCurrentEntity.position) {
                XMLEntityManager.this.fCurrentEntity.ch[var6_6] = 10;
                ++var6_6;
            }
            var7_7 = XMLEntityManager.this.fCurrentEntity.position - var2_2;
            if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count - 1) ** GOTO lbl54
            var1_1.setValues(XMLEntityManager.this.fCurrentEntity.ch, var2_2, var7_7);
            return -1;
lbl-1000:
            // 1 sources

            {
                if (XMLChar.isContent(var3_3 = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++])) continue;
                --XMLEntityManager.this.fCurrentEntity.position;
                break;
lbl54:
                // 3 sources

                ** while (XMLEntityManager.this.fCurrentEntity.position < XMLEntityManager.this.fCurrentEntity.count)
            }
lbl55:
            // 2 sources

            var6_6 = XMLEntityManager.this.fCurrentEntity.position - var2_2;
            XMLEntityManager.this.fCurrentEntity.columnNumber += var6_6 - var4_4;
            var1_1.setValues(XMLEntityManager.this.fCurrentEntity.ch, var2_2, var6_6);
            if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) {
                var3_3 = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position];
                if (var3_3 == 13 && var5_5) {
                    var3_3 = 10;
                }
            } else {
                var3_3 = -1;
            }
            return var3_3;
        }

        /*
         * Unable to fully structure code
         */
        public int scanLiteral(int var1_1, XMLString var2_2) throws IOException {
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            } else if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count - 1) {
                XMLEntityManager.this.fCurrentEntity.ch[0] = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.count - 1];
                this.load(1, false);
                XMLEntityManager.this.fCurrentEntity.position = 0;
            }
            var3_3 = XMLEntityManager.this.fCurrentEntity.position;
            var4_4 = XMLEntityManager.this.fCurrentEntity.ch[var3_3];
            var5_5 = 0;
            var6_6 = XMLEntityManager.this.fCurrentEntity.isExternal();
            if (var4_4 != 10 && (var4_4 != 13 || !var6_6)) ** GOTO lbl54
            do {
                if ((var4_4 = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++]) == 13 && var6_6) {
                    ++var5_5;
                    ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                    XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                    if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                        var3_3 = 0;
                        XMLEntityManager.this.fCurrentEntity.position = var5_5;
                        if (this.load(var5_5, false)) break;
                    }
                    if (XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position] == '\n') {
                        ++XMLEntityManager.this.fCurrentEntity.position;
                        ++var3_3;
                        continue;
                    }
                    ++var5_5;
                    continue;
                }
                if (var4_4 == 10) {
                    ++var5_5;
                    ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                    XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                    if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                    var3_3 = 0;
                    XMLEntityManager.this.fCurrentEntity.position = var5_5;
                    if (!this.load(var5_5, false)) continue;
                    break;
                }
                --XMLEntityManager.this.fCurrentEntity.position;
                break;
            } while (XMLEntityManager.this.fCurrentEntity.position < XMLEntityManager.this.fCurrentEntity.count - 1);
            var7_7 = var3_3;
            while (var7_7 < XMLEntityManager.this.fCurrentEntity.position) {
                XMLEntityManager.this.fCurrentEntity.ch[var7_7] = 10;
                ++var7_7;
            }
            var8_8 = XMLEntityManager.this.fCurrentEntity.position - var3_3;
            if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count - 1) ** GOTO lbl54
            var2_2.setValues(XMLEntityManager.this.fCurrentEntity.ch, var3_3, var8_8);
            return -1;
lbl-1000:
            // 1 sources

            {
                if (((var4_4 = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++]) != var1_1 || XMLEntityManager.this.fCurrentEntity.literal && !var6_6) && var4_4 != 37 && XMLChar.isContent(var4_4)) continue;
                --XMLEntityManager.this.fCurrentEntity.position;
                break;
lbl54:
                // 3 sources

                ** while (XMLEntityManager.this.fCurrentEntity.position < XMLEntityManager.this.fCurrentEntity.count)
            }
lbl55:
            // 2 sources

            var7_7 = XMLEntityManager.this.fCurrentEntity.position - var3_3;
            XMLEntityManager.this.fCurrentEntity.columnNumber += var7_7 - var5_5;
            var2_2.setValues(XMLEntityManager.this.fCurrentEntity.ch, var3_3, var7_7);
            if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) {
                var4_4 = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position];
                if (var4_4 == var1_1 && XMLEntityManager.this.fCurrentEntity.literal) {
                    var4_4 = -1;
                }
            } else {
                var4_4 = -1;
            }
            return var4_4;
        }

        public boolean scanData(String string, XMLString xMLString) throws IOException {
            int n;
            int n2;
            int n3 = string.length();
            char c = string.charAt(0);
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            } else if (XMLEntityManager.this.fCurrentEntity.position >= XMLEntityManager.this.fCurrentEntity.count - n3) {
                System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, XMLEntityManager.this.fCurrentEntity.position, XMLEntityManager.this.fCurrentEntity.ch, 0, XMLEntityManager.this.fCurrentEntity.count - XMLEntityManager.this.fCurrentEntity.position);
                this.load(XMLEntityManager.this.fCurrentEntity.count - XMLEntityManager.this.fCurrentEntity.position, false);
                XMLEntityManager.this.fCurrentEntity.position = 0;
            }
            int n4 = XMLEntityManager.this.fCurrentEntity.position;
            char c2 = XMLEntityManager.this.fCurrentEntity.ch[n4];
            int n5 = 0;
            boolean bl = XMLEntityManager.this.fCurrentEntity.isExternal();
            if (c2 == '\n' || c2 == '\r' && bl) {
                do {
                    if ((c2 = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++]) == '\r' && bl) {
                        ++n5;
                        ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                        XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                        if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                            n4 = 0;
                            XMLEntityManager.this.fCurrentEntity.position = n5;
                            if (this.load(n5, false)) break;
                        }
                        if (XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position] == '\n') {
                            ++XMLEntityManager.this.fCurrentEntity.position;
                            ++n4;
                            continue;
                        }
                        ++n5;
                        continue;
                    }
                    if (c2 == '\n') {
                        ++n5;
                        ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                        XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                        if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                        n4 = 0;
                        XMLEntityManager.this.fCurrentEntity.position = n5;
                        XMLEntityManager.this.fCurrentEntity.count = n5;
                        if (!this.load(n5, false)) continue;
                        break;
                    }
                    --XMLEntityManager.this.fCurrentEntity.position;
                    break;
                } while (XMLEntityManager.this.fCurrentEntity.position < XMLEntityManager.this.fCurrentEntity.count - 1);
                n2 = n4;
                while (n2 < XMLEntityManager.this.fCurrentEntity.position) {
                    XMLEntityManager.this.fCurrentEntity.ch[n2] = 10;
                    ++n2;
                }
                n = XMLEntityManager.this.fCurrentEntity.position - n4;
                if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count - 1) {
                    xMLString.setValues(XMLEntityManager.this.fCurrentEntity.ch, n4, n);
                    return true;
                }
            }
            n2 = 0;
            block2: while (XMLEntityManager.this.fCurrentEntity.position < XMLEntityManager.this.fCurrentEntity.count) {
                if ((c2 = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++]) == c) {
                    n = XMLEntityManager.this.fCurrentEntity.position - 1;
                    int n6 = 1;
                    while (n6 < n3) {
                        if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                            XMLEntityManager.this.fCurrentEntity.position -= n6;
                            break block2;
                        }
                        c2 = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++];
                        if (string.charAt(n6) != c2) {
                            --XMLEntityManager.this.fCurrentEntity.position;
                            break;
                        }
                        ++n6;
                    }
                    if (XMLEntityManager.this.fCurrentEntity.position != n + n3) continue;
                    n2 = 1;
                    break;
                }
                if (c2 == '\n' || bl && c2 == '\r') {
                    --XMLEntityManager.this.fCurrentEntity.position;
                    break;
                }
                if (!XMLChar.isInvalid(c2)) continue;
                --XMLEntityManager.this.fCurrentEntity.position;
                break;
            }
            n = XMLEntityManager.this.fCurrentEntity.position - n4;
            XMLEntityManager.this.fCurrentEntity.columnNumber += n - n5;
            if (n2 != 0) {
                n -= n3;
            }
            xMLString.setValues(XMLEntityManager.this.fCurrentEntity.ch, n4, n);
            return n2 == 0;
        }

        public boolean skipChar(int n) throws IOException {
            char c;
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            if ((c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position]) == n) {
                ++XMLEntityManager.this.fCurrentEntity.position;
                if (n == 10) {
                    ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                    XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                } else {
                    ++XMLEntityManager.this.fCurrentEntity.columnNumber;
                }
                return true;
            }
            if (n == 10 && c == '\r' && XMLEntityManager.this.fCurrentEntity.isExternal()) {
                if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                    XMLEntityManager.this.fCurrentEntity.ch[0] = c;
                    this.load(1, false);
                }
                ++XMLEntityManager.this.fCurrentEntity.position;
                if (XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position] == '\n') {
                    ++XMLEntityManager.this.fCurrentEntity.position;
                }
                ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                return true;
            }
            return false;
        }

        public boolean skipSpaces() throws IOException {
            char c;
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            if (XMLChar.isSpace(c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position])) {
                boolean bl = XMLEntityManager.this.fCurrentEntity.isExternal();
                do {
                    boolean bl2 = false;
                    if (c == '\n' || bl && c == '\r') {
                        ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                        XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                        if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count - 1) {
                            XMLEntityManager.this.fCurrentEntity.ch[0] = c;
                            bl2 = this.load(1, true);
                            if (!bl2) {
                                XMLEntityManager.this.fCurrentEntity.position = 0;
                            }
                        }
                        if (c == '\r' && bl && XMLEntityManager.this.fCurrentEntity.ch[++XMLEntityManager.this.fCurrentEntity.position] != '\n') {
                            --XMLEntityManager.this.fCurrentEntity.position;
                        }
                    } else {
                        ++XMLEntityManager.this.fCurrentEntity.columnNumber;
                    }
                    if (!bl2) {
                        ++XMLEntityManager.this.fCurrentEntity.position;
                    }
                    if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                    this.load(0, true);
                } while (XMLChar.isSpace(c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position]));
                return true;
            }
            return false;
        }

        public boolean skipString(String string) throws IOException {
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c;
                if ((c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++]) != string.charAt(n2)) {
                    XMLEntityManager.this.fCurrentEntity.position -= n2 + 1;
                    return false;
                }
                if (n2 < n - 1 && XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                    System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, XMLEntityManager.this.fCurrentEntity.count - n2 - 1, XMLEntityManager.this.fCurrentEntity.ch, 0, n2 + 1);
                    if (this.load(n2 + 1, false)) {
                        XMLEntityManager.this.fCurrentEntity.position -= n2 + 1;
                        return false;
                    }
                }
                ++n2;
            }
            XMLEntityManager.this.fCurrentEntity.columnNumber += n;
            return true;
        }

        public String getPublicId() {
            return XMLEntityManager.this.fCurrentEntity != null && XMLEntityManager.this.fCurrentEntity.entityLocation != null ? XMLEntityManager.this.fCurrentEntity.entityLocation.getPublicId() : null;
        }

        public String getExpandedSystemId() {
            if (XMLEntityManager.this.fCurrentEntity != null) {
                if (XMLEntityManager.this.fCurrentEntity.entityLocation != null && XMLEntityManager.this.fCurrentEntity.entityLocation.getExpandedSystemId() != null) {
                    return XMLEntityManager.this.fCurrentEntity.entityLocation.getExpandedSystemId();
                }
                int n = XMLEntityManager.this.fEntityStack.size();
                int n2 = n - 1;
                while (n2 >= 0) {
                    ScannedEntity scannedEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(n2);
                    if (scannedEntity.entityLocation != null && scannedEntity.entityLocation.getExpandedSystemId() != null) {
                        return scannedEntity.entityLocation.getExpandedSystemId();
                    }
                    --n2;
                }
            }
            return null;
        }

        public String getLiteralSystemId() {
            if (XMLEntityManager.this.fCurrentEntity != null) {
                if (XMLEntityManager.this.fCurrentEntity.entityLocation != null && XMLEntityManager.this.fCurrentEntity.entityLocation.getLiteralSystemId() != null) {
                    return XMLEntityManager.this.fCurrentEntity.entityLocation.getLiteralSystemId();
                }
                int n = XMLEntityManager.this.fEntityStack.size();
                int n2 = n - 1;
                while (n2 >= 0) {
                    ScannedEntity scannedEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(n2);
                    if (scannedEntity.entityLocation != null && scannedEntity.entityLocation.getLiteralSystemId() != null) {
                        return scannedEntity.entityLocation.getLiteralSystemId();
                    }
                    --n2;
                }
            }
            return null;
        }

        public int getLineNumber() {
            if (XMLEntityManager.this.fCurrentEntity != null) {
                if (XMLEntityManager.this.fCurrentEntity.isExternal()) {
                    return XMLEntityManager.this.fCurrentEntity.lineNumber;
                }
                int n = XMLEntityManager.this.fEntityStack.size();
                int n2 = n - 1;
                while (n2 > 0) {
                    ScannedEntity scannedEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(n2);
                    if (scannedEntity.isExternal()) {
                        return scannedEntity.lineNumber;
                    }
                    --n2;
                }
            }
            return -1;
        }

        public int getColumnNumber() {
            if (XMLEntityManager.this.fCurrentEntity != null) {
                if (XMLEntityManager.this.fCurrentEntity.isExternal()) {
                    return XMLEntityManager.this.fCurrentEntity.columnNumber;
                }
                int n = XMLEntityManager.this.fEntityStack.size();
                int n2 = n - 1;
                while (n2 > 0) {
                    ScannedEntity scannedEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(n2);
                    if (scannedEntity.isExternal()) {
                        return scannedEntity.columnNumber;
                    }
                    --n2;
                }
            }
            return -1;
        }

        private final boolean load(int n, boolean bl) throws IOException {
            int n2 = XMLEntityManager.this.fCurrentEntity.mayReadChunks ? XMLEntityManager.this.fCurrentEntity.ch.length - n : 64;
            int n3 = XMLEntityManager.this.fCurrentEntity.reader.read(XMLEntityManager.this.fCurrentEntity.ch, n, n2);
            boolean bl2 = false;
            if (n3 != -1) {
                if (n3 != 0) {
                    XMLEntityManager.this.fCurrentEntity.count = n3 + n;
                    XMLEntityManager.this.fCurrentEntity.position = n;
                }
            } else {
                XMLEntityManager.this.fCurrentEntity.count = n;
                XMLEntityManager.this.fCurrentEntity.position = n;
                bl2 = true;
                if (bl) {
                    XMLEntityManager.this.endEntity();
                    if (XMLEntityManager.this.fCurrentEntity == null) {
                        throw new EOFException();
                    }
                    if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                        this.load(0, true);
                    }
                }
            }
            return bl2;
        }
    }

    protected class ScannedEntity
    extends Entity {
        public InputStream stream;
        public Reader reader;
        public XMLResourceIdentifier entityLocation;
        public int lineNumber = 1;
        public int columnNumber = 1;
        public String encoding;
        public boolean literal;
        public boolean isExternal;
        public char[] ch;
        public int position;
        public int count;
        public boolean mayReadChunks;

        public ScannedEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, InputStream inputStream, Reader reader, String string2, boolean bl, boolean bl2, boolean bl3) {
            super(string);
            this.ch = new char[XMLEntityManager.this.fBufferSize];
            this.entityLocation = xMLResourceIdentifier;
            this.stream = inputStream;
            this.reader = reader;
            this.encoding = string2;
            this.literal = bl;
            this.mayReadChunks = bl2;
            this.isExternal = bl3;
        }

        public final boolean isExternal() {
            return this.isExternal;
        }

        public final boolean isUnparsed() {
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("name=\"" + this.name + '\"');
            stringBuffer.append(",ch=" + this.ch);
            stringBuffer.append(",position=" + this.position);
            stringBuffer.append(",count=" + this.count);
            return stringBuffer.toString();
        }
    }

    protected static class ExternalEntity
    extends Entity {
        public XMLResourceIdentifier entityLocation;
        public String notation;

        public ExternalEntity() {
            this.clear();
        }

        public ExternalEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2) {
            super(string);
            this.entityLocation = xMLResourceIdentifier;
            this.notation = string2;
        }

        public final boolean isExternal() {
            return true;
        }

        public final boolean isUnparsed() {
            return this.notation != null;
        }

        public void clear() {
            super.clear();
            this.entityLocation = null;
            this.notation = null;
        }

        public void setValues(Entity entity) {
            super.setValues(entity);
            this.entityLocation = null;
            this.notation = null;
        }

        public void setValues(ExternalEntity externalEntity) {
            super.setValues(externalEntity);
            this.entityLocation = externalEntity.entityLocation;
            this.notation = externalEntity.notation;
        }
    }

    protected static class InternalEntity
    extends Entity {
        public String text;

        public InternalEntity() {
            this.clear();
        }

        public InternalEntity(String string, String string2) {
            super(string);
            this.text = string2;
        }

        public final boolean isExternal() {
            return false;
        }

        public final boolean isUnparsed() {
            return false;
        }

        public void clear() {
            super.clear();
            this.text = null;
        }

        public void setValues(Entity entity) {
            super.setValues(entity);
            this.text = null;
        }

        public void setValues(InternalEntity internalEntity) {
            super.setValues(internalEntity);
            this.text = internalEntity.text;
        }
    }

    protected static abstract class Entity {
        public String name;

        public Entity() {
            this.clear();
        }

        public Entity(String string) {
            this.name = string;
        }

        public abstract boolean isExternal();

        public abstract boolean isUnparsed();

        public void clear() {
            this.name = null;
        }

        public void setValues(Entity entity) {
            this.name = entity.name;
        }
    }
}

