/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Hashtable;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMWriter;
import org.w3c.dom.ls.DOMWriterFilter;

public class DOMWriterImpl
implements DOMWriter {
    private String fEncoding;
    private XMLSerializer serializer = new XMLSerializer();

    public DOMWriterImpl(boolean bl) {
        this.serializer.fNamespaces = bl;
        this.serializer.fNSBinder = new NamespaceSupport();
        this.serializer.fLocalNSBinder = new NamespaceSupport();
        this.serializer.fSymbolTable = new SymbolTable();
        this.serializer.fFeatures = new Hashtable();
        this.serializer.fFeatures.put("normalize-characters", new Boolean(false));
        this.serializer.fFeatures.put("split-cdata-sections", new Boolean(true));
        this.serializer.fFeatures.put("validate", new Boolean(false));
        this.serializer.fFeatures.put("entities", new Boolean(false));
        this.serializer.fFeatures.put("whitespace-in-element-content", new Boolean(true));
        this.serializer.fFeatures.put("discard-default-content", new Boolean(true));
        this.serializer.fFeatures.put("canonical-form", new Boolean(false));
        this.serializer.fFeatures.put("format-pretty-print", new Boolean(false));
    }

    public void setFeature(String string, boolean bl) throws DOMException {
        if (string != null && this.serializer.fFeatures.containsKey(string)) {
            if (!this.canSetFeature(string, bl)) {
                throw new DOMException(9, "Feature " + string + " cannot be set as " + bl);
            }
        } else {
            throw new DOMException(8, "Feature " + string + " not found");
        }
        this.serializer.fFeatures.put(string, new Boolean(bl));
    }

    public boolean canSetFeature(String string, boolean bl) {
        if (string.equals("normalize-characters") && bl) {
            return false;
        }
        if (string.equals("validate") && bl) {
            return false;
        }
        if (string.equals("whitespace-in-element-content") && !bl) {
            return false;
        }
        if (string.equals("canonical-form") && bl) {
            return false;
        }
        return !string.equals("format-pretty-print") || !bl;
    }

    public boolean getFeature(String string) throws DOMException {
        Boolean bl = (Boolean)this.serializer.fFeatures.get(string);
        if (bl == null) {
            throw new DOMException(8, "Feature " + string + " not found");
        }
        return bl;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String string) {
        this.serializer._format.setEncoding(string);
        this.fEncoding = this.serializer._format.getEncoding();
    }

    public DOMErrorHandler getErrorHandler() {
        return this.serializer.fDOMErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        this.serializer.fDOMErrorHandler = dOMErrorHandler;
    }

    public boolean writeNode(OutputStream outputStream, Node node) {
        block6: {
            this.checkAllFeatures();
            try {
                this.reset();
                this.serializer.setOutputByteStream(outputStream);
                if (node == null) {
                    return false;
                }
                if (node.getNodeType() == 9) {
                    this.serializer.serialize((Document)node);
                    break block6;
                }
                if (node.getNodeType() == 11) {
                    this.serializer.serialize((DocumentFragment)node);
                    break block6;
                }
                if (node.getNodeType() == 1) {
                    this.serializer.serialize((Element)node);
                    break block6;
                }
                return false;
            }
            catch (Exception exception) {
                if (this.serializer.fDOMErrorHandler == null) break block6;
                DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                dOMErrorImpl.fException = exception;
                dOMErrorImpl.fMessage = exception.getMessage();
                dOMErrorImpl.fSeverity = 1;
                this.serializer.fDOMErrorHandler.handleError(dOMErrorImpl);
            }
        }
        return true;
    }

    public String writeToString(Node node) throws DOMException {
        StringWriter stringWriter;
        block6: {
            this.checkAllFeatures();
            stringWriter = new StringWriter();
            try {
                this.reset();
                this.serializer.setOutputCharStream(stringWriter);
                if (node == null) {
                    return null;
                }
                if (node.getNodeType() == 9) {
                    this.serializer.serialize((Document)node);
                    break block6;
                }
                if (node.getNodeType() == 11) {
                    this.serializer.serialize((DocumentFragment)node);
                    break block6;
                }
                if (node.getNodeType() == 1) {
                    this.serializer.serialize((Element)node);
                    break block6;
                }
                return null;
            }
            catch (IOException iOException) {
                throw new DOMException(2, "The resulting string is too long to fit in a DOMString: " + iOException.getMessage());
            }
        }
        return stringWriter.toString();
    }

    public void setNewLine(String string) {
        this.serializer._format.setLineSeparator(string);
    }

    public String getNewLine() {
        return this.serializer._format.getLineSeparator();
    }

    public DOMWriterFilter getFilter() {
        return null;
    }

    public void setFilter(DOMWriterFilter dOMWriterFilter) {
        this.serializer.fDOMFilter = dOMWriterFilter;
    }

    private boolean reset() {
        this.serializer.reset();
        this.serializer.fNSBinder.reset();
        this.serializer.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        this.serializer.fNamespaceCounter = 1;
        return true;
    }

    private void checkAllFeatures() {
        if (this.getFeature("whitespace-in-element-content")) {
            this.serializer._format.setPreserveSpace(true);
        } else {
            this.serializer._format.setPreserveSpace(false);
        }
    }
}

