# The test file is invoked from rpl.rpl_multi_source_timestamps.test
# and group_replication.gr_replication_timestamps
#
# This file has two main sections:
#   1) Retrieve the OCT and ICT from each server
#   2) Verify that the timestamps are correct
#
# param $gtid - the gtid of the transaction to be checked
# param $master - the master server.
# param $slave  - the slave server.
# param $check_master_OCT - if 1, then the test checks if the OCT == ICT in the
#                           master. Not applicable when a transaction was
#                           originated by a group member.
#                           if 0, the test asserts that the OCT and ICT were
#                           correctly generated by the group member.
# param $check_master_slave_ICT - if 1, then the test checks if the ICT
#                                 increases from master to slave. Not applicable
#                                 between group members.
#                                 if 0, the test asserts that the group member
#                                 replicating the transaction correctly
#                                 generated the ICT.

--echo # 1. Save both timestamps (original/immediate) on all servers.

# Switch to master, save both OCT and ICT.
--let $rpl_connection_name= $master
--source include/rpl_connection.inc

--source include/get_original_commit_timestamp.inc
--let $master_OCT= $original_commit_timestamp

--source include/get_immediate_commit_timestamp.inc
--let $master_ICT= $immediate_commit_timestamp

# Switch to slave, save both OCT and ICT.
--let $rpl_connection_name= $slave
--source include/rpl_connection.inc

--source include/get_original_commit_timestamp.inc
--let $slave_OCT= $original_commit_timestamp

--source include/get_immediate_commit_timestamp.inc
--let $slave_ICT= $immediate_commit_timestamp


--echo # 2. Verify that the timestamps are correct.

--let $assert_text= Assert that the OCT is the same on $master and $slave.
--let $assert_cond= $master_OCT = $slave_OCT
--source include/assert.inc

# Check if the platform is windows to select the appropriate assert condition
--let $is_windows= 0
if (`SELECT CONVERT(@@VERSION_COMPILE_OS USING latin1) IN ('Win32', 'Win64', 'Windows')`)
{
  --let $is_windows= 1
}

if ($check_master_OCT==1)
{
  --let $assert_text= Assert that OCT is the same as ICT on $master
  --let $assert_cond= $master_OCT = $master_ICT
  --source include/assert.inc
}
if ($check_master_OCT==0)
{
  # GR topology, so we check if the OCT and ICT were correctly generated
  # In this case, the OCT is not the same as the ICT of the original master, as
  # the former is generated before transaction certification.
  --let $assert_text= Assert that OCT is smaller than ICT on $master
  if ($is_windows)
  {
    # Due to windows lower resolution timestamps, it may happen that master_OCT
    # is equal to master_ICT
    --let $assert_cond= $master_OCT <= $master_ICT
  }
  if (!$is_windows)
  {
    --let $assert_cond= $master_OCT < $master_ICT
  }
  --source include/assert.inc
}

# This test is not applicable in a GR topology, so it can be skipped in that case
if ($check_master_slave_ICT==1)
{
  --let $assert_text= Assert that ICT increases from $master to $slave
  if ($is_windows)
  {
    # Due to windows lower resolution timestamps, it may happen that master_ICT
    # is equal to slave_ICT
    --let $assert_cond= $slave_ICT >= $master_ICT
  }
  if (!$is_windows)
  {
    --let $assert_cond= $slave_ICT > $master_ICT
  }
  --source include/assert.inc
}
if ($check_master_slave_ICT==0)
{
  # GR topology, so we check if the ICT was correctly generated for a member
  # replicating the transaction
  --let $assert_text= Assert that OCT is smaller than ICT on $slave
  if ($is_windows)
  {
    # Due to windows lower resolution timestamps, it may happen that slave_OCT
    # is equal to slave_ICT
    --let $assert_cond= $slave_OCT <= $slave_ICT
  }
  if (!$is_windows)
  {
    --let $assert_cond= $slave_OCT < $slave_ICT
  }
  --source include/assert.inc
}
