#######################################################
# 
# DataPrinter.py
# Python implementation of the Class DataPrinter
# Generated by Enterprise Architect
# Created on:      14-Aug-2019 10:12:04 AM
# Original author: talve
# 
#######################################################


class DataPrinter:
    """this class is responsible for print the given segments to the right output.
    """
    NUM_OF_DW_IN_ROW = 4

    @classmethod
    def print_query_data(cls, data):
        """this method print the user menu from the menu segment data
        """
        if data:
            for record in data.get_printable_records():
                for el in record:
                    print(el)

    @classmethod
    def print_dump_data(cls, data, file):
        """the method gets a list of segments and arguments if print to bin file or output
        to screen.
        """
        if data:
            if file:
                DataPrinter._write_to_file(data, file)
            else:
                print("Found {0} segments:".format(len(data)))
                for seg in data:
                    rows = 0
                    print("-" * 43)
                    print("Segment Type: {}".format(seg.get_type()))
                    print("Segment Size: {} Bytes".format(len(seg.get_data())*4))
                    print("Segment Data:")
                    for dw in seg.get_data():
                        print('0x{0:0{1}X} '.format(dw, 8), end="")
                        rows += 1
                        if rows == DataPrinter.NUM_OF_DW_IN_ROW:
                            print("")
                            rows = 0
                    if 0 < rows < DataPrinter.NUM_OF_DW_IN_ROW:
                        print("")
                print("-" * 43)

    @classmethod
    def _write_to_file(cls, data, path):
        with open(path, "wb") as binary_file:
            for seg in data:
                for dw in seg.get_data():
                    four_bytes = dw.to_bytes(4, byteorder='big', signed=False)
                    binary_file.write(four_bytes)

        print("write to file: ", path)


