.\" $XConsortium: texteditor.man /main/4 1995/07/17 10:48:58 drk $
.\" Motif
.\"
.\" Copyright (c) 1987-2012, The Open Group. All rights reserved.
.\"
.\" These libraries and programs are free software; you can
.\" redistribute them and/or modify them under the terms of the GNU
.\" Lesser General Public License as published by the Free Software
.\" Foundation; either version 2 of the License, or (at your option)
.\" any later version.
.\"
.\" These libraries and programs are distributed in the hope that
.\" they will be useful, but WITHOUT ANY WARRANTY; without even the
.\" implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
.\" PURPOSE. See the GNU Lesser General Public License for more
.\" details.
.\"
.\" You should have received a copy of the GNU Lesser General Public
.\" License along with these librararies and programs; if not, write
.\" to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
.\" Floor, Boston, MA 02110-1301 USA
...\" 
...\" 
...\" HISTORY
...\" "
.TH texteditor 1X MOTIF "Demonstration programs"
.SH NAME
\*Ltexteditor\*O\(emedit text with multiple views and renditions.
.SH SYNOPSIS
.sS
\*Ltexteditor\*O
.sE
.SH DESCRIPTION
\*Ltexteditor\*O 
is a primitive text editor, based on Motif's XmCSText
widget.  In addition to standard text editing features, it supports
multiple views of the same underlying text, modification of the rendition
attributes of individual pieces of text, and the reading and writing of
multiple file formats.
.SH USAGE
This section describes how to use the menus and dialog boxes.
.SH "File Menu"
This is a completely standard File menu.  The only important note is that
the Print... command only supports text-only printing.
.SH "Edit Menu"
This is a completely standard Edit menu.
.SH "View Menu"
The View menu controls the views of the text.  It includes:
.IP "\fBSplit Pane\fP"
to add a new independently scrollable view of the text
.IP "\fBRemove Pane\fP"
to remove a designated pane
.IP "\fBOne Pane\fP"
to remove all panes except the designated pane
.PP
The designated pane is determined in the following way.  Using an explicit
focus policy, it is the last view which had focus.  Using a pointer focus
policy, it is the last view which the user interacted with.
.SH "Options Menu"
.IP "\fBKeep File Dialog Open\fP"
If this option is selected, the file selection dialog will remain open
after an operation is completed.
.IP "\fBRevert Dialog to Open\fP"
If this option is selected, the file selection dialog's operation will
automatically be reset to \fBOpen\fP after an operation is completed.
.SH "Renditions Menu"
This menu provides commands to change the appearance of selected text.  
.SH "Help Menu"
This is a completely standard Help menu.
.SH "FileSelectionBox"
The FileSelectionBox that is displayed when the \fBOpen...\fP, \fBSave\fP,
or \fBSave As...\fP commands are chosen is standard with the following additions.
The \fBFormat\fP menu allows text to be read or written in the following
formats:
.IP "\fBText Only\fP"
Reads in the file as straight ASCII text.  Writes only the text portion of
a file.  All rendition information is lost.
.IP "\fBByte Stream\fP"
Reads and writes files in Compound String Byte Stream format.  This
preserves all rendition information.  See 
.IR XmCvtXmStringToByteStream(3X)
and
.IR XmCvtByteStreamToXmString(3X).
.IP "\fBXmdHelp Markup\fP"
Reads and writes files in using the XmdHelp Markup language.  This is a
simple quasi-SGML used by the Xmd Help widget.  See the onHelp application
in demos/lib/Xmd for more information.
.PP
The radio box immediately below the \fBFormat\fP menu allows interactively
switching the operation to be performed between \fBOpen\fP, \fBSave\fP,
\fBCopy\fP, and \fBMove\fP.
.SH "X Defaults"
The class of the application is \fIXmdTextEditor\fP.  The widget of primary
interest is the XmCSText widget.
.PP
In particular, users familiar with emacs may want to add the following translations
to their .Xdefaults files:

.nf
.ta .25i 2i
*XmCSText.translations: #override\\n\\
    Mod1<Btn3Down>:	scroll-cursor-vertically()\\n\\
  Mod1<Btn3Motion>:	scroll-cursor-vertically()\\n\\
	Ctrl<Key>a:	beginning-of-line()\\n\\
	Ctrl<Key>b:	backward-character()\\n\\
	Ctrl<Key>d:	delete-next-character()\\n\\
	Ctrl<Key>e:	end-of-line()\\n\\
	Ctrl<Key>f:	forward-character()\\n\\
	Ctrl<Key>g:	beep()\\n\\
	Ctrl<Key>h:	delete-previous-character()\\n\\
	Ctrl<Key>i:	cut-primary()\\n\\
	Ctrl<Key>j:	newline-and-indent()\\n\\
	Ctrl<Key>k:	set-anchor() end-of-line() key-select() cut-clipboard()\\n\\
	Ctrl<Key>l:	redraw-display()\\n\\
	Ctrl<Key>m:	newline()\\n\\
	Ctrl<Key>n:	next-line()\\n\\
	Ctrl<Key>o:	newline-and-backup()\\n\\
	Ctrl<Key>p:	previous-line()\\n\\
	Ctrl<Key>v:	next-page()\\n\\
	Ctrl<Key>w:	cut-clipboard()\\n\\
	Ctrl<Key>y:	paste-clipboard()\\n\\
	Ctrl<Key>z:	scroll-one-line-up()\\n\\
	Mod1<Key>b:	backward-word()\\n\\
	Mod1<Key>d:	delete-next-word()\\n\\
	Mod1<Key>f:	forward-word()\\n\\
	Mod1<Key>h:	delete-previous-word()\\n\\
	Mod1<Key>i:	copy-primary()\\n\\
	Mod1<Key>k:	delete-to-end-of-line()\\n\\
	Mod1<Key>v:	previous-page()\\n\\
	Mod1<Key>w:	copy-clipboard()\\n\\
	Mod1<Key>z:	scroll-one-line-down()\\n\\
	Mod1 Shift<Key>greater:	end-of-file()\\n\\
	Mod1<Key>less:	beginning-of-file()\\n\\
	Mod1<Key>]:	forward-paragraph()\\n\\
	Mod1<Key>[:	backward-paragraph()
.fi

.SH FILES
.IP ./demo1.txt
A Text Only format file.
.IP ./demo1.bts
A Byte Stream format file.  Contains the text in demo1.txt with additional
renditions.
.IP ./demo1.help
An XmdHelp Markup format file.  Produces the same output as demo1.bts.

.SH BUGS
Moving and removing files are not currently implemented.  The following
menu items are not implemented:  \fBPrint\fP, \fBPrint Setup...\fP, \fBClose\fP, \fBUndo\fP, \fBRepeat\fP,
\fBSelect All\fP, \fBDeselect All\fP, and all the \fBHelp\fP menu items.  Changing the
rendition of text contained within another rendition change can sometimes
cause renditions to "bleed" into the following text.  Changing the rendition
of a line selected by a triple-click will cause all lines until the next
rendition change to also get the selected rendition.  WYSIWYG editing and
saving of XmdHelp Markup format is not supported.  The selection of
renditions is limited.
