/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.KerberosName;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public class TokenCache {
    private static final Log LOG = LogFactory.getLog(TokenCache.class);
    public static final String JOB_TOKEN_HDFS_FILE = "jobToken";
    public static final String JOB_TOKENS_FILENAME = "mapreduce.job.jobTokenFile";
    private static final Text JOB_TOKEN = new Text("ShuffleAndJobToken");

    public static byte[] getSecretKey(Credentials credentials, Text alias) {
        if (credentials == null) {
            return null;
        }
        return credentials.getSecretKey(alias);
    }

    public static void obtainTokensForNamenodes(Credentials credentials, Path[] ps, Configuration conf) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        TokenCache.obtainTokensForNamenodesInternal(credentials, ps, conf);
    }

    static void obtainTokensForNamenodesInternal(Credentials credentials, Path[] ps, Configuration conf) throws IOException {
        KerberosName jtKrbName = new KerberosName(conf.get("mapreduce.jobtracker.kerberos.principal", ""));
        String delegTokenRenewer = jtKrbName.getShortName();
        boolean readFile = true;
        for (Path p : ps) {
            Token<?> token;
            FileSystem fs = FileSystem.get(p.toUri(), conf);
            String fsName = fs.getCanonicalServiceName();
            if (fsName == null || TokenCache.getDelegationToken(credentials, fsName) != null) continue;
            if (readFile) {
                readFile = false;
                String binaryTokenFilename = conf.get("mapreduce.job.credentials.binary");
                if (binaryTokenFilename != null) {
                    Credentials binary;
                    try {
                        binary = Credentials.readTokenStorageFile(new Path("file:///" + binaryTokenFilename), conf);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    credentials.addAll(binary);
                }
                if (TokenCache.getDelegationToken(credentials, fsName) != null) {
                    LOG.debug((Object)("DT for " + fsName + " is already present"));
                    continue;
                }
            }
            if ((token = fs.getDelegationToken(delegTokenRenewer)) == null) continue;
            Text fsNameText = new Text(fsName);
            credentials.addToken(fsNameText, token);
            LOG.info((Object)("Got dt for " + p + ";uri=" + fsName + ";t.service=" + token.getService()));
        }
    }

    public static Token<DelegationTokenIdentifier> getDelegationToken(Credentials credentials, String namenode) {
        return credentials.getToken(new Text(namenode));
    }

    public static Credentials loadTokens(String jobTokenFile, Configuration conf) throws IOException {
        Path localJobTokenFile = new Path("file:///" + jobTokenFile);
        Credentials ts = Credentials.readTokenStorageFile(localJobTokenFile, conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Task: Loaded jobTokenFile from: " + localJobTokenFile.toUri().getPath() + "; num of sec keys  = " + ts.numberOfSecretKeys() + " Number of tokens " + ts.numberOfTokens()));
        }
        return ts;
    }

    public static void setJobToken(Token<? extends TokenIdentifier> t, Credentials credentials) {
        credentials.addToken(JOB_TOKEN, t);
    }

    public static Token<JobTokenIdentifier> getJobToken(Credentials credentials) {
        return credentials.getToken(JOB_TOKEN);
    }
}

