/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.lib.MetricMutable;
import org.apache.hadoop.metrics2.lib.MetricMutableCounter;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterInt;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableFactory;
import org.apache.hadoop.metrics2.lib.MetricMutableGauge;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MetricMutableStat;

public class MetricsRegistry {
    public static final String CONTEXT_KEY = "context";
    public static final String CONTEXT_DESC = "Metrics context";
    private final LinkedHashMap<String, MetricMutable> metricsMap = new LinkedHashMap();
    private final LinkedHashMap<String, MetricsTag> tagsMap = new LinkedHashMap();
    private final String name;
    private final MetricMutableFactory mf;

    public MetricsRegistry(String name) {
        this.name = name;
        this.mf = new MetricMutableFactory();
    }

    public MetricsRegistry(String name, MetricMutableFactory factory) {
        this.name = name;
        this.mf = factory;
    }

    public String name() {
        return this.name;
    }

    public MetricMutable get(String name) {
        return this.metricsMap.get(name);
    }

    public MetricMutableCounterInt newCounter(String name, String description, int initValue) {
        this.checkMetricName(name);
        MetricMutableCounterInt ret = this.mf.newCounter(name, description, initValue);
        this.metricsMap.put(name, ret);
        return ret;
    }

    public MetricMutableCounterLong newCounter(String name, String description, long initValue) {
        this.checkMetricName(name);
        MetricMutableCounterLong ret = this.mf.newCounter(name, description, initValue);
        this.metricsMap.put(name, ret);
        return ret;
    }

    public MetricMutableGaugeInt newGauge(String name, String description, int initValue) {
        this.checkMetricName(name);
        MetricMutableGaugeInt ret = this.mf.newGauge(name, description, initValue);
        this.metricsMap.put(name, ret);
        return ret;
    }

    public MetricMutableGaugeLong newGauge(String name, String description, long initValue) {
        this.checkMetricName(name);
        MetricMutableGaugeLong ret = this.mf.newGauge(name, description, initValue);
        this.metricsMap.put(name, ret);
        return ret;
    }

    public MetricMutableStat newStat(String name, String description, String sampleName, String valueName, boolean extended) {
        this.checkMetricName(name);
        MetricMutableStat ret = this.mf.newStat(name, description, sampleName, valueName, extended);
        this.metricsMap.put(name, ret);
        return ret;
    }

    public MetricMutableStat newStat(String name, String description, String sampleName, String valueName) {
        return this.newStat(name, description, sampleName, valueName, false);
    }

    public MetricMutableStat newStat(String name) {
        return this.newStat(name, "", "ops", "time", false);
    }

    public void incr(String name) {
        this.incr(name, this.mf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void incr(String name, MetricMutableFactory factory) {
        MetricMutable m = this.metricsMap.get(name);
        if (m != null) {
            if (m instanceof MetricMutableGauge) {
                ((MetricMutableGauge)m).incr();
                return;
            } else {
                if (!(m instanceof MetricMutableCounter)) throw new MetricsException("Unsupported incr() for metric " + name);
                ((MetricMutableCounter)m).incr();
            }
            return;
        } else {
            if (factory == null) throw new MetricsException("Metric " + name + " doesn't exist");
            this.metricsMap.put(name, factory.newMetric(name));
            this.incr(name, null);
        }
    }

    public void decr(String name) {
        this.decr(name, this.mf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decr(String name, MetricMutableFactory factory) {
        MetricMutable m = this.metricsMap.get(name);
        if (m != null) {
            if (!(m instanceof MetricMutableGauge)) throw new MetricsException("Unsupported decr() for metric " + name);
            ((MetricMutableGauge)m).decr();
            return;
        } else {
            if (factory == null) throw new MetricsException("Metric " + name + " doesn't exist");
            this.metricsMap.put(name, factory.newMetric(name));
            this.decr(name, null);
        }
    }

    public void add(String name, long value) {
        this.add(name, value, this.mf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(String name, long value, MetricMutableFactory factory) {
        MetricMutable m = this.metricsMap.get(name);
        if (m != null) {
            if (!(m instanceof MetricMutableStat)) throw new MetricsException("Unsupported add(value) for metric " + name);
            ((MetricMutableStat)m).add(value);
            return;
        } else {
            if (factory == null) throw new MetricsException("Metric " + name + " doesn't exist");
            this.metricsMap.put(name, factory.newStat(name));
            this.add(name, value, null);
        }
    }

    public MetricsRegistry setContext(String name) {
        return this.tag(CONTEXT_KEY, CONTEXT_DESC, name);
    }

    public MetricsRegistry tag(String name, String description, String value) {
        return this.tag(name, description, value, false);
    }

    public MetricsRegistry tag(String name, String description, String value, boolean override) {
        if (!override) {
            this.checkTagName(name);
        }
        this.tagsMap.put(name, new MetricsTag(name, description, value));
        return this;
    }

    public Set<Map.Entry<String, MetricsTag>> tags() {
        return this.tagsMap.entrySet();
    }

    public Set<Map.Entry<String, MetricMutable>> metrics() {
        return this.metricsMap.entrySet();
    }

    private void checkMetricName(String name) {
        if (this.metricsMap.containsKey(name)) {
            throw new MetricsException("Metric name " + name + " already exists!");
        }
    }

    private void checkTagName(String name) {
        if (this.tagsMap.containsKey(name)) {
            throw new MetricsException("Tag " + name + " already exists!");
        }
    }

    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        for (Map.Entry<String, MetricsTag> entry : this.tags()) {
            builder.add(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.metrics()) {
            ((MetricMutable)entry.getValue()).snapshot(builder, all);
        }
    }
}

