/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.util.Contracts;

public class MetricsRecordImpl
implements MetricsRecord {
    protected static final String CONTEXT_KEY = "context";
    protected static final String DEFAULT_CONTEXT = "default";
    private final long timestamp;
    private final String name;
    private final Iterable<MetricsTag> tags;
    private final Iterable<Metric> metrics;

    public MetricsRecordImpl(String name, long timestamp, Iterable<MetricsTag> tags, Iterable<Metric> metrics) {
        this.timestamp = Contracts.checkArg(timestamp, timestamp > 0L, (Object)"timestamp");
        this.name = Contracts.checkNotNull(name, "name");
        this.tags = Contracts.checkNotNull(tags, "tags");
        this.metrics = Contracts.checkNotNull(metrics, "metrics");
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String context() {
        for (MetricsTag t : this.tags) {
            if (!t.name().equals(CONTEXT_KEY)) continue;
            return String.valueOf(t.value());
        }
        return DEFAULT_CONTEXT;
    }

    @Override
    public Iterable<MetricsTag> tags() {
        return this.tags;
    }

    @Override
    public Iterable<Metric> metrics() {
        return this.metrics;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricsRecordImpl other = (MetricsRecordImpl)obj;
        if (this.timestamp != other.timestamp()) {
            return false;
        }
        if (!this.name.equals(other.name())) {
            return false;
        }
        if (!this.tags.equals(other.tags())) {
            return false;
        }
        return this.metrics.equals(other.metrics());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "MetricsRecordImpl{timestamp=" + this.timestamp + " name='" + this.name + "' tags=" + this.tags + " metrics=" + this.metrics + "}\n";
    }
}

