/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MetricCounterInt;
import org.apache.hadoop.metrics2.impl.MetricCounterLong;
import org.apache.hadoop.metrics2.impl.MetricGaugeDouble;
import org.apache.hadoop.metrics2.impl.MetricGaugeFloat;
import org.apache.hadoop.metrics2.impl.MetricGaugeInt;
import org.apache.hadoop.metrics2.impl.MetricGaugeLong;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;

class MetricsRecordBuilderImpl
extends MetricsRecordBuilder {
    private final long timestamp = System.currentTimeMillis();
    private final String name;
    private final List<Metric> metrics;
    private final List<MetricsTag> tags;
    private final MetricsFilter recordFilter;
    private final MetricsFilter metricFilter;
    private final boolean acceptable;

    MetricsRecordBuilderImpl(String name, MetricsFilter rf, MetricsFilter mf, boolean acceptable) {
        this.name = name;
        this.metrics = new ArrayList<Metric>();
        this.tags = new ArrayList<MetricsTag>();
        this.recordFilter = rf;
        this.metricFilter = mf;
        this.acceptable = acceptable;
    }

    @Override
    public MetricsRecordBuilder tag(String name, String description, String value) {
        if (this.acceptable) {
            this.tags.add(new MetricsTag(name, description, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilder addCounter(String name, String description, int value) {
        if (this.acceptable && (this.metricFilter == null || this.metricFilter.accepts(name))) {
            this.metrics.add(new MetricCounterInt(name, description, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilder addCounter(String name, String description, long value) {
        if (this.acceptable && (this.metricFilter == null || this.metricFilter.accepts(name))) {
            this.metrics.add(new MetricCounterLong(name, description, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilder addGauge(String name, String description, int value) {
        if (this.acceptable && (this.metricFilter == null || this.metricFilter.accepts(name))) {
            this.metrics.add(new MetricGaugeInt(name, description, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilder addGauge(String name, String description, long value) {
        if (this.acceptable && (this.metricFilter == null || this.metricFilter.accepts(name))) {
            this.metrics.add(new MetricGaugeLong(name, description, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilder addGauge(String name, String description, float value) {
        if (this.acceptable && (this.metricFilter == null || this.metricFilter.accepts(name))) {
            this.metrics.add(new MetricGaugeFloat(name, description, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilder addGauge(String name, String description, double value) {
        if (this.acceptable && (this.metricFilter == null || this.metricFilter.accepts(name))) {
            this.metrics.add(new MetricGaugeDouble(name, description, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilder add(MetricsTag tag) {
        this.tags.add(tag);
        return this;
    }

    @Override
    public MetricsRecordBuilder add(Metric metric) {
        this.metrics.add(metric);
        return this;
    }

    @Override
    public MetricsRecordBuilder setContext(String value) {
        return this.tag("context", "Metrics context", value);
    }

    public MetricsRecordImpl getRecord() {
        if (this.acceptable && (this.recordFilter == null || this.recordFilter.accepts(this.tags))) {
            return new MetricsRecordImpl(this.name, this.timestamp, this.tags(), this.metrics());
        }
        return null;
    }

    List<MetricsTag> tags() {
        return Collections.unmodifiableList(this.tags);
    }

    List<Metric> metrics() {
        return Collections.unmodifiableList(this.metrics);
    }
}

