/* @(#)statistics.h

   Copyright 2006 Jean Lorchat

Author: lorchat@sfc.wide.ad.jp

Created : 21 Aug 2006

*/

#ifndef __STATISTICS_H__
#define __STATISTICS_H__

#include <pthread.h>

#define MIPL_STATISTICS_IN_MH		0
#define MIPL_STATISTICS_IN_HOTI		1
#define MIPL_STATISTICS_IN_COTI		2
#define MIPL_STATISTICS_IN_HOT		3
#define MIPL_STATISTICS_IN_COT		4
#define MIPL_STATISTICS_IN_BU		5
#define MIPL_STATISTICS_IN_BA		6
#define MIPL_STATISTICS_IN_BRR		7
#define MIPL_STATISTICS_IN_BE		8
#define MIPL_STATISTICS_IN_DHAAD_REQ	9
#define MIPL_STATISTICS_IN_DHAAD_REP	10
#define MIPL_STATISTICS_IN_HAO		11
#define MIPL_STATISTICS_IN_X_HAO	12
#define MIPL_STATISTICS_IN_RH2		13
#define MIPL_STATISTICS_IN_RTUN		14
#define MIPL_STATISTICS_IN_X_MH_CHK	15
#define MIPL_STATISTICS_IN_X_PAYLOAD	16
#define MIPL_STATISTICS_IN_UNKNOWN_MH	17
#define MIPL_STATISTICS_IN_NOT_HOA	18
#define MIPL_STATISTICS_IN_NO_BU	19
#define MIPL_STATISTICS_IN_X_H_COOKIE	20
#define MIPL_STATISTICS_IN_X_C_COOKIE	21
#define MIPL_STATISTICS_IN_UNSAFEBU	22
#define MIPL_STATISTICS_IN_X_BU_HAO	23
#define MIPL_STATISTICS_IN_RR_FAIL	24
#define MIPL_STATISTICS_IN_X_SEQ	25
#define MIPL_STATISTICS_IN_X_HAO_PARAM	26
#define MIPL_STATISTICS_IN_X_MH_PARAM	27
#define MIPL_STATISTICS_IN_X_COA	28
#define MIPL_STATISTICS_IN_X_MOBOPT	29

#define MIPL_STATISTICS_IN_END		64


#define MIPL_STATISTICS_OUT_MH		MIPL_STATISTICS_IN_END
#define MIPL_STATISTICS_OUT_HOTI	MIPL_STATISTICS_IN_END + 1
#define MIPL_STATISTICS_OUT_COTI	MIPL_STATISTICS_IN_END + 2
#define MIPL_STATISTICS_OUT_HOT		MIPL_STATISTICS_IN_END + 3
#define MIPL_STATISTICS_OUT_COT		MIPL_STATISTICS_IN_END + 4
#define MIPL_STATISTICS_OUT_BU		MIPL_STATISTICS_IN_END + 5
#define MIPL_STATISTICS_OUT_BA		MIPL_STATISTICS_IN_END + 6
#define MIPL_STATISTICS_OUT_BRR		MIPL_STATISTICS_IN_END + 7
#define MIPL_STATISTICS_OUT_BE		MIPL_STATISTICS_IN_END + 8
#define MIPL_STATISTICS_OUT_DHAAD_REQ	MIPL_STATISTICS_IN_END + 9
#define MIPL_STATISTICS_OUT_DHAAD_REP	MIPL_STATISTICS_IN_END + 10
#define MIPL_STATISTICS_OUT_MPA		MIPL_STATISTICS_IN_END + 11
#define MIPL_STATISTICS_OUT_MPS		MIPL_STATISTICS_IN_END + 12
#define MIPL_STATISTICS_OUT_HAO		MIPL_STATISTICS_IN_END + 13
#define MIPL_STATISTICS_OUT_RH2		MIPL_STATISTICS_IN_END + 14
#define MIPL_STATISTICS_OUT_RTUN	MIPL_STATISTICS_IN_END + 15
#define MIPL_STATISTICS_OUT_RS		MIPL_STATISTICS_IN_END + 16
#define MIPL_STATISTICS_OUT_NS		MIPL_STATISTICS_IN_END + 17
#define MIPL_STATISTICS_OUT_NA		MIPL_STATISTICS_IN_END + 18
#define MIPL_STATISTICS_OUT_RS_UNSPEC	MIPL_STATISTICS_IN_END + 19
#define MIPL_STATISTICS_OUT_NS_UNSPEC	MIPL_STATISTICS_IN_END + 20

#define MIPL_STATISTICS_OUT_END		MIPL_STATISTICS_IN_END + 21

#define MIPL_STATISTICS_SIZE		MIPL_STATISTICS_OUT_END

struct mip6_stat {
	pthread_mutex_t lock;

	unsigned long int values[MIPL_STATISTICS_OUT_END];
};

extern struct mip6_stat mipl_stat;

static inline void
statistics_inc(struct mip6_stat *mipl_stat, int index)
{
	pthread_mutex_lock(&mipl_stat->lock);
	mipl_stat->values[index]++;
	pthread_mutex_unlock(&mipl_stat->lock);
}

#endif /* __STATISTICS_H__ */
