/*
 * perf.h
 *
 * Copyright (C) 2020 Red Hat, Inc., Kairui Song <kasong@redhat.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <poll.h>
extern int perf_event_ring_num;
extern struct PerfEvent *perf_events;

#define perf_fd_num perf_event_ring_num

int perf_handling_init();
int perf_handling_clean();
int perf_handling_start();
int perf_handling_process();

inline static int perf_count_fds(void) { return perf_event_ring_num; }
int perf_apply_fds(struct pollfd *fds);
