#!/bin/sh

# Midnight Commander - calculate current version
#
# Copyright (C) 2009, 2010, 2013
# The Free Software Foundation, Inc.
#
# Written by:
#  Slava Zanko <slavazanko@gmail.com>, 2009, 2010, 2013
#  Stan. S. Krupoderov <pashelper@gmail.com>, 2009
#  Sergei Trofimovich <slyfox@inbox.ru>, 2009
#  Oswald Buddenhagen <ossi@kde.org>, 2009
#
# This file is part of the Midnight Commander.
#
# The Midnight Commander is free software: you can redistribute it
# and/or modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 3 of the License,
# or (at your option) any later version.
#
# The Midnight Commander is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#*** include section (source functions, for example) *******************

#*** file scope functions **********************************************

mc_print_version(){

    if [ ! -f "${VERSION_FILE}" \
         -o "${PREV_MC_VERSION}" != "${CURR_MC_VERSION}" ]
      then
        cat >"${VERSION_FILE}" <<EOF
#ifndef MC_CURRENT_VERSION
/* This is an autogenerated file. Don't edit! */
#define MC_CURRENT_VERSION "${CURR_MC_VERSION}"
#endif
EOF
    fi
    exit
}

#*** main code *********************************************************

if [ -z "$1" ]
  then
      echo "usage: $0 <toplevel-source-dir>"
      exit 1
fi

src_top_dir="$1"

VERSION_FILE="${src_top_dir}/version.h"
PREV_MC_VERSION="unknown"
CURR_MC_VERSION="${PREV_MC_VERSION}"

if [ -r "${VERSION_FILE}" ]
  then
    PREV_MC_VERSION=`sed -n 's/^#define MC_CURRENT_VERSION "\(.*\)"$/\1/p' "${VERSION_FILE}"`
    CURR_MC_VERSION="${PREV_MC_VERSION}"
fi

git_head=`git --git-dir "${src_top_dir}/.git" rev-parse --verify HEAD 2>/dev/null`
[ -z "${git_head}" ] && mc_print_version

# try to store sha1
CURR_MC_VERSION="${git_head}"

new_version=`git --git-dir "${src_top_dir}/.git" describe --always 2>/dev/null`
[ -z "${new_version}" ] && mc_print_version

# store pretty tagged version
CURR_MC_VERSION="${new_version}"
mc_print_version
