/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.validation;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.validation.EntityState;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;

public class ValidationState
implements ValidationContext {
    private boolean fExtraChecking = true;
    private boolean fFacetChecking = true;
    private boolean fNormalize = true;
    private EntityState fEntityState = null;
    private NamespaceSupport fNamespaceSupport = null;
    private SymbolTable fSymbolTable = null;
    private final Hashtable fIdTable = new Hashtable();
    private final Hashtable fIdRefTable = new Hashtable();
    private static final Object fNullValue = new Object();

    public void setExtraChecking(boolean bl) {
        this.fExtraChecking = bl;
    }

    public void setFacetChecking(boolean bl) {
        this.fFacetChecking = bl;
    }

    public void setNormalizationRequired(boolean bl) {
        this.fNormalize = bl;
    }

    public void setEntityState(EntityState entityState) {
        this.fEntityState = entityState;
    }

    public void setNamespaceSupport(NamespaceSupport namespaceSupport) {
        this.fNamespaceSupport = namespaceSupport;
    }

    public void setSymbolTable(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }

    public String checkIDRefID() {
        Enumeration enumeration = this.fIdRefTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.fIdTable.containsKey(string)) continue;
            return string;
        }
        return null;
    }

    public void reset() {
        this.fExtraChecking = true;
        this.fFacetChecking = true;
        this.fIdTable.clear();
        this.fIdRefTable.clear();
        this.fEntityState = null;
        this.fNamespaceSupport = null;
        this.fSymbolTable = null;
    }

    public void resetIDTables() {
        this.fIdTable.clear();
        this.fIdRefTable.clear();
    }

    public boolean needExtraChecking() {
        return this.fExtraChecking;
    }

    public boolean needFacetChecking() {
        return this.fFacetChecking;
    }

    public boolean needToNormalize() {
        return this.fNormalize;
    }

    public boolean isEntityDeclared(String string) {
        if (this.fEntityState != null) {
            return this.fEntityState.isEntityDeclared(this.getSymbol(string));
        }
        return false;
    }

    public boolean isEntityUnparsed(String string) {
        if (this.fEntityState != null) {
            return this.fEntityState.isEntityUnparsed(this.getSymbol(string));
        }
        return false;
    }

    public boolean isIdDeclared(String string) {
        return this.fIdTable.containsKey(string);
    }

    public void addId(String string) {
        this.fIdTable.put(string, fNullValue);
    }

    public void addIdRef(String string) {
        this.fIdRefTable.put(string, fNullValue);
    }

    public String getSymbol(String string) {
        if (this.fSymbolTable != null) {
            return this.fSymbolTable.addSymbol(string);
        }
        return string.intern();
    }

    public String getURI(String string) {
        if (this.fNamespaceSupport != null) {
            return this.fNamespaceSupport.getURI(string);
        }
        return null;
    }
}

