/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.util.FileNameMapper;

public class VersionMapper
implements FileNameMapper,
Comparator {
    private List versions;
    private String to;

    public String[] mapFileName(String sourceFileName) {
        String originalFileName = new File(sourceFileName).getName();
        Iterator iter = this.versions.iterator();
        while (iter.hasNext()) {
            String version = (String)iter.next();
            int index = originalFileName.indexOf(version);
            if (index < 0) continue;
            String baseFilename = originalFileName.substring(0, index - 1);
            String extension = originalFileName.substring(index + version.length());
            String path = sourceFileName.substring(0, sourceFileName.length() - originalFileName.length());
            if ("flatten".equals(this.to)) {
                path = "";
            }
            return new String[]{path + baseFilename + extension};
        }
        return new String[]{sourceFileName};
    }

    public void setFrom(String from) {
        String[] split = StringUtils.split(from, File.pathSeparator);
        Arrays.sort(split, this);
        this.versions = Arrays.asList(split);
    }

    public void setTo(String to) {
        this.to = to;
    }

    public int compare(Object o1, Object o2) {
        String s1 = (String)o1;
        String s2 = (String)o2;
        int lengthDiff = s2.length() - s1.length();
        return lengthDiff != 0 ? lengthDiff : s1.compareTo(s2);
    }
}

