/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.util;

import java.lang.reflect.Field;
import java.util.Vector;
import junit.framework.Assert;
import org.jmock.core.Verifiable;

public class Verifier {
    private static Vector myProcessingObjects = new Vector();

    public static synchronized void verifyObject(Object anObject) {
        Verifier.verifyFieldsForClass(anObject, anObject.getClass(), myProcessingObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyFieldsForClass(Object anObject, Class aClass, Vector alreadyProcessed) {
        if (alreadyProcessed.contains(anObject) || Verifier.isBaseObjectClass(aClass)) {
            return;
        }
        Verifier.verifyFieldsForClass(anObject, aClass.getSuperclass(), alreadyProcessed);
        try {
            alreadyProcessed.addElement(anObject);
            Field[] fields = aClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Verifier.verifyField(fields[i], anObject, alreadyProcessed);
            }
        }
        finally {
            alreadyProcessed.removeElement(anObject);
        }
    }

    private static void verifyField(Field aField, Object anObject, Vector alreadyProcessed) {
        try {
            aField.setAccessible(true);
            Object fieldObject = aField.get(anObject);
            if (Verifier.isVerifiable(fieldObject) && !alreadyProcessed.contains(fieldObject)) {
                ((Verifiable)fieldObject).verify();
            }
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("Could not access field " + aField.getName()));
        }
    }

    private static boolean isVerifiable(Object anObject) {
        return anObject instanceof Verifiable;
    }

    private static boolean isBaseObjectClass(Class aClass) {
        return aClass.equals(Object.class);
    }
}

