/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.logging;

import org.codehaus.plexus.logging.Logger;

public abstract class AbstractLogger
implements Logger {
    private int threshold;
    private String name;

    public AbstractLogger(int threshold, String name) {
        if (!this.isValidThreshold(threshold)) {
            throw new IllegalArgumentException("Threshold " + threshold + " is not valid");
        }
        this.threshold = threshold;
        this.name = name;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public String getName() {
        return this.name;
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public boolean isDebugEnabled() {
        return this.threshold <= 0;
    }

    public void info(String message) {
        this.info(message, null);
    }

    public boolean isInfoEnabled() {
        return this.threshold <= 1;
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public boolean isWarnEnabled() {
        return this.threshold <= 2;
    }

    public void error(String message) {
        this.error(message, null);
    }

    public boolean isErrorEnabled() {
        return this.threshold <= 3;
    }

    public void fatalError(String message) {
        this.fatalError(message, null);
    }

    public boolean isFatalErrorEnabled() {
        return this.threshold <= 4;
    }

    protected boolean isValidThreshold(int threshold) {
        if (threshold == 0) {
            return true;
        }
        if (threshold == 1) {
            return true;
        }
        if (threshold == 2) {
            return true;
        }
        if (threshold == 3) {
            return true;
        }
        if (threshold == 4) {
            return true;
        }
        return threshold == 5;
    }
}

