include(ExternalData)
set(ExternalData_LINK_CONTENT SHA1)
set(ExternalData_SOURCE_ROOT ${CMAKE_CURRENT_BINARY_DIR})
set(ExternalData_BINARY_ROOT ${CMAKE_CURRENT_BINARY_DIR}/ExternalData)
set(input ${CMAKE_CURRENT_BINARY_DIR}/ToLink.txt)
set(output ${CMAKE_CURRENT_BINARY_DIR}/ExternalData/ToLink.txt)
set(staged "${CMAKE_CURRENT_BINARY_DIR}/.ExternalData_SHA1_114ee5dda251457fd2df63bec91d3b8db43aba58")
file(REMOVE ${staged})
file(REMOVE ${input}.sha1)
file(WRITE ${input} "To be transformed into a content link.")
ExternalData_Expand_Arguments(Data args DATA{${input}})
if("x${args}" STREQUAL "x${output}")
  message(STATUS "Raw data correctly transformed to content link!")
else()
  message(FATAL_ERROR "Data reference transformed to:\n  ${args}\n"
    "but we expected:\n  ${output}")
endif()
if(EXISTS "${staged}")
  message(STATUS "Staged content exists!")
else()
  message(FATAL_ERROR "Staged content missing!")
endif()
