#define PERL_constant_NOTFOUND	1
#define PERL_constant_NOTDEF	2
#define PERL_constant_ISIV	3
#define PERL_constant_ISNO	4
#define PERL_constant_ISNV	5
#define PERL_constant_ISPV	6
#define PERL_constant_ISPVN	7
#define PERL_constant_ISSV	8
#define PERL_constant_ISUNDEF	9
#define PERL_constant_ISUV	10
#define PERL_constant_ISYES	11

#ifndef NVTYPE
typedef double NV; /* 5.6 and later define NVTYPE, and typedef NV to it.  */
#endif
#ifndef aTHX_
#define aTHX_ /* 5.6 or later define this for threading support.  */
#endif
#ifndef pTHX_
#define pTHX_ /* 5.6 or later define this for threading support.  */
#endif

static int
constant_16 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     TNC_RESULT_FATAL TNC_RESULT_OTHER TNC_VENDORID_ANY TNC_VENDORID_TCG */
  /* Offset 14 gives the best switch position.  */
  switch (name[14]) {
  case 'A':
    if (memEQ(name, "TNC_RESULT_FATAL", 16)) {
    /*                             ^        */
#ifdef TNC_RESULT_FATAL
      *iv_return = TNC_RESULT_FATAL;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "TNC_VENDORID_TCG", 16)) {
    /*                             ^        */
#ifdef TNC_VENDORID_TCG
      *iv_return = TNC_VENDORID_TCG;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "TNC_RESULT_OTHER", 16)) {
    /*                             ^        */
#ifdef TNC_RESULT_OTHER
      *iv_return = TNC_RESULT_OTHER;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "TNC_VENDORID_ANY", 16)) {
    /*                             ^        */
#ifdef TNC_VENDORID_ANY
      *iv_return = TNC_VENDORID_ANY;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_21 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     TNC_LOG_SEVERITY_INFO TNC_RESULT_CANT_RETRY TNC_RESULT_WONT_RETRY */
  /* Offset 12 gives the best switch position.  */
  switch (name[12]) {
  case 'A':
    if (memEQ(name, "TNC_RESULT_CANT_RETRY", 21)) {
    /*                           ^               */
#ifdef TNC_RESULT_CANT_RETRY
      *iv_return = TNC_RESULT_CANT_RETRY;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "TNC_RESULT_WONT_RETRY", 21)) {
    /*                           ^               */
#ifdef TNC_RESULT_WONT_RETRY
      *iv_return = TNC_RESULT_WONT_RETRY;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "TNC_LOG_SEVERITY_INFO", 21)) {
    /*                           ^               */
#ifdef TNC_LOG_SEVERITY_INFO
      *iv_return = TNC_LOG_SEVERITY_INFO;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_28 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     TNC_RESULT_ILLEGAL_OPERATION TNC_RESULT_INVALID_PARAMETER
     TNC_RESULT_NO_COMMON_VERSION */
  /* Offset 19 gives the best switch position.  */
  switch (name[19]) {
  case 'N':
    if (memEQ(name, "TNC_RESULT_NO_COMMON_VERSION", 28)) {
    /*                                  ^               */
#ifdef TNC_RESULT_NO_COMMON_VERSION
      *iv_return = TNC_RESULT_NO_COMMON_VERSION;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "TNC_RESULT_ILLEGAL_OPERATION", 28)) {
    /*                                  ^               */
#ifdef TNC_RESULT_ILLEGAL_OPERATION
      *iv_return = TNC_RESULT_ILLEGAL_OPERATION;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "TNC_RESULT_INVALID_PARAMETER", 28)) {
    /*                                  ^               */
#ifdef TNC_RESULT_INVALID_PARAMETER
      *iv_return = TNC_RESULT_INVALID_PARAMETER;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant (pTHX_ const char *name, STRLEN len, IV *iv_return) {
  /* Initially switch on the length of the name.  */
  /* When generated this function returned values for the list of names given
     in this section of perl code.  Rather than manually editing these functions
     to add or remove constants, which would result in this comment and section
     of code becoming inaccurate, we recommend that you edit this section of
     code, and use it to regenerate a new set of constant functions which you
     then use to replace the originals.

     Regenerate these constant functions by feeding this entire source file to
     perl -x

#!/usr/bin/perl -w
use ExtUtils::Constant qw (constant_types C_constant XS_constant);

my $types = {map {($_, 1)} qw(IV)};
my @names = (qw(TNC_CONNECTIONID_ANY TNC_CONNECTION_STATE_ACCESS_ALLOWED
	       TNC_CONNECTION_STATE_ACCESS_ISOLATED
	       TNC_CONNECTION_STATE_ACCESS_NONE TNC_CONNECTION_STATE_CREATE
	       TNC_CONNECTION_STATE_DELETE TNC_CONNECTION_STATE_HANDSHAKE
	       TNC_IFIMC_VERSION_1 TNC_LOG_SEVERITY_DEBUG TNC_LOG_SEVERITY_ERR
	       TNC_LOG_SEVERITY_INFO TNC_LOG_SEVERITY_NOTICE
	       TNC_LOG_SEVERITY_WARNING TNC_RESULT_ALREADY_INITIALIZED
	       TNC_RESULT_CANT_RESPOND TNC_RESULT_CANT_RETRY TNC_RESULT_FATAL
	       TNC_RESULT_ILLEGAL_OPERATION TNC_RESULT_INVALID_PARAMETER
	       TNC_RESULT_NOT_INITIALIZED TNC_RESULT_NO_COMMON_VERSION
	       TNC_RESULT_OTHER TNC_RESULT_SUCCESS TNC_RESULT_WONT_RETRY
	       TNC_RETRY_REASON_IMC_INFORMATIONAL_EVENT
	       TNC_RETRY_REASON_IMC_PERIODIC
	       TNC_RETRY_REASON_IMC_REMEDIATION_COMPLETE
	       TNC_RETRY_REASON_IMC_SERIOUS_EVENT TNC_SUBTYPE_ANY
	       TNC_VENDORID_ANY TNC_VENDORID_TCG));

print constant_types(); # macro defs
foreach (C_constant ("Interface::TNC::IMC", 'constant', 'IV', $types, undef, 3, @names) ) {
    print $_, "\n"; # C constant subs
}
print "#### XS Section:\n";
print XS_constant ("Interface::TNC::IMC", $types);
__END__
   */

  switch (len) {
  case 15:
    if (memEQ(name, "TNC_SUBTYPE_ANY", 15)) {
#ifdef TNC_SUBTYPE_ANY
      *iv_return = TNC_SUBTYPE_ANY;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 16:
    return constant_16 (aTHX_ name, iv_return);
    break;
  case 18:
    if (memEQ(name, "TNC_RESULT_SUCCESS", 18)) {
#ifdef TNC_RESULT_SUCCESS
      *iv_return = TNC_RESULT_SUCCESS;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 19:
    if (memEQ(name, "TNC_IFIMC_VERSION_1", 19)) {
#ifdef TNC_IFIMC_VERSION_1
      *iv_return = TNC_IFIMC_VERSION_1;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 20:
    /* Names all of length 20.  */
    /* TNC_CONNECTIONID_ANY TNC_LOG_SEVERITY_ERR */
    /* Offset 9 gives the best switch position.  */
    switch (name[9]) {
    case 'C':
      if (memEQ(name, "TNC_CONNECTIONID_ANY", 20)) {
      /*                        ^                 */
#ifdef TNC_CONNECTIONID_ANY
        *iv_return = TNC_CONNECTIONID_ANY;
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    case 'E':
      if (memEQ(name, "TNC_LOG_SEVERITY_ERR", 20)) {
      /*                        ^                 */
#ifdef TNC_LOG_SEVERITY_ERR
        *iv_return = TNC_LOG_SEVERITY_ERR;
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    }
    break;
  case 21:
    return constant_21 (aTHX_ name, iv_return);
    break;
  case 22:
    if (memEQ(name, "TNC_LOG_SEVERITY_DEBUG", 22)) {
#ifdef TNC_LOG_SEVERITY_DEBUG
      *iv_return = TNC_LOG_SEVERITY_DEBUG;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 23:
    /* Names all of length 23.  */
    /* TNC_LOG_SEVERITY_NOTICE TNC_RESULT_CANT_RESPOND */
    /* Offset 22 gives the best switch position.  */
    switch (name[22]) {
    case 'D':
      if (memEQ(name, "TNC_RESULT_CANT_RESPON", 22)) {
      /*                                     D      */
#ifdef TNC_RESULT_CANT_RESPOND
        *iv_return = TNC_RESULT_CANT_RESPOND;
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    case 'E':
      if (memEQ(name, "TNC_LOG_SEVERITY_NOTIC", 22)) {
      /*                                     E      */
#ifdef TNC_LOG_SEVERITY_NOTICE
        *iv_return = TNC_LOG_SEVERITY_NOTICE;
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    }
    break;
  case 24:
    if (memEQ(name, "TNC_LOG_SEVERITY_WARNING", 24)) {
#ifdef TNC_LOG_SEVERITY_WARNING
      *iv_return = TNC_LOG_SEVERITY_WARNING;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 26:
    if (memEQ(name, "TNC_RESULT_NOT_INITIALIZED", 26)) {
#ifdef TNC_RESULT_NOT_INITIALIZED
      *iv_return = TNC_RESULT_NOT_INITIALIZED;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 27:
    /* Names all of length 27.  */
    /* TNC_CONNECTION_STATE_CREATE TNC_CONNECTION_STATE_DELETE */
    /* Offset 21 gives the best switch position.  */
    switch (name[21]) {
    case 'C':
      if (memEQ(name, "TNC_CONNECTION_STATE_CREATE", 27)) {
      /*                                    ^            */
#ifdef TNC_CONNECTION_STATE_CREATE
        *iv_return = TNC_CONNECTION_STATE_CREATE;
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    case 'D':
      if (memEQ(name, "TNC_CONNECTION_STATE_DELETE", 27)) {
      /*                                    ^            */
#ifdef TNC_CONNECTION_STATE_DELETE
        *iv_return = TNC_CONNECTION_STATE_DELETE;
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    }
    break;
  case 28:
    return constant_28 (aTHX_ name, iv_return);
    break;
  case 29:
    if (memEQ(name, "TNC_RETRY_REASON_IMC_PERIODIC", 29)) {
#ifdef TNC_RETRY_REASON_IMC_PERIODIC
      *iv_return = TNC_RETRY_REASON_IMC_PERIODIC;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 30:
    /* Names all of length 30.  */
    /* TNC_CONNECTION_STATE_HANDSHAKE TNC_RESULT_ALREADY_INITIALIZED */
    /* Offset 29 gives the best switch position.  */
    switch (name[29]) {
    case 'D':
      if (memEQ(name, "TNC_RESULT_ALREADY_INITIALIZE", 29)) {
      /*                                            D      */
#ifdef TNC_RESULT_ALREADY_INITIALIZED
        *iv_return = TNC_RESULT_ALREADY_INITIALIZED;
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    case 'E':
      if (memEQ(name, "TNC_CONNECTION_STATE_HANDSHAK", 29)) {
      /*                                            E      */
#ifdef TNC_CONNECTION_STATE_HANDSHAKE
        *iv_return = TNC_CONNECTION_STATE_HANDSHAKE;
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    }
    break;
  case 32:
    if (memEQ(name, "TNC_CONNECTION_STATE_ACCESS_NONE", 32)) {
#ifdef TNC_CONNECTION_STATE_ACCESS_NONE
      *iv_return = TNC_CONNECTION_STATE_ACCESS_NONE;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 34:
    if (memEQ(name, "TNC_RETRY_REASON_IMC_SERIOUS_EVENT", 34)) {
#ifdef TNC_RETRY_REASON_IMC_SERIOUS_EVENT
      *iv_return = TNC_RETRY_REASON_IMC_SERIOUS_EVENT;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 35:
    if (memEQ(name, "TNC_CONNECTION_STATE_ACCESS_ALLOWED", 35)) {
#ifdef TNC_CONNECTION_STATE_ACCESS_ALLOWED
      *iv_return = TNC_CONNECTION_STATE_ACCESS_ALLOWED;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 36:
    if (memEQ(name, "TNC_CONNECTION_STATE_ACCESS_ISOLATED", 36)) {
#ifdef TNC_CONNECTION_STATE_ACCESS_ISOLATED
      *iv_return = TNC_CONNECTION_STATE_ACCESS_ISOLATED;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 40:
    if (memEQ(name, "TNC_RETRY_REASON_IMC_INFORMATIONAL_EVENT", 40)) {
#ifdef TNC_RETRY_REASON_IMC_INFORMATIONAL_EVENT
      *iv_return = TNC_RETRY_REASON_IMC_INFORMATIONAL_EVENT;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 41:
    if (memEQ(name, "TNC_RETRY_REASON_IMC_REMEDIATION_COMPLETE", 41)) {
#ifdef TNC_RETRY_REASON_IMC_REMEDIATION_COMPLETE
      *iv_return = TNC_RETRY_REASON_IMC_REMEDIATION_COMPLETE;
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

