#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include <libtncimv.h>
#include "const-c.inc"

// Here we define the functions that can be called from within libtnc
TNC_Result TNC_TNCS_SendMessage(
/*in*/ TNC_IMVID imvID,
/*in*/ TNC_ConnectionID connectionID,
/*in*/ TNC_BufferReference message,
/*in*/ TNC_UInt32 messageLength,
/*in*/ TNC_MessageType messageType)
{
    dSP;
    int count;
    int ret;

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSViv(imvID)));
    XPUSHs(sv_2mortal(newSViv(connectionID)));
    XPUSHs(sv_2mortal(newSVpv((const char*)message, (STRLEN)messageLength)));
    XPUSHs(sv_2mortal(newSViv(messageType)));
    PUTBACK;
    count = call_pv("Interface::IMV::TNC_TNCS_SendMessage", G_SCALAR);
    SPAGAIN ;
    if (count != 1)
       croak("Interface::IMV::TNC_TNCS_SendMessage did not return a status\n");
    ret = POPi;
    FREETMPS;
    LEAVE ;
    return ret;
}

TNC_Result TNC_TNCS_RequestHandshakeRetry(
/*in*/ TNC_IMVID imvID,
/*in*/ TNC_ConnectionID connectionID,
/*in*/ TNC_RetryReason reason)
{
    dSP;
    int count;
    int ret;

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSViv(imvID)));
    XPUSHs(sv_2mortal(newSViv(connectionID)));
    XPUSHs(sv_2mortal(newSViv(reason)));
    PUTBACK;
    count = call_pv("Interface::IMV::TNC_TNCS_RequestHandshakeRetry", G_SCALAR);
    SPAGAIN ;
    if (count != 1)
       croak("Interface::IMV::TNC_TNCS_RequestHandshakeRetry did not return a status\n");
    ret = POPi;
    FREETMPS;
    LEAVE ;
    return ret;
}

TNC_Result TNC_TNCS_ProvideRecommendation(
/*in*/ TNC_IMVID imvID,
/*in*/ TNC_ConnectionID connectionID,
/*in*/ TNC_IMV_Action_Recommendation recommendation,
/*in*/ TNC_IMV_Evaluation_Result evaluation)
{
    dSP;
    int count;
    int ret;

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSViv(imvID)));
    XPUSHs(sv_2mortal(newSViv(connectionID)));
    XPUSHs(sv_2mortal(newSViv(recommendation)));
    XPUSHs(sv_2mortal(newSViv(evaluation)));
    PUTBACK;
    count = call_pv("Interface::IMV::TNC_TNCS_ProvideRecommendation", G_SCALAR);
    SPAGAIN ;
    if (count != 1)
       croak("Interface::IMV::TNC_TNCS_ProvideRecommendation did not return a status\n");
    ret = POPi;
    FREETMPS;
    LEAVE ;
    return ret;
}

TNC_Result libtnc_logMessage(
    /*in*/ TNC_UInt32 severity,
    /*in*/ const char* format, ...)
{
    dSP;
    char buf[10000];
    va_list arg;
    va_start(arg, format);

    vsnprintf(buf, 10000, format, arg);

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSVpv((const char*)buf, strlen(buf))));
    PUTBACK;
    call_pv("Interface::IMV::libtnc_logMessage", G_SCALAR);
    FREETMPS;
    LEAVE ;
    return TNC_RESULT_SUCCESS;
}

MODULE = Interface::TNC::IMV	PACKAGE = Interface::TNC::IMV	PREFIX = libtnc_imv_
PROTOTYPES: ENABLE		
INCLUDE: const-xs.inc

TNC_Result
libtnc_imv_BatchEnding(connectionID)
	TNC_ConnectionID	connectionID

TNC_Result
libtnc_imv_NotifyConnectionChange(connectionID, newState)
	TNC_ConnectionID	connectionID
	TNC_ConnectionState	newState

TNC_Result
libtnc_imv_ReceiveMessage(connectionID, message, messageType)
	TNC_ConnectionID  connectionID
	TNC_MessageType	  messageType
	PREINIT:
	STRLEN messageLength;
	INPUT:
	char* message =  SvPV(ST(1), messageLength);
	CODE:
	 RETVAL = libtnc_imv_ReceiveMessage(connectionID, 
	 (TNC_BufferReference)message, 
	 (TNC_UInt32)messageLength, messageType);
        OUTPUT:
         RETVAL

TNC_Result
libtnc_imv_SolicitRecommendation(connectionID)
	TNC_ConnectionID	connectionID

TNC_Result
libtnc_imv_Terminate()

TNC_Result
libtnc_imv_destroy(self)
	libtnc_imv *	self

int
libtnc_imv_load_config(filename)
	char *	filename

TNC_Result
libtnc_imv_load_modules(filenames)
	SV* filenames
	INIT:
	 I32 numfiles = av_len((AV *)SvRV(filenames)) + 1;
	 char** a;
	CODE:
	 New(0, a, numfiles, char*);
         if (a)
	 {
	    int i;
	    for (i = 0; i < numfiles; i++)
	        a[i] = (char*)SvPV(*av_fetch((AV *)SvRV(filenames), i, 0), PL_na);
	    RETVAL = libtnc_imv_load_modules((const char**)a, numfiles);
	    Safefree(a);
	 }
         else
            RETVAL = TNC_RESULT_FATAL;
        OUTPUT:
         RETVAL

int
libtnc_imv_load_std_config()

libtnc_imv *
libtnc_imv_new(filename)
	char *	filename

TNC_Result
libtnc_imv_unload()

