%bcond_with     test
%global py2_build_dir %{_builddir}/%{name}-%{version}-%{release}-python2

%if 0%{?rhel} > 7 || 0%{?fedora} > 28
%bcond_with     python2
%else
%bcond_without  python2
%endif

Name:           libstoragemgmt
Version:        1.9.5
Release:        1%{?dist}
Summary:        Storage array management library
Group:          System Environment/Libraries
License:        LGPLv2+
URL:            https://github.com/libstorage/libstoragemgmt
Source0:        https://github.com/libstorage/libstoragemgmt/releases/download/%{version}/%{name}-%{version}.tar.gz
Requires:       python3-%{name}

# Packages that have been removed
Obsoletes:      %{name}-netapp-plugin < %{version}-%{release}
Obsoletes:      %{name}-nstor-plugin < %{version}-%{release}
Obsoletes:      python2-%{name}-clibs < %{version}-%{release}
Obsoletes:      python3-%{name}-clibs < %{version}-%{release}
Obsoletes:      %{name}-nfs-plugin-clibs < %{version}-%{release}


BuildRequires:  gcc gcc-c++
BuildRequires:  autoconf automake libtool check-devel perl-interpreter
BuildRequires:  glib2-devel
BuildRequires:  systemd
BuildRequires:  bash-completion
BuildRequires:  libconfig-devel
BuildRequires:  systemd-devel
BuildRequires:  kernel-headers
%if %{with python2}
BuildRequires:  python2-six
BuildRequires:  python2-devel
%endif
BuildRequires:  procps
BuildRequires:  sqlite-devel
BuildRequires:  python3-six
BuildRequires:  python3-devel

%{?systemd_requires}
BuildRequires:  systemd systemd-devel

BuildRequires:  chrpath
BuildRequires:  valgrind

%description
The libStorageMgmt library will provide a vendor agnostic open source storage
application programming interface (API) that will allow management of storage
arrays.  The library includes a command line interface for interactive use and
scripting (command lsmcli).  The library also has a daemon that is used for
executing plug-ins in a separate process (lsmd).

%package        devel
Summary:        Development files for %{name}
Group:          Development/Libraries
Requires:       %{name}%{?_isa} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%if %{with python2}
%package        -n python2-%{name}
Summary:        Python2 client libraries and plug-in support for %{name}
Group:          System Environment/Libraries
Requires:       %{name}%{?_isa} = %{version}-%{release}
%{?python_provide:%python_provide python2-%{name}}

%description    -n python2-%{name}
This package contains python client libraries as well as python
framework support and open source plug-ins written in python.

# If obsoleted plugins are installed, we need to meet it's requirement
# of having the correct version of this package functionality installed too as
# the update occurs first, before the obsolete removes the obsoleted package.
Provides:       python2-%{name} < %{version}-%{release}
%{?python_provide:%python_provide python2-%{name}-clibs}

%endif

%package        -n python3-%{name}
Summary:        Python 3 client libraries and plug-in support for %{name}
Group:          System Environment/Libraries
Requires:       %{name}%{?_isa} = %{version}-%{release}

# If obsoleted plugins are installed, we need to meet it's requirement
# of having the correct version of this package functionality installed too as
# the update occurs first, before the obsolete removes the obsoleted package.
Provides:       python3-%{name} < %{version}-%{release}
%{?python_provide:%python_provide python3-%{name}}

%description    -n python3-%{name}
This contains python 3 client libraries as well as python framework
support and open source plug-ins written in python 3.

%package        smis-plugin
Summary:        Files for SMI-S generic array support for %{name}
Group:          System Environment/Libraries
BuildRequires:  python3-pywbem
Requires:       python3-pywbem
%if %{with python2}
BuildRequires:  python2-pywbem
%endif
BuildArch:      noarch
Provides:       %{name}-ibm-v7k-plugin = 2:%{version}-%{release}
Obsoletes:      %{name}-ibm-v7k-plugin <= 2:0.1.0-3
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}


%description    smis-plugin
The %{name}-smis-plugin package contains plug-in for generic SMI-S array
support.

%package        targetd-plugin
Summary:        Files for targetd array support for %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}
BuildArch:      noarch

%description    targetd-plugin
The %{name}-targetd-plugin package contains plug-in for targetd array
support.

%package        udev
Summary:        Udev files for %{name}
Group:          System Environment/Base

%description    udev
The %{name}-udev package contains udev rules and helper utilities for
uevents generated by the kernel.

%package        megaraid-plugin
Summary:        Files for LSI MegaRAID support for %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}
BuildArch:      noarch

%description    megaraid-plugin
The %{name}-megaraid-plugin package contains the plugin for LSI
MegaRAID storage management via storcli.

%package        hpsa-plugin
Summary:        Files for HP SmartArray support for %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}
BuildArch:      noarch

%description    hpsa-plugin
The %{name}-hpsa-plugin package contains the plugin for HP
SmartArray storage management via hpssacli.

%package        arcconf-plugin
Summary:        Files for Microsemi Adaptec and Smart Family support for %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}
BuildArch:      noarch

%description    arcconf-plugin
The %{name}-arcconf-plugin package contains the plugin for Microsemi
Adaptec RAID and Smart Family Controller storage management.

%package        nfs-plugin
Summary:        Files for NFS local filesystem support for %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires:       %{name}%{?_isa} = %{version}-%{release}
Requires:       nfs-utils
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}

%description    nfs-plugin
The nfs-plugin package contains plug-in for local NFS exports support.

%package        local-plugin
Summary:        Files for local pseudo plugin of %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}
BuildArch:      noarch

%description    local-plugin
The %{name}-local-plugin is a plugin that provides auto
plugin selection for locally managed storage.

%prep
%autosetup -p1

%build
./autogen.sh
%if %{with python2}
# Copy the whole directory to Python2 build
rm -fr %{py2_build_dir}
cp -a . %{py2_build_dir}
%endif

%configure --with-python3 --disable-static
V=1 make %{?_smp_mflags}

%if %{with python2}
pushd %{py2_build_dir}
%configure --disable-static
V=1 make %{?_smp_mflags}
popd
%endif

%install
rm -rf %{buildroot}

%if %{with python2}
pushd %{py2_build_dir}
make install DESTDIR=%{buildroot}
rm -rf %{buildroot}/%{python_sitelib}/lsm/plugin
rm -rf %{buildroot}/%{_bindir}/lsmcli
popd
%endif

make install DESTDIR=%{buildroot}

find %{buildroot} -name '*.la' -exec rm -f {} ';'

#Files for udev handling
mkdir -p %{buildroot}/%{_udevrulesdir}
install -m 644 tools/udev/90-scsi-ua.rules \
    %{buildroot}/%{_udevrulesdir}/90-scsi-ua.rules
install -m 755 tools/udev/scan-scsi-target \
    %{buildroot}/%{_udevrulesdir}/../scan-scsi-target

%if 0%{with test}
%check
if ! make check
then
  cat test-suite.log || true
  exit 1
fi

%if %{with python2}
pushd %{py2_build_dir}
if ! make check
then
  cat test-suite.log || true
  exit 1
fi
popd
%endif
%endif

%pre
getent group libstoragemgmt >/dev/null || groupadd -r libstoragemgmt
getent passwd libstoragemgmt >/dev/null || \
    useradd -r -g libstoragemgmt -d /var/run/lsm -s /sbin/nologin \
    -c "daemon account for libstoragemgmt" libstoragemgmt

%post
/sbin/ldconfig
# Create tmp socket folders.
%tmpfiles_create %{_tmpfilesdir}/%{name}.conf
%systemd_post %{name}.service

%preun
%systemd_preun %{name}.service

%postun
/sbin/ldconfig
%systemd_postun %{name}.service

# Need to restart lsmd if plugin is new installed or removed.
%post smis-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

%postun smis-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post targetd-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

%postun targetd-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post megaraid-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi
%postun megaraid-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post hpsa-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi
%postun hpsa-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post arcconf-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi
%postun arcconf-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post nfs-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi
%postun nfs-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post local-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi
%postun local-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

%files
%doc README COPYING.LIB NEWS
%{_mandir}/man1/lsmcli.1*
%{_mandir}/man1/lsmd.1*
%{_mandir}/man5/lsmd.conf.5*
%{_libdir}/*.so.*
%{_bindir}/lsmcli
%{_datadir}/bash-completion/completions/lsmcli
%{_bindir}/lsmd
%{_bindir}/simc_lsmplugin
%dir %{_sysconfdir}/lsm
%dir %{_sysconfdir}/lsm/pluginconf.d
%config(noreplace) %{_sysconfdir}/lsm/lsmd.conf
%{_mandir}/man1/simc_lsmplugin.1*

%{_unitdir}/%{name}.service

%ghost %dir %attr(0775, -, -) /run/lsm/
%ghost %dir %attr(0775, -, -) /run/lsm/ipc

%attr(0644, root, root) %{_tmpfilesdir}/%{name}.conf

%files devel
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/%{name}.pc
%{_mandir}/man3/lsm_*
%{_mandir}/man3/libstoragemgmt*

%if %{with python2}
%files -n python2-%{name}
#Python library files
%dir %{python2_sitearch}/lsm
%{python2_sitearch}/lsm/__init__.*
%{python2_sitearch}/lsm/_client.*
%{python2_sitearch}/lsm/_common.*
%{python2_sitearch}/lsm/_local_disk.*
%{python2_sitearch}/lsm/_data.*
%{python2_sitearch}/lsm/_iplugin.*
%{python2_sitearch}/lsm/_pluginrunner.*
%{python2_sitearch}/lsm/_transport.*
%{python2_sitearch}/lsm/version.*
%{python2_sitearch}/lsm/_clib.*
%dir %{python2_sitearch}/lsm/lsmcli
%{python2_sitearch}/lsm/lsmcli/__init__.*
%{python2_sitearch}/lsm/lsmcli/data_display.*
%{python2_sitearch}/lsm/lsmcli/cmdline.*

%endif

%files -n python3-%{name}
%dir %{python3_sitearch}/lsm
%{python3_sitearch}/lsm/__init__.*
%{python3_sitearch}/lsm/_client.*
%{python3_sitearch}/lsm/_common.*
%{python3_sitearch}/lsm/_local_disk.*
%{python3_sitearch}/lsm/_data.*
%{python3_sitearch}/lsm/_iplugin.*
%{python3_sitearch}/lsm/_pluginrunner.*
%{python3_sitearch}/lsm/_transport.*
%{python3_sitearch}/lsm/__pycache__/
%{python3_sitearch}/lsm/version.*
%dir %{python3_sitearch}/lsm/lsmcli
%{python3_sitearch}/lsm/lsmcli/__init__.*
%{python3_sitearch}/lsm/lsmcli/__pycache__/
%{python3_sitearch}/lsm/lsmcli/data_display.*
%{python3_sitearch}/lsm/lsmcli/cmdline.*
%{python3_sitearch}/lsm/_clib.*

%dir %{python3_sitearch}/sim_plugin
%{python3_sitearch}/sim_plugin/__pycache__/
%{python3_sitearch}/sim_plugin/__init__.*
%{python3_sitearch}/sim_plugin/simulator.*
%{python3_sitearch}/sim_plugin/simarray.*

%{_bindir}/sim_lsmplugin
%dir %{_libexecdir}/lsm.d
%{_libexecdir}/lsm.d/find_unused_lun.py*
%{_libexecdir}/lsm.d/local_check.py*
%config(noreplace) %{_sysconfdir}/lsm/pluginconf.d/sim.conf
%{_mandir}/man1/sim_lsmplugin.1*

%files smis-plugin
%dir %{python3_sitelib}/smispy_plugin
%dir %{python3_sitelib}/smispy_plugin/__pycache__
%{python3_sitelib}/smispy_plugin/__pycache__/*
%{python3_sitelib}/smispy_plugin/__init__.*
%{python3_sitelib}/smispy_plugin/smis.*
%{python3_sitelib}/smispy_plugin/dmtf.*
%{python3_sitelib}/smispy_plugin/utils.*
%{python3_sitelib}/smispy_plugin/smis_common.*
%{python3_sitelib}/smispy_plugin/smis_cap.*
%{python3_sitelib}/smispy_plugin/smis_sys.*
%{python3_sitelib}/smispy_plugin/smis_pool.*
%{python3_sitelib}/smispy_plugin/smis_disk.*
%{python3_sitelib}/smispy_plugin/smis_vol.*
%{python3_sitelib}/smispy_plugin/smis_ag.*
%{_bindir}/smispy_lsmplugin
%{_mandir}/man1/smispy_lsmplugin.1*

%files targetd-plugin
%dir %{python3_sitelib}/targetd_plugin
%dir %{python3_sitelib}/targetd_plugin/__pycache__
%{python3_sitelib}/targetd_plugin/__pycache__/*
%{python3_sitelib}/targetd_plugin/__init__.*
%{python3_sitelib}/targetd_plugin/targetd.*
%{_bindir}/targetd_lsmplugin
%{_mandir}/man1/targetd_lsmplugin.1*

%files udev
%{_udevrulesdir}/../scan-scsi-target
%{_udevrulesdir}/90-scsi-ua.rules

%files megaraid-plugin
%dir %{python3_sitelib}/megaraid_plugin
%dir %{python3_sitelib}/megaraid_plugin/__pycache__
%{python3_sitelib}/megaraid_plugin/__pycache__/*
%{python3_sitelib}/megaraid_plugin/__init__.*
%{python3_sitelib}/megaraid_plugin/megaraid.*
%{python3_sitelib}/megaraid_plugin/utils.*
%{_bindir}/megaraid_lsmplugin
%config(noreplace) %{_sysconfdir}/lsm/pluginconf.d/megaraid.conf
%{_mandir}/man1/megaraid_lsmplugin.1*

%files hpsa-plugin
%dir %{python3_sitelib}/hpsa_plugin
%dir %{python3_sitelib}/hpsa_plugin/__pycache__
%{python3_sitelib}/hpsa_plugin/__pycache__/*
%{python3_sitelib}/hpsa_plugin/__init__.*
%{python3_sitelib}/hpsa_plugin/hpsa.*
%{python3_sitelib}/hpsa_plugin/utils.*
%{_bindir}/hpsa_lsmplugin
%config(noreplace) %{_sysconfdir}/lsm/pluginconf.d/hpsa.conf
%{_mandir}/man1/hpsa_lsmplugin.1*

%files nfs-plugin
%dir %{python3_sitearch}/nfs_plugin
%dir %{python3_sitearch}/nfs_plugin/__pycache__
%{python3_sitearch}/nfs_plugin/__pycache__/*
%{python3_sitearch}/nfs_plugin/__init__.*
%{python3_sitearch}/nfs_plugin/nfs.*
%{python3_sitearch}/nfs_plugin/nfs_clib.*
%config(noreplace) %{_sysconfdir}/lsm/pluginconf.d/nfs.conf
%{_bindir}/nfs_lsmplugin
%{_mandir}/man1/nfs_lsmplugin.1*

%files arcconf-plugin
%dir %{python3_sitelib}/arcconf_plugin
%dir %{python3_sitelib}/arcconf_plugin/__pycache__
%{python3_sitelib}/arcconf_plugin/__pycache__/*
%{python3_sitelib}/arcconf_plugin/__init__.*
%{python3_sitelib}/arcconf_plugin/arcconf.*
%{python3_sitelib}/arcconf_plugin/utils.*
%{_bindir}/arcconf_lsmplugin
%config(noreplace) %{_sysconfdir}/lsm/pluginconf.d/arcconf.conf
%{_mandir}/man1/arcconf_lsmplugin.1*

%files local-plugin
%dir %{python3_sitelib}/local_plugin
%dir %{python3_sitelib}/local_plugin/__pycache__
%{python3_sitelib}/local_plugin/__pycache__/*
%{python3_sitelib}/local_plugin/__init__.*
%{python3_sitelib}/local_plugin/local.*
%config(noreplace) %{_sysconfdir}/lsm/pluginconf.d/local.conf
%{_bindir}/local_lsmplugin
%{_mandir}/man1/local_lsmplugin.1*

%changelog
* Mon Feb 6 2012 Tony Asleson <tasleson@redhat.com> 1.9.5-1
- Upgrade to 1.9.5
