# NBD client library in userspace
# WARNING: THIS FILE IS GENERATED FROM
# generator/generator
# ANY CHANGES YOU MAKE TO THIS FILE WILL BE LOST.
#
# Copyright (C) 2013-2019 Red Hat Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

'''
Python bindings for libnbd

import nbd
h = nbd.NBD ()
h.connect_tcp ("localhost", "nbd")
buf = h.pread (512, 0)

Read the libnbd(3) man page to find out how to use the API.
'''

import libnbdmod

# Re-export Error exception as nbd.Error, adding some methods.
from libnbdmod import Error

Error.__doc__ = '''
Exception thrown when the underlying libnbd call fails.

This exception has three properties to query the error.  Use
the .string property to return a printable string containing
the error message.  Use the .errnum property for the associated
numeric error value (which may be 0 if the error did not
correspond to a system call failure), or the .errno property to
return a string containing the Python errno name if one is known
(which may be None if the numeric value does not correspond to
a known errno name).
'''

Error.string = property (lambda self: self.args[0])

def _errno (self):
    import errno
    try:
        return errno.errorcode[self.args[1]]
    except KeyError:
        return None
Error.errno = property (_errno)

Error.errnum = property (lambda self: self.args[1])

def _str (self):
    if self.errno:
        return ("%s (%s)" % (self.string, self.errno))
    else:
        return ("%s" % self.string)
Error.__str__ = _str

TLS_DISABLE                    = 0
TLS_ALLOW                      = 1
TLS_REQUIRE                    = 2

CMD_FLAG_FUA                   = 1
CMD_FLAG_NO_HOLE               = 2
CMD_FLAG_DF                    = 4
CMD_FLAG_REQ_ONE               = 8
CMD_FLAG_FAST_ZERO             = 16

HANDSHAKE_FLAG_FIXED_NEWSTYLE  = 1
HANDSHAKE_FLAG_NO_ZEROES       = 2

ALLOW_TRANSPORT_TCP            = 1
ALLOW_TRANSPORT_UNIX           = 2
ALLOW_TRANSPORT_VSOCK          = 4

AIO_DIRECTION_READ             = 1
AIO_DIRECTION_WRITE            = 2
AIO_DIRECTION_BOTH             = 3
READ_DATA                      = 1
READ_HOLE                      = 2
READ_ERROR                     = 3
NAMESPACE_BASE                 = "base:"
CONTEXT_BASE_ALLOCATION        = "base:allocation"
STATE_HOLE                     = 1
STATE_ZERO                     = 2

class Buffer (object):
    '''Asynchronous I/O persistent buffer'''

    def __init__ (self, len):
        '''allocate an uninitialized AIO buffer used for nbd.aio_pread'''
        self._o = libnbdmod.alloc_aio_buffer (len)

    @classmethod
    def from_bytearray (cls, ba):
        '''create an AIO buffer from a bytearray'''
        o = libnbdmod.aio_buffer_from_bytearray (ba)
        self = cls (0)
        self._o = o
        return self

    def to_bytearray (self):
        '''copy an AIO buffer into a bytearray'''
        return libnbdmod.aio_buffer_to_bytearray (self._o)

    def size (self):
        '''return the size of an AIO buffer'''
        return libnbdmod.aio_buffer_size (self._o)

class NBD (object):
    '''NBD handle'''

    def __init__ (self):
        '''create a new NBD handle'''
        self._o = libnbdmod.create ()

    def __del__ (self):
        '''close the NBD handle and underlying connection'''
        libnbdmod.close (self._o)

    def set_debug (self, debug):
        '''▶ set or clear the debug flag

    Set or clear the debug flag. When debugging is enabled,
    debugging messages from the library are printed to
    stderr, unless a debugging callback has been defined too
    (see "nbd.set_debug_callback") in which case they are
    sent to that function. This flag defaults to false on
    newly created handles, except if "DEBUG=1" is set in the
    environment in which case it defaults to true.
'''
        return libnbdmod.set_debug (self._o, debug)

    def get_debug (self):
        '''▶ return the state of the debug flag

    Return the state of the debug flag on this handle.
'''
        return libnbdmod.get_debug (self._o)

    def set_debug_callback (self, debug):
        '''▶ set the debug callback

    Set the debug callback. This function is called when the
    library emits debug messages, when debugging is enabled
    on a handle. The callback parameters are "user_data"
    passed to this function, the name of the libnbd function
    emitting the debug message ("context"), and the message
    itself ("msg"). If no debug callback is set on a handle
    then messages are printed on "stderr".

    The callback should not call "nbd_*" APIs on the same
    handle since it can be called while holding the handle
    lock and will cause a deadlock.
'''
        return libnbdmod.set_debug_callback (self._o, debug)

    def clear_debug_callback (self):
        '''▶ clear the debug callback

    Remove the debug callback if one was previously
    associated with the handle (with
    "nbd.set_debug_callback"). If no callback was associated
    this does nothing.
'''
        return libnbdmod.clear_debug_callback (self._o)

    def set_handle_name (self, handle_name):
        '''▶ set the handle name

    Handles have a name which is unique within the current
    process. The handle name is used in debug output.

    Handle names are normally generated automatically and
    have the form "nbd1", "nbd2", etc., but you can
    optionally use this call to give the handles a name
    which is meaningful for your application to make
    debugging output easier to understand.
'''
        return libnbdmod.set_handle_name (self._o, handle_name)

    def get_handle_name (self):
        '''▶ get the handle name

    Get the name of the handle. If it was previously set by
    calling "nbd.set_handle_name" then this returns the name
    that was set. Otherwise it will return a generic name
    like "nbd1", "nbd2", etc.
'''
        return libnbdmod.get_handle_name (self._o)

    def set_export_name (self, export_name):
        '''▶ set the export name

    For servers which require an export name or can serve
    different content on different exports, set the
    "export_name" to connect to. The default is the empty
    string "".

    This is only relevant when connecting to servers using
    the newstyle protocol as the oldstyle protocol did not
    support export names. The NBD protocol limits export
    names to 4096 bytes, but servers may not support the
    full length. The encoding of export names is always
    UTF-8.

    This call may be skipped if using "nbd.connect_uri" to
    connect to a URI that includes an export name.
'''
        return libnbdmod.set_export_name (self._o, export_name)

    def get_export_name (self):
        '''▶ get the export name

    Get the export name associated with the handle.
'''
        return libnbdmod.get_export_name (self._o)

    def set_tls (self, tls):
        '''▶ enable or require TLS (authentication and encryption)

    Enable or require TLS (authenticated and encrypted
    connections) to the NBD server. The possible settings
    are:

    "TLS_DISABLE"
        Disable TLS. (The default setting, unless using
        "nbd.connect_uri" with a URI that requires TLS)

    "TLS_ALLOW"
        Enable TLS if possible.

        This option is insecure (or best effort) in that in
        some cases it will fall back to an unencrypted
        and/or unauthenticated connection if TLS could not
        be established. Use "TLS_REQUIRE" below if the
        connection must be encrypted.

        Some servers will drop the connection if TLS fails
        so fallback may not be possible.

    "TLS_REQUIRE"
        Require an encrypted and authenticated TLS
        connection. Always fail to connect if the connection
        is not encrypted and authenticated.

    As well as calling this you may also need to supply the
    path to the certificates directory
    ("nbd.set_tls_certificates"), the username
    ("nbd.set_tls_username") and/or the Pre-Shared Keys
    (PSK) file ("nbd.set_tls_psk_file"). For now, when using
    "nbd.connect_uri", any URI query parameters related to
    TLS are not handled automatically. Setting the level
    higher than zero will fail if libnbd was not compiled
    against gnutls; you can test whether this is the case
    with "nbd.supports_tls".
'''
        return libnbdmod.set_tls (self._o, tls)

    def get_tls (self):
        '''▶ get the TLS request setting

    Get the TLS request setting.

    Note: If you want to find out if TLS was actually
    negotiated on a particular connection use
    "nbd.get_tls_negotiated" instead.
'''
        return libnbdmod.get_tls (self._o)

    def get_tls_negotiated (self):
        '''▶ find out if TLS was negotiated on a connection

    After connecting you may call this to find out if the
    connection is using TLS.

    This is only really useful if you set the TLS request
    mode to "TLS_ALLOW" (see "nbd.set_tls"), because in this
    mode we try to use TLS but fall back to unencrypted if
    it was not available. This function will tell you if TLS
    was negotiated or not.

    In "TLS_REQUIRE" mode (the most secure) the connection
    would have failed if TLS could not be negotiated, and in
    "TLS_DISABLE" mode TLS is not tried.
'''
        return libnbdmod.get_tls_negotiated (self._o)

    def set_tls_certificates (self, dir):
        '''▶ set the path to the TLS certificates directory

    Set the path to the TLS certificates directory. If not
    set and TLS is used then a compiled in default is used.
    For root this is "/etc/pki/libnbd/". For non-root this
    is "$HOME/.pki/libnbd" and "$HOME/.config/pki/libnbd".
    If none of these directories can be found then the
    system trusted CAs are used.

    This function may be called regardless of whether TLS is
    supported, but will have no effect unless "nbd.set_tls"
    is also used to request or require TLS.
'''
        return libnbdmod.set_tls_certificates (self._o, dir)

    def set_tls_verify_peer (self, verify):
        '''▶ set whether we verify the identity of the server

    Set this flag to control whether libnbd will verify the
    identity of the server from the server's certificate and
    the certificate authority. This defaults to true when
    connecting to TCP servers using TLS certificate
    authentication, and false otherwise.

    This function may be called regardless of whether TLS is
    supported, but will have no effect unless "nbd.set_tls"
    is also used to request or require TLS.
'''
        return libnbdmod.set_tls_verify_peer (self._o, verify)

    def get_tls_verify_peer (self):
        '''▶ get whether we verify the identity of the server

    Get the verify peer flag.
'''
        return libnbdmod.get_tls_verify_peer (self._o)

    def set_tls_username (self, username):
        '''▶ set the TLS username

    Set the TLS client username. This is used if
    authenticating with PSK over TLS is enabled. If not set
    then the local username is used.

    This function may be called regardless of whether TLS is
    supported, but will have no effect unless "nbd.set_tls"
    is also used to request or require TLS.
'''
        return libnbdmod.set_tls_username (self._o, username)

    def get_tls_username (self):
        '''▶ get the current TLS username

    Get the current TLS username.
'''
        return libnbdmod.get_tls_username (self._o)

    def set_tls_psk_file (self, filename):
        '''▶ set the TLS Pre-Shared Keys (PSK) filename

    Set the TLS Pre-Shared Keys (PSK) filename. This is used
    if trying to authenticate to the server using with a
    pre-shared key. There is no default so if this is not
    set then PSK authentication cannot be used to connect to
    the server.

    This function may be called regardless of whether TLS is
    supported, but will have no effect unless "nbd.set_tls"
    is also used to request or require TLS.
'''
        return libnbdmod.set_tls_psk_file (self._o, filename)

    def set_request_structured_replies (self, request):
        '''▶ control use of structured replies

    By default, libnbd tries to negotiate structured replies
    with the server, as this protocol extension must be in
    use before "nbd_can_meta_context" or "nbd_can_df" can
    return true. However, for integration testing, it can be
    useful to clear this flag rather than find a way to
    alter the server to fail the negotiation request.
'''
        return libnbdmod.set_request_structured_replies (self._o, request)

    def get_request_structured_replies (self):
        '''▶ see if structured replies are attempted

    Return the state of the request structured replies flag
    on this handle.

    Note: If you want to find out if structured replies were
    actually negotiated on a particular connection use
    "nbd_get_structured_replies_negotiated" instead.
'''
        return libnbdmod.get_request_structured_replies (self._o)

    def get_structured_replies_negotiated (self):
        '''▶ see if structured replies are in use

    After connecting you may call this to find out if the
    connection is using structured replies.
'''
        return libnbdmod.get_structured_replies_negotiated (self._o)

    def set_handshake_flags (self, flags):
        '''▶ control use of handshake flags

    By default, libnbd tries to negotiate all possible
    handshake flags that are also supported by the server;
    since omitting a handshake flag can prevent the use of
    other functionality such as TLS encryption or structured
    replies. However, for integration testing, it can be
    useful to reduce the set of flags supported by the
    client to test that a particular server can handle
    various clients that were compliant to older versions of
    the NBD specification.

    The "flags" argument is a bitmask, including zero or
    more of the following handshake flags:

    "HANDSHAKE_FLAG_FIXED_NEWSTYLE" = 1
        The server gracefully handles unknown option
        requests from the client, rather than disconnecting.
        Without this flag, a client cannot safely request to
        use extensions such as TLS encryption or structured
        replies, as the request may cause an older server to
        drop the connection.

    "HANDSHAKE_FLAG_NO_ZEROES" = 2
        If the client is forced to use "NBD_OPT_EXPORT_NAME"
        instead of the preferred "NBD_OPT_GO", this flag
        allows the server to send fewer all-zero padding
        bytes over the connection.

    Future NBD extensions may add further flags.
'''
        return libnbdmod.set_handshake_flags (self._o, flags)

    def get_handshake_flags (self):
        '''▶ see which handshake flags are supported

    Return the state of the handshake flags on this handle.
    When the handle has not yet completed a connection (see
    "nbd_aio_is_created"), this returns the flags that the
    client is willing to use, provided the server also
    advertises those flags. After the connection is ready
    (see "nbd_aio_is_ready"), this returns the flags that
    were actually agreed on between the server and client.
    If the NBD protocol defines new handshake flags, then
    the return value from a newer library version may
    include bits that were undefined at the time of
    compilation.
'''
        return libnbdmod.get_handshake_flags (self._o)

    def add_meta_context (self, name):
        '''▶ ask server to negotiate metadata context

    During connection libnbd can negotiate zero or more
    metadata contexts with the server. Metadata contexts are
    features (such as "base:allocation") which describe
    information returned by the "nbd.block_status" command
    (for "base:allocation" this is whether blocks of data
    are allocated, zero or sparse).

    This call adds one metadata context to the list to be
    negotiated. You can call it as many times as needed. The
    list is initially empty when the handle is created.

    The NBD protocol limits meta context names to 4096
    bytes, but servers may not support the full length. The
    encoding of meta context names is always UTF-8.

    Not all servers support all metadata contexts. To learn
    if a context was actually negotiated, call
    "nbd.can_meta_context" after connecting.

    The single parameter is the name of the metadata
    context, for example "CONTEXT_BASE_ALLOCATION".
    <libnbd.h> includes defined constants beginning with
    "CONTEXT_" for some well-known contexts, but you are
    free to pass in other contexts.

    Other metadata contexts are server-specific, but include
    "qemu:dirty-bitmap:..." for qemu-nbd (see qemu-nbd *-B*
    option).
'''
        return libnbdmod.add_meta_context (self._o, name)

    def set_uri_allow_transports (self, mask):
        '''▶ set the allowed transports in NBD URIs

    Set which transports are allowed to appear in NBD URIs.
    The default is to allow any transport.

    The "mask" parameter may contain any of the following
    flags ORed together:

    "ALLOW_TRANSPORT_TCP"
    "ALLOW_TRANSPORT_UNIX"
    "ALLOW_TRANSPORT_VSOCK"
'''
        return libnbdmod.set_uri_allow_transports (self._o, mask)

    def set_uri_allow_tls (self, tls):
        '''▶ set the allowed TLS settings in NBD URIs

    Set which TLS settings are allowed to appear in NBD
    URIs. The default is to allow either non-TLS or TLS
    URIs.

    The "tls" parameter can be:

    "TLS_DISABLE"
        TLS URIs are not permitted, ie. a URI such as
        "nbds://..." will be rejected.

    "TLS_ALLOW"
        This is the default. TLS may be used or not,
        depending on whether the URI uses "nbds" or "nbd".

    "TLS_REQUIRE"
        TLS URIs are required. All URIs must use "nbds".
'''
        return libnbdmod.set_uri_allow_tls (self._o, tls)

    def set_uri_allow_local_file (self, allow):
        '''▶ set the allowed transports in NBD URIs

    Allow NBD URIs to reference local files. This is
    *disabled* by default.

    Currently this setting only controls whether the
    "tls-psk-file" parameter in NBD URIs is allowed.
'''
        return libnbdmod.set_uri_allow_local_file (self._o, allow)

    def connect_uri (self, uri):
        '''▶ connect to NBD URI

    Connect (synchronously) to an NBD server and export by
    specifying the NBD URI. This call parses the URI and may
    call "nbd.set_export_name" and "nbd.set_tls" and other
    calls as needed, followed by "nbd.connect_tcp" or
    "nbd.connect_unix". This call returns when the
    connection has been made.

  Example URIs supported
    "nbd://example.com"
        Connect over TCP, unencrypted, to "example.com" port
        10809.

    "nbds://example.com"
        Connect over TCP with TLS, to "example.com" port
        10809. If the server does not support TLS then this
        will fail.

    "nbd+unix:///foo?socket=/tmp/nbd.sock"
        Connect over the Unix domain socket /tmp/nbd.sock to
        an NBD server running locally. The export name is
        set to "foo" (note without any leading "/"
        character).

    "nbd+vsock:///"
        In this scenario libnbd is running in a virtual
        machine. Connect over "AF_VSOCK" to an NBD server
        running on the hypervisor.

  Supported URI formats
    The following schemes are supported in the current
    version of libnbd:

    "nbd:"
        Connect over TCP without using TLS.

    "nbds:"
        Connect over TCP. TLS is required and the connection
        will fail if the server does not support TLS.

    "nbd+unix:"
    "nbds+unix:"
        Connect over a Unix domain socket, without or with
        TLS respectively. The "socket" parameter is
        required.

    "nbd+vsock:"
    "nbds+vsock:"
        Connect over the "AF_VSOCK" transport, without or
        with TLS respectively.

    The authority part of the URI
    ("[username@][servername][:port]") is parsed depending
    on the transport. For TCP it specifies the server to
    connect to and optional port number. For "+unix" it
    should not be present. For "+vsock" the server name is
    the numeric CID (eg. 2 to connect to the host), and the
    optional port number may be present. If the "username"
    is present it is used for TLS authentication.

    For all transports, an export name may be present,
    parsed in accordance with the NBD URI specification.

    Finally the query part of the URI can contain:

    socket=SOCKET
        Specifies the Unix domain socket to connect on. Must
        be present for the "+unix" transport and must not be
        present for the other transports.

    tls-psk-file=PSKFILE
        Set the PSK file. See "nbd.set_tls_psk_file". Note
        this is not allowed by default - see next section.

  Disable URI features
    For security reasons you might want to disable certain
    URI features. Pre-filtering URIs is error-prone and
    should not be attempted. Instead use the libnbd APIs
    below to control what can appear in URIs. Note you must
    call these functions on the same handle before calling
    "nbd_connect_uri" or "nbd.aio_connect_uri".

    TCP, Unix domain socket or "AF_VSOCK" transports
        Default: all allowed

        To select which transports are allowed call
        "nbd.set_uri_allow_transports".

    TLS Default: both non-TLS and TLS connections allowed

        To force TLS off or on in URIs call
        "nbd.set_uri_allow_tls".

    Connect to Unix domain socket in the local filesystem
        Default: allowed

        To prevent this you must disable the "+unix"
        transport using "nbd.set_uri_allow_transports".

    Read from local files
        Default: denied

        To allow URIs to contain references to local files
        (eg. for parameters like "tls-psk-file") call
        "nbd.set_uri_allow_local_file".

  Optional features
    This call will fail if libnbd was not compiled with
    libxml2; you can test whether this is the case with
    "nbd.supports_uri".

    Support for URIs that require TLS will fail if libnbd
    was not compiled with gnutls; you can test whether this
    is the case with "nbd.supports_tls".
'''
        return libnbdmod.connect_uri (self._o, uri)

    def connect_unix (self, unixsocket):
        '''▶ connect to NBD server over a Unix domain socket

    Connect (synchronously) over the named Unix domain
    socket ("unixsocket") to an NBD server running on the
    same machine. This call returns when the connection has
    been made.
'''
        return libnbdmod.connect_unix (self._o, unixsocket)

    def connect_vsock (self, cid, port):
        '''▶ connect to NBD server over AF_VSOCK protocol

    Connect (synchronously) over the "AF_VSOCK" protocol
    from a virtual machine to an NBD server, usually running
    on the host. The "cid" and "port" parameters specify the
    server address. Usually "cid" should be 2 (to connect to
    the host), and "port" might be 10809 or another port
    number assigned to you by the host administrator. This
    call returns when the connection has been made.
'''
        return libnbdmod.connect_vsock (self._o, cid, port)

    def connect_tcp (self, hostname, port):
        '''▶ connect to NBD server over a TCP port

    Connect (synchronously) to the NBD server listening on
    "hostname:port". The "port" may be a port name such as
    "nbd", or it may be a port number as a string such as
    "10809". This call returns when the connection has been
    made.
'''
        return libnbdmod.connect_tcp (self._o, hostname, port)

    def connect_socket (self, sock):
        '''▶ connect directly to a connected socket

    Pass a connected socket (file descriptor) which libnbd
    will talk to. The program is responsible for connecting
    this somehow to an NBD server. Once the socket is passed
    to libnbd it is the responsibility of libnbd. Libnbd may
    read and write to it, set it to non-blocking, etc., and
    will finally close it when the handle is closed. The
    program must no longer use the socket.
'''
        return libnbdmod.connect_socket (self._o, sock)

    def connect_command (self, argv):
        '''▶ connect to NBD server command

    Run the command as a subprocess and connect to it over
    stdin/stdout. This is for use with NBD servers which can
    behave like inetd clients, such as "nbdkit --single".

  Subprocess
    Libnbd will fork the "argv" command and pass the NBD
    socket to it using file descriptors 0 and 1
    (stdin/stdout):

     ┌─────────┬─────────┐    ┌────────────────┐
     │ program │ libnbd  │    │   NBD server   │
     │         │         │    │       (argv)   │
     │         │ socket ╍╍╍╍╍╍╍╍▶ stdin/stdout │
     └─────────┴─────────┘    └────────────────┘

    When the NBD handle is closed the server subprocess is
    killed.
'''
        return libnbdmod.connect_command (self._o, argv)

    def connect_systemd_socket_activation (self, argv):
        '''▶ connect using systemd socket activation

    Run the command as a subprocess and connect to it using
    systemd socket activation.

    This is especially useful for running qemu-nbd(1) as a
    subprocess of libnbd, for example to use it to open
    qcow2 files. To run nbdkit as a subprocess it is usually
    better to use "nbd.connect_command".

  Socket activation
    Libnbd will fork the "argv" command and pass an NBD
    socket to it using special "LISTEN_*" environment
    variables (as defined by the systemd socket activation
    protocol).

     ┌─────────┬─────────┐    ┌───────────────┐
     │ program │ libnbd  │    │  qemu-nbd or  │
     │         │         │    │  other server │
     │         │ socket ╍╍╍╍╍╍╍╍▶             │
     └─────────┴─────────┘    └───────────────┘

    When the NBD handle is closed the server subprocess is
    killed.
'''
        return libnbdmod.connect_systemd_socket_activation (self._o, argv)

    def is_read_only (self):
        '''▶ is the NBD export read-only?

    Returns true if the NBD export is read-only; writes and
    write-like operations will fail.

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.is_read_only (self._o)

    def can_flush (self):
        '''▶ does the server support the flush command?

    Returns true if the server supports the flush command
    (see "nbd.flush", "nbd.aio_flush"). Returns false if the
    server does not.

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.can_flush (self._o)

    def can_fua (self):
        '''▶ does the server support the FUA flag?

    Returns true if the server supports the FUA flag on
    certain commands (see "nbd.pwrite").

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.can_fua (self._o)

    def is_rotational (self):
        '''▶ is the NBD disk rotational (like a disk)?

    Returns true if the disk exposed over NBD is rotational
    (like a traditional floppy or hard disk). Returns false
    if the disk has no penalty for random access (like an
    SSD or RAM disk).

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.is_rotational (self._o)

    def can_trim (self):
        '''▶ does the server support the trim command?

    Returns true if the server supports the trim command
    (see "nbd.trim", "nbd.aio_trim"). Returns false if the
    server does not.

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.can_trim (self._o)

    def can_zero (self):
        '''▶ does the server support the zero command?

    Returns true if the server supports the zero command
    (see "nbd.zero", "nbd.aio_zero"). Returns false if the
    server does not.

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.can_zero (self._o)

    def can_fast_zero (self):
        '''▶ does the server support the fast zero flag?

    Returns true if the server supports the use of the
    "CMD_FLAG_FAST_ZERO" flag to the zero command (see
    "nbd_zero", "nbd_aio_zero"). Returns false if the server
    does not.

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.can_fast_zero (self._o)

    def can_df (self):
        '''▶ does the server support the don't fragment flag to pread?

    Returns true if the server supports structured reads
    with an ability to request a non-fragmented read (see
    "nbd.pread_structured", "nbd.aio_pread_structured").
    Returns false if the server either lacks structured
    reads or if it does not support a non-fragmented read
    request.

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.can_df (self._o)

    def can_multi_conn (self):
        '''▶ does the server support multi-conn?

    Returns true if the server supports multi-conn. Returns
    false if the server does not.

    It is not safe to open multiple handles connecting to
    the same server if you will write to the server and the
    server does not advertise multi-conn support. The safe
    way to check for this is to open one connection, check
    this flag is true, then open further connections as
    required.

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.can_multi_conn (self._o)

    def can_cache (self):
        '''▶ does the server support the cache command?

    Returns true if the server supports the cache command
    (see "nbd.cache", "nbd.aio_cache"). Returns false if the
    server does not.

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.can_cache (self._o)

    def can_meta_context (self, metacontext):
        '''▶ does the server support a specific meta context?

    Returns true if the server supports the given meta
    context (see "nbd.add_meta_context"). Returns false if
    the server does not.

    The single parameter is the name of the metadata
    context, for example "CONTEXT_BASE_ALLOCATION".
    <libnbd.h> includes defined constants for well-known
    namespace contexts beginning with "CONTEXT_", but you
    are free to pass in other contexts.

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.can_meta_context (self._o, metacontext)

    def get_protocol (self):
        '''▶ return the NBD protocol variant

    Return the NBD protocol variant in use on the
    connection. At the moment this returns one of the
    strings "oldstyle", "newstyle" or "newstyle-fixed".
    Other strings might be returned in the future. Most
    modern NBD servers use "newstyle-fixed".

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.get_protocol (self._o)

    def get_size (self):
        '''▶ return the export size

    Returns the size in bytes of the NBD export.

    This call does not block, because it returns data that
    is saved in the handle from the NBD protocol handshake.
'''
        return libnbdmod.get_size (self._o)

    def pread (self, count, offset, flags=0):
        '''▶ read from the NBD server

    Issue a read command to the NBD server for the range
    starting at "offset" and ending at "offset" + "count" -
    1. NBD can only read all or nothing using this call. The
    call returns when the data has been read fully into
    "buf" or there is an error. See also
    "nbd.pread_structured", if finer visibility is required
    into the server's replies, or if you want to use
    "CMD_FLAG_DF".

    The "flags" parameter must be 0 for now (it exists for
    future NBD protocol extensions).
'''
        return libnbdmod.pread (self._o, count, offset, flags)

    def pread_structured (self, count, offset, chunk, flags=0):
        '''▶ read from the NBD server

    Issue a read command to the NBD server for the range
    starting at "offset" and ending at "offset" + "count" -
    1. The server's response may be subdivided into chunks
    which may arrive out of order before reassembly into the
    original buffer; the "chunk" callback is used for
    notification after each chunk arrives, and may perform
    additional sanity checking on the server's reply. The
    callback cannot call "nbd_*" APIs on the same handle
    since it holds the handle lock and will cause a
    deadlock. If the callback returns -1, and no earlier
    error has been detected, then the overall read command
    will fail with any non-zero value stored into the
    callback's "error" parameter (with a default of
    "EPROTO"); but any further chunks will still invoke the
    callback.

    The "chunk" function is called once per chunk of data
    received, with the "user_data" passed to this function.
    The "subbuf" and "count" parameters represent the subset
    of the original buffer which has just been populated by
    results from the server (in C, "subbuf" always points
    within the original "buf"; but this guarantee may not
    extend to other language bindings). The "offset"
    parameter represents the absolute offset at which
    "subbuf" begins within the image (note that this is not
    the relative offset of "subbuf" within the original
    buffer "buf"). Changes to "error" on output are ignored
    unless the callback fails. The input meaning of the
    "error" parameter is controlled by the "status"
    parameter, which is one of

    "READ_DATA" = 1
        "subbuf" was populated with "count" bytes of data.
        On input, "error" contains the errno value of any
        earlier detected error, or zero.

    "READ_HOLE" = 2
        "subbuf" represents a hole, and contains "count" NUL
        bytes. On input, "error" contains the errno value of
        any earlier detected error, or zero.

    "READ_ERROR" = 3
        "count" is 0, so "subbuf" is unusable. On input,
        "error" contains the errno value reported by the
        server as occurring while reading that "offset",
        regardless if any earlier error has been detected.

    Future NBD extensions may permit other values for
    "status", but those will not be returned to a client
    that has not opted in to requesting such extensions. If
    the server is non-compliant, it is possible for the
    "chunk" function to be called more times than you expect
    or with "count" 0 for "READ_DATA" or "READ_HOLE". It is
    also possible that the "chunk" function is not called at
    all (in particular, "READ_ERROR" is used only when an
    error is associated with a particular offset, and not
    when the server reports a generic error), but you are
    guaranteed that the callback was called at least once if
    the overall read succeeds. Libnbd does not validate that
    the server obeyed the requirement that a read call must
    not have overlapping chunks and must not succeed without
    enough chunks to cover the entire request.

    The "flags" parameter may be 0 for no flags, or may
    contain "CMD_FLAG_DF" meaning that the server should not
    reply with more than one fragment (if that is supported
    - some servers cannot do this, see "nbd.can_df"). Libnbd
    does not validate that the server actually obeys the
    flag.
'''
        return libnbdmod.pread_structured (self._o, count, offset, chunk, flags)

    def pwrite (self, buf, offset, flags=0):
        '''▶ write to the NBD server

    Issue a write command to the NBD server, writing the
    data in "buf" to the range starting at "offset" and
    ending at "offset" + "count" - 1. NBD can only write all
    or nothing using this call. The call returns when the
    command has been acknowledged by the server, or there is
    an error.

    The "flags" parameter may be 0 for no flags, or may
    contain "CMD_FLAG_FUA" meaning that the server should
    not return until the data has been committed to
    permanent storage (if that is supported - some servers
    cannot do this, see "nbd.can_fua").
'''
        return libnbdmod.pwrite (self._o, buf, offset, flags)

    def shutdown (self, flags=0):
        '''▶ disconnect from the NBD server

    Issue the disconnect command to the NBD server. This is
    a nice way to tell the server we are going away, but
    from the client's point of view has no advantage over
    abruptly closing the connection (see "nbd.close").

    This function works whether or not the handle is ready
    for transmission of commands, and as such does not take
    a "flags" parameter. If more fine-grained control is
    needed, see "nbd.aio_disconnect".

    The "flags" parameter must be 0 for now (it exists for
    future NBD protocol extensions).
'''
        return libnbdmod.shutdown (self._o, flags)

    def flush (self, flags=0):
        '''▶ send flush command to the NBD server

    Issue the flush command to the NBD server. The function
    should return when all write commands which have
    completed have been committed to permanent storage on
    the server. Note this will return an error if
    "nbd.can_flush" is false.

    The "flags" parameter must be 0 for now (it exists for
    future NBD protocol extensions).
'''
        return libnbdmod.flush (self._o, flags)

    def trim (self, count, offset, flags=0):
        '''▶ send trim command to the NBD server

    Issue a trim command to the NBD server, which if
    supported by the server causes a hole to be punched in
    the backing store starting at "offset" and ending at
    "offset" + "count" - 1. The call returns when the
    command has been acknowledged by the server, or there is
    an error.

    The "flags" parameter may be 0 for no flags, or may
    contain "CMD_FLAG_FUA" meaning that the server should
    not return until the data has been committed to
    permanent storage (if that is supported - some servers
    cannot do this, see "nbd.can_fua").
'''
        return libnbdmod.trim (self._o, count, offset, flags)

    def cache (self, count, offset, flags=0):
        '''▶ send cache (prefetch) command to the NBD server

    Issue the cache (prefetch) command to the NBD server,
    which if supported by the server causes data to be
    prefetched into faster storage by the server, speeding
    up a subsequent "nbd.pread" call. The server can also
    silently ignore this command. Note this will return an
    error if "nbd.can_cache" is false.

    The "flags" parameter must be 0 for now (it exists for
    future NBD protocol extensions).
'''
        return libnbdmod.cache (self._o, count, offset, flags)

    def zero (self, count, offset, flags=0):
        '''▶ send write zeroes command to the NBD server

    Issue a write zeroes command to the NBD server, which if
    supported by the server causes a zeroes to be written
    efficiently starting at "offset" and ending at "offset"
    + "count" - 1. The call returns when the command has
    been acknowledged by the server, or there is an error.

    The "flags" parameter may be 0 for no flags, or may
    contain "CMD_FLAG_FUA" meaning that the server should
    not return until the data has been committed to
    permanent storage (if that is supported - some servers
    cannot do this, see "nbd.can_fua"), "CMD_FLAG_NO_HOLE"
    meaning that the server should favor writing actual
    allocated zeroes over punching a hole, and/or
    "CMD_FLAG_FAST_ZERO" meaning that the server must fail
    quickly if writing zeroes is no faster than a normal
    write (if that is supported - some servers cannot do
    this, see "nbd.can_fast_zero").
'''
        return libnbdmod.zero (self._o, count, offset, flags)

    def block_status (self, count, offset, extent, flags=0):
        '''▶ send block status command to the NBD server

    Issue the block status command to the NBD server. If
    supported by the server, this causes metadata context
    information about blocks beginning from the specified
    offset to be returned. The "count" parameter is a hint:
    the server may choose to return less status, or the
    final block may extend beyond the requested range. If
    multiple contexts are supported, the number of blocks
    and cumulative length of those blocks need not be
    identical between contexts.

    Depending on which metadata contexts were enabled before
    connecting (see "nbd.add_meta_context") and which are
    supported by the server (see "nbd.can_meta_context")
    this call returns information about extents by calling
    back to the "extent" function. The callback cannot call
    "nbd_*" APIs on the same handle since it holds the
    handle lock and will cause a deadlock. If the callback
    returns -1, and no earlier error has been detected, then
    the overall block status command will fail with any
    non-zero value stored into the callback's "error"
    parameter (with a default of "EPROTO"); but any further
    contexts will still invoke the callback.

    The "extent" function is called once per type of
    metadata available, with the "user_data" passed to this
    function. The "metacontext" parameter is a string such
    as "base:allocation". The "entries" array is an array of
    pairs of integers with the first entry in each pair
    being the length (in bytes) of the block and the second
    entry being a status/flags field which is specific to
    the metadata context. (The number of pairs passed to the
    function is "nr_entries/2".) The NBD protocol document
    in the section about "NBD_REPLY_TYPE_BLOCK_STATUS"
    describes the meaning of this array; for contexts known
    to libnbd, <libnbd.h> contains constants beginning with
    "STATE_" that may help decipher the values. On entry to
    the callback, the "error" parameter contains the errno
    value of any previously detected error.

    It is possible for the extent function to be called more
    times than you expect (if the server is buggy), so
    always check the "metacontext" field to ensure you are
    receiving the data you expect. It is also possible that
    the extent function is not called at all, even for
    metadata contexts that you requested. This indicates
    either that the server doesn't support the context or
    for some other reason cannot return the data.

    The "flags" parameter may be 0 for no flags, or may
    contain "CMD_FLAG_REQ_ONE" meaning that the server
    should return only one extent per metadata context where
    that extent does not exceed "count" bytes; however,
    libnbd does not validate that the server obeyed the
    flag.
'''
        return libnbdmod.block_status (self._o, count, offset, extent, flags)

    def poll (self, timeout):
        '''▶ poll the handle once

    This is a simple implementation of poll(2) which is used
    internally by synchronous API calls. On success, it
    returns 0 if the "timeout" (in milliseconds) occurs, or
    1 if the poll completed and the state machine
    progressed. Set "timeout" to -1 to block indefinitely
    (but be careful that eventual action is actually
    expected - for example, if the connection is established
    but there are no commands in flight, using an infinite
    timeout will permanently block).

    This function is mainly useful as an example of how you
    might integrate libnbd with your own main loop, rather
    than being intended as something you would use.
'''
        return libnbdmod.poll (self._o, timeout)

    def aio_connect (self, addr):
        '''▶ connect to the NBD server

    Begin connecting to the NBD server. The "addr" and
    "addrlen" parameters specify the address of the socket
    to connect to.

    You can check if the connection is still connecting by
    calling "nbd.aio_is_connecting", or if it has connected
    to the server and completed the NBD handshake by calling
    "nbd.aio_is_ready", on the connection.
'''
        return libnbdmod.aio_connect (self._o, addr)

    def aio_connect_uri (self, uri):
        '''▶ connect to an NBD URI

    Begin connecting to the NBD URI "uri". Parameters behave
    as documented in "nbd.connect_uri".

    You can check if the connection is still connecting by
    calling "nbd.aio_is_connecting", or if it has connected
    to the server and completed the NBD handshake by calling
    "nbd.aio_is_ready", on the connection.
'''
        return libnbdmod.aio_connect_uri (self._o, uri)

    def aio_connect_unix (self, unixsocket):
        '''▶ connect to the NBD server over a Unix domain socket

    Begin connecting to the NBD server over Unix domain
    socket ("unixsocket"). Parameters behave as documented
    in "nbd.connect_unix".

    You can check if the connection is still connecting by
    calling "nbd.aio_is_connecting", or if it has connected
    to the server and completed the NBD handshake by calling
    "nbd.aio_is_ready", on the connection.
'''
        return libnbdmod.aio_connect_unix (self._o, unixsocket)

    def aio_connect_vsock (self, cid, port):
        '''▶ connect to the NBD server over AF_VSOCK socket

    Begin connecting to the NBD server over the "AF_VSOCK"
    protocol to the server "cid:port". Parameters behave as
    documented in "nbd.connect_vsock".

    You can check if the connection is still connecting by
    calling "nbd.aio_is_connecting", or if it has connected
    to the server and completed the NBD handshake by calling
    "nbd.aio_is_ready", on the connection.
'''
        return libnbdmod.aio_connect_vsock (self._o, cid, port)

    def aio_connect_tcp (self, hostname, port):
        '''▶ connect to the NBD server over a TCP port

    Begin connecting to the NBD server listening on
    "hostname:port". Parameters behave as documented in
    "nbd.connect_tcp".

    You can check if the connection is still connecting by
    calling "nbd.aio_is_connecting", or if it has connected
    to the server and completed the NBD handshake by calling
    "nbd.aio_is_ready", on the connection.
'''
        return libnbdmod.aio_connect_tcp (self._o, hostname, port)

    def aio_connect_socket (self, sock):
        '''▶ connect directly to a connected socket

    Begin connecting to the connected socket "fd".
    Parameters behave as documented in "nbd.connect_socket".

    You can check if the connection is still connecting by
    calling "nbd.aio_is_connecting", or if it has connected
    to the server and completed the NBD handshake by calling
    "nbd.aio_is_ready", on the connection.
'''
        return libnbdmod.aio_connect_socket (self._o, sock)

    def aio_connect_command (self, argv):
        '''▶ connect to the NBD server

    Run the command as a subprocess and begin connecting to
    it over stdin/stdout. Parameters behave as documented in
    "nbd.connect_command".

    You can check if the connection is still connecting by
    calling "nbd.aio_is_connecting", or if it has connected
    to the server and completed the NBD handshake by calling
    "nbd.aio_is_ready", on the connection.
'''
        return libnbdmod.aio_connect_command (self._o, argv)

    def aio_connect_systemd_socket_activation (self, argv):
        '''▶ connect using systemd socket activation

    Run the command as a subprocess and begin connecting to
    it using systemd socket activation. Parameters behave as
    documented in "nbd.connect_systemd_socket_activation".

    You can check if the connection is still connecting by
    calling "nbd.aio_is_connecting", or if it has connected
    to the server and completed the NBD handshake by calling
    "nbd.aio_is_ready", on the connection.
'''
        return libnbdmod.aio_connect_systemd_socket_activation (self._o, argv)

    def aio_pread (self, buf, offset, completion=None, flags=0):
        '''▶ read from the NBD server

    Issue a read command to the NBD server.

    To check if the command completed, call
    "nbd.aio_command_completed". Or supply the optional
    "completion_callback" which will be invoked as described
    in "Completion callbacks" in libnbd(3).

    Note that you must ensure "buf" is valid until the
    command has completed. Other parameters behave as
    documented in "nbd.pread".
'''
        return libnbdmod.aio_pread (self._o, buf._o, offset, completion, flags)

    def aio_pread_structured (self, buf, offset, chunk, completion=None, flags=0):
        '''▶ read from the NBD server

    Issue a read command to the NBD server.

    To check if the command completed, call
    "nbd.aio_command_completed". Or supply the optional
    "completion_callback" which will be invoked as described
    in "Completion callbacks" in libnbd(3).

    Other parameters behave as documented in
    "nbd.pread_structured".
'''
        return libnbdmod.aio_pread_structured (self._o, buf._o, offset, chunk, completion, flags)

    def aio_pwrite (self, buf, offset, completion=None, flags=0):
        '''▶ write to the NBD server

    Issue a write command to the NBD server.

    To check if the command completed, call
    "nbd.aio_command_completed". Or supply the optional
    "completion_callback" which will be invoked as described
    in "Completion callbacks" in libnbd(3).

    Note that you must ensure "buf" is valid until the
    command has completed. Other parameters behave as
    documented in "nbd.pwrite".
'''
        return libnbdmod.aio_pwrite (self._o, buf._o, offset, completion, flags)

    def aio_disconnect (self, flags=0):
        '''▶ disconnect from the NBD server

    Issue the disconnect command to the NBD server. This is
    not a normal command because NBD servers are not obliged
    to send a reply. Instead you should wait for
    "nbd.aio_is_closed" to become true on the connection.
    Once this command is issued, you cannot issue any
    further commands.

    Although libnbd does not prevent you from issuing this
    command while still waiting on the replies to previous
    commands, the NBD protocol recommends that you wait
    until there are no other commands in flight (see
    "nbd.aio_in_flight"), to give the server a better chance
    at a clean shutdown.

    The "flags" parameter must be 0 for now (it exists for
    future NBD protocol extensions). There is no direct
    synchronous counterpart; however, "nbd.shutdown" will
    call this function if appropriate.
'''
        return libnbdmod.aio_disconnect (self._o, flags)

    def aio_flush (self, completion=None, flags=0):
        '''▶ send flush command to the NBD server

    Issue the flush command to the NBD server.

    To check if the command completed, call
    "nbd.aio_command_completed". Or supply the optional
    "completion_callback" which will be invoked as described
    in "Completion callbacks" in libnbd(3).

    Other parameters behave as documented in "nbd.flush".
'''
        return libnbdmod.aio_flush (self._o, completion, flags)

    def aio_trim (self, count, offset, completion=None, flags=0):
        '''▶ send trim command to the NBD server

    Issue a trim command to the NBD server.

    To check if the command completed, call
    "nbd.aio_command_completed". Or supply the optional
    "completion_callback" which will be invoked as described
    in "Completion callbacks" in libnbd(3).

    Other parameters behave as documented in "nbd.trim".
'''
        return libnbdmod.aio_trim (self._o, count, offset, completion, flags)

    def aio_cache (self, count, offset, completion=None, flags=0):
        '''▶ send cache (prefetch) command to the NBD server

    Issue the cache (prefetch) command to the NBD server.

    To check if the command completed, call
    "nbd.aio_command_completed". Or supply the optional
    "completion_callback" which will be invoked as described
    in "Completion callbacks" in libnbd(3).

    Other parameters behave as documented in "nbd.cache".
'''
        return libnbdmod.aio_cache (self._o, count, offset, completion, flags)

    def aio_zero (self, count, offset, completion=None, flags=0):
        '''▶ send write zeroes command to the NBD server

    Issue a write zeroes command to the NBD server.

    To check if the command completed, call
    "nbd.aio_command_completed". Or supply the optional
    "completion_callback" which will be invoked as described
    in "Completion callbacks" in libnbd(3).

    Other parameters behave as documented in "nbd.zero".
'''
        return libnbdmod.aio_zero (self._o, count, offset, completion, flags)

    def aio_block_status (self, count, offset, extent, completion=None, flags=0):
        '''▶ send block status command to the NBD server

    Send the block status command to the NBD server.

    To check if the command completed, call
    "nbd.aio_command_completed". Or supply the optional
    "completion_callback" which will be invoked as described
    in "Completion callbacks" in libnbd(3).

    Other parameters behave as documented in
    "nbd.block_status".
'''
        return libnbdmod.aio_block_status (self._o, count, offset, extent, completion, flags)

    def aio_get_fd (self):
        '''▶ return file descriptor associated with this connection

    Return the underlying file descriptor associated with
    this connection. You can use this to check if the file
    descriptor is ready for reading or writing and call
    "nbd.aio_notify_read" or "nbd.aio_notify_write". See
    also "nbd.aio_get_direction". Do not do anything else
    with the file descriptor.
'''
        return libnbdmod.aio_get_fd (self._o)

    def aio_get_direction (self):
        '''▶ return the read or write direction

    Return the current direction of this connection, which
    means whether we are next expecting to read data from
    the server, write data to the server, or both. It
    returns

    0   We are not expected to interact with the server file
        descriptor from the current state. It is not worth
        attempting to use poll(2); if the connection is not
        dead, then state machine progress must instead come
        from some other means such as "nbd.aio_connect".

    "AIO_DIRECTION_READ" = 1
        We are expected next to read from the server. If
        using poll(2) you would set "events = POLLIN". If
        "revents" returns "POLLIN" or "POLLHUP" you would
        then call "nbd.aio_notify_read".

        Note that once libnbd reaches "nbd.aio_is_ready",
        this direction is returned even when there are no
        commands in flight (see "nbd.aio_in_flight"). In a
        single-threaded use of libnbd, it is not worth
        polling until after issuing a command, as otherwise
        the server will never wake up the poll. In a
        multi-threaded scenario, you can have one thread
        begin a polling loop prior to any commands, but any
        other thread that issues a command will need a way
        to kick the polling thread out of poll in case
        issuing the command changes the needed polling
        direction. Possible ways to do this include polling
        for activity on a pipe-to-self, or using
        pthread_kill(3) to send a signal that is masked
        except during ppoll(2).

    "AIO_DIRECTION_WRITE" = 2
        We are expected next to write to the server. If
        using poll(2) you would set "events = POLLOUT". If
        "revents" returns "POLLOUT" you would then call
        "nbd.aio_notify_write".

    "AIO_DIRECTION_BOTH" = 3
        We are expected next to either read or write to the
        server. If using poll(2) you would set "events =
        POLLIN|POLLOUT". If only one of "POLLIN" or
        "POLLOUT" is returned, then see above. However, if
        both are returned, it is better to call only
        "nbd.aio_notify_read", as processing the server's
        reply may change the state of the connection and
        invalidate the need to write more commands.
'''
        return libnbdmod.aio_get_direction (self._o)

    def aio_notify_read (self):
        '''▶ notify that the connection is readable

    Send notification to the state machine that the
    connection is readable. Typically this is called after
    your main loop has detected that the file descriptor
    associated with this connection is readable.
'''
        return libnbdmod.aio_notify_read (self._o)

    def aio_notify_write (self):
        '''▶ notify that the connection is writable

    Send notification to the state machine that the
    connection is writable. Typically this is called after
    your main loop has detected that the file descriptor
    associated with this connection is writable.
'''
        return libnbdmod.aio_notify_write (self._o)

    def aio_is_created (self):
        '''▶ check if the connection has just been created

    Return true if this connection has just been created.
    This is the state before the handle has started
    connecting to a server. In this state the handle can
    start to be connected by calling functions such as
    "nbd.aio_connect".
'''
        return libnbdmod.aio_is_created (self._o)

    def aio_is_connecting (self):
        '''▶ check if the connection is connecting or handshaking

    Return true if this connection is connecting to the
    server or in the process of handshaking and negotiating
    options which happens before the handle becomes ready to
    issue commands (see "nbd.aio_is_ready").
'''
        return libnbdmod.aio_is_connecting (self._o)

    def aio_is_ready (self):
        '''▶ check if the connection is in the ready state

    Return true if this connection is connected to the NBD
    server, the handshake has completed, and the connection
    is idle or waiting for a reply. In this state the handle
    is ready to issue commands.
'''
        return libnbdmod.aio_is_ready (self._o)

    def aio_is_processing (self):
        '''▶ check if the connection is processing a command

    Return true if this connection is connected to the NBD
    server, the handshake has completed, and the connection
    is processing commands (either writing out a request or
    reading a reply).

    Note the ready state ("nbd.aio_is_ready") is not
    included. In the ready state commands may be *in flight*
    (the *server* is processing them), but libnbd is not
    processing them.
'''
        return libnbdmod.aio_is_processing (self._o)

    def aio_is_dead (self):
        '''▶ check if the connection is dead

    Return true if the connection has encountered a fatal
    error and is dead. In this state the handle may only be
    closed. There is no way to recover a handle from the
    dead state.
'''
        return libnbdmod.aio_is_dead (self._o)

    def aio_is_closed (self):
        '''▶ check if the connection is closed

    Return true if the connection has closed. There is no
    way to reconnect a closed connection. Instead you must
    close the whole handle.
'''
        return libnbdmod.aio_is_closed (self._o)

    def aio_command_completed (self, cookie):
        '''▶ check if the command completed

    Return true if the command completed. If this function
    returns true then the command was successful and it has
    been retired. Return false if the command is still in
    flight. This can also fail with an error in case the
    command failed (in this case the command is also
    retired). A command is retired either via this command,
    or by using a completion callback which returns 1.

    The "cookie" parameter is the positive unique 64 bit
    cookie for the command, as returned by a call such as
    "nbd.aio_pread".
'''
        return libnbdmod.aio_command_completed (self._o, cookie)

    def aio_peek_command_completed (self):
        '''▶ check if any command has completed

    Return the unique positive 64 bit cookie of the first
    non-retired but completed command, 0 if there are
    in-flight commands but none of them are awaiting
    retirement, or -1 on error including when there are no
    in-flight commands. Any cookie returned by this function
    must still be passed to "nbd.aio_command_completed" to
    actually retire the command and learn whether the
    command was successful.
'''
        return libnbdmod.aio_peek_command_completed (self._o)

    def aio_in_flight (self):
        '''▶ check how many aio commands are still in flight

    Return the number of in-flight aio commands that are
    still awaiting a response from the server before they
    can be retired. If this returns a non-zero value when
    requesting a disconnect from the server (see
    "nbd.aio_disconnect" and "nbd.shutdown"), libnbd does
    not try to wait for those commands to complete
    gracefully; if the server strands commands while
    shutting down, "nbd.aio_command_completed" will report
    those commands as failed with a status of "ENOTCONN".
'''
        return libnbdmod.aio_in_flight (self._o)

    def connection_state (self):
        '''▶ return string describing the state of the connection

    Returns a descriptive string for the state of the
    connection. This can be used for debugging or
    troubleshooting, but you should not rely on the state of
    connections since it may change in future versions.
'''
        return libnbdmod.connection_state (self._o)

    def get_package_name (self):
        '''▶ return the name of the library

    Returns the name of the library, always "libnbd" unless
    the library was modified with another name at compile
    time.
'''
        return libnbdmod.get_package_name (self._o)

    def get_version (self):
        '''▶ return the version of the library

    Return the version of libnbd. This is returned as a
    string in the form "major.minor.release" where each of
    major, minor and release is a small positive integer.
    For example:

         minor
           ↓
        "1.0.3"
         ↑   ↑
     major   release

    major = 0
        The major number was 0 for the early experimental
        versions of libnbd where we still had an unstable
        API.

    major = 1
        The major number is 1 for the versions of libnbd
        with a long-term stable API and ABI. It is not
        anticipated that major will be any number other than
        1.

    minor = 0, 2, ... (even)
        The minor number is even for stable releases.

    minor = 1, 3, ... (odd)
        The minor number is odd for development versions.
        Note that new APIs added in a development version
        remain experimental and subject to change in that
        branch until they appear in a stable release.

    release
        The release number is incremented for each release
        along a particular branch.
'''
        return libnbdmod.get_version (self._o)

    def kill_subprocess (self, signum):
        '''▶ kill server running as a subprocess

    This call may be used to kill the server running as a
    subprocess that was previously created using
    "nbd.connect_command". You do not need to use this call.
    It is only needed if the server does not exit when the
    socket is closed.

    The "signum" parameter is the optional signal number to
    send (see signal(7)). If "signum" is 0 then "SIGTERM" is
    sent.
'''
        return libnbdmod.kill_subprocess (self._o, signum)

    def supports_tls (self):
        '''▶ true if libnbd was compiled with support for TLS

    Returns true if libnbd was compiled with gnutls which is
    required to support TLS encryption, or false if not.
'''
        return libnbdmod.supports_tls (self._o)

    def supports_uri (self):
        '''▶ true if libnbd was compiled with support for NBD URIs

    Returns true if libnbd was compiled with libxml2 which
    is required to support NBD URIs, or false if not.
'''
        return libnbdmod.supports_uri (self._o)

package_name = NBD().get_package_name()
__version__ = NBD().get_version()

if __name__ == "__main__":
    import nbdsh

    nbdsh.shell()
