/* text-bigram-language-model.c generated by valac 0.20.1.19-a6516, the Vala compiler
 * generated from text-bigram-language-model.vala, do not modify */

/*
 * Copyright (C) 2012-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2012-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define KKC_TYPE_LANGUAGE_MODEL (kkc_language_model_get_type ())
#define KKC_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel))
#define KKC_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))
#define KKC_IS_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_IS_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))

typedef struct _KkcLanguageModel KkcLanguageModel;
typedef struct _KkcLanguageModelClass KkcLanguageModelClass;
typedef struct _KkcLanguageModelPrivate KkcLanguageModelPrivate;

#define KKC_TYPE_LANGUAGE_MODEL_ENTRY (kkc_language_model_entry_get_type ())
typedef struct _KkcLanguageModelEntry KkcLanguageModelEntry;

#define KKC_TYPE_UNIGRAM_LANGUAGE_MODEL (kkc_unigram_language_model_get_type ())
#define KKC_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModel))
#define KKC_IS_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL))
#define KKC_UNIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModelIface))

typedef struct _KkcUnigramLanguageModel KkcUnigramLanguageModel;
typedef struct _KkcUnigramLanguageModelIface KkcUnigramLanguageModelIface;

#define KKC_TYPE_BIGRAM_LANGUAGE_MODEL (kkc_bigram_language_model_get_type ())
#define KKC_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModel))
#define KKC_IS_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL))
#define KKC_BIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModelIface))

typedef struct _KkcBigramLanguageModel KkcBigramLanguageModel;
typedef struct _KkcBigramLanguageModelIface KkcBigramLanguageModelIface;

#define KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL (kkc_text_bigram_language_model_get_type ())
#define KKC_TEXT_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModel))
#define KKC_TEXT_BIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModelClass))
#define KKC_IS_TEXT_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL))
#define KKC_IS_TEXT_BIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL))
#define KKC_TEXT_BIGRAM_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModelClass))

typedef struct _KkcTextBigramLanguageModel KkcTextBigramLanguageModel;
typedef struct _KkcTextBigramLanguageModelClass KkcTextBigramLanguageModelClass;
typedef struct _KkcTextBigramLanguageModelPrivate KkcTextBigramLanguageModelPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define KKC_TYPE_METADATA_FILE (kkc_metadata_file_get_type ())
#define KKC_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFile))
#define KKC_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))
#define KKC_IS_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_METADATA_FILE))
#define KKC_IS_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_METADATA_FILE))
#define KKC_METADATA_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))

typedef struct _KkcMetadataFile KkcMetadataFile;
typedef struct _KkcMetadataFileClass KkcMetadataFileClass;

#define KKC_TYPE_LANGUAGE_MODEL_METADATA (kkc_language_model_metadata_get_type ())
#define KKC_LANGUAGE_MODEL_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadata))
#define KKC_LANGUAGE_MODEL_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadataClass))
#define KKC_IS_LANGUAGE_MODEL_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA))
#define KKC_IS_LANGUAGE_MODEL_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL_METADATA))
#define KKC_LANGUAGE_MODEL_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadataClass))

typedef struct _KkcLanguageModelMetadata KkcLanguageModelMetadata;
typedef struct _KkcLanguageModelMetadataClass KkcLanguageModelMetadataClass;

struct _KkcLanguageModelEntry {
	gchar* input;
	gchar* output;
	guint id;
};

struct _KkcLanguageModel {
	GObject parent_instance;
	KkcLanguageModelPrivate * priv;
};

struct _KkcLanguageModelClass {
	GObjectClass parent_class;
	GeeCollection* (*unigram_entries) (KkcLanguageModel* self, const gchar* input);
	GeeCollection* (*entries) (KkcLanguageModel* self, const gchar* input);
	KkcLanguageModelEntry* (*get) (KkcLanguageModel* self, const gchar* input, const gchar* output);
	gboolean (*parse) (KkcLanguageModel* self, GError** error);
	void (*get_bos) (KkcLanguageModel* self, KkcLanguageModelEntry* result);
	void (*get_eos) (KkcLanguageModel* self, KkcLanguageModelEntry* result);
};

struct _KkcUnigramLanguageModelIface {
	GTypeInterface parent_iface;
	gdouble (*unigram_cost) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
	gdouble (*unigram_backoff) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
};

struct _KkcBigramLanguageModelIface {
	GTypeInterface parent_iface;
	gboolean (*has_bigram) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_cost) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_backoff) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
};

struct _KkcTextBigramLanguageModel {
	KkcLanguageModel parent_instance;
	KkcTextBigramLanguageModelPrivate * priv;
	GeeMap* input_map;
	GeeMap* cost_map;
	GeeMap* backoff_map;
	GeeMap* id_map;
};

struct _KkcTextBigramLanguageModelClass {
	KkcLanguageModelClass parent_class;
};

struct _KkcTextBigramLanguageModelPrivate {
	KkcLanguageModelEntry _bos;
	KkcLanguageModelEntry _eos;
};


static gpointer kkc_text_bigram_language_model_parent_class = NULL;
static KkcUnigramLanguageModelIface* kkc_text_bigram_language_model_kkc_unigram_language_model_parent_iface = NULL;
static KkcBigramLanguageModelIface* kkc_text_bigram_language_model_kkc_bigram_language_model_parent_iface = NULL;

GType kkc_language_model_get_type (void) G_GNUC_CONST;
GType kkc_language_model_entry_get_type (void) G_GNUC_CONST;
KkcLanguageModelEntry* kkc_language_model_entry_dup (const KkcLanguageModelEntry* self);
void kkc_language_model_entry_free (KkcLanguageModelEntry* self);
void kkc_language_model_entry_copy (const KkcLanguageModelEntry* self, KkcLanguageModelEntry* dest);
void kkc_language_model_entry_destroy (KkcLanguageModelEntry* self);
GType kkc_unigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_bigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_text_bigram_language_model_get_type (void) G_GNUC_CONST;
#define KKC_TEXT_BIGRAM_LANGUAGE_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModelPrivate))
enum  {
	KKC_TEXT_BIGRAM_LANGUAGE_MODEL_DUMMY_PROPERTY,
	KKC_TEXT_BIGRAM_LANGUAGE_MODEL_BOS,
	KKC_TEXT_BIGRAM_LANGUAGE_MODEL_EOS
};
static gdouble* _double_dup (gdouble* self);
static GeeCollection* kkc_text_bigram_language_model_real_unigram_entries (KkcLanguageModel* base, const gchar* input);
static GeeCollection* kkc_text_bigram_language_model_real_entries (KkcLanguageModel* base, const gchar* input);
static KkcLanguageModelEntry* kkc_text_bigram_language_model_real_get (KkcLanguageModel* base, const gchar* input, const gchar* output);
gchar* kkc_text_bigram_language_model_get_key (KkcTextBigramLanguageModel* self, guint* ids, int ids_length1);
static gboolean kkc_text_bigram_language_model_real_has_bigram (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
static gdouble kkc_text_bigram_language_model_real_unigram_cost (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry);
static gdouble kkc_text_bigram_language_model_real_unigram_backoff (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry);
static gdouble kkc_text_bigram_language_model_real_bigram_cost (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
static gdouble kkc_text_bigram_language_model_real_bigram_backoff (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
void kkc_text_bigram_language_model_parse_lm (KkcTextBigramLanguageModel* self, const gchar* input, GError** error);
static void _vala_array_add1 (guint** array, int* length, int* size, guint value);
static gboolean kkc_text_bigram_language_model_real_parse (KkcLanguageModel* base, GError** error);
GType kkc_metadata_file_get_type (void) G_GNUC_CONST;
GType kkc_language_model_metadata_get_type (void) G_GNUC_CONST;
KkcLanguageModelMetadata* kkc_language_model_get_metadata (KkcLanguageModel* self);
const gchar* kkc_metadata_file_get_filename (KkcMetadataFile* self);
KkcTextBigramLanguageModel* kkc_text_bigram_language_model_new (KkcLanguageModelMetadata* metadata, GError** error);
KkcTextBigramLanguageModel* kkc_text_bigram_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error);
KkcLanguageModel* kkc_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error);
static void kkc_text_bigram_language_model_finalize (GObject* obj);
void kkc_language_model_get_bos (KkcLanguageModel* self, KkcLanguageModelEntry* result);
void kkc_language_model_get_eos (KkcLanguageModel* self, KkcLanguageModelEntry* result);
static void _vala_kkc_text_bigram_language_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gdouble* _double_dup (gdouble* self) {
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}


static GeeCollection* kkc_text_bigram_language_model_real_unigram_entries (KkcLanguageModel* base, const gchar* input) {
	KkcTextBigramLanguageModel * self;
	GeeCollection* result = NULL;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = self->input_map;
	_tmp1_ = input;
	_tmp2_ = gee_map_get (_tmp0_, _tmp1_);
	result = (GeeCollection*) ((GeeArrayList*) _tmp2_);
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeCollection* kkc_text_bigram_language_model_real_entries (KkcLanguageModel* base, const gchar* input) {
	KkcTextBigramLanguageModel * self;
	GeeCollection* result = NULL;
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp21_;
	GeeCollection* _tmp22_;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = gee_array_list_new (KKC_TYPE_LANGUAGE_MODEL_ENTRY, (GBoxedCopyFunc) kkc_language_model_entry_dup, kkc_language_model_entry_free, NULL);
	entries = _tmp0_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				const gchar* _tmp5_;
				gint _tmp6_ = 0;
				glong byte_offset = 0L;
				const gchar* _tmp7_;
				gint _tmp8_;
				gint _tmp9_ = 0;
				gchar* str = NULL;
				const gchar* _tmp10_;
				glong _tmp11_;
				gchar* _tmp12_ = NULL;
				GeeMap* _tmp13_;
				const gchar* _tmp14_;
				gboolean _tmp15_ = FALSE;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = input;
				_tmp6_ = g_utf8_strlen (_tmp5_, (gssize) (-1));
				if (!(_tmp4_ < (_tmp6_ + 1))) {
					break;
				}
				_tmp7_ = input;
				_tmp8_ = i;
				_tmp9_ = string_index_of_nth_char (_tmp7_, (glong) _tmp8_);
				byte_offset = (glong) _tmp9_;
				_tmp10_ = input;
				_tmp11_ = byte_offset;
				_tmp12_ = string_substring (_tmp10_, (glong) 0, _tmp11_);
				str = _tmp12_;
				_tmp13_ = self->input_map;
				_tmp14_ = str;
				_tmp15_ = gee_map_has_key (_tmp13_, _tmp14_);
				if (_tmp15_) {
					GeeArrayList* _tmp16_;
					GeeMap* _tmp17_;
					const gchar* _tmp18_;
					gpointer _tmp19_ = NULL;
					GeeArrayList* _tmp20_;
					_tmp16_ = entries;
					_tmp17_ = self->input_map;
					_tmp18_ = str;
					_tmp19_ = gee_map_get (_tmp17_, _tmp18_);
					_tmp20_ = (GeeArrayList*) _tmp19_;
					gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp16_, (GeeCollection*) _tmp20_);
					_g_object_unref0 (_tmp20_);
				}
				_g_free0 (str);
			}
		}
	}
	_tmp21_ = entries;
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
	result = _tmp22_;
	_g_object_unref0 (entries);
	return result;
}


static KkcLanguageModelEntry* kkc_text_bigram_language_model_real_get (KkcLanguageModel* base, const gchar* input, const gchar* output) {
	KkcTextBigramLanguageModel * self;
	KkcLanguageModelEntry* result = NULL;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (input != NULL, NULL);
	g_return_val_if_fail (output != NULL, NULL);
	result = NULL;
	return result;
}


gchar* kkc_text_bigram_language_model_get_key (KkcTextBigramLanguageModel* self, guint* ids, int ids_length1) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	guint* _tmp1_;
	gint _tmp1__length1;
	GString* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = ids;
	_tmp1__length1 = ids_length1;
	{
		guint* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp1_;
		id_collection_length1 = _tmp1__length1;
		for (id_it = 0; id_it < _tmp1__length1; id_it = id_it + 1) {
			guint id = 0U;
			id = id_collection[id_it];
			{
				GString* _tmp2_;
				guint _tmp3_;
				_tmp2_ = builder;
				_tmp3_ = id;
				g_string_append_printf (_tmp2_, "%08X", _tmp3_);
			}
		}
	}
	_tmp4_ = builder;
	_tmp5_ = _tmp4_->str;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	_g_string_free0 (builder);
	return result;
}


static gboolean kkc_text_bigram_language_model_real_has_bigram (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	KkcTextBigramLanguageModel * self;
	gboolean result = FALSE;
	gchar* key = NULL;
	KkcLanguageModelEntry _tmp0_;
	guint _tmp1_;
	KkcLanguageModelEntry _tmp2_;
	guint _tmp3_;
	guint* _tmp4_ = NULL;
	guint* _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GeeMap* _tmp8_;
	gboolean _tmp9_ = FALSE;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (pentry != NULL, FALSE);
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = *pentry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = *entry;
	_tmp3_ = _tmp2_.id;
	_tmp4_ = g_new0 (guint, 2);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = kkc_text_bigram_language_model_get_key (self, _tmp5_, 2);
	_tmp7_ = _tmp6_;
	_tmp5_ = (g_free (_tmp5_), NULL);
	key = _tmp7_;
	_tmp8_ = self->cost_map;
	_tmp9_ = gee_map_has_key (_tmp8_, (const gchar*) key);
	result = _tmp9_;
	_g_free0 (key);
	return result;
}


static gdouble kkc_text_bigram_language_model_real_unigram_cost (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry) {
	KkcTextBigramLanguageModel * self;
	gdouble result = 0.0;
	gchar* key = NULL;
	KkcLanguageModelEntry _tmp0_;
	guint _tmp1_;
	guint* _tmp2_ = NULL;
	guint* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GeeMap* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *entry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = g_new0 (guint, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = kkc_text_bigram_language_model_get_key (self, _tmp3_, 1);
	_tmp5_ = _tmp4_;
	_tmp3_ = (g_free (_tmp3_), NULL);
	key = _tmp5_;
	_tmp6_ = self->cost_map;
	_tmp7_ = key;
	_tmp8_ = gee_map_has_key (_tmp6_, _tmp7_);
	if (_tmp8_) {
		GeeMap* _tmp9_;
		const gchar* _tmp10_;
		gpointer _tmp11_ = NULL;
		gdouble* _tmp12_;
		gdouble _tmp13_;
		_tmp9_ = self->cost_map;
		_tmp10_ = key;
		_tmp11_ = gee_map_get (_tmp9_, _tmp10_);
		_tmp12_ = (gdouble*) _tmp11_;
		_tmp13_ = *_tmp12_;
		_g_free0 (_tmp12_);
		result = _tmp13_;
		_g_free0 (key);
		return result;
	}
	result = (gdouble) 0;
	_g_free0 (key);
	return result;
}


static gdouble kkc_text_bigram_language_model_real_unigram_backoff (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry) {
	KkcTextBigramLanguageModel * self;
	gdouble result = 0.0;
	gchar* key = NULL;
	KkcLanguageModelEntry _tmp0_;
	guint _tmp1_;
	guint* _tmp2_ = NULL;
	guint* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GeeMap* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *entry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = g_new0 (guint, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = kkc_text_bigram_language_model_get_key (self, _tmp3_, 1);
	_tmp5_ = _tmp4_;
	_tmp3_ = (g_free (_tmp3_), NULL);
	key = _tmp5_;
	_tmp6_ = self->backoff_map;
	_tmp7_ = key;
	_tmp8_ = gee_map_has_key (_tmp6_, _tmp7_);
	if (_tmp8_) {
		GeeMap* _tmp9_;
		const gchar* _tmp10_;
		gpointer _tmp11_ = NULL;
		gdouble* _tmp12_;
		gdouble _tmp13_;
		_tmp9_ = self->backoff_map;
		_tmp10_ = key;
		_tmp11_ = gee_map_get (_tmp9_, _tmp10_);
		_tmp12_ = (gdouble*) _tmp11_;
		_tmp13_ = *_tmp12_;
		_g_free0 (_tmp12_);
		result = _tmp13_;
		_g_free0 (key);
		return result;
	}
	result = (gdouble) 0;
	_g_free0 (key);
	return result;
}


static gdouble kkc_text_bigram_language_model_real_bigram_cost (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	KkcTextBigramLanguageModel * self;
	gdouble result = 0.0;
	gchar* key = NULL;
	KkcLanguageModelEntry _tmp0_;
	guint _tmp1_;
	KkcLanguageModelEntry _tmp2_;
	guint _tmp3_;
	guint* _tmp4_ = NULL;
	guint* _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GeeMap* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (pentry != NULL, 0.0);
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *pentry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = *entry;
	_tmp3_ = _tmp2_.id;
	_tmp4_ = g_new0 (guint, 2);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = kkc_text_bigram_language_model_get_key (self, _tmp5_, 2);
	_tmp7_ = _tmp6_;
	_tmp5_ = (g_free (_tmp5_), NULL);
	key = _tmp7_;
	_tmp8_ = self->cost_map;
	_tmp9_ = key;
	_tmp10_ = gee_map_has_key (_tmp8_, _tmp9_);
	if (_tmp10_) {
		GeeMap* _tmp11_;
		const gchar* _tmp12_;
		gpointer _tmp13_ = NULL;
		gdouble* _tmp14_;
		gdouble _tmp15_;
		_tmp11_ = self->cost_map;
		_tmp12_ = key;
		_tmp13_ = gee_map_get (_tmp11_, _tmp12_);
		_tmp14_ = (gdouble*) _tmp13_;
		_tmp15_ = *_tmp14_;
		_g_free0 (_tmp14_);
		result = _tmp15_;
		_g_free0 (key);
		return result;
	}
	result = (gdouble) 0;
	_g_free0 (key);
	return result;
}


static gdouble kkc_text_bigram_language_model_real_bigram_backoff (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	KkcTextBigramLanguageModel * self;
	gdouble result = 0.0;
	gchar* key = NULL;
	KkcLanguageModelEntry _tmp0_;
	guint _tmp1_;
	KkcLanguageModelEntry _tmp2_;
	guint _tmp3_;
	guint* _tmp4_ = NULL;
	guint* _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GeeMap* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (pentry != NULL, 0.0);
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *pentry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = *entry;
	_tmp3_ = _tmp2_.id;
	_tmp4_ = g_new0 (guint, 2);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = kkc_text_bigram_language_model_get_key (self, _tmp5_, 2);
	_tmp7_ = _tmp6_;
	_tmp5_ = (g_free (_tmp5_), NULL);
	key = _tmp7_;
	_tmp8_ = self->backoff_map;
	_tmp9_ = key;
	_tmp10_ = gee_map_has_key (_tmp8_, _tmp9_);
	if (_tmp10_) {
		GeeMap* _tmp11_;
		const gchar* _tmp12_;
		gpointer _tmp13_ = NULL;
		gdouble* _tmp14_;
		gdouble _tmp15_;
		_tmp11_ = self->backoff_map;
		_tmp12_ = key;
		_tmp13_ = gee_map_get (_tmp11_, _tmp12_);
		_tmp14_ = (gdouble*) _tmp13_;
		_tmp15_ = *_tmp14_;
		_g_free0 (_tmp14_);
		result = _tmp15_;
		_g_free0 (key);
		return result;
	}
	result = (gdouble) 0;
	_g_free0 (key);
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static void _vala_array_add1 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void kkc_text_bigram_language_model_parse_lm (KkcTextBigramLanguageModel* self, const gchar* input, GError** error) {
	GFile* lm_file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFileInputStream* _tmp2_ = NULL;
	GFile* _tmp3_;
	GFileInputStream* _tmp4_ = NULL;
	GDataInputStream* lm_data = NULL;
	GFileInputStream* _tmp5_;
	GDataInputStream* _tmp6_;
	GDataInputStream* _tmp7_;
	guint id = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	_tmp0_ = input;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	lm_file = _tmp1_;
	_tmp3_ = lm_file;
	_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error_);
	_tmp2_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (lm_file);
		return;
	}
	_tmp5_ = _tmp2_;
	_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	lm_data = _tmp7_;
	while (TRUE) {
		gsize length = 0UL;
		gchar* line = NULL;
		GDataInputStream* _tmp8_;
		gsize _tmp9_ = 0UL;
		gchar* _tmp10_ = NULL;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gboolean _tmp16_ = FALSE;
		_tmp8_ = lm_data;
		_tmp10_ = g_data_input_stream_read_line (_tmp8_, &_tmp9_, NULL, &_inner_error_);
		length = _tmp9_;
		line = _tmp10_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (lm_data);
			_g_object_unref0 (lm_file);
			return;
		}
		_tmp11_ = line;
		if (_tmp11_ == NULL) {
			_g_free0 (line);
			break;
		}
		_tmp12_ = line;
		_tmp13_ = string_strip (_tmp12_);
		_g_free0 (line);
		line = _tmp13_;
		_tmp14_ = line;
		if (g_strcmp0 (_tmp14_, "") == 0) {
			_g_free0 (line);
			continue;
		}
		_tmp15_ = line;
		_tmp16_ = g_str_has_prefix (_tmp15_, "\\1-grams:");
		if (_tmp16_) {
			_g_free0 (line);
			break;
		}
		_g_free0 (line);
	}
	id = (guint) 0;
	while (TRUE) {
		gsize length = 0UL;
		gchar* line = NULL;
		GDataInputStream* _tmp17_;
		gsize _tmp18_ = 0UL;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		const gchar* _tmp24_;
		gboolean _tmp27_;
		gchar** strv = NULL;
		const gchar* _tmp28_;
		gchar** _tmp29_;
		gchar** _tmp30_ = NULL;
		gint strv_length1;
		gint _strv_size_;
		gchar** _tmp31_;
		gint _tmp31__length1;
		const gchar* _tmp32_;
		gboolean _tmp33_ = FALSE;
		gdouble cost = 0.0;
		gchar** _tmp88_;
		gint _tmp88__length1;
		const gchar* _tmp89_;
		gdouble _tmp90_ = 0.0;
		gdouble backoff = 0.0;
		gchar** _tmp91_;
		gint _tmp91__length1;
		gchar** words = NULL;
		gchar** _tmp95_;
		gint _tmp95__length1;
		const gchar* _tmp96_;
		gchar** _tmp97_;
		gchar** _tmp98_ = NULL;
		gint words_length1;
		gint _words_size_;
		guint* ids = NULL;
		guint* _tmp99_ = NULL;
		gint ids_length1;
		gint _ids_size_;
		gchar** _tmp100_;
		gint _tmp100__length1;
		gchar* key = NULL;
		guint* _tmp106_;
		gint _tmp106__length1;
		gchar* _tmp107_ = NULL;
		GeeMap* _tmp108_;
		const gchar* _tmp109_;
		gdouble _tmp110_;
		GeeMap* _tmp111_;
		const gchar* _tmp112_;
		gdouble _tmp113_;
		_tmp17_ = lm_data;
		_tmp19_ = g_data_input_stream_read_line (_tmp17_, &_tmp18_, NULL, &_inner_error_);
		length = _tmp18_;
		line = _tmp19_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (lm_data);
			_g_object_unref0 (lm_file);
			return;
		}
		_tmp20_ = line;
		if (_tmp20_ == NULL) {
			_g_free0 (line);
			break;
		}
		_tmp21_ = line;
		_tmp22_ = string_strip (_tmp21_);
		_g_free0 (line);
		line = _tmp22_;
		_tmp24_ = line;
		if (g_strcmp0 (_tmp24_, "") == 0) {
			_tmp23_ = TRUE;
		} else {
			const gchar* _tmp25_;
			gboolean _tmp26_ = FALSE;
			_tmp25_ = line;
			_tmp26_ = g_str_has_prefix (_tmp25_, "\\");
			_tmp23_ = _tmp26_;
		}
		_tmp27_ = _tmp23_;
		if (_tmp27_) {
			_g_free0 (line);
			continue;
		}
		_tmp28_ = line;
		_tmp30_ = _tmp29_ = g_strsplit (_tmp28_, "\t", 0);
		strv = _tmp30_;
		strv_length1 = _vala_array_length (_tmp29_);
		_strv_size_ = strv_length1;
		_tmp31_ = strv;
		_tmp31__length1 = strv_length1;
		_tmp32_ = _tmp31_[1];
		_tmp33_ = string_contains (_tmp32_, " ");
		if (!_tmp33_) {
			GeeMap* _tmp34_;
			gchar** _tmp35_;
			gint _tmp35__length1;
			const gchar* _tmp36_;
			guint _tmp37_;
			gchar** input_output = NULL;
			gint input_output_length1 = 0;
			gint _input_output_size_ = 0;
			gboolean _tmp38_ = FALSE;
			gboolean _tmp39_ = FALSE;
			gchar** _tmp40_;
			gint _tmp40__length1;
			const gchar* _tmp41_;
			gboolean _tmp44_;
			gboolean _tmp47_;
			KkcLanguageModelEntry entry = {0};
			gchar** _tmp57_;
			gint _tmp57__length1;
			const gchar* _tmp58_;
			gchar* _tmp59_;
			gchar** _tmp60_;
			gint _tmp60__length1;
			const gchar* _tmp61_;
			gchar* _tmp62_;
			guint _tmp63_;
			KkcLanguageModelEntry _tmp64_ = {0};
			gchar** _tmp65_;
			gint _tmp65__length1;
			const gchar* _tmp66_;
			GeeMap* _tmp73_;
			gchar** _tmp74_;
			gint _tmp74__length1;
			const gchar* _tmp75_;
			gboolean _tmp76_ = FALSE;
			GeeMap* _tmp82_;
			gchar** _tmp83_;
			gint _tmp83__length1;
			const gchar* _tmp84_;
			gpointer _tmp85_ = NULL;
			GeeArrayList* _tmp86_;
			KkcLanguageModelEntry _tmp87_;
			_tmp34_ = self->id_map;
			_tmp35_ = strv;
			_tmp35__length1 = strv_length1;
			_tmp36_ = _tmp35_[1];
			_tmp37_ = id;
			gee_map_set (_tmp34_, _tmp36_, (gpointer) ((guintptr) _tmp37_));
			_tmp40_ = strv;
			_tmp40__length1 = strv_length1;
			_tmp41_ = _tmp40_[1];
			if (g_strcmp0 (_tmp41_, "<s>") == 0) {
				_tmp39_ = TRUE;
			} else {
				gchar** _tmp42_;
				gint _tmp42__length1;
				const gchar* _tmp43_;
				_tmp42_ = strv;
				_tmp42__length1 = strv_length1;
				_tmp43_ = _tmp42_[1];
				_tmp39_ = g_strcmp0 (_tmp43_, "</s>") == 0;
			}
			_tmp44_ = _tmp39_;
			if (_tmp44_) {
				_tmp38_ = TRUE;
			} else {
				gchar** _tmp45_;
				gint _tmp45__length1;
				const gchar* _tmp46_;
				_tmp45_ = strv;
				_tmp45__length1 = strv_length1;
				_tmp46_ = _tmp45_[1];
				_tmp38_ = g_strcmp0 (_tmp46_, "<UNK>") == 0;
			}
			_tmp47_ = _tmp38_;
			if (_tmp47_) {
				gchar* _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				const gchar* _tmp50_;
				gchar* _tmp51_;
				gchar** _tmp52_ = NULL;
				_tmp48_ = g_strdup (" ");
				_tmp49_ = strv;
				_tmp49__length1 = strv_length1;
				_tmp50_ = _tmp49_[1];
				_tmp51_ = g_strdup (_tmp50_);
				_tmp52_ = g_new0 (gchar*, 2 + 1);
				_tmp52_[0] = _tmp48_;
				_tmp52_[1] = _tmp51_;
				input_output = (_vala_array_free (input_output, input_output_length1, (GDestroyNotify) g_free), NULL);
				input_output = _tmp52_;
				input_output_length1 = 2;
				_input_output_size_ = input_output_length1;
			} else {
				gchar** _tmp53_;
				gint _tmp53__length1;
				const gchar* _tmp54_;
				gchar** _tmp55_;
				gchar** _tmp56_ = NULL;
				_tmp53_ = strv;
				_tmp53__length1 = strv_length1;
				_tmp54_ = _tmp53_[1];
				_tmp56_ = _tmp55_ = g_strsplit (_tmp54_, "/", 0);
				input_output = (_vala_array_free (input_output, input_output_length1, (GDestroyNotify) g_free), NULL);
				input_output = _tmp56_;
				input_output_length1 = _vala_array_length (_tmp55_);
				_input_output_size_ = input_output_length1;
			}
			_tmp57_ = input_output;
			_tmp57__length1 = input_output_length1;
			_tmp58_ = _tmp57_[0];
			_tmp59_ = g_strdup (_tmp58_);
			_tmp60_ = input_output;
			_tmp60__length1 = input_output_length1;
			_tmp61_ = _tmp60_[1];
			_tmp62_ = g_strdup (_tmp61_);
			_tmp63_ = id;
			id = _tmp63_ + 1;
			_g_free0 (_tmp64_.input);
			_tmp64_.input = _tmp59_;
			_g_free0 (_tmp64_.output);
			_tmp64_.output = _tmp62_;
			_tmp64_.id = _tmp63_;
			entry = _tmp64_;
			_tmp65_ = strv;
			_tmp65__length1 = strv_length1;
			_tmp66_ = _tmp65_[1];
			if (g_strcmp0 (_tmp66_, "<s>") == 0) {
				KkcLanguageModelEntry _tmp67_;
				KkcLanguageModelEntry _tmp68_ = {0};
				_tmp67_ = entry;
				kkc_language_model_entry_copy (&_tmp67_, &_tmp68_);
				kkc_language_model_entry_destroy (&self->priv->_bos);
				self->priv->_bos = _tmp68_;
			} else {
				gchar** _tmp69_;
				gint _tmp69__length1;
				const gchar* _tmp70_;
				_tmp69_ = strv;
				_tmp69__length1 = strv_length1;
				_tmp70_ = _tmp69_[1];
				if (g_strcmp0 (_tmp70_, "</s>") == 0) {
					KkcLanguageModelEntry _tmp71_;
					KkcLanguageModelEntry _tmp72_ = {0};
					_tmp71_ = entry;
					kkc_language_model_entry_copy (&_tmp71_, &_tmp72_);
					kkc_language_model_entry_destroy (&self->priv->_eos);
					self->priv->_eos = _tmp72_;
				}
			}
			_tmp73_ = self->input_map;
			_tmp74_ = input_output;
			_tmp74__length1 = input_output_length1;
			_tmp75_ = _tmp74_[0];
			_tmp76_ = gee_map_has_key (_tmp73_, _tmp75_);
			if (!_tmp76_) {
				GeeMap* _tmp77_;
				gchar** _tmp78_;
				gint _tmp78__length1;
				const gchar* _tmp79_;
				GeeArrayList* _tmp80_;
				GeeArrayList* _tmp81_;
				_tmp77_ = self->input_map;
				_tmp78_ = input_output;
				_tmp78__length1 = input_output_length1;
				_tmp79_ = _tmp78_[0];
				_tmp80_ = gee_array_list_new (KKC_TYPE_LANGUAGE_MODEL_ENTRY, (GBoxedCopyFunc) kkc_language_model_entry_dup, kkc_language_model_entry_free, NULL);
				_tmp81_ = _tmp80_;
				gee_map_set (_tmp77_, _tmp79_, _tmp81_);
				_g_object_unref0 (_tmp81_);
			}
			_tmp82_ = self->input_map;
			_tmp83_ = input_output;
			_tmp83__length1 = input_output_length1;
			_tmp84_ = _tmp83_[0];
			_tmp85_ = gee_map_get (_tmp82_, _tmp84_);
			_tmp86_ = (GeeArrayList*) _tmp85_;
			_tmp87_ = entry;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp86_, &_tmp87_);
			_g_object_unref0 (_tmp86_);
			kkc_language_model_entry_destroy (&entry);
			input_output = (_vala_array_free (input_output, input_output_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp88_ = strv;
		_tmp88__length1 = strv_length1;
		_tmp89_ = _tmp88_[0];
		_tmp90_ = double_parse (_tmp89_);
		cost = _tmp90_;
		backoff = 0.0;
		_tmp91_ = strv;
		_tmp91__length1 = strv_length1;
		if (_tmp91__length1 > 2) {
			gchar** _tmp92_;
			gint _tmp92__length1;
			const gchar* _tmp93_;
			gdouble _tmp94_ = 0.0;
			_tmp92_ = strv;
			_tmp92__length1 = strv_length1;
			_tmp93_ = _tmp92_[2];
			_tmp94_ = double_parse (_tmp93_);
			backoff = _tmp94_;
		}
		_tmp95_ = strv;
		_tmp95__length1 = strv_length1;
		_tmp96_ = _tmp95_[1];
		_tmp98_ = _tmp97_ = g_strsplit (_tmp96_, " ", 0);
		words = _tmp98_;
		words_length1 = _vala_array_length (_tmp97_);
		_words_size_ = words_length1;
		_tmp99_ = g_new0 (guint, 0);
		ids = _tmp99_;
		ids_length1 = 0;
		_ids_size_ = ids_length1;
		_tmp100_ = words;
		_tmp100__length1 = words_length1;
		{
			gchar** word_collection = NULL;
			gint word_collection_length1 = 0;
			gint _word_collection_size_ = 0;
			gint word_it = 0;
			word_collection = _tmp100_;
			word_collection_length1 = _tmp100__length1;
			for (word_it = 0; word_it < _tmp100__length1; word_it = word_it + 1) {
				gchar* _tmp101_;
				gchar* word = NULL;
				_tmp101_ = g_strdup (word_collection[word_it]);
				word = _tmp101_;
				{
					guint* _tmp102_;
					gint _tmp102__length1;
					GeeMap* _tmp103_;
					const gchar* _tmp104_;
					gpointer _tmp105_ = NULL;
					_tmp102_ = ids;
					_tmp102__length1 = ids_length1;
					_tmp103_ = self->id_map;
					_tmp104_ = word;
					_tmp105_ = gee_map_get (_tmp103_, _tmp104_);
					_vala_array_add1 (&ids, &ids_length1, &_ids_size_, (guint) ((guintptr) _tmp105_));
					_g_free0 (word);
				}
			}
		}
		_tmp106_ = ids;
		_tmp106__length1 = ids_length1;
		_tmp107_ = kkc_text_bigram_language_model_get_key (self, _tmp106_, _tmp106__length1);
		key = _tmp107_;
		_tmp108_ = self->cost_map;
		_tmp109_ = key;
		_tmp110_ = cost;
		gee_map_set (_tmp108_, _tmp109_, &_tmp110_);
		_tmp111_ = self->backoff_map;
		_tmp112_ = key;
		_tmp113_ = backoff;
		gee_map_set (_tmp111_, _tmp112_, &_tmp113_);
		_g_free0 (key);
		ids = (g_free (ids), NULL);
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
	}
	_g_object_unref0 (lm_data);
	_g_object_unref0 (lm_file);
}


static gboolean kkc_text_bigram_language_model_real_parse (KkcLanguageModel* base, GError** error) {
	KkcTextBigramLanguageModel * self;
	gboolean result = FALSE;
	gchar* prefix = NULL;
	KkcLanguageModelMetadata* _tmp0_;
	KkcLanguageModelMetadata* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (KkcTextBigramLanguageModel*) base;
	_tmp0_ = kkc_language_model_get_metadata ((KkcLanguageModel*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = kkc_metadata_file_get_filename ((KkcMetadataFile*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_path_get_dirname (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename (_tmp5_, "data", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	prefix = _tmp7_;
	_tmp8_ = g_strconcat (prefix, ".arpa", NULL);
	_tmp9_ = _tmp8_;
	kkc_text_bigram_language_model_parse_lm (self, _tmp9_, &_inner_error_);
	_g_free0 (_tmp9_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (prefix);
		return FALSE;
	}
	result = TRUE;
	_g_free0 (prefix);
	return result;
}


KkcTextBigramLanguageModel* kkc_text_bigram_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error) {
	KkcTextBigramLanguageModel * self = NULL;
	KkcLanguageModelMetadata* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = metadata;
	self = (KkcTextBigramLanguageModel*) kkc_language_model_construct (object_type, _tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


KkcTextBigramLanguageModel* kkc_text_bigram_language_model_new (KkcLanguageModelMetadata* metadata, GError** error) {
	return kkc_text_bigram_language_model_construct (KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, metadata, error);
}


static void kkc_text_bigram_language_model_real_get_bos (KkcLanguageModel* base, KkcLanguageModelEntry* result) {
	KkcTextBigramLanguageModel* self;
	KkcLanguageModelEntry _tmp0_;
	self = (KkcTextBigramLanguageModel*) base;
	_tmp0_ = self->priv->_bos;
	*result = _tmp0_;
	return;
}


static void kkc_text_bigram_language_model_real_get_eos (KkcLanguageModel* base, KkcLanguageModelEntry* result) {
	KkcTextBigramLanguageModel* self;
	KkcLanguageModelEntry _tmp0_;
	self = (KkcTextBigramLanguageModel*) base;
	_tmp0_ = self->priv->_eos;
	*result = _tmp0_;
	return;
}


static void kkc_text_bigram_language_model_class_init (KkcTextBigramLanguageModelClass * klass) {
	kkc_text_bigram_language_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcTextBigramLanguageModelPrivate));
	KKC_LANGUAGE_MODEL_CLASS (klass)->unigram_entries = kkc_text_bigram_language_model_real_unigram_entries;
	KKC_LANGUAGE_MODEL_CLASS (klass)->entries = kkc_text_bigram_language_model_real_entries;
	KKC_LANGUAGE_MODEL_CLASS (klass)->get = kkc_text_bigram_language_model_real_get;
	KKC_LANGUAGE_MODEL_CLASS (klass)->parse = kkc_text_bigram_language_model_real_parse;
	KKC_LANGUAGE_MODEL_CLASS (klass)->get_bos = kkc_text_bigram_language_model_real_get_bos;
	KKC_LANGUAGE_MODEL_CLASS (klass)->get_eos = kkc_text_bigram_language_model_real_get_eos;
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_text_bigram_language_model_get_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_text_bigram_language_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_TEXT_BIGRAM_LANGUAGE_MODEL_BOS, g_param_spec_boxed ("bos", "bos", "bos", KKC_TYPE_LANGUAGE_MODEL_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_TEXT_BIGRAM_LANGUAGE_MODEL_EOS, g_param_spec_boxed ("eos", "eos", "eos", KKC_TYPE_LANGUAGE_MODEL_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void kkc_text_bigram_language_model_kkc_unigram_language_model_interface_init (KkcUnigramLanguageModelIface * iface) {
	kkc_text_bigram_language_model_kkc_unigram_language_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->unigram_cost = (gdouble (*)(KkcUnigramLanguageModel*, KkcLanguageModelEntry*)) kkc_text_bigram_language_model_real_unigram_cost;
	iface->unigram_backoff = (gdouble (*)(KkcUnigramLanguageModel*, KkcLanguageModelEntry*)) kkc_text_bigram_language_model_real_unigram_backoff;
}


static void kkc_text_bigram_language_model_kkc_bigram_language_model_interface_init (KkcBigramLanguageModelIface * iface) {
	kkc_text_bigram_language_model_kkc_bigram_language_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->has_bigram = (gboolean (*)(KkcBigramLanguageModel*, KkcLanguageModelEntry*, KkcLanguageModelEntry*)) kkc_text_bigram_language_model_real_has_bigram;
	iface->bigram_cost = (gdouble (*)(KkcBigramLanguageModel*, KkcLanguageModelEntry*, KkcLanguageModelEntry*)) kkc_text_bigram_language_model_real_bigram_cost;
	iface->bigram_backoff = (gdouble (*)(KkcBigramLanguageModel*, KkcLanguageModelEntry*, KkcLanguageModelEntry*)) kkc_text_bigram_language_model_real_bigram_backoff;
}


static void kkc_text_bigram_language_model_instance_init (KkcTextBigramLanguageModel * self) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	self->priv = KKC_TEXT_BIGRAM_LANGUAGE_MODEL_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->input_map = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_DOUBLE, (GBoxedCopyFunc) _double_dup, g_free, NULL, NULL, NULL);
	self->cost_map = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_DOUBLE, (GBoxedCopyFunc) _double_dup, g_free, NULL, NULL, NULL);
	self->backoff_map = (GeeMap*) _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	self->id_map = (GeeMap*) _tmp3_;
}


static void kkc_text_bigram_language_model_finalize (GObject* obj) {
	KkcTextBigramLanguageModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModel);
	kkc_language_model_entry_destroy (&self->priv->_bos);
	kkc_language_model_entry_destroy (&self->priv->_eos);
	_g_object_unref0 (self->input_map);
	_g_object_unref0 (self->cost_map);
	_g_object_unref0 (self->backoff_map);
	_g_object_unref0 (self->id_map);
	G_OBJECT_CLASS (kkc_text_bigram_language_model_parent_class)->finalize (obj);
}


GType kkc_text_bigram_language_model_get_type (void) {
	static volatile gsize kkc_text_bigram_language_model_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_text_bigram_language_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcTextBigramLanguageModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_text_bigram_language_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcTextBigramLanguageModel), 0, (GInstanceInitFunc) kkc_text_bigram_language_model_instance_init, NULL };
		static const GInterfaceInfo kkc_unigram_language_model_info = { (GInterfaceInitFunc) kkc_text_bigram_language_model_kkc_unigram_language_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo kkc_bigram_language_model_info = { (GInterfaceInitFunc) kkc_text_bigram_language_model_kkc_bigram_language_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_text_bigram_language_model_type_id;
		kkc_text_bigram_language_model_type_id = g_type_register_static (KKC_TYPE_LANGUAGE_MODEL, "KkcTextBigramLanguageModel", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_text_bigram_language_model_type_id, KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, &kkc_unigram_language_model_info);
		g_type_add_interface_static (kkc_text_bigram_language_model_type_id, KKC_TYPE_BIGRAM_LANGUAGE_MODEL, &kkc_bigram_language_model_info);
		g_once_init_leave (&kkc_text_bigram_language_model_type_id__volatile, kkc_text_bigram_language_model_type_id);
	}
	return kkc_text_bigram_language_model_type_id__volatile;
}


static void _vala_kkc_text_bigram_language_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcTextBigramLanguageModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModel);
	switch (property_id) {
		case KKC_TEXT_BIGRAM_LANGUAGE_MODEL_BOS:
		{
			KkcLanguageModelEntry boxed;
			kkc_language_model_get_bos ((KkcLanguageModel*) self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case KKC_TEXT_BIGRAM_LANGUAGE_MODEL_EOS:
		{
			KkcLanguageModelEntry boxed;
			kkc_language_model_get_eos ((KkcLanguageModel*) self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



