/* context.c generated by valac 0.20.1.19-a6516, the Vala compiler
 * generated from context.vala, do not modify */

/*
 * Copyright (C) 2011-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define KKC_TYPE_CONTEXT (kkc_context_get_type ())
#define KKC_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CONTEXT, KkcContext))
#define KKC_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CONTEXT, KkcContextClass))
#define KKC_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CONTEXT))
#define KKC_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CONTEXT))
#define KKC_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CONTEXT, KkcContextClass))

typedef struct _KkcContext KkcContext;
typedef struct _KkcContextClass KkcContextClass;
typedef struct _KkcContextPrivate KkcContextPrivate;

#define KKC_TYPE_STATE (kkc_state_get_type ())
#define KKC_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_STATE, KkcState))
#define KKC_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_STATE, KkcStateClass))
#define KKC_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_STATE))
#define KKC_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_STATE))
#define KKC_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_STATE, KkcStateClass))

typedef struct _KkcState KkcState;
typedef struct _KkcStateClass KkcStateClass;

#define KKC_TYPE_STATE_HANDLER (kkc_state_handler_get_type ())
#define KKC_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_STATE_HANDLER, KkcStateHandler))
#define KKC_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_STATE_HANDLER, KkcStateHandlerClass))
#define KKC_IS_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_STATE_HANDLER))
#define KKC_IS_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_STATE_HANDLER))
#define KKC_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_STATE_HANDLER, KkcStateHandlerClass))

typedef struct _KkcStateHandler KkcStateHandler;
typedef struct _KkcStateHandlerClass KkcStateHandlerClass;

#define KKC_TYPE_DICTIONARY_LIST (kkc_dictionary_list_get_type ())
#define KKC_DICTIONARY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DICTIONARY_LIST, KkcDictionaryList))
#define KKC_DICTIONARY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_DICTIONARY_LIST, KkcDictionaryListClass))
#define KKC_IS_DICTIONARY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DICTIONARY_LIST))
#define KKC_IS_DICTIONARY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_DICTIONARY_LIST))
#define KKC_DICTIONARY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_DICTIONARY_LIST, KkcDictionaryListClass))

typedef struct _KkcDictionaryList KkcDictionaryList;
typedef struct _KkcDictionaryListClass KkcDictionaryListClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KKC_TYPE_KEY_EVENT (kkc_key_event_get_type ())
#define KKC_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEvent))
#define KKC_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))
#define KKC_IS_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEY_EVENT))
#define KKC_IS_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEY_EVENT))
#define KKC_KEY_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))

typedef struct _KkcKeyEvent KkcKeyEvent;
typedef struct _KkcKeyEventClass KkcKeyEventClass;

#define KKC_TYPE_LANGUAGE_MODEL (kkc_language_model_get_type ())
#define KKC_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel))
#define KKC_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))
#define KKC_IS_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_IS_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))

typedef struct _KkcLanguageModel KkcLanguageModel;
typedef struct _KkcLanguageModelClass KkcLanguageModelClass;

#define KKC_TYPE_INITIAL_STATE_HANDLER (kkc_initial_state_handler_get_type ())
#define KKC_INITIAL_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandler))
#define KKC_INITIAL_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandlerClass))
#define KKC_IS_INITIAL_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_INITIAL_STATE_HANDLER))
#define KKC_IS_INITIAL_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_INITIAL_STATE_HANDLER))
#define KKC_INITIAL_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandlerClass))

typedef struct _KkcInitialStateHandler KkcInitialStateHandler;
typedef struct _KkcInitialStateHandlerClass KkcInitialStateHandlerClass;

#define KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER (kkc_convert_sentence_state_handler_get_type ())
#define KKC_CONVERT_SENTENCE_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER, KkcConvertSentenceStateHandler))
#define KKC_CONVERT_SENTENCE_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER, KkcConvertSentenceStateHandlerClass))
#define KKC_IS_CONVERT_SENTENCE_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER))
#define KKC_IS_CONVERT_SENTENCE_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER))
#define KKC_CONVERT_SENTENCE_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER, KkcConvertSentenceStateHandlerClass))

typedef struct _KkcConvertSentenceStateHandler KkcConvertSentenceStateHandler;
typedef struct _KkcConvertSentenceStateHandlerClass KkcConvertSentenceStateHandlerClass;

#define KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER (kkc_convert_segment_state_handler_get_type ())
#define KKC_CONVERT_SEGMENT_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER, KkcConvertSegmentStateHandler))
#define KKC_CONVERT_SEGMENT_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER, KkcConvertSegmentStateHandlerClass))
#define KKC_IS_CONVERT_SEGMENT_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER))
#define KKC_IS_CONVERT_SEGMENT_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER))
#define KKC_CONVERT_SEGMENT_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER, KkcConvertSegmentStateHandlerClass))

typedef struct _KkcConvertSegmentStateHandler KkcConvertSegmentStateHandler;
typedef struct _KkcConvertSegmentStateHandlerClass KkcConvertSegmentStateHandlerClass;
typedef struct _KkcStatePrivate KkcStatePrivate;

#define KKC_TYPE_DECODER (kkc_decoder_get_type ())
#define KKC_DECODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DECODER, KkcDecoder))
#define KKC_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_DECODER, KkcDecoderClass))
#define KKC_IS_DECODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DECODER))
#define KKC_IS_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_DECODER))
#define KKC_DECODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_DECODER, KkcDecoderClass))

typedef struct _KkcDecoder KkcDecoder;
typedef struct _KkcDecoderClass KkcDecoderClass;

#define KKC_TYPE_SEGMENT_LIST (kkc_segment_list_get_type ())
#define KKC_SEGMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT_LIST, KkcSegmentList))
#define KKC_SEGMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SEGMENT_LIST, KkcSegmentListClass))
#define KKC_IS_SEGMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT_LIST))
#define KKC_IS_SEGMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SEGMENT_LIST))
#define KKC_SEGMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SEGMENT_LIST, KkcSegmentListClass))

typedef struct _KkcSegmentList KkcSegmentList;
typedef struct _KkcSegmentListClass KkcSegmentListClass;

#define KKC_TYPE_CANDIDATE_LIST (kkc_candidate_list_get_type ())
#define KKC_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE_LIST, KkcCandidateList))
#define KKC_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE_LIST, KkcCandidateListClass))
#define KKC_IS_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE_LIST))
#define KKC_IS_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE_LIST))
#define KKC_CANDIDATE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE_LIST, KkcCandidateListClass))

typedef struct _KkcCandidateList KkcCandidateList;
typedef struct _KkcCandidateListClass KkcCandidateListClass;

#define KKC_TYPE_ROM_KANA_CONVERTER (kkc_rom_kana_converter_get_type ())
#define KKC_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverter))
#define KKC_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterClass))
#define KKC_IS_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_CONVERTER))
#define KKC_IS_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_CONVERTER))
#define KKC_ROM_KANA_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterClass))

typedef struct _KkcRomKanaConverter KkcRomKanaConverter;
typedef struct _KkcRomKanaConverterClass KkcRomKanaConverterClass;

#define KKC_TYPE_ROM_KANA_CHARACTER_LIST (kkc_rom_kana_character_list_get_type ())
#define KKC_ROM_KANA_CHARACTER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterList))
#define KKC_ROM_KANA_CHARACTER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListClass))
#define KKC_IS_ROM_KANA_CHARACTER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST))
#define KKC_IS_ROM_KANA_CHARACTER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_CHARACTER_LIST))
#define KKC_ROM_KANA_CHARACTER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListClass))

typedef struct _KkcRomKanaCharacterList KkcRomKanaCharacterList;
typedef struct _KkcRomKanaCharacterListClass KkcRomKanaCharacterListClass;

#define KKC_TYPE_CANDIDATE (kkc_candidate_get_type ())
#define KKC_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE, KkcCandidate))
#define KKC_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE, KkcCandidateClass))
#define KKC_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE))
#define KKC_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE))
#define KKC_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE, KkcCandidateClass))

typedef struct _KkcCandidate KkcCandidate;
typedef struct _KkcCandidateClass KkcCandidateClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_KEY_EVENT_FILTER (kkc_key_event_filter_get_type ())
#define KKC_KEY_EVENT_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEY_EVENT_FILTER, KkcKeyEventFilter))
#define KKC_KEY_EVENT_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEY_EVENT_FILTER, KkcKeyEventFilterClass))
#define KKC_IS_KEY_EVENT_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEY_EVENT_FILTER))
#define KKC_IS_KEY_EVENT_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEY_EVENT_FILTER))
#define KKC_KEY_EVENT_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEY_EVENT_FILTER, KkcKeyEventFilterClass))

typedef struct _KkcKeyEventFilter KkcKeyEventFilter;
typedef struct _KkcKeyEventFilterClass KkcKeyEventFilterClass;

#define KKC_TYPE_KANA_MODE (kkc_kana_mode_get_type ())

#define KKC_TYPE_INPUT_MODE (kkc_input_mode_get_type ())

#define KKC_TYPE_PUNCTUATION_STYLE (kkc_punctuation_style_get_type ())

#define KKC_TYPE_RULE (kkc_rule_get_type ())
#define KKC_RULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_RULE, KkcRule))
#define KKC_RULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_RULE, KkcRuleClass))
#define KKC_IS_RULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_RULE))
#define KKC_IS_RULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_RULE))
#define KKC_RULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_RULE, KkcRuleClass))

typedef struct _KkcRule KkcRule;
typedef struct _KkcRuleClass KkcRuleClass;

struct _KkcContext {
	GObject parent_instance;
	KkcContextPrivate * priv;
};

struct _KkcContextClass {
	GObjectClass parent_class;
};

struct _KkcContextPrivate {
	KkcState* state;
	GeeMap* handlers;
};

struct _KkcState {
	GObject parent_instance;
	KkcStatePrivate * priv;
	GType handler_type;
	KkcLanguageModel* model;
	KkcDecoder* decoder;
	KkcSegmentList* segments;
	KkcCandidateList* candidates;
	KkcDictionaryList* dictionaries;
	KkcRomKanaConverter* rom_kana_converter;
	KkcRomKanaCharacterList* input_characters;
	gint input_characters_cursor_pos;
	GString* selection;
	GString* output;
	gboolean quoted;
	KkcKeyEvent* this_command_key;
	KkcKeyEvent* last_command_key;
	gchar* overriding_input;
	GeeIterator* completion_iterator;
};

struct _KkcStateClass {
	GObjectClass parent_class;
};

typedef enum  {
	KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED,
	KKC_KEY_EVENT_FORMAT_ERROR_KEYSYM_NOT_FOUND
} KkcKeyEventFormatError;
#define KKC_KEY_EVENT_FORMAT_ERROR kkc_key_event_format_error_quark ()
typedef enum  {
	KKC_KANA_MODE_HIRAGANA,
	KKC_KANA_MODE_KATAKANA,
	KKC_KANA_MODE_HANKAKU_KATAKANA,
	KKC_KANA_MODE_LATIN,
	KKC_KANA_MODE_WIDE_LATIN
} KkcKanaMode;

typedef enum  {
	KKC_INPUT_MODE_HIRAGANA = KKC_KANA_MODE_HIRAGANA,
	KKC_INPUT_MODE_KATAKANA = KKC_KANA_MODE_KATAKANA,
	KKC_INPUT_MODE_HANKAKU_KATAKANA = KKC_KANA_MODE_HANKAKU_KATAKANA,
	KKC_INPUT_MODE_LATIN = KKC_KANA_MODE_LATIN,
	KKC_INPUT_MODE_WIDE_LATIN = KKC_KANA_MODE_WIDE_LATIN,
	KKC_INPUT_MODE_DIRECT
} KkcInputMode;

typedef enum  {
	KKC_PUNCTUATION_STYLE_JA_JA,
	KKC_PUNCTUATION_STYLE_EN_EN,
	KKC_PUNCTUATION_STYLE_JA_EN,
	KKC_PUNCTUATION_STYLE_EN_JA
} KkcPunctuationStyle;


static gpointer kkc_context_parent_class = NULL;

GType kkc_context_get_type (void) G_GNUC_CONST;
GType kkc_state_get_type (void) G_GNUC_CONST;
GType kkc_state_handler_get_type (void) G_GNUC_CONST;
#define KKC_CONTEXT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_CONTEXT, KkcContextPrivate))
enum  {
	KKC_CONTEXT_DUMMY_PROPERTY,
	KKC_CONTEXT_DICTIONARIES,
	KKC_CONTEXT_CANDIDATES,
	KKC_CONTEXT_SEGMENTS,
	KKC_CONTEXT_INPUT,
	KKC_CONTEXT_INPUT_CURSOR_POS,
	KKC_CONTEXT_INPUT_MODE,
	KKC_CONTEXT_PUNCTUATION_STYLE,
	KKC_CONTEXT_AUTO_CORRECT,
	KKC_CONTEXT_TYPING_RULE,
	KKC_CONTEXT_KEY_EVENT_FILTER
};
static void kkc_context_disconnect_state_signals (KkcContext* self, KkcState* state);
GType kkc_dictionary_list_get_type (void) G_GNUC_CONST;
KkcDictionaryList* kkc_context_get_dictionaries (KkcContext* self);
void kkc_dictionary_list_clear (KkcDictionaryList* self);
GType kkc_key_event_get_type (void) G_GNUC_CONST;
static void kkc_context_filter_forwarded_cb (KkcContext* self, KkcKeyEvent* key);
static gboolean kkc_context_process_key_event_internal (KkcContext* self, KkcKeyEvent* key);
GType kkc_language_model_get_type (void) G_GNUC_CONST;
KkcContext* kkc_context_new (KkcLanguageModel* model);
KkcContext* kkc_context_construct (GType object_type, KkcLanguageModel* model);
GType kkc_initial_state_handler_get_type (void) G_GNUC_CONST;
KkcInitialStateHandler* kkc_initial_state_handler_new (void);
KkcInitialStateHandler* kkc_initial_state_handler_construct (GType object_type);
GType kkc_convert_sentence_state_handler_get_type (void) G_GNUC_CONST;
KkcConvertSentenceStateHandler* kkc_convert_sentence_state_handler_new (void);
KkcConvertSentenceStateHandler* kkc_convert_sentence_state_handler_construct (GType object_type);
GType kkc_convert_segment_state_handler_get_type (void) G_GNUC_CONST;
KkcConvertSegmentStateHandler* kkc_convert_segment_state_handler_new (void);
KkcConvertSegmentStateHandler* kkc_convert_segment_state_handler_construct (GType object_type);
KkcDictionaryList* kkc_dictionary_list_new (void);
KkcDictionaryList* kkc_dictionary_list_construct (GType object_type);
KkcState* kkc_state_new (KkcLanguageModel* model, KkcDictionaryList* dictionaries);
KkcState* kkc_state_construct (GType object_type, KkcLanguageModel* model, KkcDictionaryList* dictionaries);
static void kkc_context_connect_state_signals (KkcContext* self, KkcState* state);
static void kkc_context_notify_input_mode_cb (KkcContext* self, GObject* s, GParamSpec* p);
static void kkc_context_candidates_selected_cb (KkcContext* self);
static void kkc_context_request_selection_text_cb (KkcContext* self);
static void _kkc_context_notify_input_mode_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _kkc_context_request_selection_text_cb_kkc_state_request_selection_text (KkcState* _sender, gpointer self);
GType kkc_decoder_get_type (void) G_GNUC_CONST;
GType kkc_segment_list_get_type (void) G_GNUC_CONST;
GType kkc_candidate_list_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_converter_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_character_list_get_type (void) G_GNUC_CONST;
GType kkc_candidate_get_type (void) G_GNUC_CONST;
static void _kkc_context_candidates_selected_cb_kkc_candidate_list_selected (KkcCandidateList* _sender, KkcCandidate* candidate, gpointer self);
void kkc_context_set_selection_text (KkcContext* self, const gchar* text);
GQuark kkc_key_event_format_error_quark (void);
gboolean kkc_context_process_key_events (KkcContext* self, const gchar* keyseq, GError** error);
KkcKeyEvent* kkc_key_event_new_from_string (const gchar* key, GError** error);
KkcKeyEvent* kkc_key_event_construct_from_string (GType object_type, const gchar* key, GError** error);
gboolean kkc_context_process_key_event (KkcContext* self, KkcKeyEvent* key);
GType kkc_key_event_filter_get_type (void) G_GNUC_CONST;
KkcKeyEventFilter* kkc_context_get_key_event_filter (KkcContext* self);
KkcKeyEvent* kkc_key_event_filter_filter_key_event (KkcKeyEventFilter* self, KkcKeyEvent* key);
gboolean kkc_state_handler_process_key_event (KkcStateHandler* self, KkcState* state, KkcKeyEvent* key);
void kkc_context_reset (KkcContext* self);
void kkc_state_reset (KkcState* self);
void kkc_context_clear_output (KkcContext* self);
gboolean kkc_context_has_output (KkcContext* self);
static gchar* kkc_context_retrieve_output (KkcContext* self, gboolean clear);
gchar* kkc_context_peek_output (KkcContext* self);
gchar* kkc_context_poll_output (KkcContext* self);
void kkc_context_set_dictionaries (KkcContext* self, KkcDictionaryList* value);
KkcCandidateList* kkc_context_get_candidates (KkcContext* self);
KkcSegmentList* kkc_context_get_segments (KkcContext* self);
gchar* kkc_context_get_input (KkcContext* self);
gchar* kkc_state_get_input (KkcState* self);
gint kkc_context_get_input_cursor_pos (KkcContext* self);
gint kkc_state_get_input_cursor_pos (KkcState* self);
GType kkc_kana_mode_get_type (void) G_GNUC_CONST;
GType kkc_input_mode_get_type (void) G_GNUC_CONST;
KkcInputMode kkc_context_get_input_mode (KkcContext* self);
KkcInputMode kkc_state_get_input_mode (KkcState* self);
void kkc_context_set_input_mode (KkcContext* self, KkcInputMode value);
void kkc_state_set_input_mode (KkcState* self, KkcInputMode value);
GType kkc_punctuation_style_get_type (void) G_GNUC_CONST;
KkcPunctuationStyle kkc_context_get_punctuation_style (KkcContext* self);
KkcPunctuationStyle kkc_state_get_punctuation_style (KkcState* self);
void kkc_context_set_punctuation_style (KkcContext* self, KkcPunctuationStyle value);
void kkc_state_set_punctuation_style (KkcState* self, KkcPunctuationStyle value);
gboolean kkc_context_get_auto_correct (KkcContext* self);
gboolean kkc_state_get_auto_correct (KkcState* self);
void kkc_context_set_auto_correct (KkcContext* self, gboolean value);
void kkc_state_set_auto_correct (KkcState* self, gboolean value);
GType kkc_rule_get_type (void) G_GNUC_CONST;
KkcRule* kkc_context_get_typing_rule (KkcContext* self);
KkcRule* kkc_state_get_typing_rule (KkcState* self);
void kkc_context_set_typing_rule (KkcContext* self, KkcRule* value);
KkcKeyEventFilter* kkc_rule_get_filter (KkcRule* self);
static void _kkc_context_filter_forwarded_cb_kkc_key_event_filter_forwarded (KkcKeyEventFilter* _sender, KkcKeyEvent* key, gpointer self);
void kkc_state_set_typing_rule (KkcState* self, KkcRule* value);
static void kkc_context_finalize (GObject* obj);
static void _vala_kkc_context_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_kkc_context_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void kkc_context_filter_forwarded_cb (KkcContext* self, KkcKeyEvent* key) {
	KkcKeyEvent* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	kkc_context_process_key_event_internal (self, _tmp0_);
}


/**
         * Create a new Context.
         *
         * @param model a language model
         *
         * @return a new Context
         */
KkcContext* kkc_context_construct (GType object_type, KkcLanguageModel* model) {
	KkcContext * self = NULL;
	GeeMap* _tmp0_;
	KkcInitialStateHandler* _tmp1_;
	KkcInitialStateHandler* _tmp2_;
	GeeMap* _tmp3_;
	KkcConvertSentenceStateHandler* _tmp4_;
	KkcConvertSentenceStateHandler* _tmp5_;
	GeeMap* _tmp6_;
	KkcConvertSegmentStateHandler* _tmp7_;
	KkcConvertSegmentStateHandler* _tmp8_;
	KkcLanguageModel* _tmp9_;
	KkcDictionaryList* _tmp10_;
	KkcDictionaryList* _tmp11_;
	KkcState* _tmp12_;
	KkcState* _tmp13_;
	g_return_val_if_fail (model != NULL, NULL);
	self = (KkcContext*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->handlers;
	_tmp1_ = kkc_initial_state_handler_new ();
	_tmp2_ = _tmp1_;
	gee_map_set (_tmp0_, (gpointer) ((gintptr) KKC_TYPE_INITIAL_STATE_HANDLER), (KkcStateHandler*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->handlers;
	_tmp4_ = kkc_convert_sentence_state_handler_new ();
	_tmp5_ = _tmp4_;
	gee_map_set (_tmp3_, (gpointer) ((gintptr) KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER), (KkcStateHandler*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->handlers;
	_tmp7_ = kkc_convert_segment_state_handler_new ();
	_tmp8_ = _tmp7_;
	gee_map_set (_tmp6_, (gpointer) ((gintptr) KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER), (KkcStateHandler*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = model;
	_tmp10_ = kkc_dictionary_list_new ();
	_tmp11_ = _tmp10_;
	_tmp12_ = kkc_state_new (_tmp9_, _tmp11_);
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp12_;
	_g_object_unref0 (_tmp11_);
	_tmp13_ = self->priv->state;
	kkc_context_connect_state_signals (self, _tmp13_);
	return self;
}


KkcContext* kkc_context_new (KkcLanguageModel* model) {
	return kkc_context_construct (KKC_TYPE_CONTEXT, model);
}


static void kkc_context_notify_input_mode_cb (KkcContext* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_object_notify ((GObject*) self, "input-mode");
}


static void kkc_context_candidates_selected_cb (KkcContext* self) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject*) self, "input");
}


static void kkc_context_request_selection_text_cb (KkcContext* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "request-selection-text");
}


static void _kkc_context_notify_input_mode_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	kkc_context_notify_input_mode_cb (self, _sender, pspec);
}


static void _kkc_context_request_selection_text_cb_kkc_state_request_selection_text (KkcState* _sender, gpointer self) {
	kkc_context_request_selection_text_cb (self);
}


static void _kkc_context_candidates_selected_cb_kkc_candidate_list_selected (KkcCandidateList* _sender, KkcCandidate* candidate, gpointer self) {
	kkc_context_candidates_selected_cb (self);
}


static void kkc_context_connect_state_signals (KkcContext* self, KkcState* state) {
	KkcState* _tmp0_;
	KkcState* _tmp1_;
	KkcState* _tmp2_;
	KkcCandidateList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	_tmp0_ = state;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::input-mode", (GCallback) _kkc_context_notify_input_mode_cb_g_object_notify, self, 0);
	_tmp1_ = state;
	g_signal_connect_object (_tmp1_, "request-selection-text", (GCallback) _kkc_context_request_selection_text_cb_kkc_state_request_selection_text, self, 0);
	_tmp2_ = state;
	_tmp3_ = _tmp2_->candidates;
	g_signal_connect_object (_tmp3_, "selected", (GCallback) _kkc_context_candidates_selected_cb_kkc_candidate_list_selected, self, 0);
}


static void kkc_context_disconnect_state_signals (KkcContext* self, KkcState* state) {
	KkcState* _tmp0_;
	guint _tmp1_ = 0U;
	GQuark _tmp2_ = 0U;
	KkcState* _tmp3_;
	guint _tmp4_ = 0U;
	KkcState* _tmp5_;
	KkcCandidateList* _tmp6_;
	guint _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	_tmp0_ = state;
	g_signal_parse_name ("notify::input-mode", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _kkc_context_notify_input_mode_cb_g_object_notify, self);
	_tmp3_ = state;
	g_signal_parse_name ("request-selection-text", KKC_TYPE_STATE, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _kkc_context_request_selection_text_cb_kkc_state_request_selection_text, self);
	_tmp5_ = state;
	_tmp6_ = _tmp5_->candidates;
	g_signal_parse_name ("selected", KKC_TYPE_CANDIDATE_LIST, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _kkc_context_candidates_selected_cb_kkc_candidate_list_selected, self);
}


/**
         * Set the current selection text.
         *
         * @param text selection text
         */
void kkc_context_set_selection_text (KkcContext* self, const gchar* text) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = text;
	if (_tmp0_ == NULL) {
		KkcState* _tmp1_;
		GString* _tmp2_;
		_tmp1_ = self->priv->state;
		_tmp2_ = _tmp1_->selection;
		g_string_erase (_tmp2_, (gssize) 0, (gssize) (-1));
	} else {
		KkcState* _tmp3_;
		GString* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = self->priv->state;
		_tmp4_ = _tmp3_->selection;
		_tmp5_ = text;
		g_string_assign (_tmp4_, _tmp5_);
	}
}


/**
         * Pass key events (separated by spaces) to the context.
         *
         * This function is rarely used in programs but in unit tests.
         *
         * @param keyseq a string representing key events, separated by " "
         *
         * @return `true` if any of key events are handled, `false` otherwise
         */
static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean kkc_context_process_key_events (KkcContext* self, const gchar* keyseq, GError** error) {
	gboolean result = FALSE;
	GeeList* keys = NULL;
	GeeArrayList* _tmp0_;
	GString* builder = NULL;
	GString* _tmp1_;
	gboolean complex = FALSE;
	gboolean escaped = FALSE;
	gint index = 0;
	gunichar uc = 0U;
	gboolean _tmp32_;
	GString* _tmp34_;
	gssize _tmp35_;
	gboolean retval = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (keyseq != NULL, FALSE);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	keys = (GeeList*) _tmp0_;
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	complex = FALSE;
	escaped = FALSE;
	index = 0;
	while (TRUE) {
		const gchar* _tmp2_;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		gunichar _tmp8_;
		_tmp2_ = keyseq;
		_tmp4_ = string_get_next_char (_tmp2_, &index, &_tmp3_);
		uc = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = escaped;
		if (_tmp5_) {
			GString* _tmp6_;
			gunichar _tmp7_;
			_tmp6_ = builder;
			_tmp7_ = uc;
			g_string_append_unichar (_tmp6_, _tmp7_);
			escaped = FALSE;
			continue;
		}
		_tmp8_ = uc;
		switch (_tmp8_) {
			case '\\':
			{
				escaped = TRUE;
				break;
			}
			case '(':
			{
				gboolean _tmp9_;
				GString* _tmp11_;
				gunichar _tmp12_;
				_tmp9_ = complex;
				if (_tmp9_) {
					GError* _tmp10_;
					_tmp10_ = g_error_new_literal (KKC_KEY_EVENT_FORMAT_ERROR, KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "bare '(' is not allowed in complex keyseq");
					_inner_error_ = _tmp10_;
					if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_string_free0 (builder);
						_g_object_unref0 (keys);
						return FALSE;
					} else {
						_g_string_free0 (builder);
						_g_object_unref0 (keys);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				complex = TRUE;
				_tmp11_ = builder;
				_tmp12_ = uc;
				g_string_append_unichar (_tmp11_, _tmp12_);
				break;
			}
			case ')':
			{
				gboolean _tmp13_;
				GString* _tmp15_;
				gunichar _tmp16_;
				GeeList* _tmp17_;
				GString* _tmp18_;
				const gchar* _tmp19_;
				GString* _tmp20_;
				_tmp13_ = complex;
				if (!_tmp13_) {
					GError* _tmp14_;
					_tmp14_ = g_error_new_literal (KKC_KEY_EVENT_FORMAT_ERROR, KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "bare ')' is not allowed in simple keyseq");
					_inner_error_ = _tmp14_;
					if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_string_free0 (builder);
						_g_object_unref0 (keys);
						return FALSE;
					} else {
						_g_string_free0 (builder);
						_g_object_unref0 (keys);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				complex = FALSE;
				_tmp15_ = builder;
				_tmp16_ = uc;
				g_string_append_unichar (_tmp15_, _tmp16_);
				_tmp17_ = keys;
				_tmp18_ = builder;
				_tmp19_ = _tmp18_->str;
				gee_collection_add ((GeeCollection*) _tmp17_, _tmp19_);
				_tmp20_ = builder;
				g_string_erase (_tmp20_, (gssize) 0, (gssize) (-1));
				break;
			}
			case ' ':
			{
				gboolean _tmp21_;
				_tmp21_ = complex;
				if (_tmp21_) {
					GString* _tmp22_;
					gunichar _tmp23_;
					_tmp22_ = builder;
					_tmp23_ = uc;
					g_string_append_unichar (_tmp22_, _tmp23_);
				} else {
					GString* _tmp24_;
					gssize _tmp25_;
					_tmp24_ = builder;
					_tmp25_ = _tmp24_->len;
					if (_tmp25_ > ((gssize) 0)) {
						GeeList* _tmp26_;
						GString* _tmp27_;
						const gchar* _tmp28_;
						GString* _tmp29_;
						_tmp26_ = keys;
						_tmp27_ = builder;
						_tmp28_ = _tmp27_->str;
						gee_collection_add ((GeeCollection*) _tmp26_, _tmp28_);
						_tmp29_ = builder;
						g_string_erase (_tmp29_, (gssize) 0, (gssize) (-1));
					}
				}
				break;
			}
			default:
			{
				GString* _tmp30_;
				gunichar _tmp31_;
				_tmp30_ = builder;
				_tmp31_ = uc;
				g_string_append_unichar (_tmp30_, _tmp31_);
				break;
			}
		}
	}
	_tmp32_ = complex;
	if (_tmp32_) {
		GError* _tmp33_;
		_tmp33_ = g_error_new_literal (KKC_KEY_EVENT_FORMAT_ERROR, KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "premature end of key events");
		_inner_error_ = _tmp33_;
		if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (builder);
			_g_object_unref0 (keys);
			return FALSE;
		} else {
			_g_string_free0 (builder);
			_g_object_unref0 (keys);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp34_ = builder;
	_tmp35_ = _tmp34_->len;
	if (_tmp35_ > ((gssize) 0)) {
		GeeList* _tmp36_;
		GString* _tmp37_;
		const gchar* _tmp38_;
		_tmp36_ = keys;
		_tmp37_ = builder;
		_tmp38_ = _tmp37_->str;
		gee_collection_add ((GeeCollection*) _tmp36_, _tmp38_);
	}
	retval = FALSE;
	{
		GeeList* _key_list = NULL;
		GeeList* _tmp39_;
		GeeList* _tmp40_;
		gint _key_size = 0;
		GeeList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _key_index = 0;
		_tmp39_ = keys;
		_tmp40_ = _g_object_ref0 (_tmp39_);
		_key_list = _tmp40_;
		_tmp41_ = _key_list;
		_tmp42_ = gee_collection_get_size ((GeeCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_key_size = _tmp43_;
		_key_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			gchar* key = NULL;
			GeeList* _tmp47_;
			gint _tmp48_;
			gpointer _tmp49_ = NULL;
			const gchar* _tmp50_;
			KkcKeyEvent* ev = NULL;
			const gchar* _tmp58_;
			KkcKeyEvent* _tmp59_;
			gboolean _tmp60_ = FALSE;
			KkcKeyEvent* _tmp61_;
			gboolean _tmp62_ = FALSE;
			gboolean _tmp64_;
			_tmp44_ = _key_index;
			_key_index = _tmp44_ + 1;
			_tmp45_ = _key_index;
			_tmp46_ = _key_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _key_list;
			_tmp48_ = _key_index;
			_tmp49_ = gee_list_get (_tmp47_, _tmp48_);
			key = (gchar*) _tmp49_;
			_tmp50_ = key;
			if (g_strcmp0 (_tmp50_, "SPC") == 0) {
				gchar* _tmp51_;
				_tmp51_ = g_strdup ("space");
				_g_free0 (key);
				key = _tmp51_;
			} else {
				const gchar* _tmp52_;
				_tmp52_ = key;
				if (g_strcmp0 (_tmp52_, "TAB") == 0) {
					gchar* _tmp53_;
					_tmp53_ = g_strdup ("Tab");
					_g_free0 (key);
					key = _tmp53_;
				} else {
					const gchar* _tmp54_;
					_tmp54_ = key;
					if (g_strcmp0 (_tmp54_, "RET") == 0) {
						gchar* _tmp55_;
						_tmp55_ = g_strdup ("Return");
						_g_free0 (key);
						key = _tmp55_;
					} else {
						const gchar* _tmp56_;
						_tmp56_ = key;
						if (g_strcmp0 (_tmp56_, "DEL") == 0) {
							gchar* _tmp57_;
							_tmp57_ = g_strdup ("BackSpace");
							_g_free0 (key);
							key = _tmp57_;
						}
					}
				}
			}
			_tmp58_ = key;
			_tmp59_ = kkc_key_event_new_from_string (_tmp58_, &_inner_error_);
			ev = _tmp59_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (key);
					_g_object_unref0 (_key_list);
					_g_string_free0 (builder);
					_g_object_unref0 (keys);
					return FALSE;
				} else {
					_g_free0 (key);
					_g_object_unref0 (_key_list);
					_g_string_free0 (builder);
					_g_object_unref0 (keys);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			_tmp61_ = ev;
			_tmp62_ = kkc_context_process_key_event (self, _tmp61_);
			if (_tmp62_) {
				gboolean _tmp63_;
				_tmp63_ = retval;
				_tmp60_ = !_tmp63_;
			} else {
				_tmp60_ = FALSE;
			}
			_tmp64_ = _tmp60_;
			if (_tmp64_) {
				retval = TRUE;
			}
			_g_object_unref0 (ev);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_list);
	}
	result = retval;
	_g_string_free0 (builder);
	_g_object_unref0 (keys);
	return result;
}


/**
         * Pass one key event to the context.
         *
         * @param key a key event
         *
         * @return `true` if the key event is handled, `false` otherwise
         */
gboolean kkc_context_process_key_event (KkcContext* self, KkcKeyEvent* key) {
	gboolean result = FALSE;
	KkcKeyEvent* _key = NULL;
	KkcKeyEventFilter* _tmp0_;
	KkcKeyEventFilter* _tmp1_;
	KkcKeyEventFilter* _tmp2_;
	KkcKeyEvent* _tmp3_;
	KkcKeyEvent* _tmp4_ = NULL;
	KkcKeyEvent* _tmp5_;
	KkcKeyEvent* _tmp6_;
	KkcKeyEvent* _tmp7_;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = kkc_context_get_key_event_filter (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = key;
	_tmp4_ = kkc_key_event_filter_filter_key_event (_tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	_key = _tmp5_;
	_tmp6_ = _key;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_g_object_unref0 (_key);
		return result;
	}
	_tmp7_ = _key;
	_tmp8_ = kkc_context_process_key_event_internal (self, _tmp7_);
	result = _tmp8_;
	_g_object_unref0 (_key);
	return result;
}


static gboolean kkc_context_process_key_event_internal (KkcContext* self, KkcKeyEvent* key) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	while (TRUE) {
		GType handler_type = 0UL;
		KkcState* _tmp0_;
		GType _tmp1_;
		KkcStateHandler* handler = NULL;
		GeeMap* _tmp2_;
		GType _tmp3_;
		gpointer _tmp4_ = NULL;
		KkcState* _tmp5_;
		KkcKeyEvent* _tmp6_;
		KkcKeyEvent* _tmp7_;
		KkcStateHandler* _tmp8_;
		KkcState* _tmp9_;
		KkcKeyEvent* _tmp10_;
		gboolean _tmp11_ = FALSE;
		GType _tmp15_;
		KkcState* _tmp16_;
		GType _tmp17_;
		_tmp0_ = self->priv->state;
		_tmp1_ = _tmp0_->handler_type;
		handler_type = _tmp1_;
		_tmp2_ = self->priv->handlers;
		_tmp3_ = handler_type;
		_tmp4_ = gee_map_get (_tmp2_, (gpointer) ((gintptr) _tmp3_));
		handler = (KkcStateHandler*) _tmp4_;
		_tmp5_ = self->priv->state;
		_tmp6_ = key;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (_tmp5_->this_command_key);
		_tmp5_->this_command_key = _tmp7_;
		_tmp8_ = handler;
		_tmp9_ = self->priv->state;
		_tmp10_ = key;
		_tmp11_ = kkc_state_handler_process_key_event (_tmp8_, _tmp9_, _tmp10_);
		if (_tmp11_) {
			KkcState* _tmp12_;
			KkcKeyEvent* _tmp13_;
			KkcKeyEvent* _tmp14_;
			g_object_notify ((GObject*) self, "input");
			_tmp12_ = self->priv->state;
			_tmp13_ = key;
			_tmp14_ = _g_object_ref0 (_tmp13_);
			_g_object_unref0 (_tmp12_->last_command_key);
			_tmp12_->last_command_key = _tmp14_;
			result = TRUE;
			_g_object_unref0 (handler);
			return result;
		}
		_tmp15_ = handler_type;
		_tmp16_ = self->priv->state;
		_tmp17_ = _tmp16_->handler_type;
		if (_tmp15_ == _tmp17_) {
			result = FALSE;
			_g_object_unref0 (handler);
			return result;
		}
		_g_object_unref0 (handler);
	}
}


/**
         * Reset the context.
         */
void kkc_context_reset (KkcContext* self) {
	KkcState* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	kkc_state_reset (_tmp0_);
	kkc_context_clear_output (self);
}


/**
         * Check if there is pending output
         *
         * @return `true` if there is output, `false` otherwise
         */
gboolean kkc_context_has_output (KkcContext* self) {
	gboolean result = FALSE;
	KkcState* _tmp0_;
	GString* _tmp1_;
	gssize _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->output;
	_tmp2_ = _tmp1_->len;
	result = _tmp2_ > ((gssize) 0);
	return result;
}


static gchar* kkc_context_retrieve_output (KkcContext* self, gboolean clear) {
	gchar* result = NULL;
	gchar* output = NULL;
	gchar* _tmp0_;
	KkcState* _tmp1_;
	GString* _tmp2_;
	gssize _tmp3_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	output = _tmp0_;
	_tmp1_ = self->priv->state;
	_tmp2_ = _tmp1_->output;
	_tmp3_ = _tmp2_->len;
	if (_tmp3_ > ((gssize) 0)) {
		KkcState* _tmp4_;
		GString* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = self->priv->state;
		_tmp5_ = _tmp4_->output;
		_tmp6_ = _tmp5_->str;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (output);
		output = _tmp7_;
	}
	_tmp8_ = clear;
	if (_tmp8_) {
		KkcState* _tmp9_;
		GString* _tmp10_;
		_tmp9_ = self->priv->state;
		_tmp10_ = _tmp9_->output;
		g_string_erase (_tmp10_, (gssize) 0, (gssize) (-1));
	}
	result = output;
	return result;
}


/**
         * Peek (retrieve, but not remove) the current output string.
         *
         * @return an output string
         */
gchar* kkc_context_peek_output (KkcContext* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = kkc_context_retrieve_output (self, FALSE);
	result = _tmp0_;
	return result;
}


/**
         * Poll (retrieve and remove) the current output string.
         *
         * @return an output string
         */
gchar* kkc_context_poll_output (KkcContext* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = kkc_context_retrieve_output (self, TRUE);
	result = _tmp0_;
	return result;
}


/**
         * Clear the output buffer.
         */
void kkc_context_clear_output (KkcContext* self) {
	KkcState* _tmp0_;
	GString* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->output;
	g_string_erase (_tmp1_, (gssize) 0, (gssize) (-1));
}


KkcDictionaryList* kkc_context_get_dictionaries (KkcContext* self) {
	KkcDictionaryList* result;
	KkcState* _tmp0_;
	KkcDictionaryList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->dictionaries;
	result = _tmp1_;
	return result;
}


void kkc_context_set_dictionaries (KkcContext* self, KkcDictionaryList* value) {
	KkcState* _tmp0_;
	KkcDictionaryList* _tmp1_;
	KkcDictionaryList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = value;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_tmp0_->dictionaries);
	_tmp0_->dictionaries = _tmp2_;
	g_object_notify ((GObject *) self, "dictionaries");
}


KkcCandidateList* kkc_context_get_candidates (KkcContext* self) {
	KkcCandidateList* result;
	KkcState* _tmp0_;
	KkcCandidateList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->candidates;
	result = _tmp1_;
	return result;
}


KkcSegmentList* kkc_context_get_segments (KkcContext* self) {
	KkcSegmentList* result;
	KkcState* _tmp0_;
	KkcSegmentList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->segments;
	result = _tmp1_;
	return result;
}


gchar* kkc_context_get_input (KkcContext* self) {
	gchar* result;
	KkcState* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_input (_tmp0_);
	result = _tmp1_;
	return result;
}


gint kkc_context_get_input_cursor_pos (KkcContext* self) {
	gint result;
	KkcState* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_input_cursor_pos (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


KkcInputMode kkc_context_get_input_mode (KkcContext* self) {
	KkcInputMode result;
	KkcState* _tmp0_;
	KkcInputMode _tmp1_;
	KkcInputMode _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_input_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void kkc_context_set_input_mode (KkcContext* self, KkcInputMode value) {
	KkcState* _tmp0_;
	KkcInputMode _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = value;
	kkc_state_set_input_mode (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "input-mode");
}


KkcPunctuationStyle kkc_context_get_punctuation_style (KkcContext* self) {
	KkcPunctuationStyle result;
	KkcState* _tmp0_;
	KkcPunctuationStyle _tmp1_;
	KkcPunctuationStyle _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_punctuation_style (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void kkc_context_set_punctuation_style (KkcContext* self, KkcPunctuationStyle value) {
	KkcState* _tmp0_;
	KkcPunctuationStyle _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = value;
	kkc_state_set_punctuation_style (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "punctuation-style");
}


gboolean kkc_context_get_auto_correct (KkcContext* self) {
	gboolean result;
	KkcState* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_auto_correct (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void kkc_context_set_auto_correct (KkcContext* self, gboolean value) {
	KkcState* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = value;
	kkc_state_set_auto_correct (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "auto-correct");
}


KkcRule* kkc_context_get_typing_rule (KkcContext* self) {
	KkcRule* result;
	KkcState* _tmp0_;
	KkcRule* _tmp1_;
	KkcRule* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_typing_rule (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void _kkc_context_filter_forwarded_cb_kkc_key_event_filter_forwarded (KkcKeyEventFilter* _sender, KkcKeyEvent* key, gpointer self) {
	kkc_context_filter_forwarded_cb (self, key);
}


void kkc_context_set_typing_rule (KkcContext* self, KkcRule* value) {
	KkcState* _tmp0_;
	KkcRule* _tmp1_;
	KkcRule* _tmp2_;
	KkcKeyEventFilter* _tmp3_;
	KkcKeyEventFilter* _tmp4_;
	guint _tmp5_ = 0U;
	KkcState* _tmp6_;
	KkcRule* _tmp7_;
	KkcState* _tmp8_;
	KkcRule* _tmp9_;
	KkcRule* _tmp10_;
	KkcKeyEventFilter* _tmp11_;
	KkcKeyEventFilter* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_typing_rule (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = kkc_rule_get_filter (_tmp2_);
	_tmp4_ = _tmp3_;
	g_signal_parse_name ("forwarded", KKC_TYPE_KEY_EVENT_FILTER, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _kkc_context_filter_forwarded_cb_kkc_key_event_filter_forwarded, self);
	_tmp6_ = self->priv->state;
	_tmp7_ = value;
	kkc_state_set_typing_rule (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->state;
	_tmp9_ = kkc_state_get_typing_rule (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = kkc_rule_get_filter (_tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_connect_object (_tmp12_, "forwarded", (GCallback) _kkc_context_filter_forwarded_cb_kkc_key_event_filter_forwarded, self, 0);
	g_object_notify ((GObject *) self, "typing-rule");
}


KkcKeyEventFilter* kkc_context_get_key_event_filter (KkcContext* self) {
	KkcKeyEventFilter* result;
	KkcState* _tmp0_;
	KkcRule* _tmp1_;
	KkcRule* _tmp2_;
	KkcKeyEventFilter* _tmp3_;
	KkcKeyEventFilter* _tmp4_;
	KkcKeyEventFilter* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_typing_rule (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = kkc_rule_get_filter (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}


static void kkc_context_class_init (KkcContextClass * klass) {
	kkc_context_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcContextPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_context_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_kkc_context_set_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_context_finalize;
	/**
	         * Dictionaries.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_DICTIONARIES, g_param_spec_object ("dictionaries", "dictionaries", "dictionaries", KKC_TYPE_DICTIONARY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Current candidates.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_CANDIDATES, g_param_spec_object ("candidates", "candidates", "candidates", KKC_TYPE_CANDIDATE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Current segments.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_SEGMENTS, g_param_spec_object ("segments", "segments", "segments", KKC_TYPE_SEGMENT_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Current input string.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_INPUT, g_param_spec_string ("input", "input", "input", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Current cursor position in input string.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_INPUT_CURSOR_POS, g_param_spec_int ("input-cursor-pos", "input-cursor-pos", "input-cursor-pos", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Current input mode.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_INPUT_MODE, g_param_spec_enum ("input-mode", "input-mode", "input-mode", KKC_TYPE_INPUT_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Punctuation style used in romaji-to-kana conversion.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_PUNCTUATION_STYLE, g_param_spec_enum ("punctuation-style", "punctuation-style", "punctuation-style", KKC_TYPE_PUNCTUATION_STYLE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Flag to indicate if romaji-to-kana conversion is auto-corrected.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_AUTO_CORRECT, g_param_spec_boolean ("auto-correct", "auto-correct", "auto-correct", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The name of typing rule.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_TYPING_RULE, g_param_spec_object ("typing-rule", "typing-rule", "typing-rule", KKC_TYPE_RULE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Filter which runs before process_key_event.
	         *
	         * This is particularly useful for NICOLA.
	         * @see NicolaKeyEventFilter
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_KEY_EVENT_FILTER, g_param_spec_object ("key-event-filter", "key-event-filter", "key-event-filter", KKC_TYPE_KEY_EVENT_FILTER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("request_selection_text", KKC_TYPE_CONTEXT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void kkc_context_instance_init (KkcContext * self) {
	GeeHashMap* _tmp0_;
	self->priv = KKC_CONTEXT_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_GTYPE, NULL, NULL, KKC_TYPE_STATE_HANDLER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->handlers = (GeeMap*) _tmp0_;
}


static void kkc_context_finalize (GObject* obj) {
	KkcContext * self;
	KkcState* _tmp0_;
	KkcDictionaryList* _tmp1_;
	KkcDictionaryList* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_CONTEXT, KkcContext);
	_tmp0_ = self->priv->state;
	kkc_context_disconnect_state_signals (self, _tmp0_);
	_tmp1_ = kkc_context_get_dictionaries (self);
	_tmp2_ = _tmp1_;
	kkc_dictionary_list_clear (_tmp2_);
	_g_object_unref0 (self->priv->state);
	_g_object_unref0 (self->priv->handlers);
	G_OBJECT_CLASS (kkc_context_parent_class)->finalize (obj);
}


/**
     * Main entry point of libkkc.
     */
GType kkc_context_get_type (void) {
	static volatile gsize kkc_context_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcContext), 0, (GInstanceInitFunc) kkc_context_instance_init, NULL };
		GType kkc_context_type_id;
		kkc_context_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcContext", &g_define_type_info, 0);
		g_once_init_leave (&kkc_context_type_id__volatile, kkc_context_type_id);
	}
	return kkc_context_type_id__volatile;
}


static void _vala_kkc_context_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_CONTEXT, KkcContext);
	switch (property_id) {
		case KKC_CONTEXT_DICTIONARIES:
		g_value_set_object (value, kkc_context_get_dictionaries (self));
		break;
		case KKC_CONTEXT_CANDIDATES:
		g_value_set_object (value, kkc_context_get_candidates (self));
		break;
		case KKC_CONTEXT_SEGMENTS:
		g_value_set_object (value, kkc_context_get_segments (self));
		break;
		case KKC_CONTEXT_INPUT:
		g_value_take_string (value, kkc_context_get_input (self));
		break;
		case KKC_CONTEXT_INPUT_CURSOR_POS:
		g_value_set_int (value, kkc_context_get_input_cursor_pos (self));
		break;
		case KKC_CONTEXT_INPUT_MODE:
		g_value_set_enum (value, kkc_context_get_input_mode (self));
		break;
		case KKC_CONTEXT_PUNCTUATION_STYLE:
		g_value_set_enum (value, kkc_context_get_punctuation_style (self));
		break;
		case KKC_CONTEXT_AUTO_CORRECT:
		g_value_set_boolean (value, kkc_context_get_auto_correct (self));
		break;
		case KKC_CONTEXT_TYPING_RULE:
		g_value_set_object (value, kkc_context_get_typing_rule (self));
		break;
		case KKC_CONTEXT_KEY_EVENT_FILTER:
		g_value_take_object (value, kkc_context_get_key_event_filter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_kkc_context_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	KkcContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_CONTEXT, KkcContext);
	switch (property_id) {
		case KKC_CONTEXT_DICTIONARIES:
		kkc_context_set_dictionaries (self, g_value_get_object (value));
		break;
		case KKC_CONTEXT_INPUT_MODE:
		kkc_context_set_input_mode (self, g_value_get_enum (value));
		break;
		case KKC_CONTEXT_PUNCTUATION_STYLE:
		kkc_context_set_punctuation_style (self, g_value_get_enum (value));
		break;
		case KKC_CONTEXT_AUTO_CORRECT:
		kkc_context_set_auto_correct (self, g_value_get_boolean (value));
		break;
		case KKC_CONTEXT_TYPING_RULE:
		kkc_context_set_typing_rule (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



