/* bigram-decoder.c generated by valac 0.20.1.19-a6516, the Vala compiler
 * generated from bigram-decoder.vala, do not modify */

/*
 * Copyright (C) 2012-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2012-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define KKC_TYPE_NBEST_NODE (kkc_nbest_node_get_type ())
#define KKC_NBEST_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_NBEST_NODE, KkcNbestNode))
#define KKC_NBEST_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_NBEST_NODE, KkcNbestNodeClass))
#define KKC_IS_NBEST_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_NBEST_NODE))
#define KKC_IS_NBEST_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_NBEST_NODE))
#define KKC_NBEST_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_NBEST_NODE, KkcNbestNodeClass))

typedef struct _KkcNbestNode KkcNbestNode;
typedef struct _KkcNbestNodeClass KkcNbestNodeClass;
typedef struct _KkcNbestNodePrivate KkcNbestNodePrivate;

#define KKC_TYPE_TRELLIS_NODE (kkc_trellis_node_get_type ())
#define KKC_TRELLIS_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_TRELLIS_NODE, KkcTrellisNode))
#define KKC_TRELLIS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_TRELLIS_NODE, KkcTrellisNodeClass))
#define KKC_IS_TRELLIS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_TRELLIS_NODE))
#define KKC_IS_TRELLIS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_TRELLIS_NODE))
#define KKC_TRELLIS_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_TRELLIS_NODE, KkcTrellisNodeClass))

typedef struct _KkcTrellisNode KkcTrellisNode;
typedef struct _KkcTrellisNodeClass KkcTrellisNodeClass;
#define _kkc_trellis_node_unref0(var) ((var == NULL) ? NULL : (var = (kkc_trellis_node_unref (var), NULL)))
#define _kkc_nbest_node_unref0(var) ((var == NULL) ? NULL : (var = (kkc_nbest_node_unref (var), NULL)))
typedef struct _KkcParamSpecNbestNode KkcParamSpecNbestNode;

#define KKC_TYPE_DECODER (kkc_decoder_get_type ())
#define KKC_DECODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DECODER, KkcDecoder))
#define KKC_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_DECODER, KkcDecoderClass))
#define KKC_IS_DECODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DECODER))
#define KKC_IS_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_DECODER))
#define KKC_DECODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_DECODER, KkcDecoderClass))

typedef struct _KkcDecoder KkcDecoder;
typedef struct _KkcDecoderClass KkcDecoderClass;
typedef struct _KkcDecoderPrivate KkcDecoderPrivate;

#define KKC_TYPE_SEGMENT (kkc_segment_get_type ())
#define KKC_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT, KkcSegment))
#define KKC_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SEGMENT, KkcSegmentClass))
#define KKC_IS_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT))
#define KKC_IS_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SEGMENT))
#define KKC_SEGMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SEGMENT, KkcSegmentClass))

typedef struct _KkcSegment KkcSegment;
typedef struct _KkcSegmentClass KkcSegmentClass;

#define KKC_TYPE_BIGRAM_DECODER (kkc_bigram_decoder_get_type ())
#define KKC_BIGRAM_DECODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_BIGRAM_DECODER, KkcBigramDecoder))
#define KKC_BIGRAM_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_BIGRAM_DECODER, KkcBigramDecoderClass))
#define KKC_IS_BIGRAM_DECODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_BIGRAM_DECODER))
#define KKC_IS_BIGRAM_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_BIGRAM_DECODER))
#define KKC_BIGRAM_DECODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_BIGRAM_DECODER, KkcBigramDecoderClass))

typedef struct _KkcBigramDecoder KkcBigramDecoder;
typedef struct _KkcBigramDecoderClass KkcBigramDecoderClass;
typedef struct _KkcBigramDecoderPrivate KkcBigramDecoderPrivate;

#define KKC_TYPE_LANGUAGE_MODEL (kkc_language_model_get_type ())
#define KKC_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel))
#define KKC_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))
#define KKC_IS_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_IS_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))

typedef struct _KkcLanguageModel KkcLanguageModel;
typedef struct _KkcLanguageModelClass KkcLanguageModelClass;

#define KKC_TYPE_UNIGRAM_LANGUAGE_MODEL (kkc_unigram_language_model_get_type ())
#define KKC_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModel))
#define KKC_IS_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL))
#define KKC_UNIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModelIface))

typedef struct _KkcUnigramLanguageModel KkcUnigramLanguageModel;
typedef struct _KkcUnigramLanguageModelIface KkcUnigramLanguageModelIface;

#define KKC_TYPE_LANGUAGE_MODEL_ENTRY (kkc_language_model_entry_get_type ())
typedef struct _KkcLanguageModelEntry KkcLanguageModelEntry;

#define KKC_TYPE_BIGRAM_LANGUAGE_MODEL (kkc_bigram_language_model_get_type ())
#define KKC_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModel))
#define KKC_IS_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL))
#define KKC_BIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModelIface))

typedef struct _KkcBigramLanguageModel KkcBigramLanguageModel;
typedef struct _KkcBigramLanguageModelIface KkcBigramLanguageModelIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_UNIGRAM_TRELLIS_NODE (kkc_unigram_trellis_node_get_type ())
#define KKC_UNIGRAM_TRELLIS_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_UNIGRAM_TRELLIS_NODE, KkcUnigramTrellisNode))
#define KKC_UNIGRAM_TRELLIS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_UNIGRAM_TRELLIS_NODE, KkcUnigramTrellisNodeClass))
#define KKC_IS_UNIGRAM_TRELLIS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_UNIGRAM_TRELLIS_NODE))
#define KKC_IS_UNIGRAM_TRELLIS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_UNIGRAM_TRELLIS_NODE))
#define KKC_UNIGRAM_TRELLIS_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_UNIGRAM_TRELLIS_NODE, KkcUnigramTrellisNodeClass))

typedef struct _KkcUnigramTrellisNode KkcUnigramTrellisNode;
typedef struct _KkcUnigramTrellisNodeClass KkcUnigramTrellisNodeClass;
#define _kkc_language_model_entry_free0(var) ((var == NULL) ? NULL : (var = (kkc_language_model_entry_free (var), NULL)))
typedef struct _KkcTrellisNodePrivate KkcTrellisNodePrivate;
typedef struct _KkcSegmentPrivate KkcSegmentPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KkcNbestNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	KkcNbestNodePrivate * priv;
	KkcTrellisNode* node;
	gdouble gn;
	gdouble fn;
	KkcNbestNode* next;
};

struct _KkcNbestNodeClass {
	GTypeClass parent_class;
	void (*finalize) (KkcNbestNode *self);
};

struct _KkcParamSpecNbestNode {
	GParamSpec parent_instance;
};

struct _KkcDecoder {
	GObject parent_instance;
	KkcDecoderPrivate * priv;
};

struct _KkcDecoderClass {
	GObjectClass parent_class;
	KkcSegment** (*decode) (KkcDecoder* self, const gchar* input, gint nbest, gint* constraint, int constraint_length1, int* result_length1);
	KkcSegment** (*decode_with_costs) (KkcDecoder* self, const gchar* input, gint nbest, gint* constraint, int constraint_length1, gdouble max_distance, gdouble min_path_cost, int* result_length1);
};

struct _KkcBigramDecoder {
	KkcDecoder parent_instance;
	KkcBigramDecoderPrivate * priv;
};

struct _KkcBigramDecoderClass {
	KkcDecoderClass parent_class;
	gdouble (*path_cost) (KkcBigramDecoder* self, KkcTrellisNode* pnode, KkcTrellisNode* node, gint endpos);
};

struct _KkcLanguageModelEntry {
	gchar* input;
	gchar* output;
	guint id;
};

struct _KkcUnigramLanguageModelIface {
	GTypeInterface parent_iface;
	gdouble (*unigram_cost) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
	gdouble (*unigram_backoff) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
};

struct _KkcBigramLanguageModelIface {
	GTypeInterface parent_iface;
	gboolean (*has_bigram) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_cost) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_backoff) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
};

struct _KkcBigramDecoderPrivate {
	KkcBigramLanguageModel* _model;
};

struct _KkcTrellisNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	KkcTrellisNodePrivate * priv;
	KkcTrellisNode* previous;
	gdouble cumulative_cost;
};

struct _KkcTrellisNodeClass {
	GTypeClass parent_class;
	void (*finalize) (KkcTrellisNode *self);
	gchar* (*to_string) (KkcTrellisNode* self);
	guint (*get_endpos) (KkcTrellisNode* self);
	guint (*get_length) (KkcTrellisNode* self);
	const gchar* (*get_input) (KkcTrellisNode* self);
	const gchar* (*get_output) (KkcTrellisNode* self);
	KkcLanguageModelEntry* (*get_entries) (KkcTrellisNode* self, int* result_length1);
};

struct _KkcSegment {
	GObject parent_instance;
	KkcSegmentPrivate * priv;
	KkcSegment* next;
};

struct _KkcSegmentClass {
	GObjectClass parent_class;
};


static gpointer kkc_nbest_node_parent_class = NULL;
static gpointer kkc_bigram_decoder_parent_class = NULL;

gpointer kkc_nbest_node_ref (gpointer instance);
void kkc_nbest_node_unref (gpointer instance);
GParamSpec* kkc_param_spec_nbest_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void kkc_value_set_nbest_node (GValue* value, gpointer v_object);
void kkc_value_take_nbest_node (GValue* value, gpointer v_object);
gpointer kkc_value_get_nbest_node (const GValue* value);
GType kkc_nbest_node_get_type (void) G_GNUC_CONST;
gpointer kkc_trellis_node_ref (gpointer instance);
void kkc_trellis_node_unref (gpointer instance);
GParamSpec* kkc_param_spec_trellis_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void kkc_value_set_trellis_node (GValue* value, gpointer v_object);
void kkc_value_take_trellis_node (GValue* value, gpointer v_object);
gpointer kkc_value_get_trellis_node (const GValue* value);
GType kkc_trellis_node_get_type (void) G_GNUC_CONST;
enum  {
	KKC_NBEST_NODE_DUMMY_PROPERTY
};
KkcNbestNode* kkc_nbest_node_new (KkcTrellisNode* node);
KkcNbestNode* kkc_nbest_node_construct (GType object_type, KkcTrellisNode* node);
static void kkc_nbest_node_finalize (KkcNbestNode* obj);
GType kkc_decoder_get_type (void) G_GNUC_CONST;
GType kkc_segment_get_type (void) G_GNUC_CONST;
GType kkc_bigram_decoder_get_type (void) G_GNUC_CONST;
GType kkc_language_model_get_type (void) G_GNUC_CONST;
GType kkc_language_model_entry_get_type (void) G_GNUC_CONST;
KkcLanguageModelEntry* kkc_language_model_entry_dup (const KkcLanguageModelEntry* self);
void kkc_language_model_entry_free (KkcLanguageModelEntry* self);
void kkc_language_model_entry_copy (const KkcLanguageModelEntry* self, KkcLanguageModelEntry* dest);
void kkc_language_model_entry_destroy (KkcLanguageModelEntry* self);
GType kkc_unigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_bigram_language_model_get_type (void) G_GNUC_CONST;
#define KKC_BIGRAM_DECODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_BIGRAM_DECODER, KkcBigramDecoderPrivate))
enum  {
	KKC_BIGRAM_DECODER_DUMMY_PROPERTY,
	KKC_BIGRAM_DECODER_MODEL
};
static KkcSegment** kkc_bigram_decoder_real_decode (KkcDecoder* base, const gchar* input, gint nbest, gint* constraint, int constraint_length1, int* result_length1);
KkcSegment** kkc_decoder_decode_with_costs (KkcDecoder* self, const gchar* input, gint nbest, gint* constraint, int constraint_length1, gdouble max_distance, gdouble min_path_cost, int* result_length1);
static KkcSegment** kkc_bigram_decoder_real_decode_with_costs (KkcDecoder* base, const gchar* input, gint nbest, gint* constraint, int constraint_length1, gdouble max_distance, gdouble min_path_cost, int* result_length1);
GeeArrayList** kkc_bigram_decoder_build_trellis (KkcBigramDecoder* self, const gchar* input, gint* constraint, int constraint_length1, int* result_length1);
void kkc_bigram_decoder_add_unknown_nodes (KkcBigramDecoder* self, GeeArrayList** trellis, int trellis_length1, const gchar* input, gint* constraint, int constraint_length1);
void kkc_bigram_decoder_forward_search (KkcBigramDecoder* self, GeeArrayList** trellis, int trellis_length1, const gchar* input);
KkcSegment** kkc_bigram_decoder_backward_search (KkcBigramDecoder* self, GeeArrayList** trellis, int trellis_length1, gint nbest, gdouble max_distance, gdouble min_path_cost, int* result_length1);
static gboolean kkc_bigram_decoder_check_overlaps (KkcBigramDecoder* self, gint* constraint, int constraint_length1, gint i, gint j);
GType kkc_unigram_trellis_node_get_type (void) G_GNUC_CONST;
KkcUnigramTrellisNode* kkc_unigram_trellis_node_new (KkcLanguageModelEntry* entry, guint endpos);
KkcUnigramTrellisNode* kkc_unigram_trellis_node_construct (GType object_type, KkcLanguageModelEntry* entry, guint endpos);
KkcBigramLanguageModel* kkc_bigram_decoder_get_model (KkcBigramDecoder* self);
void kkc_language_model_get_bos (KkcLanguageModel* self, KkcLanguageModelEntry* result);
void kkc_language_model_get_eos (KkcLanguageModel* self, KkcLanguageModelEntry* result);
GeeCollection* kkc_language_model_entries (KkcLanguageModel* self, const gchar* input);
static gboolean kkc_bigram_decoder_check_constraint (KkcBigramDecoder* self, gint* constraint, int constraint_length1, gint i, gint j);
guint kkc_trellis_node_get_length (KkcTrellisNode* self);
gdouble kkc_bigram_decoder_path_cost (KkcBigramDecoder* self, KkcTrellisNode* pnode, KkcTrellisNode* node, gint endpos);
static gdouble kkc_bigram_decoder_real_path_cost (KkcBigramDecoder* self, KkcTrellisNode* pnode, KkcTrellisNode* node, gint endpos);
gdouble kkc_bigram_language_model_bigram_backoff_cost (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
void kkc_unigram_trellis_node_get_entry (KkcUnigramTrellisNode* self, KkcLanguageModelEntry* result);
static KkcSegment* kkc_bigram_decoder_nbest_node_to_segment (KkcBigramDecoder* self, KkcNbestNode* nbest_node);
KkcLanguageModelEntry* kkc_trellis_node_get_entries (KkcTrellisNode* self, int* result_length1);
KkcSegment* kkc_segment_new (const gchar* input, const gchar* output);
KkcSegment* kkc_segment_construct (GType object_type, const gchar* input, const gchar* output);
static gboolean _kkc_language_model_entry_equal (const KkcLanguageModelEntry* s1, const KkcLanguageModelEntry* s2);
static gint kkc_bigram_decoder_compare_nbest_node (KkcNbestNode* a, KkcNbestNode* b);
static gchar* kkc_bigram_decoder_concat_nbest_node_outputs (KkcBigramDecoder* self, KkcNbestNode* nbest_node);
guint kkc_trellis_node_get_endpos (KkcTrellisNode* self);
const gchar* kkc_trellis_node_get_output (KkcTrellisNode* self);
KkcBigramDecoder* kkc_bigram_decoder_new (KkcBigramLanguageModel* model);
KkcBigramDecoder* kkc_bigram_decoder_construct (GType object_type, KkcBigramLanguageModel* model);
KkcDecoder* kkc_decoder_construct (GType object_type);
static void kkc_bigram_decoder_finalize (GObject* obj);
static void _vala_kkc_bigram_decoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _kkc_trellis_node_ref0 (gpointer self) {
	return self ? kkc_trellis_node_ref (self) : NULL;
}


KkcNbestNode* kkc_nbest_node_construct (GType object_type, KkcTrellisNode* node) {
	KkcNbestNode* self = NULL;
	KkcTrellisNode* _tmp0_;
	KkcTrellisNode* _tmp1_;
	g_return_val_if_fail (node != NULL, NULL);
	self = (KkcNbestNode*) g_type_create_instance (object_type);
	_tmp0_ = node;
	_tmp1_ = _kkc_trellis_node_ref0 (_tmp0_);
	_kkc_trellis_node_unref0 (self->node);
	self->node = _tmp1_;
	return self;
}


KkcNbestNode* kkc_nbest_node_new (KkcTrellisNode* node) {
	return kkc_nbest_node_construct (KKC_TYPE_NBEST_NODE, node);
}


static void kkc_value_nbest_node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void kkc_value_nbest_node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		kkc_nbest_node_unref (value->data[0].v_pointer);
	}
}


static void kkc_value_nbest_node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = kkc_nbest_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer kkc_value_nbest_node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* kkc_value_nbest_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		KkcNbestNode* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = kkc_nbest_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* kkc_value_nbest_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	KkcNbestNode** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = kkc_nbest_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* kkc_param_spec_nbest_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	KkcParamSpecNbestNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, KKC_TYPE_NBEST_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer kkc_value_get_nbest_node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KKC_TYPE_NBEST_NODE), NULL);
	return value->data[0].v_pointer;
}


void kkc_value_set_nbest_node (GValue* value, gpointer v_object) {
	KkcNbestNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KKC_TYPE_NBEST_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, KKC_TYPE_NBEST_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		kkc_nbest_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		kkc_nbest_node_unref (old);
	}
}


void kkc_value_take_nbest_node (GValue* value, gpointer v_object) {
	KkcNbestNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KKC_TYPE_NBEST_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, KKC_TYPE_NBEST_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		kkc_nbest_node_unref (old);
	}
}


static void kkc_nbest_node_class_init (KkcNbestNodeClass * klass) {
	kkc_nbest_node_parent_class = g_type_class_peek_parent (klass);
	KKC_NBEST_NODE_CLASS (klass)->finalize = kkc_nbest_node_finalize;
}


static void kkc_nbest_node_instance_init (KkcNbestNode * self) {
	gdouble _tmp0_;
	self->gn = 0.0;
	_tmp0_ = DBL_MAX;
	self->fn = _tmp0_;
	self->ref_count = 1;
}


static void kkc_nbest_node_finalize (KkcNbestNode* obj) {
	KkcNbestNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_NBEST_NODE, KkcNbestNode);
	_kkc_trellis_node_unref0 (self->node);
	_kkc_nbest_node_unref0 (self->next);
}


GType kkc_nbest_node_get_type (void) {
	static volatile gsize kkc_nbest_node_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_nbest_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { kkc_value_nbest_node_init, kkc_value_nbest_node_free_value, kkc_value_nbest_node_copy_value, kkc_value_nbest_node_peek_pointer, "p", kkc_value_nbest_node_collect_value, "p", kkc_value_nbest_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (KkcNbestNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_nbest_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcNbestNode), 0, (GInstanceInitFunc) kkc_nbest_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType kkc_nbest_node_type_id;
		kkc_nbest_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "KkcNbestNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&kkc_nbest_node_type_id__volatile, kkc_nbest_node_type_id);
	}
	return kkc_nbest_node_type_id__volatile;
}


gpointer kkc_nbest_node_ref (gpointer instance) {
	KkcNbestNode* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void kkc_nbest_node_unref (gpointer instance) {
	KkcNbestNode* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		KKC_NBEST_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static KkcSegment** kkc_bigram_decoder_real_decode (KkcDecoder* base, const gchar* input, gint nbest, gint* constraint, int constraint_length1, int* result_length1) {
	KkcBigramDecoder * self;
	KkcSegment** result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gint _tmp5_ = 0;
	KkcSegment** _tmp6_ = NULL;
	KkcSegment** _tmp7_;
	gint _tmp7__length1;
	self = (KkcBigramDecoder*) base;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = nbest;
	_tmp2_ = constraint;
	_tmp2__length1 = constraint_length1;
	_tmp3_ = DBL_MAX;
	_tmp4_ = DBL_MIN;
	_tmp6_ = kkc_decoder_decode_with_costs ((KkcDecoder*) self, _tmp0_, _tmp1_, _tmp2_, _tmp2__length1, _tmp3_, _tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static KkcSegment** kkc_bigram_decoder_real_decode_with_costs (KkcDecoder* base, const gchar* input, gint nbest, gint* constraint, int constraint_length1, gdouble max_distance, gdouble min_path_cost, int* result_length1) {
	KkcBigramDecoder * self;
	KkcSegment** result = NULL;
	GeeArrayList** trellis = NULL;
	const gchar* _tmp0_;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	GeeArrayList** _tmp3_ = NULL;
	gint trellis_length1;
	gint _trellis_size_;
	GeeArrayList** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	GeeArrayList** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	KkcSegment** segments = NULL;
	GeeArrayList** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gint _tmp13_ = 0;
	KkcSegment** _tmp14_ = NULL;
	gint segments_length1;
	gint _segments_size_;
	KkcSegment** _tmp23_;
	gint _tmp23__length1;
	self = (KkcBigramDecoder*) base;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = constraint;
	_tmp1__length1 = constraint_length1;
	_tmp3_ = kkc_bigram_decoder_build_trellis (self, _tmp0_, _tmp1_, _tmp1__length1, &_tmp2_);
	trellis = _tmp3_;
	trellis_length1 = _tmp2_;
	_trellis_size_ = trellis_length1;
	_tmp4_ = trellis;
	_tmp4__length1 = trellis_length1;
	_tmp5_ = input;
	_tmp6_ = constraint;
	_tmp6__length1 = constraint_length1;
	kkc_bigram_decoder_add_unknown_nodes (self, _tmp4_, _tmp4__length1, _tmp5_, _tmp6_, _tmp6__length1);
	_tmp7_ = trellis;
	_tmp7__length1 = trellis_length1;
	_tmp8_ = input;
	kkc_bigram_decoder_forward_search (self, _tmp7_, _tmp7__length1, _tmp8_);
	_tmp9_ = trellis;
	_tmp9__length1 = trellis_length1;
	_tmp10_ = nbest;
	_tmp11_ = max_distance;
	_tmp12_ = min_path_cost;
	_tmp14_ = kkc_bigram_decoder_backward_search (self, _tmp9_, _tmp9__length1, _tmp10_, _tmp11_, _tmp12_, &_tmp13_);
	segments = _tmp14_;
	segments_length1 = _tmp13_;
	_segments_size_ = segments_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gboolean _tmp16_;
				gint _tmp18_;
				GeeArrayList** _tmp19_;
				gint _tmp19__length1;
				GeeArrayList** _tmp20_;
				gint _tmp20__length1;
				gint _tmp21_;
				GeeArrayList* _tmp22_;
				_tmp16_ = _tmp15_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp18_ = i;
				_tmp19_ = trellis;
				_tmp19__length1 = trellis_length1;
				if (!(_tmp18_ < _tmp19__length1)) {
					break;
				}
				_tmp20_ = trellis;
				_tmp20__length1 = trellis_length1;
				_tmp21_ = i;
				_tmp22_ = _tmp20_[_tmp21_];
				gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp22_);
			}
		}
	}
	_tmp23_ = segments;
	_tmp23__length1 = segments_length1;
	if (result_length1) {
		*result_length1 = _tmp23__length1;
	}
	result = _tmp23_;
	trellis = (_vala_array_free (trellis, trellis_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


void kkc_bigram_decoder_add_unknown_nodes (KkcBigramDecoder* self, GeeArrayList** trellis, int trellis_length1, const gchar* input, gint* constraint, int constraint_length1) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				GeeArrayList** _tmp4_;
				gint _tmp4__length1;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = trellis;
				_tmp4__length1 = trellis_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				{
					gint j = 0;
					gint _tmp5_;
					_tmp5_ = i;
					j = _tmp5_;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_;
							gboolean _tmp9_ = FALSE;
							gint _tmp10_;
							GeeArrayList** _tmp11_;
							gint _tmp11__length1;
							gboolean _tmp17_;
							gint* _tmp18_;
							gint _tmp18__length1;
							gint _tmp19_;
							gint _tmp20_;
							gboolean _tmp21_ = FALSE;
							glong offset = 0L;
							const gchar* _tmp22_;
							gint _tmp23_;
							gint _tmp24_ = 0;
							glong length = 0L;
							const gchar* _tmp25_;
							gint _tmp26_;
							gint _tmp27_ = 0;
							glong _tmp28_;
							gchar* _input = NULL;
							const gchar* _tmp29_;
							glong _tmp30_;
							glong _tmp31_;
							gchar* _tmp32_ = NULL;
							KkcLanguageModelEntry entry = {0};
							const gchar* _tmp33_;
							gchar* _tmp34_;
							const gchar* _tmp35_;
							gchar* _tmp36_;
							KkcLanguageModelEntry _tmp37_ = {0};
							KkcUnigramTrellisNode* node = NULL;
							KkcLanguageModelEntry _tmp38_;
							gint _tmp39_;
							KkcUnigramTrellisNode* _tmp40_;
							GeeArrayList** _tmp41_;
							gint _tmp41__length1;
							gint _tmp42_;
							GeeArrayList* _tmp43_;
							KkcUnigramTrellisNode* _tmp44_;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = j;
								j = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp10_ = j;
							_tmp11_ = trellis;
							_tmp11__length1 = trellis_length1;
							if (_tmp10_ < _tmp11__length1) {
								GeeArrayList** _tmp12_;
								gint _tmp12__length1;
								gint _tmp13_;
								GeeArrayList* _tmp14_;
								gboolean _tmp15_;
								gboolean _tmp16_;
								_tmp12_ = trellis;
								_tmp12__length1 = trellis_length1;
								_tmp13_ = j;
								_tmp14_ = _tmp12_[_tmp13_];
								_tmp15_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) _tmp14_);
								_tmp16_ = _tmp15_;
								_tmp9_ = _tmp16_;
							} else {
								_tmp9_ = FALSE;
							}
							_tmp17_ = _tmp9_;
							if (!_tmp17_) {
								break;
							}
							_tmp18_ = constraint;
							_tmp18__length1 = constraint_length1;
							_tmp19_ = i;
							_tmp20_ = j;
							_tmp21_ = kkc_bigram_decoder_check_overlaps (self, _tmp18_, _tmp18__length1, _tmp19_, _tmp20_);
							if (!_tmp21_) {
								continue;
							}
							_tmp22_ = input;
							_tmp23_ = i;
							_tmp24_ = string_index_of_nth_char (_tmp22_, (glong) (_tmp23_ - 1));
							offset = (glong) _tmp24_;
							_tmp25_ = input;
							_tmp26_ = j;
							_tmp27_ = string_index_of_nth_char (_tmp25_, (glong) _tmp26_);
							_tmp28_ = offset;
							length = _tmp27_ - _tmp28_;
							_tmp29_ = input;
							_tmp30_ = offset;
							_tmp31_ = length;
							_tmp32_ = string_substring (_tmp29_, _tmp30_, _tmp31_);
							_input = _tmp32_;
							_tmp33_ = _input;
							_tmp34_ = g_strdup (_tmp33_);
							_tmp35_ = _input;
							_tmp36_ = g_strdup (_tmp35_);
							_g_free0 (_tmp37_.input);
							_tmp37_.input = _tmp34_;
							_g_free0 (_tmp37_.output);
							_tmp37_.output = _tmp36_;
							_tmp37_.id = (guint) 2;
							entry = _tmp37_;
							_tmp38_ = entry;
							_tmp39_ = j;
							_tmp40_ = kkc_unigram_trellis_node_new (&_tmp38_, (guint) _tmp39_);
							node = _tmp40_;
							_tmp41_ = trellis;
							_tmp41__length1 = trellis_length1;
							_tmp42_ = j;
							_tmp43_ = _tmp41_[_tmp42_];
							_tmp44_ = node;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, (KkcTrellisNode*) _tmp44_);
							_kkc_trellis_node_unref0 (node);
							kkc_language_model_entry_destroy (&entry);
							_g_free0 (_input);
						}
					}
				}
			}
		}
	}
}


GeeArrayList** kkc_bigram_decoder_build_trellis (KkcBigramDecoder* self, const gchar* input, gint* constraint, int constraint_length1, int* result_length1) {
	GeeArrayList** result = NULL;
	gint length = 0;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	GeeArrayList** trellis = NULL;
	gint _tmp2_;
	GeeArrayList** _tmp3_ = NULL;
	gint trellis_length1;
	gint _trellis_size_;
	KkcUnigramTrellisNode* bos_node = NULL;
	KkcBigramLanguageModel* _tmp13_;
	KkcBigramLanguageModel* _tmp14_;
	KkcLanguageModelEntry _tmp15_;
	KkcLanguageModelEntry _tmp16_;
	KkcUnigramTrellisNode* _tmp17_;
	GeeArrayList** _tmp18_;
	gint _tmp18__length1;
	GeeArrayList* _tmp19_;
	KkcUnigramTrellisNode* _tmp20_;
	KkcUnigramTrellisNode* eos_node = NULL;
	KkcBigramLanguageModel* _tmp21_;
	KkcBigramLanguageModel* _tmp22_;
	KkcLanguageModelEntry _tmp23_;
	KkcLanguageModelEntry _tmp24_;
	gint _tmp25_;
	KkcUnigramTrellisNode* _tmp26_;
	GeeArrayList** _tmp27_;
	gint _tmp27__length1;
	gint _tmp28_;
	GeeArrayList* _tmp29_;
	KkcUnigramTrellisNode* _tmp30_;
	GeeArrayList** _tmp68_;
	gint _tmp68__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = g_utf8_strlen (_tmp0_, (gssize) (-1));
	length = _tmp1_;
	_tmp2_ = length;
	_tmp3_ = g_new0 (GeeArrayList*, (_tmp2_ + 2) + 1);
	trellis = _tmp3_;
	trellis_length1 = _tmp2_ + 2;
	_trellis_size_ = trellis_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GeeArrayList** _tmp8_;
				gint _tmp8__length1;
				GeeArrayList** _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				GeeArrayList* _tmp11_;
				GeeArrayList* _tmp12_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = trellis;
				_tmp8__length1 = trellis_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = trellis;
				_tmp9__length1 = trellis_length1;
				_tmp10_ = i;
				_tmp11_ = gee_array_list_new (KKC_TYPE_TRELLIS_NODE, (GBoxedCopyFunc) kkc_trellis_node_ref, kkc_trellis_node_unref, NULL);
				_g_object_unref0 (_tmp9_[_tmp10_]);
				_tmp9_[_tmp10_] = _tmp11_;
				_tmp12_ = _tmp9_[_tmp10_];
			}
		}
	}
	_tmp13_ = kkc_bigram_decoder_get_model (self);
	_tmp14_ = _tmp13_;
	kkc_language_model_get_bos ((KkcLanguageModel*) _tmp14_, &_tmp15_);
	_tmp16_ = _tmp15_;
	_tmp17_ = kkc_unigram_trellis_node_new (&_tmp16_, (guint) 1);
	bos_node = _tmp17_;
	_tmp18_ = trellis;
	_tmp18__length1 = trellis_length1;
	_tmp19_ = _tmp18_[0];
	_tmp20_ = bos_node;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, (KkcTrellisNode*) _tmp20_);
	_tmp21_ = kkc_bigram_decoder_get_model (self);
	_tmp22_ = _tmp21_;
	kkc_language_model_get_eos ((KkcLanguageModel*) _tmp22_, &_tmp23_);
	_tmp24_ = _tmp23_;
	_tmp25_ = length;
	_tmp26_ = kkc_unigram_trellis_node_new (&_tmp24_, (guint) (_tmp25_ + 1));
	eos_node = _tmp26_;
	_tmp27_ = trellis;
	_tmp27__length1 = trellis_length1;
	_tmp28_ = length;
	_tmp29_ = _tmp27_[_tmp28_ + 1];
	_tmp30_ = eos_node;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, (KkcTrellisNode*) _tmp30_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = TRUE;
			while (TRUE) {
				gboolean _tmp32_;
				gint _tmp34_;
				gint _tmp35_;
				glong byte_offset = 0L;
				const gchar* _tmp36_;
				gint _tmp37_;
				gint _tmp38_ = 0;
				gchar* _input = NULL;
				const gchar* _tmp39_;
				glong _tmp40_;
				gchar* _tmp41_ = NULL;
				GeeCollection* entries = NULL;
				KkcBigramLanguageModel* _tmp42_;
				KkcBigramLanguageModel* _tmp43_;
				const gchar* _tmp44_;
				GeeCollection* _tmp45_ = NULL;
				_tmp32_ = _tmp31_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp31_ = FALSE;
				_tmp34_ = i;
				_tmp35_ = length;
				if (!(_tmp34_ < _tmp35_)) {
					break;
				}
				_tmp36_ = input;
				_tmp37_ = i;
				_tmp38_ = string_index_of_nth_char (_tmp36_, (glong) _tmp37_);
				byte_offset = (glong) _tmp38_;
				_tmp39_ = input;
				_tmp40_ = byte_offset;
				_tmp41_ = string_substring (_tmp39_, _tmp40_, (glong) (-1));
				_input = _tmp41_;
				_tmp42_ = kkc_bigram_decoder_get_model (self);
				_tmp43_ = _tmp42_;
				_tmp44_ = _input;
				_tmp45_ = kkc_language_model_entries ((KkcLanguageModel*) _tmp43_, _tmp44_);
				entries = _tmp45_;
				{
					GeeIterator* _entry_it = NULL;
					GeeCollection* _tmp46_;
					GeeIterator* _tmp47_ = NULL;
					_tmp46_ = entries;
					_tmp47_ = gee_iterable_iterator ((GeeIterable*) _tmp46_);
					_entry_it = _tmp47_;
					while (TRUE) {
						GeeIterator* _tmp48_;
						gboolean _tmp49_ = FALSE;
						KkcLanguageModelEntry* entry = NULL;
						GeeIterator* _tmp50_;
						gpointer _tmp51_ = NULL;
						gint j = 0;
						gint _tmp52_;
						KkcLanguageModelEntry* _tmp53_;
						const gchar* _tmp54_;
						gint _tmp55_ = 0;
						gint* _tmp56_;
						gint _tmp56__length1;
						gint _tmp57_;
						gint _tmp58_;
						gboolean _tmp59_ = FALSE;
						KkcUnigramTrellisNode* node = NULL;
						KkcLanguageModelEntry* _tmp60_;
						gint _tmp61_;
						KkcLanguageModelEntry _tmp62_;
						KkcUnigramTrellisNode* _tmp63_;
						GeeArrayList** _tmp64_;
						gint _tmp64__length1;
						gint _tmp65_;
						GeeArrayList* _tmp66_;
						KkcUnigramTrellisNode* _tmp67_;
						_tmp48_ = _entry_it;
						_tmp49_ = gee_iterator_next (_tmp48_);
						if (!_tmp49_) {
							break;
						}
						_tmp50_ = _entry_it;
						_tmp51_ = gee_iterator_get (_tmp50_);
						entry = (KkcLanguageModelEntry*) _tmp51_;
						_tmp52_ = i;
						_tmp53_ = entry;
						_tmp54_ = (*_tmp53_).input;
						_tmp55_ = g_utf8_strlen (_tmp54_, (gssize) (-1));
						j = _tmp52_ + _tmp55_;
						_tmp56_ = constraint;
						_tmp56__length1 = constraint_length1;
						_tmp57_ = i;
						_tmp58_ = j;
						_tmp59_ = kkc_bigram_decoder_check_constraint (self, _tmp56_, _tmp56__length1, _tmp57_, _tmp58_);
						if (!_tmp59_) {
							_kkc_language_model_entry_free0 (entry);
							continue;
						}
						_tmp60_ = entry;
						_tmp61_ = j;
						_tmp62_ = *_tmp60_;
						_tmp63_ = kkc_unigram_trellis_node_new (&_tmp62_, (guint) _tmp61_);
						node = _tmp63_;
						_tmp64_ = trellis;
						_tmp64__length1 = trellis_length1;
						_tmp65_ = j;
						_tmp66_ = _tmp64_[_tmp65_];
						_tmp67_ = node;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, (KkcTrellisNode*) _tmp67_);
						_kkc_trellis_node_unref0 (node);
						_kkc_language_model_entry_free0 (entry);
					}
					_g_object_unref0 (_entry_it);
				}
				_g_object_unref0 (entries);
				_g_free0 (_input);
			}
		}
	}
	_tmp68_ = trellis;
	_tmp68__length1 = trellis_length1;
	if (result_length1) {
		*result_length1 = _tmp68__length1;
	}
	result = _tmp68_;
	_kkc_trellis_node_unref0 (eos_node);
	_kkc_trellis_node_unref0 (bos_node);
	return result;
}


static gboolean kkc_bigram_decoder_check_constraint (KkcBigramDecoder* self, gint* constraint, int constraint_length1, gint i, gint j) {
	gboolean result = FALSE;
	gint last_c = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp8_;
	gint _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	last_c = 0;
	_tmp0_ = constraint;
	_tmp0__length1 = constraint_length1;
	{
		gint* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp0_;
		c_collection_length1 = _tmp0__length1;
		for (c_it = 0; c_it < _tmp0__length1; c_it = c_it + 1) {
			gint c = 0;
			c = c_collection[c_it];
			{
				gboolean _tmp1_ = FALSE;
				gint _tmp2_;
				gint _tmp3_;
				gboolean _tmp6_;
				gint _tmp7_;
				_tmp2_ = i;
				_tmp3_ = last_c;
				if (_tmp2_ == _tmp3_) {
					gint _tmp4_;
					gint _tmp5_;
					_tmp4_ = j;
					_tmp5_ = c;
					_tmp1_ = _tmp4_ == _tmp5_;
				} else {
					_tmp1_ = FALSE;
				}
				_tmp6_ = _tmp1_;
				if (_tmp6_) {
					result = TRUE;
					return result;
				}
				_tmp7_ = c;
				last_c = _tmp7_;
			}
		}
	}
	_tmp8_ = i;
	_tmp9_ = last_c;
	result = _tmp8_ >= _tmp9_;
	return result;
}


static gboolean kkc_bigram_decoder_check_overlaps (KkcBigramDecoder* self, gint* constraint, int constraint_length1, gint i, gint j) {
	gboolean result = FALSE;
	gint last_c = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp16_;
	gint _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	last_c = 0;
	_tmp0_ = constraint;
	_tmp0__length1 = constraint_length1;
	{
		gint* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp0_;
		c_collection_length1 = _tmp0__length1;
		for (c_it = 0; c_it < _tmp0__length1; c_it = c_it + 1) {
			gint c = 0;
			c = c_collection[c_it];
			{
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_ = FALSE;
				gint _tmp3_;
				gint _tmp4_;
				gboolean _tmp7_;
				gboolean _tmp14_;
				gint _tmp15_;
				_tmp3_ = last_c;
				_tmp4_ = i;
				if (_tmp3_ <= _tmp4_) {
					gint _tmp5_;
					gint _tmp6_;
					_tmp5_ = i;
					_tmp6_ = c;
					_tmp2_ = _tmp5_ <= _tmp6_;
				} else {
					_tmp2_ = FALSE;
				}
				_tmp7_ = _tmp2_;
				if (_tmp7_) {
					gboolean _tmp8_ = FALSE;
					gint _tmp9_;
					gint _tmp10_;
					gboolean _tmp13_;
					_tmp9_ = last_c;
					_tmp10_ = j;
					if (_tmp9_ <= _tmp10_) {
						gint _tmp11_;
						gint _tmp12_;
						_tmp11_ = j;
						_tmp12_ = c;
						_tmp8_ = _tmp11_ <= _tmp12_;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp13_ = _tmp8_;
					_tmp1_ = _tmp13_;
				} else {
					_tmp1_ = FALSE;
				}
				_tmp14_ = _tmp1_;
				if (_tmp14_) {
					result = TRUE;
					return result;
				}
				_tmp15_ = c;
				last_c = _tmp15_;
			}
		}
	}
	_tmp16_ = i;
	_tmp17_ = last_c;
	result = _tmp16_ >= _tmp17_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void kkc_bigram_decoder_forward_search (KkcBigramDecoder* self, GeeArrayList** trellis, int trellis_length1, const gchar* input) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				GeeArrayList** _tmp4_;
				gint _tmp4__length1;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = trellis;
				_tmp4__length1 = trellis_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				{
					GeeArrayList* _node_list = NULL;
					GeeArrayList** _tmp5_;
					gint _tmp5__length1;
					gint _tmp6_;
					GeeArrayList* _tmp7_;
					GeeArrayList* _tmp8_;
					gint _node_size = 0;
					GeeArrayList* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					gint _node_index = 0;
					_tmp5_ = trellis;
					_tmp5__length1 = trellis_length1;
					_tmp6_ = i;
					_tmp7_ = _tmp5_[_tmp6_];
					_tmp8_ = _g_object_ref0 (_tmp7_);
					_node_list = _tmp8_;
					_tmp9_ = _node_list;
					_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
					_tmp11_ = _tmp10_;
					_node_size = _tmp11_;
					_node_index = -1;
					while (TRUE) {
						gint _tmp12_;
						gint _tmp13_;
						gint _tmp14_;
						KkcTrellisNode* node = NULL;
						GeeArrayList* _tmp15_;
						gint _tmp16_;
						gpointer _tmp17_ = NULL;
						gint j = 0;
						gint _tmp18_;
						KkcTrellisNode* _tmp19_;
						guint _tmp20_;
						guint _tmp21_;
						gint _tmp22_;
						gdouble max_cost = 0.0;
						gdouble _tmp23_;
						KkcTrellisNode* max_pnode = NULL;
						KkcTrellisNode* _tmp48_;
						KkcTrellisNode* _tmp53_;
						gdouble _tmp54_;
						KkcTrellisNode* _tmp55_;
						KkcTrellisNode* _tmp56_;
						KkcTrellisNode* _tmp57_;
						_tmp12_ = _node_index;
						_node_index = _tmp12_ + 1;
						_tmp13_ = _node_index;
						_tmp14_ = _node_size;
						if (!(_tmp13_ < _tmp14_)) {
							break;
						}
						_tmp15_ = _node_list;
						_tmp16_ = _node_index;
						_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
						node = (KkcTrellisNode*) _tmp17_;
						_tmp18_ = i;
						_tmp19_ = node;
						_tmp20_ = kkc_trellis_node_get_length (_tmp19_);
						_tmp21_ = _tmp20_;
						j = _tmp18_ - ((gint) _tmp21_);
						_tmp22_ = j;
						if (_tmp22_ < 0) {
							_kkc_trellis_node_unref0 (node);
							continue;
						}
						_tmp23_ = DBL_MAX;
						max_cost = -_tmp23_;
						max_pnode = NULL;
						{
							GeeArrayList* _pnode_list = NULL;
							GeeArrayList** _tmp24_;
							gint _tmp24__length1;
							gint _tmp25_;
							GeeArrayList* _tmp26_;
							GeeArrayList* _tmp27_;
							gint _pnode_size = 0;
							GeeArrayList* _tmp28_;
							gint _tmp29_;
							gint _tmp30_;
							gint _pnode_index = 0;
							_tmp24_ = trellis;
							_tmp24__length1 = trellis_length1;
							_tmp25_ = j;
							_tmp26_ = _tmp24_[_tmp25_];
							_tmp27_ = _g_object_ref0 (_tmp26_);
							_pnode_list = _tmp27_;
							_tmp28_ = _pnode_list;
							_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp28_);
							_tmp30_ = _tmp29_;
							_pnode_size = _tmp30_;
							_pnode_index = -1;
							while (TRUE) {
								gint _tmp31_;
								gint _tmp32_;
								gint _tmp33_;
								KkcTrellisNode* pnode = NULL;
								GeeArrayList* _tmp34_;
								gint _tmp35_;
								gpointer _tmp36_ = NULL;
								gdouble cost = 0.0;
								KkcTrellisNode* _tmp37_;
								gdouble _tmp38_;
								KkcTrellisNode* _tmp39_;
								KkcTrellisNode* _tmp40_;
								gint _tmp41_;
								gdouble _tmp42_ = 0.0;
								gdouble _tmp43_;
								gdouble _tmp44_;
								_tmp31_ = _pnode_index;
								_pnode_index = _tmp31_ + 1;
								_tmp32_ = _pnode_index;
								_tmp33_ = _pnode_size;
								if (!(_tmp32_ < _tmp33_)) {
									break;
								}
								_tmp34_ = _pnode_list;
								_tmp35_ = _pnode_index;
								_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _tmp35_);
								pnode = (KkcTrellisNode*) _tmp36_;
								_tmp37_ = pnode;
								_tmp38_ = _tmp37_->cumulative_cost;
								_tmp39_ = pnode;
								_tmp40_ = node;
								_tmp41_ = j;
								_tmp42_ = kkc_bigram_decoder_path_cost (self, _tmp39_, _tmp40_, _tmp41_);
								cost = _tmp38_ + _tmp42_;
								_tmp43_ = cost;
								_tmp44_ = max_cost;
								if (_tmp43_ > _tmp44_) {
									KkcTrellisNode* _tmp45_;
									KkcTrellisNode* _tmp46_;
									gdouble _tmp47_;
									_tmp45_ = pnode;
									_tmp46_ = _kkc_trellis_node_ref0 (_tmp45_);
									_kkc_trellis_node_unref0 (max_pnode);
									max_pnode = _tmp46_;
									_tmp47_ = cost;
									max_cost = _tmp47_;
								}
								_kkc_trellis_node_unref0 (pnode);
							}
							_g_object_unref0 (_pnode_list);
						}
						_tmp48_ = max_pnode;
						if (_tmp48_ == NULL) {
							GeeArrayList** _tmp49_;
							gint _tmp49__length1;
							gint _tmp50_;
							GeeArrayList* _tmp51_;
							gpointer _tmp52_ = NULL;
							_tmp49_ = trellis;
							_tmp49__length1 = trellis_length1;
							_tmp50_ = i;
							_tmp51_ = _tmp49_[_tmp50_];
							_tmp52_ = gee_abstract_list_get ((GeeAbstractList*) _tmp51_, 0);
							_kkc_trellis_node_unref0 (max_pnode);
							max_pnode = (KkcTrellisNode*) _tmp52_;
						}
						_tmp53_ = node;
						_tmp54_ = max_cost;
						_tmp53_->cumulative_cost = _tmp54_;
						_tmp55_ = node;
						_tmp56_ = max_pnode;
						_tmp57_ = _kkc_trellis_node_ref0 (_tmp56_);
						_kkc_trellis_node_unref0 (_tmp55_->previous);
						_tmp55_->previous = _tmp57_;
						_kkc_trellis_node_unref0 (max_pnode);
						_kkc_trellis_node_unref0 (node);
					}
					_g_object_unref0 (_node_list);
				}
			}
		}
	}
}


static gdouble kkc_bigram_decoder_real_path_cost (KkcBigramDecoder* self, KkcTrellisNode* pnode, KkcTrellisNode* node, gint endpos) {
	gdouble result = 0.0;
	KkcUnigramTrellisNode* upnode = NULL;
	KkcTrellisNode* _tmp0_;
	KkcUnigramTrellisNode* _tmp1_;
	KkcUnigramTrellisNode* unode = NULL;
	KkcTrellisNode* _tmp2_;
	KkcUnigramTrellisNode* _tmp3_;
	gboolean _tmp4_ = FALSE;
	KkcUnigramTrellisNode* _tmp5_;
	gboolean _tmp7_;
	KkcBigramLanguageModel* _tmp8_;
	KkcBigramLanguageModel* _tmp9_;
	KkcUnigramTrellisNode* _tmp10_;
	KkcLanguageModelEntry _tmp11_;
	KkcLanguageModelEntry _tmp12_;
	KkcUnigramTrellisNode* _tmp13_;
	KkcLanguageModelEntry _tmp14_;
	KkcLanguageModelEntry _tmp15_;
	gdouble _tmp16_ = 0.0;
	g_return_val_if_fail (pnode != NULL, 0.0);
	g_return_val_if_fail (node != NULL, 0.0);
	_tmp0_ = pnode;
	_tmp1_ = _kkc_trellis_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, KKC_TYPE_UNIGRAM_TRELLIS_NODE) ? ((KkcUnigramTrellisNode*) _tmp0_) : NULL);
	upnode = _tmp1_;
	_tmp2_ = node;
	_tmp3_ = _kkc_trellis_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, KKC_TYPE_UNIGRAM_TRELLIS_NODE) ? ((KkcUnigramTrellisNode*) _tmp2_) : NULL);
	unode = _tmp3_;
	_tmp5_ = upnode;
	if (_tmp5_ != NULL) {
		KkcUnigramTrellisNode* _tmp6_;
		_tmp6_ = unode;
		_tmp4_ = _tmp6_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	_vala_assert (_tmp7_, "upnode != null && unode != null");
	_tmp8_ = kkc_bigram_decoder_get_model (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = upnode;
	kkc_unigram_trellis_node_get_entry (_tmp10_, &_tmp11_);
	_tmp12_ = _tmp11_;
	_tmp13_ = unode;
	kkc_unigram_trellis_node_get_entry (_tmp13_, &_tmp14_);
	_tmp15_ = _tmp14_;
	_tmp16_ = kkc_bigram_language_model_bigram_backoff_cost (_tmp9_, &_tmp12_, &_tmp15_);
	result = _tmp16_;
	_kkc_trellis_node_unref0 (unode);
	_kkc_trellis_node_unref0 (upnode);
	return result;
}


gdouble kkc_bigram_decoder_path_cost (KkcBigramDecoder* self, KkcTrellisNode* pnode, KkcTrellisNode* node, gint endpos) {
	g_return_val_if_fail (self != NULL, 0.0);
	return KKC_BIGRAM_DECODER_GET_CLASS (self)->path_cost (self, pnode, node, endpos);
}


static KkcSegment* kkc_bigram_decoder_nbest_node_to_segment (KkcBigramDecoder* self, KkcNbestNode* nbest_node) {
	KkcSegment* result = NULL;
	KkcSegment* start_segment = NULL;
	KkcSegment* previous_segment = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nbest_node != NULL, NULL);
	start_segment = NULL;
	previous_segment = NULL;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_;
			KkcNbestNode* _tmp4_;
			KkcNbestNode* _tmp5_;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				KkcNbestNode* _tmp2_;
				KkcNbestNode* _tmp3_;
				_tmp2_ = nbest_node;
				_tmp3_ = _tmp2_->next;
				nbest_node = _tmp3_;
			}
			_tmp0_ = FALSE;
			_tmp4_ = nbest_node;
			_tmp5_ = _tmp4_->next;
			if (!(_tmp5_ != NULL)) {
				break;
			}
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp6_ = FALSE;
					_tmp6_ = TRUE;
					while (TRUE) {
						gboolean _tmp7_;
						gint _tmp9_;
						KkcNbestNode* _tmp10_;
						KkcTrellisNode* _tmp11_;
						KkcLanguageModelEntry* _tmp12_;
						gint _tmp12__length1;
						KkcLanguageModelEntry* _tmp13_;
						gint _tmp13__length1;
						KkcLanguageModelEntry entry = {0};
						KkcNbestNode* _tmp14_;
						KkcTrellisNode* _tmp15_;
						KkcLanguageModelEntry* _tmp16_;
						gint _tmp16__length1;
						KkcLanguageModelEntry* _tmp17_;
						gint _tmp17__length1;
						gint _tmp18_;
						KkcLanguageModelEntry _tmp19_;
						KkcLanguageModelEntry _tmp20_ = {0};
						KkcSegment* segment = NULL;
						KkcLanguageModelEntry _tmp21_;
						const gchar* _tmp22_;
						KkcLanguageModelEntry _tmp23_;
						const gchar* _tmp24_;
						KkcSegment* _tmp25_;
						KkcSegment* _tmp26_;
						KkcSegment* _tmp29_;
						KkcSegment* _tmp33_;
						KkcSegment* _tmp34_;
						_tmp7_ = _tmp6_;
						if (!_tmp7_) {
							gint _tmp8_;
							_tmp8_ = i;
							i = _tmp8_ + 1;
						}
						_tmp6_ = FALSE;
						_tmp9_ = i;
						_tmp10_ = nbest_node;
						_tmp11_ = _tmp10_->node;
						_tmp12_ = kkc_trellis_node_get_entries (_tmp11_, &_tmp12__length1);
						_tmp13_ = _tmp12_;
						_tmp13__length1 = _tmp12__length1;
						if (!(_tmp9_ < _tmp13__length1)) {
							break;
						}
						_tmp14_ = nbest_node;
						_tmp15_ = _tmp14_->node;
						_tmp16_ = kkc_trellis_node_get_entries (_tmp15_, &_tmp16__length1);
						_tmp17_ = _tmp16_;
						_tmp17__length1 = _tmp16__length1;
						_tmp18_ = i;
						_tmp19_ = _tmp17_[_tmp18_];
						kkc_language_model_entry_copy (&_tmp19_, &_tmp20_);
						entry = _tmp20_;
						_tmp21_ = entry;
						_tmp22_ = _tmp21_.input;
						_tmp23_ = entry;
						_tmp24_ = _tmp23_.output;
						_tmp25_ = kkc_segment_new (_tmp22_, _tmp24_);
						segment = _tmp25_;
						_tmp26_ = start_segment;
						if (_tmp26_ == NULL) {
							KkcSegment* _tmp27_;
							KkcSegment* _tmp28_;
							_tmp27_ = segment;
							_tmp28_ = _g_object_ref0 (_tmp27_);
							_g_object_unref0 (start_segment);
							start_segment = _tmp28_;
						}
						_tmp29_ = previous_segment;
						if (_tmp29_ != NULL) {
							KkcSegment* _tmp30_;
							KkcSegment* _tmp31_;
							KkcSegment* _tmp32_;
							_tmp30_ = previous_segment;
							_tmp31_ = segment;
							_tmp32_ = _g_object_ref0 (_tmp31_);
							_g_object_unref0 (_tmp30_->next);
							_tmp30_->next = _tmp32_;
						}
						_tmp33_ = segment;
						_tmp34_ = _g_object_ref0 (_tmp33_);
						_g_object_unref0 (previous_segment);
						previous_segment = _tmp34_;
						_g_object_unref0 (segment);
						kkc_language_model_entry_destroy (&entry);
					}
				}
			}
		}
	}
	result = start_segment;
	_g_object_unref0 (previous_segment);
	return result;
}


static gboolean _kkc_language_model_entry_equal (const KkcLanguageModelEntry* s1, const KkcLanguageModelEntry* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (g_strcmp0 (s1->input, s2->input)) {
		return FALSE;
	}
	if (g_strcmp0 (s1->output, s2->output)) {
		return FALSE;
	}
	if (s1->id != s2->id) {
		return FALSE;
	}
	return TRUE;
}


static gpointer _kkc_nbest_node_ref0 (gpointer self) {
	return self ? kkc_nbest_node_ref (self) : NULL;
}


KkcSegment** kkc_bigram_decoder_backward_search (KkcBigramDecoder* self, GeeArrayList** trellis, int trellis_length1, gint nbest, gdouble max_distance, gdouble min_path_cost, int* result_length1) {
	KkcSegment** result = NULL;
	KkcTrellisNode* bos_trellis_node = NULL;
	GeeArrayList** _tmp0_;
	gint _tmp0__length1;
	GeeArrayList* _tmp1_;
	gpointer _tmp2_ = NULL;
	KkcTrellisNode* eos_trellis_node = NULL;
	GeeArrayList** _tmp3_;
	gint _tmp3__length1;
	GeeArrayList** _tmp4_;
	gint _tmp4__length1;
	GeeArrayList* _tmp5_;
	gpointer _tmp6_ = NULL;
	gint _tmp7_;
	GeeHashMap* trellis_nbest_map = NULL;
	GHashFunc _tmp49_;
	GEqualFunc _tmp50_;
	GeeHashMap* _tmp51_;
	GeePriorityQueue* open_list = NULL;
	GeePriorityQueue* _tmp52_;
	GeePriorityQueue* close_list = NULL;
	GeePriorityQueue* _tmp53_;
	GeeHashSet* duplicates = NULL;
	GHashFunc _tmp54_;
	GEqualFunc _tmp55_;
	GeeHashSet* _tmp56_;
	KkcNbestNode* eos_nbest_node = NULL;
	KkcTrellisNode* _tmp57_;
	KkcNbestNode* _tmp58_;
	GeeHashMap* _tmp59_;
	KkcTrellisNode* _tmp60_;
	KkcNbestNode* _tmp61_;
	GeePriorityQueue* _tmp62_;
	KkcNbestNode* _tmp63_;
	GeeArrayList* segments = NULL;
	GeeArrayList* _tmp151_;
	GeeArrayList* _tmp163_;
	gint _tmp164_ = 0;
	gpointer* _tmp165_ = NULL;
	KkcSegment** _tmp166_;
	gint _tmp166__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = trellis;
	_tmp0__length1 = trellis_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp1_, 0);
	bos_trellis_node = (KkcTrellisNode*) _tmp2_;
	_tmp3_ = trellis;
	_tmp3__length1 = trellis_length1;
	_tmp4_ = trellis;
	_tmp4__length1 = trellis_length1;
	_tmp5_ = _tmp3_[_tmp4__length1 - 1];
	_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, 0);
	eos_trellis_node = (KkcTrellisNode*) _tmp6_;
	_tmp7_ = nbest;
	if (_tmp7_ == 1) {
		KkcSegment* segment = NULL;
		KkcSegment* next_segment = NULL;
		KkcSegment* _tmp45_;
		KkcSegment* _tmp46_;
		KkcSegment** _tmp47_ = NULL;
		KkcSegment** _tmp48_;
		gint _tmp48__length1;
		segment = NULL;
		next_segment = NULL;
		{
			KkcTrellisNode* node = NULL;
			KkcTrellisNode* _tmp8_;
			KkcTrellisNode* _tmp9_;
			KkcTrellisNode* _tmp10_;
			_tmp8_ = eos_trellis_node;
			_tmp9_ = _tmp8_->previous;
			_tmp10_ = _kkc_trellis_node_ref0 (_tmp9_);
			node = _tmp10_;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gboolean _tmp12_;
					KkcTrellisNode* _tmp16_;
					_tmp12_ = _tmp11_;
					if (!_tmp12_) {
						KkcTrellisNode* _tmp13_;
						KkcTrellisNode* _tmp14_;
						KkcTrellisNode* _tmp15_;
						_tmp13_ = node;
						_tmp14_ = _tmp13_->previous;
						_tmp15_ = _kkc_trellis_node_ref0 (_tmp14_);
						_kkc_trellis_node_unref0 (node);
						node = _tmp15_;
					}
					_tmp11_ = FALSE;
					_tmp16_ = node;
					if (!(_tmp16_ != NULL)) {
						break;
					}
					{
						gint i = 0;
						KkcTrellisNode* _tmp17_;
						KkcLanguageModelEntry* _tmp18_;
						gint _tmp18__length1;
						KkcLanguageModelEntry* _tmp19_;
						gint _tmp19__length1;
						_tmp17_ = node;
						_tmp18_ = kkc_trellis_node_get_entries (_tmp17_, &_tmp18__length1);
						_tmp19_ = _tmp18_;
						_tmp19__length1 = _tmp18__length1;
						i = _tmp19__length1 - 1;
						{
							gboolean _tmp20_ = FALSE;
							_tmp20_ = TRUE;
							while (TRUE) {
								gboolean _tmp21_;
								gint _tmp23_;
								KkcLanguageModelEntry entry = {0};
								KkcTrellisNode* _tmp24_;
								KkcLanguageModelEntry* _tmp25_;
								gint _tmp25__length1;
								KkcLanguageModelEntry* _tmp26_;
								gint _tmp26__length1;
								gint _tmp27_;
								KkcLanguageModelEntry _tmp28_;
								KkcLanguageModelEntry _tmp29_ = {0};
								KkcLanguageModelEntry _tmp30_;
								KkcBigramLanguageModel* _tmp31_;
								KkcBigramLanguageModel* _tmp32_;
								KkcLanguageModelEntry _tmp33_;
								KkcLanguageModelEntry _tmp34_;
								KkcLanguageModelEntry _tmp35_;
								const gchar* _tmp36_;
								KkcLanguageModelEntry _tmp37_;
								const gchar* _tmp38_;
								KkcSegment* _tmp39_;
								KkcSegment* _tmp40_;
								KkcSegment* _tmp41_;
								KkcSegment* _tmp42_;
								KkcSegment* _tmp43_;
								KkcSegment* _tmp44_;
								_tmp21_ = _tmp20_;
								if (!_tmp21_) {
									gint _tmp22_;
									_tmp22_ = i;
									i = _tmp22_ - 1;
								}
								_tmp20_ = FALSE;
								_tmp23_ = i;
								if (!(_tmp23_ >= 0)) {
									break;
								}
								_tmp24_ = node;
								_tmp25_ = kkc_trellis_node_get_entries (_tmp24_, &_tmp25__length1);
								_tmp26_ = _tmp25_;
								_tmp26__length1 = _tmp25__length1;
								_tmp27_ = i;
								_tmp28_ = _tmp26_[_tmp27_];
								kkc_language_model_entry_copy (&_tmp28_, &_tmp29_);
								entry = _tmp29_;
								_tmp30_ = entry;
								_tmp31_ = kkc_bigram_decoder_get_model (self);
								_tmp32_ = _tmp31_;
								kkc_language_model_get_bos ((KkcLanguageModel*) _tmp32_, &_tmp33_);
								_tmp34_ = _tmp33_;
								if (_kkc_language_model_entry_equal (&_tmp30_, &_tmp34_) == TRUE) {
									kkc_language_model_entry_destroy (&entry);
									break;
								}
								_tmp35_ = entry;
								_tmp36_ = _tmp35_.input;
								_tmp37_ = entry;
								_tmp38_ = _tmp37_.output;
								_tmp39_ = kkc_segment_new (_tmp36_, _tmp38_);
								_g_object_unref0 (segment);
								segment = _tmp39_;
								_tmp40_ = segment;
								_tmp41_ = next_segment;
								_tmp42_ = _g_object_ref0 (_tmp41_);
								_g_object_unref0 (_tmp40_->next);
								_tmp40_->next = _tmp42_;
								_tmp43_ = segment;
								_tmp44_ = _g_object_ref0 (_tmp43_);
								_g_object_unref0 (next_segment);
								next_segment = _tmp44_;
								kkc_language_model_entry_destroy (&entry);
							}
						}
					}
				}
			}
			_kkc_trellis_node_unref0 (node);
		}
		_tmp45_ = segment;
		_tmp46_ = _g_object_ref0 (_tmp45_);
		_tmp47_ = g_new0 (KkcSegment*, 1 + 1);
		_tmp47_[0] = _tmp46_;
		_tmp48_ = _tmp47_;
		_tmp48__length1 = 1;
		if (result_length1) {
			*result_length1 = _tmp48__length1;
		}
		result = _tmp48_;
		_g_object_unref0 (next_segment);
		_g_object_unref0 (segment);
		_kkc_trellis_node_unref0 (eos_trellis_node);
		_kkc_trellis_node_unref0 (bos_trellis_node);
		return result;
	}
	_tmp49_ = g_direct_hash;
	_tmp50_ = g_direct_equal;
	_tmp51_ = gee_hash_map_new (KKC_TYPE_TRELLIS_NODE, (GBoxedCopyFunc) kkc_trellis_node_ref, kkc_trellis_node_unref, KKC_TYPE_NBEST_NODE, (GBoxedCopyFunc) kkc_nbest_node_ref, kkc_nbest_node_unref, _tmp49_, _tmp50_, NULL);
	trellis_nbest_map = _tmp51_;
	_tmp52_ = gee_priority_queue_new (KKC_TYPE_NBEST_NODE, (GBoxedCopyFunc) kkc_nbest_node_ref, kkc_nbest_node_unref, (GCompareFunc) kkc_bigram_decoder_compare_nbest_node);
	open_list = _tmp52_;
	_tmp53_ = gee_priority_queue_new (KKC_TYPE_NBEST_NODE, (GBoxedCopyFunc) kkc_nbest_node_ref, kkc_nbest_node_unref, (GCompareFunc) kkc_bigram_decoder_compare_nbest_node);
	close_list = _tmp53_;
	_tmp54_ = g_str_hash;
	_tmp55_ = g_str_equal;
	_tmp56_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp54_, _tmp55_);
	duplicates = _tmp56_;
	_tmp57_ = eos_trellis_node;
	_tmp58_ = kkc_nbest_node_new (_tmp57_);
	eos_nbest_node = _tmp58_;
	_tmp59_ = trellis_nbest_map;
	_tmp60_ = eos_trellis_node;
	_tmp61_ = eos_nbest_node;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp59_, _tmp60_, _tmp61_);
	_tmp62_ = open_list;
	_tmp63_ = eos_nbest_node;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, _tmp63_);
	while (TRUE) {
		GeePriorityQueue* _tmp64_;
		gboolean _tmp65_;
		gboolean _tmp66_;
		KkcNbestNode* current_nbest_node = NULL;
		GeePriorityQueue* _tmp67_;
		gpointer _tmp68_ = NULL;
		KkcNbestNode* _tmp69_;
		KkcTrellisNode* _tmp70_;
		KkcTrellisNode* _tmp71_;
		_tmp64_ = open_list;
		_tmp65_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) _tmp64_);
		_tmp66_ = _tmp65_;
		if (!(!_tmp66_)) {
			break;
		}
		_tmp67_ = open_list;
		_tmp68_ = gee_abstract_queue_poll ((GeeAbstractQueue*) _tmp67_);
		current_nbest_node = (KkcNbestNode*) _tmp68_;
		_tmp69_ = current_nbest_node;
		_tmp70_ = _tmp69_->node;
		_tmp71_ = bos_trellis_node;
		if (_tmp70_ == _tmp71_) {
			gchar* output = NULL;
			KkcNbestNode* _tmp72_;
			gchar* _tmp73_ = NULL;
			GeeHashSet* _tmp74_;
			const gchar* _tmp75_;
			gboolean _tmp76_ = FALSE;
			_tmp72_ = current_nbest_node;
			_tmp73_ = kkc_bigram_decoder_concat_nbest_node_outputs (self, _tmp72_);
			output = _tmp73_;
			_tmp74_ = duplicates;
			_tmp75_ = output;
			_tmp76_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp74_, _tmp75_);
			if (!_tmp76_) {
				KkcTrellisNode* _tmp77_;
				gdouble _tmp78_;
				KkcNbestNode* _tmp79_;
				gdouble _tmp80_;
				gdouble _tmp81_;
				GeePriorityQueue* _tmp82_;
				KkcNbestNode* _tmp83_;
				GeePriorityQueue* _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				gint _tmp87_;
				GeeHashSet* _tmp88_;
				const gchar* _tmp89_;
				_tmp77_ = eos_trellis_node;
				_tmp78_ = _tmp77_->cumulative_cost;
				_tmp79_ = current_nbest_node;
				_tmp80_ = _tmp79_->fn;
				_tmp81_ = max_distance;
				if ((_tmp78_ - _tmp80_) > _tmp81_) {
					_g_free0 (output);
					_kkc_nbest_node_unref0 (current_nbest_node);
					break;
				}
				_tmp82_ = close_list;
				_tmp83_ = current_nbest_node;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp82_, _tmp83_);
				_tmp84_ = close_list;
				_tmp85_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = nbest;
				if (_tmp86_ == _tmp87_) {
					_g_free0 (output);
					_kkc_nbest_node_unref0 (current_nbest_node);
					break;
				}
				_tmp88_ = duplicates;
				_tmp89_ = output;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp88_, _tmp89_);
			}
			_g_free0 (output);
		} else {
			KkcNbestNode* _tmp90_;
			KkcTrellisNode* _tmp91_;
			guint _tmp92_;
			guint _tmp93_;
			KkcNbestNode* _tmp94_;
			KkcTrellisNode* _tmp95_;
			guint _tmp96_;
			guint _tmp97_;
			_tmp90_ = current_nbest_node;
			_tmp91_ = _tmp90_->node;
			_tmp92_ = kkc_trellis_node_get_endpos (_tmp91_);
			_tmp93_ = _tmp92_;
			_tmp94_ = current_nbest_node;
			_tmp95_ = _tmp94_->node;
			_tmp96_ = kkc_trellis_node_get_length (_tmp95_);
			_tmp97_ = _tmp96_;
			if (_tmp93_ >= _tmp97_) {
				guint i = 0U;
				KkcNbestNode* _tmp98_;
				KkcTrellisNode* _tmp99_;
				guint _tmp100_;
				guint _tmp101_;
				KkcNbestNode* _tmp102_;
				KkcTrellisNode* _tmp103_;
				guint _tmp104_;
				guint _tmp105_;
				_tmp98_ = current_nbest_node;
				_tmp99_ = _tmp98_->node;
				_tmp100_ = kkc_trellis_node_get_endpos (_tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = current_nbest_node;
				_tmp103_ = _tmp102_->node;
				_tmp104_ = kkc_trellis_node_get_length (_tmp103_);
				_tmp105_ = _tmp104_;
				i = ((gint) _tmp101_) - _tmp105_;
				{
					GeeArrayList* _trellis_node_list = NULL;
					GeeArrayList** _tmp106_;
					gint _tmp106__length1;
					guint _tmp107_;
					GeeArrayList* _tmp108_;
					GeeArrayList* _tmp109_;
					gint _trellis_node_size = 0;
					GeeArrayList* _tmp110_;
					gint _tmp111_;
					gint _tmp112_;
					gint _trellis_node_index = 0;
					_tmp106_ = trellis;
					_tmp106__length1 = trellis_length1;
					_tmp107_ = i;
					_tmp108_ = _tmp106_[_tmp107_];
					_tmp109_ = _g_object_ref0 (_tmp108_);
					_trellis_node_list = _tmp109_;
					_tmp110_ = _trellis_node_list;
					_tmp111_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp110_);
					_tmp112_ = _tmp111_;
					_trellis_node_size = _tmp112_;
					_trellis_node_index = -1;
					while (TRUE) {
						gint _tmp113_;
						gint _tmp114_;
						gint _tmp115_;
						KkcTrellisNode* trellis_node = NULL;
						GeeArrayList* _tmp116_;
						gint _tmp117_;
						gpointer _tmp118_ = NULL;
						KkcNbestNode* nbest_node = NULL;
						KkcTrellisNode* _tmp119_;
						KkcNbestNode* _tmp120_;
						gdouble cost = 0.0;
						KkcNbestNode* _tmp121_;
						KkcTrellisNode* _tmp122_;
						KkcNbestNode* _tmp123_;
						KkcTrellisNode* _tmp124_;
						guint _tmp125_;
						gdouble _tmp126_ = 0.0;
						gboolean _tmp127_ = FALSE;
						KkcTrellisNode* _tmp128_;
						KkcTrellisNode* _tmp129_;
						gboolean _tmp132_;
						KkcNbestNode* _tmp133_;
						gdouble _tmp134_;
						KkcNbestNode* _tmp135_;
						gdouble _tmp136_;
						KkcNbestNode* _tmp137_;
						KkcNbestNode* _tmp138_;
						gdouble _tmp139_;
						KkcNbestNode* _tmp140_;
						KkcTrellisNode* _tmp141_;
						gdouble _tmp142_;
						KkcNbestNode* _tmp143_;
						KkcNbestNode* _tmp144_;
						KkcNbestNode* _tmp145_;
						GeeHashMap* _tmp146_;
						KkcTrellisNode* _tmp147_;
						KkcNbestNode* _tmp148_;
						GeePriorityQueue* _tmp149_;
						KkcNbestNode* _tmp150_;
						_tmp113_ = _trellis_node_index;
						_trellis_node_index = _tmp113_ + 1;
						_tmp114_ = _trellis_node_index;
						_tmp115_ = _trellis_node_size;
						if (!(_tmp114_ < _tmp115_)) {
							break;
						}
						_tmp116_ = _trellis_node_list;
						_tmp117_ = _trellis_node_index;
						_tmp118_ = gee_abstract_list_get ((GeeAbstractList*) _tmp116_, _tmp117_);
						trellis_node = (KkcTrellisNode*) _tmp118_;
						_tmp119_ = trellis_node;
						_tmp120_ = kkc_nbest_node_new (_tmp119_);
						nbest_node = _tmp120_;
						_tmp121_ = nbest_node;
						_tmp122_ = _tmp121_->node;
						_tmp123_ = current_nbest_node;
						_tmp124_ = _tmp123_->node;
						_tmp125_ = i;
						_tmp126_ = kkc_bigram_decoder_path_cost (self, _tmp122_, _tmp124_, (gint) _tmp125_);
						cost = _tmp126_;
						_tmp128_ = trellis_node;
						_tmp129_ = bos_trellis_node;
						if (_tmp128_ != _tmp129_) {
							gdouble _tmp130_;
							gdouble _tmp131_;
							_tmp130_ = cost;
							_tmp131_ = min_path_cost;
							_tmp127_ = _tmp130_ < _tmp131_;
						} else {
							_tmp127_ = FALSE;
						}
						_tmp132_ = _tmp127_;
						if (_tmp132_) {
							_kkc_nbest_node_unref0 (nbest_node);
							_kkc_trellis_node_unref0 (trellis_node);
							continue;
						}
						_tmp133_ = nbest_node;
						_tmp134_ = cost;
						_tmp135_ = current_nbest_node;
						_tmp136_ = _tmp135_->gn;
						_tmp133_->gn = _tmp134_ + _tmp136_;
						_tmp137_ = nbest_node;
						_tmp138_ = nbest_node;
						_tmp139_ = _tmp138_->gn;
						_tmp140_ = nbest_node;
						_tmp141_ = _tmp140_->node;
						_tmp142_ = _tmp141_->cumulative_cost;
						_tmp137_->fn = _tmp139_ + _tmp142_;
						_tmp143_ = nbest_node;
						_tmp144_ = current_nbest_node;
						_tmp145_ = _kkc_nbest_node_ref0 (_tmp144_);
						_kkc_nbest_node_unref0 (_tmp143_->next);
						_tmp143_->next = _tmp145_;
						_tmp146_ = trellis_nbest_map;
						_tmp147_ = trellis_node;
						_tmp148_ = nbest_node;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp146_, _tmp147_, _tmp148_);
						_tmp149_ = open_list;
						_tmp150_ = nbest_node;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp149_, _tmp150_);
						_kkc_nbest_node_unref0 (nbest_node);
						_kkc_trellis_node_unref0 (trellis_node);
					}
					_g_object_unref0 (_trellis_node_list);
				}
			}
		}
		_kkc_nbest_node_unref0 (current_nbest_node);
	}
	_tmp151_ = gee_array_list_new (KKC_TYPE_SEGMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	segments = _tmp151_;
	{
		GeeIterator* _nbest_node_it = NULL;
		GeePriorityQueue* _tmp152_;
		GeeIterator* _tmp153_ = NULL;
		_tmp152_ = close_list;
		_tmp153_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp152_);
		_nbest_node_it = _tmp153_;
		while (TRUE) {
			GeeIterator* _tmp154_;
			gboolean _tmp155_ = FALSE;
			KkcNbestNode* nbest_node = NULL;
			GeeIterator* _tmp156_;
			gpointer _tmp157_ = NULL;
			GeeArrayList* _tmp158_;
			KkcNbestNode* _tmp159_;
			KkcNbestNode* _tmp160_;
			KkcSegment* _tmp161_ = NULL;
			KkcSegment* _tmp162_;
			_tmp154_ = _nbest_node_it;
			_tmp155_ = gee_iterator_next (_tmp154_);
			if (!_tmp155_) {
				break;
			}
			_tmp156_ = _nbest_node_it;
			_tmp157_ = gee_iterator_get (_tmp156_);
			nbest_node = (KkcNbestNode*) _tmp157_;
			_tmp158_ = segments;
			_tmp159_ = nbest_node;
			_tmp160_ = _tmp159_->next;
			_tmp161_ = kkc_bigram_decoder_nbest_node_to_segment (self, _tmp160_);
			_tmp162_ = _tmp161_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp158_, _tmp162_);
			_g_object_unref0 (_tmp162_);
			_kkc_nbest_node_unref0 (nbest_node);
		}
		_g_object_unref0 (_nbest_node_it);
	}
	_tmp163_ = segments;
	_tmp165_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp163_, &_tmp164_);
	_tmp166_ = _tmp165_;
	_tmp166__length1 = _tmp164_;
	if (result_length1) {
		*result_length1 = _tmp166__length1;
	}
	result = _tmp166_;
	_g_object_unref0 (segments);
	_kkc_nbest_node_unref0 (eos_nbest_node);
	_g_object_unref0 (duplicates);
	_g_object_unref0 (close_list);
	_g_object_unref0 (open_list);
	_g_object_unref0 (trellis_nbest_map);
	_kkc_trellis_node_unref0 (eos_trellis_node);
	_kkc_trellis_node_unref0 (bos_trellis_node);
	return result;
}


static gint kkc_bigram_decoder_compare_nbest_node (KkcNbestNode* a, KkcNbestNode* b) {
	gint result = 0;
	KkcNbestNode* _tmp0_;
	gdouble _tmp1_;
	KkcNbestNode* _tmp2_;
	gdouble _tmp3_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->fn;
	_tmp2_ = b;
	_tmp3_ = _tmp2_->fn;
	if (_tmp1_ == _tmp3_) {
		result = 0;
		return result;
	} else {
		KkcNbestNode* _tmp4_;
		gdouble _tmp5_;
		KkcNbestNode* _tmp6_;
		gdouble _tmp7_;
		_tmp4_ = a;
		_tmp5_ = _tmp4_->fn;
		_tmp6_ = b;
		_tmp7_ = _tmp6_->fn;
		if (_tmp5_ < _tmp7_) {
			result = 1;
			return result;
		} else {
			result = -1;
			return result;
		}
	}
}


static gchar* kkc_bigram_decoder_concat_nbest_node_outputs (KkcBigramDecoder* self, KkcNbestNode* nbest_node) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nbest_node != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	while (TRUE) {
		KkcNbestNode* _tmp1_;
		GString* _tmp2_;
		KkcNbestNode* _tmp3_;
		KkcTrellisNode* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		KkcNbestNode* _tmp7_;
		KkcNbestNode* _tmp8_;
		_tmp1_ = nbest_node;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = builder;
		_tmp3_ = nbest_node;
		_tmp4_ = _tmp3_->node;
		_tmp5_ = kkc_trellis_node_get_output (_tmp4_);
		_tmp6_ = _tmp5_;
		g_string_append (_tmp2_, _tmp6_);
		_tmp7_ = nbest_node;
		_tmp8_ = _tmp7_->next;
		nbest_node = _tmp8_;
	}
	_tmp9_ = builder;
	_tmp10_ = _tmp9_->str;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	_g_string_free0 (builder);
	return result;
}


KkcBigramDecoder* kkc_bigram_decoder_construct (GType object_type, KkcBigramLanguageModel* model) {
	KkcBigramDecoder * self = NULL;
	KkcBigramLanguageModel* _tmp0_;
	KkcBigramLanguageModel* _tmp1_;
	g_return_val_if_fail (model != NULL, NULL);
	self = (KkcBigramDecoder*) kkc_decoder_construct (object_type);
	_tmp0_ = model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp1_;
	return self;
}


KkcBigramDecoder* kkc_bigram_decoder_new (KkcBigramLanguageModel* model) {
	return kkc_bigram_decoder_construct (KKC_TYPE_BIGRAM_DECODER, model);
}


KkcBigramLanguageModel* kkc_bigram_decoder_get_model (KkcBigramDecoder* self) {
	KkcBigramLanguageModel* result;
	KkcBigramLanguageModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}


static void kkc_bigram_decoder_class_init (KkcBigramDecoderClass * klass) {
	kkc_bigram_decoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcBigramDecoderPrivate));
	KKC_DECODER_CLASS (klass)->decode = kkc_bigram_decoder_real_decode;
	KKC_DECODER_CLASS (klass)->decode_with_costs = kkc_bigram_decoder_real_decode_with_costs;
	KKC_BIGRAM_DECODER_CLASS (klass)->path_cost = kkc_bigram_decoder_real_path_cost;
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_bigram_decoder_get_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_bigram_decoder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_BIGRAM_DECODER_MODEL, g_param_spec_object ("model", "model", "model", KKC_TYPE_BIGRAM_LANGUAGE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void kkc_bigram_decoder_instance_init (KkcBigramDecoder * self) {
	self->priv = KKC_BIGRAM_DECODER_GET_PRIVATE (self);
}


static void kkc_bigram_decoder_finalize (GObject* obj) {
	KkcBigramDecoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_BIGRAM_DECODER, KkcBigramDecoder);
	_g_object_unref0 (self->priv->_model);
	G_OBJECT_CLASS (kkc_bigram_decoder_parent_class)->finalize (obj);
}


GType kkc_bigram_decoder_get_type (void) {
	static volatile gsize kkc_bigram_decoder_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_bigram_decoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcBigramDecoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_bigram_decoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcBigramDecoder), 0, (GInstanceInitFunc) kkc_bigram_decoder_instance_init, NULL };
		GType kkc_bigram_decoder_type_id;
		kkc_bigram_decoder_type_id = g_type_register_static (KKC_TYPE_DECODER, "KkcBigramDecoder", &g_define_type_info, 0);
		g_once_init_leave (&kkc_bigram_decoder_type_id__volatile, kkc_bigram_decoder_type_id);
	}
	return kkc_bigram_decoder_type_id__volatile;
}


static void _vala_kkc_bigram_decoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcBigramDecoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_BIGRAM_DECODER, KkcBigramDecoder);
	switch (property_id) {
		case KKC_BIGRAM_DECODER_MODEL:
		g_value_set_object (value, kkc_bigram_decoder_get_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



