# This file is provided under a dual BSD/GPLv2 license.  When using or
# redistributing this file, you may do so under either license.
#
# GPL LICENSE SUMMARY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# Contact Information:
# Intel Corporation
# www.intel.com
#
# BSD LICENSE
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
#   * Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#   * Neither the name of Intel Corporation nor the names of its
#     contributors may be used to endorse or promote products derived
#     from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# Copyright (c) 2013, 2014-2016. Intel Corporation. All rights reserved.
# Copyright (c) 2007, 2008, 2009. QLogic Corp. All rights reserved.
# Copyright (c) 2003, 2004, 2005. PathScale, Inc. All rights reserved.

%global ver 0.5
%global RELEASE 23
%global rel %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Name: libhfi1
Version: %ver
Release: %rel%{?dist}
Summary: Intel Omni-Path HFI Userspace Driver

Group: System Environment/Libraries
License: GPLv2 or BSD
Url: http://www.github.com/01org/opa-libhfi1verbs/
Source: %{name}-%{version}.tar.gz

BuildRequires: libibverbs-devel >= 1.0-0.5.rc7
BuildRequires: autoconf automake libtool
BuildRequires: valgrind-devel
ExclusiveArch: x86_64
Obsoletes: libhfiverbs
Obsoletes: libhfi1verbs

%description
libhfi1 provides a device-specific userspace driver for Intel Host
Fabric interface cards.  This driver is designed for use with the
libibverbs library.

%package static
Summary: Development files for the libhfi1 driver
Group: System Environment/Libraries
Requires: %{name} = %{version}-%{release}
Obsoletes: libhfiverbs-devel
Obsoletes: libhfi1verbs-devel

%description static
Static version of libhfi1 that may be linked directly to an
application, which may be useful for debugging.

%prep
%setup -q

%build
./autogen.sh
%configure --with-valgrind
make

%install
make DESTDIR=$RPM_BUILD_ROOT install
# remove unpackaged files from the buildroot
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%files
%{_libdir}/libhfi1verbs*.so
%doc AUTHORS README
%license COPYING
%config %{_sysconfdir}/libibverbs.d/hfi1.driver

%files static
%{_libdir}/libhfi1verbs*.a

%changelog
* Thu Apr 21 2016 Dennis Dalessandro <dennis.dalessandro@intel.com> 0.5-23
- Initial packaging for libhfi1 for Fedora.
