{- libguestfs Haskell bindings
   Copyright (C) 2009-2019 Red Hat Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
-}

module Guestfs030Config where
import Guestfs as G
import Control.Monad

main = do
  g <- G.create

  G.set_verbose g True
  v <- G.get_verbose g
  when (v /= True) $
    fail "get_verbose /= True"
  G.set_verbose g False
  v <- G.get_verbose g
  when (v /= False) $
    fail "get_verbose /= False"

  G.set_path g (Just ".")
  p <- G.get_path g
  when (p /= ".") $
    fail "path not dot"
  G.set_path g Nothing
  p <- G.get_path g
  when (p == "") $
    fail "path is empty"

  G.add_drive_ro g "/dev/null"
  G.add_drive_ro g "/dev/zero"
