/* libguestfs generated file
 * WARNING: THIS FILE IS GENERATED FROM THE FOLLOWING FILES:
 *          generator/ruby.ml
 *          and from the code in the generator/ subdirectory.
 * ANY CHANGES YOU MAKE TO THIS FILE WILL BE LOST.
 *
 * Copyright (C) 2009-2017 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef GUESTFS_RUBY_ACTIONS_H_
#define GUESTFS_RUBY_ACTIONS_H_

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wstrict-prototypes"
#if defined(__GNUC__) && __GNUC__ >= 6 /* gcc >= 6 */
#pragma GCC diagnostic ignored "-Wshift-overflow"
#endif
#include <ruby.h>
#pragma GCC diagnostic pop

/* ruby/defines.h defines '_'. */
#ifdef _
#undef _
#endif

#include "guestfs.h"
#include "guestfs-internal-frontend.h" /* Only for POINTER_NOT_IMPLEMENTED */

#include "extconf.h"

/* For Ruby < 1.9 */
#ifndef RARRAY_LEN
#define RARRAY_LEN(r) (RARRAY((r))->len)
#endif

/* For Ruby < 1.8 */
#ifndef RSTRING_LEN
#define RSTRING_LEN(r) (RSTRING((r))->len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(r) (RSTRING((r))->ptr)
#endif

extern VALUE m_guestfs;			/* guestfs module */
extern VALUE c_guestfs;			/* guestfs_h handle */
extern VALUE e_Error;			/* used for all errors */

extern VALUE guestfs_int_ruby_alloc_handle (VALUE klass);
extern VALUE guestfs_int_ruby_initialize_handle (int argc, VALUE *argv, VALUE m);
extern VALUE guestfs_int_ruby_compat_create_handle (int argc, VALUE *argv, VALUE module);
extern VALUE guestfs_int_ruby_close_handle (VALUE gv);
extern VALUE guestfs_int_ruby_set_event_callback (VALUE gv, VALUE cbv, VALUE event_bitmaskv);
extern VALUE guestfs_int_ruby_delete_event_callback (VALUE gv, VALUE event_handlev);
extern VALUE guestfs_int_ruby_event_to_string (VALUE modulev, VALUE eventsv);

extern VALUE guestfs_int_ruby_acl_delete_def_file (VALUE gv, VALUE dirv);
extern VALUE guestfs_int_ruby_acl_get_file (VALUE gv, VALUE pathv, VALUE acltypev);
extern VALUE guestfs_int_ruby_acl_set_file (VALUE gv, VALUE pathv, VALUE acltypev, VALUE aclv);
extern VALUE guestfs_int_ruby_add_cdrom (VALUE gv, VALUE filenamev);
extern VALUE guestfs_int_ruby_add_domain (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_add_drive (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_add_drive_ro (VALUE gv, VALUE filenamev);
extern VALUE guestfs_int_ruby_add_drive_ro_with_if (VALUE gv, VALUE filenamev, VALUE ifacev);
extern VALUE guestfs_int_ruby_add_drive_scratch (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_add_drive_with_if (VALUE gv, VALUE filenamev, VALUE ifacev);
extern VALUE guestfs_int_ruby_add_libvirt_dom (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_aug_clear (VALUE gv, VALUE augpathv);
extern VALUE guestfs_int_ruby_aug_close (VALUE gv);
extern VALUE guestfs_int_ruby_aug_defnode (VALUE gv, VALUE namev, VALUE exprv, VALUE valv);
extern VALUE guestfs_int_ruby_aug_defvar (VALUE gv, VALUE namev, VALUE exprv);
extern VALUE guestfs_int_ruby_aug_get (VALUE gv, VALUE augpathv);
extern VALUE guestfs_int_ruby_aug_init (VALUE gv, VALUE rootv, VALUE flagsv);
extern VALUE guestfs_int_ruby_aug_insert (VALUE gv, VALUE augpathv, VALUE labelv, VALUE beforev);
extern VALUE guestfs_int_ruby_aug_label (VALUE gv, VALUE augpathv);
extern VALUE guestfs_int_ruby_aug_load (VALUE gv);
extern VALUE guestfs_int_ruby_aug_ls (VALUE gv, VALUE augpathv);
extern VALUE guestfs_int_ruby_aug_match (VALUE gv, VALUE augpathv);
extern VALUE guestfs_int_ruby_aug_mv (VALUE gv, VALUE srcv, VALUE destv);
extern VALUE guestfs_int_ruby_aug_rm (VALUE gv, VALUE augpathv);
extern VALUE guestfs_int_ruby_aug_save (VALUE gv);
extern VALUE guestfs_int_ruby_aug_set (VALUE gv, VALUE augpathv, VALUE valv);
extern VALUE guestfs_int_ruby_aug_setm (VALUE gv, VALUE basev, VALUE subv, VALUE valv);
extern VALUE guestfs_int_ruby_aug_transform (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_available (VALUE gv, VALUE groupsv);
extern VALUE guestfs_int_ruby_available_all_groups (VALUE gv);
extern VALUE guestfs_int_ruby_base64_in (VALUE gv, VALUE base64filev, VALUE filenamev);
extern VALUE guestfs_int_ruby_base64_out (VALUE gv, VALUE filenamev, VALUE base64filev);
extern VALUE guestfs_int_ruby_blkdiscard (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_blkdiscardzeroes (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_blkid (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_blockdev_flushbufs (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_blockdev_getbsz (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_blockdev_getro (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_blockdev_getsize64 (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_blockdev_getss (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_blockdev_getsz (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_blockdev_rereadpt (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_blockdev_setbsz (VALUE gv, VALUE devicev, VALUE blocksizev);
extern VALUE guestfs_int_ruby_blockdev_setra (VALUE gv, VALUE devicev, VALUE sectorsv);
extern VALUE guestfs_int_ruby_blockdev_setro (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_blockdev_setrw (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_btrfs_balance_cancel (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_btrfs_balance_pause (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_btrfs_balance_resume (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_btrfs_balance_status (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_btrfs_device_add (VALUE gv, VALUE devicesv, VALUE fsv);
extern VALUE guestfs_int_ruby_btrfs_device_delete (VALUE gv, VALUE devicesv, VALUE fsv);
extern VALUE guestfs_int_ruby_btrfs_filesystem_balance (VALUE gv, VALUE fsv);
extern VALUE guestfs_int_ruby_btrfs_filesystem_defragment (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_btrfs_filesystem_resize (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_btrfs_filesystem_show (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_btrfs_filesystem_sync (VALUE gv, VALUE fsv);
extern VALUE guestfs_int_ruby_btrfs_fsck (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_btrfs_image (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_btrfs_qgroup_assign (VALUE gv, VALUE srcv, VALUE dstv, VALUE pathv);
extern VALUE guestfs_int_ruby_btrfs_qgroup_create (VALUE gv, VALUE qgroupidv, VALUE subvolumev);
extern VALUE guestfs_int_ruby_btrfs_qgroup_destroy (VALUE gv, VALUE qgroupidv, VALUE subvolumev);
extern VALUE guestfs_int_ruby_btrfs_qgroup_limit (VALUE gv, VALUE subvolumev, VALUE sizev);
extern VALUE guestfs_int_ruby_btrfs_qgroup_remove (VALUE gv, VALUE srcv, VALUE dstv, VALUE pathv);
extern VALUE guestfs_int_ruby_btrfs_qgroup_show (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_btrfs_quota_enable (VALUE gv, VALUE fsv, VALUE enablev);
extern VALUE guestfs_int_ruby_btrfs_quota_rescan (VALUE gv, VALUE fsv);
extern VALUE guestfs_int_ruby_btrfs_replace (VALUE gv, VALUE srcdevv, VALUE targetdevv, VALUE mntpointv);
extern VALUE guestfs_int_ruby_btrfs_rescue_chunk_recover (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_btrfs_rescue_super_recover (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_btrfs_scrub_cancel (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_btrfs_scrub_resume (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_btrfs_scrub_start (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_btrfs_scrub_status (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_btrfs_set_seeding (VALUE gv, VALUE devicev, VALUE seedingv);
extern VALUE guestfs_int_ruby_btrfs_subvolume_create (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_btrfs_subvolume_delete (VALUE gv, VALUE subvolumev);
extern VALUE guestfs_int_ruby_btrfs_subvolume_get_default (VALUE gv, VALUE fsv);
extern VALUE guestfs_int_ruby_btrfs_subvolume_list (VALUE gv, VALUE fsv);
extern VALUE guestfs_int_ruby_btrfs_subvolume_set_default (VALUE gv, VALUE idv, VALUE fsv);
extern VALUE guestfs_int_ruby_btrfs_subvolume_show (VALUE gv, VALUE subvolumev);
extern VALUE guestfs_int_ruby_btrfs_subvolume_snapshot (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_btrfstune_enable_extended_inode_refs (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_btrfstune_enable_skinny_metadata_extent_refs (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_btrfstune_seeding (VALUE gv, VALUE devicev, VALUE seedingv);
extern VALUE guestfs_int_ruby_c_pointer (VALUE gv);
extern VALUE guestfs_int_ruby_canonical_device_name (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_cap_get_file (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_cap_set_file (VALUE gv, VALUE pathv, VALUE capv);
extern VALUE guestfs_int_ruby_case_sensitive_path (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_cat (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_checksum (VALUE gv, VALUE csumtypev, VALUE pathv);
extern VALUE guestfs_int_ruby_checksum_device (VALUE gv, VALUE csumtypev, VALUE devicev);
extern VALUE guestfs_int_ruby_checksums_out (VALUE gv, VALUE csumtypev, VALUE directoryv, VALUE sumsfilev);
extern VALUE guestfs_int_ruby_chmod (VALUE gv, VALUE modev, VALUE pathv);
extern VALUE guestfs_int_ruby_chown (VALUE gv, VALUE ownerv, VALUE groupv, VALUE pathv);
extern VALUE guestfs_int_ruby_clear_backend_setting (VALUE gv, VALUE namev);
extern VALUE guestfs_int_ruby_command (VALUE gv, VALUE argumentsv);
extern VALUE guestfs_int_ruby_command_lines (VALUE gv, VALUE argumentsv);
extern VALUE guestfs_int_ruby_compress_device_out (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_compress_out (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_config (VALUE gv, VALUE hvparamv, VALUE hvvaluev);
extern VALUE guestfs_int_ruby_copy_attributes (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_copy_device_to_device (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_copy_device_to_file (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_copy_file_to_device (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_copy_file_to_file (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_copy_in (VALUE gv, VALUE localpathv, VALUE remotedirv);
extern VALUE guestfs_int_ruby_copy_out (VALUE gv, VALUE remotepathv, VALUE localdirv);
extern VALUE guestfs_int_ruby_copy_size (VALUE gv, VALUE srcv, VALUE destv, VALUE sizev);
extern VALUE guestfs_int_ruby_cp (VALUE gv, VALUE srcv, VALUE destv);
extern VALUE guestfs_int_ruby_cp_a (VALUE gv, VALUE srcv, VALUE destv);
extern VALUE guestfs_int_ruby_cp_r (VALUE gv, VALUE srcv, VALUE destv);
extern VALUE guestfs_int_ruby_cpio_out (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_dd (VALUE gv, VALUE srcv, VALUE destv);
extern VALUE guestfs_int_ruby_debug (VALUE gv, VALUE subcmdv, VALUE extraargsv);
extern VALUE guestfs_int_ruby_debug_drives (VALUE gv);
extern VALUE guestfs_int_ruby_debug_upload (VALUE gv, VALUE filenamev, VALUE tmpnamev, VALUE modev);
extern VALUE guestfs_int_ruby_device_index (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_df (VALUE gv);
extern VALUE guestfs_int_ruby_df_h (VALUE gv);
extern VALUE guestfs_int_ruby_disk_create (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_disk_format (VALUE gv, VALUE filenamev);
extern VALUE guestfs_int_ruby_disk_has_backing_file (VALUE gv, VALUE filenamev);
extern VALUE guestfs_int_ruby_disk_virtual_size (VALUE gv, VALUE filenamev);
extern VALUE guestfs_int_ruby_dmesg (VALUE gv);
extern VALUE guestfs_int_ruby_download (VALUE gv, VALUE remotefilenamev, VALUE filenamev);
extern VALUE guestfs_int_ruby_download_blocks (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_download_inode (VALUE gv, VALUE devicev, VALUE inodev, VALUE filenamev);
extern VALUE guestfs_int_ruby_download_offset (VALUE gv, VALUE remotefilenamev, VALUE filenamev, VALUE offsetv, VALUE sizev);
extern VALUE guestfs_int_ruby_drop_caches (VALUE gv, VALUE whattodropv);
extern VALUE guestfs_int_ruby_du (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_e2fsck (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_e2fsck_f (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_echo_daemon (VALUE gv, VALUE wordsv);
extern VALUE guestfs_int_ruby_egrep (VALUE gv, VALUE regexv, VALUE pathv);
extern VALUE guestfs_int_ruby_egrepi (VALUE gv, VALUE regexv, VALUE pathv);
extern VALUE guestfs_int_ruby_equal (VALUE gv, VALUE file1v, VALUE file2v);
extern VALUE guestfs_int_ruby_exists (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_extlinux (VALUE gv, VALUE directoryv);
extern VALUE guestfs_int_ruby_fallocate (VALUE gv, VALUE pathv, VALUE lenv);
extern VALUE guestfs_int_ruby_fallocate64 (VALUE gv, VALUE pathv, VALUE lenv);
extern VALUE guestfs_int_ruby_feature_available (VALUE gv, VALUE groupsv);
extern VALUE guestfs_int_ruby_fgrep (VALUE gv, VALUE patternv, VALUE pathv);
extern VALUE guestfs_int_ruby_fgrepi (VALUE gv, VALUE patternv, VALUE pathv);
extern VALUE guestfs_int_ruby_file (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_file_architecture (VALUE gv, VALUE filenamev);
extern VALUE guestfs_int_ruby_filesize (VALUE gv, VALUE filev);
extern VALUE guestfs_int_ruby_filesystem_available (VALUE gv, VALUE filesystemv);
extern VALUE guestfs_int_ruby_filesystem_walk (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_fill (VALUE gv, VALUE cv, VALUE lenv, VALUE pathv);
extern VALUE guestfs_int_ruby_fill_dir (VALUE gv, VALUE dirv, VALUE nrv);
extern VALUE guestfs_int_ruby_fill_pattern (VALUE gv, VALUE patternv, VALUE lenv, VALUE pathv);
extern VALUE guestfs_int_ruby_find (VALUE gv, VALUE directoryv);
extern VALUE guestfs_int_ruby_find0 (VALUE gv, VALUE directoryv, VALUE filesv);
extern VALUE guestfs_int_ruby_find_inode (VALUE gv, VALUE devicev, VALUE inodev);
extern VALUE guestfs_int_ruby_findfs_label (VALUE gv, VALUE labelv);
extern VALUE guestfs_int_ruby_findfs_uuid (VALUE gv, VALUE uuidv);
extern VALUE guestfs_int_ruby_fsck (VALUE gv, VALUE fstypev, VALUE devicev);
extern VALUE guestfs_int_ruby_fstrim (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_get_append (VALUE gv);
extern VALUE guestfs_int_ruby_get_attach_method (VALUE gv);
extern VALUE guestfs_int_ruby_get_autosync (VALUE gv);
extern VALUE guestfs_int_ruby_get_backend (VALUE gv);
extern VALUE guestfs_int_ruby_get_backend_setting (VALUE gv, VALUE namev);
extern VALUE guestfs_int_ruby_get_backend_settings (VALUE gv);
extern VALUE guestfs_int_ruby_get_cachedir (VALUE gv);
extern VALUE guestfs_int_ruby_get_direct (VALUE gv);
extern VALUE guestfs_int_ruby_get_e2attrs (VALUE gv, VALUE filev);
extern VALUE guestfs_int_ruby_get_e2generation (VALUE gv, VALUE filev);
extern VALUE guestfs_int_ruby_get_e2label (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_get_e2uuid (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_get_hv (VALUE gv);
extern VALUE guestfs_int_ruby_get_identifier (VALUE gv);
extern VALUE guestfs_int_ruby_get_libvirt_requested_credential_challenge (VALUE gv, VALUE indexv);
extern VALUE guestfs_int_ruby_get_libvirt_requested_credential_defresult (VALUE gv, VALUE indexv);
extern VALUE guestfs_int_ruby_get_libvirt_requested_credential_prompt (VALUE gv, VALUE indexv);
extern VALUE guestfs_int_ruby_get_libvirt_requested_credentials (VALUE gv);
extern VALUE guestfs_int_ruby_get_memsize (VALUE gv);
extern VALUE guestfs_int_ruby_get_network (VALUE gv);
extern VALUE guestfs_int_ruby_get_path (VALUE gv);
extern VALUE guestfs_int_ruby_get_pgroup (VALUE gv);
extern VALUE guestfs_int_ruby_get_pid (VALUE gv);
extern VALUE guestfs_int_ruby_get_program (VALUE gv);
extern VALUE guestfs_int_ruby_get_qemu (VALUE gv);
extern VALUE guestfs_int_ruby_get_recovery_proc (VALUE gv);
extern VALUE guestfs_int_ruby_get_selinux (VALUE gv);
extern VALUE guestfs_int_ruby_get_smp (VALUE gv);
extern VALUE guestfs_int_ruby_get_sockdir (VALUE gv);
extern VALUE guestfs_int_ruby_get_state (VALUE gv);
extern VALUE guestfs_int_ruby_get_tmpdir (VALUE gv);
extern VALUE guestfs_int_ruby_get_trace (VALUE gv);
extern VALUE guestfs_int_ruby_get_umask (VALUE gv);
extern VALUE guestfs_int_ruby_get_verbose (VALUE gv);
extern VALUE guestfs_int_ruby_getcon (VALUE gv);
extern VALUE guestfs_int_ruby_getxattr (VALUE gv, VALUE pathv, VALUE namev);
extern VALUE guestfs_int_ruby_getxattrs (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_glob_expand (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_grep (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_grepi (VALUE gv, VALUE regexv, VALUE pathv);
extern VALUE guestfs_int_ruby_grub_install (VALUE gv, VALUE rootv, VALUE devicev);
extern VALUE guestfs_int_ruby_head (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_head_n (VALUE gv, VALUE nrlinesv, VALUE pathv);
extern VALUE guestfs_int_ruby_hexdump (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_hivex_close (VALUE gv);
extern VALUE guestfs_int_ruby_hivex_commit (VALUE gv, VALUE filenamev);
extern VALUE guestfs_int_ruby_hivex_node_add_child (VALUE gv, VALUE parentv, VALUE namev);
extern VALUE guestfs_int_ruby_hivex_node_children (VALUE gv, VALUE nodehv);
extern VALUE guestfs_int_ruby_hivex_node_delete_child (VALUE gv, VALUE nodehv);
extern VALUE guestfs_int_ruby_hivex_node_get_child (VALUE gv, VALUE nodehv, VALUE namev);
extern VALUE guestfs_int_ruby_hivex_node_get_value (VALUE gv, VALUE nodehv, VALUE keyv);
extern VALUE guestfs_int_ruby_hivex_node_name (VALUE gv, VALUE nodehv);
extern VALUE guestfs_int_ruby_hivex_node_parent (VALUE gv, VALUE nodehv);
extern VALUE guestfs_int_ruby_hivex_node_set_value (VALUE gv, VALUE nodehv, VALUE keyv, VALUE tv, VALUE valv);
extern VALUE guestfs_int_ruby_hivex_node_values (VALUE gv, VALUE nodehv);
extern VALUE guestfs_int_ruby_hivex_open (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_hivex_root (VALUE gv);
extern VALUE guestfs_int_ruby_hivex_value_key (VALUE gv, VALUE valuehv);
extern VALUE guestfs_int_ruby_hivex_value_type (VALUE gv, VALUE valuehv);
extern VALUE guestfs_int_ruby_hivex_value_utf8 (VALUE gv, VALUE valuehv);
extern VALUE guestfs_int_ruby_hivex_value_value (VALUE gv, VALUE valuehv);
extern VALUE guestfs_int_ruby_initrd_cat (VALUE gv, VALUE initrdpathv, VALUE filenamev);
extern VALUE guestfs_int_ruby_initrd_list (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_inotify_add_watch (VALUE gv, VALUE pathv, VALUE maskv);
extern VALUE guestfs_int_ruby_inotify_close (VALUE gv);
extern VALUE guestfs_int_ruby_inotify_files (VALUE gv);
extern VALUE guestfs_int_ruby_inotify_init (VALUE gv, VALUE maxeventsv);
extern VALUE guestfs_int_ruby_inotify_read (VALUE gv);
extern VALUE guestfs_int_ruby_inotify_rm_watch (VALUE gv, VALUE wdv);
extern VALUE guestfs_int_ruby_inspect_get_arch (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_distro (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_drive_mappings (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_filesystems (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_format (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_hostname (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_icon (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_inspect_get_major_version (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_minor_version (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_mountpoints (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_package_format (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_package_management (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_product_name (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_product_variant (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_roots (VALUE gv);
extern VALUE guestfs_int_ruby_inspect_get_type (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_windows_current_control_set (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_windows_software_hive (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_windows_system_hive (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_get_windows_systemroot (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_is_live (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_is_multipart (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_is_netinst (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_list_applications (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_list_applications2 (VALUE gv, VALUE rootv);
extern VALUE guestfs_int_ruby_inspect_os (VALUE gv);
extern VALUE guestfs_int_ruby_internal_exit (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_63_optargs (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_close_output (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_only_optargs (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_rbool (VALUE gv, VALUE valv);
extern VALUE guestfs_int_ruby_internal_test_rboolerr (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_rbufferout (VALUE gv, VALUE valv);
extern VALUE guestfs_int_ruby_internal_test_rbufferouterr (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_rconstoptstring (VALUE gv, VALUE valv);
extern VALUE guestfs_int_ruby_internal_test_rconstoptstringerr (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_rconststring (VALUE gv, VALUE valv);
extern VALUE guestfs_int_ruby_internal_test_rconststringerr (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_rhashtable (VALUE gv, VALUE valv);
extern VALUE guestfs_int_ruby_internal_test_rhashtableerr (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_rint (VALUE gv, VALUE valv);
extern VALUE guestfs_int_ruby_internal_test_rint64 (VALUE gv, VALUE valv);
extern VALUE guestfs_int_ruby_internal_test_rint64err (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_rinterr (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_rstring (VALUE gv, VALUE valv);
extern VALUE guestfs_int_ruby_internal_test_rstringerr (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_rstringlist (VALUE gv, VALUE valv);
extern VALUE guestfs_int_ruby_internal_test_rstringlisterr (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_rstruct (VALUE gv, VALUE valv);
extern VALUE guestfs_int_ruby_internal_test_rstructerr (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_rstructlist (VALUE gv, VALUE valv);
extern VALUE guestfs_int_ruby_internal_test_rstructlisterr (VALUE gv);
extern VALUE guestfs_int_ruby_internal_test_set_output (VALUE gv, VALUE filenamev);
extern VALUE guestfs_int_ruby_is_blockdev (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_is_busy (VALUE gv);
extern VALUE guestfs_int_ruby_is_chardev (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_is_config (VALUE gv);
extern VALUE guestfs_int_ruby_is_dir (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_is_fifo (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_is_file (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_is_launching (VALUE gv);
extern VALUE guestfs_int_ruby_is_lv (VALUE gv, VALUE mountablev);
extern VALUE guestfs_int_ruby_is_ready (VALUE gv);
extern VALUE guestfs_int_ruby_is_socket (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_is_symlink (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_is_whole_device (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_is_zero (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_is_zero_device (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_isoinfo (VALUE gv, VALUE isofilev);
extern VALUE guestfs_int_ruby_isoinfo_device (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_journal_close (VALUE gv);
extern VALUE guestfs_int_ruby_journal_get (VALUE gv);
extern VALUE guestfs_int_ruby_journal_get_data_threshold (VALUE gv);
extern VALUE guestfs_int_ruby_journal_get_realtime_usec (VALUE gv);
extern VALUE guestfs_int_ruby_journal_next (VALUE gv);
extern VALUE guestfs_int_ruby_journal_open (VALUE gv, VALUE directoryv);
extern VALUE guestfs_int_ruby_journal_set_data_threshold (VALUE gv, VALUE thresholdv);
extern VALUE guestfs_int_ruby_journal_skip (VALUE gv, VALUE skipv);
extern VALUE guestfs_int_ruby_kill_subprocess (VALUE gv);
extern VALUE guestfs_int_ruby_launch (VALUE gv);
extern VALUE guestfs_int_ruby_lchown (VALUE gv, VALUE ownerv, VALUE groupv, VALUE pathv);
extern VALUE guestfs_int_ruby_ldmtool_create_all (VALUE gv);
extern VALUE guestfs_int_ruby_ldmtool_diskgroup_disks (VALUE gv, VALUE diskgroupv);
extern VALUE guestfs_int_ruby_ldmtool_diskgroup_name (VALUE gv, VALUE diskgroupv);
extern VALUE guestfs_int_ruby_ldmtool_diskgroup_volumes (VALUE gv, VALUE diskgroupv);
extern VALUE guestfs_int_ruby_ldmtool_remove_all (VALUE gv);
extern VALUE guestfs_int_ruby_ldmtool_scan (VALUE gv);
extern VALUE guestfs_int_ruby_ldmtool_scan_devices (VALUE gv, VALUE devicesv);
extern VALUE guestfs_int_ruby_ldmtool_volume_hint (VALUE gv, VALUE diskgroupv, VALUE volumev);
extern VALUE guestfs_int_ruby_ldmtool_volume_partitions (VALUE gv, VALUE diskgroupv, VALUE volumev);
extern VALUE guestfs_int_ruby_ldmtool_volume_type (VALUE gv, VALUE diskgroupv, VALUE volumev);
extern VALUE guestfs_int_ruby_lgetxattr (VALUE gv, VALUE pathv, VALUE namev);
extern VALUE guestfs_int_ruby_lgetxattrs (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_list_9p (VALUE gv);
extern VALUE guestfs_int_ruby_list_devices (VALUE gv);
extern VALUE guestfs_int_ruby_list_disk_labels (VALUE gv);
extern VALUE guestfs_int_ruby_list_dm_devices (VALUE gv);
extern VALUE guestfs_int_ruby_list_filesystems (VALUE gv);
extern VALUE guestfs_int_ruby_list_ldm_partitions (VALUE gv);
extern VALUE guestfs_int_ruby_list_ldm_volumes (VALUE gv);
extern VALUE guestfs_int_ruby_list_md_devices (VALUE gv);
extern VALUE guestfs_int_ruby_list_partitions (VALUE gv);
extern VALUE guestfs_int_ruby_ll (VALUE gv, VALUE directoryv);
extern VALUE guestfs_int_ruby_llz (VALUE gv, VALUE directoryv);
extern VALUE guestfs_int_ruby_ln (VALUE gv, VALUE targetv, VALUE linknamev);
extern VALUE guestfs_int_ruby_ln_f (VALUE gv, VALUE targetv, VALUE linknamev);
extern VALUE guestfs_int_ruby_ln_s (VALUE gv, VALUE targetv, VALUE linknamev);
extern VALUE guestfs_int_ruby_ln_sf (VALUE gv, VALUE targetv, VALUE linknamev);
extern VALUE guestfs_int_ruby_lremovexattr (VALUE gv, VALUE xattrv, VALUE pathv);
extern VALUE guestfs_int_ruby_ls (VALUE gv, VALUE directoryv);
extern VALUE guestfs_int_ruby_ls0 (VALUE gv, VALUE dirv, VALUE filenamesv);
extern VALUE guestfs_int_ruby_lsetxattr (VALUE gv, VALUE xattrv, VALUE valv, VALUE vallenv, VALUE pathv);
extern VALUE guestfs_int_ruby_lstat (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_lstatlist (VALUE gv, VALUE pathv, VALUE namesv);
extern VALUE guestfs_int_ruby_lstatns (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_lstatnslist (VALUE gv, VALUE pathv, VALUE namesv);
extern VALUE guestfs_int_ruby_luks_add_key (VALUE gv, VALUE devicev, VALUE keyv, VALUE newkeyv, VALUE keyslotv);
extern VALUE guestfs_int_ruby_luks_close (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_luks_format (VALUE gv, VALUE devicev, VALUE keyv, VALUE keyslotv);
extern VALUE guestfs_int_ruby_luks_format_cipher (VALUE gv, VALUE devicev, VALUE keyv, VALUE keyslotv, VALUE cipherv);
extern VALUE guestfs_int_ruby_luks_kill_slot (VALUE gv, VALUE devicev, VALUE keyv, VALUE keyslotv);
extern VALUE guestfs_int_ruby_luks_open (VALUE gv, VALUE devicev, VALUE keyv, VALUE mapnamev);
extern VALUE guestfs_int_ruby_luks_open_ro (VALUE gv, VALUE devicev, VALUE keyv, VALUE mapnamev);
extern VALUE guestfs_int_ruby_lvcreate (VALUE gv, VALUE logvolv, VALUE volgroupv, VALUE mbytesv);
extern VALUE guestfs_int_ruby_lvcreate_free (VALUE gv, VALUE logvolv, VALUE volgroupv, VALUE percentv);
extern VALUE guestfs_int_ruby_lvm_canonical_lv_name (VALUE gv, VALUE lvnamev);
extern VALUE guestfs_int_ruby_lvm_clear_filter (VALUE gv);
extern VALUE guestfs_int_ruby_lvm_remove_all (VALUE gv);
extern VALUE guestfs_int_ruby_lvm_set_filter (VALUE gv, VALUE devicesv);
extern VALUE guestfs_int_ruby_lvremove (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_lvrename (VALUE gv, VALUE logvolv, VALUE newlogvolv);
extern VALUE guestfs_int_ruby_lvresize (VALUE gv, VALUE devicev, VALUE mbytesv);
extern VALUE guestfs_int_ruby_lvresize_free (VALUE gv, VALUE lvv, VALUE percentv);
extern VALUE guestfs_int_ruby_lvs (VALUE gv);
extern VALUE guestfs_int_ruby_lvs_full (VALUE gv);
extern VALUE guestfs_int_ruby_lvuuid (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_lxattrlist (VALUE gv, VALUE pathv, VALUE namesv);
extern VALUE guestfs_int_ruby_max_disks (VALUE gv);
extern VALUE guestfs_int_ruby_md_create (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_md_detail (VALUE gv, VALUE mdv);
extern VALUE guestfs_int_ruby_md_stat (VALUE gv, VALUE mdv);
extern VALUE guestfs_int_ruby_md_stop (VALUE gv, VALUE mdv);
extern VALUE guestfs_int_ruby_mkdir (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_mkdir_mode (VALUE gv, VALUE pathv, VALUE modev);
extern VALUE guestfs_int_ruby_mkdir_p (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_mkdtemp (VALUE gv, VALUE tmplv);
extern VALUE guestfs_int_ruby_mke2fs (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_mke2fs_J (VALUE gv, VALUE fstypev, VALUE blocksizev, VALUE devicev, VALUE journalv);
extern VALUE guestfs_int_ruby_mke2fs_JL (VALUE gv, VALUE fstypev, VALUE blocksizev, VALUE devicev, VALUE labelv);
extern VALUE guestfs_int_ruby_mke2fs_JU (VALUE gv, VALUE fstypev, VALUE blocksizev, VALUE devicev, VALUE uuidv);
extern VALUE guestfs_int_ruby_mke2journal (VALUE gv, VALUE blocksizev, VALUE devicev);
extern VALUE guestfs_int_ruby_mke2journal_L (VALUE gv, VALUE blocksizev, VALUE labelv, VALUE devicev);
extern VALUE guestfs_int_ruby_mke2journal_U (VALUE gv, VALUE blocksizev, VALUE uuidv, VALUE devicev);
extern VALUE guestfs_int_ruby_mkfifo (VALUE gv, VALUE modev, VALUE pathv);
extern VALUE guestfs_int_ruby_mkfs (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_mkfs_b (VALUE gv, VALUE fstypev, VALUE blocksizev, VALUE devicev);
extern VALUE guestfs_int_ruby_mkfs_btrfs (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_mklost_and_found (VALUE gv, VALUE mountpointv);
extern VALUE guestfs_int_ruby_mkmountpoint (VALUE gv, VALUE exemptpathv);
extern VALUE guestfs_int_ruby_mknod (VALUE gv, VALUE modev, VALUE devmajorv, VALUE devminorv, VALUE pathv);
extern VALUE guestfs_int_ruby_mknod_b (VALUE gv, VALUE modev, VALUE devmajorv, VALUE devminorv, VALUE pathv);
extern VALUE guestfs_int_ruby_mknod_c (VALUE gv, VALUE modev, VALUE devmajorv, VALUE devminorv, VALUE pathv);
extern VALUE guestfs_int_ruby_mksquashfs (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_mkswap (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_mkswap_L (VALUE gv, VALUE labelv, VALUE devicev);
extern VALUE guestfs_int_ruby_mkswap_U (VALUE gv, VALUE uuidv, VALUE devicev);
extern VALUE guestfs_int_ruby_mkswap_file (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_mktemp (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_modprobe (VALUE gv, VALUE modulenamev);
extern VALUE guestfs_int_ruby_mount (VALUE gv, VALUE mountablev, VALUE mountpointv);
extern VALUE guestfs_int_ruby_mount_9p (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_mount_local (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_mount_local_run (VALUE gv);
extern VALUE guestfs_int_ruby_mount_loop (VALUE gv, VALUE filev, VALUE mountpointv);
extern VALUE guestfs_int_ruby_mount_options (VALUE gv, VALUE optionsv, VALUE mountablev, VALUE mountpointv);
extern VALUE guestfs_int_ruby_mount_ro (VALUE gv, VALUE mountablev, VALUE mountpointv);
extern VALUE guestfs_int_ruby_mount_vfs (VALUE gv, VALUE optionsv, VALUE vfstypev, VALUE mountablev, VALUE mountpointv);
extern VALUE guestfs_int_ruby_mountable_device (VALUE gv, VALUE mountablev);
extern VALUE guestfs_int_ruby_mountable_subvolume (VALUE gv, VALUE mountablev);
extern VALUE guestfs_int_ruby_mountpoints (VALUE gv);
extern VALUE guestfs_int_ruby_mounts (VALUE gv);
extern VALUE guestfs_int_ruby_mv (VALUE gv, VALUE srcv, VALUE destv);
extern VALUE guestfs_int_ruby_nr_devices (VALUE gv);
extern VALUE guestfs_int_ruby_ntfs_3g_probe (VALUE gv, VALUE rwv, VALUE devicev);
extern VALUE guestfs_int_ruby_ntfscat_i (VALUE gv, VALUE devicev, VALUE inodev, VALUE filenamev);
extern VALUE guestfs_int_ruby_ntfsclone_in (VALUE gv, VALUE backupfilev, VALUE devicev);
extern VALUE guestfs_int_ruby_ntfsclone_out (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_ntfsfix (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_ntfsresize (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_ntfsresize_size (VALUE gv, VALUE devicev, VALUE sizev);
extern VALUE guestfs_int_ruby_parse_environment (VALUE gv);
extern VALUE guestfs_int_ruby_parse_environment_list (VALUE gv, VALUE environmentv);
extern VALUE guestfs_int_ruby_part_add (VALUE gv, VALUE devicev, VALUE prlogexv, VALUE startsectv, VALUE endsectv);
extern VALUE guestfs_int_ruby_part_del (VALUE gv, VALUE devicev, VALUE partnumv);
extern VALUE guestfs_int_ruby_part_disk (VALUE gv, VALUE devicev, VALUE parttypev);
extern VALUE guestfs_int_ruby_part_expand_gpt (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_part_get_bootable (VALUE gv, VALUE devicev, VALUE partnumv);
extern VALUE guestfs_int_ruby_part_get_disk_guid (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_part_get_gpt_guid (VALUE gv, VALUE devicev, VALUE partnumv);
extern VALUE guestfs_int_ruby_part_get_gpt_type (VALUE gv, VALUE devicev, VALUE partnumv);
extern VALUE guestfs_int_ruby_part_get_mbr_id (VALUE gv, VALUE devicev, VALUE partnumv);
extern VALUE guestfs_int_ruby_part_get_mbr_part_type (VALUE gv, VALUE devicev, VALUE partnumv);
extern VALUE guestfs_int_ruby_part_get_name (VALUE gv, VALUE devicev, VALUE partnumv);
extern VALUE guestfs_int_ruby_part_get_parttype (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_part_init (VALUE gv, VALUE devicev, VALUE parttypev);
extern VALUE guestfs_int_ruby_part_list (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_part_set_bootable (VALUE gv, VALUE devicev, VALUE partnumv, VALUE bootablev);
extern VALUE guestfs_int_ruby_part_set_disk_guid (VALUE gv, VALUE devicev, VALUE guidv);
extern VALUE guestfs_int_ruby_part_set_disk_guid_random (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_part_set_gpt_guid (VALUE gv, VALUE devicev, VALUE partnumv, VALUE guidv);
extern VALUE guestfs_int_ruby_part_set_gpt_type (VALUE gv, VALUE devicev, VALUE partnumv, VALUE guidv);
extern VALUE guestfs_int_ruby_part_set_mbr_id (VALUE gv, VALUE devicev, VALUE partnumv, VALUE idbytev);
extern VALUE guestfs_int_ruby_part_set_name (VALUE gv, VALUE devicev, VALUE partnumv, VALUE namev);
extern VALUE guestfs_int_ruby_part_to_dev (VALUE gv, VALUE partitionv);
extern VALUE guestfs_int_ruby_part_to_partnum (VALUE gv, VALUE partitionv);
extern VALUE guestfs_int_ruby_ping_daemon (VALUE gv);
extern VALUE guestfs_int_ruby_pread (VALUE gv, VALUE pathv, VALUE countv, VALUE offsetv);
extern VALUE guestfs_int_ruby_pread_device (VALUE gv, VALUE devicev, VALUE countv, VALUE offsetv);
extern VALUE guestfs_int_ruby_pvchange_uuid (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_pvchange_uuid_all (VALUE gv);
extern VALUE guestfs_int_ruby_pvcreate (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_pvremove (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_pvresize (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_pvresize_size (VALUE gv, VALUE devicev, VALUE sizev);
extern VALUE guestfs_int_ruby_pvs (VALUE gv);
extern VALUE guestfs_int_ruby_pvs_full (VALUE gv);
extern VALUE guestfs_int_ruby_pvuuid (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_pwrite (VALUE gv, VALUE pathv, VALUE contentv, VALUE offsetv);
extern VALUE guestfs_int_ruby_pwrite_device (VALUE gv, VALUE devicev, VALUE contentv, VALUE offsetv);
extern VALUE guestfs_int_ruby_read_file (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_read_lines (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_readdir (VALUE gv, VALUE dirv);
extern VALUE guestfs_int_ruby_readlink (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_readlinklist (VALUE gv, VALUE pathv, VALUE namesv);
extern VALUE guestfs_int_ruby_realpath (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_remount (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_remove_drive (VALUE gv, VALUE labelv);
extern VALUE guestfs_int_ruby_removexattr (VALUE gv, VALUE xattrv, VALUE pathv);
extern VALUE guestfs_int_ruby_rename (VALUE gv, VALUE oldpathv, VALUE newpathv);
extern VALUE guestfs_int_ruby_resize2fs (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_resize2fs_M (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_resize2fs_size (VALUE gv, VALUE devicev, VALUE sizev);
extern VALUE guestfs_int_ruby_rm (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_rm_f (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_rm_rf (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_rmdir (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_rmmountpoint (VALUE gv, VALUE exemptpathv);
extern VALUE guestfs_int_ruby_rsync (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_rsync_in (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_rsync_out (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_scrub_device (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_scrub_file (VALUE gv, VALUE filev);
extern VALUE guestfs_int_ruby_scrub_freespace (VALUE gv, VALUE dirv);
extern VALUE guestfs_int_ruby_selinux_relabel (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_set_append (VALUE gv, VALUE appendv);
extern VALUE guestfs_int_ruby_set_attach_method (VALUE gv, VALUE backendv);
extern VALUE guestfs_int_ruby_set_autosync (VALUE gv, VALUE autosyncv);
extern VALUE guestfs_int_ruby_set_backend (VALUE gv, VALUE backendv);
extern VALUE guestfs_int_ruby_set_backend_setting (VALUE gv, VALUE namev, VALUE valv);
extern VALUE guestfs_int_ruby_set_backend_settings (VALUE gv, VALUE settingsv);
extern VALUE guestfs_int_ruby_set_cachedir (VALUE gv, VALUE cachedirv);
extern VALUE guestfs_int_ruby_set_direct (VALUE gv, VALUE directv);
extern VALUE guestfs_int_ruby_set_e2attrs (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_set_e2generation (VALUE gv, VALUE filev, VALUE generationv);
extern VALUE guestfs_int_ruby_set_e2label (VALUE gv, VALUE devicev, VALUE labelv);
extern VALUE guestfs_int_ruby_set_e2uuid (VALUE gv, VALUE devicev, VALUE uuidv);
extern VALUE guestfs_int_ruby_set_hv (VALUE gv, VALUE hvv);
extern VALUE guestfs_int_ruby_set_identifier (VALUE gv, VALUE identifierv);
extern VALUE guestfs_int_ruby_set_label (VALUE gv, VALUE mountablev, VALUE labelv);
extern VALUE guestfs_int_ruby_set_libvirt_requested_credential (VALUE gv, VALUE indexv, VALUE credv);
extern VALUE guestfs_int_ruby_set_libvirt_supported_credentials (VALUE gv, VALUE credsv);
extern VALUE guestfs_int_ruby_set_memsize (VALUE gv, VALUE memsizev);
extern VALUE guestfs_int_ruby_set_network (VALUE gv, VALUE networkv);
extern VALUE guestfs_int_ruby_set_path (VALUE gv, VALUE searchpathv);
extern VALUE guestfs_int_ruby_set_pgroup (VALUE gv, VALUE pgroupv);
extern VALUE guestfs_int_ruby_set_program (VALUE gv, VALUE programv);
extern VALUE guestfs_int_ruby_set_qemu (VALUE gv, VALUE hvv);
extern VALUE guestfs_int_ruby_set_recovery_proc (VALUE gv, VALUE recoveryprocv);
extern VALUE guestfs_int_ruby_set_selinux (VALUE gv, VALUE selinuxv);
extern VALUE guestfs_int_ruby_set_smp (VALUE gv, VALUE smpv);
extern VALUE guestfs_int_ruby_set_tmpdir (VALUE gv, VALUE tmpdirv);
extern VALUE guestfs_int_ruby_set_trace (VALUE gv, VALUE tracev);
extern VALUE guestfs_int_ruby_set_uuid (VALUE gv, VALUE devicev, VALUE uuidv);
extern VALUE guestfs_int_ruby_set_uuid_random (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_set_verbose (VALUE gv, VALUE verbosev);
extern VALUE guestfs_int_ruby_setcon (VALUE gv, VALUE contextv);
extern VALUE guestfs_int_ruby_setxattr (VALUE gv, VALUE xattrv, VALUE valv, VALUE vallenv, VALUE pathv);
extern VALUE guestfs_int_ruby_sfdisk (VALUE gv, VALUE devicev, VALUE cylsv, VALUE headsv, VALUE sectorsv, VALUE linesv);
extern VALUE guestfs_int_ruby_sfdiskM (VALUE gv, VALUE devicev, VALUE linesv);
extern VALUE guestfs_int_ruby_sfdisk_N (VALUE gv, VALUE devicev, VALUE partnumv, VALUE cylsv, VALUE headsv, VALUE sectorsv, VALUE linev);
extern VALUE guestfs_int_ruby_sfdisk_disk_geometry (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_sfdisk_kernel_geometry (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_sfdisk_l (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_sh (VALUE gv, VALUE commandv);
extern VALUE guestfs_int_ruby_sh_lines (VALUE gv, VALUE commandv);
extern VALUE guestfs_int_ruby_shutdown (VALUE gv);
extern VALUE guestfs_int_ruby_sleep (VALUE gv, VALUE secsv);
extern VALUE guestfs_int_ruby_stat (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_statns (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_statvfs (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_strings (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_strings_e (VALUE gv, VALUE encodingv, VALUE pathv);
extern VALUE guestfs_int_ruby_swapoff_device (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_swapoff_file (VALUE gv, VALUE filev);
extern VALUE guestfs_int_ruby_swapoff_label (VALUE gv, VALUE labelv);
extern VALUE guestfs_int_ruby_swapoff_uuid (VALUE gv, VALUE uuidv);
extern VALUE guestfs_int_ruby_swapon_device (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_swapon_file (VALUE gv, VALUE filev);
extern VALUE guestfs_int_ruby_swapon_label (VALUE gv, VALUE labelv);
extern VALUE guestfs_int_ruby_swapon_uuid (VALUE gv, VALUE uuidv);
extern VALUE guestfs_int_ruby_sync (VALUE gv);
extern VALUE guestfs_int_ruby_syslinux (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_tail (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_tail_n (VALUE gv, VALUE nrlinesv, VALUE pathv);
extern VALUE guestfs_int_ruby_tar_in (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_tar_out (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_tgz_in (VALUE gv, VALUE tarballv, VALUE directoryv);
extern VALUE guestfs_int_ruby_tgz_out (VALUE gv, VALUE directoryv, VALUE tarballv);
extern VALUE guestfs_int_ruby_touch (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_truncate (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_truncate_size (VALUE gv, VALUE pathv, VALUE sizev);
extern VALUE guestfs_int_ruby_tune2fs (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_tune2fs_l (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_txz_in (VALUE gv, VALUE tarballv, VALUE directoryv);
extern VALUE guestfs_int_ruby_txz_out (VALUE gv, VALUE directoryv, VALUE tarballv);
extern VALUE guestfs_int_ruby_umask (VALUE gv, VALUE maskv);
extern VALUE guestfs_int_ruby_umount (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_umount_all (VALUE gv);
extern VALUE guestfs_int_ruby_umount_local (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_upload (VALUE gv, VALUE filenamev, VALUE remotefilenamev);
extern VALUE guestfs_int_ruby_upload_offset (VALUE gv, VALUE filenamev, VALUE remotefilenamev, VALUE offsetv);
extern VALUE guestfs_int_ruby_user_cancel (VALUE gv);
extern VALUE guestfs_int_ruby_utimens (VALUE gv, VALUE pathv, VALUE atsecsv, VALUE atnsecsv, VALUE mtsecsv, VALUE mtnsecsv);
extern VALUE guestfs_int_ruby_utsname (VALUE gv);
extern VALUE guestfs_int_ruby_version (VALUE gv);
extern VALUE guestfs_int_ruby_vfs_label (VALUE gv, VALUE mountablev);
extern VALUE guestfs_int_ruby_vfs_minimum_size (VALUE gv, VALUE mountablev);
extern VALUE guestfs_int_ruby_vfs_type (VALUE gv, VALUE mountablev);
extern VALUE guestfs_int_ruby_vfs_uuid (VALUE gv, VALUE mountablev);
extern VALUE guestfs_int_ruby_vg_activate (VALUE gv, VALUE activatev, VALUE volgroupsv);
extern VALUE guestfs_int_ruby_vg_activate_all (VALUE gv, VALUE activatev);
extern VALUE guestfs_int_ruby_vgchange_uuid (VALUE gv, VALUE vgv);
extern VALUE guestfs_int_ruby_vgchange_uuid_all (VALUE gv);
extern VALUE guestfs_int_ruby_vgcreate (VALUE gv, VALUE volgroupv, VALUE physvolsv);
extern VALUE guestfs_int_ruby_vglvuuids (VALUE gv, VALUE vgnamev);
extern VALUE guestfs_int_ruby_vgmeta (VALUE gv, VALUE vgnamev);
extern VALUE guestfs_int_ruby_vgpvuuids (VALUE gv, VALUE vgnamev);
extern VALUE guestfs_int_ruby_vgremove (VALUE gv, VALUE vgnamev);
extern VALUE guestfs_int_ruby_vgrename (VALUE gv, VALUE volgroupv, VALUE newvolgroupv);
extern VALUE guestfs_int_ruby_vgs (VALUE gv);
extern VALUE guestfs_int_ruby_vgs_full (VALUE gv);
extern VALUE guestfs_int_ruby_vgscan (VALUE gv);
extern VALUE guestfs_int_ruby_vguuid (VALUE gv, VALUE vgnamev);
extern VALUE guestfs_int_ruby_wait_ready (VALUE gv);
extern VALUE guestfs_int_ruby_wc_c (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_wc_l (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_wc_w (VALUE gv, VALUE pathv);
extern VALUE guestfs_int_ruby_wipefs (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_write (VALUE gv, VALUE pathv, VALUE contentv);
extern VALUE guestfs_int_ruby_write_append (VALUE gv, VALUE pathv, VALUE contentv);
extern VALUE guestfs_int_ruby_write_file (VALUE gv, VALUE pathv, VALUE contentv, VALUE sizev);
extern VALUE guestfs_int_ruby_xfs_admin (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_xfs_growfs (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_xfs_info (VALUE gv, VALUE pathordevicev);
extern VALUE guestfs_int_ruby_xfs_repair (int argc, VALUE *argv, VALUE gv);
extern VALUE guestfs_int_ruby_zegrep (VALUE gv, VALUE regexv, VALUE pathv);
extern VALUE guestfs_int_ruby_zegrepi (VALUE gv, VALUE regexv, VALUE pathv);
extern VALUE guestfs_int_ruby_zero (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_zero_device (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_zero_free_space (VALUE gv, VALUE directoryv);
extern VALUE guestfs_int_ruby_zerofree (VALUE gv, VALUE devicev);
extern VALUE guestfs_int_ruby_zfgrep (VALUE gv, VALUE patternv, VALUE pathv);
extern VALUE guestfs_int_ruby_zfgrepi (VALUE gv, VALUE patternv, VALUE pathv);
extern VALUE guestfs_int_ruby_zfile (VALUE gv, VALUE methv, VALUE pathv);
extern VALUE guestfs_int_ruby_zgrep (VALUE gv, VALUE regexv, VALUE pathv);
extern VALUE guestfs_int_ruby_zgrepi (VALUE gv, VALUE regexv, VALUE pathv);

#endif /* GUESTFS_RUBY_ACTIONS_H_ */
