% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filesystem.R
\name{s3_bucket}
\alias{s3_bucket}
\title{Connect to an AWS S3 bucket}
\usage{
s3_bucket(bucket, ...)
}
\arguments{
\item{bucket}{string S3 bucket name or path}

\item{...}{Additional connection options, passed to \code{S3FileSystem$create()}}
}
\value{
A \code{SubTreeFileSystem} containing an \code{S3FileSystem} and the bucket's
relative path. Note that this function's success does not guarantee that you
are authorized to access the bucket's contents.
}
\description{
\code{s3_bucket()} is a convenience function to create an \code{S3FileSystem} object
that automatically detects the bucket's AWS region and holding onto the its
relative path.
}
\examples{
if (arrow_with_s3()) {
  bucket <- s3_bucket("ursa-labs-taxi-data")
}
}
