% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\name{data-type}
\alias{data-type}
\alias{int8}
\alias{int16}
\alias{int32}
\alias{int64}
\alias{uint8}
\alias{uint16}
\alias{uint32}
\alias{uint64}
\alias{float16}
\alias{halffloat}
\alias{float32}
\alias{float}
\alias{float64}
\alias{boolean}
\alias{bool}
\alias{utf8}
\alias{large_utf8}
\alias{binary}
\alias{large_binary}
\alias{fixed_size_binary}
\alias{string}
\alias{date32}
\alias{date64}
\alias{time32}
\alias{time64}
\alias{null}
\alias{timestamp}
\alias{decimal}
\alias{struct}
\alias{list_of}
\alias{large_list_of}
\alias{FixedSizeListType}
\alias{fixed_size_list_of}
\title{Apache Arrow data types}
\usage{
int8()

int16()

int32()

int64()

uint8()

uint16()

uint32()

uint64()

float16()

halffloat()

float32()

float()

float64()

boolean()

bool()

utf8()

large_utf8()

binary()

large_binary()

fixed_size_binary(byte_width)

string()

date32()

date64()

time32(unit = c("ms", "s"))

time64(unit = c("ns", "us"))

null()

timestamp(unit = c("s", "ms", "us", "ns"), timezone = "")

decimal(precision, scale)

struct(...)

list_of(type)

large_list_of(type)

fixed_size_list_of(type, list_size)
}
\arguments{
\item{byte_width}{byte width for \code{FixedSizeBinary} type.}

\item{unit}{For time/timestamp types, the time unit. \code{time32()} can take
either "s" or "ms", while \code{time64()} can be "us" or "ns". \code{timestamp()} can
take any of those four values.}

\item{timezone}{For \code{timestamp()}, an optional time zone string.}

\item{precision}{For \code{decimal()}, precision}

\item{scale}{For \code{decimal()}, scale}

\item{...}{For \code{struct()}, a named list of types to define the struct columns}

\item{type}{For \code{list_of()}, a data type to make a list-of-type}

\item{list_size}{list size for \code{FixedSizeList} type.}
}
\value{
An Arrow type object inheriting from DataType.
}
\description{
These functions create type objects corresponding to Arrow types. Use them
when defining a \code{\link[=schema]{schema()}} or as inputs to other types, like \code{struct}. Most
of these functions don't take arguments, but a few do.
}
\details{
A few functions have aliases:
\itemize{
\item \code{utf8()} and \code{string()}
\item \code{float16()} and \code{halffloat()}
\item \code{float32()} and \code{float()}
\item \code{bool()} and \code{boolean()}
\item When called inside an \code{arrow} function, such as \code{schema()} or \code{cast()},
\code{double()} also is supported as a way of creating a \code{float64()}
}

\code{date32()} creates a datetime type with a "day" unit, like the R \code{Date}
class. \code{date64()} has a "ms" unit.

\code{uint32} (32 bit unsigned integer), \code{uint64} (64 bit unsigned integer), and
\code{int64} (64-bit signed integer) types may contain values that exceed the
range of R's \code{integer} type (32-bit signed integer). When these arrow objects
are translated to R objects, \code{uint32} and \code{uint64} are converted to \code{double}
("numeric") and \code{int64} is converted to \code{bit64::integer64}. For \code{int64}
types, this conversion can be disabled (so that \code{int64} always yields a
\code{bit64::integer64} object) by setting \code{options(arrow.int64_downcast = FALSE)}.
}
\examples{
\donttest{
bool()
struct(a = int32(), b = double())
timestamp("ms", timezone = "CEST")
time64("ns")
}
}
\seealso{
\code{\link[=dictionary]{dictionary()}} for creating a dictionary (factor-like) type.
}
