% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunked-array.R
\name{as_chunked_array}
\alias{as_chunked_array}
\alias{as_chunked_array.ChunkedArray}
\alias{as_chunked_array.Array}
\title{Convert an object to an Arrow ChunkedArray}
\usage{
as_chunked_array(x, ..., type = NULL)

\method{as_chunked_array}{ChunkedArray}(x, ..., type = NULL)

\method{as_chunked_array}{Array}(x, ..., type = NULL)
}
\arguments{
\item{x}{An object to convert to an Arrow Chunked Array}

\item{...}{Passed to S3 methods}

\item{type}{A \link[=data-type]{type} for the final Array. A value of \code{NULL}
will default to the type guessed by \code{\link[=infer_type]{infer_type()}}.}
}
\value{
A \link{ChunkedArray}.
}
\description{
Whereas \code{\link[=chunked_array]{chunked_array()}} constructs a \link{ChunkedArray} from zero or more
\link{Array}s or R vectors, \code{as_chunked_array()} converts a single object to a
\link{ChunkedArray}.
}
\examples{
as_chunked_array(1:5)

}
