#include "cname_rr.h"

namespace ADNS
{ 
	CNAME_RR::CNAME_RR()
	{
		rr_type = RR_TYPE::CNAME;
		rr_class = RR_CLASS::IN;
	}

	Void CNAME_RR::UpdateRdata()
	{
		array<Byte>^ ctmp;

		if (!cname)
			return;

		ctmp = cname->GetName();

		if (!rdata)
			rdata = gcnew array<Byte>(ctmp->Length);
		else
			rdata->Resize(rdata,ctmp->Length);

		ctmp->CopyTo(rdata,0);

		return;
	}


	DOMAIN_NAME^ CNAME_RR::GetCname()
	{
		return cname->Clone();
	}

	Void CNAME_RR::SetCname(DOMAIN_NAME^ cn)
	{
		cname = cn->Clone();
		UpdateRdata();
	}

	String^ CNAME_RR::Print()
	{
		String^ output;

		output = PrintHeader();
		output += cname->Print();

		return output;
	}

	Void CNAME_RR::ToCanonical()
	{
		cname->MakeCanonical();
		owner->MakeCanonical();
		UpdateRdata();
		return;
	}

	CNAME_RR^ CNAME_RR::Clone()
	{
		CNAME_RR^ newrr = gcnew CNAME_RR();

		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->cname = cname->Clone();
		newrr->UpdateRdata();
		return newrr;
	}

	ResourceRecord^ CNAME_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		CNAME_RR^ cnameout;
		array<Byte>^ tmparray;
		int reallen = 0;

		cnameout = gcnew CNAME_RR();
		cnameout->owner = gcnew DOMAIN_NAME(domainname);
		cnameout->rr_class = (RR_CLASS) rr_class;
		cnameout->ttl = ttl;
		tmparray = ReadDomainFromPacket(packet, rdata_start, reallen);
		cnameout->SetCname(gcnew DOMAIN_NAME(tmparray));

		return cnameout;
	}

	String^ CNAME_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<CNAME_RR^>(rec)->Print();
	}

	ResourceRecord^ CNAME_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<CNAME_RR^>(rec)->Clone();
	}
}