#ifndef HAVE_ADNS_NSEC_RR_H
#define HAVE_ADNS_NSEC_RR_H

#include "adns_rr.h"

namespace ADNS {

/* From IETF RFC 4034

  The RDATA of the NSEC RR is as shown below:

                        1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   /                      Next Domain Name                         /
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   /                       Type Bit Maps                           /
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
*/

	public ref class NSEC_RR : ResourceRecord
	{
	public:
		NSEC_RR();
		DOMAIN_NAME^ GetNextDomain();
		Void SetNextDomain(DOMAIN_NAME^ nd);
		array<Byte>^ GetBitmap();
		Void SetBitmap(List<RR_TYPE>^ typelist);
		Void SetBitmap(array<Byte>^ bm);
		String^ Print();
		bool BitmapCoversType(RR_TYPE t);
		Void ToCanonical();
		NSEC_RR^ Clone();
		static ResourceRecord^ ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start);
		static String^ PrintRR(ResourceRecord^ rec);
		static ResourceRecord^ CloneRR(ResourceRecord^ rec);

	private:
		DOMAIN_NAME^ next_domain;
		array<Byte>^ bitmap;
		Void UpdateRdata();
		List<RR_TYPE>^ GetTypesFromBitmap();

	};
		

}


#endif
