#ifndef HAVE_ADNS_DS_RR_H
#define HAVE_ADNS_DS_RR_H

#include "adns_rr.h"

namespace ADNS {

	public ref class DS_RR : ResourceRecord
	{
	private:
		UInt16 KeyTag;
		CRYPTO_ALGORITHM crypto_algo;
		Byte DigestType;
		array<Byte>^ digest;
		//Functions
		Void UpdateRdata();

	public:
		DS_RR();
		UInt16 GetKeyTag();
		Void SetKeyTag(UInt16 KeyTag);
		CRYPTO_ALGORITHM GetCryptoAlgorithm();
		Void SetCryptoAlgorithm(CRYPTO_ALGORITHM h);
		Byte GetDigestType();
		Void SetDigestType(Byte t);
		array<Byte>^ GetDigest();
		Void SetDigest(array<Byte>^ d);
		String^ Print();
		bool EqualsSignature(array<Byte>^ b);
		DS_RR^ Clone();
		static ResourceRecord^ ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start);
		static String^ PrintRR(ResourceRecord^ rec);
		static ResourceRecord^ CloneRR(ResourceRecord^ rec);
	};

}

#endif
