/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.AppInputStream;
import com.sun.net.ssl.internal.ssl.AppOutputStream;
import com.sun.net.ssl.internal.ssl.CipherBox;
import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.ClientHandshaker;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.InputRecord;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.OutputRecord;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.ServerHandshaker;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public final class SSLSocketImpl
extends SSLSocket {
    public static final int a = 0;
    public static final int b = 1;
    public static final int c = 2;
    public static final int d = 3;
    public static final int e = 4;
    public static final int f = 5;
    public Socket g;
    public int h;
    public SSLException i;
    public boolean j;
    public boolean k;
    public String[] l;
    public boolean m = true;
    public boolean n = true;
    public String o;
    public int p;
    public boolean q = true;
    public Object r;
    public Object s;
    public MAC t;
    public MAC u;
    public CipherBox v;
    public CipherBox w;
    public SSLContextImpl x;
    public SSLSessionImpl y;
    public Handshaker z;
    public Vector aa;
    public InputStream ab;
    public OutputStream ac;
    public AppInputStream ad;
    public AppOutputStream ae;
    public byte af = (byte)3;
    public byte ag = 1;
    public static final Debug ah = Debug.getInstance("ssl");
    public static final byte ai = 1;
    public static final byte aj = 2;
    public static final byte ak = 0;
    public static final byte al = 10;
    public static final byte am = 20;
    public static final byte an = 30;
    public static final byte ao = 40;
    public static final byte ap = 41;
    public static final byte aq = 42;
    public static final byte ar = 43;
    public static final byte as = 44;
    public static final byte at = 45;
    public static final byte au = 46;
    public static final byte av = 47;
    public boolean aw = false;

    public SSLSocketImpl(SSLContextImpl sSLContextImpl) throws IOException {
        this.x = sSLContextImpl;
        this.y = SSLSessionImpl.a;
        this.g = this;
        this.a(false);
    }

    public SSLSocketImpl(SSLContextImpl sSLContextImpl, String string, int n2) throws IOException, UnknownHostException {
        super(string, n2);
        this.o = string;
        this.p = n2;
        this.g = this;
        this.x = sSLContextImpl;
        this.y = SSLSessionImpl.a;
        this.a(false);
        this.b();
    }

    public SSLSocketImpl(SSLContextImpl sSLContextImpl, String string, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        super(string, n2, inetAddress, n3);
        this.o = string;
        this.p = n2;
        this.g = this;
        this.x = sSLContextImpl;
        this.y = SSLSessionImpl.a;
        this.a(false);
        this.b();
    }

    public SSLSocketImpl(SSLContextImpl sSLContextImpl, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        super(inetAddress, n2);
        this.o = inetAddress.getHostName();
        this.p = n2;
        this.g = this;
        this.x = sSLContextImpl;
        this.y = SSLSessionImpl.a;
        this.a(false);
        this.b();
    }

    public SSLSocketImpl(SSLContextImpl sSLContextImpl, InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException, UnknownHostException {
        super(inetAddress, n2, inetAddress2, n3);
        this.o = inetAddress.getHostName();
        this.p = n2;
        this.g = this;
        this.x = sSLContextImpl;
        this.y = SSLSessionImpl.a;
        this.a(false);
        this.b();
    }

    public SSLSocketImpl(SSLContextImpl sSLContextImpl, Socket socket, String string, int n2, boolean bl2) throws IOException {
        this.o = string;
        this.p = n2;
        this.x = sSLContextImpl;
        this.y = SSLSessionImpl.a;
        this.g = socket;
        this.q = bl2;
        this.a(false);
        this.b();
    }

    public SSLSocketImpl(SSLContextImpl sSLContextImpl, Socket socket, boolean bl2) throws IOException {
        this.o = socket.getInetAddress().getHostName();
        this.p = socket.getPort();
        this.x = sSLContextImpl;
        this.y = SSLSessionImpl.a;
        this.j = bl2;
        this.q = false;
        this.g = socket;
        this.a(true);
        this.b();
    }

    public SSLSocketImpl(SSLContextImpl sSLContextImpl, boolean bl2) throws IOException {
        this.x = sSLContextImpl;
        this.j = bl2;
        this.y = SSLSessionImpl.a;
        this.g = this;
        this.a(true);
    }

    public synchronized void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (this.aa == null) {
            this.aa = new Vector(1, 2);
        }
        this.aa.addElement(handshakeCompletedListener);
    }

    private static String b(byte by2) {
        switch (by2) {
            case 0: {
                return "close_notify";
            }
            case 10: {
                return "unexpected message";
            }
            case 20: {
                return "bad_record_mac";
            }
            case 30: {
                return "decompression_failure";
            }
            case 40: {
                return "handshake_failure";
            }
            case 41: {
                return "no_certificate";
            }
            case 42: {
                return "bad_certificate";
            }
            case 43: {
                return "unsupported_certificate";
            }
            case 44: {
                return "certificate_revoked";
            }
            case 45: {
                return "certificate_expired";
            }
            case 46: {
                return "certificate_unknown";
            }
            case 47: {
                return "illegal_parameter";
            }
        }
        return "<UNKNOWN ALERT: " + (by2 & 0xFF) + ">";
    }

    private void g() throws SSLException {
        if (this.h != 1 && this.h != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        try {
            if (this.k) {
                this.v = this.z.newClntCipher();
                this.t = this.z.newClntMAC();
            } else {
                this.v = this.z.newSvrCipher();
                this.t = this.z.newSvrMAC();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLException("Algorithm missing:  " + noSuchAlgorithmException);
        }
    }

    public void a() throws SSLException {
        if (this.h != 1 && this.h != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        try {
            if (this.k) {
                this.w = this.z.newSvrCipher();
                this.u = this.z.newSvrMAC();
            } else {
                this.w = this.z.newClntCipher();
                this.u = this.z.newClntMAC();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLException("Algorithm missing:  " + noSuchAlgorithmException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(InputRecord inputRecord, boolean bl2) throws IOException {
        int n2 = this.i();
        while (n2 != 5 && n2 != 4) {
            try {
                inputRecord.read(this.ab, this.ac);
            }
            catch (SSLProtocolException sSLProtocolException) {
                try {
                    this.a((byte)10, sSLProtocolException.toString());
                    throw sSLProtocolException;
                }
                catch (IOException iOException) {}
                throw sSLProtocolException;
            }
            catch (EOFException eOFException) {
                this.a(4);
                inputRecord.close();
                return;
            }
            inputRecord.a(this.v);
            if (!inputRecord.a(this.t)) {
                if (inputRecord.contentType() == 22) {
                    this.a((byte)40, "bad handshake record MAC");
                } else {
                    this.a((byte)20, "bad record MAC");
                }
            }
            SSLSocketImpl sSLSocketImpl = this;
            synchronized (sSLSocketImpl) {
                switch (inputRecord.contentType()) {
                    case 22: {
                        if (this.z == null) {
                            try {
                                this.d();
                            }
                            catch (SSLException sSLException) {
                                this.a((byte)40, sSLException.toString());
                            }
                        }
                        try {
                            this.z.process_record(inputRecord);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            this.a((byte)40, noSuchAlgorithmException.toString());
                        }
                        catch (SSLException sSLException) {
                            if (this.h == 5) throw sSLException;
                            try {
                                try {
                                    this.a((byte)40, "");
                                    throw sSLException;
                                }
                                catch (Throwable throwable) {}
                                throw sSLException;
                            }
                            catch (Exception exception) {
                                throw sSLException;
                            }
                        }
                        if (this.z.isDone()) {
                            this.y = this.z.getSession();
                            this.z = null;
                            this.h = 2;
                            if (this.aa != null) {
                                HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(this, this.y);
                                NotifyHandshakeThread notifyHandshakeThread = new NotifyHandshakeThread(this.aa.elements(), handshakeCompletedEvent);
                                notifyHandshakeThread.start();
                            }
                        }
                        if (!bl2) {
                            if (this.h == 2) return;
                        }
                        Object var5_6 = null;
                        break;
                    }
                    case 23: {
                        if (this.h != 2 && this.h != 3) {
                            throw new SSLProtocolException("Data received in non-data state");
                        }
                        if (bl2) return;
                        throw new SSLException("Discarding app data");
                    }
                    case 21: {
                        try {
                            this.b(inputRecord);
                        }
                        catch (SSLException sSLException) {
                            this.a((byte)40, sSLException.toString());
                        }
                        Object var5_6 = null;
                        break;
                    }
                    case 20: {
                        if (this.h != 1 && this.h != 3 || inputRecord.available() != 1 || inputRecord.read() != 1) {
                            this.a((byte)10, "illegal change cipher spec msg, state = " + this.h);
                        }
                        this.g();
                        this.h = 1;
                        Object var5_6 = null;
                        break;
                    }
                    default: {
                        Object var5_6 = null;
                        break;
                    }
                }
            }
        }
        inputRecord.close();
    }

    private void h() throws SSLProtocolException, NoSuchAlgorithmException {
        switch (this.h) {
            case 0: {
                this.h = 1;
                break;
            }
            case 2: {
                this.h = 3;
                break;
            }
            default: {
                throw new SSLProtocolException("State " + this.h + " in client handshake init");
            }
        }
        this.z = new ClientHandshaker(this, this.x);
        this.z.setEnabledCipherSuites(this.l);
        this.z.enableNewSession = this.m;
    }

    public synchronized void close() throws IOException {
        switch (this.h) {
            case 0: {
                this.h = 5;
                return;
            }
            case 4: {
                if (this.g == this) {
                    super.close();
                } else {
                    this.g.close();
                }
                this.h = 5;
                return;
            }
            case 5: {
                return;
            }
        }
        try {
            this.a((byte)0);
        }
        catch (IOException iOException) {}
        this.h = 5;
        if (this.g == this) {
            super.close();
        } else if (this.q) {
            this.g.close();
        }
    }

    public void b() throws IOException {
        this.d();
        if (this.g == this) {
            this.ab = super.getInputStream();
            this.ac = super.getOutputStream();
        } else {
            this.ab = this.g.getInputStream();
            this.ac = this.g.getOutputStream();
        }
    }

    private static boolean a(String string) {
        return !string.startsWith("SSL_RSA_WITH_NULL_") && !string.startsWith("SSL_DH_anon_");
    }

    public synchronized void a(byte by2, String string) throws IOException {
        this.h = 4;
        this.b((byte)2, by2);
        if (this.g == this) {
            super.close();
        } else {
            this.g.close();
        }
        this.h = 5;
        this.y.invalidate();
        throw new SSLException(string);
    }

    public static String[] a(String[] stringArray) throws IllegalArgumentException {
        String[] stringArray2 = CipherSpec.getSupportedCipherSuites();
        String[] stringArray3 = new String[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (stringArray[n2].equals(stringArray2[n3])) break;
                ++n3;
            }
            if (n3 == stringArray2.length) {
                throw new IllegalArgumentException(stringArray[n2]);
            }
            stringArray3[n2] = stringArray[n2];
            ++n2;
        }
        return stringArray3;
    }

    public void finalize() {
        block4: {
            try {
                this.close();
            }
            catch (IOException iOException) {
                try {
                    if (this.g != this) break block4;
                    super.close();
                }
                catch (IOException iOException2) {}
            }
        }
    }

    private synchronized int i() {
        return this.h;
    }

    public static String[] getDefaultSuites() {
        String[] stringArray = CipherSpec.getSupportedCipherSuites();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (!SSLSocketImpl.a(stringArray[n3])) {
                --n2;
            }
            ++n3;
        }
        String[] stringArray2 = new String[n2];
        n3 = 0;
        int n4 = 0;
        while (n3 < stringArray.length) {
            if (SSLSocketImpl.a(stringArray[n3])) {
                stringArray2[n4++] = stringArray[n3];
            }
            ++n3;
        }
        return stringArray2;
    }

    public boolean c() {
        return this.n;
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.m;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return (String[])this.l.clone();
    }

    public Handshaker d() throws SSLException {
        try {
            switch (this.h) {
                case 0: 
                case 2: {
                    if (this.k) {
                        this.b(this.j);
                    } else {
                        this.h();
                    }
                    break;
                }
                default: {
                    throw new SSLException("Internal error");
                }
                case 1: 
                case 3: {
                    return this.z;
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLException(noSuchAlgorithmException.toString());
        }
        return this.z;
    }

    public String e() {
        if (this.o == null) {
            this.o = this.getInetAddress().getHostName();
        }
        return this.o;
    }

    public InetAddress getInetAddress() {
        if (this.g == this) {
            return super.getInetAddress();
        }
        return this.g.getInetAddress();
    }

    public synchronized InputStream getInputStream() {
        if (this.ad == null) {
            this.ad = new AppInputStream(this);
        }
        return this.ad;
    }

    public int getLocalPort() {
        if (this.g == this) {
            return super.getLocalPort();
        }
        return this.g.getLocalPort();
    }

    public synchronized boolean getNeedClientAuth() {
        return this.j;
    }

    public synchronized OutputStream getOutputStream() {
        if (this.ae == null) {
            this.ae = new AppOutputStream(this.af, this.ag, this);
        }
        return this.ae;
    }

    public int getPort() {
        if (this.g == this) {
            return super.getPort();
        }
        return this.g.getPort();
    }

    public SSLSession getSession() {
        try {
            if (this.i() == 1) {
                this.getOutputStream().write(new byte[0]);
            }
        }
        catch (IOException iOException) {}
        SSLSocketImpl sSLSocketImpl = this;
        synchronized (sSLSocketImpl) {
            SSLSessionImpl sSLSessionImpl = this.y;
            Object var3_3 = null;
            return sSLSessionImpl;
        }
    }

    public int getSoLinger() throws SocketException {
        if (this.g == this) {
            return super.getSoLinger();
        }
        return this.g.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        if (this.g == this) {
            return super.getSoTimeout();
        }
        return this.g.getSoTimeout();
    }

    public String[] getSupportedCipherSuites() {
        return CipherSpec.getSupportedCipherSuites();
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.g == this) {
            return super.getTcpNoDelay();
        }
        return this.g.getTcpNoDelay();
    }

    public synchronized boolean getUseClientMode() {
        return this.k ^ true;
    }

    private synchronized void j() throws IOException {
        switch (this.h) {
            case 2: {
                this.d();
                break;
            }
            case 3: {
                return;
            }
            default: {
                throw new IOException("connection is closed");
            }
            case 1: 
        }
        if (!this.z.started()) {
            this.z.kickstart();
            if (this.k) {
                this.h = 0;
                try {
                    this.b(this.j);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new IOException(noSuchAlgorithmException.getMessage());
                }
            }
        }
    }

    private void a(boolean bl2) {
        this.k = bl2;
        this.h = 0;
        try {
            this.v = new CipherBox.CipherNULL();
            this.t = new MAC(0, this.af, this.ag);
            this.w = new CipherBox.CipherNULL();
            this.u = new MAC(0, this.af, this.ag);
        }
        catch (Exception exception) {}
        this.l = SSLSocketImpl.getDefaultSuites();
        this.r = new Object();
        this.s = new Object();
    }

    public boolean f() {
        return this.h == 5 || this.h == 4;
    }

    public void a(InputRecord inputRecord) throws IOException {
        Object object = this.r;
        synchronized (object) {
            if (this.i() == 1 && !this.k) {
                this.aw = true;
                this.j();
                this.a(inputRecord, true);
                this.getInputStream();
                this.ad.disableFormatChecks();
                this.aw = false;
            } else {
                this.a(inputRecord, true);
            }
        }
    }

    private void b(InputRecord inputRecord) throws IOException {
        Object object;
        byte by2 = (byte)inputRecord.read();
        byte by3 = (byte)inputRecord.read();
        if (ah != null && (Debug.isOn("record") || Debug.isOn("handshake"))) {
            object = System.out;
            synchronized (object) {
                System.out.print(Thread.currentThread().getName());
                System.out.print(", RECV SSLv3 ALERT:  ");
                if (by2 == 2) {
                    System.out.print("fatal, ");
                } else if (by2 == 1) {
                    System.out.print("warning, ");
                } else {
                    System.out.print("<level " + (0xFF & by2) + ">, ");
                }
                System.out.println(SSLSocketImpl.b(by3));
            }
        }
        if (by2 == 2) {
            this.h = 4;
            this.y.invalidate();
            if (this.g == this) {
                super.close();
            } else {
                this.g.close();
            }
            object = "Received fatal alert: " + SSLSocketImpl.b(by3);
            if (by3 == 40) {
                object = String.valueOf(object) + " (no cipher suites in common)";
            }
            this.i = new SSLException((String)object);
        } else if (by2 == 1) {
            if (by3 == 0) {
                this.close();
            } else if (this.z != null) {
                this.z.a(by3);
            }
        } else {
            this.a((byte)10, "illegal alert level " + by2);
        }
    }

    public synchronized void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (this.aa == null) {
            throw new IllegalArgumentException("no listeners");
        }
        if (!this.aa.removeElement(handshakeCompletedListener)) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (this.aa.isEmpty()) {
            this.aa = null;
        }
    }

    private void b(byte by2, byte by3) throws IOException {
        if (this.h == 5) {
            return;
        }
        OutputRecord outputRecord = new OutputRecord(this.af, this.ag, 21);
        if (ah != null && (Debug.isOn("record") || Debug.isOn("handshake"))) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.print(Thread.currentThread().getName());
                System.out.print(", SEND SSL v" + this.af + "." + this.ag + " ALERT:  ");
                if (by2 == 2) {
                    System.out.print("fatal, ");
                } else if (by2 == 1) {
                    System.out.print("warning, ");
                } else {
                    System.out.print("<level = " + (0xFF & by2) + ">, ");
                }
                System.out.println("description = " + SSLSocketImpl.b(by3));
            }
        }
        outputRecord.write(by2);
        outputRecord.write(by3);
        this.a(outputRecord);
    }

    private synchronized void a(int n2) {
        this.h = n2;
    }

    public synchronized void setEnableSessionCreation(boolean bl2) {
        this.m = bl2;
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) throws IllegalArgumentException {
        this.l = SSLSocketImpl.a(stringArray);
        if (this.z != null) {
            this.z.setEnabledCipherSuites(this.l);
        }
    }

    public synchronized void setNeedClientAuth(boolean bl2) {
        this.j = bl2;
    }

    public void setSoLinger(boolean bl2, int n2) throws SocketException {
        if (this.g == this) {
            super.setSoLinger(bl2, n2);
        } else {
            this.g.setSoLinger(bl2, n2);
        }
    }

    public synchronized void setSoTimeout(int n2) throws SocketException {
        if (this.g == this) {
            super.setSoTimeout(n2);
        } else {
            this.g.setSoTimeout(n2);
        }
    }

    public void setTcpNoDelay(boolean bl2) throws SocketException {
        if (this.g == this) {
            super.setTcpNoDelay(bl2);
        } else {
            this.g.setTcpNoDelay(bl2);
        }
    }

    public synchronized void setUseClientMode(boolean bl2) {
        block3: {
            if (this.h == 0) {
                this.k = bl2 ^ true;
            }
            if (this.h != 1 || this.aw) break block3;
            this.k = bl2 ^ true;
            this.h = 0;
            try {
                this.b();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized void a(byte by2, byte by3) {
        this.af = by2;
        this.ag = by3;
        if (this.ae != null) {
            this.ae.r.a(by2, by3);
        }
    }

    public void startHandshake() throws IOException {
        if (!this.k && this.h == 1) {
            this.getOutputStream().write(new byte[0]);
        } else {
            this.j();
        }
    }

    public synchronized void startHandshake(boolean bl2) throws IOException {
        if (!this.k) {
            throw new IllegalArgumentException("not in server role");
        }
        this.j = bl2;
        this.j();
    }

    private void b(boolean bl2) throws SSLProtocolException, NoSuchAlgorithmException {
        switch (this.h) {
            case 0: {
                this.h = 1;
                break;
            }
            case 2: {
                this.h = 3;
                break;
            }
            default: {
                throw new SSLProtocolException("State " + this.h + " in server handshake init");
            }
        }
        this.z = new ServerHandshaker(this, this.x, bl2);
        this.z.setEnabledCipherSuites(this.l);
        this.z.enableNewSession = this.m;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        stringBuffer.append("[");
        if (this.y != null) {
            stringBuffer.append(this.y.getCipherSuite());
        } else {
            stringBuffer.append("(no SSL session yet)");
        }
        stringBuffer.append(": ");
        if (this.g == this) {
            stringBuffer.append(super.toString());
        } else {
            stringBuffer.append(this.g.toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void a(byte by2) throws IOException {
        this.b((byte)1, by2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void a(OutputRecord var1_1) throws IOException {
lbl1:
        // 4 sources

        block12: while (var1_1.b() == 23) {
            switch (this.i()) {
                case 1: {
                    var2_2 = this.r;
                    synchronized (var2_2) {
                        this.aw = true;
                        if (this.i() == 1) ** GOTO lbl12
                        var3_3 = null;
                        ** GOTO lbl1
lbl12:
                        // 1 sources

                        this.j();
                        var4_4 = new InputRecord();
                        var4_4.a(this.ad.r.b(), this.ad.r.c());
                        this.a(var4_4, false);
                        this.getInputStream();
                        this.ad.disableFormatChecks();
                        this.aw = false;
                        ** break;
                    }
                }
                case 4: {
                    this.close();
                    ** break;
                }
                case 5: {
                    if (this.i == null) throw new SocketException("Socket closed");
                    throw this.i;
                }
                default: {
                    throw new SSLProtocolException("State error, send app data");
                }
                case 2: 
                case 3: {
                    break block12;
                }
            }
        }
        var2_2 = this.s;
        synchronized (var2_2) {
            if (var1_1.d() != false) return;
            var1_1.a(this.u);
            var1_1.a(this.w);
            var1_1.a(this.ac);
            return;
        }
    }

    private class NotifyHandshakeThread
    extends Thread {
        public Enumeration b;
        public HandshakeCompletedEvent c;

        public NotifyHandshakeThread(Enumeration enumeration, HandshakeCompletedEvent handshakeCompletedEvent) {
            this.b = enumeration;
            this.c = handshakeCompletedEvent;
        }

        public void run() {
            while (this.b.hasMoreElements()) {
                HandshakeCompletedListener handshakeCompletedListener = (HandshakeCompletedListener)this.b.nextElement();
                handshakeCompletedListener.handshakeCompleted(this.c);
            }
        }
    }
}

