/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.AVA;
import com.sun.net.ssl.internal.ssl.DerOutputStream;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.ObjectIdentifier;
import java.io.IOException;

public class RDN {
    public AVA[] assertion;

    public RDN(int n2) {
        this.assertion = new AVA[n2];
    }

    public RDN(DerValue derValue) throws IOException {
        if (derValue.tag != 49) {
            throw new IOException("X500 RDN");
        }
        int n2 = 1;
        this.assertion = new AVA[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.assertion[n3] = new AVA(derValue.data);
            ++n3;
        }
    }

    public void a(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        int n2 = 0;
        while (n2 < this.assertion.length) {
            this.assertion[n2].encode(derOutputStream2);
            ++n2;
        }
        derOutputStream.write((byte)49, derOutputStream2);
    }

    public boolean a(RDN rDN) {
        if (rDN == this) {
            return true;
        }
        if (this.assertion.length != rDN.assertion.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.assertion.length) {
            if (!this.assertion[n2].a(rDN.assertion[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof RDN) {
            return this.a((RDN)object);
        }
        return false;
    }

    public DerValue a(ObjectIdentifier objectIdentifier) {
        int n2 = 0;
        while (n2 < this.assertion.length) {
            if (this.assertion[n2].a.equals(objectIdentifier)) {
                return this.assertion[n2].b;
            }
            ++n2;
        }
        return null;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        while (n4 < this.assertion.length) {
            if (this.assertion[n4].b != null) {
                n2 += this.assertion[n4].b.length() * n3++;
            }
            ++n4;
        }
        return n2;
    }

    public String toString() {
        String string = null;
        int n2 = 0;
        while (n2 < this.assertion.length) {
            string = string == null ? this.assertion[n2].toString() : String.valueOf(string) + " + " + this.assertion[n2];
            ++n2;
        }
        return string;
    }
}

