/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import java.math.BigInteger;

public final class BigInt {
    public byte[] a;
    public static final String b = "0123456789abcdef";

    public BigInt(int n2) {
        if (n2 < 256) {
            this.a = new byte[1];
            this.a[0] = (byte)n2;
        } else if (n2 < 65536) {
            this.a = new byte[2];
            this.a[0] = (byte)(n2 >> 8);
            this.a[1] = (byte)n2;
        } else if (n2 < 0x1000000) {
            this.a = new byte[3];
            this.a[0] = (byte)(n2 >> 16);
            this.a[1] = (byte)(n2 >> 8);
            this.a[2] = (byte)n2;
        } else {
            this.a = new byte[4];
            this.a[0] = (byte)(n2 >> 24);
            this.a[1] = (byte)(n2 >> 16);
            this.a[2] = (byte)(n2 >> 8);
            this.a[3] = (byte)n2;
        }
    }

    public BigInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if ((byArray[0] & 0x80) != 0) {
            throw new IllegalArgumentException("negative BigInteger");
        }
        if (byArray[0] != 0) {
            this.a = byArray;
        } else {
            this.a = new byte[byArray.length - 1];
            int n2 = 1;
            while (n2 < byArray.length) {
                this.a[n2 - 1] = byArray[n2];
                ++n2;
            }
        }
    }

    public BigInt(byte[] byArray) {
        this.a = (byte[])byArray.clone();
    }

    public boolean equals(BigInt bigInt) {
        if (this == bigInt) {
            return true;
        }
        byte[] byArray = bigInt.toByteArray();
        if (this.a.length != byArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.a.length) {
            if (this.a[n2] != byArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof BigInt) {
            return this.equals((BigInt)object);
        }
        return false;
    }

    private String a() {
        StringBuffer stringBuffer = new StringBuffer(this.a.length * 2);
        stringBuffer.append("    ");
        int n2 = 0;
        while (n2 < this.a.length) {
            stringBuffer.append(b.charAt(this.a[n2] >> 4 & 0xF));
            stringBuffer.append(b.charAt(this.a[n2] & 0xF));
            if ((n2 + 1) % 32 == 0) {
                if (n2 + 1 != this.a.length) {
                    stringBuffer.append("\n    ");
                }
            } else if ((n2 + 1) % 4 == 0) {
                stringBuffer.append(' ');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.a);
    }

    public byte[] toByteArray() {
        return (byte[])this.a.clone();
    }

    public int toInt() {
        if (this.a.length > 4) {
            throw new NumberFormatException("BigInt.toLong, too big");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.a.length) {
            n2 = (n2 << 8) + (this.a[n3] & 0xFF);
            ++n3;
        }
        return n2;
    }

    public String toString() {
        return this.a();
    }
}

