// Code generated by protoc-gen-gogo.
// source: scheduler.proto
// DO NOT EDIT!

package mesosproto

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

// discarding unused import gogoproto "github.com/gogo/protobuf/gogoproto"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Possible event types, followed by message definitions if
// applicable.
type Event_Type int32

const (
	Event_SUBSCRIBED Event_Type = 1
	Event_OFFERS     Event_Type = 2
	Event_RESCIND    Event_Type = 3
	Event_UPDATE     Event_Type = 4
	Event_MESSAGE    Event_Type = 5
	Event_FAILURE    Event_Type = 6
	Event_ERROR      Event_Type = 7
)

var Event_Type_name = map[int32]string{
	1: "SUBSCRIBED",
	2: "OFFERS",
	3: "RESCIND",
	4: "UPDATE",
	5: "MESSAGE",
	6: "FAILURE",
	7: "ERROR",
}
var Event_Type_value = map[string]int32{
	"SUBSCRIBED": 1,
	"OFFERS":     2,
	"RESCIND":    3,
	"UPDATE":     4,
	"MESSAGE":    5,
	"FAILURE":    6,
	"ERROR":      7,
}

func (x Event_Type) Enum() *Event_Type {
	p := new(Event_Type)
	*p = x
	return p
}
func (x Event_Type) String() string {
	return proto.EnumName(Event_Type_name, int32(x))
}
func (x *Event_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Event_Type_value, data, "Event_Type")
	if err != nil {
		return err
	}
	*x = Event_Type(value)
	return nil
}

// Possible call types, followed by message definitions if
// applicable.
type Call_Type int32

const (
	Call_SUBSCRIBE   Call_Type = 1
	Call_TEARDOWN    Call_Type = 2
	Call_ACCEPT      Call_Type = 3
	Call_DECLINE     Call_Type = 4
	Call_REVIVE      Call_Type = 5
	Call_KILL        Call_Type = 6
	Call_SHUTDOWN    Call_Type = 7
	Call_ACKNOWLEDGE Call_Type = 8
	Call_RECONCILE   Call_Type = 9
	Call_MESSAGE     Call_Type = 10
)

var Call_Type_name = map[int32]string{
	1:  "SUBSCRIBE",
	2:  "TEARDOWN",
	3:  "ACCEPT",
	4:  "DECLINE",
	5:  "REVIVE",
	6:  "KILL",
	7:  "SHUTDOWN",
	8:  "ACKNOWLEDGE",
	9:  "RECONCILE",
	10: "MESSAGE",
}
var Call_Type_value = map[string]int32{
	"SUBSCRIBE":   1,
	"TEARDOWN":    2,
	"ACCEPT":      3,
	"DECLINE":     4,
	"REVIVE":      5,
	"KILL":        6,
	"SHUTDOWN":    7,
	"ACKNOWLEDGE": 8,
	"RECONCILE":   9,
	"MESSAGE":     10,
}

func (x Call_Type) Enum() *Call_Type {
	p := new(Call_Type)
	*p = x
	return p
}
func (x Call_Type) String() string {
	return proto.EnumName(Call_Type_name, int32(x))
}
func (x *Call_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Call_Type_value, data, "Call_Type")
	if err != nil {
		return err
	}
	*x = Call_Type(value)
	return nil
}

// *
// Scheduler event API.
//
// An event is described using the standard protocol buffer "union"
// trick, see:
// https://developers.google.com/protocol-buffers/docs/techniques#union.
type Event struct {
	// Type of the event, indicates which optional field below should be
	// present if that type has a nested message definition.
	Type             *Event_Type       `protobuf:"varint,1,req,name=type,enum=mesosproto.Event_Type" json:"type,omitempty"`
	Subscribed       *Event_Subscribed `protobuf:"bytes,2,opt,name=subscribed" json:"subscribed,omitempty"`
	Offers           *Event_Offers     `protobuf:"bytes,3,opt,name=offers" json:"offers,omitempty"`
	Rescind          *Event_Rescind    `protobuf:"bytes,4,opt,name=rescind" json:"rescind,omitempty"`
	Update           *Event_Update     `protobuf:"bytes,5,opt,name=update" json:"update,omitempty"`
	Message          *Event_Message    `protobuf:"bytes,6,opt,name=message" json:"message,omitempty"`
	Failure          *Event_Failure    `protobuf:"bytes,7,opt,name=failure" json:"failure,omitempty"`
	Error            *Event_Error      `protobuf:"bytes,8,opt,name=error" json:"error,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}

func (m *Event) GetType() Event_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Event_SUBSCRIBED
}

func (m *Event) GetSubscribed() *Event_Subscribed {
	if m != nil {
		return m.Subscribed
	}
	return nil
}

func (m *Event) GetOffers() *Event_Offers {
	if m != nil {
		return m.Offers
	}
	return nil
}

func (m *Event) GetRescind() *Event_Rescind {
	if m != nil {
		return m.Rescind
	}
	return nil
}

func (m *Event) GetUpdate() *Event_Update {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *Event) GetMessage() *Event_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *Event) GetFailure() *Event_Failure {
	if m != nil {
		return m.Failure
	}
	return nil
}

func (m *Event) GetError() *Event_Error {
	if m != nil {
		return m.Error
	}
	return nil
}

// First event received when the scheduler subscribes.
type Event_Subscribed struct {
	FrameworkId      *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *Event_Subscribed) Reset()         { *m = Event_Subscribed{} }
func (m *Event_Subscribed) String() string { return proto.CompactTextString(m) }
func (*Event_Subscribed) ProtoMessage()    {}

func (m *Event_Subscribed) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

// Received whenever there are new resources that are offered to the
// scheduler. Each offer corresponds to a set of resources on a
// slave. Until the scheduler accepts or declines an offer the
// resources are considered allocated to the scheduler.
type Event_Offers struct {
	Offers           []*Offer `protobuf:"bytes,1,rep,name=offers" json:"offers,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Event_Offers) Reset()         { *m = Event_Offers{} }
func (m *Event_Offers) String() string { return proto.CompactTextString(m) }
func (*Event_Offers) ProtoMessage()    {}

func (m *Event_Offers) GetOffers() []*Offer {
	if m != nil {
		return m.Offers
	}
	return nil
}

// Received when a particular offer is no longer valid (e.g., the
// slave corresponding to the offer has been removed) and hence
// needs to be rescinded. Any future calls ('Accept' / 'Decline') made
// by the scheduler regarding this offer will be invalid.
type Event_Rescind struct {
	OfferId          *OfferID `protobuf:"bytes,1,req,name=offer_id" json:"offer_id,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Event_Rescind) Reset()         { *m = Event_Rescind{} }
func (m *Event_Rescind) String() string { return proto.CompactTextString(m) }
func (*Event_Rescind) ProtoMessage()    {}

func (m *Event_Rescind) GetOfferId() *OfferID {
	if m != nil {
		return m.OfferId
	}
	return nil
}

// Received whenever there is a status update that is generated by
// the executor or slave or master. Status updates should be used by
// executors to reliably communicate the status of the tasks that
// they manage. It is crucial that a terminal update (see TaskState
// in mesos.proto) is sent by the executor as soon as the task
// terminates, in order for Mesos to release the resources allocated
// to the task. It is also the responsibility of the scheduler to
// explicitly acknowledge the receipt of a status update. See
// 'Acknowledge' in the 'Call' section below for the semantics.
type Event_Update struct {
	Status           *TaskStatus `protobuf:"bytes,1,req,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Event_Update) Reset()         { *m = Event_Update{} }
func (m *Event_Update) String() string { return proto.CompactTextString(m) }
func (*Event_Update) ProtoMessage()    {}

func (m *Event_Update) GetStatus() *TaskStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Received when a custom message generated by the executor is
// forwarded by the master. Note that this message is not
// interpreted by Mesos and is only forwarded (without reliability
// guarantees) to the scheduler. It is up to the executor to retry
// if the message is dropped for any reason.
type Event_Message struct {
	SlaveId          *SlaveID    `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	ExecutorId       *ExecutorID `protobuf:"bytes,2,req,name=executor_id" json:"executor_id,omitempty"`
	Data             []byte      `protobuf:"bytes,3,req,name=data" json:"data,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Event_Message) Reset()         { *m = Event_Message{} }
func (m *Event_Message) String() string { return proto.CompactTextString(m) }
func (*Event_Message) ProtoMessage()    {}

func (m *Event_Message) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *Event_Message) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *Event_Message) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Received when a slave is removed from the cluster (e.g., failed
// health checks) or when an executor is terminated. Note that, this
// event coincides with receipt of terminal UPDATE events for any
// active tasks belonging to the slave or executor and receipt of
// 'Rescind' events for any outstanding offers belonging to the
// slave. Note that there is no guaranteed order between the
// 'Failure', 'Update' and 'Rescind' events when a slave or executor
// is removed.
// TODO(vinod): Consider splitting the lost slave and terminated
// executor into separate events and ensure it's reliably generated.
type Event_Failure struct {
	SlaveId *SlaveID `protobuf:"bytes,1,opt,name=slave_id" json:"slave_id,omitempty"`
	// If this was just a failure of an executor on a slave then
	// 'executor_id' will be set and possibly 'status' (if we were
	// able to determine the exit status).
	ExecutorId       *ExecutorID `protobuf:"bytes,2,opt,name=executor_id" json:"executor_id,omitempty"`
	Status           *int32      `protobuf:"varint,3,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Event_Failure) Reset()         { *m = Event_Failure{} }
func (m *Event_Failure) String() string { return proto.CompactTextString(m) }
func (*Event_Failure) ProtoMessage()    {}

func (m *Event_Failure) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *Event_Failure) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *Event_Failure) GetStatus() int32 {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return 0
}

// Received when an invalid framework (e.g., unauthenticated,
// unauthorized) attempts to subscribe with the master. Error can
// also be received if scheduler sends invalid Calls (e.g., not
// properly initialized).
// TODO(vinod): Remove this once the old scheduler driver is no
// longer supported. With HTTP API all errors will be signaled via
// HTTP response codes.
type Event_Error struct {
	Message          *string `protobuf:"bytes,1,req,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Event_Error) Reset()         { *m = Event_Error{} }
func (m *Event_Error) String() string { return proto.CompactTextString(m) }
func (*Event_Error) ProtoMessage()    {}

func (m *Event_Error) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

// *
// Scheduler call API.
//
// Like Event, a Call is described using the standard protocol buffer
// "union" trick (see above).
type Call struct {
	// Identifies who generated this call. Master assigns a framework id
	// when a new scheduler subscribes for the first time. Once assigned,
	// the scheduler must set the 'framework_id' here and within its
	// FrameworkInfo (in any further 'Subscribe' calls). This allows the
	// master to identify a scheduler correctly across disconnections,
	// failovers, etc.
	FrameworkId *FrameworkID `protobuf:"bytes,1,opt,name=framework_id" json:"framework_id,omitempty"`
	// Type of the call, indicates which optional field below should be
	// present if that type has a nested message definition.
	Type             *Call_Type        `protobuf:"varint,2,req,name=type,enum=mesosproto.Call_Type" json:"type,omitempty"`
	Subscribe        *Call_Subscribe   `protobuf:"bytes,3,opt,name=subscribe" json:"subscribe,omitempty"`
	Accept           *Call_Accept      `protobuf:"bytes,4,opt,name=accept" json:"accept,omitempty"`
	Decline          *Call_Decline     `protobuf:"bytes,5,opt,name=decline" json:"decline,omitempty"`
	Kill             *Call_Kill        `protobuf:"bytes,6,opt,name=kill" json:"kill,omitempty"`
	Shutdown         *Call_Shutdown    `protobuf:"bytes,7,opt,name=shutdown" json:"shutdown,omitempty"`
	Acknowledge      *Call_Acknowledge `protobuf:"bytes,8,opt,name=acknowledge" json:"acknowledge,omitempty"`
	Reconcile        *Call_Reconcile   `protobuf:"bytes,9,opt,name=reconcile" json:"reconcile,omitempty"`
	Message          *Call_Message     `protobuf:"bytes,10,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *Call) Reset()         { *m = Call{} }
func (m *Call) String() string { return proto.CompactTextString(m) }
func (*Call) ProtoMessage()    {}

func (m *Call) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *Call) GetType() Call_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Call_SUBSCRIBE
}

func (m *Call) GetSubscribe() *Call_Subscribe {
	if m != nil {
		return m.Subscribe
	}
	return nil
}

func (m *Call) GetAccept() *Call_Accept {
	if m != nil {
		return m.Accept
	}
	return nil
}

func (m *Call) GetDecline() *Call_Decline {
	if m != nil {
		return m.Decline
	}
	return nil
}

func (m *Call) GetKill() *Call_Kill {
	if m != nil {
		return m.Kill
	}
	return nil
}

func (m *Call) GetShutdown() *Call_Shutdown {
	if m != nil {
		return m.Shutdown
	}
	return nil
}

func (m *Call) GetAcknowledge() *Call_Acknowledge {
	if m != nil {
		return m.Acknowledge
	}
	return nil
}

func (m *Call) GetReconcile() *Call_Reconcile {
	if m != nil {
		return m.Reconcile
	}
	return nil
}

func (m *Call) GetMessage() *Call_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

// Subscribes the scheduler with the master to receive events. A
// scheduler must send other calls only after it has received the
// SUBCRIBED event.
type Call_Subscribe struct {
	// See the comments below on 'framework_id' on the semantics for
	// 'framework_info.id'.
	FrameworkInfo *FrameworkInfo `protobuf:"bytes,1,req,name=framework_info" json:"framework_info,omitempty"`
	// 'force' field is only relevant when 'framework_info.id' is set.
	// It tells the master what to do in case an instance of the
	// scheduler attempts to subscribe when another instance of it is
	// already connected (e.g., split brain due to network partition).
	// If 'force' is true, this scheduler instance is allowed and the
	// old connected scheduler instance is disconnected. If false,
	// this scheduler instance is disallowed subscription in favor of
	// the already connected scheduler instance.
	//
	// It is recommended to set this to true only when a newly elected
	// scheduler instance is attempting to subscribe but not when a
	// scheduler is retrying subscription (e.g., disconnection or
	// master failover; see sched/sched.cpp for an example).
	Force            *bool  `protobuf:"varint,2,opt,name=force" json:"force,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Call_Subscribe) Reset()         { *m = Call_Subscribe{} }
func (m *Call_Subscribe) String() string { return proto.CompactTextString(m) }
func (*Call_Subscribe) ProtoMessage()    {}

func (m *Call_Subscribe) GetFrameworkInfo() *FrameworkInfo {
	if m != nil {
		return m.FrameworkInfo
	}
	return nil
}

func (m *Call_Subscribe) GetForce() bool {
	if m != nil && m.Force != nil {
		return *m.Force
	}
	return false
}

// Accepts an offer, performing the specified operations
// in a sequential manner.
//
// E.g. Launch a task with a newly reserved persistent volume:
//
//   Accept {
//     offer_ids: [ ... ]
//     operations: [
//       { type: RESERVE,
//         reserve: { resources: [ disk(role):2 ] } }
//       { type: CREATE,
//         create: { volumes: [ disk(role):1+persistence ] } }
//       { type: LAUNCH,
//         launch: { task_infos ... disk(role):1;disk(role):1+persistence } }
//     ]
//   }
//
// Note that any of the offer’s resources not used in the 'Accept'
// call (e.g., to launch a task) are considered unused and might be
// reoffered to other frameworks. In other words, the same OfferID
// cannot be used in more than one 'Accept' call.
type Call_Accept struct {
	OfferIds         []*OfferID         `protobuf:"bytes,1,rep,name=offer_ids" json:"offer_ids,omitempty"`
	Operations       []*Offer_Operation `protobuf:"bytes,2,rep,name=operations" json:"operations,omitempty"`
	Filters          *Filters           `protobuf:"bytes,3,opt,name=filters" json:"filters,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *Call_Accept) Reset()         { *m = Call_Accept{} }
func (m *Call_Accept) String() string { return proto.CompactTextString(m) }
func (*Call_Accept) ProtoMessage()    {}

func (m *Call_Accept) GetOfferIds() []*OfferID {
	if m != nil {
		return m.OfferIds
	}
	return nil
}

func (m *Call_Accept) GetOperations() []*Offer_Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *Call_Accept) GetFilters() *Filters {
	if m != nil {
		return m.Filters
	}
	return nil
}

// Declines an offer, signaling the master to potentially reoffer
// the resources to a different framework. Note that this is same
// as sending an Accept call with no operations. See comments on
// top of 'Accept' for semantics.
type Call_Decline struct {
	OfferIds         []*OfferID `protobuf:"bytes,1,rep,name=offer_ids" json:"offer_ids,omitempty"`
	Filters          *Filters   `protobuf:"bytes,2,opt,name=filters" json:"filters,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *Call_Decline) Reset()         { *m = Call_Decline{} }
func (m *Call_Decline) String() string { return proto.CompactTextString(m) }
func (*Call_Decline) ProtoMessage()    {}

func (m *Call_Decline) GetOfferIds() []*OfferID {
	if m != nil {
		return m.OfferIds
	}
	return nil
}

func (m *Call_Decline) GetFilters() *Filters {
	if m != nil {
		return m.Filters
	}
	return nil
}

// Kills a specific task. If the scheduler has a custom executor,
// the kill is forwarded to the executor and it is up to the
// executor to kill the task and send a TASK_KILLED (or TASK_FAILED)
// update. Note that Mesos releases the resources for a task once it
// receives a terminal update (See TaskState in mesos.proto) for it.
// If the task is unknown to the master, a TASK_LOST update is
// generated.
type Call_Kill struct {
	TaskId           *TaskID  `protobuf:"bytes,1,req,name=task_id" json:"task_id,omitempty"`
	SlaveId          *SlaveID `protobuf:"bytes,2,opt,name=slave_id" json:"slave_id,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Call_Kill) Reset()         { *m = Call_Kill{} }
func (m *Call_Kill) String() string { return proto.CompactTextString(m) }
func (*Call_Kill) ProtoMessage()    {}

func (m *Call_Kill) GetTaskId() *TaskID {
	if m != nil {
		return m.TaskId
	}
	return nil
}

func (m *Call_Kill) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

// Shuts down a custom executor. When the executor gets a shutdown
// event, it is expected to kill all its tasks (and send TASK_KILLED
// updates) and terminate. If the executor doesn’t terminate within
// a certain timeout (configurable via
// '--executor_shutdown_grace_period' slave flag), the slave will
// forcefully destroy the container (executor and its tasks) and
// transition its active tasks to TASK_LOST.
type Call_Shutdown struct {
	ExecutorId       *ExecutorID `protobuf:"bytes,1,req,name=executor_id" json:"executor_id,omitempty"`
	SlaveId          *SlaveID    `protobuf:"bytes,2,req,name=slave_id" json:"slave_id,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Call_Shutdown) Reset()         { *m = Call_Shutdown{} }
func (m *Call_Shutdown) String() string { return proto.CompactTextString(m) }
func (*Call_Shutdown) ProtoMessage()    {}

func (m *Call_Shutdown) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *Call_Shutdown) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

// Acknowledges the receipt of status update. Schedulers are
// responsible for explicitly acknowledging the receipt of status
// updates that have 'Update.status().uuid()' field set. Such status
// updates are retried by the slave until they are acknowledged by
// the scheduler.
type Call_Acknowledge struct {
	SlaveId          *SlaveID `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	TaskId           *TaskID  `protobuf:"bytes,2,req,name=task_id" json:"task_id,omitempty"`
	Uuid             []byte   `protobuf:"bytes,3,req,name=uuid" json:"uuid,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Call_Acknowledge) Reset()         { *m = Call_Acknowledge{} }
func (m *Call_Acknowledge) String() string { return proto.CompactTextString(m) }
func (*Call_Acknowledge) ProtoMessage()    {}

func (m *Call_Acknowledge) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *Call_Acknowledge) GetTaskId() *TaskID {
	if m != nil {
		return m.TaskId
	}
	return nil
}

func (m *Call_Acknowledge) GetUuid() []byte {
	if m != nil {
		return m.Uuid
	}
	return nil
}

// Allows the scheduler to query the status for non-terminal tasks.
// This causes the master to send back the latest task status for
// each task in 'tasks', if possible. Tasks that are no longer known
// will result in a TASK_LOST update. If 'statuses' is empty, then
// the master will send the latest status for each task currently
// known.
type Call_Reconcile struct {
	Tasks            []*Call_Reconcile_Task `protobuf:"bytes,1,rep,name=tasks" json:"tasks,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *Call_Reconcile) Reset()         { *m = Call_Reconcile{} }
func (m *Call_Reconcile) String() string { return proto.CompactTextString(m) }
func (*Call_Reconcile) ProtoMessage()    {}

func (m *Call_Reconcile) GetTasks() []*Call_Reconcile_Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

// TODO(vinod): Support arbitrary queries than just state of tasks.
type Call_Reconcile_Task struct {
	TaskId           *TaskID  `protobuf:"bytes,1,req,name=task_id" json:"task_id,omitempty"`
	SlaveId          *SlaveID `protobuf:"bytes,2,opt,name=slave_id" json:"slave_id,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Call_Reconcile_Task) Reset()         { *m = Call_Reconcile_Task{} }
func (m *Call_Reconcile_Task) String() string { return proto.CompactTextString(m) }
func (*Call_Reconcile_Task) ProtoMessage()    {}

func (m *Call_Reconcile_Task) GetTaskId() *TaskID {
	if m != nil {
		return m.TaskId
	}
	return nil
}

func (m *Call_Reconcile_Task) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

// Sends arbitrary binary data to the executor. Note that Mesos
// neither interprets this data nor makes any guarantees about the
// delivery of this message to the executor.
type Call_Message struct {
	SlaveId          *SlaveID    `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	ExecutorId       *ExecutorID `protobuf:"bytes,2,req,name=executor_id" json:"executor_id,omitempty"`
	Data             []byte      `protobuf:"bytes,3,req,name=data" json:"data,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Call_Message) Reset()         { *m = Call_Message{} }
func (m *Call_Message) String() string { return proto.CompactTextString(m) }
func (*Call_Message) ProtoMessage()    {}

func (m *Call_Message) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *Call_Message) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *Call_Message) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterEnum("mesosproto.Event_Type", Event_Type_name, Event_Type_value)
	proto.RegisterEnum("mesosproto.Call_Type", Call_Type_name, Call_Type_value)
}
