package v1

// This file contains methods that can be used by the go-restful package to generate Swagger
// documentation for the object types found in 'types.go' This file is automatically generated
// by hack/update-generated-swagger-descriptions.sh and should be run after a full build of OpenShift.
// ==== DO NOT EDIT THIS FILE MANUALLY ====

var map_Parameter = map[string]string{
	"":            "Parameter defines a name/value variable that is to be processed during the Template to Config transformation.",
	"name":        "Name must be set and it can be referenced in Template Items using ${PARAMETER_NAME}. Required.",
	"displayName": "Optional: The name that will show in UI instead of parameter 'Name'",
	"description": "Description of a parameter. Optional.",
	"value":       "Value holds the Parameter data. If specified, the generator will be ignored. The value replaces all occurrences of the Parameter ${Name} expression during the Template to Config transformation. Optional.",
	"generate":    "generate specifies the generator to be used to generate random string from an input value specified by From field. The result string is stored into Value field. If empty, no generator is being used, leaving the result Value untouched. Optional.\n\nThe only supported generator is \"expression\", which accepts a \"from\" value in the form of a simple regular expression containing the range expression \"[a-zA-Z0-9]\", and the length expression \"a{length}\".\n\nExamples:\n\nfrom             | value",
	"from":        "From is an input value for the generator. Optional.",
	"required":    "Optional: Indicates the parameter must have a value.  Defaults to false.",
}

func (Parameter) SwaggerDoc() map[string]string {
	return map_Parameter
}

var map_Template = map[string]string{
	"":           "Template contains the inputs needed to produce a Config.",
	"metadata":   "Standard object's metadata.",
	"message":    "message is an optional instructional message that will be displayed when this template is instantiated. This field should inform the user how to utilize the newly created resources. Parameter substitution will be performed on the message before being displayed so that generated credentials and other parameters can be included in the output.",
	"objects":    "objects is an array of resources to include in this template. If a namespace value is hardcoded in the object, it will be removed during template instantiation, however if the namespace value is, or contains, a ${PARAMETER_REFERENCE}, the resolved value after parameter substitution will be respected and the object will be created in that namespace.",
	"parameters": "parameters is an optional array of Parameters used during the Template to Config transformation.",
	"labels":     "labels is a optional set of labels that are applied to every object during the Template to Config transformation.",
}

func (Template) SwaggerDoc() map[string]string {
	return map_Template
}

var map_TemplateList = map[string]string{
	"":         "TemplateList is a list of Template objects.",
	"metadata": "Standard object's metadata.",
	"items":    "Items is a list of templates",
}

func (TemplateList) SwaggerDoc() map[string]string {
	return map_TemplateList
}
